function BacklogDraggingTool() {
  go.DraggingTool.call(this);
  this.fieldTemplate = null;  // THIS NEEDS TO BE SET before a drag starts
  this.temporaryPart = null;
  this.isPartInBacklog = true;
  this.lastDraggingPoint;
  this.fromParentNodeData;

  this.ghoostPart = null;
}
go.Diagram.inherit(BacklogDraggingTool, go.DraggingTool);

// override this method
BacklogDraggingTool.prototype.findDraggablePart = function () {

  var diagram = this.diagram;
  // var obj = diagram.findObjectAt(diagram.lastInput.documentPoint);
  // while (obj !== null && obj.type !== go.Panel.TableRow) obj = obj.panel;
  
  // if (obj !== null && obj.type === go.Panel.TableRow &&
  //   this.fieldTemplate !== null && this.temporaryPart === null) {

  //   var tempPart = go.GraphObject.make(
  //       go.Node, "Table",
  //         { 
  //           layerName: "Tool", 
  //           locationSpot: go.Spot.Center 
  //         },
  //       this.fieldTemplate.copy()   // copy the template!
  //   );

  //   this.temporaryPart = tempPart;
  //   this.fromParentNodeData = obj.part.data;

  //   // assume OBJ is now a Panel representing a field, bound to field data
  //   // update the temporary Part via data binding
  //   tempPart.location = diagram.lastInput.documentPoint;  // need to set location explicitly
  //   diagram.add(tempPart);  // add to Diagram before setting data
  //   tempPart.data = obj.data;  // bind to the same field data as being dragged
   
  //   var offset = diagram.lastInput.documentPoint.copy().subtract(obj.part.documentBounds.position);
  //   console.log("offset : "+offset);
  //   this.isPartInBacklog = true;

  //   return tempPart;
  // }

  var part = go.DraggingTool.prototype.findDraggablePart.call(this);
  if (part != null) {

    const partBound = part.actualBounds;
    const ghoostPart = $$(go.Part, "Auto", {
        layerName : "Tool"
      },
      $$(go.Shape,"Rectangle", {fill: "transparent", strokeWidth: 2, stroke: "dodgerblue"})
    );
    this.ghoostPart = ghoostPart;

    diagram.commit(()=>{
      ghoostPart.desiredSize     = partBound.size.copy();
      ghoostPart.location = new go.Point(partBound.x , partBound.y );
      diagram.add(ghoostPart);
    }, null);
  }
  return part;
};

BacklogDraggingTool.prototype.doActivate = function () {

  if (this.temporaryPart === null) return go.DraggingTool.prototype.doActivate.call(this);
  var diagram = this.diagram;
  
  this.standardMouseSelect();
  this.isActive = true;
  
  var map = new go.Map();
  map.set(this.temporaryPart, new go.DraggingInfo(diagram.lastInput.documentPoint.copy()));
  this.draggedParts = map;

  this.startTransaction("Drag Field");
  diagram.isMouseCaptured = true;
};

BacklogDraggingTool.prototype.doDeactivate = function () {
  
  var diagram = this.diagram;

  const ghoostPart    = this.ghoostPart;
  const temporaryPart = this.temporaryPart;

  diagram.commit(()=>{
    if (ghoostPart != null) {
      diagram.remove(ghoostPart);
    }
    if (temporaryPart != null) {
      if (isPartInBacklog) {
        diagram.remove(temporaryPart);
      }
      else {
        boardDiagram.remove(temporaryPart);
      }
    }
  }, null);

  this.ghoostPart    = null;
  this.temporaryPart = null;

  go.DraggingTool.prototype.doDeactivate.call(this);
};

BacklogDraggingTool.prototype.doMouseMove = function () {

  var diagram = this.diagram;

  if (!this.isActive) return;
  if (this.temporaryPart === null) {
    if (this.ghoostPart != null) {
      if (this.draggedParts && this.draggedParts.size > 0) {
        const draggedPart = this.draggedParts.iteratorKeys.first();
        if (draggedPart != null) {
          const group = draggedPart.containingGroup;
          var it = group.memberParts.iterator;
          var members = [];
          while (it.next()) {
            var mPart = it.value;
            members.push(mPart);
          }
          members = _.sortBy(members, node => {
            return node.location.y;
          });
          
          for (var i = 0; i < members.length; i ++) {
            if (draggedPart.location.y < members[i].location.y) {
              diagram.commit(() => {
                this.ghoostPart.location = members[i].location.copy();
              }, null);
              break;
            }
          }
        }
      }
    }
    return go.DraggingTool.prototype.doMouseMove.call(this);
  }
  // var diagram = this.diagram;
  // // just move the temporaryPart (in draggedParts), without regard to moving or copying permissions of the Node

  // var point = diagram.lastInput.documentPoint;
  // var documentBounds = diagram.documentBounds;

  // if (point.x >= documentBounds.x && point.x <= documentBounds.x + documentBounds.width) {
  //   if (!this.isPartInBacklog) {
  //     boardDiagram.remove(this.temporaryPart);
  //     diagram.add(this.temporaryPart);
  //   }
  //   this.isPartInBacklog = true;

  //   var offset = diagram.lastInput.documentPoint.copy().subtract(diagram.firstInput.documentPoint);
  //   this.moveParts(this.draggedParts, offset, false);
  // }
  // else {
  //   if (this.isPartInBacklog) {
  //     diagram.remove(this.temporaryPart);
  //     boardDiagram.add(this.temporaryPart);
  //     var offset = diagram.lastInput.documentPoint.copy().subtract(obj.part.documentBounds.position);
  //   }
  //   this.isPartInBacklog = false;

  //   var offset = diagram.lastInput.documentPoint.copy().subtract(diagram.firstInput.documentPoint);
  //   var adjutmentPoint = new go.Point(offset.x - (documentBounds.x + documentBounds.width), offset.y - backlogDiagram.viewportBounds.y + boardDiagram.viewportBounds.y);

  //   this.moveParts(this.draggedParts, adjutmentPoint, false);
  // }
  // this.lastDraggingPoint = this.temporaryPart.location.copy();
};

BacklogDraggingTool.prototype.doMouseUp = function () {
  if (!this.isActive) return;
  if (this.temporaryPart === null) return go.DraggingTool.prototype.doMouseUp.call(this);

  var diagram = this.diagram;

  var draggingItemData = this.temporaryPart.data;

  if (this.isPartInBacklog) {
    //...  in backlog
    var dest = diagram.findPartAt(this.lastDraggingPoint, false);
    if (dest != null && dest.data && this.fromParentNodeData.key == dest.data.key) {

      var parent = this.fromParentNodeData;
      var dropInfo = _this.getDropInfoChild(draggingItemData, dest, this.lastDraggingPoint);

      // item, parent, dropInfo
      _this.$emit("drop-backlog-child", draggingItemData, parent, dropInfo);
    }
  }
  else {
    //...  in board	
    var dest = boardDiagram.findPartAt(this.lastDraggingPoint, false);
    if (dest != null && dest.data) {
      if (dest.data.isGroup || dest.data.data) {

        var fromGroup = undefined;
        var fromParent = this.fromParentNodeData;

        var toGroup;
        var toParent;

        var dropInfo = undefined;

        var parentNode;
        if (dest.data.isGroup) {
          var thisTool = this;
          dest.memberParts.each(function (part) {
            if (part.data && part.data.data && part.data.data.id === thisTool.fromParentNodeData.data.id) {
              parentNode = part;
            }
          });
        } else {
          parentNode = dest;
        }
        if (!parentNode) {
          toParent = undefined;
          toGroup = { teamId: dest.data.teamId, containerId: dest.data.containerId };
        }
        else {
          toParent = parentNode.data;
          toGroup = { tc: parentNode.data.teamContainer };
          dropInfo = _this.getDropInfoChild(draggingItemData, parentNode, this.lastDraggingPoint);
        }
        // item, fromGroup, fromParent , toGroup, toParent, dropInfo
        _this.$emit("drop-board-child", draggingItemData, fromGroup, fromParent, toGroup, toParent, dropInfo);
      }
    }
  }

  this.transactionResult = "Inserted Field";
  this.stopTool();
};