const kendisWidgetSubBatchProgress= Vue.component('kendis-widget-sub-batch-progress', {
    template: `
        <span class="inner">
        <div class="rec ed bgw a in mb-0"> 
            <div class="rc c1 fst"> 
            	<span class="fstpd">
                <em v-if="subBatch[2]" class="arrd ti-angle-right mr-10 c-point FL aa" :class="{' ': expandedBaseItems.indexOf(subBatch[0]) === -1,'active': expandedBaseItems.indexOf(subBatch[0]) !== -1}" @click="toggleBaseItemNavigation(subBatch[0])"></em>
                <span :class="{'pl-12': subBatch[2] === null, 'txt-lth': !isIdInAllBatchesList(subBatch[0])}" @click="openBatchPopup(itemIdsMap[subBatch[0]])"><a class="c-point">{{ itemIdsMap[subBatch[0]] + ' - ' + itemTitlesMap[subBatch[0]] }}</a></span>
                </span>
            </div>
            <div class="rc c2 sc" v-for="(value, index) in subBatch[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                <span class="DIB tooltip">{{ value !== null ? value + '%' : '-' }}
                    <span class="hovtooltipB tprht fs-12">Progress Criteria: {{ subBatch[5][index] }} <br> Done: {{ subBatch[3][index] }}  <br> Total: {{ subBatch[4][index] }}</span>
                    <span v-html="generateComparisonForItem(subBatch[6][index])"></span> 

                </span>
            </div>
        </div>
        <template v-if="expandedBaseItems.indexOf(subBatch[0]) !== -1">
             <template v-for="nestedSubBatch in subBatchesData(subBatch[0])">
                <kendis-widget-sub-batch-progress  :expandedBaseItems="expandedBaseItems" :itemIdsMap="itemIdsMap" :itemTitlesMap="itemTitlesMap" :datedProgressMap="datedProgressMap" :subBatch="nestedSubBatch" :tableData="tableData" :intervalDates="intervalDates" :allBatchIds="allBatchIds" :baseItemId="baseItemId"/>
            </template>
        </template>
        </span>
        
       
    `,
    props:{
        expandedBaseItems: null,
        itemIdsMap: null,
        itemTitlesMap: null,
        datedProgressMap: null,
        subBatch: null,
        tableData: null,
        keyResults: [],
        baseItemId: null,
        intervalDates: null,
        allBatchIds: {
            type: Array,
            default: () => {
                return [];
            }
        }
    },
    data() {
        return {
            selectedKRData: {},
        }
    },
    methods:{
        subBatchesData(batchId) {
            const subBatchData = {};
            const allSubBatchIds = new Set();


            const dates = Object.keys(this.datedProgressMap);
            const totalDates = dates.length;


            for (const date of dates) {
                let batchData;


                if (this.datedProgressMap[date][batchId]) {
                    batchData = this.datedProgressMap[date][batchId];
                } else {
                    batchData = this.findProgress(this.datedProgressMap[date][this.baseItemId], batchId);
                }

                if (batchData && batchData.subBatchProgress) {

                    for (const subBatchId of Object.keys(batchData.subBatchProgress)) {
                        allSubBatchIds.add(subBatchId);

                        if (!subBatchData[subBatchId]) {
                            subBatchData[subBatchId] = {
                                progressArray: Array(totalDates).fill(null),
                                subBatchProgress: null,
                                doneChildren: Array(totalDates).fill(0),
                                totalDone: Array(totalDates).fill(0),
                                progressCriteria: Array(totalDates).fill(null),
                            };
                        }

                        const subBatchInfo = batchData.subBatchProgress[subBatchId];
                        if (subBatchInfo.subBatchProgress) {
                            subBatchData[subBatchId].subBatchProgress = subBatchInfo.subBatchProgress;
                        }

                        // Populate the progress value at the correct index (date order)
                        const dateIndex = dates.indexOf(date);
                        subBatchData[subBatchId].progressArray[dateIndex] =
                            subBatchInfo.batchProgress !== undefined ? subBatchInfo.batchProgress || 0 : null;
                        subBatchData[subBatchId].doneChildren[dateIndex] = subBatchInfo.results[0] !== undefined ? subBatchInfo.results[0] || 0 : null;
                        subBatchData[subBatchId].totalDone[dateIndex] = subBatchInfo.results[1] !== undefined ? subBatchInfo.results[1] || 0 : null;
                        subBatchData[subBatchId].progressCriteria[dateIndex] = subBatchInfo.progressCriteria || null;
                    }
                }
            }

            // Ensure all subBatchIds have the correct array length (already initialized to totalDates)
            allSubBatchIds.forEach((subBatchId) => {
                if (!subBatchData[subBatchId]) {
                    subBatchData[subBatchId] = {
                        progressArray: new Array(totalDates).fill(null),
                        subBatchProgress: null,
                        doneChildren: Array(totalDates).fill(0),
                        totalDone: Array(totalDates).fill(0),
                        progressCriteria: Array(totalDates).fill(null),
                    };
                }
            });

            const subBatchesResult = Object.entries(subBatchData).map(([subBatchId, data]) => {
                const validProgress = data.progressArray
                    .map((value, index) => (value !== null && value !== undefined ? { value, index } : null))
                    .filter(item => item !== null);

                const progressDifferenceArray = new Array(totalDates).fill(null);


                for (let i = 1; i < totalDates; i++) {
                    const prev = data.progressArray[i - 1];
                    const curr = data.progressArray[i];

                    if (
                        prev !== null && prev !== undefined &&
                        curr !== null && curr !== undefined
                    ) {
                        progressDifferenceArray[i] = curr - prev;
                    }
                }

                return [subBatchId, data.progressArray, data.subBatchProgress, data.doneChildren, data.totalDone, data.progressCriteria, progressDifferenceArray];

            });

            return subBatchesResult;
        },


        findProgress(data, targetId) {
            if (data && data.subBatchProgress && data.subBatchProgress[targetId]) {
                return data.subBatchProgress[targetId];
            }

            if (data && data.subBatchProgress) {
                for (const key in data.subBatchProgress) {
                    const result = this.findProgress(data.subBatchProgress[key], targetId);
                    if (result) return result;
                }
            }
            return null;
        },
        isCurrentPeriod(date) {
            if(date){
                const today = new Date();
                let targetDate
                date = date.trim();
                const match = date.match(/\d{4}-\d{2}-\d{2}/g);
                switch (this.tableData.intervals) {
                    case 'daily':
                        targetDate = new Date(date);
                        return today.toDateString() === targetDate.toDateString();
                    case 'weekly':
                        if(match && match[match.length -1]){
                            targetDate = new Date(match[1]);
                        }
                        const isSameWeek = (date1, date2) => {
                            const dayDifference = (date1 - date2) / (1000 * 60 * 60 * 24);
                            return dayDifference < 7 && date1.getDay() >= date2.getDay();
                        };
                        return  isSameWeek(today, targetDate);
                    case 'monthly':
                        if(match && match[match.length -1]){
                            targetDate = new Date(match[1]);
                        }
                        return today.getMonth() === targetDate.getMonth() &&
                            today.getFullYear() === targetDate.getFullYear();
                    case 'quarterly':
                        if(match && match[match.length -1]){
                            targetDate = new Date(match[1]);
                        }
                        const getQuarter = (date) => Math.floor(date.getMonth() / 3) + 1;
                        return getQuarter(today) === getQuarter(targetDate) &&
                            today.getFullYear() === targetDate.getFullYear();
                    default:
                        return false;
                }
            }
            return false;
        },
        toggleBaseItemNavigation(baseItemId) {

            const index = this.expandedBaseItems.indexOf(baseItemId);

            if (index === -1) {
                this.expandedBaseItems.push(baseItemId);
                this.selectedKRData[baseItemId] = this.getAllResultsForObjective(baseItemId);
            } else {
                this.expandedBaseItems.splice(index, 1);
            }
        },
        getAllResultsForObjective(objKey, objGrpId) {
            let objProgress = {
                linkedItemsProgress: [],
                linkedKRsProgress: [],
                linkedItemsCount :[],
                doneItemsCount: []
            };


            Object.keys(this.datedProgressMap).forEach(date => {
                const entry = this.tableData.progress.datedProgressMap[date];
                let objectiveGroup;
                if(objGrpId){
                    objectiveGroup = entry[objGrpId];
                } else {
                    objectiveGroup = entry[this.objectiveGroupId];
                }
                if (objectiveGroup) {
                    const objectiveData = objectiveGroup[objKey];

                    if (objectiveData) {
                        objProgress.linkedItemsProgress.push(objectiveData.linkedItemsProgress !== undefined
                            ? objectiveData.linkedItemsProgress
                            : null);
                        objProgress.linkedItemsCount.push(objectiveData.linkedItemsCount !== undefined ? objectiveData.linkedItemsCount : 0);
                        objProgress.doneItemsCount.push(objectiveData.objProgressMap.totalDone !== undefined ? objectiveData.objProgressMap.totalDone : 0);
                    } else {
                        objProgress.linkedItemsProgress.push(null);
                        objProgress.linkedItemsCount.push(0);
                        objProgress.doneItemsCount.push(0);

                    }
                } else {
                    objProgress.linkedItemsProgress.push(null);
                    objProgress.linkedItemsCount.push(0);
                    objProgress.doneItemsCount.push(0);
                }
            });


            return objProgress;
        },
        formatDate(date) {
            const year = date.getFullYear();
            const month = (date.getMonth() + 1).toString().padStart(2, '0');
            const day = date.getDate().toString().padStart(2, '0');
            return `${year}-${month}-${day}`;
        },
        isIdInAllBatchesList(batchId){
            if(this.allBatchIds){
                return this.allBatchIds.includes(batchId);
            }
            return false;
        },
        openBatchPopup(batchTitle){
            window.location.href = window.location.origin + "/batches#/" + batchTitle;
        },
        generateComparisonForItem(diff) {
            let arrow;
            if(diff > 0){
                arrow = 'arrow-up-grn';
            } else if (diff < 0){
                arrow = 'arrow-down-red';
            }
            return `<span class="${arrow} arr p-abs"></span>`;
        },
    },
    computed:{
        dateHeaders() {
            const intervalDates = [];
            if (!_.isEmpty(this.intervalDates)) {
                const monthMap = {
                    '1': 'Jan',
                    '2': 'Feb',
                    '3': 'Mar',
                    '4': 'Apr',
                    '5': 'May',
                    '6': 'Jun',
                    '7': 'Jul',
                    '8': 'Aug',
                    '9': 'Sep',
                    '10': 'Oct',
                    '11': 'Nov',
                    '12': 'Dec'
                };
                const quarterMap = {
                    '1': 'Q1',
                    '2': 'Q1',
                    '3': 'Q2',
                    '4': 'Q2',
                    '5': 'Q2',
                    '6': 'Q2',
                    '7': 'Q3',
                    '8': 'Q3',
                    '9': 'Q3',
                    '10': 'Q4',
                    '11': 'Q4',
                    '12': 'Q4'
                };

                const dateSize = this.tablePage !== -1? Math.floor(this.tableData.intervalDates.length/2) : 0;
                switch (this.tableData.intervals) {
                    case 'daily':
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            intervalDates.push(this.formatDate(new Date(this.intervalDates[i])));
                        }
                        break;
                    case 'weekly':
                        currentDate = new Date(this.intervalDates[0]);
                        currentDate.setDate(currentDate.getDate() - 7);
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            const weekNo = this.tablePage === 0 ? `Week ${i +1}` : `Week ${i +1 + dateSize}`;
                            intervalDates.push(`${weekNo} (` + (this.formatDate(currentDate) + "-" + this.formatDate(endDate)) + ')');
                            currentDate = endDate;
                        }
                        break;
                    case 'monthly':
                        currentDate = new Date(this.intervalDates[0]);
                        let month = currentDate.getMonth();
                        currentDate.setMonth(month - 1);
                        if(currentDate.getMonth() === month){
                            currentDate.setMonth(month - 1);
                        }
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            intervalDates.push(monthMap[currentDate.getMonth() + 1] + `\n(${this.formatDate(currentDate)} - ${this.formatDate(endDate)})`);
                            currentDate = endDate;
                        }
                        break;
                    case 'quarterly':
                        currentDate = new Date(this.intervalDates[0]);
                        currentDate.setMonth(month - 3);
                        if(currentDate.getMonth() === month - 2){
                            currentDate.setMonth(month - 1);
                        }
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            intervalDates.push(quarterMap[currentDate.getMonth() + 1] + (this.formatDate(currentDate) + "-" + this.formatDate(endDate)));
                            currentDate = endDate;
                        }
                        break;
                    default:
                        console.error("Unknown interval type");
                }


            }
            return intervalDates;
        },
    }

});