

const EventBus = new Vue();

const kendisWidgetOkrsProgressTable = Vue.component('kendis-widget-okrs-progress-table', {
    template: `
        <div class="obj-graphout b">
            <div class="DF tblout">
                <div v-if="tableData.intervalDates.length > 7" class="ti-angle-left artbl lft mr-20" @click="toggleFirstHalf"></div>
                <div border="1" class="table brdwd" v-if="isOKRView">                  
                	<div class="rec hd ed">
                      <div class="rc c1 fst ftsb">Description</div>
                      <div class="rc c2 sc ftsb" v-for="(date, index) in dateHeaders" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                        <span class="clndrnw1 ico FL mr-10"></span> {{ date }}
                      </div>
                	</div>                  
                  
                    <template v-if="isOKRView">
                         <template v-if="isAllGroupsAvg">
                            <template v-for="(objGrp,index) in allGroupsData()">
                                <template>
                                    <div class="rec in ed a">
                                        <div class="rc c1 fst">
                                        	<span class="fstpd">
                                        	<em v-if="shouldObjectiveGroupExpand(objGrp)" class="ac-arr c-point mr-10 a" :class="{'ti-angle-right': objGrp.id !== 'avg' && expandedBaseItems.indexOf(objGrp.id) === -1,'ti-angle-down': objGrp.id !== 'avg' && expandedBaseItems.indexOf(objGrp.id) !== -1}" @click="toggleBaseItemNavigation(objGrp.id)"></em> 
                                        	{{ objGrp.name }}
                                        	</span>
                                        </div>
	                                    <div class="rc c2 sc" v-for="(value, index) in objGrp.progress" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
	                                        {{ value !== null ? value + '%' : '-' }}
	                                        <span v-html="generateComparisonForItem(objGrp.progressDifference[index])"></span>
	                                    </div>
                                    </div>                                    
                                    <template v-if="expandedBaseItems.indexOf(objGrp.id) !== -1">
                                        <template v-for="obj in objGrp.objProgress">
                                        <div class="rec in ed bgw a">
                                            <div class="rc c1 fst" :class="{'txt-lth' : !isIdInObjectiveGroupList(objGrp.id,obj.id)}">
                                            <span class="fstpd">
                                                <em v-if="shouldObjectiveExpand(obj.id, objGrp.id)" class="ac-arr c-point mr-10 b" :class="{'ti-angle-right': expandedBaseItems.indexOf(obj.id) === -1,'ti-angle-down': expandedBaseItems.indexOf(obj.id) !== -1}" @click="toggleObjectiveNavigation(objGrp.id, obj.id, obj.linkedKRIds ,obj.linkedObjIds)"></em>
                                                <a @click="openObjectivePopup(obj.id)" href="javascript:void(0)">{{ obj.name + ' - ' + itemTitlesMap[obj.id]}}</a>
                                            </span>
                                            </div>
                                            <div class="rc c2 sc" v-for="(value, index) in obj.progress" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                            	{{ value !== null ? value + '%' : '-' }}
                                                <span v-html="generateComparisonForItem(obj.progressDifference[index])"></span>
                                            </div>
                                            <objective-row-component v-if="clickedObjective && clickedObjective[obj.id]"
                                                :show-un-linked-items="clickedObjective[obj.id].showUnLinkedItems"
                                                :ref="clickedObjective[obj.id].ref"
                                                :group-id="clickedObjective[obj.id].groupId"
                                                :key="clickedObjective[obj.id].key"
                                                :board="clickedObjective[obj.id].board"
                                                :objective="clickedObjective[obj.id].objective"
                                                :okr-list="clickedObjective[obj.id].okrList"
                                                :is-user-searching="clickedObjective[obj.id].isUserSearching"
                                                :readOnlyView="true"
                                                :hide-okr="clickedObjective[obj.id].hideOkr"
                                                :is-feature-detail-view="clickedObjective[obj.id].isFeatureDetailView"
                                                :is-global-objective-view="clickedObjective[obj.id].isGlobalObjectiveView"
                                                :objective-team="clickedObjective[obj.id].objectiveTeam"
                                                :is-mocking-mode = "clickedObjective[obj.id].isMockingMode"
                                                :is-prioritized-obj-listing-view= "clickedObjective[obj.id].isPrioritizedObjListingView"
                                                :kr-progress-criteria-field-id = "clickedObjective[obj.id].krProgressCriteriaFieldId"
                                                :is-art="clickedObjective[obj.id].isArt"
                                                :release-train-id="clickedObjective[obj.id].releaseTrainId"
                                                :departments-map="clickedObjective[obj.id].departmentsMap"
                                                :sessions-map="clickedObjective[obj.id].sessionsMap"
                                                :batches-map="clickedObjective[obj.id].batchesMap"
                                                :is-items-loaded="clickedObjective[obj.id].isItemsLoaded"
                                                :use-old-api-for-old-state-data="clickedObjective[obj.id].useOldApiForOldStateData"
                                                :openDynamicPopup="'objective'"
                                                :customView="customView"
                                                @close="destroyRow"
                                                />
                                        </div>
                                         <template v-if="expandedBaseItems.indexOf(obj.id) !== -1">
                                            <!-- Linked Items Progress -->
                                                <div class="rec in ed bgw b">
                                                    <div class="rc c1 fst"><span class="fstpd">Linked Items</span></div>
                                                    <div class="rc c2 sc tooltip" v-for="(progress, index) in selectedKRData[obj.id].linkedItemsProgress" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                                        {{ progress !== null ? progress + '%' : '-' }}
                                                        <span v-html="generateComparisonForItem(selectedKRData[obj.id].LIProgressDifferenceArray[index])"></span>
                                                        <div class="hovtooltipB fs-12">Done Linked Items Count: {{ selectedKRData[obj.id].doneItemsCount[index] }}<br>
                                                          Total Linked Items Count: {{ selectedKRData[obj.id].linkedItemsCount[index] }}  </div>
                                                    </div>
                                                </div>
                                            
                                                <!-- Key Results Progress -->
                                                <div class="rec in ed d" v-if="selectedKRData[obj.id].linkedKRsProgress && selectedKRData[obj.id].linkedKRsProgress.length" v-for="kr in selectedKRData[obj.id].linkedKRsProgress" :key="kr[0]">
                                                    <div class="rc c1 fst"><span class="fstpd"><a class="ml-30 c-point" @click="openKRPopup(obj.id, kr[0])" :class="{'txt-lth' : !isIdInKRList(kr[0], obj.id, objGrp.id)}">{{ itemIdsMap[kr[0]] + ' - ' + itemTitlesMap[kr[0]] }}</a></span></div>
                                                    <div class="rc c2 sc" v-for="(value, index) in kr[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                                        {{ value !== null ? value + '%' : '-' }}
                                                        <span v-html="generateComparisonForItem(kr[2][index])"></span>
                                                    </div>
                                                     <objective-row-component v-if="clickedObjective && clickedObjective[obj.id] && clickedObjective[obj.id].krId === kr[0]"
                                                        :parentId="clickedObjective[obj.id].parentId"
                                                        :group-id="clickedObjective[obj.id].groupId"
                                                        :key="clickedObjective[obj.id].key"
                                                        :ref="clickedObjective[obj.id].ref"
                                                        :board="clickedObjective[obj.id].board"
                                                        :objective="clickedObjective[obj.id].objective"
                                                        :readOnlyView="true"
                                                        :hide-okr="clickedObjective[obj.id].hideOkr"
                                                        :departments-map="clickedObjective[obj.id].departmentsMap"
                                                        :is-mocking-mode="clickedObjective[obj.id].isMockingMode"
                                                        :is-feature-detail-view="clickedObjective[obj.id].isFeatureDetailView"
                                                        :is-prioritized-obj-listing-view= "clickedObjective[obj.id].isPrioritizedObjListingView"
                                                        :kr-progress-criteria-field-id = "clickedObjective[obj.id].krProgressCriteriaFieldId"
                                                        :okr-list="clickedObjective[obj.id].childList"
                                                        :sessions-map="clickedObjective[obj.id].childSessionsMap"
                                                        :is-items-loaded="clickedObjective[obj.id].isItemsLoaded"
                                                        :release-train-id="clickedObjective[obj.id].releaseTrainId"
                                                        :use-old-api-for-old-state-data="clickedObjective[obj.id].useOldApiForOldStateData"
                                                        :parentObjectiveKey="itemIdsMap[clickedObjective[obj.id].parentId]"
                                                        :objective-column-settings="clickedObjective[obj.id].objectiveColumnSettings"
                                                        :kr-parent-time-period-field-id="clickedObjective[obj.id].krParentTimePeriodFieldId"
                                                        :kr-parent="clickedObjective[obj.id].objective"
                                                        :setDetailsActive="true"
                                                        :openDynamicPopup="'KR'"
                                                        :customView="customView"
                                                        @close="destroyRow"
                                                    />
                                                </div>
                                                 <!-- Linked Objs Progress -->
                                                <div class="rec in ed h" v-if="selectedKRData[obj.id].linkedObjsProgress && selectedKRData[obj.id].linkedObjsProgress.length" v-for="linkedObj in selectedKRData[obj.id].linkedObjsProgress" :key="linkedObj[0]">
                                                    <div class="rc c1 fst">
                                                        <span class="fstpd">
                                                            <a v-if="!disableObjProgressPopup" class="ml-30 c-point"  @click="openLinkedObjectivePopup(linkedObj[0])" :class="{'txt-lth' : !isIdInKRList(linkedObj[0],obj.id, objGrp.id) && disableObjProgressPopup}">{{ itemIdsMap[linkedObj[0]] + ' - ' + itemTitlesMap[linkedObj[0]] }}</a>
                                                            <span v-if="disableObjProgressPopup" :class="{'txt-lth' : !isIdInKRList(linkedObj[0],obj.id, objGrp.id) && disableObjProgressPopup}">{{ itemIdsMap[linkedObj[0]] + ' - ' + itemTitlesMap[linkedObj[0]] }}</span>
                                                        </span>
                                                    </div>
                                                    <div class="rc c2 sc" v-for="(value, index) in linkedObj[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                                        {{ value !== null ? value + '%' : '-' }}
                                                    </div>
                                                     <objective-row-component v-if="clickedObjective && clickedObjective[linkedObj[0]]"
                                                        :show-un-linked-items="clickedObjective[linkedObj[0]].showUnLinkedItems"
                                                        :ref="clickedObjective[linkedObj[0]].ref"
                                                        :group-id="clickedObjective[linkedObj[0]].groupId"
                                                        :key="clickedObjective[linkedObj[0]].key"
                                                        :board="clickedObjective[linkedObj[0]].board"
                                                        :objective="clickedObjective[linkedObj[0]].objective"
                                                        :okr-list="clickedObjective[linkedObj[0]].okrList"
                                                        :is-user-searching="clickedObjective[linkedObj[0]].isUserSearching"
                                                        :readOnlyView="true"
                                                        :hide-okr="clickedObjective[linkedObj[0]].hideOkr"
                                                        :is-feature-detail-view="clickedObjective[linkedObj[0]].isFeatureDetailView"
                                                        :is-global-objective-view="clickedObjective[linkedObj[0]].isGlobalObjectiveView"
                                                        :objective-team="clickedObjective[linkedObj[0]].objectiveTeam"
                                                        :is-mocking-mode = "clickedObjective[linkedObj[0]].isMockingMode"
                                                        :is-prioritized-obj-listing-view= "clickedObjective[linkedObj[0]].isPrioritizedObjListingView"
                                                        :kr-progress-criteria-field-id = "clickedObjective[linkedObj[0]].krProgressCriteriaFieldId"
                                                        :is-art="clickedObjective[linkedObj[0]].isArt"
                                                        :release-train-id="clickedObjective[linkedObj[0]].releaseTrainId"
                                                        :departments-map="clickedObjective[linkedObj[0]].departmentsMap"
                                                        :sessions-map="clickedObjective[linkedObj[0]].sessionsMap"
                                                        :batches-map="clickedObjective[linkedObj[0]].batchesMap"
                                                        :is-items-loaded="clickedObjective[linkedObj[0]].isItemsLoaded"
                                                        :use-old-api-for-old-state-data="clickedObjective[linkedObj[0]].useOldApiForOldStateData"
                                                        :openDynamicPopup="'objective'"
                                                        :disableObjProgressPopup="true"
                                                        :customView="customView"
                                                        @close="destroyRow"
                                                        />
                                                </div>
                                        </template>
                                    </template>
                                </template>
                                </template>
                            </template>
                        </template>
                        
                        <div class="rec in ed e" v-if="this.radioTypeSelection === 'objectiveGroup' & !isAllGroupsAvg">
                            <div class="rc c1 fst"><span class="fstpd">{{ itemTitlesMap[baseItemId] }}</span></div>
                            <div class="rc c2 sc" v-for="(progress, index) in Object.values(progressData())" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                {{ progress[0]?.objGrpProgress !== null ? progress[0]?.objGrpProgress + '%' : '-' }}
                                <span v-html="generateComparisonForItem(progress[0]?.objGrpProgressDifference)"></span>
                            </div>
                        </div>
                        <template  v-for="obj in objData()" v-if="!isAllGroupsAvg">
                            <div class="rec in ed f">
                            <!-- Parent Row -->
                            <div class="rc c1 fst" :class="{'txt-lth' : !isIdInObjectiveGroupList(objectiveGroupId,obj[0])}">
                            	<span class="fstpd">
                                <em v-if="shouldObjectiveExpand(obj[0])" class="ac-arr c-point mr-10 c" :class="{'ti-angle-right': expandedBaseItems.indexOf(obj[0]) === -1,'ti-angle-down': expandedBaseItems.indexOf(obj[0]) !== -1}" @click="toggleBaseItemNavigation(obj[0])"></em> 
                                <a @click="openObjectivePopup(obj[0])" href="javascript:void(0)">{{ itemIdsMap[obj[0]] + ' - ' + itemTitlesMap[obj[0]] }}</a>
                                </span>
	                        </div>
                            <div class="rc c2 sc" v-for="(value, index) in obj[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                {{ value !== null ? value + '%' : '-' }}
                                <span v-html="generateComparisonForItem(obj[2][index])"></span>
                            </div>
                            <objective-row-component v-if="clickedObjective && clickedObjective[obj[0]]"
                                :show-un-linked-items="clickedObjective[obj[0]].showUnLinkedItems"
                                :ref="clickedObjective[obj[0]].ref"
                                :group-id="clickedObjective[obj[0]].groupId"
                                :key="clickedObjective[obj[0]].key"
                                :board="clickedObjective[obj[0]].board"
                                :objective="clickedObjective[obj[0]].objective"
                                :okr-list="clickedObjective[obj[0]].okrList"
                                :is-user-searching="clickedObjective[obj[0]].isUserSearching"
                                :readOnlyView="true"
                                :hide-okr="clickedObjective[obj[0]].hideOkr"
                                :is-feature-detail-view="clickedObjective[obj[0]].isFeatureDetailView"
                                :is-global-objective-view="clickedObjective[obj[0]].isGlobalObjectiveView"
                                :objective-team="clickedObjective[obj[0]].objectiveTeam"
                                :is-mocking-mode = "clickedObjective[obj[0]].isMockingMode"
                                :is-prioritized-obj-listing-view= "clickedObjective[obj[0]].isPrioritizedObjListingView"
                                :kr-progress-criteria-field-id = "clickedObjective[obj[0]].krProgressCriteriaFieldId"
                                :is-art="clickedObjective[obj[0]].isArt"
                                :release-train-id="clickedObjective[obj[0]].releaseTrainId"
                                :departments-map="clickedObjective[obj[0]].departmentsMap"
                                :sessions-map="clickedObjective[obj[0]].sessionsMap"
                                :batches-map="clickedObjective[obj[0]].batchesMap"
                                :is-items-loaded="clickedObjective[obj[0]].isItemsLoaded"
                                :use-old-api-for-old-state-data="clickedObjective[obj[0]].useOldApiForOldStateData"
                                :openDynamicPopup="'objective'"
                                :setDetailsActive="true"
                                :customView="customView"
                                @close="destroyRow"
                            />
                            </div>
                            <template v-if="expandedBaseItems.indexOf(obj[0]) !== -1">
                                <!-- Linked Items Progress -->
                                <div class="rec in ed bgw c">
                                    <div class="rc c1 fst">Linked Items</div>
                                    <div class="rc c2 sc tooltip" v-for="(progress, index) in selectedKRData[obj[0]].linkedItemsProgress" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                        {{ progress !== null ? progress + '%' : '-' }}
                                        <span v-html="generateComparisonForItem(selectedKRData[obj[0]].LIProgressDifferenceArray[index])"></span> 
                                        <div class="hovtooltipB fs-12">Done Linked Items Count: {{ selectedKRData[obj[0]].doneItemsCount[index] }} <br>
                                         Total Linked Items Count: {{ selectedKRData[obj[0]].linkedItemsCount[index] }}   </div>
                                    </div>
                                </div>
                            
                                <!-- Key Results Progress -->
                                <div class="rec in ed h" v-if="selectedKRData[obj[0]].linkedKRsProgress && selectedKRData[obj[0]].linkedKRsProgress.length" v-for="kr in selectedKRData[obj[0]].linkedKRsProgress" :key="kr[0]">
                                    <div class="rc c1 fst"><span class="fstpd"><a class="ml-30 c-point" @click="openKRPopup(obj[0], kr[0])" :class="{'txt-lth' : !isIdInKRList(kr[0], obj[0])}">{{ itemIdsMap[kr[0]] + ' - ' + itemTitlesMap[kr[0]] }}</a></span></div>
                                    <div class="rc c2 sc" v-for="(value, index) in kr[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                        {{ value !== null ? value + '%' : '-' }}
                                        <span v-html="generateComparisonForItem(kr[2][index])"></span> 
                                       
                                    </div>
                                      <objective-row-component v-if="clickedObjective && clickedObjective[obj.id] && clickedObjective[obj.id].krId === kr[0]"
                                            :parentId="clickedObjective[obj.id].parentId"
                                            :group-id="clickedObjective[obj.id].groupId"
                                            :key="clickedObjective[obj.id].key"
                                            :ref="clickedObjective[obj.id].ref"
                                            :board="clickedObjective[obj.id].board"
                                            :objective="clickedObjective[obj.id].objective"
                                            :readOnlyView="true"
                                            :hide-okr="clickedObjective[obj.id].hideOkr"
                                            :departments-map="clickedObjective[obj.id].departmentsMap"
                                            :is-mocking-mode="clickedObjective[obj.id].isMockingMode"
                                            :is-feature-detail-view="clickedObjective[obj.id].isFeatureDetailView"
                                            :is-prioritized-obj-listing-view= "clickedObjective[obj.id].isPrioritizedObjListingView"
                                            :kr-progress-criteria-field-id = "clickedObjective[obj.id].krProgressCriteriaFieldId"
                                            :okr-list="clickedObjective[obj.id].childList"
                                            :sessions-map="clickedObjective[obj.id].childSessionsMap"
                                            :is-items-loaded="clickedObjective[obj.id].isItemsLoaded"
                                            :release-train-id="clickedObjective[obj.id].releaseTrainId"
                                            :use-old-api-for-old-state-data="clickedObjective[obj.id].useOldApiForOldStateData"
                                            :parentObjectiveKey="itemIdsMap[clickedObjective[obj.id].parentId]"
                                            :objective-column-settings="clickedObjective[obj.id].objectiveColumnSettings"
                                            :kr-parent-time-period-field-id="clickedObjective[obj.id].krParentTimePeriodFieldId"
                                            :kr-parent="clickedObjective[obj.id].objective"
                                            :setDetailsActive="true"
                                            :openDynamicPopup="'KR'"
                                            :customView="customView"
                                            @close="destroyRow"
                                        />
                                    </div>
                                <!-- Linked Objs Progress -->
                                <div class="rec in ed h" v-if="selectedKRData[obj[0]].linkedObjsProgress && selectedKRData[obj[0]].linkedObjsProgress.length" v-for="linkedObj in selectedKRData[obj[0]].linkedObjsProgress" :key="linkedObj[0]">
                                    <div class="rc c1 fst">
                                        <span class="fstpd">
                                            <a v-if="!disableObjProgressPopup" class="ml-30 c-point" @click="openLinkedObjectivePopup(linkedObj[0])" :class="{'txt-lth' : !isIdInKRList(linkedObj[0],obj.id, objectiveGroupId) && disableObjProgressPopup}">{{ itemIdsMap[linkedObj[0]] + ' - ' + itemTitlesMap[linkedObj[0]] }}</a>
                                            <span v-if="disableObjProgressPopup" :class="{'txt-lth' : !isIdInKRList(linkedObj[0],obj.id, objectiveGroupId) && disableObjProgressPopup}">{{ itemIdsMap[linkedObj[0]] + ' - ' + itemTitlesMap[linkedObj[0]] }}</span>
                                        </span>
                                    </div>
                                    <div class="rc c2 sc" v-for="(value, index) in linkedObj[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                        {{ value !== null ? value + '%' : '-' }}
                                    </div>
                                         <objective-row-component v-if="clickedObjective && clickedObjective[linkedObj[0]]"
                                            :show-un-linked-items="clickedObjective[linkedObj[0]].showUnLinkedItems"
                                            :ref="clickedObjective[linkedObj[0]].ref"
                                            :group-id="clickedObjective[linkedObj[0]].groupId"
                                            :key="clickedObjective[linkedObj[0]].key"
                                            :board="clickedObjective[linkedObj[0]].board"
                                            :objective="clickedObjective[linkedObj[0]].objective"
                                            :okr-list="clickedObjective[linkedObj[0]].okrList"
                                            :is-user-searching="clickedObjective[linkedObj[0]].isUserSearching"
                                            :readOnlyView="true"
                                            :hide-okr="clickedObjective[linkedObj[0]].hideOkr"
                                            :is-feature-detail-view="clickedObjective[linkedObj[0]].isFeatureDetailView"
                                            :is-global-objective-view="clickedObjective[linkedObj[0]].isGlobalObjectiveView"
                                            :objective-team="clickedObjective[linkedObj[0]].objectiveTeam"
                                            :is-mocking-mode = "clickedObjective[linkedObj[0]].isMockingMode"
                                            :is-prioritized-obj-listing-view= "clickedObjective[linkedObj[0]].isPrioritizedObjListingView"
                                            :kr-progress-criteria-field-id = "clickedObjective[linkedObj[0]].krProgressCriteriaFieldId"
                                            :is-art="clickedObjective[linkedObj[0]].isArt"
                                            :release-train-id="clickedObjective[linkedObj[0]].releaseTrainId"
                                            :departments-map="clickedObjective[linkedObj[0]].departmentsMap"
                                            :sessions-map="clickedObjective[linkedObj[0]].sessionsMap"
                                            :batches-map="clickedObjective[linkedObj[0]].batchesMap"
                                            :is-items-loaded="clickedObjective[linkedObj[0]].isItemsLoaded"
                                            :use-old-api-for-old-state-data="clickedObjective[linkedObj[0]].useOldApiForOldStateData"
                                            :openDynamicPopup="'objective'"
                                            :disableObjProgressPopup="true"
                                            :customView="customView"
                                            @close="destroyRow"
                                            />
                                </div>
                            </template>
                        </template>
                      
                        <div class="rec in ed i" v-if="this.radioTypeSelection === 'objective'">
                            <div class="rc c1 fst">{{ itemIdsMap[baseItemId] + ' - ' + itemTitlesMap[baseItemId] }}</div>
                            <div class="rc c2 sc" v-for="(progress, index) in Object.values(progressData())" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                {{ progress[0]?.objProgress !== null ? progress[0]?.objProgress + '%' : '-' }}
                                <span v-html="generateComparisonForItem(progress[0]?.objProgressDifference)"></span>
                            </div>
                        </div>
                        <div class="rec in ed j" v-if="this.radioTypeSelection === 'objective'">
                            <div class="rc c1 fst">Linked Items</div>
                                <div class="rc c2 sc tooltip" v-for="(progress, index) in Object.values(progressData())" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                    {{ progress[0]?.linkedItemsProgress !== null ? progress[0]?.linkedItemsProgress + '%' : '-' }}
                                    <span v-html="generateComparisonForItem(progress[0]?.LIProgressDifference)"></span>
                                    <div class="hovtooltipB fs-12">Total Linked Items Count: {{ progress[0]?.linkedItemsCount }} <br>
                                      Done Linked Items Count: {{ progress[0]?.doneItemsCount }}
                                    </div>
                            </div>
                        </div>
                        <div class="rec in ed k" v-if="radioTypeSelection === 'objective'" v-for="kr in krData()" :key="kr[0]">
                            <div class="rc c1 fst"><span class="fstpd"><a v-if="baseItemId && kr[0]" @click="openKRPopup(baseItemId,kr[0])" class="ml-10 c-point" :class="{'txt-lth' : !isIdInKRList(kr[0], baseItemId)}">  {{ itemIdsMap[kr[0]] + ' - ' + itemTitlesMap[kr[0]] }}</a></span></div>
                            <div class="rc c2 sc" v-for="(value, index) in kr[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                {{ value !== null ? value + '%' : '-' }}
                                <span v-html="generateComparisonForItem(kr[2][index])"></span>
                            </div>
                            <objective-row-component v-if="clickedObjective && clickedObjective[baseItemId] && clickedObjective[baseItemId].krId === kr[0]"
                                :parentId="clickedObjective[baseItemId].parentId"
                                :group-id="clickedObjective[baseItemId].groupId"
                                :key="clickedObjective[baseItemId].key"
                                :ref="clickedObjective[baseItemId].ref"
                                :board="clickedObjective[baseItemId].board"
                                :objective="clickedObjective[baseItemId].objective"
                                :readOnlyView="true"
                                :hide-okr="clickedObjective[baseItemId].hideOkr"
                                :departments-map="clickedObjective[baseItemId].departmentsMap"
                                :is-mocking-mode="clickedObjective[baseItemId].isMockingMode"
                                :is-feature-detail-view="clickedObjective[baseItemId].isFeatureDetailView"
                                :is-prioritized-obj-listing-view= "clickedObjective[baseItemId].isPrioritizedObjListingView"
                                :kr-progress-criteria-field-id = "clickedObjective[baseItemId].krProgressCriteriaFieldId"
                                :okr-list="clickedObjective[baseItemId].childList"
                                :sessions-map="clickedObjective[baseItemId].childSessionsMap"
                                :is-items-loaded="clickedObjective[baseItemId].isItemsLoaded"
                                :release-train-id="clickedObjective[baseItemId].releaseTrainId"
                                :use-old-api-for-old-state-data="clickedObjective[baseItemId].useOldApiForOldStateData"
                                :parentObjectiveKey="itemIdsMap[clickedObjective[baseItemId].parentId]"
                                :openDynamicPopup="'KR'"
                                :setDetailsActive="true"
                                :customView="customView"
                                @close="destroyRow"
                            />
                        </div>
                         <div class="rec in ed k" v-if="radioTypeSelection === 'objective'" v-for="obj in linkedObjsData()" :key="obj[0]">
                            <div class="rc c1 fst">
                                <span class="fstpd">
                                    <a v-if="baseItemId && obj[0] && !disableObjProgressPopup" @click="openLinkedObjectivePopup(obj[0])" class="ml-10 c-point" :class="{'txt-lth' : !isIdInKRList(obj[0],baseItemId) && disableObjProgressPopup}">  {{ itemIdsMap[obj[0]] + ' - ' + itemTitlesMap[obj[0]] }}</a>
                                    <span v-if="disableObjProgressPopup" :class="{'txt-lth' : !isIdInKRList(obj[0],baseItemId) && disableObjProgressPopup}">{{ itemIdsMap[obj[0]] + ' - ' + itemTitlesMap[obj[0]] }}</span>
                                </span>
                            </div>
                            <div class="rc c2 sc" v-for="(value, index) in obj[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                                {{ value !== null ? value + '%' : '-' }}
                            </div>
                            <objective-row-component 
                              v-if="getLinkedObjectiveRow(obj[0])"
                              :show-un-linked-items="getLinkedObjectiveRow(obj[0]).showUnLinkedItems"
                              :ref="getLinkedObjectiveRow(obj[0]).ref"
                              :group-id="getLinkedObjectiveRow(obj[0]).groupId"
                              :key="getLinkedObjectiveRow(obj[0]).key"
                              :board="getLinkedObjectiveRow(obj[0]).board"
                              :objective="getLinkedObjectiveRow(obj[0]).objective"
                              :okr-list="getLinkedObjectiveRow(obj[0]).okrList"
                              :is-user-searching="getLinkedObjectiveRow(obj[0]).isUserSearching"
                              :readOnlyView="true"
                              :hide-okr="getLinkedObjectiveRow(obj[0]).hideOkr"
                              :is-feature-detail-view="getLinkedObjectiveRow(obj[0]).isFeatureDetailView"
                              :is-global-objective-view="getLinkedObjectiveRow(obj[0]).isGlobalObjectiveView"
                              :objective-team="getLinkedObjectiveRow(obj[0]).objectiveTeam"
                              :is-mocking-mode="getLinkedObjectiveRow(obj[0]).isMockingMode"
                              :is-prioritized-obj-listing-view="getLinkedObjectiveRow(obj[0]).isPrioritizedObjListingView"
                              :kr-progress-criteria-field-id="getLinkedObjectiveRow(obj[0]).krProgressCriteriaFieldId"
                              :is-art="getLinkedObjectiveRow(obj[0]).isArt"
                              :release-train-id="getLinkedObjectiveRow(obj[0]).releaseTrainId"
                              :departments-map="getLinkedObjectiveRow(obj[0]).departmentsMap"
                              :sessions-map="getLinkedObjectiveRow(obj[0]).sessionsMap"
                              :batches-map="getLinkedObjectiveRow(obj[0]).batchesMap"
                              :is-items-loaded="getLinkedObjectiveRow(obj[0]).isItemsLoaded"
                              :use-old-api-for-old-state-data="getLinkedObjectiveRow(obj[0]).useOldApiForOldStateData"
                              :openDynamicPopup="'objective'"
                              :disableObjProgressPopup="true"
                              :customView="customView"
                              @close="destroyRow"
                            />

                        </div>
                    </template>                  
                </div> <!-- Table End -->
                
                <div class="table brdwd" v-if="isBatchView">
                    <div class="rec ed hd mb-0">
                        <div class="rc c1 fst">Description</div>
                        <div class="rc c2 sc" v-for="(date, index) in dateHeaders" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="clndrnw1 ico FL mr-10"></span> {{ date }}
                        </div>
                    </div>
                    <div class="rec ed in mb-0" v-if="includeSubBatches && progressCriteria === 'BATCH_PROGRESS_CRITERIA'">
                        <div class="rc c1 fst"> 
                            Total Progress (Including Sub Batches)
                        </div>
                        <div class="rc c2 sc" v-for="(progress, index) in Object.values(batchData())" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="DIB" :class="{ 'aa': isCurrentPeriod(dateHeaders[index]) }">
                                {{ progress[0]?.batchProgress !== null ? progress[0]?.batchProgress + '%' : '-' }}
                                <span v-html="generateComparisonForItem(progress[0]?.progressDifference)"></span>
                            </span>
                        </div>
                    </div>
                    <div class="rec ed in mb-0">
                        <div class="rc c1 fst">
                            <em v-if="includeSubBatches && progressCriteria === 'BATCH_PROGRESS_CRITERIA'" class="arrd ti-angle-right mr-10 c-point FL d" :class="{' ': expandedBaseItems.indexOf(baseItemId) === -1,'active': expandedBaseItems.indexOf(baseItemId) !== -1}" @click="toggleBaseItemNavigation(baseItemId),fetchAllBatchIds()"></em> 
                            {{ itemIdsMap[baseItemId] + ' - ' + itemTitlesMap[baseItemId] }}
                        </div>
                        <div class="rc c2 sc" v-for="(progress, index) in Object.values(batchData())" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="DIB tooltip" :class="{ 'aa': isCurrentPeriod(dateHeaders[index]) }">
                            	{{ progress[0]?.topBatchProgress !== null ? progress[0]?.topBatchProgress + '%' : '-' }} 
                            	<span v-html="generateComparisonForItem(progress[0]?.progressDifference)"></span>
                            	<span class="hovtooltipB tprht fs-12"><span v-if="includeSubBatches && progressCriteria === 'BATCH_PROGRESS_CRITERIA'">Progress Criteria: {{ progress[0].progressCriteria }} <br> </span> Done: {{ progress[0]?.doneChildren }}  <br> Total: {{ progress[0]?.totalChildren }}</span>
                            </span>
                        </div>
                    </div>
                       
                   <template v-if="expandedBaseItems.indexOf(baseItemId) !== -1" v-for="subBatch in subBatchesData(baseItemId)">
                       <kendis-widget-sub-batch-progress  :expandedBaseItems="expandedBaseItems" :itemIdsMap="itemIdsMap" :itemTitlesMap="itemTitlesMap" :datedProgressMap="datedProgressMap" :subBatch="subBatch" :tableData="tableData" :baseItemId="baseItemId" :intervalDates="intervalDates" :allBatchIds="allBatchIds"/>
                   </template>
                       
                </div>  
                
                
                
                
                <div class="table brdwd" v-if="isRoadmapView">
                    <div class="rec ed hd mb-0">
                        <div class="rc c1 fst">Description</div>
                        <div class="rc c2 sc" v-for="(date, index) in dateHeaders" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="clndrnw1 ico FL mr-10"></span> {{ date }}
                        </div>
                    </div>
                    <div class="rec ed in mb-0">
                        <div class="rc c1 fst">
                            <em class="arrd ti-angle-right mr-10 c-point FL d" :class="{' ': expandedBaseItems.indexOf(baseItemId) === -1,'active': expandedBaseItems.indexOf(baseItemId) !== -1}" @click="toggleBaseItemNavigation(baseItemId),fetchAllBatchIds()"></em> 
                            {{ itemIdsMap[baseItemId] + ' - ' + itemTitlesMap[baseItemId] }}
                        </div>
                        <div class="rc c2 sc" v-for="(progress, index) in Object.values(roadmapData())" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="DIB" :class="{ 'aa': isCurrentPeriod(dateHeaders[index]) }">
                            	{{ progress[0]?.roadmapProgress !== null ? progress[0]?.roadmapProgress + '%' : '-' }}
                            </span>
                            <span v-html="generateComparisonForItem(roadmapProgressDifference[index])"></span>
                        </div>
                    </div>
                    
                   <div class="rec in ed k" v-if="expandedBaseItems.indexOf(baseItemId) !== -1" v-for="section in sectionsData()">
                        <div class="rc c1 fst" :style="{ backgroundColor: (itemColorsMap[section[0]] || '#3DC198') + '30' }" :key="section[0]">
                            <a v-if="groupBy === 'Parent' && itemTitlesMap[section[0]] !== 'No Parent'" class="fstpd c-point" @click="openItemLink(section[0])">{{ itemTitlesMap[section[0]] }}</a>
                            <span v-else class="fstpd">  {{ itemTitlesMap[section[0]] }} </span>
                        </div>
                        <div class="rc c2 sc" :style="{ backgroundColor: (itemColorsMap[section[0]] || '#3DC198') + '30' }" v-for="(value, index) in section[1]" :key="index" :class="{ 'highlight-current': isCurrentPeriod(dateHeaders[index]) }">
                            <span class="DIB tooltip">{{ value !== null ? value + '%' : '-' }}
                                <span class="hovtooltipB tprht fs-12">Done: {{ section[2][index] }}  <br> Total: {{ section[3][index] }}</span>
                                <span v-html="generateComparisonForItem(section[4][index])"></span> 
                            </span>
                        </div>
                   </div>
        
                </div>     
                
                              
                  
                <div v-if="tableData.intervalDates.length > 7" class="ti-angle-right artbl rht ml-20" @click="toggleSecondHalf"></div>
            </div>
        </div>
    `,
    props: {
        tableData: {
            type: Object,
            default: () => ({})
        },
        baseItemId : null,
        radioTypeSelection: null,
        objectiveGrpId: null,
        isAllGroupsAvg: false,
        allGroupIds: {
            type: Array,
            required: false
        },
        isBatchView: {
            type: Boolean,
            default: () => false
        },
        includeSubBatches : false,
        objectiveList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        objectiveGroupList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        progressCriteria: {
            type: String,
            default: () => {
                return "";
            }
        },
        objectiveData:{
            type: Object,
            default: () => ({})
        },
        disableObjProgressPopup:{
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isOKRView:{
            type: Boolean,
            default: () => false
        },
        isRoadmapView:{
            type: Boolean,
            default: () => false
        },
        groupBy: {
            type: String,
            default: () => {
                return "";
            }
        },
        itemsByIdMap: {
            type: Object,
            default: () => ({})
        },
        customView:{
            type: Object,
            default: () => { }
        },
    },

    components: {
        'kendis-widget-sub-batch-progress': kendisWidgetSubBatchProgress,
    },

    data() {
        return {
            krIds: new Set(),
            itemIdsMap: null,
            keyResults: [],
            objectives: [],
            selectedKrIds: [],
            expandedBaseItems: [],
            selectedKRData: {},
            itemTitlesMap: null,
            itemColorsMap: null,
            objectiveGroupId: null,
            clickedObjective: null,
            datedProgressMap: null,
            intervalDates :  null,
            tablePage : 1,
            fetchedObjectives: [],
            allBatchIds: [],
            subBatches : {},
            linkedObjs: [],
        };
    },
    created(){
        if(!this.isBatchView){
            this.objectiveGroupId = this.objectiveGrpId;
            EventBus.$on('rowDataObject', (rowData, objectiveId) => {
                if(!this.clickedObjective){
                    this.clickedObjective = {};
                }
                this.$set(this.clickedObjective, objectiveId, {
                    ...rowData,
                    id: objectiveId
                });

            });
            EventBus.$on('destroyRow',() => {
                if(this.clickedObjective && this.clickedObjective[this.baseItemId]){
                    this.clickedObjective[this.baseItemId] = null;
                }
            });
        }
        if(Object.keys(this.tableData.progress.datedProgressMap).length > 7){
            const entries = Object.entries(this.tableData.progress.datedProgressMap);
            const midpoint = Math.floor(entries.length / 2);
            const secondHalfEntries = entries.slice(midpoint);
            this.datedProgressMap = Object.fromEntries(secondHalfEntries);
            this.intervalDates = this.tableData.intervalDates.slice(midpoint);
        } else{
            this.datedProgressMap = this.tableData.progress.datedProgressMap;
            this.intervalDates = this.tableData.intervalDates;
            this.tablePage = -1;
        }
        this.initializeProgressTable();
        EventBus.$on('returnAllBatchIds',(allBatchIds) => {
            this.allBatchIds = allBatchIds;
        });
        EventBus.$on('linkedObjectiveLoaded',(objectiveId) => {
            if(this.clickedObjective[objectiveId]){
                EventBus.$emit('fetchLinkedObjectivePopupData', objectiveId);
            }
        });
    },
    methods: {
        initializeProgressTable() {
            this.itemIdsMap = this.tableData.itemIdsMap;
            this.itemTitlesMap = this.tableData.itemTitlesMap;
            this.itemColorsMap= this.tableData.itemColorsMap;
            this.tableData.show = true;
        },
        isCurrentPeriod(date) {
            if(date){
                const today = new Date();
                const match = date.match(/\d{2} [A-Za-z]{3}/g);

                if (!match && match.length < 1) {
                    throw new Error("Invalid date format");
                }

                let secondDateString;
                if(match.length === 2){
                    secondDateString = match[1];
                } else if(match.length === 1){
                    secondDateString = match[0];
                }

                // Split day and month from the second date
                const [day, month] = secondDateString.split(' ');

                // Get the month index (0-based)
                const monthIndex = new Date(`${month} 1`).getMonth();

                // Use the current year for the Date object
                const year = new Date().getFullYear();

                let targetDate = new Date(year, monthIndex, parseInt(day));

                date = date.trim();
                switch (this.tableData.intervals) {
                    case 'daily':
                        return today.toDateString() === targetDate.toDateString();
                    case 'weekly':
                        const isSameWeek = (date1, date2) => {
                            const dayDifference = (date1 - date2) / (1000 * 60 * 60 * 24);
                            return dayDifference < 7 && date1.getDay() >= date2.getDay();
                        };
                        return  isSameWeek(today, targetDate);
                    case 'monthly':
                        return today.getMonth() === targetDate.getMonth() &&
                            today.getFullYear() === targetDate.getFullYear();
                    case 'quarterly':
                        const getQuarter = (date) => Math.floor(date.getMonth() / 3) + 1;
                        return getQuarter(today) === getQuarter(targetDate) &&
                            today.getFullYear() === targetDate.getFullYear();
                    default:
                        return false;
                }
            }
            return false;
        },
        showKRForObjective(objectiveId){
            const selectedType = this.radioTypeSelection;
            const objectiveGroupId = this.objectiveGroupId;
            for (const [date, data] of Object.entries(this.datedProgressMap)) {
                const objectiveGroup = data[objectiveGroupId];
                if(selectedType === 'objectiveGroup'){
                    if(objectiveGroup){
                        const objectiveData = objectiveGroup[objectiveId];
                        if(objectiveData){
                            const linkedKRsProgress = objectiveData.linkedKRsProgress || {};
                            for (let krId in linkedKRsProgress) {
                                if (!this.selectedKrIds.some(kr => kr[0] === krId)) {
                                    this.selectedKrIds.push([krId, []]);
                                }
                            }
                        }
                    }
                }
            }
        },
        toggleBaseItemNavigation(baseItemId) {

            const index = this.expandedBaseItems.indexOf(baseItemId);

            if (index === -1) {
                this.expandedBaseItems.push(baseItemId);
                this.selectedKRData[baseItemId] = this.getAllResultsForObjective(baseItemId);
            } else {
                this.expandedBaseItems.splice(index, 1);
            }
        },
        getAllResultsForObjective(objKey, objGrpId) {
            let objProgress = {
                linkedItemsProgress: [],
                linkedKRsProgress: [],
                linkedObjsProgress: [],
                linkedItemsCount: [],
                doneItemsCount: [],
                LIProgressDifferenceArray: [], // Changed from single value
            };

            Object.keys(this.datedProgressMap).forEach(date => {
                const entry = this.tableData.progress.datedProgressMap[date];
                let objectiveGroup = objGrpId ? entry[objGrpId] : entry[this.objectiveGroupId];

                if (objectiveGroup) {
                    const objectiveData = objectiveGroup[objKey];

                    if (objectiveData) {
                        objProgress.linkedItemsProgress.push(objectiveData.linkedItemsProgress ?? null);
                        objProgress.linkedItemsCount.push(objectiveData.objProgressMap.totalSize ?? 0);
                        objProgress.doneItemsCount.push(objectiveData.objProgressMap.totalDone ?? 0);
                    } else {
                        objProgress.linkedItemsProgress.push(null);
                        objProgress.linkedItemsCount.push(0);
                        objProgress.doneItemsCount.push(0);
                    }
                } else {
                    objProgress.linkedItemsProgress.push(null);
                    objProgress.linkedItemsCount.push(0);
                    objProgress.doneItemsCount.push(0);
                }
            });

            // New: Calculate progress differences for linkedItemsProgress
            for (let i = 0; i < objProgress.linkedItemsProgress.length; i++) {
                if (i === 0) {
                    objProgress.LIProgressDifferenceArray.push(null);
                } else {
                    const prev = objProgress.linkedItemsProgress[i - 1];
                    const curr = objProgress.linkedItemsProgress[i];

                    if (prev !== null && curr !== null) {
                        objProgress.LIProgressDifferenceArray.push(curr - prev);
                    } else {
                        objProgress.LIProgressDifferenceArray.push(null);
                    }
                }
            }

            objProgress.linkedKRsProgress = this.keyResults
                .map(([krId]) => {
                    const krProgressArray = Object.keys(this.datedProgressMap).map(date => {
                        const entry = this.datedProgressMap[date];
                        let objectiveGroup = objGrpId ? entry[objGrpId] : entry[this.objectiveGroupId];

                        if (objectiveGroup) {
                            const objectiveData = objectiveGroup[objKey];
                            if (objectiveData && objectiveData.linkedKRsProgress) {
                                return objectiveData.linkedKRsProgress[krId]?.progress ?? null;
                            }
                        }
                        return null;
                    });

                    const hasProgress = krProgressArray.some(progress => progress !== null);

                    if (hasProgress) {
                        // New: Compute array of differences for KR
                        const progressDifferenceArray = krProgressArray.map((curr, i) => {
                            if (i === 0) return null;
                            let prev = krProgressArray[i - 1];
                            if(!prev){
                                prev = 0;
                            }
                            return (curr !== null && prev !== null) ? curr - prev : null;
                        });

                        return [krId, krProgressArray, progressDifferenceArray];
                    }

                    return null;
                })
                .filter(result => result !== null);

            objProgress.linkedObjsProgress = this.linkedObjs
                .map(([objId]) => {

                    const linkedObjsProgressArray = Object.keys(this.datedProgressMap).map(date => {
                        const entry = this.datedProgressMap[date];
                        let objectiveGroup;
                        if(objGrpId){
                            objectiveGroup = entry[objGrpId];
                        } else{
                            objectiveGroup = entry[this.objectiveGroupId];
                        }


                        if (objectiveGroup) {
                            const objectiveData = objectiveGroup[objKey];

                            if (objectiveData && objectiveData.linkedObjsProgress) {

                                return objectiveData.linkedObjsProgress[objId] !== undefined
                                    ? objectiveData.linkedObjsProgress[objId].progress
                                    : null;
                            }
                        }
                        return null;
                    });


                    const hasProgress = linkedObjsProgressArray.some(progress => progress !== null);

                    if (hasProgress) {
                        return [objId, linkedObjsProgressArray];
                    }

                    return null;
                })
                .filter(result => result !== null);

                return objProgress;
            },
        toggleObjectiveNavigation(groupId, objectiveId, linkedKRIds, linkedObjIds){
            this.objectiveGroupId = groupId;
            this.keyResults = linkedKRIds;
            this.linkedObjs = linkedObjIds;
            this.toggleBaseItemNavigation(objectiveId);
        },
        allGroupsData() {
            const tableData = [];

            // Iterate through all objective group IDs
            for (const objectiveGroupId of this.allGroupIds) {
                const groupInfo = {
                    name: this.itemTitlesMap[objectiveGroupId], // Map to get group name
                    progress: [], // To store group progress for each date
                    objProgress: new Map(),
                    id: null
                };

                // Arrays to store objective and key result IDs (optional if not used later)
                const objectiveIds = new Set();
                const krIds = [];
                const linkedObjIds = [];

                // Iterate over all the dates in the datedProgressMap
                for (const [date, data] of Object.entries(this.datedProgressMap)) {
                    const objectiveGroup = data[objectiveGroupId];
                    groupInfo.id = objectiveGroupId;

                    // Push the rounded progress for the group or null if not available
                    groupInfo.progress.push(objectiveGroup ? objectiveGroup.objGrpProgress : null);

                    if (objectiveGroup) {
                        // Iterate over all objectives in the objective group
                        for (const [objId, itemData] of Object.entries(objectiveGroup)) {
                            if (objId !== 'objGrpProgress') {
                                objectiveIds.add(objId); // Using Set to ensure uniqueness
                                if(itemData.linkedKRsProgress){
                                    for(const krId of Object.keys(itemData.linkedKRsProgress)){
                                        if (!krIds.some(kr => kr[0] === krId)) {
                                            krIds.push([krId, []]);
                                        }
                                        if (!this.keyResults.some(kr => kr[0] === krId)) {
                                            this.keyResults.push([krId, []]);
                                        }
                                    }
                                }
                                if(itemData.linkedObjsProgress){
                                    for(const objId of Object.keys(itemData.linkedObjsProgress)){
                                        if (!linkedObjIds.some(obj => obj[0] === objId)) {
                                            linkedObjIds.push([objId, []]);
                                        }
                                        if (!this.linkedObjs.some(kr => kr[0] === objId)) {
                                            this.linkedObjs.push([objId, []]);
                                        }
                                    }
                                }

                                // Initialize or update the objective progress map
                                if (!groupInfo.objProgress.has(objId)) {
                                    groupInfo.objProgress.set(objId, {
                                        name: this.itemIdsMap[objId], // Objective name
                                        progress: new Array(Object.keys(this.datedProgressMap).length).fill(null), // Initialize with null values for each date
                                        id: objId,
                                        linkedKRIds: krIds,
                                        linkedObjIds: linkedObjIds,
                                    });
                                }

                                // Add the progress for the current objective for this date
                                const objectiveProgress = groupInfo.objProgress.get(objId);
                                objectiveProgress.progress[groupInfo.progress.length - 1] = itemData.progress || null;
                            }
                        }
                    } else {
                        // If no data for the objective group, add null progress for each objective
                        for (const objId of objectiveIds) {
                            if (!groupInfo.objProgress.has(objId)) {
                                groupInfo.objProgress.set(objId, {
                                    name: this.itemIdsMap[objId],
                                    progress: new Array(Object.keys(this.datedProgressMap).length).fill(null),
                                    id: objId,
                                    linkedKRIds: [],
                                    linkedObjIds: []
                                });
                            }
                            const objectiveProgress = groupInfo.objProgress.get(objId);
                            objectiveProgress.progress[groupInfo.progress.length - 1] = null; // Set null for this date
                        }
                    }
                }

                // Convert the Map back to an array for objProgress
                groupInfo.objProgress = Array.from(groupInfo.objProgress.values());

                // Calculate progress differences for the objectives
                for (const obj of groupInfo.objProgress) {
                    obj.progressDifference = [];
                    obj.progressDifference.push(0);
                    for (let i = 1; i < obj.progress.length; i++) {
                        let prevProgress = obj.progress[i - 1];
                        if(!prevProgress) {
                            prevProgress = 0;
                        }
                        const currentProgress = obj.progress[i];
                        const diff = (currentProgress !== null && prevProgress !== null) ? currentProgress - prevProgress : null;
                        obj.progressDifference.push(diff);
                    }
                }

                // Calculate group-level progress difference for each date pair
                groupInfo.progressDifference = [];
                groupInfo.progressDifference.push(0);
                for (let i = 1; i < groupInfo.progress.length; i++) {
                    let prevProgress = groupInfo.progress[i - 1];
                    if(!prevProgress){
                        prevProgress = 0;
                    }
                    const currentProgress = groupInfo.progress[i];
                    const diff = (currentProgress !== null && prevProgress !== null) ? currentProgress - prevProgress : null;
                    groupInfo.progressDifference.push(diff);
                }

                // Push the completed group info to the final table data
                if (groupInfo.name) {
                    tableData.push(groupInfo);
                }
            }

            return tableData;
        },

        progressData() {
            const result = {};
            const selectedType = this.radioTypeSelection;
            const objectiveGroupId = this.objectiveGroupId;
            const objectiveId = this.baseItemId;

            for (const [date, data] of Object.entries(this.datedProgressMap)) {
                result[date] = [];
                const objectiveGroup = data[objectiveGroupId];

                if (selectedType === 'objectiveGroup') {
                    if (objectiveGroup) {
                        const objGrpProgress = objectiveGroup.objGrpProgress ?? null;
                        const objProgress = {};

                        for (const [id, itemData] of Object.entries(objectiveGroup)) {
                            if (id !== 'objGrpProgress') {
                                const linkedKRsProgress = itemData.linkedKRsProgress || {};
                                for (let krId in linkedKRsProgress) {
                                    if (!this.keyResults.some(kr => kr[0] === krId)) {
                                        this.keyResults.push([krId, []]);
                                    }
                                }
                                const linkedObjsProgress = itemData.linkedObjsProgress || {};
                                for (let objId in linkedObjsProgress) {
                                    if (!this.linkedObjs.some(kr => kr[0] === objId)) {
                                        this.linkedObjs.push([objId, []]);
                                    }
                                }
                                if (!this.objectives.some(existingId => existingId[0] === id)) {
                                    this.objectives.push([id, []]);
                                }

                                objProgress[id] = {
                                    objProgress: itemData.progress ?? null,
                                    name: this.itemIdsMap[id] || null
                                };
                            }
                        }

                        result[date].push({
                            objGrpProgress,
                            objProgress,
                            name: this.itemIdsMap[objectiveGroupId] || null,
                            objGrpProgressDifference: null,
                            objProgressDifference: {},
                        });
                    } else {
                        result[date].push({
                            objGrpProgress: null,
                            objProgress: {},
                            name: this.itemIdsMap[objectiveGroupId] || null,
                            objGrpProgressDifference: null,
                            objProgressDifference: {},
                        });
                    }

                } else if(selectedType === 'objective'){
                    if(objectiveGroup){
                        const objectiveData = objectiveGroup[objectiveId] || this.nestedObjData(objectiveGroup, objectiveId);
                        if (objectiveData) {
                            const linkedKRsProgress = objectiveData.linkedKRsProgress || {};
                            for (let krId in linkedKRsProgress) {
                                if (!this.keyResults.some(kr => kr[0] === krId)) {
                                    this.keyResults.push([krId, []]);
                                }
                            }
                            const linkedObjsProgress = objectiveData.linkedObjsProgress || {};
                            for (let objId in linkedObjsProgress) {
                                if (!this.linkedObjs.some(kr => kr[0] === objId)) {
                                    this.linkedObjs.push([objId, []]);
                                }
                            }
                            result[date].push({
                                objProgress: objectiveData.progress ?? null,
                                linkedKRsProgress,
                                name: this.itemIdsMap[objectiveId] || null,
                                linkedItemsProgress: objectiveData.linkedItemsProgress !== undefined
                                    ? objectiveData.linkedItemsProgress : null,
                                linkedItemsCount: objectiveData.objProgressMap.totalSize !== undefined ? objectiveData.objProgressMap.totalSize : 0,
                                doneItemsCount: objectiveData.objProgressMap.totalDone !== undefined ? objectiveData.objProgressMap.totalDone : 0,
                                linkedObjsProgress: linkedObjsProgress,
                                LIProgressDifference: null,
                                objProgressDifference: null
                            });
                        } else {
                            for (const [id, obj] of Object.entries(objectiveGroup)) {
                                if (id !== 'objGrpProgress' && obj.linkedKRsProgress) {
                                    for (const [krId, krData] of Object.entries(obj.linkedKRsProgress)) {
                                        if (krData.KRLinkedObjs?.[objectiveId]) {
                                            const objectiveData = krData.KRLinkedObjs[objectiveId];
                                            result[date].push({
                                                objProgress: objectiveData.progress ?? null,
                                                name: this.itemIdsMap[objectiveId] || null,
                                                linkedItemsProgress: objectiveData.linkedItemsProgress ?? null,
                                                linkedItemsCount: objectiveData.objProgressMap.totalSize ?? 0,
                                                doneItemsCount: objectiveData.objProgressMap.totalDone ?? 0,
                                                LIProgressDifference: null,
                                                objProgressDifference: null
                                            });
                                        }
                                    }
                                }
                            }
                            if (_.isEmpty(result[date])) {
                                result[date].push({
                                    objProgress: null,
                                    linkedKRsProgress: {},
                                    linkedItemsProgress: null,
                                    linkedItemsCount: 0,
                                    doneItemsCount: 0,
                                    LIProgressDifference: null,
                                    objProgressDifference: null,
                                    linkedObjsProgress: {},
                                });
                            }
                        }
                    } else {
                        result[date].push({
                            objProgress: null,
                            linkedKRsProgress: {},
                            linkedItemsProgress: null,
                            linkedItemsCount: 0,
                            doneItemsCount: 0,
                            LIProgressDifference: null,
                            objProgressDifference: null,
                            linkedObjsProgress:{}
                        });
                    }
                }
            }

            // Difference calculation for all entries
            const entries = Object.entries(result);

            for (let i = 0; i < entries.length; i++) {
                const [currDate, currData] = entries[i];
                const [currEntry] = currData;

                if (i === 0) continue; // No previous entry to compare with

                const [prevDate, prevData] = entries[i - 1];
                const [prevEntry] = prevData;

                if (selectedType === 'objective') {
                    const currObjProgress = currEntry.objProgress;
                    const prevObjProgress = prevEntry.objProgress;
                    currEntry.objProgressDifference = (currObjProgress !== null && prevObjProgress !== null)
                        ? currObjProgress - prevObjProgress
                        : null;

                    const currLIProgress = currEntry.linkedItemsProgress;
                    const prevLIProgress = prevEntry.linkedItemsProgress;
                    currEntry.LIProgressDifference = (currLIProgress !== null && prevLIProgress !== null)
                        ? currLIProgress - prevLIProgress
                        : null;

                } else if (selectedType === 'objectiveGroup') {
                    const currObjGrpProgress = currEntry.objGrpProgress;
                    const prevObjGrpProgress = prevEntry.objGrpProgress;
                    currEntry.objGrpProgressDifference = (currObjGrpProgress !== null && prevObjGrpProgress !== null)
                        ? currObjGrpProgress - prevObjGrpProgress
                        : null;

                    const currObjMap = currEntry.objProgress;
                    const prevObjMap = prevEntry.objProgress;

                    const diffMap = {};
                    Object.keys(currObjMap).forEach(objId => {
                        const curr = currObjMap[objId]?.objProgress ?? null;
                        const prev = prevObjMap[objId]?.objProgress ?? null;
                        diffMap[objId] = (curr !== null && prev !== null) ? curr - prev : null;
                    });

                    currEntry.objProgressDifference = diffMap;
                }


                result[currDate] = [currEntry];
            }

            return result;
        },
        nestedObjData(objectiveGroup){
            for(let objId in objectiveGroup){
                if(objId !== 'objGrpProgress'){
                    let objective = objectiveGroup[objId];
                    if(objective.linkedObjsProgress && objective.linkedObjsProgress[this.baseItemId]){
                        return objective.linkedObjsProgress[this.baseItemId];
                    }
                }
            }
            return null;
        },


        objData() {
            return this.objectives.map(([objId]) => {
                const dates = Object.keys(this.datedProgressMap).sort();
                const objProgressArray = dates.map(date => {
                    const entry = this.datedProgressMap[date];
                    const objectiveGroup = entry[this.objectiveGroupId];
                    const objectiveData = objectiveGroup?.[objId];
                    return objectiveData?.progress ?? null;
                });

                const progressDifferenceArray = objProgressArray.map((value, index) => {
                    if (index === 0 || value === null || objProgressArray[index - 1] === null) {
                        return null;
                    }
                    return value - objProgressArray[index - 1];
                });

                return [objId, objProgressArray, progressDifferenceArray];
            });
        },
        krData() {
            const result = [];
            const dates = Object.keys(this.datedProgressMap).sort();

            for (const [krId] of this.keyResults) {
                const krProgressArray = [];

                for (let date of dates) {
                    const entry = this.datedProgressMap[date];
                    const selectedType = this.radioTypeSelection;

                    let progressValue = null;

                    if (selectedType === 'objective') {
                        const objectiveGroup = entry[this.objectiveGroupId];
                        const objectiveData = objectiveGroup?.[this.baseItemId] || this.nestedObjData(objectiveGroup, this.baseItemId);

                        progressValue = objectiveData?.linkedKRsProgress?.[krId]?.progress ?? null;

                    } else if (selectedType === 'objectiveGroup') {
                        const objectiveGroup = entry[this.objectiveGroupId];
                        const krData = objectiveGroup?.[krId];
                        progressValue = krData?.progress?.progress ?? null;
                    }
                    krProgressArray.push(progressValue);
                }

                const progressDifferenceArray = krProgressArray.map((value, index) => {
                    if (index === 0 || value === null || krProgressArray[index - 1] === null) {
                        return null;
                    }
                    return value - krProgressArray[index - 1];
                });

                result.push([krId, krProgressArray, progressDifferenceArray]);
            }

            return result;
        },
        linkedObjsData() {
            return this.linkedObjs.map(([objId]) => {
                const linkedObjsProgressArray = Object.keys(this.datedProgressMap).map(date => {
                    const entry = this.datedProgressMap[date];
                    const selectedType = this.radioTypeSelection;

                    if (selectedType === 'objective') {
                        const objectiveGroup = entry[this.objectiveGroupId];
                        if (objectiveGroup) {
                            const objectiveData = objectiveGroup[this.baseItemId] || this.nestedObjData(objectiveGroup);
                            if (objectiveData && objectiveData.linkedObjsProgress) {
                                return objectiveData.linkedObjsProgress[objId] !== undefined
                                    ? objectiveData.linkedObjsProgress[objId].progress
                                    : null;
                            }
                        }
                    } else if (selectedType === 'objectiveGroup') {
                        const objectiveGroup = entry[this.objectiveGroupId];
                        if (objectiveGroup && objectiveGroup[objId]) {
                            return objectiveGroup[objId].progress !== undefined
                                ? objectiveGroup[objId].progress.progress
                                : null;
                        }
                    }
                    return null;
                });
                return [objId, linkedObjsProgressArray];
            });
        },
        batchData() {
            const result = {};
            const dates = Object.keys(this.datedProgressMap).sort();

            for (let i = 0; i < dates.length; i++) {
                const date = dates[i];
                result[date] = [];

                const batch = this.datedProgressMap[date]?.[this.baseItemId] || null;

                let progressDifference = null;

                if (i > 0) {
                    const prevDate = dates[i - 1];
                    const prevBatch = this.datedProgressMap[prevDate]?.[this.baseItemId] || null;

                    const currentProgress = batch?.batchProgress ?? null;
                    const previousProgress = prevBatch?.batchProgress ?? null;

                    if (currentProgress !== null && previousProgress !== null) {
                        progressDifference = currentProgress - previousProgress;
                    }
                }


                result[date].push({
                    batchProgress: batch?.batchProgress ?? null,
                    name: this.itemIdsMap[this.baseItemId] || null,
                    totalChildren: batch?.totalChildren ?? null,
                    doneChildren: batch?.doneChildren ?? null,
                    topBatchProgress: batch?.topBatchProgress ?? null,
                    progressCriteria: batch?.progressCriteria ?? null,
                    progressDifference: progressDifference,
                });
            }

            return result;
        },



        subBatchesData(batchId) {
            const subBatchData = {};
            const allSubBatchIds = new Set();


            const dates = Object.keys(this.datedProgressMap);
            const totalDates = dates.length;


            for (const date of dates) {
                let batchData;


                if (this.datedProgressMap[date][batchId]) {
                    batchData = this.datedProgressMap[date][batchId];
                } else {
                    batchData = this.findProgress(this.datedProgressMap[date][this.baseItemId], batchId);
                }

                if (batchData && batchData.subBatchProgress) {

                    for (const subBatchId of Object.keys(batchData.subBatchProgress)) {
                        allSubBatchIds.add(subBatchId);

                        if (!subBatchData[subBatchId]) {
                            subBatchData[subBatchId] = {
                                progressArray: Array(totalDates).fill(null),
                                subBatchProgress: null,
                                doneChildren: Array(totalDates).fill(0),
                                totalDone: Array(totalDates).fill(0),
                                progressCriteria: Array(totalDates).fill(null),
                            };
                        }

                        const subBatchInfo = batchData.subBatchProgress[subBatchId];
                        if (subBatchInfo.subBatchProgress) {
                            subBatchData[subBatchId].subBatchProgress = subBatchInfo.subBatchProgress;
                        }

                        // Populate the progress value at the correct index (date order)
                        const dateIndex = dates.indexOf(date);
                        subBatchData[subBatchId].progressArray[dateIndex] =
                            subBatchInfo.batchProgress !== undefined ? subBatchInfo.batchProgress || 0 : null;
                        subBatchData[subBatchId].doneChildren[dateIndex] = subBatchInfo.results[0] !== undefined ? subBatchInfo.results[0] || 0 : null;
                        subBatchData[subBatchId].totalDone[dateIndex] = subBatchInfo.results[1] !== undefined ? subBatchInfo.results[1] || 0 : null;
                        subBatchData[subBatchId].progressCriteria[dateIndex] = subBatchInfo.progressCriteria || null;
                    }
                }
            }

            // Ensure all subBatchIds have the correct array length (already initialized to totalDates)
            allSubBatchIds.forEach((subBatchId) => {
                if (!subBatchData[subBatchId]) {
                    subBatchData[subBatchId] = {
                        progressArray: new Array(totalDates).fill(null),
                        subBatchProgress: null,
                        doneChildren: Array(totalDates).fill(0),
                        totalDone: Array(totalDates).fill(0),
                        progressCriteria: Array(totalDates).fill(null),
                    };
                }
            });

            const subBatchesResult = Object.entries(subBatchData).map(([subBatchId, data]) => {
                const progressDifferenceArray = new Array(totalDates).fill(null);


                for (let i = 1; i < totalDates; i++) {
                    const prev = data.progressArray[i - 1];
                    const curr = data.progressArray[i];

                    if (
                        prev !== null && prev !== undefined &&
                        curr !== null && curr !== undefined
                    ) {
                        progressDifferenceArray[i] = curr - prev;
                    }
                }

                return [subBatchId, data.progressArray, data.subBatchProgress, data.doneChildren, data.totalDone, data.progressCriteria, progressDifferenceArray];

            });

            return subBatchesResult;
        },
        findProgress(data, targetId) {
            if (data && data.subBatchProgress && data.subBatchProgress[targetId]) {
                return data.subBatchProgress[targetId];
            }

            if (data && data.subBatchProgress) {
                for (const key in data.subBatchProgress) {
                    const result = this.findProgress(data.subBatchProgress[key], targetId);
                    if (result) return result;
                }
            }
            return null;
        },

        openObjectivePopup(objectiveId){
            EventBus.$emit('fetchObjectivePopupData', objectiveId);
        },

        openKRPopup(objectiveId, keyResultId){
            EventBus.$emit('fetchKrPopupData', objectiveId, keyResultId);

        },
        openLinkedObjectivePopup(objectiveId){
            if(!this.clickedObjective){
                this.clickedObjective = {};
            }
            if(!this.clickedObjective[objectiveId]){
                this.clickedObjective[objectiveId] = {};
            }
            EventBus.$emit('fetchLinkedObjectivePopupData', objectiveId);
        },
        destroyRow(){
            this.clickedObjective = null;
        },
        toggleFirstHalf(){
            const entries = Object.entries(this.tableData.progress.datedProgressMap);
            const midpoint = Math.floor(entries.length / 2);
            const secondHalfEntries = entries.slice(0,midpoint);
            this.datedProgressMap = Object.fromEntries(secondHalfEntries);
            this.intervalDates = this.tableData.intervalDates.slice(0,midpoint);
            this.tablePage = 0;
        },
        toggleSecondHalf(){
            const entries = Object.entries(this.tableData.progress.datedProgressMap);
            const midpoint = Math.floor(entries.length / 2);
            const secondHalfEntries = entries.slice(midpoint);
            this.datedProgressMap = Object.fromEntries(secondHalfEntries);
            this.intervalDates = this.tableData.intervalDates.slice(midpoint);
            this.tablePage = 1;
        },
        isIdInObjectiveGroupList(objGrpId, objectiveId){
            let objectiveGroupList = [];
            if(this.objectiveGroupList && this.objectiveGroupList.length > 0){
                objectiveGroupList = this.objectiveGroupList;
            } else{
                objectiveGroupList = kendisStore.state.ojectiveGroups;
            }
            const group = objectiveGroupList.find(group => group.id === objGrpId);
            if (!group) {
                return false; // Group not found
            }
            return group.baseItemLinks.some(link => link.baseItemId === objectiveId);
        },
        shouldObjectiveExpand(objectiveId, objGrpId){
            const data = this.getAllResultsForObjective(objectiveId, objGrpId);
            return data.linkedItemsCount.some(value => value > 0) || data.linkedKRsProgress.length > 0 || data.linkedObjsProgress.length > 0;
        },
        shouldObjectiveGroupExpand(objGrp){
            return objGrp.objProgress.length > 0;
        },
        fetchAllBatchIds(){
            EventBus.$emit("fetchAllBatchIds");
        },
        isIdInKRList(krId,objId, objGrpId){
            if(this.objectiveData && this.objectiveData.id){
                if(this.objectiveData.baseItemList){
                    return this.objectiveData.baseItemList.some(kr => kr.id === krId);
                }
            } else if(this.objectiveList && this.objectiveList.length > 0 && !objGrpId){
                const matchingObjective = this.objectiveList.find(objective => objective.id === objId);
                if (matchingObjective) {
                    return matchingObjective.baseItemList.some(kr => kr.id === krId);
                }
            } else {
                let objectiveGroupList = [];
                if(this.objectiveGroupList && this.objectiveGroupList.length > 0){
                    objectiveGroupList = this.objectiveGroupList;
                } else{
                    objectiveGroupList = kendisStore.state.ojectiveGroups;
                }
                if(objectiveGroupList){
                    const matchingObjectiveGroup = objectiveGroupList.find(objGroup => objGroup.id === objGrpId);
                    if(matchingObjectiveGroup) {
                        let matchingObjective;
                        if(matchingObjectiveGroup.baseItemList){
                            matchingObjective = matchingObjectiveGroup.baseItemList.find(objective => objective.id === objId);
                        } else if(matchingObjectiveGroup.baseItemLinks){
                            matchingObjective = matchingObjectiveGroup.baseItemLinks.find(
                                objective => objective?.baseItemId && objective.baseItemId === objId
                            );
                        }
                        if (matchingObjective && matchingObjective.baseItemList) {
                            return matchingObjective.baseItemList.some(kr => kr.id === krId);
                        }
                    }
                }
            }
            return false;
        },
        roadmapData(){
            let result = {};
            for(const [date,data] of Object.entries(this.datedProgressMap)){
                result[date] = [];
                const roadmap = data[this.baseItemId];
                if(roadmap){
                    result[date].push({
                        roadmapProgress: roadmap.roadmapProgress !== undefined ? roadmap.roadmapProgress || 0 : null,
                        name: this.itemIdsMap[this.baseItemId] || null,
                    });
                } else{
                    result[date].push({
                        roadmapProgress: null,
                        name: this.itemIdsMap[this.baseItemId] || null,
                    });
                }
            }
            return result;
        },
        sectionsData() {
            const sectionsData = {};
            const allSectionsIds = new Set();

            const dates = Object.keys(this.datedProgressMap);
            const totalDates = dates.length;

            for (const date of dates) {
                let roadmapData = this.datedProgressMap[date][this.baseItemId] || null;

                if (roadmapData && roadmapData.sectionsProgress) {
                    for (const sectionId of Object.keys(roadmapData.sectionsProgress)) {
                        allSectionsIds.add(sectionId);

                        if (!sectionsData[sectionId]) {
                            sectionsData[sectionId] = {
                                progressArray: Array(totalDates).fill(null),
                                doneChildren: Array(totalDates).fill(0),
                                totalDone: Array(totalDates).fill(0),
                            };
                        }

                        const sectionInfo = roadmapData.sectionsProgress[sectionId];
                        const dateIndex = dates.indexOf(date);

                        sectionsData[sectionId].progressArray[dateIndex] =
                            sectionInfo.sectionProgress !== undefined ? sectionInfo.sectionProgress || 0 : null;
                        sectionsData[sectionId].doneChildren[dateIndex] =
                            sectionInfo.totalDone !== undefined ? sectionInfo.totalDone || 0 : null;
                        sectionsData[sectionId].totalDone[dateIndex] =
                            sectionInfo.totalSize !== undefined ? sectionInfo.totalSize || 0 : null;
                    }
                }
            }

            allSectionsIds.forEach((sectionId) => {
                if (!sectionsData[sectionId]) {
                    sectionsData[sectionId] = {
                        progressArray: new Array(totalDates).fill(null),
                        doneChildren: Array(totalDates).fill(0),
                        totalDone: Array(totalDates).fill(0),
                    };
                }
            });

            const sectionsResult = Object.entries(sectionsData).map(([sectionId, data]) => {
                const progressDiffArray = new Array(totalDates).fill(null);


                for (let i = 1; i < totalDates; i++) {
                    const prev = data.progressArray[i - 1];
                    const curr = data.progressArray[i];

                    if (
                        prev !== null && prev !== undefined &&
                        curr !== null && curr !== undefined
                    ) {
                        progressDiffArray[i] = curr - prev;
                    }
                }


                return [sectionId, data.progressArray, data.doneChildren, data.totalDone, progressDiffArray];
            });

            return sectionsResult;
        },
        generateComparisonForItem(diff) {
            let arrow;
            if(diff > 0){
                arrow = 'arrow-up-grn';
            } else if (diff < 0){
                arrow = 'arrow-down-red';
            }
            return `<span class="${arrow} arr p-abs"></span>`;
        },
        openItemLink(itemId){
            if(this.itemsByIdMap && Object.keys(this.itemsByIdMap).length > 0){
                let firstKey = Object.keys(this.itemsByIdMap)[0];
                let firstItem = this.itemsByIdMap[firstKey];
                let url = firstItem.url;
                let newUrl = url.replace(/\/browse\/[A-Z]+-\d+/, "/browse");
                let almKey = this.itemTitlesMap[itemId].split(" ")[0];
                newUrl = newUrl +  "/" + almKey;
                window.open(newUrl, '_blank');
            }
        },
    },
    computed: {
        dateHeaders() {
            const intervalDates = [];
            if (!_.isEmpty(this.intervalDates)) {
                const monthMap = {
                    '1': 'Jan',
                    '2': 'Feb',
                    '3': 'Mar',
                    '4': 'Apr',
                    '5': 'May',
                    '6': 'Jun',
                    '7': 'Jul',
                    '8': 'Aug',
                    '9': 'Sep',
                    '10': 'Oct',
                    '11': 'Nov',
                    '12': 'Dec'
                };
                const quarterMap = {
                    '1': 'Q1',
                    '2': 'Q1',
                    '3': 'Q2',
                    '4': 'Q2',
                    '5': 'Q2',
                    '6': 'Q2',
                    '7': 'Q3',
                    '8': 'Q3',
                    '9': 'Q3',
                    '10': 'Q4',
                    '11': 'Q4',
                    '12': 'Q4'
                };

                const dateSize = this.tablePage !== -1? Math.floor(this.tableData.intervalDates.length/2) : 0;
                let currentDate = new Date(this.intervalDates[0]);
                let month = currentDate.getMonth();
                switch (this.tableData.intervals) {
                    case 'daily':
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            intervalDates.push(this.$parent.getExactDate(new Date(this.intervalDates[i])));
                        }
                        break;
                    case 'weekly':
                        currentDate.setDate(currentDate.getDate() - 7);
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            const weekNo = this.tablePage === 0 ? `Week ${i +1}` : `Week ${i +1 + dateSize}`;
                            let startDate = new Date(endDate);
                            startDate.setDate(startDate.getDate()-6);
                            intervalDates.push(`${weekNo} (` + (this.$parent.getExactDate(startDate) + "-" + this.$parent.getExactDate(endDate)) + ')');
                            currentDate = endDate;
                        }
                        break;
                    case 'monthly':
                        if(currentDate.getMonth() === month){
                            currentDate.setMonth(month - 1);
                            currentDate.setDate(currentDate.getDate() - 1);
                        }
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            let startDate = new Date(currentDate);
                            startDate.setDate(startDate.getDate() +1);
                            intervalDates.push(monthMap[startDate.getMonth() + 1] + ` (${this.$parent.getExactDate(startDate)} - ${this.$parent.getExactDate(endDate)})`);
                            currentDate = endDate;
                        }
                        break;
                    case 'quarterly':
                        currentDate.setMonth(month - 3);
                        if(currentDate.getMonth() === month - 2){
                            currentDate.setMonth(month - 1);
                        }
                        for (let i = 0; i < this.intervalDates.length; i++) {
                            let endDate = new Date(this.intervalDates[i]);
                            intervalDates.push(
                                quarterMap[currentDate.getMonth() + 1] +
                                ` (${this.$parent.getExactDate(currentDate)} - ${this.$parent.getExactDate(endDate)})`
                            );
                            currentDate = endDate;
                        }
                        break;
                    default:
                        console.error("Unknown interval type");
                }


            }
            return intervalDates;
        },
        getLinkedObjectiveRow() {
            return (objectiveId) => {
                return this.clickedObjective && this.clickedObjective[objectiveId];
            };
        },
        roadmapProgressDifference() {
            const values = Object.values(this.roadmapData())
                .map(item => item[0]?.roadmapProgress);

            const differences = [];

            differences.push(0);
            for (let i = 1; i < values.length; i++) {
                if(values[i] !== null && values[i-1] !== null){
                    differences.push(values[i] - values[i - 1]);
                } else if(values[i] !== null){
                    differences.push(values[i]);
                }
                else {
                    differences.push(0);
                }

            }

            return differences;
        },
    },
});
