const kendisWidgetLeadTimeGraph = Vue.component('kendis-widget-lead-time', {
    template: `
    <div style="height: 100%;">
         <div class="" style="height: 100%;">
             <div  class="cfdGraphCard">
				<div v-if="loading" class="loader">
                  <div>
                    <div class="loaderinteg"/>
                  </div>
                </div> 
				<div v-if="widgetObj.state !== 'new'"  class="graphInnerContainer">
                    <div>
                    <div class="cardHeader" ref="header">
                        <div>
                            <div class="tooltip">
                                <h4 class="cardTitle" style="max-width: initial;">{{widgetObj.name}}</h4>                                        
                            </div>                                       
                            <div v-if="!addWidget" class="tooltip criteria">
                                <p class="clickable-text">Criteria Details</p>
                                <div class="hovtooltip criteriaDetailTip">
                                    <div class="graphName">{{widgetObj.category}}</div>
                                    <kendis-widget-criteria-details :graphCriteria="graphCriteria" :type ="!_.isEmpty(widgetObj.type) ? widgetObj.type:''"/>                                          
                                </div>
                            </div>
                        </div>    
                        
                        <div v-if="widgetObj.graphCriteria?.chartType !== 'column' && !addWidget" class="averageTxt">
                        <div v-if="widgetObj.type === 'lead-time-graph' && chartData.average !== 'NaN' ">
                        <div class="DF AlignBase">
                        	<h2 class="fs-34">{{chartData.average}} </h2>
                            <span style="margin-left: 5px">Days</span>
                        </div>
                        </div>
                        </div>
                        
                    </div>
                   
                      <div class="scndheader leadtime DFCB">
                      <div class="DFA">
                      	<div class="selectcont cardHeaderSelect mr-10">
                             <vz-select 
                             v-model="filteredSelectedTeams"
                             :options="filterTeams"        
                             :multiple="true"  
                             empty-selection-text="Select Team" 
                             :selected-title="selectedTeamMessage(filteredSelectedTeams)" 
                             label="title" 
                             track-by="title" 
                             value-type="value" 
                             @select="onSelectAddtionalFilter"
                             @open="filterDataPopulate"
                              />   
                        </div>
                        <div class="selectcont cardHeaderSelect mr-10">
                             <vz-select 
                             v-model="filteredSelectedIssueTypes"
                             :options="filterIssueTypes"        
                             :multiple="true"  
                             empty-selection-text="Select Issue Type" 
                             :selected-title="selectedIssueTypeMessage(filteredSelectedIssueTypes)" 
                             label="title" 
                             track-by="title" 
                             value-type="value" 
                             @select="onSelectAddtionalFilter"
                             @open="filterDataPopulate"
                              />   
                        </div>
                        <div class="selectcont cardHeaderSelect mr-10">
                             <vz-select 
                             v-model="filteredSelectedSprints"
                             :options="filterSprints"        
                             :multiple="true"  
                             empty-selection-text="Select Sprints" 
                             :selected-title="selectedSprintMessage(filteredSelectedSprints)" 
                             label="title" 
                             track-by="title" 
                             value-type="value" 
                             @select="onSelectAddtionalFilter"
                             @open="filterDataPopulate"
                              />   
                        </div>                                       
                        <div class="selectcont cardHeaderSelect rhtsd">
                             <vz-select 
                             v-model="filteredSelectedCardTypes"
                             :options="filterCardTypes"        
                             :multiple="true"  
                             empty-selection-text="Select Card Type" 
                             :selected-title="selectedCardTypeMessage(filteredSelectedCardTypes)" 
                             label="title" 
                             track-by="title" 
                             value-type="value" 
                             @select="onSelectAddtionalFilter"
                             @open="filterDataPopulate"
                              />   
                        </div>
                      </div>
                      </div>
                    </div>
                    
    				<div v-if="errorCase" class="h-full DFA JC">
                       <div>
                           <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                           <p class="txt-cntr">Criteria not fulfilled. Try with different selection criteria. </p>
                           <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                       </div>
                   	</div>
                   	<div v-if="errorCaseNoData==true && errorCase==false" class="h-full DFA JC">
                        <div>
                            <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                            <p class="txt-cntr">No Data Available, As per selected Criteria.</p>
                            <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                        </div>
                     </div>      
                                                 
                   <chart1 class="chart" v-if="chartData.show && errorCase === false" :options="chartData.options"></chart1>
                   <div v-if = "addWidget" >
                        <button  type="button" class="button rds4 FR" @click="openLeadTimeCriteria" >Select Criteria</button> 
                   </div>
                   <div class="cardFooter" ref="footer"> 
                       <div class="DFA gap-1">
                            <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                                <img src="assets/icons/last-update.svg" alt="" />  
                                <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                            </span>
                            <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                                <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: chartData.isSyncing }" class="refreshIcon">
                                <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt=".." class="checkIcon">
                                <div class="hovtooltip ftsb wht-nwrp refreshIconTip">
                                    Refresh
                               </div>
                            </div>
                            <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                                <img  src="assets/icons/setting3.svg" alt="" />  
                                <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                                   <ul v-if="settingsLoading" class="drop_box"   style="display: block;cursor: pointer">
                                        <li  class="loader">
                                              <div>
                                                <div class="loaderinteg"/>
                                              </div>
                                        </li>             
                                    </ul> 
                                    <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                        <li class="boxItem"   @click="openLeadTimeEditCriteria()"> 
                                            <img src="/assets/icons/Dashboard/edit-gray.svg" alt=".." class=""> Edit 
                                        </li>	
                                        <li class="boxItem" @click="handleDuplicateWidget()">  
                                            <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt=".." class=""> Duplicate 
                                        </li>							
                                        <li class="boxItem" @click="handleRemoveWidget()">  
                                            <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class=""> Remove 
                                        </li>                          
                                    </ul>
                                </vuepopup>
                            </div>
                            <div class="settingsContainer c-point iconContainer" @click="handleRemoveWidget()" v-if="addWidget">
                                <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="">  
                            </div>          
                       </div>
                         <p v-if="!addWidget && errorCase === false" @click = "handleDetailList()" class="clickable-text">Detail List</p>   
                   </div>
				</div>
		     </div>    
        </div>
        <kendis-dashboard-selection-popup v-if="openSelectionPopup"  :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" :widgetType = "widgetObj.type" @close="handelCloseSelection" @populate-graph="onClickPopulateLeadTimeGraph"/>
		<kendis-graph-edit-popup v-if="openEditPopup" :selectedWidget="widgetObj" :dashboardSelected="dashboardSelectedId" @close="handleEditPopupClosure"  @updateWidget="onClickPopulateLeadTimeGraph"> </kendis-graph-edit-popup>
        <dashboard-list-items-popup v-if="isPopupOpen" @close="closeItemsPopup"  :data="popupData"/>	
    </div>			
    `,
    mixins:[rightsMixin],

    props: {widgetData: null, dashboardSelectedId: null,myRole:null},

    data() {
        return {
            filteredSelectedTeams: [],
            resultMapTeamSprint:{},
            allDataOfItems:[],
            dataOfItems:[],
            dumpDataOfItems:[],
            filterTeams: [],
            filterCardTypes: [],
            filteredSelectedSprints:[],
            filteredSelectedCardTypes:[],
            filteredSelectedIssueTypes:[],
            filterSprints:[],
            filterIssueTypes:[],
            settingsLoading:false,
            loading: false,
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            errorCaseNoData:false,
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            chartData: {
                show: false,
                options: new Object(),
                isSynced: false,
                timestampInfo: '',
                allGroupBys:[],
            },
            //chart criteria details
            graphCriteria: {
                type:"lead-time-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            groupBySelected: [],

            //Chart Object
            leadTimeGraph: {
                show: false,
                options: {
                    chart: {
                        type: 'column',
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            autoRotation: [-45, -90],
                            style: {
                                fontSize: '13px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        },
                        title: {
                            text: 'Number of Days'
                        }
                    },
                    yAxis: {
                        title: {
                            text: 'Number of Items'
                        },
                        type: 'logarithmic'
                    },
                    legend: {
                        enabled: false,
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    colors: [ "#E3554E", "#E3554E","#E64735","#D83E34","#C6352E","#B92F27","#AA241C","#FF949D","#F03F3D","#F11F15", "#D30A00","#E6357C",
                        "#E69F35","#DD527C","#D83E67","#C73A63","#B1365D","#9C3258","#752B4C","#FFA4C4","#F56193","#EB2B65", "#BE0E46","#D83EB4",
                        "#D8623E","#A251B2","#9238A4","#85349E","#732E95","#64298B","#47217A","#F3B8FF","#D379E4","#B436CD", "#6C079D","#5C38A4",
                        "#A43880","#7A5CB6","#6441A9","#5B3CA3","#4F349A","#452E91","#342381","#CFB9FF","#A180E8","#370CAC", "#4152A9","#4152A9",
                        "#606DB3","#4554A7","#3F4C9D","#364292","#2F3885","#23276F","#C0CCFF","#8D9FEF","#546EFB","#162BB2", "#4585A7","#6745A7",
                        "#5DA3E7","#4B94E3","#4587D5","#3E75C3","#3764B0","#2C4790","#9FD3FF","#7AC2FF","#339AFF","#2069D0","#4BE0E3","#4E4BE3"
                        ,"#57C3D5","#52B9CD","#4CA9BA","#4594A1","#408089","#355C5F","#ADF5FF","#72E3F4","#14DDFF","#00A5C0","#52CDA4","#527BCD"
                        ,"#4CA398","#409387","#3B867A","#36766A","#31665C","#294A41","#B0F4ED","#6EE1D4","#16CAB3","#097B66","#40935D","#407693",
                        "#94C06A","#82B552","#74A64A","#629240","#507E37","#315D25","#CBF6A1","#A3E465","#7BCE2C","#4B9F0F","#B3B552","#52B554",
                        "#FFD069","#FDC964","#FABD5E","#F6AC59","#F29E55","#EA8750","#FFE9B1","#FFDB81","#FFBA23","#FF8F12","#FD7E64","#E4FD64",
                        "#877068","#74574D","#684E46","#58423B","#493632","#392926","#E0D8CF","#C2AAA1","#9C6B5A","#703B2B","#744D57","#746A4D",
                        "#BDBDBD","#9E9E9E","#757575","#616161","#424242","#212121","#EDEDED","#D8D8D8","#959595","#434343","#9E9E9E",
                        "#7D8F99","#7D8F99","#596D77","#495961","#3B464C","#2A3135","#DAE5EB","#B4C9D4","#7397AB","#4A6675","#658883","#658883"], //
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            dataLabels: {
                                enabled: true,
                                formatter: function () {
                                    if (this.y !== 0) {
                                        return this.y;
                                    }
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            label: {
                                connectorAllowed: false
                            },
                        }
                    },
                    tooltip: {
                        useHTML: true,
                        backgroundColor: 'white',
                        borderWidth: 0,
                        borderRadius: 5,
                        formatter: function () {
                            return '' +
                                '<div class="garphsTooltipwraper">' +
                                '<div class="DFCB"><label>Items: </label> <div>' + this.point.y + '</div></div>' +
                                '</div>';
                        }
                    },
                    series: [{

                        colorByPoint: true,
                        groupPadding: 0,
                        data: [],
                        dataLabels: {
                            enabled: true,
                            inside: false, // Position data labels outside the bars
                            y: -10, // Adjust vertical position
                            style: {
                                color: 'black', // Change color for visibility
                                textOutline: '1px contrast(white)', // Add outline for contrast
                            },
                            formatter: function() {
                                return this.y !== 0 ? this.y : ''; // Show value only if not zero
                            }
                        },
                    }],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            },
            widgetObj:[],
            chartType:"",
            errorCase:false,
            itemtags:{},
            itemTagsMeta:{},
        }
    },

    components: {
        //add components here
        'kendis-dashboard-selection-popup': kendisDashboardSelectionPopup,
        "kendis-graph-edit-popup": kendisGraphEditPopup,
        'kendis-widget-criteria-details': kendisWidgetCriteraiDetails,
        'dashboard-list-items-popup': dashboardPopupComponent,
    },

    mounted() {
        //Create a new Widget if id is null
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            disableBodyScroll();
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.fetchLeadTimeWidgetData();
        }
    },

    created() {
    },

    computed: {
        selectedTeamMessage: function () {
            return function (selectedTeam) {
                let teamMessage = "Teams";
                if (selectedTeam) {
                    teamMessage = teamMessage + " (" + selectedTeam.length + ")";
                }
                return teamMessage;
            }
        },
        selectedSprintMessage : function(){
            return function(selectedSprint){
                let sprintMessage = "Sprints";
                if(selectedSprint){
                    sprintMessage = sprintMessage + " (" + selectedSprint.length + ")";
                }
                return sprintMessage;
            }
        },
        selectedCardTypeMessage : function(){
            return function(selectedCardType){
                let cardTypeMessage = "Card Type";
                if(selectedCardType){
                    cardTypeMessage = cardTypeMessage + " (" + selectedCardType.length + ")";
                }
                return cardTypeMessage;
            }
        },
        selectedIssueTypeMessage : function(){
            return function(selectedIssueType){
                let issueTypeMessage = "Issue Type";
                if(selectedIssueType){
                    issueTypeMessage = issueTypeMessage + " (" + selectedIssueType.length + ")";
                }
                return issueTypeMessage;
            }
        },
    },

    methods: {
        filterDataPopulate() {
            let teamIdsMap=this.widgetObj.graphCriteria.itemIdsMap;
            const resultMap = {
                itemIds: teamIdsMap.flatMap(group => group[1])
            };
            if(_.isEmpty(this.filterTeams) || _.isEmpty(this.filterSprints))
            {
                axios.post('/dashboard/fetch-all-item-details/', resultMap)
                    .then(response => {
                        let dataResult = response.data;

                        this.filterTeams=[];
                        this.filterTeams = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.teams && Object.keys(item.teams).length > 0
                                    ? item.teams
                                    : { "No Team": "No Team-color:#594a21" };
                            });
                        this.filterSprints=[];
                        this.filterSprints = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.sprints && Object.keys(item.sprints).length > 0
                                    ? item.sprints
                                    : { "No Sprint": "No Sprint" };
                            });
                        this.filterIssueTypes=[];
                        this.filterIssueTypes = response.data
                            .map(item => {
                                // Check if tfsItemType exists and is not empty
                                if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                    return item.tfsItemType;
                                }
                                // Otherwise, check if jiraFieldByKeyIssueType exists and has a name
                                if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                    return item.jiraFieldByKeyIssueType.name;
                                }
                                // Return undefined if neither condition is met
                                return "Kendis Only";
                            })
                            // Filter out any undefined values
                            .filter(Boolean);
                        this.filterCardTypes=[];
                        this.filterCardTypes = response.data.map(item => {
                            return item.cardType ? item.cardType : "No Card Type";
                        });
                        this.resultMapTeamSprint={};
                        this.dataOfItems=dataResult.forEach(item => {
                            const itemId = item.itemId;
                            const cardTypes = [item.cardType ? item.cardType : "No Card Type"];

                            // Extract team names (before "-")
                            const teamNames = Object.values(item.teams || {}).map(t => t.split("-")[0]);

                            // Extract sprints
                            const sprintNames = Object.values(item.sprints || {});

                            const issueTypes = [
                                (item.tfsItemType && item.tfsItemType.trim() !== "")
                                    ? item.tfsItemType
                                    : (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name)
                                        ? item.jiraFieldByKeyIssueType.name
                                        : "Kendis Only"
                            ];

                            this.resultMapTeamSprint[itemId] = {
                                teams: teamNames,
                                sprints: sprintNames,
                                issueTypes: issueTypes,
                                cardTypes: cardTypes,
                            };
                        });

                        this.filterTeamsForDropDown();
                        this.filterSprintsForDropDown();
                        this.filterIssueTypeForDropDown();
                        this.filterCardTypeForDropDown();
                    })
                    .catch(error => {
                        console.error(error);
                    });
            }

            },
        onSelectAddtionalFilter() {
            let filterTeam=this.filteredSelectedTeams
            this.initializeLeadTimeGraphData(this.widgetObj);
        },
        //Edit Popup Closure:
        handleEditPopupClosure(){
            enableBodyScroll();
            this.openEditPopup = false;
        },
        closeItemsPopup(){
            enableBodyScroll();
            this.isPopupOpen = false;
        },
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //Widget related functions
        handelCloseSelection:function(){
            this.openSelectionPopup = false;
            enableBodyScroll();
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        selectedGroupByMessage: function () {
            let selectedGrouping = this.chartData.allGroupBys?.map(groupBy => groupBy.id) || [];
            let title = "";
            if (!_.isEmpty(selectedGrouping) && !_.isEmpty(this.graphCriteria.selectedGroupBy)) {
                if (this.graphCriteria.selectedGroupBy.length >= 10) {
                    title = this.graphCriteria.selectedGroupBy.slice(0, 15) + "..." + " (" + selectedGrouping.length + ")";
                } else {
                    title = this.graphCriteria.selectedGroupBy + "s" + " (" + selectedGrouping.length + ")";
                }
            }
            return title;
        },

        fetchLeadTimeWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                this.initializeLeadTimeGraphData(this.widgetObj);
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading single Lead Time", e);
                this.loading = false;
            });
        },

        //methods for Cycle Time processing

        openLeadTimeCriteria: function () {
            disableBodyScroll();
            this.openSelectionPopup = true;
        },

        openLeadTimeEditCriteria: function () {
            disableBodyScroll();
            this.openEditPopup = true;
        },

        onClickPopulateLeadTimeGraph: function (requestBody) {
            this.filterTeams=[];
            this.filterSprints=[];
            this.loading = true;
            enableBodyScroll();
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let reqBody = {};
            if (requestBody.xAxis === 'weekly' || requestBody.xAxis == 'sprints' || requestBody.xAxis == 'monthly') {
                this.selectedInterval = requestBody.xAxis;
            } else {
                this.selectedInterval = requestBody.selectedInterval;
            }
            reqBody = {
                sessionBoardId: requestBody.sessionBoardId,
                startStatus: requestBody.statusListing.startOfSelectedStatus,
                endStatus: requestBody.statusListing.endOfSelectedStatus,
                tenant: requestBody.tenant,
                interval: requestBody.selectedInterval,
                issueType: requestBody.selectedIssueType,
                radioTypeSelection: requestBody.radioButtonSelection,
                boardItemsFilter : requestBody.boardItemsFilter,
                itemtags : requestBody.itemtags,
            };
            this.itemtags = requestBody.itemtags;
            this.itemTagsMeta = requestBody.itemTagsMeta;
            this.boardId = requestBody.selectedBoard._id;
            this.boardTenant = requestBody.tenant;
            this.graphTypeTitle = requestBody.graphTypeTitle;
            this.optionTypeTitle = requestBody.optionTypeTitle;
            this.sessionBoardId = requestBody.sessionBoardId;
            this.selectedBoard = requestBody.selectedBoard;
            this.selectedGraph = requestBody.selectedGraph;
            this.graphName = requestBody.graphName;
            this.selectedFilterType = requestBody.selectedFilterType;
            this.statusListing = requestBody.statusListing;
            this.selectedCondition = requestBody.statusIds;
            this.selectedInterval = requestBody.selectedInterval;
            this.radioButtonSelection = requestBody.radioButtonSelection;
            this.selectedIssueType = requestBody.selectedIssueType;
            this.issueTypeTitleList = requestBody.selectedIssueTypeTitleList;
            this.boardItemsFilter = requestBody.boardItemsFilter;
            this.selectedBoardTitle = requestBody.selectedBoardTitle;
            this.selectedToStatus = requestBody.selectedToStatus;
            this.selectedFromStatus = requestBody.selectedFromStatus;
            reqBody.widgetType = requestBody.optionTypeTitle;
            let _this = this;
            axios.post('/dashboard/create-timeseries-data', reqBody)
                .then(response => {
                    if (!response.data) {
                        throw new Error('Response data is empty');
                    }
                    let widgetData;
                    widgetData = _this.makeGraphObjectForLeadTimeDBStorage(response.data);
                    if (!_.isEmpty(widgetData)) {
                        return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData);
                    } else {
                        throw new Error('Processed widget data is empty');
                    }
                })
                .then(response => {
                    let updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    this.initializeLeadTimeGraphData(updatedWidget);
                    this.loading = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    _this.loading = false;
                });
        },

        makeGraphObjectForLeadTimeDBStorage: function (response) {
            let widgetData = {};
            if (response !== null) {
                let graphDataMap = response.intervals;
                let itemDaysMap = response.itemDaysMap;
                let itemDatesMap = response.itemDatesMap;
                let itemIdsMap = response.itemIdsMap;
                let itemStatusMap = response.itemStatusMap;
                const transformeditemIdsMapData = Object.entries(itemIdsMap || {}).map(([key, value]) => [key, value]);
                let categories = [];
                const transformedData = Object.entries(graphDataMap).map(([key, value]) => [key, value]);
                let widgetData = {};
                let selectedItems = [];
                if (!_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus) && (this.radioButtonSelection == 'status' || this.radioButtonSelection == 'statusCategory')) {
                    selectedItems.push(this.statusListing.startOfSelectedStatus);
                    selectedItems.push(this.statusListing.endOfSelectedStatus);
                }
                else if(!_.isEmpty(this.statusListing.endOfSelectedStatus) && this.radioButtonSelection == 'creationDate') {
                    selectedItems.push(this.statusListing.endOfSelectedStatus);
                }

                let dataOfGraph = {
                    "graphType": this.selectedGraph,
                    "selectedItems": _.isEmpty(selectedItems)?this.widgetObj.graphCriteria.selectedItems:selectedItems,
                    "boardId": this.boardId,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.selectedInterval,
                    "radioButtonSelection": this.radioButtonSelection,
                    "selectedIssueType": this.selectedIssueType,
                    "chartType": "column",
                    "boardItemsFilter": this.boardItemsFilter,
                    "fromStatusTitle": this.selectedToStatus,
                    "toStatusTitle": this.selectedFromStatus,
                    "issueTypeTitle": this.issueTypeTitleList,
                    "boardTitle": this.selectedBoardTitle,
                    "itemDaysMap": itemDaysMap,
                    "itemIdsMap": transformeditemIdsMapData,
                    "itemsGroupMap": itemDatesMap,
                    "itemTags":this.itemtags,
                    "itemTagsMetaMap" : this.itemTagsMeta,
                    "itemStatusMap":itemStatusMap,
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataOfGraph,
                    graphAdditionalCriteria: transformedData,
                    id: this.widgetData.id,
                    state:'old',
                }

                return widgetData;
            }
        },

        //Chart Population Functions
        initializeLeadTimeGraph: function () {
            let _this = this;
            this.leadTimeGraph = {
                show: false,
                options: {
                    chart: {
                        type: 'column',
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            autoRotation: [-45, -90],
                            style: {
                                fontSize: '13px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: 'Number of Items'
                        },
                        type: 'logarithmic'
                    },
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    tooltip: {
                        pointFormat: 'Items: <b>{point.y:.1f} items</b>'
                    },
                    colors: [ "#E3554E", "#E3554E","#E64735","#D83E34","#C6352E","#B92F27","#AA241C","#FF949D","#F03F3D","#F11F15", "#D30A00","#E6357C",
                        "#E69F35","#DD527C","#D83E67","#C73A63","#B1365D","#9C3258","#752B4C","#FFA4C4","#F56193","#EB2B65", "#BE0E46","#D83EB4",
                        "#D8623E","#A251B2","#9238A4","#85349E","#732E95","#64298B","#47217A","#F3B8FF","#D379E4","#B436CD", "#6C079D","#5C38A4",
                        "#A43880","#7A5CB6","#6441A9","#5B3CA3","#4F349A","#452E91","#342381","#CFB9FF","#A180E8","#370CAC", "#4152A9","#4152A9",
                        "#606DB3","#4554A7","#3F4C9D","#364292","#2F3885","#23276F","#C0CCFF","#8D9FEF","#546EFB","#162BB2", "#4585A7","#6745A7",
                        "#5DA3E7","#4B94E3","#4587D5","#3E75C3","#3764B0","#2C4790","#9FD3FF","#7AC2FF","#339AFF","#2069D0","#4BE0E3","#4E4BE3"
                        ,"#57C3D5","#52B9CD","#4CA9BA","#4594A1","#408089","#355C5F","#ADF5FF","#72E3F4","#14DDFF","#00A5C0","#52CDA4","#527BCD"
                        ,"#4CA398","#409387","#3B867A","#36766A","#31665C","#294A41","#B0F4ED","#6EE1D4","#16CAB3","#097B66","#40935D","#407693",
                        "#94C06A","#82B552","#74A64A","#629240","#507E37","#315D25","#CBF6A1","#A3E465","#7BCE2C","#4B9F0F","#B3B552","#52B554",
                        "#FFD069","#FDC964","#FABD5E","#F6AC59","#F29E55","#EA8750","#FFE9B1","#FFDB81","#FFBA23","#FF8F12","#FD7E64","#E4FD64",
                        "#877068","#74574D","#684E46","#58423B","#493632","#392926","#E0D8CF","#C2AAA1","#9C6B5A","#703B2B","#744D57","#746A4D",
                        "#BDBDBD","#9E9E9E","#757575","#616161","#424242","#212121","#EDEDED","#D8D8D8","#959595","#434343","#9E9E9E",
                        "#7D8F99","#7D8F99","#596D77","#495961","#3B464C","#2A3135","#DAE5EB","#B4C9D4","#7397AB","#4A6675","#658883","#658883"], //
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            dataLabels: {
                                enabled: true,
                                formatter: function () {
                                    if (this.y !== 0) {
                                        return this.y;
                                    }
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            label: {
                                connectorAllowed: false
                            },
                            point: {
                                events: {
                                    click: function () {
                                        const chart = this.series.chart;
                                        const allLegendsVisible = chart.series.every(series => series.visible);
                                        const xAxisIndex = this.name;
                                        let itemIds = [];
                                        if (this.series.options.chartType != 'column') {
                                            if (allLegendsVisible) {
                                                itemIds = chart.series
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            } else {
                                                itemIds = chart.series
                                                    .filter(series => series.visible)
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            }
                                        } else {
                                            itemIds = this.series.options.itemIds[xAxisIndex];
                                        }
                                        _this.onClickDataPoints(itemIds, this.series.options.graphName, this.series.options.fromStatusTitle, this.series.options.toStatusTitle, this.series.options.graphType,this.series.name);
                                    }
                                }
                            }

                        }
                    },
                    series: [{
                        name: 'Number of Days',
                        colorByPoint: true,
                        groupPadding: 0,
                        data: [],
                        dataLabels: {
                            enabled: true,
                            inside: false, // Position data labels outside the bars
                            y: -10, // Adjust vertical position
                            style: {
                                color: 'black', // Change color for visibility
                                textOutline: '1px contrast(white)', // Add outline for contrast
                            },
                            formatter: function() {
                                return this.y !== 0 ? this.y : ''; // Show value only if not zero
                            }
                        },
                    }],
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom',
                                    maxHeight: 55,
                                    navigation: {
                                        enabled: true // Enable legend navigation/pagination
                                    },
                                }
                            }
                        }]
                    },
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }
                }
            };
        },

        initializeLeadTimeGraphData: function (data) {
            if(_.isEmpty(data.graphAdditionalCriteria)){
                this.errorCase= true;
            } else{
                this.errorCase= false;
            }
            this.populateLeadTimeChart(data);
            let timestamp = '';
            if (data.updatedOn) {
                timestamp = data.updatedOn;
            } else {
                timestamp = data.createdOn;
            }
            let graphCriteria = {
                graphType: null,
                selectedBoardTitle: null,
                selectedIssueType: null,
                selectedGroupBy: null,
                selectedXAxis: null,
                selectedInterval: null,
                selectedToStatus: null,
                selectedFromStatus: null,
                sessionBoardId:null,
            };
            graphCriteria.sessionBoardId=data.graphCriteria.sessionBoardId;
            graphCriteria.chartType = data.graphCriteria.chartType;
            graphCriteria.selectedBoardTitle = data.graphCriteria.boardTitle;
            graphCriteria.selectedToStatus = data.graphCriteria.toStatusTitle;
            graphCriteria.selectedIssueType = data.graphCriteria.issueTypeTitle;
            if (data.graphCriteria.intervals == 'sprints' || data.graphCriteria.intervals == 'weekly' || data.graphCriteria.intervals == 'monthly') {
                graphCriteria.selectedXAxis = data.graphCriteria.intervals;
            } else {
                graphCriteria.selectedXAxis = "Days";
                graphCriteria.selectedInterval = data.graphCriteria.intervals;
            }            const dateData = new Date(timestamp);
            if (data.graphCriteria.graphType === '3') {
                processedGraph = {
                    options: Object.assign({}, this.leadTimeGraph.options),
                    show: true,
                    id: data.id,
                    timestampInfo: dateData.toLocaleString(),
                    name: data.name,
                    isSynced: false,
                    isSyncing: false,
                    columns: data.columns,
                    rows: data.rows,
                    posX: data.posX,
                    posY: data.posY,
                    loading:false,
                    graphCriteria: graphCriteria,
                    type: "lead-time-graph",
                    category : "Flow Time",
                    itemStatusMap : data.graphCriteria.itemStatusMap? data.graphCriteria.itemStatusMap : {},
                };
                this.$set(this.chartData, 'show', false);
                this.$set(this,'chartData', processedGraph);
                this.$set(this, 'graphCriteria', graphCriteria);
                this.$set(this, 'addWidget', false);
                this.$set(this, 'loading', false);
                let _this = this;
                this.$nextTick(() => {
                    _this.setGraphHeight();
                    _this.chartData.show = true;
                });
            }
        },

        populateLeadTimeChart: function (widget) {
            this.initializeLeadTimeGraph();
            let graphOptions = _.cloneDeep(this.leadTimeGraph.options);
            this.errorCaseNoData=false;
                if (_.isEmpty(widget.graphAdditionalCriteria)) {
                    let dummyData = [];
                    for (let i = 0; i < widget.graphAdditionalCriteria.length; i++) {
                        const pair = widget.graphAdditionalCriteria[i];
                        const interval = pair[0];
                        graphOptions.series[0].data.push([pair[0], pair[1]]);

                        const itemIds = widget.graphCriteria.itemIdsMap.find(([key]) => key.includes(`{${interval}=`));

                        if (itemIds) {
                            graphOptions.series[0].itemIds[interval] = itemIds[1]; // Item IDs for that interval
                        }
                    }
                } else {
                    graphOptions.series[0].data = widget.graphAdditionalCriteria.map(pair => [pair[0], pair[1]]);
                    graphOptions.series[0].itemIds = {};
                    widget.graphAdditionalCriteria.forEach(pair => {
                        const interval = pair[0];
                        const itemIds = widget.graphCriteria.itemIdsMap.find(([key]) => key.includes(`{${interval}=`));
                        if (itemIds) {
                            graphOptions.series[0].itemIds[interval] = itemIds[1];
                        } else {
                            graphOptions.series[0].itemIds[interval] = [];
                        }
                        graphOptions.series[0].graphName = widget.name;
                        graphOptions.series[0].graphType = widget.graphCriteria.optionTypeTitle;
                        graphOptions.series[0].chartType = widget.graphCriteria.chartType;
                        graphOptions.series[0].fromStatusTitle = widget.graphCriteria.fromStatusTitle;
                        graphOptions.series[0].toStatusTitle = widget.graphCriteria.toStatusTitle;
                    });
                    if(this.filteredSelectedTeams!=undefined || this.filteredSelectedSprints!=undefined ||this.filteredSelectedTeams.length!=0 ||  this.filteredSelectedSprints.length!=0 || this.filteredSelectedIssueTypes!=undefined || this.filteredSelectedIssueTypes.length!=0 || this.filteredSelectedCardTypes!=undefined || this.filteredSelectedCardTypes.length!=0){
                     if(this.filteredSelectedTeams==undefined ||  this.filteredSelectedSprints==undefined || this.filteredSelectedIssueTypes==undefined || this.filteredSelectedCardTypes==undefined){
                            graphOptions.series[0].data = Object.entries(graphOptions.series[0].itemIds).map(([range, items]) => {
                                return [range, 0];
                            });
                        }
                        else if(this.filterTeams.length>this.filteredSelectedTeams.length || this.filterSprints.length>this.filteredSelectedSprints.length || this.filterIssueTypes.length>this.filteredSelectedIssueTypes.length || this.filterCardTypes.length>this.filteredSelectedCardTypes.length ){
                            const filteredTeams = new Set(this.filteredSelectedTeams);
                            const filteredSprints = new Set(this.filteredSelectedSprints);
                            const filteredIssueTypes = new Set(this.filteredSelectedIssueTypes);
                            const filteredCardTypes = new Set(this.filteredSelectedCardTypes);

                            for (const range in graphOptions.series[0].itemIds) {
                                const items = graphOptions.series[0].itemIds[range];

                                graphOptions.series[0].itemIds[range] = items.filter(itemId => {
                                    const teamInfo = this.resultMapTeamSprint[itemId];
                                    if (!teamInfo) return false;

                                    const teams = teamInfo.teams;
                                    const sprints = teamInfo.sprints;
                                    const issueTypes = teamInfo.issueTypes;
                                    const cardTypes = teamInfo.cardTypes;

                                    // Check team match
                                    const hasTeamMatch = (
                                        (teams.length === 0 && filteredTeams.has("No Team")) ||
                                        teams.some(team => filteredTeams.has(team))
                                    );

                                    // Check sprint match
                                    const hasSprintMatch = (
                                        (sprints.length === 0 && filteredSprints.has("No Sprint")) ||
                                        sprints.some(sprint => filteredSprints.has(sprint))
                                    );

                                    const hasIssueTypeMatch = (
                                        (issueTypes.length === 0) ||
                                        issueTypes.some(sprint => filteredIssueTypes.has(sprint))
                                    );
                                    const hasCardTypeMatch = (
                                        (cardTypes.length === 0) ||
                                        cardTypes.some(sprint => filteredCardTypes.has(sprint))
                                    );

                                    // Keep item only if both team and sprint conditions match
                                    return hasTeamMatch && hasSprintMatch && hasIssueTypeMatch && hasCardTypeMatch;
                                });
                            }
                            graphOptions.series[0].data = Object.entries(graphOptions.series[0].itemIds).map(([range, items]) => {
                                return [range, items.length];
                            });
                        }
                    }

                }
            this.leadTimeGraph.options = graphOptions;
        },

        //Widget Removal & Duplicate
        handleRemoveWidget: function () {
			
			this.widgetObj.posX = this.widgetData.posX;
			this.widgetObj.posY = this.widgetData.posY;
			this.widgetObj.columns = this.widgetData.columns;
			this.widgetObj.rows = this.widgetData.rows;
			
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleDuplicateWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },


        //Syncing of Cycle Time Graph
        handleSyncWidget: function (widgetSelected) {
            const data = {
                dashboardId: this.dashboardSelectedId,
                widgetId: this.widgetObj.id
            };
            this.loading = true;
            widgetSelected = this.widgetObj;
            axios.post("/dashboard/syncDashboardWidgetCFD", data)
                .then(response => {
                    if (response.data) {
                        this.boardId = widgetSelected.graphCriteria.boardId;
                        this.sessionBoardId = widgetSelected.graphCriteria.sessionBoardId;
                        this.graphTypeTitle = widgetSelected.graphCriteria.graphTypeTitle;
                        this.optionTypeTitle = widgetSelected.graphCriteria.optionTypeTitle;
                        this.boardTenant = widgetSelected.graphCriteria.selectedBoardTenant;
                        this.xAxis = widgetSelected.graphCriteria.intervals;
                        this.radioButtonSelection = widgetSelected.graphCriteria.radioButtonSelection;
                        this.selectedIssueType = widgetSelected.graphCriteria.selectedIssueType;
                        this.selectedBoardTitle = widgetSelected.graphCriteria.boardTitle;
                        this.issueTypeTitleList = widgetSelected.graphCriteria.issueTypeTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.startDate = widgetSelected.graphCriteria.startDate;
                        this.endDate = widgetSelected.graphCriteria.endDate;
                        this.selectedActiveStatus = widgetSelected.graphCriteria.selectedActiveStatus;
                        this.selectedWaitingStatus = widgetSelected.graphCriteria.selectedInProgressStatus;
                        this.selectedCompletedStatus = widgetSelected.graphCriteria.selectedCompletedStatus;
                        this.boardItemsFilter = widgetSelected.graphCriteria.boardItemsFilter;
                        this.widgetId = widgetSelected.id;
                        this.graphName = widgetSelected.name;
                        this.selectedCondition = widgetSelected.graphCriteria.selectedItems;
                        this.selectedToStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.toStatusTitle;
                        this.itemtags = widgetSelected.graphCriteria.itemTags;
                        this.itemTagsMeta = widgetSelected.graphCriteria.itemTagsMetaMap;

                        const widgetData = this.makeGraphObjectForLeadTimeDBStorage(response.data);

                        if (!_.isEmpty(widgetData)) {
                            return axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData);
                        } else {
                            throw new Error('Processed widget data is empty');
                        }
                    } else {
                        throw new Error('Response data is empty');
                    }
                })
                .then(response => {
                    const updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    this.initializeLeadTimeGraphData(updatedWidget);
                    this.loading = false;
                    this.chartData.isSyncing = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },
		
        updateFlowTimeHistogramGraphData: function (response) {
            let graphDataMap = response.intervals;
            let categories = [];
            const transformedData = Object.entries(graphDataMap).map(([key, value]) => [key, value]);
            let widgetData = {};
            let selectedItems = [];
            selectedItems.push(this.statusListing.startOfSelectedStatus);
            selectedItems.push(this.statusListing.endOfSelectedStatus);
            let selectedGraphIndex = this.processedGraphData.findIndex(graph => graph.id === this.widgetId);
            let mockupWidget = {
                id: this.widgetId,
                loading: true,
                type: "temp",
                posX: this.processedGraphData[selectedGraphIndex].posX,
                posY: this.processedGraphData[selectedGraphIndex].posY,
                columns: this.processedGraphData[selectedGraphIndex].columns,
                rows: this.processedGraphData[selectedGraphIndex].rows,
            };

            this.updateGraphDataForSync(selectedGraphIndex,mockupWidget);
            if (response) {
                let dataofGraph = {
                    "graphType": this.selectedGraph,
                    "selectedItems": selectedItems,
                    "boardId": this.selectedBoard,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.selectedInterval,
                    "radioButtonSelection": this.radioButtonSelection
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataofGraph,
                    graphAdditionalCriteria: transformedData,
                    type: this.selectedFilterType,
                    id: this.widgetId,
                }
                axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData).then(response => {
                    this.isGraphEdit = false;
                    let updatedWidget = response.data.widget;
                    if (!_.isEmpty(this.widgets) ) {
                        if( this.widgets[0] !== null){
                            const index = this.widgets.findIndex(item => updatedWidget.id === item.id);
                            if (index !== -1) {
                                this.widgets.splice(index, 1, updatedWidget);
                            }
                        }
                        else{
                            this.widgets = [];
                            this.widgets.push(updatedWidget);
                        }
                    } else {
                        this.widgets = [];
                        this.widgets.push(updatedWidget);
                    }
                    this.$store.widgets = this.widgets;
                    this.initializeTimeFlowGrpah();
                    this.initializeFlowTimeLineGraph();
                    const indexOfGraph = this.processedGraphData.findIndex(item => updatedWidget.id === item.id);
                    let timestamp = null;
                    if (updatedWidget.updatedOn) {
                        timestamp = updatedWidget.updatedOn;
                    } else {
                        timestamp = updatedWidget.createdOn;
                    }
                    const dateData = new Date(timestamp);
                    if (updatedWidget.graphCriteria.optionTypeTitle === 'Time in Status' || updatedWidget.graphCriteria.optionTypeTitle === 'Lead Time Graph') {
                        let graphOptions = _.cloneDeep(this.timeFlowGraph.options);
                        if (!_.isEmpty(updatedWidget.graphAdditionalCriteria)) {
                            graphOptions.series[0].data = updatedWidget.graphAdditionalCriteria.map(pair => [pair[0], pair[1]]);
                        } else {
                            let dummyData = [];
                            for (let i = 0; i < updatedWidget.graphCriteria.intervals; i++) {
                                const calculatedValue = i * updatedWidget.graphCriteria.intervals;
                                const stringValue = calculatedValue.toString();
                                dummyData.push([stringValue, 0]);
                            }
                            graphOptions.series[0].data = dummyData;
                        }

                        this.timeFlowGraph.options = graphOptions;
                        let graphCriteria ={
                            chartType : updatedWidget.graphCriteria.chartType,
                        }
                        let processedGraph = {
                            options: Object.assign({}, this.timeFlowGraph.options),
                            show: true,
                            id: updatedWidget.id,
                            timestampInfo: dateData.toLocaleString(),
                            name: updatedWidget.name,
                            isSynced: true,
                            isSyncing: false,
                            loading: false,
                            columns: updatedWidget.columns,
                            rows: updatedWidget.rows,
                            posX: updatedWidget.posX,
                            posY: updatedWidget.posY,
                            type: "flow-time-graph",
                            graphCriteria: graphCriteria,
                        };
                        this.updateGraphData(selectedGraphIndex,processedGraph);
                        setTimeout(() => {
                            processedGraph.isSynced = false;
                            this.$set(this.processedGraphData, selectedGraphIndex, processedGraph);
                        }, 3000);
                    } else if (updatedWidget.graphCriteria.optionTypeTitle === 'Flow Time Graph') {
                        this.initializeFlowTimeLineGraph();
                        let dummyData = [];
                        let graphOptions = _.cloneDeep(this.flowTimeLineGraph.options);
                        graphOptions.xAxis.categories = updatedWidget.graphCriteria.categories;
                        if (!_.isEmpty(updatedWidget.graphAdditionalCriteria)) {
                            let index = 0;
                            let dummyMap = new Map();
                            let teamMap = new Map();
                            for (const pair of updatedWidget.graphAdditionalCriteria) {
                                dummyData = [];
                                const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                                if (!teamMap.has(pairValue)) {
                                    teamMap.set(pairValue, Array(updatedWidget.graphCriteria.categories.length).fill(0));
                                }
                            }
                            for (const pair of updatedWidget.graphAdditionalCriteria) {
                                dummyData = [];
                                const iteration = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                                const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                                const teamData = teamMap.get(team);
                                const iterationIndex = updatedWidget.graphCriteria.categories.indexOf(iteration);
                                teamData[iterationIndex] += pair[1];
                                teamMap.set(team, teamData);
                            }
                            for (const [key, value] of teamMap) {
                                graphOptions.series[index] = {
                                    name: key,
                                    data: value
                                };
                                index++;
                            }
                        } else {

                        }
                        let average = this.calculateAverageOfDataPoints(updatedWidget.graphAdditionalCriteria);
                        graphOptions.yAxis.plotLines = [{
                            value: average,
                            color: '#59D',
                            dashStyle: 'shortDash',
                            width: 2
                        }];
                        let allGroupBys = [];
                        if (!_.isEmpty(updatedWidget.allGroupBys)) {
                            allGroupBys = updatedWidget.allGroupBys;
                        }
                        const keys = Object.keys(allGroupBys);
                        const transformedallGroupBys = keys.map(key => ({
                            id: key,
                            title: allGroupBys[key]
                        }));
                        let graphCriteria = {
                            graphType: null,
                            selectedBoardTitle: null,
                            selectedIssueType: null,
                            selectedGroupBy: null,
                            selectedXAxis: null,
                            selectedInterval: null,
                            selectedToStatus: null,
                            selectedFromStatus: null,
                        };
                        graphCriteria.graphType = updatedWidget.graphCriteria.graphType;
                        graphCriteria.selectedBoardTitle = updatedWidget.graphCriteria.boardTitle;
                        graphCriteria.selectedIssueType = updatedWidget.graphCriteria.issueTypeTitle;
                        graphCriteria.selectedGroupBy =  updatedWidget.graphCriteria.groupByTitle?updatedWidget.graphCriteria.groupByTitle:updatedWidget.graphCriteria.groupBy;

                        if (updatedWidget.graphCriteria.intervals == 'sprints' || updatedWidget.graphCriteria.intervals == 'weekly' || updatedWidget.graphCriteria.intervals == 'monthly') {
                            graphCriteria.selectedXAxis = updatedWidget.graphCriteria.intervals;
                        } else {
                            graphCriteria.selectedXAxis = "Days";
                            graphCriteria.selectedInterval = updatedWidget.graphCriteria.intervals;
                        }
                        graphCriteria.selectedToStatus = updatedWidget.graphCriteria.toStatusTitle;
                        graphCriteria.selectedFromStatus = updatedWidget.graphCriteria.fromStatusTitle;

                        let processedGraph = {
                            options: Object.assign({}, graphOptions),
                            show: true,
                            id: updatedWidget.id,
                            timestampInfo: dateData.toLocaleString(),
                            name: updatedWidget.name,
                            isSynced: true,
                            isSyncing: false,
                            type: "flow-time-line-graph",
                            category: "Flow Time",
                            average: average,
                            allGroupBys: transformedallGroupBys,
                            graphCriteria: graphCriteria,
                            columns: updatedWidget.columns,
                            rows: updatedWidget.rows,
                            posX: updatedWidget.posX,
                            posY: updatedWidget.posY,
                        };
                        this.processedGraphData.splice(indexOfGraph, 1, processedGraph);
                        setTimeout(() => {
                            processedGraph.isSynced = false;
                            this.processedGraphData.splice(index, 1, processedGraph);
                        }, 3000);
                    }
                    else if (updatedWidget.graphCriteria.optionTypeTitle === 'Flow Efficiency Graph') {
                        this.initializeFlowEfficiencyGraph();
                        let dummyData = [];
                        let graphOptions = _.cloneDeep(this.flowTimeLineGraph.options);
                        graphOptions.xAxis.categories = updatedWidget.graphCriteria.categories;
                        if (!_.isEmpty(updatedWidget.graphAdditionalCriteria)) {
                            let index = 0;
                            let dummyMap = new Map();
                            let teamMap = new Map();
                            for (const pair of updatedWidget.graphAdditionalCriteria) {
                                dummyData = [];
                                const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                                if (!teamMap.has(pairValue)) {
                                    teamMap.set(pairValue, Array(updatedWidget.graphCriteria.categories.length).fill(0));
                                }
                            }
                            for (const pair of updatedWidget.graphAdditionalCriteria) {
                                dummyData = [];
                                const iteration = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                                const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                                const teamData = teamMap.get(team);
                                const iterationIndex = updatedWidget.graphCriteria.categories.indexOf(iteration);
                                teamData[iterationIndex] += pair[1];
                                teamMap.set(team, teamData);
                            }
                            for (const [key, value] of teamMap) {
                                graphOptions.series[index] = {
                                    name: key,
                                    data: value
                                };
                                index++;
                            }
                        } else {

                        }
                        let average = this.calculateAverageOfDataPoints(updatedWidget.graphAdditionalCriteria);
                        graphOptions.yAxis.plotLines = [{
                            value: average,
                            color: '#59D',
                            dashStyle: 'shortDash',
                            width: 2
                        }];
                        let allGroupBys = [];
                        if (!_.isEmpty(data.allGroupBys)) {
                            allGroupBys = updatedWidget.allGroupBys;
                        }
                        const keys = Object.keys(allGroupBys);
                        const transformedallGroupBys = keys.map(key => ({
                            id: key,
                            title: allGroupBys[key]
                        }));
                        let graphCriteria = {
                            graphType: null,
                            selectedBoardTitle: null,
                            selectedIssueType: null,
                            selectedGroupBy: null,
                            selectedXAxis: null,
                            selectedInterval: null,
                            selectedToStatus: null,
                            selectedFromStatus: null,
                        };
                        graphCriteria.graphType = updatedWidget.graphCriteria.graphType;
                        graphCriteria.selectedBoardTitle = updatedWidget.graphCriteria.boardTitle;
                        graphCriteria.selectedIssueType = updatedWidget.graphCriteria.issueTypeTitle;
                        graphCriteria.selectedGroupBy = updatedWidget.graphCriteria.groupByTitle?updatedWidget.graphCriteria.groupByTitle:updatedWidget.graphCriteria.groupBy;
                        if (updatedWidget.graphCriteria.intervals == 'sprints' || updatedWidget.graphCriteria.intervals == 'weekly' || updatedWidget.graphCriteria.intervals == 'monthly') {
                            graphCriteria.selectedXAxis = updatedWidget.graphCriteria.intervals;
                        } else {
                            graphCriteria.selectedXAxis = "Days";
                            graphCriteria.selectedInterval = updatedWidget.graphCriteria.intervals;
                        }
                        graphCriteria.selectedToStatus = updatedWidget.graphCriteria.toStatusTitle;
                        graphCriteria.selectedFromStatus = updatedWidget.graphCriteria.fromStatusTitle;

                        let processedGraph = {
                            options: Object.assign({}, graphOptions),
                            show: true,
                            id: updatedWidget.id,
                            timestampInfo: dateData.toLocaleString(),
                            name: updatedWidget.name,
                            isSynced: false,
                            isSyncing: false,
                            type: "flow-efficiency-graph",
                            category: "Flow Efficiency",
                            average: average,
                            allGroupBys: transformedallGroupBys,
                            graphCriteria: graphCriteria,
                            posX: updatedWidget.posX,
                            posY: updatedWidget.posY,
                            columns: updatedWidget.columns,
                            rows: updatedWidget.rows,
                        };
                        this.updateGraphDataForSync(indexOfGraph, processedGraph);
                    }
                }).catch(e => {
                    this.errorCase = true;
                    console.error(e);
                })
            }

        },
        handleRerenderWidget: function () {
			let _this = this;
			
			this.setGraphHeight();
			Vue.set(_this.chartData, "show", false);
			Vue.nextTick(()=> {
				Vue.set(_this.chartData, "show", true);
			});
			
		},
		setGraphHeight: function () {
			let unitWidth = this.$el.offsetHeight;
			
			let headerHeight = this.$refs.header.offsetHeight;
			let footerHeight = this.$refs.footer.offsetHeight;
			let totalHeightInPixels = unitWidth;
			this.chartData.options.chart.height = totalHeightInPixels - headerHeight - footerHeight  - 100;
		},

        //Detail List
        handleDetailList: function (data) {
            let selectedGraph = this.widgetObj;
            let grouping = selectedGraph.graphCriteria.selectedGroupBy;
            let fromStatusTitle ="";
            let toStatusTitle = "";
            if(this.widgetObj.graphCriteria.radioButtonSelection === 'creationDate'){
                toStatusTitle = "Creation Date";
                fromStatusTitle = selectedGraph.graphCriteria.toStatusTitle;
            }
            else{
                fromStatusTitle = selectedGraph.graphCriteria.toStatusTitle;
                toStatusTitle = selectedGraph.graphCriteria.fromStatusTitle;
            }
            let itemStatusMap = this.chartData.itemStatusMap;
            let itemDaysMap = selectedGraph.graphCriteria.itemDaysMap;
            let itemDatesMAp = selectedGraph.graphCriteria.itemsGroupMap;
            let itemTeamsMap = {};
            let itemSprintsMap = {};
            let chartType = this.graphCriteria.chartType;
            this.loadItemsPopup(itemDaysMap, selectedGraph.name, this.chartData.average, this.widgetData.type, fromStatusTitle, toStatusTitle, itemDatesMAp, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap);
        },

        loadItemsPopup: function (itemDaysMap, graphName, average, graphType, from, to, itemsGroupMap, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = graphType;
            this.popupData.popupTitle = graphName;
            this.popupData.average = average;
            this.popupData.itemDaysMap = itemDaysMap;
            this.popupData.total = _.size(itemDaysMap);
            this.popupData.itemStatusMap = itemStatusMap;
            this.popupData.grouping = grouping;
            this.popupData.chartType = chartType;
            this.popupData.fromStatus = from;
            this.popupData.toStatus = to;
            this.popupData.itemDatesMap = itemsGroupMap;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            disableBodyScroll();
            this.isPopupOpen = true;
        },
        //Points Click Actions
        onClickDataPoints: function (itemIds, name, toStatus, fromStatus, type,nameOfGroupby) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = "lead-time-graph-detail-view"; //"flow-time-graph-detail";
            this.popupData.itemIds = itemIds;
            let itemIdSet = new Set(itemIds);  // Convert itemIds array to a Set

            let filteredItemDaysMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                Object.entries(this.widgetObj.graphCriteria.itemDaysMap).filter(([key]) => {
                    let itemId = key.slice(7, key.indexOf(":"));  // Extract itemId efficiently
                    return itemIdSet.has(itemId);
                })
            ) : {};

            let filteredItemDatesMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                Object.entries(this.widgetObj.graphCriteria.itemsGroupMap).filter(([key]) => {
                    let itemId = key.slice(7, key.indexOf(":"));  // Extract itemId efficiently
                    return itemIdSet.has(itemId);
                })
            ) : {};
            if( this.widgetObj.graphCriteria.radioButtonSelection === 'statusCategory' ){
                if(!_.isEmpty(this.widgetObj.graphCriteria.itemStatusMap)){
                    let filteredItemStatusMap = !_.isEmpty(itemIds) ? Object.fromEntries(
                        Object.entries(this.widgetObj.graphCriteria.itemStatusMap).filter(([key, value]) => {
                            return itemIds?.includes(key);
                        })
                    ):{};
                    this.popupData.itemStatusMap = filteredItemStatusMap;
                }
            }
            this.popupData.total = _.size(itemIds);
            this.popupData.popupTitle = name;
            this.popupData.itemDaysMap = filteredItemDaysMap;
            this.popupData.itemDatesMap = filteredItemDatesMap;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            this.popupData.chartType = this.widgetObj.graphCriteria.chartType;
            if(this.widgetObj.graphCriteria.radioButtonSelection === 'creationDate'){
                this.popupData.toStatus = "Creation Date";
                this.popupData.fromStatus = this.widgetObj.graphCriteria.toStatusTitle;
            }
            else{
                this.popupData.toStatus = this.widgetObj.graphCriteria.fromStatusTitle;
                this.popupData.fromStatus = this.widgetObj.graphCriteria.toStatusTitle;
            }
            disableBodyScroll();
            this.isPopupOpen = true;
        },
        filterTeamsForDropDown:function(){


            this.filterTeams = [...new Set(
                this.filterTeams
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
                    .map(value => value.split('-color')[0]) // Extract the part before "-color"
            )]
                .sort((a, b) => {
                    if (a === "No Team") return 1; // Always move "No Team" to the end
                    if (b === "No Team") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedTeams = this.filterTeams
                .filter(team => team.title !== undefined)
                .map(team => team.title);
        },
        filterSprintsForDropDown:function(){
            this.filterSprints = [...new Set(
                this.filterSprints
                    .flatMap(item => Object.values(item)) // Extract all values from the map
                    .filter(value => value !== undefined) // Exclude undefined values
            )]
                .sort((a, b) => {
                    if (a === "No Sprint") return 1; // Always move "No Sprint" to the end
                    if (b === "No Sprint") return -1;
                    return a.localeCompare(b); // Sort alphabetically for other items
                })
                .map((title, index) => ({ id: index + 1, title })); // Add IDs


            this.filteredSelectedSprints = this.filterSprints.map(sprint => sprint.title);
        },
        filterIssueTypeForDropDown:function(){
            this.filterIssueTypes = [...new Set(this.filterIssueTypes.filter(item => item !== undefined))]
                .map((item, index) => ({ id: index + 1, title: item }));
            this.filteredSelectedIssueTypes=this.filterIssueTypes.map(team => team.title);
        },
        filterCardTypeForDropDown:function(){
            this.filterCardTypes = [...new Set(this.filterCardTypes.filter(item => item !== undefined))]
                .map((item, index) => ({ id: index + 1, title: item }));
            this.filteredSelectedCardTypes=this.filterCardTypes.map(team => team.title);
        },

    },

})