const kendisWidgetGeneralPurpose = Vue.component('kendis-widget-general-purpose', {
    template: `
    <div style="height: 100%;" class="p-rel" >
            <div v-if="loading" class="loader">
                <div>
                    <div class="loaderinteg"/>
                </div>
            </div> 
            <div class="graphInnerContainer">
                
                <div class="cardHeader" >
                    <div class="tooltip c-deflt" v-if="widgetObj && widgetObj.name">
                        <h4 class="cardTitle elips" style="max-width: calc(100% - 50px);" ref="exportName">{{widgetObj.name}}</h4>
                    </div>
                    <div class="wdmenu" ref="menu" style="top: -14px;">
		                <em v-if="isMenuOpen" @click="toggleMenu" title="Close" class="rmv-ico ti-close rnd DAJ p-intial" style="width: 30px; height: 30px;"> </em>
		                <img v-else src="/assets/icons/new/menu1.svg" @click="toggleMenu" class="menu-icon" alt="Menu Icon" />
		                <transition name="fade">
		                    <ul v-if="isMenuSettingsOpen" class="export-options-box">
		                        <li v-if="!isFullScreen" @click="toggleFullscreen" class="export-btn">View Fullscreen</li>
		                        <li v-if="isFullScreen" @click="toggleFullscreen" class="export-btn">Exit Fullscreen</li>
		<!--                        <li @click="downloadElementAsImage('png')">Download as PNG</li>-->
		<!--                        <li @click="downloadElementAsImage('jpeg', 0.9)">Download as JPEG</li>-->
		                        <li @click="downloadAsWord" class="export-btn">Download Word</li>
		                    </ul>
		                </transition>
		            </div><!-- menu close -->
                </div>
                
                <div v-if="widgetObj && widgetObj.description" class=" desc-con pd-lr-20 edtrout ck-content" v-html="widgetObj.description" ref="exportDescription"></div>
	             
	             <div class="cardFooter"> 
                    <div class="DFA gap-1">
                      <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                          <img src="assets/icons/last-update.svg" alt="" />  
                          <span class="hovtooltip refreshTime">Last Updated At:{{ formattedUpdatedOn }} </span>
                      </span>
                      <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                          <img src="assets/icons/setting3.svg" alt="" />  
                          <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                              <ul v-if="settingsLoading" class="drop_box" style="display: block;cursor: pointer">
                                <li class="loader"><div><div class="loaderinteg"></div></div></li>             
                               </ul> 
                            <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                <li class="boxItem" @click="openEditCriteria()"> 
                                    <img src="/assets/icons/Dashboard/edit-gray.svg" alt=".." class="" /> Edit 
                                </li>	
                                <li class="boxItem" @click="handleDuplicateWidget()">  
                                    <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt=".." class="" /> Duplicate 
                                </li>							
                                <li class="boxItem" @click="handleRemoveWidget()">  
                                    <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="" /> Remove 
                                </li>                          
                            </ul>
                        </vuepopup>
                      </div>            
                    </div>
                </div> <!-- cardFooter close -->
            </div> <!-- graphInnerContainer close -->
            
        <kendis-widget-general-purpose-criteria 
            v-if="openSelectionPopup"  
            :isEdit="openEditPopup"
            :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" 
            :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" 
            :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" 
            :widgetType = "widgetObj.type" 
            @close="handelCloseSelection" 
            @edit-close="handleEditClose"
            @populate-graph="onClickPopulateGraph"
            :existingGraphName="widgetObj.name"
            :existingDescription="widgetObj.description"
            :widgetId="widgetObj.id"
        />
    </div>`,

    mixins: [rightsMixin],

    props: {widgetData: null, dashboardSelectedId: null, myRole: null},

    data(){
        return {
            isFullScreen: false,
            openSelectionPopup: false,
            loading: false,
            widgetObj: [],
            widgetId: "",
            addWidget: false,
            chartData: {
                isSynced: false,
                isSyncing: false
            },
            showGraphSettings: false,
            settingsLoading: false,
            openEditPopup: false,
            errorCase: false,
            isMenuOpen: false,
            isMenuSettingsOpen: false
        }
    },

    components: {
        'kendis-widget-general-purpose-criteria': kendisWidgetGeneralPurposeCriteria,
    },

    created() {
    },

    computed: {

        formattedUpdatedOn() {
            if (!this.widgetObj || !this.widgetObj.updatedOn) return '';
            const date = new Date(this.widgetObj.updatedOn);
            const options = {
                day: '2-digit',
                month: 'long',
                year: 'numeric',
                hour: 'numeric',
                minute: '2-digit',
                hour12: true
            };
            return date.toLocaleString('en-GB', options).replace(',', ' at');
        }
    },
    mounted() {
        document.addEventListener('click', this.handleClickOutside);
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            this.openSelectionPopup = true;
            disableBodyScroll();
        } else {
            this.fetchWidgetData();
        }
    },
    methods: {
        handleClickOutside(event) {
            if (!this.$el.contains(event.target) || !this.$refs.menu.contains(event.target)) {
                this.isMenuOpen = false;
                this.isMenuSettingsOpen = false;
            }
        },

        toggleMenu() {
            this.isMenuOpen = !this.isMenuOpen;
            this.isMenuSettingsOpen = !this.isMenuSettingsOpen;
        },

        toggleFullscreen() {
            if(this.isMenuOpen){
                this.isMenuSettingsOpen = !this.isMenuSettingsOpen;
                this.isMenuOpen = !this.isMenuOpen;
            }
            this.isFullScreen = !this.isFullScreen;
            const element = this.$el;
            if(this.isFullScreen) {
                if (element.requestFullscreen) {
                    element.requestFullscreen();
                } else if (element.msRequestFullscreen) {
                    element.msRequestFullscreen();
                } else if (element.mozRequestFullScreen) {
                    element.mozRequestFullScreen();
                } else if (element.webkitRequestFullscreen) {
                    element.webkitRequestFullscreen();
                }
            }else{
                if (document.exitFullscreen) {
                    document.exitFullscreen();
                } else if (document.webkitExitFullscreen) {
                    document.webkitExitFullscreen();
                } else if (document.mozCancelFullScreen) {
                    document.mozCancelFullScreen();
                } else if (document.msExitFullscreen) {
                    document.msExitFullscreen();
                }
            }
        },

        downloadAsWord() {
            const name = this.$refs.exportName.innerHTML;
            const description = this.$refs.exportDescription.innerHTML;
            const content = `<html>
                                        <head>
                                            <meta charset="utf-8">
                                        </head>
                                        <body>
                                            <h2>${name}</h2>
                                            <div>${description}</div>
                                        </body>
                                    </html>`;

            const converted = htmlDocx.asBlob(content);
            const link = document.createElement('a');
            link.href = URL.createObjectURL(converted);
            link.download = this.widgetObj.name + '.docx'; // Set the filename for Word doc
            link.click();
        },

        async downloadElementAsImage(format = 'png', quality = 1.0) {
            const element = this.$refs.exportContent;
            if (!element) {
                alert('Nothing to export! Export content not found.');
                return;
            }

            try {
                await Promise.all(
                    Array.from(element.querySelectorAll("img")).map(img => {
                        if (img.complete) return Promise.resolve();
                        return new Promise(resolve => {
                            img.onload = resolve;
                            img.onerror = resolve;
                        });
                    })
                );

                const originalStyles = [];
                element.querySelectorAll('*').forEach(el => {
                    originalStyles.push({ el, color: el.style.color });
                    el.style.color = 'black';
                });

                const canvas = await html2canvas(element, {
                    backgroundColor: '#ffffff',
                    scale: 2,
                    useCORS: true
                });

                originalStyles.forEach(({ el, color }) => {
                    el.style.color = color;
                });

                const link = document.createElement('a');

                if (format === 'jpeg') {
                    link.href = canvas.toDataURL('image/jpeg', quality);
                    link.download = `export-${Date.now()}.jpeg`;
                } else {
                    link.href = canvas.toDataURL('image/png');
                    link.download = `export-${Date.now()}.png`;
                }

                link.click();

            } catch (err) {
                console.error('Error exporting image:', err);
                alert('Export failed: ' + err.message);
            }
        },

        handleEditClose: function() {
            enableBodyScroll();
            this.openEditPopup = false;
            this.openSelectionPopup = false;
        },

        openEditCriteria: function () {
            disableBodyScroll();
            this.openSelectionPopup = true;
            this.openEditPopup = true;
        },

        handleDuplicateWidget: function () {
            this.widgetObj.posX = this.widgetData.posX;
            this.widgetObj.posY = this.widgetData.posY;
            this.widgetObj.columns = this.widgetData.columns;
            this.widgetObj.rows = this.widgetData.rows;
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },

        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleSettingsClick:function(){
            this.settingsLoading = true;
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },

        handelCloseSelection:function(){
            this.openSelectionPopup = false;
            enableBodyScroll()
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },

        onClickPopulateGraph: function (requestBody) {
            enableBodyScroll();
            this.loading = true;
            this.openSelectionPopup = false;
            this.widgetId = this.widgetObj.id;
            this.loading = true;
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let widgetData = {};
            widgetData = {
                name: requestBody.graphName,
                description: requestBody.description,
                graphCriteria: this.widgetObj.graphCriteria,
                id: this.widgetId,
                type: requestBody.type,
                state:'old',
            }
            widgetData.graphCriteria.graphTypeTitle =  requestBody.graphTypeTitle;
            widgetData.graphCriteria.optionTypeTitle =  requestBody.optionTypeTitle;
            axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData).then(response => {
                this.widgetObj = response.data.widget;
                this.chartData = response.data.widget || {
                    isSynced: false,
                    isSyncing: false
                };
                this.addWidget = false;
                this.loading = false;
            }).catch(e => {
                this.errorCase = true;
                this.loading = false;
                console.error(e);
            })
        },

        fetchWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                this.chartData = response.data.widget || {
                    isSynced: false,
                    isSyncing: false
                };
                this.addWidget = false;
                this.loading = false;
            }).catch(e => {
                this.errorCase = true;
                this.loading = false;
                console.log(e);
            });
        },

        handleSyncWidget: function (widgetSelected) {
            let data = {};
            data.widgetId = widgetSelected.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                this.chartData = response.data.widget || {
                    isSynced: false,
                    isSyncing: false
                };
                this.addWidget = false;
                this.loading = false;
            }).catch(e => {
                this.errorCase = true;
                this.loading = false;
                console.log(e);
            });
        }

    }
})
