const kendisWidgetFlowTimeGraph = Vue.component('kendis-widget-flow-time', {
    template: `
        <div style="height: 100%;">
             <div class=""  style="height: 100%;">
                 <div class="cfdGraphCard">
                    <div v-if="loading" class="loader">
                      <div>
                        <div class="loaderinteg"/>
                      </div>
                    </div> 
                    <div class="graphInnerContainer">
                        <div v-if="widgetObj.state !== 'new'" class="cardHeader" ref="header">
                            <div>
                               <div class="tooltip c-deflt">
                                        <h4 class="cardTitle elips">
                                           {{widgetObj.name}}  
                                        </h4>
                                        <div class="hovtooltip">
                                            {{widgetObj.name}}
                                        </div>
                               </div>
                                <!--<p class="DF" style="color: #5C697C;">-->
                                <!--{{widgetObj.category}}-->
                                <!--<span class="tooltip ml-10 flowTip">-->
                                <!--<em class="infotxt"></em>-->
                                <!--<div class="hovtooltip">-->
                                <!--Flow Time widget displays the time (in days) taken by the PI items to transition between the workflows based on selected criteria.-->
                                <!--</div>-->
                                <!--</span>-->
                                <!--</p>-->
                                           
                                <div v-if="!addWidget" class="tooltip criteria">
                                    <p class="clickable-text">Criteria Details</p>
                                    <div class="hovtooltip criteriaDetailTip">
                                        <div class="graphName">{{widgetObj.category}}</div>
                                        <kendis-widget-criteria-details :graphCriteria="graphCriteria" :type ="!_.isEmpty(widgetObj.type) ? widgetObj.type:''"/>                                                                              
                                    </div>
                                </div>
                            </div>  
                            <div class="DAJE">
                            <div v-if=" !addWidget && !_.isEmpty(widgetObj.allGroupBys)" class="DF filterOptions"  style="height: fit-content;">
                                           <div  class="selectcont cardHeaderSelect">
                                               <vz-select 
                                                    :multiple="true" 
                                                    label="title" 
                                                    empty-selection-text="Select Group By"
                                                    :selected-title="selectedGroupByMessage" 
                                                    class="multi-filter"
                                                    value-type="value" 
                                                    v-model="groupBySelected" 
                                                    :options="chartData.allGroupBys"
                                                    :groups-enabled="false"
                                                    :show-select-all-on-group="false"
                                                    track-by="id"
                                                    @select="handleGroupBySelection"  
                                                />
                                          </div>
<!--                                          <span class="tooltip  dropTip">-->
<!--                                            <em class="infotxt"></em>-->
<!--                                            <div class="hovtooltip">-->
<!--                                               Select among the grouped criteria to view filtered flow time data.-->
<!--                                            </div>-->
<!--                                          </span>	-->
                            </div>
                            <div v-if="widgetObj.graphCriteria?.chartType !== 'column' && !addWidget && errorCase === false" class="averageTxt">
                                        <div v-if="widgetObj.type === 'flow-time-graph' && chartData.average !== 'NaN' ">
                                            <div class="DF AlignBase">
                                                <h2 class="fs-34">{{chartData.average}} </h2>
                                                <span style="margin-left: 5px">Days</span>
                                                <span class="tooltip ml-5 selectedCriteriaTip">
                                                        <em class="infotxt"></em>
                                                           <div class="hovtooltip">
                                                            The average number of days taken by all features to move through the selected work flows.
                                                        </div>
                                                </span>
                                            </div>
                                            <!--<p class="fs-11 DF mt-5" style="color: #5C697C;">-->
                                            <!--Average of selected criteria.-->
                                            <!--<span class="tooltip ml-5 selectedCriteriaTip">-->
                                            <!--<em class="infotxt"></em>-->
                                            <!--<div class="hovtooltip">-->
                                            <!--text test here-->
                                            <!--</div>-->
                                            <!--</span>-->
                                            <!--</p>-->
                                        </div>
                            </div>
                            </div>
                        </div>
                        <div v-if="errorCase" class="h-full DFA JC">
                            <div>
                                <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                                <p class="txt-cntr">Please make sure your board contains sprint dates</p>
                                <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                            </div>
                        </div>
                          <div v-if="errorCaseNoData==true && errorCase==false" class="h-full DFA JC">
                            <div>
                                <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                                <p class="txt-cntr">No Data Available, As per selected Criteria.</p>
                                <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                            </div>
                        </div>
                       <chart1 class="chart" v-if="chartData.show && errorCase === false && errorCaseNoData===false" :options="chartData.options"></chart1>
    <!--                   <div v-if = "addWidget" >-->
    <!--                        <button  type="button" class="button rds4 FR" @click="openFlowTimeCriteria" >Select Criteria</button> -->
    <!--                   </div>-->
                       <div class="cardFooter" ref="footer"> 
                           <div class="DFA gap-1">
                                <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                                    <img src="assets/icons/last-update.svg" alt="" />  
                                    <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                                </span>
                                <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                                    <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: chartData.isSyncing }" class="refreshIcon">
                                    <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt=".." class="checkIcon">
                                    <div class="hovtooltip ftsb wht-nwrp refreshIconTip">
                                        Refresh
                                   </div>
                                </div>
                                <div 
                                    class="settingsContainer c-point iconContainer" 
                                    v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget" 
                                   @click="handleSettingsClick">
                                    <img  src="assets/icons/setting3.svg" alt="" />  
                                    <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                                        <ul v-if="settingsLoading" class="drop_box"   style="display: block;cursor: pointer">
                                            <li  class="loader">
                                                  <div>
                                                    <div class="loaderinteg"/>
                                                  </div>
                                            </li>             
                                        </ul> 
                                        <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                            <li class="boxItem"   @click="openFlowTimeEditCriteria()"> 
                                                <img src="/assets/icons/Dashboard/edit-gray.svg" alt=".." class=""> Edit 
                                            </li>	
                                            <li class="boxItem" @click="handleDuplicateWidget()">  
                                                <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt=".." class=""> Duplicate 
                                            </li>							
                                            <li class="boxItem" @click="handleRemoveWidget()">  
                                                <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class=""> Remove 
                                            </li>                          
                                        </ul>
                                    </vuepopup>
                                </div>
    <!--                            <div class="settingsContainer c-point iconContainer" @click="handleRemoveWidget()" v-if="addWidget">-->
    <!--                                <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="">  -->
    <!--                            </div>             -->
                           </div>
                          <p v-if="!addWidget && errorCase === false" @click = "handleDetailList()" class="clickable-text">Detail List</p>
                       </div>
                    </div>
                 </div>    
            </div>
            <kendis-dashboard-selection-popup v-if="openSelectionPopup"  :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" :widgetType = "widgetObj.type" @close="handelCloseSelection" @populate-graph="onClickPopulateGraph"/>
            <kendis-graph-edit-popup v-if="openEditPopup" :selectedWidget="widgetObj" :dashboardSelected="dashboardSelectedId" @close="handleEditPopupClosure"  @updateWidget="onClickPopulateGraph"> </kendis-graph-edit-popup>
            <dashboard-list-items-popup v-if="isPopupOpen" @close="closeItemsPopup"  :data="popupData"/>	
        </div>		
    `,
    mixins:[rightsMixin],

    props: {widgetData: null, dashboardSelectedId: null,myRole:null},

    data() {
        return {
            stackingValue:'normal',
            graphTypeValue:'line',
            chartTypeName:'',
            settingsLoading:false,
            loading: false,
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            errorCaseNoData:false,
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            chartData: {
                show: false,
                options: new Object(),
                isSynced: false,
                timestampInfo: '',
                allGroupBys:[],
            },
            //chart criteria details
            graphCriteria: {
                type:"flow-time-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            groupBySelected: [],
            
            //Chart Object
            flowTimeGraph: {
                show: false,
                options: {
                    chart: {
                        type: this.graphTypeValue,
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },

                    yAxis: {
                        plotLines: [{
                            value: 6000,
                            color: '#59D',
                            dashStyle: 'shortDash',
                            width: 2
                        }],
                        title: {
                            text: 'Number of Days'
                        }
                    },

                    xAxis: {
                        categories: [],
                        labels: {
                            formatter: function() {
                                let isDaysInterval = _this.widgetObj?.graphCriteria?.intervals === "days" ? true :false ;
                                let isMonthsInterval = _this.widgetObj?.graphCriteria?.intervals === "monthly" ? true :false ;
                                let isOthersInterval = _this.widgetObj?.graphCriteria?.intervals === "weekly" || _this.widgetObj?.graphCriteria?.intervals === "sprints" ? true :false ;

                                if (isOthersInterval) {
                                    const parts = this.value.split('\n');
                                    return '<span style="display: block; text-align: center;">' + parts[0] + '</span>' + // Week name above
                                        '<span style="display: block; text-align: center;font-size: 12px; color: #5c697c;">' + parts[1] + '</span>'; // Date range below

                                } else if(isMonthsInterval){
                                    return '<span style="display: block; text-align: center;">' + this.value + '</span>';
                                }
                                else {
                                    return this.value;
                                }
                            },
                            useHTML: true
                        },
                        title: {
                            text: 'Interval'
                        }
                    },
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    tooltip: {
                        useHTML: true,
                        backgroundColor: 'white',
                        borderWidth: 0,
                        borderRadius:5,
                        formatter: function() {
                            return '' +
                                '<div class="garphsTooltipwraper">' +
                                '<div class="DFCB"><label>' + this.point.titleOfGroupby + ':</label> <div style="color: ' + this.point.color + ';">' + this.point.name + '</div></div>' +
                                '<div class="DFCB"><label>From Status:</label> <div>' + this.point.fromStatusTitle + '</div> </div>' +
                                '<div class="DFCB"><label>To Status: </label><div> ' + this.point.toStatusTitle + ' </div></div> ' +
                                '<div class="DFCB"><label>Time (in Days):</label> <div>' + this.y + ' days </div></div> <hr/>' +
                                '<div class="DFCB"><label>' + this.point.intervalTitle + ':</label> <div>' + this.point.intervalValue + '</div></div>' +
                                (this.point.intervalTitle !== 'Days' ?
                                    '<div class="DFCB"><label>Start Date:</label> <div>' + this.point.start  + '</div></div>' +
                                    '<div class="DFCB"><label>End Date:</label> <div>' + this.point.end  + '</div></div>'
                                    : '') +
                                '</div>';
                        }
                    },
                    colors: ['#32CD32','#FF69B4', '#0485E3','#EBB438','#00FFFF','#9370DB','#FFA07A','#FF4500', '#20B2AA','#FF0000', '#00FF00', '#0000FF', '#FFD700', '#800080', // Add more custom colors as needed
                        '#FF6347',
                        '#4169E1', '#8B0000', '#ADFF2F',
                        '#8A2BE2', '#556B2F'], //
                    plotOptions: {
                        column: {
                            stacking: this.stackingValue,
                            dataLabels: {
                                enabled: true,
                                formatter: function() {
                                    if (this.y !== 0) {
                                        return this.y;
                                    }
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            label: {
                                connectorAllowed: false
                            },
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onFlowTimeGraphCliked(event);
                                    }
                                }
                            }
                        }
                    },
                    series: [],
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom',
                                    maxHeight: 55,
                                    navigation: {
                                        enabled: true // Enable legend navigation/pagination
                                    },
                                }
                            }
                        }]
                    },
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen','separator','downloadPDF','downloadJPEG','downloadPNG','downloadXLS' ]
                            }
                        }
                    }
                }
            },
            widgetObj:[],
            chartType:"",
            errorCase:false,
            itemtags:{},
            itemTagsMeta:{},
        }
    },

    components: {
        //add components here
        'kendis-dashboard-selection-popup': kendisDashboardSelectionPopup,
        "kendis-graph-edit-popup": kendisGraphEditPopup,
        'kendis-widget-criteria-details': kendisWidgetCriteraiDetails,
        'dashboard-list-items-popup': dashboardPopupComponent,
    },

    mounted() {
        //Create a new Widget if id is null
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: hidden; }";
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.fetchFlowTimeWidgetData();
        }
    },

    created() {
    },

    computed: {
        selectedGroupByMessage: function () {
            let selectedGrouping = this.groupBySelected;
            let title = "";
            if (!_.isEmpty(selectedGrouping) && !_.isEmpty(this.graphCriteria.selectedGroupBy)) {
                if (this.graphCriteria.selectedGroupBy.length >= 10) {
                    title = this.graphCriteria.selectedGroupBy.slice(0, 15) + "..." + " (" + selectedGrouping.length + ")";
                } else {
                    title = this.graphCriteria.selectedGroupBy + "s" + " (" + selectedGrouping.length + ")";
                }
            }
            return title;
        },
    },

    methods: {
        //Edit Popup Closure:
        handleEditPopupClosure(){
            enableBodyScroll();
            this.openEditPopup = false;
        },
        closeItemsPopup(){
            enableBodyScroll();
            this.isPopupOpen = false;
        },
        //Handle Settings Click
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //handle the flow for cancel of selection
        handelCloseSelection:function(){
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: auto; }";
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },

        fetchFlowTimeWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
                if(!_.isEmpty(this.widgetObj.graphCriteria.chartType) && this.widgetObj.graphCriteria.chartType==='column'){
                    if(!_.isEmpty(this.widgetObj.graphCriteria.chartTypeName) && this.widgetObj.graphCriteria.chartTypeName==='Bar Graph'){
                        this.stackingValue = "";
                    }
                    else{
                        this.stackingValue = "normal";
                    }
                }
                this.initializeFlowTimeGraphData(this.widgetObj);
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading single Flow Load", e);
                this.loading = false;
            });
        },

        //methods for Flow Time processing

        openFlowTimeCriteria: function () {
            this.openSelectionPopup = true;
        },

        openFlowTimeEditCriteria: function () {
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: hidden; }";
            this.openEditPopup = true;
        },

        onClickPopulateGraph: function (requestBody) {
            this.loading = true;
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: auto; }";
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let reqBody = {};

            if (requestBody.xAxis === 'weekly' || requestBody.xAxis == 'sprints' || requestBody.xAxis == 'monthly') {
                this.selectedInterval = requestBody.xAxis;
            } else {
                this.selectedInterval = requestBody.selectedInterval;
            }
            reqBody = {
                sessionBoardId: requestBody.sessionBoardId,
                startStatus: requestBody.statusListing.startOfSelectedStatus,
                endStatus: requestBody.statusListing.endOfSelectedStatus,
                tenant: requestBody.tenant,
                interval: this.selectedInterval,
                issueType: requestBody.selectedIssueType,
                radioTypeSelection: requestBody.radioButtonSelection,
                groupBy: requestBody.groupBy,
                boardItemsFilter: requestBody.boardItemsFilter,
                dashboardId : this.dashboardSelectedId,
                itemtags : requestBody.itemtags,
            };
            this.itemtags = requestBody.itemtags;
            this.itemTagsMeta = requestBody.itemTagsMeta;
            this.boardId = requestBody.selectedBoard._id;
            this.boardTenant = requestBody.tenant;
            this.graphTypeTitle = requestBody.graphTypeTitle;
            this.optionTypeTitle = requestBody.optionTypeTitle;
            this.sessionBoardId = requestBody.sessionBoardId;
            this.selectedBoard = requestBody.selectedBoard;
            this.selectedGraph = requestBody.selectedGraph;
            this.graphName = requestBody.graphName;
            this.selectedFilterType = requestBody.selectedFilterType;
            this.statusListing = requestBody.statusListing;
            this.selectedCondition = requestBody.statusIds;
            this.radioButtonSelection = requestBody.radioButtonSelection;
            this.selectedIssueType = requestBody.selectedIssueType;
            this.groupBy = requestBody.groupBy;
            this.xAxis = requestBody.xAxis;
            this.selectedBoardTitle = requestBody.selectedBoardTitle;
            this.selectedToStatus = requestBody.selectedToStatus;
            this.selectedFromStatus = requestBody.selectedFromStatus;
            this.issueTypeTitleList = requestBody.selectedIssueTypeTitleList;
            this.groupByTitle = requestBody.groupByTitle;
            this.chartType = requestBody.chartType;
            this.chartTypeName = requestBody.chartTypeName;
            this.boardItemsFilter = requestBody.boardItemsFilter;
            if (requestBody.selectedFilterType === 'cfd') {
                this.widgetId = requestBody.widgetId;
            }
            if (requestBody.teams) {
                reqBody.teams = requestBody.teams;
                this.boardTeams = requestBody.teams;
            }
            if (requestBody.sprints) {
                reqBody.sprints = requestBody.sprints;
                this.boardSprints = requestBody.sprints;
            }
            reqBody.widgetType = requestBody.optionTypeTitle;
            let _this = this;
            axios.post('/dashboard/create-timeseries-data', reqBody)
                .then(response => {
                    if (!response.data) {
                        throw new Error('Response data is empty');
                    }
                    let widgetData;
                    widgetData = _this.makeGraphObjectForFlowTimeDBStorage(response.data);
                    if (!_.isEmpty(widgetData)) {
                        return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData);
                    } else {
                        throw new Error('Processed widget data is empty');
                    }
                })
                .then(response => {
                    let updatedWidget = response.data.widget;
                    if(!_.isEmpty(updatedWidget.graphCriteria.chartType) && updatedWidget.graphCriteria.chartType==='column'){
                        if(!_.isEmpty(updatedWidget.graphCriteria.chartTypeName) && updatedWidget.graphCriteria.chartTypeName==='Bar Graph'){
                            this.stackingValue = "";
                        }
                        else{
                            this.stackingValue = "normal";
                        }
                    }
                    this.widgetObj = updatedWidget;
                    this.initializeFlowTimeGraphData(updatedWidget);
                    this.loading = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    _this.loading = false;
                });
        },

        makeGraphObjectForFlowTimeDBStorage: function (response) {
            let widgetData = {};
            if (response) {
                let graphDataMap = response.intervals;
                let categories = response.categories;
                let allGroupBys = response.allGroupBys;
                let itemDaysMap = response.itemsDaysMap;
                let itemTeamsMap = response.itemTeamsMap;
                let itemSprintsMap = response.itemSprintsMap;
                let itemGroupbyMap = response.itemGroupByMap;
                let relevantDates = response.relevantDates;
                let intervalDates = response.intervalDates;
                let groupIdColorMap = response.groupIdColorMap;
                let itemStatusMap = response.itemStatusMap;
                let itemIdsMap = response.itemIdsMap;
                const transformedData = Object.entries(graphDataMap).map(([key, value]) => [key, value]);
                const transformeditemIdsMapData = Object.entries(itemIdsMap || {}).map(([key, value]) => [key, value]);

                let selectedItems = [];
                if (!_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) {
                    selectedItems.push(this.statusListing.startOfSelectedStatus);
                    selectedItems.push(this.statusListing.endOfSelectedStatus);
                }
                let dataofGraph = {
                    "graphType": "line",
                    "selectedItems": selectedItems,
                    "boardId": this.boardId,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.xAxis,
                    "radioButtonSelection": this.radioButtonSelection,
                    "selectedIssueType": this.selectedIssueType,
                    "groupBy": this.groupBy,
                    "categories": categories,
                    "boardTitle": this.selectedBoardTitle,
                    "fromStatusTitle": this.selectedToStatus,
                    "toStatusTitle": this.selectedFromStatus,
                    "groupByTitle": this.groupByTitle,
                    "itemDaysMap": itemDaysMap,
                    "issueTypeTitle": this.issueTypeTitleList,
                    "itemTeamsMap": itemTeamsMap,
                    "itemSprintsMap": itemSprintsMap,
                    "itemsGroupMap": itemGroupbyMap,
                    "chartType": this.chartType,
                    "chartTypeName": this.chartTypeName,
                    "relevantDates": relevantDates,
                    "boardItemsFilter": this.boardItemsFilter,
                    "itemIdsMap": transformeditemIdsMapData,
                    "groupIdColorMap" : groupIdColorMap,
                    "itemTags":this.itemtags,
                    "itemTagsMetaMap" : this.itemTagsMeta,
                    "itemStatusMap":itemStatusMap,
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataofGraph,
                    graphAdditionalCriteria: transformedData,
                    id: this.widgetData.id,
                    allGroupBys: allGroupBys,
                    state: "old",
                }
            }
            return widgetData;
        },

        //Chart Population Functions
        initializeflowTimeGraph: function () {
            let _this = this;
            this.flowTimeGraph = {
                show: false,
                options: {
                    chart: {
                        type: this.graphTypeValue,
                        zoomType: 'x',
                        height: 0,
                        resetZoomButton: {
                            position: {
                                align: 'left', // Align to the left
                                verticalAlign: 'top', // Align to the top
                                x: 10, // X offset for positioning
                                y: 10 // Y offset for positioning
                            }
                        }
                    },
                    yAxis: {
                        plotLines: [{
                            value: 6000,
                            color: '#59D',
                            dashStyle: 'shortDash',
                            width: 2
                        }],
                        title: {
                            text: 'Number of Days'
                        }
                    },
                    xAxis: {
                        categories: [],
                        labels: {
                            formatter: function() {
                                let isDaysInterval = _this.widgetObj?.graphCriteria?.intervals === "days" ? true :false ;
                                let isMonthsInterval = _this.widgetObj?.graphCriteria?.intervals === "monthly" ? true :false ;
                                let isOthersInterval = _this.widgetObj?.graphCriteria?.intervals === "weekly" || _this.widgetObj?.graphCriteria?.intervals === "sprints" ? true :false ;

                                if (isOthersInterval) {
                                    const parts = this.value.split('\n');
                                    return '<span style="display: block; text-align: center;">' + parts[0] + '</span>' + // Week name above
                                        '<span style="display: block; text-align: center;font-size: 12px; color: #5c697c;">' + parts[1] + '</span>'; // Date range below

                                } else if(isMonthsInterval){
                                    return '<span style="display: block; text-align: center;">' + this.value + '</span>';
                                }
                                else {
                                    return this.value;
                                }
                            },
                            useHTML: true
                        },
                        title: {
                            text: 'Interval'
                        }
                    },
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        },
                        maxHeight: 55,
                        navigation: {
                            enabled: true // Enable legend navigation/pagination
                        },
                    },
                    tooltip: {
                        useHTML: true,
                        backgroundColor: 'white',
                        borderWidth: 0,
                        borderRadius: 5,
                        formatter: function () {
                            return '' +
                                '<div class="garphsTooltipwraper">' +
                                '<div class="DFCB"><label>' + this.point.titleOfGroupby + ':</label> <div style="color: ' + this.point.color + '; padding-left: 20px;" >' + this.point.name + '</div></div>' +
                                '<div class="DFCB"><label>From Status:</label> <div>' + this.point.fromStatusTitle + '</div> </div>' +
                                '<div class="DFCB"><label>To Status: </label><div> ' + this.point.toStatusTitle + ' </div></div> ' +
                                '<div class="DFCB"><label>Time (in Days):</label> <div>' + this.y + ' days </div></div> <hr/>' +
                                '<div class="DFCB"><label>' + this.point.intervalTitle + ':</label> <div>' + this.point.intervalValue + '</div></div>' +
                                (this.point.intervalTitle !== 'Days' ?
                                    '<div class="DFCB"><label>Start Date:</label> <div>' + this.point.start + '</div></div>' +
                                    '<div class="DFCB"><label>End Date:</label> <div>' + this.point.end + '</div></div>'
                                    : '') +
                                '</div>';
                        }
                    },
                    colors: ['#32CD32', '#FF69B4', '#0485E3', '#EBB438', '#00FFFF', '#9370DB', '#FFA07A', '#FF4500', '#20B2AA', '#FF0000', '#00FF00', '#0000FF', '#FFD700', '#800080', // Add more custom colors as needed
                        '#FF6347',
                        '#4169E1', '#8B0000', '#ADFF2F',
                        '#8A2BE2', '#556B2F'], //
                    plotOptions: {
                        column: {
                            stacking: this.stackingValue,
                            dataLabels: {
                                enabled: true,
                                formatter: function () {
                                    if (this.y !== 0) {
                                        return this.y;
                                    }
                                }
                            },
                            borderRadius: 5,
                        },
                        series: {
                            stickyTracking: false,
                            events: {
                                legendItemClick: function () {
                                    if (this.visible) {
                                        console.log('Series ' + this.name + ' is selected');
                                    } else {
                                        console.log('Series ' + this.name + ' is unselected');
                                    }
                                }
                            },
                            label: {
                                connectorAllowed: false
                            },
                            point: {
                                events: {
                                    click: function () {
                                        const chart = this.series.chart;
                                        const allLegendsVisible = chart.series.every(series => series.visible);
                                        const xAxisIndex = this.index;
                                        let itemIds = [];
                                        if (this.series.options.chartType != 'column') {
                                            if (allLegendsVisible) {
                                                itemIds = chart.series
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            } else {
                                                itemIds = chart.series
                                                    .filter(series => series.visible)
                                                    .flatMap(series => series.options.itemIds[xAxisIndex] || [])
                                                    .filter(id => id !== "");
                                            }
                                        } else {
                                            itemIds = this.series.options.itemIds[xAxisIndex];
                                        }
                                        _this.onClickDataPoints(itemIds, this.series.options.graphName, this.options.fromStatusTitle, this.options.toStatusTitle, this.series.options.graphType,this.series.name);
                                    }
                                }
                            }
                        }
                    },
                    series: [],
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom',
                                    maxHeight: 55,
                                    navigation: {
                                        enabled: true // Enable legend navigation/pagination
                                    },
                                }
                            }
                        }]
                    },
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen', 'separator', 'downloadPDF', 'downloadJPEG', 'downloadPNG', 'downloadXLS']
                            }
                        }
                    }

                }
            };
        },

        initializeFlowTimeGraphData: function (data) {
            var processedGraph = {};
            if (data !== null) {
                if (data.type === 'flow-time-graph') {
                    if(_.isEmpty(data.graphCriteria.categories)){
                        this.errorCase= true;
                    }
                    else{
                        this.errorCase= false;
                    }
                    this.populateFlowTimeChart(data);
                    let timestamp = '';
                    if (data.updatedOn) {
                        timestamp = data.updatedOn;
                    } else {
                        timestamp = data.createdOn;
                    }
                    const dateData = new Date(timestamp);
                    let average = this.calculateAverageOfDataPoints(data.graphAdditionalCriteria);
                    if (average === 'NaN') {
                        average = 0.0;
                    }
                    let allGroupBys = [];
                    if (!_.isEmpty(data.allGroupBys)) {
                        allGroupBys = data.allGroupBys;
                    }
                    const keys = Object.keys(allGroupBys);
                    const transformedallGroupBys = keys.map(key => ({
                        id: key,
                        title: allGroupBys[key]
                    }));
                    let graphCriteria = {
                        graphType: null,
                        selectedBoardTitle: null,
                        selectedIssueType: null,
                        selectedGroupBy: null,
                        selectedXAxis: null,
                        selectedInterval: null,
                        selectedToStatus: null,
                        selectedFromStatus: null,
                        sessionBoardId:null,
                    };
                    graphCriteria.sessionBoardId=data.graphCriteria.sessionBoardId;
                    graphCriteria.graphType = 'Flow Time Graph';
                    graphCriteria.chartType = data.graphCriteria.chartType;
                    graphCriteria.selectedBoardTitle = data.graphCriteria.boardTitle;
                    graphCriteria.selectedIssueType = data.graphCriteria.issueTypeTitle;
                    graphCriteria.selectedGroupBy = data.graphCriteria.groupByTitle ? data.graphCriteria.groupByTitle : data.graphCriteria.groupBy;
                    if (data.graphCriteria.intervals == 'sprints' || data.graphCriteria.intervals == 'weekly' || data.graphCriteria.intervals == 'monthly') {
                        graphCriteria.selectedXAxis = data.graphCriteria.intervals;
                    } else {
                        graphCriteria.selectedXAxis = "Days";
                        graphCriteria.selectedInterval = data.graphCriteria.intervals;
                    }
                    graphCriteria.selectedToStatus = data.graphCriteria.toStatusTitle;
                    graphCriteria.selectedFromStatus = data.graphCriteria.fromStatusTitle;

                    if (data.graphCriteria.graphType === 'line') {
                        processedGraph = {
                            options: Object.assign({}, this.flowTimeGraph.options),
                            show: false,
                            id: data.id,
                            timestampInfo: dateData.toLocaleString(),
                            name: data.name,
                            isSynced: false,
                            isSyncing: false,
                            type: "flow-time-graph",
                            category: "Flow Time",
                            average: average,
                            loading: false,
                            allGroupBys: transformedallGroupBys,
                            graphCriteria: graphCriteria,
                            columns: data.columns,
                            rows: data.rows,
                            posX: data.posX,
                            posY: data.posY,
                            itemDaysMap: data.graphCriteria.itemDaysMap ? data.graphCriteria.itemDaysMap : {},
                            itemTeamsMap: data.graphCriteria.itemTeamsMap ? data.graphCriteria.itemTeamsMap : {},
                            itemSprintsMap: data.graphCriteria.itemSprintsMap ? data.graphCriteria.itemSprintsMap : {},
                            itemGroupbyMap: data.graphCriteria.itemsGroupMap ? data.graphCriteria.itemsGroupMap : {},
                            itemStatusMap : data.graphCriteria.itemStatusMap? data.graphCriteria.itemStatusMap : {},
                        };
                        this.$set(this.chartData, 'show', false);
                        this.$set(this,'chartData', processedGraph);
                        this.$set(this,'groupBySelected', this.chartData?.allGroupBys?.map(option => option?.id));
                        this.$set(this.chartData,'selectedGroupBy',this.groupBySelected);
                        this.$set(this, 'graphCriteria', graphCriteria);
                        this.$set(this, 'addWidget', false);
                        this.$set(this, 'loading', false);

                        let _this = this;
                        this.$nextTick(() => {
                            _this.setGraphHeight();
                            _this.chartData.show = true;
                        });
                    }
                }
            }
        },

        populateFlowTimeChart: function (widget) {
            const data = [];
            let categories = [];
            let dataOfGraph = [];
            this.initializeflowTimeGraph();
            this.errorCaseNoData=false;
            let dummyData = [];
            const monthMap = {
                Jan: '01', Feb: '02', Mar: '03', Apr: '04',
                May: '05', Jun: '06', Jul: '07', Aug: '08',
                Sep: '09', Oct: '10', Nov: '11', Dec: '12'
            };
            let graphOptions = _.cloneDeep(this.flowTimeGraph.options);
            const formattedList = Object.keys(widget.graphCriteria.relevantDates).map(sprint => {
                const [startTimestamp, endTimestamp] = widget.graphCriteria.relevantDates[sprint];
                const startDateParts = startTimestamp.split(" ");
                const startDay = startDateParts[2];
                const startMonthName = startDateParts[1];
                const startYear = startDateParts[5];
                const startMonth = monthMap[startMonthName];
                let formattedStartDate = "";
                if(widget.graphCriteria.intervals === "weekly"){
                    formattedStartDate = `${startDay} ${startMonthName}`;
                    return `${sprint}\n(${formattedStartDate})`;
                }
                if(widget.graphCriteria.intervals === "monthly"){
                    const parts = sprint.split(" "); // Split the string by spaces
                    const month = parts[0];
                    return `${month} ${startYear.slice(-2)}`;
                }

                formattedStartDate = `${startDay}/${startMonth}/${startYear}`;

                const endDateParts = endTimestamp.split(" ");
                const endDay = endDateParts[2];
                const endMonthName = endDateParts[1];
                const endYear = endDateParts[5];
                const endMonth = monthMap[endMonthName];
                const formattedEndDate = `${endDay}/${endMonth}/${endYear}`;

                return `${sprint}\n(${formattedStartDate} - ${formattedEndDate})`;
            });
            graphOptions.xAxis.categories = formattedList;
            graphOptions.chart.type = widget.graphCriteria.chartType;
            if (!_.isEmpty(widget.graphAdditionalCriteria)) {
                let index = 0;
                let itemDaysMap = {};
                if (widget.graphCriteria.itemDaysMap != null) {
                    if (!_.isEmpty(widget.graphCriteria.itemDaysMap)) {
                        itemDaysMap = widget.graphCriteria.itemDaysMap;
                    }
                }
                let average = this.calculateAverageOfDataPoints(widget.graphAdditionalCriteria);
                if (average === 'NaN') {
                    average = 0.0;
                }
                if (widget.graphCriteria.chartType !== 'column') {
                    graphOptions.yAxis.plotLines = [{
                        value: average,
                        color: '#59D',
                        dashStyle: 'shortDash',
                        width: 2
                    }];
                }
                let teamMap = new Map();
                if (widget.graphAdditionalCriteria !== null) {
                    for (const pair of widget.graphAdditionalCriteria) {
                        const key = pair[0];
                        const value = pair[1];
                        const iteration = key.split('=')[0].replace('{', '').trim();
                        const team = key.split('=')[1].replace('}', '').trim();
                        if (!teamMap.has(team)) {
                            teamMap.set(team, {
                                counts: new Array(widget.graphCriteria.categories.length).fill(0),
                                itemIds: new Array(widget.graphCriteria.categories.length).fill([])
                            });
                        }
                        const teamData = teamMap.get(team);
                        const iterationIndex = widget.graphCriteria.categories.indexOf(iteration);
                        teamData.counts[iterationIndex] += value;
                        const itemIdsEntry = widget.graphCriteria.itemIdsMap.find(entry => entry[0] === key);
                        const itemIds = itemIdsEntry ? itemIdsEntry[1] : [];
                        teamData.itemIds[iterationIndex] = teamData.itemIds[iterationIndex].concat(itemIds);
                        teamMap.set(team, teamData);
                    }
                    let indexx = 0;
                    for (const [key, value] of teamMap) {
                        const nonZeroData = value.counts.filter(item => item !== 0); // Filter out zero values
                        if (nonZeroData.length > 0) {
                        graphOptions.series[indexx] = {
                            name: key,
                            data: value.counts.map((item, iterationIndex) => ({
                                y: item,
                                name: key,
                                titleOfGroupby: widget.graphCriteria.groupByTitle,
                                fromStatusTitle: widget.graphCriteria.fromStatusTitle,
                                toStatusTitle: widget.graphCriteria.toStatusTitle,
                                intervalTitle: _.capitalize(widget.graphCriteria.intervals.toString()),
                                intervalValue: widget.graphCriteria.categories[iterationIndex],
                                start: this.formatInnerDate(this.getStartDate(widget.graphCriteria.categories[iterationIndex], widget.graphCriteria.relevantDates)),
                                end: this.formatInnerDate(this.getEndDate(widget.graphCriteria.categories[iterationIndex], widget.graphCriteria.relevantDates)),
                            })),
                            itemIds: value.itemIds,
                            graphName: widget.name,
                            graphType: widget.graphCriteria.optionTypeTitle,
                            chartType: widget.graphCriteria.chartType,
                            color: !_.isEmpty(widget.graphCriteria.groupIdColorMap) ? widget.graphCriteria.groupIdColorMap[key] : '#FF0000',
                        };
                        indexx++;
                        }
                    }
                }
            }
            if(graphOptions.series.length>0 && graphOptions.series[0].data.length>0){
                this.flowTimeGraph.options = graphOptions;
            }
            else{
                this.errorCaseNoData=true;
            }
        },

        //Helper functions for formatting
        formattedCompletionStatus(status) {
            if (!_.isEmpty(status)) {
                return status.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },
        formatTimestamp(timestamp) {
            const date = new Date(Number(timestamp));
            const month = (date.getMonth() + 1).toString().padStart(2, '0');
            const day = date.getDate().toString().padStart(2, '0');
            const year = date.getFullYear();

            return `${month}/${day}/${year}`;
        },

        formatInnerDate: function (dateString) {
            const parts = dateString.split(" ");
            const month = parts[1];
            const day = parts[2];
            const year = parts[5];
            return `${month} ${day} ${year}`;
        },

        formatBoardItemsTitle: function (input) {
            if (!input) {
                return '';
            }

            return input
                .split('-')
                .map(word => word.charAt(0).toUpperCase() + word.slice(1))
                .join(' ');
        },

        getStartDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[0];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        getEndDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[dateList.length - 1];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        calculateAverageOfDataPoints: function (dataPoints) {
            let sum = 0;
            for (let i = 0; i < dataPoints.length; i++) {
                sum += dataPoints[i][1];
            }
            let average = sum / dataPoints.length;
            return average.toFixed(1);
        },

        handleGroupBySelection: function (selected) {
            let tempselectedGroupBy = selected == undefined ? [] : selected;
            let selectedGraph = this.chartData;
            let selectedGraphOptions = selectedGraph.options;
            let selectedWidget = this.widgetObj;
            let selectedGroupBy = selectedGraph.allGroupBys.filter(groupBy =>
                tempselectedGroupBy.includes(groupBy.id)
            );
            let dummyData = [];
            let graphOptions = null;

            if (selectedGraph.type == 'flow-time-graph') {
                this.initializeflowTimeGraph();
                graphOptions = _.cloneDeep(this.flowTimeGraph.options);
            }

            const monthMap = {
                Jan: '01', Feb: '02', Mar: '03', Apr: '04',
                May: '05', Jun: '06', Jul: '07', Aug: '08',
                Sep: '09', Oct: '10', Nov: '11', Dec: '12'
            };
            const formattedList = Object.keys(selectedWidget.graphCriteria.relevantDates).map(sprint => {
                const [startTimestamp, endTimestamp] = selectedWidget.graphCriteria.relevantDates[sprint];
                const startDateParts = startTimestamp.split(" ");
                const startDay = startDateParts[2];
                const startMonthName = startDateParts[1];
                const startYear = startDateParts[5];
                const startMonth = monthMap[startMonthName];
                const formattedStartDate = `${startDay}/${startMonth}/${startYear}`;

                const endDateParts = endTimestamp.split(" ");
                const endDay = endDateParts[2];
                const endMonthName = endDateParts[1];
                const endYear = endDateParts[5];
                const endMonth = monthMap[endMonthName];
                const formattedEndDate = `${endDay}/${endMonth}/${endYear}`;

                if(this.widgetObj.graphCriteria.intervals === "weekly"){
                    let formattedStartDate = `${startDay} ${startMonthName}`;
                    return `${sprint}\n(${formattedStartDate})`;
                }
                if(this.widgetObj.graphCriteria.intervals === "monthly"){
                    const parts = sprint.split(" "); // Split the string by spaces
                    const month = parts[0];
                    return `${month} ${startYear.slice(-2)}`;
                }
                return `${sprint}\n(${formattedStartDate} - ${formattedEndDate})`;
            });
            graphOptions.xAxis.categories = formattedList;
            graphOptions.chart.type = selectedWidget.graphCriteria.chartType;

            if (!_.isEmpty(selectedWidget.graphAdditionalCriteria)) {
                let teamMap = new Map();

                // Preprocess team map to avoid redundant operations
                selectedWidget.graphAdditionalCriteria.forEach(pair => {
                    const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                    if (!teamMap.has(team)) {
                        teamMap.set(team, Array(selectedWidget.graphCriteria.categories.length).fill(0));
                    }
                });

                if (selectedGroupBy != null) {
                    selectedWidget.graphAdditionalCriteria.forEach(pair => {
                        const iteration = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                        const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                        const teamData = teamMap.get(team);

                        if (selectedGroupBy.some(groupBy => groupBy.title === team)) {
                            const iterationIndex = selectedWidget.graphCriteria.categories.indexOf(iteration);
                            if (iterationIndex !== -1) {
                                teamData[iterationIndex] += pair[1];
                            }
                        }
                    });

                    let seriesData = [];
                    teamMap.forEach((value, key) => {
                        seriesData.push({ name: key, data: value });
                    });

                    graphOptions.series = seriesData.length ? seriesData : [{ name: "No Data", data: [] }];
                }
            }

            if (selectedGraph.type == 'flow-time-graph') {
                this.flowTimeGraph.options = graphOptions;
            }

            let timestamp = selectedWidget.updatedOn || selectedWidget.createdOn;
            const dateData = new Date(timestamp);
            let average = this.filteredDataPointsAvg(selectedWidget.graphAdditionalCriteria, selectedGroupBy);
            average = isNaN(average) ? 0.0 : average;

            if (selectedWidget.graphCriteria.chartType !== 'column' && selectedGraph.type == 'flow-time-graph' && selectedWidget.graphCriteria.chartType == 'line') {
                this.flowTimeGraph.options.yAxis.plotLines = [{
                    value: average,
                    dashStyle: 'shortDash',
                    width: 1
                }];
            }

            const transformedallGroupBys = Object.keys(selectedWidget.allGroupBys || {}).map(key => ({
                id: key,
                title: selectedWidget.allGroupBys[key]
            }));

            let graphCriteria = {
                chartType: selectedWidget.graphCriteria.chartType,
                graphType: selectedWidget.graphCriteria.graphType,
                selectedBoardTitle: selectedWidget.graphCriteria.boardTitle,
                selectedIssueType: selectedWidget.graphCriteria.issueTypeTitle,
                selectedGroupBy: selectedWidget.graphCriteria.groupByTitle || selectedWidget.graphCriteria.groupBy,
                selectedXAxis: ['sprints', 'weekly', 'monthly'].includes(selectedWidget.graphCriteria.intervals) ? selectedWidget.graphCriteria.intervals : "Days",
                selectedInterval: selectedWidget.graphCriteria.intervals,
                selectedToStatus: selectedWidget.graphCriteria.toStatusTitle,
                selectedFromStatus: selectedWidget.graphCriteria.fromStatusTitle,
            };

            let updatedItemsMap = selectedWidget.graphCriteria.itemDaysMap || selectedWidget.graphCriteria.itemStatusMap;
            let filteredItems = {};

            // Preprocess itemTeamsMap and updatedItemsMap for faster lookups
            let teamMap = new Map();
            for (const key in selectedWidget.graphCriteria.itemTeamsMap) {
                const [itemId, team] = key.split(':').map(s => s.trim());
                if (!teamMap.has(team)) {
                    teamMap.set(team, []);
                }
                teamMap.get(team).push(itemId);
            }

            let itemMap = new Map();
            for (const key in updatedItemsMap) {
                const [itemId, name] = key.split(':').map(s => s.trim());
                itemMap.set(`${itemId}:${name}`, updatedItemsMap[key]);
            }

            selectedGroupBy.forEach(groupBy => {
                const team = groupBy.title;
                if (teamMap.has(team)) {
                    teamMap.get(team).forEach(itemId => {
                        const key = `${itemId}:${team}`;
                        if (itemMap.has(key)) {
                            filteredItems[key] = itemMap.get(key);
                        }
                    });
                }
            });

            let processedGraph = {
                options: { ...this.flowTimeGraph.options },
                show: true,
                id: selectedWidget.id,
                timestampInfo: dateData.toLocaleString(),
                name: selectedWidget.name,
                isSynced: false,
                isSyncing: false,
                type: selectedGraph.type,
                category: "Flow Time",
                average: average,
                allGroupBys: transformedallGroupBys,
                graphCriteria: graphCriteria,
                yAxis: selectedWidget.graphCriteria.yAxis || "",
                itemDaysMap: selectedGraph.type !== "flow-load-graph" ? filteredItems : [],
                itemStatusMap: selectedGraph.type == "flow-load-graph" ? filteredItems : [],
                itemGroupbyMap: {},
                itemTeamsMap: selectedWidget.graphCriteria.itemTeamsMap || {},
                itemSprintsMap: selectedWidget.graphCriteria.itemSprintsMap || {},
                posX: selectedGraph.posX,
                posY: selectedGraph.posY,
                columns: selectedGraph.columns,
                rows: selectedGraph.rows
            };

            this.chartData = processedGraph;

            // Vue.nextTick(() => {
            //     if (this.gridStack) {
            //         let widgetElement = document.getElementById(selectedWidget.id);
            //         this.gridStack.update(widgetElement);
            //     }
            // });
        },

        filteredDataPointsAvg: function (data, selectedGroupBy) {
            if (!_.isEmpty(selectedGroupBy)) {
                let dummyData = data
                    .filter(pair => selectedGroupBy.some(groupBy => groupBy.title === pair[0].split('=')[1].replace('}', '')))
                    .map(pair => pair[1]);

                let sum = dummyData.reduce((acc, val) => acc + val, 0);
                let avg = sum / dummyData.length;
                return avg.toFixed(1);
            }
            return 0;
        },


        //Widget Removal & Duplicate
        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleDuplicateWidget: function () {
			
			this.widgetObj.posX = this.widgetData.posX;
			this.widgetObj.posY = this.widgetData.posY;
			this.widgetObj.columns = this.widgetData.columns;
			this.widgetObj.rows = this.widgetData.rows;
			
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },

        // Graph Detail View on Click of Points
        onClickCFDDataPoints: function (itemIds) {
            this.popupData = [];
            this.popupData.graphType = "Cumulative Flow Diagram";
            this.popupData.graphSpecificType = "cfd";
            this.popupData.itemIds = itemIds;
            this.popupData.total = itemIds.length;
            this.popupData.popupTitle = "Cumulative Flow Diagram - Detail View";
            this.popupData.chartType = "bar";
            disableBodyScroll();
            this.isPopupOpen = true;
        },

        //Syncing of Flow Time Graph
        handleSyncWidget: function (widgetSelected) {
            const data = {
                dashboardId: this.dashboardSelectedId,
                widgetId: this.widgetObj.id
            };
            this.loading = true;
            widgetSelected = this.widgetObj;
            axios.post("/dashboard/syncDashboardWidgetCFD", data)
                .then(response => {
                    if (response.data) {
                        this.boardId = widgetSelected.graphCriteria.boardId;
                        this.sessionBoardId = widgetSelected.graphCriteria.sessionBoardId;
                        this.graphTypeTitle = widgetSelected.graphCriteria.graphTypeTitle;
                        this.optionTypeTitle = widgetSelected.graphCriteria.optionTypeTitle;
                        this.boardTenant = widgetSelected.graphCriteria.selectedBoardTenant;
                        this.xAxis = widgetSelected.graphCriteria.intervals;
                        this.radioButtonSelection = widgetSelected.graphCriteria.radioButtonSelection;
                        this.selectedIssueType = widgetSelected.graphCriteria.selectedIssueType;
                        this.selectedBoardTitle = widgetSelected.graphCriteria.boardTitle;
                        this.issueTypeTitleList = widgetSelected.graphCriteria.issueTypeTitle;
                        this.selectedToStatus = widgetSelected.graphCriteria.fromStatusTitle;
                        this.selectedFromStatus = widgetSelected.graphCriteria.toStatusTitle;
                        this.startDate = widgetSelected.graphCriteria.startDate;
                        this.endDate = widgetSelected.graphCriteria.endDate;
                        this.selectedActiveStatus = widgetSelected.graphCriteria.selectedActiveStatus;
                        this.selectedWaitingStatus = widgetSelected.graphCriteria.selectedInProgressStatus;
                        this.selectedCompletedStatus = widgetSelected.graphCriteria.selectedCompletedStatus;
                        this.boardItemsFilter = widgetSelected.graphCriteria.boardItemsFilter;
                        this.widgetId = widgetSelected.id;
                        this.graphName = widgetSelected.name;
                        this.selectedCondition = widgetSelected.graphCriteria.selectedItems;
                        this.statusListing.startOfSelectedStatus = widgetSelected?.graphCriteria?.selectedItems[0];
                        this.statusListing.endOfSelectedStatus = widgetSelected?.graphCriteria?.selectedItems[1];
                        this.chartType = widgetSelected.graphCriteria.chartType;
                        this.chartTypeName = widgetSelected.graphCriteria.chartTypeName;
                        this.itemtags = widgetSelected.graphCriteria.itemTags;
                        this.itemTagsMeta = widgetSelected.graphCriteria.itemTagsMetaMap;

                        const widgetData = this.makeGraphObjectForFlowTimeDBStorage(response.data);

                        if (!_.isEmpty(widgetData)) {
                            return axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData);
                        } else {
                            throw new Error('Processed widget data is empty');
                        }
                    } else {
                        throw new Error('Response data is empty');
                    }
                })
                .then(response => {
                    const updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    this.initializeFlowTimeGraphData(updatedWidget);
                    this.loading = false;
                    this.chartData.isSyncing = false;
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },

        //Detail List
        handleDetailList: function (data) {
            let selectedGraph = this.widgetData;
            let grouping = selectedGraph.graphCriteria.selectedGroupBy;
            let chartType = "";
            let fromStatusTitle = this.graphCriteria.selectedToStatus
            let toStatusTitle = this.graphCriteria.selectedFromStatus;
            let itemDaysMap = this.chartData.itemDaysMap;
            let itemStatusMap = this.chartData.itemStatusMap;
            let itemTeamsMap = this.chartData.itemTeamsMap;
            let itemSprintsMap = this.chartData.itemSprintsMap;
            let itemGroupbyMap = this.chartData.itemGroupbyMap;
            chartType = this.graphCriteria.chartType;
            this.loadItemsPopup(itemDaysMap, selectedGraph.name, this.chartData.average, this.widgetData.type, fromStatusTitle, toStatusTitle, itemGroupbyMap, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap);
        },

        loadItemsPopup: function (itemDaysMap, graphName, average, graphType, from, to, itemsGroupMap, grouping, itemTeamsMap, itemSprintsMap, chartType,itemStatusMap) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = graphType;
            this.popupData.popupTitle = graphName;
            this.popupData.average = average;
            this.popupData.itemDaysMap = itemDaysMap;
            this.popupData.itemStatusMap = itemStatusMap;
            this.popupData.total = _.size(itemDaysMap);
            this.popupData.grouping = grouping;
            this.popupData.itemTeamsMap = itemTeamsMap;
            this.popupData.itemSprintsMap = itemSprintsMap;
            this.popupData.itemGroupbyMap = itemsGroupMap;
            this.popupData.chartType = chartType;
            this.popupData.fromStatus = from;
            this.popupData.toStatus = to;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            disableBodyScroll();
            this.isPopupOpen = true;
        },

        //Points Click Actions
        onClickDataPoints: function (itemIds, name, toStatus, fromStatus, type,nameOfGroupby) {
            this.popupData = [];
            this.popupData.graphType = "Flow Metrices";
            this.popupData.graphSpecificType = "flow-time-graph"; //"flow-time-graph-detail";
            let idsOfItems = filterItemIdsByName(this.widgetObj.graphCriteria.itemIdsMap, itemIds, nameOfGroupby);
            let filteredItemDaysMap =!_.isEmpty(idsOfItems) ? Object.fromEntries(
                Object.entries(this.widgetObj.graphCriteria.itemDaysMap).filter(([key, value]) => {
                    let itemId = key.split(":")[0].replace("itemId_", "");
                    return idsOfItems?.includes(itemId);
                })
            ):{};
            if(this.widgetObj.graphCriteria.radioButtonSelection === 'statusCategory'){
                if(!_.isEmpty(this.widgetObj.graphCriteria.itemStatusMap)) {
                    let filteredItemStatusMap = !_.isEmpty(idsOfItems) ? Object.fromEntries(
                        Object.entries(this.widgetObj.graphCriteria.itemStatusMap).filter(([key, value]) => {
                            let itemId = key.split(":")[0].replace("itemId_", "");
                            return idsOfItems?.includes(itemId);
                        })
                    ) : {};
                    this.popupData.itemStatusMap = filteredItemStatusMap;
                }
            }
            this.popupData.itemGroupbyMap= this.chartData.itemGroupbyMap;
            this.popupData.itemDaysMap = filteredItemDaysMap;
            this.popupData.total = _.size(filteredItemDaysMap);
            let total = Object.values(filteredItemDaysMap).reduce((sum, value) => sum + value, 0);
            let average = (total / this.popupData.total).toFixed(1);
            this.popupData.average = _.isEmpty(average) ? average == NaN ? 0.0 : average : average;
            this.popupData.popupTitle = name;
            this.popupData.chartType = this.widgetObj.graphCriteria.chartType;
            this.popupData.fromStatus = fromStatus;
            this.popupData.toStatus = toStatus;
            this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
            disableBodyScroll();
            this.isPopupOpen = true;
        },
        handleRerenderWidget: function () {
			let _this = this;
			
			this.setGraphHeight();
			Vue.set(_this.chartData, "show", false);
			Vue.nextTick(()=> {
				Vue.set(_this.chartData, "show", true);
			});
			
		},
        setGraphHeight: function () {
			let unitWidth = this.$el.offsetHeight
			
			let headerHeight = this.$refs.header.offsetHeight;
			let footerHeight = this.$refs.footer.offsetHeight;
			let totalHeightInPixels = unitWidth;
			this.chartData.options.chart.height = totalHeightInPixels - headerHeight - footerHeight;
		}

    },

})