const kendisWidgetCompletedStories = Vue.component('kendis-widget-completed-stories', {
    template: `
    <div style="height: 100%;" class="p-rel">
		<div class="simplifiedgraph">		
		<div v-if="loading" class="loader">
                            <div>
                                <div class="loaderinteg"/>
                                <div>Loading your widget... Please wait a moment.</div>
                            </div>
                        </div> 
		<div v-if="widgetObj.state !== 'new'" class="graphInnerContainer">
		
			<div class="cardHeader">
				<div class="tooltip c-deflt">
	          		<h4 class="cardTitle elips">{{widgetObj.name}}</h4>
	           		<div class="hovtooltip">{{widgetObj.name}}</div>
	          	</div>			      
				<div class="DAJE" v-if="!addWidget">			 
	           		<!-- Graphival View -->
	           		<div class="DAJ c-point ml-10" @click="switchPercentage">
	           			Scope Changes
	           			<span class="switchbtn-clsnw ml-10" :class="showPercentage?'onn':'green'"><span><label></label></span></span>
	           		</div>
	           		<div class="DAJ c-point ml-10" @click="switchCriteria"> 
	           			Estimate 
	           			<span class="switchbtn-clsnw ml-10" :class="showCriteria ? 'onn':'green'"><span><label></label></span></span>
	           		</div>	           		
				</div>
			</div>		
			    
	        <div class="scndheader DFCB">
				<div class="DFA">
				<div class="selectcont sml">
	                 <vz-select 
	                 v-model="filteredSelectedTeams"
	                 :options="filterTeams"        
	                 :multiple="true"  
	                 empty-selection-text="Select Team" 
	                 :selected-title="selectedTeamMessage(filteredSelectedTeams)" 
	                 label="label" 
	                 track-by="value" 
	                 value-type="value" 
	                 @select="onSelectTeamFilterData" />   
				</div>
				<span class="infotxt mht tooltip ml-10">
	                <div class="hovtooltip">Select specific team/s to view their story progress on the graph.</div>
                </span>
				<div class="selectcont sml ml-10">
					<vz-select 
					    :multiple="false" 
					    label="title" 
					    empty-selection-text="Select Program Board Sprint" 
					    class="multi-filter"
					    value-type="object" 
					    v-model="selectedBoardSprint" 
					    :options="boardSprintListing"
					    :show-select-all-on-group=false
					    track-by="id"
					    @select="onSelectSprintFilterData"
					/>
				</div>
				<span class="infotxt mht tooltip ml-10">
	                <div class="hovtooltip">Select specific iteration/s to view story progress during selected iterations/s only.</div>
                </span>
                </div>
                <div class="DFA ml-20">
                	<em class="target-ico-grn mr-10"></em>
                	<div class="button-w trgbtn green mr-20" title="Stories Completed Target">  {{ (!teamTarget || isNaN(teamTarget)) ? "0.00" : Number(teamTarget).toFixed(2) }}% </div>   
                	<em class="mr-10" :class="{'actual-ico-grn': actualPercentage >= teamTarget, 'actual-ico-red': actualPercentage < teamTarget}"></em>
                	<div class="button-w trgbtn" :class="{'green': actualPercentage >= teamTarget, 'red': actualPercentage < teamTarget}" title="Actual"> {{actualPercentage?actualPercentage.toFixed(2):0.00}}%</div>
                </div>
			</div> 
		
			<div class="mt-20">
		    	<div v-if="widgetObj.loading" class="loader"><div><div class="loaderinteg"/></div></div> 
	           <div v-else class="pd-lr-20">
	               <div v-if="errorCase" class="h-full DFA JC">
	                   <div>
	                       <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10" />
	                       <p class="txt-cntr">No Data Available, As per selected Criteria.</p>
	                       <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
	                   	</div>
	               	</div>
						               	
	               	<div class="cntouttbl" :style="{ height: chartData.options.chart.height + 'px' }" v-if="showTable && errorCase === false">
	               	<div class="table brd prow cmpltstory">		               
	                  	<div class="rec hd"> 
	                       <div class="rc c1">Teams</div>  
	                       <div class="rc c2">All Items</div>
	                       <div class="rc c2">Completed</div>              
	                       <div class="rc c2">Tracking (%)</div>       
	                   	</div>
                       	<div class="team-container" v-for="team in allTeams" :key="team">
                            <div class="rec in mn" :style="{ backgroundColor: teamAndColorList[team]+15}">                           
                                <div class="rc c1 pdl" :class="[' ', { 'w-full': teamsDropDown[team] }]" @click="showAdditionalDetails(teamsDropDown,team)">
                                	<span class="arrhtico DIB trnsn" :class="[' ', { 'active': teamsDropDown[team] }]"></span>
                                    <span class="tmlbl ftsb fs-14">{{ team }}</span>
                                    <span class="cbox" :style="{ color: teamAndColorList[team], backgroundColor: teamAndColorList[team]+20}">{{ teamAndLabelList[team] }}</span>
                                </div>
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage">
                                    <div class="cbox gray" @click="handleCombinedCommittedClick(team,committedStoriesBeforeSprint[team],scopeChangeAddedItems[team],scopeChangeRemovedItems[team],'Completion by Teams - Total Committed')">{{committedTeamsData[team]+scopeChangeAdded[team]-scopeChangeRemoved[team] ? committedTeamsData[team]+scopeChangeAdded[team]-scopeChangeRemoved[team] : 0.00}}</div>                                
                                </div>
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage">
                                    <div class="cbox green" @click="handleCombinedDeliveredClick(team,deliveredCommittedStoriesBeforeSprint[team],deliveredScopeChange[team],'Completion by Teams - Total Delivered')">{{ extractNumberBeforeSlash(committedAndScopeChangeTotal[team]) ? extractNumberBeforeSlash(committedAndScopeChangeTotal[team]) : 0.00 }}</div>
                                </div>
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage">
                                    <div class="cbox" @click="handleCombinedCommittedClick(team,committedStoriesBeforeSprint[team],scopeChangeAddedItems[team],scopeChangeRemovedItems[team],'Completion by Teams -Tracking Total Committed')" :class="{'green': scopeChangeDeliveredTracking[team] >= teamTarget, 'red': scopeChangeDeliveredTracking[team] < teamTarget}" > {{scopeChangeDeliveredTracking[team]?scopeChangeDeliveredTracking[team].toFixed(2):0.00}}%</div>
                                </div>
                                
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage===false">
                                    <div class="cbox gray" @click="handleClick(team, committedStoriesBeforeSprint[team],'Completion by Teams - Committed Items')">{{committedTeamsData[team]?committedTeamsData[team]:0}}</div>                                
                                </div>
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage===false">
                                    <div class="cbox green" @click="handleClick(team, deliveredCommittedStoriesBeforeSprint[team],'Completion by Teams - Delivered Committed Stories')">{{ extractNumberBeforeSlash(committedDelivered[team])?extractNumberBeforeSlash(committedDelivered[team]):0 }}</div>                                 
                                 </div>
                                <div class="rc c2" v-if="teamsDropDown[team] ===false && showPercentage===false">
                                    <div class="cbox" @click="handleClick(team, committedStoriesBeforeSprint[team],'Completion by Teams - Tracking Committed Items')" :class="{'green': committedDeliveredTracking[team] >= teamTarget, 'red': committedDeliveredTracking[team] < teamTarget}">{{committedDeliveredTracking[team]?committedDeliveredTracking[team].toFixed(2):0.00}}%</div> 
                                </div>
                                
                                
                           </div>
                           <div class="rec in" v-if="teamsDropDown[team]">                           
                                <div class="rc c1 ftsb fs-14 DFA">Committed:</div>
                                <div class="rc c2">                            	
                                       <div class="cbox gray" @click="handleClick(team, committedStoriesBeforeSprint[team],'Completion by Teams - Committed Items')">{{showCriteria? (committedTeamsData[team]?committedTeamsData[team].toFixed(2):0) : committedTeamsData[team]?committedTeamsData[team]:0}}</div>    
                                </div>
                                <div class="rc c2">                            	
                                       <div class="cbox green" @click="handleClick(team, deliveredCommittedStoriesBeforeSprint[team],'Completion by Teams - Delivered Committed Stories')">{{ extractNumberBeforeSlash(committedDelivered[team])?extractNumberBeforeSlash(committedDelivered[team]):0 }}</div>                                </div>
                                <div class="rc c2">                           		
                                <div class="cbox" @click="handleClick(team, committedStoriesBeforeSprint[team],'Completion by Teams - Tracking Committed Items')" :class="{'green': committedDeliveredTracking[team] >= teamTarget, 'red': committedDeliveredTracking[team] < teamTarget}">{{committedDeliveredTracking[team]?committedDeliveredTracking[team].toFixed(2):0.00}}%</div>
                                </div>
                           </div>
                           <div class="rec in" v-if="teamsDropDown[team]">                           
                                <div class="rc c1 ftsb fs-14 DFA brdnone">Scope Change:</div>
                                <div class="rc c2 DAJ">                            	
                                    <div @click="handleClick(team, scopeChangeAddedItems[team],'Completion by Teams - Scope Change (Added)')"> Added: {{scopeChangeAdded[team]?scopeChangeAdded[team]:0}}</div>
                                </div>
                                <div class="rc c2 DAJ">                            	
                                    <div @click="handleClick(team, deliveredScopeChange[team],'Completion by Teams - Delivered Scope Change Stories')">Added Completed: {{ extractNumberBeforeSlash(scopeChngeDelivered[team]) ?extractNumberBeforeSlash(scopeChngeDelivered[team]) :0 }}</div>
                                </div>
                                <div class="rc c2">                           		
                                    <div 
                                      class="cbox" 
                                      @click="handleClick(team, scopeChangeAddedItems[team], 'Completion by Teams - Tracking Scope Change (Added)')" 
                                      :class="getScopeChangeClass(team)">
                                              {{
                                               isNaN(extractNumberBeforeSlash(scopeChngeDelivered[team])) || 
                                                  isNaN(parseFloat(scopeChangeAdded[team])) || 
                                                   parseFloat(scopeChangeAdded[team]) === 0 
                                                  ? '0.00' 
                                                  : (
                                                      extractNumberBeforeSlash(scopeChngeDelivered[team]) / 
                                                      (scopeChangeAdded[team]) * 100
                                                    ).toFixed(2)
                                              }}%
                                            </div>
                                </div>
                           </div>                           
                           <div class="rec in" v-if="teamsDropDown[team]">                           
                                <div class="rc c1 ftsb fs-14 DFA"></div>
                                <div class="rc c2 DAJ">                            	
                                    <div @click="handleClick(team, scopeChangeRemovedItems[team],'Completion by Teams - Scope Change (Removed)')">Removed: {{scopeChangeRemoved[team]?scopeChangeRemoved[team]:0}}</div>
                                </div>
                                <div class="rc c2">                            	
                                </div>
                                <div class="rc c2">                           		        
                                </div>
                           </div>
                           <div class="rec in" v-if="teamsDropDown[team]">                           
                                <div class="rc c1 ftsb fs-14 DFA">Total:</div>
                                <div class="rc c2">                            	
                                    <div class="cbox gray" @click="handleCombinedCommittedClick(team,committedStoriesBeforeSprint[team],scopeChangeAddedItems[team],scopeChangeRemovedItems[team],'Completion by Teams - Total Committed')">{{Number.isFinite(committedTeamsData[team] + scopeChangeAdded[team] - scopeChangeRemoved[team]) ? (showCriteria ? (committedTeamsData[team] + scopeChangeAdded[team] - scopeChangeRemoved[team]).toFixed(2) : Math.round(committedTeamsData[team] + scopeChangeAdded[team] - scopeChangeRemoved[team])) : 0 }}</div>
                                </div>
                                <div class="rc c2">                            	
                                    <div class="cbox green" @click="handleCombinedDeliveredClick(team,deliveredCommittedStoriesBeforeSprint[team],deliveredScopeChange[team],'Completion by Teams - Total Delivered')">{{ extractNumberBeforeSlash(committedAndScopeChangeTotal[team]) ? extractNumberBeforeSlash(committedAndScopeChangeTotal[team]) : 0.00 }}</div>
                                </div>
                                <div class="rc c2">                           		
                                    <div class="cbox" @click="handleCombinedCommittedClick(team,committedStoriesBeforeSprint[team],scopeChangeAddedItems[team],scopeChangeRemovedItems[team],'Completion by Teams -Tracking Total Committed')" :class="{'green': scopeChangeDeliveredTracking[team] >= teamTarget, 'red': scopeChangeDeliveredTracking[team] < teamTarget}" > {{scopeChangeDeliveredTracking[team]?scopeChangeDeliveredTracking[team].toFixed(2):0.00}}%</div>
                                </div>
                           </div>
                       </div>
	               	</div>
	               	</div> <!-- table End -->
					<chart1 class="chart" style="height: 100%;" v-if="chartData.show && errorCase === false && showTable===false" :options="chartData.options"/>
	              	
	            </div>
		     </div>
		     
		     <div class="cardFooter"> 
             	<div class="DFA gap-1">
                  <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                      <img src="assets/icons/last-update.svg" alt="" />  
                      <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                  </span>
                  <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                      <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: chartData.isSyncing }" class="refreshIcon">
                      <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt=".." class="checkIcon">
                      <div class="hovtooltip ftsb wht-nwrp refreshIconTip">Refresh</div>
                  </div>
                  <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                      <img src="assets/icons/setting3.svg" alt="" />  
                      <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                          <ul v-if="settingsLoading" class="drop_box" style="display: block;cursor: pointer">
                            <li class="loader"><div><div class="loaderinteg"></div></div></li>             
                        </ul> 
                        <ul v-else class="drop_box" style="display: block;cursor: pointer">
                            <li class="boxItem" @click="openEditCriteria()"> 
                                <img src="/assets/icons/Dashboard/edit-gray.svg" alt=".." class="" /> Edit 
                            </li>	
                            <li class="boxItem" @click="handleDuplicateWidget()">  
                                <img src="/assets/icons/Dashboard/dublicate-gray.svg" alt=".." class="" /> Duplicate 
                            </li>							
                            <li class="boxItem" @click="handleRemoveWidget()">  
                                <img src="/assets/icons/Dashboard/delete-gray.svg" alt=".." class="" /> Remove 
                            </li>                          
                        </ul>
                    </vuepopup>
                  </div>
             	</div>
            	<div class="DFA"><span class="DAJ c-point txgrn ml-10" :class="" @click="switchView">Switch View</span></div>
	        </div>
		     
		</div>
		</div>
          
		<kendis-widget-completed-stories-criteria v-if="openSelectionPopup"  :graphTypeOptionTitle = "widgetObj.graphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.graphCriteria.optionTypeTitle" :graphTypeTitle = "widgetObj.graphCriteria.graphTypeTitle" :widgetType = "widgetObj.type" @close="handelCloseSelection" @populate-graph="onClickPopulateGraph"/>
		<kendis-widget-completed-stories-edit-criteria v-if="openEditPopup" :selectedWidget="widgetObj" :dashboardSelected="dashboardSelectedId" @close="openEditPopup=false;"  @updateWidget="onUpdateClick"> </kendis-widget-completed-stories-edit-criteria   >
        <dashboard-list-items-popup v-if="isPopupOpen" @close="closeItemsPopup"  :data="popupData"/>	

    </div>
    `
    ,
    mixins: [rightsMixin],
    props: {widgetData: null, dashboardSelectedId: null, myRole: null},
    data() {
        return {
            allTeams: [],
            teamsDropDown:[],
            filterTeams: [],
            categories: [],
            teamAndColorList:{},
            teamAndLabelList:{},
            boardSprintListing:[],
            series: [],
            updateSprintList:false,
            showTable: false,
            actualPercentage:null,
            targetPercentage: null,
            committedTeamsData: {},
            committedStoriesBeforeSprint: {},
            deliveredCommittedStoriesBeforeSprint:{},
            deliveredScopeChange:{},
            scopeChangeAdded: {},
            scopeChangeAddedItems: {},
            scopeChangeRemovedItems: {},
            scopeChangeRemoved: {},
            committedDelivered: {},
            scopeChngeDelivered: {},
            committedAndScopeChangeTotal: {},
            committedDeliveredTracking: {},
            scopeChangeDeliveredTracking: {},
            showPercentage: true,
            showCriteria:false,
            teamTarget: null,
            settingsLoading: false,
            loading: false,
            boardListing:[],
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            filteredSelectedTeams: [],
            selectedBoardSprint:[],
            //CFD Widget Object Data
            boardTenant: '',
            graphTypeTitle: '',
            optionTypeTitle: '',
            sessionBoardId: '',
            selectedBoard: null,
            startDate: null,
            endDate: null,
            selectedGraph: null,
            graphName: null,
            selectedFilterType: null,
            selectedCondition: null,
            advanceCriteria: null,
            selectedAdvanceCriteria: null,
            issueType: null,
            selectedActiveStatus: null,
            selectedWaitingStatus: null,
            selectedCompletedStatus: null,
            toggleAvgLeadTime: null,
            toggleAvgCycleTime: null,
            toggleAvgWIPTime: null,
            toggleAvgArrivalTime: null,
            toggleAvgThroughputTime: null,
            toggleAdvanceCriteria: null,
            toggleAdvanceCalculation: null,
            xAxis: null,
            radioButtonSelection: null,
            selectedBoardTitle: null,
            selectedFromStatus: null,
            issueTypeTitleList: null,
            advanceCriteria: null,
            selectedAdvanceCriteria: null,
            selectedIssueType: null,
            boardItemsFilter: null,
            selectedIssueTypeTitleMap: null,
            widgetId: null,
            boardId: null,
            storyPointSave:true,
            selectedCompletionStatusTitle:"",
            selectedCompletionStatusIds:[],
            //Chart: Stacked Area chart
            completedStoriesGraph: {
                show: false,
                options: {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: 'Basic Column Chart'
                    },
                    xAxis: {
                        categories: []
                    },
                    tooltip: {
                        shared: true,
                        headerFormat: '<span style="font-size:12px"><b>{point.key}</b></span><br>',
                    },
                    yAxis: {
                        title: {},
                        plotLines: [{
                            value: 3, // The value where the line will be drawn
                            color: 'red', // Color of the line
                            width: 2, // Width of the line
                            zIndex: 5, // Layering of the plot line
                            label: {
                                text: 'Average', // Label for the plot line
                                align: 'right', // Alignment of the label
                                style: {
                                    color: 'red'
                                }
                            }
                        }]
                    },
                    series: []
                }
            },
            chartData: {
                isSynced: false,
                show: true,
                options: new Object(),
                timestampInfo: '',
            },
            //chart criteria details
            graphCriteria: {
                type: "cfd-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            widgetObj: [],
            errorCase: false,
            itemtags: {},
            itemTagsMeta: {},
        }
    },
    components: {
        'kendis-widget-completed-stories-criteria': kendisWidgetCompletedStoriesCriteria,
        'kendis-widget-completed-stories-edit-criteria': kendisWidgetCompletedStoriesEditCriteria,
        'dashboard-list-items-popup': dashboardPopupComponent,

    },
    created() {
    },
    computed: {
        selectedTeamMessage: function () {
            return function (selectedTeam) {
                let teamMessage = "Teams";
                if (selectedTeam) {
                    teamMessage = teamMessage + " (" + selectedTeam.length + ")";
                }
                return teamMessage;
            }
        }
    },

    mounted() {
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.fetchWidgetData();
        }
    },
    methods: {
        getScopeChangeClass(team) {
                const delivered = this.extractNumberBeforeSlash(this.scopeChngeDelivered[team]);
                const added = parseFloat(this.scopeChangeAdded[team]);

                // Ensure valid numbers and avoid division by zero
                const percentage = this.isValidNumber(delivered) && this.isValidNumber(added) && added !== 0
                    ? (delivered / added) * 100
                    : 0.00;

                return {
                    'green': percentage >= this.teamTarget,
                    'red': percentage < this.teamTarget
                };
        },
        isValidNumber(value) {
            return !isNaN(parseFloat(value)) && isFinite(value);
        },
        showAdditionalDetails(teamsDropDown,team){
            this.teamsDropDown[team]=!this.teamsDropDown[team];
        },
        getTextAfterTeam(text) {
            const regex = /Team\s*(.*)/i; // Regex to find 'Team' and everything after it
            const match = text.match(regex);
            return match ? match[1].trim() : ''; // Return the text after 'Team' or an empty string if no match
        },
        extractNumberBeforeSlash(value) {
            if (typeof value !== "string") {
                return null; // Handle non-string inputs gracefully
            }
            const match = value.match(/^(\d+(\.\d+)?)\//); // Capture whole or decimal number before '/'
            return match ? parseFloat(match[1]) : null; // Convert to float and return
        },
        closeItemsPopup(){
            enableBodyScroll();
            this.isPopupOpen = false;
        },
        handleCombinedDeliveredClick(team,committed,scopeAdded,popUpTitle){
            // Ensure committed and scopeAdded are arrays
            const validCommitted = Array.isArray(committed) ? committed : [];
            const validScopeAdded = Array.isArray(scopeAdded) ? scopeAdded : [];

            // Combine the lists
            const combinedList = [...validCommitted, ...validScopeAdded];

            // Pass the combined list to handleClick
            this.handleClick(team, combinedList, popUpTitle);
        },
        handleCombinedCommittedClick(team,committed,scopeAdded,scopeRemoved,popUpTitle){
            const validCommitted = Array.isArray(committed) ? committed : [];
            const validScopeAdded = Array.isArray(scopeAdded) ? scopeAdded : [];

            // Combine the lists
            let combinedList = [...validCommitted, ...validScopeAdded];

            // Remove items from scopeRemoved
            if(scopeRemoved){
                combinedList = combinedList.filter(item => !scopeRemoved.includes(item));
            }

            this.handleClick(team,combinedList,popUpTitle);
        },
        handleClick(team,itemIds,popUptitle){
            if(itemIds!=undefined && itemIds.length>0)
            {
                this.popupData = [];
                this.popupData.sessionBoardId=this.widgetObj.graphCriteria.selectedBoard?this.widgetObj.graphCriteria.selectedBoard.activeSessionBoard:this.widgetObj.graphCriteria.sessionBoardId;
                this.popupData.graphType = "Completion by Teams";
                this.popupData.graphSpecificType = "cs";
                this.popupData.itemIds = itemIds;
                this.popupData.total = itemIds.length;
                this.popupData.radioButtonSelection = this.widgetObj.graphCriteria.radioButtonSelection;
                this.popupData.popupTitle = popUptitle;
                this.popupData.chartType = "bar";
                disableBodyScroll();
                this.isPopupOpen = true;
            }

        },
        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },
        handleSyncWidget: function (widgetSelected) {
            this.showPercentage=true;
            this.showCriteria=false;
            const data = {
                dashboardId: this.dashboardSelectedId,
                widgetId: this.widgetObj.id
            };
            this.loading = true;

            let _this = this;
            var requestId = getNewUUID();
            data.syncId = syncId + "#" + requestId;

            startPoll(requestId, "onSyncCompletionCalculated", _this);
            axios.post("/dashboard/syncDashboardWidgetCS", data)
                .then(response => {
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },
        onSyncCompletionCalculated:function(response){
            if(response.done) {
                let data = JSON.parse(response.requestParam);
                let widgetSelected = this.widgetObj;
                this.boardId = widgetSelected.graphCriteria.boardId;
                this.sessionBoardId = widgetSelected.graphCriteria.sessionBoardId;
                this.graphTypeTitle = widgetSelected.graphCriteria.graphTypeTitle;
                this.optionTypeTitle = widgetSelected.graphCriteria.optionTypeTitle;
                this.boardTenant=widgetSelected.graphCriteria.selectedBoardTenant;
                this.xAxis=widgetSelected.graphCriteria.intervals;
                this.radioButtonSelection = widgetSelected.graphCriteria.radioButtonSelection;
                this.selectedIssueType =  widgetSelected.graphCriteria.selectedIssueType;
                this.selectedBoardTitle = widgetSelected.graphCriteria.boardTitle;
                this.issueTypeTitleList = widgetSelected.graphCriteria.issueTypeTitle;
                this.selectedFromStatus = widgetSelected.graphCriteria.fromStatusTitle;
                this.toggleAvgLeadTime  = widgetSelected.graphCriteria.toggleAvgLeadTime;
                this.toggleAvgCycleTime=widgetSelected.graphCriteria.toggleAvgCycleTime;
                this.toggleAvgWIPTime=widgetSelected.graphCriteria.toggleAvgWIPTime;
                this.toggleAvgArrivalTime=widgetSelected.graphCriteria.toggleAvgArrivalTime;
                this.toggleAvgThroughputTime=widgetSelected.graphCriteria.toggleAvgThroughputTime;
                this.toggleAdvanceCalculation=widgetSelected.graphCriteria.toggleAdvanceCalculation;
                this.toggleAdvanceCriteria=widgetSelected.graphCriteria.toggleAdvanceCriteria;
                this.startDate=widgetSelected.graphCriteria.startDate;
                this.endDate=widgetSelected.graphCriteria.endDate;
                this.selectedActiveStatus=widgetSelected.graphCriteria.selectedActiveStatus;
                this.selectedWaitingStatus=widgetSelected.graphCriteria.selectedInProgressStatus;
                this.selectedCompletedStatus=widgetSelected.graphCriteria.selectedCompletedStatus;
                this.advanceCriteria=widgetSelected.graphCriteria.advanceCriteria;
                this.selectedAdvanceCriteria=widgetSelected.graphCriteria.selectedAdvanceCriteria;
                this.boardItemsFilter=widgetSelected.graphCriteria.boardItemsFilter;
                this.widgetId = widgetSelected.id;
                this.graphName = widgetSelected.name;
                this.selectedCondition = widgetSelected.graphCriteria.selectedItems;
                this.itemtags = widgetSelected.graphCriteria.itemTags;
                this.itemTagsMeta = widgetSelected.graphCriteria.itemTagsMetaMap;
                this.allTeams = data.teams;
                this.teamAndColorList=data.teamAndColorList;
                this.teamAndLabelList=data.teamAndLabelList;
                this.committedStoriesBeforeSprint = data.committedStoriesBeforeSprint;
                this.deliveredCommittedStoriesBeforeSprint=data.deliveredCommittedStoriesBeforeSprint;
                this.deliveredScopeChange=data.deliveredScopeChange;
                this.scopeChangeAddedItems = data.scopeChangeAddedItems;
                this.scopeChangeRemovedItems = data.scopeChangeRemovedItems;
                this.committedDelivered = data.committedDelivered;
                this.scopeChngeDelivered = data.scopeChngeDelivered;
                this.committedAndScopeChangeTotal = data.committedAndScopeChangeTotal;
                this.committedDeliveredTracking = data.committedDeliveredTracking;
                this.scopeChangeDeliveredTracking = data.scopeChangeDeliveredTracking;
                this.committedTeamsData = data.committedTeamsData;
                this.scopeChangeAdded = data.scopeChangeAdded;
                this.scopeChangeRemoved = data.scopeChangeRemoved;
                this.selectedBoard=data.selectedBoard;
                const widgetData = this.makeGraphObjectForDBStorage(data);

                if (!_.isEmpty(widgetData)) {
                    axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData)
                        .then(response => {
                            const updatedWidget = response.data.widget;
                            this.widgetObj = updatedWidget;
                            this.initializeCSGraphData(updatedWidget);
                            this.chartData.isSyncing = false;
                        })
                        .catch(error => {
                            this.errorCase = true;
                            console.error('Error during API call or data processing:', error);
                            this.loading = false;
                        });
                } else {
                    throw new Error('Processed widget data is empty');
                }
            }
        },
        openEditCriteria: function () {
            this.openEditPopup = true;
        },
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //handle the flow for cancel of selection
        handelCloseSelection:function(){
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        switchView: function () {        	
            this.showTable = !this.showTable;
        },
        switchPercentage: function () {
            this.loader=true;
            this.showPercentage = !this.showPercentage;
            this.initializeCSGraphData(this.widgetObj);
            this.loader=false;
        },
        switchCriteria: function () {
            this.showCriteria = !this.showCriteria;
            this.widgetObj.graphCriteria.selectedBoardSprint=this.filterSelectedBoardSprint(this.selectedBoardSprint);
            this.widgetObj.graphCriteria.showCriteria=this.showCriteria;
            this.storyPointSave=false;
            this.onClickPopulateGraph(this.widgetObj.graphCriteria);
            },
        handelCloseSelection: function () {
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        onSelectTeamFilterData() {
            this.initializeCSGraphData(this.widgetObj);
        },
            onSelectSprintFilterData(){
            this.showCriteria = false;
            this.widgetObj.graphCriteria.selectedBoardSprint=this.filterSelectedBoardSprint(this.selectedBoardSprint);
            this.onClickPopulateGraph(this.widgetObj.graphCriteria);
        },
        onUpdateClick(requestBody){
            this.updateSprintList=true;
            this.showCriteria=false;
            this.showPercentage=true;
            this.onClickPopulateGraph(requestBody);
        },
        filterSelectedBoardSprint(selectedBoardSprint) {
            const { id, title, label, startDate, endDate } = selectedBoardSprint;
            return { id, title, label, startDate, endDate };
        },

onClickPopulateGraph: function (requestBody) {
            this.loading = true;
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            let reqBody = {};

            reqBody = {
                selectedCompletionStatus: requestBody.selectedStatusTitle,
                // selectedBoard: requestBody.selectedBoard,
                selectedBoardSprint: requestBody.selectedBoardSprint,
                teamTarget: requestBody.teamTarget,
                sessionBoardId: requestBody.sessionBoardId,
                selectedStatusIds: requestBody.selectedStatusIds!=undefined?requestBody.selectedStatusIds:this.widgetObj.graphCriteria.selectedItems,
                startDate: requestBody.startDate,
                endDate: requestBody.endDate,
                tenant: requestBody.tenant,
                xAxis: requestBody.xAxis,
                advanceCriteria: requestBody.advanceCriteria,
                selectedAdvanceCriteria: requestBody.selectedAdvanceCriteria,
                issueType: requestBody.selectedIssueType,
                selectedActiveStatus: requestBody.selectedActiveStatus,
                selectedWaitingStatus: requestBody.selectedWaitingStatus,
                selectedCompletedStatus: requestBody.selectedCompletedStatus,
                toggleAvgLeadTime: requestBody.toggleAvgLeadTime,
                toggleAvgCycleTime: requestBody.toggleAvgCycleTime,
                toggleAvgWIPTime: requestBody.toggleAvgWIPTime,
                toggleAvgArrivalTime: requestBody.toggleAvgArrivalTime,
                toggleAvgThroughputTime: requestBody.toggleAvgThroughputTime,
                toggleAdvanceCriteria: requestBody.toggleAdvanceCriteria,
                toggleAdvanceCalculation: requestBody.toggleAdvanceCalculation,
                issueTypeMap: requestBody.selectedIssueTypeTitleMap,
                radioButtonSelection: requestBody.radioButtonSelection,
                boardItemsFilter: requestBody.boardItemsFilter,
                dashboardId: this.dashboardSelectedId,
                itemtags: requestBody.itemtags,
                fromStatusTitle:requestBody.selectedStatusTitle,
                selectedItems:requestBody.selectedStatusIds,
                showCriteria:requestBody.showCriteria
            };
            this.selectedBoardSprint=requestBody.selectedBoardSprint;
            this.selectedCompletionStatusIds=requestBody.selectedStatusIds;
            this.selectedCompletionStatusTitle=requestBody.selectedStatusIds;
            this.itemtags = requestBody.itemtags;
            this.itemTagsMeta = requestBody.itemTagsMeta;
            this.boardTenant = requestBody.tenant;
            this.graphTypeTitle = requestBody.graphTypeTitle;
            this.optionTypeTitle = requestBody.optionTypeTitle;
            this.sessionBoardId = requestBody.sessionBoardId;
            this.selectedBoard = requestBody.selectedBoard;
            this.startDate = requestBody.orignalStartDate;
            this.endDate = requestBody.orignalEndDate;
            this.selectedGraph = requestBody.selectedGraph;
            this.graphName = requestBody.graphName;
            this.selectedFilterType = requestBody.selectedFilterType;
            this.selectedCondition = requestBody.selectedStatusIds;
            this.advanceCriteria = requestBody.advanceCriteria;
            this.selectedAdvanceCriteria = requestBody.selectedAdvanceCriteria;
            this.issueType = requestBody.selectedIssueType;
            this.selectedActiveStatus = requestBody.selectedActiveStatus;
            this.selectedWaitingStatus = requestBody.selectedWaitingStatus;
            this.selectedCompletedStatus = requestBody.selectedCompletedStatus;
            this.toggleAvgLeadTime = requestBody.toggleAvgLeadTime;
            this.toggleAvgCycleTime = requestBody.toggleAvgCycleTime;
            this.toggleAvgWIPTime = requestBody.toggleAvgWIPTime;
            this.toggleAvgArrivalTime = requestBody.toggleAvgArrivalTime;
            this.toggleAvgThroughputTime = requestBody.toggleAvgThroughputTime;
            this.toggleAdvanceCriteria = requestBody.toggleAdvanceCriteria;
            this.toggleAdvanceCalculation = requestBody.toggleAdvanceCalculation;
            this.xAxis = requestBody.xAxis;
            this.radioButtonSelection = requestBody.radioButtonSelection;
            this.selectedBoardTitle = requestBody.selectedBoardTitle;
            this.selectedFromStatus = requestBody.selectedStatusTitle;
            this.issueTypeTitleList = requestBody.selectedIssueTypeTitleList;
            this.advanceCriteria = requestBody.advanceCriteria;
            this.selectedAdvanceCriteria = requestBody.selectedAdvanceCriteria;
            this.selectedIssueType = requestBody.selectedIssueType;
            this.boardItemsFilter = requestBody.boardItemsFilter;
            this.selectedIssueTypeTitleMap = requestBody.selectedIssueTypeTitleMap;
            this.widgetId = this.widgetObj.id;
            this.boardId = this.selectedBoard!=undefined?this.selectedBoard._id:this.widgetObj.graphCriteria.boardId;
            this.teamTarget = reqBody.teamTarget;
            reqBody.widgetType = requestBody.optionTypeTitle;
            let _this = this;
            var requestId = getNewUUID();
            reqBody.syncId = syncId + "#" + requestId;
            startPoll(requestId, "onCompletionCalculated", _this);
            axios.post('/dashboard/create-timeseries-data', reqBody)
                .then(response => {
                    //Logic Code in Pooling Callback Method
                })
                .catch(error => {
                    this.errorCase = true;
                    console.error('Error during API call or data processing:', error);
                    this.loading = false;
                });
        },
        onCompletionCalculated: function(response) {
            if(response.done) {
                let data = JSON.parse(response.requestParam);

                this.allTeams = data.teams;
                this.filterTeams = this.allTeams.map(item => {
                    return {
                        value: item,   // value is the actual team name
                        label: item    // label is also the same as value (can be customized if needed)
                    };
                });
                this.filteredSelectedTeams = this.filterTeams.map((team) => team.value);
                this.teamAndColorList = data.teamAndColorList;
                this.teamAndLabelList = data.teamAndLabelList;
                this.committedStoriesBeforeSprint = data.committedStoriesBeforeSprint;
                this.deliveredCommittedStoriesBeforeSprint = data.deliveredCommittedStoriesBeforeSprint;
                this.deliveredScopeChange = data.deliveredScopeChange;
                this.scopeChangeAddedItems = data.scopeChangeAddedItems;
                this.scopeChangeRemovedItems = data.scopeChangeRemovedItems;
                this.committedDelivered = data.committedDelivered;
                this.scopeChngeDelivered = data.scopeChngeDelivered;
                this.committedAndScopeChangeTotal = data.committedAndScopeChangeTotal;
                this.committedDeliveredTracking = data.committedDeliveredTracking;
                this.scopeChangeDeliveredTracking = data.scopeChangeDeliveredTracking;
                this.committedTeamsData = data.committedTeamsData;
                this.scopeChangeAdded = data.scopeChangeAdded;
                this.scopeChangeRemoved = data.scopeChangeRemoved;

                let widgetData;
                let _this = this;
                widgetData = _this.makeGraphObjectForDBStorage(data);

                if (this.storyPointSave) {
                    widgetData.graphCriteria.saveFilter = true;
                } else {
                    widgetData.graphCriteria.saveFilter = false;
                }

                if (!_.isEmpty(widgetData)) {
                    return axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData)
                        .then(response => {
                            this.storyPointSave = true;
                            let updatedWidget = response.data.widget;
                            this.widgetObj = updatedWidget;
                            this.initializeCSGraphData(updatedWidget);
                            this.loading = false;
                        })
                        .catch(error => {
                            console.error('Error during widget save:', error);
                            this.loading = false;
                        });
                } else {
                    throw new Error('Processed widget data is empty');
                }
            }
        },
        makeGraphObjectForDBStorage: function (response) {
            let widgetData = {};
            if (response) {
                let graphDataMap = response.intervals;
                let categories = response.categories;
                let allGroupBys = response.allGroupBysMap;
                let itemStatusMap = response.itemStatusMap;
                let issueTypeMap = response.allIssueTypesMap;
                let itemIdsMap = response.itemIdsMap;
                let relevantdates = response.intervalDates;
                let groupIdColorMap = response.groupIdColorMap;
                let avgCycleTime = "";
                let avgLeadTime = "";
                let avgArrivalTime = "";
                let avgThroughputTime = "";
                let avgWIPTime = "";
                if (response.avgCycleTime) {
                    avgCycleTime = response.avgCycleTime;
                }
                if (response.avgLeadTime) {
                    avgLeadTime = response.avgLeadTime;
                }
                if (response.avgArrivalTime) {
                    avgArrivalTime = response.avgArrivalTime;
                }
                if (response.avgThroughputTime) {
                    avgThroughputTime = response.avgThroughputTime;
                }
                if (response.avgWIPTime) {
                    avgWIPTime = response.avgWIPTime;
                }
                let selectedItems = [];

                if (!_.isEmpty(this.selectedCondition)) {
                    for (let i = 0; i < this.selectedCondition.length; i++) {
                        selectedItems.push(this.selectedCondition[i]);
                    }
                }

                let dataofGraph = {
                    "graphType": "area",
                    "selectedItems": selectedItems.length>0?selectedItems:this.widgetObj.graphCriteria.selectedItems,
                    "boardId": this.boardId,
                    "sessionBoardId": this.sessionBoardId,
                    "graphTypeTitle": this.graphTypeTitle,
                    "optionTypeTitle": this.optionTypeTitle,
                    "selectedBoardTenant": this.boardTenant,
                    "intervals": this.xAxis,
                    "radioButtonSelection": this.radioButtonSelection,
                    "selectedIssueType": this.selectedIssueType,
                    "categories": categories,
                    "boardTitle": this.selectedBoardTitle,
                    "itemStatusMap": itemStatusMap,
                    "issueTypeTitle": this.issueTypeTitleList,
                    "fromStatusTitle": this.selectedFromStatus!=undefined?this.selectedFromStatus:this.widgetObj.graphCriteria.selectedFromStatus,
                    "toggleAvgLeadTime": this.toggleAvgLeadTime,
                    "toggleAvgCycleTime": this.toggleAvgCycleTime,
                    "toggleAvgWIPTime": this.toggleAvgWIPTime,
                    "toggleAvgArrivalTime": this.toggleAvgArrivalTime,
                    "toggleAvgThroughputTime": this.toggleAvgThroughputTime,
                    "toggleAdvanceCalculation": this.toggleAdvanceCalculation,
                    "toggleAdvanceCriteria": this.toggleAdvanceCriteria,
                    "startDate": this.startDate,
                    "endDate": this.endDate,
                    "selectedActiveStatus": _.isEmpty(this.selectedActiveStatus) ? '' : this.selectedActiveStatus,
                    "selectedInProgressStatus": _.isEmpty(this.selectedWaitingStatus) ? [] : this.selectedWaitingStatus,
                    "selectedCompletedStatus": _.isEmpty(this.selectedCompletedStatus) ? [] : this.selectedCompletedStatus,
                    "advanceCriteria": this.advanceCriteria,
                    "selectedAdvanceCriteria": this.selectedAdvanceCriteria,
                    "boardItemsFilter": this.boardItemsFilter,
                    "issueTypeMap": this.selectedIssueTypeTitleMap,
                    "itemTags": this.itemtags,
                    "itemTagsMetaMap": this.itemTagsMeta,
                    "committedDeliveredTracking": this.committedDeliveredTracking,
                    "committedDelivered": this.committedDelivered,
                    "committedAndScopeChangeTotal": this.committedAndScopeChangeTotal,
                    "scopeChangeDeliveredTracking": this.scopeChangeDeliveredTracking,
                    "scopeChngeDelivered": this.scopeChngeDelivered,
                    "committedTeamsData": this.committedTeamsData,
                    "scopeChangeAdded": this.scopeChangeAdded,
                    "scopeChangeRemoved": this.scopeChangeRemoved,
                    "allTeams": this.allTeams,
                    "teamTarget": this.teamTarget,
                    "selectedBoardSprint":this.selectedBoardSprint,
                    "teamAndColorList":this.teamAndColorList,
                    "teamAndLabelList":this.teamAndLabelList,
                    // "selectedBoard":this.selectedBoard,
                    "committedStoriesBeforeSprint":this.committedStoriesBeforeSprint,
                    "deliveredCommittedStoriesBeforeSprint":this.deliveredCommittedStoriesBeforeSprint,
                    "deliveredScopeChange":this.deliveredScopeChange,
                   "scopeChangeAddedItems":this.scopeChangeAddedItems,
                    "scopeChangeRemovedItems":this.scopeChangeRemovedItems,
                };
                widgetData = {
                    name: this.graphName,
                    graphCriteria: dataofGraph,
                    id: this.widgetId,
                    allGroupBys: allGroupBys,
                    state: "old",
                    category: "Completion by Teams",
                }
            }
            return widgetData;
        },
        fetchWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.widgetObj = response.data.widget;
               // this.selectedBoard = {_id: response.data.widget.graphCriteria.sessionBoardId};
                this.initializeCSGraphData(this.widgetObj);
                if (this.filteredSelectedTeams) {
                    this.filteredSelectedTeams = this.filterTeams.map((team) => team.value);
                }
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading single CFD", e);
                this.loading = false;
            });
        },
        initializeCSGraphData: function (data) {
            var processedGraph = {};
            if (data !== null) {
                if (data.type === 'completed-stories') {
                    if (_.isEmpty(data.graphCriteria.categories)) {
                        this.errorCase = true;
                    } else {
                        this.errorCase = false;
                    }
                    this.populateCSChart(data);

                    let timestamp = '';
                    if (data.updatedOn) {
                        timestamp = data.updatedOn;
                    } else {
                        timestamp = data.createdOn;
                    }
                    const dateData = new Date(timestamp);

                    let graphCriteria = {
                        graphType: null,
                        selectedBoardTitle: null,
                        selectedIssueType: null,
                        selectedGroupBy: null,
                        selectedXAxis: null,
                        selectedInterval: null,
                        selectedFromStatus: null,
                        selectedIssueType: null,
                        sessionBoardId: null,

                    };
                    graphCriteria.sessionBoardId = data.graphCriteria.sessionBoardId;
                    graphCriteria.graphType = 'Column';
                    graphCriteria.selectedBoardTitle = data.graphCriteria.boardTitle;
                    //   graphCriteria.selectedIssueType = data.graphCriteria.issueTypeTitle;
                    // graphCriteria.selectedIssueType = issueTypeValues;

                    processedGraph = {
                        options: Object.assign({}, this.completedStoriesGraph.options),
                        show: true,
                        id: data.id,
                        timestampInfo: dateData.toLocaleString(),
                        name: data.name,
                        isSynced: false,
                        isSyncing: false,
                        type: "completed-stories",
                        category: "Completion by Teams",
                        //  allGroupBys: transformedallGroupBys,
                        graphCriteria: graphCriteria,
                        //itemStatusMap: data.graphCriteria.itemStatusMap,
                        //allIssueTypes: transformedIssueTypeallGroupBys,
                        columns: data.columns,
                        rows: data.rows,
                        posX: data.posX,
                        posY: data.posY,
                    };
                    // Ensuring reactivity
                    this.$set(this.chartData, 'show', false);
                    this.$set(this.chartData, 'options', processedGraph.options);
                    this.$set(this.chartData, 'timestampInfo', dateData.toLocaleString());
                    this.$set(this, 'graphCriteria', graphCriteria);
                    this.$set(this, 'addWidget', false);
                    this.$set(this, 'loading', false);
                    let _this = this;
                    this.$nextTick(() => {
                        _this.setGraphHeight();
                        _this.chartData.show = true;
                        this.loading = false;
                    });
                }
            }
        },
        populateCSChart: function (widget) {
            this.initializeCompletedStoriesGraph();
            this.errorCase=false;
            let graphOptions = _.cloneDeep(this.completedStoriesGraph.options);
            if (!_.isEmpty(widget.graphCriteria.teamTarget)) {
                this.teamTarget = widget.graphCriteria.teamTarget;
            }
            if (!_.isEmpty(widget.graphCriteria.selectedBoard)) {
                this.selectedBoard = widget.graphCriteria.selectedBoard;
            }
            if(widget.graphCriteria.sessionBoardId){
                this.getSelectedBoardTeamAndSprintList(false,true,widget.graphCriteria.sessionBoardId);
            }
            if(widget.graphCriteria.teamAndColorList){
                this.teamAndColorList=widget.graphCriteria.teamAndColorList;
                for (let team in this.teamAndColorList) {
                    this.$set(this.teamsDropDown, team, false);
                }
            }
            if(widget.graphCriteria.teamAndLabelList){
                this.teamAndLabelList=widget.graphCriteria.teamAndLabelList;
                for (let team in this.teamAndLabelList) {
                    this.$set(this.teamsDropDown, team, false);
                }
            }
            if (this.showPercentage) {
                graphOptions.xAxis.categories = [];
                graphOptions.series = [];
                if (widget.graphCriteria && widget.graphCriteria.scopeChangeDeliveredTracking) {
                    const keysList = Object.keys(widget.graphCriteria.scopeChangeDeliveredTracking);
                    graphOptions.xAxis.categories = keysList;
                    this.categories = keysList;
                }
                if (widget.graphCriteria && widget.graphCriteria.scopeChangeDeliveredTracking) {
                    const valuesList = Object.values(widget.graphCriteria.scopeChangeDeliveredTracking);

                    const enrichedData = valuesList.map((value, index) => {
                        const teamName = this.categories[index]; // Get team name
                        const teamColor = this.teamAndColorList[teamName] || "#cccccc"; // Use team-specific color or fallback

                        return {
                            y: value,
                            teamTarget: this.teamTarget,
                            color: teamColor, // Assign dynamic color
                            totalCommittedStories:
                                widget.graphCriteria.committedTeamsData[teamName] +
                                widget.graphCriteria.scopeChangeAdded[teamName] -
                                widget.graphCriteria.scopeChangeRemoved[teamName],
                            totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                            showCriteria:this.showCriteria
                        };
                    });


                    graphOptions.series = [
                        {
                            name: 'Scope Change Delivered Tracking',
                            data: enrichedData
                        }
                    ];
                    graphOptions.yAxis={
                        min:0,
                        max:Math.max(this.teamTarget, Math.max(...valuesList)) * 1.1
                    }
                    graphOptions.yAxis.plotLines = [{
                        value: this.teamTarget,
                        color: '#59D',
                        dashStyle: 'shortDash',
                        width: 2
                    }];
                    const total = valuesList.reduce((sum, value) => sum + value, 0);
                    let average = total / valuesList.length;
                    this.actualPercentage = Math.min(average, 100);
                }
            } else {
                if (widget.graphCriteria && widget.graphCriteria.committedDeliveredTracking) {
                    const keysList = Object.keys(widget.graphCriteria.committedDeliveredTracking);
                    graphOptions.xAxis.categories = keysList;
                    this.categories = keysList;
                }
                if (widget.graphCriteria && widget.graphCriteria.committedDeliveredTracking) {
                    const keysList = Object.keys(widget.graphCriteria.committedDeliveredTracking);
                    graphOptions.xAxis.categories = keysList;
                    this.categories = keysList;

                    const valuesList = Object.values(widget.graphCriteria.committedDeliveredTracking);

                    // Add team target for each data point
                    const enrichedData = valuesList.map((value, index) => {
                        const teamName = this.categories[index]; // Get team name
                        const teamColor = this.teamAndColorList[teamName] || ""; // Use team-specific color or fallback

                        return {
                            y: value,
                            teamTarget: this.teamTarget,
                            color: teamColor, // Assign dynamic color
                            totalCommittedStories:
                                widget.graphCriteria.committedTeamsData[teamName] +
                                widget.graphCriteria.scopeChangeAdded[teamName] -
                                widget.graphCriteria.scopeChangeRemoved[teamName],
                            totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                            showCriteria:this.showCriteria
                        };
                    });

                    graphOptions.series = [
                        {
                            name: 'Committed Delivered Tracking',
                            data: enrichedData
                        }
                    ];
                    graphOptions.yAxis={
                        min:0,
                        max:Math.max(this.teamTarget, Math.max(...valuesList)) * 1.1
                    }
                    graphOptions.yAxis.plotLines = [{
                        value: this.teamTarget,
                        color: '#59D',
                        dashStyle: 'shortDash',
                        width: 2
                    }];
                    const total = valuesList.reduce((sum, value) => sum + value, 0);
                    let average = total / valuesList.length;
                    this.actualPercentage = Math.min(average, 100);                }
            }

            if (widget.graphCriteria) {
                if (!_.isEmpty(widget.graphCriteria.allTeams)) {
                    this.allTeams = widget.graphCriteria.allTeams;
                    this.filterTeams = this.allTeams.map(item => {
                        return {
                            value: item,   // value is the actual team name
                            label: item    // label is also the same as value (can be customized if needed)
                        };
                    });
                }
                if (!_.isEmpty(widget.graphCriteria.committedStoriesBeforeSprint)) {
                    this.committedStoriesBeforeSprint = widget.graphCriteria.committedStoriesBeforeSprint;
                }
                if (!_.isEmpty(widget.graphCriteria.deliveredScopeChange)) {
                    this.deliveredScopeChange = widget.graphCriteria.deliveredScopeChange;
                }
                if (!_.isEmpty(widget.graphCriteria.deliveredCommittedStoriesBeforeSprint)) {
                    this.deliveredCommittedStoriesBeforeSprint = widget.graphCriteria.deliveredCommittedStoriesBeforeSprint;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChangeAddedItems)) {
                    this.scopeChangeAddedItems = widget.graphCriteria.scopeChangeAddedItems;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChangeRemovedItems)) {
                    this.scopeChangeRemovedItems = widget.graphCriteria.scopeChangeRemovedItems;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChangeAdded)) {
                    this.scopeChangeAdded = widget.graphCriteria.scopeChangeAdded;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChangeRemoved)) {
                    this.scopeChangeRemoved = widget.graphCriteria.scopeChangeRemoved;
                }
                if (!_.isEmpty(widget.graphCriteria.committedDelivered)) {
                    this.committedDelivered = widget.graphCriteria.committedDelivered;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChngeDelivered)) {
                    this.scopeChngeDelivered = widget.graphCriteria.scopeChngeDelivered;
                }
                if (!_.isEmpty(widget.graphCriteria.committedAndScopeChangeTotal)) {
                    this.committedAndScopeChangeTotal = widget.graphCriteria.committedAndScopeChangeTotal;
                }
                if (!_.isEmpty(widget.graphCriteria.committedDeliveredTracking)) {
                    this.committedDeliveredTracking = widget.graphCriteria.committedDeliveredTracking;
                }
                if (!_.isEmpty(widget.graphCriteria.scopeChangeDeliveredTracking)) {
                    this.scopeChangeDeliveredTracking = widget.graphCriteria.scopeChangeDeliveredTracking;
                }
                if (!_.isEmpty(widget.graphCriteria.committedTeamsData)) {
                    this.committedTeamsData = widget.graphCriteria.committedTeamsData;
                }
                if (this.filteredSelectedTeams != undefined && this.filteredSelectedTeams.length > 0) {
                    if (!_.isEmpty(this.allTeams)) {
                        this.allTeams = this.allTeams.filter(team => this.filteredSelectedTeams.includes(team));

                    }
                    if (!_.isEmpty(this.committedStoriesBeforeSprint)) {
                        this.committedStoriesBeforeSprint = Object.keys(this.committedStoriesBeforeSprint)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.committedStoriesBeforeSprint[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.deliveredCommittedStoriesBeforeSprint)) {
                        this.deliveredCommittedStoriesBeforeSprint = Object.keys(this.deliveredCommittedStoriesBeforeSprint)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.deliveredCommittedStoriesBeforeSprint[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }if (!_.isEmpty(this.deliveredScopeChange)) {
                        this.deliveredScopeChange = Object.keys(this.deliveredScopeChange)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.deliveredScopeChange[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.scopeChangeAddedItems)) {
                        this.scopeChangeAddedItems = Object.keys(this.scopeChangeAddedItems)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChangeAddedItems[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.scopeChangeRemovedItems)) {
                        this.scopeChangeRemovedItems = Object.keys(this.scopeChangeRemovedItems)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChangeRemovedItems[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.scopeChangeAdded)) {
                        this.scopeChangeAdded = Object.keys(this.scopeChangeAdded)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChangeAdded[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.scopeChangeRemoved)) {
                        this.scopeChangeRemoved = Object.keys(this.scopeChangeRemoved)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChangeRemoved[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.committedDelivered)) {
                        this.committedDelivered = Object.keys(this.committedDelivered)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.committedDelivered[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.scopeChngeDelivered)) {
                        this.scopeChngeDelivered = Object.keys(this.scopeChngeDelivered)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChngeDelivered[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.committedAndScopeChangeTotal)) {
                        this.committedAndScopeChangeTotal = Object.keys(this.committedAndScopeChangeTotal)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.committedAndScopeChangeTotal[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                    if (!_.isEmpty(this.committedDeliveredTracking)) {
                        this.committedDeliveredTracking = Object.keys(this.committedDeliveredTracking)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.committedDeliveredTracking[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                        if (this.showPercentage == false) {
                            const keysList = Object.keys(this.committedDeliveredTracking);
                            graphOptions.xAxis.categories = keysList;
                            this.categories = keysList;

                            const valuesList = Object.values(this.committedDeliveredTracking);
                            const enrichedData = valuesList.map((value, index) => {
                                const teamName = this.categories[index]; // Get team name
                                const teamColor = this.teamAndColorList[teamName] || ""; // Use team-specific color or fallback

                                return {
                                    y: value,
                                    teamTarget: this.teamTarget,
                                    color: teamColor, // Assign dynamic color
                                    totalCommittedStories:
                                        widget.graphCriteria.committedTeamsData[teamName] +
                                        widget.graphCriteria.scopeChangeAdded[teamName] -
                                        widget.graphCriteria.scopeChangeRemoved[teamName],
                                    totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                                    showCriteria:this.showCriteria

                                };
                            });
                            graphOptions.series = [
                                {
                                    name: 'Committed Delivered Tracking',
                                    data: enrichedData
                                }
                            ];
                        }

                    }
                    if (!_.isEmpty(this.scopeChangeDeliveredTracking)) {
                        this.scopeChangeDeliveredTracking = Object.keys(this.scopeChangeDeliveredTracking)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.scopeChangeDeliveredTracking[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                        if (this.showPercentage) {
                            const keysList = Object.keys(this.scopeChangeDeliveredTracking);
                            graphOptions.xAxis.categories = keysList;
                            this.categories = keysList;

                            const valuesList = Object.values(this.scopeChangeDeliveredTracking);
                            const enrichedData = valuesList.map((value, index) => {
                                const teamName = this.categories[index]; // Get team name
                                const teamColor = this.teamAndColorList[teamName] || "#cccccc"; // Use team-specific color or fallback

                                return {
                                    y: value,
                                    teamTarget: this.teamTarget,
                                    color: teamColor, // Assign dynamic color
                                    totalCommittedStories:
                                        widget.graphCriteria.committedTeamsData[teamName] +
                                        widget.graphCriteria.scopeChangeAdded[teamName] -
                                        widget.graphCriteria.scopeChangeRemoved[teamName],
                                    totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                                    showCriteria:this.showCriteria
                                };
                            });
                            graphOptions.series = [
                                {
                                    name: 'Scope Change Delivered Tracking',
                                    data: enrichedData
                                }
                            ];
                        }

                    }
                    if (!_.isEmpty(this.committedTeamsData)) {
                        this.committedTeamsData = Object.keys(this.committedTeamsData)
                            .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                            .reduce((acc, key) => {
                                acc[key] = this.committedTeamsData[key]; // Add the matching key-value pair to the result
                                return acc;
                            }, {});
                    }
                }
                else if(this.filteredSelectedTeams == undefined) {
                    this.errorCase=true;
                    // if (!_.isEmpty(this.allTeams) && (this.filteredSelectedTeams!=undefined || this.filteredSelectedTeams!=null)) {
                    //     this.allTeams = this.allTeams.filter(team => this.filteredSelectedTeams.includes(team));
                    //
                    // }
                    // if (!_.isEmpty(this.committedStoriesBeforeSprint)) {
                    //     this.committedStoriesBeforeSprint = Object.keys(this.committedStoriesBeforeSprint)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.committedStoriesBeforeSprint[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.deliveredCommittedStoriesBeforeSprint)) {
                    //     this.deliveredCommittedStoriesBeforeSprint = Object.keys(this.deliveredCommittedStoriesBeforeSprint)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.deliveredCommittedStoriesBeforeSprint[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.deliveredScopeChange)) {
                    //     this.deliveredScopeChange = Object.keys(this.deliveredScopeChange)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.deliveredScopeChange[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.scopeChangeAddedItems)) {
                    //     this.scopeChangeAddedItems = Object.keys(this.scopeChangeAddedItems)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChangeAddedItems[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.scopeChangeRemovedItems)) {
                    //     this.scopeChangeRemovedItems = Object.keys(this.scopeChangeRemovedItems)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChangeRemovedItems[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.scopeChangeAdded)) {
                    //     this.scopeChangeAdded = Object.keys(this.scopeChangeAdded)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChangeAdded[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.scopeChangeRemoved)) {
                    //     this.scopeChangeRemoved = Object.keys(this.scopeChangeRemoved)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChangeRemoved[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.committedDelivered)) {
                    //     this.committedDelivered = Object.keys(this.committedDelivered)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.committedDelivered[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.scopeChngeDelivered)) {
                    //     this.scopeChngeDelivered = Object.keys(this.scopeChngeDelivered)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChngeDelivered[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.committedAndScopeChangeTotal)) {
                    //     this.committedAndScopeChangeTotal = Object.keys(this.committedAndScopeChangeTotal)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.committedAndScopeChangeTotal[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                    // if (!_.isEmpty(this.committedDeliveredTracking)) {
                    //     this.committedDeliveredTracking = Object.keys(this.committedDeliveredTracking)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.committedDeliveredTracking[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    //     if (this.showPercentage == false) {
                    //         const keysList = Object.keys(this.committedDeliveredTracking);
                    //         graphOptions.xAxis.categories = keysList;
                    //         this.categories = keysList;
                    //
                    //         const valuesList = Object.values(this.committedDeliveredTracking);
                    //         const enrichedData = valuesList.map((value, index) => {
                    //             const teamName = this.categories[index]; // Get team name
                    //             const teamColor = this.teamAndColorList[teamName] || ""; // Use team-specific color or fallback
                    //
                    //             return {
                    //                 y: value,
                    //                 teamTarget: this.teamTarget,
                    //                 color: teamColor, // Assign dynamic color
                    //                 totalCommittedStories:
                    //                     widget.graphCriteria.committedTeamsData[teamName] +
                    //                     widget.graphCriteria.scopeChangeAdded[teamName] -
                    //                     widget.graphCriteria.scopeChangeRemoved[teamName],
                    //                 totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                    //             };
                    //         });
                    //         graphOptions.series = [
                    //             {
                    //                 name: 'Committed Delivered Tracking',
                    //                 data: enrichedData
                    //             }
                    //         ];
                    //     }
                    //
                    // }
                    // if (!_.isEmpty(this.scopeChangeDeliveredTracking)) {
                    //     this.scopeChangeDeliveredTracking = Object.keys(this.scopeChangeDeliveredTracking)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.scopeChangeDeliveredTracking[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    //     if (this.showPercentage) {
                    //         const keysList = Object.keys(this.scopeChangeDeliveredTracking);
                    //         graphOptions.xAxis.categories = keysList;
                    //         this.categories = keysList;
                    //
                    //         const valuesList = Object.values(this.scopeChangeDeliveredTracking);
                    //         const enrichedData = valuesList.map((value, index) => {
                    //             const teamName = this.categories[index]; // Get team name
                    //             const teamColor = this.teamAndColorList[teamName] || "#cccccc"; // Use team-specific color or fallback
                    //
                    //             return {
                    //                 y: value,
                    //                 teamTarget: this.teamTarget,
                    //                 color: teamColor, // Assign dynamic color
                    //                 totalCommittedStories:
                    //                     widget.graphCriteria.committedTeamsData[teamName] +
                    //                     widget.graphCriteria.scopeChangeAdded[teamName] -
                    //                     widget.graphCriteria.scopeChangeRemoved[teamName],
                    //                 totalDeliveredStories: widget.graphCriteria.committedAndScopeChangeTotal[teamName].split('/')[0],
                    //             };
                    //         });
                    //         graphOptions.series = [
                    //             {
                    //                 name: 'Scope Change Delivered Tracking',
                    //                 data: enrichedData
                    //             }
                    //         ];
                    //     }
                    //
                    // }
                    // if (!_.isEmpty(this.committedTeamsData)) {
                    //     this.committedTeamsData = Object.keys(this.committedTeamsData)
                    //         .filter(key => this.filteredSelectedTeams.includes(key)) // Check if the key exists in the list
                    //         .reduce((acc, key) => {
                    //             acc[key] = this.committedTeamsData[key]; // Add the matching key-value pair to the result
                    //             return acc;
                    //         }, {});
                    // }
                }


            }
            if(graphOptions.series.length>0 && graphOptions.series[0].data.length>0){
                this.completedStoriesGraph.options = graphOptions;
            }
            else{
                this.errorCase=true;
            }



        },
        initializeCompletedStoriesGraph: function () {
            let _this = this;
            this.completedStoriesGraph = {
                show: false,
                options: {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: 'Basic Column Chart'
                    },
                    xAxis: {
                        categories: []
                    },
                    tooltip: {
                        shared: true,
                        useHTML: true,
                        backgroundColor: 'rgba(255, 255, 255, 0.9)',
                        borderColor: '#ccc',
                        borderRadius: 5,
                        borderWidth: 1,
                        shadow: true,
                        style: {
                            padding: '10px',
                            color: '#333',
                            fontSize: '12px'
                        },
                        formatter: function () {
                            const teamTarget = this.points[0].point.options.teamTarget || 'N/A';
                            const committedStories = this.points[0].point.options.totalCommittedStories || 'N/A';
                            const totalDeliveredStories = this.points[0].point.options.totalDeliveredStories || 'N/A';
                            const showCriteria = this.points[0].point.options.showCriteria;
                            return `
                                <div style="color: #333; font-size: 12px;">
                                    Team : <strong>${this.x}</strong><br/>
                                    Percentage number : <strong>${this.y?this.y.toFixed(2):0.00}</strong><br/>
                                    ${showCriteria ? `Total Estimates: <strong>${committedStories}</strong><br/>` : `Total Stories: <strong>${committedStories}</strong><br/>`}
                                    ${showCriteria ? `Delivered Estimates: <strong>${totalDeliveredStories}</strong><br/>` : `Delivered Stories: <strong>${totalDeliveredStories}</strong><br/>`}
                                    Sprint Target: <strong>${teamTarget}%</strong><br/>
                                </div>
                            `;
                        }
                    },
                    yAxis: {
                        title: {},
                        plotLines: [{
                            value: 3, // The value where the line will be drawn
                            color: 'red', // Color of the line
                            width: 2, // Width of the line
                            zIndex: 5, // Layering of the plot line
                            label: {
                                text: 'Average', // Label for the plot line
                                align: 'right', // Alignment of the label
                                style: {
                                    color: 'red'
                                }
                            }
                        }]
                    },
                    plotOptions: {
                        column: {
                            point: {
                                events: {
                                    click: function () {
                                        _this.switchView();
                                    }
                                }
                            }
                        }
                    },
                    series: []
                }
            };
        },
        handleDuplicateWidget: function () {

            this.widgetObj.posX = this.widgetData.posX;
            this.widgetObj.posY = this.widgetData.posY;
            this.widgetObj.columns = this.widgetData.columns;
            this.widgetObj.rows = this.widgetData.rows;

            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },handleRerenderWidget: function () {
            let _this = this;
            this.setGraphHeight();
            Vue.set(_this.widgetObj, "loading", true);
            Vue.nextTick(() => {
                Vue.set(_this.widgetObj, "loading", false);
            });
        },
        setGraphHeight: function () {
            let unitWidth = this.$el.offsetHeight
            this.chartData.options.chart.height = unitWidth - 180;
        },
        handleRerenderWidget: function () {
            let _this = this;

            this.setGraphHeight();
            Vue.set(_this.chartData, "show", false);
            Vue.nextTick(() => {
                Vue.set(_this.chartData, "show", true);
            });

        },
        getSelectedBoardTeamAndSprintList : function(teamFlag,sprintFlag,sessionId){
            let requestBody = {};
            if(teamFlag){
                requestBody['teams'] = 'teams';
            }

            if(sprintFlag){
                requestBody['sprints'] = 'sprints';
            }

            let _this = this;
            let boardId = sessionId;
            axios.post('/dashboard/get-board-teams-sprints/'+ boardId , requestBody)
                .then(response => {

                    try{
                        if (response.data) {

                            this.populateTeamsAndSprintData(response.data,requestBody);
                        }
                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
                handleErrorSprintReportMsg(error);
            });
        },
        populateTeamsAndSprintData : function(response,requestBody){

            if(requestBody['teams']){

                let teamSequence = response['teamSequence'];
                let teamsGroupBy = _.groupBy(response['teams'],'_id');

                for(let teamId of teamSequence){

                    this.boardTeamListing.push(teamsGroupBy[teamId][0]);
                }
            }

            if(requestBody['sprints'] && (this.boardSprintListing.length==0 ||this.updateSprintList==true)){
                this.updateSprintList=false;
                this.boardSprintListing = response["sprints"];
                this.boardSprintListing=this.boardSprintListing.filter(sprint =>sprint.startDate && sprint.endDate);

                const currentDate = Date.now(); // Current date in milliseconds

                if(this.widgetObj.graphCriteria.selectedBoardSprint){
                    this.selectedBoardSprint=this.widgetObj.graphCriteria.selectedBoardSprint;
                }
                else{
                    this.selectedBoardSprint = this.boardSprintListing.find(sprint =>
                        currentDate >= sprint.startDate && currentDate <= sprint.endDate
                    );
                }
                const getDateOnly = timestamp => {
                    const date = new Date(timestamp);
                    return new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime();
                };
                this.boardSprintListing = this.boardSprintListing.filter(sprint => {
                    return sprint.startDate && getDateOnly(sprint.startDate) <= currentDate;
                });

                if (!this.selectedBoardSprint) {
                    // If no sprint matches the current date, find the closest sprint
                    this.selectedBoardSprint = this.boardSprintListing.reduce((closest, sprint) => {
                        const currentDiff = Math.abs(sprint.startDate - currentDate);
                        const closestDiff = closest ? Math.abs(closest.startDate - currentDate) : Infinity;

                        return currentDiff < closestDiff ? sprint : closest;
                    }, null);
                }
            }
        },
    }
}
)