const kendisWidgetCollectionColumn = Vue.component('kendis-widget-collection-column', {
    template: `
    <div style="height: 100%;">        
        <div class="cfdGraphCard">
            <div v-if="loading" class="loader">
              <div>
                <div class="loaderinteg"/>
              </div>
            </div> 
            <div v-if="widgetObj.state !== 'new'" class="graphInnerContainer">
                <div class="cardHeader" ref="header">
                    <div>
                        <div class="tooltip c-deflt" :style="{ maxWidth: titleWidth + 'px' }">
                            <h4 class="cardTitle" :style="{ maxWidth: titleWidth + 'px' }">
                               {{widgetObj.name}}  
                            </h4>
                            <div class="hovtooltip">
                                {{widgetObj.name}}
                            </div>
                        </div>
                                
                        <div v-if="!addWidget" class="tooltip criteria">
                            <p class="clickable-text">Criteria Details</p>
                            <div class="hovtooltip criteriaDetailTip">
                                <div class="graphName">{{widgetObj.category}}</div>
                                <criteria-details-pie :releaseTrainId="releaseTrainId" :groupTitle="groupTitle"  :graphCriteria="collectionsGraphCriteria" :type ="!_.isEmpty(widgetObj.type) ? widgetObj.type:''"/>                                          
                            </div>
                        </div>
                    </div> 
                <div class="DFA filterOptions">   
                <div v-if="!errorCase" class="DFA">   
					<div class="rec lblm">
                        <div class="DF">
                        <div class="selectcont nwsl FL rnd4">
                             <vz-select 
                                v-if="$options.filterOptions != undefined && $options.filterOptions.length > 0"
                                :multiple="true" 
                                :empty-selection-text="selectedFilterMessage()"
                                :selected-title="selectedFilterMessage()" 
                                class="multi-filter" 
                                value-type="object"
                                :options="$options.filterOptions"
                                v-model="filterColumn.selected"
                                @select="onFilterAndFormatChange(filterColumn.selected, selectedOption)" 
                                @close=""
                             />
                             </div>
                             <span class="tooltip ml-10 dropTip nxt">
<!--                                <em class="infotxt"></em> -->
                                <span class="hovtooltip">
<!--                                  Use this dropdown to flexibly hide or show groups in the widget, tailoring the view to your needs.-->
                                </span>
                             </span>
                        </div>
                    </div>
            
                    <div class="rec lblm">
                        <div class="DF">
                          <div class="selectcont nwsl FL rnd4">
                            <vz-select 
                              v-if="options != undefined && options.length > 0"
                              v-model="selectedOption" 
                              class="format-dropdown"
                              :options="options" 
                              empty-selection-text="Select Option" 
                              label="label" 
                              track-by="value" 
                              value-type="object" 
                              @close=""
                              @select="onFilterAndFormatChange(filterColumn.selected, selectedOption)" 
                            />
                          </div>
                          <span class="tooltip ml-10 dropTip nxt">
<!--                            <em class="infotxt"></em> -->
                            <span class="hovtooltip">
<!--                              Select the data visualization format-->
                            </span>
                          </span>
                        </div>    
                        </div>              
                     </div>
                    </div>
                    </div>                       
                    <div v-if="errorCase" class="h-full DFA JC">
                        <div>
                            <img src="/assets/icons/Dashboard/empty-widget-item.svg" alt=".." class="mr-10">
                            <p class="txt-cntr">Criteria not fulfilled. Try with different selection criteria. </p>
                            <p class="txt-cntr"><a class="und c-point" href="#">Learn more</a></p>
                        </div>
                    </div>
            <div v-if="chartData && chartData.options?.series?.[0]?.data?.length < 1 && errorCase === false" class="nofound fs-14">
                {{ noDataMsg }}
            </div> 
           <chart1 class="chart" v-if="chartData.show && errorCase === false && chartData.options?.series?.[0]?.data?.length > 0"  :options="chartData.options"></chart1>
           <div class="cardFooter" ref="footer"> 
               <div class="DFA gap-1">
                    <span class="tooltip DF c-point lastUpdate iconContainer" v-if="!addWidget">
                        <img src="assets/icons/last-update.svg" alt="" />  
                        <span class="hovtooltip refreshTime">Last Updated At:{{chartData.timestampInfo}} </span>
                    </span>
                    <div class="refresh c-point tooltip iconContainer" @click="handleSyncWidget()" v-if="dashboardActionAllowed(myRole,'SyncWidget') && !addWidget">
                        <img v-if="chartData.isSynced == false" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: chartData.isSyncing }" class="refreshIcon" />
                        <img v-if="chartData.isSynced " src="/assets/icons/new/check.svg" alt=".." class="checkIcon" />
                        <div class="hovtooltip ftsb wht-nwrp refreshIconTip">Refresh</div>
                    </div>
                    <div class="settingsContainer c-point iconContainer" @click="handleSettingsClick" v-if="dashboardActionAllowed(myRole,'WidgetSettings') && !addWidget">
                        <img src="assets/icons/setting3.svg" alt="Settings" />  
                        <vuepopup v-if="showGraphSettings" @close="showGraphSettings = false;">
                            <ul v-if="settingsLoading" class="drop_box" style="display: block; cursor: pointer">
                                <li class="loader"><div><div class="loaderinteg"/></div></li>             
                            </ul> 
                            <ul v-else class="drop_box" style="display: block;cursor: pointer">
                                <li class="boxItem" @click="openEditCriteria()"> <img src="/assets/icons/Dashboard/edit-gray.svg" alt="Edit" /> Edit </li>	
                                <li class="boxItem" @click="handleDuplicateWidget()"><img src="/assets/icons/Dashboard/dublicate-gray.svg" alt="Duplicate" /> Duplicate </li>							
                                <li class="boxItem" @click="handleRemoveWidget()"><img src="/assets/icons/Dashboard/delete-gray.svg" alt="Remove" /> Remove </li>                          
                            </ul>
                        </vuepopup>
                    </div>
                    <div class="settingsContainer c-point iconContainer" @click="handleRemoveWidget()" v-if="addWidget">
                        <img src="/assets/icons/Dashboard/delete-gray.svg" alt="Delete" />  
                    </div>             
               </div>
              <p v-if="!addWidget" @click = "handleDetailList()" class="clickable-text">Detail List</p>
           </div>		        
        </div>
        <kendis-widget-collection-pie-col-criteria v-if="openSelectionPopup || openEditPopup" :graphWidth="updatedGraphWidth" :graphTypeOptionTitle = "widgetObj.collectionsGraphCriteria.graphTypeOptionTitle" :optionTypeTitle = "widgetObj.category"  :selectedWidget="widgetObj"  :editMode ="openEditPopup"  :graphTypeTitle = "widgetObj.collectionsGraphCriteria.graphTypeTitle" :widgetType = "widgetObj.type"  @editClose ="handleEditClosure" @close="handelCloseSelection" @populate-graph="loadBacklogItems"/>
        <backlog-items-popup 
            v-if="isPopupOpen" 
            :collType="collectionType"
            :releaseTrain="releaseTrain"
            :kenCustomFields="kendisCustomFields"
            @close="closeItemsPopup"
            :filter="errorCase ? {} : collectionsGraphCriteria" 
            :group="errorCase ? {} : group" 
            :level="errorCase ? null : widgetObj.collectionsGraphCriteria.hierarchyLevel" 
            :data="data" 
            :releaseTrainId="widgetObj.collectionsGraphCriteria.releaseTrainId" 
            :widget = "widgetObj"
            :groupStat="errorCase ? {} : groupStat"
            :filterCriteria="filter"
            :groups="groups"
            :groupsWithIds="groupsWithIds"
            :itemType="itemType"
        />	
    </div>        
</div>
`,
    mixins:[rightsMixin],

//Data Used
    props: {widgetData: null, dashboardSelectedId: null,myRole:null, globalColorsMap: null},

    data() {
        return {
            releaseTrain: null,
            kendisCustomFields:[],
            noDataMsg: 'No Data',
            graphName:"",
            selectedCollection:{},
            selectedGraph:"",
            selectedCondition:[],
            conditionsList:[],
            settingsLoading:false,
            loading: false,
            addWidget: false,
            showGraphSettings: false,
            openSelectionPopup: false,
            openEditPopup: false,
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            chartData: {
                show: false,
                options: {},
                isSynced: false,
                timestampInfo: '',
            },
            //chart criteria details
            collectionsGraphCriteria: {
                type:"cycle-time-graph",
            },
            //popup data
            popupData: [],
            isPopupOpen: false,
            groupBySelected: [],

            //Chart Object
            pieChart: {
                show: false,
                options: {
                    chart: {
                        type: 'column',
                        height: 0,
                    },
                    title: {
                        text: 'Gradient Fill Column Chart'
                    },
                    plotOptions: {
                        column: {
                            dataLabels: {
                                enabled: true,
                                format: '{point.name}: {point.percentage:.1f} %'
                            }
                        }
                    },
                    series: [],
                }
            },
            widgetObj:[],
            chartType:"",
            errorCase:false,
            itemtags:{},
            itemTagsMeta:{},
            conditionsList : [],
            selectedCondition :  [],
            selectedGraph : '',
            graphName :'',
            selectedCollectionId : '',
            groupBy:{},
            $options:{filterOptions:[]},
            filterColumn: {
                selected: [],
                selectedMap: {}
            },
            selectedOption: { value: 'number', label: 'Number' },
            options: [
                { value: 'number', label: 'Number' },
                { value: 'percentage', label: 'Percentage' }
            ],
            originalChartDataOptions: {},
            collectionName:'',
            filterName:'',
            releaseTrainId:null,
            filterId:null,
            selectedFilter:null,
            hierarchylevel:null,
            groups:[],
            columns:["status", "children", "estimate", "boards"],
            data:{},
            type: '',
            groupTitle: '',
            group: null,
            teamAndColorList: null,
            hierarchyLevelId: null,
            groupStat: {},
            filter: null,
            collectionType: "",
            titleWidth: 400,
            updatedGraphWidth: 950,
            itemType: "",
            groupIdColorMap: null,
            colors: [ "#E3554E", "#E3554E","#E64735","#D83E34","#C6352E","#B92F27","#AA241C","#FF949D","#F03F3D","#F11F15", "#D30A00","#E6357C",
                "#E69F35","#DD527C","#D83E67","#C73A63","#B1365D","#9C3258","#752B4C","#FFA4C4","#F56193","#EB2B65", "#BE0E46","#D83EB4",
                "#D8623E","#A251B2","#9238A4","#85349E","#732E95","#64298B","#47217A","#F3B8FF","#D379E4","#B436CD", "#6C079D","#5C38A4",
                "#A43880","#7A5CB6","#6441A9","#5B3CA3","#4F349A","#452E91","#342381","#CFB9FF","#A180E8","#370CAC", "#4152A9","#4152A9",
                "#606DB3","#4554A7","#3F4C9D","#364292","#2F3885","#23276F","#C0CCFF","#8D9FEF","#546EFB","#162BB2", "#4585A7","#6745A7",
                "#5DA3E7","#4B94E3","#4587D5","#3E75C3","#3764B0","#2C4790","#9FD3FF","#7AC2FF","#339AFF","#2069D0","#4BE0E3","#4E4BE3"
                ,"#57C3D5","#52B9CD","#4CA9BA","#4594A1","#408089","#355C5F","#ADF5FF","#72E3F4","#14DDFF","#00A5C0","#52CDA4","#527BCD"
                ,"#4CA398","#409387","#3B867A","#36766A","#31665C","#294A41","#B0F4ED","#6EE1D4","#16CAB3","#097B66","#40935D","#407693",
                "#94C06A","#82B552","#74A64A","#629240","#507E37","#315D25","#CBF6A1","#A3E465","#7BCE2C","#4B9F0F","#B3B552","#52B554",
                "#FFD069","#FDC964","#FABD5E","#F6AC59","#F29E55","#EA8750","#FFE9B1","#FFDB81","#FFBA23","#FF8F12","#FD7E64","#E4FD64",
                "#877068","#74574D","#684E46","#58423B","#493632","#392926","#E0D8CF","#C2AAA1","#9C6B5A","#703B2B","#744D57","#746A4D",
                "#BDBDBD","#9E9E9E","#757575","#616161","#424242","#212121","#EDEDED","#D8D8D8","#959595","#434343","#9E9E9E",
                "#7D8F99","#7D8F99","#596D77","#495961","#3B464C","#2A3135","#DAE5EB","#B4C9D4","#7397AB","#4A6675","#658883","#658883"], //
            isGroupIdObject: false,
            selectedPoint: null,
            groupsWithIds: [],
        }
    },

//External Components Used:

    components: {
        'kendis-widget-collection-pie-col-criteria':kendisWidgetCollectionPieColumnCriteria,
        'criteria-details-pie': criteraiDetailsPie,
        'backlog-items-popup':backlogItemsPopup,
    },

//Life Cycle Methods
    mounted() {
        this.groupIdColorMap = this.globalColorsMap;
        //Create a new Widget if id is null
        if (this.widgetData.state == "new") {
            this.addWidget = true;
            this.widgetObj = this.widgetData;
            this.openSelectionPopup = true;
        } else {
            //fetch widget data, process it and load the graph
            this.fetchCycleTimeWidgetData();
        }
    },

    watch: {
        widgetData: {
            handler(newVal, oldVal) {
                if(this.$el?.offsetWidth) {
                    this.updatedGraphWidth = this.$el.offsetWidth;
                    this.titleWidth = this.$el.offsetWidth * 0.55;
                }
            },
            deep: true,
            immediate: true,
        }
    },

    created() {
    },

    computed: {
        selectedFilterMessage : function(){
            return function(){
                return (this.collectionsGraphCriteria.selectedGroupBy==="Session" ? "PI Boards" : this.groupTitle) + " (" + this.filterColumn.selected.length + ")";
            }
        },
    },

//Methods used in this Graph

    methods: {

        removeHtmlTags(html) {
            if (!html) return "";
            const doc = new DOMParser().parseFromString(html, "text/html");
            return doc.body.textContent || "";
        },

        closeItemsPopup(){
            if (this.selectedPoint) {
                this.selectedPoint.point.select(false);
                this.selectedPoint = null;
            }
            enableBodyScroll();
            this.isPopupOpen = false;
        },

        onFilterAndFormatChange(filterValue, formatValue) {
            const filterIds = new Set(filterValue.map(filter => filter?.title));
            const filteredData = this.originalChartDataOptions.data.filter(item => filterIds.has(item.name));
            const updatedCategories = filteredData.map(item => item.name); // Update xAxis labels
            this.chartData.options.xAxis.categories = updatedCategories;
            this.changeDataFormat(formatValue, filteredData);
        },

        changeDataFormat: function (formatValue, data){
            if (formatValue) {
                let max = 0;
                this.chartData?.options?.series?.forEach(series => {
                    series.data = data.map(point => {
                        let updatedY = point.y;

                        if (!this.chartData.options.yAxis) {
                            this.chartData.options.yAxis = {};
                        }
                        if (!this.chartData.options.yAxis.title) {
                            this.chartData.options.yAxis.title = {};
                        }

                        if (formatValue.value === 'percentage') {
                            if (point.originalValue === undefined) {
                                point.originalValue = point.y;
                            }
                            updatedY = parseFloat(((point.originalValue / this.totalSize) * 100).toFixed(2)) ;
                            this.chartData.options.yAxis.title.text = 'Percentage';
                        }else{
                            this.chartData.options.yAxis.title.text = 'Values';
                        }

                        max = Math.max(max, updatedY);
                        return {
                            name: point.name,
                            y: updatedY,
                            groupId: point.groupId,
                            color: point.color,
                            originalValue: point.originalValue
                        };
                    });
                });
                if(this.selectedOption.value === "percentage"){
                    if((max + (max * 0.1)) > 100){
                        this.chartData.options.yAxis.max = 100;
                    }else{
                        this.chartData.options.yAxis.max = max + (max * 0.1);
                    }
                }else{
                    this.chartData.options.yAxis.max = max + 5;
                }
            }
        },

        loadBacklogItems: function(requestBody) {
            var _this = this;
            var data = {};
            this.loading = true;
            this.openSelectionPopup = false;
            this.openEditPopup = false;
            this.releaseTrainId = requestBody.releaseTrainId;
            this.type = requestBody.type;
            this.groupTitle = requestBody.title;
            this.hierarchyLevelId = requestBody.hierarchyLevelId;
            data.hierachLevel = String(requestBody.level);
            data.filter = requestBody?.filter?.criteria ?? data.filter;
            data.fetchParents  = true;
            data.rollupSprints = true;
            data.rollupBatches = true;
            data.rollupStoryPointsArray = true;
            data.requestId = getNewUUID();
            data.groupBy = requestBody.group === "jiraProject" ? "project" : requestBody.group;
            data.type = requestBody.type || this.widgetObj.collectionsGraphCriteria.type;
            this.graphName = requestBody.titleOfGraph;
            this.groupBy = requestBody.group === "jiraProject" ? "project" : requestBody.group;
            data.itemType = requestBody.itemType;
            this.itemType = requestBody.itemType;
            this.collectionName = requestBody.collectionName;
            this.hierarchylevel =  String(requestBody.level);
            this.totalSize = 0;

            if (requestBody?.filter) {
                this.filterName = requestBody.filter.name;
                this.filterId = requestBody.filter.id;
                this.selectedFilter = requestBody.filter;
            }

            axios.post('/releasetrain/' + this.releaseTrainId + '/backlog', data)
                .then(res => {
                    this.groups = this.createGroups(res.data,data.groupBy);
                    this.teamAndColorList = res.data.teamsWithColor;
                    this.populateTitleGroupMap(res.data,data.groupBy);
                }).catch(error => {
                console.log(error);
            });
        },

        createGroups:function(data, groupType) {
            return data.result.items.map(item => ({
                groupId: item._id.id || null,
                type: groupType,
                size: item.count,
                multiIds: item.multiIds,
                excludeGroupIds: item.excludeGroupIds
            }));
        },


        populateTitleGroupMap:function(data,type){
            let itemsGroupMap = {"-1":"No Group"};
            const ids = data.result.items
                .map(item => {
                    if(item._id.id && typeof item._id.id === "object") {
                        if (item._id.id?.length > 0) {
                            return item._id.id[0].name + "";
                        } else {
                            return item._id.id?.value || item._id?.id.name;
                        }
                        return item._id.id?.name + "";
                    }
                    return item._id.id ? item._id.id + "" : item._id.id
                })
                .filter(id => id);
            let req = {};
            req.ids = ids;
            req.type = type;
            req.dashboardKey = this.dashboardSelectedId;
            req.colors = this.colors;

            axios.post('/dashboard/fetchgrouptitles', req)
                .then(res => {
                    let groupTitleMap = res.data.groupTitleMap;
                    this.groupIdColorMap = res.data.globalColorsMap;
                    // Create the map
                    const map = {};

                    data.result.items.forEach(item => {
                        let id = item._id.id || "-1"; // Default to "-1" if id is missing
                        if(item._id.id && typeof item._id.id === "object"){
                            id = item._id.id?.name + "";
                            if(item._id.id?.length > 0){
                                id = item._id.id[0].name + "";
                            }else{
                                id = id = item._id.id?.name || item._id.id?.value;
                            }
                        }
                        const title = id === "-1" ? "No-Group" : groupTitleMap[id]; // Use "No-Group" for default, otherwise look up title
                        if (title) { // Only include entries with valid titles
                            map[id] = {
                                title: title === "undefined" ? "No Group" : title,
                                count: item.count
                            };
                        }
                    });
                    const transformed = Object.entries(map).map(([id, { title, count }]) => [
                        `{${id}=${title}}`,
                        count
                    ]);
                    const widgetData = this.makeGraphObjectForCollectionPieDBStorage(transformed);
                    if (!_.isEmpty(widgetData)) {
                        return axios.post(`/dashboard/${this.dashboardSelectedId}/widget/save`, widgetData);
                    }

                }).then(response => {
                    this.groupTitle = response.data.widget.collectionsGraphCriteria.groupByTitle
                    this.groupsWithIds = response.data.widget.collectionsGraphCriteria.groups;
                    const updatedWidget = response.data.widget;
                    this.widgetObj = updatedWidget;
                    // this.groupIdColorMap = this.widgetObj.collectionsGraphCriteria.groupIdColorMap;
                    this.initializePieGraphData(updatedWidget);
                    this.populateFilters();
                    this.loading = false;
                    this.chartData.isSyncing = false;
                    this.changeDataFormat(this.selectedOption, this.pieChart.options.series[0].data);
                }).catch(error => {
                    console.log(error);
                });
        },

        //Widget related functions
        handleSettingsClick:function(){
            this.settingsLoading = true;
            //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"WidgetSettings")){
                        this.showGraphSettings = true;
                        this.settingsLoading = false;
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.","warning","8000");
                        this.settingsLoading = false;
                        location.reload();
                    }
                })
                .catch(e => {
                    this.settingsLoading = false;
                });
        },
        //handle the flow for cancel of selection
        handelCloseSelection:function(){
            this.openSelectionPopup = false;
            this.$emit('handleRemovalAction', {id: this.widgetObj.id});
        },
        handleEditClosure:function(){
            this.openSelectionPopup = false;
            this.openEditPopup = false;
        },
        openEditCriteria: function () {
            this.updatedGraphWidth = this.$el.offsetWidth;
            this.openEditPopup = true;
        },
        openPieCriteria: function () {
            this.openSelectionPopup = true;
        },


        selectedGroupByMessage: function () {
            let selectedGrouping = this.chartData.allGroupBys?.map(groupBy => groupBy.id) || [];
            let title = "";
            if (!_.isEmpty(selectedGrouping) && !_.isEmpty(this.collectionsGraphCriteria.selectedGroupBy)) {
                if (this.collectionsGraphCriteria.selectedGroupBy.length >= 10) {
                    title = this.collectionsGraphCriteria.selectedGroupBy.slice(0, 15) + "..." + " (" + selectedGrouping.length + ")";
                } else {
                    title = this.collectionsGraphCriteria.selectedGroupBy + "s" + " (" + selectedGrouping.length + ")";
                }
            }
            return title;
        },

        fetchCycleTimeWidgetData: function () {
            let data = {};
            data.widgetId = this.widgetData.id;
            this.loading = true;
            axios.post("/dashboard/getSingleWidget/", data).then(response => {
                this.teamAndColorList = response.data.widget.collectionsGraphCriteria.teamAndColorList;
                let widget = response.data.widget;
                data = {"releaseTrainID": widget.collectionsGraphCriteria.releaseTrainId};
                this.releaseTrainId = widget.collectionsGraphCriteria.releaseTrainId;
                this.itemType = widget.collectionsGraphCriteria.itemType;
                this.groupsWithIds = widget.collectionsGraphCriteria.groups;
                this.filterId = widget.collectionsGraphCriteria?.filterId;
                // this.groupIdColorMap = widget.collectionsGraphCriteria.groupIdColorMap;
                axios.post("/dashboard/fetch-release-train-filters", data)
                    .then(response => {
                        let selectedFilter = response.data.releaseTrainFilters.find(filter => filter.id === widget.collectionsGraphCriteria.filterId);
                        if (!_.isEqual(widget?.criteria?.criteria.rules, selectedFilter?.criteria.rules)) {
                            let requestBody = {
                                filter: selectedFilter,
                                group: widget.collectionsGraphCriteria.groupBy,
                                title: widget.collectionsGraphCriteria.groupByTitle,
                                titleOfGraph: widget.name,
                                releaseTrainId: widget.collectionsGraphCriteria.releaseTrainId,
                                collectionName: widget.collectionsGraphCriteria.collectionName,
                                level: widget.collectionsGraphCriteria.hierarchyLevel,
                                type: widget.collectionsGraphCriteria.type,
                                itemType: widget.collectionsGraphCriteria.itemType
                            };
                            this.loadBacklogItems(requestBody);
                        }
                    }).catch(error => {
                    console.error(error);
                });
                this.widgetObj = response.data.widget;
                this.type = response.data.widget.collectionsGraphCriteria.type;
                this.groupTitle = response.data.widget.collectionsGraphCriteria.groupByTitle;
                this.initializePieGraphData(this.widgetObj);
                this.populateFilters();
            }).catch(e => {
                this.errorCase = true;
                console.log("Some Error Occurred While Loading Single Cycle Time", e);
                this.loading = false;
            });
        },

        //methods for Cycle Time processing

        openCycleTimeCriteria: function () {
            this.openSelectionPopup = true;
        },

        openCycleTimeEditCriteria: function () {
            this.updatedGraphWidth = this.$el.offsetWidth;
            this.openEditPopup = true;
        },

        makeGraphObjectForCollectionPieDBStorage: function (response) {
            let widgetData = {};
            // let groupIdColorMap = new Map();

            this.groups.sort((a, b) => {
                let groupA = a.groupId ?? "";
                let groupB = b.groupId ?? "";
                if(groupA && typeof groupA === "object"){
                    groupA = groupA?.name + "";
                }
                if(groupB && typeof groupB === "object"){
                    groupB = groupB?.name + "";
                }
                groupA = String(groupA);
                groupB = String(groupB);
                return groupA.localeCompare(groupB);
            });
            this.groups.forEach((group, index) => {
                const colorIndex = index % this.colors.length;
                let id = group.groupId ? group.groupId : "-1";
                if(group.groupId && typeof group.groupId === "object"){
                    id = id?.name + "";
                }
                // groupIdColorMap[id] = this.colors[colorIndex];
                group.type = this.selectedOption.value
            });
            let groups = this.groups;
            groups.forEach(group =>{
                if(group.groupId && typeof group.groupId === "object"){
                    group.groupId = group.groupId?.name + "";
                    group.isGroupIdObject = "true";
                }else{
                    group.isGroupIdObject = "false";
                }
            })
            if (response !== null) {
                let dataOfGraph = {
                    "graphType": "pie",
                    "groupBy": this.groupBy,
                    "collectionName":this.collectionName,
                    "backlogFilterName":this.filterName,
                    "releaseTrainId":this.releaseTrainId,
                    "filterId":this.filterId,
                    "hierarchyLevel":this.hierarchylevel,
                    "groups":groups,
                    "type": this.type,
                    "groupByTitle": this.groupTitle,
                    "hierarchyLevelId" : this.hierarchyLevelId,
                    "teamAndColorList": this.teamAndColorList,
                    "itemType": this.itemType,
                    // "groupIdColorMap": groupIdColorMap
                };
                widgetData = {
                    name: this.graphName,
                    collectionsGraphCriteria: dataOfGraph,
                    graphAdditionalCriteria: response,
                    id: this.widgetObj.id,
                    state:'old',
                    criteria :  this.selectedFilter,
                };
                return widgetData;
            }
        },

        populateFilters: function(){
            this.totalSize = this.widgetObj.graphAdditionalCriteria.reduce((sum, group) => sum + parseFloat(group[1]), 0);
            const filterList = this.widgetObj.graphAdditionalCriteria.map( filter => {
                const parts= filter[0].replace(/[{}]/g, '').split('=')
                return {
                    id: parts[1],
                    title : parts[1]
                };
            });
            const uniqueFilters = Array.from(new Map(filterList.map(item => [item.title, item])).values());
            this.filterColumn.selected = uniqueFilters;
            this.$options.filterOptions = uniqueFilters;
            this.originalChartDataOptions = JSON.parse(JSON.stringify(this.chartData.options.series[0]));
        },

        //Chart Population Functions
        initializePieGraph: function () {
            let _this = this;
            this.pieChart = {
                show: false,
                options: {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'column',
                        height: 0,
                    },

                    tooltip: {
                        useHTML: true,
                        backgroundColor: 'white',
                        borderWidth: 0,
                        borderRadius:5,
                        formatter: function() {
                            let value = this.y;
                            if(_this.selectedOption.value === 'percentage') {
                                 value = value.toFixed(2) + '%';
                            }
                            return '' +
                                '<div class="garphsTooltipwraper">' +
                                '<div class="DFCB"><label> Group by:  </label> <div style="color: ' + this.point.color + ';">' + this.point.name + '</div></div>' +
                                '<div class="DFCB"><label>Items:</label> <div>' + value + '  </div></div>' +
                                '</div>';
                        }
                    },
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom',
                        useHTML: true,
                        itemStyle: {
                            pointerEvents: 'none' // Disable pointer events on legend items
                        }
                    },
                    colors: ['#32CD32','#FF69B4', '#0485E3','#EBB438','#00FFFF','#9370DB','#FFA07A','#FF4500', '#20B2AA','#FF0000', '#00FF00', '#0000FF', '#FFD700', '#800080', // Add more custom colors as needed
                        '#FF6347',
                        '#4169E1', '#8B0000', '#ADFF2F',
                        '#8A2BE2', '#556B2F'], //
                    plotOptions: {
                        column: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            dataLabels: {
                                enabled: true,
                                formatter: function() {
                                    if (this.y <= 0) return null;
                                    let value = this.y;
                                    if(_this.selectedOption.value === 'percentage') {
                                        value = this.y + '%';
                                    }
                                    const style= 'font-weight: bold';

                                    return `<span style="${style}">${value}</span>`;
                                },
                                useHTML: true
                            },
                            showInLegend: true
                        },
                        series: {
                            label: {
                                connectorAllowed: false
                            },
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onClickDataPoints(event);
                                    }
                                }
                            }
                        }
                    },
                    series: [],
                    responsive: {
                        rules: [{
                            condition: {
                                maxWidth: 500
                            },
                            chartOptions: {
                                legend: {
                                    layout: 'horizontal',
                                    align: 'center',
                                    verticalAlign: 'bottom'
                                }
                            }
                        }]
                    },
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen','separator','downloadPDF','downloadJPEG','downloadPNG','downloadXLS' ]
                            }
                        }
                    }
                }
            };
        },

        initializePieGraphData: function (data) {
            if(_.isEmpty(data.graphAdditionalCriteria)){
                this.errorCase= true;
            }
            else{
                this.errorCase= false;
            }
            this.populatePieChart(data);
            let timestamp = '';
            if (data.updatedOn) {
                timestamp = data.updatedOn;
            } else {
                timestamp = data.createdOn;
            }
            let collectionsGraphCriteria = {
                graphType: null,
                selectedBoardTitle: null,
                selectedIssueType: null,
                selectedGroupBy: null,
                selectedXAxis: null,
                selectedInterval: null,
                selectedToStatus: null,
                selectedFromStatus: null,
                selectedFilter : null,
                selectedCollection: null,
            };
            collectionsGraphCriteria.chartType = data.collectionsGraphCriteria.chartType;
            collectionsGraphCriteria.selectedBoardTitle = data.collectionsGraphCriteria.boardTitle;
            collectionsGraphCriteria.selectedToStatus = data.collectionsGraphCriteria.toStatusTitle;
            collectionsGraphCriteria.selectedFromStatus = data.collectionsGraphCriteria.fromStatusTitle;
            collectionsGraphCriteria.selectedIssueType = data.collectionsGraphCriteria.issueTypeTitle;
            collectionsGraphCriteria.selectedGroupBy = data.collectionsGraphCriteria.groupBy;
            collectionsGraphCriteria.selectedCollection=data.collectionsGraphCriteria.collectionName;
            collectionsGraphCriteria.selectedFilter = data.collectionsGraphCriteria.backlogFilterName;
            const dateData = new Date(timestamp);
            processedGraph = {
                options: Object.assign({}, this.pieChart.options),
                show: true,
                id: data.id,
                timestampInfo: dateData.toLocaleString(),
                name: data.name,
                isSynced: false,
                isSyncing: false,
                columns: data.columns,
                rows: data.rows,
                posX: data.posX,
                posY: data.posY,
                loading:false,
                collectionsGraphCriteria: collectionsGraphCriteria,
                type: "flow-time-graph",
                category : "Pie Chart",
                itemDaysMap: data.collectionsGraphCriteria.itemDaysMap ? data.collectionsGraphCriteria.itemDaysMap : {},
            };
            // Ensuring reactivity
            this.$set(this.chartData, 'show', false);
            this.$set(this,'chartData', processedGraph);
            this.$set(this, 'addWidget', false);
            this.$set(this, 'collectionsGraphCriteria', collectionsGraphCriteria);
            this.$set(this, 'loading', false);

            let _this = this;
            this.$nextTick(() => {
                _this.setGraphHeight();
                _this.chartData.show = true;
            });
        },

        populatePieChart: function (widget) {
            this.initializePieGraph();
            let graphOptions = _.cloneDeep(this.pieChart.options);
            const shouldUseTeamColors = widget.collectionsGraphCriteria.groupBy === "Teams";
            let series = [{
                name: 'Collection Graph of '+this.widgetObj.collectionsGraphCriteria.groupByTitle,
                colorByPoint: !shouldUseTeamColors,
                showInLegend: true,
                data: widget.graphAdditionalCriteria.map(entry => {
                    const [idAndTitle, count] = entry; // Destructure the array
                    const title = idAndTitle.match(/=(.*)}/)?.[1]; // Extract the title using a regex
                    const groupId = idAndTitle.replace(/{|}/g, '').split('=')[0];
                    return {
                        name: title || "Unknown", // Fallback to "Unknown" if parsing fails
                        y: count,
                        groupId: groupId,
                        ...(shouldUseTeamColors ? { color: this.teamAndColorList?.[groupId] || "#CCCCCC" } : {color: this.groupIdColorMap?.[groupId] || "rgb(50,205,50)" }),
                        type: this.selectedOption.value
                    };
                })
            }];

            series[0].data.sort((a, b) => {
                if (a.name === "No-Group") return 1;
                if (b.name === "No-Group") return -1;
                return 0;
            });

            this.groups = series[0].data;
            graphOptions.xAxis = {
                categories: series[0].data.map(entry => entry.name),
                labels: {
                    style: {
                        fontSize: '12px',
                    },
                },
            };

            graphOptions.series  = series;
            this.pieChart.options = graphOptions;
        },

        //Helper functions for formatting
        formattedCompletionStatus(status) {
            if (!_.isEmpty(status)) {
                return status.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },

        formatInnerDate: function (dateString) {
            const parts = dateString.split(" ");
            const month = parts[1];
            const day = parts[2];
            const year = parts[5];
            return `${month} ${day} ${year}`;
        },

        formatBoardItemsTitle: function (input) {
            if (!input) {
                return '';
            }

            return input
                .split('-')
                .map(word => word.charAt(0).toUpperCase() + word.slice(1))
                .join(' ');
        },

        getStartDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[0];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        getEndDate: function (key, relevantDates) {
            if (relevantDates.hasOwnProperty(key)) {
                let dateList = relevantDates[key];
                if (dateList.length > 0) {
                    return dateList[dateList.length - 1];
                } else {
                    console.error("The list for the key is empty.");
                    return null;
                }
            } else {
                console.error("The key does not exist in the relevantDates map.");
                return null;
            }
        },

        calculateAverageOfDataPoints: function (dataPoints) {
            let sum = 0;
            for (let i = 0; i < dataPoints.length; i++) {
                sum += dataPoints[i][1];
            }
            let average = sum / dataPoints.length;
            return average.toFixed(1);
        },

        handleGroupBySelection: function (selected) {

            let tempselectedGroupBy = selected == undefined ? [] : selected;
            let selectedGraph = this.chartData;
            let selectedGraphOptions = selectedGraph.options;
            let selectedWidget = this.widgetData;
            let selectedGroupBy = selectedGraph.allGroupBys.filter(groupBy =>
                tempselectedGroupBy.includes(groupBy.id)
            );
            let dummyData = [];
            let graphOptions = null;
            if (selectedGraph.type == 'flow-time-graph') {
                this.initializeCycleTimeGraph();
                graphOptions = _.cloneDeep(this.flowTimeGraph.options);
            }
            graphOptions.xAxis.categories = selectedWidget.collectionsGraphCriteria.categories;
            graphOptions.chart.type = selectedWidget.collectionsGraphCriteria.chartType;
            if (!_.isEmpty(selectedWidget.graphAdditionalCriteria)) {
                let index = 0;
                let teamMap = new Map();
                for (const pair of selectedWidget.graphAdditionalCriteria) {
                    dummyData = [];
                    const pairKey = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                    const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                    if (!teamMap.has(pairValue)) {
                        teamMap.set(pairValue, Array(selectedWidget.collectionsGraphCriteria.categories.length).fill(0));
                    }
                }
                if (selectedGroupBy != null) {
                    for (const pair of selectedWidget.graphAdditionalCriteria) {
                        dummyData = [];
                        const iteration = pair[0].split('=')[0].replace('{', ''); // Extracts "Iteration 2"
                        const team = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                        const teamData = teamMap.get(team);
                        if (selectedGroupBy.some(groupBy => groupBy.title === team)) {
                            const iterationIndex = selectedWidget.collectionsGraphCriteria.categories.indexOf(iteration);
                            if (iterationIndex !== -1) {
                                if (!teamMap.has(team)) {
                                    teamMap.set(team, Array(selectedWidget.collectionsGraphCriteria.categories.length).fill(0));
                                }
                                const teamData = teamMap.get(team);
                                teamData[iterationIndex] += pair[1];
                                teamMap.set(team, teamData);
                            }
                        }
                    }
                    for (const [key, value] of teamMap) {
                        graphOptions.series[index] = {
                            name: key,
                            data: value
                        };
                        index++;
                    }
                    if (_.isEmpty(graphOptions.series)) {
                        graphOptions.series[0] = {
                            name: "No Data",
                            data: []
                        };
                    }
                }
            } else {
            }
            if (selectedGraph.type == 'flow-time-graph') {
                graphOptions.chart.type = selectedWidget.collectionsGraphCriteria.chartType;
                this.flowTimeGraph.options = graphOptions;
            }
            let timestamp = '';
            if (selectedWidget.updatedOn) {
                timestamp = selectedWidget.updatedOn;
            } else {
                timestamp = selectedWidget.createdOn;
            }
            const dateData = new Date(timestamp);
            let average = this.filteredDataPointsAvg(selectedWidget.graphAdditionalCriteria, selectedGroupBy);
            if (average == 'NaN') {
                average = 0.0;
            }
            if (selectedWidget.collectionsGraphCriteria.chartType !== 'column') {
                if (selectedGraph.type == 'flow-time-graph') {
                    if (selectedWidget.collectionsGraphCriteria.chartType == 'line') {
                        this.flowTimeGraph.options.yAxis.plotLines = [{
                            value: average,
                            dashStyle: 'shortDash',
                            width: 1
                        }];
                    }
                }
            }
            let allGroupBys = [];
            if (!_.isEmpty(selectedWidget.allGroupBys)) {
                allGroupBys = selectedWidget.allGroupBys;
            }
            const keys = Object.keys(allGroupBys);
            const transformedallGroupBys = keys.map(key => ({
                id: key,
                title: allGroupBys[key]
            }));

            let collectionsGraphCriteria = {
                graphType: null,
                selectedBoardTitle: null,
                selectedIssueType: null,
                selectedGroupBy: null,
                selectedXAxis: null,
                selectedInterval: null,
                selectedToStatus: null,
                selectedFromStatus: null,
            };
            collectionsGraphCriteria.chartType = selectedWidget.collectionsGraphCriteria.chartType;
            collectionsGraphCriteria.graphType = selectedWidget.collectionsGraphCriteria.graphType;
            collectionsGraphCriteria.selectedBoardTitle = selectedWidget.collectionsGraphCriteria.boardTitle;
            collectionsGraphCriteria.selectedIssueType = selectedWidget.collectionsGraphCriteria.issueTypeTitle;
            collectionsGraphCriteria.selectedGroupBy = selectedWidget.collectionsGraphCriteria.groupByTitle ? selectedWidget.collectionsGraphCriteria.groupByTitle : selectedWidget.collectionsGraphCriteria.groupBy;

            if (selectedWidget.collectionsGraphCriteria.intervals == 'sprints' || selectedWidget.collectionsGraphCriteria.intervals == 'weekly' || selectedWidget.collectionsGraphCriteria.intervals == 'monthly') {
                collectionsGraphCriteria.selectedXAxis = selectedWidget.collectionsGraphCriteria.intervals;
            } else {
                collectionsGraphCriteria.selectedXAxis = "Days";
                collectionsGraphCriteria.selectedInterval = selectedWidget.collectionsGraphCriteria.intervals;
            }
            collectionsGraphCriteria.selectedToStatus = selectedWidget.collectionsGraphCriteria.toStatusTitle;
            collectionsGraphCriteria.selectedFromStatus = selectedWidget.collectionsGraphCriteria.fromStatusTitle;
            let option = null;
            let type = null;
            let category = null;
            if (selectedGraph.type == "flow-time-graph") {
                option = this.flowTimeGraph.options;
                type = "flow-time-graph";
                category = "Cycle Time";
            }

            let updatedItemsMap = selectedWidget.collectionsGraphCriteria.itemDaysMap ? selectedWidget.collectionsGraphCriteria.itemDaysMap : selectedWidget.collectionsGraphCriteria.itemStatusMap;
            let filteredItems = {};
            for (const key in selectedWidget.collectionsGraphCriteria.itemTeamsMap) {
                const team = key.split(':')[1].trim();
                let itemId = key.split(':')[0];
                if (selectedGroupBy.some(groupBy => groupBy.title === team)) {
                    for (const key2 in updatedItemsMap) {
                        let tempId = key2.split(':')[0].trim();
                        let tempName = key2.split(':')[1].trim();
                        if (itemId === tempId) {
                            itemId += ':';
                            itemId += tempName;
                            filteredItems[itemId] = updatedItemsMap[itemId];
                        }
                    }
                }
            }
            let filteredGroupBy = {};

            let processedGraph = {
                options: Object.assign({}, option),
                show: true,
                id: selectedWidget.id,
                timestampInfo: dateData.toLocaleString(),
                name: selectedWidget.name,
                isSynced: false,
                isSyncing: false,
                type: type,
                category: category,
                average: average,
                allGroupBys: transformedallGroupBys,
                collectionsGraphCriteria: collectionsGraphCriteria,
                yAxis: selectedWidget.collectionsGraphCriteria.yAxis ? selectedWidget.collectionsGraphCriteria.yAxis : "",
                itemDaysMap: selectedGraph.type !== "flow-load-graph" ? filteredItems : [],
                itemStatusMap: selectedGraph.type == "flow-load-graph" ? filteredItems : [],
                itemGroupbyMap: filteredGroupBy,
                itemTeamsMap: selectedWidget.collectionsGraphCriteria.itemTeamsMap ? selectedWidget.collectionsGraphCriteria.itemTeamsMap : {},
                itemSprintsMap: selectedWidget.collectionsGraphCriteria.itemSprintsMap ? selectedWidget.collectionsGraphCriteria.itemSprintsMap : {},
                posX: selectedGraph.posX,
                posY: selectedGraph.posY,
                columns: selectedGraph.columns,
                rows: selectedGraph.rows
            }

            this.chartData = processedGraph;

            // let _this = this;
            // Vue.nextTick(()=>{
            //     if (_this.gridStack) {
            //         let widgetElement = document.getElementById(selectedWidget.id);
            //         _this.gridStack.update(widgetElement);
            //     }
            // });
        },

        filteredDataPointsAvg: function (data, selectedGroupBy) {
            if (!_.isEmpty(selectedGroupBy)) {
                let dataPoints = [];
                let dummyData = [];
                for (const pair of data) {
                    const pairValue = pair[0].split('=')[1].replace('}', ''); // Extracts "Team B"
                    if (selectedGroupBy.some(groupBy => groupBy.title === pairValue)) {
                        dummyData.push(pair[1]);
                    }
                }
                let sum = 0;
                for (let i = 0; i < dummyData.length; i++) {
                    sum += dummyData[i];
                }
                let avg = sum / dummyData.length;
                return avg.toFixed(1);
            }
            return 0;
        },

        //Widget Removal & Duplicate
        handleRemoveWidget: function () {
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this widget?",
                [() => this.$emit('handleRemovalAction', {id: this.widgetObj.id}), null],
                [takeNoAction]
            );
        },

        handleDuplicateWidget: function () {
            this.widgetObj.posX = this.widgetData.posX;
            this.widgetObj.posY = this.widgetData.posY;
            this.widgetObj.columns = this.widgetData.columns;
            this.widgetObj.rows = this.widgetData.rows;
            askFromSweetAlertWrapper(
                "Are you sure you want to duplicate this widget?",
                [() => this.$emit('handleDuplicateAction', {widget: this.widgetObj}), null],
                [takeNoAction]
            );
        },

        //Syncing of Pie chart
        handleSyncWidget: function (widgetSelected) {
            const data = {"releaseTrainID": this.widgetObj.collectionsGraphCriteria.releaseTrainId};
            let requestBody = {
                group :  this.widgetObj.collectionsGraphCriteria.groupBy,
                titleOfGraph : this.widgetObj.name,
                releaseTrainId : this.widgetObj.collectionsGraphCriteria.releaseTrainId,
                collectionName: this.widgetObj.collectionsGraphCriteria.collectionName,
                level: this.widgetObj.collectionsGraphCriteria.hierarchyLevel,
                itemType: this.widgetObj.collectionsGraphCriteria.itemType,
                type: this.widgetObj.collectionsGraphCriteria.type,
                title: this.widgetObj.collectionsGraphCriteria.groupByTitle,
            }
            if(this.widgetObj.collectionsGraphCriteria.hierarchyLevelId !== ""){
                requestBody.level = this.widgetObj.collectionsGraphCriteria.hierarchyLevel;
                requestBody.hierarchyLevelId = this.widgetObj.collectionsGraphCriteria.hierarchyLevelId;
            }else{
                requestBody.filter = this.widgetObj.criteria;
            }
            axios.post("/dashboard/fetch-release-train-filters", data)
                .then(response => {
                    const selectedFilter = response.data.releaseTrainFilters.find(filter => filter.id === this.widgetObj.collectionsGraphCriteria.filterId);
                    if (selectedFilter) {
                        requestBody = {
                            ...requestBody,
                            type: this.widgetObj.collectionsGraphCriteria.type,
                            title: this.widgetObj.collectionsGraphCriteria.groupByTitle,
                            filter: selectedFilter,
                        };
                        this.loadBacklogItems(requestBody);
                    }else{
                        this.loadBacklogItems(requestBody);
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        handleRerenderWidget: function () {
            let _this = this;

            this.setGraphHeight();
            Vue.set(_this.chartData, "show", false);
            Vue.nextTick(()=> {
                Vue.set(_this.chartData, "show", true);
            });
        },

        setGraphHeight: function () {
            let totalHeightInPixels = this.$el.offsetHeight;
            let headerHeight = this.$refs.header.offsetHeight;
            let footerHeight = this.$refs.footer.offsetHeight;
            this.chartData.options.chart.height = totalHeightInPixels - headerHeight - footerHeight- 10;
        },

        //Detail List
        handleDetailList: function (data) {
            this.selectedPoint = null;
            this.loadItemsPopup();
        },

        combineItems: function(objects) {
            return objects.reduce((acc, obj) => acc.concat(obj.items || []), []);
        },

        loadItemsPopup: function () {
            var data = {};
            data.fetchParents  = true;
            data.rollupSprints = true;
            data.rollupBatches = true;
            data.rollupStoryPointsArray = true;
            data.requestId = getNewUUID();
            data.hierachLevel = this.widgetObj.collectionsGraphCriteria.hierarchyLevelId !== "" ? this.widgetObj.collectionsGraphCriteria.hierarchyLevel : this.widgetObj.criteria.level.toString();
            data.pageStart = "0";
            data.pageSize = "50"

            if (this.widgetObj.collectionsGraphCriteria.hierarchyLevelId === "") {
                data.filter = this.widgetObj.criteria.criteria;
            }

            axios.post('/releasetrain/' + this.releaseTrainId + '/backlog', data)
                .then(res => {
                    let group = {size :res.data.result.total, type:"-1"};
                    this.group = group;
                    // this.loadGroupItems(group).then(() => {
                        // this.popupData = combinedItems;
                        this.data.popupTitle = this.widgetObj.name;
                        this.groupStat = {};
                        disableBodyScroll();
                        this.isPopupOpen = true;
                    // }).catch(error => {
                    //     console.error(error);
                    // });
                }).catch(error => {
                console.log(error);
            });
        },
        //Points Click Actions
        onClickDataPoints: function (event) {
            this.selectedPoint = event;
            let groupId = event.point.groupId === '-1' ? null : event.point.groupId  ;
            let size = "0";
            if(event.point?.originalValue){
                size = event.point.originalValue.toString();
            }else {
                size = event.point.y.toString();
            }
            let group = {
                type: this.widgetObj.collectionsGraphCriteria.groupBy,
                groupId:groupId,
                size :size,
            };
            this.group = group;
            // this.loadGroupItems(group).then(() => {
                if(this.selectedOption.value === 'percentage') {
                    let percentage = (parseFloat(group.size) / this.totalSize) * 100;
                    this.groupStat.size = percentage.toFixed(2) + '%';
                }else{
                    this.groupStat.size = group.size;
                }
                this.groupStat.name = this.removeHtmlTags(event.point.name);
                this.data.popupTitle = this.widgetObj.name;
                disableBodyScroll();
                this.isPopupOpen = true;
            // }).catch(error => {
            //     console.error('Error:', error);
            // });
        },

    },

})