const backlogItemsPopup = Vue.component("backlog-items-popup", {
    name: "backlog-items-popup",
    template: `
     <div id="overlay" class="overlay" style="display: block;">	              
         <div class="dependpop additionalClass graphDetailPopUpContainer">			
                <div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div></div></div>
                <div class="graphDetailPopUpHeader">
                   <div class="DFA">
                      <span class="fs-22 ftsb">{{data.popupTitle}}</span>
                   </div> 
                   <div class="DFA gap-2">
						<div class="ti-search sreachIcon p-rel">
							<input v-model="search.text" type="text" placeholder="Search..." class="listingSearch rds4" lazy @input="onSearchInput"/>
						</div>					
                       <div class="selectcont rhtsd statusDrop" v-if="totalItems > 0">
                             <vz-select 
                                 v-if="$options.columnOptions != undefined && $options.columnOptions.length > 0"
                                 :multiple="true" 
                                 empty-selection-text="Columns"
                                 selected-title="Columns" 
                                 class="multi-filter" 
                                 value-type="value"
                                 :options="$options.columnOptions" 
                                 v-model="columns.selected"
                                 @select="onColumnsSelectValue" 
                             />
                       </div>              
                        <div class="p-rel c-point impout">
                        	<div class="slctdn rds4" onclick="showOverLay(this,'#analytics-popup_export')" data-overlayopener="analytics-popup_export">
	                        	<a href="javascript:void(0);"><em class="ti-import"></em></a>
		                        <ul class="drop_box" id="analytics-popup_export" style="display: none;">
			                        <li @click="exportChartDetail('csv')"><a class="applyfilter" href="javascript:void(0);">Export CSV</a></li>
			                        <li @click="exportChartDetail('xlsx')"><a class="applyfilter" href="javascript:void(0);">Export Excel</a></li>
		                        </ul>
	                        </div>
                        </div>
                       <em @click="hide()" title="Close" class="rmv-ico ti-close rnd DAJ"></em>
                   </div>                                                                
                </div> 
                <div class="graphDetailPopUpinnerHeader" :class="{'flex-e': Object.keys(groupStat).length === 0}">
                    <div v-if="Object.keys(groupStat).length > 0" class="group-name" v-html="formattedGroupStat">
                    </div>
                    <div class="DFA d-filter" >
                    
                        <div class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto">
							<vz-select 
							    v-model="filteredSelectedIssueTypes" 
							    :options="filterIssueTypes" 
							    :multiple="true"  
							    class="multi-filter" 
							    :empty-selection-text="selectedIssueTypeMessage(filteredSelectedIssueTypes)" 
							    :selected-title="selectedIssueTypeMessage(filteredSelectedIssueTypes)" 
							    value-type="object" 
							    @select="onFilterSelectValue" 
							/>							
						</div>
						
                        <div v-if="allFilters.length>0" class="selectcont dropItem rhtsd rds4 ml-10 w-a h-auto"  v-for="filter in allFilters" :key="filter.id">
                            <vz-select 
                                :multiple="true" 
                                :empty-selection-text="getFilterTitle(filter)"
                                :selected-title="getFilterTitle(filter)"
                                class="multi-filter" 
                                value-type="object"
                                :options="filter.options"
                                v-model="filter.model"
                                @select="onFilterSelectValue" 
                            />
                        </div>
                    </div>
                </div>
                <div class="cntr mrow mb-5 scrollBar of-a detail-pad">
                    <div v-if="dataOfItems.length < 1" class="nofound fs-14">{{noDataMsg}}</div>                                  
                    <ul v-if=" data != undefined && dataOfItems.length > 0" class="table prow graphDetailPopUp popup-width-aa" id="items">
                        <li class="rec hd mb-0">
                            <div class="rc kyout c-point" data-header="key" @click="onClickSort('key')">Key
                            	<img v-if="sortBy.value =='key' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
                            </div>
                            <div class="rc c3 id c-point" data-header="details" @click="onClickSort('title')">Details
                            	<img v-if="sortBy.value =='title' " img src="/assets/icons/Dashboard/sort.svg" alt=".." class="ml-5 c-point sortIcon" :class="{'active':(this.sortBy.ascending)}"/>
                            </div>
                            <span style="display: none" data-header="title">Title</span>
                            <div v-for="column in columns.selected" class="rc c2" :class="[isSortableColumn($options.columsMap[column].title.toLowerCase())?'c-point':'']">
                                <span v-if="$options.columsMap[column]" @click="onClickSort($options.columsMap[column].title.toLowerCase())">
                                    <span :data-header="$options.columsMap[column].dataHeader" >{{$options.columsMap[column].title}}</span>
                                	<img 
                                      v-if="isSortableColumn($options.columsMap[column].title.toLowerCase()) && sortBy.value === $options.columsMap[column].title.toLowerCase()" 
                                      src="/assets/icons/Dashboard/sort.svg" 
                                      alt="Sort icon" 
                                      class="ml-5 c-point sortIcon" 
                                      :class="{ 'active': sortBy.ascending }" 
                                	/>
                                </span>
                            </div>
                        </li>  
                        <div class="prow poupupItemsList">  
                            <li class="rec mb-0" v-for="(item, index) in paginatedData"> 
                                <div class="rc kyout" v-if="item">
                                    <img v-if="item.fields?.itemTypeIcon || item.almFields?.issuetype?.iconUrl" :src="item.fields?.itemTypeIcon || item.almFields?.issuetype?.iconUrl" class="azurico" alt="Azure" />					
                                    <a v-if="item.almKey" class="key ftsb jiraKeyHandle kendisOnly" :href="item.url" target="_blank">{{item.almKey}}</a>
                                    <a v-else-if="item.kendisKey" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">{{item.kendisKey}}</a>
                                    <a v-else-if="item.fields && item.fields.externalKey" :href="item.fields.externalLink" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">{{item.fields.externalKey}}</a>
                                    <div v-else>--</div>
                                </div>
                                 			
                                <div class="rc c3 id c-point" v-if="item.title"><span v-if="!_.isEmpty(item.title)" class="" :title="item.title" data-header="title">{{item.title}}</span></div> 
                                <div v-for="column in columns.selected" class="rc c2 status padd">
                                    <div v-if="column === 'status'" style="margin-left: 2px;">
                                        <span class="sts new FL" v-if="item?.status && item.status?.id && statusMetaMap[item.status.id]" :class="categoryMetaMap[item.status.id] == 'ToDo' ? 'a' : categoryMetaMap[item.status.id] == 'InProgress' ? 'b' : categoryMetaMap[item.status.id] == 'Done' ? 'c' : 'd' " >
                                            <span data-header="status">{{statusMetaMap[item?.status?.id]}}</span>
                                        </span>
                                        <span v-else class="nofound">No Status</span>
                                    </div>		
                                    <div v-if="column === 'estimate'" class="DF DW gap-1">
                                        <span class="c3 spctg" v-if="item.storyPoints !== undefined && item.storyPoints !== null">
                                            <span class="ftsb" data-header="estimate">{{ item.storyPoints }}</span>
                                        </span>
                                        <span v-else class="nofound">No Estimate</span>
                                    </div>
                                    <div v-if="column === 'assignee'" class="">
                                        <div v-if="!_.isEmpty(almFieldMap) && almFieldMap[item?.id] && almFieldMap[item?.id][column] && almFieldMap[item?.id][column][0]" class="DFA tooltip assigneeBadge">
                                            <div class="pic mr-10" data-header="assignee" @click="onClickSort('assignee')">
                                                <div class="initial" :style="{ backgroundColor: '#1991EB' }">
                                                    {{ getInitials(almFieldMap[item?.id][column][0].value)}}
                                                </div>
                                            </div>
                                            <div class="hovtooltip">{{ almFieldMap[item?.id][column][0].value }}</div>
                                        </div>
                                        <span class="nofound" v-else>No Assignee</span>
                                    </div>
                                    <div v-else-if="!['status', 'estimate', 'teams', 'sprint', 'batches', 'boards', 'parent', 'solutionBoards'].includes(column)" class="DW gap-1">
                                        <span v-if="hasFieldData(item.id, column)">
                                            <span v-for="(field, index) in getFieldData(item.id, column)" :key="index">
                                              <span v-html="field.value"></span>
                                              <span v-if="index !== getFieldData(item.id, column).length - 1">, </span>
                                            </span>
                                          </span>
                                        <span class="nofound" v-else>No {{$options.columsMap[column].title}}</span>
                                    </div>  
                                    <div v-if="column === 'teams'" class="DF DW das-pop-sprint">
                                        <template v-if="!_.isEmpty(item.teamContainerRelations)">
                                            <div v-for="team in visibleTeamsAndSprints(teamMetaMap, item.teamContainerRelations, 'teamId')" 
                                                 :key="team.teamId">
                                                <div class="team-badge DAJ tooltip c-deflt margin-t"
                                                     :style="{ backgroundColor: widget.collectionsGraphCriteria.teamAndColorList[team.teamId] + '30', 
                                                               color: widget.collectionsGraphCriteria.teamAndColorList[team.teamId] }">
                                                    {{ team.detailMap.label }}
                                                    <div class="hovtooltipB l-t">
                                                        <span data-header="team">{{ team.detailMap.title }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        
                                            <!-- Hidden Teams +N count -->
                                            <div v-if="hiddenTeamAndSprintCount(teamMetaMap, item.teamContainerRelations, 'teamId') > 0" 
                                                 class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenTeamAndSprintCount(teamMetaMap, item.teamContainerRelations, 'teamId') }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenTeam in hiddenTeamAndSprints(teamMetaMap, item.teamContainerRelations, 'teamId')" 
                                                         :key="hiddenTeam.teamId"
                                                         class="team-badge DAJ tooltip c-deflt margin-t"
                                                         :style="{ backgroundColor: widget.collectionsGraphCriteria.teamAndColorList[hiddenTeam.teamId] + '30', 
                                                                   color: widget.collectionsGraphCriteria.teamAndColorList[hiddenTeam.teamId] }">
                                                        {{ hiddenTeam.detailMap.label }}
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else class="nofound">No Team</span>
                                    </div>
                                    <div v-if="column === 'sprint'" class="DF DW das-pop-sprint ">
                                        <template v-if="!_.isEmpty(item.teamContainerRelations)">
                                           <div v-for="sprint in visibleTeamsAndSprints(sprintMetaMap, item.teamContainerRelations, 'sprintId')" 
                                                 :key="sprint.teamId" class="spttg nsw mxwd tooltip">
                                                <span class="das-pop-sprint-name sss">
                                                    {{ sprint.detailMap.label }}
                                                </span>
                                                <div class="hovtooltipB l-s">
                                                    {{ sprint.detailMap.title + " (" + sprint.detailMap.boardTitle + ")" }}
                                                </div>
                                            </div>
                                            <div v-if="hiddenTeamAndSprintCount(sprintMetaMap, item.teamContainerRelations, 'sprintId') > 0"
                                                 class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenTeamAndSprintCount(sprintMetaMap, item.teamContainerRelations, 'sprintId') }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenSprint in hiddenTeamAndSprints(sprintMetaMap, item.teamContainerRelations, 'sprintId')" 
                                                         :key="hiddenSprint.teamId" class="spttg nsw mxwd tooltip">
                                                        <span class="das-pop-sprint-name sss">
                                                            {{ hiddenSprint.detailMap.label }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else class="nofound">No Sprint</span>
                                    </div>
                                     <div v-if="column === 'batches'" class="DF DW das-pop-sprint">
                                        <template v-if="!_.isEmpty(item.batchRelations)">
                                            <div v-for="(sprintValue, sprintKey) in visibleItems(item.batchRelations, column)" 
                                                 :key="sprintKey" class="spttg nsw mxwd tooltip">
                                                <span class="sss">
                                                    {{ batchMetaMap[sprintValue.baseItemId] }}
                                                </span>
                                                <div class="hovtooltipB">
                                                    {{ batchMetaMap[sprintValue.baseItemId]?.split(':').pop() }}
                                                </div>
                                            </div>
                                            <div v-if="hiddenItems(item.batchRelations, column).length > 0" class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenItemCount(item.batchRelations, column) }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenBatch in hiddenItems(item.batchRelations, column)" class="spttg nsw mxwd">
                                                        <span v-if="batchMetaMap[hiddenBatch.baseItemId]">
                                                            {{ batchMetaMap[hiddenBatch.baseItemId] }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else class="nofound">No Batch</span>
                                    </div>
                                     <div v-if="column === 'boards'" class="DF DW das-pop-sprint">
                                        <template v-if="!_.isEmpty(item.boardRelations)">
                                            <div  v-for="(sprintValue, sprintKey) in visibleItems(item.boardRelations, column)" :key="sprintKey" class="spttg nsw mxwd tooltip" v-if="sessionBoardMetaMap[sprintValue.sessionId]">
                                                <span class="das-pop-sprint-name sss">
                                                    {{sessionBoardMetaMap[sprintValue.sessionId]?.prefix ? sessionBoardMetaMap[sprintValue.sessionId]?.prefix : sessionBoardMetaMap[sprintValue.sessionId]?.title}}
                                                </span>
                                                <div class="hovtooltipB l-s">{{sessionBoardMetaMap[sprintValue.sessionId]?.title}}</div>	
                                            </div>
                                            <div v-if="hiddenItems(item.boardRelations, column).length > 0" class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenItems(item.boardRelations, column).length }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenBatch in hiddenItems(item.boardRelations, column)" class="spttg nsw mxwd">
                                                        <span>
                                                            {{ sessionBoardMetaMap[hiddenBatch.sessionId]?.prefix ? sessionBoardMetaMap[hiddenBatch.sessionId]?.prefix : sessionBoardMetaMap[hiddenBatch.sessionId]?.title }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else class="nofound">No Boards</span>
                                     </div>
                                     <div v-if="column === 'solutionBoards'" class="DF DW das-pop-sprint">
                                        <template v-if="!_.isEmpty(item.solutionRelations)">
                                            <div  v-for="(sprintValue, sprintKey) in visibleItems(item.solutionRelations, column)" :key="sprintKey" class="spttg nsw mxwd tooltip">
                                                <span class="das-pop-sprint-name sss">
                                                    {{ solutionBoardMetaMap[sprintValue.solutionId] }}
                                                </span>
                                                <div class="hovtooltipB l-s">{{ solutionBoardMetaMap[sprintValue.solutionId] }}</div>	
                                            </div>
                                            <div v-if="hiddenItems(item.solutionRelations, column).length > 0" class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenItems(item.solutionRelations, column).length }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenBatch in hiddenItems(item.solutionRelations, column)" class="spttg nsw mxwd">
                                                        <span>
                                                            {{ solutionBoardMetaMap[hiddenBatch.solutionId] }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else class="nofound">No Solution Boards</span>
                                     </div>
                                     <div v-if="column === 'parent'" class="DF DW das-pop-sprint">
                                        <template v-if="!_.isEmpty(item.parentRelationMap)">
                                            <div v-for="parent in visibleParents(item.parentRelationMap)">
                                                <div class="spttg nsw mxwd tooltip">
                                                    <span class="das-pop-sprint-name sss">
                                                        {{ parentMetaMap[parent.backlogItemId]?.key + ' : ' + getParentTitle(parent.backlogItemId) }}
                                                    </span>
                                                    <div class="hovtooltipB l-s">{{parentMetaMap[parent.backlogItemId]?.key + ' : ' +getParentTitle(parent.backlogItemId) }}</div>    
                                                </div>
                                            </div>
                                            <div v-if="hiddenParentCount(item.parentRelationMap) > 0" class="spttg nsw mxwd tooltip">
                                                <span>+{{ hiddenParentCount(item.parentRelationMap) }}</span>
                                                <div class="hovtooltip DF DW">
                                                    <div v-for="hiddenParent in hiddenParents(item.parentRelationMap)" 
                                                         class="spttg nsw mxwd tooltip">
                                                        <span class="das-pop-sprint-name sss">
                                                            {{ parentMetaMap[hiddenParent.backlogItemId]?.key + ' : ' + getParentTitle(hiddenParent.backlogItemId) }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <span v-else>No Parent</span>
                                    </div>
                                </div> 
                            </li>    
                        </div>                                        
                    </ul>
                </div>
                <div class="prow pagging pb-15" style="padding-left: 70px;">
                       <input hidden="hidden" type="number" title="temporary binding due to redrening issue"/>
                       <template>
                            <div class="paginator">
                               <vue-ads-pagination :key="paginationKey" :total-items="pagination.totalItemSize" :items-per-page="pagination.pageSize" v-on:page-change="onPaginatorChangePage">
                                    <template slot-scope="props"><div class="txt">{{ props.start }} to {{ props.end }} of {{ props.total }} Items</div></template>
                               </vue-ads-pagination>
                           </div>
                           <span class="selectcont pgsize" style="margin-left: 0;">
                               <select v-model="pagination.pageSize" class="" @change="onChangePageSizeofpopup">
                                    <option v-for="option in pagination.pageSizeOptions" :value="option">{{option}}</option>
                               </select>
                           </span>
                       </template>
                </div>
            </div>
    </div>`,

    props: ["filter", "level", "releaseTrainId", "data", "widget", "group", "groupStat", "filterCriteria", "groups", "groupsWithIds", "itemType"],

    data() {
        return {
            groupItemPayload: null,
            isGroupIdObject: false,
            releaseTrain: null,
            paginationKey: 0,
            almError: {
                show: false,
                message: ""
            },
            batchesList: [],
            teamsList: [],
            sprintsList: [],
            root: {
                flags: {
                    teams: false,
                    status: false,
                    boards: false,
                    containers: false,
                    solutionBoards: false,
                    batches: false
                }
            },
            paginatedData: [],
            noData: false,
            noDataMsg: 'No Data',
            mainTitle: '',
            totalItemsCount: '',
            subTitle: '',
            type: '',
            popupData: [],
            selectedSprint: [],
            selectedTeam: [],
            filterTeams: [],
            filteredSelectedTeams: [],
            filterSprints: [],
            filteredSelectedSprints: [],
            filterIssueTypes: [],
            filteredSelectedIssueTypes: [],
            sortableColumns: ['key', 'title', 'status', 'estimate', 'Assignee', 'Time (in Days)', 'Start Date', 'End Date'],
            $options: {
                columsMap: {},
                columnOptions: [],
                teamFilterOptions: [],
                sprintFilterOptions: [],
                issueTypeFilterOptions: []
            },
            columns: {
                selected: [],
                selectedMap: {}
            },
            filterColumn: {
                selectedTeam: [],
                selectedTeamMap: {},
                selectedSprint: [],
                selectedIssueType: [],
                selectedSprintMap: {}
            },
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 50,
                pageIndex: 0,
                pageSizeOptions: [10, 20, 50, 100],
                totalItemSize: 0,
            },
            loader: {
                show: false,
                title: ""
            },
            backlogItemsLoaded: false,
            filters: {
                searchText: "",
                isApplied: false,
                filterCriteria: {},
                filter: {},
                filtersCount: 0,
                show: false
            },
            dataOfItems: [],
            allDataOfItems: [],
            dumpDataOfItems: [],
            loaded: false,
            graphSpecificType: null,
            fromStatus: null,
            toStatus: null,
            grouping: null,
            groupByString: '',
            sortBy: {
                value: "created",
                ascending: true,
            },
            search: {
                text: ""
            },
            statusMetaMap: {},
            categoryMetaMap:{},
            teamMetaMap: {},
            sprintMetaMap: {},
            batchMetaMap: {},
            parentMetaMap: {},
            solutionBoardMetaMap: {},
            sessionBoardMetaMap: {},
            selectedCollection: null,
            additionalGroupByFilters: {
                adoOptions: [
                    {title: "Area Path", id: "AreaPath", sort: true, class: "c3"},
                    {title: "Iteration Path", id: "Iteration", sort: true, class: "c3"},
                    {title: "ADO Project", id: "Project", sort: true, class: "c3"},
                ],
                jiraOptions: [
                    {title: "Jira Project", id: "jiraProject", sort: true, class: "c3", sortCommand: ""},
                ],
            },
            collectionType: "",
            customFields: '',
            almFieldMap: {},
            localItems: [],
            dataHistory: [{}],
            totalItems: 0,
            callType: "",
            allFilters: [],
            dynamicFilterOptions: {},
            dynamicFilterModel: {},
            selectedFilters: [],
            keyFilters: [],
            kendisCustomFields: [],
        }
    },
    created() {
    },
    components: {
        VueAdsPagination: window["vue-ads-pagination"].default,
        VueAdsPageButton: window["vue-ads-pagination"].VueAdsPageButton,
    },
    mounted() {
        this.loader.show = true;
        this.root.flags.teams = true;
        this.root.flags.status = true;
        this.root.flags.boards = true;
        this.root.flags.containers = true;
        this.root.flags.solutionBoards = true;
        this.totalItems = parseInt(this.group.size, 10);
        if (isNaN(this.totalItems)) this.totalItems = 0;
        if (this.totalItems === 0) {
            this.loader.show = false;
            return;
        }
        this.fetchReleaseTrain();
        this.pagination.totalItemSize = this.totalItems;
    },
    watch: {
        'search.text': {
            handler(newVal) {
                this.onSearchInput(newVal);
            },
            immediate: true
        }
    },
    computed: {

        formattedGroupStat() {
            return `${this.groupStat.name.trim()} : ${this.groupStat.size}`;
        },

        totalEstimateTooltip() {
            return "Rollup Estimate";
        },

        selectedIssueTypeMessage: function(){
            return function(selectedIssueType){
                let issueTypeMessage = "Issue Type";
                if(selectedIssueType){
                    issueTypeMessage = issueTypeMessage + " (" + selectedIssueType.length + ")";
                }
                return issueTypeMessage;
            }
        },

        getFilterTitle: function() {
            return function(filter) {
                return filter.selectedMessage + " (" + filter.model.length + ")";
            }
        },
    },
    methods: {

        getInitials(name) {
            if (!name || typeof name !== 'string') return '';
            const parts = name.trim().split(' ');
            return parts.map(p => p[0]).join('').toUpperCase();
        },

        loadPopupData: function () {
            return axios.post('/releasetrain/backlog/backlogGroupItems', this.groupItemPayload)
                .then(res => {
                    if (res.data) {
                        this.loader.show = false;
                        const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
                        const endIndex = startIndex + this.pagination.pageSize;
                        this.dataOfItems = res.data.items;
                        this.allDataOfItems = [...res.data.items];
                        this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
                        this.fetchStatusMeta();
                    }else{
                        this.loader.show = false;
                    }
                })
                .catch(error => {
                    console.error("Error fetching Group Items: ", error);
                });

        },

        getFieldKey(column) {
            const title = this.getTitleOfKendisCustomField(column);
            return title !== '' ? title : column;
        },

        getFieldData(itemId, column) {
            const fieldKey = this.getFieldKey(column);
            // fieldKey.replace(/\./g, "_")
            return this.almFieldMap?.[itemId]?.[fieldKey] || [];
        },

        hasFieldData(itemId, column) {
            const data = this.getFieldData(itemId, column);
            return Array.isArray(data) && data.length > 0;
        },

        removeHtmlTags(html) {
            if (!html) return "";
            const doc = new DOMParser().parseFromString(html, "text/html");
            return doc.body.textContent || "";
        },

        getFilteredData(metaMap, containerRelations, key) {
            return Object.entries(metaMap)
                .filter(([metaId]) => containerRelations.some(relation => relation[key] === metaId))
                .map(([metaId, detailMap]) => ({ teamId: metaId, detailMap }));
        },

        visibleTeamsAndSprints(metaMap, containerRelations, key) {
            return this.getFilteredData(metaMap, containerRelations, key).slice(0, 2);
        },

        hiddenTeamAndSprints(metaMap, containerRelations, key) {
            return this.getFilteredData(metaMap, containerRelations, key).slice(2);
        },

        hiddenTeamAndSprintCount(metaMap, containerRelations, key) {
            return this.hiddenTeamAndSprints(metaMap, containerRelations, key).length;
        },

        hiddenItems(items, type = null) {
            if (!items) return [];
            items = _.compact(items);
            const uniqueMap = new Map();
            if(type === "boards"){
                for (const item of items) {
                    if (item?.sessionId && this.sessionBoardMetaMap.hasOwnProperty(item.sessionId) && !uniqueMap.has(item.sessionId)) {
                        uniqueMap.set(item.sessionId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(2);
            }else if(type === "batches"){
                for (const item of items) {
                    if (item?.baseItemId && !uniqueMap.has(item.baseItemId)) {
                        uniqueMap.set(item.baseItemId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(2);
            }else if(type === "solutionBoards"){
                for (const item of items) {
                    if (item?.solutionId && this.solutionBoardMetaMap.hasOwnProperty(item.solutionId) && !uniqueMap.has(item.solutionId)) {
                        uniqueMap.set(item.solutionId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(2);
            }
            return items.slice(2);
        },

        hiddenItemCount(items, type=null) {
            const hiddenLength = this.hiddenItems(items).length;
            return hiddenLength;
        },

        visibleItems(items, type = null) {
            if (!items) return [];
            items = _.compact(items);
            const uniqueMap = new Map();
            if(type === "boards"){
                for (const item of items) {
                    if (item?.sessionId && !uniqueMap.has(item.sessionId)) {
                        uniqueMap.set(item.sessionId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(0, 2);
            }else if(type === "batches"){
                for (const item of items) {
                    if (item?.baseItemId && !uniqueMap.has(item.baseItemId)) {
                        uniqueMap.set(item.baseItemId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(0, 2);
            }else if(type === "solutionBoards"){
                for (const item of items) {
                    if (item?.solutionId && this.solutionBoardMetaMap.hasOwnProperty(item.solutionId) && !uniqueMap.has(item.solutionId)) {
                        uniqueMap.set(item.solutionId, item);
                    }
                }
                return Array.from(uniqueMap.values()).slice(0, 2);
            }
            return items.slice(0, 2);
        },

        getFilteredParents(parentRelationMap) {
            return Object.entries(parentRelationMap)
                .flatMap(([parentKey, relations]) =>
                    relations.map(relation => ({
                        parentKey,
                        backlogItemId: relation.backlogItemId
                    }))
                )
                .filter(parent => this.getParentTitle(parent.backlogItemId));
        },

        visibleParents(parentRelationMap) {
            return this.getFilteredParents(parentRelationMap).slice(0, 1);
        },

        hiddenParents(parentRelationMap) {
            return this.getFilteredParents(parentRelationMap).slice(1);
        },

        hiddenParentCount(parentRelationMap) {
            return this.hiddenParents(parentRelationMap).length;
        },


        getTitleOfKendisCustomField(id){
            let _this = this;
            let opt = _this.$options.columnOptions.find(opt => opt.id === id)
            const isAlphanumericId = /^[a-f0-9]{24}$/i.test(id);

            if (isAlphanumericId) {
                let opt = _this.$options.columnOptions.find(opt => opt.id === id);
                if (opt && opt.title) {
                    return opt.title;
                }
            }
            return "";
        },

        getParentTitle(backlogItemId) {
            if (typeof backlogItemId === "string" ) {
                return this.parentMetaMap[backlogItemId]?.title || "Unknown Parent";
            }
        },

        // onSelectIssueType(){
        //     this.onFilterSelectValue();
        // },

        filterDataBasedOnIssueType(){
            if(this.filteredSelectedIssueTypes) {
                const releaseTrainId = this.widget.collectionsGraphCriteria.releaseTrainId;
                _.each(this.dataOfItems, (dashboard) => {
                    const hasKendisKey = !!dashboard?.kendisKey;
                    const almType = dashboard?.almType;
                    const hasEmptyAlmFields = Object.keys(dashboard.almFields || {}).length === 0;
                    const isKendisOnlySelected = this.filteredSelectedIssueTypes.some(item => item.id === "Kendis Only");
                    if (hasKendisKey && hasEmptyAlmFields && !dashboard?.almItemId) {
                        dashboard.filterOn = isKendisOnlySelected;
                    } else if (almType && dashboard.almKey) {
                        dashboard.filterOn = this.filteredSelectedIssueTypes.some(selectedType =>
                            selectedType.title === almType);
                    }
                    else if (dashboard.almFields) {
                        dashboard.filterOn = this.filteredSelectedIssueTypes.some(selectedType =>
                            dashboard.almFields["issuetype"]?.name === selectedType.title
                        );
                    }
                });
                this.dataOfItems = this.dataOfItems.filter(dashboard => dashboard.filterOn);
                const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
                const endIndex = startIndex + this.pagination.pageSize;
                this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
                this.pagination.totalItemSize = this.dataOfItems.length;
            }else{
                this.pagination.totalItemSize = this.allDataOfItems.length;
                this.dataOfItems = []
            }
        },

        fetchIssueTypes() {
            const issueTypeMap = new Map();
            if(this.releaseTrain) {
                this.releaseTrain?.tfsProjects?.forEach(project => {
                    project?.workFlow?.statuses?.forEach(type => {
                        const title = type.itemType.trim();
                        if (!issueTypeMap.has(title)) {
                            issueTypeMap.set(title, {
                                title: title,
                                id: title,
                            });
                        }
                    })
                });

                this.releaseTrain.backlogHierarchyLevels.forEach(issue => {
                    issue?.almHierarchyLevelMappings?.forEach(almLevel => {
                        almLevel?.jiraIssueTypes?.forEach(type => {
                            const title = type.name.trim();
                            if (!issueTypeMap.has(title)) {
                                issueTypeMap.set(title, {
                                    title: title,
                                    id: title,
                                });
                            }

                        });
                    });
                });
                this.filterIssueTypes = Array.from(issueTypeMap.values());
            }
            this.filterIssueTypes.push({
                title: "Kendis Only",
                id: "Kendis Only",
            });
            this.filteredSelectedIssueTypes = [...this.filterIssueTypes];
        },

        loadItemsOfBacklog: function (pageStart) {
            let existingData = {};
            let requiredPageSize = 0;
            let data = {};

            requiredPageSize = this.pagination.pageSize;
            let startIndex = pageStart * requiredPageSize;
            let itemsToFetch = requiredPageSize;
            itemsToFetch <= 0 && (itemsToFetch = this.pagination.totalItemSize - startIndex);
            if (isNaN(itemsToFetch)) return;
            existingData = this.findExistingData(startIndex, itemsToFetch);

            if (itemsToFetch === 0 || existingData.adjustedStartIndex === -1 || existingData.adjustedSize > this.totalItems) {
                this.dataOfItems = this.getPaginatedData(pageStart, requiredPageSize);
                this.paginatedData = this.dataOfItems
                return;
            }
           
            data = {
                releaseTrainId: this.widget.collectionsGraphCriteria.releaseTrainId,
                groupType: this.group.type,
                hierachLevel: this.widget.collectionsGraphCriteria.hierarchyLevelId !== "" ? this.widget.collectionsGraphCriteria.hierarchyLevel : this.widget.criteria.level.toString(),
                fetchParents: true,
                rollupSprints: true,
                rollupBatches: true,
                rollupStoryPointsArray: true,
                groupValueType: this.widget.collectionsGraphCriteria.type || ""
            };

            data.pageStart = existingData.adjustedStartIndex.toString();
            data.pageSize = existingData.adjustedSize.toString();
            if (this.group.groupId) {
                data.groupId = this.group.groupId;
            }
            if (!data?.groupType || !data?.pageSize) return;
            if (
                this.filter.filterCriteria &&
                (this.filter.filterCriteria.rules?.length > 0)
            ) {
                data.filter = this.filter.filterCriteria;
            }
            if (this.widget.collectionsGraphCriteria.hierarchyLevelId === "") {
                if (!data.filter) {
                    data.filter = { condition: "AND", rules: [] };
                }
                if (!data.filter.rules) {
                    data.filter.rules = [];
                }
                const ruleExists = data.filter.rules.some(rule =>
                    JSON.stringify(rule) === JSON.stringify(this.widget.criteria.criteria.rules[0]) // Deep comparison
                );
                if (!ruleExists) {
                    data.filter.rules.push(this.widget.criteria.criteria.rules[0]);
                }
            }

            this.fetchBacklogGroupItems(data)
                .then(res => {
                    if (res.data) {
                        let newItems = res.data.items;
                        if (newItems.length) {
                            this.dataHistory.push({
                                pageStart: data.pageStart,
                                pageSize: data.pageSize,
                                items: newItems
                            })
                            this.localItems = [...this.localItems, ...newItems];
                            // this.pagination.totalItemSize = this.totalItems;
                            this.dataOfItems = this.getPaginatedData(pageStart, requiredPageSize);
                            this.paginatedData = this.dataOfItems
                        }
                    }
                })
                .catch(error => {
                    console.error("Error fetching data:", error);
                });
        },

        findExistingData(startIndex, itemsToFetch) {
            let adjustedStartIndex = startIndex;
            let adjustedSize = itemsToFetch;
            let requestedEndIndex = startIndex + itemsToFetch;
            let isFullyCached = this.dataHistory.some(entry => {
                let historyStart = parseInt(entry.pageStart);
                let historyEnd = historyStart + parseInt(entry.pageSize);
                return historyStart <= startIndex && historyEnd >= requestedEndIndex;
            });
            if (isFullyCached)
                return {adjustedStartIndex: -1, adjustedSize: 0};

            this.dataHistory = this.dataHistory.filter(entry => {
                let historyStart = parseInt(entry.pageStart);
                let historyEnd = historyStart + parseInt(entry.pageSize);
                let isOverlapping = historyStart >= startIndex && historyEnd <= requestedEndIndex;
                return !isOverlapping;
            });
            return {adjustedStartIndex, adjustedSize};
        },

        fetchReleaseTrains: function (data) {
            return axios.post("/dashboard/fetch-all-release-trains", data)
                .then(response => response)
                .catch(error => {
                    console.error("Error fetching release trains:", error);
                });
        },

        fetchBacklogGroupItems: function (data) {
            return axios.post('/releasetrain/backlog/backlogGroupItems', data)
                .then(response => response)
                .catch(error => {
                    console.error("Error fetching release trains:", error);
                });
        },

        fetchGroupingForAlms: function (requestBody) {
            return axios.post("/dashboard/retrieveGroupingForAlms", requestBody)
                .then(response => response)
                .catch(error => {
                    console.error("Error fetching grouping for ALMs:", error);
                });
        },

        fetchReleaseTrain: function () {
            const groupsArray = Array.isArray(this.group) ? this.group : [this.group];
            const promises = groupsArray.map(group => {
                let data = {
                    releaseTrainId: this.widget.collectionsGraphCriteria.releaseTrainId,
                    groupType: group.type,
                    hierachLevel: this.widget.collectionsGraphCriteria.hierarchyLevelId !== "" ? this.widget.collectionsGraphCriteria.hierarchyLevel : this.widget.criteria.level.toString(),
                    fetchParents: true,
                    rollupSprints: true,
                    rollupBatches: true,
                    rollupStoryPointsArray: true
                };

                // Only add groupId if it's defined and not "null"
                if ((group.groupId !== undefined && group.groupId !== "null") &&  group.groupId !== "undefined") {
                    data.groupId = group.groupId;
                }

                let pageSize = 50;
                data.pageStart = "" + 0;
                if(group?.size){
                    data.pageSize = group?.size.toString();
                }
                data.groupValueType = this.widget.collectionsGraphCriteria.type  || "";
                group.loading = true;

                if (!Number.isInteger(parseFloat(data.pageSize))) {
                    const currentGroup = this.groups.find(g => g.groupId === group.groupId)
                    if(currentGroup?.originalValue){
                        data.pageSize = currentGroup?.originalValue?.toString()
                    }else {
                        data.pageSize = currentGroup?.y?.toString()
                    }
                }
                let req = {id: this.widget.collectionsGraphCriteria.releaseTrainId};
                return axios.post("/releasetrain/" + this.widget.collectionsGraphCriteria.releaseTrainId, req)
                    .then(response => {
                        this.releaseTrain = response.data;
                        this.fetchIssueTypes();
                        if (response.data?.layouts && response.data?.layouts?.kendisCard && response.data?.layouts?.kendisCard.fields) {
                            this.kendisCustomFields = response.data?.layouts?.kendisCard.fields.map(field => ({id: field.field.id, title: field.field.title, sort: false, class: "c3", sortCommand: ""}));
                        }
                        if (response.data.releaseTrain.almFilters?.length > 0) {
                            if (response.data.releaseTrain.almFilters[0]?.jiraFilter) {
                                this.collectionType = "jira";
                                if (this.widget.collectionsGraphCriteria.hierarchyLevelId === "") {
                                    data.filter = this.widget.criteria.criteria;
                                }
                            } else if (response.data.releaseTrain.almFilters[0]?.tfsFilter) {
                                this.collectionType = "ado";
                                if (this.widget.collectionsGraphCriteria.hierarchyLevelId === "") {
                                    data.filter = this.widget.criteria.criteria;
                                }
                            }
                        } else {
                            if (this.widget.collectionsGraphCriteria.hierarchyLevelId === "") {
                                data.filter = this.widget.criteria.criteria;
                            }
                        }
                        if(this.itemType){
                            data.optionType = this.itemType;
                        }

                        this.isGroupIdObject = this.widget.collectionsGraphCriteria.groups.some(group => group.isGroupIdObject === "true");

                        if(this.isGroupIdObject){
                            data.groupValueType = "array";
                            data.optionType = "version";
                        }

                        let gId = null;
                        let g = null;
                        if (group.groupId != undefined && group.groupId != "null") {
                            gId = group.groupId;
                        }

                        if (gId === null) {
                            g = this.groupsWithIds.find(group => !group.id);  // find group where `id` is missing or falsy
                        } else {
                            g = this.groupsWithIds.find(group => group.groupId === gId);
                        }

                        if (g?.multiIds && !_.isEmpty(g?.multiIds)) {
                            let multipleGroups = [null];
                            _.each(g.multiIds, gid => {
                                multipleGroups.push(gid);
                            });
                            data.groupIds = multipleGroups;
                        }
                        if (g?.excludeGroupIds && !_.isEmpty(g?.excludeGroupIds)) {
                            data.excludeGroupIds = g.excludeGroupIds;
                        }

                        this.groupItemPayload = data;

                        this.loadPopupData();
                    })
                    .catch(error => {
                        console.error("Error fetching release trains:", error);
                    });
            });
            return Promise.all(promises);
        },

        getFilterCriteria: function () {
            let filters = _.cloneDeep(this.filters.filterCriteria);
            if (_.isEmpty(filters)) {
                filters = {condition:"AND"};
            }
            if (!_.isEmpty(this.search.text)) {
                if (!filters.rules) {
                    filters.rules = [];
                }
                let titleFilter = _.find(filters.rules,{key:"title-id"});
                if (!titleFilter) {
                    titleFilter = {key:"title-id",value:[],operator:"EQUALS",type:"text"};
                    filters.rules.push(titleFilter);
                }
                titleFilter.value.push(this.search.text.trim());
            }
            return filters;
        },

        getPaginatedData: function (pageNumber, pageSize) {
            let startIndex = pageNumber * pageSize;
            let endIndex = startIndex + pageSize;
            if (endIndex > this.totalItems)
                endIndex = this.totalItems;
            // this.pagination.totalItemSize = this.totalItems;
            this.resetPages();

            for (let entry of this.dataHistory) {
                let historyStart = parseInt(entry.pageStart);
                let historyEnd = historyStart + parseInt(entry.pageSize);
                if (historyStart <= startIndex && historyEnd >= endIndex) {
                    let offsetStart = startIndex - historyStart;
                    let offsetEnd = offsetStart + pageSize;
                    let lastPageSize = endIndex % pageSize;
                    if(lastPageSize !== 0){
                        offsetEnd = lastPageSize
                    }
                    return entry.items.slice(offsetStart, offsetStart + offsetEnd);
                }
            }
            return this.localItems.slice(startIndex, endIndex);
        },

        onChangePageSizeofpopup() {
            this.resetPages();
            this.pagination.pageIndex = 0;
            const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
            const endIndex = startIndex + this.pagination.pageSize;
            this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
            this.paginationKey++;
        },

        resetPages() {
            this.pagination.pageIndex = 0;
            // this.pagination.totalItemSize = this.totalItems;
        },

        onPaginatorChangePage(pageNumber) {
            this.pagination.pageIndex = pageNumber;
            this.pagination.avoidPaginatorAtFirstLoad = false;
            const startIndex = (pageNumber) * this.pagination.pageSize;
            const endIndex = startIndex + this.pagination.pageSize;
            this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
        },

        fetchCustomFields: function () {
            let _this = this;
            // let data = {};
            // data.fetchTypes = false;
            // this.fetchReleaseTrains(data)
                // .then(response => {
                    if (this.releaseTrain?.releaseTrain) {
                        _this.selectedCollection = this.releaseTrain.releaseTrain;
                        if (!this.selectedCollection) return;
                        let hierarchyLevel = this.selectedCollection.level;
                        let linkedAlmHierarchyId = this.selectedCollection.linkedAlmHierarchy;
                        let linkedAlmAccounts = this.selectedCollection.linkedAlmAccounts;
                        const ids = Array.isArray(linkedAlmAccounts)
                            ? linkedAlmAccounts.map(account => account.id)
                            : [];

                        let requestBody = {
                            hierarchyLevel: hierarchyLevel,
                            linkedAlmAccounts: ids,
                            linkedAlmHierarchyId: linkedAlmHierarchyId,
                            releaseTrainId: this.selectedCollection.id,
                        };

                        this.fetchGroupingForAlms(requestBody).then(response => {
                            let adoFilters = [];
                            let jiraFilters = [];
                            let type = '';
                            if (this.selectedCollection.almFilters?.length > 0) {
                                if (this.selectedCollection.almFilters[0]?.jiraFilter && !this.additionalGroupByFilters.jiraOptionsIncluded) {
                                    type = "jira";
                                    this.collectionType = type;
                                    _this.$options.columsMap["jiraProject"] = _this.additionalGroupByFilters.jiraOptions[0];
                                } else if (this.selectedCollection.almFilters[0]?.tfsFilter && !this.additionalGroupByFilters.adoOptionsIncluded) {
                                    type = "ado";
                                    this.collectionType = type;
                                    _this.additionalGroupByFilters.adoOptions.forEach(f => {
                                        _this.$options.columsMap[f.id] = f
                                    });
                                }
                            }
                            jiraFilters = response.data?.almFields.map(alm => {return { title: alm.name, id: alm.id, sort: false, class: "c3", sortCommand: ""}})
                            adoFilters = response.data?.almFields.map(alm => {return { title: alm.name, id: alm?.referenceName?.replace(/\./, "_"), sort: false, class: "c3", sortCommand: ""}})
                            if (type === "ado") {
                                adoFilters.forEach(column => {_this.$options.columsMap[column.id] = column})
                            } else if (type === "jira") {
                                jiraFilters.forEach(column => {_this.$options.columsMap[column.id] = column})
                            }else if(jiraFilters.length > 0){
                                type = "jira";
                                jiraFilters.forEach(column => {_this.$options.columsMap[column.id] = column})
                            }
                            if(this.kendisCustomFields){
                                this.kendisCustomFields.forEach(column => {_this.$options.columsMap[column.id] = column})
                            }
                            _this.$options.columnOptions = Object.values(_this.$options.columsMap);
                            _this.$forceUpdate();

                            this.initializeItemsData();

                            this.columns.selected = this.columns.selected.filter(
                                column => this.$options.columnOptions.some(option => option.id === column)
                            );

                            // const selectedOption = _this.$options.columnOptions.find(o => o.title === this.widget.collectionsGraphCriteria.groupTitle);
                            // if (selectedOption && !this.columns.selected.includes(selectedOption?.id)) {
                            //     this.columns.selected.push(selectedOption?.id);
                            // }

                            _this.populateFilterOptions();
                        }).catch(error => {
                            console.error("Error fetching data of grouping", error)
                        });
                    }
                // })
        },

        fetchStatusMeta: function () {
            //this function is getting status titles from db based on ids
            let statusIds = new Set();
            let teamIds = new Set();
            let sprintIds = new Set();
            let batchIds = new Set();
            let sessionIds = new Set();
            let parentIds = new Set();
            let solutionIds = new Set();
            let tenant = new Set();
            if (this.allDataOfItems.length === 0) return;
            for (let index in this.allDataOfItems) {
                let fieldMap = {};
                statusIds.add(this.allDataOfItems[index]?.status?.id);
                for (let innerIndex in this.allDataOfItems[index].teamContainerRelations) {
                    teamIds.add(this.allDataOfItems[index].teamContainerRelations[innerIndex].teamId);
                    sprintIds.add(this.allDataOfItems[index].teamContainerRelations[innerIndex].sprintId);
                    tenant.add(this.allDataOfItems[index].teamContainerRelations[innerIndex].tenant);
                }
                for (let innerIndex in this.allDataOfItems[index].batchRelations) {
                    batchIds.add(this.allDataOfItems[index].batchRelations[innerIndex].baseItemId);
                    tenant.add(this.allDataOfItems[index].batchRelations[innerIndex].tenant);
                }
                for (let innerIndex in this.allDataOfItems[index].boardRelations) {
                    const sessionId = this.allDataOfItems[index].boardRelations?.[innerIndex].sessionId;
                    // if (sessionId) {
                        sessionIds.add(this.allDataOfItems[index].boardRelations?.[innerIndex].sessionId);
                    // }
                    tenant.add(this.allDataOfItems[index].boardRelations[innerIndex].tenant);

                }
                for (let innerIndex in this.allDataOfItems[index].solutionRelations) {
                    solutionIds.add(this.allDataOfItems[index].solutionRelations[innerIndex].solutionId);
                    tenant.add(this.allDataOfItems[index].solutionRelations[innerIndex].tenant);
                }
                for (let innerIndex in this.allDataOfItems[index].parentRelationMap) {
                    for (let parent in this.allDataOfItems[index].parentRelationMap[innerIndex]) {
                        if(innerIndex === this.widget.collectionsGraphCriteria.releaseTrainId) {
                            let backlogItemId = this.allDataOfItems[index].parentRelationMap[innerIndex][parent]?.backlogItemId;

                            if (typeof backlogItemId === "string") {  // Ensure only string values are added
                                parentIds.add(backlogItemId);
                            }
                            tenant.add(this.allDataOfItems[index].parentRelationMap[innerIndex][parent].tenant);
                        }
                    }
                }

                Object.entries(this.allDataOfItems[index]?.fields).forEach(([key, value]) => {
                    if (key === "tfsIterationPath") {
                        this.fieldMapForAdoCollection("Iteration", value, fieldMap);
                    } else if (key === "tfsProject") {
                        this.fieldMapForAdoCollection("Project", value, fieldMap);
                    } else if (key === "tfsAreaPath") {
                        this.fieldMapForAdoCollection("AreaPath", value, fieldMap);
                    }else{
                        const field = this.kendisCustomFields.find(field => field.id === key);
                        if(field){
                            this.fieldMapForAdoCollection(field.title, value, fieldMap);
                        }
                    }
                });

                Object.entries(this.allDataOfItems[index]?.almFields).forEach(([key, value]) => {
                    key = key === "project" ? "jiraProject" : key;
                    if (!fieldMap[key]) fieldMap[key] = [];
                    if (!this.dynamicFilterOptions[key]) this.dynamicFilterOptions[key] = new Set();

                    // if (typeof value === 'object' && value !== null) {
                    //     fieldMap[key].push({value: value.displayName || value.name || value.value || value});
                    //     this.dynamicFilterOptions[key].add(value.displayName || value.name || value.value || value);
                    // }

                    if (Array.isArray(value)) {
                        value.forEach(item => {
                            const extractedValue = item?.displayName || item?.name || item?.value || item;
                            fieldMap[key].push({ value: extractedValue });
                            this.dynamicFilterOptions[key].add(extractedValue);
                        });
                    }
                    else if (typeof value === 'object') {
                        if(value !== null && Object.keys(value).length > 0) {
                            const extractedValue = value.displayName || value.name || value.value;

                            if (extractedValue) {
                                fieldMap[key].push({value: extractedValue});
                                this.dynamicFilterOptions[key].add(extractedValue);
                            }
                        }
                    }
                    else {
                        value = value.toString();
                        fieldMap[key].push({value});
                        this.dynamicFilterOptions[key].add(value);
                    }
                })
                this.almFieldMap[this.allDataOfItems[index].id] = fieldMap;
            }

            let data = {};
            let sIds = Array.from(statusIds);
            let tIds = Array.from(teamIds);
            let spIds = Array.from(sprintIds);
            let bIds = Array.from(batchIds);
            let sessIds = Array.from(sessionIds);
            let pIds = Array.from(parentIds);
            let sbIds = Array.from(solutionIds);

            data.statusIds = sIds;
            data.teamIds = tIds;
            data.sprintIds = spIds;
            data.sessionIds = sessIds;
            data.batchIds = bIds;
            data.parentIds = pIds;
            data.solutionIds = sbIds;
            data.tenant = tenant.values().next().value || "";
            // this.populateColumnsOptions();
            axios.post('/dashboard/fetchItemsMeta', data).then(
                res => {
                    this.statusMetaMap = res.data.statusMap;
                    this.categoryMetaMap = res.data.categoryMap
                    this.sprintMetaMap = res.data.sprintMap;
                    this.teamMetaMap = res.data.teamMap;
                    this.batchMetaMap = res.data.batchMap;
                    this.sessionBoardMetaMap = res.data.sessionMap;
                    this.parentMetaMap = res.data.parentMap;
                    this.solutionBoardMetaMap = res.data.solutionBoardMap;
                    this.populateColumnsOptions();
                    this.populateFilterOptions();
                }
            )
        },

        fieldMapForAdoCollection: function(key, value, fieldMap){
            if (!fieldMap[key]) fieldMap[key] = [];
            if (!this.dynamicFilterOptions[key]) this.dynamicFilterOptions[key] = new Set();
            if (Array.isArray(value)) {
                value.forEach(item => {
                    const extractedValue = item?.title || item?.name || item?.value || item?.displayName || item?.fullName || item;
                    fieldMap[key].push({ value: extractedValue });
                    this.dynamicFilterOptions[key].add(extractedValue);
                });
            }else if(typeof value === "object"){
                if(value !== null && Object.keys(value).length > 0) {
                    const extractedValue = value?.title || value?.name || value?.displayName || value?.fullName || value?.value || value;
                    fieldMap[key].push({value: extractedValue});
                    this.dynamicFilterOptions[key].add(extractedValue);
                }
            } else{
                fieldMap[key].push({value});
                this.dynamicFilterOptions[key].add(value);
            }
        },

        onSelectSprintOrTeamFilterData: function (filterType) {
            if ((this.filteredSelectedTeams == undefined || this.filteredSelectedTeams.length == 0)) {
                _.each(this.allDataOfItems, dashboard => {
                    dashboard.filterOn = false;
                });
            }
            if ((this.filteredSelectedSprints == undefined || this.filteredSelectedSprints.length == 0)) {
                _.each(this.allDataOfItems, dashboard => {
                    dashboard.filterOn = false;
                });
            }
            if ((this.filteredSelectedIssueTypes == undefined || this.filteredSelectedIssueTypes.length == 0)) {
                _.each(this.allDataOfItems, dashboard => {
                    dashboard.filterOn = false;
                });
            }
            if ((this.filteredSelectedTeams == undefined || this.filteredSelectedTeams.length == 0) || (this.filteredSelectedSprints == undefined || this.filteredSelectedSprints.length == 0) || (this.filteredSelectedIssueTypes == undefined || this.filteredSelectedIssueTypes.length == 0)) {
                _.each(this.allDataOfItems, dashboard => {
                    dashboard.filterOn = false;
                });
            } else if (this.filterTeams.length === this.filteredSelectedTeams.length && this.filterSprints.length === this.filteredSelectedSprints.length && this.filterIssueTypes.length === this.filteredSelectedIssueTypes.length) {
                _.each(this.allDataOfItems, dashboard => {
                    dashboard.filterOn = true;
                });
            } else if (this.filteredSelectedTeams.length > 0) {
                this.allDataOfItems.forEach(dataItem => {
                    const teamKeys = Object.keys(dataItem.teams || {});
                    const sprintKeys = Object.keys(dataItem.sprints || {});
                    const issueType = dataItem?.issueType;
                    let hasMatchingTeam = true;
                    let hasMatchingSprint = true;
                    let hasMatchingIssueType = true;
                    if (this.filteredSelectedTeams.length != 0) {
                        hasMatchingTeam = teamKeys.some(team => this.filteredSelectedTeams.includes(team));

                    }
                    if (this.filteredSelectedTeams.length != 0) {
                        hasMatchingSprint = sprintKeys.some(sprint => this.filteredSelectedSprints.includes(sprint));
                    }
                    if (this.filteredSelectedIssueTypes.length != 0) {
                        hasMatchingIssueType = this.filteredSelectedIssueTypes.includes(dataItem.issueType);
                    }

                    dataItem.filterOn = hasMatchingTeam && hasMatchingSprint && hasMatchingIssueType;
                });
            }
            this.onChangePageSizeofpopup();
        },

        isSortableColumn(title) {
            if(!this.sortableColumns.includes(title) && title!=="teams" && title!=="sprints" && title!=="batches"  && title!=="pi boards" && title!="solution boards"){
                return true;
            }
            return this.sortableColumns.includes(title);
        },

        onSearchInput: function () {
            this.onFilterSelectValue();
        },

        applyFilter: function () {
            this.dataOfItems = this.allDataOfItems;
            if (!_.isEmpty(this.search.text)) {
                let lowerQuery = this.search.text;
                _.each(this.dataOfItems, (dashboard) => {
                    let lowerName = dashboard.title ? dashboard.title.toLowerCase() : "";
                    let keyFilter = "";
                    if(dashboard.almKey){
                        keyFilter =  String(dashboard.almKey).toLowerCase() || "";
                    }else if(dashboard.fields && dashboard.fields.externalKey){
                        keyFilter = String(dashboard.externalKey).toLowerCase() || "";
                    }else{
                        keyFilter =  String(dashboard.kendisKey).toLowerCase() ||  "";
                    }
                    dashboard.filterOn = lowerName.includes(lowerQuery) || keyFilter.includes(lowerQuery);
                });
                this.dataOfItems = this.dataOfItems.filter(dashboard => dashboard.filterOn);
                const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
                const endIndex = startIndex + this.pagination.pageSize;
                this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
                this.pagination.totalItemSize = this.dataOfItems.length;
            } else {
                this.pagination.totalItemSize = this.allDataOfItems.length;
                this.dataOfItems = this.allDataOfItems
            }
        },

        applySort: function () {
            let _this = this;
            if (this.pagination.pageIndex === 0) {
                if (this.sortBy.value == 'title') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        if (this.sortBy.ascending) {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? 1 : -1;
                        } else {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? -1 : 1;
                        }
                    });
                } else if (this.sortBy.value == 'key') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const keyA = a.almKey || (a.fields && a.fields.externalKey) || a.kendisKey || "";
                        const keyB = b.almKey || (b.fields && b.fields.externalKey) || b.kendisKey || "";

                        if (this.sortBy.ascending) {
                            return keyA.toLowerCase() > keyB.toLowerCase() ? 1 : -1;
                        } else {
                            return keyA.toLowerCase() > keyB.toLowerCase() ? -1 : 1;
                        }
                    });
                } else if (this.sortBy.value == 'status') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        let statusA = this.statusMetaMap[a.status.id] || "";
                        let statusB = this.statusMetaMap[b.status.id] || "";

                        if (this.sortBy.ascending) {
                            return statusA.localeCompare(statusB);
                        } else {
                            return statusB.localeCompare(statusA);
                        }
                    });
                } else if (this.sortBy.value == 'estimate') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        if (this.sortBy.ascending) {
                            return a.storyPoints > b.storyPoints ? 1 : -1;
                        } else {
                            return a.storyPoints > b.storyPoints ? -1 : 1;
                        }
                    });
                } else if (this.sortBy.value == 'Assignee') {
                    this.allDataOfItems = this.allDataOfItems.sort((a, b) => {
                        const aName = a.assignee ? a.assignee.displayName.toLowerCase() : '';
                        const bName = b.assignee ? b.assignee.displayName.toLowerCase() : '';

                        if (_this.sortBy.ascending) {
                            if (aName > bName) return 1; // a comes after b
                            if (aName < bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        } else {
                            if (aName < bName) return 1; // a comes after b
                            if (aName > bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        }
                    });
                } else if (this.sortBy.value == 'Time (in Days)') {

                    this.allDataOfItems.sort((a, b) => {
                        const aDays = parseInt(a.days) || 0; // Extracts 31 from "31 Days" or defaults to 0 if not a valid number
                        const bDays = parseInt(b.days) || 0; // Extracts 1 from "1 Day" or defaults to 0 if not a valid number

                        if (this.sortBy.ascending) {
                            return aDays - bDays; // Ascending order
                        } else {
                            return bDays - aDays; // Descending order
                        }
                    });
                } else if (this.sortBy.value == 'Start Date') {
                    this.allDataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.startDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.startDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                } else if (this.sortBy.value == 'End Date') {
                    this.allDataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.endDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.endDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                } else if(this.sortBy.value == 'parent'){
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const getParentId = (item) => {
                            const parentRelationMap = this.allDataOfItems.find(d => d.id === item.id)?.parentRelationMap || {};
                            for (let innerIndex in parentRelationMap) {
                                if (innerIndex === this.widget.collectionsGraphCriteria.releaseTrainId) {
                                    for (let parent in parentRelationMap[innerIndex]) {
                                        let backlogItemId = parentRelationMap[innerIndex][parent]?.backlogItemId;
                                        if (typeof backlogItemId === "string") {
                                            return backlogItemId;
                                        }
                                    }
                                }
                            }
                            return null;
                        };

                        const parentIdA = getParentId(a);
                        const parentIdB = getParentId(b);

                        const titleA = parentIdA ? this.getParentTitle(parentIdA).toString() : '';
                        const titleB = parentIdB ? this.getParentTitle(parentIdB).toString() : '';

                        // Compare based on sort direction
                        return this.sortBy.ascending
                            ? titleA.localeCompare(titleB)
                            : titleB.localeCompare(titleA);
                    });
                } else{
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const column =  this.$options.columnOptions.find(o => o.title.toLowerCase() === this.sortBy.value).id;
                        let valA = (this.almFieldMap[a.id] && this.almFieldMap[a.id][column] && this.almFieldMap[a.id][column][0])
                            ? this.almFieldMap[a.id][column][0].value
                            : '';
                        let valB = (this.almFieldMap[b.id] && this.almFieldMap[b.id][column] && this.almFieldMap[b.id][column][0])
                            ? this.almFieldMap[b.id][column][0].value
                            : '';
                        if (!isNaN(valA) && !isNaN(valB)) {
                            return this.sortBy.ascending ? valA - valB : valB - valA;
                        }
                        return this.sortBy.ascending ? valA.localeCompare(valB) : valB.localeCompare(valA);
                    });
                }
            } else {
                if (this.sortBy.value == 'title') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        if (_this.sortBy.ascending) {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? 1 : -1;
                        } else {
                            return a.title.toLowerCase() > b.title.toLowerCase() ? -1 : 1;
                        }
                    });
                } else if (this.sortBy.value == 'Assignee') {
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const aName = a.assignee ? a.assignee.displayName.toLowerCase() : '';
                        const bName = b.assignee ? b.assignee.displayName.toLowerCase() : '';

                        if (_this.sortBy.ascending) {
                            if (aName > bName) return 1; // a comes after b
                            if (aName < bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        } else {
                            if (aName < bName) return 1; // a comes after b
                            if (aName > bName) return -1; // a comes before b
                            return 0; // a and b are equal
                        }
                    });
                } else if (this.sortBy.value == 'Time (in Days)') {

                    this.dataOfItems.sort((a, b) => {
                        const aDays = parseInt(a.days) || 0; // Extracts 31 from "31 Days" or defaults to 0 if not a valid number
                        const bDays = parseInt(b.days) || 0; // Extracts 1 from "1 Day" or defaults to 0 if not a valid number

                        if (this.sortBy.ascending) {
                            return aDays - bDays; // Ascending order
                        } else {
                            return bDays - aDays; // Descending order
                        }
                    });
                } else if (this.sortBy.value == 'Start Date') {
                    this.dataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.startDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.startDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                } else if (this.sortBy.value == 'End Date') {
                    this.dataOfItems.sort((a, b) => {
                        // Clean up the date string by removing the time zone and year part
                        const cleanDateA = a.endDate.replace(/ PKT \d{4}/, '');
                        const cleanDateB = b.endDate.replace(/ PKT \d{4}/, '');

                        // Parse the cleaned-up date strings into Date objects
                        const dateA = new Date(cleanDateA);
                        const dateB = new Date(cleanDateB);

                        // Ensure the dates are valid before sorting
                        if (isNaN(dateA) || isNaN(dateB)) {
                            return 0; // If dates are invalid, don't change the order
                        }

                        // Perform the sorting based on the "ascending" flag
                        if (this.sortBy.ascending) {
                            return dateA - dateB; // Sorts in ascending order
                        } else {
                            return dateB - dateA; // Sorts in descending order
                        }
                    });
                }else if(this.sortBy.value == 'parent'){
                    this.dataOfItems = this.dataOfItems.sort((a, b) => {
                        const getParentId = (item) => {
                            const parentRelationMap = this.allDataOfItems.find(d => d.id === item.id)?.parentRelationMap || {};
                            for (let innerIndex in parentRelationMap) {
                                if (innerIndex === this.widget.collectionsGraphCriteria.releaseTrainId) {
                                    for (let parent in parentRelationMap[innerIndex]) {
                                        let backlogItemId = parentRelationMap[innerIndex][parent]?.backlogItemId;
                                        if (typeof backlogItemId === "string") {
                                            return backlogItemId;
                                        }
                                    }
                                }
                            }
                            return null;
                        };

                        const parentIdA = getParentId(a);
                        const parentIdB = getParentId(b);

                        const titleA = parentIdA ? this.getParentTitle(parentIdA).toString() : '';
                        const titleB = parentIdB ? this.getParentTitle(parentIdB).toString() : '';

                        return this.sortBy.ascending
                            ? titleA.localeCompare(titleB)
                            : titleB.localeCompare(titleA);
                    });
                }
            }
            const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
            const endIndex = startIndex + this.pagination.pageSize;
            this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
        },

        onClickSort: function (sortKey) {
            if (sortKey == this.sortBy.value) {
                this.sortBy.ascending = !this.sortBy.ascending;
            } else {
                this.sortBy.ascending = true;
                this.sortBy.value = sortKey;
            }
            this.applySort();
        },

        findInitials: function (name) {
            if (name === '') {
                return '';
            }
            const words = name.split(' ');
            let initials = '';

            // for (let i = 0; i < words.length; i++) {
            const initial = words[0][0].toUpperCase();
            initials += initial;
            // }
            return initials;
        },

        initializeItemsData: function () {
            let columns = localStorage.getItem(this.widget.collectionsGraphCriteria.releaseTrainId + "_GraphBacklog_Columns"+ this.widget.collectionsGraphCriteria.groupByTitle);
            let _this = this;
            if (columns) {
                try {
                    columns = JSON.parse(columns);
                    this.columns.selected = [...columns];
                } catch (error) {
                }
            }else{
                this.columns.selected = ["status"];
                const selectedOption = _this.$options.columnOptions.find(o => o.title === this.widget.collectionsGraphCriteria.groupByTitle);
                if (selectedOption && !this.columns.selected.includes(selectedOption?.id)) {
                    this.columns.selected.push(selectedOption?.id);
                }
            }
        },

        putIconDataIntheMap(cssMap, issueType) {
            if (issueType.id != '10100') {
                //return;
            }
            let iconKey = 'jira-icon_' + issueType.id;
            cssMap[iconKey] = '.' + iconKey + ':before {content:""; background-image: url("' + issueType.iconUrl + '");} /*' + issueType.name + '*/';
            if (cssMap.idByUrl == undefined) {
                cssMap.idByUrl = {};
            }
            cssMap.idByUrl[issueType.iconUrl] = issueType.id;

            return iconKey;
        },

        onColumnsSelectValue: function (valuse) {
            localStorage.setItem(this.widget.collectionsGraphCriteria.releaseTrainId + "_GraphBacklog_Columns" +this.widget.collectionsGraphCriteria.groupByTitle, JSON.stringify(valuse));
            this.populateFilterOptions();
        },

        onFilterSelectValue: function () {
            const isMatch = (relations, key, selectedFilters, identifier = null, metaMap = {}) => {
                relations = relations.filter(relation => {
                    const id = relation[`${key}Id`]?.toString();
                    return !!id && !!metaMap[id];
                });
                if (relations.length > 0) {
                    return relations.some(relation => {
                        const relationId = relation[`${key}Id`]?.toString();
                        if (!relationId) {
                            return selectedFilters.some(f => f.id === "-1");
                        }
                        const relationTitle = typeof metaMap[relationId] === "object" ? metaMap[relationId].title : metaMap[relationId];
                        if (!relationTitle) {
                            return selectedFilters.some(selected => selected.id === "-1");
                        }
                        // title = identifier === "batches"
                        //     ? title.includes(":")
                        //         ? title.split(":").pop().trim()
                        //         : title
                        //     : title;
                        return selectedFilters.some(selected => {
                            return selected.title === relationTitle;
                        });
                    });
                }

                return selectedFilters.some(f => {
                    return (identifier !== null ? identifier : f.identifier) === (key === "solution" ? "solutionBoards" : key) && f.id === "-1"
                });
            };

            this.selectedFilters = this.allFilters
                .filter(filter => filter.model)
                .map(filter => ({
                    id: filter.id,
                    model: filter.model
                }));
            this.applyFilter();
            this.filterDataBasedOnIssueType();
            let items = this.dataOfItems;
            this.selectedFilters.map(f => {
                switch (f.id) {
                    case "teams":
                        items = items.filter(item => isMatch(item.teamContainerRelations, "team", f.model, "team", this.teamMetaMap));
                        break;
                    case "sprint":
                        items = items.filter(item => isMatch(item.teamContainerRelations, "sprint", f.model, null, this.sprintMetaMap));
                        break;
                    case "status":
                        items = items.filter(item => {
                            const statusId = item.status?.id;
                            const statusTitle = this.statusMetaMap[statusId];
                            return f.model.some(selected => {
                                if(selected.id === "-1" && !statusTitle){
                                    return true;
                                }
                                return selected.title === statusTitle
                            });
                        });
                        break;
                    case "boards":
                        items = items.filter(item => isMatch(item.boardRelations, "session", f.model, "session", this.sessionBoardMetaMap));
                        break;
                    case "batches":
                        items = items.filter(item => isMatch(item.batchRelations, "baseItem", f.model, "baseItem", this.batchMetaMap));
                        break;
                    case "parent":
                        const includeNoParentItems = f.model.some(selected => selected.id === "-1");
                        items = items.filter(item => {
                            if (!item.parentRelationMap) return includeNoParentItems;
                            const hasOnlyEmptyParents = Object.values(item.parentRelationMap).every(relations => Array.isArray(relations) && relations.length === 0);
                            if (includeNoParentItems && hasOnlyEmptyParents) {
                                return true;
                            }
                            return Object.entries(item.parentRelationMap).some(([_, relations]) =>
                                relations.some(relation => {
                                    let backlogItemId = relation?.backlogItemId;
                                    if(typeof backlogItemId !== "string"){
                                        return includeNoParentItems;
                                    }
                                    return (
                                        typeof backlogItemId === "string" &&
                                        f.model.some(selected => selected.title === this.parentMetaMap[backlogItemId].title)
                                    );
                                })
                            );
                        });
                        break;
                    case "estimate":
                        items = items.filter(item => {
                            const hasStoryPoints = item.storyPoints !== undefined && item.storyPoints !== null;
                            return f.model.some(selected => {
                                if (selected.id === "-1" && !hasStoryPoints) {
                                    return true;
                                }
                                return hasStoryPoints && selected.id === item.storyPoints.toString();
                            });
                        });
                        break;
                    case "solutionBoards":
                        items = items.filter(item => isMatch(item.solutionRelations, "solution", f.model, "solutionBoards", this.solutionBoardMetaMap));
                        break;
                    default:
                        const isAlphanumericId = /^[a-f0-9]{24}$/i.test(f.id);
                        items = items.filter(item => {
                            const values = this.almFieldMap[item?.id];
                            let storedIteration = "";
                            if(isAlphanumericId){
                                let opt = this.$options.columnOptions.find(opt => opt.id === f.id);
                                if (opt && opt.title) {
                                    storedIteration = values[opt.title];
                                }
                            }else{
                                storedIteration = values[f.id];
                            }
                            if (!storedIteration || storedIteration.length === 0) {
                                return f.model.some(selected => selected.id === "-1");
                            }
                            storedIteration = storedIteration.map(v => this.removeHtmlTags(v.value).toString())
                            return f.model.some(selected => storedIteration.includes(this.removeHtmlTags(selected.id).toString()));

                        });
                }
            })

            this.dataOfItems = items;
            const startIndex = this.pagination.pageIndex * this.pagination.pageSize;
            const endIndex = startIndex + this.pagination.pageSize;
            this.paginatedData = this.dataOfItems.slice(startIndex, endIndex);
            this.pagination.totalItemSize = this.dataOfItems.length;
        },

        populateColumnsOptions: function () {
            this.$options.columsMap = {};
            this.$options.columsMap["solutionBoards"] = {
                id: "solutionBoards",
                title: "Solution Boards",
                sortCommand: "",
                sort: false ,
                class:"c3"
            };
            this.$options.columsMap["parent"] = {
                id: "parent",
                title: "Parent",
                sortCommand: "",
                sort: true,
                class: "c3"
            };
            this.$options.columsMap["status"] = {
                id: "status",
                title: "Status",
                sortCommand: "statusTitle",
                sort: true,
                class: "c3"
            };
            this.$options.columsMap["estimate"] = {
                id: "estimate",
                title: "Estimate",
                sortCommand: "",
                sort: false,
                class: "c3"
            };
            this.$options.columsMap["boards"] = {
                id: "boards",
                title: "PI Boards",
                sortCommand: "",
                sort: false,
                class: "c3"
            };
            this.$options.columsMap["batches"] = {
                id: "batches",
                title: "Batches",
                sortCommand: "",
                sort: false,
                class: "c3"
            };
            this.$options.columsMap["teams"] = {id: "teams", title: "Teams", sortCommand: "", sort: false, class: "c3"};
            this.$options.columsMap["sprint"] = {
                id: "sprint",
                title: "Sprints",
                sortCommand: "",
                sort: false,
                class: "c3"
            };
            this.$options.columnOptions = Object.values(this.$options.columsMap);
            this.columns.selected = [];
            this.fetchCustomFields();
        },

        populateFilterOptions: function () {
            if(!this.columns.selected){
                this.allFilters = [];
                return;
            }
            let columns = this.columns.selected
                .map(selectedId => {
                    let f = this.$options.columnOptions.find(option => option.id === selectedId);
                    if(f) {
                        return {
                            id: f?.id || f.id,
                            options: [],
                            model: [],
                            emptyMessage: `Select ${f?.title || 'Field'}`,
                            selectedMessage: `Selected ${f?.title || 'Field'}`
                        };
                    }
                });

            let newColumn = [];
            columns.forEach(c => {
                if (!this.allFilters.some(f => f.id === c.id)) {
                    newColumn.push(c);
                }
            });

            newColumn = newColumn.filter(c => c.id !== 'issuetype');

            let removeFilters = this.allFilters.filter(f =>
                !this.columns.selected.includes(f.id)
            );
            const createFilterOptions = (metaMap, identifier) => {
                if (Object.keys(metaMap).length === 0) {
                    return [];
                }
                const seenTitles = new Set();
                return Object.entries(metaMap)
                    .reduce((acc, [key, value]) => {
                        let title = typeof value === "object" ? value.title : value;
                        // title = identifier === "sprint"  ? title + " (" + value.boardTitle + ")" : title;
                        // title = identifier === "batches"
                        //     ? title.includes(":")
                        //         ? title.split(":").pop().trim()
                        //         : title
                        //     : title;
                        if (!seenTitles.has(title)) {
                            seenTitles.add(title);
                            acc.push({ id: key, title, identifier });
                        }
                        return acc;
                    }, []);
            };

            this.$options.teamFilterOptions = createFilterOptions(this.teamMetaMap, "teams");
            this.$options.sprintFilterOptions = createFilterOptions(this.sprintMetaMap, "sprint");
            this.$options.issueTypeFilterOptions = createFilterOptions(this.statusMetaMap, "status");
            this.$options.boardFilterOptions = createFilterOptions(this.sessionBoardMetaMap, "boards");
            this.$options.batchesFilterOptions = createFilterOptions(this.batchMetaMap, "batches");
            this.$options.parentFilterOptions = createFilterOptions(this.parentMetaMap, "parent");
            this.$options.solutionBoardFilterOptions = createFilterOptions(this.solutionBoardMetaMap, "solutionBoards");
            newColumn.forEach(filter => {
                let currentFilter = this.selectedFilters.find(f => f.id === filter?.id)
                switch (filter?.id) {
                    case "teams":
                        filter.options = this.$options.teamFilterOptions;
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedTeam = [...filter.options]);
                        break;
                    case "sprint":
                        filter.options = this.$options.sprintFilterOptions;
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedSprint = [...filter.options]);
                        break;
                    case "status":
                        filter.options = this.$options.issueTypeFilterOptions;
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedIssueType = [...filter.options]);
                        break;
                    case "boards":
                        filter.options = this.$options.boardFilterOptions;
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedBoard = [...filter.options]);
                        break;
                    case "batches":
                        filter.options = this.$options.batchesFilterOptions;
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedBatches = [...filter.options]);
                        break;
                    case "estimate":
                        const uniqueStoryPoints = [...new Set(this.allDataOfItems.map(data => data.storyPoints))];
                        filter.options = uniqueStoryPoints.filter(storyPoint => storyPoint !== undefined && storyPoint !== null).map(storyPoint => ({
                            id: storyPoint.toString(),
                            title: storyPoint.toString(),
                            identifier: "estimate"
                        }));
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn[filter.id] = [...filter.options]);
                        break;
                    case "parent":
                        filter.options = this.$options.parentFilterOptions
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedBatches = [...filter.options]);
                        break;
                    case "solutionBoards":
                        filter.options = this.$options.solutionBoardFilterOptions
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn.selectedBatches = [...filter.options]);
                        break;
                    default:
                        const kendisFilter = this.kendisCustomFields.find(f => f.id === filter.id);
                        if(kendisFilter){
                            filter.options = this.dynamicFilterOptions[kendisFilter.title] ? Array.from(this.dynamicFilterOptions[kendisFilter.title]).map(value => {
                                if(value && Object.keys(value).length > 0) {
                                    return {
                                        id: this.removeHtmlTags(value.toString()),
                                        title: this.removeHtmlTags(value.toString()),
                                        identifier: filter.id
                                    }
                                }
                                return null;
                            }).filter(option => option !== null) : [];
                            this.$set(this.filterColumn, filter.id, []);
                            break;
                        }
                        filter.options = this.dynamicFilterOptions[filter.id] ? Array.from(this.dynamicFilterOptions[filter.id]).map(value => {
                            return {
                                id: value.toString(),
                                title: value.toString(),
                                identifier: value.toString()
                            }

                        }) : [];
                        this.$set(this.filterColumn, filter.id, []);
                        // filter.model = currentFilter?.model.length > 0 ? currentFilter.model : (this.filterColumn[filter.id] = [...filter.options]);

                }
            });

            this.$options.columnOptions.forEach(option => {
                let index = newColumn.findIndex(f => f.id === option.id);

                if (index !== -1) {
                    newColumn[index].options = [...newColumn[index].options, {
                        id: "-1",
                        title: `No ${option.title}`,
                        identifier: option.id
                    }]
                    newColumn[index].model = [...newColumn[index].options];

                    // this.allFilters[index].options = [...this.allFilters[index].options, {
                    //     id: "deleted",
                    //     title: `Deleted ${option.title}`,
                    //     identifier: option.id
                    // }]
                    // this.allFilters[index].model = [...this.allFilters[index].options];
                }
            })

            this.allFilters.push(...newColumn);
            this.allFilters = this.allFilters.filter(f =>
                !removeFilters.some(r => r.id === f.id)
            );
            this.$forceUpdate();
            this.loader.show = false;
        },

        getItemRelations(item, link) {
            if (item[link]) return item[link];
            else return [];
        },
        formatDate: function (date, format) {
            if (date) {
                return dateFormat(date, format);
            }
            return "";
        },
        redirectToUrl: function (key) {
            let url = "batches#/" + key;
            window.open(url, "_blank");
        },
        getMetaDetail: function (type, bid) {
            let item = {};
            if (type = 'batches' && this.batches[bid]) {
                item = this.batches[bid];
            }
            return item;
        },
        onClickShowAlmError: function () {
            if (this.getAlmAccountType == 'jira') {
                handleJiraError(this.item.fields);
                return;
            }
            let error = JSON.parse(this.item.fields.AlmErrorMesaage);
            this.almError.message = error.message;
            this.almError.show = true;
        },

        setOptionColumnForFlowTime: function (type) {
            if (type === 'cycle-time-graph' || type === 'cycle-time-graph-detail-view' || type === 'lead-time-graph' || type === 'lead-time-graph-detail-view') {
                if (_.isEmpty(this.columns.selected)) {
                    // this.columns.selected = ["time","groupBy", "teams", "sprint"];
                    this.columns.selected = ["time", "startDate", "endDate", "teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["time"] = {
                    id: "time",
                    title: "Time (in Days)",
                    class: "c3",
                    toolTip: "Time in Days",
                    dataHeader: "status"
                };
                this.$options.columsMap["startDate"] = {
                    id: "startDate",
                    title: "Start Date",
                    class: "c3",
                    toolTip: "Start Date",
                    dataHeader: "startDate"
                };
                this.$options.columsMap["endDate"] = {
                    id: "endDate",
                    title: "End Date",
                    class: "c3",
                    toolTip: "End Date",
                    dataHeader: "endDate"
                };
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            } else if (type == 'flow-time-graph') {
                if (_.isEmpty(this.columns.selected)) {
                    // this.columns.selected = ["time","groupBy", "teams", "sprint"];
                    this.columns.selected = ["time", "teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["time"] = {
                    id: "time",
                    title: "Time (in Days)",
                    class: "c3",
                    toolTip: "Time in Days",
                    dataHeader: "status"
                };
                // this.$options.columsMap["groupBy"] = { id: "groupBy", title: "Group By ("+this.grouping+")", class:"c3", toolTip:"Groupby"};
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            } else if (type == 'flow-efficiency-graph') {
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["efficiency", "teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["efficiency"] = {
                    id: "efficiency",
                    title: "Efficiency %",
                    class: "c3",
                    toolTip: "Efficiency in %",
                    dataHeader: "status"
                };
                // this.$options.columsMap["groupBy"] = { id: "groupBy", title: "Group By ("+this.grouping+")", class:"c3", toolTip:"Groupby"};
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            } else if (type == 'flow-velocity-graph') {
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["items", "teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["items"] = {
                    id: "items",
                    title: "No. of Items",
                    class: "c3",
                    toolTip: "Number of Items in Completion Status",
                    dataHeader: "status"
                };
                // this.$options.columsMap["groupBy"] = { id: "groupBy", title: "Group By ("+this.grouping+")", class:"c3", toolTip:"Groupby"};
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            } else if (type == 'flow-load-graph' || type == 'flow-distribution-graph') {
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["status", "teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["status"] = {
                    id: "status",
                    title: "Status of Item",
                    class: "c3",
                    toolTip: "Status of Items",
                    dataHeader: "status"
                };
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            } else if (type == 'cfd' || type == 'flow-time-graph-detail' || type == 'flow-efficiency-graph-detail' || type == 'flow-velocity-graph-detail' || type == 'flow-load-graph-detail' || type == 'flow-distribution-graph-detail') {
                if (_.isEmpty(this.columns.selected)) {
                    this.columns.selected = ["teams", "sprint", "assignee"];
                }
                this.$options.columsMap = {};
                this.$options.columsMap["teams"] = {id: "teams", title: "Teams", class: "c3", dataHeader: "team"};
                this.$options.columsMap["sprint"] = {id: "sprint", title: "Sprint", class: "c3", dataHeader: "sprint"};
                this.$options.columsMap["assignee"] = {
                    id: "assignee",
                    title: "Assignee",
                    class: "c3",
                    dataHeader: "assignee"
                };
                this.$options.columnOptions = Object.values(this.$options.columsMap);
            }
        },
        checkNumberIsNotNaN: function (number) {

            if (isNaN(number)) {
                return 0;
            } else {
                return parseFloat(number.toFixed(2));
            }
        },
        hide: function () {
            enableBodyScroll();
            this.$emit('close');
        },
        customExport: function (requestBody) {
            requestBody.headers = [];
            requestBody.items = [];

            // Define the columns that should be checked and added
            const possibleColumns = ['key', 'title'];
            if (this.columns.selected !== undefined) {
                possibleColumns.push(...this.columns.selected);
            }

            let columnsAdded = []; // Initialize with no columns initially
            // Loop through all data items
            // this.paginatedData.filter(item => item.filterOn);
            let filteredItems = this.dataOfItems;

            for (var i = 0; i < filteredItems.length; i++) {
                var item = filteredItems[i];

                let check = false;
                // Dynamically check for the presence of specified columns and add them
                possibleColumns.forEach(column => {
                    if (!columnsAdded.includes(column)) {
                        columnsAdded.push(column); // Add column to headers if it exists in the item
                    }
                });

                // Process headers for the first iteration
                if (i === 0) {
                    columnsAdded.forEach(column => {
                        let headerName = "";
                        if (this.$options.columsMap?.[column]?.title) {
                            // Preferred: Use columnsMap title if available
                            headerName = this.$options.columsMap[column].title;
                        } else {
                            // Fallback: prettified column name
                            headerName = column.charAt(0).toUpperCase() + column.slice(1).replace(/([A-Z])/g, ' $1');
                        }
                        requestBody.headers.push({ value: column, header: headerName });
                    });
                }

                // Add the item data for each row
                var rowItem = {};

                // Add the selected fields based on the dynamically determined columns
                columnsAdded.forEach(column => {
                    const columnData = item[column];
                    if (column.toLowerCase() === 'key') {
                        rowItem[column] =
                            item.almKey ||
                            item.kendisKey ||
                            (item.fields && item.fields.externalKey) ||
                            '';
                    } else if (column.toLowerCase() === 'title') {
                        rowItem[column] = columnData;
                    } else if (column.toLowerCase() === 'status') {
                        rowItem[column] = this.statusMetaMap[item?.status?.id];
                    } else if (column.toLowerCase() === 'teams') {
                        rowItem[column] = item.teamContainerRelations.map(team => this.teamMetaMap[team.teamId]?.title || '').join(", ");
                    } else if (column.toLowerCase() === 'sprint') {
                        rowItem[column] = item.teamContainerRelations.map(sprint => this.sprintMetaMap[sprint.sprintId]?.title || '').join(", ");
                    } else if (column.toLowerCase() === 'days') {
                        rowItem[column] = this.statusMetaMap[item?.status?.id];
                    } else if (column.toLowerCase() === 'boards') {
                        rowItem[column] = item.boardRelations.map(board => this.sessionBoardMetaMap[board.sessionId]?.title || '').join(", ");
                    } else if (column.toLowerCase() === 'solutionboards') {
                        rowItem[column] = item.solutionRelations.map(sol => this.solutionBoardMetaMap[sol.solutionId] || '').join(", ");
                    } else if (column.toLowerCase() === 'parent') {
                        rowItem[column] = Object.values(item.parentRelationMap || {})
                            .flat()
                            .map(relation => {
                                const backlogItemId = relation?.backlogItemId;
                                const parent = typeof backlogItemId === "string" ? this.parentMetaMap[backlogItemId] : null;
                                return parent ? `${parent.key}: ${parent.title}` : '';
                            })
                            .filter(Boolean)
                            .join(", ");
                    }else if (column.toLowerCase() === 'batches') {
                        rowItem[column] = item.batchRelations.map(batch => this.batchMetaMap[batch.baseItemId] || '').join(", ");
                    } else if (column.toLowerCase() === 'estimate') {
                        rowItem[column] = item.storyPoints;
                    } else if (column.toLowerCase() === 'assignee' && columnData && columnData.displayName) {
                        // Handle 'assignee' by using displayName if present
                        rowItem[column] = columnData.displayName;
                    } else if (Array.isArray(columnData)) {
                        // If it's an array, join values with commas
                        rowItem[column] = columnData.join(", ");
                    } else if (typeof columnData === 'object' && columnData !== null) {
                        // Handle any other objects by converting to a JSON string
                        rowItem[column] = JSON.stringify(columnData);
                    } else if (column.toLowerCase() === 'startdate' || column.toLowerCase() === 'enddate') {
                        // Handle date fields with a custom format
                        const dateParts = columnData.match(/^(\w{3}) (\w{3}) (\d{2}) (\d{2}:\d{2}:\d{2}) \w{3} (\d{4})$/);
                        if (dateParts) {
                            // Convert to a format like "Month Day, Year"
                            const parsedDate = new Date(`${dateParts[2]} ${dateParts[3]}, ${dateParts[5]} ${dateParts[4]}`);
                            rowItem[column] = parsedDate.toLocaleDateString();  // Format date as string
                        } else {
                            rowItem[column] = 'Invalid Date';
                        }
                    } else {
                        let value = this.getFieldData(item.id, column);
                        if (value) {
                            value = value.map(v => v?.value ?? '').join(', ');
                            rowItem[column] = this.removeHtmlTags(value);
                        }else{
                            rowItem[column] = "";
                        }
                    }
                });


                // Add the item to the exportable items
                requestBody.items.push(rowItem);
            }


            return requestBody;
        },
        exportChartDetail: function (type) {
            var rows = $('#items li,.data');
            var requestBody = {};
            requestBody.title = this.data.popupTitle;
            requestBody = this.customExport(requestBody);
            sendExportRequest(type, requestBody);
        },

        onChangePageSize() {
            this.pagination.pageIndex = 0;
            // this.loadItemsOfBacklog();
        },

        loadItemsofPI: function () {
            let pageStart = this.pagination.pageIndex;
            let pageSize = this.pagination.pageSize;
            let itemsDaysMapList = this.data.itemDaysMap;
            let itemDatesMapList = this.data.itemDatesMap;
            this.grouping = this.data.grouping;
            let itemTeamsMap = this.data.itemTeamsMap;
            let itemSprintsMap = this.data.itemSprintsMap;
            let itemGroupbyMap = this.data.itemGroupbyMap;
            if (!_.isEmpty(itemsDaysMapList)) {
                let itemDatesArray = [];
                let combinedArray = [];
                let itemsArray = Object.entries(itemsDaysMapList).map(([id, value]) => ({id, value}));
                if (!_.isEmpty(itemDatesMapList)) {
                    itemDatesArray = Object.entries(itemDatesMapList).map(([id, value]) => ({id, value}));
                    combinedArray = itemDatesArray.map(item2 => {
                        const item1 = itemsArray.find(item1 => item1.id === item2.id);
                        return {
                            id: item2.id,
                            value: {
                                daydifference: item1 ? item1.value.toString() : null,
                                startDate: item2.value[0],
                                endDate: item2.value[1]
                            }
                        };
                    });
                }
                let startIndex = pageStart * pageSize;
                if (startIndex >= itemsArray.length) {
                    startIndex = itemsArray.length - 1;
                }
                let endIndex = Math.min(startIndex + pageSize, itemsArray.length);
                let paginatedItems = [];
                if (!_.isEmpty(combinedArray)) {
                    paginatedItems = combinedArray.slice(startIndex, endIndex);
                } else {
                    paginatedItems = itemsArray.slice(startIndex, endIndex);
                }
                let paginatedItemsObject = {};
                if (!_.isEmpty(combinedArray)) {
                    for (let item of paginatedItems) {
                        paginatedItemsObject[item.id] = {
                            days: item.value.daydifference,
                            startDate: item.value.startDate,
                            endDate: item.value.endDate,
                            teams: [],
                            sprints: [],
                        };
                    }
                } else {
                    for (let item of paginatedItems) {
                        paginatedItemsObject[item.id] = {
                            days: item.value,
                            groupby: !_.isEmpty(itemGroupbyMap) ? itemGroupbyMap[item.id] : [],
                            // teams:itemTeamsMap[item.id]||[],
                            // sprints:itemSprintsMap[item.id]||[]
                            teams: [],
                            sprints: [],
                        };
                    }
                }
                this.pagination.totalItemSize = paginatedItems.length;
                this.loader.text = "Data loading ...";
                this.loader.show = true;
                if (!_.isEmpty(paginatedItemsObject)) {

                    //Commented the code as it was fetching only the page size items

                    // axios.post('/dashboard/fetch-item-details-list/', paginatedItemsObject)
                    //     .then(response => {
                    //         // Set the array
                    //         this.dataOfItems = response.data.map(item => {
                    //             item.filterOn = true; // Add `filterOn` attribute to each item
                    //             return item;
                    //         });
                    //         this.loader.show = false;
                    //     })
                    //     .catch(error => {
                    //         console.error(error);
                    //         this.loader.show = false;
                    //     });

                    let paginatedItems = [];
                    if (!_.isEmpty(combinedArray)) {
                        paginatedItems = combinedArray;
                    } else {
                        paginatedItems = itemsArray;
                    }
                    let paginatedItemsObjectAllData = {};
                    if (!_.isEmpty(combinedArray)) {
                        for (let item of paginatedItems) {
                            paginatedItemsObjectAllData[item.id] = {
                                days: item.value.daydifference,
                                startDate: item.value.startDate,
                                endDate: item.value.endDate,
                                teams: [],
                                sprints: [],
                            };
                        }
                    } else {
                        for (let item of paginatedItems) {
                            paginatedItemsObjectAllData[item.id] = {
                                days: item.value,
                                groupby: !_.isEmpty(itemGroupbyMap) ? itemGroupbyMap[item.id] : [],
                                // teams:itemTeamsMap[item.id]||[],
                                // sprints:itemSprintsMap[item.id]||[]
                                teams: [],
                                sprints: [],
                            };
                        }
                    }
                    this.data.total = paginatedItems.length;
                    this.loader.text = "Data loading ...";
                    this.loader.show = true;
                    axios.post('/dashboard/fetch-item-details-list/', paginatedItemsObjectAllData)
                        .then(response => {
                            // Set the array
                            this.filterTeams = [];
                            // this.filterTeams = response.data
                            //     .filter(item => item.teams) // Only keep items that have a `teams` attribute
                            //     .map(item => item.teams);
                            this.filterTeams = response.data
                                .map(item => {
                                    // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                    return item.teams && Object.keys(item.teams).length > 0
                                        ? item.teams
                                        : {"No Team": "No Team-color:#594a21"};
                                });
                            this.filterSprints = [];
                            // this.filterSprints = response.data
                            //     .filter(item => item.sprints) // Only keep items that have a `sprints` attribute
                            //     .map(item => item.sprints);
                            this.filterSprints = response.data
                                .map(item => {
                                    // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                    return item.sprints && Object.keys(item.sprints).length > 0
                                        ? item.sprints
                                        : {"No Sprint": "No Sprint"};
                                });
                            this.filterIssueTypes = [];
                            this.filterIssueTypes = response.data
                                .map(item => {
                                    // Check if tfsItemType exists and is not empty
                                    if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                        return item.tfsItemType;
                                    }
                                    // Otherwise, check if jiraFieldByKeyIssueType exists and has a name
                                    if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                        return item.jiraFieldByKeyIssueType.name;
                                    }
                                    // Return undefined if neither condition is met
                                    return "Kendis Only";
                                })
                                // Filter out any undefined values
                                .filter(Boolean);
                            this.allDataOfItems = response.data.map(item => {
                                item.filterOn = true; // Add `filterOn` attribute to each item
                                return item;
                            });
                            this.allDataOfItems = this.allDataOfItems.map(item => {
                                // Check for tfsItemType or fallback to jiraFieldByKeyIssueType.name
                                if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                    item.issueType = item.tfsItemType;  // Set issueType to tfsItemType if available
                                } else if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                    item.issueType = item.jiraFieldByKeyIssueType.name;  // Otherwise, set issueType to jiraFieldByKeyIssueType.name
                                } else {
                                    item.issueType = "Kendis Only"; // Optionally set to null if neither condition is met
                                }
                                if (!item.teams || Object.keys(item.teams).length === 0) {
                                    item.teams = {"No Team": "No Team-color:#594a21"};
                                }
                                if (!item.sprints || Object.keys(item.sprints).length === 0) {
                                    item.sprints = {"No Sprint": "No Sprint"};
                                }
                                return item; // Return the modified item
                            });
                            this.dumpDataOfItems = response.data.map(item => {
                                item.filterOn = true; // Add `filterOn` attribute to each item
                                return item;
                            });
                            this.dataOfItems = this.allDataOfItems.slice(startIndex, endIndex);
                            this.loader.show = false;
                            this.loaded = true;
                            this.filterTeamsForDropDown();
                            this.filterSprintsForDropDown();
                            this.filterIssueTypeForDropDown();
                        })
                        .catch(error => {
                            console.error(error);
                            this.loader.show = false;
                        });
                }
            }
        },

        loadCFDItems: function () {
            let pageStart = this.pagination.pageIndex;
            let pageSize = this.pagination.pageSize;
            let startIndex = pageStart * pageSize;
            if (startIndex >= this.data.itemIds.length) {
                startIndex = this.data.itemIds.length - 1;
            }
            let endIndex = Math.min(startIndex + pageSize, this.data.itemIds.length);
            let paginatedItems = this.data.itemIds.slice(startIndex, endIndex);
            let paginatedItemsObject = {"itemIds": paginatedItems};
            this.pagination.totalItemSize = paginatedItems.length;
            this.loader.text = "Data loading ...";
            this.loader.show = true;
            if (!_.isEmpty(paginatedItemsObject)) {

                //Commented the code as it was fetching only the page size items

                // axios.post('/dashboard/fetch-cfd-item-details/', paginatedItemsObject)
                //     .then(response => {
                //         // Set the array
                //         this.dataOfItems = response.data.map(item => {
                //             item.filterOn = true; // Add `filterOn` attribute to each item
                //             return item;
                //         });
                //         this.loader.show = false;
                //     })
                //     .catch(error => {
                //         console.error(error);
                //         this.loader.show = false;
                //     });
                //
                let paginatedItems = this.data.itemIds;
                this.data.total = paginatedItems.length;
                let paginatedItemsObjectAllData = {"itemIds": paginatedItems};
                this.loader.text = "Data loading ...";
                this.loader.show = true;
                axios.post('/dashboard/fetch-cfd-item-details/', paginatedItemsObjectAllData)
                    .then(response => {
                        this.filterTeams = [];
                        // this.filterTeams = response.data
                        //     .filter(item => item.teams) // Only keep items that have a `teams` attribute
                        //     .map(item => item.teams);
                        this.filterTeams = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.teams && Object.keys(item.teams).length > 0
                                    ? item.teams
                                    : {"No Team": "No Team-color:#594a21"};
                            });
                        this.filterSprints = [];
                        // this.filterSprints = response.data
                        //     .filter(item => item.sprints) // Only keep items that have a `sprints` attribute
                        //     .map(item => item.sprints);
                        this.filterSprints = response.data
                            .map(item => {
                                // Check if 'teams' exists and has values, otherwise return the default "Not Defined" entry
                                return item.sprints && Object.keys(item.sprints).length > 0
                                    ? item.sprints
                                    : {"No Sprint": "No Sprint"};
                            });
                        this.filterIssueTypes = [];
                        this.filterIssueTypes = response.data
                            .map(item => {
                                // Check if tfsItemType exists and is not empty
                                if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                    return item.tfsItemType;
                                }
                                // Otherwise, check if jiraFieldByKeyIssueType exists and has a name
                                if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                    return item.jiraFieldByKeyIssueType.name;
                                }
                                // Return undefined if neither condition is met
                                return "Kendis Only";
                            })
                            // Filter out any undefined values
                            .filter(Boolean);
                        this.allDataOfItems = response.data.map(item => {
                            item.filterOn = true; // Add `filterOn` attribute to each item
                            return item;
                        });
                        this.allDataOfItems = this.allDataOfItems.map(item => {
                            // Check for tfsItemType or fallback to jiraFieldByKeyIssueType.name
                            if (item.tfsItemType && item.tfsItemType.trim() !== "") {
                                item.issueType = item.tfsItemType;  // Set issueType to tfsItemType if available
                            } else if (item.jiraFieldByKeyIssueType && item.jiraFieldByKeyIssueType.name) {
                                item.issueType = item.jiraFieldByKeyIssueType.name;  // Otherwise, set issueType to jiraFieldByKeyIssueType.name
                            } else {
                                item.issueType = "Kendis Only"; // Optionally set to null if neither condition is met
                            }
                            if (!item.teams || Object.keys(item.teams).length === 0) {
                                item.teams = {"No Team": "No Team-color:#594a21"};
                            }
                            if (!item.sprints || Object.keys(item.sprints).length === 0) {
                                item.sprints = {"No Sprint": "No Sprint"};
                            }
                            return item; // Return the modified item
                        });
                        this.dumpDataOfItems = response.data.map(item => {
                            item.filterOn = true; // Add `filterOn` attribute to each item
                            return item;
                        });
                        this.dataOfItems = this.allDataOfItems.slice(startIndex, endIndex);
                        this.loader.show = false;
                        this.loaded = true;
                        this.filterTeamsForDropDown();
                        this.filterSprintsForDropDown();
                        this.filterIssueTypeForDropDown();
                    })
                    .catch(error => {
                        console.error(error);
                        this.loader.show = false;
                    });
            }
        },
        filterTeamsForDropDown: function () {
            this.filterTeams = [...new Set(
                this.filterTeams
                    .map(item => Object.keys(item)[0])
                    .filter(title => title !== undefined)
            )]
                .map((title, index) => ({id: index + 1, title}))
                .sort((a, b) => {
                    if (a.title === "No Team") return 1; // Move "No Team" to the end
                    if (b.title === "No Team") return -1;
                    return 0; // Keep order for other items
                });

            this.filteredSelectedTeams = this.filterTeams
                .filter(team => team.title !== undefined)
                .map(team => team.title);
        },
        filterSprintsForDropDown: function () {
            this.filterSprints = [...new Set(
                this.filterSprints
                    .filter(item => Object.keys(item)[0] !== undefined) // Exclude items with undefined keys
                    .map(item => Object.keys(item)[0]) // Extract keys
            )]
                .map((title, index) => ({id: index + 1, title}))
                .sort((a, b) => {
                    if (a.title === "No Sprint") return 1; // Move "No Sprint" to the end
                    if (b.title === "No Sprint") return -1;
                    return 0; // Keep order for other items
                });

            this.filteredSelectedSprints = this.filterSprints.map(sprint => sprint.title);
        },
        filterIssueTypeForDropDown: function () {
            this.filterIssueTypes = [...new Set(this.filterIssueTypes.filter(item => item !== undefined))]
                .map((item, index) => ({id: index + 1, title: item}));
            this.filteredSelectedIssueTypes = this.filterIssueTypes.map(team => team.title);
        },
    }
});
