const kendisWidgetCollectionPieColumnCriteria = Vue.component('kendis-widget-collection-pie-col-criteria', {

    template:`
		<div id="overlay" class="overlay" style="display: block;">	
			<div class="ui-dialog selectionPopUp">
				<div v-if="showloader" class="loader">
					<div>
						<div class="loaderinteg"></div>
					</div>
				</div>
				<div class="selectionPopUpHeader DFCB  pd-20 pb-0">
					<span class="fs-18 ftsb widgetPopUpTitle">
						{{this.optionTypeTitle + " For Collections"}}
					</span>
					<em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="handleConfigClosure"></em>
				</div>
				<div class="selectionPopUpContentWraper">
					<div  class="rec lblm">
						<div class="DFA">
					        <label>Enter Title of Graph *
					        <span class="tooltip ml-10 dropTip ttl">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip hov-l-z">Enter the title that better explains your graph.</div>
                            </span>
                            </label>
                        </div>
						<input id="graphTitle" :maxlength="dynamicMaxLength" name="Enter Name" class="txsrch filterinput mr-10"  placeholder="Type Widget Name" v-model="graphName" type="text" />
					</div>
					
					<div v-if="!_.isEmpty(collections)" class="rec lblm">
						<label>Select Collection *
						    <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip hov-l-z">
                                    Select a collection to display its data in the charts. Only collections you have access to will appear in the dropdown.
                                </div>
                            </span>
						</label>
						<div class="DF">
                            <div id="collection-dropdown" class="selectcont nwsl FL"><vz-select v-model="selectedCollection" :options="collections" empty-selection-text="Select Collection" label="title" track-by="id" value-type="object" @close="" @select="handleCollectionSelection()"/></div> 
                        </div>
					</div>	
																	
					<div v-if="!_.isEmpty(filterList)" class="rec lblm">
					    <label>Select Datasource Filter
					        <span class="tooltip ml-10 dropTip nxt">
                               <em class="infotxt"></em> 
                               <div class="hovtooltip hov-l-z">
                                 This dropdown allows you to select a pre-defined filter from your collection. The charts will update to display only the data that matches the selected filter. Only filters accessible to you in the selected collection will be available.
                               </div>
                            </span>
					    </label>
						<div class="DF">
                            <div id="datasource-filter" class="selectcont nwsl FL">
                                <vz-select 
                                    class="reset"
                                    v-model="selectedFilter" 
                                    :options="filterList" 
                                    empty-selection-text="Select Data Source Filter" 
                                    label="name" 
                                    track-by="id" 
                                    value-type="object" 
                                    @close="" 
                                    @select="handleFilterSelection()" 
                                    :disabled="isDatasourceFilterDisabled"
                                    :key="filterKey"
                                />
                            </div>
                        </div>
					</div>
					<div v-if="(!_.isEmpty(hierarchyLevels)) && !_.isEmpty(selectedCollection)" class="rec lblm">
					    <label>Select Backlog Level
					        <span class="tooltip ml-10 dropTip nxt">
                               <em class="infotxt"></em> 
                               <div class="hovtooltip hov-l-z">
                                 Select Backlog Level
                               </div>
                            </span>
					    </label>
						<div class="DF">
                            <div id="datasource-hierarchy" class="selectcont nwsl FL">
                                <vz-select 
                                    class="reset"
                                    empty-selection-text="Select Backlog Level"
                                    :options="hierarchyLevels" 
                                    v-model="currentSelectedHierarchyLevelForItem" 
                                    value-type="object" 
                                    @close="" 
                                    label="title" 
                                    track-by="id" 
                                    @select="value => onSelectHierarchy(value)"
                                    :disabled="disableBacklogLevel"
                                    :key="backlogLevelKey"
                                />
                            </div>
                        </div>
					</div>
					
					<div v-if="(!_.isEmpty(filterList) || !_.isEmpty(hierarchyLevels)) && !_.isEmpty(selectedCollection)" class="rec lblm">
					    <div class="DFA">
					        <label>Select Group By *
                                <span class="tooltip ml-10 dropTip ttl">
                                   <em class="infotxt"></em> 
                                   <div class="hovtooltip hov-l-z">
                                     Select a criterion to group the data displayed in the widget. For example, choosing "Teams" will show the team-wise data, helping you analyze performance or metrics based on the selected grouping.
                                   </div>
                               </span>
                           </label>
                        </div>
					    <div id ="groupby" class="selectcont">
                            <vz-select label="title" empty-selection-text="Select Group By"
                            class="multi-filter" value-type="value" v-model="groupBy.value"
                            :options="groupBy.options" @select="onSelectMoreOptions" />
                        </div>
		            </div>
						
					<div v-if="_.isEmpty(filterList) && !_.isEmpty(collections) && !_.isEmpty(selectedCollection)" class="rec lblm nofound">
							No Filters Available
					</div>				
					<div class="DFA FL w-full gap-2"> 
                        <div v-if="!_.isEmpty(boardSprintListing)" class="rec lblm">
                            <label>Select Sprint</label>
                            <div  class="selectcont FL d">
                                <vz-select 
                                    :multiple="true" 
                                    label="title" 
                                    empty-selection-text="Select Program Board Sprint" 
                                    class="multi-filter"
                                    value-type="object" 
                                    v-model="selectedBoardSprint" 
                                    :options="boardSprintListing"
                                    :show-select-all-on-group=false
                                    track-by="id"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip">
                                        text test here
                                    </div>
                            </span>	
                        </div>
					</div>	
				
				
					<div v-if="((!_.isEmpty(issueTypesList)  &&  ((optionTypeTitle === 'Time in Status'  ) || optionTypeTitle === 'Lead Time Graph'  ) && graphSelected && !_.isEmpty(selectedBoard)  && !_.isEmpty(graphName)   && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection)) || (( optionTypeTitle =='Item Completion by Teams' || optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph'  ) && !_.isEmpty(selectedBoard) )) " class="rec lblm">
						<label>Select Issue Type</label>
						<div class="DF">
                            <div id="issueType" class="selectcont FL d w-half">
                                <vz-select 
                                    :multiple="true" 
                                    label="name"
                                    empty-selection-text="Select Issue Type" 
                                    class="multi-filter"
                                    value-type="value" 
                                    v-model="selectedIssueType" 
                                    :options="issueTypesList"
                                    :groups-enabled=false
                                    :show-select-all-on-group=false
                                    track-by="id"
                                    @select="clearFilterIfEmptyIssueTypes"
                                />
                            </div>	
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Choose one or more issue types from the dropdown menu. The widget will display items with the selected issue types from the chosen PI board.
                                </div>
                            </span>
                        </div>	
					</div>
				
					<div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram' " class="prow">
                        <label class="p-rel">Select Items <a v-if="!_.isEmpty(this.filterwithMeta)" href="javascript:void(0);" class="reset und" @click="resetFilter">Reset</a></label>
                        <div class="DF">
                            <div id="srch-cont" class="srchout prow">
                                <div id="searchTerm" class="sin">
                                    <div class="c1">
                                        <input 
                                            id="input-srch-ext" 
                                            class="srfld form-control" 
                                            type="text" 
                                            placeholder="To search, please type ID or Title..." 
                                            v-model="searchTerm" 
                                            @keydown.enter="handleSearch"
                                        />                                        
                                    </div>
                                    <div id="srch-lst-cont" class="link-over drop_box cssHidea"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                    <div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram'">
                        <span  class="search_tags">
                            <ul id="search-text_tags">
                                <li v-for="(title, id) in filterwithMeta" :key="id" class="tooltip">
                                    {{ title.key }} 
                                    <i @click="onRemoveTag(id)" class="ti-close"></i>
                                    <div class="hovtooltip">{{ title.title }} </div>
                                </li>
                            </ul>
                        </span>
                    </div>
					
			
					<div v-if="selectedFilterType == 'teams' && !_.isEmpty(selectedCondition) && selectedGraph =='2' " class="rec lblm">
							<label>Select Additional Graph GroupBy</label>
							<div class="selectcont nwsl FL"><vz-select v-model="selectedAdditionalFilterCriteria" :options="additionalFilterCriteriaList" empty-selection-text="Select Additional Graph GroupBy" label="name" track-by="id" value-type="object" @close="" /></div>
					</div>
					
					<div v-if="selectedFilterType == 'teams' && !_.isEmpty(selectedCondition) && !_.isEmpty(selectedAdditionalFilterCriteria) && selectedGraph =='2' " class="rec lblm">
							<label>Select Additional Graph Type</label>
							<div class="selectcont nwsl FL"><vz-select v-model="selectedAdditionalGraphOption" :options="additionalGraphOptionList" empty-selection-text="Select Additional Graph Type" label="name" track-by="id" value-type="object" @close="" /></div>
					</div>	
									
					<div v-if="!_.isEmpty(selectedCondition) && !_.isEmpty(boardTeamListing)" class="rec lblm">
						<label>Select Program Board Teams</label>
						<div class="selectcont nwsl FL"><vz-select :multiple=true v-model="selectedBoardTeams" :options="boardTeamListing" empty-selection-text="Select Program Board Teams" label="title" track-by="_id" value-type="object" @select=""/></div>
					</div>	
									
					<div v-if="!_.isEmpty(selectedCondition) && !_.isEmpty(boardSprintListing)" class="rec lblm">
						<label>Select Program Board Sprint</label>
						<div class="selectcont nwsl FL"><vz-select :multiple=true v-model="selectedBoardSprint" :options="boardSprintListing" empty-selection-text="Select Program Board Sprint" label="title" track-by="_id" value-type="object" /></div>
					</div>					
				</div>
				<div class="rec btn">
					 <button  type="button" class="button rds4 FR" @click="passRequestObjToWidgetParent">Save</button> 
				</div>
			</div>	
		</div>
	`,

//Data Used
    props : {
        graphWidth: {
            type: Number,
            default: 950,
        },
        graphTypeOptionTitle    : null,
        optionTypeTitle         : null,
        graphTypeTitle          : null,
        dashboardSelected       : null,
        widgetType              : null,
        editMode                : null,
        selectedWidget          :null,
    },

    data() {
        return {
            hierarchyLevels: [],
            currentSelectedHierarchyLevelForItem: {},
            boardListing: [],
            selectedBoard: {},
            eventStartDate: '',
            eventEndDate: '',
            cfdResponceData: {},

            boardTeamListing: [],
            selectedBoardTeams: {},

            boardSprintListing: [],
            selectedBoardSprint: {},

            statusListing: {

                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},

            },
            format: 'MMM dd yyyy',
            collections: [],
            selectedCollection: '',
            filterList: [],
            additionalFilterCriteriaList: [{name: "Status Category", id: "statusCategory"}],
            additionalGraphOptionList: [{name: "Column With Breakdown", id: "colBreakDown"}],
            selectedFilter: null,
            selectedAdditionalFilterCriteria: null,
            selectedAdditionalGraphOption: null,
            selectedCondition: [],
            selectedStatusCategory: "0",
            filterSelected: false,
            graphsList: [{name: "Pie Chart", id: "1"}, {name: "Column Chart", id: '3'}],
            graphsListCFD: [{name: "Column Chart", id: '3'}, {
                name: "Basic Area Chart",
                id: '4'
            }, {name: "Stacked Area Chart", id: '5'}],
            graphsListFlowTime: [{name: "Column Chart", id: '3'}],
            filterTypes: [{name: "Status", id: "status"}, {name: "Teams", id: "teams"}],
            filterTypesCFD: [{name: "CFD", id: "cfd"}],
            selectedFilterType: null,
            selectedGraph: "1",
            graphSelected: false,
            popupData: [],
            selectedInterval: null,
            intervalList: [{id: '5', title: '5'}, {id: '10', title: '10'}, {id: '20', title: '20'}, {
                id: '40',
                title: '40'
            }, {id: '50', title: '50'}, {id: 'custom', title: 'custom'}],
            customInterval: null,
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 50,
                pageIndex: 0,
                pageSizeOptions: [50, 100, 200],
                totalItemSize: 0
            },
            nextPageFirstItem: undefined,
            selectedTileItems: [],
            conditionsList: [],
            filteredData: [],
            graphName: '',
            widgets: [],
            collectionSelected: false,
            filterTypeSelected: false,
            optionsList: [],
            statusList: [],
            selectedStatus: null,
            radioOptions: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
            ],
            radioOptionsLeadTime: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
                {label: 'Creation date', value: 'creationDate'},
            ],
            pickedRadioType: 'status',
            categoryList:[],
            selectedIssueType:null,
            issueTypesList:[],
            additionalCriteriaForFlowTime : [{name: "Issue Type", id: "issueType"}],
            selectedAdditionalCriteriaForFlowTime:null,
            showloader:false,
            flowTimeLineGroupByList:[
                {name:"Teams",id:"teams"},
                {name:"Assignee",id:"assignee"}
            ],
            selectedFlowTimeLineGroupBy:null,
            xAxisList:[
                {name:"Sprints",id:"sprints"},
                {name:"Days",id:"days"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],
            selectedXAxis:null,
            sessionBoard:[],
            boardType:null,
            tfsProjects:[],
            jiraFieldsMap:{},
            //Filter related data attributes
            selectedFilters: [],
            boardFilter:[],
            almAccountType:'',
            almFields:[],
            moreFilterOptions:[],
            filterCriteriaList:[],
            timelineFilters:[],
            selectedTimelineFilter:[],
            selectedHierarchyLevels:'',
            selectedLevel:'',
            rowFilterTypeValue: [],
            moreFilterSelected: [],
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            groupBy: {
                applied: false,
                options: [
                    { title: "No Group", id: "-1" },
                    { title: "Parent", id: "Parent" },
                    { title: "PI Boards", id: "Session" },
                    { title: "Batches", id: "Batches" },
                    { title: "Teams", id: "Teams" },
                    { title: "Sprints", id: "Containers" },
                    { title: "Solution Boards", id: "SolutionBoards" },
                    { title: "Status", id: "kendisStatus" },
                ],
                value: "-1",
                subValue: "-1",
                showPopup: false,
                multiGroups: [],
                groupConfig: {}
            },
            almAccountType:'',
            collectionType:'',
            additionalGroupByFilters:{
                adoOptions: [
                    { title: "Area Path", id: "AreaPath" },
                    { title: "Iteration Path", id: "Iteration" },
                    { title: "ADO Project", id: "Project" },
                ],
                jiraOptions: [
                    { title: "Jira Project", id: "project" },
                ],
                adoOptionsIncluded: false,
                kendisOptionsIncluded: false,
                jiraOptionsIncluded: false,
                adoCustomOptionsIncluded: false,
                jiraCustomOptionsIncluded: false
            },
            defaultGroupByOptions: [],
            jiraSchemaType:'',
            disableBacklogLevel: false,
            disableDataSourceFilter: false,
            backlogLevelKey: 0,
            filterKey: 0,
            kendisCustomFields: [],
            jiraFilter : []
        }
    },

//Life Cycle Methods
    created() {
        this.getBoardOrOrgDataOnTheBasiesOfSelection();
       // this.createFilterOptionsData();
        this.defaultGroupByOptions = [...this.groupBy.options];
    },

    mounted() {
        // this.selectedFilterType ='cfd';
        this.graphSelected = true;
        if(this.editMode){
            this.onLoadConfiguration();
            this.graphName = this.selectedWidget.name;
            this.selectedGraph = this.selectedWidget.collectionsGraphCriteria.graphType;
            // this.optionTypeTitle = this.selectedWidget.collectionsGraphCriteria.optionTypeTitle;
            this.graphTypeTitle = this.selectedWidget.collectionsGraphCriteria.graphTypeTitle;
            this.selectedFilterType = this.selectedWidget.type
        }
    },

    computed: {
        isBacklogLevelDisabled() {
            return this.disableBacklogLevel
        },

        isDatasourceFilterDisabled() {
            return this.disableDataSourceFilter
        },

        dynamicMaxLength() {
            let maxLength = 255;
            if (this.graphWidth > 1200) maxLength = 500;
            else if (this.graphWidth > 900) maxLength = 400;
            else if (this.graphWidth > 600) maxLength = 300;
            return maxLength;
        }
    },

    watch : {},

//External Components Used:

    components: {
        vuejsDatepicker,
        VueAdsPagination : window["vue-ads-pagination"].default,
        VueAdsPageButton : window["vue-ads-pagination"].VueAdsPageButton,
    },

//Methods used in this Graph Criteria
    methods: {

        onSelectHierarchy(selectedValue) {
            if(selectedValue.id === "reset"){
                this.backlogLevelKey += 1;
                this.filterKey += 1;
                this.disableBacklogLevel = false;
                this.disableDataSourceFilter = false;
            }else{
                this.disableBacklogLevel = false;
                this.disableDataSourceFilter = true;
                this.backlogLevelKey += 1;
                this.filterKey += 1;
            }
            this.selectedFilter = null;
        },

        fetchBacklogItemsSettings: function(){
            this.disableBacklogLevel = false;
            this.disableDataSourceFilter = false;
            this.backlogLevelKey += 1;
            this.filterKey += 1;
            let requestBody = {
                "releaseTrainId"   : this.selectedCollection.id,
                "fetchHierarchies" : true,
                "fetchFilters" : true
            }
            axios.post("/releasetrain/fetch-release-train-hierarchies-and-filters", requestBody)
                .then(response => {
                    this.hierarchyLevels = response.data.hierarchyLevels;
                    this.filterList = response.data.filterCriterias.filter(filter => !filter.userId);
                    this.kendisCustomFields = response.data.defaultKendisCardLayout.fields.map(field => ({id: "kendisFields-"+field.field.id, title: field.field.title, itemType: "version"}));
                    let jiraFields = [];
                    response.data?.hierarchyLevels?.forEach(level =>{
                        level.almHierarchyLevelMappings.map( obj => {
                            if(obj?.jiraFields?.length > 0 && obj?.jiraFields[0] && !this.additionalGroupByFilters.jiraOptionsIncluded){
                                this.collectionType = "jira";
                                this.additionalGroupByFilters.jiraOptionsIncluded = true;
                                this.additionalGroupByFilters.adoOptionsIncluded = false;
                                jiraFields = obj?.jiraFields.map(field => ({ title: field.name, id: field.id }));
                                this.jiraFilter = [...obj?.jiraFields];
                                this.groupBy.options = [...this.groupBy.options, ...jiraFields];
                            }
                        })
                    });

                    if(!this.additionalGroupByFilters.kendisOptionsIncluded){
                        this.additionalGroupByFilters.kendisOptionsIncluded = true;
                        this.groupBy.options = [...this.groupBy.options, ...this.kendisCustomFields];
                    }
                    this.groupBy.options = this.groupBy.options.filter(group => group.title !== "rett");


                    if(_.isEmpty(this.hierarchyLevels) && _.isEmpty(this.filterList)){
                        return;
                    }

                    if(this.filterList.length !== 0){
                        this.filterList.unshift({ id: "reset", name: "Reset"});
                    }

                    if(this.hierarchyLevels?.length !== 0){
                        this.hierarchyLevels.unshift({ id: "reset", title: "Reset"});
                    }
                    if (this.editMode && (!this.selectedWidget.collectionsGraphCriteria.hierarchyLevelId || this.selectedWidget.collectionsGraphCriteria.hierarchyLevelId === "")) {
                        this.selectedFilter = this.filterList.find(item => item.id === this.selectedWidget.collectionsGraphCriteria.filterId);
                    }else{
                        this.selectedFilter = null;
                    }

                    if(this.editMode && (_.isEmpty(this.selectedFilter))){
                        let selectedLevel = this.hierarchyLevels?.find( level => level.id === this.selectedWidget.collectionsGraphCriteria.hierarchyLevelId)
                        if (selectedLevel) {
                            this.currentSelectedHierarchyLevelForItem = selectedLevel;
                            this.disableBacklogLevel = false;
                            this.disableDataSourceFilter = true;
                            this.backlogLevelKey += 1;
                            this.filterKey += 1;
                        }
                    }else if(this.editMode && (!_.isEmpty(this.selectedFilter) && (!_.isEmpty(this.hierarchyLevels)))){
                        this.currentSelectedHierarchyLevelForItem = this.hierarchyLevels?.find( level => level.level === this.selectedFilter.level);
                        this.disableBacklogLevel = true;
                        this.disableDataSourceFilter = false;
                        this.backlogLevelKey += 1;
                        this.filterKey += 1;
                    }
                    this.showloader = false;
                })
                .catch(error => {
                    console.error("Error occurred while fetching hierarchy levels: ", error);
                });
        },

        //Edit
        onLoadConfiguration:function(){
            this.showloader = true;
            this.fetchAllCollections();
        },
        ///
        handleConfigClosure:function(){
            if(this.editMode){
                this.$emit('editClose')
            }else{
                this.$emit('close')
            }
        },

        checkAllThingsAreSelectedToEnableSaveButton : function(){
            let error = false;
            if (!_.isEmpty(this.selectedCollection) && (!_.isEmpty(this.selectedFilter) || !_.isEmpty(this.currentSelectedHierarchyLevelForItem)) && !_.isEmpty(this.groupBy.value) && !_.isEmpty(this.graphName)) {
                return true;
            } else{
                if(_.isEmpty(this.graphName)){
                    $("#graphTitle").addClass("red");
                    error = true;
                }
                if (!_.isEmpty(this.graphName)) {
                    if (this.graphName.trim() === "") {
                        $("#graphTitle").addClass("red");
                        error = true;
                    } else {
                        $("#graphTitle").removeClass("red");
                    }
                }
                if(_.isEmpty(this.selectedCollection)){
                    $("#collection-dropdown").addClass("red");
                    error = true;
                }
                if(!_.isEmpty(this.selectedCollection)){
                    $("#collection-dropdown").removeClass("red");
                }
                if(_.isEmpty(this.selectedFilter) && _.isEmpty(this.currentSelectedHierarchyLevelForItem)){
                    $("#datasource-filter").addClass("red");
                    $("#datasource-hierarchy").addClass("red");
                    error = true;
                }
                if(!_.isEmpty(this.selectedFilter) || !_.isEmpty(this.currentSelectedHierarchyLevelForItem)){
                    $("#datasource-filter").removeClass("red");
                    $("#datasource-hierarchy").removeClass("red");
                }
                if(_.isEmpty(this.groupBy.value)){
                    $("#groupby").addClass("red");
                    error = true;
                }
                if(!_.isEmpty(this.groupBy.value)){
                    $("#groupby").removeClass("red");
                }

                return false;
            }
        },

        passRequestObjToWidgetParent:function(){
            if(!this.checkAllThingsAreSelectedToEnableSaveButton()) {
                showTopMessage("Please provide all the information","warning", 2000);
            }
            else {
                const selectedOption = this.groupBy.options.find(o =>
                    o.id === this.groupBy.value
                );
                if(!selectedOption || (!this.disableDataSourceFilter && !this.disableBacklogLevel)){
                    showTopMessage("Please provide all the information", "warning", 2000);
                    return;
                }
                let data = {};
                data.requestId = getNewUUID();
                data.id = this.selectedCollection.key;

                let filters = [];
                axios.post("/releasetrain/" + this.selectedCollection.key, data).then(res => {

                    if(this.collectionType === "ado"){
                        let filterSet = new Set();
                        res.data.backlogHierarchyLevels.forEach(l => {
                            l.almHierarchyLevelMappings.forEach( l =>{
                                l?.tfsFields?.forEach(field =>{
                                    filterSet.add(JSON.stringify({title: field.name, type: field?.type}));
                                })
                            })
                        });
                        filters = Array.from(filterSet).map(item => JSON.parse(item));
                    }else if(this.collectionType === "jira"){
                        res.data.layouts.kendisCard.fields?.forEach(f => {
                            filters.push({title: f.field.title, type: f.field?.type});
                        });
                    }

                    let field = filters.find(filter => filter.title === selectedOption.title);
                    let requestBody = {
                        group : this.groupBy.value,
                        title: selectedOption.title,
                        titleOfGraph : this.graphName,
                        releaseTrainId : this.selectedCollection.id,
                        collectionName: this.selectedCollection.title,
                    }

                    if (!_.isEmpty(this.currentSelectedHierarchyLevelForItem) && this.disableDataSourceFilter) {
                        requestBody.level = this.currentSelectedHierarchyLevelForItem.level;
                        requestBody.hierarchyLevelId = this.currentSelectedHierarchyLevelForItem.id;
                    } else if(!_.isEmpty(this.selectedFilter)) {
                        requestBody.filter = this.selectedFilter;
                        requestBody.level = this.selectedFilter.level;
                        requestBody.hierarchyLevelId = "";
                    }

                    const level = this.hierarchyLevels.find(level => level.level === requestBody.level)
                    let issueType = "";
                    if(this.groupBy.value.startsWith("kendisFields-")){
                        // issueType = "string"
                    }else if(level?.almHierarchyLevelMappings[0]?.jiraFields){
                        issueType = level?.almHierarchyLevelMappings[0].jiraFields.find(field => field.name === requestBody.title)
                        issueType = issueType?.schema?.items || "";
                    }


                    if(this.collectionType === "jira"){
                        if (field) {
                            if(field.type === 'singleselect') {
                                requestBody.type = "object";
                            }else if (field.type === 'multiselect') {
                                requestBody.type = "array";
                            }else if (field.type === "userpicker") {
                                requestBody.type = "user";
                            }else{
                                requestBody.type = "string";
                            }
                            requestBody.customType = field.type;
                        }else{
                            requestBody.type = selectedOption.type;
                        }
                        requestBody.itemType = issueType;
                    }else{
                        requestBody.type = field?.type || "";
                    }
                    if(!field && this.jiraFilter.length > 0){
                        const f = this.jiraFilter.find(f => f.id === this.groupBy.value);
                        if(f){
                            requestBody.type = f?.schema?.type;
                        }
                    }
                    this.$emit('populate-graph', requestBody);
                })
            }
        },

        handleSprintSelection:function(){console.log("selection of sprint: ", this.selectedBoardSprint)},

        getBoardOrOrgDataOnTheBasiesOfSelection : function(){
                this.fetchAllCollections();
        },

        getGraphDataOnTheBasiesOfSelection : function(){

            if(this.graphTypeOptionTitle === "Cumulative Flow Diagram"){
                if(this.optionTypeTitle ==='By Status Category'){
                    let requestBody = {
                        sessionBoardId 	  : this.selectedBoard.activeSessionBoard,
                        statusIds 		  : this.selectedCondition,
                        startDate 		  : this.eventStartDate.format("d mmm yyyy"),
                        endDate			  : this.eventEndDate.format("d mmm yyyy"),
                        tenant			  : this.selectedBoard.tenant,
                        statusListing     : this.statusListing,
                        selectedGraph     : this.selectedGraph,
                        graphName         : this.graphName,
                        selectedFilterType: this.selectedFilterType,
                        selectedBoard     : this.selectedBoard,
                        orignalStartDate  : this.eventStartDate,
                        orignalEndDate    : this.eventEndDate,
                        optionTypeTitle   : this.optionTypeTitle,
                        graphTypeTitle    : this.graphType.title,
                    }
                    console.log("REQUEST BODY: ",requestBody);
                    if(!_.isEmpty(this.selectedBoardTeams)){
                        let idsArray = this.selectedBoardTeams.map(item => item._id);
                        requestBody["teams"] = idsArray;
                    }

                    if(!_.isEmpty(this.selectedBoardSprint)){
                        let idsArray = this.selectedBoardSprint.map(item => item._id);
                        requestBody["sprints"] = idsArray;
                    }
                    this.$emit('populate-graph',requestBody);
                }
            }
            else if(this.graphTypeOptionTitle == "Collection Metrics")
            {
                var conditionsList=this.conditionsList;
                var selectedItems=this.selectedCondition;
                var selectedGraph=this.selectedGraph;
                var graphName=this.graphName;
                var selectedCollectionId=this.selectedCollection.id;
                var dataofGraph={"graphType":selectedGraph,"itemList":conditionsList,"selectedItems":selectedItems,"hierarchyLevel": "" + this.selectedFilter.level};
                this.widgets=[];
                var widgetData={};
                console.log("Widget Data: ", widgetData);
                if(!_.isEmpty(this.selectedAdditionalFilterCriteria) && !_.isEmpty(this.selectedAdditionalGraphOption)) {
                    widgetData = {
                        name: graphName,
                        type: this.selectedFilterType,
                        graphCriteria: dataofGraph,
                        releaseTrainId: selectedCollectionId,
                        criteria: this.selectedFilter,
                        selectedAdditionalGraphOption: this.selectedAdditionalGraphOption.id,
                        selectedAdditionalFilterCriteria: this.selectedAdditionalFilterCriteria.id,
                    };
                    var data={};
                    data.groupBy = this.selectedAdditionalFilterCriteria.id;
                    data.parentGroup = this.selectedFilterType;
                    data.selectedItems=selectedItems;
                    data.releaseTrainID=this.selectedCollection.id;
                    let requestBody = {
                        groupBy:this.selectedAdditionalFilterCriteria.id,
                        parentGroup:this.selectedFilterType,
                        selectedItems:selectedItems,
                        releaseTrainID:this.selectedCollection.id,
                        graphName : graphName,
                        conidtionsList:this.conditionsList,
                        selectedItems:this.selectedCondition,
                        selectedGraph:this.selectedGraph,
                        selectedCollectionId:this.selectedCollection.id,
                    };

                    axios.post("/dashboard/" + this.dashboardSelected + "/retrieveAdditionalItems/",data).then(response => {
                        console.log("Response of Additional Items: ",response.data.itemsList);
                        const itemList=response.data.itemsList;
                        var graphAdditionalCriteriaList=[];
                        for(let i =0 ;i<itemList.length;i++){
                            var graphAdditionalCriteria={};
                            graphAdditionalCriteria.title=itemList[i].title;
                            graphAdditionalCriteria.id=itemList[i].id;
                            graphAdditionalCriteria.itemList=itemList[i].statusList;
                            graphAdditionalCriteriaList.push(graphAdditionalCriteria);
                        }
                        widgetData.graphAdditionalCriteria=graphAdditionalCriteriaList;

                        this.graphName="";
                        this.selectedCollection.id="";
                        this.selectedGraph="";
                        this.selectedCondition=[];
                        this.conditionsList=[];
                        this.$emit('populate-graph',requestBody);
                    }).catch(error => {
                        console.error(error)
                    });
                }
                else {
                    let requestBody = {
                        selectedItems:selectedItems,
                        releaseTrainID:this.selectedCollection.id,
                        graphName : graphName,
                        conidtionsList:this.conditionsList,
                        selectedItems:this.selectedCondition,
                        selectedGraph:this.selectedGraph,
                        selectedCollectionId:this.selectedCollection.id,
                    };

                    this.conditionsList = requestBody.conidtionsList;
                    this.selectedCondition =  requestBody.selectedCondition;
                    this.selectedGraph = requestBody.selectedGraph;
                    this.graphName = requestBody.graphName;
                    this.selectedCollectionId = requestBody.selectedGraph;

                    widgetData = {
                        name: graphName,
                        type: this.selectedFilterType,
                        graphCriteria: dataofGraph,
                        releaseTrainId:selectedCollectionId,
                        criteria:this.selectedFilter,
                    }

                    axios.post("/dashboard/"+this.dashboardSelected+"/widget/save",widgetData).then(response=>{
                        this.graphName="";
                        this.selectedCollection.id="";
                        this.selectedGraph="";
                        this.selectedCondition=[];
                        this.conditionsList=[];
                        this.$emit('closeSelection',response.data.widget);
                    }).catch(e=>{
                        console.error(e);
                    })
                }
            }
        },

        handleSelect:function(){
            console.log("This item selected: ",this.selectedAdditionalFilterCriteria);
        },

        populateTeamsAndSprintData : function(response,requestBody){

            if(requestBody['teams']){

                let teamSequence = response['teamSequence'];
                let teamsGroupBy = _.groupBy(response['teams'],'_id');

                for(let teamId of teamSequence){

                    this.boardTeamListing.push(teamsGroupBy[teamId][0]);
                }
            }

            if(requestBody['sprints']){

                this.boardSprintListing = response["sprints"];
            }
        },

        getPIStartEndDates: function(boardId){
            console.log("Inside getPIStartEndDates()");
            let _this = this;
            axios.get('/dashboard/get-start-end-date/'+ boardId)
                .then(response => {
                    try{
                        if (response.data) {
                            console.log(response.data);
                            _this.eventStartDate = new Date(response.data.startDate);
                            _this.eventEndDate = new Date(response.data.endDate);
                        }
                    }catch(e){
                        handleErrorSprintReportMsg(e);
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                    handleErrorSprintReportMsg(error);
                });
        },

        fetchAllCollections: function () {
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            axios.post("/dashboard/fetch-all-release-trains", data)
                .then(response => {
                    if (response.data) {
                        _this.collections = response.data.releaseTrains.filter( collection => collection?.type);
                        if(_this.editMode){
                            _this.selectedCollection = _this.collections.find(item => item.id === this.selectedWidget.collectionsGraphCriteria.releaseTrainId);
                            _this.handleCollectionSelection();
                        }
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        handleGraphSelection:function(){
            this.graphSelected=true;
        },

        handleCollectionSelection: function () {
            this.collectionSelected=true;
            this.filterList=[];

            if(this.selectedCollection){
                if(this.selectedCollection?.almFilters?.length > 0){
                    if(this.selectedCollection.almFilters[0]?.jiraFilter && !this.additionalGroupByFilters.jiraOptionsIncluded){
                        this.collectionType = "jira";
                        this.groupBy.options = [...this.defaultGroupByOptions, ...this.additionalGroupByFilters.jiraOptions];
                        this.additionalGroupByFilters.jiraOptionsIncluded = true;
                        this.additionalGroupByFilters.adoOptionsIncluded = false;
                    }else if (this.selectedCollection?.almFilters[0]?.tfsFilter && !this.additionalGroupByFilters.adoOptionsIncluded) {
                        this.collectionType = "ado";
                        this.groupBy.options = [...this.defaultGroupByOptions, ...this.additionalGroupByFilters.adoOptions];
                        this.additionalGroupByFilters.adoOptionsIncluded = true;
                        this.additionalGroupByFilters.jiraOptionsIncluded = false;
                    }
                }

                this.fetchAllGroupings();
                this.fetchBacklogItemsSettings();
            }

        },

        handleFilterSelection:function(){
            this.currentSelectedHierarchyLevelForItem = null;
            if(this.selectedFilter.id === "reset"){
                this.disableBacklogLevel = false;
                this.disableDataSourceFilter = false;
                this.backlogLevelKey += 1;
                this.filterKey +=1;
                return;
            }

            let selectedLevel = this.hierarchyLevels?.find( level => level.level === this.selectedFilter.level);
            if (selectedLevel) {
                this.currentSelectedHierarchyLevelForItem = selectedLevel;
            }

            this.disableBacklogLevel = true;
            this.disableDataSourceFilter = false;
            this.backlogLevelKey += 1;
            this.filterKey +=1;

            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
            this.filterSelected=true;
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
        },

        loadBacklogItems: function(filterBy) {
            var _this = this;
            var data = {};
            data.hierachLevel = "" + this.selectedFilter.level;
            data.fetchParents  = true;
            data.filterBy=filterBy;
            data.requestId = getNewUUID();
            data.filter = this.selectedFilter.criteria;
            if (data.filter && !_.isEmpty(data.filter.rules)) {
                console.log("This is what I am getting in data: ",data);
            }else {
                delete data.filter;
            }
            axios.post('/dashboard/' + this.selectedCollection.id + '/retrieveItems', data)
                .then(res => {
                    if (res.data) {
                        var items = [];
                        items = res.data;
                        this.filteredData=[];
                        this.filteredData=items;
                        this.populateConditionsDropdown(items);
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        populateConditionsDropdown: function (response) {
            let _this = this;
            this.conditionsList = [];
             {
                 try {
                     let groupedItems = {};
                     for (let status of response) {
                         if (!groupedItems[status.title]) {
                             groupedItems[status.title] = {
                                 title: status.title,
                                 ids: [],
                                 category: status.category,
                             };
                         }
                         groupedItems[status.title].ids.push(status.id);
                     }

                     let resultList = Object.values(groupedItems);

                     if (resultList) {
                         _this.statusListing.startOfStatusListing = resultList;
                         _this.statusListing.endOfStatusListing = resultList;

                         let categoryMap = new Map();
                         let statuscategoryMap = new Map();

                         for (let i = 0; i < resultList.length; i++) {
                             let category = resultList[i].category;
                             if (!categoryMap.has(category)) {
                                 categoryMap.set(category, []);
                             }
                             if (!statuscategoryMap.has(category)) {
                                 statuscategoryMap.set(category, []);
                             }
                             let condition = {
                                 ids: resultList[i].ids,
                                 title: resultList[i].title
                             };
                             categoryMap.get(category).push(condition);
                             let conditionStatusCategory = resultList[i].ids;
                             statuscategoryMap.get(category).push(conditionStatusCategory);
                         }

                         let sortedEntries = Array.from(categoryMap.entries());
                         let sortedEntriesForStatusCategory = Array.from(statuscategoryMap.entries());

                         const order = ["ToDo", "InProgress", "Done", "Misc"];
                         sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                         sortedEntriesForStatusCategory.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));

                         let transformedEntriesForStatusCategory = sortedEntriesForStatusCategory.map(entry => {
                             let category = entry[0];
                             let nestedArrays = entry[1];
                             let uniqueIdsList = [];
                             for (let i = 0; i < nestedArrays.length; i++) {
                                 let nestedArray = nestedArrays[i];
                                 for (let j = 0; j < nestedArray.length; j++) {
                                     if (!uniqueIdsList.includes(nestedArray[j])) {
                                         uniqueIdsList.push(nestedArray[j]);
                                     }
                                 }
                             }
                             return {
                                 key: category,
                                 value: {
                                     ids: uniqueIdsList
                                 }
                             };
                         });

                         categoryMap = new Map(sortedEntries);

                         let categoryList = [];
                         categoryMap.forEach((items, category) => {
                             categoryList.push({
                                 title: category,
                                 items: items
                             });
                         });

                         let statusCategoryList = [];
                         transformedEntriesForStatusCategory.forEach((items) => {
                             statusCategoryList.push({
                                 title: items.key,
                                 ids: items.value.ids.join(","),
                             });
                         });
                         _this.statusList = categoryList;
                         _this.fromStatusList = categoryList;
                         _this.toStatusList = categoryList;
                         _this.categoryList = statusCategoryList;
                     }
                     console.log(this.categoryList);
                     console.log(this.statusList);
                 } catch (e) {
                     handleErrorSprintReportMsg(e);
                     console.log(e);
                 }
            }
        },


        //Groupby related methods
        createGroupByOptionsData: function() {

            //
            this.$options.columsMap = {};
            this.$options.columsMap["status"] = { id: "status", title: "Status", sortCommand: "statusTitle", sort: true, class:"c3" };
            this.$options.columsMap["children"] = { id: "children", title: "Children Count", sortCommand: "childCount", sort: false , class:"c3"};
            this.$options.columsMap["estimate"] = { id: "estimate", title: "Estimate (SP)", sortCommand: "totalEstimate", sort: false , class:"c3", toolTip:"Rollup Estimate"};
            this.$options.columsMap["startDate"] = { id: "startDate", title: "Start Date", sortCommand: "startDate", sort: true , class:"c3"};
            this.$options.columsMap["endDate"] = { id: "endDate", title: "End Date", sortCommand: "endDate", sort: true , class:"c3"};
            this.$options.columsMap["boards"] = { id: "boards", title: "Kendis Board", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["batches"] = { id: "batches", title: "Batches", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["teams"] = { id: "teams", title: "Teams (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["sprints"] = { id: "sprints", title: "Sprints (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["solutionBoards"] = { id: "solutionBoards", title: "Solution Boards", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["r_st"] = { id: "r_st", title: "% Completion By Rollup (Status)", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["r_sp"] = { id: "r_sp", title: "% Completion By Rollup (Estimate)", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["c_st"] = { id: "c_st", title: "% Completion By Done Children", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["fetchedBy"] = { id: "fetchedBy", title: "Fetched By", sortCommand: "", sort: false , class:"c3"};
            let _this = this;
            if (this.almAccountType === "tfs") {
                this.$options.columsMap["project"] = { id: "project", title: "Project", sortCommand: "fields.tfsProject", sort: true , class:"c3"};
                this.$options.columsMap["areaPath"] = { id: "areaPath", title: "Area Path", sortCommand: "fields.tfsAreaPath", sort: true , class:"c3"};
                this.$options.columsMap["iterationPath"] = { id: "iterationPath", title: "Iteration Path", sortCommand: "fields.tfsIterationPath", sort: true , class:"c3"};
                this.$options.columsMap["responsible"] = { id: "responsible", title: "Responsible", sortCommand: "fields.CreatedBy", sort: true , class:"c3"}
                if(!_.isEmpty(_this.almMappingByLevel[this.currentHierarchyLevel.level])) {
                    _.each(_this.almMappingByLevel[this.currentHierarchyLevel.level].tfsFields, field => {
                        if(field.type != 'treePath') {
                            let id = field.referenceName.replace(".","_");
                            _this.$options.columsMap[id] = { id: id, title: field.name, sortCommand: "almFields." +id, sort: true, class: "c3" };
                            _this.defaultSettingsPopup.dynamicAlmFields.push({ id: id, title: field.name, sortCommand: "almFields." +id, sort: true , disabled: false, class:"c3"});
                            _this.groupBy.options.push({ title: field.name, id: id });
                            if (id == _this.groupBy.value) {
                                _this.groupBy.type = field.type;
                                _this.groupBy.customType = field.type;
                            }
                        }
                    });
                }
            }
            else if (this.almAccountType === "jira") {
                this.$options.columsMap["responsible"] = { id: "responsible", title: "Responsible", sortCommand: "fields.assignee.displayName", sort: true , class:"c3"}
                if(!_.isEmpty(_this.almMappingByLevel[this.currentHierarchyLevel.level])) {
                    _.each(_this.almMappingByLevel[this.currentHierarchyLevel.level].jiraFields, field=>{
                        if(field && field.id) {
                            _this.$options.columsMap[field.id] = { id: field.id, title: field.name, sortCommand: "almFields." +field.id, sort: true , class:"c3"};
                            _this.defaultSettingsPopup.dynamicAlmFields.push({ id: field.id, title: field.name, sortCommand: "almFields." +field.id, sort: true , disabled: false, class:"c3"});
                            _this.groupBy.options.push({title: field.name, id: field.id});
                            if(field.id == _this.groupBy.value) {
                                _this.groupBy.type = field.schema.type;
                                if(field.schema.items) {
                                    _this.groupBy.itemType = field.schema.items;
                                }
                                if (field.custom) {
                                    _this.groupBy.customType = field.schema.custom;
                                }
                            }
                        }
                    });
                }
            }

            this.$options.columsMap["parent"] = { id: "parent", title: "Parent", sortCommand: "", sort: false , class:"c3"};

            this.$options.columsMap["updated"] = { id: "updated", title: "Updated On", sortCommand: "updatedOn", sort: true , class:"c3"}
            this.$options.columsMap["created"] = { id: "created", title: "Created On", sortCommand: "createdOn", sort: true , class:"c3"}
            this.$options.columsMap["creater"] = { id: "creater", title: "Creator", sortCommand: "", sort: false , class:"c3"}
            this.$options.columsMap["milstones"] = { id: "milstones", title: "Milestones", sortCommand: "", sort: false , class:"c3"}


            this.$options.columnOptions = Object.values(this.$options.columsMap);

            //................................
            if (this.almAccountType === "tfs") {
                this.groupBy.options.push({ title: "Project", id: "Project" });
                this.groupBy.options.push({ title: "Area Path", id: "AreaPath" });
                this.groupBy.options.push({ title: "Iteration Path", id: "Iteration" });
            }

            if(this.editMode){
                this.groupBy.value = this.selectedWidget.collectionsGraphCriteria.groupBy;
                this.showloader = false;
            }
        },

        onSelectMoreOptions:function(){
            console.log("Selected Grouping: ",this.moreFilterSelected);
        },

        handleRadioChange(value) {
            this.statusListing.startOfSelectedStatus = "";
            this.statusListing.endOfSelectedStatus = "";
        },

        fetchAllGroupings:function(){
          let hierarchyLevel = this.selectedCollection.level;
          let linkedAlmHierarchyId =  this.selectedCollection.linkedAlmHierarchy;
          let linkedAlmAccounts    =  this.selectedCollection.linkedAlmAccounts;
          const ids = Array.isArray(linkedAlmAccounts)
              ? linkedAlmAccounts.map(account => account.id)
              : [];

          let requestBody = {
              hierarchyLevel : hierarchyLevel,
              linkedAlmAccounts : ids,
              linkedAlmHierarchyId : linkedAlmHierarchyId,
              releaseTrainId : this.selectedCollection.id,
          };

          if (linkedAlmHierarchyId) {
              axios.post("/dashboard/retrieveGroupingForAlms",requestBody).
              then(response => {
                  let almFilters = [];
                  if(this.collectionType === "jira" && !this.jiraCustomOptionsIncluded){
                      almFilters = response.data?.almFields.map(alm => {
                          return {
                              title: alm.name,
                              id: alm.id,
                              ...(alm?.schema?.type && { type: alm.schema.type} )
                          }
                      })
                      this.groupBy.options = [...this.groupBy.options, ...almFilters]
                      this.jiraCustomOptionsIncluded= true;
                      this.adoCustomOptionsIncluded= false;
                  }else if(this.collectionType === "ado" && !this.adoCustomOptionsIncluded){
                      almFilters = response.data?.almFields.map(alm => {
                          return { title: alm.name, id: alm?.referenceName?.replace(/\./, "_"), name: alm.name}
                      })
                      this.groupBy.options = [...this.groupBy.options, ...almFilters]
                      this.adoCustomOptionsIncluded= true;
                      this.jiraCustomOptionsIncluded= false;
                  }
                  this.almFields = response.data.almFields;
                  this.createGroupByOptionsData();
              }).
              catch(error=>{console.error("Error fetching data of grouping",error)});
          }else {
              console.log("Incomplete data for fetchAllGroupings:", {
                  hierarchyLevel,
                  linkedAlmHierarchyId,
                  linkedAlmAccounts,
              });
          }
        },
    },

})