const flowEfficiencyEditCriteria = Vue.component('flow-efficiency-edit-criteria', {
    template: `
		<div id="overlay" class="overlay" style="display: block;">	
			<div class="ui-dialog widgetEditPopUp">
			  <div v-if="showloader" class="loader">
					<div>
						<div class="loaderinteg"></div>
					</div>
				</div>
				<div class="editPopUpHeader DFCB  pd-20 pb-0">
					<span class="fs-18 ftsb widgetPopUpTitle">
						Edit
						<span class="tooltip ml-10 dropTip ttl">
                           <em class="infotxt"></em> 
                           <div class="hovtooltip">{{optionTypeTitle}}</div>
                        </span>
					</span>
					<em title="Close" class="rmv-ico ti-close rnd DAJ p-intial" @click="$emit('close')"></em>
				</div>
				<div class="selectionPopUpContentWraper">			
					<div  class="rec lblm">					    
                        <label>Enter Title of Graph 
	                        <span class="tooltip ml-10 dropTip ttl">
	                            <em class="infotxt"></em> 
	                            <div class="hovtooltip">Enter the title that better explains your graph.</div>
	                        </span>
                        </label>                        
						<input id="graphTitle" maxlength="255" name="Enter Name" class="txsrch filterinput mr-10"  placeholder="Type Graph Name to Save …" v-model="graphName" type="text" />
					</div>
					<div v-if=" optionTypeTitle == 'Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph' " class="rec lblm" >
					    <label>Select Chart Type</label>
					    <div id="chartType" class="selectcont nwsl FL w-half">
					    	<vz-select v-model="chartType" :options="chartTypeList" empty-selection-text="Select Chart Type" label="name" track-by="name" value-type="value" @close=""  />
					    </div>
					    <span class="tooltip ml-10 dropTip nxt">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip visualizing">Choose the chart type for visualizing your data (e.g., bar, line, or stack view).</div>
					        <!--
					        <div class="hovtooltip selectChart">
                                Select the desired graph type from the dropdown menu to visualize the data.
                                <br/> <br/>
                                <span class="titleName">Stack Graph:</span> A stack-up graph displays cumulative data segments, showing how different parts contribute to the whole over time or categories. Ideal for visualizing component contributions.
                                <br/><br/>                                    
                                <span class="titleName">Line Graph:</span> A line graph connects data points with a continuous line, effectively illustrating trends and changes over time. Perfect for tracking progress and patterns.
                            </div> -->
                        </span>
                    </div> 
                   
					<div v-if=" (!_.isEmpty(boardListing) &&  optionTypeTitle === 'Cumulative Flow Diagram'  && _.isEmpty(collections)) || (!_.isEmpty(boardListing)  && !_.isEmpty(selectedGraph) && graphSelected && _.isEmpty(collections)) || (!_.isEmpty(boardListing) && ( optionTypeTitle === 'Flow Time Graph' || optionTypeTitle === 'Flow Efficiency Graph' || optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle === 'Flow Load Graph' || optionTypeTitle === 'Flow Distribution Graph'  ) && _.isEmpty(collections))" class="rec lblm">
						<label>Select Board</label>
						<div id="piBoard" class="selectcont nwsl FL w-half">
						    <vz-select v-model="selectedBoard" :options="boardListing" empty-selection-text="Select Program Board" label="title" track-by="_id" value-type="object" @close="" @select="getStatusOrIssueTypeDataOnTheBasiesOfSelection()"/>
						</div>
						<span class="tooltip ml-10 dropTip nxt">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                            </div>
                        </span>
					</div>
					<div v-if=" (!_.isEmpty(boardListing))" class="rec lblm" >
					    <label>Please select board items</label>
					    <div id="boardItemsFilter" class="selectcont nwsl FL w-half">
					    	<vz-select v-model="boardItemsFilter" :options="boardItemsFilterList" empty-selection-text="Select board items" label="name" track-by="id" value-type="value" @close="" @select="handleBoardFilterSelection()"  />
					    </div>
                        <span class="tooltip ml-10 dropTip nxt">
						        <em class="infotxt"></em> 
						        <div class="hovtooltip selectBordItems">
                                   Select items for the graph.
                                   <ul class="tooltipList ">
                                        <li>'ALL' includes both PI board-planned and backlog items.</li>
                                        <li>'Planned items' are scheduled in the PI board.</li>
                                        <li>'Unplanned items' remain in the backlog.</li>
                                   </ul>
                                </div>
                        </span>
                    </div> 
					
					<div v-if=" ( optionTypeTitle === 'Flow Efficiency Graph' || ( optionTypeTitle === 'Flow Velocity Graph' && pickedRadioType == 'status' ) || ( optionTypeTitle === 'Flow Distribution Graph' && pickedRadioType == 'status' )) && !_.isEmpty(selectedBoard) " class="rec lblm">
						<label v-if= " optionTypeTitle === 'Flow Efficiency Graph' ">Status for Active Time (Cycle Time)</label>
						<label v-if= " optionTypeTitle === 'Flow Velocity Graph' ">Status Criteria for Item Completion</label>
						<label v-if= " optionTypeTitle === 'Flow Distribution Graph' ">Distribution Status Criteria</label>
						<div  id="activeStatus" class="selectcont FL d w-half">
							<vz-select 
								:multiple="true" 
								label="title" 
								empty-selection-text="Select Status" 
								class="multi-filter"
								value-type="value" 
								v-model="selectedActiveStatus" 
								:options="statusList"
								:groups-enabled=true
								:show-select-all-on-group=false
								track-by="ids"
							/>
						</div>
						<span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Efficiency Graph' ">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                            </div>
                        </span>	
                        <span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Velocity Graph' ">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Choose a Program board from the dropdown list menu. The list displays the boards you have access to.
                            </div>
                        </span>
                        <span class="tooltip ml-10 dropTip nxt" v-if= " optionTypeTitle === 'Flow Distribution Graph' ">
					        <em class="infotxt"></em> 
					        <div class="hovtooltip">
                               Please select one or more Statuses to view items’ data on the graph.
                            </div>
                        </span>
					</div>		
			
					<div v-if=" optionTypeTitle === 'Flow Efficiency Graph' && !_.isEmpty(selectedBoard)" class="rec lblm">
                        <label>
                        	Lead Time Definition
                        	<span class="tooltip ml-10 dropTip rhttip">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    If the From Creation Date toggle is on, the start status dropdown will be disabled and the system counts total time from creation date of issue till selected End Status.
                                </div>
                            </span>	
                        </label>
                        <label>From Creation Date</label>
                        <div class="switch-button-class"  >
                            <input type="checkbox" id="creationCheckbox" @click="toggleCreationDateButton()"  :class="[checkExternalValue(toggleCreationDate) ? 'checked' : 'unchecked']">
                            <span><label for="creationCheckbox"></label></span>
                        </div>
				    </div>

					<div class="DFA FL w-full gap-2">				
                        <div v-if=" (!toggleCreationDate) && ( ( ( optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph' || optionTypeTitle === 'Flow Efficiency Graph') && graphSelected) || optionTypeTitle === 'Flow Time Graph' )  && !_.isEmpty(selectedBoard)" class="rec lblm">
                            <label>From Status Category</label>
                            <div class="DF">
                                <div id = "fromStatus" class="selectcont nwsl FL">
                                    <vz-select v-model="statusListing.startOfSelectedStatus" :options="categoryList" empty-selection-text="Select Start Status Category" label="title" track-by="ids" value-type="value" @close=""/>
                                </div>
                                <span class="tooltip ml-10 dropTip nxt">
                                   <em class="infotxt"></em> 
                                   <div class="hovtooltip fromStatus">
                                     Please select the initial status category to start tracking the time from this point. For example,
                                     <br/>       
                                     From status category is selected as “To Do” and To status category is selected as “Done”, it will start calculating time from “To Do” status category till “Done” status.
                                  </div>
                                </span>
                            </div>
                        </div>		
                        <div v-if="( ( ( optionTypeTitle === 'Time in Status' || optionTypeTitle === 'Lead Time Graph' || optionTypeTitle === 'Flow Efficiency Graph') && graphSelected) || optionTypeTitle === 'Flow Time Graph' )  && !_.isEmpty(selectedBoard) " class="rec lblm">
                            <label>To Status Category</label>
                            <div class="DF">
                                <div id="toStatus" class="selectcont nwsl FL">
                                    <vz-select v-model="statusListing.endOfSelectedStatus" :options="categoryList" empty-selection-text="Select End Status Category" label="title" track-by="ids" value-type="value" @close=""/>
                                </div>
                                <span class="tooltip ml-10 dropTip nxt">
                                    <em class="infotxt"></em> 
                                    <div class="hovtooltip toStatus">
                                        Please select the ending status category to track the time till this point. For example,
                                        <br/>
                                        From status category is selected as “To Do” and To status category is selected as “Done”, it will start calculating time from “To Do” status category till “Done” status.
                                    </div>
                                </span>
                            </div>
                        </div>
					</div>	
											
					<div v-if="((!_.isEmpty(issueTypesList)  &&  ((optionTypeTitle === 'Time in Status'  ) || optionTypeTitle === 'Lead Time Graph'  ) && graphSelected && !_.isEmpty(selectedBoard)    && !_.isEmpty(boardListing)  && _.isEmpty(selectedCollection)) || (( optionTypeTitle =='Item Completion by Teams' || optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph'  ) && !_.isEmpty(selectedBoard) )) " class="rec lblm">
						<label>Select Issue Type</label>
						<div id="issueType" class="selectcont FL d w-half">
							<vz-select 
								:multiple="true" 
								label="name" 
								empty-selection-text="Select Issue Type" 
								class="multi-filter"
								value-type="value" 
								v-model="selectedIssueType" 
								:options="issueTypesList"
								:groups-enabled=false
								:show-select-all-on-group=false
								track-by="id"
								@select="clearFilterIfEmptyIssueTypes"
							/>
						</div>	
						<span class="tooltip ml-10 dropTip nxt">
                            <em class="infotxt"></em> 
                            <div class="hovtooltip">
                                Choose one or more issue types from the dropdown menu. The widget will display items with the selected issue types from the chosen Program board.
                            </div>
                        </span>
					</div>		
					<div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram' " class="prow">
                        <label class="p-rel">Select Items <a v-if="!_.isEmpty(this.filterwithMeta)" href="javascript:void(0);" class="reset und" @click="resetFilter">Reset</a></label>
                        <div class="DF">
                            <div id="srch-cont" class="srchout prow">
                                <div id="searchTerm" class="sin">
                                    <div class="c1">
                                        <input 
                                            id="input-srch-ext" 
                                            class="srfld form-control" 
                                            type="text" 
                                            placeholder="To search, please type ID or Title..." 
                                            v-model="searchTerm" 
                                            @input="handleSearch"
                                        />
                                    </div>
                                    <div id="srch-lst-cont" class="link-over drop_box cssHidea"></div>
                                </div>
					    	</div>
                            <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em> 
                                <div class="hovtooltip">
                                    Search and select items of the chosen issue type to display their data exclusively on the graph.
                                </div>
                            </span>
                        </div>
                    </div>
                    <div v-if="!_.isEmpty(selectedIssueType) && optionTypeTitle !== 'Cumulative Flow Diagram' ">
                        <span  class="search_tags">
                            <ul id="search-text_tags">
                                <li v-for="(title, id) in filterwithMeta" :key="id" class="tooltip">
                                    {{ title.key }} 
                                    <i @click="onRemoveTag(id)" class="ti-close"></i>
                                    <div class="hovtooltip">{{ title.title }} </div>
                                </li>
                            </ul>
                        </span>
                    </div>
					<div  v-if=" ( optionTypeTitle === 'Flow Time Graph' || optionTypeTitle === 'Flow Efficiency Graph' || optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle == 'Flow Load Graph' || optionTypeTitle == 'Flow Distribution Graph' ) && !_.isEmpty(selectedBoard)" class="rec lblm">
						<label>Group by</label>
						<div id="groupBy" class="selectcont nwsl FL w-half">
							<vz-select  id="groupByBacklogDashboard" :multiple="false" label="title" empty-selection-text="Group By" class="multi-filter"
							track-by="id" value-type="value" :options="flowTimeLineGroupByList" :groups-enabled="true" v-model = "selectedFlowTimeLineGroupBy"
							group-values="items" group-label="title" 
							:show-select-all-on-group="false" 
							>	
							</vz-select>						
						</div>
						<span class="tooltip ml-10 dropTip nxt">
                          <em class="infotxt"></em> 
                          <div class="hovtooltip groupByTip">
                              Select a criterion to group the data displayed in the widget. For example, choosing "Teams" will show the team-wise data, helping you analyze performance or metrics based on the selected grouping.
                          </div>
                        </span>
					</div>		
										
	
                    <div v-if="(optionTypeTitle === 'Flow Time Graph' ||  optionTypeTitle === 'Flow Efficiency Graph' )" class="rec lblm">					
                        <label>X Axis</label>
                        <div class="DF">
                            <div id="xAxis" class="selectcont nwsl FL w-half">
                                <vz-select v-model="selectedXAxis" :options="xAxisListForFlowTime" empty-selection-text="X Axis" label="name" track-by="id" value-type="value" @close=""/>
                            </div>
                             <span class="tooltip  ml-10 dropTip nxt">
                                <em class="infotxt"></em>
                                <div class="hovtooltip xAxis">
                                    Choose the time frame for tracking progress. Options include sprints for viewing sprint-wise progress, days for daily updates and other intervals to see data over specific periods.
                                </div>
                            </span>
                        </div>  
                    </div>
					<div v-if="( optionTypeTitle === 'Flow Velocity Graph' || optionTypeTitle === 'Flow Load Graph' || optionTypeTitle === 'Flow Distribution Graph' || optionTypeTitle === 'Cumulative Flow Diagram' )" class="rec lblm">					
						<label>X Axis</label>
						<div class="DF">
                            <div id="xAxis" class="selectcont nwsl FL w-half">
                                <vz-select v-model="selectedXAxis" :options="xAxisList" empty-selection-text="X Axis" label="name" track-by="id" value-type="value" @close=""/>
                            </div>
                             <span class="tooltip ml-10 dropTip nxt">
                                <em class="infotxt"></em>
                                <div class="hovtooltip xAxis">
                                    Choose the time frame for tracking progress. Options include sprints for viewing sprint-wise progress, days for daily updates and other intervals to see data over specific periods.
                                </div>
                             </span>
					    </div>
					</div>
					
					<!-- Added impossible condition 1==2 to hide advance calculation for now as per business -->
					
                        <div v-if=" (optionTypeTitle === 'Lead Time Graph')   || ((optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle == 'Flow Velocity Graph' ) && selectedXAxis === 'days')||(!_.isEmpty(statusListing.endOfSelectedStatus) && selectedGraph === '3' && !_.isEmpty(statusListing.startOfSelectedStatus)) || ( ((pickedRadioType === 'status' && (!_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.statusListing.startOfSelectedStatus))) || (pickedRadioType === 'statusCategory' && (!_.isEmpty(this.statusListing.endOfSelectedStatus) && !_.isEmpty(this.statusListing.startOfSelectedStatus))) || pickedRadioType === 'creationDate') && selectedGraph === '3')" class="rec lblm w-half intrvl">
						<label>Select Interval</label>
						<div class="DF">
							<div class="selectcont nwsl FL"><vz-select v-model="selectedInterval" :options="intervalList" empty-selection-text="Select Interval" label="title" track-by="id" value-type="value" /></div>
							<span class="tooltip ml-10 dropTip nxt">
	                            <em class="infotxt"></em> 
	                            <div class="hovtooltip">
	                                Select number of days for time interval to view the number of items that completed their journey between the specified From-To statuses within the chosen duration.  For example, selecting an interval of 5 days will display the items that moved from the selected start status to the end status in a 5 days interval.
	                            </div>
	                        </span>
                        </div>
					</div>	
					<div v-if="(selectedInterval == 'custom' && selectedGraph == '3') || (selectedInterval == 'custom' && ( optionTypeTitle =='Flow Time Graph' || optionTypeTitle == 'Flow Efficiency Graph' || optionTypeTitle === 'Flow Velocity Graph'   ) ) " class="rec lblm">
						<label>Enter Interval (Days)</label>
						<div id= "custom-days-interval" class="rc z"><input type="text" v-model="customInterval" class="pi" placeholder="Enter Interval"></div>
					</div>	
				</div>	
				<div class="rec btn">
				    <button type="button" class="button FR rds4" @click="updateConfirmation()">Update</button> 
                </div>		
			</div>	
		</div>
		`,
    props: {
        dashboardSelected: null,
        selectedWidget: null,
    },
    data() {
        return {
            boardListing: [],
            selectedBoard: {},
            eventStartDate: '',
            eventEndDate: '',
            cfdResponceData: {},
            boardTeamListing: [],
            selectedBoardTeams: {},
            boardSprintListing: [],
            selectedBoardSprint: {},
            statusListing: {
                startOfStatusListing: [],
                startOfSelectedStatus: {},
                endOfStatusListing: [],
                endOfSelectedStatus: {},
            },
            selectedInterval: null,
            intervalList: [{id: '5', title: '5'}, {id: '10', title: '10'}, {id: '20', title: '20'}, {
                id: '40',
                title: '40'
            }, {id: '50', title: '50'}, {id: 'custom', title: 'custom'}],
            format: 'MMM dd yyyy',
            collections: [],
            selectedCollection: '',
            filterList: [],
            selectedFilter: "",
            selectedCondition: [],
            selectedStatusCategory: "0",
            filterSelected: false,
            graphsList: [{name: "Pie Chart", id: "1"}, {name: "Bar Chart", id: "2"}, {name: "Column Chart", id: '3'}],
            graphsListCFD: [{name: "Column Chart", id: '3'}, {
                name: "Basic Area Chart",
                id: '4'
            }, {name: "Stacked Area Chart", id: '5'}],
            graphsListFlowTime: [{name: "Column Chart", id: '3'}],
            filterTypes: [{name: "Status", id: "status"}, {name: "Teams", id: "teams"}],
            filterTypesCFD: [{name: "CFD", id: "cfd"}],
            selectedGraph: null,
            graphSelected: false,
            popupData: [],
            selectedFilters: [
                {
                    id: "status",
                    title: "Status",
                    values: [],
                    operator: 'IN',
                    disabled: true,
                    remove: true,
                    editable: true
                },
                {id: "teams", title: "Teams", values: [], operator: 'IN', disabled: true, remove: true, editable: true}
            ],
            pagination: {
                avoidPaginatorAtFirstLoad: true,
                pageSize: 50,
                pageIndex: 0,
                pageSizeOptions: [50, 100, 200],
                totalItemSize: 0
            },
            nextPageFirstItem: undefined,
            selectedTileItems: [],
            conditionsList: [],
            filteredData: [],
            graphName: '',
            widgets: [],
            selectedFilterType: null,
            collectionSelected: false,
            filterTypeSelected: false,
            optionsList: [],
            selectedAdditionalFilterCriteria: null,
            selectedAdditionalGraphOption: null,
            additionalFilterCriteriaList: [{name: "Status Category", id: "statusCategory"}],
            additionalGraphOptionList: [{name: "Column With Breakdown", id: "colBreakDown"}],
            statusList: [],
            optionTypeTitle: null,
            customInterval: null,
            radioOptions: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
            ],
            radioOptionsLeadTime: [
                {label: 'Status', value: 'status'},
                {label: 'Status Category', value: 'statusCategory'},
                {label: 'Creation date', value: 'creationDate'},
            ],
            pickedRadioType: 'statusCategory',
            categoryList: [],
            selectedIssueType: null,
            issueTypesList: [],
            additionalCriteriaForFlowTime: [{name: "Issue Type", id: "issueType"}],
            selectedAdditionalCriteriaForFlowTime: null,
            showloader: false,
            flowTimeLineGroupByList: [
                {name: "Teams", id: "teams"},
                {name: "Assignee", id: "assignee"}
            ],
            selectedFlowTimeLineGroupBy: null,
            xAxisList: [
                {name: "Sprints", id: "sprints"},
                {name: "Weekly", id: "weekly"},
                {name: "Monthly", id: "monthly"},
            ],
            selectedXAxis: null,
            sessionBoard: [],
            boardType: null,
            tfsProjects: [],
            jiraFieldsMap: {},
            selectedActiveStatus: [],
            radioOptionsDistributionTime: [
                {label: 'Percentage', value: 'percentage'},
                {label: 'Numbers', value: 'numbers'},
            ],
            pickedYAxisRadioType: 'numbers',
            toggleCreationDate:false,
            toggleAdvanceCriteria:false,
            toggleAdvanceCalculation:false,
            cfdCriteriaList:[{id:'default',title:'Select'},{id: 'teams', title: 'Teams'}],
            selectedCFDCriteria:null,
            criteriaContentList:[],
            selectedCriteriaContent:[],
            completedStatuses :null,
            activeStatuses:null,
            inProgressStatuses:null,
            toggleAvgLeadTime :false,
            toggleAvgCycleTime:false,
            toggleAvgWIPTime:false,
            toggleAvgArrivalTime:false,
            toggleAvgThroughputTime:false,
            teams:[],
            sprints:[],
            fromStatusList:[],
            toStatusList:[],
            activeStatusList:[],
            inProgressStatusList:[],
            issueType:null,
            groupByTitle :  "",
            xAxisListForFlowTime:[
                {name:"Sprints",id:"sprints"},
                {name:"Weekly",id:"weekly"},
                {name:"Monthly",id:"monthly"},
            ],
            chartType:'Line Graph',
            chartTypeName:'',
            chartTypeList:[{'id':'line',name:'Line Graph'},{'id':'column',name:'Stack Graph'},{'id':'column',name:'Bar Graph'}],
            boardItemsFilterList:[{'id':'all-items',name:'All Items'},{'id':'planned-items',name:'Planned Items'},{'id':'unplanned-items',name:'Unplanned Items'}],
            boardItemsFilter:'planned-items',
            searchTerm:'',
            selectedIssueType: '',  // Selected issue type
            selectedItems: [],      // Stores selected item IDs
            searchResults: [],       // Stores search results from the API
            filter:{},
            filterwithMeta:{},
        }
    },
    watch: {
        pickedRadioType(newValue, oldValue) {
            this.selectedCondition = [];
        },
    },
    created() {
        if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Cumulative Flow Diagram'){
            this.xAxisList.splice(1, 0, { name: "Days", id: "days" });
        }
        if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Load Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph'){
            this.xAxisList = [
                {name:"Sprints",id:"sprints"},
            ]
        }
    },
    mounted() {
        this.onloadComponent();
        this.graphName = this.selectedWidget.name;
        this.selectedGraph = this.selectedWidget.graphCriteria.graphType;
        this.selectedFilterType = this.selectedWidget.type;
        this.selectedAdditionalFilterCriteria = this.additionalFilterCriteriaList.find(item => this.selectedWidget.selectedAdditionalFilterCriteria === item.id);
        this.selectedAdditionalGraphOption = this.additionalGraphOptionList.find(item => this.selectedWidget.selectedAdditionalGraphOption === item.id);
        this.optionTypeTitle = this.selectedWidget.graphCriteria.optionTypeTitle;
        this.graphTypeTitle = this.selectedWidget.graphCriteria.graphTypeTitle;

    },

    computed: {
        checkExternalValue() {
            return function (value) {
                return value === true;
            };
        },

    },

    components: {
        vuejsDatepicker,
        VueAdsPagination: window["vue-ads-pagination"].default,
        VueAdsPageButton: window["vue-ads-pagination"].VueAdsPageButton,
    },

    methods: {
        getChartIdByName(name) {
            const chart = this.chartTypeList.find(item => item.name === name);
            return chart ? chart.id : null;
        },
        getChartNameById(id) {
            const chart = this.chartTypeList.find(item => item.id === id);
            return chart ? chart.name : null;
        },
        clearFilterIfEmptyIssueTypes(){
            if(_.isEmpty(this.selectedIssueType)){
                this.resetFilter();
            }
        },
        resetFilter() {
            this.filter = {};
            this.filterwithMeta={};
            this.selectedItems = [];
        },
        handleSearch() {
            this.validateItemSearchCriteria();
        },
        validateItemSearchCriteria() {
            let error = false;

            if (_.isEmpty(this.selectedBoard)) {
                $("#piBoard").addClass("red");
                error = true;
            } else {
                $("#piBoard").removeClass("red");
            }

            if (_.isEmpty(this.selectedIssueType)) {
                $("#issueType").addClass("red");
                error = true;
            } else {
                $("#issueType").removeClass("red");
            }

            if (_.isEmpty(this.searchTerm.trim())) {
                $("#srch-lst-cont").css("display", "none");
                error = true;
            }
            else {
                $("#srch-lst-cont").css("display", "block");
            }

            if (error) {
                // showTopMessage("Please enter something to search","warning", 2000);
            } else {
                let data = {
                    sessionBoardId: this.selectedBoard.activeSessionBoard,
                    issueTypes: this.selectedIssueType,
                    searchText: this.searchTerm
                };

                axios.post('/dashboard/searchItems/', data).then(response => {
                    let itemsList = response.data.itemsList;
                    this.searchResults = itemsList;
                    let $container = $("#srch-lst-cont");
                    $container.empty();
                    let htmlArray = [];

                    itemsList.forEach(itm => {
                        let key = itm.jiraKey ? itm.jiraKey : itm.tfsId;
                        let ui = '<span class="item-title"><a target="_blank">' + key + '</a> ' + itm.title + '</span>';
                        let selectedClass = this.selectedItems.indexOf(itm.id) > -1 ? 'SELECTED-ITEM' : '';

                        let backgroundColorStyle = this.selectedItems.indexOf(itm.id) > -1 ?
                            ' style="background-color: rgba(0, 0, 0, 0.05); color: #fff;"' : '';

                        let tickIcon = this.selectedItems.indexOf(itm.id) > -1 ?
                            '<span class="tick-icon">&#10003;</span>' : ''; // Checkmark

                        htmlArray.push('<li class="ITM ' + selectedClass + '"' + backgroundColorStyle +
                            ' data-id="' + itm.id + '" data-title="' + itm.title  + '" data-key="' + key + '" >' + ui + tickIcon + '</li>');
                    });


                    if (htmlArray.length === 0) {
                        htmlArray.push('<span class="NO-RESULT nofound DB mt-10">No search results</span>');
                    }

                    $container.html('<ul id="rslt">' + htmlArray.join('') + '</ul>');

                    this.$nextTick(() => {
                        document.querySelectorAll('#rslt li').forEach(item => {
                            item.addEventListener('click', (event) => {
                                this.toggleItemSelection(event.currentTarget.getAttribute('data-id'),event.currentTarget.getAttribute('data-title'),event.currentTarget.getAttribute('data-key'));
                            });
                        });

                        document.querySelectorAll('#rslt li .clickable-link').forEach(link => {
                            link.addEventListener('click', (event) => {
                                event.preventDefault();
                                event.stopPropagation();
                                let li = event.target.closest('li');
                                this.toggleItemSelection(li.getAttribute('data-id'),li.getAttribute('data-title'), li.getAttribute('data-key'));
                            });
                        });
                    });

                    console.log("Selected Items",this.selectedItems);
                    $container.show();
                }).catch(error => {
                    console.log("Error occurred", error);
                });
            }
        },

        toggleItemSelection(id, title, key) {
            let index = !_.isEmpty(this.selectedItems) ? this.selectedItems.indexOf(id) : -1;
            if (index === -1) {
                if (id !== null && id !== undefined) {
                    if (_.isEmpty(this.filter) || _.isEmpty(this.filterwithMeta)) {
                        this.filter = {};
                        this.filterwithMeta={};
                    }
                    Vue.set(this.filter, id, title);
                    Vue.set(this.filterwithMeta, id, { title: title, key: key });
                } else {
                    console.log("Invalid id, item not inserted:", id);
                }
                this.selectedItems.push(id);
            } else {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
            this.updateSelectedStyles(id);
        },

        onRemoveTag: function(id) {
            let index = this.selectedItems?.findIndex(itemIds => itemIds === id);

            if (index !== -1) {
                this.selectedItems.splice(index, 1);
                if (id in this.filter) {
                    Vue.delete(this.filter, id);
                    Vue.delete(this.filterwithMeta, id);
                }
            }
        },

        updateSelectedStyles(jiraId) {
            const elements = document.querySelectorAll(`[data-id="${jiraId}"]`);
            elements.forEach(el => {
                if (this.selectedItems.indexOf(jiraId) > -1) {
                    el.style.backgroundColor = 'rgba(0, 0, 0, 0.05)';
                    el.style.color = '#fff';

                    if (!el.querySelector('.tick-icon')) {
                        const tickIcon = document.createElement('span');
                        tickIcon.className = 'tick-icon';
                        tickIcon.innerHTML = '&#10003;';
                        //tickIcon.style.marginLeft = '8px';
                        el.appendChild(tickIcon);
                    }
                } else {
                    el.style.backgroundColor = '';
                    el.style.color = '';

                    const tickIcon = el.querySelector('.tick-icon');
                    if (tickIcon) {
                        el.removeChild(tickIcon);
                    }
                }
            });
        },

        isNumber:function(value) {
            return /^-?\d+$/.test(value);
        },

        checkCriteriaBeforeUpdate: function () {
            if(_.isEmpty(this.selectedIssueType)){
                this.filter = {};
                this.filterwithMeta = {};
                this.selectedItems = {};
            }
             if(this.optionTypeTitle === 'Flow Efficiency Graph'){
                if(!_.isEmpty(this.selectedBoard) && !_.isEmpty(this.boardItemsFilter) && !_.isEmpty(this.selectedXAxis) &&  !_.isEmpty(this.selectedActiveStatus)   && !_.isEmpty(this.selectedFlowTimeLineGroupBy)  && !_.isEmpty(this.graphName)  && (( this.toggleCreationDate == false && !_.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) || ( this.toggleCreationDate == true && _.isEmpty(this.statusListing.startOfSelectedStatus) && !_.isEmpty(this.statusListing.endOfSelectedStatus)) ) ){
                    return true;
                }else{
                    if(_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedActiveStatus)){
                        $("#activeStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.graphName)){
                        $("#graphTitle").addClass("red");
                    }
                    if (!_.isEmpty(this.graphName)) {
                        if (this.graphName.trim() === "") {
                            $("#graphTitle").addClass("red");
                        } else {
                            $("#graphTitle").removeClass("red");
                        }
                    }

                    if(_.isEmpty(this.selectedBoard)){
                        $("#piBoard").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedBoard)){
                        $("#piBoard").removeClass("red");
                    }
                    if(( this.toggleCreationDate == false
                        && _.isEmpty(this.statusListing.startOfSelectedStatus)
                    )){
                        $("#fromStatus").addClass("red");
                    }
                    if(( this.toggleCreationDate == false
                        && !_.isEmpty(this.statusListing.startOfSelectedStatus)
                    )){
                        $("#fromStatus").removeClass("red");
                    }
                    if( _.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").addClass("red");
                    }
                    if( !_.isEmpty(this.statusListing.endOfSelectedStatus)){
                        $("#toStatus").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedFlowTimeLineGroupBy)){
                        $("#groupBy").removeClass("red");
                    }
                    if(_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").addClass("red");
                    }
                    if(!_.isEmpty(this.selectedXAxis)){
                        $("#xAxis").removeClass("red");
                    }
                    if(_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").addClass("red");
                    }
                    if(!_.isEmpty(this.boardItemsFilter)){
                        $("#boardItemsFilter").removeClass("red");
                    }
                    return false;
                }
            }
            else
            if(!_.isEmpty(this.selectedCollection)&& !_.isEmpty(this.selectedFilter) && !_.isEmpty(this.selectedCondition)&& !_.isEmpty(this.graphName)){
                return true;
            }
            else{
                return false;
            }
        },
        handleRadioChange(value) {
            this.statusListing.startOfSelectedStatus = "";
            this.statusListing.endOfSelectedStatus = "";
        },
        getTitleById:function(id) {
            for (const group of this.flowTimeLineGroupByList) {
                for (const item of group.items) {
                    if (item.id === id) {
                        return item.title;
                    }
                }
            }
            return null; // Return null if no match found
        },
        getCFDAdvanceCriteria:function(boardId){
            let _this = this;
            axios.get('/dashboard/get-cfd-advance-criteria/'+ boardId)
                .then(response => {
                    try {
                        this.teams = response.data.teams;
                        this.sprints = response.data.sprints;
                        if(this.selectedCFDCriteria == 'teams')
                        { this.criteriaContentList =  this.teams; }
                        else if(this.selectedCFDCriteria == 'sprints'){
                            this.criteriaContentList =  this.sprints;
                        }
                    }
                    catch (e){
                        console.error(e);
                    }
                });
        },
        handleAdvanceSelection:function(){
            if(this.selectedCFDCriteria == 'teams')
            { this.criteriaContentList =  this.teams; }
            else if(this.selectedCFDCriteria == 'sprints'){
                this.criteriaContentList =  this.sprints;
            }else{
                this.selectedCriteriaContent = [];
            }
        },
        toggleAvgLeadTimeCal() {
            this.toggleAvgLeadTime = !this.toggleAvgLeadTime;
        },
        toggleAvgCycleTimeCal(){
            this.toggleAvgCycleTime = !this.toggleAvgCycleTime;
        },
        toggleAvgWIPTimeCal(){
            this.toggleAvgWIPTime = !this.toggleAvgWIPTime;
        },
        toggleAvgArrivalTimeCal(){
            this.toggleAvgArrivalTime = !this.toggleAvgArrivalTime;
        },
        toggleAvgThroughputTimeCal(){
            this.toggleAvgThroughputTime = !this.toggleAvgThroughputTime;
        },


        toggleAdvanceCriteriaAccordian(){
            this.toggleAdvanceCriteria = !this.toggleAdvanceCriteria;
        },
        toggleAdvanceCalculationAccordian(){
            this.toggleAdvanceCalculation = !this.toggleAdvanceCalculation;
            // this.toggleAdvanceCriteria = !this.toggleAdvanceCriteria;
        },
        toggleCreationDateButton() {
            this.toggleCreationDate = !this.toggleCreationDate;
            this.statusListing.endOfSelectedStatus = {};
            this.statusListing.startOfSelectedStatus = {};
        },
        recreateSelectedBoardSprint: function (backendIds, sprints) {
            return backendIds.map(id => sprints.find(sprint => sprint._id === id));
        },
        onloadComponent: function () {
            this.showloader = true;
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            if (this.selectedWidget.type == 'cfd') {
                axios.post("/dashboard/fetch-all-release-trains", data)
                    .then(response => {
                        if (response.data) {
                            _this.collections = response.data.releaseTrains;
                            if (!_.isEmpty(_this.collections)) {
                                _this.selectedCollection = _this.collections.find(item => _this.selectedWidget.releaseTrainId == item.id);
                            }
                            if (_this.selectedCollection) {
                                _this.collectionSelected = true;
                                _this.graphSelected = true;
                                _this.filterList = [];
                                if (!_.isEmpty(_this.selectedFilterType)) {
                                    this.filterTypeSelected = true;
                                    let _this = this;
                                    data = {
                                        "releaseTrainID": _this.selectedCollection.id,
                                        "filterType": _this.selectedFilterType
                                    };
                                    axios.post("/dashboard/fetch-release-train-filters", data)
                                        .then(response => {
                                            _this.filterList = response.data.releaseTrainFilters;
                                            _this.filterSelected = false;
                                            _this.selectedFilter = _this.selectedWidget.criteria;
                                            if (!_.isEmpty(_this.selectedFilter)) {
                                                _this.handleFilterSelection(_this.selectedFilterType);
                                            }
                                        }).catch(error => {
                                        console.error(error);
                                    });
                                }
                            }
                        }
                    }).catch(error => {
                    console.error(error);
                });
            }
            else {
                this.chartType = this.selectedWidget.graphCriteria.chartTypeName;
                this.graphName = this.selectedWidget.name;
                this.selectedGraph = this.selectedWidget.graphCriteria.graphType;
                this.graphSelected = true;
                this.selectedIssueType = this.selectedWidget.graphCriteria.selectedIssueType;
                this.filter = this.selectedWidget?.graphCriteria?.itemTags;
                this.filterwithMeta = this.selectedWidget?.graphCriteria?.itemTagsMetaMap;
                if(!_.isEmpty(this.filterwithMeta)){
                    this.selectedItems = Object.keys(this.filterwithMeta);
                }
                this.boardItemsFilter = this.selectedWidget.graphCriteria.boardItemsFilter;
                if (this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph') {
                    this.selectedActiveStatus = this.selectedWidget.graphCriteria.activeTimeStatuses;
                    this.pickedYAxisRadioType = this.selectedWidget.graphCriteria.yAxis;
                    this.selectedXAxis = this.selectedWidget.graphCriteria.intervals;
                }
                if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Cumulative Flow Diagram') {
                    if(this.selectedWidget.graphCriteria.intervals == 'days'){
                        this.eventEndDate = this.selectedWidget.graphCriteria.startDate;
                        this.eventStartDate = this.selectedWidget.graphCriteria.endDate;
                    }
                    this.selectedXAxis = this.selectedWidget.graphCriteria.intervals;
                    this.toggleAvgLeadTime = this.selectedWidget.graphCriteria.toggleAvgLeadTime;
                    this.toggleAvgCycleTime = this.selectedWidget.graphCriteria.toggleAvgCycleTime;
                    this.toggleAvgWIPTime = this.selectedWidget.graphCriteria.toggleAvgWIPTime;
                    this.toggleAvgArrivalTime = this.selectedWidget.graphCriteria.toggleAvgArrivalTime;
                    this.toggleAvgThroughputTime = this.selectedWidget.graphCriteria.toggleAvgThroughputTime;
                    this.toggleAdvanceCalculation = this.selectedWidget.graphCriteria.toggleAdvanceCalculation;
                    this.toggleAdvanceCriteria = this.selectedWidget.graphCriteria.toggleAdvanceCriteria;
                    this.avgCycleTime = this.selectedWidget.graphCriteria.avgCycleTime;
                    this.avgLeadTime = this.selectedWidget.graphCriteria.avgLeadTime;
                    this.avgArrivalTime = this.selectedWidget.graphCriteria.avgArrivalTime;
                    this.avgWIPTime = this.selectedWidget.graphCriteria.avgWIPTime;
                    this.avgThroughputTime = this.selectedWidget.graphCriteria.avgThroughputTime;
                    this.activeStatuses = this.selectedWidget.graphCriteria.selectedActiveStatus;
                    this.inProgressStatuses = this.selectedWidget.graphCriteria.selectedInProgressStatus;
                    this.completedStatuses = this.selectedWidget.graphCriteria.selectedCompletedStatus;
                    this.selectedCFDCriteria = this.selectedWidget.graphCriteria.advanceCriteria;
                    this.selectedCriteriaContent= this.selectedWidget.graphCriteria.selectedAdvanceCriteria;
                    this.pickedRadioType = this.selectedWidget.graphCriteria.radioButtonSelection;
                    this.selectedIssueType = this.selectedWidget.graphCriteria.selectedIssueType;
                }
                this.getAllAccessableBoardsListingInitial();
                if(this.selectedWidget.graphCriteria.optionTypeTitle == 'Time in Status' || this.selectedWidget.graphCriteria.optionTypeTitle == 'Lead Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Efficiency Graph' || this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Velocity Graph'  || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph' || this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Load Graph'){

                    if( this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Load Graph'){
                        this.activeStatusList = this.selectedWidget.graphCriteria.activeStatuses;
                        this.inProgressStatusList = this.selectedWidget.graphCriteria.selectedInProgressStatus;
                    }
                    else if(this.selectedWidget.graphCriteria.optionTypeTitle !== 'Flow Efficiency Graph' && this.selectedWidget.graphCriteria.optionTypeTitle !== 'Flow Velocity Graph' ){
                        if(this.selectedWidget.graphCriteria.radioButtonSelection !== "statusCategory"){
                            this.statusListing.startOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[0];
                            this.statusListing.endOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[1];
                        }
                    }
                    if(this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Efficiency Graph'){
                        this.selectedActiveStatus = this.selectedWidget.graphCriteria.activeTimeStatuses;
                        this.toggleCreationDate = this.selectedWidget.graphCriteria.toggleCreationDate;
                        if(this.toggleCreationDate){
                            this.statusListing.endOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[0];
                        }
                        else{
                            this.statusListing.startOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[0];
                            this.statusListing.endOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[1];
                        }
                    }
                    if(this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Velocity Graph'){
                        this.selectedActiveStatus = this.selectedWidget.graphCriteria.selectedItems;
                        this.selectedIssueType = this.selectedWidget.graphCriteria.selectedIssueType;
                    }
                    if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph'){
                        this.selectedActiveStatus = this.selectedWidget.graphCriteria.selectedItems[0];
                        this.pickedYAxisRadioType = this.selectedWidget.graphCriteria.yAxis;
                    }
                    if(!_.isEmpty(this.selectedWidget.graphCriteria.intervals)){
                        if(this.selectedWidget.graphCriteria.intervals == 'sprints' || this.selectedWidget.graphCriteria.intervals == 'monthly' || this.selectedWidget.graphCriteria.intervals == 'weekly' ){
                            this.selectedXAxis = this.selectedWidget.graphCriteria.intervals;
                        }
                        else if (this.intervalList.find(item=> item.id === this.selectedWidget.graphCriteria.intervals)) {
                            this.selectedXAxis = 'days';
                            this.selectedInterval = this.selectedWidget.graphCriteria.intervals;
                        }
                        else {
                            this.selectedXAxis = 'days';
                            if(this.selectedWidget.graphCriteria.optionTypeTitle !== 'Flow Load Graph'){
                                this.selectedInterval = 'custom';
                                this.customInterval = this.selectedWidget.graphCriteria.intervals;
                            }
                        }
                    }
                    if (!_.isEmpty(this.selectedWidget.graphCriteria.groupBy)) {
                        this.selectedFlowTimeLineGroupBy = this.selectedWidget.graphCriteria.groupBy;
                    }
                    this.pickedRadioType = this.selectedWidget.graphCriteria.radioButtonSelection;
                    if (this.selectedWidget.graphCriteria.optionTypeTitle === 'Lead Time Graph' && this.selectedWidget.graphCriteria.radioButtonSelection === 'creationDate') {
                        this.statusListing.endOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[0];
                    }
                    else if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Lead Time Graph' && this.selectedWidget.graphCriteria.radioButtonSelection !== 'creationDate'){
                        this.statusListing.startOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[0];
                        this.statusListing.endOfSelectedStatus=this.selectedWidget.graphCriteria.selectedItems[1];
                    }
                }
                if(!_.isEmpty(this.flowTimeLineGroupByList)){
                    this.handleBoardFilterSelection();
                }
            }
        },

        getAllAccessableBoardsListing: function () {
            let _this = this;
            axios.get('/dashboard/get-board-listing/')
                .then(response => {
                    try {
                        if (response.data) {
                            _this.boardListing = response.data;
                            _this.selectedBoard = _this.boardListing.find(item => this.selectedWidget.graphCriteria.boardId == item._id);
                            if(_.isEmpty( _this.selectedBoard) && _.isEmpty(_this.boardListing)){
                                showTopMessage("No PI Board is present, Please create a new PI Board and Select that to continue",'warning',5000);
                                this.showloader =false;
                                return;
                            }
                            else if(_.isEmpty( _this.selectedBoard)){
                                showTopMessage("PI Board doesn't exist anymore, Please select a different board",'warning',3000);
                                this.showloader =false;
                                return;
                            }
                            _this.getStatusOrIssueTypeDataOnTheBasiesOfSelection();
                            _this.selectedCondition = this.selectedWidget.graphCriteria.selectedItems;
                            const timestamp = _this.selectedWidget.graphCriteria.startDate;
                            const dateData = new Date(timestamp);
                            _this.eventStartDate = dateData;
                            const timestamp2 = _this.selectedWidget.graphCriteria.endDate;
                            const dateData2 = new Date(timestamp2);
                            _this.eventEndDate = dateData2;
                        }
                    } catch (e) {
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
            });
        },
        getAllAccessableBoardsListingInitial: function () {
            let _this = this;
            axios.get('/dashboard/get-board-listing/')
                .then(response => {
                    try {
                        if (response.data) {
                            _this.boardListing = response.data;
                            _this.selectedBoard = _this.boardListing.find(item => this.selectedWidget.graphCriteria.boardId == item._id);
                            if(_.isEmpty( _this.selectedBoard) && _.isEmpty(_this.boardListing)){
                                showTopMessage("No PI Board is present, Please create a new PI Board and Select that to continue",'warning',5000);
                                this.showloader =false;
                                return;
                            }
                            else if(_.isEmpty( _this.selectedBoard)){
                                showTopMessage("PI Board doesn't exist anymore, Please select a different board",'warning',3000);
                                this.showloader =false;
                                return;
                            }
                            _this.getStatusOrIssueTypeDataOnTheBasisOfSelectionInitial();
                            _this.selectedCondition = this.selectedWidget.graphCriteria.selectedItems;
                            const timestamp = _this.selectedWidget.graphCriteria.startDate;
                            const dateData = new Date(timestamp);
                            _this.eventStartDate = dateData;
                            const timestamp2 = _this.selectedWidget.graphCriteria.endDate;
                            const dateData2 = new Date(timestamp2);
                            _this.eventEndDate = dateData2;
                            if (!_.isEmpty(this.selectedBoard)) {
                                this.handleAdditionalCriteriaForFlowTimeInitial()
                            }
                        }
                    } catch (e) {
                        console.log(e);
                        showTopMessage("Some error occurred while fetching boards",'warning',2000);
                        this.showloader =false;
                    }

                }).catch(error => {
                console.log(error);
            });
        },

        populateTeamsAndSprintData: function (response, requestBody) {

            if (requestBody['teams']) {

                let teamSequence = response['teamSequence'];
                let teamsGroupBy = _.groupBy(response['teams'], '_id');

                for (let teamId of teamSequence) {

                    this.boardTeamListing.push(teamsGroupBy[teamId][0]);
                }
            }

            if (requestBody['sprints']) {

                this.boardSprintListing = response["sprints"];
            }
            if (!_.isEmpty(this.selectedWidget.graphCriteria.optionalSprints) && !_.isEmpty(this.boardSprintListing)) {
                this.selectedBoardSprint = this.recreateSelectedBoardSprint(this.selectedWidget.graphCriteria.optionalSprints, this.boardSprintListing);
            } else if (!_.isEmpty(this.selectedWidget.graphCriteria.optionalTeams) && !_.isEmpty(this.boardTeamListing)) {
                this.selectedBoardTeams = this.recreateSelectedBoardSprint(this.selectedWidget.graphCriteria.optionalTeams, this.boardTeamListing);
            }
        },

        getSelectedBoardTeamAndSprintList: function (teamFlag, sprintFlag) {

            let requestBody = {};

            if (teamFlag) {
                requestBody['teams'] = 'teams';
            }

            if (sprintFlag) {
                requestBody['sprints'] = 'sprints';
            }

            let _this = this;
            let boardId = this.selectedBoard.activeSessionBoard;
            axios.post('/dashboard/get-board-teams-sprints/' + boardId, requestBody)
                .then(response => {

                    try {
                        if (response.data) {
                            this.populateTeamsAndSprintData(response.data, requestBody);
                        }
                    } catch (e) {
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
            });
        },
        getAllAccessableBoardStartEndStatusListing: function (boardId) {
            let _this = this;
            axios.get('/dashboard/get-status-listing/' + boardId)
                .then(response => {
                    try {
                        let groupedItems = {};
                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }
                        let resultList = Object.values(groupedItems);
                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            _this.statusListing.endOfStatusListing = resultList;
                            let categoryMap = new Map();
                            let statuscategoryMap = new Map();
                            for (let i = 0; i < _this.statusListing.startOfStatusListing.length; i++) {
                                let category = _this.statusListing.startOfStatusListing[i].category;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                if (!statuscategoryMap.has(category)) {
                                    statuscategoryMap.set(category, []);
                                }
                                let condition = {
                                    "ids": _this.statusListing.startOfStatusListing[i].ids,
                                    "title": _this.statusListing.startOfStatusListing[i].title
                                }
                                categoryMap.get(category).push(condition);
                                let conditionStatusCategory = [_this.statusListing.startOfStatusListing[i].ids]
                                statuscategoryMap.get(category).push(conditionStatusCategory);
                            }
                            let sortedEntries = Array.from(categoryMap.entries());
                            let sortedEntriesForStatusCategory = Array.from(statuscategoryMap.entries());
                            const order = ["ToDo", "InProgress", "Done", "Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            sortedEntriesForStatusCategory.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            let transformedEntriesForStatusCategory = sortedEntriesForStatusCategory.map(entry => {
                                let category = entry[0];
                                let nestedArrays = entry[1];
                                let uniqueIdsSet = new Set();
                                for (let i = 0; i < nestedArrays.length; i++) {
                                    let nestedArray = nestedArrays[i];
                                    for (let j = 0; j < nestedArray[0].length; j++) {
                                        uniqueIdsSet.add(nestedArray[0][j]);
                                    }
                                }
                                let uniqueIdsArray = Array.from(uniqueIdsSet);

                                return {key: category, value: {ids: uniqueIdsArray}};
                            });
                            categoryMap = new Map(sortedEntries);
                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });
                            let statusCategoryList = [];
                            transformedEntriesForStatusCategory.forEach((items) => {
                                statusCategoryList.push({
                                    title: items.key,
                                    ids: items.value.ids,
                                });
                            });
                            _this.statusList = categoryList;
                            _this.categoryList = statusCategoryList;

                            if (this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Efficiency Graph') {
                                const commaSeparatedIDs = this.selectedActiveStatus.split(',');
                                const statusTitles = new Set();
                                _this.statusList.forEach(statusObj => {
                                    statusObj.items.forEach(item => {
                                        if (item.ids.some(id => commaSeparatedIDs.includes(id))) {
                                            statusTitles.add(statusObj.title);
                                        }
                                    });
                                });
                                let statusMap = {};
                                this.statusList.forEach(function (statusObj) {
                                    var title = statusObj.title;
                                    statusMap[title] = statusObj.items.reduce(function (acc, item) {
                                        if (item.ids.some(function (id) {
                                            return commaSeparatedIDs.includes(id);
                                        })) {
                                            var idsString = item.ids.join(',');
                                            acc.push(idsString);
                                        }
                                        return acc;
                                    }, []);
                                });
                                this.selectedActiveStatus = [];
                                if (this.selectedWidget.graphCriteria.radioButtonSelection !== "statusCategory") {
                                    let globalCombinedIds = new Set();
                                    for (var key in statusMap) {
                                        let combinedIds = new Set();
                                        if (statusMap.hasOwnProperty(key) && statusMap[key].length > 0) {
                                            for (var i = 0; i < statusMap[key].length; i++) {
                                                combinedIds.add(statusMap[key][i]);
                                                globalCombinedIds.add(statusMap[key][i]);
                                            }
                                            this.selectedActiveStatus.push(Array.from(combinedIds).join(','));
                                        }
                                    }

                                    this.selectedActiveStatus = this.selectedActiveStatus.map(statusString => {
                                        let ids = statusString.split(',');
                                        let uniqueIds = Array.from(new Set(ids));
                                        return uniqueIds.join(',');
                                    });
                                }
                                else{
                                    for (var key in statusMap) {
                                        if (statusMap.hasOwnProperty(key) && statusMap[key].length > 0) {
                                            for (var i = 0; i < statusMap[key].length; i++) {
                                                this.selectedActiveStatus.push(statusMap[key][i]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } catch (e) {
                        //   showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                        this.showloader = false;
                        console.log(e);
                    }
                }).catch(error => {
                // showTopMessage("Some error has occurred while fetching board statuses",'warning','4000');
                this.showloader = false;
                console.log(error);
            });
        },


        getStatusOrIssueTypeDataOnTheBasiesOfSelection : function(){
            this.selectedItems = [];
            this.filter = {};
            if(this.selectedWidget.graphCriteria.optionTypeTitle == "Cumulative Flow Diagram"){

                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);

                // if(this.graphType.title == "For items in a Team in PI"){
                //
                //     this.getSelectedBoardTeamAndSprintList(true);
                //
                // }else if(this.graphType.title == "For items in a Sprint in PI"){
                //
                //     this.getSelectedBoardTeamAndSprintList(null,true);
                // }
                this.getCFDAdvanceCriteria(this.selectedBoard._id);
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
                this.getCFDAdvanceCriteria(this.selectedBoard._id);
                this.handleAdvanceSelection();
            }
            else if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Time in Status' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Lead Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Efficiency Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Velocity Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Load Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph' ){
                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
                if( this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Efficiency Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Velocity Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Load Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph'){
                    {
                        if (this.selectedBoard.activeSessionBoard) {
                            this.getIssueTypes(this.selectedBoard.activeSessionBoard);
                        }
                    }
                }
            }
        },
        getStatusOrIssueTypeDataOnTheBasisOfSelectionInitial : function(){
            if(this.selectedWidget.graphCriteria.optionTypeTitle == "Cumulative Flow Diagram"){

                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                // this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
                this.getCFDAdvanceCriteria(this.selectedBoard._id);
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
                this.getCFDAdvanceCriteria(this.selectedBoard._id);
                this.handleAdvanceSelection();
            }
            else if(this.selectedWidget.graphCriteria.optionTypeTitle === 'Time in Status' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Lead Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Efficiency Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Velocity Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Load Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph' ){
                this.getAllAccessableBoardStartEndStatusListing(this.selectedBoard._id);
                //    this.getPIStartEndDates(this.selectedBoard.activeSessionBoard);
                if( this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Time Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Efficiency Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Velocity Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Load Graph' || this.selectedWidget.graphCriteria.optionTypeTitle === 'Flow Distribution Graph'){
                    {
                        if (this.selectedBoard.activeSessionBoard) {
                            this.getIssueTypes(this.selectedBoard.activeSessionBoard);
                        }
                    }
                }
            }
        },
        getPIStartEndDates: function(boardId) {
            let _this = this;
            axios.get('/dashboard/get-start-end-date/' + boardId)
                .then(response => {
                    try {
                        if (!_.isEmpty(response.data)) {
                            _this.eventStartDate = new Date(response.data.startDate);
                            _this.eventEndDate = new Date(response.data.endDate);
                        } else {
                            let currentDate = new Date();
                            _this.eventStartDate = currentDate;
                            _this.eventEndDate = currentDate;
                        }
                    } catch (e) {
                        console.log(e);
                    }
                })
                .catch(error => {
                    console.log(error);
                });
        },


        getAllAccessableBoardStatusListing: function (boardId) {
            let _this = this;
            axios.get('/dashboard/get-status-listing/' + boardId)
                .then(response => {
                    try {
                        let groupedItems = {};

                        for (let status of response.data) {
                            if (!groupedItems[status.title]) {
                                groupedItems[status.title] = {
                                    title: status.title,
                                    ids: [],
                                    category: status.category,
                                };
                            }
                            groupedItems[status.title].ids.push(status.id);
                        }

                        let resultList = Object.values(groupedItems);

                        if (resultList) {
                            _this.statusListing.startOfStatusListing = resultList;
                            let categoryMap = new Map();
                            for (let i = 0; i < _this.statusListing.startOfStatusListing.length; i++) {
                                let category = _this.statusListing.startOfStatusListing[i].category;
                                if (!categoryMap.has(category)) {
                                    categoryMap.set(category, []);
                                }
                                let condition = {
                                    "ids": _this.statusListing.startOfStatusListing[i].ids,
                                    "title": _this.statusListing.startOfStatusListing[i].title
                                }
                                categoryMap.get(category).push(condition);
                            }
                            let sortedEntries = Array.from(categoryMap.entries());
                            const order = ["ToDo", "InProgress", "Done", "Misc"];
                            sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                            categoryMap = new Map(sortedEntries);
                            let categoryList = [];
                            categoryMap.forEach((items, category) => {
                                categoryList.push({
                                    title: category,
                                    items: items
                                });
                            });
                            _this.statusList = categoryList;
                        }
                    } catch (e) {
                        console.log(e);
                    }

                }).catch(error => {
                console.log(error);
            });
        },

        updateConfirmation: function () {
            if(_.isEmpty(this.boardListing)){
                showTopMessage('Previously selected board not found, You need to create a new board and select it to update','warning',7000);
            }
            else if(!this.checkCriteriaBeforeUpdate()){
                showTopMessage("Please provide all the information for update","warning", 3000);
            }
            else{
                askFromSweetAlertWrapper(
                    "Are you sure you want to save the changes?",
                    [() => this.updateGraphData(), null],
                    [takeNoAction]
                );
            }
        },

        updateGraphData: function () {
            var conditionsList = this.conditionsList;
            var selectedItems = this.selectedCondition;
            var selectedGraph = this.selectedGraph;
            var graphName = this.graphName;
             if (this.selectedWidget.graphCriteria.optionTypeTitle == 'Flow Efficiency Graph') {
                let selectedBoardTitle = this.boardListing.find(item => item._id == this.selectedBoard._id).title;
                let selectedToStatus = null;
                let selectedFromStatus = null;
                if (this.toggleCreationDate == false) {
                    // const startIds = this.statusListing.startOfSelectedStatus.split(',');
                    // const endIds = this.statusListing.endOfSelectedStatus.split(',');
                    // for (const status of this.statusList) {
                    //     for (const item of status.items) {
                    //         if (startIds.some(id => item.ids.includes(id))) {
                    //             selectedToStatus = status.title;
                    //         }
                    //         if (endIds.some(id => item.ids.includes(id))) {
                    //             selectedFromStatus = status.title;
                    //         }
                    //     }
                    // }
                    if(this.categoryList.find(item => item.ids == this.statusListing.startOfSelectedStatus).title){
                        selectedToStatus=this.categoryList.find(item => item.ids == this.statusListing.startOfSelectedStatus).title;
                    }
                    if(this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title){
                        selectedFromStatus=this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title;
                    }
                } else if(this.toggleCreationDate){
                    // const endIds = this.statusListing.endOfSelectedStatus.split(',');
                    // for (const status of this.statusList) {
                    //     for (const item of status.items) {
                    //         if (endIds.some(id => item.ids.includes(id))) {
                    //             selectedFromStatus = item.title;
                    //         }
                    //     }
                    // }
                    if(this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title){
                        selectedFromStatus=this.categoryList.find(item => item.ids == this.statusListing.endOfSelectedStatus).title;
                    }
                }

                let joinedActiveStatuses = this.selectedActiveStatus.join(',');
                let requestBody = {
                    widgetId: this.selectedWidget.id,
                    selectedBoard: this.selectedBoard,
                    sessionBoardId: this.selectedBoard.activeSessionBoard,
                    tenant: this.selectedBoard.tenant,
                    selectedGraph: this.selectedGraph,
                    graphName: this.graphName,
                    selectedFilterType: this.selectedFilterType,
                    statusListing: this.statusListing,
                    selectedInterval: this.selectedInterval == 'custom' ? this.customInterval : this.selectedInterval,
                    optionTypeTitle: this.selectedWidget.graphCriteria.optionTypeTitle,
                    graphTypeTitle: this.selectedWidget.graphCriteria.graphTypeTitle,
                    radioButtonSelection: this.pickedRadioType,
                    selectedIssueType: _.isEmpty(this.selectedIssueType) ? [] : this.selectedIssueType,
                    activeTimeStatus: joinedActiveStatuses,
                    toggleCreationDate: this.toggleCreationDate,
                    groupBy: this.selectedFlowTimeLineGroupBy,
                    groupByTitle : this.getTitleById(this.selectedFlowTimeLineGroupBy),
                    xAxis: this.selectedXAxis,
                    selectedBoardTitle: selectedBoardTitle,
                    selectedToStatus: selectedToStatus,
                    selectedFromStatus: selectedFromStatus,
                    selectedIssueTypeTitleList: this.issueTypesList?.filter(item => this.selectedIssueType?.includes(item.id)).map(item => item.name),
                    chartType: this.getChartIdByName(this.chartType),
                    chartTypeName: this.chartType,
                    boardItemsFilter : this.boardItemsFilter,
                    itemtags : this.filter,
                    itemTagsMeta: this.filterwithMeta,
                }
                this.$emit('updateWidget', requestBody);
            }

            else {
                var dataofGraph = {
                    "graphType": selectedGraph,
                    "itemList": conditionsList,
                    "selectedItems": selectedItems,
                    "hierarchyLevel": "" + this.selectedFilter.level
                };
                const widgetData = {
                    name: graphName,
                    id: this.selectedWidget.id,
                    graphCriteria: dataofGraph,
                    criteria: this.selectedFilter,
                    type: this.selectedFilterType,
                    releaseTrainId: this.selectedCollection.id,
                }
                this.$store.itemsOfPieGraph[this.selectedWidget.id] = conditionsList;
                const index = this.$store.widgets.findIndex(item => this.selectedWidget.id === item.id);
                if (index !== -1) {
                    this.$store.widgets.splice(index, 1, widgetData);
                }
                this.$emit('updateWidget', widgetData);
            }

        },

        retrieveAllCollections: function () {
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            axios.post("/dashboard/fetch-all-release-trains", data)
                .then(response => {
                    if (response.data) {
                        _this.collections = response.data.releaseTrains;
                        if (!_.isEmpty(_this.collections)) {
                            _this.selectedCollection = _this.collections.find(item => item.id == _this.selectedWidget.releaseTrainId);
                        }
                        if (this.selectedCollection) {
                            _this.handleCollectionSelection();
                        }
                    }
                }).catch(error => {
                console.error(error);
            });
        },

        handleCollectionSelection: function () {
            this.collectionSelected = true;
            this.graphSelected = true;
            this.filterList = [];
        },

        handleFilterTypeSelection: function () {
            this.filterTypeSelected = true;
            this.selectedAdditionalFilterCriteria = null;
            this.selectedAdditionalGraphOption = null;
            let _this = this;
            data = {"releaseTrainID": _this.selectedCollection.id, "filterType": _this.selectedFilterType};
            axios.post("/dashboard/fetch-release-train-filters", data)
                .then(response => {
                    _this.filterList = response.data.releaseTrainFilters;
                    _this.filterSelected = false;
                    _this.selectedFilter = _this.selectedWidget.criteria;
                }).catch(error => {
                console.error(error);
            });
            _this.pagination.pageIndex = 0;
            _this.pagination.totalItemSize = 0;
        },

        handleFilterSelection: function (filter) {
            this.loadBacklogItems(filter);
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
            this.filterSelected = true;
            this.pagination.pageIndex = 0;
            this.pagination.totalItemSize = 0;
        },

        loadBacklogItems: function (filterBy) {
            var data = {};
            data.hierachLevel = "" + this.selectedFilter.level;
            data.fetchParents = true;
            if (_.isEmpty(this.selectedFilterType)) {
                data.filterBy = filterBy;
            } else {
                data.filterBy = this.selectedFilterType;
            }
            data.requestId = getNewUUID();
            data.filter = this.selectedFilter.criteria;
            if (data.filter && !_.isEmpty(data.filter.rules)) {
            } else {
                delete data.filter;
            }
            axios.post('/dashboard/' + this.selectedCollection.id + '/retrieveItems', data)
                .then(res => {
                    if (res.data) {
                        var items = [];
                        items = res.data;
                        this.filteredData = [];
                        this.filteredData = items;
                        this.populateConditionsDropdown(items);
                        this.selectedCondition = this.selectedWidget.graphCriteria.selectedItems;
                    }
                }).catch(error => {
                console.error(error);
            });

        },

        populateConditionsDropdown: function (responseData) {
            this.conditionsList = [];
            if (this.selectedFilterType === "status") {
                const statusMap = responseData.statusMap;
                const statusList = statusMap.statusList;
                this.conditionsList = statusList;
                let categoryMap = new Map();
                for (let i = 0; i < this.conditionsList.length; i++) {
                    let category = this.conditionsList[i].key.split("-")[0];
                    if (!categoryMap.has(category)) {
                        categoryMap.set(category, []);
                    }
                    let condition = {
                        "id": this.conditionsList[i].id,
                        "count": this.conditionsList[i].count,
                        "key": this.conditionsList[i].key,
                        "title": this.conditionsList[i].title
                    }
                    categoryMap.get(category).push(condition);
                }
                let sortedEntries = Array.from(categoryMap.entries());
                const order = ["ToDo", "InProgress", "Done", "Misc"];
                sortedEntries.sort((a, b) => order.indexOf(a[0]) - order.indexOf(b[0]));
                categoryMap = new Map(sortedEntries);
                let categoryList = [];
                categoryMap.forEach((items, category) => {
                    categoryList.push({
                        title: category,
                        items: items
                    });
                });
                this.optionsList = categoryList;
            } else if (this.selectedFilterType === "teams") {
                const teamsMap = responseData.teamsMap;
                const teamsList = teamsMap.teamsList;
                this.conditionsList = teamsList;
                this.optionsList = teamsList;
            }
            this.filterSelected = true;
        },
        handleAdditionalCriteriaForFlowTime: function () {
            if (this.selectedBoard.activeSessionBoard) {
                this.getIssueTypes(this.selectedBoard.activeSessionBoard);
            }
        },
        handleAdditionalCriteriaForFlowTimeInitial: function () {
            if (this.selectedBoard.activeSessionBoard) {
                this.getIssueTypesInitial(this.selectedBoard.activeSessionBoard);
            }
        },

        getIssueTypesInitial: function(boardId) {
            let param = { alm: true };
            this.showloader = true;

            axios.get('/dashboard/fetchALMTFSMeta/' + boardId)
                .then(response => {
                    this.showloader = false;

                    if (_.isEmpty(response.data)) {
                        return;
                    }

                    if (response.data.jiraFields) {
                        this.processJiraFields(response.data);
                    } else if (response.data.tfsProject) {
                        this.processTfsProjects(response.data);
                    }

                    this.createBacklogGroups();
                })
                .catch(error => {
                    this.showloader = false;
                    console.error(error);
                });
        },

        getIssueTypes: function(boardId) {
            let param = { alm: true };
            this.showloader = true;

            axios.get('/dashboard/fetchALMTFSMeta/' + boardId)
                .then(response => {
                    this.showloader = false;

                    if (_.isEmpty(response.data)) {
                        return;
                    }

                    if (response.data.jiraFields) {
                        this.processJiraFields(response.data);
                    } else if (response.data.tfsProject) {
                        this.processTfsProjects(response.data);
                    }

                    this.createBacklogGroups();
                })
                .catch(error => {
                    this.showloader = false;
                    console.error(error);
                });
        },

        processJiraFields: function(data) {
            this.boardType = 'jiraBoard';
            let allIssueTypes = [];

            if (!_.isEmpty(data.jiraProjectIssueTypes)) {
                data.jiraProjectIssueTypes?.forEach(issueTypeGroup => {
                    if(!_.isEmpty(issueTypeGroup.issueTypes)){
                        let issueTypes = JSON.parse(issueTypeGroup.issueTypes);
                        allIssueTypes = allIssueTypes.concat(issueTypes);
                    }
                });

                let uniqueIssueTypes = new Set();
                let filteredIssueTypes = [];

                allIssueTypes.forEach(item => {
                    if (!uniqueIssueTypes.has(item.id)) {
                        uniqueIssueTypes.add(item.id);
                        filteredIssueTypes.push({ id: item.id, name: item.name, iconUrl: item.iconUrl });
                    }
                });

                this.issueTypesList = filteredIssueTypes;

            } else {
                this.issueTypesList = [];
            }
            this.sessionBoard = data.sessionBoard;
            this.jiraFieldsMap = JSON.parse(data.jiraFields);
        },

        processTfsProjects: function(data) {
            this.boardType = 'tfsBoard';
            let filteredIssueTypes = [];
            let seenIssueTypes = new Set();

            if (!_.isEmpty(data.tfsProject)) {
                data.tfsProject.forEach(project => {
                    if(!_.isEmpty(project.itemTypesStr)){
                        let obj = JSON.parse(project.itemTypesStr).value;

                        obj.forEach(item => {
                            if (!seenIssueTypes.has(item.name)) {
                                seenIssueTypes.add(item.name);
                                filteredIssueTypes.push({ id: item.name, name: item.name, iconUrl: item.url });
                            }
                        });
                    }
                });

                this.issueTypesList = filteredIssueTypes;
                this.tfsProjects = data.tfsProject;
            } else {
                this.issueTypesList = [];
            }
        }
        ,
        createBacklogGroups: function () {
            var almData = [];
            var kendisData = {
                id: "kendisGroups",
                items: [{id: 'teams', title: "Team"},
                    {id: "cardType", title: "Card Type"},
                    // {id: "plannedUnplanned", title: "Planned/Unplanned"},
                ],
                title: "Group by"
            }
            this.flowTimeLineGroupByList = [];
            if (this.boardType == 'jiraBoard') {
                let additionalFieldArray = [];
                // if (this.sessionBoard.session.jiraFeatureParentEnabled) {
                //     additionalFieldArray.push({title: 'Parent', id: 'jiraField-parent'});
                // }

                // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesFeature) {
                //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesFeature) {
                //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                //         if (fieldData) {
                //             if (this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent') {
                //                 continue;
                //             }
                //             additionalFieldArray.push({title: fieldData.name, id: 'jiraField-' + fieldData.key});
                //         }
                //     }
                // }
                // if (this.sessionBoard.session.additionalFieldsEnabled && this.sessionBoard.session.additionalFieldsValuesUserStory) {
                //     for (let featureField of this.sessionBoard.session.additionalFieldsValuesUserStory) {
                //         let fieldData = this.jiraFieldsMap.find(item => (item.key == featureField.key));
                //         if (fieldData) {
                //             if(this.sessionBoard.session.jiraFeatureParentEnabled && fieldData.key == 'parent'){
                //                 continue;
                //             }
                //             additionalFieldArray.push({ title: fieldData.name, id: 'jiraField-'+fieldData.key });
                //         }
                //     }
                // }
                // if (additionalFieldArray.length > 0) {
                //     almData = {
                //         id: "almGroups",
                //         items: additionalFieldArray,
                //         title: "By Jira Additional Fields"
                //     }
                // }
                if (!_.isEmpty(this.sessionBoard.session.almConfigurations)) {
                    kendisData.items.push({id: 'jiraProject', title: "Jira Project"});  //tbc
                }
            } else if(this.boardType == 'tfsBoard') {
                almData = {
                    id: "almGroups",
                    items: [{id: 'tfsProject', title: "Project"},
                        {id: 'areaPath', title: "Area Path"},
                        // {id: 'epic', title: "Parent-Epic"}
                    ],
                    title: "By Azure DevOps Fields"
                }; //tbc

                // let duplicationCheckMap = {};
                // _.each(this.tfsProjects, project => {
                //     if (project.selectedFields) {
                //         _.each(project.selectedFields, fieldMap => {
                //             if (!duplicationCheckMap[fieldMap.referenceName]) {
                //                 duplicationCheckMap[fieldMap.referenceName] = true;
                //                 let groupByOption = {};
                //                 groupByOption.title = fieldMap.name;
                //                 groupByOption.id = "tfsField-" + fieldMap.referenceName;
                //                 groupByOption.key = fieldMap.referenceName;
                //                 groupByOption.dataType = fieldMap.type;
                //                 almData.items.push(groupByOption);
                //             }
                //         });
                //     }
                // });
            }

            this.flowTimeLineGroupByList.push(kendisData);
            this.flowTimeLineGroupByList.push(almData);
            if(this.optionTypeTitle === 'Flow Load Graph' || this.optionTypeTitle === 'Flow Distribution Graph'){
                var teamData = {
                    id: "kendisGroups",
                    items: [{id: 'teams', title: "Team"},
                    ],
                    title: "Group by"
                }
                this.flowTimeLineGroupByList = [];
                this.flowTimeLineGroupByList.push(teamData);
            }
            if(!_.isEmpty(this.flowTimeLineGroupByList)){
                this.handleBoardFilterSelection();
            }
        },

        handleBoardFilterSelection: function() {
            // Handle Cumulative Flow Diagram criteria
            const handleCfdCriteriaList = () => {
                const indexOfTeams = this.cfdCriteriaList.findIndex(item => item.id === 'teams');
                if (this.boardItemsFilter === 'unplanned-items') {
                    if (indexOfTeams !== -1) {
                        this.cfdCriteriaList.splice(indexOfTeams, 1);
                        this.selectedCFDCriteria = '';
                    }
                } else {
                    if (indexOfTeams === -1) {
                        this.cfdCriteriaList.push({ id: 'teams', title: 'Team' });
                    }
                }
            };

            // If CFD, handle and return early
            if (this.optionTypeTitle === 'Cumulative Flow Diagram') {
                handleCfdCriteriaList();
                return;
            }

            // Finding the "kendisGroups" object
            const kendisGroups = this.flowTimeLineGroupByList.find(group => group.id === 'kendisGroups');
            if (kendisGroups) {
                const items = kendisGroups.items;

                const removeItemById = (array, id) => {
                    const index = array.findIndex(item => item.id === id);
                    if (index !== -1) array.splice(index, 1);
                };

                const addItemToTop = (array, item) => {
                    if (!array.some(existingItem => existingItem.id === item.id)) {
                        if (array.length > 15) {
                            array.push(item);
                        } else {
                            array.unshift(item);
                        }
                    }
                };

                // Handle group by options based on board filter selection
                const teamsItem = { id: 'teams', title: 'Team' };
                if (this.boardItemsFilter === 'unplanned-items') {
                    if(this.selectedFlowTimeLineGroupBy === 'teams'){
                        this.selectedFlowTimeLineGroupBy = "";
                    }
                    removeItemById(items, 'teams');
                } else {
                    addItemToTop(items, teamsItem);
                }
            }
        },


    },

})
