const kendisWidgetCriteraiDetails = Vue.component('kendis-widget-criteria-details', {
    template: `
		<div>
		    <div v-if="!_.isEmpty(graphCriteria.selectedBoardTitle)" class="DAB">
                <label>Board: </label>
                <a :href="boardHyperlink" target="_blank" class="und">{{ graphCriteria.selectedBoardTitle }}</a>
			</div>		
			<div v-if ="!_.isEmpty(graphCriteria.boardItemsFilter)" class="DAB">
                <label>Items Filter: </label>
                <div class="">{{graphCriteria.boardItemsFilter}}</div>  			
            </div>  
			<div v-if="!_.isEmpty(graphCriteria.selectedIssueType) && !['cfd-graph', 'flow-time-graph', 'cycle-time-graph', 'lead-time-graph','flow-efficiency-graph','flow-velocity-graph','flow-load-graph','flow-distribution-graph'].includes(type)" class="DAB">
                <label>Issue Type: </label>
                <div class="" style="max-width: 180px;">{{graphCriteria.selectedIssueType.join(', ')}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedGroupBy)" class="DAB">
                <label>Group By: </label>
                <div class="">{{graphCriteria.selectedGroupBy}}</div>
			</div>			
			<div v-if="!_.isEmpty(graphCriteria.selectedXAxis)" class="DAB x-axis">
                <label>X-Axis: </label>
                <div class="">{{_.capitalize(graphCriteria.selectedXAxis)}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedInterval) && type !== 'flow-distribution-graph' && type !== 'cfd-graph'  && type !== 'cycle-time-graph' && type !== 'lead-time-graph' " class="DAB">
                <label>Days: </label>
                <div class="">{{graphCriteria.selectedInterval}}</div>
			</div>	
			<div v-if="!_.isEmpty(graphCriteria.selectedInterval) && type === 'cycle-time-graph' || type === 'lead-time-graph'  " class="DAB">
                <label>Interval: </label>
                <div class="">{{graphCriteria.selectedInterval}}</div>
			</div>			
			<div v-if=" type == 'flow-efficiency-graph' || type == 'cycle-time-graph' || type == 'flow-time-graph' && !_.isEmpty(graphCriteria.selectedFromStatus) && !_.isEmpty(graphCriteria.selectedToStatus)" class="DAB">
                <label>Status(From - To): </label>
                <div class="">{{graphCriteria.selectedFromStatus}} - {{graphCriteria.selectedToStatus}}</div>
			</div>		
			<div v-if=" type == 'flow-load-graph' && !_.isEmpty(graphCriteria.selectedFromStatus) && !_.isEmpty(graphCriteria.selectedToStatus)" class="DAB">                
                <label>Active Status: </label>
            	<div class="">{{formattedActiveStatus}}</div>                
            </div>    
            <div v-if=" type == 'flow-load-graph' && !_.isEmpty(graphCriteria.selectedFromStatus) && !_.isEmpty(graphCriteria.selectedToStatus)" class="DAB">                
            	<label>Waiting Status: </label>
                <div class="">{{formattedWaitingStatus}}</div>                
            </div>       
            <div v-if="  type == 'flow-velocity-graph' && !_.isEmpty(graphCriteria.selectedFromStatus)" class="DAB">
                <label>Statuses: </label>
                <div class="elips" style="max-width: 180px;">{{formattedActiveStatus}}</div>  
            </div>
            <div v-if ="type == 'cfd-graph' && !_.isEmpty(graphCriteria.advanceCriteria)" class="DAB">
                <label>Advance Criteria: </label>
                <div class="">{{graphCriteria.advanceCriteria}}</div>  			
            </div>                       
        </div>
                         
		`, data() {
        return {};
    },

    props: {
        graphCriteria: {
            type: Object, required: true
        },
        type: {
            type: String, required: true
        },
    },

    created() {

    },

    mounted() {
    },

    computed: {
        boardHyperlink() {
            // Construct the base URL and append the session query parameter
            const baseURL = `${window.location.protocol}//${window.location.hostname}${window.location.port ? ':' + window.location.port : ''}`;
            return `${baseURL}/session?id=${this.graphCriteria.sessionBoardId}`;
        },
        formattedActiveStatus() {
            if (!_.isEmpty(this.graphCriteria.selectedFromStatus)) {
                return this.graphCriteria.selectedFromStatus.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },
        formattedWaitingStatus() {
            if (!_.isEmpty(this.graphCriteria.selectedToStatus)) {
                return this.graphCriteria.selectedToStatus.split(',').map(item => item.trim()).join(', ');
            } else {
                return '';
            }
        },
    },

    methods: {},
})
