try{
Vue.use(VueRouter);
Vue.use(Pinia.PiniaVuePlugin);
Vue.use(Pinia.createPinia());
Vue.use(VueObserveVisibility);
}catch(e){}
//Pinia store used to store items of graph, to make it available for all components.
const useGraphItemsStore = Pinia.defineStore('useGraphItemsStore', {
    state() {
        return {
            itemsOfPieGraph: [],
            graphSelected: false,
            widgets: [],
        }
    },
    getters: {
        getItemsOfPieGraph() {
            return this.itemsOfPieGraph;
        },
        getGraphSelected() {
            return this.graphSelected;
        },
        getWidgets() {
            return this.widgets;
        },
    },
    actions: {
        setItemsOfPieGraph(items) {
            this.itemsOfPieGraph = items;
        },
        addItemsOfPieGraph({widgetId, itemList}) {
            this.itemsOfPieGraph[widgetId] = itemList;
        },
        setGraphSelected(selected) {
            this.graphSelected = selected;
        },
        addWidget(widget) {
            this.widgets.push(widget);
        },
        removeWidget(id) {
            const index = this.widgets.findIndex(widget => widget.id === id);
            if (index !== -1) {
                this.widgets.splice(index, 1);
            }
        },
    },
});
let dashboardHomeVue = undefined;

const kendisDashboardHomepage = Vue.component('kendis-dashboard-homepage', {
    store: useGraphItemsStore,
    template: `
		<div id="kendisdashboardlisting" class="pnlAnalytics active nw-analtc dashBoardWraper">
		    <div v-if="showloader" class="loader">
		    	<div>
		    		<div class="loaderinteg"></div>
		    	</div>
			</div>
			<kendis-dashboard-graph-options v-if="openDashboardWidgetsOptions" @close="onSelectGraphTypeOption"> </kendis-dashboard-graph-options>
			<kendis-create-dashboard v-if="dashboardPopup.show" :dashboard="dashboardPopup.dashboard"
				@updated="onDashboardPopupUpdated"
				@close="onDashboardPopupClose"
				@roleUpdate="onRoleUpdateForAll"
				>
			</kendis-create-dashboard>
		 	<div>
				<div class="DFCB dashboardHeader">
				 	<div class="DFA">
				 	    <div class="tooltip">
                            <h4 class="fs-22 ftsb pl-5 elips c-deflt" style="max-width: 1000px;">
                                <a class="mr-5 fs-22">{{dashboardSelectedId}}</a> {{dashboardName}}                                
                            </h4>
                            <div class="hovtooltip">{{dashboardName}}</div>
                        </div>
                         <span v-if="!_.isEmpty(dashboardDescription)" class="tooltip gap-1 flowTip ml-10">
                             <em class="infotxt"></em>
                             <div class="hovtooltip">
                                {{dashboardDescription}}
                             </div>
                         </span>
                    </div>
				 	<div class="DFA gap-2">
				 	    <div v-if="dashboardActionAllowed(myRole,'EditDashboard')" class="hd mt-5">
                            <div class="switch-button grn switch-button-sm mr-5" style="margin-top: -1px;" @click="onEnableReordering">
                                <input type="checkbox" :checked="canReorder" />
                                <span><label for="chkLinks"></label></span>
                            </div>
                            Edit Mode
					    </div>
						<a v-if="widgetspresent"  class="refreshContainer tooltip" href="javascript:void(0);"   @click="syncDashboard()">
							<!--<img  src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: isSyncing }" class="refreshIcon">-->
							<img v-if="!isSycned" src="/assets/icons/refresh-gray.svg" alt=".." :class="{ active: isSyncing }" class="refreshIcon">
							<img v-if="isSycned" src="/assets/icons/new/check.svg" alt=".." class="checkIcon">
							<div class="hovtooltip wht-nwrp ftsb">
								Refresh Dashboard
							</div>
						</a>
						<button v-if="dashboardActionAllowed(myRole,'CreateWidget')" type="button" class="button rds4" @click="onClickAddWidget()">
							+ Add Widget
						</button>
						<div class="dshstng DFA c-point" v-if="dashboardActionAllowed(myRole,'EditDashboard')" @click="onOpenDashBoardPopup()"> <div class="ftsb fs-14">Settings</div></div>
						<em @click="handleClose" title="Close" class="rmv-ico ti-close rnd DAJ p-intial"></em>
						<!--<div v-if="!_.isEmpty(dashboardDate)" class="light">Last Dashboard updated on: {{dashboardDate}}</div>-->
					</div>
				 </div>	
                 <div class="alertBarContainer" v-if="isEditMode">
                     <div class="DFA alertBar">
                          <img src="/assets/icons/info-g.svg" alt=".." class="alertIcon">
                          <span class="fs-14">You're currently in edit mode. Widgets can be reordered and resized.</span>
                     </div>
                 </div>
                <div class="scrollBar grid-stack cardsWraper">
                        <div v-if=" dashboardActionAllowed(myRole,'CreateWidget') && widgetList.length == 0" class="emptyWidgetScreen">
                            <div  v-if="dashboardActionAllowed(myRole,'add-widget')"  class="txt-cntr">
                                <div  class="emptyTextwidgetWrap">
                                    <h3 class="fs-18">Create your first Widget</h3>
                                    <p>Customize your dashboard by adding widgets to track key metrics and visualize data in real time.</p>
                                    <div class="DF JC">
                                        <button type="button" class="button rds4" @click="onClickAddWidget()">
                                            + Add Widget
                                        </button> 
                                    </div>
                                </div>
                            </div>
                            <div v-else class="txt-cntr">
                                <div class="emptyTextwidgetWrap">
                                    <div class="fs-18">
                                            This Dashboard is empty
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <kendis-dashboard-widget-factory v-for="(widgetData,widgetDataIndex) in widgetList" :key="widgetData.id" :myRole ="myRole" :widgetData="widgetData" :dashboardSelectedId="dashboardSelectedId" @handleRemoveAction="handleRemoveAction" @handleDuplicateAction ="handleDuplicateAction" :globalColorsMap="globalColorsMap"/>
                </div>
    		</div>		 
		</div>
	`,
    mixins:[rightsMixin],
    props: {dashboardSelectedId: null, selectedDashboardName: null,
    	isGlobal: {
            type: Boolean,
			default: () => { return true }
        }
    },

    data() {
        return {
            isEditMode: false,
            myRole:'',
            dashboardDescription:'',
            dashboardName :'',
            widgetType:'',
            widgetList:[],
            openDashboardWidgetsOptions: false,
            processedGraphData: [],
            optionsDataSelectionPopup: {
                openDashboardWidgetsOptionsDataSelection: false,
                graphTypeOption: '',
                optionType: '',
                graphType: '',
            },
            graphSelected: false,
            graphName: '',
            graphs: [],
            scopeGraph: {
                show: false,
                options: {
                    chart: {
                        plotBackgroundColor: null,
                        plotBorderWidth: null,
                        plotShadow: false,
                        type: 'pie',
                        zoomType: 'x',
                    },
                    tooltip: {
                        pointFormat: '<b>{point.options.percentage:.2f}%</b>'
                    },
                    plotOptions: {
                        format: '<b>{point.name}</b>: {point.options.percentage:.0f} %',
                        pie: {
                            dataLabels: {
                                enabled: true,
                                distance: '-100%',
                                formatter: function () {
                                    return '<b>' + this.percentage.toFixed() + ' %</b>:' + this.point.name;
                                },
                                style: {
                                    fontSize: "20px",
                                    fontWeight: 'bold',
                                    color: 'black'
                                },
                                filter: {
                                    property: 'name',
                                    operator: '===',
                                    value: 'Done'
                                }
                            },
                            stacking: 'normal',
                            cursor: 'pointer',
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onGraphClicked(event);
                                    }
                                }
                            },
                            showInLegend: true,
                        },
                        bar: {
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onGraphClicked(event);
                                    }
                                }
                            },
                            stacking: 'normal',
                            cursor: 'pointer',
                            showInLegend: false,
                            dataLabels: {
                                enabled: true
                            },
                            groupPadding: 0.1
                        },
                        column: {
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onGraphClicked(event);
                                    }
                                }
                            },
                            stacking: 'normal',
                            cursor: 'pointer',
                            showInLegend: false,
                            dataLabels: {
                                enabled: true
                            },
                            groupPadding: 0.1
                        },
                    },
                    xAxis: {
                        categories: [],
                        crosshair: true,
                        accessibility: {
                            description: 'statuses'
                        }
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: 'Count Items'
                        },
                        stackLabels: {
                            enabled: true
                        }
                    },
                    series: [{
                        innerSize: '70%',
                        colorByPoint: true,
                        data: [],
                    }],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen','separator','downloadPDF','downloadJPEG','downloadPNG','downloadXLS' ]
                            }
                        }
                    }
                },
            },
            teamStatusGraph: {
                show: false,
                options: {
                    chart: {
                        type: 'bar',
                        zoomType: 'x',
                    },
                    xAxis: {
                        categories: [],
                        title: {
                            text: null
                        },
                        gridLineWidth: 1,
                        lineWidth: 0
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: 'Count of Items',
                            align: 'high'
                        },
                        labels: {
                            overflow: 'justify'
                        },
                        gridLineWidth: 0
                    },
                    plotOptions: {
                        bar: {
                            dataLabels: {
                                enabled: true
                            },
                            groupPadding: 0.1,
                            point: {
                                events: {
                                    click: (event) => {
                                        this.onGraphClicked(event);
                                    }
                                }
                            },
                        }
                    },
                    credits: {
                        enabled: false
                    },
                    series: [],
                    exporting: {
                        buttons: {
                            contextButton: {
                                menuItems: ['viewFullscreen','separator','downloadPDF','downloadJPEG','downloadPNG','downloadXLS' ]
                            }
                        }
                    }
                }
            },
            widgets: [],
            widgetId: '',
            selectedWidget: [],
            showloader: false,
            widgetspresent: false,
            dashboardDate: '',
            graphTypeTitle: null,
            optionTypeTitle: null,
            isSyncing: false,
            isSycned: false,
            //Area Chart
            areaChart: {
                show: false,
                options: {
                    chart: {
                        type: 'area',
                        zoomType: 'x',
                    },
                    xAxis: {
                        categories: [],
                        allowDecimals: false,
                    },
                    yAxis: {
                        title: {
                            text: 'Count of Items'
                        }
                    },
                    tooltip: {
                        pointFormat: '{series.name} : <b>{point.y:,.0f}</b><br/>'
                    },
                    plotOptions: {
                        area: {
                            marker: {
                                enabled: false,
                                symbol: 'circle',
                                radius: 2,
                                states: {
                                    hover: {
                                        enabled: true
                                    }
                                }
                            }
                        }
                    },
                    series: [],
                    exporting: {
                        enabled: false
                    }
                }
            },
            xAxis: null,
            yAxis : null,
            gridStack : undefined,
            canReorder: false,
            globalColorsMap: null,
			dashboardPopup: {
				show: false,
				dashboard: undefined,
			},
			dashboard : {}
        }
    },

    mounted() {
        this.fetchDashboardWidgets();
    },
    created() {
		if (typeof releaseTrainVue !== "undefined") {
			releaseTrainVue.store.setShowLeftMenuBar(false);
		}
        dashboardHomeVue = this;
    },
    beforeRouteLeave(to, from, next) {
		
		next();
	},

    computed: {
	},

    beforeDestroy() {
		dashboardHomeVue = undefined;
		if(this.isGlobal){
	        this.$router.go(-1);
		}else{
			if (typeof releaseTrainVue !== "undefined") {
				releaseTrainVue.store.setShowLeftMenuBar(true);
			}
		}
    },

    components: {
        'kendis-dashboard-graph-options': kendisDashboardGraphOptions,
        'kendis-dashboard-widget-factory':kendisDashboardWidgetFactory,
		'kendis-create-dashboard'  : kendisCreateDashboard,
    },

    methods: {
        handleClose() {
			if(this.isGlobal){
				window.location.href = '/dashboard';  //needs to be updated
			}else{
				this.$emit('close');
			}
        },
        /////////////////////////////////////////////////
		////////      GRID STACK CODE
		onEnableReordering: function () {
                //Check if the user has access rights for Edit Options
            axios.get('/dashboard/getUserDashboardAccessRole/'+ this.dashboardSelectedId)
                .then(response => {
                    this.myRole = response.data.userRole;
                    if(this.dashboardActionAllowed(this.myRole,"EditDashboard")){
                        this.canReorder = !this.canReorder;

                        if (this.gridStack) {
                            if (this.canReorder) {
                                this.isEditMode = true;
                                this.gridStack.enable();
                            }else {
                                this.isEditMode = false;
                                this.gridStack.disable();
                            }
                        }
                    }
                    else{
                        showTopMessage("Please ask the author to provide editor access to continue.Refreshing for updated access controls","warning","8000");
                        location.reload();
                    }
                })
                .catch(e => {
                    _this.loader.show = false;
                });
		},
		onGridStartEditing: function () {
			let _this = this;
			
			Vue.nextTick(() => {
				if (!_this.gridStack) {
					_this.gridStack = GridStack.init(
						{
						column: 6, 
						animate: false,
						margin: "10px"
						}
					);
					if (_this.canReorder) {
						_this.gridStack.enable();
					} else {
						_this.gridStack.disable();
					}

					_this.gridStack.on('change', function(event, items) {
					});
					
					_this.gridStack.on('dragstop', function(event, el) {
						_this.updateWidgetGridPosition();
					});
					_this.gridStack.on('resizestop', function(event, el) {
						_this.updateWidgetGridPosition();
						let _id = el.id;
						EventBus.$emit('rerenderWidget', _id);
					});
				}
			});
		},
		getNewGridPosition: function (widget) {
			
			let lastNode = undefined;
			
			let validWidgetMap = {};
			_.each(this.widgetList,gd=> {
				if (gd.id && gd.id !== "temp-id") {
					validWidgetMap[gd.id] = true; 
				}
			});
			this.gridStack.engine.nodes.forEach(function(item) {
				if (item.el.id !== "temp-id" && validWidgetMap[item.el.id]) {
					if (lastNode == undefined) {
						lastNode = item;
					}
					else {
						if (item.y > lastNode.y) {
							lastNode = item;
						}
						else if (item.y == lastNode.y
							&& item.x > lastNode.x) {
							lastNode = item;
						}
					}
				}
			});
			
			if (lastNode == undefined) {
				return {x:0,y:0};
			}
			else {
				let widgetWidth = 1;
				if (widget && widget.columns > 1) {
					widgetWidth = widget.columns;
				}
				let y = lastNode.y;
				let x = lastNode.x + lastNode.w;
				if (x + widgetWidth > 6) {
					x = 0;
					y = y + lastNode.h;
				}
				return {x:x , y: y};
			}
		},
		updateWidgetGridPosition: function () {
			let items = [];
			
			let graphDataMapBy = {};
			_.each(this.widgetList, graph=> {
				graphDataMapBy[graph.id] = graph;
			});
			
			this.gridStack.engine.nodes.forEach(function(item) {
				let widget = { id: item.el.id };

				widget.posX = item.x;
				widget.posY = item.y;
				widget.columns = item.w;
				widget.rows = item.h;

				let graphData = graphDataMapBy[widget.id];
				if (graphData) {
					graphData.posX = item.x;
					graphData.posY = item.y;
					graphData.columns = item.w;
					graphData.rows = item.h;
				}

				items.push(widget);
			});
			
			let data = {};
			data.widgets = JSON.stringify(items);
			
			axios.post("/dashboard/updateWidgetGridPosition/"+this.dashboardSelectedId,data)
			.then((response)=>{
				if (response.data && response.data.success) {
					
				}
			}
			).catch((error)=> {
				console.log(error);
			});
		},
		onGridEndEditing: function () {
			if (this.gridStack) {
				this.gridStack.destroy(false);
				this.gridStack = undefined;
			}
		},
		/////////////////////////////////////////////////

        //////////////Helper Functions///////////////////
        //Method for getting columns of widget

        onClickAddWidget: function () {
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: hidden; }";
            this.openDashboardWidgetsOptions = true;
        },

        computeWidgetColumns:function(widgetType){
            if(widgetType == 'cfd-graph'){
                return 6;
            }
            else{
                return 3;
            }
        },

        //Method for setting name for a new widget based on its type
        createWidgetDefaultName:function(widgetType){
            switch (widgetType){
                case    "cfd-graph":
                    return "Cumulative Flow Diagram"
                case    "cycle-time-graph":
                    return "Cycle Time Graph"
                case    "lead-time-graph":
                    return "Lead Time Graph"
                case    "flow-time-graph":
                    return "Flow Time Graph"
                case    "flow-efficiency-graph":
                    return "Flow Efficiency Graph"
                case    "flow-velocity-graph":
                    return "Flow Velocity Graph"
                case    "flow-load-graph":
                    return "Flow Load Graph"
                case    "flow-distribution-graph":
                    return "Flow Distribution Graph"
                default:
                    return  "New Graph"
            }
        },

        onSelectGraphTypeOption: function (info) {
            let _this = this;
            var style = document.createElement('style');
            document.head.appendChild(style);
            style.textContent = "body { overflow: auto; }";
            _this.openDashboardWidgetsOptions = false;
            if (info) {
                _this.widgetType = info.optionType.type;
                console.log(_this.widgetType);
                _this.optionsDataSelectionPopup.graphTypeOption = info.graphTypeOption;
                _this.optionsDataSelectionPopup.optionType = info.optionType;
                _this.optionsDataSelectionPopup.graphType = info.graphType;
                // this.optionsDataSelectionPopup.openDashboardWidgetsOptionsDataSelection = true;
                _this.createNewGraph();
            }
        },
        ////////////////////////////////////////////////////////////

        //Method for creation of a new empty widget
        createNewGraph:function(){
            console.log("createNewGraph");
            let _this = this;
            let graphCriteria = {
                "graphTypeTitle"        : _this.optionsDataSelectionPopup.graphType.title,
                "optionTypeTitle"       : _this.optionsDataSelectionPopup.optionType.title,
                "graphTypeOptionTitle"  : _this.optionsDataSelectionPopup.graphTypeOption.title,
            }
            let widget = {
                type            :   _this.widgetType,
                columns         :   _this.computeWidgetColumns(_this.widgetType),
                name            :   _this.createWidgetDefaultName(_this.widgetType),
                state           :   "new",
                graphCriteria   :   graphCriteria,
                collectionsGraphCriteria: graphCriteria,
                category        :   _this.optionsDataSelectionPopup.optionType.category,
            };
            if (!_.isEmpty(widget)) {
                if (!this.widgetId) {
                    let position = _this.getNewGridPosition(widget);
                    widget.posX = position.x;
                    widget.posY = position.y;
                }
                axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widget).then(response=>{
                    if(response.data !== null){
                        console.log("Created Widget with Data: ",response.data?.widget);
                        if(!_.isEmpty(response.data.widget)){
							let newWidget = response.data.widget;
                            this.$set(this,'widgetspresent',true);
                            _this.widgetList.push(newWidget);
                            Vue.nextTick(()=>{
								let widgetElement = document.getElementById(newWidget.id);
								_this.gridStack.makeWidget(widgetElement);
							});
                        }
                    }
                }).catch(e=>{
                    console.log("Error occured while creating new graph: ",e);
                })
            } else {
                throw new Error('Processed widget data is empty');
            }
        },
        ////////////////////////////////////////////////////////////

        //Action Handling: Removal and Duplication of Graphs
        handleRemoveAction:function(payload){
            const {id} = payload;
            this.removeWidget(id);
        },

        handleDuplicateAction:function(payload){
            const {widget} = payload;
            this.duplicateWidget(widget);
        },

        removeWidget: function (widgetId) {
            let _this = this;

            const data = {"widgetId": widgetId};

            axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/deleteWidget", data).then(response => {
                    Vue.nextTick(()=>{
                    if (_this.widgetList.length > 0) {
                      //  _this.widgetspresent = true;
                        this.$set(this,'widgetspresent',true);
                    } else {
                       // _this.widgetspresent = false;
                        this.$set(this,'widgetspresent',false);
                    }
                    });
                _this.$store.widgets = response.data.dashboard.widgets;
                if (_this.gridStack) {
				 	let widgetElement = document.getElementById(widgetId);
                     _this.gridStack.removeWidget(widgetElement,false,false);
                }
                let widgetIndex = _.findIndex(_this.widgetList, {id: widgetId});
                if (widgetIndex > -1) {
					_this.widgetList.splice(widgetIndex, 1);
				}
                Vue.nextTick(()=>{
                    _this.updateWidgetGridPosition();
                });

            }).catch(e => {
                console.error(e)
            });
        },

        duplicateWidget: function (widget) {
            let selectedWidget = widget;
            let widgetData = {};
            if (selectedWidget.type === 'teams' && selectedWidget.selectedAdditionalFilterCriteria == 'statusCategory' && selectedWidget.selectedAdditionalGraphOption == 'colBreakDown') {
                let dataofGraph = {
                    "graphType": selectedWidget.graphCriteria.graphType,
                    "itemList": selectedWidget.graphCriteria.itemList,
                    "selectedItems": selectedWidget.graphCriteria.selectedItems,
                    "hierarchyLevel": selectedWidget.graphCriteria.hierarchyLevel
                };
                widgetData = {
                    name: selectedWidget.name,
                    type: selectedWidget.type,
                    graphCriteria: dataofGraph,
                    releaseTrainId: selectedWidget.releaseTrainId,
                    criteria: selectedWidget.criteria,
                    selectedAdditionalGraphOption: selectedWidget.selectedAdditionalGraphOption,
                    selectedAdditionalFilterCriteria: selectedWidget.selectedAdditionalFilterCriteria,
                    columns: selectedWidget.columns,
                    rows: selectedWidget.rows,
                    category:selectedWidget.category,
                };
                widgetData.graphAdditionalCriteria = selectedWidget.graphAdditionalCriteria;
            }
            else if (selectedWidget.type == 'completed-stories' || selectedWidget.type == 'cfd-graph' || selectedWidget.type == 'flow-time-graph' || selectedWidget.type == 'flow-velocity-graph' || selectedWidget.type == 'flow-efficiency-graph' ||  selectedWidget.type == 'flow-load-graph' ||  selectedWidget.type == 'flow-distribution-graph' ||  selectedWidget.type == 'cycle-time-graph' ||  selectedWidget.type == 'lead-time-graph' || selectedWidget.type == 'general-purpose') {
                widgetData = {
                    name: selectedWidget.name,
                    description: selectedWidget.description,
                    graphCriteria: selectedWidget.graphCriteria,
                    graphAdditionalCriteria: selectedWidget.graphAdditionalCriteria,
                    type: selectedWidget.type,
                    allGroupBys: selectedWidget.allGroupBys,
                    columns: selectedWidget.columns,
                    rows: selectedWidget.rows,
                    category:selectedWidget.category,
                    criteria: selectedWidget.criteria,
                }
            }else if(selectedWidget.type == 'collections-pie-chart' || selectedWidget.type == 'collections-col-chart'){
                widgetData = {
                    name: selectedWidget.name,
                    description: selectedWidget.description,
                    collectionsGraphCriteria: selectedWidget.collectionsGraphCriteria,
                    graphAdditionalCriteria: selectedWidget.graphAdditionalCriteria,
                    type: selectedWidget.type,
                    allGroupBys: selectedWidget.allGroupBys,
                    columns: selectedWidget.columns,
                    rows: selectedWidget.rows,
                    category:selectedWidget.category,
                    criteria: selectedWidget.criteria,
                }
            }
            else {
                let dataofGraph = {
                    "graphType": selectedWidget.graphCriteria.graphType,
                    "itemList": selectedWidget.graphCriteria.itemList,
                    "selectedItems": selectedWidget.graphCriteria.selectedItems,
                    "hierarchyLevel": selectedWidget.graphCriteria.hierarchyLevel
                };
                widgetData = {
                    name: selectedWidget.name,
                    type: selectedWidget.type,
                    graphCriteria: dataofGraph,
                    releaseTrainId: selectedWidget.releaseTrainId,
                    criteria: selectedWidget.criteria,
                    columns: selectedWidget.columns,
                    rows: selectedWidget.rows,
                    category:selectedWidget.category,
                }
                widgetData = widget;
            }

            let position = this.getNewGridPosition(widgetData);
            widgetData.posX = position.x;
            widgetData.posY = position.y;
            if ((selectedWidget.type == 'collections-pie-chart' || selectedWidget.type == 'collections-col-chart') && widgetData.hasOwnProperty('id')) {
                // delete widgetData?.id;
                widgetData.id = getNewUUID();
            }

            let _this = this;
            axios.post("/dashboard/" + this.dashboardSelectedId + "/widget/save", widgetData).then(response => {
				let newWidget = response.data.widget;
                _this.globalColorsMap = response.data.dashboard.globalColorsMap;
				_this.widgetList.push(newWidget);
				
				Vue.nextTick(()=> {
					let widgetElement = document.getElementById(newWidget.id);
					_this.gridStack.makeWidget(widgetElement);
				});
				
            }).catch(e => {
                console.error(e);
            })
        },

        ////////////////////////////////////////////////////////////
        //Method to load inital data of widgets
        fetchDashboardWidgets: function () {
            let _this = this;
            if(!this.dashboardSelectedId){
				return;
			}
            this.showloader = true;

            let data = {"dashboardId": this.dashboardSelectedId};

            axios.post("/dashboard/getAllDashboardWidgets/", data).then(response => {
                this.globalColorsMap = response.data.globalColorsMap
                if(response.data.error === 'noAccessRights'){
                    showTopMessage("Dashboard Access not present",'warning',5000);
                    if(this.isGlobal){
	                    window.location.href = '/dashboard';
					}
                }

                this.dashboardName = response.data.dashboardName;
				this.dashboard = response.data.dashboard;
				this.dashboard.myRole = response.data.myRole;
                // this.dashboardName = response.data.dashboardName;
                this.dashboardDescription = response.data.dashboardDescription;
                let widgetMap = response.data.widgetMap;
                let allgroupBys = response.data.allgroupsMap;
                this.myRole = response.data.myRole;
                _this.widgetspresent = false;
                if (!_.isEmpty(widgetMap)) {
                    if (widgetMap.length > 0) {
                        this.widgetList = widgetMap;
                        _this.widgetspresent = true;
                        this.showloader = false;
                    } else {
                        _this.showloader = false;
                        _this.widgetspresent = false;
                    }
                }
                else{
                    _this.showloader = false;
                }
                _this.onGridStartEditing();
            }).catch(e => {
				_this.onGridStartEditing();
                this.showloader = false;
                console.error(e)
            });
        },
        ////////////////////////////////////////////////////////////

        ////////Method for Sync dashboard
        syncDashboard:function(){
            EventBus.$emit('syncAllWidgets');
        },
        ////////////////////////////////////////////////////////////
		onOpenDashBoardPopup : function () {
			this.dashboardPopup.dashboard = this.dashboard;
			this.dashboardPopup.show = true;
		},
		onDashboardPopupClose: function () {
			this.dashboardPopup.dashboard = undefined;
			this.dashboardPopup.show = false;
		},
		onDashboardPopupUpdated: function (dashboard, closePopup) {
			
			if (closePopup) {
				this.dashboardPopup.show=false;
			}
			this.dashboard = dashboard;
			this.dashboard.myRole = this.myRole;
			this.dashboardName = dashboard.name;
			this.dashboardDescription = dashboard.description;
		},
		onRoleUpdateForAll : function (flag) {
			this.dashboard.sharedWithAll = flag;
		},
    },
})
