

const kendisCreateDashboard = Vue.component('kendis-create-dashboard',{
    template:`
	<div>
		<div v-if="addKendisUserPopup.showRolePopup">
			<div class="overlay" style="display: block;  z-index: 1000;"></div> 
			<div class="ui-dialog minipop dshbrd p-fix" style="display: block; z-index: 1000;">
				<div class="head" style="display: block;">Add Role
					<i class="rmv-ico ti-close rnd DAJ" @click="onKendisUserCancelUserOrGroup"></i>
				</div> 
				<div class="cntr">
					<div class="prow light mtxt mb-10">Please select a role. Multiple roles can be assigned.</div> 
					<div class="rec">
						<div class="selectcont">
							<select title="" class="" v-model="addKendisUserPopup.role">
								<option value="Editor">Editor</option>
								<option value="Viewer">Viewer</option>
							</select>
						</div>
					</div>
				</div> 
				<div class="rec btn">
					<a href="javascript:void(0);" class="button FR" @click="onKendisUserAddUserOrGroup">Add</a> 
					<a href="javascript:void(0);" class="cncl FR" @click="onKendisUserCancelUserOrGroup">Cancel</a>
				</div>
			</div>
		</div>
		
		<div class="overlay" style="display: block;"></div>
		<div id="kendisdashboardlisting" class="ui-dialog createpop dshbrdsntg">			
			<div v-if="loader.show" class="loader">
				<div>
					<div class="loaderinteg"></div>
					<span class="LOADER-TITLE" v-html="loader.text"></span>
				</div>
			</div>
			
			<div class="DFCB py-10 px-20" style="border-bottom: 1px solid #CED5DD;">
				<span class="fs-18 ftsb widgetPopUpTitle">{{popupTitle}}</span>
				<em title="Close" @click="$emit('close')" class="rmv-ico ti-close rnd DAJ p-intial" style="top: 10px;"></em>
			</div>
			<div class="popUpContentWraper">
				<div class="DFA">
					<div class="detailTab popUpTab" :class="[tabIndex == 0 ? 'active' : '' ]" @click="onChangeTabIndex(0);">
						<label class="ftsb clrblck DIB mb-0 c-point">Basic Details</label> 
						<span class="infotxt  ml-5 lngtip tooltip tipher pl-10">
							<span class="hovtooltip wht-nwrp">Enter the dashboard title and description.</span>
						</span>
					</div>
					<div v-if="model.id" class="sharingTab popUpTab"  :class="[tabIndex == 1 ? 'active' : '' ]" @click="onChangeTabIndex(1);">
						<label class="ftsb clrblck DIB mb-0  c-point">Sharing</label> 
						<span class="infotxt  ml-5 lngtip tooltip tipher pl-10">
							<span class="hovtooltip wht-nwrp">Tag team members to share this dashboard.</span>
						</span>
					</div>
				</div>
				<div class="tabContent tab1 mb-70"  v-if="tabIndex == 0" >
					<div class="pd-20 ">
						<div class="mb-20">
							<label class="ftsb">Enter Dashboard Title </label> 
							<input maxlength="255" name="Enter Name" class="txsrch filterinput mr-10 rds4" :class="[modelErrors.name ? 'red' : '' ]"  placeholder="Type Name of Your Dashboard …" v-model="model.name" type="text" :disable="!dashboardActionAllowed(model.myRole, 'EditDashboard')" />
						</div>
						<div class="mb-20">
							<label class="ftsb">Enter Description </label>
							<input maxlength="255" name="Enter Name" class="txsrch filterinput mr-10 rds4"  placeholder="Type description of this Dashboard …" v-model="model.description" type="text" :disable="!dashboardActionAllowed(model.myRole, 'EditDashboard')"/>
						</div>
						<div class="mb-20">
							<label class="ftsb">Collection Association </label>
							<treeselect
								  :multiple="true"
								  :options="workSpacesList"
								  :flat="true"
								  placeholder="Search Parent Collections"
								  v-model="model.linkedWorkSpaces"
								  no-children-text="No Sub Level"
								  />	
						</div>
						<div class="mb-20 cssHide">
							<label class="ftsb">Solution Board Association </label>
							<treeselect
								  :multiple="true"
								  :options="soltionBoardsList"
								  :flat="true"
								  placeholder="Search Soltion Boards"
								  v-model="model.linkedSolutonBoards"
								  />
						</div>
					</div>
					<div class="rec btn">
						 <button v-if="dashboardActionAllowed(model.myRole, 'EditDashboard')" type="button" class="button FR rds4" :class="[ dashboardActionAllowed(model.myRole, 'EditDashboard') ? '' : 'disabled' ]" @click="onClickSaveDashboard()">Save Dashboard</button> 
					</div>	
				</div>
				<div class="tabContent tab2 mb-70a" v-if="tabIndex == 1" >
					<div class="pd-20">
					    <!--	<div :class="[publicShare.value == 'p_url_p' ? '' : 'mb-20']">
							<label>Public Access Type</label>
							<div class="selectcont">
								<select title="" class="rds4" :value="publicShare.value" @change="onPublicShareSelectValue">
									<option value="-1">None</option>
									<option value="p_url_p">Public URL with password</option>
								</select>
							</div>
							<div class="DF JE">
								<button class="mt-10 rds4" v-if="publicShare.value == 'p_url_p'" @click="onPublicShareCopyUrl">Copy Link To Share</button>
							</div>
						</div> -->
						<div class="rec lblm custom-checkbox">
							<input id="roleForAll" type="checkbox" v-model="model.sharedWithAll" @change="onChangePermision"/>
							<label for="roleForAll" class="mn" id="icttp-edtBrddp">Allow access to all users in your Organization (read-only)</label>
							<span class="infotxt  ml-5 lngtip tooltip tipher pl-10">
								<span class="hovtooltip tprht wdt35">Makes this dashboard visible to all users in your account (read-only). Not shared outside your Organization.</span>
							</span>
						</div>
						<div>
							<label>Share With Kendis Users</label>
							<div class="p-rel">
								<input class="rds4" v-if="dashboardActionAllowed(model.myRole, 'EditRoles')" maxlength="255" name="SearchUsers"  placeholder="Search User Or Groups..." v-model="kendisUsers.searchText" type="text" @input="onKendisUserSearchInput"/>
								<vuepopup v-if="kendisUsers.showSearch" @close="kendisUsers.showSearch = false;" class="drop_boxa scrollBar">
									<div v-for="item in kendisUsers.searchResult" @click="onKendisUserSelectUserOrGroup(item);" class="pd-10">
										<div v-if="item.email" class="DFA">
											<div class="pic mr-10">
												<template v-if="profilePic(item)">
													<img class="pin" :src="profilePic(item)" alt='' width='80px' height='80px'/>	
												</template>
												<template v-else>
													<div class="initial" :style="{'background-color': item.backgroundColor}">{{userInitials(item)}}</div>
												</template>
											</div>
											<label class="mb-0">{{item.fullName}}</label>
										</div>
										<div v-else class="DFA">
											<div class="mr-10">
												<img src="/assets/icons/group-role.svg" alt=".." class="mr-5">
											</div>
											<label class="mb-0">{{item.title}}</label>
										</div>
									</div>
								</vuepopup>
							</div>
							<div class="mt-15">
								<div v-for="accessRole in kendisUsers.accessRoles" class="DFCB">
									<div v-if="accessRole.user" class="DFA mb-10">
										<div class="pic mr-10">
											<template v-if="profilePic(accessRole.user)">
												<img class="" :src="profilePic(accessRole.user)" alt=''/>
											</template>
											<template v-else>
												<div class="initial" :style="{'background-color': accessRole.user.backgroundColor}">{{userInitials(accessRole.user)}}</div>
											</template>
										</div>
										<label class="mb-0">{{accessRole.user.fullName}}</label>
									</div>
									<div v-else class="DFA mb-10">
										<div class="mr-10">
											<img src="/assets/icons/group-role.svg" alt=".." class="">
										</div>
										<label class="mb-0">{{accessRole.group.title}}</label>
									</div>
									<div class="DFA p-rel">
										<div class="mr-30 ftsb c-point" style="color: #5C697C;" @click="kendisUsers.editRolePopup = accessRole.id;">
											{{accessRole.role}}
											<em class="ti-angle-down fs-10"></em>
										</div>
										<vuepopup v-if="kendisUsers.editRolePopup == accessRole.id" @close="kendisUsers.editRolePopup = undefined;">
										<div class="drop_box" style="display:block; left: 0; top: 5px; border-radius: 4px;">
											<div class="c-point" @click="onKendisUserUpdateAccessRole(accessRole, 'Editor');" style="padding:5px 10px;">Editor</div>
											<div class="c-point" @click="onKendisUserUpdateAccessRole(accessRole, 'Viewer');" style="padding:5px 10px;">Viewer</div>
										</div>
										</vuepopup>
										<div v-if="dashboardActionAllowed(model.myRole, 'EditRoles')" @click="onKendisUserRemoveAccessRole(accessRole);" class="ti-close itemRemoveIcon DAJ c-point"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	`,
	props: ["dashboard","dashindex"],
	mixins:[rightsMixin],
    components: {
		'treeselect': VueTreeselect.Treeselect
	},
    data(){
        return {
            dashboardName: '',
            dashboardDescription:'',
            dashboardKey:'',
            loader: {
				show: false,
				text:""	
			},
            
            model: {
				id: undefined,
				name: "",
				description:"",
				key:"",
				linkedWorkSpaces:[],
				linkedSolutonBoards:[],
				sharedWithAll : false
			},
			workSpacesList : [],
			soltionBoardsList : [],
			modelErrors: {
				name: false
			},
            tabIndex : 0,
            
            kendisUsers: {
				searchText:"",
				showSearch: true,
				searchResult: [],
				
				accessRoles: [],
				cancelToken: undefined,
				
				editRolePopup: undefined,
			},
			addKendisUserPopup: {
				showRolePopup: false,
				userOrGroup: undefined,
				role: ""
			},
			publicShare: {
				value: "-1" 
			}
        }
    },
    computed : {
		popupTitle: function (){
			if (this.model.id) {
				return "Edit Dashboard";
			}
			else {
				return "Create Dashboard";
			}
		},
		profilePic: function() {
			return function(user) {
				if (user.picturePath) {
					return s3_resource_url + user.picturePath;
				} else {
					return undefined;
				}
			};
		},
		userInitials: function() {
			return function(user) {
				var initials = "";
				if (!_.isEmpty(user.firstName)) {
					initials += user.firstName.substring(0, 1);
				}
				if (!_.isEmpty(user.lastName)) {
					initials += user.lastName.substring(0, 1);
				}
				return initials;
			};
		}
	},
    created(){
        if (this.dashboard) {
			if (this.dashboard.id) {
				this.model.id = this.dashboard.id;
				this.model.name = this.dashboard.name;
				this.model.description = this.dashboard.description;
				this.model.key = this.dashboard.key;
				this.model.publicLink = this.dashboard.publicLink;
				this.model.myRole = this.dashboard.myRole;
				this.model.sharedWithAll = this.dashboard.sharedWithAll;
				if (this.model.publicLink) {
					this.publicShare.value = "p_url_p";
				}
				else {
					this.publicShare.value = "-1";
				}
			}else {
				this.model.myRole = "Owner";
			}
		}else {
			this.model.myRole = "Owner";
		}
		
		this.fetchAllAssociations();
		if(this.dashindex && this.dashindex == 1) {
			this.onChangeTabIndex(this.dashindex);
		}
    },
    methods:{
		//////////////////////////////////////////
		//////     LOGIC
		validateSave: function () {
			if (this.model.name) {
				this.model.name = this.model.name.trim();
			}
			this.modelErrors.name = _.isEmpty(this.model.name);
			if (this.modelErrors.name) {
				return false;
			}
			return true;
		},
		//////////////////////////////////////////
		//////     API
		saveDashboard: function (dashboard) {
			
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
				axios.post('/dashboard/saveDashboard', dashboard)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let newDashboard = response.data.dashboard;
						if (!dashboard.id) {
							newDashboard.myRole  = "Owner";
							newDashboard.favorite = false;
							newDashboard.sharedWithMe = false;
							showTopMessage("Dashboard Created Successfully","success");
							
							_this.$emit('created', newDashboard);
						}
						else {
							showTopMessage("Dashboard Edited Successfully","success");
							_this.$emit('updated', newDashboard, true);
						}
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		fetchAccessRoles: function () {
			
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.get('/dashboard/getDashboardAccessRoles/'+ this.model.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						_this.kendisUsers.accessRoles = response.data.accessRoles;
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		addAccessRole: function (accessRole) {
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.post('/dashboard/createDashboardAccessRole', accessRole)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						if (!_this.kendisUsers.accessRoles) {
							_this.kendisUsers.accessRoles = [];
						}
						let accessRole = response.data.accessRole;
						_this.kendisUsers.accessRoles.push(accessRole);
						if (_this.kendisUsers.accessRoles.length > 0) {
							_this.dashboard.shared = true;
							_this.$emit('updated', _this.dashboard, false);
						}
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		updateAccessRole: function (accessRole) {
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.post('/dashboard/updateDashboardAccessRole', accessRole)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		removeAccessRole: function (accessRole) {
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.delete('/dashboard/deleteDashboardAccessRole/'+accessRole.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let index = _.findIndex(_this.kendisUsers.accessRoles, {id: accessRole.id});
						if (index > -1) {
							_this.kendisUsers.accessRoles.splice(index, 1);
						}
						if (_this.kendisUsers.accessRoles.length == 0) {
							_this.dashboard.shared = false;
							_this.$emit('updated', _this.dashboard, false);
						}
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		searchKendisUsersOrGroups: function () {
			
			let _this = this;
			
			_this.kendisUsers.searchResult = [];
			
			if (typeof this.kendisUsers.cancelToken != typeof undefined) {
				this.kendisUsers.cancelToken.cancel("Operation canceled due to new request.")
			}
			//Save the cancel token for the current request
			this.kendisUsers.cancelToken = axios.CancelToken.source();
			
			this.kendisUsers.showSearch = true;
			
			axios.get('/dashboard/searchUsersOrGroups/' + this.kendisUsers.searchText, {
				cancelToken: this.kendisUsers.cancelToken.token
			})
				.then(response => {
					if (response.data) {
						
						let duplicationCheckMap = {};
						_.each(_this.kendisUsers.accessRoles, ar=> {
							if (ar.user) {
								duplicationCheckMap[ar.user.id] = true;
							}
							else if (ar.group) {
								duplicationCheckMap[ar.group.id] = true;
							}
						});
						
						let groups = response.data.groups;
						let users = response.data.users;

						if (!_.isEmpty(groups)) {
							_.each(groups, group => {
								if (!duplicationCheckMap[group.id]) {
									_this.kendisUsers.searchResult.push(group);
								}
							});
						}
						if (!_.isEmpty(users)) {
							_.each(users, user => {
								if (!duplicationCheckMap[user.id]) {
									_this.kendisUsers.searchResult.push(user);
								}
							});
						}
					}
				}).catch(e => {

				});
		},
		createPublicLinkWithPassword: function (password) {
			
			let _this = this;
			
			let data = {};
			data.password = password;
			data.code = 0;
			data.dashboardId = this.model.id;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.post('/dashboard/createDashboardPublicLink',data)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						if (response.data.success) {
							_this.publicShare.value = "p_url_p";
							_this.model.publicLink = response.data.dashboard.publicLink;
							_this.dashboard.publicLink = response.data.dashboard.publicLink;
						}
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		removePublicLink: function () {	
					
			let _this = this;
			
			_this.loader.show = true;
			_this.loader.text = "";
			
			axios.get('/dashboard/removeDashboardPublicLink/'+this.model.id)
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						if (response.data.success) {
							_this.publicShare.value = "-1";
							_this.model.publicLink = undefined;
							_this.dashboard.publicLink = undefined;
						}
					}
				}).catch(e => {
					_this.loader.show = false;
				});
		},
		onChangePermision : function () {
			var _this = this;
			var data = {};
			data.id = this.model.id;
			data.flag = this.model.sharedWithAll;
			
			axios.post("/dashboard/updatePermissonForAll", data)
				.then(response => {
					if (response.data && response.data.success) {
						showTopMessage("Permission Update", 'success');
						_this.$emit("roleUpdate", _this.model.sharedWithAll);
					}
				}).catch(error => {
					console.error(error);
				});
		},
		//////////////////////////////////////////
		//////     EVENTS
        onClickSaveDashboard:function(){
            
            if (!this.dashboardActionAllowed(this.model.myRole, 'EditDashboard')) {
				showTopMessage("You are not allowed to Edit Dashboard","warning");
				return;
			}
            
			if (this.validateSave()) {
				let dashboardData = {
					name: this.model.name,
					description: this.model.description
				}
				if (this.model.id) {
					dashboardData.id = this.model.id;
				}
				dashboardData.solutionBoardIds = [];
				dashboardData.workSpaceKeys = [];
				if(this.model.linkedWorkSpaces){
					dashboardData.workSpaceKeys = this.model.linkedWorkSpaces;
				}
				if(this.model.linkedSolutonBoards){
					dashboardData.solutionBoardIds = this.model.linkedSolutonBoards;
				}
				if(dashboardData.id) {
					let _this = this;
					askFromSweetAlertWrapper('Do you want to update this dashboard?', [()=>{
						_this.saveDashboard(dashboardData);
					}], [takeNoAction]);
				}
				else{
					this.saveDashboard(dashboardData);
				}
			}
        },
        onChangeTabIndex: function (index) {
			if (this.model.id) {
				this.tabIndex = index;
				if (this.tabIndex == 1) {
					this.fetchAccessRoles();
				}	
			}
			else {
				if (index == 1) {
					
				}else {
					this.tabIndex = index;
				}
			}
		},
		//.............  kendis user share
		onKendisUserSearchInput: function () {
			if (this.kendisUsers.searchText && this.kendisUsers.searchText.length > 2) {
				this.searchKendisUsersOrGroups();
			}else {
				this.kendisUsers.searchResult = [];
			}
		},
		onKendisUserSearchClose: function () {
			this.kendisUsers.searchResult = [];
			this.kendisUsers.searchText = "";
			this.kendisUsers.showSearch = false;
		},
		
		onKendisUserUpdateAccessRole: function (accessRole, role) {
			this.kendisUsers.editRolePopup = undefined;
			if (accessRole.role !== role) {
				accessRole.role = role;
				this.updateAccessRole(accessRole);
			}
		},
		
		onKendisUserRemoveAccessRole: function (accessRole) {
			let _this = this;
			askFromSweetAlertWrapper('Do you want to remove this User / Group?', [()=>{
					_this.removeAccessRole(accessRole);
				}], [takeNoAction]);
		},
		
		onKendisUserAddUserOrGroup: function () {
			
			let accessRole = {dashboardId: this.model.id};
			if (this.addKendisUserPopup.userOrGroup) {
				if (this.addKendisUserPopup.userOrGroup.email) {
					accessRole.user = {id:this.addKendisUserPopup.userOrGroup.id};
				}else {
					accessRole.group = {id:this.addKendisUserPopup.userOrGroup.id};
				}
			}
			accessRole.role = this.addKendisUserPopup.role;
			this.addAccessRole(accessRole);
			this.onKendisUserCancelUserOrGroup();
		},
		onKendisUserSelectUserOrGroup: function (item) {
			this.addKendisUserPopup.userOrGroup = item;
			this.addKendisUserPopup.role = "Viewer";
			this.addKendisUserPopup.showRolePopup = true;
			this.onKendisUserSearchClose();
		},
		onKendisUserCancelUserOrGroup: function () {
			this.addKendisUserPopup.userOrGroup = undefined;
			this.addKendisUserPopup.showRolePopup = false;
		},
		//..........  public share
		onPublicShareSelectValue: function (event) {
			
			if (!this.dashboardActionAllowed(this.model.myRole, 'ShareDashboard')) {
				showTopMessage("You are not allowed to Share Dashboard","warning");
				return;
			}
			
			let value = event.target.value;

			if (value == "-1") {
				this.removePublicLink();
			}
			else if (value == "p_url_p") {
				this.createPublicLinkWithPassword("");
			}
		},
		onPublicShareCopyUrl: function () {
			
		},
		
		fetchAllAssociations: function () {
            let _this = this;
            let data = {};
            data.fetchTypes = false;
            data.fetchArchived = true;
            delete _this.$parent.$options.associations;
            if(_this.$parent.$options.associations){
				_this.loadAssociationsOptions(_this.$parent.$options.associations);
			}else{
				if(this.dashboard && this.dashboard.id && this.dashboard.workSpaceKeys){
						data.workSpaceKeys = this.dashboard.workSpaceKeys;
				}
	            axios.post("/dashboard/fetch-all-release-trains?soltionBoards=true", data)
	                .then(response => {
	                    if (response.data) {
							_this.$parent.$options.associations = {};
							_this.$parent.$options.associations.workSpacesList = response.data.releaseTrains;
							_this.$parent.$options.associations.soltionBoardsList = response.data.soltionBoards;
							_this.loadAssociationsOptions(_this.$parent.$options.associations);
	                    }
	                }).catch(error => {
	                console.error(error);
	            });
			}
        },
        loadAssociationsOptions : function(meta){
			let _this = this;
			let archived = false;
			let mapWsKeys = {};
			let mapSolIds = {};
			_this.workSpacesList = [{id: '-', label: 'Global', children: []}];//meta.workSpacesList;
			_this.soltionBoardsList = [];//meta.soltionBoardsList;
            _this.model.linkedWorkSpaces = [];
			_this.model.linkedSolutonBoards =[];
			
			if(this.dashboard && this.dashboard.id){
				if(this.dashboard.workSpaceKeys){
					_this.model.linkedWorkSpaces = this.dashboard.workSpaceKeys;
					mapWsKeys = _.keyBy(this.dashboard.workSpaceKeys);
				}
	            if(this.dashboard.solutionBoardIds){
					_this.model.linkedSolutonBoards = this.dashboard.solutionBoardIds;
					mapSolIds = _.keyBy(this.dashboard.solutionBoardIds);
				}
				archived = true;
			}else{
				if(window.location.pathname == '/org'){
					let params = _this.$route.fullPath.split('/');
					if(params && params[2]){
						_this.model.linkedWorkSpaces.push(params[2]);
					}
				}else if(window.location.pathname == '/solutions' && vueInstance && vueInstance.activeSolutionId){
					_this.model.linkedSolutonBoards.push(vueInstance.activeSolutionId);
				}	
			}
			
            if(meta.workSpacesList){
				let workspaceMap = {};
				_.each(meta.workSpacesList, opt => {
					if(_.isEmpty(workspaceMap[opt.id])) {
						workspaceMap[opt.id] = {id: opt.key, label: opt.title+(opt.rowStatus == 1 ? ' (Archived)':''), children: []};
					}
				})
	
				_.each(meta.workSpacesList, opt => {
					if(opt.modules != undefined){
						if(opt.rowStatus == 0 || (archived && mapWsKeys[opt.key])){
							if(opt.linkedWorkSpaces && opt.linkedWorkSpaces.length > 0) {
								_.each(opt.linkedWorkSpaces, linkedWorkSpaceId => {
									if(linkedWorkSpaceId){
										let parent = workspaceMap[linkedWorkSpaceId];
										parent.children.push(workspaceMap[opt.id]);
									}
			
								});
							} else {
								_this.workSpacesList.push(workspaceMap[opt.id]);
							}
							delete mapWsKeys[opt.key];
						}
					}
				});
			}
			if(meta.soltionBoardsList){
	            _.each(meta.soltionBoardsList, opt => {
					if(opt.rowStatus == 0 || (archived && mapSolIds[opt.id])){
						_this.soltionBoardsList.push({id: opt.id, label: opt.title+(opt.rowStatus == 1 ? ' (Archived)':''), children: null});
						delete mapSolIds[opt.id];
					}
				});
			}
			if(!_.isEmpty(mapSolIds)){
				_.each(mapSolIds, val => {
					let indx = _.indexOf(_this.model.linkedSolutonBoards,val);
					if (indx > -1) {
						_this.model.linkedSolutonBoards.splice(indx, 1);
					}
				});
			}
		}
    },
})









