const CONFIG_LISTING = 
{
	name: "configuration-listing",
	template:
	`
	<div class="config-listing admnew">
	     <div class="main-head DFCB">
	     	<span class="mnhd DFA"><em class="config-ico DIB mr-15"></em> Manage Risk Connections <span class="infotxt tooltip mht ml-10"><span class="hovtooltipB lft">View or edit your Azure DevOps risk connections.</span></span></span> 
	     	<a href="javascript:void(0);" class="create button FR rnd4" @click="onClickCreateConfig">New Connection</a>
	     </div>
	     
	     <configuration-popup v-if="configPopup.show"
	     	:config="configPopup.config"
	     	@close="onConfigPopupClose"
	     	@created="onConfigPopupCreated"
	     	@updated="onConfigPopupUpdated"
	     />
	     
	     <ul class="maintabs grn mt-20">
     		<li class="tabgenrl ftsb active">For Azure DevOps</li>
     	</ul>
	     	
	     <div class="section">
			<ul id="roles" class="table risk mb-20 mt-0">
				<li class="rec hd">
					<div class="rc c1">Connection Name</div>
					<div class="rc c1">ALM Account Name</div>
					<div class="rc c1">Created By</div>
				</li>
				<li v-for="configration in configrations" class="rec">
					<div class="rc c1">
						<a href="javascript:void(0);" @click="onClickOpenConfig(configration);">{{configration.title}} <em class="ti-pencil edic DIB ml-10" title="Edit Configuration"></em></a>
					</div>
					<div v-if="configration.almAccount" class="rc c1">{{configration.almAccount.name}}</div>
					<div class="rc c1">{{configration.createdBy}}</div>
					
					<!-- <div class="r-icons mnuout" style="top: 11px;">
						<div class="ti-menu mnu"></div> 
						<div class="drop_box nwmu artp stngar" style="">
							<ul id="settingsList" class="list">
								<li class="adwsmenu DFA" @click="onClickOpenConfig(configration);"><em class="ti-pencil ico FL mr-10"></em> Edit</li> 
								<li class="adwsmenu DFA"><em class="ti-trash ico FL mr-10"></em>Delete</li>
							</ul>
						</div>
					</div> -->
				</li>
				<li v-if="configrations.length == 0" class="nofound fs-14">No configuration found</li>
			</ul>
		</div>
	</div>
	`,
	props: [],
	data() {
		return {
			
			loader: {
				show: false,
				text: ""
			},
			
			configrations: [],
			
			configPopup: {
				show: false,
				config : {}
			}
		}
	},
	components: {
		"configuration-popup" : CONFIG_POPUP
	},
	created() {
		this.loadAllConfigs();
	},
	mounted() {

	},
	computed: {

	},
	methods: {
		///////////////////////////////////////////
		/////////    LOGIC
		copyConfigAttributes: function(original, newCopy) {

			original.title = newCopy.title;
			original.almAccount = newCopy.almAccount;

			original.tfsProjectId = newCopy.tfsProjectId;
			original.tfsProjectTfsId = newCopy.tfsProjectTfsId;
			original.tfsProjectName = newCopy.tfsProjectName;

			original.riskItemType = newCopy.riskItemType;
			original.riskItemTypeName = newCopy.riskItemTypeName;

			original.riskLinkType = newCopy.riskLinkType;
			original.riskFieldsMappings = newCopy.riskFieldsMappings;
			original.riskCsutomFieldsMappings = newCopy.riskCsutomFieldsMappings;
		},
		///////////////////////////////////////////
		/////////    API
		loadAllConfigs: function () {
			
			let _this = this;
			
			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.get("/configAndMapping/loadConfigs")
				.then(response => {
					_this.loader.show = false;
					if (response.data) {
						let configs = response.data.configs;
						_this.configrations = configs;
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
		},
		///////////////////////////////////////////
		/////////    EVENTS
		onClickCreateConfig: function () {
			this.configPopup.config = {};
			this.configPopup.show = true;
		},
		onClickOpenConfig: function (config) {
			this.configPopup.config = config;
			this.configPopup.show = true;
		},
		//.....   config popup
		onConfigPopupClose: function () {
			this.configPopup.config = {};
			this.configPopup.show = false;
		},
		onConfigPopupCreated: function (newConfig, close) {
			this.configrations.push(newConfig);
			if (close) {
				this.onConfigPopupClose();
			}
		},
		onConfigPopupUpdated: function (newConfig, close) {
			
			let orgCopy = _.find(this.configrations, {id: newConfig.id});
			if (orgCopy) {
				this.copyConfigAttributes(orgCopy, newConfig);
			}
			if (close) {
				this.onConfigPopupClose();
			}
		}
	}
};