/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.viztrend.safe.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoExpiringSession;
import org.springframework.util.Assert;

public class JdkMongoSessionConverter
extends AbstractMongoSessionConverter {
    private static final String ID = "_id";
    private static final String CREATION_TIME = "created";
    private static final String LAST_ACCESSED_TIME = "accessed";
    private static final String MAX_INTERVAL = "interval";
    static final String ATTRIBUTES = "attr";
    private static final String PRINCIPAL_FIELD_NAME = "principal";
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkMongoSessionConverter.class);

    public JdkMongoSessionConverter() {
        this((Converter)new SerializingConverter(), (Converter)new DeserializingConverter());
    }

    public JdkMongoSessionConverter(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer) {
        Assert.notNull(serializer, (String)"serializer cannot be null");
        Assert.notNull(deserializer, (String)"deserializer cannot be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public Query getQueryForIndex(String indexName, Object indexValue) {
        if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Query.query((CriteriaDefinition)Criteria.where((String)PRINCIPAL_FIELD_NAME).is(indexValue));
        }
        return null;
    }

    protected DBObject convert(MongoExpiringSession session) {
        BasicDBObject basicDBObject = null;
        try {
            basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)ID, (Object)session.getId());
            basicDBObject.put((Object)CREATION_TIME, (Object)session.getCreationTime());
            basicDBObject.put((Object)LAST_ACCESSED_TIME, (Object)session.getLastAccessedTime());
            basicDBObject.put((Object)MAX_INTERVAL, (Object)session.getMaxInactiveIntervalInSeconds());
            basicDBObject.put((Object)PRINCIPAL_FIELD_NAME, (Object)this.extractPrincipal((Session)session));
            basicDBObject.put((Object)"expireAt", (Object)session.getExpireAt());
            basicDBObject.put((Object)ATTRIBUTES, (Object)this.serializeAttributes((Session)session));
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return basicDBObject;
    }

    protected MongoExpiringSession convert(DBObject sessionWrapper) {
        MongoExpiringSession session = null;
        try {
            session = new MongoExpiringSession((String)sessionWrapper.get(ID), ((Integer)sessionWrapper.get(MAX_INTERVAL)).intValue());
            session.setCreationTime(((Long)sessionWrapper.get(CREATION_TIME)).longValue());
            session.setLastAccessedTime(((Long)sessionWrapper.get(LAST_ACCESSED_TIME)).longValue());
            session.setExpireAt((Date)sessionWrapper.get("expireAt"));
            this.deserializeAttributes(sessionWrapper, (Session)session);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return session;
    }

    private byte[] serializeAttributes(Session session) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String attrName : session.getAttributeNames()) {
            attributes.put(attrName, session.getAttribute(attrName));
        }
        return this.mapToBytes(attributes);
    }

    private void deserializeAttributes(DBObject sessionWrapper, Session session) throws Exception {
        byte[] attributesBytes = (byte[])sessionWrapper.get(ATTRIBUTES);
        if (attributesBytes != null) {
            Map attributes = this.bytesToMap(attributesBytes);
            for (Map.Entry entry : attributes.entrySet()) {
                session.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> bytesToMap(byte[] byteArr) throws Exception {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteArr);
        try {
            Map data2;
            ObjectInputStream in = new ObjectInputStream(byteIn);
            Map map = data2 = (Map)in.readObject();
            return map;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        finally {
            try {
                byteIn.close();
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] mapToBytes(Map<String, Object> attributes) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(attributes);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        finally {
            try {
                byteOut.close();
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }
}

