/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleMongoRepository<T, ID extends Serializable>
implements MongoRepository<T, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public SimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        Assert.notNull(metadata, (String)"MongoEntityInformation must not be null!");
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        } else {
            this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
        }
        return entity;
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List result = SimpleMongoRepository.convertIterableToList(entities);
        boolean allNew = true;
        for (Object entity : entities) {
            if (!allNew || this.entityInformation.isNew(entity)) continue;
            allNew = false;
        }
        if (allNew) {
            this.mongoOperations.insertAll((Collection)result);
        } else {
            for (Object entity : result) {
                this.save(entity);
            }
        }
        return result;
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"id").is(id));
        List objs = this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        if (objs != null && objs.size() > 0) {
            return (T)this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()).get(0);
        }
        return null;
    }

    private Query getIdQuery(Object id) {
        return new Query((CriteriaDefinition)this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where((String)this.entityInformation.getIdAttribute()).is(id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mongoOperations.exists(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public long count() {
        return this.mongoOperations.getCollection(this.entityInformation.getCollectionName()).count();
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.mongoOperations.remove(this.getIdQuery(id), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        this.delete(this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.mongoOperations.remove(new Query(), this.entityInformation.getCollectionName());
    }

    public List<T> findAll() {
        return this.findAll(new Query());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        HashSet<Serializable> parameters = new HashSet<Serializable>(SimpleMongoRepository.tryDetermineRealSizeOrReturn(ids, (int)10));
        for (Serializable id : ids) {
            parameters.add(id);
        }
        return this.findAll(new Query((CriteriaDefinition)new Criteria(this.entityInformation.getIdAttribute()).in(parameters)));
    }

    public Page<T> findAll(Pageable pageable) {
        Long count = this.count();
        List list = this.findAll(new Query().with(pageable));
        return new PageImpl(list, pageable, count.longValue());
    }

    public List<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        return entity;
    }

    public <S extends T> List<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        List list = SimpleMongoRepository.convertIterableToList(entities);
        if (list.isEmpty()) {
            return list;
        }
        this.mongoOperations.insertAll((Collection)list);
        return list;
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example)).with(pageable);
        List list = this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, (PageableExecutionUtils.TotalSupplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        if (sort != null) {
            q.with(sort);
        }
        return this.mongoOperations.find(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> List<S> findAll(Example<S> example) {
        return this.findAll(example, (Sort)null);
    }

    public <S extends T> S findOne(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return (S)this.mongoOperations.findOne(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> long count(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return this.mongoOperations.count(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> boolean exists(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null!");
        Query q = new Query((CriteriaDefinition)new Criteria().alike(example));
        return this.mongoOperations.exists(q, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    private List<T> findAll(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    private static <T> List<T> convertIterableToList(Iterable<T> entities) {
        if (entities instanceof List) {
            return (List)entities;
        }
        int capacity = SimpleMongoRepository.tryDetermineRealSizeOrReturn(entities, (int)10);
        if (capacity == 0 || entities == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(capacity);
        for (T entity : entities) {
            list.add(entity);
        }
        return list;
    }

    private static int tryDetermineRealSizeOrReturn(Iterable<?> iterable, int defaultSize) {
        return iterable == null ? 0 : (iterable instanceof Collection ? ((Collection)iterable).size() : defaultSize);
    }

    static /* synthetic */ MongoEntityInformation access$000(SimpleMongoRepository x0) {
        return x0.entityInformation;
    }

    static /* synthetic */ MongoOperations access$100(SimpleMongoRepository x0) {
        return x0.mongoOperations;
    }
}

