/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.JiraWebhookMappedData;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.WebhookActivityRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.WebhookActivityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookActivityUtil {
    private static final long serialVersionUID = -6641401147537865131L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookActivityUtil.class);
    private static final Logger LOGGER_WH_HEALTH = LoggerFactory.getLogger((String)"wh_health");
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_TITLE = "jira:issue_updated,summary";
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_STATUS = "jira:issue_updated,status";
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_STORY_POINTS = "jira:issue_updated,Story Points";
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_DUE_DATE = "jira:issue_updated,duedate";
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_START_DATE = "jira:issue_updated,startDate";
    private static final String JIRA_ISSUE_UPDATE_EVENT_FOR_END_DATE = "jira:issue_updated,endDate";
    private static final String JIRA_ISSUE_UPDATED_SPRINT_CHANGE = "jira:issue_updated,Sprint";
    private static WebhookActivityUtil instance;
    List<InstructionNode> allJiraInstructions;
    List<Boolean> visitedNodes;
    Map<String, List<String>> errorLogBufferAgainstNodeId;
    private String jiraIssueUpdateEventType;
    private ItemJiraFieldMap sharedSprintField;
    private boolean isSharedSprintUpdated = false;
    private List<String> causedReasons;
    private List<String> logs;
    private int lastErrorNodeIndex;
    private Map<String, InstructionNode> instructionMapAgainstEventType;
    private Map<String, Boolean> conditionChecker;
    private List<Item> fetchedItemList;
    private Map<String, String> tfsErrorLookup;
    private Set<String> tfsFailedFields;
    private String tfsId;
    private Set<String> tfsCausedReasons;

    private WebhookActivityUtil() {
        Gson gson = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.allJiraInstructions = (List)gson.fromJson("[{\"id\":0,\"log\":\"Found items against webhook Jira IDs.\",\"causedBy\":[\"No Jira items against webhook Jira IDs.\"],\"childNodes\":null},{\"id\":1,\"log\":\"Alm configurations found against alm account.\",\"causedBy\":[\"No Alm configurations found against alm account.\"],\"childNodes\":null},{\"id\":2,\"log\":\"Both story point and due date field found, continuing processing.\",\"causedBy\":[\"Both story point and-or due date field missing.\"],\"childNodes\":null},{\"id\":3,\"log\":\"Session board IDs found, continuing processing.\",\"causedBy\":[\"Session board IDs not found.\"],\"childNodes\":null},{\"id\":4,\"log\":\"Handling event for jira issue updated.\",\"causedBy\":[\"Error in handling event for jira:issue_updated.\"],\"childNodes\":null},{\"id\":5,\"log\":\"Getting change log from webhook.\",\"causedBy\":[\"No change log found for webhook.\"],\"childNodes\":null},{\"id\":6,\"log\":\"Enabling check for issue updated event.\",\"causedBy\":[\"Error in enabling check for issue updated event.\"],\"childNodes\":null},{\"id\":7,\"log\":\"Finding items for update event using Jira ID and user info.\",\"causedBy\":[\"No items found for update event using jira id and user info.\"],\"childNodes\":null},{\"id\":8,\"log\":\"Items found to settle for update event.\",\"causedBy\":[\"No Items found to settle for update event.\"],\"childNodes\":null},{\"id\":9,\"log\":\"Handling update event for item.\",\"isLoopNode\":true,\"causedBy\":[\"Error in handling update event for item.\"],\"childNodes\":null},{\"id\":10,\"log\":\"Verifying change log in webhook.\",\"causedBy\":[\"Could not verify change log in webhook, please try again.\"],\"childNodes\":null},{\"id\":11,\"log\":\"Processing change log in webhook.\",\"causedBy\":[\"Error in processing change log in webhook, please try again.\"],\"childNodes\":null},{\"id\":12,\"log\":\"Processing item update for summary.\",\"causedBy\":[\"Error in processing item update for summary, please try again.\"],\"childNodes\":null},{\"id\":13,\"log\":\"Processing item update for target dependencies meta.\",\"causedBy\":[\"Could not successfully process item update for target dependencies meta.\"],\"childNodes\":null},{\"id\":14,\"log\":\"Item saved successfully.\",\"causedBy\":[\"Error in saving item, please try again.\"],\"childNodes\":null},{\"id\":15,\"log\":\"Completed processing for update event.\",\"causedBy\":[\"Unable to complete processing for update event.\"],\"childNodes\":null},{\"id\":16,\"log\":\"Processing item for status change.\",\"causedBy\":[\"Error in processing item update for status, please try again.\"],\"childNodes\":null},{\"id\":17,\"log\":\"Getting issue type id, project key and status id to retrieve valid status.\",\"causedBy\":[\"Error in getting issue type id, project key and status id.\"],\"childNodes\":null},{\"id\":18,\"log\":\"Getting associated session ID.\",\"causedBy\":[\"Could not find associated session ID.\"],\"childNodes\":null},{\"id\":19,\"log\":\"Retrieving status from database using issue type, project key and status id.\",\"causedBy\":[\"Error in retrieving status from given parameters.\"],\"childNodes\":null},{\"id\":20,\"log\":\"Valid status retrieved against parameters.\",\"causedBy\":[\"Invalid status found, please try again.\"],\"childNodes\":null},{\"id\":21,\"log\":\"Processing item for story point field.\",\"causedBy\":[\"An error occurred in handling event for story point field.\"],\"childNodes\":null},{\"id\":22,\"log\":\"Setting incoming story points in item.\",\"causedBy\":[\"Could not set story points in item.\"],\"childNodes\":null},{\"id\":23,\"log\":\"Successfully found field ID mapped with alm account against field id present in change logs for due date.\",\"causedBy\":[\"Invalid mapping found against due date, please verify mapping for this field on your alm account.\"],\"childNodes\":null},{\"id\":24,\"log\":\"Processing item for due date update.\",\"causedBy\":[\"Error in processing item update for due date, please try again.\"],\"childNodes\":null},{\"id\":25,\"log\":\"Verifying field mapping and setting new due date in item.\",\"causedBy\":[\"Invalid or no mapping found against due date, please verify mapping for this field.\"],\"childNodes\":null},{\"id\":26,\"log\":\"Finding items to be processed for issuelink_deleted event using source and destination id.\",\"causedBy\":[\"Error in finding items to be processed.\"],\"childNodes\":null},{\"id\":27,\"log\":\"Checking for handle jira dependency flow for jira event.\",\"causedBy\":[\"An error occurred in checking for handle jira dependency flow or jira event.\"],\"isLoopNode\":true,\"childNodes\":null},{\"id\":28,\"log\":\"Item type verified as USER STORY.\",\"causedBy\":[\"Item type is not USER STORY, skipping link deletion.\"],\"childNodes\":null},{\"id\":29,\"log\":\"Getting destination jira ID for item.\",\"causedBy\":[\"An error occurred in getting destination jira ID for item.\"],\"childNodes\":null},{\"id\":30,\"log\":\"Successfully found destination jira id.\",\"causedBy\":[\"No destination jira id found for item.\"],\"childNodes\":null},{\"id\":31,\"log\":\"System link found for item.\",\"causedBy\":null,\"childNodes\":null},{\"id\":32,\"log\":\"Getting jira destination issue and epic field using destination id.\",\"causedBy\":null,\"childNodes\":null},{\"id\":33,\"log\":\"Epic field jira id exists in jira destination issue mapping for jira ids.\",\"causedBy\":null,\"childNodes\":null},{\"id\":34,\"log\":\"Getting parent epic key using jira destination issue.\",\"causedBy\":null,\"childNodes\":null},{\"id\":35,\"log\":\"Parent epic key found, getting Jira Parent Epic using parent epic key.\",\"causedBy\":null,\"childNodes\":null},{\"id\":36,\"log\":\"Source issue Jira ID is same as Parent Epic Jira ID, returning without updating link.\",\"isFailure\":true,\"causedBy\":[\"Source issue Jira ID is same as Parent Epic Jira ID, returning without updating link.\"],\"childNodes\":null},{\"id\":37,\"log\":\"Fetched items using destination Jira ID.\",\"causedBy\":[\"Error occurred in fetching items using Jira Destination ID.\"],\"childNodes\":null},{\"id\":38,\"log\":\"Existing items found using destination Jira ID, continuing processing.\",\"causedBy\":[\"No existing items found using destination Jira ID.\"],\"childNodes\":null},{\"id\":39,\"log\":\"Items processed for link deletion.\",\"causedBy\":[\"An error occurred in processing issue for link deletion, please try again.\"],\"childNodes\":null},{\"id\":40,\"log\":\"Processing jira dependencies for issue link event.\",\"causedBy\":[\"Could not process jira depedencies for issue link event, please try again.\"],\"childNodes\":null},{\"id\":41,\"log\":\"Completed processing for item jira dependency link deletion.\",\"causedBy\":[\"Could not successfully save and update parent item with new item links.\"],\"childNodes\":null},{\"id\":42,\"log\":\"Handling item link dependencies for jira item.\",\"causedBy\":null,\"childNodes\":null},{\"id\":43,\"log\":\"Item links found to be processed with jira dependency list, removing alm link IDs.\",\"causedBy\":[\"No items found to be processed with jira dependency list.\"],\"childNodes\":null},{\"id\":44,\"log\":\"Finding items to be processed for issuelink_created event using source and destination id.\",\"causedBy\":[\"Error in finding items to be processed.\"],\"childNodes\":null},{\"id\":45,\"log\":\"Item type verified as FEATURE.\",\"causedBy\":[\"Item type is not FEATURE, skipping link creation.\"],\"childNodes\":null},{\"id\":46,\"log\":\"Item link types found and item jira filters are missing, continuing getting destination id using item link types.\",\"causedBy\":[\"Error in getting destination id using item link types.\"],\"childNodes\":null},{\"id\":47,\"log\":\"Processing to retrieve destination jira id.\",\"causedBy\":[\"Could not begin process for retrieving destination jira id. This may be due to parent link types not being present or no jira filter for item.\"],\"childNodes\":null},{\"id\":48,\"log\":\"Items settled with other parent case.\",\"causedBy\":[\"Error occurred in processing items with other parent case.\"],\"childNodes\":null},{\"id\":49,\"log\":\"Getting alm config from item.\",\"causedBy\":[\"Could not find alm config from item.\"],\"childNodes\":null},{\"id\":50,\"log\":\"Jira filter exists for item, continuing to check feature filter from alm config.\",\"causedBy\":[\"No jira filter exists for item.\"],\"childNodes\":null},{\"id\":51,\"log\":\"Feature link mappings found from filter using alm config.\",\"causedBy\":[\"No feature link mappings found from filter using alm config.\"],\"childNodes\":null},{\"id\":52,\"log\":\"Item project key matches link mapping project key.\",\"causedBy\":[\"Item project key does not match link mapping project key.\"],\"childNodes\":null},{\"id\":53,\"log\":\"Successfully retrieved link types from link mappings.\",\"causedBy\":[\"No link types found from link mappings.\"],\"childNodes\":null},{\"id\":54,\"log\":\"Feature filter mappings found from alm config.\",\"causedBy\":[\"No feature filter mappings found from alm config.\"],\"childNodes\":null},{\"id\":55,\"log\":\"No existing items found, using destination jira id for further processing.\",\"causedBy\":[\"Unable to use destination jira id for further processing.\"],\"childNodes\":null},{\"id\":56,\"log\":\"Changing sprint for item.\",\"causedBy\":[\"Cannot change sprint for parent item.\"],\"childNodes\":null},{\"id\":57,\"log\":\"Successfully updated parent item.\",\"causedBy\":[\"No update occurred in parent item with child item.\"],\"childNodes\":null},{\"id\":58,\"log\":\"No Jira dependencies fetched against board id.\",\"causedBy\":[\"Jira dependencies already fetched against board id.\"],\"childNodes\":null},{\"id\":59,\"log\":\"Using jira ids from items to fetch parent items.\",\"causedBy\":[\"No jira ids found against items, please try again.\"],\"childNodes\":null},{\"id\":60,\"log\":\"Found parent items using session board id and jira ids from webhook.\",\"causedBy\":[\"No parent items found using session board id and jira ids from webhook.\"],\"childNodes\":null},{\"id\":61,\"log\":\"Paged jira data retrieved against jira ids provided in webhook.\",\"causedBy\":[\"No data retrieved using jira ids from webhook.\"],\"childNodes\":null},{\"id\":62,\"log\":\"Issue links are present in jira data retrieved from filter.\",\"causedBy\":[\"No issue link found in data retrieved from filter.\"],\"childNodes\":null},{\"id\":63,\"log\":\"Issue link type id matched against dependency link type id.\",\"causedBy\":[\"Issue link type id did not match against dependency link type id.\"],\"childNodes\":null},{\"id\":64,\"log\":\"Target jira issue set in item jira dependency.\",\"causedBy\":[\"Could not set target jira issue set in item jira dependency.\"],\"childNodes\":null},{\"id\":65,\"log\":\"Existing item map contains target jira issue id from item jira dependency.\",\"causedBy\":[\"Existing item map does not contain target jira issue id from item jira dependency.\"],\"childNodes\":null},{\"id\":66,\"log\":\"Successfully updated parent items with new link dependencies.\",\"causedBy\":[\"Parent not updated with new link dependencies.\"],\"childNodes\":null},{\"id\":67,\"log\":\"Change log field matched with sprint field id, continue processing.\",\"causedBy\":[\"Sprint field id does not match field id present in change log.\"],\"childNodes\":null},{\"id\":68,\"log\":\"Sprint to change is valid, continuing.\",\"causedBy\":[\"Invalid sprint to change.\"],\"childNodes\":null},{\"id\":69,\"log\":\"Setting new sprint as active sprint.\",\"causedBy\":[\"Could not find sprint to set as active sprint.\"],\"childNodes\":null},{\"id\":70,\"log\":\"Setting new sprint in child item.\",\"causedBy\":[\"Could not set new sprint in child item.\"],\"childNodes\":null},{\"id\":71,\"log\":\"Successfully found field ID mapped with alm account against field id present in change logs for start date.\",\"causedBy\":[\"Invalid mapping found against start date, please verify mapping for this field on your alm account.\"],\"childNodes\":null},{\"id\":72,\"log\":\"Successfully found field ID mapped with alm account against field id present in change logs for end date.\",\"causedBy\":[\"Invalid mapping found against end date, please verify mapping for this field on your alm account.\"],\"childNodes\":null},{\"id\":73,\"log\":\"Processing item for start date update.\",\"causedBy\":[\"Error in processing item update for start date, please try again.\"],\"childNodes\":null},{\"id\":74,\"log\":\"Processing item for end date update.\",\"causedBy\":[\"Error in processing item update for end date, please try again.\"],\"childNodes\":null},{\"id\":75,\"log\":\"Verifying field mapping and setting new start date in item.\",\"causedBy\":[\"Invalid or no mapping found against start date, please verify mapping for this field.\"],\"childNodes\":null},{\"id\":76,\"log\":\"Verifying field mapping and setting new end date in item.\",\"causedBy\":[\"Invalid or no mapping found against end date, please verify mapping for this field.\"],\"childNodes\":null},{\"id\":77,\"log\":\"Item type is Feature, continuing processing.\",\"causedBy\":[\"Item type is not Feature, skipping update.\"],\"childNodes\":null},{\"id\":78,\"log\":\"Parent link types (multiple link typess) and item jira filter is not present.\",\"causedBy\":[\"Parent link types OR item jira filter is present.\"],\"childNodes\":null},{\"id\":79,\"log\":\"Parent link type and item jira filter is not present.\",\"causedBy\":[\"Parent link type OR item jira filter is present.\"],\"childNodes\":null},{\"id\":80,\"log\":\"Parent link type is not present OR item jira filter is present, using alm configurations to continue.\",\"causedBy\":[\"Parent link type OR item jira filter is not present.\"],\"childNodes\":null},{\"id\":81,\"log\":\"Project key from link mapping matches jira project key of parent item.\",\"causedBy\":[\"Project key from link mapping does not match jira project key of parent item.\"],\"childNodes\":null,\"isLoopNode\":true},{\"id\":82,\"log\":\"Item jira filter is not present, using feature link mappings from alm config.\",\"causedBy\":[\"Link types are not present in link mapping.\"],\"childNodes\":null}]", T.getType());
            this.instructionMapAgainstEventType = this.createPredefinedInstructionGraphs();
        }
        catch (Exception ex) {
            LOGGER.error("Could not create all instruction list: " + StringUtils.getTraceString((Throwable)ex));
        }
    }

    public static WebhookActivityUtil getInstance() {
        if (instance == null) {
            instance = new WebhookActivityUtil();
        }
        return instance;
    }

    public void addErrorLogToBuffer(String id, List<String> causedReasons) {
        if (!PropertyValidator.isValid((Object)this.errorLogBufferAgainstNodeId)) {
            this.errorLogBufferAgainstNodeId = new HashMap();
        }
        this.errorLogBufferAgainstNodeId.put(id, causedReasons);
    }

    public void putInConditionChecker(String key, boolean value) {
        if (!PropertyValidator.isValid((Object)this.conditionChecker)) {
            this.conditionChecker = new HashMap();
        }
        this.conditionChecker.put(key, value);
    }

    public boolean getConditionCheckerValue(String key) {
        if (PropertyValidator.isValid((Object)this.conditionChecker)) {
            return (Boolean)this.conditionChecker.get(key);
        }
        return false;
    }

    private Map<String, InstructionNode> createPredefinedInstructionGraphs() {
        HashMap<String, InstructionNode> instructionsAgainstEventType = new HashMap<String, InstructionNode>();
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_TITLE, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"12\":{\"id\":12,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_STORY_POINTS, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_STATUS, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"16\":{\"id\":16,\"childNodes\":{\"17\":{\"id\":17,\"childNodes\":{\"18\":{\"id\":18,\"childNodes\":{\"19\":{\"id\":19,\"childNodes\":{\"20\":{\"id\":20,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_DUE_DATE, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"23\":{\"id\":23,\"childNodes\":{\"24\":{\"id\":24,\"childNodes\":{\"78\":{\"id\":78,\"childNodes\":{\"25\":{\"id\":25,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}},\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATED_SPRINT_CHANGE, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"67\":{\"id\":67,\"childNodes\":{\"56\":{\"id\":56,\"childNodes\":{\"68\":{\"id\":68,\"childNodes\":{\"69\":{\"id\":69,\"childNodes\":{\"70\":{\"id\":70,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}},\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put("issuelink_created", this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"44\":{\"id\":44,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"27\":{\"id\":27,\"childNodes\":{\"40\":{\"id\":40,\"childNodes\":{\"58\":{\"id\":58,\"childNodes\":{\"59\":{\"id\":59,\"childNodes\":{\"60\":{\"id\":60,\"childNodes\":{\"61\":{\"id\":61,\"childNodes\":{\"62\":{\"id\":62,\"childNodes\":{\"63\":{\"id\":63,\"childNodes\":{\"64\":{\"id\":64,\"childNodes\":{\"65\":{\"id\":65,\"childNodes\":{\"66\":{\"id\":66,\"childNodes\":{}}}}}}}}}}}}}}}}}}}},\"45\":{\"id\":45,\"childNodes\":{\"29\":{\"id\":29,\"childNodes\":{\"46\":{\"id\":46,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"37\":{\"id\":37,\"childNodes\":{\"48\":{\"id\":48,\"childNodes\":{}}}}}}}}}},\"49\":{\"id\":49,\"childNodes\":{\"50\":{\"id\":50,\"childNodes\":{\"51\":{\"id\":51,\"childNodes\":{\"52\":{\"id\":52,\"childNodes\":{\"53\":{\"id\":53,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"37\":{\"id\":37,\"childNodes\":{\"48\":{\"id\":48,\"childNodes\":{}}}}}}}}}}}}}}}},\"54\":{\"id\":54,\"childNodes\":{\"52\":{\"id\":52,\"childNodes\":{\"53\":{\"id\":53,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"55\":{\"id\":55,\"childNodes\":{\"56\":{\"id\":56,\"childNodes\":{\"57\":{\"id\":57,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put("issuelink_deleted", this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"26\":{\"id\":26,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"27\":{\"id\":27,\"childNodes\":{\"28\":{\"id\":28,\"childNodes\":{\"29\":{\"id\":29,\"childNodes\":{\"78\":{\"id\":78,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"31\":{\"id\":31,\"childNodes\":{\"32\":{\"id\":32,\"childNodes\":{\"33\":{\"id\":33,\"childNodes\":{\"34\":{\"id\":34,\"childNodes\":{\"35\":{\"id\":35,\"childNodes\":{\"36\":{\"id\":36,\"childNodes\":{}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}}}}}},\"79\":{\"id\":79,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"31\":{\"id\":31,\"childNodes\":{\"32\":{\"id\":32,\"childNodes\":{\"33\":{\"id\":33,\"childNodes\":{\"34\":{\"id\":34,\"childNodes\":{\"35\":{\"id\":35,\"childNodes\":{\"36\":{\"id\":36,\"childNodes\":{}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}}}}}},\"80\":{\"id\":80,\"childNodes\":{\"50\":{\"id\":50,\"childNodes\":{\"51\":{\"id\":51,\"childNodes\":{\"81\":{\"id\":81,\"childNodes\":{\"53\":{\"id\":53,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"31\":{\"id\":31,\"childNodes\":{\"32\":{\"id\":32,\"childNodes\":{\"33\":{\"id\":33,\"childNodes\":{\"34\":{\"id\":34,\"childNodes\":{\"35\":{\"id\":35,\"childNodes\":{\"36\":{\"id\":36,\"childNodes\":{}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}}}}}}}}}}}},\"82\":{\"id\":82,\"childNodes\":{\"81\":{\"id\":81,\"childNodes\":{\"53\":{\"id\":53,\"childNodes\":{\"47\":{\"id\":47,\"childNodes\":{\"30\":{\"id\":30,\"childNodes\":{\"31\":{\"id\":31,\"childNodes\":{\"32\":{\"id\":32,\"childNodes\":{\"33\":{\"id\":33,\"childNodes\":{\"34\":{\"id\":34,\"childNodes\":{\"35\":{\"id\":35,\"childNodes\":{\"36\":{\"id\":36,\"childNodes\":{}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}},\"37\":{\"id\":37,\"childNodes\":{\"38\":{\"id\":38,\"childNodes\":{\"39\":{\"id\":39,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}},\"40\":{\"id\":40,\"childNodes\":{\"41\":{\"id\":41,\"childNodes\":{\"42\":{\"id\":42,\"childNodes\":{\"43\":{\"id\":43,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_START_DATE, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"71\":{\"id\":71,\"childNodes\":{\"73\":{\"id\":73,\"childNodes\":{\"75\":{\"id\":75,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}},\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        instructionsAgainstEventType.put(JIRA_ISSUE_UPDATE_EVENT_FOR_END_DATE, this.createInstructionGraphFromJson("{\"id\":0,\"childNodes\":{\"1\":{\"id\":1,\"childNodes\":{\"2\":{\"id\":2,\"childNodes\":{\"3\":{\"id\":3,\"childNodes\":{\"4\":{\"id\":4,\"childNodes\":{\"5\":{\"id\":5,\"childNodes\":{\"6\":{\"id\":6,\"childNodes\":{\"7\":{\"id\":7,\"childNodes\":{\"8\":{\"id\":8,\"childNodes\":{\"9\":{\"id\":9,\"childNodes\":{\"10\":{\"id\":10,\"childNodes\":{\"11\":{\"id\":11,\"childNodes\":{\"72\":{\"id\":72,\"childNodes\":{\"74\":{\"id\":74,\"childNodes\":{\"76\":{\"id\":76,\"childNodes\":{\"13\":{\"id\":13,\"childNodes\":{\"21\":{\"id\":21,\"childNodes\":{\"22\":{\"id\":22,\"childNodes\":{\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}},\"14\":{\"id\":14,\"childNodes\":{\"15\":{\"id\":15,\"childNodes\":{}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}", this.allJiraInstructions));
        return instructionsAgainstEventType;
    }

    private InstructionNode createInstructionGraphFromJson(String json, List<InstructionNode> allInstructions) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InstructionNode nodeMapping = (InstructionNode)objectMapper.readValue(json, InstructionNode.class);
            return this.createInstructionGraphFromJsonUtil(nodeMapping, allInstructions);
        }
        catch (IOException ex) {
            LOGGER.error("Exception occurred while creating instruction graph from json" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private InstructionNode createInstructionGraphFromJsonUtil(InstructionNode instructionNode, List<InstructionNode> allInstructions) {
        if (instructionNode.getChildNodes() != null && instructionNode.getChildNodes().size() > 0) {
            ArrayList childNodes = new ArrayList(instructionNode.getChildNodes().values());
            ArrayList<InstructionNode> nodesAfterRecursion = new ArrayList<InstructionNode>();
            for (InstructionNode childNode : childNodes) {
                nodesAfterRecursion.add(this.createInstructionGraphFromJsonUtil(childNode, allInstructions));
            }
            return new InstructionNode(instructionNode.getId(), allInstructions, nodesAfterRecursion);
        }
        return new InstructionNode(instructionNode.getId(), allInstructions);
    }

    public void addOneCausedBy(String causedBy) {
        if (!PropertyValidator.isValid((Collection)this.causedReasons)) {
            this.causedReasons = new ArrayList();
        }
        this.causedReasons.add(causedBy);
    }

    public void addOneTfsCausedBy(String causedBy) {
        if (!PropertyValidator.isValid((Collection)this.tfsCausedReasons)) {
            this.tfsCausedReasons = new HashSet();
        }
        this.tfsCausedReasons.add(causedBy);
    }

    public List<String> getCausedBy() {
        return this.causedReasons;
    }

    public void setCausedBy(List<String> causedReasons) {
        this.causedReasons = causedReasons;
    }

    public void extractMismatchLog(String executionPathKey) {
        try {
            this.visitedNodes = new ArrayList<Boolean>(Collections.nCopies(this.allJiraInstructions.size(), false));
            InstructionNode rootNode = (InstructionNode)this.instructionMapAgainstEventType.get(executionPathKey);
            int index = this.getNextId(-1);
            this.causedReasons = PropertyValidator.isValid((Object)rootNode) ? this.getCausedByFromInstructionLogs(index, rootNode, rootNode) : new ArrayList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void extractMismatchLogForTfs() {
        if (PropertyValidator.isValid((Collection)this.tfsFailedFields)) {
            for (Object failedTfsField : this.tfsFailedFields.toArray()) {
                String causedReason;
                String string = causedReason = PropertyValidator.isValid((Object)this.tfsErrorLookup) ? (String)this.tfsErrorLookup.get((String)failedTfsField) : null;
                if (!PropertyValidator.isValid(causedReason)) continue;
                this.addOneCausedBy(causedReason);
            }
        }
        if (PropertyValidator.isValid((Collection)this.tfsCausedReasons)) {
            if (!PropertyValidator.isValid((Collection)this.causedReasons)) {
                this.causedReasons = new ArrayList();
            }
            this.causedReasons.addAll(this.tfsCausedReasons);
        }
    }

    public void saveTfsError(AlmAccount almAccount, ItemRepository itemRepository, WebhookActivityRepository webhookActivityRepository) {
        try {
            LOGGER_WH_HEALTH.debug("\nsaveTfsError webhook TFS ID : " + this.tfsId);
            LOGGER_WH_HEALTH.debug("***** ***** ***** ***** ***** ***** ***** ***** ***** ");
            if (this.logs != null) {
                LOGGER_WH_HEALTH.debug("logs : ");
                LOGGER_WH_HEALTH.debug(this.logs.toString());
            }
            if (this.causedReasons != null) {
                LOGGER_WH_HEALTH.debug(" error cause");
                LOGGER_WH_HEALTH.debug(this.causedReasons.toString());
            }
            LOGGER_WH_HEALTH.debug("***** ***** ***** ***** ***** ***** ***** ***** ***** ");
        }
        catch (Exception ex) {
            LOGGER_WH_HEALTH.error("Error in saveTfsError: ", (Object)StringUtils.getTraceString((Throwable)ex));
        }
        this.reset();
    }

    public List<String> getUniqueLinkTypes(Collection<JiraIssueLink> issueLinks) {
        HashSet<String> uniqueLinkTypes = new HashSet<String>();
        for (JiraIssueLink issueLink : issueLinks) {
            uniqueLinkTypes.add(issueLink.getType().getName());
            uniqueLinkTypes.add(issueLink.getType().getOutward());
            uniqueLinkTypes.add(issueLink.getType().getInward());
        }
        return new ArrayList<String>(uniqueLinkTypes);
    }

    private List<String> getCausedByFromInstructionLogs(int index, InstructionNode node, InstructionNode rootNode) {
        if (!PropertyValidator.isValid((Object)node)) {
            LOGGER.info("Node is null in **getCausedByFromInstructionLogs**");
            LOGGER.info("Index is: " + index);
            LOGGER.info(this.logs.toString());
            return null;
        }
        if (node.isFailure()) {
            return this.errorLogBufferAgainstNodeId.getOrDefault(node.getId(), node.getCausedBy());
        }
        if (index == this.lastErrorNodeIndex) {
            return this.addAllChildNodesInList(node);
        }
        this.visitedNodes.set(Integer.parseInt(node.getId()), true);
        int nextIndex = this.getNextId(index);
        if (nextIndex != -1) {
            String nextNodeID = (String)this.logs.get(nextIndex);
            if (PropertyValidator.isValid((Object)node.getChildNodes()) && PropertyValidator.isValid(node.getChildNodes().get(nextNodeID)) || this.checkLoopNode(nextNodeID)) {
                if (((Boolean)this.visitedNodes.get(Integer.parseInt(nextNodeID))).booleanValue()) {
                    InstructionNode nodeFromTree = this.findParentNode(nextNodeID, rootNode);
                    InstructionNode instructionNode = node = PropertyValidator.isValid((Object)nodeFromTree) ? nodeFromTree : node;
                }
                if (PropertyValidator.isValid((Object)node.getChildNodes())) {
                    InstructionNode childNode = (InstructionNode)node.getChildNodes().get(nextNodeID);
                    if (PropertyValidator.isValid((Object)childNode)) {
                        List recurValues = this.getCausedByFromInstructionLogs(nextIndex, childNode, rootNode);
                        return PropertyValidator.isValid((Collection)recurValues) ? recurValues : node.getCausedBy();
                    }
                    List errorReason = this.addAllChildNodesInList(node);
                    errorReason.addAll(this.errorLogBufferAgainstNodeId.getOrDefault(node.getId(), node.getCausedBy()));
                    return errorReason;
                }
                return this.errorLogBufferAgainstNodeId.getOrDefault(node.getId(), node.getCausedBy());
            }
            return this.addAllChildNodesInList(node);
        }
        List errorReason = this.addAllChildNodesInList(node);
        errorReason.addAll(this.errorLogBufferAgainstNodeId.getOrDefault(node.getId(), node.getCausedBy()));
        return errorReason;
    }

    private InstructionNode findParentNode(String id, InstructionNode node) {
        if (PropertyValidator.isValid((Object)node.getChildNodes()) && PropertyValidator.isValid(node.getChildNodes().get(id))) {
            return node;
        }
        if (PropertyValidator.isValid((Object)node.getChildNodes())) {
            ArrayList childNodes = new ArrayList(node.getChildNodes().values());
            for (InstructionNode instructionNode : childNodes) {
                InstructionNode recurNode = this.findParentNode(id, instructionNode);
                if (!PropertyValidator.isValid((Object)recurNode)) continue;
                return recurNode;
            }
        }
        return null;
    }

    private boolean checkLoopNode(String nodeId) {
        try {
            int insNodeId = Integer.parseInt(nodeId);
            InstructionNode instructionNode = (InstructionNode)this.allJiraInstructions.get(insNodeId);
            if (PropertyValidator.isValid((Object)instructionNode) && instructionNode.id.equals(nodeId)) {
                return instructionNode.isLoopNode;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private List<String> addAllChildNodesInList(InstructionNode node) {
        ArrayList<String> causedReasons = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)node)) {
            ArrayList childNodes = new ArrayList(node.getChildNodes().values());
            for (InstructionNode instructionNode : childNodes) {
                causedReasons.addAll(this.errorLogBufferAgainstNodeId.getOrDefault(instructionNode.getId(), instructionNode.getCausedBy()));
            }
        }
        return causedReasons;
    }

    private int getNextId(int startingIndex) {
        if (PropertyValidator.isValid((Collection)this.logs)) {
            int index = startingIndex + 1;
            int logsRootNodeId = -1;
            while (logsRootNodeId == -1 && index < this.logs.size()) {
                logsRootNodeId = this.getNodeIdFromLogs(index);
                if (logsRootNodeId != -1) continue;
                ++index;
            }
            return index == this.logs.size() ? -1 : index;
        }
        return -1;
    }

    private int getNodeIdFromLogs(int index) {
        try {
            return Integer.parseInt((String)this.logs.get(index));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public void logActivity(String activity) {
        if (!PropertyValidator.isValid((Collection)this.logs)) {
            this.logs = new ArrayList();
        }
        if (PropertyValidator.isValid((Object)activity) && PropertyValidator.isValid((Collection)this.logs)) {
            this.logs.add(activity);
        }
    }

    public void putTfsErrorLookup(String key, String val) {
        if (!PropertyValidator.isValid((Object)this.tfsErrorLookup)) {
            this.tfsErrorLookup = new HashMap();
        }
        this.tfsErrorLookup.put(key, val);
    }

    public void addTfsFailedField(String fieldName) {
        if (!PropertyValidator.isValid((Collection)this.tfsFailedFields)) {
            this.tfsFailedFields = new HashSet();
        }
        this.tfsFailedFields.add(fieldName);
    }

    public int getCurrentInsertionIndex() {
        return this.logs.size();
    }

    public void logActivity(String activity, boolean isCausedBy) {
        this.logActivity(activity);
        if (isCausedBy) {
            this.addOneCausedBy(activity);
        }
    }

    private Map<String, String> getJiraKeys(JiraWebhookMappedData jiraWebhookMappedData, ItemRepository itemRepository) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!PropertyValidator.isValid((Collection)this.fetchedItemList)) {
            ArrayList<String> jiraIds = new ArrayList<String>();
            if (PropertyValidator.isValid((Object)jiraWebhookMappedData.getJiraId())) {
                jiraIds.add(jiraWebhookMappedData.getJiraId());
                resultMap.put("jiraId", jiraWebhookMappedData.getJiraId());
            }
            if (PropertyValidator.isValid((Object)jiraWebhookMappedData.getJiraSourceIssueId())) {
                jiraIds.add(jiraWebhookMappedData.getJiraSourceIssueId());
                resultMap.put("jiraSourceIssueId", jiraWebhookMappedData.getJiraSourceIssueId());
            }
            if (PropertyValidator.isValid((Object)jiraWebhookMappedData.getJiraDestinationIssueId())) {
                jiraIds.add(jiraWebhookMappedData.getJiraDestinationIssueId());
                resultMap.put("jiraDestinationIssueId", jiraWebhookMappedData.getJiraDestinationIssueId());
            }
        }
        return resultMap;
    }

    public void saveError(JiraWebhookMappedData jiraWebhookMappedData, AlmAccount almAccount, ItemRepository itemRepository, WebhookActivityRepository webhookActivityRepository) {
        ArrayList mappedLogs = new ArrayList();
        if (PropertyValidator.isValid((Object)jiraWebhookMappedData) && PropertyValidator.isValid((Collection)this.causedReasons)) {
            Map jiraKeysMap = this.getJiraKeys(jiraWebhookMappedData, itemRepository);
            try {
                LOGGER_WH_HEALTH.debug("\nsaveError webhook Jira ID : " + jiraKeysMap.toString());
                LOGGER_WH_HEALTH.debug("***** ***** ***** ***** ***** ***** ***** ***** ***** ");
                if (this.logs != null) {
                    LOGGER_WH_HEALTH.debug("logs : ");
                    LOGGER_WH_HEALTH.debug(this.logs.toString());
                }
                if (this.causedReasons != null) {
                    LOGGER_WH_HEALTH.debug("error cause : ");
                    LOGGER_WH_HEALTH.debug(this.causedReasons.toString());
                }
                LOGGER_WH_HEALTH.debug("***** ***** ***** ***** ***** ***** ***** ***** ***** ");
            }
            catch (Exception ex) {
                LOGGER_WH_HEALTH.error("Error occurred in ***** saveError *****" + StringUtils.getTraceString((Throwable)ex));
            }
        }
        this.reset();
    }

    public void reset() {
        this.logs = null;
        this.causedReasons = null;
        this.visitedNodes = null;
        this.errorLogBufferAgainstNodeId = new HashMap();
        this.lastErrorNodeIndex = -1;
        this.isSharedSprintUpdated = false;
        this.sharedSprintField = null;
        this.fetchedItemList = null;
        this.tfsErrorLookup = null;
        this.tfsId = null;
        this.tfsCausedReasons = null;
        this.conditionChecker = null;
        this.jiraIssueUpdateEventType = null;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public void setLogs(List<String> logs) {
        this.logs = logs;
    }

    public int getLastErrorNodeIndex() {
        return this.lastErrorNodeIndex;
    }

    public void setLastErrorNodeIndex(int lastErrorNodeIndex) {
        this.lastErrorNodeIndex = lastErrorNodeIndex;
    }

    public String getJiraIssueUpdateEventType() {
        return this.jiraIssueUpdateEventType;
    }

    public void setJiraIssueUpdateEventType(String jiraIssueUpdateEventType) {
        this.jiraIssueUpdateEventType = jiraIssueUpdateEventType;
    }

    public ItemJiraFieldMap getSharedSprintField() {
        return this.sharedSprintField;
    }

    public void setSharedSprintField(ItemJiraFieldMap sharedSprintField) {
        this.sharedSprintField = sharedSprintField;
    }

    public boolean isSharedSprintUpdated() {
        return this.isSharedSprintUpdated;
    }

    public void setSharedSprintUpdated(boolean sharedSprintUpdated) {
        this.isSharedSprintUpdated = sharedSprintUpdated;
    }

    public List<Item> getFetchedItemList() {
        return this.fetchedItemList;
    }

    public void setFetchedItemList(List<Item> fetchedItemList) {
        this.fetchedItemList = fetchedItemList;
    }

    public Set<String> getTfsFailedFields() {
        return this.tfsFailedFields;
    }

    public void setTfsFailedFields(Set<String> tfsFailedFields) {
        this.tfsFailedFields = tfsFailedFields;
    }

    public String getTfsId() {
        return this.tfsId;
    }

    public void setTfsId(String tfsId) {
        this.tfsId = tfsId;
    }

    public Map<String, Boolean> getConditionChecker() {
        return this.conditionChecker;
    }

    public void setConditionChecker(Map<String, Boolean> conditionChecker) {
        this.conditionChecker = conditionChecker;
    }
}

