/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.change.stream.model.BaseItemLinkMirror;
import com.viztrend.safe.change.stream.model.StatusMirror;
import com.viztrend.safe.enums.EnumBaseItemLinkTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Dashboard;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.DateUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TimeSeriesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesUtils.class);
    private final MongoTemplate mongoTemplate;
    private final StatusRepository statusRepository;
    private final DecimalFormat df = new DecimalFormat("#.#");

    public TimeSeriesUtils(MongoTemplate mongoTemplate, StatusRepository statusRepository) {
        this.mongoTemplate = mongoTemplate;
        this.statusRepository = statusRepository;
    }

    public static Date stripTime(Date date) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        catch (Exception e) {
            LOGGER.error("Error processing stripTime()" + StringUtils.getTraceString((Throwable)e));
            return new Date();
        }
    }

    public Map<String, List<Date>> getSprintDates(SessionBoard sessionBoard) {
        TreeMap<String, ArrayList<Date>> dates = new TreeMap<String, ArrayList<Date>>();
        LinkedHashMap<String, List<Date>> sortedDates = new LinkedHashMap<String, List<Date>>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoard.getId())));
            query.fields().include("containers");
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("sessionBoard").find(query.getQueryObject());
            ArrayList<String> containerIdsList = new ArrayList<String>();
            while (dbCursorPrefix.hasNext()) {
                DBObject dbo = dbCursorPrefix.next();
                BasicDBList containers = (BasicDBList)dbo.get("containers");
                for (Object container : containers) {
                    DBRef containerRef = (DBRef)container;
                    Object object = containerRef.getId();
                    if (!(object instanceof ObjectId) && (!(object instanceof String) || !DBUtils.isHexString((String)((String)object)) && !DBUtils.isUUID((String)((String)object)))) continue;
                    containerIdsList.add(object.toString());
                }
            }
            dbCursorPrefix.close();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (!containerIdsList.isEmpty()) {
                Query queryForContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(containerIdsList).and("tenant").is((Object)tenant));
                queryForContainer.fields().include("startDate");
                queryForContainer.fields().include("endDate");
                queryForContainer.fields().include("title");
                List containers = this.mongoTemplate.find(queryForContainer, Container.class);
                for (Container container : containers) {
                    Date date = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (date == null || endDate == null || TimeSeriesUtils.stripTime((Date)date).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                    Calendar startCal = Calendar.getInstance();
                    startCal.setTime(date);
                    startCal.set(11, 0);
                    startCal.set(12, 0);
                    startCal.set(13, 0);
                    startCal.set(14, 0);
                    Date date2 = startCal.getTime();
                    Calendar endCal = Calendar.getInstance();
                    endCal.setTime(endDate);
                    endCal.set(11, 23);
                    endCal.set(12, 59);
                    endCal.set(13, 59);
                    endCal.set(14, 999);
                    endDate = endCal.getTime();
                    ArrayList<Date> dateList = new ArrayList<Date>(Arrays.asList(date2, endDate));
                    Collections.sort(dateList);
                    dates.put(container.getTitle(), dateList);
                }
                ArrayList entries = new ArrayList(dates.entrySet());
                entries.sort(Comparator.comparing(entry -> (Date)((List)entry.getValue()).get(0)));
                for (Map.Entry entry2 : entries) {
                    sortedDates.put((String)entry2.getKey(), (List<Date>)entry2.getValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSprintDates()" + StringUtils.getTraceString((Throwable)e));
        }
        return sortedDates;
    }

    public Map<String, List<Date>> getSprintDatesWithFuture(SessionBoard sessionBoard) throws Exception {
        TreeMap<String, ArrayList<Date>> dates = new TreeMap<String, ArrayList<Date>>();
        LinkedHashMap<String, List<Date>> sortedDates = new LinkedHashMap<String, List<Date>>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoard.getId())));
            query.fields().include("containers");
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("sessionBoard").find(query.getQueryObject());
            ArrayList<String> containerIdsList = new ArrayList<String>();
            while (dbCursorPrefix.hasNext()) {
                DBObject dbo = dbCursorPrefix.next();
                BasicDBList containers = (BasicDBList)dbo.get("containers");
                for (Object container : containers) {
                    DBRef containerRef = (DBRef)container;
                    Object object = containerRef.getId();
                    if (!(object instanceof ObjectId) && (!(object instanceof String) || !DBUtils.isHexString((String)((String)object)) && !DBUtils.isUUID((String)((String)object)))) continue;
                    containerIdsList.add(object.toString());
                }
            }
            dbCursorPrefix.close();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (!containerIdsList.isEmpty()) {
                Query queryForContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(containerIdsList).and("tenant").is((Object)tenant));
                queryForContainer.fields().include("startDate");
                queryForContainer.fields().include("endDate");
                queryForContainer.fields().include("title");
                List containers = this.mongoTemplate.find(queryForContainer, Container.class);
                for (Container container : containers) {
                    Date date = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (date == null || endDate == null) continue;
                    Calendar startCal = Calendar.getInstance();
                    startCal.setTime(date);
                    startCal.set(11, 0);
                    startCal.set(12, 0);
                    startCal.set(13, 0);
                    startCal.set(14, 0);
                    Date date2 = startCal.getTime();
                    Calendar endCal = Calendar.getInstance();
                    endCal.setTime(endDate);
                    endCal.set(11, 23);
                    endCal.set(12, 59);
                    endCal.set(13, 59);
                    endCal.set(14, 999);
                    endDate = endCal.getTime();
                    ArrayList<Date> dateList = new ArrayList<Date>(Arrays.asList(date2, endDate));
                    Collections.sort(dateList);
                    dates.put(container.getTitle(), dateList);
                }
                ArrayList entries = new ArrayList(dates.entrySet());
                entries.sort(Comparator.comparing(entry -> (Date)((List)entry.getValue()).get(0)));
                for (Map.Entry entry2 : entries) {
                    sortedDates.put((String)entry2.getKey(), (List<Date>)entry2.getValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSprintDates()" + StringUtils.getTraceString((Throwable)e));
        }
        return sortedDates;
    }

    public Map<String, List<Date>> getSprintDatesIdMap(SessionBoard sessionBoard) {
        TreeMap<String, ArrayList<Date>> dates = new TreeMap<String, ArrayList<Date>>();
        LinkedHashMap<String, List<Date>> sortedDates = new LinkedHashMap<String, List<Date>>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoard.getId())));
            query.fields().include("containers");
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("sessionBoard").find(query.getQueryObject());
            ArrayList<String> containerIdsList = new ArrayList<String>();
            while (dbCursorPrefix.hasNext()) {
                DBObject dbo = dbCursorPrefix.next();
                BasicDBList containers = (BasicDBList)dbo.get("containers");
                for (Object container : containers) {
                    DBRef containerRef = (DBRef)container;
                    Object object = containerRef.getId();
                    if (!(object instanceof ObjectId) && (!(object instanceof String) || !DBUtils.isHexString((String)((String)object)) && !DBUtils.isUUID((String)((String)object)))) continue;
                    containerIdsList.add(object.toString());
                }
            }
            dbCursorPrefix.close();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (!containerIdsList.isEmpty()) {
                Query queryForContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(containerIdsList).and("tenant").is((Object)tenant));
                queryForContainer.fields().include("startDate");
                queryForContainer.fields().include("endDate");
                queryForContainer.fields().include("title");
                List containers = this.mongoTemplate.find(queryForContainer, Container.class);
                for (Container container : containers) {
                    Date date = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (date == null || endDate == null) continue;
                    Calendar startCal = Calendar.getInstance();
                    startCal.setTime(date);
                    startCal.set(11, 0);
                    startCal.set(12, 0);
                    startCal.set(13, 0);
                    startCal.set(14, 0);
                    Date date2 = startCal.getTime();
                    Calendar endCal = Calendar.getInstance();
                    endCal.setTime(endDate);
                    endCal.set(11, 23);
                    endCal.set(12, 59);
                    endCal.set(13, 59);
                    endCal.set(14, 999);
                    endDate = endCal.getTime();
                    ArrayList<Date> dateList = new ArrayList<Date>(Arrays.asList(date2, endDate));
                    Collections.sort(dateList);
                    dates.put(container.getId(), dateList);
                }
                ArrayList entries = new ArrayList(dates.entrySet());
                entries.sort(Comparator.comparing(entry -> (Date)((List)entry.getValue()).get(0)));
                for (Map.Entry entry2 : entries) {
                    sortedDates.put((String)entry2.getKey(), (List<Date>)entry2.getValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSprintDates()" + StringUtils.getTraceString((Throwable)e));
        }
        return sortedDates;
    }

    public Map<String, List<Date>> getAllMonths(Calendar calendar) {
        LinkedHashMap<String, List<Date>> allMonths = new LinkedHashMap<String, List<Date>>();
        try {
            Calendar currentCalender = Calendar.getInstance();
            int currentMonth = currentCalender.get(2);
            for (int month = 0; month <= currentMonth; ++month) {
                calendar.set(2, month);
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                Date monthStartDate = calendar.getTime();
                calendar.set(5, calendar.getActualMaximum(5));
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                Date monthEndDate = calendar.getTime();
                String monthName = new SimpleDateFormat("MMMM").format(monthStartDate);
                allMonths.put(monthName, Arrays.asList(monthStartDate, monthEndDate));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllMonths()" + StringUtils.getTraceString((Throwable)e));
        }
        return allMonths;
    }

    public Map<String, List<Date>> getAllMonthswrtFirstEntry(Calendar calendar, Date firstEntry) {
        LinkedHashMap<String, List<Date>> allMonths = new LinkedHashMap<String, List<Date>>();
        try {
            Calendar currentCalender = Calendar.getInstance();
            int currentMonth = currentCalender.get(2);
            for (int month = 0; month <= currentMonth; ++month) {
                calendar.set(2, month);
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                Date monthStartDate = calendar.getTime();
                calendar.set(5, calendar.getActualMaximum(5));
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                Date monthEndDate = calendar.getTime();
                if (monthEndDate.before(firstEntry)) continue;
                String monthName = new SimpleDateFormat("MMMM").format(monthStartDate);
                allMonths.put(monthName, Arrays.asList(monthStartDate, monthEndDate));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllMonthswrtFirstEntry()" + StringUtils.getTraceString((Throwable)e));
        }
        return allMonths;
    }

    public Map<String, List<Date>> getAllMonthswrtFirstAndLastEntry(Calendar calendar, Date firstEntry, Date lastEntry) {
        LinkedHashMap<String, List<Date>> allMonths = new LinkedHashMap<String, List<Date>>();
        try {
            calendar.setTime(firstEntry);
            int startYear = calendar.get(1);
            int startMonth = calendar.get(2);
            Calendar lastEntryCalendar = Calendar.getInstance();
            lastEntryCalendar.setTime(lastEntry);
            int endYear = lastEntryCalendar.get(1);
            int endMonth = lastEntryCalendar.get(2);
            block2: for (int year = startYear; year <= endYear; ++year) {
                int monthStart = year == startYear ? startMonth : 0;
                int monthEnd = year == endYear ? endMonth : 11;
                for (int month = monthStart; month <= monthEnd; ++month) {
                    calendar.set(1, year);
                    calendar.set(2, month);
                    calendar.set(5, 1);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    Date monthStartDate = calendar.getTime();
                    calendar.set(5, calendar.getActualMaximum(5));
                    calendar.set(11, 23);
                    calendar.set(12, 59);
                    calendar.set(13, 59);
                    Date monthEndDate = calendar.getTime();
                    if (monthEndDate.before(firstEntry)) continue;
                    if (monthStartDate.after(lastEntry)) continue block2;
                    String monthName = new SimpleDateFormat("MMMM yyyy").format(monthStartDate);
                    allMonths.put(monthName, Arrays.asList(monthStartDate, monthEndDate));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllMonthswrtFirstAndLastEntry()" + StringUtils.getTraceString((Throwable)e));
        }
        return allMonths;
    }

    public Map<String, Item> fetchItemsUsingBasicDBObject(Set<String> itemIds, String sessionBoardIds, String tenant) {
        Map<String, Object> itemMap = new HashMap<String, Item>();
        try {
            List objectIdList = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new BasicDBObject("$in", objectIdList));
            query.put((Object)"sessionBoards.$id", (Object)new ObjectId(sessionBoardIds));
            query.put((Object)"tenant", (Object)tenant);
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraIssueTypeId", (Object)1);
            fields.put((Object)"tfsItemType", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            DBCollection collection = this.mongoTemplate.getCollection("item");
            DBCursor cursor = collection.find((DBObject)query, (DBObject)fields);
            ArrayList<Item> items = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item2 = new Item();
                item2.setId(dbObject.get("_id").toString());
                item2.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
                item2.setTfsItemType((String)dbObject.get("tfsItemType"));
                item2.setTeamContainers((List)dbObject.get("teamContainers"));
                items.add(item2);
            }
            itemMap = items.parallelStream().collect(Collectors.toConcurrentMap(item -> item.getId().toString(), Function.identity(), (existing, replacement) -> existing));
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        return itemMap;
    }

    public List<Item> fetchItemsListUsingBasicDBObject(Set<String> itemIds, String sessionBoardIds, String tenant, BasicDBObject fields) {
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            List objectIdList = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new BasicDBObject("$in", objectIdList));
            query.put((Object)"sessionBoards.$id", (Object)new ObjectId(sessionBoardIds));
            query.put((Object)"tenant", (Object)tenant);
            DBCollection collection = this.mongoTemplate.getCollection("item");
            DBCursor cursor = collection.find((DBObject)query, (DBObject)fields);
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                item.setType((String)dbObject.get("type"));
                item.setTeamContainers((List)dbObject.get("teamContainers"));
                item.setJiraProjectKey((String)dbObject.get("jiraProjectKey"));
                item.setTfsProjectId((String)dbObject.get("tfsProjectId"));
                item.setTfsId((String)dbObject.get("tfsId"));
                item.setTfsAreaPath((String)dbObject.get("tfsAreaPath"));
                item.setTfsAreaPath((String)dbObject.get("tfsAreaPath"));
                item.setTfsFieldByKey((Map)dbObject.get("tfsFieldByKey"));
                items.add(item);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsListUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        return items;
    }

    public Map<String, TimeSeriesLog> populateEarliestStatusMap(List<TimeSeriesLog> startingStatusMatch, List<String> selectedIssueType, String sessionBoardIds) {
        HashMap<String, TimeSeriesLog> earliestStartingStatusMap = new HashMap<String, TimeSeriesLog>();
        HashSet<String> earliestItemIds = new HashSet<String>();
        try {
            if (startingStatusMatch == null) {
                return earliestStartingStatusMap;
            }
            Set itemIds = startingStatusMatch.stream().map(TimeSeriesLog::getItemId).filter(Objects::nonNull).collect(Collectors.toSet());
            String tenant = Optional.ofNullable(UserContextUtil.getUserContext()).map(context -> context.getCurrentCompany()).map(company -> company.getTenant()).orElse(null);
            if (tenant == null) {
                return earliestStartingStatusMap;
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraIssueTypeId", (Object)1);
            fields.put((Object)"tfsItemType", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            DBCursor cursor = collection.find((DBObject)query, (DBObject)fields);
            ArrayList<Item> items = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item2 = new Item();
                item2.setId(dbObject.get("_id").toString());
                List teamContainerRefs = (List)dbObject.get("teamContainers");
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                if (PropertyValidator.isValid((Collection)teamContainerRefs)) {
                    for (DBRef ref : teamContainerRefs) {
                        DBCollection containerCollection;
                        DBObject containerDbObject;
                        DBRef containerRef;
                        DBCollection teamCollection;
                        DBObject teamDbObject;
                        String id = ref.getId().toString();
                        BasicDBObject queryObj = new BasicDBObject();
                        queryObj.put((Object)"_id", (Object)new ObjectId(id));
                        BasicDBObject fieldObj = new BasicDBObject();
                        fieldObj.put((Object)"_id", (Object)1);
                        fieldObj.put((Object)"team", (Object)1);
                        fieldObj.put((Object)"container", (Object)1);
                        DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
                        DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)queryObj, (DBObject)fieldObj);
                        if (!teamContainerCursor.hasNext()) continue;
                        BasicDBObject teamContainerDbObject = (BasicDBObject)teamContainerCursor.next();
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setId(teamContainerDbObject.get("_id").toString());
                        DBRef teamRef = (DBRef)teamContainerDbObject.get("team");
                        if (teamRef != null && (teamDbObject = (teamCollection = this.mongoTemplate.getCollection("team")).findOne(teamRef.getId())) != null) {
                            Team team = new Team();
                            team.setId(teamDbObject.get("_id").toString());
                            team.setTitle((String)teamDbObject.get("title"));
                            team.setLabel((String)teamDbObject.get("label"));
                            teamContainer.setTeam(team);
                        }
                        if ((containerRef = (DBRef)teamContainerDbObject.get("container")) != null && (containerDbObject = (containerCollection = this.mongoTemplate.getCollection("container")).findOne(containerRef.getId())) != null) {
                            Container container = new Container();
                            container.setId(containerDbObject.get("_id").toString());
                            container.setTitle((String)containerDbObject.get("title"));
                            container.setLabel((String)containerDbObject.get("label"));
                            teamContainer.setContainer(container);
                        }
                        teamContainers.add(teamContainer);
                    }
                }
                item2.setTeamContainers(teamContainers);
                item2.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
                item2.setTfsItemType((String)dbObject.get("tfsItemType"));
                items.add(item2);
            }
            Map<String, Item> itemMap = items.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
            block5: for (TimeSeriesLog startingStatus : startingStatusMatch) {
                boolean issueTypeValid;
                Item selectedItem;
                String itemId = startingStatus.getItemId();
                if (itemId == null || !itemMap.containsKey(itemId) || (selectedItem = itemMap.get(itemId)) == null) continue;
                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                List teamContainers = Optional.ofNullable(selectedItem.getTeamContainers()).orElse(Collections.emptyList());
                if (!teamContainers.isEmpty()) {
                    for (TeamContainer teamContainer : teamContainers) {
                        String plannedKey = itemId + "-" + teamContainer.getTeam().getTitle();
                        if (earliestStartingStatusMap.containsKey(plannedKey)) {
                            TimeSeriesLog existingLog = (TimeSeriesLog)earliestStartingStatusMap.get(plannedKey);
                            if (!startingStatus.getEventTime().before(existingLog.getEventTime())) continue;
                            earliestStartingStatusMap.put(plannedKey, startingStatus);
                            continue;
                        }
                        earliestStartingStatusMap.put(plannedKey, startingStatus);
                    }
                    continue;
                }
                String unplannedKey = itemId + "-unplanned-" + UUID.randomUUID().toString();
                boolean foundMatchingItemId = false;
                if (earliestItemIds.contains(itemId)) {
                    for (String existingKey : earliestStartingStatusMap.keySet()) {
                        String[] keyParts = existingKey.split("-");
                        String existingItemId = keyParts[0];
                        if (!itemId.equals(existingItemId)) continue;
                        TimeSeriesLog existingLog = (TimeSeriesLog)earliestStartingStatusMap.get(existingKey);
                        if (startingStatus.getEventTime().before(existingLog.getEventTime())) {
                            earliestStartingStatusMap.put(existingKey, startingStatus);
                        }
                        foundMatchingItemId = true;
                        continue block5;
                    }
                    continue;
                }
                earliestStartingStatusMap.put(unplannedKey, startingStatus);
                earliestItemIds.add(itemId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateEarliestStatusMap()" + StringUtils.getTraceString((Throwable)e));
        }
        return earliestStartingStatusMap;
    }

    public static String[] customSplit(String input) {
        ArrayList<String> parts = new ArrayList<String>();
        try {
            int start = 0;
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != '-') continue;
                parts.add(input.substring(start, i));
                start = i + 1;
            }
            parts.add(input.substring(start));
        }
        catch (Exception e) {
            LOGGER.error("Error processing customSplit()" + StringUtils.getTraceString((Throwable)e));
        }
        return parts.toArray(new String[0]);
    }

    public Map<String, TimeSeriesLog> populateFarthestStatusMap(List<TimeSeriesLog> endingStatusMatch, List<String> selectedIssueType, String sessionBoardIds) {
        HashMap<String, TimeSeriesLog> farthestEndingStatusMap = new HashMap<String, TimeSeriesLog>();
        HashSet<String> farthestItemIds = new HashSet<String>();
        try {
            if (endingStatusMatch == null) {
                return farthestEndingStatusMap;
            }
            Set itemIds = endingStatusMatch.stream().map(TimeSeriesLog::getItemId).filter(Objects::nonNull).collect(Collectors.toSet());
            String tenant = Optional.ofNullable(UserContextUtil.getUserContext()).map(context -> context.getCurrentCompany()).map(company -> company.getTenant()).orElse(null);
            if (tenant == null) {
                return farthestEndingStatusMap;
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraIssueTypeId", (Object)1);
            fields.put((Object)"tfsItemType", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            DBCursor cursor = collection.find((DBObject)query, (DBObject)fields);
            ArrayList<Item> items = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item2 = new Item();
                item2.setId(dbObject.get("_id").toString());
                List teamContainerRefs = (List)dbObject.get("teamContainers");
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                if (PropertyValidator.isValid((Collection)teamContainerRefs)) {
                    for (DBRef ref : teamContainerRefs) {
                        DBCollection containerCollection;
                        DBObject containerDbObject;
                        DBRef containerRef;
                        DBCollection teamCollection;
                        DBObject teamDbObject;
                        String id = ref.getId().toString();
                        BasicDBObject queryObj = new BasicDBObject();
                        queryObj.put((Object)"_id", (Object)new ObjectId(id));
                        BasicDBObject fieldObj = new BasicDBObject();
                        fieldObj.put((Object)"_id", (Object)1);
                        fieldObj.put((Object)"team", (Object)1);
                        fieldObj.put((Object)"container", (Object)1);
                        DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
                        DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)queryObj, (DBObject)fieldObj);
                        if (!teamContainerCursor.hasNext()) continue;
                        BasicDBObject teamContainerDbObject = (BasicDBObject)teamContainerCursor.next();
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setId(teamContainerDbObject.get("_id").toString());
                        DBRef teamRef = (DBRef)teamContainerDbObject.get("team");
                        if (teamRef != null && (teamDbObject = (teamCollection = this.mongoTemplate.getCollection("team")).findOne(teamRef.getId())) != null) {
                            Team team = new Team();
                            team.setId(teamDbObject.get("_id").toString());
                            team.setTitle((String)teamDbObject.get("title"));
                            team.setLabel((String)teamDbObject.get("label"));
                            teamContainer.setTeam(team);
                        }
                        if ((containerRef = (DBRef)teamContainerDbObject.get("container")) != null && (containerDbObject = (containerCollection = this.mongoTemplate.getCollection("container")).findOne(containerRef.getId())) != null) {
                            Container container = new Container();
                            container.setId(containerDbObject.get("_id").toString());
                            container.setTitle((String)containerDbObject.get("title"));
                            container.setLabel((String)containerDbObject.get("label"));
                            teamContainer.setContainer(container);
                        }
                        teamContainers.add(teamContainer);
                    }
                }
                item2.setTeamContainers(teamContainers);
                item2.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
                item2.setTfsItemType((String)dbObject.get("tfsItemType"));
                items.add(item2);
            }
            Map<String, Item> itemMap = items.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
            block5: for (TimeSeriesLog endingStatus : endingStatusMatch) {
                boolean issueTypeValid;
                Item selectedItem;
                String itemId = endingStatus.getItemId();
                if (itemId == null || !itemMap.containsKey(itemId) || (selectedItem = itemMap.get(itemId)) == null) continue;
                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                List teamContainers = Optional.ofNullable(selectedItem.getTeamContainers()).orElse(Collections.emptyList());
                if (!teamContainers.isEmpty()) {
                    for (TeamContainer teamContainer : teamContainers) {
                        String plannedKey = itemId + "-" + teamContainer.getTeam().getTitle();
                        if (farthestEndingStatusMap.containsKey(plannedKey)) {
                            TimeSeriesLog existingLog = (TimeSeriesLog)farthestEndingStatusMap.get(plannedKey);
                            if (!endingStatus.getEventTime().after(existingLog.getEventTime())) continue;
                            farthestEndingStatusMap.put(plannedKey, endingStatus);
                            continue;
                        }
                        farthestEndingStatusMap.put(plannedKey, endingStatus);
                    }
                    continue;
                }
                String unplannedKey = itemId + "-unplanned-" + UUID.randomUUID().toString();
                boolean foundMatchingItemId = false;
                if (farthestItemIds.contains(itemId)) {
                    for (String existingKey : farthestEndingStatusMap.keySet()) {
                        String[] keyParts = existingKey.split("-");
                        String existingItemId = keyParts[0];
                        if (!itemId.equals(existingItemId)) continue;
                        TimeSeriesLog existingLog = (TimeSeriesLog)farthestEndingStatusMap.get(existingKey);
                        if (endingStatus.getEventTime().after(existingLog.getEventTime())) {
                            farthestEndingStatusMap.put(existingKey, endingStatus);
                        }
                        foundMatchingItemId = true;
                        continue block5;
                    }
                    continue;
                }
                farthestItemIds.add(itemId);
                farthestEndingStatusMap.put(unplannedKey, endingStatus);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateFarthestStatusMap()" + StringUtils.getTraceString((Throwable)e));
        }
        return farthestEndingStatusMap;
    }

    private void sortTimeSeriesList(List<TimeSeriesLog> unsortedList) {
        try {
            unsortedList.sort((log1, log2) -> log1.getEventTime().compareTo(log2.getEventTime()));
        }
        catch (Exception e) {
            LOGGER.error("Error processing sortTimeSeriesList()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, TimeSeriesLog> populateFarthestStatusCategoryMap(List<TimeSeriesLog> endingStatusMatch, List<String> selectedIssueType, String sessionBoardIds, List<String> endingStatusId, String endingCategory) {
        HashMap<String, TimeSeriesLog> farthestEndingStatusMap = new HashMap<String, TimeSeriesLog>();
        try {
            if (endingStatusMatch == null) {
                return farthestEndingStatusMap;
            }
            this.sortTimeSeriesList(endingStatusMatch);
            Set itemIds = endingStatusMatch.stream().map(TimeSeriesLog::getItemId).filter(Objects::nonNull).collect(Collectors.toSet());
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraIssueTypeId", (Object)1);
            fields.put((Object)"tfsItemType", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            DBCursor cursor = collection.find((DBObject)query, (DBObject)fields);
            ArrayList<Item> items = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item2 = new Item();
                item2.setId(dbObject.get("_id").toString());
                List teamContainerRefs = (List)dbObject.get("teamContainers");
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                if (PropertyValidator.isValid((Collection)teamContainerRefs)) {
                    for (DBRef ref : teamContainerRefs) {
                        DBCollection containerCollection;
                        DBObject containerDbObject;
                        DBRef containerRef;
                        DBCollection teamCollection;
                        DBObject teamDbObject;
                        String id = ref.getId().toString();
                        BasicDBObject queryObj = new BasicDBObject();
                        queryObj.put((Object)"_id", (Object)new ObjectId(id));
                        BasicDBObject fieldObj = new BasicDBObject();
                        fieldObj.put((Object)"_id", (Object)1);
                        fieldObj.put((Object)"team", (Object)1);
                        fieldObj.put((Object)"container", (Object)1);
                        DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
                        DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)queryObj, (DBObject)fieldObj);
                        if (!teamContainerCursor.hasNext()) continue;
                        BasicDBObject teamContainerDbObject = (BasicDBObject)teamContainerCursor.next();
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setId(teamContainerDbObject.get("_id").toString());
                        DBRef teamRef = (DBRef)teamContainerDbObject.get("team");
                        if (teamRef != null && (teamDbObject = (teamCollection = this.mongoTemplate.getCollection("team")).findOne(teamRef.getId())) != null) {
                            Team team = new Team();
                            team.setId(teamDbObject.get("_id").toString());
                            team.setTitle((String)teamDbObject.get("title"));
                            team.setLabel((String)teamDbObject.get("label"));
                            teamContainer.setTeam(team);
                        }
                        if ((containerRef = (DBRef)teamContainerDbObject.get("container")) != null && (containerDbObject = (containerCollection = this.mongoTemplate.getCollection("container")).findOne(containerRef.getId())) != null) {
                            Container container = new Container();
                            container.setId(containerDbObject.get("_id").toString());
                            container.setTitle((String)containerDbObject.get("title"));
                            container.setLabel((String)containerDbObject.get("label"));
                            teamContainer.setContainer(container);
                        }
                        teamContainers.add(teamContainer);
                    }
                }
                item2.setTeamContainers(teamContainers);
                item2.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
                item2.setTfsItemType((String)dbObject.get("tfsItemType"));
                items.add(item2);
            }
            Map<String, Item> itemMap = items.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
            for (TimeSeriesLog endingStatus : endingStatusMatch) {
                String currentCategory;
                Map currentObj;
                boolean issueTypeValid;
                Item selectedItem;
                String itemId = endingStatus.getItemId();
                if (itemId == null || !itemMap.containsKey(itemId) || (selectedItem = itemMap.get(itemId)) == null) continue;
                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                List teamContainers = Optional.ofNullable(selectedItem.getTeamContainers()).orElse(Collections.emptyList());
                if (!teamContainers.isEmpty()) {
                    block6: for (TeamContainer teamContainer : teamContainers) {
                        String currentCategory2;
                        Map currentObj2;
                        String plannedKey = itemId + "-" + teamContainer.getTeam().getTitle();
                        TimeSeriesLog tempTimeSerieslogItem = (TimeSeriesLog)farthestEndingStatusMap.get(plannedKey);
                        if (tempTimeSerieslogItem != null) {
                            Map tempTimeSerieslogItemStatusObject = (Map)tempTimeSerieslogItem.getChanges().get("status");
                            String tempTimeSerieslogItemCategory = (String)tempTimeSerieslogItemStatusObject.get("category");
                            Map endingStatusObject = (Map)endingStatus.getChanges().get("status");
                            if (!PropertyValidator.isValid((Object)endingStatusObject)) continue;
                            String endingStatusCategory = (String)endingStatusObject.get("category");
                            if (!tempTimeSerieslogItemCategory.equals(endingStatusCategory)) {
                                Query queryForOtherStatus = new Query((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)endingStatus.getItemId()).and("eventTime").gt((Object)endingStatus.getEventTime()).and("changes.status.id").exists(true).ne(endingStatusId));
                                List otherStatusItems = Optional.ofNullable(this.mongoTemplate.find(queryForOtherStatus, TimeSeriesLog.class, "itemTimeSeries")).orElse(Collections.emptyList());
                                if (!otherStatusItems.isEmpty()) {
                                    this.sortTimeSeriesList(otherStatusItems);
                                }
                                for (int i = endingStatusMatch.indexOf(endingStatus) + 1; i < endingStatusMatch.size(); ++i) {
                                    Map currentObj3;
                                    String currentCategory3;
                                    if (endingStatusMatch.get(i).getChanges() == null || endingStatusMatch.get(i).getChanges().get("status") == null || !endingStatus.getItemId().equals(endingStatusMatch.get(i).getItemId()) || !(currentCategory3 = (String)(currentObj3 = (Map)endingStatusMatch.get(i).getChanges().get("status")).get("category")).equals(tempTimeSerieslogItemCategory)) continue;
                                    farthestEndingStatusMap.put(plannedKey, endingStatusMatch.get(i));
                                    continue block6;
                                }
                                continue;
                            }
                            if (farthestEndingStatusMap.containsKey(plannedKey)) continue;
                            farthestEndingStatusMap.put(plannedKey, endingStatus);
                            continue;
                        }
                        if (endingStatus.getChanges() == null || !PropertyValidator.isValid((Object)(currentObj2 = (Map)endingStatus.getChanges().get("status"))) || !endingCategory.equals(currentCategory2 = (String)currentObj2.get("category"))) continue;
                        farthestEndingStatusMap.put(plannedKey, endingStatus);
                    }
                    continue;
                }
                String unplannedKey = itemId + "-unplanned-" + UUID.randomUUID().toString();
                if (endingStatus.getChanges() == null || !PropertyValidator.isValid((Object)(currentObj = (Map)endingStatus.getChanges().get("status"))) || !endingCategory.equals(currentCategory = (String)currentObj.get("category"))) continue;
                farthestEndingStatusMap.put(unplannedKey, endingStatus);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateFarthestStatusCategoryMap()" + StringUtils.getTraceString((Throwable)e));
        }
        return farthestEndingStatusMap;
    }

    public Map<String, TimeSeriesLog> populateFarthestStatusMapForVelocity(List<TimeSeriesLog> endingStatusMatch, List<String> selectedIssueType, String sessionBoardIds) {
        HashMap<String, TimeSeriesLog> farthestEndingStatusMap = new HashMap<String, TimeSeriesLog>();
        try {
            Set itemIds = endingStatusMatch.stream().map(TimeSeriesLog::getItemId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map itemMap = this.fetchItems(itemIds);
            for (TimeSeriesLog endingStatus : endingStatusMatch) {
                boolean issueTypeValid;
                Item selectedItem;
                String itemId = endingStatus.getItemId();
                if (itemId == null || !itemMap.containsKey(itemId) || (selectedItem = (Item)itemMap.get(itemId)) == null) continue;
                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                if (PropertyValidator.isValid((Collection)selectedItem.getTeamContainers())) {
                    for (TeamContainer teamContainer : selectedItem.getTeamContainers()) {
                        String plannedKey = endingStatus.getEventTime().toString() + "-" + teamContainer.getTeam().getTitle();
                        if (farthestEndingStatusMap.containsKey(plannedKey)) {
                            plannedKey = plannedKey + "-" + UUID.randomUUID().toString();
                        }
                        farthestEndingStatusMap.put(plannedKey, endingStatus);
                    }
                    continue;
                }
                String unplannedKey = endingStatus.getEventTime().toString() + "-unplanned";
                if (farthestEndingStatusMap.containsKey(unplannedKey)) {
                    unplannedKey = unplannedKey + "-" + UUID.randomUUID().toString();
                }
                farthestEndingStatusMap.put(unplannedKey, endingStatus);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateFarthestStatusMapForVelocity()" + StringUtils.getTraceString((Throwable)e));
        }
        return farthestEndingStatusMap;
    }

    public List<Map<TimeSeriesLog, TimeSeriesLog>> populateMatchingItemsMap(List<String> doneCategoryStatusesIds, List<String> endingStatusId, Map<String, TimeSeriesLog> earliestStartingStatusMap, Map<String, TimeSeriesLog> farthestEndingStatusMap) {
        ArrayList<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsList = new ArrayList<Map<TimeSeriesLog, TimeSeriesLog>>();
        try {
            String itemId;
            if (doneCategoryStatusesIds == null || endingStatusId == null || earliestStartingStatusMap == null || farthestEndingStatusMap == null) {
                return matchingItemsList;
            }
            boolean isDoneCategorySameAsEndingStatus = doneCategoryStatusesIds.equals(endingStatusId);
            HashMap<String, TimeSeriesLog> prefixToEndingStatusMap = new HashMap<String, TimeSeriesLog>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                itemId = entry.getKey();
                String prefix = this.getPrefix(itemId);
                prefixToEndingStatusMap.put(prefix, entry.getValue());
            }
            for (Map.Entry<String, TimeSeriesLog> entry : earliestStartingStatusMap.entrySet()) {
                itemId = entry.getKey();
                TimeSeriesLog earliestStartingStatus = entry.getValue();
                String itemIdPrefix = this.getPrefix(itemId);
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)prefixToEndingStatusMap.get(itemIdPrefix);
                if (farthestEndingStatus == null) continue;
                if (isDoneCategorySameAsEndingStatus) {
                    HashMap status = (HashMap)farthestEndingStatus.getChanges().get("status");
                    if (!doneCategoryStatusesIds.contains(status.get("id"))) continue;
                    HashMap<TimeSeriesLog, TimeSeriesLog> tempMap = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                    tempMap.put(earliestStartingStatus, farthestEndingStatus);
                    matchingItemsList.add(tempMap);
                    continue;
                }
                HashMap<TimeSeriesLog, TimeSeriesLog> tempMap = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                tempMap.put(earliestStartingStatus, farthestEndingStatus);
                matchingItemsList.add(tempMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        return matchingItemsList;
    }

    private String getPrefix(String str) {
        try {
            int index = str.indexOf("-unplanned-");
            return index != -1 ? str.substring(0, index) : str;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPrefix()" + StringUtils.getTraceString((Throwable)e));
            return str;
        }
    }

    public List<TimeSeriesLog> populateActiveStatusTimeSeries(SessionBoard sb, String tenant, List<String> activeStatuses, String sessionBoardIds, Set<TimeSeriesLog> itemOfMatchingItemsMap, Map<String, List<Date>> sprintDates) {
        List<Object> activeStatusList = new ArrayList<TimeSeriesLog>();
        try {
            ArrayList<String> allSprints = new ArrayList<String>(sprintDates.keySet());
            activeStatusList = this.populateTimeSeriesItemsListbyStatus(activeStatuses, sb.getCreationDate(), sprintDates.get(allSprints.get(allSprints.size() - 1)).get(1), tenant, "itemTimeSeries", sessionBoardIds);
            ArrayList<TimeSeriesLog> filteredItems = new ArrayList<TimeSeriesLog>();
            for (TimeSeriesLog mapItem : itemOfMatchingItemsMap) {
                for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                    if (!mapItem.getItemId().equals(timeSeriesLog.getItemId())) continue;
                    filteredItems.add(timeSeriesLog);
                }
            }
            activeStatusList = filteredItems;
            activeStatusList.sort(Comparator.comparing(TimeSeriesLog::getEventTime));
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateActiveStatusTimeSeries()" + StringUtils.getTraceString((Throwable)e));
        }
        return activeStatusList;
    }

    public List<String> getDoneStatusIds(List<Status> statusList) {
        ArrayList<String> doneCategoryStatusesIds = new ArrayList<String>();
        try {
            for (Status status : statusList) {
                if (!status.getCategory().equals("Done")) continue;
                doneCategoryStatusesIds.add(status.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDoneStatusIds()" + StringUtils.getTraceString((Throwable)e));
        }
        return doneCategoryStatusesIds;
    }

    public Map<String, Object> getTeamGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId) {
        HashMap<String, Map> teamGroupByMatchingItemsMap = new HashMap<String, Map>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<String, String> teamIdColorMap = new HashMap<String, String>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            for (Map<TimeSeriesLog, TimeSeriesLog> map : matchingItemsMap) {
                for (TimeSeriesLog farthestEndingStatus : map.values()) {
                    itemIds.add(farthestEndingStatus.getItemId());
                }
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            DBCursor cursor = collection.find((DBObject)basicDBObject, (DBObject)fields);
            ArrayList<Item> items = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item2 = new Item();
                item2.setId(dbObject.get("_id").toString());
                List teamContainerRefs = (List)dbObject.get("teamContainers");
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                if (PropertyValidator.isValid((Collection)teamContainerRefs)) {
                    for (DBRef ref : teamContainerRefs) {
                        DBCollection containerCollection;
                        DBObject containerDbObject;
                        DBRef containerRef;
                        DBCollection teamCollection;
                        DBObject teamDbObject;
                        String id = ref.getId().toString();
                        BasicDBObject queryObj = new BasicDBObject();
                        queryObj.put((Object)"_id", (Object)new ObjectId(id));
                        BasicDBObject fieldObj = new BasicDBObject();
                        fieldObj.put((Object)"_id", (Object)1);
                        fieldObj.put((Object)"team", (Object)1);
                        fieldObj.put((Object)"container", (Object)1);
                        DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
                        DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)queryObj, (DBObject)fieldObj);
                        if (!teamContainerCursor.hasNext()) continue;
                        BasicDBObject teamContainerDbObject = (BasicDBObject)teamContainerCursor.next();
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setId(teamContainerDbObject.get("_id").toString());
                        DBRef teamRef = (DBRef)teamContainerDbObject.get("team");
                        if (teamRef != null && (teamDbObject = (teamCollection = this.mongoTemplate.getCollection("team")).findOne(teamRef.getId())) != null) {
                            Team team = new Team();
                            team.setId(teamDbObject.get("_id").toString());
                            team.setTitle((String)teamDbObject.get("title"));
                            team.setLabel((String)teamDbObject.get("label"));
                            team.setColor((String)teamDbObject.get("color"));
                            teamContainer.setTeam(team);
                        }
                        if ((containerRef = (DBRef)teamContainerDbObject.get("container")) != null && (containerDbObject = (containerCollection = this.mongoTemplate.getCollection("container")).findOne(containerRef.getId())) != null) {
                            Container container = new Container();
                            container.setId(containerDbObject.get("_id").toString());
                            container.setTitle((String)containerDbObject.get("title"));
                            container.setLabel((String)containerDbObject.get("label"));
                            teamContainer.setContainer(container);
                        }
                        teamContainers.add(teamContainer);
                    }
                }
                item2.setTeamContainers(teamContainers);
                items.add(item2);
            }
            Map<String, Item> itemMap = items.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
            for (Map<TimeSeriesLog, TimeSeriesLog> matchingItem : matchingItemsMap) {
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry : matchingItem.entrySet()) {
                    String itemIdFarthest;
                    Item item3;
                    TimeSeriesLog earliestStartingStatus = entry.getKey();
                    TimeSeriesLog farthestEndingStatus = entry.getValue();
                    if (farthestEndingStatus == null || (item3 = itemMap.get(itemIdFarthest = farthestEndingStatus.getItemId() != null ? farthestEndingStatus.getItemId() : "")) == null || item3.getTeamContainers() == null) continue;
                    for (TeamContainer teamContainer : item3.getTeamContainers()) {
                        Team team = teamContainer.getTeam();
                        if (team == null) continue;
                        String teamId = team.getId();
                        allGroupBysMap.put(teamId, team.getTitle());
                        teamIdColorMap.put(team.getTitle(), team.getColor());
                        teamGroupByMatchingItemsMap.computeIfAbsent(teamId, k -> new HashMap()).put(earliestStartingStatus, farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("teamGroupByMatchingItemsMap", teamGroupByMatchingItemsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("teamIdColorMap", teamIdColorMap);
        return result;
    }

    public Map<String, Object> getCardTypeGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId) {
        HashMap<List<IssueType>, Map> issueGroupByMatchingItemsMap = new HashMap<List<IssueType>, Map>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashMap<List, Map> tempIssueGroupByMatchingItemsMap = new HashMap<List, Map>();
        HashMap<String, String> cardTypeColorMap = new HashMap<String, String>();
        HashMap updatedMap = new HashMap();
        try {
            Object issueType;
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>> itemIdToEntryMap = new HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>>();
            for (Map<TimeSeriesLog, TimeSeriesLog> map : matchingItemsMap) {
                Map.Entry<TimeSeriesLog, TimeSeriesLog> entry = map.entrySet().iterator().next();
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToEntryMap.put(farthestEndingStatus.getItemId(), entry);
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"type", (Object)1);
            fields.put((Object)"teamContainers", (Object)1);
            fields.put((Object)"issueType", (Object)1);
            DBCursor cursor = collection.find((DBObject)basicDBObject, (DBObject)fields);
            ArrayList<Item> allItems = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                List teamContainerRefs = (List)dbObject.get("teamContainers");
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                if (PropertyValidator.isValid((Collection)teamContainerRefs)) {
                    for (DBRef ref : teamContainerRefs) {
                        DBCollection containerCollection;
                        DBObject containerDbObject;
                        DBRef containerRef;
                        DBCollection teamCollection;
                        DBObject teamDbObject;
                        String id = ref.getId().toString();
                        BasicDBObject queryObj = new BasicDBObject();
                        queryObj.put((Object)"_id", (Object)new ObjectId(id));
                        BasicDBObject fieldObj = new BasicDBObject();
                        fieldObj.put((Object)"_id", (Object)1);
                        fieldObj.put((Object)"team", (Object)1);
                        fieldObj.put((Object)"container", (Object)1);
                        DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
                        DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)queryObj, (DBObject)fieldObj);
                        if (!teamContainerCursor.hasNext()) continue;
                        BasicDBObject teamContainerDbObject = (BasicDBObject)teamContainerCursor.next();
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setId(teamContainerDbObject.get("_id").toString());
                        DBRef teamRef = (DBRef)teamContainerDbObject.get("team");
                        if (teamRef != null && (teamDbObject = (teamCollection = this.mongoTemplate.getCollection("team")).findOne(teamRef.getId())) != null) {
                            Team team = new Team();
                            team.setId(teamDbObject.get("_id").toString());
                            team.setTitle((String)teamDbObject.get("title"));
                            team.setLabel((String)teamDbObject.get("label"));
                            teamContainer.setTeam(team);
                        }
                        if ((containerRef = (DBRef)teamContainerDbObject.get("container")) != null && (containerDbObject = (containerCollection = this.mongoTemplate.getCollection("container")).findOne(containerRef.getId())) != null) {
                            Container container = new Container();
                            container.setId(containerDbObject.get("_id").toString());
                            container.setTitle((String)containerDbObject.get("title"));
                            container.setLabel((String)containerDbObject.get("label"));
                            teamContainer.setContainer(container);
                        }
                        teamContainers.add(teamContainer);
                    }
                }
                item.setTeamContainers(teamContainers);
                if (PropertyValidator.isValid((Object)dbObject)) {
                    if (PropertyValidator.isValid((Object)dbObject.get("type"))) {
                        item.setType((String)dbObject.get("type"));
                    }
                    if (PropertyValidator.isValid((Object)dbObject.get("issueType"))) {
                        DBRef issueTypeRef = (DBRef)dbObject.get("issueType");
                        String issueTypeId = issueTypeRef.getId().toString();
                        if (ObjectId.isValid((String)issueTypeId)) {
                            Query queryForIssueType = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(issueTypeId)));
                            queryForIssueType.fields().include("title");
                            queryForIssueType.fields().include("color");
                            queryForIssueType.fields().include("textColor");
                            IssueType issueTypeResult = (IssueType)this.mongoTemplate.findOne(queryForIssueType, IssueType.class);
                            item.setIssueType(issueTypeResult);
                        } else {
                            issueType = new IssueType();
                            issueType.setTitle("Feature");
                            issueType.setId("Feature");
                            issueType.setColor("#732E95");
                            item.setIssueType((IssueType)issueType);
                        }
                    } else {
                        IssueType issueType2 = new IssueType();
                        issueType2.setTitle("Feature");
                        issueType2.setId("Feature");
                        issueType2.setColor("#732E95");
                        item.setIssueType(issueType2);
                    }
                }
                allItems.add(item);
            }
            for (Item item : allItems) {
                List<IssueType> issueTypes;
                Map.Entry entry = (Map.Entry)itemIdToEntryMap.get(item.getId().toString());
                if (entry == null) continue;
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                if (!"Feature".equals(item.getType())) continue;
                if (item.getIssueType() != null) {
                    HashSet<String> selectedIssueTypes = new HashSet<String>();
                    selectedIssueTypes.add(item.getIssueType().getId());
                    Query queryForIssueType = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(selectedIssueTypes));
                    issueTypes = this.mongoTemplate.find(queryForIssueType, IssueType.class);
                    if (!PropertyValidator.isValid((Collection)issueTypes)) {
                        IssueType issueType3 = new IssueType();
                        issueType3.setTitle("Feature");
                        issueType3.setId("Feature");
                        issueType3.setColor("#732E95");
                        issueTypes = Collections.singletonList(issueType3);
                    }
                } else {
                    issueType = new IssueType();
                    issueType.setTitle("Feature");
                    issueType.setId("Feature");
                    issueType.setColor("#732E95");
                    issueTypes = Collections.singletonList(issueType);
                }
                for (IssueType issueType4 : issueTypes) {
                    allGroupBysMap.put(issueType4.getId(), issueType4.getTitle());
                    cardTypeColorMap.put(issueType4.getTitle(), issueType4.getColor());
                }
                List issueTypeListString = issueTypes.stream().map(IssueType::getId).collect(Collectors.toList());
                HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                selectedMatchingItem.put(earliestStartingStatus, farthestEndingStatus);
                Map tempMap2 = (Map)tempIssueGroupByMatchingItemsMap.get(issueTypeListString);
                if (tempMap2 == null) {
                    tempIssueGroupByMatchingItemsMap.put(issueTypeListString, selectedMatchingItem);
                    issueGroupByMatchingItemsMap.put(issueTypes, selectedMatchingItem);
                    continue;
                }
                tempMap2.putAll(selectedMatchingItem);
                issueGroupByMatchingItemsMap.put(issueTypes, tempMap2);
                tempIssueGroupByMatchingItemsMap.put(issueTypeListString, tempMap2);
            }
            tempIssueGroupByMatchingItemsMap.forEach((key, value) -> {
                List updatedKeySet = key.stream().map(allGroupBysMap::get).collect(Collectors.toList());
                updatedMap.put(updatedKeySet, value);
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("issueGroupByMatchingItemsMap", updatedMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("cardtypeColorMap", cardTypeColorMap);
        return result;
    }

    public Map<String, Object> getPlannedUnPlannedGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId) {
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        try {
            matchingItemsMap.forEach(matchingItem -> {
                HashSet<String> allPlannedUnplanned = new HashSet<String>();
                Map.Entry entry = matchingItem.entrySet().iterator().next();
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                String itemIdFarthest = null;
                Query queryForTeamContainer = null;
                if (farthestEndingStatus.getJiraKey() != null) {
                    itemIdFarthest = farthestEndingStatus.getJiraKey();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    itemIdFarthest = farthestEndingStatus.getTfsId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else {
                    itemIdFarthest = farthestEndingStatus.getItemId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemIdFarthest)).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForTeamContainer, Item.class);
                if (item != null && item.getTeamContainers() != null && !item.getTeamContainers().isEmpty()) {
                    allPlannedUnplanned.add("Planned");
                } else {
                    allPlannedUnplanned.add("Unplanned");
                }
                int index = 0;
                for (String plannedUnplanned : allPlannedUnplanned) {
                    allGroupBysMap.put(String.valueOf(index), plannedUnplanned);
                    ++index;
                    ArrayList allPlannedUnplannedList = new ArrayList(allPlannedUnplanned);
                    Map tempMap = (Map)plannedUnplannedStatusMap.get(allPlannedUnplannedList);
                    if (tempMap != null) {
                        tempMap.put(earliestStartingStatus, farthestEndingStatus);
                        plannedUnplannedStatusMap.put(allPlannedUnplannedList, tempMap);
                        continue;
                    }
                    HashMap<TimeSeriesLog, TimeSeriesLog> newMap = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                    newMap.put(earliestStartingStatus, farthestEndingStatus);
                    plannedUnplannedStatusMap.put(allPlannedUnplannedList, newMap);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPlannedUnPlannedGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("plannedUnplannedStatusMap", plannedUnplannedStatusMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getJiraProjectGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId, Dashboard dashboard) {
        HashMap jiraProjectIssueTypeMap = new HashMap();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashMap<String, String> jiraProjectColorMap = new HashMap<String, String>();
        HashSet<String> itemIds = new HashSet<String>();
        Map globalColorsMap = new HashMap();
        try {
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>> itemIdToEntryMap = new HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>>();
            for (Map<TimeSeriesLog, TimeSeriesLog> map : matchingItemsMap) {
                Map.Entry<TimeSeriesLog, TimeSeriesLog> entry = map.entrySet().iterator().next();
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToEntryMap.put(farthestEndingStatus.getItemId(), entry);
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraProjectKey", (Object)1);
            DBCursor cursor = collection.find((DBObject)basicDBObject, (DBObject)fields);
            ArrayList<Item> allItems = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                item.setJiraProjectKey((String)dbObject.get("jiraProjectKey"));
                allItems.add(item);
            }
            Set jiraProjectKeys = allItems.stream().map(Item::getJiraProjectKey).filter(Objects::nonNull).collect(Collectors.toSet());
            Query jiraProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"jiraProjectKey").in(jiraProjectKeys));
            List jiraProjectIssueTypesList = Optional.ofNullable(this.mongoTemplate.find(jiraProjectQuery, JiraProjectIssueTypes.class)).orElse(Collections.emptyList());
            Map<String, JiraProjectIssueTypes> jiraProjectIssueTypesMap = jiraProjectIssueTypesList.stream().filter(tfsProject -> tfsProject.getJiraProjectKey() != null).collect(Collectors.toMap(JiraProjectIssueTypes::getJiraProjectKey, t -> t, (existing, replacement) -> existing));
            for (Item item : allItems) {
                JiraProjectIssueTypes jiraProjectIssueType;
                Map.Entry entry = (Map.Entry)itemIdToEntryMap.get(item.getId().toString());
                if (entry == null) continue;
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                String jiraProjectKey = item.getJiraProjectKey();
                if (jiraProjectKey == null || (jiraProjectIssueType = jiraProjectIssueTypesMap.get(jiraProjectKey)) == null) continue;
                List<JiraProjectIssueTypes> jiraProjectIssueTypes = Collections.singletonList(jiraProjectIssueType);
                for (JiraProjectIssueTypes jiraProjectIssueTyp : jiraProjectIssueTypes) {
                    allGroupBysMap.put(jiraProjectIssueTyp.getJiraProjectId(), jiraProjectIssueTyp.getJiraProjectKey());
                    if (globalColorsMap.containsKey(jiraProjectIssueTyp.getJiraProjectKey())) {
                        jiraProjectColorMap.put(jiraProjectIssueTyp.getJiraProjectKey(), globalColorsMap.get(jiraProjectIssueTyp.getJiraProjectKey()).toString());
                    } else {
                        jiraProjectColorMap.put(jiraProjectIssueTyp.getJiraProjectKey(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"jiraProject", (String)""));
                        globalColorsMap.put(jiraProjectIssueTyp.getJiraProjectKey(), jiraProjectColorMap.get(jiraProjectIssueTyp.getJiraProjectKey()));
                    }
                    HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                    selectedMatchingItem.put(earliestStartingStatus, farthestEndingStatus);
                    ArrayList<JiraProjectIssueTypes> tempProjectIssueTypes = new ArrayList<JiraProjectIssueTypes>(jiraProjectIssueTypes);
                    Map tempMap = (Map)jiraProjectIssueTypeMap.get(tempProjectIssueTypes);
                    if (tempMap != null) {
                        tempMap.putAll(selectedMatchingItem);
                        continue;
                    }
                    jiraProjectIssueTypeMap.put(tempProjectIssueTypes, selectedMatchingItem);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("jiraProjectIssueTypeMap", jiraProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("jiraProjectColorMap", jiraProjectColorMap);
        dashboard.setGlobalColorsMap(globalColorsMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getTFSProjectGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId, Dashboard dashboard) {
        HashMap<ArrayList<TFSProject>, Map> tfsProjectIssueTypeMap = new HashMap<ArrayList<TFSProject>, Map>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<String, String> tfsProjectColorMap = new HashMap<String, String>();
        Map globalColorsMap = new HashMap();
        try {
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>> itemIdToEntryMap = new HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>>();
            for (Map<TimeSeriesLog, TimeSeriesLog> map : matchingItemsMap) {
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry : map.entrySet()) {
                    TimeSeriesLog farthestEndingStatus = entry.getValue();
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToEntryMap.put(farthestEndingStatus.getItemId(), entry);
                }
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"tfsId", (Object)1);
            fields.put((Object)"tfsProjectId", (Object)1);
            DBCursor cursor = collection.find((DBObject)basicDBObject, (DBObject)fields);
            ArrayList<Item> allItems = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                item.setTfsId((String)dbObject.get("tfsId"));
                item.setTfsProjectId((String)dbObject.get("tfsProjectId"));
                allItems.add(item);
            }
            Set tfsProjectIds = allItems.stream().map(Item::getTfsProjectId).filter(Objects::nonNull).collect(Collectors.toSet());
            Query tfsProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").in(tfsProjectIds));
            List tfsProjectList = Optional.ofNullable(this.mongoTemplate.find(tfsProjectQuery, TFSProject.class)).orElse(Collections.emptyList());
            Map<String, TFSProject> tfsProjectMap = tfsProjectList.stream().filter(tfsProject -> tfsProject.getTfsId() != null).collect(Collectors.toMap(TFSProject::getTfsId, t -> t, (existing, replacement) -> existing));
            for (Item item : allItems) {
                TFSProject tfsProject2;
                Map.Entry entry = (Map.Entry)itemIdToEntryMap.get(item.getId().toString());
                if (entry == null) continue;
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                String tfsProjectId = item.getTfsProjectId();
                if (tfsProjectId == null || (tfsProject2 = tfsProjectMap.get(tfsProjectId)) == null) continue;
                List<TFSProject> tfsProjects = Collections.singletonList(tfsProject2);
                for (TFSProject tfsProjectIssueType : tfsProjects) {
                    allGroupBysMap.put(tfsProjectIssueType.getTfsId(), tfsProjectIssueType.getName());
                    if (globalColorsMap.containsKey(tfsProjectIssueType.getTfsId())) {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), globalColorsMap.get(tfsProjectIssueType.getTfsId()).toString());
                    } else {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"tfsProject", (String)""));
                        globalColorsMap.put(tfsProjectIssueType.getTfsId(), tfsProjectColorMap.get(tfsProjectIssueType.getName()));
                    }
                    HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                    selectedMatchingItem.put(earliestStartingStatus, farthestEndingStatus);
                    ArrayList<TFSProject> tempProjectIssueTypes = new ArrayList<TFSProject>(tfsProjects);
                    Map tempMap = (Map)tfsProjectIssueTypeMap.get(tempProjectIssueTypes);
                    if (tempMap != null) {
                        tempMap.putAll(selectedMatchingItem);
                        tfsProjectIssueTypeMap.put(tempProjectIssueTypes, tempMap);
                        continue;
                    }
                    tfsProjectIssueTypeMap.put(tempProjectIssueTypes, selectedMatchingItem);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tfsProjectIssueTypeMap", tfsProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("tfsProjectColorMap", tfsProjectColorMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getAreaPathGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId, Dashboard dashboard) {
        HashMap areaPathMap = new HashMap();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allAreaPaths = new HashSet<String>();
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>> itemIdToEntryMap = new HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>>();
        Map globalColorsMap = new HashMap();
        HashMap<String, String> areaPathColorMap = new HashMap<String, String>();
        try {
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            for (Map<TimeSeriesLog, TimeSeriesLog> map : matchingItemsMap) {
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry : map.entrySet()) {
                    TimeSeriesLog farthestEndingStatus = entry.getValue();
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToEntryMap.put(farthestEndingStatus.getItemId(), entry);
                }
            }
            HashSet<ObjectId> ids = new HashSet<ObjectId>();
            for (String id : itemIds) {
                ids.add(new ObjectId(id));
            }
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.put((Object)"_id", (Object)new BasicDBObject("$in", ids));
            DBCollection collection = this.mongoTemplate.getCollection("item");
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"tfsAreaPath", (Object)1);
            DBCursor cursor = collection.find((DBObject)basicDBObject, (DBObject)fields);
            ArrayList<Item> allItems = new ArrayList<Item>();
            while (cursor.hasNext()) {
                DBObject dbObject = cursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                item.setTfsAreaPath((String)dbObject.get("tfsAreaPath"));
                allItems.add(item);
            }
            for (Item item : allItems) {
                Map.Entry entry = (Map.Entry)itemIdToEntryMap.get(item.getId().toString());
                if (entry == null) continue;
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                String areaPath = item.getTfsAreaPath();
                if (areaPath == null) continue;
                allAreaPaths.add(areaPath);
                allGroupBysMap.put(areaPath, areaPath);
                if (globalColorsMap.containsKey(areaPath)) {
                    areaPathColorMap.put(areaPath, globalColorsMap.get(areaPath).toString());
                } else {
                    areaPathColorMap.put(areaPath, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"areaPath", (String)""));
                    globalColorsMap.put(areaPath, areaPathColorMap.get(areaPath));
                }
                ArrayList<String> areaPathsList = new ArrayList<String>();
                areaPathsList.add(areaPath);
                HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                selectedMatchingItem.put(earliestStartingStatus, farthestEndingStatus);
                HashMap tempMap = (HashMap)areaPathMap.get(areaPathsList);
                if (tempMap != null) {
                    tempMap.putAll(selectedMatchingItem);
                } else {
                    tempMap = new HashMap(selectedMatchingItem);
                }
                areaPathMap.put(areaPathsList, tempMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAreaPathGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("areaPathMap", areaPathMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("areaPathColorMap", areaPathColorMap);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(query, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getParentEpicGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String sessionBoardId) {
        HashMap parentEpicMap = new HashMap();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allParentEpics = new HashSet<String>();
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>> itemIdToEntryMap = new HashMap<String, Map.Entry<TimeSeriesLog, TimeSeriesLog>>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            if (matchingItemsMap == null || sessionBoardId == null) {
                return Collections.emptyMap();
            }
            for (Map<TimeSeriesLog, TimeSeriesLog> itemPair : matchingItemsMap) {
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry : itemPair.entrySet()) {
                    TimeSeriesLog farthestEndingStatus = entry.getValue();
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToEntryMap.put(farthestEndingStatus.getItemId(), entry);
                }
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())).and("tfsFieldByKey.ParentId").exists(true).and("tfsFieldByKey.ParentTitle").exists(true).and("sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)).and("tenant").is((Object)tenant));
            query.fields().include("_id").include("tfsFieldByKey.ParentId").include("tfsFieldByKey.ParentTitle");
            List allItems = Optional.ofNullable(this.mongoTemplate.find(query, Item.class)).orElse(Collections.emptyList());
            for (Item item : allItems) {
                Map.Entry entry = (Map.Entry)itemIdToEntryMap.get(item.getId().toString());
                if (entry == null) continue;
                TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry.getKey();
                TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry.getValue();
                Map tfsFieldByKey = item.getTfsFieldByKey();
                if (tfsFieldByKey == null) continue;
                String parentEpicKey = tfsFieldByKey.get("ParentId").toString() + " " + tfsFieldByKey.get("ParentTitle").toString();
                String parentIdKey = item.getTfsId() + " " + tfsFieldByKey.get("ParentTitle").toString();
                allParentEpics.add(parentEpicKey);
                allGroupBysMap.put(parentIdKey, parentEpicKey);
                ArrayList parentEpicsList = new ArrayList(allParentEpics);
                HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                selectedMatchingItem.put(earliestStartingStatus, farthestEndingStatus);
                HashMap tempMap = (HashMap)parentEpicMap.get(parentEpicsList);
                if (tempMap != null) {
                    tempMap.putAll(selectedMatchingItem);
                } else {
                    tempMap = new HashMap(selectedMatchingItem);
                }
                parentEpicMap.put(parentEpicsList, tempMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getParentEpicGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("parentEpicMap", parentEpicMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getJiraCustomFieldGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String groupByValue, String sessionBoardId) {
        HashMap customFieldsMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        try {
            matchingItemsMap.forEach(map -> map.forEach((earliestStartingStatus, farthestEndingStatus) -> {
                Map customFields;
                Query queryForTeamContainer;
                String itemIdFarthest;
                HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                selectedMatchingItem.put((TimeSeriesLog)earliestStartingStatus, (TimeSeriesLog)farthestEndingStatus);
                if (farthestEndingStatus.getJiraKey() != null) {
                    itemIdFarthest = farthestEndingStatus.getJiraKey();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    itemIdFarthest = farthestEndingStatus.getTfsId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else {
                    itemIdFarthest = farthestEndingStatus.getItemId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemIdFarthest)).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForTeamContainer, Item.class);
                if (item != null && (customFields = item.getJiraFieldByKey()) != null) {
                    for (Map.Entry entry : customFields.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (!key.equals(groupByValue)) continue;
                        this.handleCustomFieldValue(groupByValue, value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
                    }
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraCustomFieldGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("customFieldsMap", customFieldsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    private void handleCustomFieldValue(String groupByValue, Object value, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            if (value instanceof String) {
                this.handleStringValue(groupByValue, (String)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof List) {
                this.handleListValue(groupByValue, (List)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof Map) {
                this.handleMapValue(groupByValue, (Map)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof Boolean) {
                this.handleBooleanValue(groupByValue, (Boolean)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof Number) {
                if (value instanceof Double) {
                    this.handleDoubleValue(groupByValue, (Double)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
                } else if (value instanceof Long) {
                    this.handleLongValue(groupByValue, (Long)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
                } else {
                    this.handleNumberValue(groupByValue, (Number)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
                }
            } else if (value instanceof Date) {
                this.handleDateValue(groupByValue, (Date)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof Float) {
                this.handleFloatValue(groupByValue, (Float)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value instanceof BigDecimal) {
                this.handleBigDecimalValue(groupByValue, (BigDecimal)value, allGroupBysMap, customFieldsMap, selectedMatchingItem);
            } else if (value != null) {
                System.out.println("Unsupported custom field type: " + value.getClass().getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing handleCustomFieldValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleStringValue(String groupByValue, String stringValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            allGroupBysMap.put(groupByValue, stringValue);
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(stringValue);
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleStringValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleListValue(String groupByValue, List<?> list, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            for (Object customField : list) {
                if (customField == null) continue;
                if (customField instanceof Map) {
                    Map customFieldMap = (Map)customField;
                    Object value = customFieldMap.get("value");
                    if (value == null) continue;
                    String keyWithValue = groupByValue + value.toString();
                    allGroupBysMap.put(keyWithValue, value.toString());
                    ArrayList<String> customFieldList = new ArrayList<String>();
                    customFieldList.add(value.toString());
                    List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
                    tempList.add(selectedMatchingItem);
                    customFieldsMap.put(customFieldList, tempList);
                    continue;
                }
                if (customField instanceof String) {
                    String stringValue = (String)customField;
                    String keyWithValue = groupByValue + stringValue;
                    allGroupBysMap.put(keyWithValue, stringValue);
                    ArrayList<String> customFieldList = new ArrayList<String>();
                    customFieldList.add(stringValue);
                    List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
                    tempList.add(selectedMatchingItem);
                    customFieldsMap.put(customFieldList, tempList);
                    continue;
                }
                System.out.println("Unsupported custom field type in list");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleListValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleMapValue(String groupByValue, Map<?, ?> mapValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            Object value = mapValue.get("displayName");
            if (value != null && value instanceof String) {
                String displayName = (String)value;
                String keyWithValue = groupByValue + displayName;
                allGroupBysMap.put(keyWithValue, displayName);
                ArrayList<String> customFieldList = new ArrayList<String>();
                customFieldList.add(displayName);
                List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
                tempList.add(selectedMatchingItem);
                customFieldsMap.put(customFieldList, tempList);
            } else {
                Object valueOfCustomField = mapValue.get("value");
                if (valueOfCustomField != null) {
                    String keyWithValue = groupByValue + valueOfCustomField.toString();
                    allGroupBysMap.put(keyWithValue, valueOfCustomField.toString());
                    ArrayList<String> customFieldList = new ArrayList<String>();
                    customFieldList.add(valueOfCustomField.toString());
                    List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
                    tempList.add(selectedMatchingItem);
                    customFieldsMap.put(customFieldList, tempList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleMapValue()()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleBooleanValue(String groupByValue, Boolean booleanValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + booleanValue.toString();
            allGroupBysMap.put(keyWithValue, booleanValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(booleanValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields:  handleBooleanValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleNumberValue(String groupByValue, Number numberValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + numberValue.toString();
            allGroupBysMap.put(keyWithValue, numberValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(numberValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleNumberValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleDateValue(String groupByValue, Date dateValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String dateString = dateFormat.format(dateValue);
            String keyWithValue = groupByValue + dateString;
            allGroupBysMap.put(keyWithValue, dateString);
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(dateString);
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleDateValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleBigDecimalValue(String groupByValue, BigDecimal bigDecimalValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + bigDecimalValue.toString();
            allGroupBysMap.put(keyWithValue, bigDecimalValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(bigDecimalValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleBigDecimalValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleLongValue(String groupByValue, Long longValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + longValue.toString();
            allGroupBysMap.put(keyWithValue, longValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(longValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleLongValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleDoubleValue(String groupByValue, Double doubleValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + doubleValue.toString();
            allGroupBysMap.put(keyWithValue, doubleValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(doubleValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleDoubleValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void handleFloatValue(String groupByValue, Float floatValue, Map<String, String> allGroupBysMap, Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem) {
        try {
            String keyWithValue = groupByValue + floatValue.toString();
            allGroupBysMap.put(keyWithValue, floatValue.toString());
            ArrayList<String> customFieldList = new ArrayList<String>();
            customFieldList.add(floatValue.toString());
            List tempList = customFieldsMap.getOrDefault(customFieldList, new ArrayList());
            tempList.add(selectedMatchingItem);
            customFieldsMap.put(customFieldList, tempList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing custom fields: handleFloatValue()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, Object> getTFSCustomFieldGroupByMatchingItemsMap(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String groupByValue, String sessionBoardId) {
        HashMap customFieldsMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        try {
            matchingItemsMap.forEach(map -> map.forEach((earliestStartingStatus, farthestEndingStatus) -> {
                HashMap<TimeSeriesLog, TimeSeriesLog> selectedMatchingItem = new HashMap<TimeSeriesLog, TimeSeriesLog>();
                selectedMatchingItem.put((TimeSeriesLog)earliestStartingStatus, (TimeSeriesLog)farthestEndingStatus);
                String itemIdFarthest = null;
                Query queryForTeamContainer = null;
                if (farthestEndingStatus.getJiraKey() != null) {
                    itemIdFarthest = farthestEndingStatus.getJiraKey();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    itemIdFarthest = farthestEndingStatus.getTfsId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)itemIdFarthest).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                } else {
                    itemIdFarthest = farthestEndingStatus.getItemId();
                    queryForTeamContainer = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemIdFarthest)).and("sessionBoards.$id").in(new Object[]{new ObjectId(sessionBoardId)}));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForTeamContainer, Item.class);
                if (item != null && item.getTfsFieldMap() != null) {
                    item.getTfsFieldMap().forEach(field -> {
                        if (field.getKey().equals(groupByValue)) {
                            String fieldValue = field.getValue();
                            allGroupBysMap.put(field.getKey(), fieldValue);
                            ArrayList<String> customFieldList = new ArrayList<String>();
                            customFieldList.add(fieldValue);
                            customFieldsMap.put(customFieldList, selectedMatchingItem);
                        }
                    });
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSCustomFieldGroupByMatchingItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("customFieldsMap", customFieldsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getTeamGroupByFurthestItemsMap(Map<String, TimeSeriesLog> combinedMap) {
        HashMap<String, List> teamGroupByMatchingItemsMap = new HashMap<String, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashMap<String, String> teamIdColorMap = new HashMap<String, String>();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : combinedMap.entrySet()) {
                String itemId = entry.getValue().getItemId();
                if (itemId == null) continue;
                itemIds.add(itemId);
                itemIdToFarthestStatusMap.computeIfAbsent(itemId, k -> new ArrayList()).add(entry.getValue());
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set teamIds = allItems.stream().filter(Objects::nonNull).flatMap(item -> {
                List containers = item.getTeamContainers();
                if (containers == null) {
                    return Stream.empty();
                }
                return containers.stream().filter(Objects::nonNull).map(teamContainer -> {
                    Team team = teamContainer.getTeam();
                    return team != null ? team.getId() : null;
                }).filter(Objects::nonNull);
            }).collect(Collectors.toSet());
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds));
            teamQuery.fields().include("_id").include("title").include("color");
            List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
            Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(BaseEntity::getId, team -> team, (existing, replacement) -> existing));
            for (Item item2 : allItems) {
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item2.getId().toString());
                if (farthestEndingStatusList == null || item2.getTeamContainers() == null) continue;
                for (TeamContainer teamContainer : item2.getTeamContainers()) {
                    Team team2 = teamMap.get(teamContainer.getTeam().getId());
                    if (team2 == null) continue;
                    allGroupBysMap.put(team2.getId(), team2.getTitle());
                    teamIdColorMap.put(team2.getTitle(), team2.getColor());
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        teamGroupByMatchingItemsMap.computeIfAbsent(team2.getId(), k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("teamGroupByMatchingItemsMap", teamGroupByMatchingItemsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("teamIdColorMap", teamIdColorMap);
        return result;
    }

    public Map<String, Object> getTeamGroupByLatestItemsMap(Map<String, TimeSeriesLog> combinedMap) throws Exception {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Going to group all items by teams at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        HashMap<String, List> teamGroupByMatchingItemsMap = new HashMap<String, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashMap<String, String> teamIdColorMap = new HashMap<String, String>();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : combinedMap.entrySet()) {
                String itemId = entry.getValue().getItemId();
                if (itemId == null) continue;
                itemIds.add(itemId);
                itemIdToFarthestStatusMap.computeIfAbsent(itemId, k -> new ArrayList()).add(entry.getValue());
            }
            Map itemsMap = this.fetchAllItems(itemIds);
            Collection allItems = itemsMap.values();
            HashSet<String> teamIds = new HashSet<String>();
            for (TimeSeriesLog entry : combinedMap.values()) {
                ArrayList teamsList = (ArrayList)entry.getTeamContainers();
                if (!PropertyValidator.isValid((Collection)teamsList)) continue;
                for (Object teamContainer : teamsList) {
                    ObjectId itemTeamId;
                    BasicDBObject obj;
                    BasicDBObject itemTeam;
                    if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(itemTeam = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("team"))) || !PropertyValidator.isValid((Object)(itemTeamId = (ObjectId)itemTeam.get("_id")))) continue;
                    teamIds.add(itemTeamId.toString());
                }
            }
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds));
            teamQuery.fields().include("_id").include("title").include("color");
            List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
            Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(BaseEntity::getId, team -> team, (existing, replacement) -> existing));
            for (Item item : allItems) {
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || item.getTeamContainers() == null) continue;
                for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                    ArrayList teamsList = (ArrayList)farthestEndingStatus.getTeamContainers();
                    if (!PropertyValidator.isValid((Collection)teamsList)) continue;
                    for (Object teamContainer : teamsList) {
                        BasicDBObject obj;
                        BasicDBObject itemTeam;
                        if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(itemTeam = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("team")))) continue;
                        ObjectId itemTeamId = (ObjectId)itemTeam.get("_id");
                        Team team2 = teamMap.get(itemTeamId.toString());
                        if (PropertyValidator.isValid((Object)team2)) {
                            allGroupBysMap.put(team2.getId(), team2.getTitle());
                            teamIdColorMap.put(team2.getTitle(), team2.getColor());
                        }
                        teamGroupByMatchingItemsMap.computeIfAbsent(itemTeamId.toString(), k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamGroupByLatestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("teamGroupByMatchingItemsMap", teamGroupByMatchingItemsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("teamIdColorMap", teamIdColorMap);
        LOGGER.info("All items grouped by teams at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        return result;
    }

    public Map<String, Object> getTeamGroupByForFlowLoad(Map<String, List<TimeSeriesLog>> combinedMap) {
        HashMap<String, List> teamGroupByMatchingItemsMap = new HashMap<String, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashMap<String, String> teamIdColorMap = new HashMap<String, String>();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog log : entry.getValue()) {
                    String itemId = log.getItemId();
                    if (itemId == null) continue;
                    itemIds.add(itemId);
                    itemIdToFarthestStatusMap.computeIfAbsent(itemId, k -> new ArrayList()).add(log);
                }
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set teamIds = allItems.stream().filter(Objects::nonNull).flatMap(item -> {
                List containers = item.getTeamContainers();
                if (containers == null) {
                    return Stream.empty();
                }
                return containers.stream().filter(Objects::nonNull).map(teamContainer -> {
                    Team team = teamContainer.getTeam();
                    return team != null ? team.getId() : null;
                }).filter(Objects::nonNull);
            }).collect(Collectors.toSet());
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds));
            teamQuery.fields().include("_id").include("title").include("color");
            List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
            Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(BaseEntity::getId, team -> team, (existing, replacement) -> existing));
            for (Item item2 : allItems) {
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item2.getId().toString());
                if (farthestEndingStatusList == null || item2.getTeamContainers() == null) continue;
                for (TeamContainer teamContainer : item2.getTeamContainers()) {
                    Team team2 = teamMap.get(teamContainer.getTeam().getId());
                    if (team2 == null) continue;
                    allGroupBysMap.put(team2.getId(), team2.getTitle());
                    teamIdColorMap.put(team2.getTitle(), team2.getColor());
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        teamGroupByMatchingItemsMap.computeIfAbsent(team2.getId(), k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamGroupByForFlowLoad()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("teamGroupByMatchingItemsMap", teamGroupByMatchingItemsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("teamIdColorMap", teamIdColorMap);
        return result;
    }

    public Map<String, Object> getCardTypeGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap) {
        HashMap<List, List> issueTypeStatusMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<IssueType> allCardTypes = new HashSet<IssueType>();
        HashMap<String, String> cardTypeColorMap = new HashMap<String, String>();
        try {
            if (farthestEndingStatusMap == null || farthestEndingStatusMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                if (farthestEndingStatus.getItemId() == null) continue;
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set issueTypeIds = allItems.stream().map(Item::getIssueType).filter(Objects::nonNull).map(IssueType::getId).collect(Collectors.toSet());
            Query issueTypeQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(issueTypeIds));
            List allIssueTypes = Optional.ofNullable(this.mongoTemplate.find(issueTypeQuery, IssueType.class)).orElse(Collections.emptyList());
            Map<String, IssueType> issueTypeMap = allIssueTypes.stream().collect(Collectors.toMap(IssueType::getId, issueType -> issueType, (existing, replacement) -> existing));
            for (Item item : allItems) {
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null) continue;
                ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
                if (!"Feature".equals(item.getType())) continue;
                if (item.getIssueType() != null) {
                    IssueType issueType2 = issueTypeMap.get(item.getIssueType().getId());
                    if (issueType2 != null) {
                        issueTypes.add(issueType2);
                    } else {
                        IssueType featureType = new IssueType();
                        featureType.setTitle("Feature");
                        featureType.setId("Feature");
                        featureType.setColor("#732E95");
                        issueTypes.add(featureType);
                    }
                } else {
                    IssueType featureType = new IssueType();
                    featureType.setTitle("Feature");
                    featureType.setId("Feature");
                    featureType.setColor("#732E95");
                    issueTypes.add(featureType);
                }
                for (IssueType issueType3 : issueTypes) {
                    allCardTypes.add(issueType3);
                    allGroupBysMap.put(issueType3.getId(), issueType3.getTitle());
                    cardTypeColorMap.put(issueType3.getTitle(), issueType3.getColor());
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        issueTypeStatusMap.computeIfAbsent(issueTypes, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("issueTypeStatusMap", issueTypeStatusMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("cardtypeColorMap", cardTypeColorMap);
        return result;
    }

    public Map<String, Object> getCardTypeGroupForFlowLoad(Map<String, List<TimeSeriesLog>> combinedMap) {
        HashMap<List, List> issueTypeStatusMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<IssueType> allCardTypes = new HashSet<IssueType>();
        HashMap<String, String> cardTypeColorMap = new HashMap<String, String>();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog farthestEndingStatus : entry.getValue()) {
                    if (farthestEndingStatus.getItemId() == null) continue;
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set issueTypeIds = allItems.stream().map(Item::getIssueType).filter(Objects::nonNull).map(IssueType::getId).collect(Collectors.toSet());
            Query issueTypeQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(issueTypeIds));
            List allIssueTypes = Optional.ofNullable(this.mongoTemplate.find(issueTypeQuery, IssueType.class)).orElse(Collections.emptyList());
            Map<String, IssueType> issueTypeMap = allIssueTypes.stream().collect(Collectors.toMap(IssueType::getId, issueType -> issueType, (existing, replacement) -> existing));
            for (Item item : allItems) {
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null) continue;
                ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
                if (!"Feature".equals(item.getType())) continue;
                if (item.getIssueType() != null) {
                    IssueType issueType2 = issueTypeMap.get(item.getIssueType().getId());
                    if (issueType2 != null) {
                        issueTypes.add(issueType2);
                    } else {
                        IssueType featureType = new IssueType();
                        featureType.setTitle("Feature");
                        featureType.setId("Feature");
                        featureType.setColor("#732E95");
                        issueTypes.add(featureType);
                    }
                } else {
                    IssueType featureType = new IssueType();
                    featureType.setTitle("Feature");
                    featureType.setId("Feature");
                    featureType.setColor("#732E95");
                    issueTypes.add(featureType);
                }
                for (IssueType issueType3 : issueTypes) {
                    allCardTypes.add(issueType3);
                    allGroupBysMap.put(issueType3.getId(), issueType3.getTitle());
                    cardTypeColorMap.put(issueType3.getTitle(), issueType3.getColor());
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        issueTypeStatusMap.computeIfAbsent(issueTypes, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeGroupForFlowLoad()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("issueTypeStatusMap", issueTypeStatusMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("cardtypeColorMap", cardTypeColorMap);
        return result;
    }

    public Map<String, Object> getPlannedUnPlannedGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap) {
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        HashSet allPlannedUnplanned = new HashSet();
        try {
            farthestEndingStatusMap.forEach((key, farthestEndingStatus) -> {
                String tempKey = null;
                Query queryForItem = null;
                if (farthestEndingStatus.getJiraKey() != null) {
                    tempKey = farthestEndingStatus.getJiraKey();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)tempKey));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    tempKey = farthestEndingStatus.getTfsId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)tempKey));
                } else {
                    tempKey = farthestEndingStatus.getItemId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(tempKey)));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                HashSet SelectedTeams = new HashSet();
                if (item.getTeamContainers() != null && item.getTeamContainers().size() > 0) {
                    allPlannedUnplanned.add("Planned");
                } else {
                    allPlannedUnplanned.add("UnPlanned");
                }
                int index = 0;
                for (String plannedUnplanned : allPlannedUnplanned) {
                    allGroupBysMap.put(String.valueOf(index), plannedUnplanned);
                    ArrayList allPlannedUnplannedList = new ArrayList(allPlannedUnplanned);
                    List tempList = (List)plannedUnplannedStatusMap.get(allPlannedUnplannedList);
                    if (plannedUnplannedStatusMap.size() > 0 && tempList != null) {
                        tempList.add(farthestEndingStatus);
                        plannedUnplannedStatusMap.put(allPlannedUnplannedList, tempList);
                        continue;
                    }
                    ArrayList<TimeSeriesLog> temp = new ArrayList<TimeSeriesLog>();
                    temp.add((TimeSeriesLog)farthestEndingStatus);
                    plannedUnplannedStatusMap.put(allPlannedUnplannedList, temp);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPlannedUnPlannedGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("plannedUnplannedStatusMap", plannedUnplannedStatusMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getJiraProjectGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap, Dashboard dashboard) {
        HashMap<List, List> jiraProjectIssueTypeMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<JiraProjectIssueTypes> allJiraProjects = new HashSet<JiraProjectIssueTypes>();
        HashMap<String, String> jiraProjectColorMap = new HashMap<String, String>();
        Map globalColorsMap = new HashMap();
        try {
            if (farthestEndingStatusMap == null || farthestEndingStatusMap.isEmpty()) {
                return Collections.emptyMap();
            }
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                if (farthestEndingStatus.getItemId() == null) continue;
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set jiraProjectKeys = allItems.stream().map(Item::getJiraProjectKey).filter(Objects::nonNull).collect(Collectors.toSet());
            Query jiraProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"jiraProjectKey").in(jiraProjectKeys));
            List jiraProjectIssueTypesList = Optional.ofNullable(this.mongoTemplate.find(jiraProjectQuery, JiraProjectIssueTypes.class)).orElse(Collections.emptyList());
            Map<String, JiraProjectIssueTypes> jiraProjectIssueTypesMap = jiraProjectIssueTypesList.stream().collect(Collectors.toMap(JiraProjectIssueTypes::getJiraProjectKey, j -> j, (existing, replacement) -> existing));
            for (Item item : allItems) {
                JiraProjectIssueTypes jiraProjectIssueType;
                String jiraProjectKey;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (jiraProjectKey = item.getJiraProjectKey()) == null || (jiraProjectIssueType = jiraProjectIssueTypesMap.get(jiraProjectKey)) == null) continue;
                List<JiraProjectIssueTypes> jiraProjectIssueTypes = Collections.singletonList(jiraProjectIssueType);
                for (JiraProjectIssueTypes projectIssueType : jiraProjectIssueTypes) {
                    allJiraProjects.add(projectIssueType);
                    allGroupBysMap.put(projectIssueType.getJiraProjectId(), projectIssueType.getJiraProjectKey());
                    if (globalColorsMap.containsKey(projectIssueType.getJiraProjectKey())) {
                        jiraProjectColorMap.put(projectIssueType.getJiraProjectKey(), globalColorsMap.get(projectIssueType.getJiraProjectKey()).toString());
                    } else {
                        jiraProjectColorMap.put(projectIssueType.getJiraProjectKey(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"jiraProject", (String)""));
                        globalColorsMap.put(projectIssueType.getJiraProjectKey(), jiraProjectColorMap.get(projectIssueType.getJiraProjectKey()));
                    }
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        jiraProjectIssueTypeMap.computeIfAbsent(jiraProjectIssueTypes, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("jiraProjectIssueTypeMap", jiraProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("jiraProjectColorMap", jiraProjectColorMap);
        dashboard.setGlobalColorsMap(globalColorsMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getJiraProjectGroupByForFlowload(Map<String, List<TimeSeriesLog>> combinedMap, Dashboard dashboard) {
        HashMap<List, List> jiraProjectIssueTypeMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<JiraProjectIssueTypes> allJiraProjects = new HashSet<JiraProjectIssueTypes>();
        HashMap<String, String> jiraProjectColorMap = new HashMap<String, String>();
        Map globalColorsMap = new HashMap();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog farthestEndingStatus : entry.getValue()) {
                    if (farthestEndingStatus.getItemId() == null) continue;
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set jiraProjectKeys = allItems.stream().map(Item::getJiraProjectKey).filter(Objects::nonNull).collect(Collectors.toSet());
            Query jiraProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"jiraProjectKey").in(jiraProjectKeys));
            List jiraProjectIssueTypesList = Optional.ofNullable(this.mongoTemplate.find(jiraProjectQuery, JiraProjectIssueTypes.class)).orElse(Collections.emptyList());
            Map<String, JiraProjectIssueTypes> jiraProjectIssueTypesMap = jiraProjectIssueTypesList.stream().collect(Collectors.toMap(JiraProjectIssueTypes::getJiraProjectKey, j -> j, (existing, replacement) -> existing));
            for (Item item : allItems) {
                JiraProjectIssueTypes jiraProjectIssueType;
                String jiraProjectKey;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (jiraProjectKey = item.getJiraProjectKey()) == null || (jiraProjectIssueType = jiraProjectIssueTypesMap.get(jiraProjectKey)) == null) continue;
                List<JiraProjectIssueTypes> jiraProjectIssueTypes = Collections.singletonList(jiraProjectIssueType);
                for (JiraProjectIssueTypes projectIssueType : jiraProjectIssueTypes) {
                    allJiraProjects.add(projectIssueType);
                    allGroupBysMap.put(projectIssueType.getJiraProjectId(), projectIssueType.getJiraProjectKey());
                    if (globalColorsMap.containsKey(projectIssueType.getJiraProjectKey())) {
                        jiraProjectColorMap.put(projectIssueType.getJiraProjectKey(), globalColorsMap.get(projectIssueType.getJiraProjectKey()).toString());
                    } else {
                        jiraProjectColorMap.put(projectIssueType.getJiraProjectKey(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"jiraProject", (String)""));
                        globalColorsMap.put(projectIssueType.getJiraProjectKey(), jiraProjectColorMap.get(projectIssueType.getJiraProjectKey()));
                    }
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        jiraProjectIssueTypeMap.computeIfAbsent(jiraProjectIssueTypes, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectGroupByForFlowload()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("jiraProjectIssueTypeMap", jiraProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("jiraProjectColorMap", jiraProjectColorMap);
        dashboard.setGlobalColorsMap(globalColorsMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getTFSProjectGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap, Dashboard dashboard) {
        HashMap<List, List> tfsProjectIssueTypeMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<TFSProject> allTFSProjects = new HashSet<TFSProject>();
        HashMap<String, String> tfsProjectColorMap = new HashMap<String, String>();
        Map globalColorsMap = new HashMap();
        try {
            if (farthestEndingStatusMap == null || farthestEndingStatusMap.isEmpty()) {
                return Collections.emptyMap();
            }
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                if (farthestEndingStatus.getItemId() == null) continue;
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set tfsProjectIds = allItems.stream().map(Item::getTfsProjectId).filter(Objects::nonNull).collect(Collectors.toSet());
            Query tfsProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").in(tfsProjectIds));
            List tfsProjectList = Optional.ofNullable(this.mongoTemplate.find(tfsProjectQuery, TFSProject.class)).orElse(Collections.emptyList());
            Map<String, TFSProject> tfsProjectMap = tfsProjectList.stream().collect(Collectors.toMap(TFSProject::getTfsId, t -> t, (existing, replacement) -> existing));
            for (Item item : allItems) {
                TFSProject tfsProject;
                String tfsProjectId;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsProjectId = item.getTfsProjectId()) == null || (tfsProject = tfsProjectMap.get(tfsProjectId)) == null) continue;
                List<TFSProject> tfsProjects = Collections.singletonList(tfsProject);
                for (TFSProject tfsProjectIssueType : tfsProjects) {
                    allTFSProjects.add(tfsProjectIssueType);
                    allGroupBysMap.put(tfsProjectIssueType.getTfsId(), tfsProjectIssueType.getName());
                    if (globalColorsMap.containsKey(tfsProjectIssueType.getTfsId())) {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), globalColorsMap.get(tfsProjectIssueType.getTfsId()).toString());
                    } else {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"tfsProject", (String)""));
                        globalColorsMap.put(tfsProjectIssueType.getTfsId(), tfsProjectColorMap.get(tfsProjectIssueType.getName()));
                    }
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        tfsProjectIssueTypeMap.computeIfAbsent(tfsProjects, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tfsProjectIssueTypeMap", tfsProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("tfsProjectColorMap", tfsProjectColorMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getTFSProjectGroupByForFlowload(Map<String, List<TimeSeriesLog>> combinedMap, Dashboard dashboard) {
        HashMap<List, List> tfsProjectIssueTypeMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<TFSProject> allTFSProjects = new HashSet<TFSProject>();
        HashMap<String, String> tfsProjectColorMap = new HashMap<String, String>();
        Map globalColorsMap = new HashMap();
        try {
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog farthestEndingStatus : entry.getValue()) {
                    if (farthestEndingStatus.getItemId() == null) continue;
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            Set tfsProjectIds = allItems.stream().map(Item::getTfsProjectId).filter(Objects::nonNull).collect(Collectors.toSet());
            Query tfsProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").in(tfsProjectIds));
            List tfsProjectList = Optional.ofNullable(this.mongoTemplate.find(tfsProjectQuery, TFSProject.class)).orElse(Collections.emptyList());
            Map<String, TFSProject> tfsProjectMap = tfsProjectList.stream().collect(Collectors.toMap(TFSProject::getTfsId, t -> t, (existing, replacement) -> existing));
            for (Item item : allItems) {
                TFSProject tfsProject;
                String tfsProjectId;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsProjectId = item.getTfsProjectId()) == null || (tfsProject = tfsProjectMap.get(tfsProjectId)) == null) continue;
                List<TFSProject> tfsProjects = Collections.singletonList(tfsProject);
                for (TFSProject tfsProjectIssueType : tfsProjects) {
                    allTFSProjects.add(tfsProjectIssueType);
                    allGroupBysMap.put(tfsProjectIssueType.getTfsId(), tfsProjectIssueType.getName());
                    if (globalColorsMap.containsKey(tfsProjectIssueType.getTfsId())) {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), globalColorsMap.get(tfsProjectIssueType.getTfsId()).toString());
                    } else {
                        tfsProjectColorMap.put(tfsProjectIssueType.getName(), TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"tfsProject", (String)""));
                        globalColorsMap.put(tfsProjectIssueType.getTfsId(), tfsProjectColorMap.get(tfsProjectIssueType.getName()));
                    }
                    for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                        tfsProjectIssueTypeMap.computeIfAbsent(tfsProjects, k -> new ArrayList()).add(farthestEndingStatus);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectGroupByForFlowload()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tfsProjectIssueTypeMap", tfsProjectIssueTypeMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("tfsProjectColorMap", tfsProjectColorMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getAreaPathGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap, Dashboard dashboard) {
        HashMap<List, List> areaPathMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allAreaPaths = new HashSet<String>();
        Map globalColorsMap = new HashMap();
        HashMap<String, String> areaPathColorMap = new HashMap<String, String>();
        try {
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (farthestEndingStatusMap == null || farthestEndingStatusMap.isEmpty()) {
                return Collections.emptyMap();
            }
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                if (farthestEndingStatus.getItemId() == null) continue;
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            for (Item item : allItems) {
                String tfsAreaPath;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsAreaPath = item.getTfsAreaPath()) == null) continue;
                allAreaPaths.add(tfsAreaPath);
                allGroupBysMap.put(tfsAreaPath, tfsAreaPath);
                if (globalColorsMap.containsKey(tfsAreaPath)) {
                    areaPathColorMap.put(tfsAreaPath, globalColorsMap.get(tfsAreaPath).toString());
                } else {
                    areaPathColorMap.put(tfsAreaPath, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"areaPath", (String)""));
                    globalColorsMap.put(tfsAreaPath, areaPathColorMap.get(tfsAreaPath));
                }
                for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                    List<String> areaPathsList = Collections.singletonList(tfsAreaPath);
                    areaPathMap.computeIfAbsent(areaPathsList, k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAreaPathGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("areaPathMap", areaPathMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("areaPathColorMap", areaPathColorMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getAreaPathGroupByForFlowload(Map<String, List<TimeSeriesLog>> combinedMap, Dashboard dashboard) {
        HashMap<List, List> areaPathMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allAreaPaths = new HashSet<String>();
        Map globalColorsMap = new HashMap();
        HashMap<String, String> areaPathColorMap = new HashMap<String, String>();
        try {
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            if (!PropertyValidator.isValid(globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog farthestEndingStatus : entry.getValue()) {
                    if (farthestEndingStatus.getItemId() == null) continue;
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
            Map itemsMap = this.fetchItems(itemIds);
            Collection allItems = itemsMap.values();
            for (Item item : allItems) {
                String tfsAreaPath;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsAreaPath = item.getTfsAreaPath()) == null) continue;
                allAreaPaths.add(tfsAreaPath);
                allGroupBysMap.put(tfsAreaPath, tfsAreaPath);
                if (globalColorsMap.containsKey(tfsAreaPath)) {
                    areaPathColorMap.put(tfsAreaPath, globalColorsMap.get(tfsAreaPath).toString());
                } else {
                    areaPathColorMap.put(tfsAreaPath, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"areaPath", (String)""));
                    globalColorsMap.put(tfsAreaPath, areaPathColorMap.get(tfsAreaPath));
                }
                for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                    List<String> areaPathsList = Collections.singletonList(tfsAreaPath);
                    areaPathMap.computeIfAbsent(areaPathsList, k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAreaPathGroupByForFlowload()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("areaPathMap", areaPathMap);
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("areaPathColorMap", areaPathColorMap);
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getParentEpicGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap) {
        HashMap<List, List> parentEpicMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allParentEpics = new HashSet<String>();
        try {
            if (farthestEndingStatusMap == null || farthestEndingStatusMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                TimeSeriesLog farthestEndingStatus = entry.getValue();
                if (farthestEndingStatus.getItemId() == null) continue;
                itemIds.add(farthestEndingStatus.getItemId());
                itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
            }
            Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())).and("tfsFieldByKey.ParentId").and("tfsFieldByKey.ParentTitle").exists(true));
            itemQuery.fields().include("_id").include("tfsId").include("tfsFieldByKey.ParentId").include("tfsFieldByKey.ParentTitle");
            List allItems = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
            for (Item item : allItems) {
                Map tfsFieldByKey;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsFieldByKey = item.getTfsFieldByKey()) == null) continue;
                String parentEpicKey = tfsFieldByKey.get("ParentId").toString() + " " + tfsFieldByKey.get("ParentTitle").toString();
                String parentIdKey = item.getTfsId() + " " + tfsFieldByKey.get("ParentTitle").toString();
                allParentEpics.add(parentEpicKey);
                allGroupBysMap.put(parentIdKey, parentEpicKey);
                for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                    List<String> parentEpicsList = Collections.singletonList(parentEpicKey);
                    parentEpicMap.computeIfAbsent(parentEpicsList, k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getParentEpicGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("parentEpicMap", parentEpicMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getParentEpicGroupByForFlowload(Map<String, List<TimeSeriesLog>> combinedMap) {
        HashMap<List, List> parentEpicMap = new HashMap<List, List>();
        HashMap<String, String> allGroupBysMap = new HashMap<String, String>();
        HashSet<String> allParentEpics = new HashSet<String>();
        try {
            if (combinedMap == null || combinedMap.isEmpty()) {
                return Collections.emptyMap();
            }
            HashSet<String> itemIds = new HashSet<String>();
            HashMap<String, List> itemIdToFarthestStatusMap = new HashMap<String, List>();
            for (Map.Entry<String, List<TimeSeriesLog>> entry : combinedMap.entrySet()) {
                for (TimeSeriesLog farthestEndingStatus : entry.getValue()) {
                    if (farthestEndingStatus.getItemId() == null) continue;
                    itemIds.add(farthestEndingStatus.getItemId());
                    itemIdToFarthestStatusMap.computeIfAbsent(farthestEndingStatus.getItemId(), k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
            Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())).and("tfsFieldByKey.ParentId").exists(true).and("tfsFieldByKey.ParentTitle").exists(true));
            itemQuery.fields().include("_id").include("tfsId").include("tfsFieldByKey.ParentId").include("tfsFieldByKey.ParentTitle");
            List allItems = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
            for (Item item : allItems) {
                Map tfsFieldByKey;
                List farthestEndingStatusList = (List)itemIdToFarthestStatusMap.get(item.getId().toString());
                if (farthestEndingStatusList == null || (tfsFieldByKey = item.getTfsFieldByKey()) == null) continue;
                String parentEpicKey = tfsFieldByKey.get("ParentId").toString() + " " + tfsFieldByKey.get("ParentTitle").toString();
                String parentIdKey = item.getTfsId() + " " + tfsFieldByKey.get("ParentTitle").toString();
                allParentEpics.add(parentEpicKey);
                allGroupBysMap.put(parentIdKey, parentEpicKey);
                for (TimeSeriesLog farthestEndingStatus : farthestEndingStatusList) {
                    List<String> parentEpicsList = Collections.singletonList(parentEpicKey);
                    parentEpicMap.computeIfAbsent(parentEpicsList, k -> new ArrayList()).add(farthestEndingStatus);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getParentEpicGroupByForFlowload()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("parentEpicMap", parentEpicMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getJiraCustomFieldsGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap, String groupByvalue) {
        HashMap customFieldsMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        HashSet allParentEpics = new HashSet();
        try {
            farthestEndingStatusMap.forEach((earliestStartingStatus, farthestEndingStatus) -> {
                String tempKey = null;
                Query queryForItem = null;
                if (farthestEndingStatus.getJiraKey() != null) {
                    tempKey = farthestEndingStatus.getJiraKey();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)tempKey));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    tempKey = farthestEndingStatus.getTfsId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)tempKey));
                } else {
                    tempKey = farthestEndingStatus.getItemId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(tempKey)));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                HashSet<String> selectedCustomFields = new HashSet<String>();
                Map customFields = item.getJiraFieldByKey();
                if (customFields != null) {
                    for (Map.Entry entry : customFields.entrySet()) {
                        Map map;
                        String valueOfCustomField;
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (!key.equals(groupByvalue)) continue;
                        if (value instanceof String) {
                            allGroupBysMap.put(groupByvalue, (String)value);
                            selectedCustomFields.add((String)value);
                            continue;
                        }
                        if (value instanceof List) {
                            List list = (List)value;
                            for (String customField : list) {
                                if (customField == null) continue;
                                allGroupBysMap.put(groupByvalue + customField, customField);
                                selectedCustomFields.add(customField);
                            }
                            continue;
                        }
                        if (!(value instanceof Map) || (valueOfCustomField = (String)(map = (Map)value).get("value")) == null) continue;
                        allGroupBysMap.put(groupByvalue + valueOfCustomField, valueOfCustomField);
                        selectedCustomFields.add(valueOfCustomField);
                    }
                }
                ArrayList customFieldsList = new ArrayList(selectedCustomFields);
                List tempList = (List)customFieldsMap.get(customFieldsList);
                if (!customFieldsMap.isEmpty() && tempList != null) {
                    tempList.add(farthestEndingStatus);
                    customFieldsMap.put(customFieldsList, tempList);
                } else {
                    ArrayList<TimeSeriesLog> temp = new ArrayList<TimeSeriesLog>();
                    temp.add((TimeSeriesLog)farthestEndingStatus);
                    customFieldsMap.put(customFieldsList, temp);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraCustomFieldsGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("customFieldsMap", customFieldsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getTFSCustomFieldsGroupByFurthestItemsMap(Map<String, TimeSeriesLog> farthestEndingStatusMap, String groupByvalue) {
        HashMap customFieldsMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        try {
            farthestEndingStatusMap.forEach((earliestStartingStatus, farthestEndingStatus) -> {
                HashSet<String> selectedCustomFields = new HashSet<String>();
                String tempKey = null;
                Query queryForItem = null;
                if (farthestEndingStatus.getJiraKey() != null) {
                    tempKey = farthestEndingStatus.getJiraKey();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"jiraKey").is((Object)tempKey));
                } else if (farthestEndingStatus.getTfsId() != null) {
                    tempKey = farthestEndingStatus.getTfsId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"tfsId").is((Object)tempKey));
                } else {
                    tempKey = farthestEndingStatus.getItemId();
                    queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(tempKey)));
                }
                Item item = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                if (item.getTfsFieldMap() != null) {
                    for (int i = 0; i < item.getTfsFieldMap().size(); ++i) {
                        if (!((ItemJiraFieldMap)item.getTfsFieldMap().get(i)).getKey().equals(groupByvalue)) continue;
                        allGroupBysMap.put(((ItemJiraFieldMap)item.getTfsFieldMap().get(i)).getKey(), ((ItemJiraFieldMap)item.getTfsFieldMap().get(i)).getValue().toString());
                        selectedCustomFields.add(((ItemJiraFieldMap)item.getTfsFieldMap().get(i)).getValue().toString());
                    }
                }
                ArrayList customFieldsList = new ArrayList(allGroupBysMap.keySet());
                List tempList = (List)customFieldsMap.get(customFieldsList);
                if (!customFieldsMap.isEmpty() && tempList != null) {
                    tempList.add(farthestEndingStatus);
                    customFieldsMap.put(customFieldsList, tempList);
                } else {
                    ArrayList<TimeSeriesLog> temp = new ArrayList<TimeSeriesLog>();
                    temp.add((TimeSeriesLog)farthestEndingStatus);
                    customFieldsMap.put(customFieldsList, temp);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSCustomFieldsGroupByFurthestItemsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("customFieldsMap", customFieldsMap);
        result.put("allGroupBysMap", allGroupBysMap);
        return result;
    }

    public Map<String, Object> getTeamGroupDateAgainstInterval(Map<String, Map<TimeSeriesLog, TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys, SessionBoard sessionBoard) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap teamCountMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        ArrayList<Object> allSprints = new ArrayList();
        HashSet<String> itemIds = new HashSet<String>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                teamQuery.fields().include("title").include("label");
                List list = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = list.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                for (Map.Entry<String, Map<TimeSeriesLog, TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String string = entry.getKey();
                    Team teamFound = teamMap.get(string);
                    if (teamFound == null) continue;
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog timeSeriesLog = entry1.getKey();
                        TimeSeriesLog farthestEndingStatus = entry1.getValue();
                        if (timeSeriesLog.getEventTime().after(farthestEndingStatus.getEventTime())) continue;
                        long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0 && daysDifference >= 0.0) {
                            daysDifference = 1.0;
                        }
                        if (!(daysDifference > 0.0)) continue;
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String team2 = teamFound.getTitle();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team2);
                        double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = teamCountMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            teamCountMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            teamCountMap.put(temp, ++totalCount);
                            currentValue += daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(farthestEndingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(timeSeriesLog.getItemId());
                        itemsDaysMap.put("itemId_" + timeSeriesLog.getItemId() + ":" + team2, daysDifference);
                        itemTeamsMap.put("itemId_" + timeSeriesLog.getItemId() + ":" + team2, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<String, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)teamCountMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamGroupDateAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemIds", itemIds);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getCardTypeGroupDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> issueTypeStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet<String> itemIds = new HashSet<String>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<String> list = entry.getKey();
                    long totalCount = 0L;
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        if (earliestStartingStatus.getEventTime().after(timeSeriesLog.getEventTime())) continue;
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String issueType = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1) : list.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, issueType);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(earliestStartingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)countMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        result.put("itemIds", itemIds);
        return result;
    }

    private void handleIssueTypeMapFromScratch(Map<String, String> allGroupBys, Map<Map<String, String>, Double> sprintCounts, List<String> allSprints) {
        try {
            Query queryForIssueType = new Query();
            queryForIssueType.fields().include("title").include("color").include("textColor").include("sequence");
            List uniqueIssueTypes = this.mongoTemplate.find(queryForIssueType, IssueType.class);
            HashSet<String> issueTypesSet = new HashSet<String>();
            for (IssueType issueType : uniqueIssueTypes) {
                issueTypesSet.add(issueType.getTitle());
            }
            issueTypesSet.add("Feature");
            for (String issueTypes : issueTypesSet) {
                allGroupBys.put(issueTypes, issueTypes);
            }
            for (String entry : issueTypesSet) {
                for (String category : allSprints) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(category, entry);
                    sprintCounts.put(tempMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing handleIssueTypeMapFromScratch()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, Object> getplannedUnplannedGroupDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> plannedUnplannedStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : plannedUnplannedStatusMap.entrySet()) {
                List<String> list = entry.getKey();
                Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                long totalCount = 0L;
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                    TimeSeriesLog earliestStartingStatus = entry1.getKey();
                    TimeSeriesLog timeSeriesLog = entry1.getValue();
                    long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                    double daysDifference = millisecondsDifference / 86400000L;
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    String key = null;
                    if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                        for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                            String selectedInterval = intervalEntry.getKey();
                            List<Date> dates = intervalEntry.getValue();
                            if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                            key = selectedInterval;
                            break;
                        }
                    } else {
                        for (String intervalValue : allIntervals) {
                            String[] parts = intervalValue.split("-");
                            int intervalStart = Integer.parseInt(parts[0]);
                            int intervalEnd = Integer.parseInt(parts[1]);
                            if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                            key = intervalValue;
                            break;
                        }
                    }
                    if (key == null) continue;
                    String plannedUnplannedString = null;
                    if (list.size() > 1) {
                        if (!list.get(0).equals(list.get(1))) {
                            plannedUnplannedString = list.get(1);
                        }
                    } else {
                        plannedUnplannedString = list.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, plannedUnplannedString);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        currentValue = daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        currentValue = currentValue + daysDifference;
                    }
                    sprintCounts.put(temp, currentValue);
                    itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":plannedUnplannedString", daysDifference);
                    itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + plannedUnplannedString, new ArrayList());
                }
            }
            if (!sprintCounts.isEmpty()) {
                for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)l;
                    entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                }
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        int tempIndex = categories.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getplannedUnplannedGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        return result;
    }

    public Map<String, Object> getJiraProjectGroupDataAgainstInterval(Map<List<JiraProjectIssueTypes>, Map<TimeSeriesLog, TimeSeriesLog>> jiraProjectIssueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet<String> itemIds = new HashSet<String>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(jiraProjectIssueTypeMap)) {
                for (Map.Entry<List<JiraProjectIssueTypes>, Map<TimeSeriesLog, TimeSeriesLog>> entry : jiraProjectIssueTypeMap.entrySet()) {
                    List<JiraProjectIssueTypes> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        if (earliestStartingStatus.getEventTime().after(timeSeriesLog.getEventTime())) continue;
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String jiraProjectIssueType = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getJiraProjectKey() : list.get(0).getJiraProjectKey();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, jiraProjectIssueType);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(earliestStartingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + jiraProjectIssueType, daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + jiraProjectIssueType, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<List<Object>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)countMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        result.put("itemIds", itemIds);
        return result;
    }

    public Map<String, Object> getTFSProjectGroupDataAgainstInterval(Map<List<TFSProject>, Map<TimeSeriesLog, TimeSeriesLog>> tfsProjectIssueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys, String sessionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet<String> itemIds = new HashSet<String>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(tfsProjectIssueTypeMap)) {
                for (Map.Entry<List<TFSProject>, Map<TimeSeriesLog, TimeSeriesLog>> entry : tfsProjectIssueTypeMap.entrySet()) {
                    List<TFSProject> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        if (earliestStartingStatus.getEventTime().after(timeSeriesLog.getEventTime())) continue;
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String tfsProject = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getName() : list.get(0).getName();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, tfsProject);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(earliestStartingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + tfsProject, daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + tfsProject, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<List<Object>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)countMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        result.put("itemIds", itemIds);
        return result;
    }

    public Map<String, Object> getAreaPathGroupDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> areaPathMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet<String> itemIds = new HashSet<String>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(areaPathMap)) {
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : areaPathMap.entrySet()) {
                    List<String> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        if (earliestStartingStatus.getEventTime().after(timeSeriesLog.getEventTime())) continue;
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String areaPath = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1) : list.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, areaPath);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(earliestStartingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + areaPath, daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + areaPath, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)countMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAreaPathGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        result.put("itemIds", itemIds);
        return result;
    }

    public Map<String, Object> getParentEpicGroupDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> parentEpicMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        LinkedHashMap itemIdswrtInterval;
        HashMap itemGroupByMap;
        HashMap itemTeamsMap;
        HashMap itemSprintsMap;
        HashMap<String, Double> itemsDaysMap;
        HashMap sprintCounts;
        ArrayList<Object> allSprints;
        HashMap<String, Object> result;
        block21: {
            result = new HashMap<String, Object>();
            allSprints = new ArrayList();
            sprintCounts = new HashMap();
            itemsDaysMap = new HashMap<String, Double>();
            itemSprintsMap = new HashMap();
            itemTeamsMap = new HashMap();
            itemGroupByMap = new HashMap();
            HashMap countMap = new HashMap();
            itemIdswrtInterval = new LinkedHashMap();
            try {
                allSprints = new ArrayList<String>(relevantDates.keySet());
                if (!PropertyValidator.isValid(parentEpicMap)) break block21;
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : parentEpicMap.entrySet()) {
                    List<String> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String parentEpic = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1) : list.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, parentEpic);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + parentEpic, daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + parentEpic, new ArrayList());
                    }
                }
                if (!sprintCounts.isEmpty()) {
                    for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                        long l = (Long)countMap.get(entry.getKey());
                        double value = (Double)((Object)entry.getValue()) / (double)l;
                        entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                    }
                    ArrayList newEntries = new ArrayList();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        Map tempKey = (Map)entry.getKey();
                        String intervalPart = (String)tempKey.keySet().iterator().next();
                        String value = (String)tempKey.get(intervalPart);
                        List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                        int indexOfInterval = categories.indexOf(intervalPart);
                        for (String string : categories) {
                            int tempIndex = categories.indexOf(string);
                            if (string.equals(intervalPart)) continue;
                            HashMap<String, String> tempMap = new HashMap<String, String>();
                            tempMap.put(string, value);
                            if (sprintCounts.get(tempMap) != null) continue;
                            newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                        }
                    }
                    for (Map.Entry entry : newEntries) {
                        sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                    }
                } else if (sprintCounts.isEmpty()) {
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories) {
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(string, "No data is available for the specified selection.");
                        sprintCounts.put(temp, 0.0);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getParentEpicGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getJiraCustomFieldGroupDataAgainstInterval(Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> entry : customFieldsMap.entrySet()) {
                List<String> list = entry.getKey();
                List<Map<TimeSeriesLog, TimeSeriesLog>> statusMap = entry.getValue();
                long totalCount = 0L;
                for (Map<TimeSeriesLog, TimeSeriesLog> tempMap : statusMap) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry2 : tempMap.entrySet()) {
                        TimeSeriesLog earliestStartingStatus = entry2.getKey();
                        TimeSeriesLog farthestEndingStatus = entry2.getValue();
                        long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        String key = null;
                        if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                            for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                                String selectedInterval = intervalEntry.getKey();
                                List<Date> dates = intervalEntry.getValue();
                                if (TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                                key = selectedInterval;
                                break;
                            }
                        } else {
                            for (String intervalValue : allIntervals) {
                                String[] parts = intervalValue.split("-");
                                int intervalStart = Integer.parseInt(parts[0]);
                                int intervalEnd = Integer.parseInt(parts[1]);
                                if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                                key = intervalValue;
                                break;
                            }
                        }
                        if (key == null) continue;
                        String fields = null;
                        if (list.size() > 1) {
                            if (!list.get(0).equals(list.get(1))) {
                                fields = list.get(1);
                            }
                        } else {
                            fields = list.get(0);
                        }
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, fields);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        sprintCounts.put(temp, currentValue);
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":fields", daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, new ArrayList());
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                for (Map.Entry<List<String>, List<Map<Object, Object>>> entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)l;
                    entry.setValue((List<Map<Object, Object>>)Double.parseDouble(this.df.format(value)));
                }
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        int tempIndex = categories.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraCustomFieldGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        return result;
    }

    public Map<String, Object> getTFSCustomFieldGroupDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> customFieldsMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : customFieldsMap.entrySet()) {
                List<String> list = entry.getKey();
                Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                long totalCount = 0L;
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                    TimeSeriesLog earliestStartingStatus = entry1.getKey();
                    TimeSeriesLog timeSeriesLog = entry1.getValue();
                    long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                    double daysDifference = millisecondsDifference / 86400000L;
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    String key = null;
                    if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                        for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                            String selectedInterval = intervalEntry.getKey();
                            List<Date> dates = intervalEntry.getValue();
                            if (TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(0))) < 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)timeSeriesLog.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                            key = selectedInterval;
                            break;
                        }
                    } else {
                        for (String intervalValue : allIntervals) {
                            String[] parts = intervalValue.split("-");
                            int intervalStart = Integer.parseInt(parts[0]);
                            int intervalEnd = Integer.parseInt(parts[1]);
                            if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                            key = intervalValue;
                            break;
                        }
                    }
                    if (key == null) continue;
                    String fields = null;
                    if (list.size() > 1) {
                        if (!list.get(0).equals(list.get(1))) {
                            fields = list.get(1);
                        }
                    } else {
                        fields = list.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, fields);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        currentValue = daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        currentValue = currentValue + daysDifference;
                    }
                    sprintCounts.put(temp, currentValue);
                    itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":fields", daysDifference);
                    itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, new ArrayList());
                }
            }
            if (!sprintCounts.isEmpty()) {
                for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)l;
                    entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                }
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        int tempIndex = categories.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSCustomFieldGroupDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        return result;
    }

    public Map<String, Object> getTeamEfficiencyDataAgainstInterval(Map<String, Map<TimeSeriesLog, TimeSeriesLog>> teamStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, Date sDate, Date eDate, String tenant) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>(relevantDates.keySet());
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap itemsDaysMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet itemIds = new HashSet();
        try {
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                teamQuery.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                HashSet<String> itemIdsToQuery = new HashSet<String>();
                for (Map.Entry<String, Map<TimeSeriesLog, TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    for (TimeSeriesLog earliestStartingStatus : statusMap.keySet()) {
                        itemIdsToQuery.add(earliestStartingStatus.getItemId());
                    }
                }
                Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"itemId").in(itemIdsToQuery));
                itemQuery.fields().include("itemId").include("eventTime").include("changes.status.id");
                List itemLogs = Optional.ofNullable(this.mongoTemplate.find(itemQuery, TimeSeriesLog.class, "itemTimeSeries")).orElse(Collections.emptyList());
                Map<String, List<TimeSeriesLog>> itemLogsMap = itemLogs.stream().collect(Collectors.groupingBy(TimeSeriesLog::getItemId));
                ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                ArrayList futures = new ArrayList();
                for (Map.Entry<String, Map<TimeSeriesLog, TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    futures.add(executorService.submit(() -> {
                        String teamId = (String)entry.getKey();
                        Team teamFound = (Team)teamMap.get(teamId);
                        if (teamFound == null) {
                            return;
                        }
                        Map statusMap = (Map)entry.getValue();
                        long totalCount = 0L;
                        for (Map.Entry statusEntry : statusMap.entrySet()) {
                            double percentage;
                            TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)statusEntry.getKey();
                            TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)statusEntry.getValue();
                            long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                            double daysDifference = millisecondsDifference / 86400000L;
                            if (daysDifference < 1.0) {
                                if (!(daysDifference >= 0.0)) continue;
                                daysDifference = 1.0;
                            }
                            double cumulativeTimeDifference = 0.0;
                            List logsForItem = itemLogsMap.getOrDefault(earliestStartingStatus.getItemId(), Collections.emptyList());
                            for (TimeSeriesLog timeSeriesLog : logsForItem) {
                                Object statusObject;
                                Date currentEventTime = timeSeriesLog.getEventTime();
                                if (currentEventTime.compareTo(earliestStartingStatus.getEventTime()) <= 0 || !((statusObject = timeSeriesLog.getChanges().get("status")) instanceof Map)) continue;
                                Map currentStatusMap = (Map)statusObject;
                                Object currentStatusId = currentStatusMap.get("id");
                                TimeSeriesLog otherEntry = logsForItem.stream().filter(log -> {
                                    Object otherStatusObject;
                                    Date logEventTime = log.getEventTime();
                                    if (logEventTime.after(currentEventTime) && (otherStatusObject = log.getChanges().get("status")) instanceof Map) {
                                        Map otherStatusMap = (Map)otherStatusObject;
                                        Object otherStatusId = otherStatusMap.get("id");
                                        return !Objects.equals(otherStatusId, currentStatusId);
                                    }
                                    return false;
                                }).findFirst().orElse(null);
                                if (otherEntry == null) continue;
                                long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                                double activeDaysDifference = milliSecDifference / 86400000L;
                                if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                    activeDaysDifference = 1.0;
                                }
                                cumulativeTimeDifference += activeDaysDifference;
                            }
                            String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                            if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, teamFound.getTitle());
                            double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                                percentage = currentValue + tempPercentage;
                            }
                            if (!(percentage > 0.0)) continue;
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(farthestEndingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, percentage);
                            double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                            double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                            activeCounts.put(temp, currentActiveValue += cumulativeTimeDifference);
                            totalCounts.put(temp, currentTotalValue += daysDifference);
                            itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + teamFound.getTitle(), cumulativeTimeDifference * 100.0 / daysDifference);
                            itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + teamFound.getTitle(), new ArrayList());
                            itemIds.add(earliestStartingStatus.getItemId());
                        }
                    }));
                }
                for (Future future : futures) {
                    future.get();
                }
                executorService.shutdown();
                for (Map.Entry<String, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)l;
                    entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                }
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), entry.getValue());
                }
            }
            if (sprintCounts.isEmpty()) {
                List<String> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String category : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(category, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamEfficiencyDataAgainstInterval()", (Object)StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("categories", !allIntervals.isEmpty() ? allIntervals : allSprints);
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getCardTypeEfficiencyDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> issueTypeStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, Date sDate, Date eDate, String tenant) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap itemsDaysMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                ExecutorService executor = Executors.newFixedThreadPool(4);
                HashSet<String> itemIdsForQuery = new HashSet<String>();
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : entry.getValue().entrySet()) {
                        itemIdsForQuery.add(entry1.getKey().getItemId());
                    }
                }
                ArrayList<TimeSeriesLog> arrayList = new ArrayList<TimeSeriesLog>();
                BasicDBObject filter = new BasicDBObject();
                filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                filter.put((Object)"itemId", (Object)new BasicDBObject("$in", itemIdsForQuery));
                filter.put((Object)"meta.tenant", (Object)tenant);
                filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
                DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                long startTime = System.currentTimeMillis();
                DBCursor querys = collection.find((DBObject)filter);
                while (querys.hasNext()) {
                    TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                    DBObject dbObject = querys.next();
                    timeSeriesLog.setId(dbObject.get("_id").toString());
                    timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                    timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                    timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                    timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                    timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                    timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                    arrayList.add(timeSeriesLog);
                }
                this.checkItemExistanceInCollection(arrayList);
                LOGGER.info("Method : execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> timeSeriesLogMap = new HashMap<String, TimeSeriesLog>();
                for (TimeSeriesLog timeSeriesLog : arrayList) {
                    timeSeriesLogMap.put(timeSeriesLog.getItemId(), timeSeriesLog);
                }
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<String> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    tasks.add(() -> {
                        for (Map.Entry entry1 : statusMap.entrySet()) {
                            double percentage;
                            TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry1.getKey();
                            TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry1.getValue();
                            long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                            double daysDifference = millisecondsDifference / 86400000L;
                            if (daysDifference < 1.0) {
                                if (!(daysDifference >= 0.0)) continue;
                                daysDifference = 1.0;
                            }
                            double cumulativeTimeDifference = 0.0;
                            for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                                Date currentEventTime;
                                if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId()) || (currentEventTime = timeSeriesLog.getEventTime()).compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                                LinkedHashMap currentStatusMap = (LinkedHashMap)timeSeriesLog.getChanges().get("status");
                                TimeSeriesLog otherEntry = (TimeSeriesLog)timeSeriesLogMap.get(timeSeriesLog.getItemId());
                                if (otherEntry == null) continue;
                                long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                                double activeDaysDifference = milliSecDifference / 86400000L;
                                if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                    activeDaysDifference = 1.0;
                                }
                                cumulativeTimeDifference += activeDaysDifference;
                            }
                            String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                            if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                            String issueType = issueTypes.size() > 1 && !((String)issueTypes.get(0)).equals(issueTypes.get(1)) ? (String)issueTypes.get(1) : (String)issueTypes.get(0);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, issueType);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            long totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                                percentage = currentValue + tempPercentage;
                            }
                            if (!(percentage > 0.0)) continue;
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(farthestEndingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, percentage);
                            double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                            double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                            activeCounts.put(temp, currentActiveValue += cumulativeTimeDifference);
                            totalCounts.put(temp, currentTotalValue += daysDifference);
                            itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, cumulativeTimeDifference * 100.0 / daysDifference);
                            itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, new ArrayList());
                        }
                        return null;
                    });
                }
                try {
                    executor.invokeAll(tasks);
                }
                catch (Exception exception) {
                    LOGGER.error("Error processing executor service in getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)exception));
                }
                finally {
                    executor.shutdown();
                }
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)entry.getValue() / (double)l;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        arrayList2.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : arrayList2) {
                    sprintCounts.put(entry.getKey(), entry.getValue());
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("categories", allIntervals.isEmpty() ? allSprints : allIntervals);
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getplannedUnplannedEfficiencyDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> plannedUnplannedStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : plannedUnplannedStatusMap.entrySet()) {
                List<String> list = entry.getKey();
                Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                long totalCount = 0L;
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                    double percentage;
                    TimeSeriesLog earliestStartingStatus = entry1.getKey();
                    TimeSeriesLog farthestEndingStatus = entry1.getValue();
                    long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                    double daysDifference = millisecondsDifference / 86400000L;
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    double cumulativeTimeDifference = 0.0;
                    TimeSeriesLog currentActiveItem = new TimeSeriesLog();
                    for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                        if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId())) continue;
                        currentActiveItem = timeSeriesLog;
                        Date currentEventTime = currentActiveItem.getEventTime();
                        LinkedHashMap currentStatusMap = new LinkedHashMap();
                        if (currentActiveItem.getChanges().get("status") == null || currentEventTime.compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                        currentStatusMap = (LinkedHashMap)currentActiveItem.getChanges().get("status");
                        Query query = new Query((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)currentActiveItem.getItemId()).and("eventTime").gt((Object)currentEventTime).and("changes.status.id").exists(true).ne((Object)currentStatusMap.get("id").toString()));
                        query.limit(1);
                        TimeSeriesLog otherEntry = (TimeSeriesLog)this.mongoTemplate.findOne(query, TimeSeriesLog.class, "itemTimeSeries");
                        if (otherEntry == null) continue;
                        long milliSecDifference = otherEntry.getEventTime().getTime() - currentActiveItem.getEventTime().getTime();
                        double activeDaysDifference = milliSecDifference / 86400000L;
                        if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                            activeDaysDifference = 1.0;
                        }
                        cumulativeTimeDifference += activeDaysDifference;
                    }
                    String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                    if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                    String plannedUnplannedString = null;
                    if (list.size() > 1) {
                        if (!list.get(0).equals(list.get(1))) {
                            plannedUnplannedString = list.get(1);
                        }
                    } else {
                        plannedUnplannedString = list.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, plannedUnplannedString);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        percentage = currentValue + tempPercentage;
                    }
                    if (!(percentage > 0.0)) continue;
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(farthestEndingStatus.getItemId());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                    sprintCounts.put(temp, percentage);
                    double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                    double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                    currentActiveValue += cumulativeTimeDifference;
                    currentTotalValue += daysDifference;
                    currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                    currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                    activeCounts.put(temp, currentActiveValue);
                    totalCounts.put(temp, currentTotalValue);
                    itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":plannedUnplannedString", cumulativeTimeDifference * 100.0 / daysDifference);
                    itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + plannedUnplannedString, new ArrayList());
                }
            }
            for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                long l = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)l;
                entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
            }
            ArrayList newEntries = new ArrayList();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    if (categories.indexOf(tempInterval) >= indexOfInterval || tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                }
            }
            for (Map.Entry entry : newEntries) {
                sprintCounts.put(entry.getKey(), (Double)entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getplannedUnplannedEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getJiraProjectEfficiencyDataAgainstInterval(Map<List<JiraProjectIssueTypes>, Map<TimeSeriesLog, TimeSeriesLog>> issueTypeStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, Date sDate, Date eDate, String tenant) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap itemsDaysMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                ExecutorService executor = Executors.newFixedThreadPool(4);
                HashSet<String> itemIdsForQuery = new HashSet<String>();
                for (Map.Entry<List<JiraProjectIssueTypes>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : entry.getValue().entrySet()) {
                        itemIdsForQuery.add(entry1.getKey().getItemId());
                    }
                }
                ArrayList<TimeSeriesLog> arrayList = new ArrayList<TimeSeriesLog>();
                BasicDBObject filter = new BasicDBObject();
                filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                filter.put((Object)"itemId", (Object)new BasicDBObject("$in", itemIdsForQuery));
                filter.put((Object)"meta.tenant", (Object)tenant);
                filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
                DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                long startTime = System.currentTimeMillis();
                DBCursor querys = collection.find((DBObject)filter);
                while (querys.hasNext()) {
                    TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                    DBObject dbObject = querys.next();
                    timeSeriesLog.setId(dbObject.get("_id").toString());
                    timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                    timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                    timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                    timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                    timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                    timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                    arrayList.add(timeSeriesLog);
                }
                this.checkItemExistanceInCollection(arrayList);
                LOGGER.info("Method : execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> timeSeriesLogMap = new HashMap<String, TimeSeriesLog>();
                for (TimeSeriesLog timeSeriesLog : arrayList) {
                    timeSeriesLogMap.put(timeSeriesLog.getItemId(), timeSeriesLog);
                }
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (Map.Entry<List<JiraProjectIssueTypes>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<JiraProjectIssueTypes> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    tasks.add(() -> {
                        for (Map.Entry entry1 : statusMap.entrySet()) {
                            double percentage;
                            TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry1.getKey();
                            TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry1.getValue();
                            long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                            double daysDifference = millisecondsDifference / 86400000L;
                            if (daysDifference < 1.0) {
                                if (!(daysDifference >= 0.0)) continue;
                                daysDifference = 1.0;
                            }
                            double cumulativeTimeDifference = 0.0;
                            for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                                Date currentEventTime;
                                if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId()) || (currentEventTime = timeSeriesLog.getEventTime()).compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                                LinkedHashMap currentStatusMap = (LinkedHashMap)timeSeriesLog.getChanges().get("status");
                                TimeSeriesLog otherEntry = (TimeSeriesLog)timeSeriesLogMap.get(timeSeriesLog.getItemId());
                                if (otherEntry == null) continue;
                                long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                                double activeDaysDifference = milliSecDifference / 86400000L;
                                if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                    activeDaysDifference = 1.0;
                                }
                                cumulativeTimeDifference += activeDaysDifference;
                            }
                            String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                            if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                            String issueType = issueTypes.size() > 1 && !((JiraProjectIssueTypes)issueTypes.get(0)).equals(issueTypes.get(1)) ? ((JiraProjectIssueTypes)issueTypes.get(1)).getJiraProjectKey() : ((JiraProjectIssueTypes)issueTypes.get(0)).getJiraProjectKey();
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, issueType);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            long totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                                percentage = currentValue + tempPercentage;
                            }
                            if (!(percentage > 0.0)) continue;
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(farthestEndingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, percentage);
                            double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                            double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                            activeCounts.put(temp, currentActiveValue += cumulativeTimeDifference);
                            totalCounts.put(temp, currentTotalValue += daysDifference);
                            itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, cumulativeTimeDifference * 100.0 / daysDifference);
                            itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, new ArrayList());
                        }
                        return null;
                    });
                }
                try {
                    executor.invokeAll(tasks);
                }
                catch (Exception exception) {
                    LOGGER.error("Error processing executor service in getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)exception));
                }
                finally {
                    executor.shutdown();
                }
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)entry.getValue() / (double)l;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        arrayList2.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : arrayList2) {
                    sprintCounts.put(entry.getKey(), entry.getValue());
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("categories", allIntervals.isEmpty() ? allSprints : allIntervals);
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTFSProjectEfficiencyDataAgainstInterval(Map<List<TFSProject>, Map<TimeSeriesLog, TimeSeriesLog>> issueTypeStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, Date sDate, Date eDate, String tenant) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap itemsDaysMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                ExecutorService executor = Executors.newFixedThreadPool(4);
                HashSet<String> itemIdsForQuery = new HashSet<String>();
                for (Map.Entry<List<TFSProject>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : entry.getValue().entrySet()) {
                        itemIdsForQuery.add(entry1.getKey().getItemId());
                    }
                }
                ArrayList<TimeSeriesLog> arrayList = new ArrayList<TimeSeriesLog>();
                BasicDBObject filter = new BasicDBObject();
                filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                filter.put((Object)"itemId", (Object)new BasicDBObject("$in", itemIdsForQuery));
                filter.put((Object)"meta.tenant", (Object)tenant);
                filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
                DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                long startTime = System.currentTimeMillis();
                DBCursor querys = collection.find((DBObject)filter);
                while (querys.hasNext()) {
                    TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                    DBObject dbObject = querys.next();
                    timeSeriesLog.setId(dbObject.get("_id").toString());
                    timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                    timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                    timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                    timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                    timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                    timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                    arrayList.add(timeSeriesLog);
                }
                this.checkItemExistanceInCollection(arrayList);
                LOGGER.info("Method : execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> timeSeriesLogMap = new HashMap<String, TimeSeriesLog>();
                for (TimeSeriesLog timeSeriesLog : arrayList) {
                    timeSeriesLogMap.put(timeSeriesLog.getItemId(), timeSeriesLog);
                }
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (Map.Entry<List<TFSProject>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<TFSProject> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    tasks.add(() -> {
                        for (Map.Entry entry1 : statusMap.entrySet()) {
                            double percentage;
                            TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry1.getKey();
                            TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry1.getValue();
                            long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                            double daysDifference = millisecondsDifference / 86400000L;
                            if (daysDifference < 1.0) {
                                if (!(daysDifference >= 0.0)) continue;
                                daysDifference = 1.0;
                            }
                            double cumulativeTimeDifference = 0.0;
                            for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                                Date currentEventTime;
                                if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId()) || (currentEventTime = timeSeriesLog.getEventTime()).compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                                LinkedHashMap currentStatusMap = (LinkedHashMap)timeSeriesLog.getChanges().get("status");
                                TimeSeriesLog otherEntry = (TimeSeriesLog)timeSeriesLogMap.get(timeSeriesLog.getItemId());
                                if (otherEntry == null) continue;
                                long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                                double activeDaysDifference = milliSecDifference / 86400000L;
                                if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                    activeDaysDifference = 1.0;
                                }
                                cumulativeTimeDifference += activeDaysDifference;
                            }
                            String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                            if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                            String issueType = issueTypes.size() > 1 && !((TFSProject)issueTypes.get(0)).equals(issueTypes.get(1)) ? ((TFSProject)issueTypes.get(1)).getName() : ((TFSProject)issueTypes.get(0)).getName();
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, issueType);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            long totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                                percentage = currentValue + tempPercentage;
                            }
                            if (!(percentage > 0.0)) continue;
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(farthestEndingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, percentage);
                            double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                            double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                            activeCounts.put(temp, currentActiveValue += cumulativeTimeDifference);
                            totalCounts.put(temp, currentTotalValue += daysDifference);
                            itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, cumulativeTimeDifference * 100.0 / daysDifference);
                            itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, new ArrayList());
                        }
                        return null;
                    });
                }
                try {
                    executor.invokeAll(tasks);
                }
                catch (Exception exception) {
                    LOGGER.error("Error processing executor service in getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)exception));
                }
                finally {
                    executor.shutdown();
                }
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)entry.getValue() / (double)l;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        arrayList2.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : arrayList2) {
                    sprintCounts.put(entry.getKey(), entry.getValue());
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("categories", allIntervals.isEmpty() ? allSprints : allIntervals);
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAreaPathEfficiencyDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> issueTypeStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, Date sDate, Date eDate, String tenant) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap itemsDaysMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashSet itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                ExecutorService executor = Executors.newFixedThreadPool(4);
                HashSet<String> itemIdsForQuery = new HashSet<String>();
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : entry.getValue().entrySet()) {
                        itemIdsForQuery.add(entry1.getKey().getItemId());
                    }
                }
                ArrayList<TimeSeriesLog> arrayList = new ArrayList<TimeSeriesLog>();
                BasicDBObject filter = new BasicDBObject();
                filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                filter.put((Object)"itemId", (Object)new BasicDBObject("$in", itemIdsForQuery));
                filter.put((Object)"meta.tenant", (Object)tenant);
                filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
                DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                long startTime = System.currentTimeMillis();
                DBCursor querys = collection.find((DBObject)filter);
                while (querys.hasNext()) {
                    TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                    DBObject dbObject = querys.next();
                    timeSeriesLog.setId(dbObject.get("_id").toString());
                    timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                    timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                    timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                    timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                    timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                    timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                    arrayList.add(timeSeriesLog);
                }
                this.checkItemExistanceInCollection(arrayList);
                LOGGER.info("Method : execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> timeSeriesLogMap = new HashMap<String, TimeSeriesLog>();
                for (TimeSeriesLog timeSeriesLog : arrayList) {
                    timeSeriesLogMap.put(timeSeriesLog.getItemId(), timeSeriesLog);
                }
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<String> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    tasks.add(() -> {
                        for (Map.Entry entry1 : statusMap.entrySet()) {
                            double percentage;
                            TimeSeriesLog earliestStartingStatus = (TimeSeriesLog)entry1.getKey();
                            TimeSeriesLog farthestEndingStatus = (TimeSeriesLog)entry1.getValue();
                            long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                            double daysDifference = millisecondsDifference / 86400000L;
                            if (daysDifference < 1.0) {
                                if (!(daysDifference >= 0.0)) continue;
                                daysDifference = 1.0;
                            }
                            double cumulativeTimeDifference = 0.0;
                            for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                                Date currentEventTime;
                                if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId()) || (currentEventTime = timeSeriesLog.getEventTime()).compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                                LinkedHashMap currentStatusMap = (LinkedHashMap)timeSeriesLog.getChanges().get("status");
                                TimeSeriesLog otherEntry = (TimeSeriesLog)timeSeriesLogMap.get(timeSeriesLog.getItemId());
                                if (otherEntry == null) continue;
                                long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog.getEventTime().getTime();
                                double activeDaysDifference = milliSecDifference / 86400000L;
                                if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                    activeDaysDifference = 1.0;
                                }
                                cumulativeTimeDifference += activeDaysDifference;
                            }
                            String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                            if (key == null || !(cumulativeTimeDifference > 0.0)) continue;
                            String issueType = issueTypes.size() > 1 && !((String)issueTypes.get(0)).equals(issueTypes.get(1)) ? (String)issueTypes.get(1) : (String)issueTypes.get(0);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, issueType);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            long totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                                percentage = currentValue + tempPercentage;
                            }
                            if (!(percentage > 0.0)) continue;
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(farthestEndingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, percentage);
                            double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                            double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                            activeCounts.put(temp, currentActiveValue += cumulativeTimeDifference);
                            totalCounts.put(temp, currentTotalValue += daysDifference);
                            itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, cumulativeTimeDifference * 100.0 / daysDifference);
                            itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + issueType, new ArrayList());
                        }
                        return null;
                    });
                }
                try {
                    executor.invokeAll(tasks);
                }
                catch (Exception exception) {
                    LOGGER.error("Error processing executor service in getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)exception));
                }
                finally {
                    executor.shutdown();
                }
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)entry.getValue() / (double)l;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        arrayList2.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : arrayList2) {
                    sprintCounts.put(entry.getKey(), entry.getValue());
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("categories", allIntervals.isEmpty() ? allSprints : allIntervals);
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getParentEpicEfficiencyDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> parentEpicMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(parentEpicMap)) {
                for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : parentEpicMap.entrySet()) {
                    List<String> list = entry.getKey();
                    Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                    long totalCount = 0L;
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                        double percentage;
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog timeSeriesLog = entry1.getValue();
                        long millisecondsDifference = timeSeriesLog.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = 0.0;
                        for (TimeSeriesLog timeSeriesLog2 : activeStatusList) {
                            Date currentEventTime;
                            if (!timeSeriesLog2.getItemId().equals(earliestStartingStatus.getItemId()) || (currentEventTime = timeSeriesLog2.getEventTime()).compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                            LinkedHashMap currentStatusMap = (LinkedHashMap)timeSeriesLog2.getChanges().get("status");
                            Query queryForOtherEntries = new Query((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)timeSeriesLog2.getItemId()).and("changes.status.id").ne((Object)currentStatusMap.get("id").toString()).and("eventTime").gt((Object)currentEventTime));
                            TimeSeriesLog otherEntry = (TimeSeriesLog)this.mongoTemplate.findOne(queryForOtherEntries, TimeSeriesLog.class, "itemTimeSeries");
                            if (otherEntry == null) continue;
                            long milliSecDifference = otherEntry.getEventTime().getTime() - timeSeriesLog2.getEventTime().getTime();
                            double activeDaysDifference = milliSecDifference / 86400000L;
                            if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                activeDaysDifference = 1.0;
                            }
                            cumulativeTimeDifference += activeDaysDifference;
                        }
                        String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, timeSeriesLog, daysDifference, relevantDates);
                        if (key == null) continue;
                        String parentEpic = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1) : list.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, parentEpic);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        if (!(percentage > 0.0)) continue;
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + parentEpic, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + parentEpic, new ArrayList());
                    }
                }
                for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                    long l = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)l;
                    entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
                }
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        int tempIndex = categories.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getParentEpicEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getJiraCustomFieldsEfficiencyDataAgainstInterval(Map<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> customFieldsMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, List<Map<TimeSeriesLog, TimeSeriesLog>>> entry : customFieldsMap.entrySet()) {
                List<String> list = entry.getKey();
                List<Map<TimeSeriesLog, TimeSeriesLog>> statusMap = entry.getValue();
                long totalCount = 0L;
                for (Map<TimeSeriesLog, TimeSeriesLog> tempMap : statusMap) {
                    for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : tempMap.entrySet()) {
                        double percentage;
                        TimeSeriesLog earliestStartingStatus = entry1.getKey();
                        TimeSeriesLog farthestEndingStatus = entry1.getValue();
                        long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                        double daysDifference = millisecondsDifference / 86400000L;
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = 0.0;
                        TimeSeriesLog currentActiveItem = new TimeSeriesLog();
                        for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                            if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId())) continue;
                            currentActiveItem = timeSeriesLog;
                            Date currentEventTime = currentActiveItem.getEventTime();
                            LinkedHashMap currentStatusMap = new LinkedHashMap();
                            if (currentActiveItem.getChanges().get("status") == null || currentEventTime.compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                            currentStatusMap = (LinkedHashMap)currentActiveItem.getChanges().get("status");
                            Query queryForOtherEntries = new Query((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)currentActiveItem.getItemId()).and("changes.status.id").ne((Object)currentStatusMap.get("id").toString()).and("eventTime").gt((Object)currentEventTime));
                            TimeSeriesLog otherEntry = (TimeSeriesLog)this.mongoTemplate.findOne(queryForOtherEntries, TimeSeriesLog.class, "itemTimeSeries");
                            if (otherEntry == null) continue;
                            long milliSecDifference = otherEntry.getEventTime().getTime() - currentActiveItem.getEventTime().getTime();
                            double activeDaysDifference = milliSecDifference / 86400000L;
                            if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                                activeDaysDifference = 1.0;
                            }
                            cumulativeTimeDifference += activeDaysDifference;
                        }
                        String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String fields = null;
                        if (list.size() > 1) {
                            if (!list.get(0).equals(list.get(1))) {
                                fields = list.get(1);
                            }
                        } else {
                            fields = list.get(0);
                        }
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, fields);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        if (!(percentage > 0.0)) continue;
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, new ArrayList());
                    }
                }
            }
            for (Map.Entry<List<String>, List<Map<Object, Object>>> entry : sprintCounts.entrySet()) {
                long l = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)l;
                entry.setValue((List<Map<Object, Object>>)Double.parseDouble(this.df.format(value)));
            }
            ArrayList newEntries = new ArrayList();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    if (categories.indexOf(tempInterval) >= indexOfInterval || tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                }
            }
            for (Map.Entry entry : newEntries) {
                sprintCounts.put(entry.getKey(), (Double)entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraCustomFieldsEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        return result;
    }

    public Map<String, Object> getTFSCustomFieldsEfficiencyDataAgainstInterval(Map<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> customFieldsMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, Map<TimeSeriesLog, TimeSeriesLog>> entry : customFieldsMap.entrySet()) {
                List<String> list = entry.getKey();
                Map<TimeSeriesLog, TimeSeriesLog> statusMap = entry.getValue();
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> entry1 : statusMap.entrySet()) {
                    double percentage;
                    TimeSeriesLog earliestStartingStatus = entry1.getKey();
                    TimeSeriesLog farthestEndingStatus = entry1.getValue();
                    long millisecondsDifference = farthestEndingStatus.getEventTime().getTime() - earliestStartingStatus.getEventTime().getTime();
                    double daysDifference = millisecondsDifference / 86400000L;
                    long totalCount = 0L;
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    double cumulativeTimeDifference = 0.0;
                    TimeSeriesLog currentActiveItem = new TimeSeriesLog();
                    for (TimeSeriesLog timeSeriesLog : activeStatusList) {
                        if (!timeSeriesLog.getItemId().equals(earliestStartingStatus.getItemId())) continue;
                        currentActiveItem = timeSeriesLog;
                        Date currentEventTime = currentActiveItem.getEventTime();
                        LinkedHashMap currentStatusMap = new LinkedHashMap();
                        if (currentActiveItem.getChanges().get("status") == null || currentEventTime.compareTo(earliestStartingStatus.getEventTime()) <= 0) continue;
                        currentStatusMap = (LinkedHashMap)currentActiveItem.getChanges().get("status");
                        Query queryForOtherEntries = new Query((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)currentActiveItem.getItemId()).and("changes.status.id").ne((Object)currentStatusMap.get("id").toString()).and("eventTime").gt((Object)currentEventTime));
                        TimeSeriesLog otherEntry = (TimeSeriesLog)this.mongoTemplate.findOne(queryForOtherEntries, TimeSeriesLog.class, "itemTimeSeries");
                        if (otherEntry == null) continue;
                        long milliSecDifference = otherEntry.getEventTime().getTime() - currentActiveItem.getEventTime().getTime();
                        double activeDaysDifference = milliSecDifference / 86400000L;
                        if (activeDaysDifference < 1.0 && activeDaysDifference >= 0.0) {
                            activeDaysDifference = 1.0;
                        }
                        cumulativeTimeDifference += activeDaysDifference;
                    }
                    String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, farthestEndingStatus, daysDifference, relevantDates);
                    if (key == null) continue;
                    String fields = null;
                    if (list.size() > 1) {
                        if (!list.get(0).equals(list.get(1))) {
                            fields = list.get(1);
                        }
                    } else {
                        fields = list.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, fields);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        percentage = currentValue + tempPercentage;
                    }
                    if (!(percentage > 0.0)) continue;
                    sprintCounts.put(temp, percentage);
                    double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                    double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                    currentActiveValue += cumulativeTimeDifference;
                    currentTotalValue += daysDifference;
                    currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                    currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                    activeCounts.put(temp, currentActiveValue);
                    totalCounts.put(temp, currentTotalValue);
                    itemsDaysMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, cumulativeTimeDifference * 100.0 / daysDifference);
                    itemTeamsMap.put("itemId_" + earliestStartingStatus.getItemId() + ":" + fields, new ArrayList());
                }
            }
            for (Map.Entry<List<String>, Map<Object, Object>> entry : sprintCounts.entrySet()) {
                long l = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)l;
                entry.setValue((Map<Object, Object>)Double.parseDouble(this.df.format(value)));
            }
            ArrayList newEntries = new ArrayList();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    if (categories.indexOf(tempInterval) >= indexOfInterval || tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                }
            }
            for (Map.Entry entry : newEntries) {
                sprintCounts.put(entry.getKey(), (Double)entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSCustomFieldsEfficiencyDataAgainstInterval()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        return result;
    }

    public Map<String, Object> getTeamEfficiencybyCreationDate(Map<String, List<TimeSeriesLog>> teamStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                query.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(query, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchItems(itemIds);
                Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String teamId = entry.getKey();
                    Team teamFound = teamMap.get(teamId);
                    if (teamFound == null) continue;
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog timeSeriesLog : farthestEndingStatusList) {
                        double percentage;
                        String itemId = timeSeriesLog.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = this.getDateDifference(selectedItem, timeSeriesLog);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, timeSeriesLog);
                        String key = this.getValueOfDataKey(interval, allIntervals, timeSeriesLog, timeSeriesLog, daysDifference, relevantDates);
                        if (key == null) continue;
                        String team2 = teamFound.getTitle();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team2);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        if (!(percentage > 0.0)) continue;
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(timeSeriesLog.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + timeSeriesLog.getItemId() + ":" + team2, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + timeSeriesLog.getItemId() + ":" + team2, new ArrayList());
                    }
                }
                for (Map.Entry<String, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getCardTypeEfficiencybyCreationDate(Map<List<IssueType>, List<TimeSeriesLog>> issueTypeStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeStatusMap)) {
                Set itemIds = issueTypeStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                Set set = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(itemIds, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<List<IssueType>, List<TimeSeriesLog>> entry : issueTypeStatusMap.entrySet()) {
                    List<IssueType> issueTypes = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        double percentage;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = this.getDateDifference(selectedItem, endingStatus);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                        String key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String issueType = issueTypes.size() > 1 && !issueTypes.get(0).equals(issueTypes.get(1)) ? issueTypes.get(1).getTitle() : issueTypes.get(0).getTitle();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, issueType);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + issueType, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + issueType, new ArrayList());
                    }
                }
                for (Map.Entry<List<Object>, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getPlannedUnplannedEfficiencybyCreationDate(Map<List<String>, List<TimeSeriesLog>> plannedUnplannedStatusMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        TimeSeriesLog earliestStartingStatus = new TimeSeriesLog();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
            for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : plannedUnplannedStatusMap.entrySet()) {
                List<String> plannedUnplanned = entry.getKey();
                long totalCount = 0L;
                List<TimeSeriesLog> farthestEndingStatus = entry.getValue();
                for (TimeSeriesLog endingStatus : farthestEndingStatus) {
                    double percentage;
                    String itemId = endingStatus.getItemId();
                    Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                    Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                    double daysDifference = 0.0;
                    if (selectedItem == null) continue;
                    daysDifference = this.getDateDifference(selectedItem, endingStatus);
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    double cumulativeTimeDifference = 0.0;
                    cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                    String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, endingStatus, daysDifference, relevantDates);
                    TimeSeriesLog currentActiveItem = new TimeSeriesLog();
                    if (key == null) continue;
                    String plannedUnplannedString = null;
                    if (plannedUnplanned.size() > 1) {
                        if (!plannedUnplanned.get(0).equals(plannedUnplanned.get(1))) {
                            plannedUnplannedString = plannedUnplanned.get(1);
                        }
                    } else {
                        plannedUnplannedString = plannedUnplanned.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, plannedUnplannedString);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        percentage = currentValue + tempPercentage;
                    }
                    sprintCounts.put(temp, percentage);
                    double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                    double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                    currentActiveValue += cumulativeTimeDifference;
                    currentTotalValue += daysDifference;
                    currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                    currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                    activeCounts.put(temp, currentActiveValue);
                    totalCounts.put(temp, currentTotalValue);
                    itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + plannedUnplannedString, cumulativeTimeDifference * 100.0 / daysDifference);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + plannedUnplannedString, new ArrayList());
                }
            }
            for (Map.Entry<List<String>, List<Object>> entry : sprintCounts.entrySet()) {
                long totalCount = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
            }
            HashMap newEntries = new HashMap();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    int tempIndex = categories.indexOf(tempInterval);
                    if (tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    if (sprintCounts.containsKey(tempMap)) continue;
                    newEntries.put(tempMap, 0.0);
                }
            }
            sprintCounts.putAll(newEntries);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPlannedUnplannedEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        return result;
    }

    public Map<String, Object> getJiraProjectEfficiencybyCreationDate(Map<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> jiraProjectIssueTypeMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        double daysDifference = 0.0;
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(jiraProjectIssueTypeMap)) {
                Set itemIds = jiraProjectIssueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                Set set = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(set, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> entry : jiraProjectIssueTypeMap.entrySet()) {
                    List<JiraProjectIssueTypes> jiraProjectIssueTypes = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        double percentage;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        daysDifference = this.getDateDifference(selectedItem, endingStatus);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                        String key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String jiraProjectissueType = jiraProjectIssueTypes.size() > 1 && !jiraProjectIssueTypes.get(0).equals((Object)jiraProjectIssueTypes.get(1)) ? jiraProjectIssueTypes.get(1).getJiraProjectKey() : jiraProjectIssueTypes.get(0).getJiraProjectKey();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, jiraProjectissueType);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + jiraProjectissueType, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + jiraProjectissueType, new ArrayList());
                    }
                }
                for (Map.Entry<List<Object>, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getTFSProjectEfficiencybyCreationDate(Map<List<TFSProject>, List<TimeSeriesLog>> tfsProjectIssueTypeMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        double daysDifference = 0.0;
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(tfsProjectIssueTypeMap)) {
                Set itemIds = tfsProjectIssueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                Set set = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(set, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<List<TFSProject>, List<TimeSeriesLog>> entry : tfsProjectIssueTypeMap.entrySet()) {
                    List<TFSProject> tfsProjects = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        double percentage;
                        String itemId = endingStatus.getItemId();
                        Item item = (Item)itemMap.get(itemId);
                        if (item == null) continue;
                        daysDifference = this.getDateDifference(item, endingStatus);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                        String key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String tfsProject = tfsProjects.size() > 1 && !tfsProjects.get(0).equals((Object)tfsProjects.get(1)) ? tfsProjects.get(1).getName() : tfsProjects.get(0).getName();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, tfsProject);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + tfsProject, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + tfsProject, new ArrayList());
                    }
                }
                for (Map.Entry<List<Object>, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories = !allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String string : categories) {
                        int tempIndex = categories.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getAreaPathEfficiencybyCreationDate(Map<List<String>, List<TimeSeriesLog>> areaPathMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        double daysDifference = 0.0;
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(areaPathMap)) {
                Set itemIds = areaPathMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                List list = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
                Map<String, Item> itemMap = list.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
                Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : areaPathMap.entrySet()) {
                    List<String> areaPaths = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        double percentage;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        daysDifference = this.getDateDifference(selectedItem, endingStatus);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                        String key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String areaPath = areaPaths.size() > 1 && !areaPaths.get(0).equals(areaPaths.get(1)) ? areaPaths.get(1) : areaPaths.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, areaPath);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + areaPath, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + areaPath, new ArrayList());
                    }
                }
                for (Map.Entry<List<String>, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAreaPathEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getParentEpicEfficiencybyCreationDate(Map<List<String>, List<TimeSeriesLog>> parentEpicMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>(relevantDates.keySet());
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        double daysDifference = 0.0;
        try {
            allSprints = new ArrayList();
            if (PropertyValidator.isValid(parentEpicMap)) {
                Set itemIds = parentEpicMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                List allItems = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
                Map<String, Item> itemMap = allItems.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
                Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
                for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : parentEpicMap.entrySet()) {
                    List<String> parentEpics = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        double percentage;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        daysDifference = this.getDateDifference(selectedItem, endingStatus);
                        if (daysDifference < 1.0) {
                            if (!(daysDifference >= 0.0)) continue;
                            daysDifference = 1.0;
                        }
                        double cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                        String key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates);
                        if (key == null) continue;
                        String parentEpic = parentEpics.size() > 1 && !parentEpics.get(0).equals(parentEpics.get(1)) ? parentEpics.get(1) : parentEpics.get(0);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, parentEpic);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                            percentage = currentValue + tempPercentage;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, percentage);
                        double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                        double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                        currentActiveValue += cumulativeTimeDifference;
                        currentTotalValue += daysDifference;
                        currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                        currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                        activeCounts.put(temp, currentActiveValue);
                        totalCounts.put(temp, currentTotalValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + parentEpic, cumulativeTimeDifference * 100.0 / daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + parentEpic, new ArrayList());
                    }
                }
                for (Map.Entry<List<String>, List<Object>> entry : sprintCounts.entrySet()) {
                    long totalCount = (Long)countMap.get(entry.getKey());
                    double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                    entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getParentEpicEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getJiraCustomFieldEfficiencybyCreationDate(Map<List<String>, List<TimeSeriesLog>> customFieldsMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        TimeSeriesLog earliestStartingStatus = new TimeSeriesLog();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
            for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : customFieldsMap.entrySet()) {
                List<String> jiraCustomFields = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatus = entry.getValue();
                long totalCount = 0L;
                for (TimeSeriesLog endingStatus : farthestEndingStatus) {
                    double percentage;
                    String itemId = endingStatus.getItemId();
                    Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                    Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                    long millisecondsDifference = 0L;
                    double daysDifference = 0.0;
                    if (selectedItem == null) continue;
                    daysDifference = this.getDateDifference(selectedItem, endingStatus);
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    double cumulativeTimeDifference = 0.0;
                    cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                    String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, endingStatus, daysDifference, relevantDates);
                    if (key == null) continue;
                    String fields = null;
                    if (jiraCustomFields.size() > 1) {
                        if (!jiraCustomFields.get(0).equals(jiraCustomFields.get(1))) {
                            fields = jiraCustomFields.get(1);
                        }
                    } else {
                        fields = jiraCustomFields.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, fields);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        percentage = currentValue + tempPercentage;
                    }
                    sprintCounts.put(temp, percentage);
                    double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                    double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                    currentActiveValue += cumulativeTimeDifference;
                    currentTotalValue += daysDifference;
                    currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                    currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                    activeCounts.put(temp, currentActiveValue);
                    totalCounts.put(temp, currentTotalValue);
                    itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + fields, cumulativeTimeDifference * 100.0 / daysDifference);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + fields, new ArrayList());
                }
            }
            for (Map.Entry<List<String>, List<Object>> entry : sprintCounts.entrySet()) {
                long totalCount = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
            }
            HashMap newEntries = new HashMap();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    int tempIndex = categories.indexOf(tempInterval);
                    if (tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    if (sprintCounts.containsKey(tempMap)) continue;
                    newEntries.put(tempMap, 0.0);
                }
            }
            sprintCounts.putAll(newEntries);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraCustomFieldEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        return result;
    }

    public Map<String, Object> getTFSCustomFieldEfficiencybyCreationDate(Map<List<String>, List<TimeSeriesLog>> customFieldsMap, List<TimeSeriesLog> activeStatusList, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        TimeSeriesLog earliestStartingStatus = new TimeSeriesLog();
        HashMap countMap = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap activeCounts = new HashMap();
        HashMap totalCounts = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            Set ids = activeStatusList.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map logsByItemId = this.populateLogsbyItemIdsMap(ids, sessionBoardId, tenant, sDate, eDate);
            for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : customFieldsMap.entrySet()) {
                List<String> tfsCustomFields = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatus = entry.getValue();
                long totalCount = 0L;
                for (TimeSeriesLog endingStatus : farthestEndingStatus) {
                    double percentage;
                    String itemId = endingStatus.getItemId();
                    Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                    Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                    double daysDifference = 0.0;
                    if (selectedItem == null) continue;
                    daysDifference = this.getDateDifference(selectedItem, endingStatus);
                    if (daysDifference < 1.0) {
                        if (!(daysDifference >= 0.0)) continue;
                        daysDifference = 1.0;
                    }
                    double cumulativeTimeDifference = 0.0;
                    cumulativeTimeDifference = this.getCumulativeActiveTimeDifference(logsByItemId, activeStatusList, endingStatus);
                    String key = this.getValueOfDataKey(interval, allIntervals, earliestStartingStatus, endingStatus, daysDifference, relevantDates);
                    if (key == null) continue;
                    String fields = null;
                    if (tfsCustomFields.size() > 1) {
                        if (!tfsCustomFields.get(0).equals(tfsCustomFields.get(1))) {
                            fields = tfsCustomFields.get(1);
                        }
                    } else {
                        fields = tfsCustomFields.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    temp.put(key, fields);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        percentage = cumulativeTimeDifference * 100.0 / daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        double tempPercentage = cumulativeTimeDifference * 100.0 / daysDifference;
                        percentage = currentValue + tempPercentage;
                    }
                    sprintCounts.put(temp, percentage);
                    double currentActiveValue = activeCounts.getOrDefault(temp, 0.0);
                    double currentTotalValue = totalCounts.getOrDefault(temp, 0.0);
                    currentActiveValue += cumulativeTimeDifference;
                    currentTotalValue += daysDifference;
                    currentActiveValue = Double.parseDouble(this.df.format(currentActiveValue));
                    currentTotalValue = Double.parseDouble(this.df.format(currentTotalValue));
                    activeCounts.put(temp, currentActiveValue);
                    totalCounts.put(temp, currentTotalValue);
                    itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + fields, cumulativeTimeDifference * 100.0 / daysDifference);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + fields, new ArrayList());
                }
            }
            for (Map.Entry<List<String>, List<Object>> entry : sprintCounts.entrySet()) {
                long totalCount = (Long)countMap.get(entry.getKey());
                double value = (Double)((Object)entry.getValue()) / (double)totalCount;
                entry.setValue((List<Object>)Double.parseDouble(this.df.format(value)));
            }
            HashMap newEntries = new HashMap();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    int tempIndex = categories.indexOf(tempInterval);
                    if (tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    if (sprintCounts.containsKey(tempMap)) continue;
                    newEntries.put(tempMap, 0.0);
                }
            }
            sprintCounts.putAll(newEntries);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSCustomFieldEfficiencybyCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemActiveCountsMap", activeCounts);
        result.put("itemTotalCountsMap", totalCounts);
        return result;
    }

    public Map<String, Object> getTeamVelocitybyCompletion(Map<String, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        Set<Object> itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                teamQuery.fields().include("title").include("label");
                List list = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = list.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String teamId = entry.getKey();
                    Team teamFound = teamMap.get(teamId);
                    if (teamFound == null) continue;
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    long totalCount = 0L;
                    double numberOfItems = 0.0;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String key;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = 1.0;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (completionStatuses.contains(status.get("id"))) {
                            numberOfItems += 1.0;
                        }
                        if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                            String team2 = teamFound.getTitle();
                            HashMap<String, String> temp = new HashMap<String, String>();
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            temp.put(key, team2);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                currentValue = daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                currentValue = currentValue + daysDifference;
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            itemIds.add(endingStatus.getItemId());
                            itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, daysDifference);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, new ArrayList());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String team3 = teamFound.getTitle();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        temp.put(key, team3);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(endingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team3, daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team3, new ArrayList());
                    }
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getCardTypeVelocitybyCompletion(Map<List<IssueType>, List<TimeSeriesLog>> issueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        Set<Object> itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeMap)) {
                itemIds = issueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry entry : issueTypeMap.entrySet()) {
                    List list = (List)entry.getKey();
                    List farthestEndingStatusList = (List)entry.getValue();
                    long totalCount = 0L;
                    double numberOfItems = 0.0;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String team;
                        String key;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = 1.0;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (completionStatuses.contains(status.get("id"))) {
                            numberOfItems += 1.0;
                        }
                        if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            String team2;
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                            String string = team2 = list.size() > 1 && !((IssueType)list.get(0)).equals(list.get(1)) ? ((IssueType)list.get(1)).getTitle() : ((IssueType)list.get(0)).getTitle();
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, team2);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                currentValue = daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                currentValue = currentValue + daysDifference;
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, daysDifference);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, new ArrayList());
                            itemIds.add(endingStatus.getItemId());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String string = team = list.size() > 1 && !((IssueType)list.get(0)).equals(list.get(1)) ? ((IssueType)list.get(1)).getTitle() : ((IssueType)list.get(0)).getTitle();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(endingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team, daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team, new ArrayList());
                    }
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(hashMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getPlannedUnplannedVelocitybyCompletion(Map<List<String>, List<TimeSeriesLog>> issueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap countMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : issueTypeMap.entrySet()) {
                List<String> tfsCustomFields = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatus = entry.getValue();
                double numberOfItems = 0.0;
                long totalCount = 0L;
                for (TimeSeriesLog endingStatus : farthestEndingStatus) {
                    String key;
                    String itemId = endingStatus.getItemId();
                    Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                    Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                    double daysDifference = 0.0;
                    if (selectedItem == null) continue;
                    daysDifference = 1.0;
                    HashMap status = (HashMap)endingStatus.getChanges().get("status");
                    if (completionStatuses.contains((String)status.get("id"))) {
                        numberOfItems += 1.0;
                    }
                    if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null) continue;
                    String team = null;
                    if (tfsCustomFields.size() > 1) {
                        if (!tfsCustomFields.get(0).equals(tfsCustomFields.get(1))) {
                            team = tfsCustomFields.get(1);
                        }
                    } else {
                        team = tfsCustomFields.get(0);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, team);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    totalCount = countMap.getOrDefault(temp, 0L);
                    if (currentValue == 0.0) {
                        countMap.put(temp, ++totalCount);
                        currentValue = daysDifference;
                    } else {
                        countMap.put(temp, ++totalCount);
                        currentValue = currentValue + daysDifference;
                    }
                    sprintCounts.put(temp, currentValue);
                    itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team, daysDifference);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team, new ArrayList());
                }
            }
            HashMap newEntries = new HashMap();
            for (Map.Entry entry : sprintCounts.entrySet()) {
                Map tempKey = (Map)entry.getKey();
                String intervalPart = (String)tempKey.keySet().iterator().next();
                String value = (String)tempKey.get(intervalPart);
                List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                int indexOfInterval = categories.indexOf(intervalPart);
                for (String tempInterval : categories) {
                    int tempIndex = categories.indexOf(tempInterval);
                    if (tempInterval.equals(intervalPart)) continue;
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put(tempInterval, value);
                    if (sprintCounts.containsKey(tempMap)) continue;
                    newEntries.put(tempMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPlannedUnplannedVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        return result;
    }

    public Map<String, Object> getJiraProjectVelocitybyCompletion(Map<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> issueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        Set<Object> itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeMap)) {
                itemIds = issueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry entry : issueTypeMap.entrySet()) {
                    List list = (List)entry.getKey();
                    List farthestEndingStatusList = (List)entry.getValue();
                    long totalCount = 0L;
                    double numberOfItems = 0.0;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String team;
                        String key;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = 1.0;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (completionStatuses.contains(status.get("id"))) {
                            numberOfItems += 1.0;
                        }
                        if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            String team2;
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                            String string = team2 = list.size() > 1 && !((JiraProjectIssueTypes)list.get(0)).equals(list.get(1)) ? ((JiraProjectIssueTypes)list.get(1)).getJiraProjectKey() : ((JiraProjectIssueTypes)list.get(0)).getJiraProjectKey();
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, team2);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                currentValue = daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                currentValue = currentValue + daysDifference;
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, daysDifference);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, new ArrayList());
                            itemIds.add(endingStatus.getItemId());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String string = team = list.size() > 1 && !((JiraProjectIssueTypes)list.get(0)).equals(list.get(1)) ? ((JiraProjectIssueTypes)list.get(1)).getJiraProjectKey() : ((JiraProjectIssueTypes)list.get(0)).getJiraProjectKey();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team, daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team, new ArrayList());
                        itemIds.add(endingStatus.getItemId());
                    }
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(hashMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getTFSProjectVelocitybyCompletion(Map<List<TFSProject>, List<TimeSeriesLog>> issueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        Set<Object> itemIds = new HashSet();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeMap)) {
                itemIds = issueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry entry : issueTypeMap.entrySet()) {
                    List list = (List)entry.getKey();
                    List farthestEndingStatusList = (List)entry.getValue();
                    long totalCount = 0L;
                    double numberOfItems = 0.0;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String team;
                        String key;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = 1.0;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (completionStatuses.contains(status.get("id"))) {
                            numberOfItems += 1.0;
                        }
                        if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            String team2;
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                            String string = team2 = list.size() > 1 && !((TFSProject)list.get(0)).equals(list.get(1)) ? ((TFSProject)list.get(1)).getName() : ((TFSProject)list.get(0)).getName();
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, team2);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                currentValue = daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                currentValue = currentValue + daysDifference;
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            itemIds.add(endingStatus.getItemId());
                            itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, daysDifference);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, new ArrayList());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String string = team = list.size() > 1 && !((TFSProject)list.get(0)).equals(list.get(1)) ? ((TFSProject)list.get(1)).getName() : ((TFSProject)list.get(0)).getName();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemIds.add(endingStatus.getItemId());
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team, daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team, new ArrayList());
                    }
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(hashMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getStringTypeVelocitybyCompletion(Map<List<String>, List<TimeSeriesLog>> issueTypeMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> completionStatuses) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap<String, Double> itemsDaysMap = new HashMap<String, Double>();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        HashMap countMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        Set<Object> itemIds = new HashSet();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(issueTypeMap)) {
                itemIds = issueTypeMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry entry : issueTypeMap.entrySet()) {
                    List list = (List)entry.getKey();
                    List farthestEndingStatusList = (List)entry.getValue();
                    long totalCount = 0L;
                    double numberOfItems = 0.0;
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String team;
                        String key;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        double daysDifference = 1.0;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (completionStatuses.contains(status.get("id"))) {
                            numberOfItems += 1.0;
                        }
                        if ((key = this.getValueOfDataKey(interval, allIntervals, endingStatus, endingStatus, daysDifference, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            String team2;
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                            String string = team2 = list.size() > 1 && !((String)list.get(0)).equals(list.get(1)) ? (String)list.get(1) : (String)list.get(0);
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, team2);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            totalCount = countMap.getOrDefault(temp, 0L);
                            if (currentValue == 0.0) {
                                countMap.put(temp, ++totalCount);
                                currentValue = daysDifference;
                            } else {
                                countMap.put(temp, ++totalCount);
                                currentValue = currentValue + daysDifference;
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, daysDifference);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team2, new ArrayList());
                            itemIds.add(endingStatus.getItemId());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String string = team = list.size() > 1 && !((String)list.get(0)).equals(list.get(1)) ? (String)list.get(1) : (String)list.get(0);
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, team);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        totalCount = countMap.getOrDefault(temp, 0L);
                        if (currentValue == 0.0) {
                            countMap.put(temp, ++totalCount);
                            currentValue = daysDifference;
                        } else {
                            countMap.put(temp, ++totalCount);
                            currentValue = currentValue + daysDifference;
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":" + team, daysDifference);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + team, new ArrayList());
                        itemIds.add(endingStatus.getItemId());
                    }
                }
                HashMap newEntries = new HashMap();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<String> categories = !allIntervals.isEmpty() ? allIntervals : allSprints;
                    int indexOfInterval = categories.indexOf(intervalPart);
                    for (String tempInterval : categories) {
                        int tempIndex = categories.indexOf(tempInterval);
                        if (tempInterval.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(tempInterval, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.put(tempMap, 0.0);
                    }
                }
                sprintCounts.putAll(newEntries);
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(hashMap, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getStringTypeVelocitybyCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemIds", itemIds);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("itemGroupByMap", itemGroupByMap);
        result.put("itemSprintsMap", itemSprintsMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getTeamLoadByCompletion(Map<String, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
        try {
            HashMap<String, String> temp;
            List<Object> categories;
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                query.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(query, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String teamId = entry.getKey();
                    Team team2 = teamMap.get(teamId);
                    if (team2 == null) continue;
                    HashMap latestEntriesBySprint = new HashMap();
                    for (TimeSeriesLog log : entry.getValue()) {
                        String itemId = log.getItemId();
                        String sprintKey = this.getValueOfDataKeyFlowLoad(interval, allIntervals, log, relevantDates);
                        if (sprintKey == null) continue;
                        latestEntriesBySprint.putIfAbsent(sprintKey, new HashMap());
                        Map latestEntriesForSprint = (Map)latestEntriesBySprint.get(sprintKey);
                        if (latestEntriesForSprint.containsKey(itemId) && !TimeSeriesUtils.stripTime((Date)log.getEventTime()).after(TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)latestEntriesForSprint.get(itemId)).getEventTime()))) continue;
                        latestEntriesForSprint.put(itemId, log);
                    }
                    for (Map latestEntriesForSprint : latestEntriesBySprint.values()) {
                        for (TimeSeriesLog endingStatus : latestEntriesForSprint.values()) {
                            String key;
                            HashMap status;
                            long numberOfActiveItems = 0L;
                            long numberOfWaitingItems = 0L;
                            String itemId = endingStatus.getItemId();
                            Item selectedItem = (Item)itemMap.get(itemId);
                            if (selectedItem == null || !PropertyValidator.isValid((Object)(status = (HashMap)endingStatus.getChanges().get("status")))) continue;
                            if (activeStatusIds.contains(status.get("id"))) {
                                numberOfActiveItems = 1L;
                            }
                            if (waitingStatusIds.contains(status.get("id"))) {
                                numberOfWaitingItems = 1L;
                            }
                            if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null) continue;
                            String team22 = team2.getTitle();
                            HashMap<String, String> temp2 = new HashMap<String, String>();
                            temp2.put(key, team22);
                            if (countedSprintItemsMap.containsKey(temp2) && ((List)countedSprintItemsMap.get(temp2)).contains(endingStatus.getItemId())) continue;
                            Double currentValue = sprintCounts.getOrDefault(temp2, 0.0);
                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                            long activeValue = activeItemsCounts.getOrDefault(temp2, 0L);
                            long waitingValue = waitingItemsCounts.getOrDefault(temp2, 0L);
                            activeItemsCounts.put(temp2, activeValue += numberOfActiveItems);
                            waitingItemsCounts.put(temp2, waitingValue += numberOfWaitingItems);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp2, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp2, tempItemIdsSet);
                            countedSprintItemsMap.computeIfAbsent(temp2, l -> new ArrayList()).add(endingStatus.getItemId());
                            sprintCounts.put(temp2, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault("itemId_" + endingStatus.getItemId() + ":team", new ArrayList());
                            if (PropertyValidator.isValid((Object)selectedItem.getStatus()) && !tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":team", tempStatus);
                            }
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":team", new ArrayList());
                        }
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories2 = allIntervals.isEmpty() ? allSprints : allIntervals;
                    int indexOfInterval = categories2.indexOf(intervalPart);
                    for (String string : categories2) {
                        int tempIndex = categories2.indexOf(string);
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.get(tempMap) != null) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamLoadByCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getCardTypeLoadByCompletion(Map<List<IssueType>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            HashMap<String, String> temp;
            List<Object> categories;
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<IssueType>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<IssueType> teamsList = entry.getKey();
                    HashMap latestEntriesBySprint = new HashMap();
                    for (TimeSeriesLog log : entry.getValue()) {
                        String string = log.getItemId();
                        String sprintKey = this.getValueOfDataKeyFlowLoad(interval, allIntervals, log, relevantDates);
                        if (sprintKey == null) continue;
                        latestEntriesBySprint.putIfAbsent(sprintKey, new HashMap());
                        Map latestEntriesForSprint = (Map)latestEntriesBySprint.get(sprintKey);
                        if (latestEntriesForSprint.containsKey(string) && !TimeSeriesUtils.stripTime((Date)log.getEventTime()).after(TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)latestEntriesForSprint.get(string)).getEventTime()))) continue;
                        latestEntriesForSprint.put(string, log);
                    }
                    for (Map latestEntriesForSprint : latestEntriesBySprint.values()) {
                        for (TimeSeriesLog endingStatus : latestEntriesForSprint.values()) {
                            String key;
                            long numberOfActiveItems = 0L;
                            long numberOfWaitingItems = 0L;
                            String itemId = endingStatus.getItemId();
                            Item selectedItem = (Item)itemMap.get(itemId);
                            if (selectedItem == null) continue;
                            HashMap status = (HashMap)endingStatus.getChanges().get("status");
                            if (activeStatusIds.contains(status.get("id"))) {
                                numberOfActiveItems = 1L;
                            }
                            if (waitingStatusIds.contains(status.get("id"))) {
                                numberOfWaitingItems = 1L;
                            }
                            if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null) continue;
                            String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals(teamsList.get(1)) ? teamsList.get(1).getTitle() : teamsList.get(0).getTitle();
                            HashMap<String, String> temp2 = new HashMap<String, String>();
                            temp2.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp2, 0.0);
                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                            long activeValue = activeItemsCounts.getOrDefault(temp2, 0L);
                            long waitingValue = waitingItemsCounts.getOrDefault(temp2, 0L);
                            activeItemsCounts.put(temp2, activeValue += numberOfActiveItems);
                            waitingItemsCounts.put(temp2, waitingValue += numberOfWaitingItems);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp2, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp2, tempItemIdsSet);
                            sprintCounts.put(temp2, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                            if (PropertyValidator.isValid((Object)selectedItem.getStatus()) && !tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":team", tempStatus);
                            }
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                        }
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories2 = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories2) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeLoadByCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getStringLoadByCompletion(Map<List<String>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            HashMap<String, String> temp;
            List<Object> categories;
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<String> teamsList = entry.getKey();
                    HashMap latestEntriesBySprint = new HashMap();
                    for (TimeSeriesLog log : entry.getValue()) {
                        String string = log.getItemId();
                        String sprintKey = this.getValueOfDataKeyFlowLoad(interval, allIntervals, log, relevantDates);
                        if (sprintKey == null) continue;
                        latestEntriesBySprint.putIfAbsent(sprintKey, new HashMap());
                        Map latestEntriesForSprint = (Map)latestEntriesBySprint.get(sprintKey);
                        if (latestEntriesForSprint.containsKey(string) && !TimeSeriesUtils.stripTime((Date)log.getEventTime()).after(TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)latestEntriesForSprint.get(string)).getEventTime()))) continue;
                        latestEntriesForSprint.put(string, log);
                    }
                    for (Map latestEntriesForSprint : latestEntriesBySprint.values()) {
                        for (TimeSeriesLog endingStatus : latestEntriesForSprint.values()) {
                            String key;
                            long numberOfActiveItems = 0L;
                            long numberOfWaitingItems = 0L;
                            String itemId = endingStatus.getItemId();
                            Item selectedItem = (Item)itemMap.get(itemId);
                            if (selectedItem == null) continue;
                            HashMap status = (HashMap)endingStatus.getChanges().get("status");
                            if (activeStatusIds.contains(status.get("id"))) {
                                numberOfActiveItems = 1L;
                            }
                            if (waitingStatusIds.contains(status.get("id"))) {
                                numberOfWaitingItems = 1L;
                            }
                            if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null) continue;
                            String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals(teamsList.get(1)) ? teamsList.get(1) : teamsList.get(0);
                            HashMap<String, String> temp2 = new HashMap<String, String>();
                            temp2.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp2, 0.0);
                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                            long activeValue = activeItemsCounts.getOrDefault(temp2, 0L);
                            long waitingValue = waitingItemsCounts.getOrDefault(temp2, 0L);
                            activeItemsCounts.put(temp2, activeValue += numberOfActiveItems);
                            waitingItemsCounts.put(temp2, waitingValue += numberOfWaitingItems);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp2, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp2, tempItemIdsSet);
                            sprintCounts.put(temp2, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                            if (PropertyValidator.isValid((Object)selectedItem.getStatus()) && !tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":team", tempStatus);
                            }
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                        }
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories2 = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories2) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getStringLoadByCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getJiraProjectLoadByCompletion(Map<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            HashMap<String, String> temp;
            List<Object> categories;
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<JiraProjectIssueTypes> teamsList = entry.getKey();
                    HashMap latestEntriesBySprint = new HashMap();
                    for (TimeSeriesLog log : entry.getValue()) {
                        String string = log.getItemId();
                        String sprintKey = this.getValueOfDataKeyFlowLoad(interval, allIntervals, log, relevantDates);
                        if (sprintKey == null) continue;
                        latestEntriesBySprint.putIfAbsent(sprintKey, new HashMap());
                        Map latestEntriesForSprint = (Map)latestEntriesBySprint.get(sprintKey);
                        if (latestEntriesForSprint.containsKey(string) && !TimeSeriesUtils.stripTime((Date)log.getEventTime()).after(TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)latestEntriesForSprint.get(string)).getEventTime()))) continue;
                        latestEntriesForSprint.put(string, log);
                    }
                    for (Map latestEntriesForSprint : latestEntriesBySprint.values()) {
                        for (TimeSeriesLog endingStatus : latestEntriesForSprint.values()) {
                            String key;
                            long numberOfActiveItems = 0L;
                            long numberOfWaitingItems = 0L;
                            String itemId = endingStatus.getItemId();
                            Item selectedItem = (Item)itemMap.get(itemId);
                            if (selectedItem == null) continue;
                            HashMap status = (HashMap)endingStatus.getChanges().get("status");
                            if (activeStatusIds.contains(status.get("id"))) {
                                numberOfActiveItems = 1L;
                            }
                            if (waitingStatusIds.contains(status.get("id"))) {
                                numberOfWaitingItems = 1L;
                            }
                            if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null) continue;
                            String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals((Object)teamsList.get(1)) ? teamsList.get(1).getJiraProjectKey() : teamsList.get(0).getJiraProjectKey();
                            HashMap<String, String> temp2 = new HashMap<String, String>();
                            temp2.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp2, 0.0);
                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                            long activeValue = activeItemsCounts.getOrDefault(temp2, 0L);
                            long waitingValue = waitingItemsCounts.getOrDefault(temp2, 0L);
                            activeItemsCounts.put(temp2, activeValue += numberOfActiveItems);
                            waitingItemsCounts.put(temp2, waitingValue += numberOfWaitingItems);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp2, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp2, tempItemIdsSet);
                            sprintCounts.put(temp2, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                            if (PropertyValidator.isValid((Object)selectedItem.getStatus()) && !tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":team", tempStatus);
                            }
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                        }
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories2 = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories2) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getJiraProjectLoadByCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getTFSProjectLoadByCompletion(Map<List<TFSProject>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, String> allGroupBys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            HashMap<String, String> temp;
            List<Object> categories;
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<TFSProject>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<TFSProject> teamsList = entry.getKey();
                    HashMap latestEntriesBySprint = new HashMap();
                    for (TimeSeriesLog log : entry.getValue()) {
                        String string = log.getItemId();
                        String sprintKey = this.getValueOfDataKeyFlowLoad(interval, allIntervals, log, relevantDates);
                        if (sprintKey == null) continue;
                        latestEntriesBySprint.putIfAbsent(sprintKey, new HashMap());
                        Map latestEntriesForSprint = (Map)latestEntriesBySprint.get(sprintKey);
                        if (latestEntriesForSprint.containsKey(string) && !TimeSeriesUtils.stripTime((Date)log.getEventTime()).after(TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)latestEntriesForSprint.get(string)).getEventTime()))) continue;
                        latestEntriesForSprint.put(string, log);
                    }
                    for (Map latestEntriesForSprint : latestEntriesBySprint.values()) {
                        for (TimeSeriesLog endingStatus : latestEntriesForSprint.values()) {
                            String key;
                            long numberOfActiveItems = 0L;
                            long numberOfWaitingItems = 0L;
                            String itemId = endingStatus.getItemId();
                            Item selectedItem = (Item)itemMap.get(itemId);
                            if (selectedItem == null) continue;
                            HashMap status = (HashMap)endingStatus.getChanges().get("status");
                            if (activeStatusIds.contains(status.get("id"))) {
                                numberOfActiveItems = 1L;
                            }
                            if (waitingStatusIds.contains(status.get("id"))) {
                                numberOfWaitingItems = 1L;
                            }
                            if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null) continue;
                            String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals((Object)teamsList.get(1)) ? teamsList.get(1).getName() : teamsList.get(0).getName();
                            HashMap<String, String> temp2 = new HashMap<String, String>();
                            temp2.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp2, 0.0);
                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                            long activeValue = activeItemsCounts.getOrDefault(temp2, 0L);
                            long waitingValue = waitingItemsCounts.getOrDefault(temp2, 0L);
                            activeItemsCounts.put(temp2, activeValue += numberOfActiveItems);
                            waitingItemsCounts.put(temp2, waitingValue += numberOfWaitingItems);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp2, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp2, tempItemIdsSet);
                            sprintCounts.put(temp2, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                            if (PropertyValidator.isValid((Object)selectedItem.getStatus()) && !tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":team", tempStatus);
                            }
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", new ArrayList());
                        }
                    }
                }
            }
            if (!sprintCounts.isEmpty()) {
                ArrayList newEntries = new ArrayList();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    Map tempKey = (Map)entry.getKey();
                    String intervalPart = (String)tempKey.keySet().iterator().next();
                    String value = (String)tempKey.get(intervalPart);
                    List<Object> categories2 = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories2) {
                        if (string.equals(intervalPart)) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(string, value);
                        if (sprintCounts.containsKey(tempMap)) continue;
                        newEntries.add(new AbstractMap.SimpleEntry(tempMap, 0.0));
                    }
                }
                for (Map.Entry entry : newEntries) {
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
            } else if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (sprintCounts.isEmpty()) {
                categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    temp = new HashMap();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectLoadByCompletion()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        return result;
    }

    public Map<String, Object> getTeamDistribution(Map<String, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, Map<String, String> selectedIssueTypeMap, String yAxis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap itemTeamsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set<String> teamIds = teamStatusMap.keySet();
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                query.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(query, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String string = entry.getKey();
                    Team teamFound = teamMap.get(string);
                    if (teamFound == null) continue;
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        String key;
                        long numberOfActiveItems = 0L;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (activeStatusIds.contains(status.get("id"))) {
                            numberOfActiveItems = 1L;
                        }
                        if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null || !PropertyValidator.isValid(iterationItemsMap)) continue;
                        if (iterationItemsMap.get(key) != null) {
                            String selectedTeam = teamFound.getTitle();
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId()) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam)) continue;
                            HashMap<String, String> temp = new HashMap<String, String>();
                            List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                            if (existingItemIds.contains(itemId) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam)) continue;
                            existingItemIds.add(itemId);
                            itemIterationMap.put(key, existingItemIds);
                            temp.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            currentValue = currentValue + (double)numberOfActiveItems;
                            long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                            activeValue += numberOfActiveItems;
                            HashMap<String, String> tempIssueType = new HashMap<String, String>();
                            String currentIssueType = null;
                            if (selectedItem.getJiraIssueTypeId() != null) {
                                currentIssueType = selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId());
                                tempIssueType.put(key, currentIssueType);
                            } else if (selectedItem.getTfsItemType() != null) {
                                currentIssueType = selectedItem.getTfsItemType();
                                tempIssueType.put(key, currentIssueType);
                            }
                            if (activeValue > 0L) {
                                issueTypeMap.put(tempIssueType, activeValue);
                            }
                            HashMap<String, String> tempIMap = new HashMap<String, String>();
                            tempIMap.put(selectedTeam, currentIssueType);
                            HashMap<String, HashMap<String, String>> tempMap = new HashMap<String, HashMap<String, String>>();
                            tempMap.put(key, tempIMap);
                            double currentValueOfIssue = issueTypeIterationMap.getOrDefault(tempMap, 0.0);
                            issueTypeIterationMap.put(tempMap, currentValueOfIssue += 1.0);
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                            if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                            }
                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                            itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, new ArrayList());
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String selectedTeam = teamFound.getTitle();
                        HashMap<String, String> temp = new HashMap<String, String>();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        temp.put(key, selectedTeam);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        currentValue = currentValue + (double)numberOfActiveItems;
                        long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                        activeValue += numberOfActiveItems;
                        HashMap<String, String> tempIssueType = new HashMap<String, String>();
                        String currentIssueType = null;
                        if (selectedItem.getJiraIssueTypeId() != null) {
                            currentIssueType = selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId());
                            tempIssueType.put(key, currentIssueType);
                        } else if (selectedItem.getTfsItemType() != null) {
                            currentIssueType = selectedItem.getTfsItemType();
                            tempIssueType.put(key, currentIssueType);
                        }
                        if (activeValue > 0L) {
                            issueTypeMap.put(tempIssueType, activeValue);
                        }
                        HashMap<String, String> tempIMap = new HashMap<String, String>();
                        tempIMap.put(selectedTeam, currentIssueType);
                        HashMap<String, HashMap<String, String>> tempMap = new HashMap<String, HashMap<String, String>>();
                        tempMap.put(key, tempIMap);
                        double currentValueOfIssue = issueTypeIterationMap.getOrDefault(tempMap, 0.0);
                        issueTypeIterationMap.put(tempMap, currentValueOfIssue += 1.0);
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                        }
                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, new ArrayList());
                    }
                }
                if (yAxis.equals("percentage")) {
                    int totalItems = sprintCounts.values().stream().mapToInt(Double::intValue).sum();
                    for (Map.Entry entry : sprintCounts.entrySet()) {
                        double value = (Double)entry.getValue() * 100.0 / (double)totalItems;
                        entry.setValue(Double.parseDouble(this.df.format(value)));
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getTeamDist(Map<String, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType, Map<String, List<TimeSeriesLog>> finalItemsMap, Set<String> plannedItems) throws Exception {
        LinkedHashMap itemIdswrtInterval;
        HashMap<String, List> itemsStatusMap;
        HashMap issueTypeMap;
        HashMap issueTypeIterationMap;
        HashMap sprintCounts;
        ArrayList<String> allSprints;
        HashMap<String, Object> result;
        long startTime;
        block17: {
            startTime = System.currentTimeMillis();
            LOGGER.info("Going to calculate final count now at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            result = new HashMap<String, Object>();
            allSprints = new ArrayList<String>();
            sprintCounts = new HashMap();
            issueTypeIterationMap = new HashMap();
            issueTypeMap = new HashMap();
            itemsStatusMap = new HashMap<String, List>();
            HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
            itemIdswrtInterval = new LinkedHashMap();
            try {
                ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
                for (String sprintId : tempallSprints) {
                    allSprints.add(containers.get(sprintId).getTitle());
                }
                if (!PropertyValidator.isValid(teamStatusMap)) break block17;
                Set<String> teamIds = teamStatusMap.keySet();
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                teamQuery.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchAllItems(itemIds);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String teamId = entry.getKey();
                    Team teamFound = teamMap.get(teamId);
                    if (teamFound == null) continue;
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                        Map<String, Object> currentSprintEntries = en.getValue();
                        for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                            List itemsList = (List)innerEntry.getValue();
                            itemsList.sort(Comparator.comparing(TimeSeriesLog::getEventTime).reversed());
                            for (TimeSeriesLog item : itemsList) {
                                ArrayList teamsList;
                                boolean issueTypeValid;
                                String itemId = item.getItemId();
                                Item selectedItem = (Item)itemMap.get(itemId);
                                if (selectedItem == null || !plannedItems.contains(itemId)) continue;
                                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()) || selectedIssueType.isEmpty() && selectedItem.getJiraIssueTypeId() == null && selectedItem.getTfsItemType() == null);
                                if (!issueTypeValid && !selectedIssueType.isEmpty() || !PropertyValidator.isValid((Collection)(teamsList = (ArrayList)item.getTeamContainers()))) continue;
                                for (Object teamContainer : teamsList) {
                                    BasicDBObject itemTeam;
                                    ObjectId itemTeamId;
                                    BasicDBObject obj;
                                    BasicDBObject containerObj;
                                    if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container")))) continue;
                                    Object sprintIdObj = containerObj.get("_id");
                                    String sprintId = "";
                                    if (sprintIdObj instanceof String) {
                                        sprintId = (String)sprintIdObj;
                                    } else if (sprintIdObj instanceof ObjectId) {
                                        sprintId = ((ObjectId)sprintIdObj).toString();
                                    }
                                    if (!PropertyValidator.isValid((Object)(itemTeamId = (ObjectId)(itemTeam = (BasicDBObject)obj.get("team")).get("_id"))) || !teamId.equalsIgnoreCase(itemTeamId.toString())) continue;
                                    List attachedSprints = this.isSprintChangedAtLastDate(relevantDates, item, finalItemsMap, teamId);
                                    if (PropertyValidator.isValid((Collection)attachedSprints)) {
                                        for (String attachedSprint : attachedSprints) {
                                            Item foundItem;
                                            Team attachedTeam = teamMap.get(teamId);
                                            String selectedTeam = attachedTeam.getTitle();
                                            HashMap<String, String> temp = new HashMap<String, String>();
                                            if (!PropertyValidator.isValid((Object)containers.get(attachedSprint))) continue;
                                            temp.put(containers.get(attachedSprint).getTitle(), selectedTeam);
                                            if (!itemTeamId.toString().equalsIgnoreCase(teamId) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId()) || !PropertyValidator.isValid((Object)itemTeamId)) continue;
                                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                            Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                            List tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                            if (!tempStatus.contains((foundItem = (Item)itemMap.get(item.getItemId())).getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                            }
                                            if (!PropertyValidator.isValid((Object)foundItem.getStatus())) continue;
                                            itemIdsSet.add(item.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                            Double d = currentValue;
                                            Double d2 = currentValue = Double.valueOf(currentValue + 1.0);
                                            sprintCounts.put(temp, currentValue);
                                            itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                        }
                                        continue;
                                    }
                                    String selectedTeam = teamFound.getTitle();
                                    HashMap<String, String> temp = new HashMap<String, String>();
                                    if (!PropertyValidator.isValid((Object)containers.get(en.getKey()))) continue;
                                    temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                    if (!PropertyValidator.isValid((Object)sprintId) || !sprintId.equalsIgnoreCase(en.getKey()) || !PropertyValidator.isValid((Object)containers.get(en.getKey())) || !this.shouldIncludeInSprint(farthestEndingStatusList, item, containers.get(en.getKey()), teamId, finalItemsMap) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                    List tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                    Item foundItem = (Item)itemMap.get(item.getItemId());
                                    if (!PropertyValidator.isValid((Object)foundItem.getStatus())) continue;
                                    if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                        tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                    }
                                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                    Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                    itemIdsSet.add(item.getItemId());
                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                    Double d = currentValue;
                                    Double d3 = currentValue = Double.valueOf(currentValue + 1.0);
                                    sprintCounts.put(temp, currentValue);
                                    countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                    itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getTeamDist()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        LOGGER.info("Final count calculated at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        return result;
    }

    public boolean shouldIncludeInSprint(List<TimeSeriesLog> teamStatusEntries, TimeSeriesLog item, Container container, String teamId, Map<String, List<TimeSeriesLog>> finalItemsMap) throws Exception {
        ArrayList teamsList;
        Date endDate = container.getEndDate();
        Date startDate = container.getStartDate();
        TimeSeriesLog latestEntry = null;
        Date today = new Date();
        List<TimeSeriesLog> allEntries = finalItemsMap.get(item.getItemId());
        if (container.getStartDate().after(TimeSeriesUtils.stripTime((Date)today)) || container.getEndDate().after(today)) {
            for (int i = allEntries.size() - 1; i >= 0; --i) {
                TimeSeriesLog entry;
                if (!PropertyValidator.isValid(allEntries) || !TimeSeriesUtils.stripTime((Date)(entry = allEntries.get(i)).getEventTime()).before(container.getEndDate())) continue;
                latestEntry = entry;
                break;
            }
        } else {
            for (TimeSeriesLog itemEntry : allEntries) {
                if (!TimeSeriesUtils.stripTime((Date)itemEntry.getEventTime()).before(endDate)) continue;
                if (TimeSeriesUtils.stripTime((Date)item.getEventTime()).before(TimeSeriesUtils.stripTime((Date)endDate)) && TimeSeriesUtils.stripTime((Date)item.getEventTime()).after(TimeSeriesUtils.stripTime((Date)startDate))) {
                    latestEntry = itemEntry;
                    break;
                }
                ArrayList teamsList2 = (ArrayList)item.getTeamContainers();
                if (!PropertyValidator.isValid((Collection)teamsList2)) continue;
                block2: for (Object teamContainer : teamsList2) {
                    ArrayList entryTeamsList;
                    BasicDBObject obj = (BasicDBObject)teamContainer;
                    BasicDBObject containerObj = (BasicDBObject)obj.get("container");
                    Object sprintIdObj = containerObj.get("_id");
                    String sprintId = "";
                    if (sprintIdObj instanceof String) {
                        sprintId = (String)sprintIdObj;
                    } else if (sprintIdObj instanceof ObjectId) {
                        sprintId = ((ObjectId)sprintIdObj).toString();
                    }
                    if (!PropertyValidator.isValid((Collection)(entryTeamsList = (ArrayList)itemEntry.getTeamContainers()))) continue;
                    for (Object entryTeamContainer : entryTeamsList) {
                        BasicDBObject entryObj = (BasicDBObject)entryTeamContainer;
                        BasicDBObject entryContainerObj = (BasicDBObject)entryObj.get("container");
                        Object entrySprintIdObj = entryContainerObj.get("_id");
                        String entrySprintId = "";
                        if (entrySprintIdObj instanceof String) {
                            entrySprintId = (String)entrySprintIdObj;
                        } else if (entrySprintIdObj instanceof ObjectId) {
                            entrySprintId = ((ObjectId)entrySprintIdObj).toString();
                        }
                        if (!sprintId.equalsIgnoreCase(entrySprintId)) continue;
                        latestEntry = itemEntry;
                        continue block2;
                    }
                }
            }
        }
        if (!PropertyValidator.isValid(latestEntry) && PropertyValidator.isValid(allEntries)) {
            latestEntry = allEntries.get(allEntries.size() - 1);
        }
        if (PropertyValidator.isValid((Collection)(teamsList = (ArrayList)latestEntry.getTeamContainers()))) {
            for (Object teamContainer : teamsList) {
                if (!(teamContainer instanceof BasicDBObject)) continue;
                BasicDBObject obj = (BasicDBObject)teamContainer;
                BasicDBObject containerObj = (BasicDBObject)obj.get("container");
                Object sprintIdObj = containerObj.get("_id");
                String sprintId = "";
                if (sprintIdObj instanceof String) {
                    sprintId = (String)sprintIdObj;
                } else if (sprintIdObj instanceof ObjectId) {
                    sprintId = ((ObjectId)sprintIdObj).toString();
                }
                BasicDBObject itemTeam = (BasicDBObject)obj.get("team");
                ObjectId itemTeamId = (ObjectId)itemTeam.get("_id");
                if (!sprintId.equalsIgnoreCase(container.getId()) || !itemTeamId.toString().equalsIgnoreCase(teamId)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getTeamLoad(Map<String, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType, List<String> activeStatusIds, List<String> waitingStatusIds, Set<String> activeStatusCategories, Set<String> waitingStatusCategories, String radioTypeSelection, Map<String, List<TimeSeriesLog>> finalItemsMap, Set<String> plannedItems) throws Exception {
        HashMap waitingItemsCounts;
        HashMap activeItemsCounts;
        HashMap<String, List> itemTeamsMap;
        LinkedHashMap itemIdswrtInterval;
        HashMap<String, List> itemsStatusMap;
        HashMap sprintCounts;
        ArrayList<String> allSprints;
        HashMap<String, Object> result;
        long startTime;
        block42: {
            startTime = System.currentTimeMillis();
            LOGGER.info("Going to calculate final count at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            result = new HashMap<String, Object>();
            allSprints = new ArrayList<String>();
            sprintCounts = new HashMap();
            itemsStatusMap = new HashMap<String, List>();
            HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
            itemIdswrtInterval = new LinkedHashMap();
            itemTeamsMap = new HashMap<String, List>();
            activeItemsCounts = new HashMap();
            waitingItemsCounts = new HashMap();
            try {
                ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
                for (String sprintId : tempallSprints) {
                    allSprints.add(containers.get(sprintId).getTitle());
                }
                if (!PropertyValidator.isValid(teamStatusMap)) break block42;
                Set<String> teamIds = teamStatusMap.keySet();
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
                teamQuery.fields().include("title").include("label");
                List allTeams = Optional.ofNullable(this.mongoTemplate.find(teamQuery, Team.class)).orElse(Collections.emptyList());
                Map<String, Team> teamMap = allTeams.stream().collect(Collectors.toMap(team -> team.getId().toString(), team -> team, (existing, replacement) -> existing));
                Map itemMap = this.fetchAllItems(itemIds);
                for (Map.Entry<String, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    String teamId = entry.getKey();
                    Team teamFound = teamMap.get(teamId);
                    if (teamFound == null) continue;
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                        Map<String, Object> currentSprintEntries = en.getValue();
                        for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                            List itemsList = (List)innerEntry.getValue();
                            itemsList.sort(Comparator.comparing(TimeSeriesLog::getEventTime).reversed());
                            for (TimeSeriesLog item : itemsList) {
                                boolean issueTypeValid;
                                String itemId = item.getItemId();
                                Item selectedItem = (Item)itemMap.get(itemId);
                                if (selectedItem == null || !plannedItems.contains(itemId)) continue;
                                boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()) || selectedIssueType.isEmpty() && selectedItem.getJiraIssueTypeId() == null && selectedItem.getTfsItemType() == null);
                                if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                                long numberOfActiveItems = 0L;
                                long numberOfWaitingItems = 0L;
                                ArrayList teamsList = (ArrayList)item.getTeamContainers();
                                if (!PropertyValidator.isValid((Collection)teamsList)) continue;
                                for (Object teamContainer : teamsList) {
                                    BasicDBObject itemTeam;
                                    ObjectId itemTeamId;
                                    BasicDBObject obj;
                                    BasicDBObject containerObj;
                                    if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container")))) continue;
                                    Object sprintIdObj = containerObj.get("_id");
                                    String sprintId = "";
                                    if (sprintIdObj instanceof String) {
                                        sprintId = (String)sprintIdObj;
                                    } else if (sprintIdObj instanceof ObjectId) {
                                        sprintId = ((ObjectId)sprintIdObj).toString();
                                    }
                                    if (!PropertyValidator.isValid((Object)(itemTeamId = (ObjectId)(itemTeam = (BasicDBObject)obj.get("team")).get("_id"))) || !teamId.equalsIgnoreCase(itemTeamId.toString())) continue;
                                    List attachedSprints = this.isSprintChangedAtLastDate(relevantDates, item, finalItemsMap, teamId);
                                    if (PropertyValidator.isValid((Collection)attachedSprints)) {
                                        for (String attachedSprint : attachedSprints) {
                                            ObjectId attachedTeamId = (ObjectId)itemTeam.get("_id");
                                            Team attachedTeam = teamMap.get(attachedTeamId.toString());
                                            String selectedTeam = attachedTeam.getTitle();
                                            HashMap<String, String> temp = new HashMap<String, String>();
                                            if (!PropertyValidator.isValid((Object)containers.get(attachedSprint))) continue;
                                            temp.put(containers.get(attachedSprint).getTitle(), selectedTeam);
                                            if (!itemTeamId.toString().equalsIgnoreCase(teamId) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId()) || !PropertyValidator.isValid((Object)attachedTeamId)) continue;
                                            Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                            Map changes = item.getChanges();
                                            Map status = (Map)changes.get("status");
                                            if ("status".equalsIgnoreCase(radioTypeSelection) && PropertyValidator.isValid((Object)status) && status.containsKey("category")) {
                                                List tempStatus;
                                                Item foundItem;
                                                if (activeStatusIds.contains(status.get("id"))) {
                                                    itemIdsSet.add(item.getItemId());
                                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                                    foundItem = (Item)itemMap.get(item.getItemId());
                                                    if (PropertyValidator.isValid((Object)foundItem) && !(tempStatus = (List)itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList())).contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                        tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                        itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                    }
                                                    numberOfActiveItems = 1L;
                                                }
                                                if (waitingStatusIds.contains(status.get("id"))) {
                                                    itemIdsSet.add(item.getItemId());
                                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                                    foundItem = (Item)itemMap.get(item.getItemId());
                                                    if (PropertyValidator.isValid((Object)foundItem) && !(tempStatus = (List)itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList())).contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                        tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                        itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                    }
                                                    numberOfWaitingItems = 1L;
                                                }
                                            } else if ("statusCategory".equalsIgnoreCase(radioTypeSelection)) {
                                                List tempStatus;
                                                String category = (String)status.get("category");
                                                if (activeStatusCategories.contains(category)) {
                                                    numberOfActiveItems = 1L;
                                                    Item foundItem = (Item)itemMap.get(item.getItemId());
                                                    if (PropertyValidator.isValid((Object)foundItem) && !(tempStatus = (List)itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList())).contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                        tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                        itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                        itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                    }
                                                    itemIdsSet.add(item.getItemId());
                                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                                }
                                                if (waitingStatusCategories.contains(category)) {
                                                    numberOfWaitingItems = 1L;
                                                    itemIdsSet.add(item.getItemId());
                                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                                    Item foundItem = (Item)itemMap.get(item.getItemId());
                                                    if (PropertyValidator.isValid((Object)foundItem)) {
                                                        tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                                        if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                            tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                        }
                                                        itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                        itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                    }
                                                }
                                            }
                                            countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                                            long activeValue = activeItemsCounts.getOrDefault(temp, 0L);
                                            long waitingValue = waitingItemsCounts.getOrDefault(temp, 0L);
                                            activeItemsCounts.put(temp, activeValue += numberOfActiveItems);
                                            waitingItemsCounts.put(temp, waitingValue += numberOfWaitingItems);
                                            sprintCounts.put(temp, currentValue);
                                        }
                                        continue;
                                    }
                                    String selectedTeam = teamFound.getTitle();
                                    HashMap<String, String> temp = new HashMap<String, String>();
                                    if (!PropertyValidator.isValid((Object)containers.get(en.getKey()))) continue;
                                    temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                    if (!PropertyValidator.isValid((Object)sprintId) || !sprintId.equalsIgnoreCase(en.getKey()) || !PropertyValidator.isValid((Object)containers.get(en.getKey())) || !this.shouldIncludeInSprint(farthestEndingStatusList, item, containers.get(en.getKey()), teamId, finalItemsMap) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                    Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                    Map changes = item.getChanges();
                                    Map status = (Map)changes.get("status");
                                    if ("status".equalsIgnoreCase(radioTypeSelection) && PropertyValidator.isValid((Object)status) && status.containsKey("category")) {
                                        Item foundItem;
                                        if (activeStatusIds.contains(status.get("id"))) {
                                            numberOfActiveItems = 1L;
                                            itemIdsSet.add(item.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            foundItem = (Item)itemMap.get(item.getItemId());
                                            if (PropertyValidator.isValid((Object)foundItem)) {
                                                List tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                                if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                    tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                }
                                                itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                            }
                                        }
                                        if (waitingStatusIds.contains(status.get("id"))) {
                                            numberOfWaitingItems = 1L;
                                            itemIdsSet.add(item.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            foundItem = (Item)itemMap.get(item.getItemId());
                                            if (PropertyValidator.isValid((Object)foundItem)) {
                                                List tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                                if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                    tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                }
                                                itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                            }
                                        }
                                    } else if ("statusCategory".equalsIgnoreCase(radioTypeSelection)) {
                                        List tempStatus;
                                        String category = (String)status.get("category");
                                        if (activeStatusCategories.contains(category)) {
                                            numberOfActiveItems = 1L;
                                            itemIdsSet.add(item.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            Item foundItem = (Item)itemMap.get(item.getItemId());
                                            if (PropertyValidator.isValid((Object)foundItem)) {
                                                tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                                if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                    tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                }
                                                itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                            }
                                        }
                                        if (waitingStatusCategories.contains(category)) {
                                            numberOfWaitingItems = 1L;
                                            itemIdsSet.add(item.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            Item foundItem = (Item)itemMap.get(item.getItemId());
                                            if (PropertyValidator.isValid((Object)foundItem)) {
                                                tempStatus = itemsStatusMap.getOrDefault(item.getItemId(), new ArrayList());
                                                if (!tempStatus.contains(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory())) {
                                                    tempStatus.add(foundItem.getStatus().getTitle() + "status_category:" + foundItem.getStatus().getCategory());
                                                }
                                                itemsStatusMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                                itemTeamsMap.put("itemId_" + item.getItemId() + ":selectedTeam", tempStatus);
                                            }
                                        }
                                    }
                                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                    currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                                    long activeValue = activeItemsCounts.getOrDefault(temp, 0L);
                                    long waitingValue = waitingItemsCounts.getOrDefault(temp, 0L);
                                    activeItemsCounts.put(temp, activeValue += numberOfActiveItems);
                                    waitingItemsCounts.put(temp, waitingValue += numberOfWaitingItems);
                                    sprintCounts.put(temp, currentValue);
                                    countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getTeamLoad()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        result.put("intervals", sprintCounts);
        result.put("itemTeamsMap", itemTeamsMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        LOGGER.info("Final count calculated at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        return result;
    }

    public Map<String, Object> getCardTypeLoad(Map<List<IssueType>, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType, List<String> activeStatusIds, List<String> waitingStatusIds, Map<String, List<TimeSeriesLog>> finalItemsMap) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
        HashMap activeItemsCounts = new HashMap();
        HashMap waitingItemsCounts = new HashMap();
        try {
            ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
            for (String sprintId : tempallSprints) {
                allSprints.add(containers.get(sprintId).getTitle());
            }
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<IssueType>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<IssueType> teamsList = entry.getKey();
                    String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals(teamsList.get(1)) ? teamsList.get(1).getTitle() : teamsList.get(0).getTitle();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        boolean issueTypeValid;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        long numberOfActiveItems = 0L;
                        long numberOfWaitingItems = 0L;
                        boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                        if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                        for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                            Map<String, Object> currentSprintEntries = en.getValue();
                            for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                                List itemsList = (List)innerEntry.getValue();
                                for (TimeSeriesLog item : itemsList) {
                                    ArrayList attachedTeamsList = (ArrayList)item.getTeamContainers();
                                    for (Object teamContainer : attachedTeamsList) {
                                        List tempStatus;
                                        long waitingValue;
                                        long activeValue;
                                        Double currentValue;
                                        Map status;
                                        Map changes;
                                        Set itemIdsSet;
                                        HashMap<String, String> temp;
                                        if (!(teamContainer instanceof BasicDBObject)) continue;
                                        BasicDBObject obj = (BasicDBObject)teamContainer;
                                        BasicDBObject containerObj = (BasicDBObject)obj.get("container");
                                        String sprintId = (String)containerObj.get("_id");
                                        BasicDBObject itemTeam = (BasicDBObject)obj.get("team");
                                        ObjectId itemTeamId = (ObjectId)itemTeam.get("_id");
                                        if (!PropertyValidator.isValid((Object)itemTeamId) || !selectedTeam.equalsIgnoreCase(itemTeamId.toString())) continue;
                                        List attachedSprints = this.isSprintChangedAtLastDate(relevantDates, item, finalItemsMap, itemTeam.toString());
                                        if (PropertyValidator.isValid((Collection)attachedSprints)) {
                                            temp = new HashMap<String, String>();
                                            temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                            if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                            itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                            itemIdsSet.add(endingStatus.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            changes = item.getChanges();
                                            status = (Map)changes.get("status");
                                            if (PropertyValidator.isValid((Object)status) && status.containsKey("category")) {
                                                if (activeStatusIds.contains(status.get("id"))) {
                                                    numberOfActiveItems = 1L;
                                                }
                                                if (waitingStatusIds.contains(status.get("id"))) {
                                                    numberOfWaitingItems = 1L;
                                                }
                                            }
                                            currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                            currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                                            activeValue = activeItemsCounts.getOrDefault(temp, 0L);
                                            waitingValue = waitingItemsCounts.getOrDefault(temp, 0L);
                                            activeItemsCounts.put(temp, activeValue += numberOfActiveItems);
                                            waitingItemsCounts.put(temp, waitingValue += numberOfWaitingItems);
                                            sprintCounts.put(temp, currentValue);
                                            countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                            tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                            if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                            }
                                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                            continue;
                                        }
                                        if (!PropertyValidator.isValid((Object)sprintId) || !sprintId.equalsIgnoreCase(en.getKey())) continue;
                                        temp = new HashMap();
                                        temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                        if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                        itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                        itemIdsSet.add(endingStatus.getItemId());
                                        itemIdswrtInterval.put(temp, itemIdsSet);
                                        changes = item.getChanges();
                                        status = (Map)changes.get("status");
                                        if (PropertyValidator.isValid((Object)status) && status.containsKey("category")) {
                                            if (activeStatusIds.contains(status.get("id"))) {
                                                numberOfActiveItems = 1L;
                                            }
                                            if (waitingStatusIds.contains(status.get("id"))) {
                                                numberOfWaitingItems = 1L;
                                            }
                                        }
                                        currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                        currentValue = currentValue + (double)(numberOfWaitingItems + numberOfActiveItems);
                                        activeValue = activeItemsCounts.getOrDefault(temp, 0L);
                                        waitingValue = waitingItemsCounts.getOrDefault(temp, 0L);
                                        activeItemsCounts.put(temp, activeValue += numberOfActiveItems);
                                        waitingItemsCounts.put(temp, waitingValue += numberOfWaitingItems);
                                        sprintCounts.put(temp, currentValue);
                                        countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                        tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                        }
                                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeLoad()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        result.put("activeIntervals", activeItemsCounts);
        result.put("waitingIntervals", waitingItemsCounts);
        return result;
    }

    public List<String> isSprintChangedAtLastDate(Map<String, List<Date>> sprintDates, TimeSeriesLog item, Map<String, List<TimeSeriesLog>> finalItemsMap, String teamId) throws Exception {
        if (!item.getChanges().containsKey("teamContainers")) {
            return null;
        }
        ArrayList<String> oldSprints = new ArrayList<String>();
        for (List<Date> sprintIntervals : sprintDates.values()) {
            int i;
            List<TimeSeriesLog> farthestEndingStatusList;
            Date endDate = sprintIntervals.get(1);
            if (TimeSeriesUtils.stripTime((Date)item.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)endDate)) != 0 || !PropertyValidator.isValid(farthestEndingStatusList = finalItemsMap.get(item.getItemId()))) continue;
            farthestEndingStatusList.sort(Comparator.comparing(TimeSeriesLog::getEventTime).reversed());
            TimeSeriesLog latestEntry = null;
            for (i = 0; i < farthestEndingStatusList.size() && latestEntry == null; ++i) {
                TimeSeriesLog loopedEntry = farthestEndingStatusList.get(i);
                if (!item.getId().equalsIgnoreCase(loopedEntry.getId())) continue;
                latestEntry = loopedEntry;
            }
            TimeSeriesLog prevEntry = null;
            if (i == farthestEndingStatusList.size()) {
                prevEntry = latestEntry;
            } else if (i < farthestEndingStatusList.size() && TimeSeriesUtils.stripTime((Date)farthestEndingStatusList.get(i).getEventTime()).before(TimeSeriesUtils.stripTime((Date)latestEntry.getEventTime()))) {
                prevEntry = farthestEndingStatusList.get(i);
            }
            if (PropertyValidator.isValid(prevEntry) && TimeSeriesUtils.stripTime((Date)prevEntry.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)latestEntry.getEventTime())) == 0) {
                ++i;
                while (i < farthestEndingStatusList.size()) {
                    if (TimeSeriesUtils.stripTime((Date)farthestEndingStatusList.get(i).getEventTime()).before(TimeSeriesUtils.stripTime((Date)prevEntry.getEventTime()))) {
                        prevEntry = farthestEndingStatusList.get(i);
                    }
                    ++i;
                }
            }
            TimeSeriesLog nextEntry = farthestEndingStatusList.get(0);
            ArrayList teamContainerMirrors = new ArrayList();
            if (PropertyValidator.isValid((Object)nextEntry) && PropertyValidator.isValid((Collection)nextEntry.getTeamContainers())) {
                teamContainerMirrors.addAll(nextEntry.getTeamContainers());
            }
            if (PropertyValidator.isValid((Object)prevEntry) && PropertyValidator.isValid((Collection)prevEntry.getTeamContainers())) {
                teamContainerMirrors.addAll(prevEntry.getTeamContainers());
            }
            if (!PropertyValidator.isValid(teamContainerMirrors)) continue;
            for (Object teamContainer : teamContainerMirrors) {
                BasicDBObject itemTeam;
                ObjectId itemTeamId;
                Object sprintIdObj;
                BasicDBObject obj;
                BasicDBObject containerObj;
                if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container"))) || !PropertyValidator.isValid((Object)(sprintIdObj = containerObj.get("_id")))) continue;
                String attachedSprintId = "";
                if (sprintIdObj instanceof String) {
                    attachedSprintId = (String)sprintIdObj;
                } else if (sprintIdObj instanceof ObjectId) {
                    attachedSprintId = ((ObjectId)sprintIdObj).toString();
                }
                if (!teamId.equalsIgnoreCase((itemTeamId = (ObjectId)(itemTeam = (BasicDBObject)obj.get("team")).get("_id")).toString())) continue;
                oldSprints.add(attachedSprintId);
            }
        }
        return oldSprints;
    }

    public Map<String, Object> getCardTypeDist(Map<List<IssueType>, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType, Map<String, List<TimeSeriesLog>> finalItemsMap) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, Object> itemsStatusMap = new HashMap<String, Object>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
        try {
            ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
            for (String sprintId : tempallSprints) {
                allSprints.add(containers.get(sprintId).getTitle());
            }
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<IssueType>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<IssueType> teamsList = entry.getKey();
                    String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals(teamsList.get(1)) ? teamsList.get(1).getTitle() : teamsList.get(0).getTitle();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        boolean issueTypeValid;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                        if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                        for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                            Map<String, Object> currentSprintEntries = en.getValue();
                            Object latestStatusEntry = null;
                            for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                                List itemsList = (List)innerEntry.getValue();
                                for (TimeSeriesLog item : itemsList) {
                                    ArrayList attachedTeamsList = (ArrayList)item.getTeamContainers();
                                    for (Object teamContainer : attachedTeamsList) {
                                        Object tempStatus;
                                        Double d;
                                        Set itemIdsSet;
                                        Double currentValue;
                                        HashMap<String, String> temp;
                                        if (!(teamContainer instanceof BasicDBObject)) continue;
                                        BasicDBObject obj = (BasicDBObject)teamContainer;
                                        BasicDBObject containerObj = (BasicDBObject)obj.get("container");
                                        String sprintId = (String)containerObj.get("_id");
                                        BasicDBObject itemTeam = (BasicDBObject)obj.get("team");
                                        ObjectId itemTeamId = (ObjectId)itemTeam.get("_id");
                                        if (!PropertyValidator.isValid((Object)itemTeamId) || !selectedTeam.equalsIgnoreCase(itemTeamId.toString())) continue;
                                        List attachedSprints = this.isSprintChangedAtLastDate(relevantDates, item, finalItemsMap, itemTeam.toString());
                                        if (PropertyValidator.isValid((Collection)attachedSprints)) {
                                            temp = new HashMap<String, String>();
                                            temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                            if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                            currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                            itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                            itemIdsSet.add(endingStatus.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            Double d2 = currentValue;
                                            d = currentValue = Double.valueOf(currentValue + 1.0);
                                            sprintCounts.put(temp, currentValue);
                                            countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                            tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                            if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                            }
                                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                            continue;
                                        }
                                        if (!PropertyValidator.isValid((Object)sprintId) || !sprintId.equalsIgnoreCase(en.getKey())) continue;
                                        temp = new HashMap();
                                        temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                        if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                        currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                        itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                        itemIdsSet.add(endingStatus.getItemId());
                                        itemIdswrtInterval.put(temp, itemIdsSet);
                                        tempStatus = currentValue;
                                        d = currentValue = Double.valueOf(currentValue + 1.0);
                                        sprintCounts.put(temp, currentValue);
                                        countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                        tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                        }
                                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getJiraProjectDist(Map<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType, Map<String, List<TimeSeriesLog>> finalItemsMap) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, Object> itemsStatusMap = new HashMap<String, Object>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<Map, List> countedSprintItemsMap = new HashMap<Map, List>();
        try {
            ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
            for (String sprintId : tempallSprints) {
                allSprints.add(containers.get(sprintId).getTitle());
            }
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<JiraProjectIssueTypes> teamsList = entry.getKey();
                    String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals((Object)teamsList.get(1)) ? teamsList.get(1).getJiraProjectKey() : teamsList.get(0).getJiraProjectKey();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        boolean issueTypeValid;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                        if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                        for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                            Map<String, Object> currentSprintEntries = en.getValue();
                            Object latestStatusEntry = null;
                            for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                                List itemsList = (List)innerEntry.getValue();
                                for (TimeSeriesLog item : itemsList) {
                                    ArrayList attachedTeamsList = (ArrayList)item.getTeamContainers();
                                    for (Object teamContainer : attachedTeamsList) {
                                        Object tempStatus;
                                        Double d;
                                        Set itemIdsSet;
                                        Double currentValue;
                                        HashMap<String, String> temp;
                                        if (!(teamContainer instanceof BasicDBObject)) continue;
                                        BasicDBObject obj = (BasicDBObject)teamContainer;
                                        BasicDBObject containerObj = (BasicDBObject)obj.get("container");
                                        String sprintId = (String)containerObj.get("_id");
                                        BasicDBObject itemTeam = (BasicDBObject)obj.get("team");
                                        ObjectId itemTeamId = (ObjectId)itemTeam.get("_id");
                                        if (!PropertyValidator.isValid((Object)itemTeamId) || !selectedTeam.equalsIgnoreCase(itemTeamId.toString())) continue;
                                        List attachedSprints = this.isSprintChangedAtLastDate(relevantDates, item, finalItemsMap, itemTeamId.toString());
                                        if (PropertyValidator.isValid((Collection)attachedSprints)) {
                                            temp = new HashMap<String, String>();
                                            temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                            if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                            currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                            itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                            itemIdsSet.add(endingStatus.getItemId());
                                            itemIdswrtInterval.put(temp, itemIdsSet);
                                            Double d2 = currentValue;
                                            d = currentValue = Double.valueOf(currentValue + 1.0);
                                            sprintCounts.put(temp, currentValue);
                                            countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                            tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                            if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                                tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                            }
                                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                            continue;
                                        }
                                        if (!PropertyValidator.isValid((Object)sprintId) || !sprintId.equalsIgnoreCase(en.getKey())) continue;
                                        temp = new HashMap();
                                        temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                        if (!endingStatus.getId().equals(item.getId()) || PropertyValidator.isValid((Collection)((Collection)countedSprintItemsMap.get(temp))) && ((List)countedSprintItemsMap.get(temp)).contains(item.getItemId())) continue;
                                        currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                        itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                        itemIdsSet.add(endingStatus.getItemId());
                                        itemIdswrtInterval.put(temp, itemIdsSet);
                                        tempStatus = currentValue;
                                        d = currentValue = Double.valueOf(currentValue + 1.0);
                                        sprintCounts.put(temp, currentValue);
                                        countedSprintItemsMap.computeIfAbsent(temp, l -> new ArrayList()).add(item.getItemId());
                                        tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                        }
                                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getTFSProjectDist(Map<List<TFSProject>, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap itemTeamsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap itemIterationMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        try {
            ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
            for (String sprintId : tempallSprints) {
                allSprints.add(containers.get(sprintId).getTitle());
            }
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<TFSProject>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<TFSProject> teamsList = entry.getKey();
                    String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals((Object)teamsList.get(1)) ? teamsList.get(1).getName() : teamsList.get(0).getName();
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        boolean issueTypeValid;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                        if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                        for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                            Map<String, Object> currentSprintEntries = en.getValue();
                            Object latestStatusEntry = null;
                            for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                                List itemsList = (List)innerEntry.getValue();
                                for (TimeSeriesLog item : itemsList) {
                                    if (!endingStatus.getId().equals(item.getId())) continue;
                                    HashMap<String, String> temp = new HashMap<String, String>();
                                    temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                    Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                    itemIdsSet.add(endingStatus.getItemId());
                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                    Double d = currentValue;
                                    Double d2 = currentValue = Double.valueOf(currentValue + 1.0);
                                    sprintCounts.put(temp, currentValue);
                                    List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                    if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                        tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                    }
                                    itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getStringDist(Map<List<String>, List<TimeSeriesLog>> teamStatusMap, Map<String, Map<String, Object>> sprintItemsMap, List<String> allIntervals, Map<String, List<Date>> relevantDates, Map<String, Container> containers, List<String> selectedIssueType) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> allSprints = new ArrayList<String>();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeIterationMap = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap itemTeamsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap itemIterationMap = new HashMap();
        HashMap iterationItemsMap = new HashMap();
        try {
            ArrayList<String> tempallSprints = new ArrayList<String>(relevantDates.keySet());
            for (String sprintId : tempallSprints) {
                allSprints.add(containers.get(sprintId).getTitle());
            }
            if (PropertyValidator.isValid(teamStatusMap)) {
                Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                Map itemMap = this.fetchItems(itemIds);
                for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<String> teamsList = entry.getKey();
                    String selectedTeam = teamsList.size() > 1 && !teamsList.get(0).equals(teamsList.get(1)) ? teamsList.get(1) : teamsList.get(0);
                    List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                        boolean issueTypeValid;
                        String itemId = endingStatus.getItemId();
                        Item selectedItem = (Item)itemMap.get(itemId);
                        if (selectedItem == null) continue;
                        boolean bl = issueTypeValid = !selectedIssueType.isEmpty() && (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId()) || selectedItem.getTfsItemType() != null && selectedIssueType.contains(selectedItem.getTfsItemType()));
                        if (!issueTypeValid && !selectedIssueType.isEmpty()) continue;
                        for (Map.Entry<String, Map<String, Object>> en : sprintItemsMap.entrySet()) {
                            Map<String, Object> currentSprintEntries = en.getValue();
                            Object latestStatusEntry = null;
                            for (Map.Entry<String, Object> innerEntry : currentSprintEntries.entrySet()) {
                                List itemsList = (List)innerEntry.getValue();
                                for (TimeSeriesLog item : itemsList) {
                                    if (!endingStatus.getId().equals(item.getId())) continue;
                                    HashMap<String, String> temp = new HashMap<String, String>();
                                    temp.put(containers.get(en.getKey()).getTitle(), selectedTeam);
                                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                                    Set itemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                                    itemIdsSet.add(endingStatus.getItemId());
                                    itemIdswrtInterval.put(temp, itemIdsSet);
                                    Double d = currentValue;
                                    Double d2 = currentValue = Double.valueOf(currentValue + 1.0);
                                    sprintCounts.put(temp, currentValue);
                                    List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                                    if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                                        tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                                    }
                                    itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueSprintMap", issueTypeIterationMap);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getCardTypeDistribution(Map<List<IssueType>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, Map<String, String> selectedIssueTypeMap, String yAxis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap countMap = new HashMap();
        HashMap itemSprintsMap = new HashMap();
        HashMap itemTeamsMap = new HashMap();
        HashMap itemGroupByMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (!PropertyValidator.isValid(teamStatusMap)) {
                if (sprintCounts.isEmpty()) {
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories) {
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(string, "No data is available for the specified selection.");
                        sprintCounts.put(temp, 0.0);
                    }
                }
                result.put("intervals", sprintCounts);
                result.put("issueTypeMap", issueTypeMap);
                result.put("categories", allSprints);
                result.put("itemStatusMap", itemsStatusMap);
                return result;
            }
            Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map itemMap = this.fetchItems(itemIds);
            for (Map.Entry<List<IssueType>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                List<IssueType> list = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                    String selectedTeam;
                    String key;
                    long numberOfActiveItems = 0L;
                    String itemId = endingStatus.getItemId();
                    Item selectedItem = (Item)itemMap.get(itemId);
                    if (selectedItem == null) continue;
                    HashMap status = (HashMap)endingStatus.getChanges().get("status");
                    if (activeStatusIds.contains(status.get("id"))) {
                        numberOfActiveItems = 1L;
                    }
                    if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null || iterationItemsMap == null) continue;
                    if (iterationItemsMap.get(key) != null) {
                        String selectedTeam2;
                        if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId())) continue;
                        String string = selectedTeam2 = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1).getTitle() : list.get(0).getTitle();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, selectedTeam2);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        currentValue = currentValue + (double)numberOfActiveItems;
                        long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                        activeValue += numberOfActiveItems;
                        HashMap<String, String> tempIssueType = new HashMap<String, String>();
                        if (selectedItem.getJiraIssueTypeId() != null) {
                            tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                        } else if (selectedItem.getTfsItemType() != null) {
                            tempIssueType.put(key, selectedItem.getTfsItemType());
                        }
                        if (activeValue > 0L) {
                            issueTypeMap.put(tempIssueType, activeValue);
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                        }
                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam2, new ArrayList());
                        continue;
                    }
                    ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                    tempIteraionItemEntry.add(selectedItem.getId());
                    iterationItemsMap.put(key, tempIteraionItemEntry);
                    String string = selectedTeam = list.size() > 1 && !list.get(0).equals(list.get(1)) ? list.get(1).getTitle() : list.get(0).getTitle();
                    List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                    if (existingItemIds.contains(itemId)) continue;
                    existingItemIds.add(itemId);
                    itemIterationMap.put(key, existingItemIds);
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, selectedTeam);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    currentValue = currentValue + (double)numberOfActiveItems;
                    long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                    activeValue += numberOfActiveItems;
                    HashMap<String, String> tempIssueType = new HashMap<String, String>();
                    if (selectedItem.getJiraIssueTypeId() != null) {
                        tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                    } else if (selectedItem.getTfsItemType() != null) {
                        tempIssueType.put(key, selectedItem.getTfsItemType());
                    }
                    if (activeValue > 0L) {
                        issueTypeMap.put(tempIssueType, activeValue);
                    }
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(endingStatus.getItemId());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                    sprintCounts.put(temp, currentValue);
                    List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                    if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                        tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                    }
                    itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                }
            }
            if (yAxis.equals("percentage")) {
                int n = sprintCounts.values().stream().mapToInt(Double::intValue).sum();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    double value = (Double)entry.getValue() * 100.0 / (double)n;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> list = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : list) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCardTypeDistribution()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getPlannedUnPlannedDistribution(Map<List<String>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, Map<String, String> selectedIssueTypeMap, String yAxis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (PropertyValidator.isValid(teamStatusMap)) {
                for (Map.Entry<List<String>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                    List<String> list = entry.getKey();
                    List<TimeSeriesLog> farthestEndingStatus = entry.getValue();
                    for (TimeSeriesLog endingStatus : farthestEndingStatus) {
                        List existingItemIds;
                        String key;
                        long numberOfActiveItems = 0L;
                        String itemId = endingStatus.getItemId();
                        Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                        Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                        if (selectedItem == null) continue;
                        HashMap status = (HashMap)endingStatus.getChanges().get("status");
                        if (activeStatusIds.contains((String)status.get("id"))) {
                            numberOfActiveItems = 1L;
                        }
                        if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null || iterationItemsMap == null) continue;
                        if (iterationItemsMap.get(key) != null) {
                            List existingItemIds2;
                            String selectedTeam = null;
                            if (list.size() > 1) {
                                if (!list.get(0).equals(list.get(1))) {
                                    selectedTeam = list.get(1);
                                }
                            } else {
                                selectedTeam = list.get(0);
                            }
                            if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId()) && itemsStatusMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam) || (existingItemIds2 = (List)itemIterationMap.getOrDefault(key, new ArrayList())).contains(itemId) && itemsStatusMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam)) continue;
                            existingItemIds2.add(itemId);
                            itemIterationMap.put(key, existingItemIds2);
                            HashMap<String, String> temp = new HashMap<String, String>();
                            temp.put(key, selectedTeam);
                            Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                            currentValue = currentValue + (double)numberOfActiveItems;
                            long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                            activeValue += numberOfActiveItems;
                            HashMap<String, String> tempIssueType = new HashMap<String, String>();
                            if (selectedItem.getJiraIssueTypeId() != null) {
                                if (!selectedIssueTypeMap.isEmpty()) {
                                    tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                                }
                            } else if (selectedItem.getTfsItemType() != null) {
                                tempIssueType.put(key, selectedItem.getTfsItemType());
                            }
                            if (activeValue > 0L) {
                                issueTypeMap.put(tempIssueType, activeValue);
                            }
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(endingStatus.getItemId());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                            sprintCounts.put(temp, currentValue);
                            if (endingStatus.getItemId() == null) continue;
                            if (itemsStatusMap.get(endingStatus.getItemId()) != null) {
                                List existingStatuses = (List)itemsStatusMap.get(endingStatus.getItemId());
                                if (existingStatuses.contains(selectedItem.getStatus().getTitle())) continue;
                                existingStatuses.add(selectedItem.getStatus().getTitle());
                                itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, existingStatuses);
                                continue;
                            }
                            ArrayList<String> tempStatusList = new ArrayList<String>();
                            tempStatusList.add(selectedItem.getStatus().getTitle());
                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, tempStatusList);
                            continue;
                        }
                        ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                        tempIteraionItemEntry.add(selectedItem.getId());
                        iterationItemsMap.put(key, tempIteraionItemEntry);
                        String selectedTeam = null;
                        if (list.size() > 1) {
                            if (!list.get(0).equals(list.get(1))) {
                                selectedTeam = list.get(1);
                            }
                        } else {
                            selectedTeam = list.get(0);
                        }
                        if ((existingItemIds = (List)itemIterationMap.getOrDefault(key, new ArrayList())).contains(itemId)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, selectedTeam);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        currentValue = currentValue + (double)numberOfActiveItems;
                        long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                        activeValue += numberOfActiveItems;
                        HashMap<String, String> tempIssueType = new HashMap<String, String>();
                        if (selectedItem.getJiraIssueTypeId() != null) {
                            if (!selectedIssueTypeMap.isEmpty()) {
                                tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                            }
                        } else if (selectedItem.getTfsItemType() != null) {
                            tempIssueType.put(key, selectedItem.getTfsItemType());
                        }
                        if (activeValue > 0L) {
                            issueTypeMap.put(tempIssueType, activeValue);
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        if (endingStatus.getItemId() == null) continue;
                        if (itemsStatusMap.get(endingStatus.getItemId()) != null) {
                            List existingStatuses = (List)itemsStatusMap.get(endingStatus.getItemId());
                            if (existingStatuses.contains(selectedItem.getStatus().getTitle())) continue;
                            existingStatuses.add(selectedItem.getStatus().getTitle());
                            itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, existingStatuses);
                            continue;
                        }
                        ArrayList<String> tempStatusList = new ArrayList<String>();
                        tempStatusList.add(selectedItem.getStatus().getTitle());
                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, tempStatusList);
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : categories) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
            if (yAxis.equals("percentage")) {
                int totalItems = 0;
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    totalItems = (int)((double)totalItems + (Double)entry.getValue());
                }
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    double value = (Double)entry.getValue() * 100.0 / (double)totalItems;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                    sprintCounts.put(entry.getKey(), (Double)entry.getValue());
                }
                result.put("intervals", sprintCounts);
            } else {
                result.put("intervals", sprintCounts);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPlannedUnPlannedDistribution()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getjiraProjectDistribution(Map<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, Map<String, String> selectedIssueTypeMap, String yAxis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap itemTeamsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (!PropertyValidator.isValid(teamStatusMap)) {
                if (sprintCounts.isEmpty()) {
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories) {
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(string, "No data is available for the specified selection.");
                        sprintCounts.put(temp, 0.0);
                    }
                }
                result.put("intervals", sprintCounts);
                result.put("issueTypeMap", issueTypeMap);
                result.put("categories", allSprints);
                result.put("itemStatusMap", itemsStatusMap);
                return result;
            }
            Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map itemMap = this.fetchItems(itemIds);
            for (Map.Entry<List<JiraProjectIssueTypes>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                List<JiraProjectIssueTypes> list = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                    String selectedTeam;
                    String key;
                    long numberOfActiveItems = 0L;
                    String itemId = endingStatus.getItemId();
                    Item selectedItem = (Item)itemMap.get(itemId);
                    if (selectedItem == null) continue;
                    HashMap status = (HashMap)endingStatus.getChanges().get("status");
                    if (activeStatusIds.contains(status.get("id"))) {
                        numberOfActiveItems = 1L;
                    }
                    if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null || iterationItemsMap == null) continue;
                    if (iterationItemsMap.get(key) != null) {
                        List existingItemIds;
                        String selectedTeam2;
                        String string = selectedTeam2 = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getJiraProjectKey() : list.get(0).getJiraProjectKey();
                        if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId()) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam2) || (existingItemIds = (List)itemIterationMap.getOrDefault(key, new ArrayList())).contains(itemId) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam2)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, selectedTeam2);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        currentValue = currentValue + (double)numberOfActiveItems;
                        long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                        activeValue += numberOfActiveItems;
                        HashMap<String, String> tempIssueType = new HashMap<String, String>();
                        if (selectedItem.getJiraIssueTypeId() != null) {
                            tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                        } else if (selectedItem.getTfsItemType() != null) {
                            tempIssueType.put(key, selectedItem.getTfsItemType());
                        }
                        if (activeValue > 0L) {
                            issueTypeMap.put(tempIssueType, activeValue);
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                        }
                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam2, new ArrayList());
                        continue;
                    }
                    ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                    tempIteraionItemEntry.add(selectedItem.getId());
                    iterationItemsMap.put(key, tempIteraionItemEntry);
                    String string = selectedTeam = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getJiraProjectKey() : list.get(0).getJiraProjectKey();
                    List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                    if (existingItemIds.contains(itemId)) continue;
                    existingItemIds.add(itemId);
                    itemIterationMap.put(key, existingItemIds);
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, selectedTeam);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    currentValue = currentValue + (double)numberOfActiveItems;
                    long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                    activeValue += numberOfActiveItems;
                    HashMap<String, String> tempIssueType = new HashMap<String, String>();
                    if (selectedItem.getJiraIssueTypeId() != null) {
                        tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                    } else if (selectedItem.getTfsItemType() != null) {
                        tempIssueType.put(key, selectedItem.getTfsItemType());
                    }
                    if (activeValue > 0L) {
                        issueTypeMap.put(tempIssueType, activeValue);
                    }
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(endingStatus.getItemId());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                    sprintCounts.put(temp, currentValue);
                    List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                    if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                        tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                    }
                    itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, new ArrayList());
                }
            }
            if (yAxis.equals("percentage")) {
                int n = sprintCounts.values().stream().mapToInt(Double::intValue).sum();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    double value = (Double)entry.getValue() * 100.0 / (double)n;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> list = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : list) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getjiraProjectDistribution()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public Map<String, Object> getTFSProjectDistribution(Map<List<TFSProject>, List<TimeSeriesLog>> teamStatusMap, Map<String, List<Date>> relevantDates, List<String> allIntervals, String interval, List<String> activeStatusIds, Map<String, String> selectedIssueTypeMap, String yAxis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> allSprints = new ArrayList();
        HashMap sprintCounts = new HashMap();
        HashMap issueTypeMap = new HashMap();
        HashMap<String, List> itemsStatusMap = new HashMap<String, List>();
        HashMap itemTeamsMap = new HashMap();
        HashMap<String, List> itemIterationMap = new HashMap<String, List>();
        HashMap iterationItemsMap = new HashMap();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        try {
            allSprints = new ArrayList<String>(relevantDates.keySet());
            if (!PropertyValidator.isValid(teamStatusMap)) {
                if (sprintCounts.isEmpty()) {
                    List<Object> categories = allIntervals.isEmpty() ? allSprints : allIntervals;
                    for (String string : categories) {
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(string, "No data is available for the specified selection.");
                        sprintCounts.put(temp, 0.0);
                    }
                }
                result.put("intervals", sprintCounts);
                result.put("issueTypeMap", issueTypeMap);
                result.put("categories", allSprints);
                result.put("itemStatusMap", itemsStatusMap);
                return result;
            }
            Set itemIds = teamStatusMap.values().stream().flatMap(Collection::stream).map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Map itemMap = this.fetchItems(itemIds);
            for (Map.Entry<List<TFSProject>, List<TimeSeriesLog>> entry : teamStatusMap.entrySet()) {
                List<TFSProject> list = entry.getKey();
                List<TimeSeriesLog> farthestEndingStatusList = entry.getValue();
                for (TimeSeriesLog endingStatus : farthestEndingStatusList) {
                    String key;
                    long numberOfActiveItems = 0L;
                    String itemId = endingStatus.getItemId();
                    Item selectedItem = (Item)itemMap.get(itemId);
                    if (selectedItem == null) continue;
                    HashMap status = (HashMap)endingStatus.getChanges().get("status");
                    if (activeStatusIds.contains(status.get("id"))) {
                        numberOfActiveItems = 1L;
                    }
                    if ((key = this.getValueOfDataKeyFlowLoad(interval, allIntervals, endingStatus, relevantDates)) == null || iterationItemsMap == null) continue;
                    if (iterationItemsMap.get(key) != null) {
                        String selectedTeam;
                        String string = selectedTeam = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getName() : list.get(0).getName();
                        if (((List)iterationItemsMap.get(key)).contains(selectedItem.getId()) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam)) continue;
                        HashMap<String, String> temp = new HashMap<String, String>();
                        List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                        if (existingItemIds.contains(itemId) && itemTeamsMap.containsKey("itemId_" + endingStatus.getItemId() + ":" + selectedTeam)) continue;
                        existingItemIds.add(itemId);
                        itemIterationMap.put(key, existingItemIds);
                        temp.put(key, selectedTeam);
                        Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                        currentValue = currentValue + (double)numberOfActiveItems;
                        long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                        activeValue += numberOfActiveItems;
                        HashMap<String, String> tempIssueType = new HashMap<String, String>();
                        if (selectedItem.getJiraIssueTypeId() != null) {
                            tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                        } else if (selectedItem.getTfsItemType() != null) {
                            tempIssueType.put(key, selectedItem.getTfsItemType());
                        }
                        if (activeValue > 0L) {
                            issueTypeMap.put(tempIssueType, activeValue);
                        }
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(endingStatus.getItemId());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        sprintCounts.put(temp, currentValue);
                        List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                        if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                            tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                        }
                        itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                        itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, new ArrayList());
                        continue;
                    }
                    ArrayList<String> tempIteraionItemEntry = new ArrayList<String>();
                    tempIteraionItemEntry.add(selectedItem.getId());
                    iterationItemsMap.put(key, tempIteraionItemEntry);
                    String selectedTeam = list.size() > 1 && !list.get(0).equals((Object)list.get(1)) ? list.get(1).getName() : list.get(0).getName();
                    HashMap<String, String> temp = new HashMap<String, String>();
                    List existingItemIds = itemIterationMap.getOrDefault(key, new ArrayList());
                    if (existingItemIds.contains(itemId)) continue;
                    existingItemIds.add(itemId);
                    itemIterationMap.put(key, existingItemIds);
                    temp.put(key, selectedTeam);
                    Double currentValue = sprintCounts.getOrDefault(temp, 0.0);
                    currentValue = currentValue + (double)numberOfActiveItems;
                    long activeValue = issueTypeMap.getOrDefault(temp, 0L);
                    activeValue += numberOfActiveItems;
                    HashMap<String, String> tempIssueType = new HashMap<String, String>();
                    if (selectedItem.getJiraIssueTypeId() != null) {
                        tempIssueType.put(key, selectedIssueTypeMap.get(selectedItem.getJiraIssueTypeId()));
                    } else if (selectedItem.getTfsItemType() != null) {
                        tempIssueType.put(key, selectedItem.getTfsItemType());
                    }
                    if (activeValue > 0L) {
                        issueTypeMap.put(tempIssueType, activeValue);
                    }
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(endingStatus.getItemId());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                    sprintCounts.put(temp, currentValue);
                    List tempStatus = itemsStatusMap.getOrDefault(endingStatus.getItemId(), new ArrayList());
                    if (!tempStatus.contains(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory())) {
                        tempStatus.add(selectedItem.getStatus().getTitle() + "status_category:" + selectedItem.getStatus().getCategory());
                    }
                    itemsStatusMap.put("itemId_" + endingStatus.getItemId() + ":selectedTeam", tempStatus);
                    itemTeamsMap.put("itemId_" + endingStatus.getItemId() + ":" + selectedTeam, new ArrayList());
                }
            }
            if (yAxis.equals("percentage")) {
                int n = sprintCounts.values().stream().mapToInt(Double::intValue).sum();
                for (Map.Entry entry : sprintCounts.entrySet()) {
                    double value = (Double)entry.getValue() * 100.0 / (double)n;
                    entry.setValue(Double.parseDouble(this.df.format(value)));
                }
            }
            if (sprintCounts.isEmpty()) {
                List<Object> list = allIntervals.isEmpty() ? allSprints : allIntervals;
                for (String string : list) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(string, "No data is available for the specified selection.");
                    sprintCounts.put(temp, 0.0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTFSProjectDistribution()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("intervals", sprintCounts);
        result.put("issueTypeMap", issueTypeMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        if (!allIntervals.isEmpty()) {
            result.put("categories", allIntervals);
        } else {
            result.put("categories", allSprints);
        }
        result.put("itemStatusMap", itemsStatusMap);
        return result;
    }

    public double getDateDifference(Item selectedItem, TimeSeriesLog farthestEndingStatus) {
        long millisecondsDifference = 0L;
        double daysDifference = 0.0;
        try {
            if (selectedItem.getJiraFieldByKey() != null) {
                Instant instant;
                String creationDate = (String)selectedItem.getJiraFieldByKey().get("created");
                if (creationDate != null && PropertyValidator.isValid((Object)(instant = TimeSeriesUtils.parseDate((String)creationDate)))) {
                    Date creationDateFinal = Date.from(instant);
                    millisecondsDifference = TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)creationDateFinal).getTime();
                    daysDifference = (double)millisecondsDifference / 8.64E7;
                }
            } else if (selectedItem.getTfsFieldByKey() != null) {
                Instant instant;
                String creationDate = (String)selectedItem.getTfsFieldByKey().get("CreatedDate");
                if (creationDate != null && PropertyValidator.isValid((Object)(instant = TimeSeriesUtils.parseDate((String)creationDate)))) {
                    Date creationDateFinal = Date.from(instant);
                    millisecondsDifference = TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)creationDateFinal).getTime();
                    daysDifference = (double)millisecondsDifference / 8.64E7;
                }
            } else if (selectedItem.getCreatedOn() != null) {
                millisecondsDifference = TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)selectedItem.getCreatedOn()).getTime();
                daysDifference = (double)millisecondsDifference / 8.64E7;
            }
            if (daysDifference < 1.0 && daysDifference >= 0.0) {
                daysDifference = 1.0;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDateDifference()" + StringUtils.getTraceString((Throwable)e));
        }
        return daysDifference;
    }

    public double getCumulativeActiveTimeDifference(Map<String, List<TimeSeriesLog>> logsByItemId, List<TimeSeriesLog> activeStatusList, TimeSeriesLog farthestEndingStatus) {
        double cumulativeTimeDifference = 0.0;
        try {
            for (TimeSeriesLog currentActiveItem : activeStatusList) {
                if (!currentActiveItem.getItemId().equals(farthestEndingStatus.getItemId())) continue;
                Date currentEventTime = currentActiveItem.getEventTime();
                LinkedHashMap currentStatusMap = new LinkedHashMap();
                if (currentActiveItem.getChanges().get("status") == null) continue;
                currentStatusMap = (LinkedHashMap)currentActiveItem.getChanges().get("status");
                List<TimeSeriesLog> itemLogs = logsByItemId.get(currentActiveItem.getItemId());
                if (itemLogs == null) continue;
                LinkedHashMap finalCurrentStatusMap = currentStatusMap;
                Optional<TimeSeriesLog> otherEntry = itemLogs.stream().filter(log -> log.getEventTime().after(currentEventTime) && !finalCurrentStatusMap.get("id").toString().equals(((LinkedHashMap)log.getChanges().get("status")).get("id").toString())).findFirst();
                if (!otherEntry.isPresent()) continue;
                TimeSeriesLog log2 = otherEntry.get();
                long milliSecDifference = TimeSeriesUtils.stripTime((Date)log2.getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)currentActiveItem.getEventTime()).getTime();
                long activeDaysDifference = milliSecDifference / 86400000L;
                if (activeDaysDifference <= 0L && milliSecDifference >= 0L) {
                    activeDaysDifference = 1L;
                }
                cumulativeTimeDifference += (double)activeDaysDifference;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCumulativeActiveTimeDifference()", (Object)StringUtils.getTraceString((Throwable)e));
        }
        return cumulativeTimeDifference;
    }

    public List<String> getDayIntervalsofFarthestItems(Map<String, TimeSeriesLog> farthestEndingStatusMap, String interval, List<String> finalStatuses) {
        HashMap<String, Double> days = new HashMap<String, Double>();
        ArrayList<String> allIntervals = new ArrayList<String>();
        try {
            for (Map.Entry<String, TimeSeriesLog> entry : farthestEndingStatusMap.entrySet()) {
                Object instant;
                String itemId = entry.getValue().getItemId();
                Query query2 = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
                Item selectedItem = (Item)this.mongoTemplate.findOne(query2, Item.class);
                String creationDate = null;
                creationDate = selectedItem.getJiraFieldByKey() != null ? (String)selectedItem.getJiraFieldByKey().get("created") : (selectedItem.getTfsFieldByKey() != null ? (String)selectedItem.getTfsFieldByKey().get("CreatedDate") : selectedItem.getCreatedOn().toString());
                if (creationDate == null || !PropertyValidator.isValid((Object)(instant = TimeSeriesUtils.parseDate((String)creationDate)))) continue;
                Date creationDateFinal = Date.from((Instant)instant);
                long millisecondsDifference = entry.getValue().getEventTime().getTime() - creationDateFinal.getTime();
                Double daysDifference = millisecondsDifference / 86400000L;
                days.put(entry.getValue().getItemId(), daysDifference);
            }
            TreeMap intervals = new TreeMap((o1, o2) -> {
                String[] parts1 = o1.split("-");
                String[] parts2 = o2.split("-");
                int start1 = Integer.parseInt(parts1[0]);
                int start2 = Integer.parseInt(parts2[0]);
                return Integer.compare(start1, start2);
            });
            if (interval != null && Integer.parseInt(interval) > 0) {
                int intervalNumber = Integer.parseInt(interval);
                double biggestDifference = 0.0;
                double smallestDifference = 9.223372036854776E18;
                for (Map.Entry entry : days.entrySet()) {
                    if ((Double)entry.getValue() > biggestDifference) {
                        biggestDifference = (Double)entry.getValue();
                    }
                    if (!((Double)entry.getValue() < smallestDifference)) continue;
                    smallestDifference = (Double)entry.getValue();
                }
                smallestDifference = smallestDifference - (double)intervalNumber < 0.0 ? 0.0 : (smallestDifference -= (double)intervalNumber);
                if (intervalNumber > 0 && !days.isEmpty()) {
                    int i = (int)smallestDifference;
                    while ((double)i <= biggestDifference + (double)intervalNumber) {
                        allIntervals.add(String.valueOf(i) + "-" + String.valueOf(i + intervalNumber));
                        i += intervalNumber + 1;
                    }
                }
            } else {
                int intervalNumber = 5;
                double biggestDifference = 0.0;
                double smallestDifference = 9.223372036854776E18;
                for (Map.Entry entry : days.entrySet()) {
                    if ((Double)entry.getValue() > biggestDifference) {
                        biggestDifference = (Double)entry.getValue();
                    }
                    if (!((Double)entry.getValue() < smallestDifference)) continue;
                    smallestDifference = (Double)entry.getValue();
                }
                smallestDifference = smallestDifference - (double)intervalNumber < 0.0 ? 0.0 : (smallestDifference -= (double)intervalNumber);
                if (!days.isEmpty()) {
                    int i = (int)smallestDifference;
                    while ((double)i <= biggestDifference + (double)intervalNumber) {
                        allIntervals.add(String.valueOf(i) + "-" + String.valueOf(i + intervalNumber));
                        i += intervalNumber + 1;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDayIntervalsofFarthestItems()" + StringUtils.getTraceString((Throwable)e));
        }
        return allIntervals;
    }

    public List<String> getAllDates(Date startDate, Date endDate) {
        ArrayList<String> allIntervals = new ArrayList<String>();
        try {
            if (startDate != null && endDate != null) {
                Date date = startDate;
                while (!date.after(endDate)) {
                    allIntervals.add(date.toString());
                    date = DateUtils.addDays((Date)date, (int)1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllDates()" + StringUtils.getTraceString((Throwable)e));
        }
        return allIntervals;
    }

    public Map<String, List<Date>> getAllDateswrtFirstDate(Date startDate, Date endDate, Date firstEntryDate) {
        LinkedHashMap<String, List<Date>> relevantDates = new LinkedHashMap<String, List<Date>>();
        try {
            if (startDate != null && endDate != null) {
                Date today = TimeSeriesUtils.stripTime((Date)new Date());
                Date truncatedEndDate = TimeSeriesUtils.stripTime((Date)endDate);
                Date date = startDate;
                while (!TimeSeriesUtils.stripTime((Date)date).after(truncatedEndDate) && !TimeSeriesUtils.stripTime((Date)date).after(today)) {
                    relevantDates.put(date.toString(), Collections.singletonList(date));
                    date = this.addDays(date, 1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllDateswrtFirstDate()" + StringUtils.getTraceString((Throwable)e));
        }
        return relevantDates;
    }

    private Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(date);
            cal.add(5, days);
        }
        catch (Exception e) {
            LOGGER.error("Error processing addDays()" + StringUtils.getTraceString((Throwable)e));
        }
        return cal.getTime();
    }

    public List<String> getDayIntervals(List<Map<TimeSeriesLog, TimeSeriesLog>> matchingItemsMap, String interval) {
        HashMap<String, Double> days = new HashMap<String, Double>();
        ArrayList<String> allIntervals = new ArrayList<String>();
        try {
            for (Map<TimeSeriesLog, TimeSeriesLog> entry : matchingItemsMap) {
                for (Map.Entry<TimeSeriesLog, TimeSeriesLog> logEntry : entry.entrySet()) {
                    TimeSeriesLog key = logEntry.getKey();
                    TimeSeriesLog value = logEntry.getValue();
                    long millisecondsDifference = value.getEventTime().getTime() - key.getEventTime().getTime();
                    double daysDifference = (double)millisecondsDifference / 8.64E7;
                    days.put(key.getItemId(), daysDifference);
                }
            }
            TreeMap intervals = new TreeMap((o1, o2) -> {
                String[] parts1 = o1.split("-");
                String[] parts2 = o2.split("-");
                int start1 = Integer.parseInt(parts1[0]);
                int start2 = Integer.parseInt(parts2[0]);
                return Integer.compare(start1, start2);
            });
            int intervalNumber = interval != null && Integer.parseInt(interval) > 0 ? Integer.parseInt(interval) : 5;
            double biggestDifference = 0.0;
            double smallestDifference = Double.MAX_VALUE;
            for (Map.Entry entry : days.entrySet()) {
                double value = (Double)entry.getValue();
                biggestDifference = Math.max(biggestDifference, value);
                smallestDifference = Math.min(smallestDifference, value);
            }
            smallestDifference = Math.max(0.0, smallestDifference - (double)intervalNumber);
            if (!days.isEmpty()) {
                int i = (int)smallestDifference;
                while ((double)i <= biggestDifference + (double)intervalNumber) {
                    allIntervals.add(i + "-" + (i + intervalNumber));
                    i += intervalNumber + 1;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDayIntervals()" + StringUtils.getTraceString((Throwable)e));
        }
        return allIntervals;
    }

    public String getValueOfDataKey(String interval, List<String> allIntervals, TimeSeriesLog earliestStartingStatus, TimeSeriesLog farthestEndingStatus, double daysDifference, Map<String, List<Date>> relevantDates) {
        String key;
        block5: {
            key = null;
            try {
                if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                    for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                        String selectedInterval = intervalEntry.getKey();
                        List<Date> dates = intervalEntry.getValue();
                        if (TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)farthestEndingStatus.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                        key = selectedInterval;
                        break block5;
                    }
                    break block5;
                }
                for (String intervalValue : allIntervals) {
                    String[] parts = intervalValue.split("-");
                    int intervalStart = Integer.parseInt(parts[0]);
                    int intervalEnd = Integer.parseInt(parts[1]);
                    if (!(daysDifference >= (double)intervalStart) || !(daysDifference <= (double)intervalEnd)) continue;
                    key = intervalValue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getValueOfDataKey()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return key;
    }

    public String getValueOfDataKeyFlowLoad(String interval, List<String> allIntervals, TimeSeriesLog selectedItemOfTimeSeries, Map<String, List<Date>> relevantDates) {
        String key;
        block5: {
            key = null;
            try {
                if (interval.equals("sprints") || interval.equals("weekly") || interval.equals("monthly")) {
                    for (Map.Entry<String, List<Date>> intervalEntry : relevantDates.entrySet()) {
                        String selectedInterval = intervalEntry.getKey();
                        List<Date> dates = intervalEntry.getValue();
                        if (TimeSeriesUtils.stripTime((Date)selectedItemOfTimeSeries.getEventTime()).compareTo(TimeSeriesUtils.stripTime((Date)dates.get(1))) > 0 || TimeSeriesUtils.stripTime((Date)selectedItemOfTimeSeries.getEventTime()).after(TimeSeriesUtils.stripTime((Date)new Date()))) continue;
                        key = selectedInterval;
                        break block5;
                    }
                    break block5;
                }
                for (String intervalValue : allIntervals) {
                    Date selecteDate = TimeSeriesUtils.parseDateString((String)intervalValue);
                    Date selectedItemTimeSeriesDate = selectedItemOfTimeSeries.getEventTime();
                    Calendar endCalendar = Calendar.getInstance();
                    endCalendar.setTime(selectedItemOfTimeSeries.getEventTime());
                    endCalendar.set(11, 0);
                    endCalendar.set(12, 0);
                    endCalendar.set(13, 0);
                    endCalendar.set(14, 0);
                    selectedItemTimeSeriesDate = endCalendar.getTime();
                    if (!selectedItemTimeSeriesDate.equals(selecteDate)) continue;
                    key = intervalValue;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getValueOfDataKeyFlowLoad()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return key;
    }

    public static Date parseDateString(String dateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.error("Error occured in parsing in dateFormat()" + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public Map<String, Object> getIntervalForLeadTime(String interval, Map<String, Long> result) {
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        TreeMap<String, Long> intervals = null;
        try {
            intervals = new TreeMap<String, Long>((o1, o2) -> {
                String[] parts1 = o1.split("-");
                String[] parts2 = o2.split("-");
                int start1 = Integer.parseInt(parts1[0]);
                int start2 = Integer.parseInt(parts2[0]);
                return Integer.compare(start1, start2);
            });
            if (interval != null) {
                int intervalNumber = Integer.parseInt(interval);
                double biggestDifference = 0.0;
                double smallestDifference = 9.223372036854776E18;
                for (Map.Entry<String, Long> entry : result.entrySet()) {
                    if ((double)entry.getValue().longValue() > biggestDifference) {
                        biggestDifference = entry.getValue().longValue();
                    }
                    if (!((double)entry.getValue().longValue() < smallestDifference)) continue;
                    smallestDifference = entry.getValue().longValue();
                }
                smallestDifference = smallestDifference - (double)intervalNumber < 0.0 ? 0.0 : (smallestDifference -= (double)intervalNumber);
                if (intervalNumber > 0) {
                    int i = (int)smallestDifference;
                    while ((double)i <= biggestDifference + (double)intervalNumber) {
                        intervals.put(String.valueOf(i) + "-" + String.valueOf(i + intervalNumber), 0L);
                        i += intervalNumber + 1;
                    }
                    for (Map.Entry entry : intervals.entrySet()) {
                        String[] parts = ((String)entry.getKey()).split("-");
                        int intervalStart = Integer.parseInt(parts[0]);
                        int intervalEnd = Integer.parseInt(parts[1]);
                        for (Map.Entry<String, Long> newEntry : result.entrySet()) {
                            int valueToMap = newEntry.getValue().intValue();
                            if (valueToMap < intervalStart || valueToMap > intervalEnd) continue;
                            intervals.put((String)entry.getKey(), (Long)entry.getValue() + 1L);
                            HashMap temp = new HashMap();
                            temp.put(entry.getKey(), "cycletime");
                            Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                            tempItemIdsSet.add(newEntry.getKey());
                            itemIdswrtInterval.put(temp, tempItemIdsSet);
                        }
                    }
                } else if (intervalNumber <= 0) {
                    for (Map.Entry<String, Long> entry : result.entrySet()) {
                        String key = String.valueOf(entry.getValue());
                        if (intervals.containsKey(key)) {
                            intervals.put(key, (Long)intervals.get(key) + 1L);
                        } else {
                            intervals.put(key, 1L);
                        }
                        HashMap<String, String> temp = new HashMap<String, String>();
                        temp.put(key, "cycletime");
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(entry.getKey());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                    }
                }
            } else {
                for (Map.Entry<String, Long> days : result.entrySet()) {
                    String key = String.valueOf(days.getValue());
                    if (intervals.containsKey(key)) {
                        intervals.put(key, (Long)intervals.get(key) + 1L);
                    } else {
                        intervals.put(key, 1L);
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(key, "cycletime");
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(days.getKey());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getIntervalForLeadTime()" + StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> responseObject = new HashMap<String, Object>();
        responseObject.put("intervals", intervals);
        responseObject.put("itemIdsMap", itemIdswrtInterval);
        return responseObject;
    }

    public static Map<String, List<String>> handleTimeZone(Map<String, List<Date>> relevantDates) {
        LinkedHashMap<String, List<String>> stringDates = new LinkedHashMap<String, List<String>>();
        try {
            for (Map.Entry<String, List<Date>> entry : relevantDates.entrySet()) {
                List<Date> value = entry.getValue();
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(value.get(0).toString());
                tempList.add(value.get(1).toString());
                stringDates.put(entry.getKey(), tempList);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing handleTimeZone()" + StringUtils.getTraceString((Throwable)e));
        }
        return stringDates;
    }

    public List<TimeSeriesLog> retrieveAndCheckTeamContainerForUnPlanned(List<TimeSeriesLog> queriedTimeSeriesItems, String tenant) {
        List<Object> filteredTimeSeriesItems = new ArrayList<TimeSeriesLog>();
        try {
            Set itemIds = queriedTimeSeriesItems.stream().map(TimeSeriesLog::getItemId).map(ObjectId::new).collect(Collectors.toSet());
            BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", itemIds)));
            BasicDBObject addFieldsStage1 = new BasicDBObject("$addFields", (Object)new BasicDBObject("teamContainers", (Object)new BasicDBObject("$ifNull", Arrays.asList("$teamContainers", new BasicDBList()))));
            BasicDBObject addFieldsStage2 = new BasicDBObject("$addFields", (Object)new BasicDBObject("teamContainersSize", (Object)new BasicDBObject("$size", (Object)"$teamContainers")));
            BasicDBObject matchEmptyTeamContainersStage = new BasicDBObject("$match", (Object)new BasicDBObject("teamContainersSize", (Object)0));
            List<DBObject> pipeline = Arrays.asList(matchStage, addFieldsStage1, addFieldsStage2, matchEmptyTeamContainersStage);
            DBCollection collection = this.mongoTemplate.getCollection("item");
            AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
            Cursor cursor = collection.aggregate(pipeline, options);
            ArrayList<ObjectId> itemIdsWithEmptyTeamContainer = new ArrayList<ObjectId>();
            while (cursor.hasNext()) {
                DBObject o = (DBObject)cursor.next();
                itemIdsWithEmptyTeamContainer.add((ObjectId)o.get("_id"));
            }
            Set itemIdsWithEmptyTeamContainerSet = itemIdsWithEmptyTeamContainer.stream().map(ObjectId::toHexString).collect(Collectors.toSet());
            filteredTimeSeriesItems = queriedTimeSeriesItems.stream().filter(timeSeriesLog -> itemIdsWithEmptyTeamContainerSet.contains(timeSeriesLog.getItemId())).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Error processing retrieveAndCheckTeamContainerForUnPlanned()" + StringUtils.getTraceString((Throwable)e));
        }
        return filteredTimeSeriesItems;
    }

    public List<TimeSeriesLog> retrieveAndCheckTeamContainerForPlanned(List<TimeSeriesLog> queriedTimeSeriesItems, String tenant) {
        List<Object> filteredTimeSeriesItems = new ArrayList<TimeSeriesLog>();
        try {
            Set itemIds = queriedTimeSeriesItems.stream().map(TimeSeriesLog::getItemId).map(ObjectId::new).collect(Collectors.toSet());
            BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", itemIds)));
            BasicDBObject addFieldsStage1 = new BasicDBObject("$addFields", (Object)new BasicDBObject("teamContainers", (Object)new BasicDBObject("$ifNull", Arrays.asList("$teamContainers", new BasicDBList()))));
            BasicDBObject addFieldsStage2 = new BasicDBObject("$addFields", (Object)new BasicDBObject("teamContainersSize", (Object)new BasicDBObject("$size", (Object)"$teamContainers")));
            BasicDBObject matchNonEmptyTeamContainersStage = new BasicDBObject("$match", (Object)new BasicDBObject("teamContainersSize", (Object)new BasicDBObject("$gt", (Object)0)));
            List<DBObject> pipeline = Arrays.asList(matchStage, addFieldsStage1, addFieldsStage2, matchNonEmptyTeamContainersStage);
            DBCollection collection = this.mongoTemplate.getCollection("item");
            AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
            Cursor cursor = collection.aggregate(pipeline, options);
            ArrayList<ObjectId> itemIdsWithNonEmptyTeamContainer = new ArrayList<ObjectId>();
            while (cursor.hasNext()) {
                DBObject o = (DBObject)cursor.next();
                itemIdsWithNonEmptyTeamContainer.add((ObjectId)o.get("_id"));
            }
            Set itemIdsWithNonEmptyTeamContainerSet = itemIdsWithNonEmptyTeamContainer.stream().map(ObjectId::toHexString).collect(Collectors.toSet());
            filteredTimeSeriesItems = queriedTimeSeriesItems.stream().filter(timeSeriesLog -> itemIdsWithNonEmptyTeamContainerSet.contains(timeSeriesLog.getItemId())).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Error processing retrieveAndCheckTeamContainerForPlanned()" + StringUtils.getTraceString((Throwable)e));
        }
        return filteredTimeSeriesItems;
    }

    public void checkItemExistanceInCollection(List<TimeSeriesLog> queriedTimeSeriesItems) {
        List itemIdsToCheck = queriedTimeSeriesItems.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toList());
        Query itemQueryy = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsToCheck).and("archive").in(new Object[]{false}));
        itemQueryy.fields().include("id");
        List existingItems = this.mongoTemplate.find(itemQueryy, Item.class, "item");
        List existingItemIds = existingItems.stream().map(BaseEntity::getId).collect(Collectors.toList());
        queriedTimeSeriesItems.removeIf(timeSeriesLog -> !existingItemIds.contains(timeSeriesLog.getItemId()));
    }

    public void populateStatusMapForSprintWeekMonth(String advanceCriteria, Set<String> allStatusTitles, Map<String, String> allGroupBysMap, Map<String, String> allIssueTypesMap, List<Date> dates, Map<String, Map<String, Set<String>>> intervalStatusItemMap, List<String> individualSelectedStatusIds, Map<String, String> issueTypeMap, List<String> selectedAdvanceCriteria, List<String> selectedIssueType, SessionBoard sessionBoard, Sort sort, Map<String, List<Date>> relevantDates, String key, String previousKey, String radioButtonSelection, String tenant, String boardItemsFilter, Map<String, String> itemTags, Set<String> itemIds) {
        block15: {
            ConcurrentHashMap statusTitleToItemIdMap = new ConcurrentHashMap();
            Set<Object> tempItemIds = new HashSet();
            ArrayList<String> searchedItemIds = new ArrayList<String>();
            try {
                if (PropertyValidator.isValid(itemTags)) {
                    searchedItemIds.addAll(itemTags.keySet());
                }
                if (dates.size() <= 1) break block15;
                Date sDate = !PropertyValidator.isValid((Object)previousKey) ? TimeSeriesUtils.stripTime((Date)sessionBoard.getCreationDate()) : TimeSeriesUtils.stripTime((Date)dates.get(0));
                Date eDate = this.getEndOfDay(dates.get(1));
                List<TimeSeriesLog> queriedTimeSeriesItems = new ArrayList();
                BasicDBObject filter = new BasicDBObject();
                filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                filter.put((Object)"changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
                filter.put((Object)"meta.tenant", (Object)tenant);
                filter.put((Object)"meta.sessionBoardId", (Object)sessionBoard.getId());
                try {
                    DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                    DBCursor querys = collection.find((DBObject)filter);
                    while (querys.hasNext()) {
                        TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                        DBObject dbObject = querys.next();
                        timeSeriesLog.setId(dbObject.get("_id").toString());
                        timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                        timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                        timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                        timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                        timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                        timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                        queriedTimeSeriesItems.add(timeSeriesLog);
                    }
                    this.checkItemExistanceInCollection(queriedTimeSeriesItems);
                }
                catch (Exception e) {
                    LOGGER.error("Error querying time series data", (Object)StringUtils.getTraceString((Throwable)e));
                }
                try {
                    if (boardItemsFilter.equals("unplanned-items")) {
                        queriedTimeSeriesItems = this.retrieveAndCheckTeamContainerForUnPlanned(queriedTimeSeriesItems, tenant);
                    } else if (boardItemsFilter.equals("planned-items")) {
                        queriedTimeSeriesItems = this.retrieveAndCheckTeamContainerForPlanned(queriedTimeSeriesItems, tenant);
                    }
                    queriedTimeSeriesItems = this.filterSearchedItems(queriedTimeSeriesItems, searchedItemIds);
                    Set statusIds = queriedTimeSeriesItems.stream().map(log -> (String)((Map)log.getChanges().get("status")).get("id")).collect(Collectors.toSet());
                    Map statusMap = this.fetchStatuses(statusIds);
                    tempItemIds = queriedTimeSeriesItems.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                    if (PropertyValidator.isValid(tempItemIds)) {
                        itemIds.addAll(tempItemIds);
                    }
                    ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    Set<String> finalItemIds = itemIds;
                    Future<Map> itemMapFuture = executorService.submit(() -> this.fetchItems(finalItemIds));
                    Map itemMap = new ConcurrentHashMap();
                    try {
                        itemMap = itemMapFuture.get();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error fetching items", (Object)StringUtils.getTraceString((Throwable)e));
                    }
                    this.processTimeSeriesLogs(queriedTimeSeriesItems, statusMap, itemMap, statusTitleToItemIdMap, radioButtonSelection, selectedIssueType, issueTypeMap, allIssueTypesMap, advanceCriteria, selectedAdvanceCriteria, allGroupBysMap, itemIds);
                    if (previousKey != null && intervalStatusItemMap.containsKey(previousKey)) {
                        this.copyUnchangedItemsFromPreviousIteration(intervalStatusItemMap.get(previousKey), statusTitleToItemIdMap);
                    }
                    this.ensureAllStatusTitlesRepresented(allStatusTitles, statusTitleToItemIdMap);
                    this.removeArchivedItems(relevantDates.get(key), statusTitleToItemIdMap, "group-intervals");
                    intervalStatusItemMap.put(key, statusTitleToItemIdMap);
                    executorService.shutdown();
                }
                catch (Exception e) {
                    LOGGER.error("Error processing queried time series items", (Object)StringUtils.getTraceString((Throwable)e));
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in populateStatusMapForSprintWeekMonth", (Object)StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    private Date getEndOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    private Map<String, Status> fetchStatuses(Set<String> statusIds) {
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(statusIds));
            query.fields().include("title").include("category");
            List statuses = this.mongoTemplate.find(query, Status.class);
            return statuses.stream().collect(Collectors.toMap(BaseEntity::getId, status -> status));
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchStatuses()" + StringUtils.getTraceString((Throwable)e));
            return new HashMap<String, Status>();
        }
    }

    private Map<String, Item> fetchItems(Set<String> itemIds) {
        List validItemIds = itemIds.stream().filter(PropertyValidator::isValid).map(ObjectId::new).collect(Collectors.toList());
        BasicDBObject filter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", validItemIds));
        DBCollection collection = this.mongoTemplate.getCollection("item");
        DBCursor dbCursor = collection.find((DBObject)filter);
        ArrayList<Item> itemList = new ArrayList<Item>();
        HashMap itemTeamContainerMap = new HashMap();
        HashMap<String, ObjectId> itemStatusMap = new HashMap<String, ObjectId>();
        HashMap<String, ObjectId> itemIssueTypeMap = new HashMap<String, ObjectId>();
        while (dbCursor.hasNext()) {
            DBRef issueTypeRef;
            DBObject dbObject = dbCursor.next();
            Item item = new Item();
            item.setId(dbObject.get("_id").toString());
            item.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
            item.setTfsItemType((String)dbObject.get("tfsItemType"));
            item.setJiraProjectKey((String)dbObject.get("jiraProjectKey"));
            item.setType((String)dbObject.get("type"));
            item.setTfsProjectId((String)dbObject.get("tfsProjectId"));
            item.setTfsAreaPath((String)dbObject.get("tfsAreaPath"));
            item.setJiraFieldByKey((Map)dbObject.get("jiraFieldByKey"));
            item.setTfsFieldByKey((Map)dbObject.get("tfsFieldByKey"));
            item.setCreatedOn((Date)dbObject.get("createdOn"));
            DBRef statusRef = (DBRef)dbObject.get("status");
            if (statusRef != null && statusRef.getId() instanceof ObjectId) {
                itemStatusMap.put(item.getId(), (ObjectId)statusRef.getId());
            }
            if ((issueTypeRef = (DBRef)dbObject.get("issueType")) != null) {
                itemIssueTypeMap.put(item.getId(), (ObjectId)issueTypeRef.getId());
            }
            List teamContainersRef = (List)dbObject.get("teamContainers");
            ArrayList<ObjectId> teamContainerIds = new ArrayList<ObjectId>();
            if (PropertyValidator.isValid((Collection)teamContainersRef)) {
                for (DBRef dbRef : teamContainersRef) {
                    teamContainerIds.add((ObjectId)dbRef.getId());
                }
                itemTeamContainerMap.put(item.getId(), teamContainerIds);
            }
            itemList.add(item);
        }
        List allTeamContainerIds = itemTeamContainerMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        ConcurrentHashMap teamContainerMap = new ConcurrentHashMap();
        ConcurrentHashMap.KeySetView allTeamIds = ConcurrentHashMap.newKeySet();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Callable<Void> fetchTeamContainersTask = () -> {
            BasicDBObject teamContainerFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)allTeamContainerIds));
            DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
            DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)teamContainerFilter);
            while (teamContainerCursor.hasNext()) {
                DBObject dbObject = teamContainerCursor.next();
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(dbObject.get("_id").toString());
                DBRef teamRef = (DBRef)dbObject.get("team");
                if (teamRef != null) {
                    ObjectId teamId = (ObjectId)teamRef.getId();
                    allTeamIds.add(teamId);
                    teamContainer.setTeam(new Team());
                    teamContainer.getTeam().setId(teamId.toString());
                }
                teamContainerMap.put(new ObjectId(teamContainer.getId()), teamContainer);
            }
            return null;
        };
        Future<Void> teamContainerFuture = executorService.submit(fetchTeamContainersTask);
        try {
            teamContainerFuture.get();
        }
        catch (Exception e) {
            LOGGER.error("Error processing team containers in fetchItems()" + StringUtils.getTraceString((Throwable)e));
        }
        ConcurrentHashMap teamMap = new ConcurrentHashMap();
        if (!allTeamIds.isEmpty()) {
            Iterator fetchTeamsTask = () -> {
                BasicDBObject teamFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", new ArrayList(allTeamIds)));
                DBCollection teamCollection = this.mongoTemplate.getCollection("team");
                DBCursor teamCursor = teamCollection.find((DBObject)teamFilter);
                while (teamCursor.hasNext()) {
                    DBObject dbObject = teamCursor.next();
                    Team team = new Team();
                    team.setId(dbObject.get("_id").toString());
                    team.setTitle(dbObject.get("title").toString());
                    teamMap.put(new ObjectId(team.getId()), team);
                }
                return null;
            };
            Future teamFuture = executorService.submit(fetchTeamsTask);
            try {
                teamFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing teams in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        for (TeamContainer teamContainer : teamContainerMap.values()) {
            Team team = teamContainer.getTeam();
            if (team == null) continue;
            ObjectId teamId = new ObjectId(team.getId());
            teamContainer.setTeam((Team)teamMap.get(teamId));
        }
        for (Item item : itemList) {
            List teamContainerIds = (List)itemTeamContainerMap.get(item.getId());
            if (teamContainerIds == null) continue;
            List teamContainers = teamContainerIds.stream().map(teamContainerMap::get).collect(Collectors.toList());
            item.setTeamContainers(teamContainers);
        }
        if (!itemStatusMap.isEmpty()) {
            Callable<Void> fetchStatusesTask = () -> {
                BasicDBObject statusFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", new ArrayList(itemStatusMap.values())));
                DBCollection statusCollection = this.mongoTemplate.getCollection("status");
                DBCursor statusCursor = statusCollection.find((DBObject)statusFilter);
                HashMap<ObjectId, Status> statusMap = new HashMap<ObjectId, Status>();
                while (statusCursor.hasNext()) {
                    DBObject dbObject = statusCursor.next();
                    Status status = new Status();
                    status.setId(dbObject.get("_id").toString());
                    status.setTitle((String)dbObject.get("title"));
                    status.setCategory((String)dbObject.get("category"));
                    statusMap.put(new ObjectId(status.getId()), status);
                }
                for (Item item : itemList) {
                    ObjectId statusId = (ObjectId)itemStatusMap.get(item.getId());
                    if (statusId == null) continue;
                    item.setStatus((Status)statusMap.get(statusId));
                }
                return null;
            };
            Future<Void> statusFuture = executorService.submit(fetchStatusesTask);
            try {
                statusFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing status in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        if (!itemIssueTypeMap.isEmpty()) {
            Callable<Void> fetchIssueTypesTask = () -> {
                BasicDBObject issueTypeFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", new ArrayList(itemIssueTypeMap.values())));
                DBCollection issueTypeCollection = this.mongoTemplate.getCollection("issueType");
                DBCursor issueTypeCursor = issueTypeCollection.find((DBObject)issueTypeFilter);
                HashMap<ObjectId, IssueType> issueTypeMap = new HashMap<ObjectId, IssueType>();
                while (issueTypeCursor.hasNext()) {
                    DBObject dbObject = issueTypeCursor.next();
                    IssueType issueType = new IssueType();
                    issueType.setId(dbObject.get("_id").toString());
                    issueType.setTitle((String)dbObject.get("title"));
                    issueType.setColor((String)dbObject.get("color"));
                    issueType.setTextColor((String)dbObject.get("textColor"));
                    issueTypeMap.put(new ObjectId(issueType.getId()), issueType);
                }
                for (Item item : itemList) {
                    ObjectId issueTypeId = (ObjectId)itemIssueTypeMap.get(item.getId());
                    if (issueTypeId == null) continue;
                    item.setIssueType((IssueType)issueTypeMap.get(issueTypeId));
                }
                return null;
            };
            Future<Void> issueTypeFuture = executorService.submit(fetchIssueTypesTask);
            try {
                issueTypeFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing issueType in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        executorService.shutdown();
        return itemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
    }

    private Map<String, Item> fetchAllItems(Set<String> itemIds) throws Exception {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Going to fetch all items at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        List validItemIds = itemIds.stream().filter(PropertyValidator::isValid).map(ObjectId::new).collect(Collectors.toList());
        BasicDBObject filter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", validItemIds));
        DBCollection collection = this.mongoTemplate.getCollection("item");
        DBCursor dbCursor = collection.find((DBObject)filter);
        ArrayList<Item> itemList = new ArrayList<Item>();
        HashMap itemTeamContainerMap = new HashMap();
        HashMap<String, String> itemStatusMap = new HashMap<String, String>();
        HashMap<String, ObjectId> itemIssueTypeMap = new HashMap<String, ObjectId>();
        while (dbCursor.hasNext()) {
            DBRef issueTypeRef;
            DBObject dbObject = dbCursor.next();
            Item item = new Item();
            item.setId(dbObject.get("_id").toString());
            item.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
            item.setTfsItemType((String)dbObject.get("tfsItemType"));
            item.setJiraProjectKey((String)dbObject.get("jiraProjectKey"));
            item.setType((String)dbObject.get("type"));
            item.setTfsProjectId((String)dbObject.get("tfsProjectId"));
            item.setTfsAreaPath((String)dbObject.get("tfsAreaPath"));
            item.setJiraFieldByKey((Map)dbObject.get("jiraFieldByKey"));
            item.setTfsFieldByKey((Map)dbObject.get("tfsFieldByKey"));
            item.setCreatedOn((Date)dbObject.get("createdOn"));
            DBRef statusRef = (DBRef)dbObject.get("status");
            if (statusRef != null) {
                if (statusRef.getId() instanceof ObjectId) {
                    ObjectId statusId = (ObjectId)statusRef.getId();
                    itemStatusMap.put(item.getId(), statusId.toString());
                } else if (statusRef.getId() instanceof String) {
                    itemStatusMap.put(item.getId(), (String)statusRef.getId());
                }
            }
            if ((issueTypeRef = (DBRef)dbObject.get("issueType")) != null) {
                itemIssueTypeMap.put(item.getId(), (ObjectId)issueTypeRef.getId());
            }
            List teamContainersRef = (List)dbObject.get("teamContainers");
            ArrayList<ObjectId> teamContainerIds = new ArrayList<ObjectId>();
            if (PropertyValidator.isValid((Collection)teamContainersRef)) {
                for (DBRef dbRef : teamContainersRef) {
                    teamContainerIds.add((ObjectId)dbRef.getId());
                }
                itemTeamContainerMap.put(item.getId(), teamContainerIds);
            }
            itemList.add(item);
        }
        List allTeamContainerIds = itemTeamContainerMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        ConcurrentHashMap teamContainerMap = new ConcurrentHashMap();
        ConcurrentHashMap.KeySetView allTeamIds = ConcurrentHashMap.newKeySet();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Callable<Void> fetchTeamContainersTask = () -> {
            BasicDBObject teamContainerFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)allTeamContainerIds));
            DBCollection teamContainerCollection = this.mongoTemplate.getCollection("teamContainer");
            DBCursor teamContainerCursor = teamContainerCollection.find((DBObject)teamContainerFilter);
            while (teamContainerCursor.hasNext()) {
                DBObject dbObject = teamContainerCursor.next();
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(dbObject.get("_id").toString());
                DBRef teamRef = (DBRef)dbObject.get("team");
                if (teamRef != null) {
                    ObjectId teamId = (ObjectId)teamRef.getId();
                    allTeamIds.add(teamId);
                    teamContainer.setTeam(new Team());
                    teamContainer.getTeam().setId(teamId.toString());
                }
                teamContainerMap.put(new ObjectId(teamContainer.getId()), teamContainer);
            }
            return null;
        };
        Future<Void> teamContainerFuture = executorService.submit(fetchTeamContainersTask);
        try {
            teamContainerFuture.get();
        }
        catch (Exception e) {
            LOGGER.error("Error processing team containers in fetchItems()" + StringUtils.getTraceString((Throwable)e));
        }
        ConcurrentHashMap teamMap = new ConcurrentHashMap();
        if (!allTeamIds.isEmpty()) {
            Iterator fetchTeamsTask = () -> {
                BasicDBObject teamFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", new ArrayList(allTeamIds)));
                DBCollection teamCollection = this.mongoTemplate.getCollection("team");
                DBCursor teamCursor = teamCollection.find((DBObject)teamFilter);
                while (teamCursor.hasNext()) {
                    DBObject dbObject = teamCursor.next();
                    Team team = new Team();
                    team.setId(dbObject.get("_id").toString());
                    team.setTitle(dbObject.get("title").toString());
                    teamMap.put(new ObjectId(team.getId()), team);
                }
                return null;
            };
            Future teamFuture = executorService.submit(fetchTeamsTask);
            try {
                teamFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing teams in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        for (TeamContainer teamContainer : teamContainerMap.values()) {
            Team team = teamContainer.getTeam();
            if (team == null) continue;
            ObjectId teamId = new ObjectId(team.getId());
            teamContainer.setTeam((Team)teamMap.get(teamId));
        }
        for (Item item : itemList) {
            List teamContainerIds = (List)itemTeamContainerMap.get(item.getId());
            if (teamContainerIds == null) continue;
            List teamContainers = teamContainerIds.stream().map(teamContainerMap::get).collect(Collectors.toList());
            item.setTeamContainers(teamContainers);
        }
        if (!itemStatusMap.isEmpty()) {
            Callable<Void> fetchStatusesTask = () -> {
                List statuses = this.statusRepository.findProjectedByIdIn(new ArrayList(itemStatusMap.values()));
                HashMap<String, Status> statusMap = new HashMap<String, Status>();
                for (Status status : statuses) {
                    statusMap.put(status.getId(), status);
                }
                for (Item item : itemList) {
                    String statusId = (String)itemStatusMap.get(item.getId());
                    if (statusId == null) continue;
                    item.setStatus((Status)statusMap.get(statusId));
                }
                return null;
            };
            Future<Void> statusFuture = executorService.submit(fetchStatusesTask);
            try {
                statusFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing status in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        if (!itemIssueTypeMap.isEmpty()) {
            Callable<Void> fetchIssueTypesTask = () -> {
                BasicDBObject issueTypeFilter = new BasicDBObject("_id", (Object)new BasicDBObject("$in", new ArrayList(itemIssueTypeMap.values())));
                DBCollection issueTypeCollection = this.mongoTemplate.getCollection("issueType");
                DBCursor issueTypeCursor = issueTypeCollection.find((DBObject)issueTypeFilter);
                HashMap<ObjectId, IssueType> issueTypeMap = new HashMap<ObjectId, IssueType>();
                while (issueTypeCursor.hasNext()) {
                    DBObject dbObject = issueTypeCursor.next();
                    IssueType issueType = new IssueType();
                    issueType.setId(dbObject.get("_id").toString());
                    issueType.setTitle((String)dbObject.get("title"));
                    issueType.setColor((String)dbObject.get("color"));
                    issueType.setTextColor((String)dbObject.get("textColor"));
                    issueTypeMap.put(new ObjectId(issueType.getId()), issueType);
                }
                for (Item item : itemList) {
                    ObjectId issueTypeId = (ObjectId)itemIssueTypeMap.get(item.getId());
                    if (issueTypeId == null) continue;
                    item.setIssueType((IssueType)issueTypeMap.get(issueTypeId));
                }
                return null;
            };
            Future<Void> issueTypeFuture = executorService.submit(fetchIssueTypesTask);
            try {
                issueTypeFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("Error processing issueType in fetchItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        executorService.shutdown();
        LOGGER.info("fetchAllItems execution lasted: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
        return itemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
    }

    private void processTimeSeriesLogs(List<TimeSeriesLog> logs, Map<String, Status> statusMap, Map<String, Item> itemMap, Map<String, Set<String>> statusTitleToItemIdMap, String radioButtonSelection, List<String> selectedIssueType, Map<String, String> issueTypeMap, Map<String, String> allIssueTypesMap, String advanceCriteria, List<String> selectedAdvanceCriteria, Map<String, String> allGroupBysMap, Set<String> itemIds) {
        try {
            HashMap<String, TimeSeriesLog> latestStatusChangeMap = new HashMap<String, TimeSeriesLog>();
            for (TimeSeriesLog log : logs) {
                String itemId = log.getItemId();
                if (latestStatusChangeMap.containsKey(itemId) && !log.getEventTime().after(((TimeSeriesLog)latestStatusChangeMap.get(itemId)).getEventTime())) continue;
                latestStatusChangeMap.put(itemId, log);
            }
            for (TimeSeriesLog log : latestStatusChangeMap.values()) {
                Map statusChange = (Map)log.getChanges().get("status");
                String statusId = (String)statusChange.get("id");
                Status status = statusMap.get(statusId);
                String statusTitle = radioButtonSelection.equals("status") ? status.getTitle() : status.getCategory();
                statusTitleToItemIdMap.computeIfAbsent(statusTitle, k -> new HashSet()).add(log.getItemId());
                Item item = itemMap.get(log.getItemId());
                if (item == null) continue;
                itemIds.add(item.getId());
                if (!selectedIssueType.isEmpty() && !this.isValidIssueType(item, selectedIssueType, issueTypeMap, allIssueTypesMap)) {
                    statusTitleToItemIdMap.get(statusTitle).remove(log.getItemId());
                    continue;
                }
                if (!"teams".equals(advanceCriteria) || this.isValidTeam(item, selectedAdvanceCriteria, allGroupBysMap)) continue;
                statusTitleToItemIdMap.get(statusTitle).remove(log.getItemId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing processTimeSeriesLogs()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private boolean isValidIssueType(Item item, List<String> selectedIssueType, Map<String, String> issueTypeMap, Map<String, String> allIssueTypesMap) {
        try {
            if (item.getJiraIssueTypeId() != null && selectedIssueType.contains(item.getJiraIssueTypeId())) {
                allIssueTypesMap.put(item.getJiraIssueTypeId(), issueTypeMap.get(item.getJiraIssueTypeId()));
                return true;
            }
            if (item.getTfsItemType() != null && selectedIssueType.contains(item.getTfsItemType())) {
                allIssueTypesMap.put(item.getTfsItemType(), item.getTfsItemType());
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing isValidIssueType()" + StringUtils.getTraceString((Throwable)e));
        }
        return false;
    }

    private boolean isValidTeam(Item item, List<String> selectedAdvanceCriteria, Map<String, String> allGroupBysMap) {
        try {
            List teamContainers = item.getTeamContainers();
            if (teamContainers != null && !teamContainers.isEmpty()) {
                for (TeamContainer teamContainer : teamContainers) {
                    String teamId;
                    if (teamContainer == null || teamContainer.getTeam() == null || !selectedAdvanceCriteria.contains(teamId = teamContainer.getTeam().getId())) continue;
                    allGroupBysMap.put(teamId, teamContainer.getTeam().getTitle());
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing isValidTeam()" + StringUtils.getTraceString((Throwable)e));
        }
        return false;
    }

    private void copyUnchangedItemsFromPreviousIteration(Map<String, Set<String>> previousMap, Map<String, Set<String>> currentMap) {
        try {
            for (Map.Entry<String, Set<String>> entry : previousMap.entrySet()) {
                String status = entry.getKey();
                Set<String> previousItemIds = entry.getValue();
                for (String itemId : previousItemIds) {
                    if (!currentMap.values().stream().noneMatch(set -> set.contains(itemId))) continue;
                    currentMap.computeIfAbsent(status, k -> new HashSet()).add(itemId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing copyUnchangedItemsFromPreviousIteration()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void ensureAllStatusTitlesRepresented(Set<String> allStatusTitles, Map<String, Set<String>> statusTitleToItemIdMap) {
        try {
            if (allStatusTitles != null) {
                for (String status : allStatusTitles) {
                    statusTitleToItemIdMap.putIfAbsent(status, new HashSet());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing ensureAllStatusTitlesRepresented()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void removeArchivedItems(List<Date> dateList, Map<String, Set<String>> statusTitleToItemIdMap, String interval) {
        boolean dateValidity = false;
        try {
            if (interval.equals("days")) {
                if (dateList != null && dateList.size() >= 1) {
                    dateValidity = true;
                }
            } else if (interval.equals("group-intervals") && dateList != null && dateList.size() >= 2) {
                dateValidity = true;
            }
            if (dateValidity) {
                Date startingDate = TimeSeriesUtils.stripTime((Date)dateList.get(0));
                Date endingDate = new Date();
                endingDate = interval.equals("days") ? this.getEndOfDay(dateList.get(0)) : this.getEndOfDay(dateList.get(1));
                Set allItemIds = statusTitleToItemIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                Query queryToCheckRemoval = new Query((CriteriaDefinition)Criteria.where((String)"itemId").in(allItemIds).and("changes.archive").is((Object)true).and("eventTime").gte((Object)startingDate).lt((Object)endingDate));
                List archivedItems = this.mongoTemplate.find(queryToCheckRemoval, TimeSeriesLog.class, "itemTimeSeries");
                Set archivedItemIds = archivedItems.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                statusTitleToItemIdMap.values().forEach(itemIdsSet -> itemIdsSet.removeAll(archivedItemIds));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing removeArchivedItems()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public void populateStatusMapForDays(String advanceCriteria, Set<String> allStatusTitles, Map<String, String> allGroupBysMap, Map<String, String> allIssueTypesMap, List<Date> dates, Map<String, Map<String, Set<String>>> intervalStatusItemMap, List<String> individualSelectedStatusIds, Map<String, String> issueTypeMap, List<String> selectedAdvanceCriteria, List<String> selectedIssueType, SessionBoard sessionBoard, Sort sort, Map<String, List<Date>> relevantDates, String key, String previousKey, String radioButtonSelection, String tenant, String boardItemsFilter, Map<String, String> itemTags, Set<String> itemIds) {
        block19: {
            HashMap statusTitleToItemIdMap = new HashMap();
            ArrayList<String> searchedItemIds = new ArrayList<String>();
            try {
                if (PropertyValidator.isValid(itemTags)) {
                    searchedItemIds.addAll(itemTags.keySet());
                }
                if (dates.isEmpty()) break block19;
                Date date = dates.get(0);
                Date sDate = !PropertyValidator.isValid((Object)previousKey) ? TimeSeriesUtils.stripTime((Date)sessionBoard.getCreationDate()) : TimeSeriesUtils.stripTime((Date)dates.get(0));
                Date eDate = this.getEndOfDay(date);
                if (sessionBoard == null) break block19;
                List<TimeSeriesLog> queriedTimeSeriesItems = new ArrayList();
                try {
                    BasicDBObject filter = new BasicDBObject();
                    filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
                    filter.put((Object)"changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
                    filter.put((Object)"meta.tenant", (Object)tenant);
                    filter.put((Object)"meta.sessionBoardId", (Object)sessionBoard.getId());
                    DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
                    long startTime = System.currentTimeMillis();
                    DBCursor querys = collection.find((DBObject)filter);
                    while (querys.hasNext()) {
                        try {
                            TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                            DBObject dbObject = querys.next();
                            timeSeriesLog.setId(dbObject.get("_id").toString());
                            timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                            timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                            timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                            timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                            timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                            timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                            queriedTimeSeriesItems.add(timeSeriesLog);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error processing a TimeSeriesLog entry from the query result: {}" + StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    this.checkItemExistanceInCollection(queriedTimeSeriesItems);
                    LOGGER.info("Query execution time (seconds): {}", (Object)Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
                }
                catch (Exception e) {
                    LOGGER.error("Error during TimeSeriesLog query execution: {}" + StringUtils.getTraceString((Throwable)e));
                }
                if ("unplanned-items".equals(boardItemsFilter)) {
                    queriedTimeSeriesItems = this.retrieveAndCheckTeamContainerForUnPlanned(queriedTimeSeriesItems, tenant);
                } else if ("planned-items".equals(boardItemsFilter)) {
                    queriedTimeSeriesItems = this.retrieveAndCheckTeamContainerForPlanned(queriedTimeSeriesItems, tenant);
                }
                queriedTimeSeriesItems = this.filterSearchedItems(queriedTimeSeriesItems, searchedItemIds);
                Set statusIds = queriedTimeSeriesItems.stream().map(log -> (String)((Map)log.getChanges().get("status")).get("id")).collect(Collectors.toSet());
                Map statusMap = this.fetchStatuses(statusIds);
                Set tempItemIds = queriedTimeSeriesItems.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
                if (PropertyValidator.isValid(tempItemIds)) {
                    itemIds.addAll(tempItemIds);
                }
                Map itemMap = new HashMap();
                try {
                    itemMap = this.fetchItems(itemIds);
                }
                catch (Exception e) {
                    LOGGER.error("Error fetching items: {}", (Object)StringUtils.getTraceString((Throwable)e));
                }
                try {
                    this.processTimeSeriesLogsForDays(queriedTimeSeriesItems, statusMap, itemMap, statusTitleToItemIdMap, radioButtonSelection, selectedIssueType, issueTypeMap, allIssueTypesMap, advanceCriteria, selectedAdvanceCriteria, allGroupBysMap);
                }
                catch (Exception e) {
                    LOGGER.error("Error processing TimeSeriesLogs: {}", (Object)StringUtils.getTraceString((Throwable)e));
                }
                if (previousKey != null && intervalStatusItemMap.containsKey(previousKey)) {
                    this.copyUnchangedItemsFromPreviousIteration(intervalStatusItemMap.get(previousKey), statusTitleToItemIdMap);
                }
                this.ensureAllStatusTitlesRepresented(allStatusTitles, statusTitleToItemIdMap);
                try {
                    this.removeArchivedItems(relevantDates.get(key), statusTitleToItemIdMap, "days");
                }
                catch (Exception e) {
                    LOGGER.error("Error removing archived items: {}", (Object)StringUtils.getTraceString((Throwable)e));
                }
                intervalStatusItemMap.put(key, statusTitleToItemIdMap);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in populateStatusMapForDays: {}", (Object)StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    private void processTimeSeriesLogsForDays(List<TimeSeriesLog> logs, Map<String, Status> statusMap, Map<String, Item> itemMap, Map<String, Set<String>> statusTitleToItemIdMap, String radioButtonSelection, List<String> selectedIssueType, Map<String, String> issueTypeMap, Map<String, String> allIssueTypesMap, String advanceCriteria, List<String> selectedAdvanceCriteria, Map<String, String> allGroupBysMap) {
        HashMap<String, TimeSeriesLog> latestStatusChangeMap = new HashMap<String, TimeSeriesLog>();
        try {
            for (TimeSeriesLog log : logs) {
                String itemId = log.getItemId();
                if (latestStatusChangeMap.containsKey(itemId) && !log.getEventTime().after(((TimeSeriesLog)latestStatusChangeMap.get(itemId)).getEventTime())) continue;
                latestStatusChangeMap.put(itemId, log);
            }
            for (TimeSeriesLog log : latestStatusChangeMap.values()) {
                Map statusChange = (Map)log.getChanges().get("status");
                String statusId = (String)statusChange.get("id");
                Status status = statusMap.get(statusId);
                String statusTitle = radioButtonSelection.equals("status") ? status.getTitle() : status.getCategory();
                statusTitleToItemIdMap.computeIfAbsent(statusTitle, k -> new HashSet()).add(log.getItemId());
                Item item = itemMap.get(log.getItemId());
                if (item == null) continue;
                if (!selectedIssueType.isEmpty() && !this.isValidIssueType(item, selectedIssueType, issueTypeMap, allIssueTypesMap)) {
                    statusTitleToItemIdMap.get(statusTitle).remove(log.getItemId());
                    continue;
                }
                if (!"teams".equals(advanceCriteria) || this.isValidTeam(item, selectedAdvanceCriteria, allGroupBysMap)) continue;
                statusTitleToItemIdMap.get(statusTitle).remove(log.getItemId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing processTimeSeriesLogsForDays()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<Map<String, String>, Long> populateMapOfCountOfStatuses(Set<String> allStatusTitles, Map<String, Map<String, Set<String>>> intervalStatusItemMap, Map<Map<String, String>, Set<String>> itemIdsWRTInterval) {
        LinkedHashMap<Map<String, String>, Long> sprintCounts = new LinkedHashMap<Map<String, String>, Long>();
        try {
            if (intervalStatusItemMap != null && !intervalStatusItemMap.isEmpty()) {
                for (String key : intervalStatusItemMap.keySet()) {
                    Map<String, Set<String>> map = intervalStatusItemMap.get(key);
                    if (map == null) continue;
                    for (String internalKey : map.keySet()) {
                        Set<String> list = map.get(internalKey);
                        if (list == null) continue;
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        tempMap.put(key, internalKey);
                        sprintCounts.put(tempMap, Long.valueOf(list.size()));
                        itemIdsWRTInterval.put(tempMap, list);
                    }
                }
            }
            ArrayList tempsprintCount = new ArrayList();
            if (sprintCounts != null) {
                tempsprintCount.addAll(sprintCounts.entrySet());
            }
            if (allStatusTitles != null) {
                Set<String> finalAllStatusTitles = allStatusTitles;
                tempsprintCount.sort(new /* Unavailable Anonymous Inner Class!! */);
            }
            LinkedHashMap sortedSprintCounts = new LinkedHashMap();
            for (Map.Entry entry : tempsprintCount) {
                sortedSprintCounts.put(entry.getKey(), entry.getValue());
            }
            sprintCounts.clear();
            if (sortedSprintCounts != null) {
                sprintCounts.putAll(sortedSprintCounts);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateMapOfCountOfStatuses()" + StringUtils.getTraceString((Throwable)e));
        }
        return sprintCounts;
    }

    public Map<String, List<Date>> getDatesOfCFD(String xAxisSelection, SessionBoard sessionBoard, Date firstEntryDate, Date startDate, Date endDate) {
        Map<String, List<Date>> releventDates = new LinkedHashMap<String, List<Date>>();
        try {
            block7 : switch (xAxisSelection) {
                case "sprints": {
                    releventDates = this.getSprintDates(sessionBoard);
                    break;
                }
                case "weekly": {
                    Map sprintDates = this.getSprintDates(sessionBoard);
                    ArrayList allSprints = new ArrayList(sprintDates.keySet());
                    if (allSprints.isEmpty()) break;
                    Date dateStart = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                    Date dateEnd = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                    long startTime = dateStart.getTime();
                    long endTime = dateEnd.getTime();
                    for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                        Date weekStartDate = new Date(weekStart);
                        Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                        if (weekStartDate.after(new Date())) break block7;
                        releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                    }
                    break;
                }
                case "monthly": {
                    Calendar calendar = Calendar.getInstance();
                    Map sprintDates = this.getSprintDates(sessionBoard);
                    ArrayList allSprints = new ArrayList(sprintDates.keySet());
                    if (allSprints.isEmpty()) break;
                    calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                    releventDates = this.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), endDate);
                    break;
                }
                case "days": {
                    releventDates = new HashMap();
                    ArrayList allDates = new ArrayList();
                    releventDates = this.getAllDateswrtFirstDate(startDate, endDate, firstEntryDate);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDatesOfCFD()" + StringUtils.getTraceString((Throwable)e));
        }
        return releventDates;
    }

    public List<String> getStatusCategoryOrder(List<String> statusOrderList) {
        ArrayList<String> statusOrder = new ArrayList<String>();
        try {
            if (statusOrderList != null) {
                if (statusOrderList == null || statusOrderList.isEmpty()) {
                    return Collections.emptyList();
                }
                List ids = statusOrderList.stream().filter(Objects::nonNull).map(status -> DBUtils.isHexString((String)status) ? new ObjectId(status) : status).collect(Collectors.toList());
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
                query.fields().include("category");
                List resultStatusObj = this.mongoTemplate.find(query, Status.class);
                for (Status status2 : resultStatusObj) {
                    if (status2 == null || status2.getCategory() == null) continue;
                    statusOrder.add(status2.getCategory());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getStatusCategoryOrder()" + StringUtils.getTraceString((Throwable)e));
        }
        return statusOrder;
    }

    public Set<String> sortStatusesByWorkflow(List<String> individualSelectedStatusIds, List<String> statusOrder, String radioButtonSelection) {
        LinkedHashSet<String> allStatusTitles = new LinkedHashSet<String>();
        try {
            if (individualSelectedStatusIds == null || individualSelectedStatusIds.isEmpty()) {
                return Collections.emptySet();
            }
            List ids = individualSelectedStatusIds.stream().filter(Objects::nonNull).map(status -> DBUtils.isHexString((String)status) ? new ObjectId(status) : status).collect(Collectors.toList());
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(ids));
            query.fields().include("title").include("category");
            List statuses = this.mongoTemplate.find(query, Status.class);
            Map categoryToStatusTitlesMap = statuses.stream().filter(status -> status.getCategory() != null && status.getTitle() != null).collect(Collectors.groupingBy(Status::getCategory, Collectors.mapping(Status::getTitle, Collectors.toList())));
            if (statusOrder != null && radioButtonSelection.equals("status")) {
                for (String category : statusOrder) {
                    List titles = categoryToStatusTitlesMap.get(category);
                    if (titles == null) continue;
                    allStatusTitles.addAll(titles);
                }
            } else if (statusOrder != null) {
                for (String category : statusOrder) {
                    if (!categoryToStatusTitlesMap.containsKey(category)) continue;
                    allStatusTitles.add(category);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing sortStatusesByWorkflow()" + StringUtils.getTraceString((Throwable)e));
        }
        return allStatusTitles;
    }

    public Double calculateAverageCycleTime(List<String> individualActiveStatusIds, List<String> individualCompletedStatusIds, SessionBoard sessionBoard, String tenant) {
        if (individualActiveStatusIds != null && !individualActiveStatusIds.isEmpty() && individualCompletedStatusIds != null && !individualCompletedStatusIds.isEmpty()) {
            Query queryForActiveItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualActiveStatusIds).and("tenant").is((Object)tenant).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
            queryForActiveItems.fields().include("eventTime");
            queryForActiveItems.fields().include("itemId");
            List activeItemsList = this.mongoTemplate.find(queryForActiveItems, TimeSeriesLog.class, "itemTimeSeries");
            if (activeItemsList != null && !activeItemsList.isEmpty()) {
                ArrayList<String> allActiveItemsIds = new ArrayList<String>();
                for (TimeSeriesLog seriesLog : activeItemsList) {
                    if (seriesLog == null || seriesLog.getItemId() == null) continue;
                    allActiveItemsIds.add(seriesLog.getItemId());
                }
                Query queryForCompletedItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualCompletedStatusIds).and("tenant").is((Object)tenant).and("itemId").in(allActiveItemsIds).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
                List completedItemsList = this.mongoTemplate.find(queryForCompletedItems, TimeSeriesLog.class, "itemTimeSeries");
                if (completedItemsList != null && !completedItemsList.isEmpty()) {
                    List tempList;
                    double avgCycleTime = 0.0;
                    double numberOfPreviousCycles = 0.0;
                    HashMap<String, List> allActiveItemsMap = new HashMap<String, List>();
                    HashMap<String, List> allCompletedItemsMap = new HashMap<String, List>();
                    for (TimeSeriesLog timeSeriesLog : activeItemsList) {
                        if (timeSeriesLog == null || timeSeriesLog.getItemId() == null) continue;
                        tempList = allActiveItemsMap.getOrDefault(timeSeriesLog.getItemId(), new ArrayList());
                        tempList.add(timeSeriesLog);
                        allActiveItemsMap.put(timeSeriesLog.getItemId(), tempList);
                    }
                    for (TimeSeriesLog timeSeriesLog : completedItemsList) {
                        if (timeSeriesLog == null || timeSeriesLog.getItemId() == null) continue;
                        tempList = allCompletedItemsMap.getOrDefault(timeSeriesLog.getItemId(), new ArrayList());
                        tempList.add(timeSeriesLog);
                        allCompletedItemsMap.put(timeSeriesLog.getItemId(), tempList);
                    }
                    for (Map.Entry entry : allCompletedItemsMap.entrySet()) {
                        Object eventDate;
                        if (entry == null || entry.getValue() == null) continue;
                        Date closingDate = new Date(Long.MAX_VALUE);
                        List timeSeriesLogs = (List)entry.getValue();
                        for (TimeSeriesLog log : timeSeriesLogs) {
                            if (log == null || log.getEventTime() == null || !((Date)(eventDate = log.getEventTime())).before(closingDate)) continue;
                            closingDate = eventDate;
                        }
                        Date startingDate = new Date(Long.MAX_VALUE);
                        List active = (List)allActiveItemsMap.get(((TimeSeriesLog)timeSeriesLogs.get(0)).getItemId());
                        if (active != null) {
                            eventDate = active.iterator();
                            while (eventDate.hasNext()) {
                                Date eventDate2;
                                TimeSeriesLog log = (TimeSeriesLog)eventDate.next();
                                if (log == null || log.getEventTime() == null || !(eventDate2 = log.getEventTime()).before(startingDate)) continue;
                                startingDate = eventDate2;
                            }
                        }
                        long millisecondsDifference = closingDate.getTime() - startingDate.getTime();
                        long daysDifference = millisecondsDifference / 86400000L;
                        avgCycleTime = (avgCycleTime * numberOfPreviousCycles + (double)daysDifference) / (numberOfPreviousCycles + 1.0);
                        numberOfPreviousCycles += 1.0;
                    }
                }
            }
        }
        return 0.0;
    }

    public Double calculateAverageLeadTime(List<String> individualCompletedStatusIds, SessionBoard sessionBoard, String tenant) {
        double numberOfPreviousCycles = 0.0;
        double avgLeadTime = 0.0;
        if (individualCompletedStatusIds != null && !individualCompletedStatusIds.isEmpty()) {
            Query queryForActiveItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualCompletedStatusIds).and("meta.tenant").is((Object)tenant).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
            queryForActiveItems.fields().include("eventTime");
            queryForActiveItems.fields().include("itemId");
            List completedItemsList = this.mongoTemplate.find(queryForActiveItems, TimeSeriesLog.class, "itemTimeSeries");
            if (completedItemsList != null) {
                for (TimeSeriesLog completedTimeSeriesEntry : completedItemsList) {
                    Instant instant;
                    if (completedTimeSeriesEntry == null || completedTimeSeriesEntry.getItemId() == null) continue;
                    Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(completedTimeSeriesEntry.getItemId())).and("tenant").is((Object)tenant));
                    Item selectedItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                    Date createdDate = new Date();
                    if (selectedItem == null) continue;
                    if (selectedItem.getJiraFieldByKey() != null) {
                        String creationDate = (String)selectedItem.getJiraFieldByKey().get("created");
                        if (creationDate != null && PropertyValidator.isValid((Object)(instant = TimeSeriesUtils.parseDate((String)creationDate)))) {
                            createdDate = Date.from(instant);
                        }
                    } else if (selectedItem.getTfsFieldByKey() != null) {
                        String creationDate = (String)selectedItem.getTfsFieldByKey().get("createdDate");
                        if (creationDate != null && PropertyValidator.isValid((Object)(instant = TimeSeriesUtils.parseDate((String)creationDate)))) {
                            createdDate = Date.from(instant);
                        }
                    } else if (selectedItem.getCreatedOn() != null) {
                        createdDate = selectedItem.getCreatedOn();
                    }
                    if (completedTimeSeriesEntry.getEventTime() == null) continue;
                    double millisecondsDifference = completedTimeSeriesEntry.getEventTime().getTime() - createdDate.getTime();
                    double daysDifference = millisecondsDifference / 8.64E7;
                    avgLeadTime = (avgLeadTime * numberOfPreviousCycles + daysDifference) / (numberOfPreviousCycles + 1.0);
                    numberOfPreviousCycles += 1.0;
                }
            }
        }
        return avgLeadTime;
    }

    public Double calculateAverageArrivalTime(Date endDate, List<String> individualWaitingStatusIds, Map<String, List<Date>> releventDates, SessionBoard sessionBoard, Date startDate, String tenant, String xAxis) {
        double avgArrivalTime = 0.0;
        double itemsCount = 0.0;
        if (individualWaitingStatusIds != null && !individualWaitingStatusIds.isEmpty()) {
            int totalIntervals = 1;
            if (releventDates != null) {
                totalIntervals = releventDates.size();
            }
            Query queryForActiveItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualWaitingStatusIds).and("meta.tenant").is((Object)tenant).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
            queryForActiveItems.fields().include("eventTime");
            List inProgressItemsList = this.mongoTemplate.find(queryForActiveItems, TimeSeriesLog.class, "itemTimeSeries");
            Date dateStarting = new Date();
            Date dateEnding = new Date();
            if (xAxis != null) {
                if (xAxis.equals("sprints") || xAxis.equals("weekly") || xAxis.equals("monthly")) {
                    Set<Map.Entry<String, List<Date>>> entries;
                    ArrayList<Map.Entry<String, List<Date>>> entryList;
                    if (releventDates != null && !releventDates.isEmpty() && !(entryList = new ArrayList<Map.Entry<String, List<Date>>>(entries = releventDates.entrySet())).isEmpty()) {
                        Map.Entry lastEntry;
                        List lastEntryDates;
                        Map.Entry firstntry = (Map.Entry)entryList.get(0);
                        List firstEntryDates = (List)firstntry.getValue();
                        if (firstEntryDates != null && !firstEntryDates.isEmpty()) {
                            dateStarting = (Date)firstEntryDates.get(0);
                        }
                        if ((lastEntryDates = (List)(lastEntry = (Map.Entry)entryList.get(entryList.size() - 1)).getValue()) != null && !lastEntryDates.isEmpty()) {
                            dateEnding = (Date)lastEntryDates.get(lastEntryDates.size() - 1);
                        }
                    }
                } else if (xAxis.equals("days")) {
                    if (startDate != null) {
                        dateStarting = startDate;
                    }
                    if (endDate != null) {
                        dateEnding = endDate;
                    }
                }
            }
            if (inProgressItemsList != null) {
                for (TimeSeriesLog wipTimeSeriesItem : inProgressItemsList) {
                    if (wipTimeSeriesItem == null || wipTimeSeriesItem.getEventTime() == null || wipTimeSeriesItem.getEventTime().compareTo(dateStarting) < 0 || wipTimeSeriesItem.getEventTime().compareTo(dateEnding) > 0) continue;
                    itemsCount += 1.0;
                }
            }
            if (totalIntervals > 0) {
                avgArrivalTime = itemsCount / (double)totalIntervals;
            }
        }
        return avgArrivalTime;
    }

    public Double calculateAverageThroughputTime(Date endDate, List<String> individualCompletedStatusIds, Map<String, List<Date>> releventDates, SessionBoard sessionBoard, Date startDate, String tenant, String xAxis) {
        double avgThroughputTime = 0.0;
        if (individualCompletedStatusIds != null && !individualCompletedStatusIds.isEmpty()) {
            double itemsCount = 0.0;
            double totalIntervals = 1.0;
            if (releventDates != null && !releventDates.isEmpty()) {
                totalIntervals = releventDates.size();
            }
            Query queryForActiveItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualCompletedStatusIds).and("meta.tenant").is((Object)tenant).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
            queryForActiveItems.fields().include("eventTime");
            List inProgressItemsList = this.mongoTemplate.find(queryForActiveItems, TimeSeriesLog.class, "itemTimeSeries");
            Date dateStarting = new Date();
            Date dateEnding = new Date();
            if (xAxis != null) {
                if (xAxis.equals("sprints") || xAxis.equals("weekly") || xAxis.equals("monthly")) {
                    Set<Map.Entry<String, List<Date>>> entries;
                    ArrayList<Map.Entry<String, List<Date>>> entryList;
                    if (releventDates != null && !releventDates.isEmpty() && !(entryList = new ArrayList<Map.Entry<String, List<Date>>>(entries = releventDates.entrySet())).isEmpty()) {
                        Map.Entry lastEntry;
                        List lastEntryDates;
                        Map.Entry firEntry = (Map.Entry)entryList.get(0);
                        List firstEntryDates = (List)firEntry.getValue();
                        if (firstEntryDates != null && !firstEntryDates.isEmpty()) {
                            dateStarting = (Date)firstEntryDates.get(0);
                        }
                        if ((lastEntryDates = (List)(lastEntry = (Map.Entry)entryList.get(entryList.size() - 1)).getValue()) != null && !lastEntryDates.isEmpty()) {
                            dateEnding = (Date)lastEntryDates.get(lastEntryDates.size() - 1);
                        }
                    }
                } else if (xAxis.equals("days")) {
                    if (startDate != null) {
                        dateStarting = startDate;
                    }
                    if (endDate != null) {
                        dateEnding = endDate;
                    }
                }
            }
            if (inProgressItemsList != null) {
                for (TimeSeriesLog wipTimeSeriesItem : inProgressItemsList) {
                    if (wipTimeSeriesItem == null || wipTimeSeriesItem.getEventTime() == null || wipTimeSeriesItem.getEventTime().compareTo(dateStarting) < 0 || wipTimeSeriesItem.getEventTime().compareTo(dateEnding) > 0) continue;
                    itemsCount += 1.0;
                }
            }
            if (totalIntervals > 0.0) {
                avgThroughputTime = itemsCount / totalIntervals;
            }
        }
        return avgThroughputTime;
    }

    public Double calculateAverageWIPTime(Date endDate, List<String> individualWaitingStatusIds, Map<String, List<Date>> releventDates, SessionBoard sessionBoard, Date startDate, String tenant, String xAxis) {
        double avgArrivalTime = 0.0;
        if (individualWaitingStatusIds != null && !individualWaitingStatusIds.isEmpty()) {
            double itemsCount = 0.0;
            double totalIntervals = 1.0;
            if (releventDates != null && !releventDates.isEmpty()) {
                totalIntervals = releventDates.size();
            }
            Query queryForActiveItems = new Query((CriteriaDefinition)Criteria.where((String)"changes.status.id").in(individualWaitingStatusIds).and("meta.tenant").is((Object)tenant).and("meta.sessionBoardId").is((Object)sessionBoard.getId()));
            queryForActiveItems.fields().include("eventTime");
            List inProgressItemsList = this.mongoTemplate.find(queryForActiveItems, TimeSeriesLog.class, "itemTimeSeries");
            Date dateStarting = new Date();
            Date dateEnding = new Date();
            if (xAxis != null) {
                if (xAxis.equals("sprints") || xAxis.equals("weekly") || xAxis.equals("monthly")) {
                    Set<Map.Entry<String, List<Date>>> entries;
                    ArrayList<Map.Entry<String, List<Date>>> entryList;
                    if (releventDates != null && !releventDates.isEmpty() && !(entryList = new ArrayList<Map.Entry<String, List<Date>>>(entries = releventDates.entrySet())).isEmpty()) {
                        Map.Entry lastEntry;
                        List lastEntryDates;
                        Map.Entry firsttEntry = (Map.Entry)entryList.get(0);
                        List firstEntryDates = (List)firsttEntry.getValue();
                        if (firstEntryDates != null && !firstEntryDates.isEmpty()) {
                            dateStarting = (Date)firstEntryDates.get(0);
                        }
                        if ((lastEntryDates = (List)(lastEntry = (Map.Entry)entryList.get(entryList.size() - 1)).getValue()) != null && !lastEntryDates.isEmpty()) {
                            dateEnding = (Date)lastEntryDates.get(lastEntryDates.size() - 1);
                        }
                    }
                } else if (xAxis.equals("days")) {
                    if (startDate != null) {
                        dateStarting = startDate;
                    }
                    if (endDate != null) {
                        dateEnding = endDate;
                    }
                }
            }
            if (inProgressItemsList != null) {
                for (TimeSeriesLog wipTimeSeriesItem : inProgressItemsList) {
                    if (wipTimeSeriesItem == null || wipTimeSeriesItem.getEventTime() == null || wipTimeSeriesItem.getEventTime().compareTo(dateStarting) < 0 || wipTimeSeriesItem.getEventTime().compareTo(dateEnding) > 0) continue;
                    itemsCount += 1.0;
                }
            }
            if (totalIntervals > 0.0) {
                avgArrivalTime = itemsCount / totalIntervals;
            }
        }
        return avgArrivalTime;
    }

    public List<TimeSeriesLog> populateTimeSeriesItemsListbyStatus(List<String> statusList, Date startDate, Date endDate, String tenant, String collectionName, String sessionBoardId) {
        ArrayList<TimeSeriesLog> resultList = new ArrayList<TimeSeriesLog>();
        try {
            BasicDBObject filter = new BasicDBObject();
            filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate));
            filter.put((Object)"changes.status.id", (Object)new BasicDBObject("$in", statusList));
            filter.put((Object)"meta.tenant", (Object)tenant);
            filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
            DBCollection collection = this.mongoTemplate.getCollection(collectionName);
            long startTime = System.currentTimeMillis();
            DBCursor querys = collection.find((DBObject)filter);
            while (querys.hasNext()) {
                TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                DBObject dbObject = querys.next();
                timeSeriesLog.setId(dbObject.get("_id").toString());
                timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                resultList.add(timeSeriesLog);
            }
            this.checkItemExistanceInCollection(resultList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateTimeSeriesItemsListbyStatus()" + StringUtils.getTraceString((Throwable)e));
        }
        return resultList;
    }

    public List<TimeSeriesLog> populateTimeSeriesItemsList(List<String> statusList, Date startDate, Date endDate, String tenant, String collectionName, String sessionBoardId) {
        ArrayList<TimeSeriesLog> resultList = new ArrayList<TimeSeriesLog>();
        try {
            BasicDBObject filter = new BasicDBObject();
            filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lt", (Object)endDate));
            filter.put((Object)"meta.tenant", (Object)tenant);
            filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
            filter.put((Object)"changes.status.id", (Object)new BasicDBObject("$in", statusList));
            DBCollection collection = this.mongoTemplate.getCollection(collectionName);
            DBCursor querys = collection.find((DBObject)filter);
            while (querys.hasNext()) {
                TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                DBObject dbObject = querys.next();
                timeSeriesLog.setId(dbObject.get("_id").toString());
                timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                resultList.add(timeSeriesLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing populateTimeSeriesItemsList()" + StringUtils.getTraceString((Throwable)e));
        }
        return resultList;
    }

    public static Instant parseDate(String creationDate) {
        try {
            return Instant.parse(creationDate);
        }
        catch (DateTimeParseException e1) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                OffsetDateTime dateTime = OffsetDateTime.parse(creationDate, formatter);
                return dateTime.toInstant();
            }
            catch (DateTimeParseException e2) {
                return null;
            }
        }
    }

    public static String getRandomHexColor(Map<String, Object> globalColorsMap, String type, String statusCategory) {
        String randColor = "";
        try {
            int randomIndex;
            List colorGroups;
            HashMap<String, String> categoryHexMap = new HashMap<String, String>();
            categoryHexMap.put(EnumStatusCategory.OPEN.getCode(), "#E59367");
            categoryHexMap.put(EnumStatusCategory.INPROGRESS.getCode(), "#3C93C7");
            categoryHexMap.put(EnumStatusCategory.DONE.getCode(), "#26BAA1");
            categoryHexMap.put(EnumStatusCategory.MISC.getCode(), "#5D3FD1");
            if (type.equals("statusCategory") && !statusCategory.isEmpty()) {
                return (String)categoryHexMap.get(statusCategory);
            }
            HashMap<String, List<List>> statusColorGroups = new HashMap<String, List<List>>();
            statusColorGroups.put(EnumStatusCategory.DONE.getCode(), Arrays.asList(Arrays.asList("#10C92E", "#15A432", "#1E7B2B", "#1C5626"), Arrays.asList("#10CB5A", "#19A252", "#1B7D42", "#1B5733"), Arrays.asList("#59C90F", "#53A119", "#447D1E", "#31571A"), Arrays.asList("#80C711", "#6DA214", "#557D1D", "#3E5720"), Arrays.asList("#0FC97E", "#18A368", "#1F7B54", "#1D543D"), Arrays.asList("#A3CA0D", "#87A217", "#687D16", "#4B561E"), Arrays.asList("#06CDA4", "#1AA387", "#1C7D6A", "#1D554A")));
            statusColorGroups.put(EnumStatusCategory.OPEN.getCode(), Arrays.asList(Arrays.asList("#C93A0E", "#A43919", "#7D331A", "#58291F"), Arrays.asList("#C85911", "#A25217", "#7B441D", "#56321A"), Arrays.asList("#CB7A0F", "#A2681E", "#7B521E", "#543D1B"), Arrays.asList("#C9A310", "#A28817", "#7E681F", "#534C16"), Arrays.asList("#C8CA0D", "#A4A315", "#797C21", "#53561D"), Arrays.asList("#391D16", "#331E10", "#302310", "#29260C")));
            statusColorGroups.put(EnumStatusCategory.INPROGRESS.getCode(), Arrays.asList(Arrays.asList("#2596D0", "#277CA5", "#26637F", "#214658"), Arrays.asList("#0FC8CA", "#1BA1A2", "#1F7A7F", "#1A5657"), Arrays.asList("#0FA5C8", "#1A88A1", "#1E697C", "#184C59"), Arrays.asList("#3281D0", "#366EA7", "#315683", "#294159"), Arrays.asList("#3D66DA", "#3B5AAC", "#374C85", "#2A375A"), Arrays.asList("#4143D6", "#433FB7", "#383A85", "#2F2C57")));
            statusColorGroups.put(EnumStatusCategory.MISC.getCode(), Arrays.asList(Arrays.asList("#5D3FD1", "#513BA7", "#463585", "#372B59"), Arrays.asList("#7438D4", "#6636AC", "#503481", "#3F2763"), Arrays.asList("#8E2CD1", "#7A30A9", "#602F80", "#432557"), Arrays.asList("#A50FC9", "#8819A3", "#6A1A7D", "#4C1A57"), Arrays.asList("#C70FC9", "#A318A5", "#7C1E7E", "#561D54"), Arrays.asList("#C810A6", "#A31988", "#7D1C69", "#581A49")));
            if (type.equals("status") && !statusCategory.isEmpty() && (colorGroups = (List)statusColorGroups.get(statusCategory)) != null) {
                for (Object colorGroup : colorGroups) {
                    Iterator iterator = colorGroup.iterator();
                    while (iterator.hasNext()) {
                        String color = (String)iterator.next();
                        if (globalColorsMap.containsValue(color)) continue;
                        return color;
                    }
                }
                ArrayList allCategoryColors = new ArrayList();
                for (List group : colorGroups) {
                    allCategoryColors.addAll(group);
                }
                Random random = new Random();
                int randomIndex2 = random.nextInt(allCategoryColors.size());
                randColor = (String)allCategoryColors.get(randomIndex2);
                return randColor;
            }
            List<String> hexColors = Arrays.asList("#E3554E", "#E3554E", "#E64735", "#D83E34", "#C6352E", "#B92F27", "#AA241C", "#FF949D", "#F03F3D", "#F11F15", "#D30A00", "#E6357C", "#E69F35", "#DD527C", "#D83E67", "#C73A63", "#B1365D", "#9C3258", "#752B4C", "#FFA4C4", "#F56193", "#EB2B65", "#BE0E46", "#D83EB4", "#D8623E", "#A251B2", "#9238A4", "#85349E", "#732E95", "#64298B", "#47217A", "#F3B8FF", "#D379E4", "#B436CD", "#6C079D", "#5C38A4", "#A43880", "#7A5CB6", "#6441A9", "#5B3CA3", "#4F349A", "#452E91", "#342381", "#CFB9FF", "#A180E8", "#370CAC", "#4152A9", "#4152A9", "#606DB3", "#4554A7", "#3F4C9D", "#364292", "#2F3885", "#23276F", "#C0CCFF", "#8D9FEF", "#546EFB", "#162BB2", "#4585A7", "#6745A7", "#5DA3E7", "#4B94E3", "#4587D5", "#3E75C3", "#3764B0", "#2C4790", "#9FD3FF", "#7AC2FF", "#339AFF", "#2069D0", "#4BE0E3", "#4E4BE3", "#57C3D5", "#52B9CD", "#4CA9BA", "#4594A1", "#408089", "#355C5F", "#ADF5FF", "#72E3F4", "#14DDFF", "#00A5C0", "#52CDA4", "#527BCD", "#4CA398", "#409387", "#3B867A", "#36766A", "#31665C", "#294A41", "#B0F4ED", "#6EE1D4", "#16CAB3", "#097B66", "#40935D", "#407693", "#94C06A", "#82B552", "#74A64A", "#629240", "#507E37", "#315D25", "#CBF6A1", "#A3E465", "#7BCE2C", "#4B9F0F", "#B3B552", "#52B554", "#FFD069", "#FDC964", "#FABD5E", "#F6AC59", "#F29E55", "#EA8750", "#FFE9B1", "#FFDB81", "#FFBA23", "#FF8F12", "#FD7E64", "#E4FD64", "#877068", "#74574D", "#684E46", "#58423B", "#493632", "#392926", "#E0D8CF", "#C2AAA1", "#9C6B5A", "#703B2B", "#744D57", "#746A4D", "#BDBDBD", "#9E9E9E", "#757575", "#616161", "#424242", "#212121", "#EDEDED", "#D8D8D8", "#959595", "#434343", "#9E9E9E", "#7D8F99", "#7D8F99", "#596D77", "#495961", "#3B464C", "#2A3135", "#DAE5EB", "#B4C9D4", "#7397AB", "#4A6675", "#658883", "#658883");
            Random random = new Random();
            for (int index = 0; (globalColorsMap.containsValue(randColor = hexColors.get(randomIndex = random.nextInt(hexColors.size()))) || index == hexColors.size()) && index != hexColors.size(); ++index) {
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getRandomHexColor()", (Object)StringUtils.getTraceString((Throwable)e));
        }
        return randColor;
    }

    public List<String> getStatusListOfaTitle(List<String> statuses, List<Status> statusList) {
        ArrayList<String> statusIdsBatch = new ArrayList<String>();
        HashSet<Object> allSelectedStatuses = new HashSet();
        try {
            for (String statusId : statuses) {
                statusIdsBatch.add((String)(ObjectId.isValid((String)statusId) ? new ObjectId(statusId) : statusId));
            }
            allSelectedStatuses = new HashSet<String>(statuses);
            Query queryForStatusCategories = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(statusIdsBatch));
            queryForStatusCategories.fields().include("title");
            List selectedStatusList = this.mongoTemplate.find(queryForStatusCategories, Status.class);
            if (PropertyValidator.isValid(statusList) && PropertyValidator.isValid((Collection)selectedStatusList)) {
                for (Status status : statusList) {
                    for (Status selectedStatus : selectedStatusList) {
                        if (!status.getTitle().equals(selectedStatus.getTitle())) continue;
                        allSelectedStatuses.add(status.getId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getStatusListOfaTitle()" + StringUtils.getTraceString((Throwable)e));
        }
        return new ArrayList<String>(allSelectedStatuses);
    }

    public List<TimeSeriesLog> getFilteredItemsListByStatus(List<String> searchedItemIds, List<String> startingStatusId, Date startDate, Date endDate, String tenant, String collectionName, String sessionBoardId) {
        ArrayList<TimeSeriesLog> matchedItems = new ArrayList();
        try {
            if (PropertyValidator.isValid(searchedItemIds)) {
                List allItemslog = this.populateTimeSeriesItemsListbyStatus(startingStatusId, startDate, endDate, tenant, collectionName, sessionBoardId);
                if (PropertyValidator.isValid((Collection)allItemslog)) {
                    for (TimeSeriesLog timeSeriesLog : allItemslog) {
                        if (!searchedItemIds.contains(timeSeriesLog.getItemId())) continue;
                        matchedItems.add(timeSeriesLog);
                    }
                }
            } else {
                matchedItems = this.populateTimeSeriesItemsListbyStatus(startingStatusId, startDate, endDate, tenant, collectionName, sessionBoardId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getFilteredItemsListByStatus()" + StringUtils.getTraceString((Throwable)e));
        }
        return matchedItems;
    }

    public List<TimeSeriesLog> getFilteredItemsListByStatusCategory(List<String> searchedItemIds, List<String> startingStatusId, Date startDate, Date endDate, String tenant, String collectionName, String sessionBoardId) {
        ArrayList<TimeSeriesLog> matchedItems = new ArrayList();
        try {
            if (PropertyValidator.isValid(searchedItemIds)) {
                List allItemslog = this.populateTimeSeriesItemsList(startingStatusId, startDate, endDate, tenant, collectionName, sessionBoardId);
                if (PropertyValidator.isValid((Collection)allItemslog)) {
                    for (TimeSeriesLog timeSeriesLog : allItemslog) {
                        if (!searchedItemIds.contains(timeSeriesLog.getItemId())) continue;
                        matchedItems.add(timeSeriesLog);
                    }
                }
            } else {
                matchedItems = this.populateTimeSeriesItemsList(startingStatusId, startDate, endDate, tenant, collectionName, sessionBoardId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getFilteredItemsListByStatusCategory()" + StringUtils.getTraceString((Throwable)e));
        }
        return matchedItems;
    }

    public List<TimeSeriesLog> filterSearchedItems(List<TimeSeriesLog> queriedItems, List<String> searchedItemIds) {
        ArrayList<TimeSeriesLog> resultList;
        block4: {
            resultList = new ArrayList<TimeSeriesLog>();
            try {
                if (!PropertyValidator.isValid(queriedItems)) break block4;
                if (PropertyValidator.isValid(searchedItemIds)) {
                    for (TimeSeriesLog entry : queriedItems) {
                        if (!searchedItemIds.contains(entry.getItemId())) continue;
                        resultList.add(entry);
                    }
                    break block4;
                }
                return queriedItems;
            }
            catch (Exception e) {
                LOGGER.error("Error processing filterSearchedItems()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return resultList;
    }

    public void getItemDifferenceMapwrtCreationDate(Item selectedItem, TimeSeriesLog endingStatus, Map<String, Long> result, Map<String, Long> itemsDaysMap, Map<String, List<String>> itemDatesMap) {
        try {
            LocalDateTime creationDateTime = selectedItem.getCreatedOn().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().withSecond(0).withNano(0);
            LocalDateTime endingDateTime = endingStatus.getEventTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().withSecond(0).withNano(0);
            long millisecondsDifference = TimeSeriesUtils.stripTime((Date)endingStatus.getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)selectedItem.getCreatedOn()).getTime();
            long daysDifference = millisecondsDifference / 86400000L;
            if (daysDifference < 1L && millisecondsDifference > 0L || creationDateTime.equals(endingDateTime) || endingStatus.getEventTime().getTime() - selectedItem.getCreatedOn().getTime() > 0L && millisecondsDifference < 1L) {
                daysDifference = 1L;
            }
            if (daysDifference > 0L) {
                result.put(endingStatus.getItemId(), daysDifference);
                itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":team", daysDifference);
                ArrayList<String> dates = new ArrayList<String>();
                dates.add(selectedItem.getCreatedOn().toString());
                dates.add(endingStatus.getEventTime().toString());
                itemDatesMap.put("itemId_" + endingStatus.getItemId() + ":team", dates);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getItemDifferenceMapwrtCreationDate()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, List<TimeSeriesLog>> populateLogsbyItemIdsMap(Set<String> ids, String sessionBoardId, String tenant, Date sDate, Date eDate) {
        try {
            BasicDBObject filter = new BasicDBObject();
            filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sDate).append("$lt", (Object)eDate));
            filter.put((Object)"meta.tenant", (Object)tenant);
            filter.put((Object)"itemId", (Object)new BasicDBObject("$in", ids));
            filter.put((Object)"meta.sessionBoardId", (Object)sessionBoardId);
            filter.put((Object)"changes.status.id", (Object)new BasicDBObject("$exists", (Object)true));
            DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
            DBCursor querys = collection.find((DBObject)filter);
            ArrayList<TimeSeriesLog> timeSeriesLogs = new ArrayList<TimeSeriesLog>();
            while (querys.hasNext()) {
                TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                DBObject dbObject = querys.next();
                timeSeriesLog.setId(dbObject.get("_id").toString());
                timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                timeSeriesLogs.add(timeSeriesLog);
            }
            Map<String, List<TimeSeriesLog>> logsByItemId = timeSeriesLogs.stream().collect(Collectors.groupingBy(TimeSeriesLog::getItemId, Collectors.toList()));
            return logsByItemId;
        }
        catch (Exception e) {
            LOGGER.error("failed to create selective items map from time series based on itemids in populateLogsbyItemIdsMap()" + StringUtils.getTraceString((Throwable)e));
            return new HashMap<String, List<TimeSeriesLog>>();
        }
    }

    public List<BaseItem> fetchBaseItems(DBObject query, String baseItemCollection, boolean allowDuplicates, int sortOrder) throws Exception {
        ArrayList<BaseItem> baseItems = new ArrayList<BaseItem>();
        DBCollection collection = this.mongoTemplate.getCollection(baseItemCollection);
        DBCursor cursor = collection.find(query).sort((DBObject)new BasicDBObject("eventTime", (Object)sortOrder));
        HashSet<String> uniqueItemIds = new HashSet<String>();
        while (cursor.hasNext()) {
            BaseItemLink link;
            ArrayList links;
            DBObject dbObject = (DBObject)cursor.next();
            String itemId = (String)dbObject.get("itemId");
            if (uniqueItemIds.contains(itemId) && !allowDuplicates) continue;
            uniqueItemIds.add(itemId);
            BaseItem baseItem = new BaseItem();
            baseItem.setId(itemId);
            baseItem.setCreatedOn((Date)dbObject.get("eventTime"));
            baseItem.setTitle((String)dbObject.get("title"));
            baseItem.setKey((String)dbObject.get("key"));
            baseItem.setArchive(((Boolean)dbObject.get("archive")).booleanValue());
            Map staticFields = (Map)dbObject.get("staticFields");
            baseItem.setAlmFields(new HashMap());
            baseItem.setStarred(Boolean.valueOf(false));
            baseItem.setIsDefaultGroup(Boolean.valueOf(false));
            baseItem.setNotifyWatchers(Boolean.valueOf(true));
            baseItem.setBacklogItemsMap(new HashMap());
            if (!PropertyValidator.isValid((Object)staticFields)) continue;
            if (staticFields.containsKey("fields")) {
                baseItem.setFields((Map)staticFields.get("fields"));
            }
            baseItem.setCompletionCriteria((String)staticFields.get("completionCriteria"));
            baseItem.setLinkedCardWeights(staticFields.getOrDefault("linkedCardWeights", 1.0));
            if (staticFields.containsKey("archive")) {
                baseItem.setArchive(((Boolean)staticFields.get("archive")).booleanValue());
            }
            if (null == (links = (ArrayList)staticFields.get("baseItemLinks")) || links.isEmpty()) continue;
            ArrayList<BaseItemLink> linksList = new ArrayList<BaseItemLink>();
            if (links.get(0) instanceof BaseItemLinkMirror) {
                ArrayList linksListMirror = links;
                for (Object mirror : linksListMirror) {
                    link = new BaseItemLink();
                    link.setSessionId(mirror.getSessionId());
                    link.setLinkType(mirror.getLinkType());
                    link.setWeightage(mirror.getWeightage());
                    link.setId(mirror.getId());
                    link.setArchive(mirror.isArchive());
                    link.setBaseItemId(mirror.getBaseItemId());
                    link.setReleaseTrainId(mirror.getReleaseTrainId());
                    link.setLinkedItemById(mirror.getLinkedItemById());
                    link.setTeamId(mirror.getTeamId());
                    link.setCreatedOn(mirror.getCreatedOn());
                    linksList.add(link);
                }
            } else if (links.get(0) instanceof LinkedHashMap) {
                ArrayList linkedList = links;
                for (Object mirror : linkedList) {
                    link = new BaseItemLink();
                    link.setSessionId((String)((LinkedHashMap)mirror).get("sessionId"));
                    link.setLinkType((String)((LinkedHashMap)mirror).get("linkType"));
                    link.setWeightage((Double)((LinkedHashMap)mirror).get("weightage"));
                    link.setId((String)((LinkedHashMap)mirror).get("id"));
                    link.setBaseItemId((String)((LinkedHashMap)mirror).get("baseItemId"));
                    link.setArchive(((Boolean)((LinkedHashMap)mirror).get("archive")).booleanValue());
                    link.setReleaseTrainId((String)((LinkedHashMap)mirror).get("releaseTrainId"));
                    link.setTeamId((String)((LinkedHashMap)mirror).get("teamId"));
                    link.setLinkedItemById((Map)((LinkedHashMap)mirror).get("linkedItemById"));
                    if (PropertyValidator.isValid(((LinkedHashMap)mirror).get("createdOn"))) {
                        link.setCreatedOn(new Date((String)((LinkedHashMap)mirror).get("createdOn")));
                    }
                    linksList.add(link);
                }
            }
            baseItem.setBaseItemLinks(linksList);
            if (staticFields.containsKey("status")) {
                if (staticFields.get("status") instanceof StatusMirror) {
                    Status status = new Status();
                    StatusMirror statusMirror = (StatusMirror)staticFields.get("status");
                    status.setCategory(statusMirror.getCategory());
                    baseItem.setStatus(status);
                } else if (staticFields.get("status") instanceof LinkedHashMap) {
                    LinkedHashMap statusMirror = (LinkedHashMap)staticFields.get("status");
                    Status status = new Status();
                    status.setCategory((String)statusMirror.get("category"));
                    baseItem.setStatus(status);
                }
            }
            baseItems.add(baseItem);
        }
        cursor.close();
        return baseItems;
    }

    public List<BacklogItem> fetchBacklogItems(DBObject query, String backlogItemCollection, boolean allowDuplicates, int sortOrder) throws Exception {
        ArrayList<BacklogItem> backlogItems = new ArrayList<BacklogItem>();
        DBCollection collection = this.mongoTemplate.getCollection(backlogItemCollection);
        DBCursor cursor = collection.find(query).sort((DBObject)new BasicDBObject("eventTime", (Object)sortOrder));
        HashSet uniqueItemIds = new HashSet();
        while (cursor.hasNext()) {
            Object teamMap;
            DBObject dbObject = (DBObject)cursor.next();
            String itemId = (String)dbObject.get("itemId");
            if (uniqueItemIds.contains(itemId) && !allowDuplicates) continue;
            BacklogItem backlogItem = new BacklogItem();
            backlogItem.setId(itemId);
            backlogItem.setCreatedOn((Date)dbObject.get("eventTime"));
            backlogItem.setTitle((String)dbObject.get("title"));
            backlogItem.setKey((String)dbObject.get("key"));
            backlogItem.setAlmKey((String)dbObject.get("almKey"));
            backlogItem.setAlmType((String)dbObject.get("almType"));
            if (dbObject.containsField("jiraKey")) {
                backlogItem.setAlmKey((String)dbObject.get("jiraKey"));
            }
            if (dbObject.containsField("tfsId")) {
                backlogItem.setAlmKey((String)dbObject.get("tfsId"));
            }
            backlogItem.setAlmFields(new HashMap());
            backlogItem.setStarred(Boolean.valueOf(false));
            backlogItem.setIsDefaultGroup(Boolean.valueOf(false));
            backlogItem.setNotifyWatchers(Boolean.valueOf(true));
            backlogItem.setBacklogItemsMap(new HashMap());
            backlogItem.setBaseItemLinks(new ArrayList());
            if (dbObject.containsKey("teamContainers")) {
                ArrayList basicTeamsList = (ArrayList)dbObject.get("teamContainers");
                ArrayList<Team> teams = new ArrayList<Team>();
                if (PropertyValidator.isValid((Collection)basicTeamsList)) {
                    for (Object obj : basicTeamsList) {
                        BasicDBObject dbTeamObject;
                        if (!(obj instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(dbTeamObject = (BasicDBObject)obj)) || !PropertyValidator.isValid((Object)(teamMap = (Map)dbTeamObject.get("team")))) continue;
                        Team team = new Team();
                        team.setId(teamMap.get("_id").toString());
                        team.setArchive(((Boolean)teamMap.get("archive")).booleanValue());
                        team.setRowStatus(((Integer)teamMap.get("rowStatus")).intValue());
                        teams.add(team);
                    }
                }
                backlogItem.setTeamData(teams);
            }
            ArrayList<BaseItemLink> links = new ArrayList<BaseItemLink>();
            Map staticFields = (Map)dbObject.get("staticFields");
            if (PropertyValidator.isValid((Object)staticFields)) {
                BaseItemLink link;
                BasicDBObject mirror;
                Map issueType;
                Map jiraFieldByKey;
                Map issueType2;
                if (staticFields.containsKey("archive")) {
                    backlogItem.setArchive(((Boolean)staticFields.get("archive")).booleanValue());
                }
                if (PropertyValidator.isValid(staticFields.get("issueType")) && PropertyValidator.isValid((Object)(issueType2 = (Map)staticFields.get("issueType")))) {
                    backlogItem.setType((String)issueType2.get("id"));
                }
                if (PropertyValidator.isValid(staticFields.get("jiraFieldByKey")) && PropertyValidator.isValid((Object)(jiraFieldByKey = (Map)staticFields.get("jiraFieldByKey"))) && PropertyValidator.isValid((Object)(issueType = (Map)jiraFieldByKey.get("issuetype")))) {
                    backlogItem.setIssueType((String)issueType.get("name"));
                }
                backlogItem.setCompletionCriteria((String)staticFields.get("completionCriteria"));
                backlogItem.setStoryPoints((Double)staticFields.get("storyPoints"));
                if (null == backlogItem.getStoryPoints()) {
                    backlogItem.setStoryPoints((Double)staticFields.get("customfield_10005"));
                }
                backlogItem.setLinkedCardWeights(staticFields.getOrDefault("linkedCardWeights", 1.0));
                if (staticFields.containsKey("keyResultRelations")) {
                    links.addAll((ArrayList)staticFields.get("keyResultRelations"));
                }
                if (staticFields.containsKey("objectiveRelations")) {
                    links.addAll((ArrayList)staticFields.get("objectiveRelations"));
                }
                if (staticFields.containsKey("archive")) {
                    backlogItem.setArchive(((Boolean)staticFields.get("archive")).booleanValue());
                }
                if (staticFields.containsKey("fields")) {
                    backlogItem.setFields((Map)staticFields.get("fields"));
                }
                Map childRelationMap = (Map)staticFields.get("childRelationMap");
                Map artRelationMap = (Map)staticFields.get("artRelationMap");
                HashMap childRelations = new HashMap();
                if (null != childRelationMap && !childRelationMap.isEmpty()) {
                    teamMap = childRelationMap.entrySet().iterator();
                    while (teamMap.hasNext()) {
                        Map.Entry objEntry = (Map.Entry)teamMap.next();
                        Object obj = objEntry.getValue();
                        links.addAll((ArrayList)obj);
                        if (!(obj instanceof BasicDBList)) continue;
                        for (Object listObj : (BasicDBList)obj) {
                            BasicDBObject mirror2 = (BasicDBObject)listObj;
                            BaseItemLink link2 = new BaseItemLink();
                            link2.setSessionId((String)mirror2.get("sessionId"));
                            link2.setLinkType((String)mirror2.get("linkType"));
                            link2.setWeightage((Double)mirror2.get("weightage"));
                            link2.setId((String)mirror2.get("id"));
                            link2.setArchive(((Boolean)mirror2.get("archive")).booleanValue());
                            link2.setBaseItemId((String)mirror2.get("baseItemId"));
                            if (mirror2.get("backlogItemId") instanceof ObjectId) {
                                link2.setBacklogItemId((ObjectId)mirror2.get("backlogItemId"));
                            } else if (mirror2.get("backlogItemId") instanceof String) {
                                link2.setBacklogItemId(new ObjectId((String)mirror2.get("backlogItemId")));
                            }
                            link2.setReleaseTrainId((String)mirror2.get("releaseTrainId"));
                            if (mirror2.containsKey("rowStatus")) {
                                if (mirror2.get("rowStatus") instanceof Double) {
                                    double rowStatus = (Double)mirror2.get("rowStatus");
                                    link2.setRowStatus((int)rowStatus);
                                } else if (mirror2.get("rowStatus") instanceof Integer) {
                                    link2.setRowStatus(((Integer)mirror2.get("rowStatus")).intValue());
                                }
                            } else {
                                link2.setRowStatus(0);
                            }
                            link2.setTenant((String)mirror2.get("tenant"));
                            List tempLinks = childRelations.getOrDefault(objEntry.getKey(), new ArrayList());
                            tempLinks.add(link2);
                            childRelations.put(objEntry.getKey(), tempLinks);
                        }
                    }
                }
                backlogItem.setChildRelationMap(childRelations);
                ArrayList<BaseItemLink> sectionRelations = new ArrayList<BaseItemLink>();
                BasicDBList sectionRelationsList = (BasicDBList)staticFields.get("sectionRelations");
                if (PropertyValidator.isValid((Collection)sectionRelationsList)) {
                    for (Object listObj : sectionRelationsList) {
                        mirror = (BasicDBObject)listObj;
                        link = new BaseItemLink();
                        link.setLinkType((String)mirror.get("linkType"));
                        link.setWeightage((Double)mirror.get("weightage"));
                        link.setId((String)mirror.get("id"));
                        link.setArchive(((Boolean)mirror.get("archive")).booleanValue());
                        link.setBaseItemId((String)mirror.get("baseItemId"));
                        if (mirror.get("baseItemId") instanceof String) {
                            link.setBaseItemId((String)mirror.get("baseItemId"));
                        }
                        if (mirror.containsKey("rowStatus")) {
                            if (mirror.get("rowStatus") instanceof Double) {
                                double rowStatus = (Double)mirror.get("rowStatus");
                                link.setRowStatus((int)rowStatus);
                            } else if (mirror.get("rowStatus") instanceof Integer) {
                                link.setRowStatus(((Integer)mirror.get("rowStatus")).intValue());
                            }
                        } else {
                            link.setRowStatus(0);
                        }
                        link.setTenant((String)mirror.get("tenant"));
                        sectionRelations.add(link);
                    }
                }
                backlogItem.setSectionRelations(sectionRelations);
                if (artRelationMap != null && !artRelationMap.isEmpty()) {
                    for (Iterator obj : artRelationMap.values()) {
                        if (obj instanceof BasicDBObject) {
                            mirror = (BasicDBObject)obj;
                            link = new BaseItemLinkMirror();
                            link.setSessionId((String)mirror.get("sessionId"));
                            link.setLinkType((String)mirror.get("linkType"));
                            link.setWeightage((Double)mirror.get("weightage"));
                            link.setId((String)mirror.get("id"));
                            link.setArchive(((Boolean)mirror.get("archive")).booleanValue());
                            link.setBaseItemId((String)mirror.get("baseItemId"));
                            if (mirror.get("backlogItemId") instanceof ObjectId) {
                                link.setBacklogItemId((ObjectId)mirror.get("backlogItemId"));
                            } else if (mirror.get("backlogItemId") instanceof String) {
                                link.setBacklogItemId(new ObjectId((String)mirror.get("backlogItemId")));
                            }
                            link.setReleaseTrainId((String)mirror.get("releaseTrainId"));
                            if (mirror.containsKey("rowStatus")) {
                                if (mirror.get("rowStatus") instanceof Double) {
                                    double rowStatus = (Double)mirror.get("rowStatus");
                                    link.setRowStatus(Integer.valueOf((int)rowStatus));
                                } else if (mirror.get("rowStatus") instanceof Integer) {
                                    link.setRowStatus(Integer.valueOf((Integer)mirror.get("rowStatus")));
                                }
                            } else {
                                link.setRowStatus(Integer.valueOf(0));
                            }
                            links.add(link);
                            continue;
                        }
                        links.addAll((ArrayList)((Object)obj));
                    }
                }
                if (!links.isEmpty()) {
                    Iterator obj;
                    ArrayList<BaseItemLink> linksList = new ArrayList<BaseItemLink>();
                    obj = links.iterator();
                    while (obj.hasNext()) {
                        Object mirror3;
                        Object obj2 = obj.next();
                        if (obj2 instanceof BaseItemLinkMirror) {
                            link = new BaseItemLink();
                            mirror3 = (BaseItemLinkMirror)obj2;
                            link.setSessionId(mirror3.getSessionId());
                            link.setBaseItemId(mirror3.getBaseItemId());
                            link.setBacklogItemId(mirror3.getBacklogItemId());
                            link.setLinkType(mirror3.getLinkType());
                            link.setWeightage(mirror3.getWeightage());
                            link.setId(mirror3.getId());
                            link.setArchive(mirror3.isArchive());
                            link.setReleaseTrainId(mirror3.getReleaseTrainId());
                            link.setRowStatus(mirror3.getRowStatus().intValue());
                            link.setLinkedItemById(mirror3.getLinkedItemById());
                            linksList.add(link);
                            continue;
                        }
                        if (!(obj2 instanceof LinkedHashMap)) continue;
                        link = new BaseItemLink();
                        mirror3 = (LinkedHashMap)obj2;
                        link.setSessionId((String)((LinkedHashMap)mirror3).get("sessionId"));
                        link.setLinkType((String)((LinkedHashMap)mirror3).get("linkType"));
                        link.setWeightage((Double)((LinkedHashMap)mirror3).get("weightage"));
                        link.setId((String)((LinkedHashMap)mirror3).get("id"));
                        link.setArchive(((Boolean)((LinkedHashMap)mirror3).get("archive")).booleanValue());
                        link.setBaseItemId((String)((LinkedHashMap)mirror3).get("baseItemId"));
                        if (((LinkedHashMap)mirror3).get("backlogItemId") instanceof ObjectId) {
                            link.setBacklogItemId((ObjectId)((LinkedHashMap)mirror3).get("backlogItemId"));
                        } else if (((LinkedHashMap)mirror3).get("backlogItemId") instanceof String) {
                            link.setBacklogItemId(new ObjectId((String)((LinkedHashMap)mirror3).get("backlogItemId")));
                        }
                        link.setReleaseTrainId((String)((LinkedHashMap)mirror3).get("releaseTrainId"));
                        if (((HashMap)mirror3).containsKey("rowStatus")) {
                            if (((LinkedHashMap)mirror3).get("rowStatus") instanceof Double) {
                                double rowStatus = (Double)((LinkedHashMap)mirror3).get("rowStatus");
                                link.setRowStatus((int)rowStatus);
                            } else if (((LinkedHashMap)mirror3).get("rowStatus") instanceof Integer) {
                                link.setRowStatus(((Integer)((LinkedHashMap)mirror3).get("rowStatus")).intValue());
                            }
                        } else {
                            link.setRowStatus(0);
                        }
                        link.setLinkedItemById((Map)((LinkedHashMap)mirror3).get("linkedItemById"));
                        linksList.add(link);
                    }
                    backlogItem.setBaseItemLinks(linksList);
                }
                if (staticFields.containsKey("status")) {
                    if (staticFields.get("status") instanceof StatusMirror) {
                        Status status = new Status();
                        StatusMirror statusMirror = (StatusMirror)staticFields.get("status");
                        if (PropertyValidator.isValid((Object)statusMirror)) {
                            status.setCategory(statusMirror.getCategory());
                            status.setId(statusMirror.getId());
                        }
                        backlogItem.setStatus(status);
                    } else if (staticFields.get("status") instanceof LinkedHashMap) {
                        LinkedHashMap statusMirror = (LinkedHashMap)staticFields.get("status");
                        Status status = new Status();
                        if (PropertyValidator.isValid((Object)statusMirror)) {
                            status.setCategory((String)statusMirror.get("category"));
                            status.setId((String)statusMirror.get("id"));
                        }
                        backlogItem.setStatus(status);
                    }
                    if (staticFields.containsKey("parent")) {
                        backlogItem.setParentMap((Map)staticFields.get("parent"));
                    }
                }
            }
            backlogItems.add(backlogItem);
        }
        cursor.close();
        return backlogItems;
    }

    public List<Board> fetchRoadmaps(DBObject query, String boardCollection, boolean allowDuplicates, int sortOrder) throws Exception {
        ArrayList<Board> boards = new ArrayList<Board>();
        DBCollection collection = this.mongoTemplate.getCollection(boardCollection);
        DBCursor cursor = collection.find(query).sort((DBObject)new BasicDBObject("eventTime", (Object)sortOrder));
        HashSet<String> uniqueItemIds = new HashSet<String>();
        while (cursor.hasNext()) {
            DBObject dbObject = (DBObject)cursor.next();
            String itemId = (String)dbObject.get("itemId");
            if (uniqueItemIds.contains(itemId) && !allowDuplicates) continue;
            uniqueItemIds.add(itemId);
            Board board = new Board();
            board.setId(itemId);
            board.setCreatedOn((Date)dbObject.get("eventTime"));
            board.setName((String)dbObject.get("name"));
            board.setKey((String)dbObject.get("key"));
            board.setArchive(((Boolean)dbObject.get("archive")).booleanValue());
            Map staticFields = (Map)dbObject.get("staticFields");
            board.setLinkedBacklogItems(new ArrayList());
            if (PropertyValidator.isValid((Object)staticFields) && staticFields.containsKey("linkedBacklogItems")) {
                List linkedBacklogItems = (List)staticFields.get("linkedBacklogItems");
                board.setLinkedBacklogItems(linkedBacklogItems);
            }
            boards.add(board);
        }
        cursor.close();
        return boards;
    }

    public Map<Date, Map<String, BaseItem>> fetchObjectivesCompleteData(List<BaseItem> mappedObjs, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String criteriaCalculation, String tenant, Date startDate, Date endDate, boolean isPiView, List<Fields> fields, boolean isOkrEnabled, Map<String, Object> excludeItemsData, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        Map datedObjectivesMap = this.mapBaseItemLogsToDates(mappedObjs, intervalDates, interval);
        if (isOkrEnabled) {
            LOGGER.debug("Going to hunt key results against objective");
            Map datedLinkedObjsMap = this.fetchObjectiveLinkedObjectives(mappedObjs, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
            Map datedKeyResultsMap = this.fetchObjectiveLinkedKeyResults(mappedObjs, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
            if (null != datedKeyResultsMap && null != datedObjectivesMap) {
                datedObjectivesMap.forEach((key, value) -> {
                    if (null != value && null != datedKeyResultsMap.get(key)) {
                        for (BaseItem item : ((Map)datedKeyResultsMap.get(key)).values()) {
                            List links = item.getBaseItemLinks();
                            String baseItemId = links.stream().filter(b -> EnumKendis.PARENT_OBJECTIVE.getCode().equalsIgnoreCase(b.getLinkType())).findFirst().map(BaseItemLink::getBaseItemId).orElse("");
                            boolean archive = item.isArchive();
                            if (!value.containsKey(baseItemId) || archive) continue;
                            ((BaseItem)value.get(baseItemId)).getBaseItemsMap().put(item.getId(), item);
                        }
                    }
                });
            }
            if (null != datedLinkedObjsMap && null != datedObjectivesMap) {
                datedLinkedObjsMap.forEach((key, value) -> {
                    if (null != value && null != datedObjectivesMap.get(key)) {
                        for (BaseItem item : ((Map)datedObjectivesMap.get(key)).values()) {
                            boolean archive = item.isArchive();
                            if (archive) continue;
                            List links = item.getBaseItemLinks();
                            HashSet<String> baseItemIds = new HashSet<String>();
                            for (BaseItemLink link : links) {
                                if (!EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                                baseItemIds.add(link.getBaseItemId());
                            }
                            for (String baseItemId : baseItemIds) {
                                BaseItem tempObj;
                                boolean isLinkedObjArchive;
                                if (!value.containsKey(baseItemId) || (isLinkedObjArchive = (tempObj = (BaseItem)value.get(baseItemId)).isArchive())) continue;
                                item.getObjectivesMap().put(tempObj.getId(), tempObj);
                            }
                        }
                    }
                });
            }
        }
        boolean[] isPiObj = new boolean[]{false};
        LOGGER.debug("Going to hunt backlog items against objective");
        Map datedBacklogItemsMap = this.fetchObjectiveLinkedBacklogItems(mappedObjs, itemKeys, itemTitles, intervalDates, interval, tenant, startDate, endDate, isPiView, excludeItemsData, isPiObj, syncDate, sessionBoardId, sessionId);
        LOGGER.debug("Linking items against objective");
        if (null != datedBacklogItemsMap) {
            datedBacklogItemsMap.forEach((key, value) -> {
                if (null != value && null != datedObjectivesMap.get(key)) {
                    for (BaseItem item : ((Map)datedObjectivesMap.get(key)).values()) {
                        List links = item.getBaseItemLinks();
                        for (BaseItemLink link : links) {
                            Map linkedItemByIdsMap;
                            if (!EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)(linkedItemByIdsMap = link.getLinkedItemById()))) continue;
                            Set OBJBacklogItemIds = linkedItemByIdsMap.keySet();
                            for (String backlogItemID : OBJBacklogItemIds) {
                                if (!value.containsKey(backlogItemID)) continue;
                                BacklogItem backlogItem = (BacklogItem)value.get(backlogItemID);
                                boolean isArchive = link.isArchive();
                                boolean itemArchive = backlogItem.isArchive();
                                int rowStatus = Optional.ofNullable(backlogItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(0);
                                if (PropertyValidator.isValid((Collection)backlogItem.getBaseItemLinks())) {
                                    String releaseTrainId = backlogItem.getBaseItemLinks().stream().filter(l -> EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getReleaseTrainId).findFirst().orElse("");
                                    Status status = backlogItem.getStatus();
                                    if (PropertyValidator.isValid((Object)status) && PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                                        status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                                    }
                                }
                                if (rowStatus != 0 || isArchive || itemArchive) continue;
                                item.getBacklogItemsMap().computeIfAbsent(backlogItem.getId(), l -> new ArrayList()).add(backlogItem);
                            }
                        }
                    }
                }
            });
            LOGGER.debug("Linking backlog items against objective");
            datedBacklogItemsMap.forEach((key, value) -> {
                if (null != value && null != datedObjectivesMap.get(key)) {
                    for (BaseItem item : ((Map)datedObjectivesMap.get(key)).values()) {
                        List links = item.getBaseItemLinks();
                        List OBJBacklogItemIds = links.stream().filter(b -> EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(b.getLinkType())).map(BaseItemLink::getBaseItemId).collect(Collectors.toList());
                        boolean archive = item.isArchive();
                        for (String backlogItemID : OBJBacklogItemIds) {
                            BacklogItem backlogItem;
                            int rowStatus;
                            if (!value.containsKey(backlogItemID) || archive || (rowStatus = Optional.ofNullable(backlogItem = (BacklogItem)value.get(backlogItemID)).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(1).intValue()) != 0) continue;
                            item.getBacklogItemsMap().computeIfAbsent(backlogItem.getId(), l -> new ArrayList()).add(backlogItem);
                        }
                    }
                }
            });
        }
        return datedObjectivesMap;
    }

    public Map<Date, Map<String, BaseItem>> fetchObjectiveLinkedObjectives(List<BaseItem> mappedObjs, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String criteriaCalculation, String tenant, Date startDate, Date endDate, boolean isPiView, List<Fields> fields, boolean isOkrEnabled, Map<String, Object> excludeItemsData, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        HashSet objLinkedObjs = new HashSet();
        for (BaseItem obj : mappedObjs) {
            objLinkedObjs.addAll(obj.getBaseItemLinks().stream().filter(l -> EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList()));
        }
        if (objLinkedObjs.isEmpty()) {
            return null;
        }
        BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedObjs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedObjs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        List fetchedObjs = this.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
        fetchedObjs.addAll(this.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
        if ("current".equalsIgnoreCase(criteriaCalculation)) {
            Map<String, List<BaseItem>> groupedById = fetchedObjs.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            for (List<BaseItem> group : groupedById.values()) {
                BaseItem latestItem = group.stream().max(Comparator.comparing(BaseEntity::getCreatedOn)).orElse(null);
                if (latestItem == null) continue;
                String latestCompletionCriteria = latestItem.getCompletionCriteria();
                for (BaseItem item : group) {
                    item.setCompletionCriteria(latestCompletionCriteria);
                }
            }
        }
        if (PropertyValidator.isValid((Collection)fetchedObjs)) {
            return this.fetchObjectivesCompleteData(fetchedObjs, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
        }
        return null;
    }

    public Map<Date, Map<String, BacklogItem>> fetchObjectiveLinkedBacklogItems(List<BaseItem> mappedObjs, Map<String, String> itemKeys, Map<String, String> itemTitles, List<Date> intervalDates, String interval, String tenant, Date startDate, Date endDate, boolean isPiView, Map<String, Object> excludeItemsData, boolean[] isPiObj, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        HashSet<String> attachedSessionIds = new HashSet<String>();
        attachedSessionIds.add(sessionId);
        HashSet<String> objLinkedBLItemsIDs = new HashSet<String>();
        HashSet objLinkedItemIds = new HashSet();
        HashSet<String> tfsIds = new HashSet<String>();
        HashSet<String> jiraKeys = new HashSet<String>();
        List mappedBIBacklogItems = new ArrayList();
        HashSet<String> attachedReleaseTrains = new HashSet<String>();
        for (BaseItem baseItem : mappedObjs) {
            for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                if (EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(baseItemLink.getLinkType()) && null != baseItemLink.getLinkedItemById() && !baseItemLink.getLinkedItemById().isEmpty()) {
                    objLinkedItemIds.addAll(baseItemLink.getLinkedItemById().keySet());
                    Map linkedItems = baseItemLink.getLinkedItemById();
                    for (Map.Entry entry : linkedItems.entrySet()) {
                        Map linkedItem = (Map)entry.getValue();
                        if (linkedItem.containsKey("jiraKey")) {
                            jiraKeys.add((String)linkedItem.get("jiraKey"));
                        }
                        if (linkedItem.containsKey("tfsId")) {
                            tfsIds.add((String)linkedItem.get("tfsId"));
                        }
                        attachedSessionIds.add((String)linkedItem.get("session_id"));
                    }
                    isPiObj[0] = true;
                    isPiView = true;
                }
                if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(baseItemLink.getLinkType())) continue;
                objLinkedBLItemsIDs.add(baseItemLink.getBaseItemId());
                if (PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId())) {
                    attachedReleaseTrains.add(baseItemLink.getReleaseTrainId());
                } else {
                    LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{baseItem.getKey(), baseItem.getId(), baseItem.getCreatedOn()});
                }
                isPiObj[0] = false;
                isPiView = false;
            }
            itemKeys.put(baseItem.getId(), baseItem.getKey());
            itemTitles.put(baseItem.getId(), baseItem.getTitle());
        }
        LOGGER.info("Objective linked backlog itemIds size :{}", (Object)objLinkedBLItemsIDs.size());
        LOGGER.info("Objective linked item ids size :{}", (Object)objLinkedItemIds.size());
        if (!(objLinkedBLItemsIDs.isEmpty() && tfsIds.isEmpty() && jiraKeys.isEmpty() && objLinkedItemIds.isEmpty())) {
            Date key;
            Map value;
            BasicDBObject queryEarliest;
            BasicDBObject query;
            if (!objLinkedBLItemsIDs.isEmpty()) {
                LOGGER.debug("Querying with backlog itemids");
                query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedBLItemsIDs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedBLItemsIDs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                mappedBIBacklogItems = this.fetchBacklogItems((DBObject)queryEarliest, "backlogItemTimeSeries", false, -1);
                mappedBIBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, "backlogItemTimeSeries", true, 1));
                LOGGER.info("Objective linked backlog items found of size :{}", (Object)mappedBIBacklogItems.size());
            }
            if (!objLinkedItemIds.isEmpty()) {
                query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedItemIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objLinkedItemIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                mappedBIBacklogItems.addAll(this.fetchBacklogItems((DBObject)queryEarliest, "itemTimeSeries", false, -1));
                mappedBIBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, "itemTimeSeries", true, 1));
                LOGGER.info("Objective linked items found of size :{}", (Object)mappedBIBacklogItems.size());
            }
            if (!tfsIds.isEmpty() && !jiraKeys.isEmpty()) {
                LOGGER.debug("Querying with tfsIds and jira keys");
                BasicDBObject queryEarliest2 = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", tfsIds)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", jiraKeys)))), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                BasicDBObject query2 = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", tfsIds)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", jiraKeys)))), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                mappedBIBacklogItems.addAll(this.fetchBacklogItems((DBObject)queryEarliest2, "itemTimeSeries", false, -1));
                mappedBIBacklogItems.addAll(this.fetchBacklogItems((DBObject)query2, "itemTimeSeries", true, 1));
                LOGGER.info("Objective linked backlog items found of size :{}", (Object)mappedBIBacklogItems.size());
            }
            Map datedBacklogItemsMap = this.mapBackLogItemToDates(mappedBIBacklogItems, intervalDates, interval, isPiView, excludeItemsData);
            Map nestedObjBackLogItems = this.buildBackLogNthLevelHierarchy(mappedBIBacklogItems, intervalDates, tenant, startDate, endDate, interval, isPiView, excludeItemsData, syncDate, attachedReleaseTrains, sessionId, objLinkedItemIds, attachedSessionIds);
            LOGGER.debug("Going to link children items with parent");
            if (null != datedBacklogItemsMap && null != nestedObjBackLogItems) {
                for (Map.Entry entry : datedBacklogItemsMap.entrySet()) {
                    value = (Map)entry.getValue();
                    key = (Date)entry.getKey();
                    LOGGER.debug("Traversing for date: {}", (Object)key);
                    if (null == value || null == nestedObjBackLogItems.get(key)) continue;
                    for (BacklogItem item : ((Map)nestedObjBackLogItems.get(key)).values()) {
                        String parentId;
                        Map parentMap = item.getParentMap();
                        if (!PropertyValidator.isValid((Object)parentMap) || !PropertyValidator.isValid((Object)(parentId = (String)parentMap.get("id"))) || !value.containsKey(parentId)) continue;
                        int rowStatus = Optional.ofNullable(item).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(0);
                        boolean isArchive = item.isArchive();
                        if (PropertyValidator.isValid((Collection)item.getBaseItemLinks())) {
                            String releaseTrainId = item.getBaseItemLinks().stream().filter(l -> EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getReleaseTrainId).findFirst().orElse("");
                            Status status = item.getStatus();
                            if (PropertyValidator.isValid((Object)status) && PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                                status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                            }
                        }
                        if (rowStatus != 0 || isArchive || ((BacklogItem)value.get(parentId)).getBacklogItemsMap().containsKey(item.getId())) continue;
                        BaseItem parent = (BaseItem)value.get(parentId);
                        LOGGER.debug("Adding item to parent with key : {} and id : {} and child with almKey : {} and id: {} ", new Object[]{parent.getKey(), parent.getId(), item.getAlmKey(), item.getId()});
                        parent.getBacklogItemsMap().computeIfAbsent(item.getId(), l -> new ArrayList()).add(item);
                    }
                }
            }
            LOGGER.debug("Going to link backlog children items with parent");
            if (null != datedBacklogItemsMap && null != nestedObjBackLogItems) {
                for (Map.Entry entry : nestedObjBackLogItems.entrySet()) {
                    value = (Map)entry.getValue();
                    key = (Date)entry.getKey();
                    LOGGER.debug("Traversing for date: {}", (Object)key);
                    if (null == value || null == datedBacklogItemsMap.get(key)) continue;
                    for (BacklogItem item : ((Map)datedBacklogItemsMap.get(key)).values()) {
                        for (String releaseTrain : attachedReleaseTrains) {
                            List links;
                            HashSet childItemIds = new HashSet();
                            if (PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrain))) && PropertyValidator.isValid((Collection)(links = (List)item.getChildRelationMap().get(releaseTrain)))) {
                                childItemIds.addAll(links.stream().filter(l -> EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBacklogItemId).distinct().collect(Collectors.toList()));
                            }
                            if (childItemIds.isEmpty()) continue;
                            for (ObjectId childItemId : childItemIds) {
                                String id = childItemId.toString();
                                if (!value.containsKey(id)) continue;
                                BacklogItem childItem = (BacklogItem)value.get(id);
                                int rowStatus = Optional.ofNullable(childItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType()) && releaseTrain.equalsIgnoreCase(l.getReleaseTrainId())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                boolean isArchive = childItem.isArchive();
                                if (rowStatus != 0 || item.getBacklogItemsMap().containsKey(childItem.getId()) || isArchive) continue;
                                LOGGER.debug("Adding backlogitem to parent with almKey : {} and id : {} and child with almKey : {} and id: {} ", new Object[]{item.getAlmKey(), item.getId(), childItem.getAlmKey(), childItem.getId()});
                                item.getBacklogItemsMap().computeIfAbsent(childItem.getId(), l -> new ArrayList()).add(childItem);
                            }
                        }
                    }
                }
            }
            return datedBacklogItemsMap;
        }
        return null;
    }

    public Map<Date, Map<String, BaseItem>> fetchObjectiveLinkedKeyResults(List<BaseItem> objectives, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String criteriaCalculation, String tenant, Date startDate, Date endDate, boolean isPiView, List<Fields> fields, boolean isOkrEnabled, Map<String, Object> excludeItemsData, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        Map<Date, Map<String, Object>> datedKeyResultsMap = new HashMap<Date, Map<String, BaseItem>>();
        HashSet keyResultIds = new HashSet();
        for (BaseItem baseItem : objectives) {
            keyResultIds.addAll(baseItem.getBaseItemLinks().stream().filter(l -> EnumKendis.CHILD_OBJECTIVE.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList()));
            itemKeys.put(baseItem.getId(), baseItem.getKey());
            itemTitles.put(baseItem.getId(), baseItem.getTitle());
        }
        LOGGER.debug("Key result ids of size :{}  found", (Object)keyResultIds.size());
        if (!keyResultIds.isEmpty()) {
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", keyResultIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", keyResultIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            List mappedKeyResults = this.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
            mappedKeyResults.addAll(this.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
            LOGGER.debug("Key results of size :{}  found", (Object)mappedKeyResults.size());
            if (!mappedKeyResults.isEmpty()) {
                if ("current".equalsIgnoreCase(criteriaCalculation)) {
                    Map<String, List<BaseItem>> groupedById = mappedKeyResults.stream().collect(Collectors.groupingBy(BaseEntity::getId));
                    for (List<BaseItem> group : groupedById.values()) {
                        BaseItem latestItem = group.stream().max(Comparator.comparing(BaseEntity::getCreatedOn)).orElse(null);
                        if (latestItem == null) continue;
                        String latestCompletionCriteria = latestItem.getCompletionCriteria();
                        for (BaseItem item : group) {
                            item.setCompletionCriteria(latestCompletionCriteria);
                        }
                    }
                }
                datedKeyResultsMap = this.fetchKRProgressCriteria(mappedKeyResults, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
            }
        }
        return datedKeyResultsMap;
    }

    private Map<Date, Map<String, BaseItem>> fetchKRProgressCriteria(List<BaseItem> mappedKeyResults, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String criteriaCalculation, String tenant, Date startDate, Date endDate, boolean isPiView, List<Fields> fields, boolean isOkrEnabled, Map<String, Object> excludeItemsData, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        HashSet<String> keyResultsWithLI = new HashSet<String>();
        HashSet<BaseItem> KRWithObjs = new HashSet<BaseItem>();
        Map<Date, Map<String, Object>> datedKeyResultsMap = new HashMap<Date, Map<String, BaseItem>>();
        if (!mappedKeyResults.isEmpty()) {
            Map objLinkedKRMap;
            List keyResultIds = mappedKeyResults.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            Query queryForKRs = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(keyResultIds));
            List fetchedKeyResults = this.mongoTemplate.find(queryForKRs, BaseItem.class);
            HashMap<String, String> krFieldsMap = new HashMap<String, String>();
            block10: for (BaseItem kr : fetchedKeyResults) {
                for (Map.Entry fieldMap : kr.getFields().entrySet()) {
                    String title;
                    if (!(fieldMap.getValue() instanceof String) || !"Target".equalsIgnoreCase(title = (String)fieldMap.getValue()) && !"By Objectives".equalsIgnoreCase(title) && !"By Items".equalsIgnoreCase(title)) continue;
                    krFieldsMap.put(kr.getId(), title);
                    continue block10;
                }
            }
            for (BaseItem kr : mappedKeyResults) {
                if (!PropertyValidator.isValid((Object)kr.getFields())) continue;
                List fieldsIds = kr.getFields().keySet().stream().map(ObjectId::new).collect(Collectors.toList());
                Query queryForFields = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(fieldsIds));
                fields = this.mongoTemplate.find(queryForFields, Fields.class);
                String progressCriteriaId = fields.stream().filter(f -> "Progress Criteria".equalsIgnoreCase(f.getTitle())).map(BaseEntity::getId).findAny().orElse(null);
                itemKeys.put(kr.getId(), kr.getKey());
                itemTitles.put(kr.getId(), kr.getTitle());
                if ((null == kr.getFields() || null == progressCriteriaId) && (!"current".equalsIgnoreCase(criteriaCalculation) || !krFieldsMap.containsKey(kr.getId()))) continue;
                Object progressCriteria = "";
                progressCriteria = "current".equalsIgnoreCase(criteriaCalculation) && krFieldsMap.containsKey(kr.getId()) ? (String)krFieldsMap.get(kr.getId()) : (String)kr.getFields().get(progressCriteriaId);
                kr.getFields().put("progressCriteria", progressCriteria);
                if ("Target".equalsIgnoreCase((String)progressCriteria)) {
                    double targetValue = 0.0;
                    double progressValue = 0.0;
                    double startValue = 0.0;
                    double krCompletion = 0.0;
                    for (Fields groupField : fields) {
                        switch (groupField.getTitle()) {
                            case "Target Value": {
                                if (!PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) break;
                                targetValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
                                break;
                            }
                            case "Progress": {
                                if (!PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) break;
                                progressValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
                                break;
                            }
                            case "Start": {
                                if (!PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) break;
                                startValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
                            }
                        }
                    }
                    if (!Double.isNaN(targetValue) && !Double.isNaN(progressValue) && targetValue > 0.0) {
                        if (Double.isNaN(startValue) || startValue == targetValue) {
                            krCompletion = progressValue / targetValue * 100.0;
                        } else if (!Double.isNaN(startValue)) {
                            krCompletion = startValue < targetValue ? (progressValue - startValue) / (targetValue - startValue) * 100.0 : (startValue - progressValue) / (startValue - targetValue) * 100.0;
                        }
                    }
                    kr.setProgress(krCompletion);
                    continue;
                }
                if ("By Objectives".equalsIgnoreCase((String)progressCriteria)) {
                    KRWithObjs.add(kr);
                    continue;
                }
                if (!"By Items".equalsIgnoreCase((String)progressCriteria)) continue;
                keyResultsWithLI.add(kr.getId());
            }
            datedKeyResultsMap = this.mapBaseItemLogsToDates(mappedKeyResults, intervalDates, interval);
            if (!keyResultsWithLI.isEmpty()) {
                HashSet<String> attachedSessionIds = new HashSet<String>();
                attachedSessionIds.add(sessionId);
                HashSet<String> attachedReleaseTrains = new HashSet<String>();
                HashSet<String> tfsIds = new HashSet<String>();
                HashSet<String> jiraKeys = new HashSet<String>();
                HashSet KRLinkedItems = new HashSet();
                for (BaseItem item : mappedKeyResults) {
                    List links = item.getBaseItemLinks();
                    for (BaseItemLink link : links) {
                        if (EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType())) {
                            Map linkedItemByIdsMap = link.getLinkedItemById();
                            if (PropertyValidator.isValid((Object)linkedItemByIdsMap)) {
                                KRLinkedItems.addAll(linkedItemByIdsMap.keySet());
                                for (Map.Entry entry : linkedItemByIdsMap.entrySet()) {
                                    Map map = (Map)entry.getValue();
                                    if (map.containsKey("jiraKey")) {
                                        jiraKeys.add((String)map.get("jiraKey"));
                                    }
                                    if (map.containsKey("tfsId")) {
                                        tfsIds.add((String)map.get("tfsId"));
                                    }
                                    attachedSessionIds.add((String)map.get("session_id"));
                                }
                            }
                            isPiView = true;
                        }
                        if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                        if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                            attachedReleaseTrains.add(link.getReleaseTrainId());
                        } else {
                            LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{item.getKey(), item.getId(), item.getCreatedOn()});
                        }
                        isPiView = false;
                    }
                }
                if (!(KRLinkedItems.isEmpty() && tfsIds.isEmpty() && jiraKeys.isEmpty())) {
                    ArrayList mappedKRBacklogItems = new ArrayList();
                    if (!KRLinkedItems.isEmpty()) {
                        BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", KRLinkedItems)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                        BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", KRLinkedItems)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                        mappedKRBacklogItems.addAll(this.fetchBacklogItems((DBObject)queryEarliest, "itemTimeSeries", false, -1));
                        mappedKRBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, "itemTimeSeries", true, 1));
                    }
                    if (!tfsIds.isEmpty() || !jiraKeys.isEmpty()) {
                        BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", tfsIds)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", jiraKeys)))), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                        BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", tfsIds)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", jiraKeys)))), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList(attachedSessionIds)))));
                        mappedKRBacklogItems.addAll(this.fetchBacklogItems((DBObject)queryEarliest, "itemTimeSeries", false, -1));
                        mappedKRBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, "itemTimeSeries", true, 1));
                    }
                    Map datedKRBacklogItemsMap = this.mapBackLogItemToDates(mappedKRBacklogItems, intervalDates, interval, true, excludeItemsData);
                    Map nestedKRBackLogItems = this.buildBackLogNthLevelHierarchy(mappedKRBacklogItems, intervalDates, tenant, startDate, endDate, interval, true, excludeItemsData, syncDate, attachedReleaseTrains, sessionId, KRLinkedItems, attachedSessionIds);
                    if (null != datedKRBacklogItemsMap && null != nestedKRBackLogItems) {
                        for (Map.Entry backlogItemEntry : datedKRBacklogItemsMap.entrySet()) {
                            Map value2 = (Map)backlogItemEntry.getValue();
                            Date key2 = (Date)backlogItemEntry.getKey();
                            LOGGER.debug("Traversing for date: {}", (Object)key2);
                            if (null == value2 || null == nestedKRBackLogItems.get(key2)) continue;
                            for (BacklogItem backlogItem : ((Map)nestedKRBackLogItems.get(key2)).values()) {
                                int rowStatus;
                                String parentId;
                                Map parentMap = backlogItem.getParentMap();
                                if (!PropertyValidator.isValid((Object)parentMap) || !PropertyValidator.isValid((Object)(parentId = (String)parentMap.get("id"))) || !value2.containsKey(parentId) || (rowStatus = Optional.ofNullable(backlogItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(0).intValue()) != 0 || ((BacklogItem)value2.get(parentId)).getBacklogItemsMap().containsKey(backlogItem.getId())) continue;
                                BaseItem parent = (BaseItem)value2.get(parentId);
                                LOGGER.debug("Adding item to parent with key : {} and id : {} and child with almKey : {} and id: {} ", new Object[]{parent.getKey(), parent.getId(), backlogItem.getAlmKey(), backlogItem.getId()});
                                parent.getBacklogItemsMap().computeIfAbsent(backlogItem.getId(), l -> new ArrayList()).add(backlogItem);
                            }
                        }
                    }
                    if (null != datedKRBacklogItemsMap && null != datedKeyResultsMap) {
                        for (Map.Entry entry : datedKRBacklogItemsMap.entrySet()) {
                            Map value3 = (Map)entry.getValue();
                            Date key2 = (Date)entry.getKey();
                            if (null == value3 || null == datedKeyResultsMap.get(key2)) continue;
                            for (BaseItem baseItem : datedKeyResultsMap.get(key2).values()) {
                                List links = baseItem.getBaseItemLinks();
                                for (BaseItemLink link : links) {
                                    Map linkedItemByIdsMap;
                                    if (!EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)(linkedItemByIdsMap = link.getLinkedItemById()))) continue;
                                    Set OBJBacklogItemIds = linkedItemByIdsMap.keySet();
                                    for (String backlogItemID : OBJBacklogItemIds) {
                                        BacklogItem backlogItem;
                                        boolean archive = link.isArchive();
                                        if (!value3.containsKey(backlogItemID) || archive || (backlogItem = (BacklogItem)value3.get(backlogItemID)).isArchive()) continue;
                                        baseItem.getBacklogItemsMap().computeIfAbsent(backlogItem.getId(), l -> new ArrayList()).add(backlogItem);
                                    }
                                }
                            }
                        }
                    }
                }
                BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("staticFields.keyResultRelations", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("baseItemId", (Object)new BasicDBObject("$in", keyResultsWithLI)))), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("staticFields.keyResultRelations", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("baseItemId", (Object)new BasicDBObject("$in", keyResultsWithLI)))), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                List mappedKRBacklogItems = this.fetchBacklogItems((DBObject)queryEarliest, backlogItemCollection, false, -1);
                mappedKRBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, backlogItemCollection, true, 1));
                if (!mappedKRBacklogItems.isEmpty()) {
                    Map datedKRBacklogItemsMap = this.mapBackLogItemToDates(mappedKRBacklogItems, intervalDates, interval, isPiView, excludeItemsData);
                    Map nestedKRBackLogItems = this.buildBackLogNthLevelHierarchy(mappedKRBacklogItems, intervalDates, tenant, startDate, endDate, interval, isPiView, excludeItemsData, syncDate, attachedReleaseTrains, sessionId, KRLinkedItems, attachedSessionIds);
                    if (null != nestedKRBackLogItems && null != datedKRBacklogItemsMap) {
                        nestedKRBackLogItems.forEach((key, value) -> {
                            if (null != value && null != datedKRBacklogItemsMap.get(key)) {
                                LOGGER.debug("Traversing nested KR items for date: {}", key);
                                for (BacklogItem item : ((Map)datedKRBacklogItemsMap.get(key)).values()) {
                                    for (String releaseTrain : attachedReleaseTrains) {
                                        HashSet<ObjectId> childItemIds = new HashSet<ObjectId>();
                                        if (PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrain)))) {
                                            List links = (List)item.getChildRelationMap().get(releaseTrain);
                                            for (BaseItemLink link : links) {
                                                if (!EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBacklogItemId())) continue;
                                                childItemIds.add(link.getBacklogItemId());
                                            }
                                        }
                                        if (childItemIds.isEmpty()) continue;
                                        for (ObjectId childItemId : childItemIds) {
                                            String id = childItemId.toString();
                                            if (!value.containsKey(id)) continue;
                                            BacklogItem childItem = (BacklogItem)value.get(id);
                                            boolean isArchive = childItem.isArchive();
                                            int rowStatus = Optional.ofNullable(childItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType()) && releaseTrain.equalsIgnoreCase(l.getReleaseTrainId())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                            if (rowStatus != 0 || isArchive || item.getBacklogItemsMap().containsKey(childItem.getId())) continue;
                                            item.getBacklogItemsMap().computeIfAbsent(childItem.getId(), l -> new ArrayList()).add(childItem);
                                        }
                                    }
                                }
                            }
                        });
                    }
                    Map<Date, Map<String, Object>> finalDatedKeyResultsMap = datedKeyResultsMap;
                    datedKRBacklogItemsMap.forEach((date, backLogItemMap) -> {
                        if (null != backLogItemMap && null != finalDatedKeyResultsMap.get(date)) {
                            for (BaseItem KR : ((Map)finalDatedKeyResultsMap.get(date)).values()) {
                                List links = KR.getBaseItemLinks();
                                List KRBacklogItemIds = links.stream().filter(b -> EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(b.getLinkType())).map(BaseItemLink::getBaseItemId).collect(Collectors.toList());
                                for (String KRBacklogItemID : KRBacklogItemIds) {
                                    if (!backLogItemMap.containsKey(KRBacklogItemID)) continue;
                                    BacklogItem item = (BacklogItem)backLogItemMap.get(KRBacklogItemID);
                                    int rowStatus = Optional.ofNullable(item).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                    if (item.isArchive() || rowStatus != 0) continue;
                                    KR.getBacklogItemsMap().computeIfAbsent(((BacklogItem)backLogItemMap.get(KRBacklogItemID)).getId(), l -> new ArrayList()).add(item);
                                }
                            }
                        }
                    });
                }
            }
            if (!KRWithObjs.isEmpty() && null != (objLinkedKRMap = this.fetchKRLinkedObj(mappedKeyResults, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId))) {
                Map<Date, Map<String, Object>> finalDatedKeyResultsMap1 = datedKeyResultsMap;
                objLinkedKRMap.forEach((key, value) -> {
                    if (null != value && null != finalDatedKeyResultsMap1.get(key)) {
                        for (BaseItem item : ((Map)finalDatedKeyResultsMap1.get(key)).values()) {
                            List links = item.getBaseItemLinks();
                            List KRLinkedObjIds = links.stream().filter(b -> EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(b.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList());
                            for (String KRLinkedObjId : KRLinkedObjIds) {
                                BaseItem obj;
                                if (null == KRLinkedObjId || !value.containsKey(KRLinkedObjId) || (obj = (BaseItem)value.get(KRLinkedObjId)).isArchive()) continue;
                                BaseItemLink latestLinkEntry = null;
                                for (BaseItemLink link : obj.getBaseItemLinks()) {
                                    if (!item.getId().equalsIgnoreCase(link.getBaseItemId())) continue;
                                    if (!PropertyValidator.isValid(latestLinkEntry) || link.getCreatedOn().after(latestLinkEntry.getCreatedOn())) {
                                        latestLinkEntry = link;
                                    }
                                    if (!PropertyValidator.isValid((Object)link) || link.isArchive()) continue;
                                    item.getBaseItemsMap().put(obj.getId(), obj);
                                }
                            }
                        }
                    }
                });
            }
        }
        return datedKeyResultsMap;
    }

    public Map<Date, Map<String, BaseItem>> fetchKRLinkedObj(List<BaseItem> mappedKeyResults, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String criteriaCalculation, String tenant, Date startDate, Date endDate, boolean isPiView, List<Fields> fields, boolean isOkrEnabled, Map<String, Object> excludeItemsData, Date syncDate, String sessionBoardId, String sessionId) throws Exception {
        HashSet KRLinkedObjs = new HashSet();
        for (BaseItem kr : mappedKeyResults) {
            KRLinkedObjs.addAll(kr.getBaseItemLinks().stream().filter(l -> EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList()));
        }
        BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", KRLinkedObjs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", KRLinkedObjs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        List mappedObjs = this.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
        mappedObjs.addAll(this.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
        if ("current".equalsIgnoreCase(criteriaCalculation)) {
            Map<String, List<BaseItem>> groupedById = mappedObjs.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            for (List<BaseItem> group : groupedById.values()) {
                BaseItem latestItem = group.stream().max(Comparator.comparing(BaseEntity::getCreatedOn)).orElse(null);
                if (latestItem == null) continue;
                String latestCompletionCriteria = latestItem.getCompletionCriteria();
                for (BaseItem item : group) {
                    item.setCompletionCriteria(latestCompletionCriteria);
                }
            }
        }
        return this.fetchObjectivesCompleteData(mappedObjs, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
    }

    public List<Date> divideIntervals(Date startDate, Date endDate, String interval) throws Exception {
        ArrayList<Date> intervals = new ArrayList<Date>();
        LocalDate start = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate today = LocalDate.now();
        switch (interval.toLowerCase()) {
            case "quarterly": {
                LocalDate date = end;
                while (!date.isBefore(start)) {
                    LocalDate intervalEnd = date.withDayOfMonth(date.lengthOfMonth());
                    if (intervalEnd.getMonth() == today.getMonth() && intervalEnd.getYear() == today.getYear()) {
                        intervalEnd = today;
                    }
                    intervals.add(this.convertToDate(intervalEnd));
                    date = date.minusMonths(3L);
                }
                Collections.reverse(intervals);
                break;
            }
            case "monthly": {
                LocalDate date = end;
                while (!date.isBefore(start)) {
                    LocalDate intervalEnd = date.withDayOfMonth(date.lengthOfMonth());
                    if (intervalEnd.getMonth() == today.getMonth() && intervalEnd.getYear() == today.getYear()) {
                        intervalEnd = today;
                    }
                    intervals.add(this.convertToDate(intervalEnd));
                    date = date.minusMonths(1L);
                }
                Collections.reverse(intervals);
                break;
            }
            case "weekly": {
                LocalDate date = end;
                while (!date.isBefore(start)) {
                    intervals.add(this.convertToDate(date));
                    date = date.minusWeeks(1L);
                }
                Collections.reverse(intervals);
                break;
            }
            case "daily": {
                LocalDate date = start;
                while (!date.isAfter(end)) {
                    intervals.add(this.convertToDate(date));
                    date = date.plusDays(1L);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid interval type: " + interval);
            }
        }
        return intervals;
    }

    private Date convertToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public Map<Date, Map<String, BaseItem>> mapBaseItemLogsToDates(List<BaseItem> logs, List<Date> dateList, String interval) throws Exception {
        LinkedHashMap<Date, Map<String, BaseItem>> resultMap = new LinkedHashMap<Date, Map<String, BaseItem>>();
        if (!logs.isEmpty()) {
            Map logMap = logs.stream().collect(Collectors.groupingBy(log -> TimeSeriesUtils.stripTime((Date)log.getCreatedOn()), TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(BaseEntity::getCreatedOn)).collect(Collectors.toList()))));
            HashMap allKnownLogs = new HashMap();
            Date startOfInterval = dateList.get(0);
            if ("monthly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("quarterly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusMonths(3L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("weekly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusWeeks(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("daily".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            for (int i = 0; i < dateList.size(); ++i) {
                Date endOfInterval = dateList.get(i);
                HashMap<String, BaseItem> intervalLogsMap = new HashMap<String, BaseItem>(allKnownLogs);
                for (Map.Entry entry : logMap.entrySet()) {
                    Date logDate = (Date)entry.getKey();
                    if (endOfInterval != null && logDate.after(endOfInterval)) continue;
                    for (BaseItem log2 : (List)entry.getValue()) {
                        intervalLogsMap.put(log2.getId(), new BaseItem(log2));
                    }
                }
                allKnownLogs.putAll(intervalLogsMap);
                if (allKnownLogs.isEmpty() && i == 0) {
                    for (BaseItem earliestLog : (List)logMap.entrySet().iterator().next().getValue()) {
                        if (!earliestLog.getCreatedOn().before(startOfInterval)) continue;
                        allKnownLogs.put(earliestLog.getId(), new BaseItem(earliestLog));
                        for (Map.Entry entry : allKnownLogs.entrySet()) {
                            intervalLogsMap.put((String)entry.getKey(), new BaseItem((BaseItem)entry.getValue()));
                        }
                    }
                }
                resultMap.put(endOfInterval, intervalLogsMap);
                startOfInterval = endOfInterval;
            }
        }
        return resultMap;
    }

    public Map<Date, Map<String, BacklogItem>> mapBackLogItemToDates(List<BacklogItem> logs, List<Date> dateList, String interval, boolean isPiView, Map<String, Object> excludeItemsData) throws Exception {
        LinkedHashMap<Date, Map<String, BacklogItem>> resultMap = new LinkedHashMap<Date, Map<String, BacklogItem>>();
        if (!logs.isEmpty()) {
            Map logMap = logs.stream().collect(Collectors.groupingBy(log -> TimeSeriesUtils.stripTime((Date)log.getCreatedOn()), TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(BaseEntity::getCreatedOn)).collect(Collectors.toList()))));
            HashMap allKnownLogs = new HashMap();
            Date startOfInterval = dateList.get(0);
            if ("monthly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("quarterly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusMonths(3L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("weekly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusWeeks(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("daily".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            for (int i = 0; i < dateList.size(); ++i) {
                Date endOfInterval = dateList.get(i);
                HashMap intervalLogsMap = new HashMap();
                for (Map.Entry entry : allKnownLogs.entrySet()) {
                    intervalLogsMap.put(entry.getKey(), new BacklogItem((BacklogItem)entry.getValue()));
                }
                for (Map.Entry entry : logMap.entrySet()) {
                    Date logDate = (Date)entry.getKey();
                    if (endOfInterval != null && logDate.after(endOfInterval)) continue;
                    for (BacklogItem log2 : (List)entry.getValue()) {
                        intervalLogsMap.put(log2.getId(), new BacklogItem(log2));
                    }
                }
                allKnownLogs.putAll(intervalLogsMap);
                if (allKnownLogs.isEmpty() && i == 0) {
                    for (BacklogItem earliestLog : (List)logMap.entrySet().iterator().next().getValue()) {
                        if (!earliestLog.getCreatedOn().before(startOfInterval)) continue;
                        allKnownLogs.put(earliestLog.getId(), new BacklogItem(earliestLog));
                        for (Map.Entry entry : allKnownLogs.entrySet()) {
                            intervalLogsMap.put(entry.getKey(), new BacklogItem((BacklogItem)entry.getValue()));
                        }
                    }
                }
                resultMap.put(endOfInterval, intervalLogsMap);
                startOfInterval = endOfInterval;
            }
        }
        if (isPiView) {
            HashSet<String> filteredStatusIds = new HashSet<String>();
            if (PropertyValidator.isValid((Object)excludeItemsData.get("featuresStatus")) || PropertyValidator.isValid((Object)excludeItemsData.get("storyStatus"))) {
                LinkedHashMap featuresStatus = (LinkedHashMap)excludeItemsData.get("featuresStatus");
                HashSet allStatusTitle = new HashSet();
                allStatusTitle.addAll(featuresStatus.values());
                LinkedHashMap storyStatus = (LinkedHashMap)excludeItemsData.get("storyStatus");
                allStatusTitle.addAll(storyStatus.values());
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                BasicDBObject query = new BasicDBObject();
                query.put((Object)"$and", Arrays.asList(new BasicDBObject("title", (Object)new BasicDBObject("$in", allStatusTitle)), new BasicDBObject("tenant", (Object)tenant)));
                DBCollection statusCollection = this.mongoTemplate.getCollection("status");
                DBCursor dbCursor = statusCollection.find((DBObject)query);
                while (dbCursor.hasNext()) {
                    DBObject dBObject = (DBObject)dbCursor.next();
                    if (!PropertyValidator.isValid((Object)dBObject.get("_id"))) continue;
                    if (dBObject.get("_id") instanceof ObjectId) {
                        ObjectId statusObjId = (ObjectId)dBObject.get("_id");
                        if (!PropertyValidator.isValid((Object)statusObjId)) continue;
                        filteredStatusIds.add(statusObjId.toString());
                        continue;
                    }
                    if (!(dBObject.get("_id") instanceof String)) continue;
                    filteredStatusIds.add((String)dBObject.get("_id"));
                }
            }
            for (Map.Entry resultMapEntry : resultMap.entrySet()) {
                Map resultMapVal = (Map)resultMapEntry.getValue();
                Iterator iterator = resultMapVal.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    BacklogItem item = (BacklogItem)entry.getValue();
                    boolean shouldRemove = false;
                    if ("Feature".equalsIgnoreCase(item.getAlmType())) {
                        if (PropertyValidator.isValid((Object)excludeItemsData.get("cardType"))) {
                            List cardTypes = (List)excludeItemsData.get("cardType");
                            for (LinkedHashMap cardTypeMap : cardTypes) {
                                String cardTypeId = (String)cardTypeMap.get("id");
                                String cardTypeTitle = (String)cardTypeMap.get("title");
                                if (!cardTypeId.equalsIgnoreCase(item.getType()) && (PropertyValidator.isValid((Object)item.getType()) || !"Feature".equalsIgnoreCase(cardTypeTitle))) continue;
                                shouldRemove = true;
                                break;
                            }
                        }
                        if (!shouldRemove && PropertyValidator.isValid((Object)excludeItemsData.get("featuresIssueType"))) {
                            LinkedHashMap featuresIssueType = (LinkedHashMap)excludeItemsData.get("featuresIssueType");
                            for (String featureIssueType : featuresIssueType.values()) {
                                if (!featureIssueType.equalsIgnoreCase(item.getIssueType())) continue;
                                shouldRemove = true;
                                break;
                            }
                        }
                        if (!shouldRemove && PropertyValidator.isValid((Object)excludeItemsData.get("featuresStatus")) && PropertyValidator.isValid((Object)item.getStatus()) && filteredStatusIds.contains(item.getStatus().getId())) {
                            shouldRemove = true;
                        }
                    } else if ("UserStory".equalsIgnoreCase(item.getAlmType())) {
                        List storyPlans;
                        if (PropertyValidator.isValid((Object)excludeItemsData.get("storyIssueType"))) {
                            LinkedHashMap storyIssueTypes = (LinkedHashMap)excludeItemsData.get("storyIssueType");
                            for (String storyIssueType : storyIssueTypes.values()) {
                                if (!storyIssueType.equalsIgnoreCase(item.getType())) continue;
                                shouldRemove = true;
                                break;
                            }
                        }
                        if (!shouldRemove && PropertyValidator.isValid((Object)excludeItemsData.get("storyPlan")) && PropertyValidator.isValid((Collection)(storyPlans = (List)excludeItemsData.get("storyPlan")))) {
                            List list2 = item.getTeamData();
                            for (LinkedHashMap storyPlan : storyPlans) {
                                String title = (String)storyPlan.get("title");
                                if ((!title.equalsIgnoreCase("Planned") || !PropertyValidator.isValid((Collection)list2)) && (!title.equalsIgnoreCase("Unplanned") || PropertyValidator.isValid((Collection)list2))) continue;
                                shouldRemove = true;
                                break;
                            }
                        }
                        if (!shouldRemove && PropertyValidator.isValid((Object)excludeItemsData.get("storyStatus")) && PropertyValidator.isValid((Object)item.getStatus()) && filteredStatusIds.contains(item.getStatus().getId())) {
                            shouldRemove = true;
                        }
                    }
                    if (!shouldRemove) continue;
                    iterator.remove();
                    excludeItemsData.put("itemsExcluded", true);
                }
            }
        }
        return resultMap;
    }

    public Map<Date, Map<String, Board>> mapBoardLogsToDates(List<Board> logs, List<Date> dateList, String interval) throws Exception {
        LinkedHashMap<Date, Map<String, Board>> resultMap = new LinkedHashMap<Date, Map<String, Board>>();
        if (!logs.isEmpty()) {
            Map logMap = logs.stream().collect(Collectors.groupingBy(log -> TimeSeriesUtils.stripTime((Date)log.getCreatedOn()), TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(BaseEntity::getCreatedOn)).collect(Collectors.toList()))));
            HashMap allKnownLogs = new HashMap();
            Date startOfInterval = dateList.get(0);
            if ("monthly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("quarterly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusMonths(3L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("weekly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusWeeks(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("daily".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            for (int i = 0; i < dateList.size(); ++i) {
                Date endOfInterval = dateList.get(i);
                HashMap<String, Board> intervalLogsMap = new HashMap<String, Board>(allKnownLogs);
                for (Map.Entry entry : logMap.entrySet()) {
                    Date logDate = (Date)entry.getKey();
                    if (endOfInterval != null && logDate.after(endOfInterval)) continue;
                    for (Board log2 : (List)entry.getValue()) {
                        intervalLogsMap.put(log2.getId(), new Board(log2));
                    }
                }
                allKnownLogs.putAll(intervalLogsMap);
                if (allKnownLogs.isEmpty() && i == 0) {
                    for (Board earliestLog : (List)logMap.entrySet().iterator().next().getValue()) {
                        if (!earliestLog.getCreatedOn().before(startOfInterval)) continue;
                        allKnownLogs.put(earliestLog.getId(), new Board(earliestLog));
                        for (Map.Entry entry : allKnownLogs.entrySet()) {
                            intervalLogsMap.put((String)entry.getKey(), new Board((Board)entry.getValue()));
                        }
                    }
                }
                resultMap.put(endOfInterval, intervalLogsMap);
                startOfInterval = endOfInterval;
            }
        }
        return resultMap;
    }

    public Map<Date, Map<String, BacklogItem>> buildBackLogNthLevelHierarchy(List<BacklogItem> backlogItems, List<Date> dateList, String tenant, Date startDate, Date endDate, String interval, boolean isPiView, Map<String, Object> excludeItemsData, Date syncDate, Set<String> attachedReleaseTrains, String sessionId, Set<String> objLinkedItemIds, Set<String> attachedSessionIds) throws Exception {
        List nestedDBBackLogItems = new ArrayList();
        if (!objLinkedItemIds.isEmpty()) {
            LOGGER.debug("Going to hunt user stories");
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("staticFields.parent.id", (Object)new BasicDBObject("$in", new ArrayList<String>(objLinkedItemIds))), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList<String>(attachedSessionIds)))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("staticFields.parent.id", (Object)new BasicDBObject("$in", new ArrayList<String>(objLinkedItemIds))), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("meta.sessionId", (Object)new BasicDBObject("$in", new ArrayList<String>(attachedSessionIds)))));
            nestedDBBackLogItems = this.fetchBacklogItems((DBObject)queryEarliest, "itemTimeSeries", false, -1);
            nestedDBBackLogItems.addAll(this.fetchBacklogItems((DBObject)query, "itemTimeSeries", true, 1));
            LOGGER.debug("Child items of size : {} found", (Object)nestedDBBackLogItems.size());
        }
        HashSet<String> childBacklogItems = new HashSet<String>();
        for (BacklogItem item : backlogItems) {
            if (null == item.getBaseItemLinks()) continue;
            for (BaseItemLink link : item.getBaseItemLinks()) {
                if (!EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || null == link.getBacklogItemId()) continue;
                childBacklogItems.add(link.getBacklogItemId().toString());
            }
        }
        LOGGER.debug("Child backlog item ids of size : {} found", (Object)childBacklogItems.size());
        BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", childBacklogItems)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", childBacklogItems)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        nestedDBBackLogItems.addAll(this.fetchBacklogItems((DBObject)queryEarliest, "backlogItemTimeSeries", false, -1));
        nestedDBBackLogItems.addAll(this.fetchBacklogItems((DBObject)query, "backlogItemTimeSeries", true, 1));
        LOGGER.info("Children linked backlog items found of size :{}", (Object)nestedDBBackLogItems.size());
        if (nestedDBBackLogItems.isEmpty()) {
            LOGGER.debug("No child item found. Returning");
            return null;
        }
        Map datedBacklogMap = this.mapBackLogItemToDates(nestedDBBackLogItems, dateList, interval, isPiView, excludeItemsData);
        if (isPiView) {
            LOGGER.debug("Is PI board objective. Not going to hunt children of children.");
            return datedBacklogMap;
        }
        Map linkedBacklogMap = this.buildBackLogNthLevelHierarchy(nestedDBBackLogItems, dateList, tenant, startDate, endDate, interval, isPiView, excludeItemsData, syncDate, attachedReleaseTrains, sessionId, new HashSet(), attachedSessionIds);
        LOGGER.debug("Going to link children items with parent");
        if (null != linkedBacklogMap && null != datedBacklogMap) {
            datedBacklogMap.forEach((key, value) -> {
                if (null != value && null != linkedBacklogMap.get(key)) {
                    for (BacklogItem item : ((Map)linkedBacklogMap.get(key)).values()) {
                        String parentId;
                        Map parentMap = item.getParentMap();
                        if (!PropertyValidator.isValid((Object)parentMap) || !PropertyValidator.isValid((Object)(parentId = (String)parentMap.get("id"))) || !value.containsKey(parentId)) continue;
                        boolean isArchive = item.isArchive();
                        int rowStatus = Optional.ofNullable(item).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(0);
                        if (rowStatus == 0 && !isArchive && !((BacklogItem)value.get(parentId)).getBacklogItemsMap().containsKey(item.getId())) {
                            ((BacklogItem)value.get(parentId)).getBacklogItemsMap().computeIfAbsent(item.getId(), l -> new ArrayList()).add(item);
                        }
                        if (!PropertyValidator.isValid((Collection)item.getBaseItemLinks())) continue;
                        String releaseTrainId = item.getBaseItemLinks().stream().filter(l -> EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getReleaseTrainId).findFirst().orElse("");
                        Status status = item.getStatus();
                        if (!PropertyValidator.isValid((Object)status) || !PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) || !PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) continue;
                        status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                    }
                }
            });
        }
        LOGGER.debug("Going to link backlog children items with parent");
        if (null != linkedBacklogMap && null != datedBacklogMap) {
            linkedBacklogMap.forEach((key, value) -> {
                if (null != value && null != datedBacklogMap.get(key)) {
                    for (BacklogItem item : ((Map)datedBacklogMap.get(key)).values()) {
                        for (String releaseTrain : attachedReleaseTrains) {
                            HashSet<ObjectId> childItemIds = new HashSet<ObjectId>();
                            if (PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrain)))) {
                                List links = (List)item.getChildRelationMap().get(releaseTrain);
                                for (BaseItemLink link : links) {
                                    if (!EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBacklogItemId())) continue;
                                    childItemIds.add(link.getBacklogItemId());
                                }
                            }
                            if (childItemIds.isEmpty()) continue;
                            for (ObjectId childItemId : childItemIds) {
                                String id = childItemId.toString();
                                if (!value.containsKey(id)) continue;
                                BacklogItem childItem = (BacklogItem)value.get(id);
                                boolean isArchive = childItem.isArchive();
                                int rowStatus = Optional.ofNullable(childItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType()) && releaseTrain.equalsIgnoreCase(l.getReleaseTrainId())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                if (rowStatus != 0 || isArchive || item.getBacklogItemsMap().containsKey(childItem.getId())) continue;
                                item.getBacklogItemsMap().computeIfAbsent(childItem.getId(), l -> new ArrayList()).add(childItem);
                            }
                        }
                    }
                }
            });
        }
        return datedBacklogMap;
    }

    public Map<Date, Map<String, BaseItem>> fetchBatchesCompleteData(List<BaseItem> mappedBatches, Map<String, String> itemKeys, Map<String, String> itemTitles, String baseItemCollection, String backlogItemCollection, List<Date> intervalDates, String interval, String tenant, Date startDate, Date endDate, String progressCriteria, boolean includeSubBatches, String levelSelection, int level, Date syncDate, String parentBatchId, Set<String> traversedIds) throws Exception {
        Map datedBacklogItemsMap;
        Map datedBatchesMap = this.mapBaseItemLogsToDates(mappedBatches, intervalDates, interval);
        if (!"SUB_BATCH_STATUS".equalsIgnoreCase(progressCriteria) && null != (datedBacklogItemsMap = this.fetchBatchesLinkedBacklogItems(mappedBatches, itemKeys, itemTitles, backlogItemCollection, intervalDates, interval, tenant, startDate, endDate, false, syncDate)) && null != datedBatchesMap) {
            datedBacklogItemsMap.forEach((key, value) -> {
                if (null != value && null != datedBatchesMap.get(key)) {
                    for (BaseItem item : ((Map)datedBatchesMap.get(key)).values()) {
                        List links = item.getBaseItemLinks();
                        List backlogItemIds = links.stream().filter(b -> EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(b.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList());
                        boolean archive = item.isArchive();
                        for (String backlogItemId : backlogItemIds) {
                            BacklogItem backlogItem;
                            int rowStatus;
                            if (!value.containsKey(backlogItemId) || archive || (rowStatus = Optional.ofNullable(backlogItem = (BacklogItem)value.get(backlogItemId)).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(1).intValue()) != 0) continue;
                            item.getBacklogItemsMap().computeIfAbsent(((BacklogItem)value.get(backlogItemId)).getId(), l -> new ArrayList()).add(value.get(backlogItemId));
                        }
                    }
                }
            });
        }
        if (includeSubBatches && (level < 2 || "COMPLETE_TREE".equalsIgnoreCase(levelSelection))) {
            HashSet<String> subBatchesIds = new HashSet<String>();
            for (BaseItem batch : mappedBatches) {
                for (BaseItemLink link : batch.getBaseItemLinks()) {
                    if (!EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType().equalsIgnoreCase(link.getLinkType()) || traversedIds.contains(link.getBaseItemId())) continue;
                    subBatchesIds.add(link.getBaseItemId());
                    traversedIds.add(link.getBaseItemId());
                }
                itemKeys.put(batch.getId(), batch.getKey());
                itemTitles.put(batch.getId(), batch.getTitle());
            }
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", subBatchesIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", subBatchesIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            List mappedSubBatches = this.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
            mappedSubBatches.addAll(this.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
            ++level;
            if (!mappedSubBatches.isEmpty()) {
                Map datedSubBatchesMap = this.fetchBatchesCompleteData(mappedSubBatches, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, tenant, startDate, endDate, progressCriteria, includeSubBatches, levelSelection, level, syncDate, parentBatchId, traversedIds);
                datedSubBatchesMap.forEach((key, value) -> {
                    if (null != value && null != datedBatchesMap.get(key)) {
                        for (BaseItem item : ((Map)datedBatchesMap.get(key)).values()) {
                            List links = item.getBaseItemLinks();
                            List batchIds = links.stream().filter(b -> EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType().equalsIgnoreCase(b.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList());
                            boolean archive = item.isArchive();
                            for (String batchId : batchIds) {
                                if (!value.containsKey(batchId) || archive) continue;
                                item.getBaseItemsMap().put(((BaseItem)value.get(batchId)).getId(), value.get(batchId));
                            }
                        }
                    }
                });
            }
        }
        return datedBatchesMap;
    }

    public Map<Date, Map<String, BacklogItem>> fetchBatchesLinkedBacklogItems(List<BaseItem> mappedBatches, Map<String, String> itemKeys, Map<String, String> itemTitles, String backlogItemCollection, List<Date> intervalDates, String interval, String tenant, Date startDate, Date endDate, boolean isPiView, Date syncDate) throws Exception {
        HashSet<String> batchesLinkedBLItemsIDs = new HashSet<String>();
        HashSet<String> attachedReleaseTrains = new HashSet<String>();
        for (BaseItem baseItem : mappedBatches) {
            if (PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
                for (BaseItemLink link : baseItem.getBaseItemLinks()) {
                    if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                    batchesLinkedBLItemsIDs.add(link.getBaseItemId());
                    if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                        attachedReleaseTrains.add(link.getReleaseTrainId());
                        continue;
                    }
                    LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{baseItem.getKey(), baseItem.getId(), baseItem.getCreatedOn()});
                }
            }
            itemKeys.put(baseItem.getId(), baseItem.getKey());
            itemTitles.put(baseItem.getId(), baseItem.getTitle());
        }
        LOGGER.info("Batches linked backlog itemIds size :{}", (Object)batchesLinkedBLItemsIDs.size());
        if (!batchesLinkedBLItemsIDs.isEmpty()) {
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", batchesLinkedBLItemsIDs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", batchesLinkedBLItemsIDs)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            List mappedBatchesBacklogItems = this.fetchBacklogItems((DBObject)queryEarliest, backlogItemCollection, false, -1);
            mappedBatchesBacklogItems.addAll(this.fetchBacklogItems((DBObject)query, backlogItemCollection, true, 1));
            LOGGER.info("Batches linked backlog items found of size :{}", (Object)mappedBatchesBacklogItems.size());
            Map datedBacklogItemsMap = this.mapBackLogItemToDates(mappedBatchesBacklogItems, intervalDates, interval, isPiView, null);
            Map nestedBackLogItems = this.buildBackLogNthLevelHierarchy(mappedBatchesBacklogItems, intervalDates, tenant, startDate, endDate, interval, isPiView, null, syncDate, attachedReleaseTrains, "", new HashSet(), new HashSet());
            if (null != datedBacklogItemsMap && null != nestedBackLogItems) {
                nestedBackLogItems.forEach((key, value) -> {
                    if (null != value && null != datedBacklogItemsMap.get(key)) {
                        for (BacklogItem item : ((Map)datedBacklogItemsMap.get(key)).values()) {
                            HashSet<ObjectId> childItemIds = new HashSet<ObjectId>();
                            for (String releaseTrain : attachedReleaseTrains) {
                                if (PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrain)))) {
                                    List links = (List)item.getChildRelationMap().get(releaseTrain);
                                    for (BaseItemLink link : links) {
                                        if (!EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBacklogItemId())) continue;
                                        childItemIds.add(link.getBacklogItemId());
                                    }
                                }
                                if (childItemIds.isEmpty()) continue;
                                for (ObjectId childItemId : childItemIds) {
                                    String id = childItemId.toString();
                                    if (!value.containsKey(id)) continue;
                                    BacklogItem childItem = (BacklogItem)value.get(id);
                                    boolean isArchive = childItem.isArchive();
                                    int rowStatus = Optional.ofNullable(childItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType()) && releaseTrain.equalsIgnoreCase(l.getReleaseTrainId())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                    if (rowStatus != 0 || isArchive || item.getBacklogItemsMap().containsKey(childItem.getId())) continue;
                                    item.getBacklogItemsMap().computeIfAbsent(childItem.getId(), l -> new ArrayList()).add(childItem);
                                }
                            }
                        }
                    }
                });
            }
            return datedBacklogItemsMap;
        }
        return null;
    }

    public Map<String, Object> calculateBatchProgress(BaseItem batch, String progressCriteria, boolean includeSubBatches, Map<String, BaseItem> fetchedBaches) {
        double[] results = new double[]{0.0, 0.0};
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> batchProgress = new HashMap<String, Object>();
        if (includeSubBatches) {
            double[] totalBatchesProgress = new double[]{0.0, 0.0};
            Map batchesResult = this.calculateSubBatchesProgress(Collections.singletonList(batch), results, progressCriteria, totalBatchesProgress, fetchedBaches);
            if (PropertyValidator.isValid(batchesResult.get("batchProgress")) && !PropertyValidator.isValid((Object)"topBatchProgress")) {
                double topBatchProgress = (Double)batchesResult.get("batchProgress");
                batchesResult.put("topBatchProgress", topBatchProgress);
            }
            resultMap.put(batch.getId(), batchesResult);
        } else {
            HashSet<String> attachedReleaseTrains = new HashSet<String>();
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getReleaseTrainId())) continue;
                attachedReleaseTrains.add(link.getReleaseTrainId());
            }
            results = this.calculateBatchesItemsProgress(batch.getBacklogItemsMap(), results, progressCriteria, attachedReleaseTrains);
            double totalProgress = 0.0;
            if (results[0] > 0.0) {
                totalProgress = results[0] / results[1] * 100.0;
            }
            batchProgress.put("doneChildren", results[0]);
            batchProgress.put("totalChildren", results[1]);
            batchProgress.put("progressCriteria", this.fetchBatchProgressTitle(progressCriteria));
            if (batch.getBacklogItemsMap().isEmpty()) {
                batchProgress.put("topBatchProgress", null);
                batchProgress.put("batchProgress", null);
            } else {
                batchProgress.put("topBatchProgress", (double)Math.round(totalProgress * 10.0) / 10.0);
                batchProgress.put("batchProgress", (double)Math.round(totalProgress * 10.0) / 10.0);
            }
            resultMap.put(batch.getId(), batchProgress);
        }
        return resultMap;
    }

    public Map<String, Object> calculateSubBatchesProgress(List<BaseItem> batches, double[] results, String progressCriteria, double[] totalBatchesProgress, Map<String, BaseItem> fetchedBatches) {
        double batchProgress = 0.0;
        double[] batchResult = new double[]{0.0, 0.0};
        HashMap<String, Object> batchProgressMap = new HashMap<String, Object>();
        for (BaseItem batch : batches) {
            if ("SUB_BATCH_STATUS".equalsIgnoreCase(progressCriteria)) {
                for (BaseItem subBatch : batch.getBaseItemsMap().values()) {
                    if (null != subBatch.getStatus() && PropertyValidator.isValid((Object)subBatch.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(subBatch.getStatus().getCategory())) {
                        results[0] = results[0] + 1.0;
                    }
                    results[1] = results[1] + 1.0;
                }
                this.calculateSubBatchesProgress(new ArrayList(batch.getBaseItemsMap().values()), results, progressCriteria, totalBatchesProgress, fetchedBatches);
                if (results[1] > 0.0) {
                    batchProgress = results[0] / results[1] * 100.0;
                }
                batchProgressMap.put("doneChildren", results[0]);
                batchProgressMap.put("totalChildren", results[1]);
                if (Double.isNaN(batchProgress)) {
                    batchProgressMap.put("topBatchProgress", null);
                    continue;
                }
                batchProgressMap.put("topBatchProgress", (double)Math.round(batchProgress * 10.0) / 10.0);
                continue;
            }
            if (!"BATCH_PROGRESS_CRITERIA".equalsIgnoreCase(progressCriteria)) continue;
            BaseItem fetchedBatch = fetchedBatches.get(batch.getId());
            String batchProgressCriteria = "c_lis";
            if (PropertyValidator.isValid((Object)fetchedBatch) && PropertyValidator.isValid((Object)fetchedBatch.getFields()) && PropertyValidator.isValid(fetchedBatch.getFields().get("selectedCriteria"))) {
                batchProgressCriteria = (String)fetchedBatch.getFields().get("selectedCriteria");
            }
            Map subBatchProgress = this.calculateRollupSubBatchProgress(new ArrayList(batch.getBaseItemsMap().values()), batchProgressCriteria, totalBatchesProgress, fetchedBatches);
            HashSet<String> attachedReleaseTrains = new HashSet<String>();
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                    attachedReleaseTrains.add(link.getReleaseTrainId());
                    continue;
                }
                LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{batch.getKey(), batch.getId(), batch.getCreatedOn()});
            }
            batchResult = this.calculateBatchesItemsProgress(batch.getBacklogItemsMap(), batchResult, batchProgressCriteria, attachedReleaseTrains);
            batchProgress = batchResult[0] / batchResult[1] * 100.0;
            if (!Double.isNaN(batchProgress)) {
                batchProgressMap.put("topBatchProgress", (double)Math.round(batchProgress * 10.0) / 10.0);
                batchProgressMap.put("doneChildren", batchResult[0]);
                batchProgressMap.put("totalChildren", batchResult[1]);
                totalBatchesProgress[0] = totalBatchesProgress[0] + batchProgress;
            } else {
                batchProgressMap.put("topBatchProgress", null);
                batchProgressMap.put("doneChildren", Character.valueOf('-'));
                batchProgressMap.put("totalChildren", Character.valueOf('-'));
            }
            totalBatchesProgress[1] = totalBatchesProgress[1] + 1.0;
            batchProgress = totalBatchesProgress[0] / totalBatchesProgress[1];
            batchProgressMap.put("progressCriteria", this.fetchBatchProgressTitle(batchProgressCriteria));
            batchProgressMap.put("subBatchProgress", subBatchProgress);
            batchProgressMap.put("batchProgress", (double)Math.round(batchProgress * 10.0) / 10.0);
            batchProgressMap.put("totalDone", batchResult[0]);
            batchProgressMap.put("totalSize", batchResult[1]);
        }
        batchProgressMap.put("batchProgress", (double)Math.round(batchProgress * 10.0) / 10.0);
        return batchProgressMap;
    }

    private Map<String, Object> calculateRollupSubBatchProgress(List<BaseItem> batches, String progressCriteria, double[] totalBatchesProgress, Map<String, BaseItem> fetchedBatches) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (BaseItem batch : batches) {
            double[] results = new double[]{0.0, 0.0};
            HashMap<String, Object> batchProgressMap = new HashMap<String, Object>();
            BaseItem fetchedBatch = fetchedBatches.get(batch.getId());
            if (PropertyValidator.isValid((Object)fetchedBatch) && PropertyValidator.isValid((Object)fetchedBatch.getFields()) && PropertyValidator.isValid(fetchedBatch.getFields().get("selectedCriteria"))) {
                progressCriteria = (String)fetchedBatch.getFields().get("selectedCriteria");
            }
            Map subBatchProgress = this.calculateRollupSubBatchProgress(new ArrayList(batch.getBaseItemsMap().values()), progressCriteria, totalBatchesProgress, fetchedBatches);
            HashSet<String> attachedReleaseTrains = new HashSet<String>();
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                    attachedReleaseTrains.add(link.getReleaseTrainId());
                    continue;
                }
                LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{batch.getKey(), batch.getId(), batch.getCreatedOn()});
            }
            results = this.calculateBatchesItemsProgress(batch.getBacklogItemsMap(), results, progressCriteria, attachedReleaseTrains);
            double batchProgress = results[0] / results[1] * 100.0;
            if (!Double.isNaN(batchProgress)) {
                totalBatchesProgress[0] = totalBatchesProgress[0] + batchProgress;
                totalBatchesProgress[1] = totalBatchesProgress[1] + 1.0;
            }
            if (!subBatchProgress.isEmpty()) {
                batchProgressMap.put("subBatchProgress", subBatchProgress);
            }
            batchProgressMap.put("results", results);
            batchProgressMap.put("progressCriteria", this.fetchBatchProgressTitle(progressCriteria));
            if (Double.isNaN(batchProgress)) {
                batchProgressMap.put("batchProgress", null);
            } else {
                batchProgressMap.put("batchProgress", (double)Math.round(batchProgress * 10.0) / 10.0);
            }
            resultMap.put(batch.getId(), batchProgressMap);
        }
        return resultMap;
    }

    public double[] calculateBatchesItemsProgress(Map<String, List<BacklogItem>> backlogItemsMap, double[] results, String criteria, Set<String> attachedReleaseTrains) {
        for (Map.Entry<String, List<BacklogItem>> backlogItemMapEntrySet : backlogItemsMap.entrySet()) {
            List<BacklogItem> backlogItems = backlogItemMapEntrySet.getValue();
            block12: for (BacklogItem item : backlogItems) {
                switch (criteria) {
                    case "c_lis": {
                        if (PropertyValidator.isValid((Object)item.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(item.getStatus().getCategory())) {
                            results[0] = results[0] + 1.0;
                        }
                        results[1] = results[1] + 1.0;
                        break;
                    }
                    case "c_st": {
                        for (String releaseTrain : attachedReleaseTrains) {
                            LOGGER.debug("Traversing for releaseTrainId: {}", (Object)releaseTrain);
                            ArrayList<String> countedAlmKeys = new ArrayList<String>();
                            for (List<BacklogItem> parentBacklogItems : backlogItemsMap.values()) {
                                for (BacklogItem backlogItem : backlogItems) {
                                    if (countedAlmKeys.contains(backlogItem.getAlmKey())) continue;
                                    if (!PropertyValidator.isValid((Object)backlogItem.getAlmKey())) {
                                        countedAlmKeys.add(backlogItem.getTitle());
                                    } else {
                                        countedAlmKeys.add(backlogItem.getAlmKey());
                                    }
                                    LOGGER.debug("Traversing backlogitem with almKey: {} and id: {}", (Object)backlogItem.getAlmKey(), (Object)backlogItem.getId());
                                    Map featuresMap = backlogItem.getBacklogItemsMap();
                                    for (Map.Entry featureEntrySet : featuresMap.entrySet()) {
                                        List stories = (List)featureEntrySet.getValue();
                                        if (!PropertyValidator.isValid((Collection)stories)) continue;
                                        for (BacklogItem story : stories) {
                                            LOGGER.debug("Nested Backlog item with key: {} and id: {} found", (Object)story.getAlmKey(), (Object)story.getId());
                                            int rowStatus = 1;
                                            if (PropertyValidator.isValid((Collection)story.getBaseItemLinks())) {
                                                for (BaseItemLink link : story.getBaseItemLinks()) {
                                                    if (!PropertyValidator.isValid((Object)link.getLinkType()) || !PropertyValidator.isValid((Object)link.getReleaseTrainId()) || !PropertyValidator.isValid((Object)releaseTrain) || !EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !releaseTrain.equalsIgnoreCase(link.getReleaseTrainId())) continue;
                                                    rowStatus = link.getRowStatus();
                                                }
                                            }
                                            if (rowStatus != 0) continue;
                                            results[1] = results[1] + 1.0;
                                            if (!PropertyValidator.isValid((Object)story.getStatus()) || !EnumStatusCategory.DONE.getCode().equalsIgnoreCase(story.getStatus().getCategory())) continue;
                                            LOGGER.debug("Counting backlogitem children with almKey: {} and id: {} as done", (Object)story.getAlmKey(), (Object)story.getId());
                                            results[0] = results[0] + 1.0;
                                        }
                                    }
                                }
                            }
                        }
                        continue block12;
                    }
                    case "r_st": 
                    case "r_sp": {
                        results = this.calculateRollupEstimates(results, item.getBacklogItemsMap(), criteria, attachedReleaseTrains);
                    }
                }
            }
        }
        return results;
    }

    private double[] calculateRollupEstimates(double[] results, Map<String, List<BacklogItem>> itemsMap, String criteria, Set<String> attachedReleaseTrains) {
        for (Map.Entry<String, List<BacklogItem>> backlogItemMapEntrySet : itemsMap.entrySet()) {
            List<BacklogItem> items = backlogItemMapEntrySet.getValue();
            for (BacklogItem item : items) {
                results = this.calculateRollupEstimates(results, item.getBacklogItemsMap(), criteria, attachedReleaseTrains);
                for (String releaseTrain : attachedReleaseTrains) {
                    int rowStatus = 1;
                    if (PropertyValidator.isValid((Collection)item.getBaseItemLinks())) {
                        for (BaseItemLink link : item.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link.getLinkType()) || !PropertyValidator.isValid((Object)link.getReleaseTrainId()) || !EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !releaseTrain.equalsIgnoreCase(link.getReleaseTrainId())) continue;
                            rowStatus = link.getRowStatus();
                        }
                    }
                    if (rowStatus != 0) continue;
                    if ("r_st".equalsIgnoreCase(criteria)) {
                        if (PropertyValidator.isValid((Object)item.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(item.getStatus().getCategory())) {
                            results[0] = results[0] + 1.0;
                        }
                        results[1] = results[1] + 1.0;
                        continue;
                    }
                    if (!"r_sp".equalsIgnoreCase(criteria)) continue;
                    if (PropertyValidator.isValid((Object)item.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(item.getStatus().getCategory())) {
                        results[0] = results[0] + item.getStoryPoints();
                    }
                    results[1] = results[1] + item.getStoryPoints();
                }
            }
        }
        return results;
    }

    public Map<String, Object> getSeriesForBatches(Map<Date, Map<String, Object>> datedProgressMap, Collection<String> allItemIds, List<Date> intervalDates) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, ArrayList<Double>> series = new HashMap<String, ArrayList<Double>>();
        for (String itemId : allItemIds) {
            series.put(itemId, new ArrayList<Double>(Collections.nCopies(intervalDates.size(), 0.0)));
        }
        for (int i = 0; i < intervalDates.size(); ++i) {
            Date date = intervalDates.get(i);
            Map<String, Object> dailyProgress = datedProgressMap.get(date);
            if (null == dailyProgress || dailyProgress.isEmpty()) continue;
            for (Map.Entry<String, Object> batchProgress : dailyProgress.entrySet()) {
                Map batchEntry = (Map)batchProgress.getValue();
                double batchProgressValue = 0.0;
                if (PropertyValidator.isValid(batchEntry.get("batchProgress"))) {
                    batchProgressValue = (Double)batchEntry.get("batchProgress");
                }
                if (series.containsKey(batchProgress.getKey())) {
                    ((List)series.get(batchProgress.getKey())).set(i, batchProgressValue);
                }
                for (String itemId : allItemIds) {
                    if (!batchEntry.containsKey(itemId)) continue;
                    Map subBatchEntry = (Map)batchEntry.get(itemId);
                    double subBatchProgress = (Double)subBatchEntry.get("batchProgress");
                    if (!series.containsKey(itemId)) continue;
                    ((List)series.get(itemId)).set(i, subBatchProgress);
                }
            }
        }
        result.put("series", series);
        return result;
    }

    private String fetchBatchProgressTitle(String code) {
        switch (code) {
            case "c_lis": {
                return "By Linked Items (Status)";
            }
            case "c_st": {
                return "By Done Children (Status)";
            }
            case "r_st": {
                return "By Rollup (Status)";
            }
            case "r_sp": {
                return "By Rollup (Story Points)";
            }
        }
        return "";
    }

    public Map<Date, Map<String, BacklogItem>> fetchRoadmapLinkedBacklogItems(List<String> backlogItemIds, String tenant, Date startDate, Date endDate, Date syncDate, List<Date> intervalDates, String interval, String releaseTrainId) throws Exception {
        HashSet<String> attachedReleaseTrains = new HashSet<String>();
        attachedReleaseTrains.add(releaseTrainId);
        BasicDBObject queryForBacklog = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", backlogItemIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        BasicDBObject queryForBacklogEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", backlogItemIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
        List mappedBacklogItems = this.fetchBacklogItems((DBObject)queryForBacklogEarliest, "backlogItemTimeSeries", false, -1);
        mappedBacklogItems.addAll(this.fetchBacklogItems((DBObject)queryForBacklog, "backlogItemTimeSeries", true, 1));
        LOGGER.info("Roadmap linked backlog items found of size :{}", (Object)mappedBacklogItems.size());
        if (PropertyValidator.isValid((Collection)mappedBacklogItems)) {
            Map datedBacklogItemsMap = this.mapBackLogItemToDates(mappedBacklogItems, intervalDates, interval, false, null);
            Map nestedBackLogItems = this.buildBackLogNthLevelHierarchy(mappedBacklogItems, intervalDates, tenant, startDate, endDate, interval, false, null, syncDate, attachedReleaseTrains, "", new HashSet(), new HashSet());
            if (null != datedBacklogItemsMap && null != nestedBackLogItems) {
                for (Map.Entry nestedBacklogItemEntry : nestedBackLogItems.entrySet()) {
                    Map value = (Map)nestedBacklogItemEntry.getValue();
                    Date key = (Date)nestedBacklogItemEntry.getKey();
                    if (null == value || null == datedBacklogItemsMap.get(key)) continue;
                    for (BacklogItem item : ((Map)datedBacklogItemsMap.get(key)).values()) {
                        HashSet childItemIds = new HashSet();
                        for (String releaseTrain : attachedReleaseTrains) {
                            List links;
                            if (!PropertyValidator.isValid((Collection)((Collection)item.getChildRelationMap().get(releaseTrain))) || !PropertyValidator.isValid((Collection)(links = (List)item.getChildRelationMap().get(releaseTrain)))) continue;
                            childItemIds.addAll(links.stream().filter(l -> EnumKendis.ART_CHILD_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBacklogItemId).distinct().collect(Collectors.toList()));
                        }
                        if (childItemIds.isEmpty()) continue;
                        for (ObjectId childItemId : childItemIds) {
                            BacklogItem childItem;
                            int rowStatus;
                            String id = childItemId.toString();
                            if (!value.containsKey(id) || (rowStatus = Optional.ofNullable(childItem = (BacklogItem)value.get(id)).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseEntity::getRowStatus).findFirst().orElse(0).intValue()) != 0 || item.getBacklogItemsMap().containsKey(childItem.getId())) continue;
                            item.getBacklogItemsMap().computeIfAbsent(childItem.getId(), l -> new ArrayList()).add(childItem);
                        }
                    }
                }
            }
            return datedBacklogItemsMap;
        }
        return null;
    }

    public Map<Date, Map<String, RoadmapSection>> mapRoadMapSectionsToDates(List<RoadmapSection> logs, List<Date> dateList, String interval) throws Exception {
        LinkedHashMap<Date, Map<String, RoadmapSection>> resultMap = new LinkedHashMap<Date, Map<String, RoadmapSection>>();
        if (!logs.isEmpty()) {
            Map logMap = logs.stream().collect(Collectors.groupingBy(log -> TimeSeriesUtils.stripTime((Date)log.getCreatedOn()), TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(BaseEntity::getCreatedOn)).collect(Collectors.toList()))));
            HashMap allKnownLogs = new HashMap();
            Date startOfInterval = dateList.get(0);
            if ("monthly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("quarterly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusMonths(3L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("weekly".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusWeeks(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            } else if ("daily".equalsIgnoreCase(interval)) {
                startOfInterval = Date.from(dateList.get(0).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            for (int i = 0; i < dateList.size(); ++i) {
                Date endOfInterval = dateList.get(i);
                HashMap<String, RoadmapSection> intervalLogsMap = new HashMap<String, RoadmapSection>(allKnownLogs);
                for (Map.Entry entry : logMap.entrySet()) {
                    Date logDate = (Date)entry.getKey();
                    if (endOfInterval != null && logDate.after(endOfInterval)) continue;
                    for (RoadmapSection log2 : (List)entry.getValue()) {
                        intervalLogsMap.put(log2.getId(), new RoadmapSection(log2));
                    }
                }
                allKnownLogs.putAll(intervalLogsMap);
                if (allKnownLogs.isEmpty() && i == 0) {
                    for (RoadmapSection earliestLog : (List)logMap.entrySet().iterator().next().getValue()) {
                        if (!earliestLog.getCreatedOn().before(startOfInterval)) continue;
                        allKnownLogs.put(earliestLog.getId(), new RoadmapSection(earliestLog));
                        for (Map.Entry entry : allKnownLogs.entrySet()) {
                            intervalLogsMap.put((String)entry.getKey(), new RoadmapSection((RoadmapSection)entry.getValue()));
                        }
                    }
                }
                resultMap.put(endOfInterval, intervalLogsMap);
                startOfInterval = endOfInterval;
            }
        }
        return resultMap;
    }

    public Map<String, Object> calculateRoadmapProgress(Board roadmap, String progressCriteria, Set<String> attachedReleaseTrains) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Serializable> roadmapProgressMap = new HashMap<String, Serializable>();
        LinkedHashMap<String, Map> allSectionsData = new LinkedHashMap<String, Map>();
        double sectionsSize = 0.0;
        double roadMapProgress = 0.0;
        for (RoadmapSection roadmapSection : roadmap.getRoadmapSectionMap().values()) {
            HashMap<String, Number> sectionsMap = new HashMap<String, Number>();
            double[] results = new double[]{0.0, 0.0};
            results = this.calculateBatchesItemsProgress(roadmapSection.getBacklogItemMap(), results, progressCriteria, attachedReleaseTrains);
            double totalProgress = results[0] / results[1] * 100.0;
            if (Double.isNaN(totalProgress)) {
                sectionsMap.put("sectionProgress", 0.0);
            }
            if (roadmapSection.getBacklogItemMap().isEmpty()) {
                sectionsMap.put("sectionProgress", null);
                sectionsMap.put("totalDone", 0);
                sectionsMap.put("totalSize", 0);
            } else {
                sectionsMap.put("sectionProgress", (double)Math.round(totalProgress * 10.0) / 10.0);
                sectionsMap.put("totalDone", results[0]);
                sectionsMap.put("totalSize", results[1]);
                sectionsSize += 1.0;
            }
            if (!Double.isNaN(totalProgress)) {
                roadMapProgress += totalProgress;
            }
            allSectionsData.put(roadmapSection.getId(), sectionsMap);
        }
        Map nullValue = (Map)allSectionsData.remove("null");
        allSectionsData.put("null", nullValue);
        roadmapProgressMap.put("sectionsProgress", allSectionsData);
        roadmapProgressMap.put("roadmapProgress", Double.valueOf((double)Math.round((roadMapProgress /= sectionsSize) * 10.0) / 10.0));
        resultMap.put(roadmap.getId(), roadmapProgressMap);
        return resultMap;
    }

    public Map<String, Object> getSeriesForRoadmaps(Map<Date, Map<String, Object>> datedProgressMap, String roadmapId, List<Date> intervalDates) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, ArrayList<Double>> series = new HashMap<String, ArrayList<Double>>();
        series.put(roadmapId, new ArrayList<Double>(Collections.nCopies(intervalDates.size(), 0.0)));
        for (int i = 0; i < intervalDates.size(); ++i) {
            Date date = intervalDates.get(i);
            Map<String, Object> dailyProgress = datedProgressMap.get(date);
            if (null == dailyProgress || dailyProgress.isEmpty()) continue;
            Map roadmapProgressMap = (Map)dailyProgress.get(roadmapId);
            double roadmapProgressValue = 0.0;
            if (PropertyValidator.isValid(roadmapProgressMap.get("roadmapProgress"))) {
                roadmapProgressValue = (Double)roadmapProgressMap.get("roadmapProgress");
            }
            if (!series.containsKey(roadmapId)) continue;
            ((List)series.get(roadmapId)).set(i, roadmapProgressValue);
        }
        result.put("series", series);
        return result;
    }
}

