/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.sun.management.OperatingSystemMXBean;
import com.viztrend.safe.Application;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemUtil {
    public static String userHomeFolderPath;
    public static String kendisHomeFolderPath;
    public static final String CA_CERT_PROP_KEY = "ca.certificate.path";
    public static final String CERT_PROP_KEY = "certificate.path";
    public static final String KEY_FILE_PROP_KEY = "key.file.path";
    public static String logsFilePath;
    public static String resourcesFolderPath;
    public static String backupFolder;
    public static String tempFolder;
    public static String tokenAuthorizedUrl;
    public static String properiesFile;
    public static String portsFileName;
    private static String sysPassFile;
    public static String sysPassFilePath;
    private static String defaultPassword;
    private static Properties portProperties;
    private static boolean isWindwos;
    private static boolean isMAC;
    public static boolean isLocalDeployment;
    private static String domain;
    private static String serverReplica;
    public static boolean isSysEnabled;
    private static boolean debug;
    private static boolean isSharedSprintEnabled;
    private static boolean isTeamFieldEnabled;
    public static Properties props;
    private static final Logger LOGGER;

    public static Properties getDefaultProperties() {
        LOGGER.info("Kendis build version  :" + SystemUtil.getAppVersion());
        if (userHomeFolderPath != null) {
            LOGGER.info("Home directory :" + userHomeFolderPath);
        }
        try {
            domain = props.getProperty("server.domain");
            String nodeInfo = System.getenv("node");
            serverReplica = PropertyValidator.isValid((Object)nodeInfo) ? nodeInfo : props.getProperty("server.replica");
            props.setProperty("server.session.timeout", "-1");
            props.setProperty("server.session.cookie.max-age", "-1");
            String aws_accessKey = System.getenv("aws_accessKey");
            String aws_secretKey = System.getenv("aws_secretKey");
            String sqs_aws_accessKey = System.getenv("sqs_aws_accessKey");
            String sqs_aws_secretKey = System.getenv("sqs_aws_secretKey");
            String aws_kms_key_id = System.getenv("aws_kms_key_id");
            String mongo_user = System.getenv("mongo_user");
            String mongo_pass = System.getenv("mongo_pass");
            String pusher_app_id = System.getenv("pusher.app_id");
            String pusher_key = System.getenv("pusher.key");
            String pusher_secret = System.getenv("pusher.secret");
            String pusher_cluster = System.getenv("pusher.cluster");
            if (PropertyValidator.isValid((Object)aws_accessKey)) {
                LOGGER.info("setting aws.accessKey:" + aws_accessKey.substring(0, 3));
                props.setProperty("aws.accessKey", aws_accessKey);
            }
            if (PropertyValidator.isValid((Object)aws_secretKey)) {
                LOGGER.info("setting aws.secretKey:" + aws_secretKey.substring(0, 3));
                props.setProperty("aws.secretKey", aws_secretKey);
            }
            if (PropertyValidator.isValid((Object)sqs_aws_accessKey)) {
                LOGGER.info("setting sqs.aws.accessKey:" + sqs_aws_accessKey.substring(0, 3));
                props.setProperty("sqs.aws.accessKey", sqs_aws_accessKey);
            }
            if (PropertyValidator.isValid((Object)sqs_aws_secretKey)) {
                LOGGER.info("setting sqs.aws.secretKey:" + sqs_aws_secretKey.substring(0, 3));
                props.setProperty("sqs.aws.secretKey", sqs_aws_secretKey);
            }
            if (PropertyValidator.isValid((Object)aws_kms_key_id)) {
                LOGGER.info("setting aws.kms_key_id:" + aws_kms_key_id.substring(0, 3));
                props.setProperty("aws.kms_key_id", aws_kms_key_id);
            }
            if (PropertyValidator.isValid((Object)mongo_user)) {
                LOGGER.info("setting mongo.user:" + mongo_user.substring(0, 3));
                props.setProperty("mongo.user", mongo_user);
            }
            if (PropertyValidator.isValid((Object)mongo_pass)) {
                LOGGER.info("setting mongo.pass:" + mongo_pass.substring(0, 3));
                props.setProperty("mongo.pass", mongo_pass);
            }
            if (PropertyValidator.isValid((Object)pusher_app_id)) {
                props.setProperty("pusher.app_id", pusher_app_id);
            }
            if (PropertyValidator.isValid((Object)pusher_key)) {
                props.setProperty("pusher.key", pusher_key);
            }
            if (PropertyValidator.isValid((Object)pusher_secret)) {
                props.setProperty("pusher.secret", pusher_secret);
            }
            if (PropertyValidator.isValid((Object)pusher_cluster)) {
                props.setProperty("pusher.cluster", pusher_cluster);
            }
            if (props.getProperty("isLocalDeployment").equals("true")) {
                isLocalDeployment = true;
                String dbPort = "27017";
                String dbHost = "127.0.0.1";
                String dbName = "kendis";
                String dbUser = null;
                String dbPassword = null;
                String port = null;
                props.setProperty("payment.cronExpression", "0 0 17 * * ?");
                props.setProperty("spring.http.multipart.maxFileSize", "128000MB");
                props.setProperty("spring.http.multipart.maxRequestSize", "128000MB");
                props.setProperty("isLocalDeployment", "true");
                props.setProperty("mongo.db", dbName);
                props.setProperty("app.env", "onsite");
                props.setProperty("resource-domain", "/");
                props.setProperty("resource-version", "" + new Date().getTime());
                props.setProperty("management.context-path", "/system");
                props.setProperty("management.health.ldap.enabled", "false");
                props.setProperty("management.security.enabled", "false");
                props.setProperty("webhook.scheduler.rate", "20000");
                String keystore = System.getenv("keystore");
                if (keystore != null) {
                    props.setProperty("mutualTls", "true");
                } else {
                    props.setProperty("mutualTls", "false");
                }
                if (isSysEnabled) {
                    props.setProperty("endpoints.enabled", "true");
                }
                if (isSharedSprintEnabled) {
                    props.setProperty("isSharedSprintEnabled", "true");
                }
                if (isTeamFieldEnabled) {
                    props.setProperty("isTeamFieldEnabled", "true");
                }
                props.setProperty("s3.resource.url", "/local/resource/");
                props.setProperty("spring.thymeleaf.mode", "LEGACYHTML5");
                props.setProperty("mongo.port", dbPort);
                props.setProperty("mongo.url1", dbHost);
                props.setProperty("mongo.url2", dbHost);
                props.setProperty("server.port", "8080");
                props.setProperty("isWindow", "false");
                if (portProperties != null && portProperties.size() > 0) {
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("server.port"))) {
                        port = portProperties.getProperty("server.port");
                        props.setProperty("server.port", port);
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("db.port"))) {
                        dbPort = portProperties.getProperty("db.port");
                        props.setProperty("mongo.port", dbPort);
                    } else {
                        props.remove("mongo.port");
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("db.host"))) {
                        dbHost = portProperties.getProperty("db.host");
                        props.setProperty("mongo.url1", dbHost);
                        props.setProperty("mongo.url2", dbHost);
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("ca.certificate.path"))) {
                        props.setProperty("ca.certificate.path", portProperties.getProperty("ca.certificate.path"));
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("certificate.path"))) {
                        props.setProperty("certificate.path", portProperties.getProperty("certificate.path"));
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("key.file.path"))) {
                        props.setProperty("key.file.path", portProperties.getProperty("key.file.path"));
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("ssl.password"))) {
                        props.setProperty("ssl.password", portProperties.getProperty("ssl.password"));
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("db.user"))) {
                        dbUser = portProperties.getProperty("db.user");
                        props.setProperty("mongo.user", dbUser);
                    } else {
                        props.remove("mongo.user");
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("db.name"))) {
                        dbName = portProperties.getProperty("db.name");
                        props.setProperty("mongo.db", dbName);
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("db.password"))) {
                        dbPassword = portProperties.getProperty("db.password");
                        props.setProperty("mongo.pass", dbPassword);
                    } else {
                        props.remove("mongo.pass");
                    }
                    if (PropertyValidator.isValid((Object)portProperties.getProperty("tokenAuthorizedUrl"))) {
                        LOGGER.info("Found TokenAuthorizeUrl   :" + portProperties.getProperty("tokenAuthorizedUrl"));
                        tokenAuthorizedUrl = portProperties.getProperty("tokenAuthorizedUrl");
                    }
                    props.setProperty("isWindow", "true");
                }
                props.setProperty("logging.file", logsFilePath);
                props.setProperty("attachment.location", resourcesFolderPath);
                props.setProperty("temp.file.location", tempFolder);
                props.setProperty("backup.location", backupFolder);
                if ("true".equals(props.getProperty("isTeamFieldEnabled"))) {
                    LOGGER.info("TeamFieldEnabled");
                }
                if ("true".equals(props.getProperty("isSharedSprintEnabled"))) {
                    LOGGER.info("SharedSprintEnabled");
                }
                try {
                    if (SystemUtil.getSysPass() == null) {
                        SystemUtil.setSysPass((String)defaultPassword);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                }
            }
            SystemUtil.printSystemDetails();
            LOGGER.info("Going to connect database using : host " + props.getProperty("mongo.url1") + " port:" + props.getProperty("mongo.port") + " database:" + props.getProperty("mongo.db"));
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return props;
    }

    public static String getSysPass() {
        String fileName = sysPassFilePath;
        String password = null;
        try {
            File passFile = new File(fileName);
            if (passFile.exists()) {
                String line;
                FileReader fileReader = new FileReader(passFile);
                BufferedReader br = new BufferedReader(fileReader);
                while ((line = br.readLine()) != null) {
                    password = line;
                }
                br.close();
            }
            if (EncDecUtility.isEncrypted(password)) {
                password = EncDecUtility.decrypt(password);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return password;
    }

    public static String uploadFileToServer(MultipartFile multipartFile) {
        if (!PropertyValidator.isValid((Object)multipartFile)) {
            return "";
        }
        try {
            String filePath = kendisHomeFolderPath + "/" + multipartFile.getOriginalFilename();
            Path newFilePath = Paths.get(kendisHomeFolderPath, multipartFile.getOriginalFilename());
            multipartFile.transferTo(newFilePath.toFile());
            return filePath;
        }
        catch (Exception exception) {
            LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            return null;
        }
    }

    public static String getOrigin(HttpServletRequest request) {
        if (props.getProperty("isLocalDeployment").equals("true")) {
            return "";
        }
        String scheme = Optional.ofNullable(request.getHeader("X-Forwarded-Proto")).orElse(request.getScheme());
        String host = Optional.ofNullable(request.getHeader("X-Forwarded-Host")).orElse(request.getServerName());
        String port = Optional.ofNullable(request.getHeader("X-Forwarded-Port")).orElse(String.valueOf(request.getServerPort()));
        if (!("http".equals(scheme) && "80".equals(port) || "https".equals(scheme) && "443".equals(port))) {
            host = host + ":" + port;
        }
        String urlPrefix = scheme + "://" + host;
        return urlPrefix;
    }

    public static HashMap<String, Object> updateDBSettings(String host, String port, String user, String pass, String db, String sslPassword, String caCertPath, String certPath, String keyFilePath) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            FileOutputStream out = new FileOutputStream(kendisHomeFolderPath + "/" + portsFileName);
            if (PropertyValidator.isValid((Object)user)) {
                portProperties.setProperty("db.user", user);
            } else {
                portProperties.remove("db.user");
            }
            if (PropertyValidator.isValid((Object)pass)) {
                portProperties.setProperty("db.password", pass);
            } else {
                portProperties.remove("db.password");
            }
            if (PropertyValidator.isValid((Object)db)) {
                portProperties.setProperty("db.name", db);
            } else {
                portProperties.remove("db.name");
            }
            portProperties.setProperty("db.host", host);
            portProperties.setProperty("db.port", port);
            if (PropertyValidator.isValid((Object)sslPassword)) {
                portProperties.setProperty("ssl.password", sslPassword);
            } else {
                portProperties.remove("ssl.password");
            }
            if (PropertyValidator.isValid((Object)caCertPath)) {
                portProperties.setProperty("ca.certificate.path", caCertPath);
            } else {
                portProperties.remove("ca.certificate.path");
            }
            if (PropertyValidator.isValid((Object)certPath)) {
                portProperties.setProperty("certificate.path", certPath);
            } else {
                portProperties.remove("certificate.path");
            }
            if (PropertyValidator.isValid((Object)keyFilePath)) {
                portProperties.setProperty("key.file.path", keyFilePath);
            } else {
                portProperties.remove("key.file.path");
            }
            portProperties.store(out, null);
            out.close();
            responseMap.put("success", true);
            return responseMap;
        }
        catch (Exception e) {
            responseMap.put("success", false);
            responseMap.put("error", StringUtils.getTraceString((Throwable)e));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return responseMap;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(Application.class.getResource("/" + properiesFile).getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printSystemDetails() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long memory = bean.getFreePhysicalMemorySize();
        LOGGER.info("Available OS memory (MB) :" + memory / 0x100000L);
        LOGGER.info("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
        LOGGER.info("Free JVM memory (MB): " + Runtime.getRuntime().freeMemory() / 0x100000L);
        long maxMemory = Runtime.getRuntime().maxMemory();
        LOGGER.info("Maximum JVM memory (MB): " + (maxMemory == Long.MAX_VALUE ? "no limit" : Long.valueOf(maxMemory / 0x100000L)));
        LOGGER.info("Total JVM memory (MB): " + Runtime.getRuntime().totalMemory() / 0x100000L);
    }

    public static String setSysPass(String pass) {
        BufferedWriter writer = null;
        try {
            File passFile = new File(sysPassFilePath);
            passFile.createNewFile();
            writer = new BufferedWriter(new FileWriter(passFile));
            pass = EncDecUtility.encrypt((String)pass);
            writer.write(pass);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    public static String getAppVersion() {
        try {
            InputStream is = Application.class.getResourceAsStream("/ORIG_HEAD");
            if (is == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            is.close();
            is = Application.class.getResourceAsStream("/HEAD");
            line = null;
            bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(" : " + line.substring(line.lastIndexOf("/") + 1, line.length()));
            }
            is = Application.class.getResourceAsStream("/build-ver.txt");
            if (is != null) {
                line = null;
                bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(" : " + line);
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception ex) {
            LOGGER.error("Error in app version fetching :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public static String getReplicaState() {
        return serverReplica;
    }

    public static boolean isCloudDomain(String domain) {
        String[] domains;
        for (String d : domains = new String[]{".kendis.io", ".prescrum.com", ".prescrum.com", ".kenv2.com", ".kendisboards.com", "52.6.236.139", "localhost", ".k1deve.com", ".k2deve.com", ".k4deve.com", ".agile4startups.com", "34.203.102.119"}) {
            if (!domain.endsWith(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProductionCloudDomain(String domain) {
        String[] domains;
        for (String d : domains = new String[]{".kendis.io"}) {
            if (!domain.endsWith(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProductionCloudEnv() {
        return "kendis.io".equals(domain) && !isLocalDeployment;
    }

    @Deprecated
    public static boolean isProductionEnv() {
        boolean flag = true;
        return flag;
    }

    static {
        kendisHomeFolderPath = "/var/lib/kendis-config";
        logsFilePath = "/var/log/kendis-logs/kendis.log";
        resourcesFolderPath = "/var/lib/kendis-resources";
        backupFolder = "/var/lib/kendis-backup";
        tempFolder = "/opt/temp/";
        properiesFile = "kendis.properties";
        portsFileName = "app.config";
        sysPassFile = "kendispass";
        sysPassFilePath = resourcesFolderPath + "/" + sysPassFile;
        defaultPassword = "admin";
        portProperties = new Properties();
        isWindwos = SystemUtils.IS_OS_WINDOWS;
        isMAC = SystemUtils.IS_OS_MAC;
        isLocalDeployment = false;
        domain = "";
        serverReplica = "1";
        isSysEnabled = true;
        debug = false;
        isSharedSprintEnabled = false;
        isTeamFieldEnabled = false;
        props = new Properties();
        LOGGER = LoggerFactory.getLogger(SystemUtil.class);
        try {
            System.setProperty("mail.mime.charset", "utf8");
            props.load(Application.class.getResourceAsStream("/" + properiesFile));
            String isWindowExe = System.getenv("isWindowExe");
            String use265bit = System.getenv("aes256");
            String sysenabed = System.getenv("sysenabed");
            String sharedSprintEnabled = System.getenv("sharedSprintEnabled");
            String teamFieldEnabled = System.getenv("teamFieldEnabled");
            String isDebug = System.getenv("debug");
            if (sharedSprintEnabled != null && "true".equals(sharedSprintEnabled)) {
                isSharedSprintEnabled = true;
            }
            if (teamFieldEnabled != null && "true".equals(teamFieldEnabled)) {
                isTeamFieldEnabled = true;
            }
            if (sysenabed != null && "false".equals(sysenabed)) {
                isSysEnabled = false;
            }
            if (use265bit != null && "true".equals(use265bit)) {
                EncDecUtility.use265Bit = true;
            }
            if (isDebug != null && "true".equals(isDebug)) {
                debug = true;
            }
            if ("true".equals(isWindowExe)) {
                if (isWindwos || isMAC) {
                    LOGGER.info("Kendis is running on Windows");
                    userHomeFolderPath = System.getProperty("user.dir");
                } else {
                    LOGGER.info("Kendis is running on Linux");
                    String jarDir = Application.class.getResource("/" + properiesFile).getPath();
                    jarDir = jarDir.replace("file:", "");
                    userHomeFolderPath = jarDir = jarDir.replace("kendis-1.0.jar!/BOOT-INF/classes!/kendis.properties", "");
                }
                LOGGER.info("Resource directory :" + userHomeFolderPath);
                File userHomefolder = new File(userHomeFolderPath);
                if (userHomefolder.canWrite()) {
                    File backupFolderDir;
                    File resourcesFolderDir;
                    File tempFolderDir;
                    kendisHomeFolderPath = userHomeFolderPath + "/kendis";
                    backupFolder = kendisHomeFolderPath + "/kendis-backup";
                    resourcesFolderPath = kendisHomeFolderPath + "/kendis-resources";
                    tempFolder = kendisHomeFolderPath + "/temp/";
                    File kendisHomefolder = new File(kendisHomeFolderPath);
                    if (!kendisHomefolder.exists()) {
                        LOGGER.info("Creating home directory");
                        kendisHomefolder.mkdir();
                    }
                    if (!(tempFolderDir = new File(tempFolder)).exists()) {
                        LOGGER.info("Creating temp directory");
                        tempFolderDir.mkdir();
                    }
                    if (!(resourcesFolderDir = new File(resourcesFolderPath)).exists()) {
                        LOGGER.info("Creating resource directory");
                        resourcesFolderDir.mkdir();
                    }
                    if (!(backupFolderDir = new File(backupFolder)).exists()) {
                        LOGGER.info("Creating backup directory");
                        backupFolderDir.mkdir();
                    }
                    sysPassFilePath = kendisHomeFolderPath + "/" + sysPassFile;
                }
            }
            if (props.getProperty("isLocalDeployment").equals("true") && new File(kendisHomeFolderPath).canWrite()) {
                File portsFile = new File(kendisHomeFolderPath + "/" + portsFileName);
                if (!portsFile.exists()) {
                    portsFile.createNewFile();
                    List<String> lines = Arrays.asList("server.port=8080", "db.host=127.0.0.1", "db.port=27017", "#db.name=<dbName>", "#db.user=<user>", "#db.password=<password>", "#tokenAuthorizedUrl=<url>");
                    Path file = Paths.get(kendisHomeFolderPath + "/" + portsFileName, new String[0]);
                    Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                FileInputStream input = new FileInputStream(kendisHomeFolderPath + "/" + portsFileName);
                portProperties.load(input);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }
}

