/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class S3CacheUtil {
    private static final String BUCKET_NAME = "webhook-lambda-cache";
    private static final String FILE_KEY = "activeCache.json";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static AmazonS3 s3Client;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.env.getProperty("sqs.aws.accessKey"), this.env.getProperty("sqs.aws.secretKey"));
        s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(this.env.getProperty("aws.region", "us-east-1"))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    public static Set<String> getActiveAccounts() throws Exception {
        S3Object s3Object = s3Client.getObject("webhook-lambda-cache", "activeCache.json");
        String json = IOUtils.toString((InputStream)s3Object.getObjectContent());
        List list = (List)mapper.readValue(json, List.class);
        return new HashSet<String>(list);
    }

    public static void blockAccount(String almAccountId) throws Exception {
        Set accounts = S3CacheUtil.getActiveAccounts();
        accounts.add(almAccountId);
        String updatedJson = mapper.writeValueAsString((Object)accounts);
        s3Client.putObject(new PutObjectRequest("webhook-lambda-cache", "activeCache.json", (InputStream)new ByteArrayInputStream(updatedJson.getBytes(StandardCharsets.UTF_8)), null));
    }

    public static void unblockAccount(String almAccountId) throws Exception {
        Set accounts = S3CacheUtil.getActiveAccounts();
        accounts.remove(almAccountId);
        String updatedJson = mapper.writeValueAsString((Object)accounts);
        s3Client.putObject(new PutObjectRequest("webhook-lambda-cache", "activeCache.json", (InputStream)new ByteArrayInputStream(updatedJson.getBytes(StandardCharsets.UTF_8)), null));
    }

    public static void main(String[] args) throws Exception {
        StandardEnvironment env = new StandardEnvironment();
    }

    public static void regenerateAccounts(List<String> accountIds) throws Exception {
        if (accountIds == null) {
            throw new IllegalArgumentException("accountIds cannot be null");
        }
        HashSet<String> uniqueAccounts = new HashSet<String>(accountIds);
        String updatedJson = mapper.writeValueAsString(uniqueAccounts);
        s3Client.putObject(new PutObjectRequest("webhook-lambda-cache", "activeCache.json", (InputStream)new ByteArrayInputStream(updatedJson.getBytes(StandardCharsets.UTF_8)), null));
    }
}

