/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.viztrend.safe.alm.tfs.TFSMeta;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.enums.EnumActivityType;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemLogDetail;
import com.viztrend.safe.persistence.entity.ItemLogMap;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Severity;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang.WordUtils;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

/*
 * Exception performing whole class analysis ignored.
 */
public class KendisUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);

    public static String dbName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        return name.subSequence(0, 1).toString().toLowerCase() + name.substring(1);
    }

    public static List<Severity> getDeaultSeverities() {
        Date now = new Date();
        String loggedInUser = null;
        if (UserContextUtil.getUserContext() != null) {
            loggedInUser = UserContextUtil.getUserContext().getLoggedInUser().getUserName();
        }
        ArrayList<Severity> severityList = new ArrayList<Severity>();
        severityList.add(new Severity(ObjectId.get().toString(), loggedInUser, now, "Blocker", "#ec1b00"));
        severityList.add(new Severity(ObjectId.get().toString(), loggedInUser, now, "Critical", "#eba800"));
        severityList.add(new Severity(ObjectId.get().toString(), loggedInUser, now, "Major", "#965699"));
        severityList.add(new Severity(ObjectId.get().toString(), loggedInUser, now, "Minor", "#999999"));
        severityList.add(new Severity(ObjectId.get().toString(), loggedInUser, now, "Enhancement", "#997556"));
        return severityList;
    }

    public static boolean isActionAllowed(String permissionCode, List<String> restrictions) {
        return !PropertyValidator.isValid(restrictions) || !restrictions.contains(permissionCode);
    }

    public static List<String> getRestrictions(WorkSpaceRepository workSpaceRepository, WorkSpaceAccessRoleRepository accessRoleRepository, String currentWorkSpaceId) {
        User contextUser = UserContextUtil.getUserContext().getLoggedInUser();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        boolean isAdmin = false;
        boolean isSuperAdmin = false;
        for (int i = 0; i < contextUser.getUserCompanies().size(); ++i) {
            if (!cid.equals(((UserCompany)contextUser.getUserCompanies().get(i)).getCompany().getId())) continue;
            isAdmin = ((UserCompany)contextUser.getUserCompanies().get(i)).getIsAdmin();
            isSuperAdmin = ((UserCompany)contextUser.getUserCompanies().get(i)).getIsAdmin();
            break;
        }
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        Object defaulCodes = null;
        if (PropertyValidator.isValid((Object)contextUser) && (isAdmin || isSuperAdmin)) {
            workSpaces = Sets.newHashSet((Iterable)workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(contextUser);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = PropertyValidator.isValid((Object)currentWorkSpaceId) ? accessRoleRepository.findByUserAndWorkSpace(contextUser, new WorkSpace(currentWorkSpaceId)) : accessRoleRepository.findByUser(contextUser);
        }
        ArrayList<String> totalRoles = new ArrayList<String>();
        HashMap<String, Integer> common = new HashMap<String, Integer>();
        List<WorkSpaceAccessRole> accessRoles = workSpaceAccessRoles;
        ArrayList<String> restrictions = new ArrayList<String>();
        if (PropertyValidator.isValid(accessRoles)) {
            for (WorkSpaceAccessRole accessRole : accessRoles) {
                if (!PropertyValidator.isValid((Collection)accessRole.getRoles())) continue;
                for (Role role : accessRole.getRoles()) {
                    if (!PropertyValidator.isValid((Collection)role.getRestrictions())) continue;
                    totalRoles.add(role.getId());
                    for (String restriction : restrictions) {
                        if (common.get(restriction) == null) {
                            common.put(restriction, 0);
                        }
                        common.put(restriction, (Integer)common.get(restriction) + 1);
                    }
                }
            }
        }
        Set codes = common.keySet();
        for (String restriction : codes) {
            if (common.get(restriction) == null || (Integer)common.get(restriction) <= 0 || !((Integer)common.get(restriction)).equals(totalRoles.size())) continue;
            restrictions.add(restriction);
        }
        return restrictions;
    }

    public static HashMap<String, Object> getTfsMeta(SessionBoard sessionBoard, TFSProjectRepository tfsProjectRepository, WorkFlowItemTypeRepository workFlowItemTypeRepository, WorkFlowRepository workFlowRepository, StatusRepository statusRepository, TFSservice tfSservice) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List tfsProjects = tfsProjectRepository.findBySessionId(sessionBoard.getSession().getId());
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (int i = 0; i < tfsProjects.size(); ++i) {
                TFSProject project = (TFSProject)tfsProjects.get(i);
                List itemTypes = workFlowItemTypeRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                project.setItemTypes(itemTypes);
                WorkFlow workflow = workFlowRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                project.setWorkFlow(workflow);
                List statuses = statusRepository.findByWorkFlow(workflow);
                workflow.setStatuses(statuses);
            }
        }
        response.put("tfsProject", tfsProjects);
        AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        HashMap linkTypesResult = tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
        if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
            response.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
            response.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
        } else {
            TFSMeta tfsMeta = new TFSMeta();
            tfsMeta.setLinkTypes((String)linkTypesResult.get("linkTypes"));
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                tfsMeta.setAlmAccount(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount());
            }
            response.put("tfsMeta", tfsMeta);
        }
        return response;
    }

    public static boolean isCaptchaValid(String secretKey, String response) {
        try {
            int cp;
            String url = "https://www.google.com/recaptcha/api/siteverify?secret=" + secretKey + "&response=" + response;
            InputStream res = new URL(url).openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(res, Charset.forName("UTF-8")));
            StringBuilder sb = new StringBuilder();
            while ((cp = rd.read()) != -1) {
                sb.append((char)cp);
            }
            String jsonText = sb.toString();
            res.close();
            JSONObject json = new JSONObject(jsonText);
            return json.getBoolean("success");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<User> filterUsersByWorkSpace(String cid, List<User> usersList, List<WorkSpaceAccessRole> ws_access) {
        HashMap<String, Boolean> uMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> gMap = new HashMap<String, Boolean>();
        if (PropertyValidator.isValid(ws_access)) {
            for (WorkSpaceAccessRole ws : ws_access) {
                if (PropertyValidator.isValid((Object)ws.getUser())) {
                    uMap.put(ws.getUser().getId(), true);
                }
                if (!PropertyValidator.isValid((Object)ws.getGroup())) continue;
                gMap.put(ws.getGroup().getId(), true);
            }
        }
        ArrayList<User> users = new ArrayList<User>();
        for (User u : usersList) {
            boolean valid = false;
            Boolean admin2 = false;
            Set ug = u.getGroups();
            List ucomps = u.getUserCompanies();
            for (UserCompany ucomp : ucomps) {
                if (ucomp.getCompany() == null || !ucomp.getCompany().getId().equals(cid)) continue;
                admin2 = ucomp.getIsAdmin();
                break;
            }
            if (u.getIsAdmin().booleanValue() || u.getIsSuperAdmin().booleanValue()) {
                valid = true;
            } else if (Boolean.TRUE.equals(admin2)) {
                valid = true;
            } else if (uMap.get(u.getId()) != null) {
                valid = true;
            } else if (PropertyValidator.isValid((Collection)ug)) {
                for (String gid : ug) {
                    if (gMap.get(gid) == null) continue;
                    valid = true;
                    break;
                }
            }
            if (!valid) continue;
            users.add(u);
        }
        return users;
    }

    public static List<Status> sortStatuses(List<Status> status, String statusSequence) {
        if (PropertyValidator.isValid((Object)statusSequence)) {
            Status s = new Status();
            String[] sIds = statusSequence.split(",");
            ArrayList<Status> sorted = new ArrayList<Status>();
            for (int i = 0; i < sIds.length; ++i) {
                s.setId(sIds[i]);
                int index = status.indexOf(s);
                if (index <= -1) continue;
                sorted.add(status.get(index));
                status.remove(index);
            }
            status = null;
            return sorted;
        }
        return status;
    }

    public static void pollBasedResponse(String requestId, JSONObject params, PushResponseRepository pushResponseRepository) {
        try {
            params.put("requestId", (Object)requestId);
            pushResponseRepository.save((Object)new PushResponse(requestId, params.toString(), Boolean.valueOf(true)));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public static void downloadExportFile(String syncId, String filePath, String name, PushResponseRepository pushResponseRepository) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Board");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestId", (Object)requestId);
            pushJson.put("srcPath", (Object)URLEncoder.encode(filePath, "UTF-8"));
            pushJson.put("name", (Object)URLEncoder.encode(name, "UTF-8"));
            pushJson.put("metaMap", (Object)("{\"event\":\"ExportFile\", \"syncId\":\"" + syncId + "\"}"));
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public static void unArchiveItemLink(ItemLinkRepository itemLinkRepository, ItemLink itemLink) {
        itemLink.setArchive(false);
        itemLinkRepository.save((Object)itemLink);
    }

    public static void archiveItemLinks(ItemLinkRepository itemLinkRepository, List<ItemLink> itemLinks) {
        if (itemLinks != null) {
            for (int i = 0; i < itemLinks.size(); ++i) {
                itemLinks.get(i).setArchive(true);
            }
            itemLinkRepository.save(itemLinks);
        }
    }

    public static List<Object> getListAsObjectIds2(Collection<String> list) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (PropertyValidator.isValid(list)) {
            for (String id : list) {
                if ("-1".equals(id)) continue;
                if (ObjectId.isValid((String)id)) {
                    ids.add(new ObjectId(id));
                    continue;
                }
                ids.add(id);
            }
        }
        return ids;
    }

    public static List<ObjectId> getListAsObjectIds(Collection<String> list) {
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid(list)) {
            for (String id : list) {
                if ("-1".equals(id)) continue;
                ids.add(new ObjectId(id));
            }
        }
        return ids;
    }

    public static List<ObjectId> getListAsObjectIds(String id) {
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid((Object)id) && !id.equals("-1")) {
            ids.add(new ObjectId(id));
        }
        return ids;
    }

    public static void pushProgressUpdates(String progressType, String syncId, Object data, PushResponseRepository pushResponseRepository, boolean hasPendingPush) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            boolean otherTab = false;
            JSONObject pushJson = new JSONObject();
            JSONObject metaMap = new JSONObject();
            metaMap.put("syncId", (Object)syncId);
            metaMap.put("event", (Object)progressType);
            String cid = null;
            if (progressType == "converting_finished") {
                pushJson = new JSONObject();
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("done", true);
                pushJson.put("progress", (Object)"converting_finished");
                metaMap.put("event", (Object)"StoringProgress");
            } else if (progressType == "convert_children") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("progress", (Object)"convert_children");
                metaMap.put("event", (Object)"StoringProgress");
            } else if (progressType == "convert_feature") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("progress", (Object)"convert_feature");
                metaMap.put("event", (Object)"StoringProgress");
            } else if (progressType == "progress") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("progress", data);
                metaMap.put("event", (Object)"Progress");
            } else if (progressType == "COMPARISON" || progressType == "JQL") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("data", data);
            } else if (progressType == "WSJF_DATA") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("data", data);
            } else if (progressType.startsWith("Resync") || progressType.startsWith("Refresh")) {
                pushJson.put("type", (Object)"Resync");
                pushJson.put("push", (Object)"Self");
                pushJson.put("data", data);
                if (data instanceof Map) {
                    Map map = (Map)data;
                    metaMap.put("releaseTrainId", map.get("releaseTrainId"));
                    metaMap.put("boardId", map.get("boardId"));
                    metaMap.put("isJira", map.get("isJira"));
                    cid = (String)map.get("cid");
                    otherTab = map.containsKey("syncItems");
                }
            }
            pushJson.put("metaMap", (Object)metaMap.toString());
            if (!PropertyValidator.isValid((Object)requestId) || otherTab) {
                if (cid == null) {
                    PushSender.sendMsg((String)pushJson.toString());
                } else {
                    PushSender.sendMsg(cid, (String)pushJson.toString());
                }
            }
            if (PropertyValidator.isValid((Object)requestId)) {
                pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(!hasPendingPush)));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public static void onResyncComplete(String syncId, String url, String payload, Boolean isReadOnly, AlmAccount almAccount, String sessionBoardId, PushResponseRepository pushResponseRepository) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Resync");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestURL", (Object)url);
            pushJson.put("requestParam", (Object)payload);
            String evt = "";
            evt = Boolean.TRUE.equals(isReadOnly) ? "ReSyncCompared" : "ReSyncDone";
            pushJson.put("metaMap", (Object)("{\"event\":\"" + evt + "\", \"" + (url == null ? "releaseTrainId" : "boardId") + "\" : \"" + sessionBoardId + "\", \"syncId\":\"" + syncId + "\"}"));
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                pushJson.put("requestId", (Object)requestId);
                pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
                if (!Boolean.TRUE.equals(isReadOnly)) {
                    PushSender.sendMsg((String)pushJson.toString());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public static void onResyncError(String syncId, String url, String payload, String boardId, PushResponseRepository pushResponseRepository) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Resync");
            pushJson.put("push", (Object)"Self");
            pushJson.put("error", true);
            pushJson.put("data", (Object)payload);
            pushJson.put("metaMap", (Object)("{\"event\":\"ReSyncError\", \"syncId\":\"" + syncId + "\"}"));
            if (PropertyValidator.isValid((Object)url)) {
                pushJson.put("requestURL", (Object)url);
            }
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public static Query getChildQuery(String sBoardId, Collection<?> activeSessionBoardIds, Collection<?> keys) {
        Query query = new Query();
        Criteria whr1 = new Criteria();
        whr1.orOperator(new Criteria[]{Criteria.where((String)"solutionBoard.$id").is((Object)new ObjectId(sBoardId)), Criteria.where((String)"sessionBoards.$id").in(activeSessionBoardIds)});
        Criteria whr2 = new Criteria();
        whr2.orOperator(new Criteria[]{Criteria.where((String)"jiraKey").in(keys), Criteria.where((String)"tfsId").in(keys)});
        Criteria whr3 = Criteria.where((String)"type").is((Object)Item.Type.Feature.name());
        Criteria whr = new Criteria();
        whr.andOperator(new Criteria[]{whr1, whr2, whr3});
        query.addCriteria((CriteriaDefinition)whr);
        return query;
    }

    public static void checkChanges(Item item) {
        if (item.getStatus().getId().equals(item.getLastUpdatedValue(ItemLog.Changes.status.name()))) {
            item.removeChange(ItemLog.Changes.status.name(), null);
        } else {
            item.putLastUpdatedValue(ItemLog.Changes.status.name(), (Object)true);
        }
        if (item.getType().equals(Item.Type.UserStory.name())) {
            Double v1 = item.getStoryPoints() == null ? 0.0 : item.getStoryPoints();
            if (v1.equals(item.getLastUpdatedValue(ItemLog.Changes.storyPoints.name()))) {
                item.removeChange(ItemLog.Changes.storyPoints.name(), null);
            } else {
                item.putLastUpdatedValue(ItemLog.Changes.storyPoints.name(), (Object)true);
            }
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                item.putLastUpdatedValue(ItemLog.Changes.teamContainers.name(), (Object)true);
            }
        } else {
            TeamContainer tc1 = item.calcPhoenixTC();
            if (PropertyValidator.isValid((Object)tc1)) {
                // empty if block
            }
        }
    }

    public static void addChanges(Item item, ItemLink itemLink, String linkOldStatus) {
        String log = ItemLog.UniquePrefix.byLinks.name() + itemLink.getId();
        if (!itemLink.getStatus().equals(linkOldStatus)) {
            List linkIds = (List)item.getLastUpdatedValue(ItemLog.Changes.itemLinks.name());
            if (linkIds == null) {
                item.putLastUpdatedValue(ItemLog.Changes.itemLinks.name(), new ArrayList());
                linkIds = (List)item.getLastUpdatedValue(ItemLog.Changes.itemLinks.name());
            }
            linkIds.add(log);
        }
    }

    public static void addChanges(boolean isReadOnly, boolean isOld, Item item, Item refItem) {
        if (isReadOnly) {
            return;
        }
        try {
            HashMap<String, Object> changes = null;
            if (isOld) {
                changes = new HashMap<String, Object>();
            } else {
                changes = item.getLastUpdate();
                if (changes == null) {
                    changes = new HashMap();
                }
            }
            if (refItem != null) {
                changes.put(ItemLog.Changes.status.name(), refItem.getStatus().getId());
                if (item.getType().equals(Item.Type.UserStory.name())) {
                    Double v1 = refItem.getStoryPoints() == null ? 0.0 : refItem.getStoryPoints();
                    changes.put(ItemLog.Changes.storyPoints.name(), v1);
                    if (PropertyValidator.isValid((Collection)refItem.getTeamContainers())) {
                        TeamContainer tc1 = (TeamContainer)refItem.getTeamContainers().get(0);
                        changes.put(ItemLog.Changes.teamChanged.name(), tc1.getTeam().getId());
                        changes.put(ItemLog.Changes.containerChanged.name(), tc1.getContainer().getId());
                    }
                } else {
                    TeamContainer tc1 = refItem.calcPhoenixTC();
                    if (PropertyValidator.isValid((Object)tc1)) {
                        changes.put(ItemLog.Changes.teamContainers.name(), tc1.getContainer().getId());
                    }
                }
                if (isOld) {
                    item.setOldSate(changes);
                } else {
                    Map oldValues = (Map)item.getOldSate();
                    if (oldValues != null) {
                        if (changes.get(ItemLog.Changes.status.name()).equals(oldValues.get(ItemLog.Changes.status.name()))) {
                            changes.remove(ItemLog.Changes.status.name());
                        }
                        if (item.getType().equals(Item.Type.UserStory.name())) {
                            if (changes.get(ItemLog.Changes.storyPoints.name()).equals(oldValues.get(ItemLog.Changes.storyPoints.name()))) {
                                changes.remove(ItemLog.Changes.storyPoints.name());
                            }
                            if (changes.containsKey(ItemLog.Changes.teamChanged.name())) {
                                if (changes.get(ItemLog.Changes.teamChanged.name()).equals(oldValues.get(ItemLog.Changes.teamChanged.name()))) {
                                    changes.remove(ItemLog.Changes.teamChanged.name());
                                } else {
                                    changes.put(ItemLog.Changes.teamContainers.name(), true);
                                }
                            } else if (oldValues.containsKey(ItemLog.Changes.teamChanged.name())) {
                                changes.put(ItemLog.Changes.teamChanged.name(), true);
                                changes.put(ItemLog.Changes.teamContainers.name(), false);
                            }
                            if (changes.containsKey(ItemLog.Changes.containerChanged.name())) {
                                if (changes.get(ItemLog.Changes.containerChanged.name()).equals(oldValues.get(ItemLog.Changes.containerChanged.name()))) {
                                    changes.remove(ItemLog.Changes.containerChanged.name());
                                } else {
                                    changes.put(ItemLog.Changes.teamContainers.name(), true);
                                }
                            } else if (oldValues.containsKey(ItemLog.Changes.containerChanged.name())) {
                                changes.put(ItemLog.Changes.containerChanged.name(), true);
                                changes.put(ItemLog.Changes.teamContainers.name(), false);
                            }
                        } else if (changes.containsKey(ItemLog.Changes.teamContainers.name())) {
                            if (changes.get(ItemLog.Changes.teamContainers.name()).equals(oldValues.get(ItemLog.Changes.teamContainers.name()))) {
                                changes.remove(ItemLog.Changes.teamContainers.name());
                            } else {
                                changes.put(ItemLog.Changes.phoenixSequence.name(), true);
                            }
                        } else if (oldValues.containsKey(ItemLog.Changes.teamContainers.name())) {
                            changes.put(ItemLog.Changes.phoenixSequence.name(), false);
                            changes.put(ItemLog.Changes.teamContainers.name(), false);
                        }
                        oldValues.clear();
                        item.setSyncWithART(Boolean.valueOf(true));
                    }
                    if (changes == null || changes.isEmpty()) {
                        item.setLastUpdate(null);
                    } else {
                        item.setLastUpdate(changes);
                    }
                }
                item.setSyncWithART(Boolean.valueOf(true));
            } else {
                item.setSyncWithART(Boolean.valueOf(true));
                if (isOld) {
                    item.setOldSate(changes);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Resync change log : " + e.getMessage());
        }
    }

    public static boolean mapDifference(Map<String, Object> oldFields, Map<String, Object> newFields, Map<String, Object> changes) {
        MapDifference fieldsDiff;
        if (oldFields == null) {
            oldFields = new HashMap<String, Object>();
        }
        if (newFields == null) {
            newFields = new HashMap<String, Object>();
        }
        if ((fieldsDiff = Maps.difference(oldFields, newFields)) != null) {
            HashMap fieldChanges = new HashMap();
            fieldChanges.putAll(fieldsDiff.entriesDiffering());
            fieldChanges.putAll(fieldsDiff.entriesOnlyOnLeft());
            fieldChanges.putAll(fieldsDiff.entriesOnlyOnRight());
            if (!fieldChanges.isEmpty()) {
                changes.put("fields", fieldChanges);
                return true;
            }
        }
        return false;
    }

    public static void addChanges(boolean isReadOnly, boolean isOld, BacklogItem item, BacklogItem refItem) {
        if (isReadOnly) {
            return;
        }
        try {
            HashMap<String, Object> changes = null;
            if (isOld) {
                changes = new HashMap<String, Object>();
            } else {
                changes = item.getLastUpdate();
                if (changes == null) {
                    changes = new HashMap();
                }
            }
            if (refItem != null) {
                changes.put(ItemLog.Changes.status.name(), refItem.getStatus().getId());
                Double v1 = refItem.getStoryPoints() == null ? 0.0 : refItem.getStoryPoints();
                changes.put(ItemLog.Changes.storyPoints.name(), v1);
                if (isOld) {
                    changes.put("fields", item.getFields());
                    item.setOldSate(changes);
                } else {
                    Map oldValues = (Map)item.getOldSate();
                    if (oldValues != null) {
                        if (changes.get(ItemLog.Changes.status.name()).equals(oldValues.get(ItemLog.Changes.status.name()))) {
                            changes.remove(ItemLog.Changes.status.name());
                        }
                        if (changes.get(ItemLog.Changes.storyPoints.name()).equals(oldValues.get(ItemLog.Changes.storyPoints.name()))) {
                            changes.remove(ItemLog.Changes.storyPoints.name());
                        }
                        KendisUtils.mapDifference((Map)((Map)oldValues.get("fields")), (Map)item.getFields(), changes);
                        oldValues.clear();
                    }
                    if (changes == null || changes.isEmpty()) {
                        item.setLastUpdate(null);
                    } else {
                        item.setLastUpdate(changes);
                    }
                }
            } else if (isOld) {
                item.setOldSate(changes);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Resync change log : " + e.getMessage());
        }
    }

    public static void putDeletedItems(Map<String, HashMap<String, ? super Object>> deletedMap, List<Item> deletedItems) {
        if (deletedItems != null && deletedItems.size() > 0) {
            if (deletedMap == null) {
                deletedMap = new HashMap<String, HashMap<String, ? super Object>>();
            }
            for (Item item : deletedItems) {
                deletedMap.put(item.getId(), item.toMap());
            }
        }
    }

    public static void createLogs(Collection<Item> items, State boardState, List<ItemLog> logs, List<ItemLogMap> logMaps, Set<String> itemIds) {
        Gson gson = new Gson();
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String perDay = sdf.format(now);
        User loggedInUser = null;
        if (UserContextUtil.getUserContext() != null) {
            loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        }
        for (Item item : items) {
            KendisUtils.addChanges((boolean)false, (boolean)false, (Item)item, (Item)item);
            Map changes = item.getLastUpdate();
            if (changes != null) {
                ItemLog log = new ItemLog();
                log.setEventTime(now);
                log.setItemId(item.getId());
                log.setItemType(item.getClass().getSimpleName());
                log.setEventType(EnumActivityType.BULK.getCode());
                log.setChanges(gson.toJson((Object)changes));
                log.setSessionBoard((SessionBoard)item.getSessionBoards().get(0));
                log.setTenant(item.getTenant());
                log.setActivitySource("APP");
                if (loggedInUser == null) {
                    log.setActivitySource("WEBHOOK");
                } else {
                    log.setActivityBy(loggedInUser.getFullName());
                }
                if (item.getSessionBoards() != null && item.getSessionBoards().size() > 0 && ((SessionBoard)item.getSessionBoards().get(0)).getState() == null) {
                    ((SessionBoard)item.getSessionBoards().get(0)).setState(boardState);
                }
                log.setDetail((Object)new ItemLogDetail((Object)item).clean(null));
                log.setTitle(item.getTitle());
                log.setKey(item.plainId());
                logs.add(log);
                ItemLogMap itemLogMap = new ItemLogMap();
                itemLogMap.setEventTime(log.getEventTime());
                itemLogMap.setItemLog(log);
                itemLogMap.setSessionBoard(log.getSessionBoard());
                itemLogMap.setTenant(log.getTenant());
                StringBuilder id = new StringBuilder();
                id.append(perDay).append("_").append(EnumActivityType.BULK.getNarrative());
                if (changes.containsKey(ItemLog.Changes.status.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byStatus.name());
                    itemIds.add(item.plainId());
                }
                if (changes.containsKey(ItemLog.Changes.teamContainers.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byPlan.name());
                    itemIds.add(item.plainId());
                }
                if (changes.containsKey(ItemLog.Changes.containerChanged.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byC.name());
                    itemIds.add(item.plainId());
                }
                if (changes.containsKey(ItemLog.Changes.teamChanged.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byT.name());
                    itemIds.add(item.plainId());
                }
                if (changes.containsKey(ItemLog.Changes.phoenixSequence.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byTC.name());
                }
                if (changes.containsKey(ItemLog.Changes.storyPoints.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byPoints.name());
                    itemIds.add(item.plainId());
                }
                if (changes.containsKey(ItemLog.Changes.itemLinks.name())) {
                    id.append("_").append(ItemLog.UniquePrefix.byLinks.name());
                }
                id.append("_").append(item.getId());
                itemLogMap.setId(id.toString());
                logMaps.add(itemLogMap);
            }
            if (!Boolean.TRUE.equals(item.getSyncWithART())) continue;
            itemIds.add(item.plainId());
        }
    }

    public static String parseRichText(String richText) {
        Document document = Jsoup.parse((String)richText, (String)"", (Parser)Parser.htmlParser());
        Element element = document.body();
        StringBuilder plainText = new StringBuilder();
        for (Element child : element.children()) {
            switch (child.tagName()) {
                case "strong": 
                case "b": {
                    plainText.append(child.text().toUpperCase());
                    break;
                }
                case "i": 
                case "em": {
                    plainText.append("*").append(child.text()).append("*");
                    break;
                }
                case "ul": 
                case "ol": {
                    for (Element li : child.children()) {
                        plainText.append("- ").append(li.text()).append("\n");
                    }
                    break;
                }
                case "li": {
                    plainText.append("- ").append(child.text()).append("\n");
                    break;
                }
                case "p": {
                    plainText.append(child.text()).append("\n");
                    break;
                }
                default: {
                    plainText.append(child.text());
                }
            }
            plainText.append("\n");
        }
        return plainText.toString().trim();
    }

    public static void createLogsForDelete(Map<String, HashMap<String, ? super Object>> removedItems, SessionBoard board, List<ItemLog> logs, List<ItemLogMap> logMaps, Set<String> itemIds) {
        Gson gson = new Gson();
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String perDay = sdf.format(now);
        User loggedInUser = null;
        if (UserContextUtil.getUserContext() != null) {
            loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        }
        Set<String> ids = removedItems.keySet();
        for (String itemId : ids) {
            HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
            changes.put(ItemLog.Changes.archive.name(), true);
            if (changes == null) continue;
            ItemLog log = new ItemLog();
            log.setEventTime(now);
            log.setItemId(itemId);
            log.setItemType(Item.class.getSimpleName());
            log.setEventType(EnumActivityType.DELETED.getCode());
            log.setChanges(gson.toJson(changes));
            log.setSessionBoard(board);
            log.setTenant(board.getTenant());
            log.setActivitySource("APP");
            if (loggedInUser == null) {
                log.setActivitySource("WEBHOOK");
            } else {
                log.setActivityBy(loggedInUser.getFullName());
            }
            Map itm = removedItems.get(itemId);
            log.setDetail((Object)itm);
            log.setTitle((String)itm.get("title"));
            log.setKey((String)itm.get("tfsId"));
            if (log.getKey() == null) {
                log.setKey((String)itm.get("jiraKey"));
            } else {
                itemIds.add(log.getKey());
            }
            if (log.getKey() == null) {
                log.setKey((String)itm.get("kendisKey"));
            }
            logs.add(log);
            ItemLogMap itemLogMap = new ItemLogMap();
            itemLogMap.setEventTime(log.getEventTime());
            itemLogMap.setItemLog(log);
            itemLogMap.setSessionBoard(log.getSessionBoard());
            itemLogMap.setTenant(log.getTenant());
            StringBuilder id = new StringBuilder();
            id.append(perDay).append("_").append(EnumActivityType.DELETED.getNarrative());
            if (changes.containsKey(ItemLog.Changes.archive.name())) {
                id.append("_").append(ItemLog.UniquePrefix.archive.name());
            }
            id.append("_").append(itemId);
            itemLogMap.setId(id.toString());
            logMaps.add(itemLogMap);
            if (itm.get("tfsId") != null) {
                itemIds.add((String)itm.get("tfsId"));
                continue;
            }
            if (itm.get("jiraId") != null) {
                itemIds.add((String)itm.get("jiraId"));
                continue;
            }
            itemIds.add((String)itm.get("id"));
        }
    }

    public static void createLogsForDelete(List<Item> removedItems, SessionBoard board, List<ItemLog> logs, List<ItemLogMap> logMaps, Set<String> itemIds) {
        Gson gson = new Gson();
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String perDay = sdf.format(now);
        User loggedInUser = null;
        if (UserContextUtil.getUserContext() != null) {
            loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        }
        for (Item item : removedItems) {
            HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
            changes.put(ItemLog.Changes.archive.name(), true);
            if (changes == null) continue;
            ItemLog log = new ItemLog();
            log.setEventTime(now);
            log.setItemId(item.getId());
            log.setItemType(Item.class.getSimpleName());
            log.setEventType(EnumActivityType.DELETED.getCode());
            log.setChanges(gson.toJson(changes));
            log.setSessionBoard(board);
            log.setTenant(board.getTenant());
            log.setActivitySource("APP");
            if (loggedInUser == null) {
                log.setActivitySource("WEBHOOK");
            } else {
                log.setActivityBy(loggedInUser.getFullName());
            }
            HashMap itm = item.toSimpleObject();
            log.setDetail((Object)itm);
            log.setTitle((String)itm.get("title"));
            log.setKey((String)itm.get("tfsId"));
            if (log.getKey() == null) {
                log.setKey((String)itm.get("jiraKey"));
            } else {
                itemIds.add(log.getKey());
            }
            if (log.getKey() == null) {
                log.setKey((String)itm.get("kendisKey"));
            }
            logs.add(log);
            ItemLogMap itemLogMap = new ItemLogMap();
            itemLogMap.setEventTime(log.getEventTime());
            itemLogMap.setItemLog(log);
            itemLogMap.setSessionBoard(log.getSessionBoard());
            itemLogMap.setTenant(log.getTenant());
            StringBuilder id = new StringBuilder();
            id.append(perDay).append("_").append(EnumActivityType.DELETED.getNarrative());
            if (changes.containsKey(ItemLog.Changes.archive.name())) {
                id.append("_").append(ItemLog.UniquePrefix.archive.name());
            }
            id.append("_").append(item.getId());
            itemLogMap.setId(id.toString());
            logMaps.add(itemLogMap);
            if (itm.get("tfsId") != null) {
                itemIds.add((String)itm.get("tfsId"));
                continue;
            }
            if (itm.get("jiraId") != null) {
                itemIds.add((String)itm.get("jiraId"));
                continue;
            }
            itemIds.add((String)itm.get("id"));
        }
    }

    public static void createLogs(Collection<BacklogItem> items, List<ItemLog> logs) {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String perDay = sdf.format(now);
        User loggedInUser = null;
        if (UserContextUtil.getUserContext() != null) {
            loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        }
        for (BacklogItem item : items) {
            KendisUtils.addChanges((boolean)false, (boolean)false, (BacklogItem)item, (BacklogItem)item);
            Map changes = item.getLastUpdate();
            if (changes == null) continue;
            ItemLog log = new ItemLog();
            log.setEventTime(now);
            log.setItemId(item.getId());
            log.setItemType(item.getClass().getSimpleName());
            log.setEventType(EnumActivityType.BULK.getCode());
            log.setActions(changes);
            log.setTenant(item.getTenant());
            log.setActivitySource("APP");
            if (loggedInUser == null) {
                log.setActivitySource("WEBHOOK");
            } else {
                log.setActivityBy(loggedInUser.getFullName());
            }
            log.setDetail((Object)new ItemLogDetail((Object)item).clean(null));
            log.setTitle(item.getTitle());
            log.setKey(item.getAlmKey());
            logs.add(log);
        }
    }

    public static void printLOG(String msg, boolean debug) {
        if (debug || UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser() != null && "sysadmin@kendis.io".equals(UserContextUtil.getUserContext().getLoggedInUser().getUserName())) {
            LOGGER.debug(msg);
        }
    }

    public static void printLOG(String msg) {
        if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser() != null && "sysadmin@kendis.io".equals(UserContextUtil.getUserContext().getLoggedInUser().getUserName())) {
            LOGGER.debug(msg);
        }
    }

    public static void putStartEndSprintParam(Map<String, Object> map, SessionBoard board, List<String> tids, List<String> sids) {
        String bid = board.getId();
        for (String tid : tids) {
            for (String sid : sids) {
                map.put(tid + "_" + sid, bid);
            }
        }
        map.put(bid, board);
        map.put("tenant_" + bid, board.getTenant());
        map.put("tids_" + bid, tids);
        map.put("sids_" + bid, sids);
        ArrayList<String> bids = (ArrayList<String>)map.get("bids");
        if (bids == null) {
            bids = new ArrayList<String>();
            map.put("bids", bids);
        }
        bids.add(bid);
    }

    public static Date convertStringToDayEndDate(String dateStr) {
        if (!PropertyValidator.isValid((Object)dateStr)) {
            return new Date();
        }
        Instant instant = Instant.parse(dateStr);
        return KendisUtils.convertInstantToDayEndDate((Instant)instant);
    }

    public static Date convertInstantToDayEndDate(Instant instant) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(5, localDateTime.getDayOfMonth());
        calendar.set(2, localDateTime.getMonthValue() - 1);
        calendar.set(1, localDateTime.getYear());
        Date date = calendar.getTime();
        date.setHours(23);
        date.setMinutes(59);
        date.setSeconds(59);
        return date;
    }

    public static int calculateDaysDifference(Date expiresAt) {
        Date currentDate = new Date();
        long differenceInMillis = expiresAt.getTime() - currentDate.getTime();
        return (int)TimeUnit.MILLISECONDS.toDays(differenceInMillis);
    }

    public static LocalDateTime convertToLocalDateTime(String date) {
        if (PropertyValidator.isValid((Object)date)) {
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
            LocalDateTime localDateTime = LocalDateTime.parse(date, inputFormatter);
            ZoneId zone = ZoneId.of("GMT");
            return localDateTime.atZone(zone).toLocalDateTime();
        }
        return LocalDateTime.now();
    }

    public static LocalDate convertToLocalDate(String date) {
        if (PropertyValidator.isValid((Object)date)) {
            LocalDateTime localDateTime = KendisUtils.convertToLocalDateTime((String)date);
            return PropertyValidator.isValid((Object)localDateTime) ? localDateTime.toLocalDate() : null;
        }
        return LocalDate.now();
    }

    public static Date convertStringToDate(String dateString, String dateFormat) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.parse(dateString);
    }

    public static String camelCase(String str) {
        return org.apache.commons.lang.StringUtils.uncapitalize((String)WordUtils.capitalizeFully((String)str)).replaceAll(" ", "");
    }

    public static Double getPercentage(Double val1, Double val2) {
        Double completion = 0.0;
        if (val1 == null) {
            val1 = 0.0;
        }
        if (val2 == null) {
            val2 = 0.0;
        }
        completion = val2 == 0.0 ? Double.valueOf(0.0) : Double.valueOf(val1 / val2 * 100.0);
        return (double)Math.round(completion * 100.0) / 100.0;
    }

    public static <V, T> T getValue(Map<String, V> data, String key, Class<T> valueType) {
        if (data.containsKey(key)) {
            V value = data.get(key);
            if (valueType.isInstance(value)) {
                return valueType.cast(value);
            }
            throw new ClassCastException("Value cannot be cast to " + valueType.getName());
        }
        return null;
    }

    public static <V, R, M extends Map<String, R>> M getMapValue(Map<String, V> inputMap, String key, Class<R> returnType, Supplier<M> mapSupplier) {
        V rawValue;
        Map resultMap = (Map)mapSupplier.get();
        if (inputMap.containsKey(key) && (rawValue = inputMap.get(key)) instanceof Map) {
            Map rawMap = (Map)rawValue;
            for (Map.Entry entry : rawMap.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                try {
                    resultMap.put((String)entry.getKey(), returnType.cast(entry.getValue()));
                }
                catch (ClassCastException e) {
                    throw new ClassCastException("Value for key " + entry.getKey() + " cannot be cast to " + returnType.getName());
                }
            }
        }
        return (M)resultMap;
    }

    public static <V, R> Map<String, R> getMapValue(Map<String, V> inputMap, String key, Class<R> returnType) {
        return KendisUtils.getMapValue(inputMap, (String)key, returnType, HashMap::new);
    }

    public static <V, E> List<E> getListValue(Map<String, V> inputMap, String key, Class<E> elementType) {
        ArrayList<E> resultList = new ArrayList<E>();
        V rawValue = inputMap.get(key);
        if (rawValue instanceof List) {
            List rawList = (List)rawValue;
            for (Object element : rawList) {
                if (!elementType.isInstance(element)) continue;
                resultList.add(elementType.cast(element));
            }
        }
        return resultList;
    }

    public static String generateRandomLightColorCode() {
        Random rand = new Random();
        int r = rand.nextInt(156) + 100;
        int g = rand.nextInt(156) + 100;
        int b = rand.nextInt(156) + 100;
        return String.format("#%02x%02x%02x", r, g, b);
    }
}

