/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.Image;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ImageTagProcessor
extends Image {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        Map attributes = tag.getAttributes();
        String src = (String)attributes.get("src");
        List<Object> elements = new ArrayList<Element>(1);
        if (null != src && src.length() > 0) {
            com.itextpdf.text.Image img = null;
            if (src.startsWith("data:image/")) {
                block8: {
                    String base64Data = src.substring(src.indexOf(",") + 1);
                    try {
                        img = com.itextpdf.text.Image.getInstance((byte[])Base64.decode((String)base64Data));
                    }
                    catch (Exception e) {
                        if (!this.logger.isLogging(Level.ERROR)) break block8;
                        this.logger.error(String.format(LocaleMessages.getInstance().getMessage("html.tag.img.failedretrieve"), src), e);
                    }
                }
                if (img != null) {
                    try {
                        HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                        elements.add(this.getCssAppliers().apply((Element)new Chunk((com.itextpdf.text.Image)this.getCssAppliers().apply((Element)img, tag, htmlPipelineContext), 0.0f, 0.0f, true), tag, htmlPipelineContext));
                    }
                    catch (NoCustomContextException e) {
                        throw new RuntimeWorkerException((Throwable)e);
                    }
                }
            }
            if (img == null) {
                elements = super.end(ctx, tag, currentContent);
            }
        }
        return elements;
    }
}

