/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.viztrend.safe.utils.GenericDeserializer;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.IOException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDeserializer<T>
extends JsonDeserializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericDeserializer.class);
    private final Class<T> targetType;

    public GenericDeserializer(Class<T> targetType) {
        this.targetType = targetType;
    }

    public static <T> T deserializeJson(String json, Class<T> targetType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(targetType, (JsonDeserializer)new GenericDeserializer(targetType));
        mapper.registerModule((Module)module);
        return (T)mapper.readValue(json, targetType);
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixIn(this.targetType, IgnoreJsonIgnoreMixIn.class);
        ObjectNode node = (ObjectNode)jsonParser.readValueAsTree();
        this.modifyIdFields((JsonNode)node);
        node.remove("_class");
        return (T)mapper.treeToValue((TreeNode)node, this.targetType);
    }

    private ObjectId createObjectIdFromJson(JsonNode jsonNode) {
        ObjectNode objectNode;
        if (jsonNode.isObject() && !(objectNode = (ObjectNode)jsonNode).isNull() && PropertyValidator.isValid((Object)objectNode.get("timestamp")) && PropertyValidator.isValid((Object)objectNode.get("counter")) && PropertyValidator.isValid((Object)objectNode.get("machineIdentifier")) && PropertyValidator.isValid((Object)objectNode.get("processIdentifier"))) {
            int timestamp = jsonNode.get("timestamp").asInt();
            int counter = jsonNode.get("counter").asInt();
            int machineIdentifier = jsonNode.get("machineIdentifier").asInt();
            short processIdentifier = jsonNode.get("processIdentifier").shortValue();
            return new ObjectId(timestamp, machineIdentifier, processIdentifier, counter);
        }
        return null;
    }

    private void modifyIdFields(JsonNode node) throws IOException {
        if (node.isObject()) {
            ObjectId id;
            JsonNode idJson;
            ObjectNode objectNode = (ObjectNode)node;
            if (objectNode.has("_id")) {
                JsonNode objectIdJson = objectNode.get("_id");
                if (objectIdJson != null && !objectIdJson.isNull()) {
                    if (JsonNodeType.STRING.equals((Object)objectIdJson.getNodeType())) {
                        String id2 = objectIdJson.asText();
                        objectNode.remove("_id");
                        objectNode.put("id", id2);
                    } else {
                        ObjectId id3 = this.createObjectIdFromJson(objectIdJson);
                        if (PropertyValidator.isValid((Object)id3)) {
                            objectNode.remove("_id");
                            objectNode.put("id", id3.toString());
                        }
                    }
                }
            } else if (objectNode.has("id") && (idJson = objectNode.get("id")) != null && !idJson.isNull() && PropertyValidator.isValid((Object)(id = this.createObjectIdFromJson(idJson)))) {
                objectNode.put("id", id.toString());
            }
            objectNode.fields().forEachRemaining(entry -> {
                try {
                    boolean skipRecursionForObjectId = false;
                    if (((JsonNode)entry.getValue()).isObject() && this.isObjectIdJson((ObjectNode)entry.getValue())) {
                        ObjectNode entryObjectNode = (ObjectNode)entry.getValue();
                        skipRecursionForObjectId = true;
                        ObjectId id = this.createObjectIdFromJson((JsonNode)entryObjectNode);
                        if (PropertyValidator.isValid((Object)id)) {
                            entry.setValue(new TextNode(id.toString()));
                        }
                    }
                    if (!skipRecursionForObjectId) {
                        this.modifyIdFields((JsonNode)entry.getValue());
                    }
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            });
        } else if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            arrayNode.elements().forEachRemaining(element -> {
                try {
                    this.modifyIdFields(element);
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            });
        }
    }

    private boolean isObjectIdJson(ObjectNode objectNode) {
        return PropertyValidator.isValid((Object)objectNode.get("timestamp")) && PropertyValidator.isValid((Object)objectNode.get("counter")) && PropertyValidator.isValid((Object)objectNode.get("machineIdentifier")) && PropertyValidator.isValid((Object)objectNode.get("processIdentifier"));
    }
}

