/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.utils;

import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlmUtils {
    public static AlmAccount getALMAcount() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        AlmAccount doc = (AlmAccount)secureUser.getUserContextDTO().getContextMap().get("alm");
        if (doc == null) {
            return new AlmAccount();
        }
        return doc;
    }

    public static AlmAccount getALMAcount(String almAccId, AlmAccountRepository almAccountRepository) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        AlmAccount doc = (AlmAccount)secureUser.getUserContextDTO().getContextMap().get("alm");
        if (doc != null && doc.getName() != null && doc.getName().equals(almAccId)) {
            return doc;
        }
        doc = (AlmAccount)almAccountRepository.findOne((Serializable)((Object)almAccId));
        return doc;
    }

    public static String cleanText(String text) {
        if (PropertyValidator.isValid((Object)text)) {
            return text.replaceAll("[^a-zA-Z^0-9^_\\^-]+", "_");
        }
        return text;
    }

    public static String replaceWhiteSpaces(String text, String replacement) {
        if (PropertyValidator.isValid((Object)text)) {
            return text.replaceAll("\\s+", replacement);
        }
        return text;
    }

    public static String getJiraBrowseURL(String baseURL) {
        if (PropertyValidator.isValid((Object)baseURL)) {
            return baseURL.replaceAll("(\\/)+$", "") + "/browse";
        }
        return baseURL;
    }

    public static Integer getServerTimeZone() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 1000 / 60 * -1;
    }

    public static Boolean isValidJiraKey(String jKey) {
        String regex = "(?<!([A-Za-z]{1,10})-?)[A-Za-z0-9]+-\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(jKey);
        return matcher.matches();
    }

    public static void main(String[] args) {
        System.err.println(AlmUtils.isValidJiraKey((String)"PMPT21-78"));
    }

    public static Map<String, Status> convertStatusListToMap(List<Status> statuses) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid(statuses)) {
            for (Status st : statuses) {
                String key = st.getItemType() + "_" + st.getJiraProjKey() + "_" + st.getJiraIssueTypeId() + "_" + st.getJiraStatusId() + "_" + st.getTenant();
                statusMap.put(key, st);
            }
        }
        return statusMap;
    }

    public static String getMappedStatusCategory(String key) {
        if (key != null) {
            if (key.equalsIgnoreCase("indeterminate")) {
                return EnumStatusCategory.INPROGRESS.getCode();
            }
            if (key.equalsIgnoreCase("done")) {
                return EnumStatusCategory.DONE.getCode();
            }
            if (key.equalsIgnoreCase("undefined")) {
                return EnumStatusCategory.OPEN.getCode();
            }
            return EnumStatusCategory.OPEN.getCode();
        }
        return EnumStatusCategory.OPEN.getCode();
    }

    public static String createWIQLQuery(Map<String, Object> params) {
        Object ip;
        Object ip2;
        Object _iterationPath;
        StringBuilder wiqlQuery = new StringBuilder();
        String iterationPathOp = (String)params.get("iterationPathOp");
        String areaPathOp = (String)params.get("areaPathOp");
        String stateOp = (String)params.get("stateOp");
        if (iterationPathOp == null) {
            iterationPathOp = "=";
        }
        if (areaPathOp == null) {
            areaPathOp = "=";
        }
        if (stateOp == null) {
            stateOp = "=";
        }
        String iterationPath = "";
        if (iterationPathOp.equals("IN") || iterationPathOp.equals("NOTIN")) {
            _iterationPath = (List)params.get("iterationPath");
            iterationPath = "";
            Iterator iterator = _iterationPath.iterator();
            while (iterator.hasNext()) {
                ip2 = (String)iterator.next();
                if (iterationPath.length() == 0) {
                    iterationPath = "('" + (String)ip2 + "'";
                    continue;
                }
                iterationPath = iterationPath + ",'" + (String)ip2 + "'";
            }
            iterationPath = iterationPath + ")";
        } else {
            _iterationPath = (String)params.get("iterationPath");
            iterationPath = "'" + (String)_iterationPath + "'";
        }
        String areaPath = null;
        if (areaPathOp != null && params.get("areaPath") != null) {
            Object _areaPath;
            if (areaPathOp.equals("IN") || areaPathOp.equals("NOTIN")) {
                _areaPath = (List)params.get("areaPath");
                areaPath = "";
                ip2 = _areaPath.iterator();
                while (ip2.hasNext()) {
                    ip = (String)ip2.next();
                    if (areaPath.length() == 0) {
                        areaPath = "('" + (String)ip + "'";
                        continue;
                    }
                    areaPath = areaPath + ",'" + (String)ip + "'";
                }
                areaPath = areaPath + ")";
            } else {
                _areaPath = (String)params.get("areaPath");
                areaPath = "'" + (String)_areaPath + "'";
            }
        }
        String state = null;
        if (stateOp != null && params.get("state") != null) {
            Object _state;
            if (stateOp.equals("IN") || stateOp.equals("NOTIN")) {
                _state = (List)params.get("state");
                state = "";
                ip = _state.iterator();
                while (ip.hasNext()) {
                    String ip3 = (String)ip.next();
                    if (state.length() == 0) {
                        state = "('" + ip3 + "'";
                        continue;
                    }
                    state = state + ",'" + ip3 + "'";
                }
                state = state + ")";
            } else {
                _state = (String)params.get("state");
                state = "'" + (String)_state + "'";
            }
        }
        String teamProject = (String)params.get("teamProject");
        String workItemType = (String)params.get("workItemType");
        wiqlQuery.append("SELECT\n");
        wiqlQuery.append("        [System.Id],\n");
        wiqlQuery.append("        [System.WorkItemType],\n");
        wiqlQuery.append("        [System.Title],\n");
        wiqlQuery.append("        [System.AssignedTo],\n");
        wiqlQuery.append("        [System.State],\n");
        wiqlQuery.append("        [System.AreaPath],\n");
        wiqlQuery.append("        [System.Tags],\n");
        wiqlQuery.append("        [System.CommentCount]\n");
        wiqlQuery.append("      FROM workitems\n");
        wiqlQuery.append("      WHERE\n");
        wiqlQuery.append("        [System.WorkItemType] = '").append(workItemType).append("'");
        if (iterationPathOp.equals("NOTIN")) {
            wiqlQuery.append("\n        AND NOT [System.IterationPath] IN ").append(iterationPath);
        } else if (iterationPathOp.equals("IN")) {
            wiqlQuery.append("\n        AND [System.IterationPath] IN ").append(iterationPath);
        } else if (iterationPathOp.equals("UNDER")) {
            wiqlQuery.append("\n        AND [System.IterationPath] UNDER ").append(iterationPath);
        } else if (iterationPathOp.equals("NOTUNDER")) {
            wiqlQuery.append("\n        AND NOT [System.IterationPath] UNDER ").append(iterationPath);
        } else if (iterationPathOp.equals("=")) {
            wiqlQuery.append("\n        AND [System.IterationPath] = ").append(iterationPath);
        }
        if (PropertyValidator.isValid((Object)areaPath)) {
            if (areaPathOp.equals("NOTIN")) {
                wiqlQuery.append("\n        AND NOT [System.AreaPath] IN ").append(areaPath);
            } else if (areaPathOp.equals("IN")) {
                wiqlQuery.append("\n        AND [System.AreaPath] IN ").append(areaPath);
            } else if (areaPathOp.equals("UNDER")) {
                wiqlQuery.append("\n        AND [System.AreaPath] UNDER ").append(areaPath);
            } else if (areaPathOp.equals("NOTUNDER")) {
                wiqlQuery.append("\n        AND NOT [System.AreaPath] UNDER ").append(areaPath);
            } else if (areaPathOp.equals("=")) {
                wiqlQuery.append("\n        AND [System.AreaPath] = ").append(areaPath);
            }
        }
        if (PropertyValidator.isValid((Object)state)) {
            if (stateOp.equals("NOTIN")) {
                wiqlQuery.append("\n        AND NOT [System.State] IN ").append(state);
            } else if (stateOp.equals("IN")) {
                wiqlQuery.append("\n        AND [System.State] IN ").append(state);
            } else if (stateOp.equals("=")) {
                wiqlQuery.append("\n        AND [System.State] = ").append(state);
            }
        }
        wiqlQuery.append("\n        AND [System.TeamProject] = '").append(teamProject).append("'");
        wiqlQuery.append("\n      ORDER BY [System.ChangedDate] ASC");
        return wiqlQuery.toString();
    }
}

