/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceTypeRepository;
import com.viztrend.safe.service.WorkSpaceTypeService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="WorkSpaceTypeService")
@Transactional
public class WorkSpaceTypeServiceImpl
implements WorkSpaceTypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceTypeServiceImpl.class);
    @Autowired
    WorkSpaceTypeRepository workSpaceTypeRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;

    public List<WorkSpaceType> getListOfAllWorkSpacesTypes() {
        List<WorkSpaceType> listOfAllWorkSpacesTypes = new ArrayList();
        try {
            listOfAllWorkSpacesTypes = this.workSpaceTypeRepository.findAllByOrderBySequenceAsc();
            if (listOfAllWorkSpacesTypes == null || listOfAllWorkSpacesTypes.size() <= 0) {
                this.createDefaultWorkSpaceType();
                listOfAllWorkSpacesTypes = this.workSpaceTypeRepository.findAllByOrderBySequenceAsc();
            }
            return listOfAllWorkSpacesTypes;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return listOfAllWorkSpacesTypes;
        }
    }

    public ResponseEntity<Object> updateWorkSpaceSequence(HashMap<String, Object> params) {
        try {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            String workspaceTypeId = (String)params.get("workspaceTypeId");
            Double sequence = Double.parseDouble((String)params.get("sequence"));
            WorkSpaceType workspaceType = (WorkSpaceType)this.workSpaceTypeRepository.findOne((Serializable)((Object)workspaceTypeId));
            if (PropertyValidator.isValid((Object)workspaceType)) {
                workspaceType.setSequence(sequence);
                this.workSpaceTypeRepository.save((Object)workspaceType);
                result.put("success", true);
            }
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public ResponseEntity<Object> saveNewWorkSpaceType(WorkSpaceType workSpaceType) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (PropertyValidator.isValid((Object)workSpaceType)) {
                if (PropertyValidator.isValid((Object)workSpaceType.getId())) {
                    WorkSpaceType workSpaceTypeAlresyExist = (WorkSpaceType)this.workSpaceTypeRepository.findOne((Serializable)((Object)String.valueOf(workSpaceType.getId())));
                    if (PropertyValidator.isValid((Object)workSpaceTypeAlresyExist)) {
                        if (workSpaceTypeAlresyExist.getPrefix().equals(workSpaceType.getPrefix())) {
                            data.put("message", "work Space Type is updated successfully");
                            data.put("response", this.workSpaceTypeRepository.save((Object)workSpaceType));
                        } else {
                            data.put("message", "work Space Type prefix cannot be updated");
                        }
                    }
                } else {
                    WorkSpaceType workSpaceTypeAlresyExist = this.workSpaceTypeRepository.findByTitleOrPrefix(workSpaceType.getTitle(), workSpaceType.getPrefix());
                    if (!PropertyValidator.isValid((Object)workSpaceTypeAlresyExist)) {
                        data.put("message", "work Space Type is added successfully");
                        data.put("response", this.workSpaceTypeRepository.save((Object)workSpaceType));
                    } else {
                        data.put("message", "work Space Type title or Prefix already exist");
                    }
                }
                return new ResponseEntity(data, HttpStatus.OK);
            }
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public ResponseEntity<Object> removeWorkSpaceType(String workSpaceTypeId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)workSpaceTypeId)) {
                List workSpaces = this.workSpaceRepository.findByTypeId(workSpaceTypeId);
                if (workSpaces != null && !workSpaces.isEmpty()) {
                    data.put("attachedWorkSpaces", workSpaces);
                    data.put("isDeleted", Boolean.FALSE);
                    data.put("message", "work Space Type cannot be deleted");
                } else {
                    this.customRepository.setArchive(workSpaceTypeId, Boolean.valueOf(true), WorkSpaceType.class);
                    data.put("isDeleted", Boolean.TRUE);
                    data.put("message", "work Space Type deleted");
                }
            }
            data.put("id", workSpaceTypeId);
            data.put("type", "removeWorkSpaceType");
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(data, HttpStatus.OK);
        }
    }

    public void createDefaultWorkSpaceType() {
        ArrayList<WorkSpaceType> listOfAllWorkSpacesTypes = new ArrayList<WorkSpaceType>();
        WorkSpaceType wsType = new WorkSpaceType("Department", "D", "#1991eb", "apartment", "ea40");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 10L));
        listOfAllWorkSpacesTypes.add(wsType);
        wsType = new WorkSpaceType("Program", "PR", "#f85359", "conveyor_belt", "f867");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 100L));
        listOfAllWorkSpacesTypes.add(wsType);
        wsType = new WorkSpaceType("Portfolio", "P", "#6b47db", "folder_open", "e2c8");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 1000L));
        listOfAllWorkSpacesTypes.add(wsType);
        wsType = new WorkSpaceType("Agile Release Train", "ART", "#f9bf3b", "model_training", "f0cf");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 10000L));
        listOfAllWorkSpacesTypes.add(wsType);
        wsType = new WorkSpaceType("Solution Train", "ST", "#0747a6", "on_device_training", "ebfd");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 100000L));
        listOfAllWorkSpacesTypes.add(wsType);
        wsType = new WorkSpaceType("Shared Services", "SS", "#34495e", "share_reviews", "f8a4");
        wsType.setSequence(new Double(System.nanoTime() / 100000L + 1000000L));
        listOfAllWorkSpacesTypes.add(wsType);
        List _listOfAllWorkSpacesTypes = this.workSpaceTypeRepository.findAllByOrderBySequenceAsc();
        if (_listOfAllWorkSpacesTypes == null || _listOfAllWorkSpacesTypes.size() <= 0) {
            this.workSpaceTypeRepository.save(listOfAllWorkSpacesTypes);
        }
    }
}

