/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.dto.WorkSpaceLinksGroupDTO;
import com.viztrend.safe.enums.EnumWorkSpaceLinksGroupType;
import com.viztrend.safe.mapper.WorkSpaceLinksGroupMapper;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceLinksGroup;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceLinkRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceLinksGroupRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.WorkSpaceLinksGroupService;
import com.viztrend.safe.utils.LexoRankUtil;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkSpaceLinksGroupServiceImpl
implements WorkSpaceLinksGroupService {
    private final WorkSpaceLinksGroupRepository workSpaceLinksGroupRepository;
    private final WorkSpaceRepository workSpaceRepository;
    private final WorkSpaceLinkRepository workSpaceLinkRepository;
    private final UserRepository userRepository;
    private final WorkSpaceLinksGroupMapper workSpaceLinksGroupMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLinksGroupServiceImpl.class);

    public WorkSpaceLinksGroupServiceImpl(WorkSpaceLinksGroupRepository workSpaceLinksGroupRepository, WorkSpaceRepository workSpaceRepository, WorkSpaceLinkRepository workSpaceLinkRepository, UserRepository userRepository, WorkSpaceLinksGroupMapper workSpaceLinksGroupMapper) {
        this.workSpaceLinksGroupRepository = workSpaceLinksGroupRepository;
        this.workSpaceRepository = workSpaceRepository;
        this.workSpaceLinkRepository = workSpaceLinkRepository;
        this.userRepository = userRepository;
        this.workSpaceLinksGroupMapper = workSpaceLinksGroupMapper;
    }

    public WorkSpaceLinksGroupDTO createGroup(WorkSpaceLinksGroupDTO group) throws Exception {
        WorkSpaceLinksGroupDTO result = new WorkSpaceLinksGroupDTO();
        try {
            WorkSpaceLinksGroup workSpaceLinksGroup = new WorkSpaceLinksGroup();
            String title = group.getTitle();
            String description = group.getDescription();
            String workspaceKey = group.getOriginWorkSpace();
            EnumWorkSpaceLinksGroupType type = group.getType();
            User currentUser = UserContextUtil.getUserContext().getLoggedInUser();
            workSpaceLinksGroup.setCreator(currentUser.getId());
            if (PropertyValidator.isValid((Object)title)) {
                workSpaceLinksGroup.setTitle(title);
            }
            if (PropertyValidator.isValid((Object)description)) {
                workSpaceLinksGroup.setDescription(description);
            }
            if (PropertyValidator.isValid((Object)workspaceKey)) {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(workspaceKey);
                workSpaceLinksGroup.setOriginWorkSpace(workSpace.getKey());
            }
            if (PropertyValidator.isValid((Object)type)) {
                workSpaceLinksGroup.setType(type);
            }
            if ("personal".equals(type.toString().toLowerCase())) {
                workSpaceLinksGroup.setGroupColor("#EFF6E9");
            } else {
                workSpaceLinksGroup.setGroupColor("#E5F2FB");
            }
            this.setSequenceForNewGroup(workSpaceLinksGroup, workspaceKey, type.toString().toLowerCase());
            workSpaceLinksGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.save((Object)workSpaceLinksGroup);
            result = this.workSpaceLinksGroupMapper.toDTOWithLinksAndCreator(workSpaceLinksGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public WorkSpaceLinksGroupDTO updateGroup(WorkSpaceLinksGroupDTO group) throws Exception {
        String groupId = group.getId();
        String title = group.getTitle();
        String description = group.getDescription();
        EnumWorkSpaceLinksGroupType type = group.getType();
        WorkSpaceLinksGroupDTO result = new WorkSpaceLinksGroupDTO();
        try {
            WorkSpaceLinksGroup existingGroup = new WorkSpaceLinksGroup();
            existingGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            if (PropertyValidator.isValid((Object)title)) {
                existingGroup.setTitle(title);
            }
            if (PropertyValidator.isValid((Object)description)) {
                existingGroup.setDescription(description);
            }
            if (PropertyValidator.isValid((Object)type)) {
                existingGroup.setType(type);
                if ("personal".equals(type.toString().toLowerCase())) {
                    existingGroup.setGroupColor("#EFF6E9");
                } else {
                    existingGroup.setGroupColor("#E5F2FB");
                }
            }
            existingGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.save((Object)existingGroup);
            result = this.workSpaceLinksGroupMapper.toDTOWithLinksAndCreator(existingGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public boolean deleteGroup(String groupId) throws Exception {
        try {
            WorkSpaceLinksGroup existingGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            this.workSpaceLinksGroupRepository.delete((Object)existingGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return true;
    }

    public Map<String, List<WorkSpaceLinksGroupDTO>> getGroupsByCollectionId(String collectionId) throws Exception {
        HashMap<String, List<WorkSpaceLinksGroupDTO>> result = new HashMap<String, List<WorkSpaceLinksGroupDTO>>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            User currentUser = UserContextUtil.getUserContext().getLoggedInUser();
            WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionId);
            if (workSpace != null) {
                List personalGroups = this.workSpaceLinksGroupRepository.findByOriginWorkSpaceAndTypeAndCreator(workSpace.getKey(), EnumWorkSpaceLinksGroupType.PERSONAL, currentUser.getId());
                personalGroups.sort((a, b) -> {
                    String seqA = this.getGroupSequenceForSorting(a, workSpace.getId());
                    String seqB = this.getGroupSequenceForSorting(b, workSpace.getId());
                    return LexoRankUtil.compareLexoRanks((String)seqA, (String)seqB);
                });
                List sharedGroups = this.workSpaceLinksGroupRepository.findWorkspaceLinksSharedGroups(workSpace.getKey(), EnumWorkSpaceLinksGroupType.SHARED, workSpace.getId(), EnumWorkSpaceLinksGroupType.PERSONAL);
                sharedGroups.sort((a, b) -> {
                    String seqA = this.getGroupSequenceForSorting(a, workSpace.getId());
                    String seqB = this.getGroupSequenceForSorting(b, workSpace.getId());
                    return LexoRankUtil.compareLexoRanks((String)seqA, (String)seqB);
                });
                List personalGroupsDTO = this.workSpaceLinksGroupMapper.toDTOList(personalGroups);
                List sharedGroupsDTO = this.workSpaceLinksGroupMapper.toDTOList(sharedGroups);
                result.put("personal", personalGroupsDTO);
                result.put("shared", sharedGroupsDTO);
            } else {
                result.put("personal", Collections.emptyList());
                result.put("shared", Collections.emptyList());
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public WorkSpaceLinksGroupDTO shareGroup(String groupId, Map payload) throws Exception {
        WorkSpaceLinksGroupDTO result = new WorkSpaceLinksGroupDTO();
        try {
            WorkSpaceLinksGroup group = new WorkSpaceLinksGroup();
            group = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            HashSet collectionsSet = new HashSet();
            List incoming = payload.getOrDefault("collections", new ArrayList());
            collectionsSet.addAll(incoming);
            this.cleanupRemovedCollectionSequences(group, incoming);
            group.setSharedCollections(new ArrayList(collectionsSet));
            this.setSequenceForSharedCollections(group, incoming);
            group = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.save((Object)group);
            result = this.workSpaceLinksGroupMapper.toDTOWithLinksAndCreator(group);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public WorkSpaceLinksGroupDTO duplicateGroup(String groupId, WorkSpaceLinksGroupDTO payload) throws Exception {
        WorkSpaceLinksGroupDTO result = new WorkSpaceLinksGroupDTO();
        String collectionKey = payload.getOriginWorkSpace();
        String title = payload.getTitle();
        String description = payload.getDescription();
        EnumWorkSpaceLinksGroupType type = payload.getType();
        try {
            WorkSpaceLinksGroup workSpaceLinksGroup = new WorkSpaceLinksGroup();
            if (PropertyValidator.isValid((Object)collectionKey)) {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionKey);
                workSpaceLinksGroup.setOriginWorkSpace(workSpace.getKey());
                workSpaceLinksGroup.setCreator(UserContextUtil.getUserContext().getLoggedInUser().getId());
            }
            WorkSpaceLinksGroup group = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            workSpaceLinksGroup.setLinks(group.getLinks());
            workSpaceLinksGroup.setType(group.getType());
            workSpaceLinksGroup.setDescription(group.getDescription());
            if (PropertyValidator.isValid((Object)title)) {
                workSpaceLinksGroup.setTitle(title);
            }
            if (PropertyValidator.isValid((Object)description)) {
                workSpaceLinksGroup.setDescription(description);
            } else {
                workSpaceLinksGroup.setDescription("");
            }
            if (PropertyValidator.isValid((Object)type)) {
                workSpaceLinksGroup.setType(type);
                if ("personal".equals(type.toString().toLowerCase())) {
                    workSpaceLinksGroup.setGroupColor("#EFF6E9");
                } else {
                    workSpaceLinksGroup.setGroupColor("#E5F2FB");
                }
            }
            this.setSequenceForNewGroup(workSpaceLinksGroup, collectionKey, type.toString().toLowerCase());
            workSpaceLinksGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.save((Object)workSpaceLinksGroup);
            this.setSequenceForDuplicatedGroupLinks(workSpaceLinksGroup, groupId);
            result = this.workSpaceLinksGroupMapper.toDTOWithLinksAndCreator(workSpaceLinksGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private String getGroupSequenceForSorting(WorkSpaceLinksGroup group, String sequenceId) {
        if (group == null || group.getSequence() == null) {
            return "aaa";
        }
        String sequence = (String)group.getSequence().get(sequenceId);
        return sequence != null ? sequence : "aaa";
    }

    private void setSequenceForDuplicatedGroupLinks(WorkSpaceLinksGroup group, String originalGroupId) {
        List links = this.workSpaceLinkRepository.findAllWorkspaceLinksByIdIn(group.getLinks());
        links.forEach(link -> {
            if (link.getSequence() != null && link.getSequence().containsKey(originalGroupId)) {
                String sequence = (String)link.getSequence().get(originalGroupId);
                link.getSequence().put(group.getId(), sequence);
                this.workSpaceLinkRepository.save(link);
            }
        });
    }

    private void setSequenceForNewGroup(WorkSpaceLinksGroup workSpaceLinksGroup, String workspaceKey, String type) {
        try {
            WorkSpace workSpace;
            Object lastSequence = null;
            String collectionId = null;
            if (PropertyValidator.isValid((Object)workspaceKey) && (workSpace = this.workSpaceRepository.findByKey(workspaceKey)) != null) {
                collectionId = workSpace.getId();
            }
            String sequenceKey = collectionId;
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            User currentUser = UserContextUtil.getUserContext().getLoggedInUser();
            List existingGroups = new ArrayList();
            existingGroups = "shared".equals(type) && PropertyValidator.isValid((Object)workspaceKey) ? this.workSpaceLinksGroupRepository.findWorkspaceLinksSharedGroups(workspaceKey, EnumWorkSpaceLinksGroupType.SHARED, collectionId, EnumWorkSpaceLinksGroupType.PERSONAL) : this.workSpaceLinksGroupRepository.findByOriginWorkSpaceAndTypeAndCreator(workspaceKey, EnumWorkSpaceLinksGroupType.PERSONAL, currentUser.getId());
            String lastLexoRank = null;
            for (WorkSpaceLinksGroup existingGroup : existingGroups) {
                String groupSeq;
                if (existingGroup.getSequence() == null || !existingGroup.getSequence().containsKey(sequenceKey) || (groupSeq = this.getGroupSequence(existingGroup, sequenceKey)) == null || lastLexoRank != null && LexoRankUtil.compareLexoRanks((String)groupSeq, (String)lastLexoRank) <= 0) continue;
                lastLexoRank = groupSeq;
            }
            String newLexoRank = lastLexoRank == null ? LexoRankUtil.generateLexoRankBetween((String)"a", (String)"z") : LexoRankUtil.generateLexoRankBetween(lastLexoRank, (String)"z");
            HashMap<String, String> sequenceMap = workSpaceLinksGroup.getSequence();
            if (sequenceMap == null) {
                sequenceMap = new HashMap<String, String>();
            }
            sequenceMap.put(sequenceKey, newLexoRank);
            workSpaceLinksGroup.setSequence(sequenceMap);
        }
        catch (Exception e) {
            LOGGER.error("Error setting sequence for new group: " + StringUtils.getTraceString((Throwable)e));
        }
    }

    private String getGroupSequence(WorkSpaceLinksGroup group, String collectionId) {
        if (group == null || group.getSequence() == null) {
            return null;
        }
        Object sequenceObj = group.getSequence().get(collectionId);
        if (sequenceObj instanceof String) {
            return (String)sequenceObj;
        }
        if (sequenceObj instanceof Double) {
            return sequenceObj.toString();
        }
        return null;
    }

    private void cleanupRemovedCollectionSequences(WorkSpaceLinksGroup group, List<String> incomingCollectionIds) {
        try {
            WorkSpace originWorkSpace;
            if (group.getSequence() == null || group.getSequence().isEmpty()) {
                return;
            }
            String originWorkSpaceId = null;
            if (group.getOriginWorkSpace() != null && (originWorkSpace = this.workSpaceRepository.findByKey(group.getOriginWorkSpace())) != null) {
                originWorkSpaceId = originWorkSpace.getId();
            }
            HashSet<String> keepSequences = new HashSet<String>(incomingCollectionIds);
            if (originWorkSpaceId != null) {
                keepSequences.add(originWorkSpaceId);
            } else if (group.getOriginWorkSpace() != null) {
                keepSequences.add(group.getOriginWorkSpace());
            }
            Map sequenceMap = group.getSequence();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String collectionId : sequenceMap.keySet()) {
                if (keepSequences.contains(collectionId)) continue;
                toRemove.add(collectionId);
            }
            for (String collectionId : toRemove) {
                sequenceMap.remove(collectionId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error cleaning up removed collection sequences: " + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void setSequenceForSharedCollections(WorkSpaceLinksGroup group, List<String> newCollectionIds) {
        try {
            if (newCollectionIds == null || newCollectionIds.isEmpty()) {
                return;
            }
            if (group.getSequence() == null) {
                group.setSequence(new HashMap());
            }
            for (String collectionId : newCollectionIds) {
                if (group.getSequence().containsKey(collectionId)) continue;
                WorkSpace workSpace = this.workSpaceRepository.findById(collectionId);
                this.setSequenceForNewGroup(group, workSpace.getKey(), "shared");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error setting sequence for shared collections: " + StringUtils.getTraceString((Throwable)e));
        }
    }
}

