/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.dto.WorkSpaceLinkDTO;
import com.viztrend.safe.mapper.WorkSpaceLinkMapper;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceLink;
import com.viztrend.safe.persistence.entity.WorkSpaceLinksGroup;
import com.viztrend.safe.persistence.repository.WorkSpaceLinkRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceLinksGroupRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.WorkSpaceLinkService;
import com.viztrend.safe.utils.LexoRankUtil;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkSpaceLinkServiceImpl
implements WorkSpaceLinkService {
    private final WorkSpaceLinkRepository workSpaceLinkRepository;
    private final WorkSpaceLinksGroupRepository workSpaceLinksGroupRepository;
    private final WorkSpaceRepository workSpaceRepository;
    private final WorkSpaceLinkMapper workSpaceLinkMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLinkServiceImpl.class);

    public WorkSpaceLinkServiceImpl(WorkSpaceLinkRepository workSpaceLinkRepository, WorkSpaceLinksGroupRepository workSpaceLinksGroupRepository, WorkSpaceRepository workSpaceRepository, WorkSpaceLinkMapper workSpaceLinkMapper) {
        this.workSpaceLinkRepository = workSpaceLinkRepository;
        this.workSpaceLinksGroupRepository = workSpaceLinksGroupRepository;
        this.workSpaceRepository = workSpaceRepository;
        this.workSpaceLinkMapper = workSpaceLinkMapper;
    }

    public WorkSpaceLinkDTO createLink(String groupId, WorkSpaceLinkDTO linkData) throws Exception {
        WorkSpaceLinkDTO result = new WorkSpaceLinkDTO();
        try {
            WorkSpaceLinksGroup group = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            WorkSpaceLink workSpaceLink = this.workSpaceLinkMapper.toEntity(linkData);
            String newLexoRank = this.generateLexoRankForNewLink(group, groupId);
            HashMap<String, String> sequenceMap = new HashMap<String, String>();
            sequenceMap.put(groupId, newLexoRank);
            workSpaceLink.setSequence(sequenceMap);
            workSpaceLink = (WorkSpaceLink)this.workSpaceLinkRepository.save((Object)workSpaceLink);
            if (group.getLinks() == null) {
                group.setLinks(new ArrayList());
            }
            group.getLinks().add(workSpaceLink.getId());
            this.workSpaceLinksGroupRepository.save((Object)group);
            result = this.workSpaceLinkMapper.toDTO(workSpaceLink);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public WorkSpaceLinkDTO updateLink(String linkId, WorkSpaceLinkDTO linkData) throws Exception {
        WorkSpaceLinkDTO result = new WorkSpaceLinkDTO();
        try {
            WorkSpaceLink existingLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)linkId));
            if (PropertyValidator.isValid((Object)linkData.getTitle())) {
                existingLink.setTitle(linkData.getTitle());
            }
            if (PropertyValidator.isValid((Object)linkData.getDescription())) {
                existingLink.setDescription(linkData.getDescription());
            }
            if (PropertyValidator.isValid((Object)linkData.getUrl())) {
                existingLink.setUrl(linkData.getUrl());
            }
            existingLink = (WorkSpaceLink)this.workSpaceLinkRepository.save((Object)existingLink);
            result = this.workSpaceLinkMapper.toDTO(existingLink);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public boolean deleteLink(String linkId) throws Exception {
        try {
            WorkSpaceLink existingLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)linkId));
            if (existingLink == null) {
                return false;
            }
            List allGroups = this.workSpaceLinksGroupRepository.findWorkSpaceLinksGroupByLinks(linkId);
            for (WorkSpaceLinksGroup group : allGroups) {
                if (group.getLinks() == null) continue;
                boolean removed = group.getLinks().removeIf(linkId::equals);
                if (!removed) continue;
                this.workSpaceLinksGroupRepository.save((Object)group);
            }
            this.workSpaceLinkRepository.delete((Serializable)((Object)linkId));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return true;
    }

    public boolean moveLink(String sourceGroupId, String destinationGroupId, String linkId) throws Exception {
        try {
            WorkSpaceLink link;
            WorkSpaceLinksGroup destGroup;
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            WorkSpaceLinksGroup sourceGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)sourceGroupId));
            boolean removed = sourceGroup.getLinks().removeIf(linkId::equals);
            if (removed) {
                this.workSpaceLinksGroupRepository.save((Object)sourceGroup);
            }
            if ((destGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)destinationGroupId))).getLinks() == null) {
                destGroup.setLinks(new ArrayList());
            }
            if ((link = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)linkId))).getSequence() != null) {
                link.getSequence().remove(sourceGroupId);
            }
            String newLexoRank = this.generateLexoRankForNewLink(destGroup, destinationGroupId);
            HashMap<String, String> sequenceMap = link.getSequence();
            if (sequenceMap == null) {
                sequenceMap = new HashMap<String, String>();
            }
            sequenceMap.put(destinationGroupId, newLexoRank);
            link.setSequence(sequenceMap);
            this.workSpaceLinkRepository.save((Object)link);
            destGroup.getLinks().add(linkId);
            this.workSpaceLinksGroupRepository.save((Object)destGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return true;
    }

    public Map<String, WorkSpaceLinkDTO> copyLinkToMultipleGroups(List<String> destinationGroupIds, String linkId) throws Exception {
        HashMap<String, WorkSpaceLinkDTO> result = new HashMap<String, WorkSpaceLinkDTO>();
        try {
            WorkSpaceLink originalLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)linkId));
            List workSpaceLinksGroups = this.workSpaceLinksGroupRepository.findWorkSpaceLinksGroupByIdIn(destinationGroupIds);
            for (WorkSpaceLinksGroup destGroup : workSpaceLinksGroups) {
                if (destGroup == null) continue;
                WorkSpaceLink copyLink = new WorkSpaceLink();
                copyLink.setTitle(originalLink.getTitle());
                if (PropertyValidator.isValid((Object)originalLink.getDescription())) {
                    copyLink.setDescription(originalLink.getDescription());
                }
                copyLink.setUrl(originalLink.getUrl());
                if (destGroup.getLinks() == null) {
                    destGroup.setLinks(new ArrayList());
                }
                String newLexoRank = this.generateLexoRankForNewLink(destGroup, destGroup.getId());
                HashMap<String, String> sequenceMap = new HashMap<String, String>();
                sequenceMap.put(destGroup.getId(), newLexoRank);
                copyLink.setSequence(sequenceMap);
                copyLink = (WorkSpaceLink)this.workSpaceLinkRepository.save((Object)copyLink);
                destGroup.getLinks().add(copyLink.getId());
                this.workSpaceLinksGroupRepository.save((Object)destGroup);
                WorkSpaceLinkDTO resultLink = new WorkSpaceLinkDTO();
                resultLink = this.workSpaceLinkMapper.toDTO(copyLink);
                result.put(destGroup.getId(), resultLink);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, String> updateSequence(String groupId, Map<String, Object> requestBody) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WorkSpaceLink prevLink;
            String movedLinkId = (String)requestBody.get("movedLinkId");
            String prevLinkId = (String)requestBody.get("prevLinkId");
            String nextLinkId = (String)requestBody.get("nextLinkId");
            if (!PropertyValidator.isValid((Object)movedLinkId)) {
                throw new IllegalArgumentException("Missing movedLinkId");
            }
            WorkSpaceLinksGroup group = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)groupId));
            List groupLinks = this.workSpaceLinkRepository.findAllWorkspaceLinksByIdIn(group.getLinks());
            List existingSequences = groupLinks.stream().filter(link -> !link.getId().equals(movedLinkId)).map(link -> link.getSequence() != null ? (String)link.getSequence().get(groupId) : null).filter(PropertyValidator::isValid).collect(Collectors.toList());
            WorkSpaceLink movedLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)movedLinkId));
            if (movedLink == null) {
                throw new IllegalArgumentException("Link not found: " + movedLinkId);
            }
            String oldSequence = movedLink.getSequence() != null ? (String)movedLink.getSequence().get(groupId) : null;
            String newSequence = null;
            if (PropertyValidator.isValid((Object)prevLinkId) && PropertyValidator.isValid((Object)nextLinkId)) {
                prevLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)prevLinkId));
                WorkSpaceLink nextLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)nextLinkId));
                String prevSequence = prevLink != null && prevLink.getSequence() != null ? (String)prevLink.getSequence().get(groupId) : null;
                String nextSequence = nextLink != null && nextLink.getSequence() != null ? (String)nextLink.getSequence().get(groupId) : null;
                newSequence = LexoRankUtil.generateLexoRankBetween((String)prevSequence, nextSequence);
            } else if (PropertyValidator.isValid((Object)prevLinkId)) {
                prevLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)prevLinkId));
                String prevSequence = prevLink != null && prevLink.getSequence() != null ? (String)prevLink.getSequence().get(groupId) : null;
                newSequence = LexoRankUtil.generateLexoRankBetween(prevSequence, (String)"z");
            } else if (PropertyValidator.isValid((Object)nextLinkId)) {
                String nextSequence;
                WorkSpaceLink nextLink = (WorkSpaceLink)this.workSpaceLinkRepository.findOne((Serializable)((Object)nextLinkId));
                String string = nextSequence = nextLink != null && nextLink.getSequence() != null ? (String)nextLink.getSequence().get(groupId) : null;
                newSequence = LexoRankUtil.compareLexoRanks(nextSequence, (String)LexoRankUtil.getMinLexoRank()) == 0 ? LexoRankUtil.generateLexoRankBetween((String)"a", (String)nextSequence) : LexoRankUtil.generateLexoRankBetween((String)LexoRankUtil.getMinLexoRank(), (String)nextSequence);
            } else {
                newSequence = LexoRankUtil.generateFirstLexoRank();
            }
            HashMap<String, String> seqMap = movedLink.getSequence();
            if (seqMap == null) {
                seqMap = new HashMap<String, String>();
            }
            seqMap.put(groupId, newSequence);
            movedLink.setSequence(seqMap);
            this.workSpaceLinkRepository.save((Object)movedLink);
            result.put(movedLinkId, newSequence);
            return result;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return result;
        }
    }

    public Map<String, String> updateGroupSequence(String collectionKey, Map<String, Object> requestBody) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String newSequence;
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionKey);
            String collectionId = workSpace.getId();
            String movedGroupId = (String)requestBody.get("movedGroupId");
            String prevGroupId = (String)requestBody.get("prevGroupId");
            String nextGroupId = (String)requestBody.get("nextGroupId");
            String groupType = (String)requestBody.get("groupType");
            WorkSpaceLinksGroup movedGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)movedGroupId));
            if (PropertyValidator.isValid((Object)prevGroupId) && PropertyValidator.isValid((Object)nextGroupId)) {
                WorkSpaceLinksGroup prevGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)prevGroupId));
                WorkSpaceLinksGroup nextGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)nextGroupId));
                String prevSequence = this.getGroupSequence(prevGroup, collectionId, groupType);
                String nextSequence = this.getGroupSequence(nextGroup, collectionId, groupType);
                newSequence = LexoRankUtil.generateLexoRankBetween((String)prevSequence, (String)nextSequence);
            } else if (PropertyValidator.isValid((Object)prevGroupId)) {
                WorkSpaceLinksGroup prevGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)prevGroupId));
                String prevSequence = this.getGroupSequence(prevGroup, collectionId, groupType);
                newSequence = LexoRankUtil.generateLexoRankBetween((String)prevSequence, (String)"z");
            } else {
                WorkSpaceLinksGroup nextGroup;
                String nextSequence;
                newSequence = PropertyValidator.isValid((Object)nextGroupId) ? (LexoRankUtil.compareLexoRanks((String)(nextSequence = this.getGroupSequence(nextGroup = (WorkSpaceLinksGroup)this.workSpaceLinksGroupRepository.findOne((Serializable)((Object)nextGroupId)), collectionId, groupType)), (String)LexoRankUtil.getMinLexoRank()) == 0 ? LexoRankUtil.generateLexoRankBetween((String)"a", (String)nextSequence) : LexoRankUtil.generateLexoRankBetween((String)LexoRankUtil.getMinLexoRank(), (String)nextSequence)) : LexoRankUtil.generateFirstLexoRank();
            }
            this.setGroupSequence(movedGroup, collectionId, groupType, newSequence);
            this.workSpaceLinksGroupRepository.save((Object)movedGroup);
            result.put(movedGroupId, newSequence);
            return result;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return result;
        }
    }

    private String getGroupSequence(WorkSpaceLinksGroup group, String collectionId, String groupType) {
        String sequence;
        if (group == null) {
            return null;
        }
        String string = sequence = group.getSequence() != null ? (String)group.getSequence().get(collectionId) : null;
        if (sequence == null) {
            return "aaa";
        }
        return sequence;
    }

    private void setGroupSequence(WorkSpaceLinksGroup group, String collectionId, String groupType, String newSequence) {
        HashMap<String, String> seqMap = group.getSequence();
        if (seqMap == null) {
            seqMap = new HashMap<String, String>();
        }
        seqMap.put(collectionId, newSequence);
        group.setSequence(seqMap);
    }

    private String generateLexoRankForNewLink(WorkSpaceLinksGroup group, String groupId) {
        String lastLexoRank = null;
        if (group.getLinks() != null && !group.getLinks().isEmpty()) {
            List existingLinks = this.workSpaceLinkRepository.findAllWorkspaceLinksByIdIn(group.getLinks());
            for (WorkSpaceLink existingLink : existingLinks) {
                if (existingLink.getSequence() == null || !existingLink.getSequence().containsKey(groupId)) continue;
                String linkSeq = (String)existingLink.getSequence().get(groupId);
                if (lastLexoRank != null && LexoRankUtil.compareLexoRanks((String)linkSeq, (String)lastLexoRank) <= 0) continue;
                lastLexoRank = linkSeq;
            }
        }
        String newLexoRank = lastLexoRank == null ? LexoRankUtil.generateLexoRankBetween((String)"a", (String)"z") : LexoRankUtil.generateLexoRankBetween(lastLexoRank, (String)"z");
        return newLexoRank;
    }
}

