/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.FeatureSetupProgress;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.FeatureSetupProgressRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PiAgendaRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="userService")
@Transactional
class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    FeatureSetupProgressRepository featureSetupProgressRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private PiAgendaRepository piAgendaRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;

    UserServiceImpl() {
    }

    public User findByUserName(String userName) {
        return this.userRepository.findByUserNameIgnoreCase(userName);
    }

    public Long findActiveUserByCompanyId(String companyId) {
        Long activeUserCount = 0L;
        try {
            List companiesUsers = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(companyId, Boolean.valueOf(false));
            for (User user : companiesUsers) {
                for (UserCompany uc : user.getUserCompanies()) {
                    if (!uc.getCompany().getId().equals(companyId) || !uc.getIsActive().booleanValue() || uc.getIsGuest().booleanValue()) continue;
                    Long l = activeUserCount;
                    Long l2 = activeUserCount = Long.valueOf(activeUserCount + 1L);
                }
            }
            return activeUserCount;
        }
        catch (Exception exception) {
            return activeUserCount;
        }
    }

    public boolean isPremiumPackageUser(User user, Company company) {
        if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Object)company)) {
            throw new IllegalArgumentException("User or Company is null");
        }
        List userCompanies = PropertyValidator.isValid((Collection)user.getUserCompanies()) ? user.getUserCompanies() : new ArrayList();
        Optional<UserCompany> loggedInCompany = userCompanies.stream().filter(userCompany -> PropertyValidator.isValid((Object)userCompany.getCompany()) && company.getId().equals(userCompany.getCompany().getId())).findFirst();
        return loggedInCompany.isPresent() && company.getIsPremium() != false;
    }

    public Long findActiveGuestUserByCompanyId(String companyId) {
        long activeGuestUserCount = 0L;
        try {
            List companiesUsers = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(companyId, Boolean.valueOf(false));
            for (User user : companiesUsers) {
                for (UserCompany uc : user.getUserCompanies()) {
                    if (!PropertyValidator.isValid((Object)uc.getCompany()) || !uc.getCompany().getId().equals(companyId) || !uc.getIsActive().booleanValue() || !uc.getIsGuest().booleanValue()) continue;
                    ++activeGuestUserCount;
                }
            }
            return activeGuestUserCount;
        }
        catch (Exception ex) {
            LOGGER.error("Exception -> findActiveGuestUserByCompanyId <-", (Throwable)ex);
            return activeGuestUserCount;
        }
    }

    public void createOnboardGuide() {
        FeatureSetupProgress featuresList = new FeatureSetupProgress();
        ArrayList featureProgressList = new ArrayList();
        String labelKey = "label";
        String completedKey = "completed";
        String orderkey = "order";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Connect_To_Jira");
        keys.add("Create_Board");
        keys.add("Get_Features_from_Jira");
        keys.add("Create_Dependencies");
        keys.add("Manage_Objectives");
        keys.add("ROAM_Risks");
        keys.add("Start_Planning_Agenda");
        int i = 1;
        for (String key : keys) {
            HashMap keyMeta = new HashMap();
            HashMap<String, Object> metaData = new HashMap<String, Object>();
            metaData.put(labelKey, key);
            metaData.put(completedKey, false);
            metaData.put(orderkey, i++);
            keyMeta.put(key, metaData);
            featureProgressList.add(keyMeta);
        }
        featuresList.setFeatureSetup(featureProgressList);
        this.featureSetupProgressRepository.save((Object)featuresList);
    }

    public List<Map<String, Object>> setOnboardingMeta(String key, boolean status) {
        try {
            List onboardingData = this.featureSetupProgressRepository.findAll();
            List<Map> fetureSetup = new ArrayList();
            FeatureSetupProgress featuresList = new FeatureSetupProgress();
            if (PropertyValidator.isValid((Collection)onboardingData)) {
                fetureSetup = ((FeatureSetupProgress)onboardingData.get(0)).getFeatureSetup();
            }
            if (PropertyValidator.isValid(fetureSetup)) {
                if (PropertyValidator.isValid((Object)key)) {
                    for (int i = 0; i < fetureSetup.size(); ++i) {
                        Map obj = (Map)fetureSetup.get(i);
                        if (obj.get(key) == null) continue;
                        ((Map)obj.get(key)).put("completed", status);
                        fetureSetup.set(i, obj);
                    }
                    ((FeatureSetupProgress)onboardingData.get(0)).setFeatureSetup(fetureSetup);
                    this.featureSetupProgressRepository.save((Iterable)onboardingData);
                }
            } else {
                HashMap<String, Object> feaObjMeta = new HashMap<String, Object>();
                HashMap<String, HashMap<String, Object>> keyMeta = new HashMap<String, HashMap<String, Object>>();
                feaObjMeta.put("label", key);
                feaObjMeta.put("completed", status);
                feaObjMeta.put("orderKey", 1);
                keyMeta.put(key, feaObjMeta);
                fetureSetup.add(keyMeta);
                featuresList.setFeatureSetup(fetureSetup);
            }
            return featuresList.getFeatureSetup();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public FeatureSetupProgress checkOnboardingMeta() {
        FeatureSetupProgress temp = new FeatureSetupProgress();
        ArrayList fetureSetup = new ArrayList();
        List almConfig = this.almConfigurationsRepository.findAll();
        List tfsAlmConfigs = this.tfsAlmConfigurationsRepository.findAll();
        List sessionBoards = this.sessionBoardRepository.findAll();
        List items = this.itemRepository.findAll();
        List jiraLinks = this.itemJiraDependencyRepository.findAll();
        List risks = this.riskRepository.findAll();
        List agenda = this.piAgendaRepository.findAll();
        Boolean riskPresent = false;
        for (SessionBoard sessionboard : sessionBoards) {
            if (!PropertyValidator.isValid((Collection)sessionboard.getObjectiveIds()) || sessionboard.getObjectiveIds().size() <= 0) continue;
            riskPresent = true;
            break;
        }
        if (PropertyValidator.isValid((Collection)almConfig) || PropertyValidator.isValid((Collection)tfsAlmConfigs)) {
            fetureSetup.addAll(this.setOnboardingMeta("Connect_To_Jira", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("Connect_To_Jira", false));
        }
        if (PropertyValidator.isValid((Collection)sessionBoards)) {
            fetureSetup.addAll(this.setOnboardingMeta("Create_Board", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("Create_Board", false));
        }
        if (PropertyValidator.isValid((Collection)items)) {
            fetureSetup.addAll(this.setOnboardingMeta("Get_Features_from_Jira", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("Get_Features_from_Jira", false));
        }
        if (PropertyValidator.isValid((Collection)jiraLinks)) {
            fetureSetup.addAll(this.setOnboardingMeta("Create_Dependencies", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("Create_Dependencies", false));
        }
        fetureSetup.addAll(this.setOnboardingMeta("Manage_Objectives", riskPresent.booleanValue()));
        if (PropertyValidator.isValid((Collection)risks)) {
            fetureSetup.addAll(this.setOnboardingMeta("ROAM_Risks", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("ROAM_Risks", false));
        }
        if (PropertyValidator.isValid((Collection)agenda)) {
            fetureSetup.addAll(this.setOnboardingMeta("Start_Planning_Agenda", true));
        } else {
            fetureSetup.addAll(this.setOnboardingMeta("Start_Planning_Agenda", false));
        }
        temp.setFeatureSetup(fetureSetup);
        this.featureSetupProgressRepository.save((Object)temp);
        return temp;
    }

    public Map<String, Long> getPackageLimitCount(Company company) {
        HashMap<String, Long> packageLimitCount = new HashMap<String, Long>();
        long invitationCount = this.invitationRepository.countByTenantAndArchiveFalse(company.getTenant());
        Long usersCount = this.customRepositoryImpl.findActiveUserCountAndActiveGuesUserUserCount(company.getId(), false);
        usersCount = usersCount + invitationCount;
        Long pkgUsersCount = company.getUserCount();
        Long guestUserCount = this.customRepositoryImpl.findActiveUserCountAndActiveGuesUserUserCount(company.getId(), true);
        Long pkgGuestUsersCount = company.getGuestUserCount();
        packageLimitCount.put("userCount", usersCount);
        packageLimitCount.put("pkgUserCount", pkgUsersCount);
        packageLimitCount.put("guestUserCount", guestUserCount);
        packageLimitCount.put("pkgGuestUserCount", pkgGuestUsersCount);
        packageLimitCount.put("invitationCount", invitationCount);
        return packageLimitCount;
    }
}

