/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.Token;
import com.viztrend.safe.persistence.repository.TokenRepository;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.stereotype.Component;

@Component
public class TokenService
implements PersistentTokenRepository {
    @Autowired
    TokenRepository repository;

    public void createNewToken(PersistentRememberMeToken token) {
        this.repository.save((Object)new Token(null, token.getUsername(), token.getSeries(), token.getTokenValue(), token.getDate()));
    }

    public void updateToken(String series, String value, Date lastUsed) {
        Token token = this.repository.findBySeries(series);
        this.repository.save((Object)new Token(token.getId(), token.getUsername(), series, value, lastUsed));
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        return this.repository.findBySeries(seriesId);
    }

    public void removeUserTokens(String username) {
        Token token = this.repository.findByUsername(username);
        if (token != null) {
            this.repository.delete((Object)token);
        }
    }
}

