/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.TimeSeriesDTO;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.service.TimeSeriesService;
import com.viztrend.safe.service.TimeSeriesServiceImpl;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesServiceImpl
implements TimeSeriesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesServiceImpl.class);
    private final TimeSeriesRepository timeSeriesRepository;

    @Autowired
    public TimeSeriesServiceImpl(TimeSeriesRepository timeSeriesRepository) {
        this.timeSeriesRepository = timeSeriesRepository;
    }

    public List<TimeSeriesDTO> createDataForAreaChart(Date startDate, Date endDate, String tenant, TimeSeriesDTO.ChartType type, TimeSeriesDTO.Interval interval, List<String> queryData) throws Exception {
        List intervals = this.createIntervalsBetweenDatesForType(startDate, endDate, interval);
        List itemData = this.timeSeriesRepository.getItemCountForIdsInRange(startDate, endDate, tenant, type, interval, queryData);
        for (TimeSeriesDTO item : itemData) {
            ArrayList<Object> sortedItemCountForDuration = new ArrayList<Object>();
            Map itemCountForDuration = item.getItemCountForDuration();
            for (String intervalDates : intervals) {
                sortedItemCountForDuration.add(itemCountForDuration.getOrDefault(intervalDates, null));
            }
            item.setDateSortedItemCounts(sortedItemCountForDuration);
            item.setItemCountForDuration(null);
        }
        return itemData;
    }

    public Map<Long, Integer> createDataForFlowChart(Date startDate, Date endDate, String tenant, String startStatusId, String endStatusId, int interval) throws Exception {
        List dayIntervals = this.calculateDayIntervalsBetweenDates(startDate, endDate, interval);
        List itemData = this.timeSeriesRepository.getStartAndEndStatusTimesInRange(startDate, endDate, tenant, startStatusId, endStatusId);
        List filteredItems = this.filterCompletedItemsForLeapTime(itemData);
        HashMap<Long, Integer> itemCountPerInterval = new HashMap<Long, Integer>();
        for (Long inter : dayIntervals) {
            itemCountPerInterval.put(inter, 0);
        }
        for (TimeSeriesDTO item : filteredItems) {
            List startToEndDuration = item.getStartToEndDurationInDays();
            if (!PropertyValidator.isValid((Collection)startToEndDuration)) continue;
            for (Long duration : startToEndDuration) {
                Long roundedDuration = this.roundToNearest(dayIntervals, duration);
                if (!itemCountPerInterval.containsKey(roundedDuration)) continue;
                itemCountPerInterval.put(roundedDuration, (Integer)itemCountPerInterval.get(roundedDuration) + 1);
            }
        }
        return itemCountPerInterval;
    }

    public List<Map<String, List<Long>>> createDataForStackedStatusChart(Date startDate, Date endDate, String tenant, List<String> itemIds, List<String> statusIds) throws Exception {
        Map itemData = this.timeSeriesRepository.getStatusIdAndEventTimeForEachItem(startDate, endDate, tenant, itemIds, statusIds);
        ArrayList<Map<String, List<Long>>> statusItemMatrix = new ArrayList<Map<String, List<Long>>>();
        HashMap itemStatusTransitionDuration = new HashMap();
        List<Object> allItemSortedStatusIds = new ArrayList();
        for (String itemId : itemIds) {
            Map itemStatuses;
            TimeSeriesDTO item = (TimeSeriesDTO)itemData.get(itemId);
            if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid((Object)(itemStatuses = item.getStatusMap()))) continue;
            Map<String, LocalDateTime> statusIdToDateTimeMap = statusIds.stream().filter(itemStatuses::containsKey).collect(Collectors.toMap(statusId -> statusId, statusId -> KendisUtils.convertToLocalDateTime((String)((String)itemStatuses.get(statusId)))));
            ArrayList<Map.Entry<String, LocalDateTime>> sortedStatuses = new ArrayList<Map.Entry<String, LocalDateTime>>(statusIdToDateTimeMap.entrySet());
            sortedStatuses.sort(Map.Entry.comparingByValue());
            List sortedStatusIds = sortedStatuses.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            if (sortedStatusIds.size() > allItemSortedStatusIds.size()) {
                allItemSortedStatusIds = sortedStatusIds;
            }
            HashMap daysDiffMap = new HashMap();
            IntStream.range(0, sortedStatuses.size() - 1).forEach(i -> {
                long days = ChronoUnit.DAYS.between((Temporal)((Map.Entry)sortedStatuses.get(i)).getValue(), (Temporal)((Map.Entry)sortedStatuses.get(i + 1)).getValue());
                daysDiffMap.merge(((Map.Entry)sortedStatuses.get(i)).getKey(), days, Long::sum);
            });
            itemStatusTransitionDuration.put(itemId, daysDiffMap);
        }
        for (String statusId2 : allItemSortedStatusIds) {
            HashMap statusItem = new HashMap();
            List itemDurationForStatus = itemIds.stream().map(itemStatusTransitionDuration::get).filter(PropertyValidator::isValid).map(statusDurationMap -> (Long)statusDurationMap.get(statusId2)).collect(Collectors.toList());
            if (statusId2.equals(allItemSortedStatusIds.get(allItemSortedStatusIds.size() - 1))) continue;
            statusItem.put(statusId2, itemDurationForStatus);
            statusItemMatrix.add(statusItem);
        }
        return statusItemMatrix;
    }

    private Long roundToNearest(List<Long> values, Long number) {
        Long closestValue = values.get(0);
        boolean firstMax = false;
        for (int i = 0; i < values.size() && !firstMax; ++i) {
            if (values.get(i) <= number) continue;
            firstMax = true;
            closestValue = values.get(i);
        }
        return closestValue;
    }

    private List<TimeSeriesDTO> filterCompletedItemsForLeapTime(List<TimeSeriesDTO> itemData) {
        ArrayList<TimeSeriesDTO> filteredItems = new ArrayList<TimeSeriesDTO>();
        if (PropertyValidator.isValid(itemData)) {
            for (TimeSeriesDTO item : itemData) {
                if (!PropertyValidator.isValid((Collection)item.getStartStatusTime()) || !PropertyValidator.isValid((Collection)item.getEndStatusTime())) continue;
                TimeSeriesDTO filteredItem = this.getDurationIntervalsFromValidStartDates(item);
                filteredItems.add(filteredItem);
            }
        }
        return filteredItems;
    }

    private TimeSeriesDTO getDurationIntervalsFromValidStartDates(TimeSeriesDTO item) {
        List startDates = item.getStartStatusTime();
        List endDates = item.getEndStatusTime();
        TimeSeriesDTO validRangeItem = new TimeSeriesDTO(item);
        for (Date endDate : endDates) {
            LocalDateTime localEndDate = KendisUtils.convertToLocalDateTime((String)endDate.toString());
            boolean validDateFound = false;
            for (int startIdx = 0; startIdx < startDates.size() && !validDateFound; ++startIdx) {
                LocalDateTime localStartDate = KendisUtils.convertToLocalDateTime((String)((Date)startDates.get(startIdx)).toString());
                if (!PropertyValidator.isValid((Object)localStartDate) || !localStartDate.isBefore(localEndDate)) continue;
                validRangeItem.addStartToEndDurationInDays(localStartDate, localEndDate);
                validDateFound = true;
            }
        }
        return validRangeItem;
    }

    private List<String> createIntervalsBetweenDatesForType(Date startDate, Date endDate, TimeSeriesDTO.Interval interval) {
        ArrayList<String> dateIntervals = new ArrayList<String>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(interval.getPattern());
        LocalDate localStartDate = KendisUtils.convertToLocalDate((String)startDate.toString());
        LocalDate localEndDate = KendisUtils.convertToLocalDate((String)endDate.toString());
        if (PropertyValidator.isValid((Object)localStartDate) && PropertyValidator.isValid((Object)localEndDate)) {
            LocalDate currentDate = localStartDate;
            while (!currentDate.isAfter(localEndDate)) {
                dateIntervals.add(formatter.format(currentDate));
                switch (1.$SwitchMap$com$viztrend$safe$persistence$entity$TimeSeriesDTO$Interval[interval.ordinal()]) {
                    case 1: {
                        currentDate = currentDate.plusDays(1L);
                        break;
                    }
                    case 2: {
                        currentDate = currentDate.plusMonths(1L);
                        break;
                    }
                    case 3: {
                        currentDate = currentDate.plusYears(1L);
                    }
                }
            }
        }
        return dateIntervals;
    }

    private List<Long> calculateDayIntervalsBetweenDates(Date startDate, Date endDate, int interval) {
        LocalDate currentDate;
        LocalDate startLocalDate = currentDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ArrayList<Long> dayGroups = new ArrayList<Long>();
        long daysUntilInterval = interval;
        while (!currentDate.isAfter(endLocalDate)) {
            daysUntilInterval = ChronoUnit.DAYS.between(startLocalDate, currentDate);
            dayGroups.add(daysUntilInterval);
            currentDate = currentDate.plusDays(interval);
        }
        dayGroups.add(daysUntilInterval + (long)interval);
        return dayGroups;
    }

    private List<String> sortStatusList(List<String> statusIds, List<String> itemStatusList) {
        Map<String, Integer> indexMap = IntStream.range(0, statusIds.size()).boxed().collect(Collectors.toMap(statusIds::get, i -> i));
        ArrayList<String> sortedList2 = new ArrayList<String>(itemStatusList);
        sortedList2.sort(Comparator.comparingInt(s -> indexMap.getOrDefault(s, -1)));
        return sortedList2;
    }
}

