/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.service.TimeSeriesInfoService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesInfoServiceImpl
implements TimeSeriesInfoService {
    @Autowired
    private MongoTemplate mongoTemplate;

    public Map<String, List<TimeSeriesLog>> fetchItemsData(String startDate, String endDate, String sessionId, String sessionBoardId) throws Exception {
        HashMap<String, List<TimeSeriesLog>> resultMap = new HashMap();
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        LocalDate localDate = LocalDate.parse(startDate);
        LocalDateTime dateTimeAtStartOfCurrentDay = localDate.atTime(LocalTime.MIN);
        Date startTime = Date.from(dateTimeAtStartOfCurrentDay.atZone(ZoneId.systemDefault()).toInstant());
        localDate = LocalDate.parse(endDate);
        LocalDateTime dateTimeAtEndOfCurrentDay = localDate.atTime(LocalTime.MAX);
        Date endTime = Date.from(dateTimeAtEndOfCurrentDay.atZone(ZoneId.systemDefault()).toInstant());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventTime").gte((Object)startTime).lte((Object)endTime));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"meta.tenant").is((Object)tenant));
        if (PropertyValidator.isValid((Object)sessionId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"meta.sessionId").is((Object)sessionId));
        }
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"meta.sessionBoardId").is((Object)sessionBoardId));
        }
        query.fields().include("meta").include("archive").include("itemId").include("title").include("changes").include("eventTime");
        List itemsLog = this.mongoTemplate.find(query, TimeSeriesLog.class, "itemTimeSeries");
        HashSet<String> statusIds = new HashSet<String>();
        HashSet<String> teamIds = new HashSet<String>();
        HashSet<String> sprintIds = new HashSet<String>();
        for (TimeSeriesLog log : itemsLog) {
            ArrayList teamContainers;
            Map status;
            Map changes = log.getChanges();
            if (!PropertyValidator.isValid((Object)changes)) continue;
            if (changes.containsKey("status") && PropertyValidator.isValid((Object)(status = (Map)changes.get("status")))) {
                statusIds.add(status.get("id").toString());
            }
            if (!changes.containsKey("teamContainers") || !PropertyValidator.isValid((Collection)(teamContainers = (ArrayList)changes.get("teamContainers")))) continue;
            for (Object teamContainer : teamContainers) {
                Map team;
                LinkedHashMap obj;
                if (!(teamContainer instanceof LinkedHashMap) || !PropertyValidator.isValid((Object)(obj = (LinkedHashMap)teamContainer))) continue;
                LinkedHashMap containerObj = (LinkedHashMap)obj.get("container");
                if (PropertyValidator.isValid((Object)containerObj)) {
                    Object sprintIdObj = containerObj.get("id");
                    sprintIds.add((String)sprintIdObj);
                }
                if (!PropertyValidator.isValid((Object)(team = (Map)obj.get("team")))) continue;
                teamIds.add((String)team.get("id"));
            }
        }
        query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(statusIds));
        query.fields().include("title");
        List allStatuses = this.mongoTemplate.find(query, Status.class, "status");
        query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds));
        query.fields().include("title");
        List allTeams = this.mongoTemplate.find(query, Team.class, "team");
        query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sprintIds));
        query.fields().include("title");
        List allSprints = this.mongoTemplate.find(query, Container.class, "container");
        HashMap<String, Object> allStatusMap = new HashMap<String, Object>();
        for (Object status : allStatuses) {
            allStatusMap.put(status.getId(), status);
        }
        HashMap<String, Team> allTeamMap = new HashMap<String, Team>();
        for (Team team : allTeams) {
            allTeamMap.put(team.getId(), team);
        }
        HashMap<String, Container> allSprintMap = new HashMap<String, Container>();
        for (Container container : allSprints) {
            allSprintMap.put(container.getId(), container);
        }
        for (TimeSeriesLog log : itemsLog) {
            ArrayList teamContainers;
            Status tempStatus;
            Map status;
            Map changes = log.getChanges();
            if (!PropertyValidator.isValid((Object)changes)) continue;
            if (changes.containsKey("status") && PropertyValidator.isValid((Object)(status = (Map)changes.get("status"))) && PropertyValidator.isValid((Object)(tempStatus = (Status)allStatusMap.get(status.get("id").toString())))) {
                status.put("title", tempStatus.getTitle());
            }
            if (!changes.containsKey("teamContainers") || !PropertyValidator.isValid((Collection)(teamContainers = (ArrayList)changes.get("teamContainers")))) continue;
            for (Object teamContainer : teamContainers) {
                Team tempTeam;
                Map team;
                Object sprintIdObj;
                Container tempContainer;
                LinkedHashMap obj;
                if (!(teamContainer instanceof LinkedHashMap) || !PropertyValidator.isValid((Object)(obj = (LinkedHashMap)teamContainer))) continue;
                LinkedHashMap containerObj = (LinkedHashMap)obj.get("container");
                if (PropertyValidator.isValid((Object)containerObj) && PropertyValidator.isValid((Object)(tempContainer = (Container)allSprintMap.get((sprintIdObj = containerObj.get("id")).toString())))) {
                    containerObj.put("title", tempContainer.getTitle());
                }
                if (!PropertyValidator.isValid((Object)(team = (Map)obj.get("team"))) || !PropertyValidator.isValid((Object)(tempTeam = (Team)allTeamMap.get(team.get("id").toString())))) continue;
                team.put("title", tempTeam.getTitle());
            }
        }
        resultMap = itemsLog.stream().sorted(Comparator.comparing(TimeSeriesLog::getEventTime)).collect(Collectors.groupingBy(TimeSeriesLog::getItemId, LinkedHashMap::new, Collectors.toList()));
        return resultMap;
    }
}

