/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.TimeCapsule;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.TimeCapsuleRepository;
import com.viztrend.safe.service.TimeCapsuleService;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component(value="timeCapsuleService")
public class TimeCapsuleServiceImpl
implements TimeCapsuleService {
    private static final Logger logger = LoggerFactory.getLogger(TimeCapsuleServiceImpl.class);
    @Autowired
    private TimeCapsuleRepository timeCapsulesRepository;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;

    public void setDefaultTimeCapsules() {
        try {
            int year = Year.now().getValue();
            int noOfYears = 5;
            ArrayList timeCapsules = new ArrayList(this.createTimeCapsulesForYear(year - 1));
            --noOfYears;
            for (int i = 0; i < noOfYears; ++i) {
                timeCapsules.addAll(this.createTimeCapsulesForYear(year));
                ++year;
            }
            this.timeCapsulesRepository.save(timeCapsules);
        }
        catch (Exception e) {
            logger.error("Error while setting default time capsules", (Throwable)e);
        }
    }

    public int getCount() {
        return this.timeCapsulesRepository.findAll().size();
    }

    public List<TimeCapsule> getTimeCapsules() {
        ArrayList timeCapsules = new ArrayList();
        try {
            timeCapsules = this.timeCapsulesRepository.findAll();
        }
        catch (Exception e) {
            logger.error("Error while getting time capsules", (Throwable)e);
        }
        return timeCapsules;
    }

    public boolean saveEditedTimeCapsules(List<TimeCapsule> timeCapsules) throws Exception {
        this.timeCapsulesRepository.save(timeCapsules);
        return true;
    }

    public ResponseEntity<Object> updateSequence(HashMap<String, Object> params) throws Exception {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String timeCapsuleId = (String)params.get("timeCapsuleId");
        Double sequence = Double.parseDouble((String)params.get("sequence"));
        TimeCapsule timeCapsule = (TimeCapsule)this.timeCapsulesRepository.findOne((Serializable)((Object)timeCapsuleId));
        if (PropertyValidator.isValid((Object)timeCapsule)) {
            timeCapsule.setSequence(sequence);
            this.timeCapsulesRepository.save((Object)timeCapsule);
            result.put("success", true);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    private List<TimeCapsule> createTimeCapsulesForYear(int year) {
        ArrayList<TimeCapsule> timeCapsules = new ArrayList<TimeCapsule>();
        timeCapsules.add(new TimeCapsule("Q1 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-01-01"), this.formatDateString(year + "-03-31")));
        timeCapsules.add(new TimeCapsule("Q2 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-04-01"), this.formatDateString(year + "-06-30")));
        timeCapsules.add(new TimeCapsule("Q3 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-07-01"), this.formatDateString(year + "-09-30")));
        timeCapsules.add(new TimeCapsule("Q4 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-10-01"), this.formatDateString(year + "-12-31")));
        timeCapsules.add(new TimeCapsule("H1 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-01-01"), this.formatDateString(year + "-06-30")));
        timeCapsules.add(new TimeCapsule("H2 " + year, "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-07-01"), this.formatDateString(year + "-12-31")));
        timeCapsules.add(new TimeCapsule(String.valueOf(year), "#000000", KendisUtils.generateRandomLightColorCode(), this.formatDateString(year + "-01-01"), this.formatDateString(year + "-12-31")));
        return timeCapsules;
    }

    private Date formatDateString(String inputDateString) {
        Date outputDateString = null;
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
            inputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            outputDateString = inputFormat.parse(inputDateString);
        }
        catch (Exception e) {
            logger.error("Error while formatting date string", (Throwable)e);
        }
        return outputDateString;
    }

    public TimeCapsule getTimeCapsule(String id) {
        return (TimeCapsule)this.timeCapsulesRepository.findOne((Serializable)((Object)id));
    }

    public void deleteTimeCapsule(String id) {
        this.timeCapsulesRepository.delete((Serializable)((Object)id));
        this.backlogItemRepository.findByCustomId(id).forEach(item -> {
            item.setTimeCapsuleRelation(null);
            this.backlogItemRepository.save(item);
        });
    }

    public TimeCapsule addTimeCapsule(TimeCapsule timeCapsule) throws Exception {
        return (TimeCapsule)this.timeCapsulesRepository.save((Object)timeCapsule);
    }
}

