/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkFlowItemType;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSPreferencesRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.TfsProjectWorkflowService;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="TfsProjectWorkflowService")
@Transactional
public class TfsProjectWorkflowServiceImpl
implements TfsProjectWorkflowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TfsProjectWorkflowServiceImpl.class);
    @Autowired
    StatusRepository statusRepository;
    @Autowired
    WorkFlowRepository workFlowRepository;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    TFSUtils tfsUtils;
    @Autowired
    TFSPreferencesRepository tfsPreferencesRepository;

    public WorkFlow createWorkflowForProject(TFSProject tfsProject, String almId) throws Exception {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setTitle("workflow-" + tfsProject.getName());
        workFlow.setTfsProject(tfsProject.getName());
        workFlow.setTfsProjectId(tfsProject.getTfsId());
        workFlow.setAlmId(almId);
        workFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
        ArrayList<Status> statuses = new ArrayList<Status>();
        ArrayList<WorkFlowItemType> itemTypes = new ArrayList<WorkFlowItemType>();
        String itemTypeStr = tfsProject.getItemTypesJSON();
        if (PropertyValidator.isValid((Object)itemTypeStr)) {
            try {
                JSONObject typesObjectJSON = new JSONObject(itemTypeStr);
                JSONArray typesArrayJSON = typesObjectJSON.getJSONArray("value");
                for (int j = 0; j < typesArrayJSON.length(); ++j) {
                    JSONObject typeJSON = typesArrayJSON.getJSONObject(j);
                    JSONArray statesArrayJSON = null;
                    if (!typeJSON.isNull("states")) {
                        statesArrayJSON = typeJSON.getJSONArray("states");
                    } else {
                        AlmAccount almAccount = this.almAccountRepository.findById(almId);
                        String responseStatesStr = this.tfsUtils.getItemTypeStates(tfsProject.getTfsId(), typeJSON.getString("name"), almAccount);
                        JSONObject statesJSON = new JSONObject(responseStatesStr);
                        statesArrayJSON = statesJSON.getJSONArray("value");
                    }
                    JSONArray actualStatesArrayJSON = null;
                    HashMap<String, String> actualStatesMap = null;
                    if (!typeJSON.isNull("states") && PropertyValidator.isValid((Object)(actualStatesArrayJSON = typeJSON.getJSONArray("states")))) {
                        actualStatesMap = new HashMap<String, String>();
                        for (int k = 0; k < actualStatesArrayJSON.length(); ++k) {
                            JSONObject stateJSON = actualStatesArrayJSON.getJSONObject(k);
                            actualStatesMap.put(stateJSON.getString("name"), stateJSON.getString("name"));
                        }
                    }
                    JSONObject trasitionsJSON = typeJSON.getJSONObject("transitions");
                    DBObject trasitionsDBObject = (DBObject)JSON.parse((String)trasitionsJSON.toString());
                    WorkFlowItemType itemType = new WorkFlowItemType(typeJSON.getString("name"), typeJSON.getString("referenceName"));
                    itemType.setTfsProject(tfsProject.getName());
                    itemType.setTfsProjectId(tfsProject.getTfsId());
                    itemType.setAlmId(almId);
                    itemType.setIsDisabled(Boolean.valueOf(typeJSON.getBoolean("isDisabled")));
                    itemType.setTransitions(trasitionsDBObject);
                    try {
                        itemType = (WorkFlowItemType)this.workFlowItemTypeRepository.save((Object)itemType);
                        itemTypes.add(itemType);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    for (int k = 0; k < statesArrayJSON.length(); ++k) {
                        JSONObject stateJSON = statesArrayJSON.getJSONObject(k);
                        if (actualStatesMap != null && !actualStatesMap.containsKey(stateJSON.getString("name"))) continue;
                        Status status = new Status();
                        status.setTfsProject(tfsProject.getName());
                        status.setTfsProjectId(tfsProject.getTfsId());
                        status.setAlmId(almId);
                        status.setWorkFlowItemType(itemType);
                        status.setItemType(itemType.getTitle());
                        status.setTitle(stateJSON.getString("name"));
                        status.setColor(stateJSON.getString("color"));
                        status.setCategory(this.tfsToKendisStatusCategory(stateJSON.getString("category")));
                        statuses.add(status);
                        WorkFlow wf = new WorkFlow();
                        wf.setId(workFlow.getId());
                        status.setWorkFlow(wf);
                    }
                }
            }
            catch (JSONException e) {
                return null;
            }
            this.statusRepository.save(statuses);
            workFlow.setStatuses(statuses);
        }
        return workFlow;
    }

    public WorkFlow updateWorkflowForProject(TFSProject tfsProject, String almId) throws Exception {
        AlmAccount almAccount = this.almAccountRepository.findById(almId);
        WorkFlow workFlow = this.workFlowRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
        List olderStatuses = this.statusRepository.findStatusByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
        List olderWorkFlowItemTypes = this.workFlowItemTypeRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
        HashMap olderWorkflowItemTypeMapById = new HashMap();
        if (PropertyValidator.isValid((Collection)olderWorkFlowItemTypes)) {
            olderWorkFlowItemTypes.forEach(itemType -> olderWorkflowItemTypeMapById.put(itemType.getId(), itemType.getTfsReferenceName()));
        }
        HashMap olderStatusMapByItemTypeAndName = new HashMap();
        if (PropertyValidator.isValid((Collection)olderStatuses)) {
            olderStatuses.forEach(status -> {
                WorkFlowItemType type = status.getWorkFlowItemType();
                String itemTypeId = type.getId();
                if (status.getTitle() != null && olderWorkflowItemTypeMapById.containsKey(itemTypeId)) {
                    olderStatusMapByItemTypeAndName.put((String)olderWorkflowItemTypeMapById.get(itemTypeId) + ":" + status.getTitle(), status);
                }
            });
        }
        ArrayList<Status> statuses = new ArrayList<Status>();
        ArrayList<WorkFlowItemType> itemTypes = new ArrayList<WorkFlowItemType>();
        String itemTypeStr = tfsProject.getItemTypesJSON();
        if (PropertyValidator.isValid((Object)itemTypeStr)) {
            try {
                JSONObject typesObjectJSON = new JSONObject(itemTypeStr);
                JSONArray typesArrayJSON = typesObjectJSON.getJSONArray("value");
                List tfsPreferences = this.tfsPreferencesRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almAccount.getId());
                HashMap tfsPreferencesMap = new HashMap();
                if (PropertyValidator.isValid((Collection)tfsPreferences)) {
                    tfsPreferences.forEach(preference -> tfsPreferencesMap.put(preference.getKey(), preference.getValue()));
                    LOGGER.debug(tfsPreferencesMap.keySet().toString());
                }
                for (int j = 0; j < typesArrayJSON.length(); ++j) {
                    JSONObject typeJSON = typesArrayJSON.getJSONObject(j);
                    JSONArray actualStatesArrayJSON = null;
                    HashMap<String, String> actualStatesMap = null;
                    if (!typeJSON.isNull("states") && PropertyValidator.isValid((Object)(actualStatesArrayJSON = typeJSON.getJSONArray("states")))) {
                        actualStatesMap = new HashMap<String, String>();
                        for (int k = 0; k < actualStatesArrayJSON.length(); ++k) {
                            JSONObject stateJSON = actualStatesArrayJSON.getJSONObject(k);
                            actualStatesMap.put(stateJSON.getString("name"), stateJSON.getString("name"));
                        }
                    }
                    JSONArray statesArrayJSON = null;
                    String responseStatesStr = this.tfsUtils.getItemTypeStates(tfsProject.getTfsId(), typeJSON.getString("name"), almAccount);
                    JSONObject statesJSON = new JSONObject(responseStatesStr);
                    statesArrayJSON = statesJSON.getJSONArray("value");
                    JSONObject trasitionsJSON = typeJSON.getJSONObject("transitions");
                    DBObject trasitionsDBObject = (DBObject)JSON.parse((String)trasitionsJSON.toString());
                    WorkFlowItemType itemType2 = new WorkFlowItemType(typeJSON.getString("name"), typeJSON.getString("referenceName"));
                    itemType2.setTfsProject(tfsProject.getName());
                    itemType2.setTfsProjectId(tfsProject.getTfsId());
                    itemType2.setAlmId(almId);
                    itemType2.setIsDisabled(Boolean.valueOf(typeJSON.getBoolean("isDisabled")));
                    itemType2.setTransitions(trasitionsDBObject);
                    try {
                        itemType2 = (WorkFlowItemType)this.workFlowItemTypeRepository.save((Object)itemType2);
                        itemTypes.add(itemType2);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    for (int k = 0; k < statesArrayJSON.length(); ++k) {
                        JSONObject stateJSON = statesArrayJSON.getJSONObject(k);
                        if (actualStatesMap != null && !actualStatesMap.containsKey(stateJSON.getString("name"))) continue;
                        String statusId = stateJSON.getString("name");
                        Status status2 = null;
                        String mapKey = itemType2.getTfsReferenceName() + ":" + statusId;
                        if (olderStatusMapByItemTypeAndName.containsKey(mapKey)) {
                            status2 = (Status)olderStatusMapByItemTypeAndName.get(mapKey);
                            olderStatusMapByItemTypeAndName.remove(mapKey);
                        } else {
                            status2 = new Status();
                        }
                        status2.setWorkFlowItemType(itemType2);
                        status2.setTfsProject(tfsProject.getName());
                        status2.setTfsProjectId(tfsProject.getTfsId());
                        status2.setAlmId(almId);
                        status2.setItemType(itemType2.getTitle());
                        status2.setTitle(stateJSON.getString("name"));
                        status2.setColor(stateJSON.getString("color"));
                        String key = itemType2.getTitle() + "_" + status2.getTitle();
                        if (tfsPreferencesMap.containsKey(key)) {
                            status2.setCategory((String)tfsPreferencesMap.get(key));
                            LOGGER.debug(key + " :: " + (String)tfsPreferencesMap.get(key));
                        } else {
                            status2.setCategory(this.tfsToKendisStatusCategory(stateJSON.getString("category")));
                        }
                        statuses.add(status2);
                        WorkFlow wf = new WorkFlow();
                        wf.setId(workFlow.getId());
                        status2.setWorkFlow(wf);
                    }
                }
            }
            catch (JSONException e) {
                return null;
            }
            if (!statuses.isEmpty()) {
                List savedStatuses = this.statusRepository.save(statuses);
                workFlow.setStatuses(savedStatuses);
            }
            ArrayList<Status> deletedStatus = new ArrayList<Status>();
            for (String key : olderStatusMapByItemTypeAndName.keySet()) {
                Status status3 = (Status)olderStatusMapByItemTypeAndName.get(key);
                status3.setIsDeletedFromAlm(Boolean.valueOf(true));
                deletedStatus.add(status3);
            }
            this.statusRepository.delete(deletedStatus);
            this.workFlowItemTypeRepository.delete((Iterable)olderWorkFlowItemTypes);
        }
        return workFlow;
    }

    private String tfsToKendisStatusCategory(String tfs) {
        if (tfs.equals("Proposed")) {
            return "ToDo";
        }
        if (tfs.equals("In Progress") || tfs.equals("InProgress")) {
            return "InProgress";
        }
        if (tfs.equals("Resolved")) {
            return "Done";
        }
        if (tfs.equals("Completed")) {
            return "Done";
        }
        return "Misc";
    }
}

