/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.alm.tfs.TFSBacklogMappingLinks;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSMeta;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmHierarchyLevelMapping;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.BoardFilter;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.FieldMapping;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.HierarchyLevel;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLinkType;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.JiraAlmAccountMeta;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionAlmSettings;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.TFSItemLinkType;
import com.viztrend.safe.persistence.entity.TFSPreferences;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.BacklogHierarchyRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BoardFilterRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.EpicFeaturesRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.HierarchyLevelRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.JiraAlmAccountMetaRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSMetaRepository;
import com.viztrend.safe.persistence.repository.TFSPreferencesRepository;
import com.viztrend.safe.persistence.repository.TFSProcessRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.NotificaitonServiceImpl;
import com.viztrend.safe.service.RTItemTfsSyncService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.TFSserviceImpl;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="TFSService")
public class TFSserviceImpl
implements TFSservice {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private TFSMetaRepository tfsMetaRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private TFSPreferencesRepository tfsPreferencesRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ALMSyncServiceImpl.class);
    @Autowired
    private Environment environment;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private JiraAlmAccountMetaRepository jiraAlmAccountMetaRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private EpicFeaturesRepository epicFeaturesRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private NotificaitonServiceImpl notificationServiceImpl;
    @Autowired
    private BoardFilterRepository boardFilterRepository;
    @Autowired
    private TFSProcessRepository tfsProcessRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private RTItemTfsSyncService itemTfsSyncService;
    @Autowired
    private HierarchyLevelRepository hierarchyLevelRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private BacklogHierarchyRepository backlogHierarchyRepository;
    @Autowired
    private ScoreCardService scoreCardService;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private CompanyRepository companyRepository;

    public void fetchTFSMeta(AlmAccount almAccount) {
        Object tfsLinkTypesStr = this.tfsUtils.getRelationShipTypes(almAccount);
        TFSMeta tfsMeta = this.tfsMetaRepository.findByAlmAccount(almAccount);
        if (!PropertyValidator.isValid((Object)tfsMeta)) {
            tfsMeta = new TFSMeta();
            tfsMeta.setAlmAccount(almAccount);
        }
        if (tfsLinkTypesStr instanceof String) {
            tfsMeta.setLinkTypes((String)tfsLinkTypesStr);
        } else {
            ViztrendJiraException viztrendJiraException = (ViztrendJiraException)((Object)tfsLinkTypesStr);
        }
        this.tfsMetaRepository.save((Object)tfsMeta);
    }

    public String fetchTFSProjects(AlmAccount almAccount) {
        String tfsProjectStr = this.tfsUtils.getTFSProjectsByPage(almAccount);
        return tfsProjectStr;
    }

    public HashMap<String, Object> retrieveJiraIssueLinkTypesList(AlmAccount almAccount, boolean eagerFetch) {
        Object linkTypes = null;
        String linkTypesStr = null;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!eagerFetch) {
            DBObject vo;
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)almAccount.getId()));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("jiraAlmAccountMeta").find(query.getQueryObject());
            if (dbCursorPrefix.hasNext() && PropertyValidator.isValid((Object)(vo = dbCursorPrefix.next()))) {
                linkTypesStr = (String)vo.get("issueLinkTypes");
                ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByAlmAccountId(almAccount.getId());
                if (!PropertyValidator.isValid((Object)itemLinkType)) {
                    this.saveTFSLinkType(linkTypesStr, almAccount.getId());
                }
            }
        }
        if (!PropertyValidator.isValid(linkTypesStr) || eagerFetch) {
            Object tfsLinkTypesStr = this.tfsUtils.getRelationShipTypes(almAccount);
            if (tfsLinkTypesStr instanceof String) {
                linkTypesStr = (String)tfsLinkTypesStr;
                JiraAlmAccountMeta accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(almAccount.getId());
                if (!PropertyValidator.isValid((Object)accountMeta)) {
                    accountMeta = new JiraAlmAccountMeta(almAccount.getId());
                }
                accountMeta.setIssueLinkTypes(linkTypesStr);
                accountMeta = (JiraAlmAccountMeta)this.jiraAlmAccountMetaRepository.save((Object)accountMeta);
                ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByAlmAccountId(almAccount.getId());
                if (PropertyValidator.isValid((Object)itemLinkType)) {
                    this.itemLinkTypeRepository.deleteByAlmAccountId(almAccount.getId());
                    this.saveTFSLinkType(linkTypesStr, almAccount.getId());
                }
            } else {
                ViztrendJiraException exception = (ViztrendJiraException)((Object)tfsLinkTypesStr);
                if (!PropertyValidator.isValid((Object)exception.getCode()) || !exception.getCode().equals(200)) {
                    responseJson.put("tfsALMErrorCode", exception.getCode());
                    responseJson.put("tfsALMErrorMessage", exception.getAlmError());
                }
            }
        }
        if (PropertyValidator.isValid(linkTypesStr)) {
            responseJson.put("linkTypes", linkTypesStr);
        }
        return responseJson;
    }

    private List<TFSProject> linkTFSProjects(String tfsProjectIds, AlmAccount almAccount, TFSProject tfsProject) throws ViztrendJiraException {
        String[] tfsProjectIdsArray = tfsProjectIds.split(",");
        ArrayList<TFSProject> tfsProjects = new ArrayList<TFSProject>();
        if (PropertyValidator.isValid((Object)tfsProject) && PropertyValidator.isValid((Object)tfsProject.getId())) {
            if (PropertyValidator.isValid((Object)tfsProject.getFetchedBy())) {
                AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)tfsProject.getFetchedBy(), (AlmAccount)almAccount);
                if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                    almAccount = taggedAlmAccount;
                }
            } else {
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
            }
        }
        for (String projectId : tfsProjectIdsArray) {
            String tfsProjectStr = null;
            tfsProjectStr = this.tfsUtils.getTFSProject(projectId, almAccount);
            try {
                JSONObject projectObject = new JSONObject(tfsProjectStr);
                String id = ObjectId.get().toString();
                String tfsId = projectObject.getString("id");
                String name = projectObject.getString("name");
                String url = projectObject.getString("url");
                String state = projectObject.getString("state");
                TFSProject tfsProjectTemp = new TFSProject(id, tfsId, name, url, state);
                if (PropertyValidator.isValid(tfsProjects)) {
                    tfsProjectTemp.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                }
                try {
                    JSONObject capabilitiesObject = projectObject.getJSONObject("capabilities");
                    JSONObject processTemplateObject = capabilitiesObject.getJSONObject("processTemplate");
                    String templateName = processTemplateObject.getString("templateName");
                    String templateTypeId = processTemplateObject.getString("templateTypeId");
                    tfsProjectTemp.setTfsProcessId(templateTypeId);
                    tfsProjectTemp.setTfsProcessName(templateName);
                }
                catch (Exception capabilitiesObject) {
                    // empty catch block
                }
                if (PropertyValidator.isValid((Object)tfsProject) && PropertyValidator.isValid((Object)tfsProject.getId())) {
                    tfsProjectTemp.setId(tfsProject.getId());
                    tfsProjectTemp.setItemEstimationField(tfsProject.getItemEstimationField());
                    tfsProjectTemp.setSubItemEstimationField(tfsProject.getSubItemEstimationField());
                    tfsProjectTemp.setItemDueDateField(tfsProject.getItemDueDateField());
                    tfsProjectTemp.setSubItemDueDateField(tfsProject.getSubItemDueDateField());
                    tfsProjectTemp.setItemStartDateField(tfsProject.getItemStartDateField());
                    tfsProjectTemp.setItemEndDateField(tfsProject.getItemEndDateField());
                    tfsProjectTemp.setSubItemStartDateField(tfsProject.getSubItemStartDateField());
                    tfsProjectTemp.setSubItemEndDateField(tfsProject.getSubItemEndDateField());
                    tfsProjectTemp.setSelectedFields(tfsProject.getSelectedFields());
                }
                String tfsItemTypesStr = this.tfsUtils.getProjectItemTypes(tfsProjectTemp.getTfsId(), almAccount);
                String tfsTeamsStr = this.tfsUtils.getProjectTeamsByPage(tfsProjectTemp.getTfsId(), almAccount);
                String tfsAllFieldsStr = this.tfsUtils.getProjectAllFields(tfsProjectTemp.getTfsId(), almAccount);
                JSONObject allFieldsObject = new JSONObject(tfsAllFieldsStr);
                JSONArray fieldsArray = allFieldsObject.getJSONArray("value");
                HashMap<String, JSONObject> allFieldsMap = new HashMap<String, JSONObject>();
                for (int i = 0; i < fieldsArray.length(); ++i) {
                    try {
                        JSONObject fieldObject = fieldsArray.getJSONObject(i);
                        String fieldRefName = fieldObject.getString("referenceName");
                        allFieldsMap.put(fieldRefName, fieldObject);
                        continue;
                    }
                    catch (Exception fieldObject) {
                        // empty catch block
                    }
                }
                JSONObject itemTypesObject = new JSONObject(tfsItemTypesStr);
                JSONArray itemTypesArray = itemTypesObject.getJSONArray("value");
                JSONObject itemTypesWithFields = new JSONObject();
                tfsProjectTemp.setIconByItemType(new HashMap());
                for (int i = 0; i < itemTypesArray.length(); ++i) {
                    try {
                        JSONObject itemTypeObject = itemTypesArray.getJSONObject(i);
                        String itemTypeName = itemTypeObject.getString("name");
                        JSONObject icon = itemTypeObject.getJSONObject("icon");
                        String iconURL = icon.getString("url");
                        tfsProjectTemp.getIconByItemType().put(itemTypeName, iconURL);
                        String itemTypeFields = this.tfsUtils.getProjectItemTypeFields(tfsProjectTemp.getTfsId(), itemTypeName, almAccount);
                        itemTypesWithFields = new JSONObject(itemTypeFields);
                        JSONArray itemTypeWithFieldsArray = itemTypesWithFields.getJSONArray("value");
                        for (int j = 0; j < itemTypeWithFieldsArray.length(); ++j) {
                            JSONObject fieldObject = itemTypeWithFieldsArray.getJSONObject(j);
                            if (fieldObject.isNull("referenceName") || !allFieldsMap.containsKey(fieldObject.get("referenceName"))) continue;
                            JSONObject fieldMapObj = (JSONObject)allFieldsMap.get(fieldObject.get("referenceName"));
                            fieldObject.put("type", fieldMapObj.get("type"));
                            fieldObject.put("readOnly", fieldMapObj.get("readOnly"));
                        }
                        itemTypeObject.put("fieldsWithAllowedValues", (Object)itemTypesWithFields);
                        itemTypeObject.remove("fields");
                        itemTypeObject.remove("fieldInstances");
                        itemTypeObject.remove("xmlForm");
                        continue;
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        String sStackTrace = sw.toString();
                        LOGGER.error(" :: JSON Exception ..  " + sStackTrace);
                    }
                }
                String classificationNodes = this.tfsUtils.getProjectAreaNodes(tfsProjectTemp.getTfsId(), null, almAccount);
                tfsProjectTemp.setClassificationNodes(classificationNodes);
                tfsProjectTemp.setItemTypesStr(tfsItemTypesStr);
                tfsProjectTemp.setItemTypesJSON(itemTypesObject.toString());
                tfsProjectTemp.setFieldsStr(tfsAllFieldsStr);
                tfsProjectTemp.setTeamsStr(tfsTeamsStr);
                tfsProjects.add(tfsProjectTemp);
                this.createWebhookInTFS(almAccount, projectId);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                throw e1;
            }
        }
        return tfsProjects;
    }

    public List<TFSProject> linkTFSProjectsWithSolution(String tfsProjectIds, String solutionId, AlmAccount almAccount, TFSProject tfsProject) {
        List tfsProjects = this.linkTFSProjects(tfsProjectIds, almAccount, tfsProject);
        SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(solutionId);
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            tfsProjects.forEach(project -> {
                project.setSolutionId(solutionId);
                if (PropertyValidator.isValid((Collection)project.getSolutionIds())) {
                    if (!project.getSolutionIds().contains(solutionId)) {
                        project.getSolutionIds().add(solutionId);
                    }
                } else {
                    if (!PropertyValidator.isValid((Collection)project.getSolutionIds())) {
                        project.setSolutionIds(new ArrayList());
                    }
                    project.getSolutionIds().add(solutionId);
                }
                project.setAlmAccount(almAccount);
                if (PropertyValidator.isValid((Object)solutionBoard) && PropertyValidator.isValid((Collection)solutionBoard.getSolutionBoardWsjFAlmConfiguration())) {
                    solutionBoard.getSolutionBoardWsjFAlmConfiguration().forEach(config -> {
                        if (config.getAlmId().equals(almAccount.getId())) {
                            if (config.isApplyToAll()) {
                                project.setWsjfAlmField(config.getAlmField());
                            }
                            if (config.isApplyToAllForUnplannedFeatures()) {
                                project.setWsjfAlmFieldForUnplannedFeatures(config.getAlmFieldForUnplannedFeatures());
                            }
                        }
                    });
                }
            });
        }
        return this.tfsProjectRepository.save((Iterable)tfsProjects);
    }

    public List<TFSProject> linkTFSProjectsWithSession(String tfsProjectIds, String sessionId, TFSProject tfsProject) throws ViztrendJiraException {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        AlmAccount almAccount = session.getTfsAlmConfigurations().getAlmAccount();
        List tfsProjects = this.linkTFSProjects(tfsProjectIds, almAccount, tfsProject);
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            tfsProjects.forEach(project -> project.setSessionId(sessionId));
        }
        return this.tfsProjectRepository.save((Iterable)tfsProjects);
    }

    private HashMap<String, Status> getStatusesMap(List<Status> statuses) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        for (Status status : statuses) {
            String key = status.getTfsProjectId() + status.getItemType() + status.getTitle();
            statusMap.put(key, status);
        }
        return statusMap;
    }

    public void linkDependencyWorkflow(SessionBoard sessionBoard) {
        List workFlowList = this.workFlowRepository.findAllByWorkflowType("Dependency");
        if (PropertyValidator.isValid((Collection)workFlowList)) {
            sessionBoard.getSession().setDependencyWorkFlow((WorkFlow)workFlowList.get(0));
        } else {
            sessionBoard.getSession().setDependencyWorkFlow(this.createDefaultDependencyWorkflow());
        }
        this.sessionRepository.save((Object)sessionBoard.getSession());
    }

    public WorkFlow createDefaultDependencyWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Dependency Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType("Dependency");
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 4; ++j) {
            Status status;
            int i;
            if (j == 0) {
                for (i = 0; i < 3; ++i) {
                    status = new Status();
                    status.setCategory("ToDo");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("Waiting for Acceptance");
                    } else if (i == 1) {
                        status.setTitle("Accepted");
                    } else {
                        status.setTitle("Not Started");
                    }
                    statusList.add(status);
                }
                continue;
            }
            if (j == 1) {
                Status status2 = new Status();
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setCategory("InProgress");
                status2.setTitle("In Progress");
                statusList.add(status2);
                continue;
            }
            if (j == 2) {
                for (i = 0; i < 2; ++i) {
                    status = new Status();
                    status.setCategory("Done");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("Done");
                    } else if (i == 1) {
                        status.setTitle("Done with Acceptance");
                    }
                    statusList.add(status);
                }
                continue;
            }
            for (i = 0; i < 3; ++i) {
                status = new Status();
                status.setCategory("Misc");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                if (i == 0) {
                    status.setTitle("Blocked");
                } else if (i == 1) {
                    status.setTitle("Ignored ");
                } else {
                    status.setTitle("Integrated");
                }
                statusList.add(status);
            }
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    public void fetchTFSSubItems(List<String> tfsIds, String sessionBoardId, List<String> relationTypes, String parentId, TeamContainer teamContainer, IssueType issueType, String metaMap, AlmAccount almAccount, String tfsSprintPath, String tfsAreaPath) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        List statuses = this.statusRepository.findBySessionId(board.getSession().getId());
        HashMap statusMap = this.getStatusesMap(statuses);
        List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(board.getSession().getId());
        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (TFSProject tfsProject : tfsProjects) {
                tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
            }
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(new SessionBoard(sessionBoardId));
        Item parentItem = this.itemRepository.findById(parentId);
        if (PropertyValidator.isValid(relationTypes) && PropertyValidator.isValid((Object)parentItem) && PropertyValidator.isValid((Collection)parentItem.getTfsLinkTypes())) {
            String tfsLinkType = relationTypes.get(0);
            if (PropertyValidator.isValid((Object)tfsLinkType) && tfsLinkType.endsWith("-Forward")) {
                tfsLinkType = tfsLinkType.replace("-Forward", "-Reverse");
            } else if (PropertyValidator.isValid((Object)tfsLinkType) && tfsLinkType.endsWith("-Reverse")) {
                tfsLinkType = tfsLinkType.replace("-Reverse", "-Forward");
            }
            if (parentItem.getTfsLinkTypes().indexOf(tfsLinkType) == -1) {
                parentItem.getTfsLinkTypes().add(tfsLinkType);
                this.itemRepository.save((Object)parentItem);
            }
        }
        ArrayList<Item> childItems = new ArrayList<Item>();
        String childIds = String.join((CharSequence)",", tfsIds);
        String childItemsStr = this.tfsUtils.getItems("1", childIds, almAccount);
        List syncMappers = null;
        if (teamContainer == null) {
            syncMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardId));
        }
        HashMap<String, TFSTeamMapping> tfsTeamMapping = new HashMap<String, TFSTeamMapping>();
        if (PropertyValidator.isValid((Object)board.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)board.getSession().getTfsAlmConfigurations().getTeamMappings())) {
            for (TFSTeamMapping mappedTeam : board.getSession().getTfsAlmConfigurations().getTeamMappings()) {
                tfsTeamMapping.put(mappedTeam.getKendisTeamId(), mappedTeam);
            }
        }
        try {
            JSONObject dataObjects = new JSONObject(childItemsStr);
            dataObjects = new JSONObject(childItemsStr);
            JSONArray itemsArray = dataObjects.getJSONArray("value");
            Double sysSequence = new Double(System.nanoTime() / 100000L);
            HashMap<String, Object> extraFields = new HashMap<String, Object>();
            extraFields.put("sequence", sysSequence);
            extraFields.put("statusMap", statusMap);
            extraFields.put("type", Item.USER_STORY);
            for (int i = 0; i < itemsArray.length(); ++i) {
                try {
                    JSONObject itemObject = itemsArray.getJSONObject(i);
                    JSONObject tfsFields = itemObject.getJSONObject("fields");
                    String iterationPath = (String)tfsFields.get("System.IterationPath");
                    String areaPath = (String)tfsFields.get("System.AreaPath");
                    Map itemMap = this.getKendisItemFromTFSItem(board.getSession(), null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                    Item item = (Item)itemMap.get("item");
                    item.setType(Item.USER_STORY);
                    item.setParent(parentItem);
                    item.setSessionBoards(sessionBoards);
                    item.setTeamContainers(new ArrayList());
                    if (teamContainer != null) {
                        item.getTeamContainers().add(teamContainer);
                    }
                    item.setCreatedOn(new Date());
                    item.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                    item.applySprintDates(board.getSession(), null, null);
                    if (tfsSprintPath != null) {
                        iterationPath = tfsSprintPath;
                        item.setTfsIterationPath(iterationPath);
                    }
                    if (!PropertyValidator.isValid((Object)teamContainer) && PropertyValidator.isValid((Collection)syncMappers) && PropertyValidator.isValid((Object)iterationPath)) {
                        ArrayList<ItemSyncMapper> matchedSyncMappers = new ArrayList<ItemSyncMapper>();
                        for (ItemSyncMapper syncMapper : syncMappers) {
                            if (!(PropertyValidator.isValid((Object)syncMapper) && PropertyValidator.isValid((Object)syncMapper.getTfsSprint()) && tfsTeamMapping.containsKey(syncMapper.getTeam().getId()) && board.getSession().getAreaPathDisabled().booleanValue())) {
                                // empty if block
                            }
                            if (!PropertyValidator.isValid((Object)syncMapper) || !PropertyValidator.isValid((Object)syncMapper.getTfsSprint()) || !iterationPath.equals(syncMapper.getTfsSprint().getIterationPath()) || !tfsTeamMapping.containsKey(syncMapper.getTeam().getId())) continue;
                            if (!board.getSession().getAreaPathDisabled().booleanValue()) {
                                TFSTeamMapping _tfsTeamMapping = (TFSTeamMapping)tfsTeamMapping.get(syncMapper.getTeam().getId());
                                if (!PropertyValidator.isValid((Object)areaPath)) continue;
                                if (_tfsTeamMapping.getIncludeSubAreaPaths().booleanValue()) {
                                    boolean check1 = areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) || areaPath.startsWith(_tfsTeamMapping.getTfsAreaPath() + "\\");
                                    boolean check2 = true;
                                    if (PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam())) {
                                        check2 = false;
                                        for (String aPath : _tfsTeamMapping.getTfsAreaPathsForTeam()) {
                                            if (!areaPath.equals(aPath) && !areaPath.startsWith(aPath + "\\")) continue;
                                            check2 = true;
                                            break;
                                        }
                                    }
                                    if (!check1 && !check2) continue;
                                    matchedSyncMappers.add(syncMapper);
                                    continue;
                                }
                                if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                                matchedSyncMappers.add(syncMapper);
                                continue;
                            }
                            matchedSyncMappers.add(syncMapper);
                        }
                        boolean parentItemMappingFound = false;
                        boolean newSubItemMappingFound = false;
                        if (PropertyValidator.isValid(matchedSyncMappers)) {
                            newSubItemMappingFound = true;
                            if (matchedSyncMappers.size() > 1) {
                                for (ItemSyncMapper syncMapper : matchedSyncMappers) {
                                    TFSTeamMapping _tfsTeamMapping = (TFSTeamMapping)tfsTeamMapping.get(syncMapper.getTeam().getId());
                                    if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                                    matchedSyncMappers.clear();
                                    matchedSyncMappers.add(syncMapper);
                                    break;
                                }
                            }
                            for (ItemSyncMapper itemSyncMapper : matchedSyncMappers) {
                                TeamContainer newTeamContainer = null;
                                if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                                    for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                                        if (!parentTeamContainer.getTeam().equals((Object)itemSyncMapper.getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.getContainer())) continue;
                                        item.setTeamContainers(new ArrayList());
                                        item.getTeamContainers().add(parentTeamContainer);
                                        newTeamContainer = parentTeamContainer;
                                        parentItemMappingFound = true;
                                        item.applySprintDates(board.getSession(), null, null);
                                        break;
                                    }
                                }
                                if (!parentItemMappingFound) {
                                    TeamContainer _teamContainer;
                                    newTeamContainer = _teamContainer = new TeamContainer();
                                    _teamContainer.setTeam(itemSyncMapper.getTeam());
                                    _teamContainer.setContainer(itemSyncMapper.getContainer());
                                    _teamContainer.setSequence(Double.valueOf((Double)extraFields.get("sequence") + 1000.0));
                                    _teamContainer.setSuspendActivity(true);
                                    _teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)_teamContainer);
                                    item.setTeamContainers(new ArrayList());
                                    item.getTeamContainers().add(_teamContainer);
                                    item.applySprintDates(board.getSession(), null, null);
                                    if (parentItem.getTeamContainers() == null) {
                                        parentItem.setTeamContainers(new ArrayList());
                                    }
                                    parentItem.getTeamContainers().add(_teamContainer);
                                    this.itemRepository.save((Object)parentItem);
                                    continue;
                                }
                                item.setTeamContainers(new ArrayList());
                                item.getTeamContainers().add(newTeamContainer);
                            }
                        }
                    }
                    childItems.add(item);
                    KendisUtils.addChanges((boolean)false, (boolean)true, (Item)item, null);
                    continue;
                }
                catch (JSONException e1) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e1.printStackTrace(pw);
                    String sStackTrace = sw.toString();
                    LOGGER.error(" :: JSON Exception ..  " + sStackTrace);
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.error(" :: Exception while conversiion ..  " + sStackTrace);
        }
        if (PropertyValidator.isValid(childItems)) {
            this.itemRepository.save(childItems);
            this.customRepositoryImpl.bulkLogs(sessionBoardId, childItems, null, null, almAccount.getTenant());
            new Thread(() -> childItems.forEach(item -> {
                Item dbItem = this.itemRepository.findById(item.getId());
                if (PropertyValidator.isValid((Object)dbItem) && PropertyValidator.isValid((Object)dbItem.getParent())) {
                    this.customRepositoryImpl.addAuditLogEntryInActiveSprintForSingleItem(dbItem);
                }
            })).start();
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        if (metaMap != null) {
            JSONObject pushJson = new JSONObject();
            try {
                ObjectMapper mapper = new ObjectMapper();
                String childStr = mapper.writeValueAsString(childItems);
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap.toString());
                pushJson.put("childItems", (Object)childStr);
                pushJson.put("parentId", (Object)parentItem.getId());
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JsonProcessingException | JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
    }

    public HashMap<String, Object> fetchTFSEpicItemsScore(List<String> tfsIds, SolutionBoard solutionBoard, TFSFilter filter, AlmAccount _almAccount, String requestId, Boolean isResync) {
        List existingEpics;
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)_almAccount.getId()));
        ArrayList validEpicIds = new ArrayList();
        HashMap<String, Item> existingEpicsById = new HashMap<String, Item>();
        HashMap<String, Item> existingEpicsByTFSId = new HashMap<String, Item>();
        ArrayList<Item> epics = new ArrayList<Item>();
        ArrayList<Item> features = new ArrayList<Item>();
        HashMap allEpicMapByTfsId = new HashMap();
        HashMap existingSessionFeaturesByKey = new HashMap();
        HashMap<String, String> newFeaturesEpicMap = new HashMap<String, String>();
        ArrayList<Item> allEpics = new ArrayList<Item>();
        HashMap<String, Item> existingSolutionFeaturesByKey = new HashMap<String, Item>();
        List existingSolutionFeatures = new ArrayList();
        ArrayList allNewFeatures = new ArrayList();
        ArrayList existingSolutionFeaturesToUpdate = new ArrayList();
        HashMap<String, Item> existingSolutionFeaturesById = new HashMap<String, Item>();
        HashMap existingSolutionFeaturesDeletionMap = new HashMap();
        if (PropertyValidator.isValid((Object)filter) && isResync.booleanValue()) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            Iterator tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is(tenant));
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoard.$id").is((Object)new ObjectId(solutionBoard.getId())));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.Type.Epic.toString()));
            Criteria criteria0 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tfsFilter").is((Object)filter.getTfsId()), Criteria.where((String)"tfsId").in(tfsIds)});
            query.addCriteria((CriteriaDefinition)criteria0);
            existingEpics = this.mongoTemplate.find(query, Item.class);
        } else {
            existingEpics = this.itemRepository.findBySolutionBoardAndTfsIdInAndType(solutionBoard, tfsIds, Item.Type.Epic.toString());
        }
        ArrayList<String> existingEpicKeys = new ArrayList<String>();
        for (Item epic : existingEpics) {
            existingEpicsById.put(epic.getId(), epic);
            existingEpicsByTFSId.put(epic.getTfsId(), epic);
            existingEpicKeys.add(epic.getTfsId());
        }
        existingSolutionFeatures = this.itemRepository.findBySolutionBoardAndTfsIdNotNullAndType(solutionBoard.getId(), Item.Type.Feature.toString());
        for (Item feature : existingSolutionFeatures) {
            existingSolutionFeaturesById.put(feature.getId(), feature);
            existingSolutionFeaturesByKey.put(feature.getTfsId(), feature);
        }
        List allTFSProjects = this.tfsProjectRepository.findBySolutionId(solutionBoard.getId());
        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)allTFSProjects)) {
            for (TFSProject tfsProject : allTFSProjects) {
                if (PropertyValidator.isValid(tfsProjectsMap.get(tfsProject.getTfsId()))) {
                    if (((TFSProject)tfsProjectsMap.get(tfsProject.getTfsId())).getSolutionId() != null) continue;
                    tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                    tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                    continue;
                }
                tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
            }
        }
        List subSetsEpicIdsToResync = Lists.partition(new ArrayList<String>(tfsIds), (int)100);
        for (List subSetParentIds : subSetsEpicIdsToResync) {
            String idsParentStr = String.join((CharSequence)",", subSetParentIds);
            String parentItemsStr = this.tfsUtils.getItems("1", idsParentStr, almAccount);
            try {
                JSONObject dataObjects = new JSONObject(parentItemsStr);
                JSONArray itemsArray = dataObjects.getJSONArray("value");
                HashMap<String, Object> extraFields = new HashMap<String, Object>();
                extraFields.put("type", Item.Type.Epic.toString());
                Double sysSequence = new Double(System.nanoTime() / 100000L);
                extraFields.put("sequence", sysSequence);
                extraFields.put("type", Item.Type.Epic.toString());
                HashMap epicsByEpicId = new HashMap();
                HashMap newFeatureSetByEpicKey = new HashMap();
                HashMap<String, String> epicKeyByFeatureKey = new HashMap<String, String>();
                for (int i = 0; i < itemsArray.length(); ++i) {
                    try {
                        JSONArray relationsArray;
                        JSONObject itemObject = itemsArray.getJSONObject(i);
                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                        Map itemMap = this.getKendisItemFromTFSItem(null, null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                        Item epic = null;
                        Item temp = null;
                        TFSProject tfsProject = null;
                        if (!PropertyValidator.isValid(itemMap.get("item"))) {
                            ArrayList<String> projectsNotLoaded = (ArrayList<String>)responseMap.get("projectsNotLoaded");
                            if (!PropertyValidator.isValid((Collection)projectsNotLoaded)) {
                                projectsNotLoaded = new ArrayList<String>();
                                responseMap.put("projectsNotLoaded", projectsNotLoaded);
                            }
                            projectsNotLoaded.add((String)itemMap.get("project"));
                            continue;
                        }
                        temp = (Item)itemMap.get("item");
                        epic = this.itemRepository.findByTfsId(temp.getTfsId());
                        tfsProject = (TFSProject)itemMap.get("project");
                        if (PropertyValidator.isValid((Object)tfsProject.getWsjfAlmField()) && !tfsFields.isNull(tfsProject.getWsjfAlmField())) {
                            int tempAlmScore = (Integer)tfsFields.get(tfsProject.getWsjfAlmField());
                            epic.setAlmScoreField(Double.valueOf(tempAlmScore));
                        }
                        if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                            HashSet<String> tfsFeatureKeySet = new HashSet<String>();
                            for (int j = 0; j < relationsArray.length(); ++j) {
                                JSONObject relationObject = relationsArray.getJSONObject(j);
                                String rel = relationObject.getString("rel");
                                List relationsToFetch = new ArrayList();
                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                    for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                        if (!epic.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                        relationsToFetch.addAll(backlogMappingLink.getLinkTypes());
                                        break;
                                    }
                                } else {
                                    relationsToFetch = epic.getTfsLinkTypes();
                                }
                                String relURL = relationObject.getString("url");
                                if (!PropertyValidator.isValid(relationsToFetch) || !relationsToFetch.contains(rel)) continue;
                                String workItemKey = relURL.substring(relURL.lastIndexOf("/") + 1);
                                tfsFeatureKeySet.add(workItemKey);
                                epicKeyByFeatureKey.put(workItemKey, epic.getTfsId());
                            }
                            newFeatureSetByEpicKey.put(epic.getTfsId(), tfsFeatureKeySet);
                        }
                        epics.add(epic);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.print(e);
                    }
                }
                allEpics.addAll(epics);
                for (String epicKey : newFeatureSetByEpicKey.keySet()) {
                    Set newFeatureKeys = (Set)newFeatureSetByEpicKey.get(epicKey);
                    if (!PropertyValidator.isValid((Collection)newFeatureKeys)) continue;
                    for (Object featureKey : newFeatureKeys) {
                        newFeaturesEpicMap.put((String)featureKey, epicKey);
                    }
                }
                if (!PropertyValidator.isValid(newFeaturesEpicMap)) continue;
                List subSetsFeatureIds = Lists.partition(new ArrayList(newFeaturesEpicMap.keySet()), (int)100);
                for (List subSetFeatureIds : subSetsFeatureIds) {
                    Object featureKey;
                    if (!PropertyValidator.isValid((Collection)subSetFeatureIds)) continue;
                    ArrayList<String> newFeatureIds = new ArrayList<String>();
                    featureKey = subSetFeatureIds.iterator();
                    while (featureKey.hasNext()) {
                        String id = (String)featureKey.next();
                        if (PropertyValidator.isValid((Collection)((Collection)existingSessionFeaturesByKey.get(id)))) continue;
                        newFeatureIds.add(id);
                    }
                    if (!PropertyValidator.isValid(newFeatureIds)) continue;
                    String idsFeatureStr = String.join((CharSequence)",", newFeatureIds);
                    String featureItemsStr = this.tfsUtils.getItems("1", idsFeatureStr, almAccount);
                    try {
                        dataObjects = new JSONObject(featureItemsStr);
                        itemsArray = dataObjects.getJSONArray("value");
                        sysSequence = new Double((double)System.nanoTime() / 100000.0);
                        extraFields = new HashMap();
                        extraFields.put("sequence", sysSequence);
                        extraFields.put("type", Item.FEATURE);
                        extraFields.put("boardType", "solutionBoard");
                        for (int j = 0; j < itemsArray.length(); ++j) {
                            try {
                                JSONObject itemObject1 = itemsArray.getJSONObject(j);
                                JSONObject tfsFields1 = itemObject1.getJSONObject("fields");
                                Map itemMap1 = this.getKendisItemFromTFSItem(null, null, itemObject1, tfsFields1, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                                Item feature = null;
                                Item temp = null;
                                TFSProject tfsProject1 = null;
                                if (PropertyValidator.isValid(itemMap1.get("item"))) {
                                    temp = (Item)itemMap1.get("item");
                                    feature = this.itemRepository.findByTfsId(temp.getTfsId());
                                    tfsProject1 = (TFSProject)itemMap1.get("project");
                                }
                                if (PropertyValidator.isValid(tfsProject1) && PropertyValidator.isValid((Object)tfsProject1.getWsjfAlmFieldForUnplannedFeatures()) && !tfsFields1.isNull(tfsProject1.getWsjfAlmFieldForUnplannedFeatures())) {
                                    int tempAlmScore = (Integer)tfsFields1.get(tfsProject1.getWsjfAlmFieldForUnplannedFeatures());
                                    feature.setAlmScoreField(Double.valueOf(tempAlmScore));
                                }
                                if (!PropertyValidator.isValid(feature)) continue;
                                features.add(feature);
                                continue;
                            }
                            catch (Exception ex) {
                                responseMap.put("dataStatus", "Error while processing data.");
                                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                            }
                        }
                    }
                    catch (Exception e) {
                        responseMap.put("dataStatus", "Error while processing data.");
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        if (PropertyValidator.isValid(allEpics)) {
            this.itemRepository.save(allEpics);
        }
        if (PropertyValidator.isValid(existingSolutionFeaturesToUpdate)) {
            this.itemRepository.save(existingSolutionFeaturesToUpdate);
        }
        if (PropertyValidator.isValid(allNewFeatures)) {
            this.itemRepository.save(allNewFeatures);
        }
        if (PropertyValidator.isValid(features)) {
            this.itemRepository.save(features);
        }
        responseMap.put("updatedFeatures", features);
        responseMap.put("newFeatures", allNewFeatures);
        responseMap.put("epics", allEpics);
        return responseMap;
    }

    public HashMap<String, Object> fetchTFSEpicItems(List<String> tfsIds, List<String> linkTypes, SolutionBoard solutionBoard, TFSFilter filter, AlmAccount _almAccount, String requestId, Boolean isResync) {
        Collection itemJiraDependenciesValues;
        List existingEpics;
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)_almAccount.getId()));
        SolutionAlmSettings solutionAlmSettings = null;
        if (PropertyValidator.isValid((Collection)solutionBoard.getSolutionAlmSettings())) {
            solutionAlmSettings = solutionBoard.getSolutionAlmSettings().stream().filter(sas -> sas.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null);
        }
        ArrayList<ItemJiraDependency> tfsDependenciesToBeDeleted = new ArrayList<ItemJiraDependency>();
        HashMap<String, ItemJiraDependency> jiraDependencyMapByTFSSourceTarget = new HashMap<String, ItemJiraDependency>();
        HashSet<String> tfsIdsForART = new HashSet<String>();
        HashSet<String> relationTFSIds = new HashSet<String>();
        int depCount = 1;
        List existingSessionFeatures = new ArrayList();
        HashMap existingSessionFeaturesByKey = new HashMap();
        List existingSolutionFeatures = new ArrayList();
        HashMap<String, Item> existingSolutionFeaturesByKey = new HashMap<String, Item>();
        HashMap<String, Item> existingSolutionFeaturesById = new HashMap<String, Item>();
        HashMap<String, Item> existingEpicsById = new HashMap<String, Item>();
        HashMap<String, Object> existingEpicsByTFSId = new HashMap<String, Object>();
        ArrayList<String> validEpicIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)filter) && isResync.booleanValue()) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoard.$id").is((Object)new ObjectId(solutionBoard.getId())));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.Type.Epic.toString()));
            Criteria criteria0 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"tfsFilter").is((Object)filter.getTfsId()), Criteria.where((String)"tfsId").in(tfsIds)});
            query.addCriteria((CriteriaDefinition)criteria0);
            existingEpics = this.mongoTemplate.find(query, Item.class);
        } else {
            existingEpics = this.itemRepository.findBySolutionBoardAndTfsIdInAndType(solutionBoard, tfsIds, Item.Type.Epic.toString());
        }
        HashMap<String, Boolean> existingEpicsDeletionMap = new HashMap<String, Boolean>();
        ArrayList<String> existingEpicKeys = new ArrayList<String>();
        for (Item epic : existingEpics) {
            existingEpicsById.put(epic.getId(), epic);
            existingEpicsByTFSId.put(epic.getTfsId(), epic);
            existingEpicsDeletionMap.put(epic.getId(), Boolean.TRUE);
            existingEpicKeys.add(epic.getTfsId());
        }
        ArrayList allEpics = new ArrayList();
        ArrayList<Item> allNewFeatures = new ArrayList<Item>();
        ArrayList<Item> existingSolutionFeaturesToUpdate = new ArrayList<Item>();
        List sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
        ArrayList<String> activeSessionBoardIds = new ArrayList<String>();
        ArrayList<String> sessionIds = new ArrayList<String>();
        HashMap<String, String> sessionIdBySessionBoardId = new HashMap<String, String>();
        for (Session session : sessions) {
            if (!PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) || !almAccount.getId().equals(session.getTfsAlmConfigurations().getAlmAccount().getId())) continue;
            activeSessionBoardIds.add(session.getActiveSessionBoard());
            sessionIds.add(session.getId());
            sessionIdBySessionBoardId.put(session.getActiveSessionBoard(), session.getId());
        }
        existingSessionFeatures = this.itemRepository.findBySessionBoardsIdInAndTfsIdNotNullAndType(activeSessionBoardIds, Item.Type.Feature.toString());
        for (Item feature : existingSessionFeatures) {
            if (!existingSessionFeaturesByKey.containsKey(feature.getTfsId())) {
                existingSessionFeaturesByKey.put(feature.getTfsId(), new ArrayList());
            }
            ((List)existingSessionFeaturesByKey.get(feature.getTfsId())).add(feature);
        }
        existingSolutionFeatures = this.itemRepository.findBySolutionBoardAndTfsIdNotNullAndType(solutionBoard.getId(), Item.Type.Feature.toString());
        for (Item feature : existingSolutionFeatures) {
            existingSolutionFeaturesById.put(feature.getId(), feature);
            existingSolutionFeaturesByKey.put(feature.getTfsId(), feature);
        }
        HashMap<String, Boolean> existingSolutionFeaturesDeletionMap = new HashMap<String, Boolean>();
        List allTFSProjects = this.tfsProjectRepository.findBySolutionId(solutionBoard.getId());
        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)allTFSProjects)) {
            for (TFSProject tfsProject : allTFSProjects) {
                if (PropertyValidator.isValid(tfsProjectsMap.get(tfsProject.getTfsId()))) {
                    if (((TFSProject)tfsProjectsMap.get(tfsProject.getTfsId())).getSolutionId() != null) continue;
                    tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                    tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                    continue;
                }
                tfsProjectsMap.put(tfsProject.getTfsId(), tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
            }
        }
        List statuses = this.statusRepository.findBySolutionIdOrSessionIdIn(solutionBoard.getId(), sessionIds);
        HashMap statusMap = this.getStatusesMap(statuses);
        HashMap<String, ItemJiraDependency> oldLinksMapByAlmId = new HashMap<String, ItemJiraDependency>();
        ArrayList<EpicFeature> newEpicFeatures = new ArrayList<EpicFeature>();
        HashMap<String, String> newFeaturesEpicMap = new HashMap<String, String>();
        HashMap<String, Object> allEpicMapByTfsId = new HashMap<String, Object>();
        ArrayList<String> tfsProjectsNotLoaded = new ArrayList<String>();
        List subSetsEpicIdsToResync = Lists.partition(new ArrayList<String>(tfsIds), (int)100);
        for (Iterator subSetParentIds : subSetsEpicIdsToResync) {
            String idsParentStr = String.join((CharSequence)",", (Iterable<? extends CharSequence>)((Object)subSetParentIds));
            String parentItemsStr = null;
            try {
                parentItemsStr = this.tfsUtils.getItems("1", idsParentStr, almAccount);
            }
            catch (ViztrendJiraException vje) {
                LOGGER.error("Exception while parent conversion :: " + StringUtils.getTraceString((Throwable)vje));
                responseMap.put("dataStatus", "Error while processing data.");
                throw vje;
            }
            ArrayList<Object> epics = new ArrayList<Object>();
            try {
                JSONObject dataObjects = new JSONObject(parentItemsStr);
                JSONArray itemsArray = dataObjects.getJSONArray("value");
                Object sysSequence = new Double(System.nanoTime() / 100000L);
                HashMap<String, Object> extraFields = new HashMap<String, Object>();
                extraFields.put("sequence", sysSequence);
                extraFields.put("statusMap", statusMap);
                extraFields.put("type", Item.Type.Epic.toString());
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                HashMap hashMap2 = new HashMap();
                HashMap<String, String> epicKeyByFeatureKey = new HashMap<String, String>();
                for (int i = 0; i < itemsArray.length(); ++i) {
                    try {
                        JSONArray relationsArray;
                        String dateStr;
                        JSONObject itemObject = itemsArray.getJSONObject(i);
                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                        Map itemMap = this.getKendisItemFromTFSItem(null, null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                        Object epic = null;
                        TFSProject tfsProject = null;
                        if (!PropertyValidator.isValid(itemMap.get("item"))) {
                            ArrayList<String> projectsNotLoaded = (ArrayList<String>)responseMap.get("projectsNotLoaded");
                            if (!PropertyValidator.isValid((Collection)projectsNotLoaded)) {
                                projectsNotLoaded = new ArrayList<String>();
                                responseMap.put("projectsNotLoaded", projectsNotLoaded);
                            }
                            projectsNotLoaded.add((String)itemMap.get("project"));
                            continue;
                        }
                        epic = (Item)itemMap.get("item");
                        tfsProject = (TFSProject)itemMap.get("project");
                        epic.setAlmId(_almAccount.getId());
                        HashMap<String, ItemJiraDependency> oldLinksMapByTfsIdAndLinkType = new HashMap<String, ItemJiraDependency>();
                        if (PropertyValidator.isValid((Object)tfsProject) && !tfsFields.isNull(tfsProject.getItemEstimationField())) {
                            Double storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            epic.setStoryPoints(storyPoint);
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField()) && !tfsFields.isNull(tfsProject.getItemDueDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getItemDueDateField());
                            epic.setDueDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField()) && !tfsFields.isNull(tfsProject.getItemStartDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getItemStartDateField());
                            epic.setStartDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField()) && !tfsFields.isNull(tfsProject.getItemEndDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getItemEndDateField());
                            epic.setEndDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getWsjfAlmField()) && !tfsFields.isNull(tfsProject.getWsjfAlmField())) {
                            int tempAlmScore = (Integer)tfsFields.get(tfsProject.getWsjfAlmField());
                            epic.setAlmScoreField(Double.valueOf(tempAlmScore));
                        }
                        epic.setType(Item.Type.Epic.toString());
                        epic.setStatus(this.filterStatus(epic.getStatus()));
                        allEpicMapByTfsId.put(epic.getTfsId(), epic);
                        if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                            for (Object backlogMappingLink : filter.getBacklogMappingLinks()) {
                                if (!epic.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                epic.setTfsLinkTypes(backlogMappingLink.getLinkTypes());
                                break;
                            }
                        }
                        if (existingEpicsByTFSId.containsKey(epic.getTfsId())) {
                            Item existingEpic = (Item)existingEpicsByTFSId.get(epic.getTfsId());
                            if (!isResync.booleanValue()) {
                                existingEpicsDeletionMap.put(existingEpic.getId(), Boolean.FALSE);
                                continue;
                            }
                            if (!(!PropertyValidator.isValid((Object)filter) || PropertyValidator.isValid((Object)existingEpic.getTfsFilter()) && existingEpic.getTfsFilter().equals(filter.getTfsId()))) {
                                existingEpicsDeletionMap.put(existingEpic.getId(), Boolean.FALSE);
                                continue;
                            }
                            epic.setId(existingEpic.getId());
                            epic.setTeamContainers(existingEpic.getTeamContainers());
                            epic.setSequence(existingEpic.getSequence());
                            epic.setBacklogSequence(existingEpic.getBacklogSequence());
                            epic.setSolutionSourceItemLinks(existingEpic.getSolutionSourceItemLinks());
                            epic.setSolutionTargetItemLinks(existingEpic.getSolutionTargetItemLinks());
                            epic.setIssueType(existingEpic.getIssueType());
                            epic.setOriginItemId(existingEpic.getOriginItemId());
                            epic.setDuplicateOfId(existingEpic.getDuplicateOfId());
                            epic.setScore(existingEpic.getScore());
                            epic.setScoreParams(existingEpic.getScoreParams());
                            epic.setAlmScoreField(existingEpic.getAlmScoreField());
                            epic.setItemLinks(existingEpic.getItemLinks());
                            if (!PropertyValidator.isValid((Object)existingEpic.getTfsFilter()) && PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getTfsId())) {
                                epic.setTfsFilter(filter.getTfsId());
                            } else {
                                epic.setTfsFilter(existingEpic.getTfsFilter());
                                epic.setTfsLinkTypes(existingEpic.getTfsLinkTypes());
                            }
                            if (PropertyValidator.isValid((Object)existingEpic.getFetchedBy())) {
                                epic.setFetchedBy(existingEpic.getFetchedBy());
                            }
                            if (PropertyValidator.isValid((Collection)epic.getJiraDependencies())) {
                                Object backlogMappingLink;
                                tfsDependenciesToBeDeleted.addAll(epic.getJiraDependencies());
                                backlogMappingLink = epic.getJiraDependencies().iterator();
                                while (backlogMappingLink.hasNext()) {
                                    ItemJiraDependency dependency = (ItemJiraDependency)backlogMappingLink.next();
                                    if (!PropertyValidator.isValid((Object)dependency)) continue;
                                    oldLinksMapByTfsIdAndLinkType.put(dependency.getTargetTFSItem().getTfsId() + "_" + dependency.getTfsLinkType(), dependency);
                                    if (!PropertyValidator.isValid((Object)dependency.getJiraDependencyId())) continue;
                                    oldLinksMapByAlmId.put(dependency.getJiraDependencyId(), dependency);
                                }
                            }
                        } else {
                            if (PropertyValidator.isValid((Object)filter)) {
                                epic.setTfsFilter(filter.getTfsId());
                            }
                            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
                                epic.setFetchedBy(filter.getFilterFetchedBy());
                            } else {
                                epic.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                            }
                            existingEpicsByTFSId.put(epic.getTfsId(), epic);
                            tfsIdsForART.add(epic.getTfsId());
                        }
                        validEpicIds.add(epic.getTfsId());
                        if (!PropertyValidator.isValid((Object)epic.getId())) {
                            epic.setCreatedOn(new Date());
                            epic.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                        } else {
                            if (PropertyValidator.isValid(existingEpicsDeletionMap.get(epic.getId()))) {
                                existingEpicsDeletionMap.put(epic.getId(), Boolean.FALSE);
                            }
                            epic.setUpdatedOn(new Date());
                            epic.setUpdatedBy(UserContextUtil.getUserContext().getUsername());
                        }
                        epic.setSolutionBoard(this.dbRefOfSolutionBoard(solutionBoard));
                        if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                            HashSet<String> tfsFeatureKeySet = new HashSet<String>();
                            for (int j = 0; j < relationsArray.length(); ++j) {
                                JSONObject relationObject = relationsArray.getJSONObject(j);
                                String rel = relationObject.getString("rel");
                                List<Object> relationsToFetch = new ArrayList();
                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                    for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                        if (!epic.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                        relationsToFetch.addAll(backlogMappingLink.getLinkTypes());
                                        break;
                                    }
                                } else {
                                    relationsToFetch = PropertyValidator.isValid(linkTypes) ? linkTypes : epic.getTfsLinkTypes();
                                }
                                String relURL = relationObject.getString("url");
                                if (PropertyValidator.isValid(relationsToFetch) && relationsToFetch.contains(rel)) {
                                    String workItemKey = relURL.substring(relURL.lastIndexOf("/") + 1);
                                    tfsFeatureKeySet.add(workItemKey);
                                    epicKeyByFeatureKey.put(workItemKey, epic.getTfsId());
                                }
                                if (!PropertyValidator.isValid((Collection)epic.getJiraDependencies())) {
                                    epic.setJiraDependencies(new ArrayList());
                                }
                                if (!PropertyValidator.isValid((Object)solutionAlmSettings) || !solutionAlmSettings.getDependencyEnabled().booleanValue() || !PropertyValidator.isValid((Collection)solutionAlmSettings.getLinkTypes()) || !solutionAlmSettings.getLinkTypes().contains(rel)) continue;
                                String childId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                ItemJiraDependency tfsDependency = new ItemJiraDependency();
                                tfsDependency.setIsTFS(Boolean.valueOf(true));
                                tfsDependency.setSourceItemId(epic.getId());
                                tfsDependency.setTargetItemId(null);
                                String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
                                String itemStatusTitle = null;
                                if (PropertyValidator.isValid((Object)epic.getStatus())) {
                                    itemStatusTitle = epic.getStatus().getTitle();
                                }
                                TFSIssue tfsSourceIssue = new TFSIssue(epic.getTfsId(), epic.getTitle(), itemStatusTitle, epic.getTfsURL(), epic.getTfsApiURL());
                                TFSIssue tfsTargetIssue = new TFSIssue(childId, null, null, targetItemURL, relURL);
                                tfsDependency.setSourceTFSItem(tfsSourceIssue);
                                tfsDependency.setTargetTFSItem(tfsTargetIssue);
                                tfsDependency.setTfsLinkType(rel);
                                tfsDependency.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                tfsDependency.setCreatedOn(new Date());
                                if (PropertyValidator.isValid(oldLinksMapByTfsIdAndLinkType.get(childId + "_" + rel))) {
                                    ItemJiraDependency oldTfsDependency = (ItemJiraDependency)oldLinksMapByTfsIdAndLinkType.get(childId + "_" + rel);
                                    tfsDependenciesToBeDeleted.remove(oldTfsDependency);
                                    oldTfsDependency.setSourceTFSItem(tfsDependency.getSourceTFSItem());
                                    oldTfsDependency.setTargetTFSItem(tfsDependency.getTargetTFSItem());
                                    epic.getJiraDependencies().add(oldTfsDependency);
                                    jiraDependencyMapByTFSSourceTarget.put(epic.getId() + "_" + childId + "_" + depCount, oldTfsDependency);
                                    if (PropertyValidator.isValid((Object)oldTfsDependency.getJiraDependencyId()) && PropertyValidator.isValid(oldLinksMapByAlmId.get(oldTfsDependency.getJiraDependencyId()))) {
                                        oldLinksMapByAlmId.remove(oldTfsDependency.getJiraDependencyId());
                                    }
                                } else {
                                    tfsDependency.setRaisedOn(new Date());
                                    epic.getJiraDependencies().add(tfsDependency);
                                    jiraDependencyMapByTFSSourceTarget.put(epic.getId() + "_" + childId + "_" + depCount, tfsDependency);
                                }
                                ++depCount;
                                relationTFSIds.add(childId);
                            }
                            hashMap2.put(epic.getTfsId(), tfsFeatureKeySet);
                        }
                        hashMap.put(epic.getId(), epic);
                        epics.add(epic);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while parent conversion :: " + StringUtils.getTraceString((Throwable)e));
                        responseMap.put("dataStatus", "Error while processing data.");
                    }
                }
                allEpics.addAll(epics);
                for (String epicKey : hashMap2.keySet()) {
                    Set newFeatureKeys = (Set)hashMap2.get(epicKey);
                    Item epic = (Item)allEpicMapByTfsId.get(epicKey);
                    if (!PropertyValidator.isValid((Collection)newFeatureKeys)) continue;
                    for (String featureKey : newFeatureKeys) {
                        List features = (List)existingSessionFeaturesByKey.get(featureKey);
                        if (PropertyValidator.isValid((Collection)features)) {
                            for (Item item : features) {
                                EpicFeature epicFeature = new EpicFeature();
                                if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0))) {
                                    String sessionId = (String)sessionIdBySessionBoardId.get(((SessionBoard)item.getSessionBoards().get(0)).getId());
                                    epicFeature.setSessionId(sessionId);
                                }
                                epicFeature.setEpicKey(epicKey);
                                epicFeature.setFeatureKey(featureKey);
                                epicFeature.setFeatureId(item.getId());
                                if (PropertyValidator.isValid((Object)filter)) {
                                    epicFeature.setAlmFilterId(filter.getTfsId());
                                } else {
                                    epicFeature.setAlmFilterId(epic.getTfsFilter());
                                }
                                epicFeature.setSolutionBoardId(solutionBoard.getId());
                                newEpicFeatures.add(epicFeature);
                                newFeaturesEpicMap.put(featureKey, epicKey);
                            }
                            continue;
                        }
                        EpicFeature epicFeature = new EpicFeature();
                        epicFeature.setEpicKey(epicKey);
                        epicFeature.setFeatureKey(featureKey);
                        epicFeature.setSolutionBoardId(solutionBoard.getId());
                        if (PropertyValidator.isValid((Object)filter)) {
                            epicFeature.setAlmFilterId(filter.getTfsId());
                        } else {
                            epicFeature.setAlmFilterId(epic.getTfsFilter());
                        }
                        newEpicFeatures.add(epicFeature);
                        newFeaturesEpicMap.put(featureKey, epicKey);
                    }
                }
                if (!PropertyValidator.isValid(newFeaturesEpicMap)) continue;
                List subSetsFeatureIds = Lists.partition(new ArrayList(newFeaturesEpicMap.keySet()), (int)100);
                for (List subSetFeatureIds : subSetsFeatureIds) {
                    if (!PropertyValidator.isValid((Collection)subSetFeatureIds)) continue;
                    ArrayList<String> newFeatureIds = new ArrayList<String>();
                    for (String id : subSetFeatureIds) {
                        if (PropertyValidator.isValid((Collection)((Collection)existingSessionFeaturesByKey.get(id)))) continue;
                        newFeatureIds.add(id);
                    }
                    if (!PropertyValidator.isValid(newFeatureIds)) continue;
                    String idsFeatureStr = String.join((CharSequence)",", newFeatureIds);
                    String featureItemsStr = this.tfsUtils.getItems("1", idsFeatureStr, almAccount);
                    try {
                        dataObjects = new JSONObject(featureItemsStr);
                        itemsArray = dataObjects.getJSONArray("value");
                        sysSequence = new Double((double)System.nanoTime() / 100000.0);
                        extraFields = new HashMap();
                        extraFields.put("sequence", sysSequence);
                        extraFields.put("statusMap", statusMap);
                        extraFields.put("type", Item.FEATURE);
                        for (int i = 0; i < itemsArray.length(); ++i) {
                            try {
                                String dateStr;
                                JSONObject itemObject = itemsArray.getJSONObject(i);
                                JSONObject tfsFields = itemObject.getJSONObject("fields");
                                Map itemMap = this.getKendisItemFromTFSItem(null, null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                                Item feature = null;
                                TFSProject tfsProject = null;
                                if (PropertyValidator.isValid(itemMap.get("item"))) {
                                    feature = (Item)itemMap.get("item");
                                    tfsProject = (TFSProject)itemMap.get("project");
                                }
                                if (feature == null) {
                                    if (PropertyValidator.isValid(itemMap.get("project"))) {
                                        tfsProjectsNotLoaded.add((String)itemMap.get("project"));
                                    }
                                    LOGGER.error("Child item skipped : " + (Integer)itemObject.get("id"));
                                    continue;
                                }
                                feature.setAlmId(_almAccount.getId());
                                if (PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField()) && !tfsFields.isNull(tfsProject.getSubItemEstimationField())) {
                                    Double storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getSubItemEstimationField())));
                                    if (PropertyValidator.isValid((Object)storyPoint)) {
                                        storyPoint = StringUtils.round((double)storyPoint, (int)2);
                                    }
                                    feature.setStoryPoints(storyPoint);
                                }
                                if (PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField()) && !tfsFields.isNull(tfsProject.getSubItemDueDateField())) {
                                    dateStr = (String)tfsFields.get(tfsProject.getSubItemDueDateField());
                                    feature.setDueDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                                }
                                if (PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField()) && !tfsFields.isNull(tfsProject.getSubItemStartDateField())) {
                                    dateStr = (String)tfsFields.get(tfsProject.getSubItemStartDateField());
                                    feature.setStartDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                                }
                                if (PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField()) && !tfsFields.isNull(tfsProject.getSubItemEndDateField())) {
                                    dateStr = (String)tfsFields.get(tfsProject.getSubItemEndDateField());
                                    feature.setEndDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                                }
                                if (PropertyValidator.isValid((Object)tfsProject.getWsjfAlmFieldForUnplannedFeatures()) && !tfsFields.isNull(tfsProject.getWsjfAlmFieldForUnplannedFeatures())) {
                                    int tempAlmScore = (Integer)tfsFields.get(tfsProject.getWsjfAlmFieldForUnplannedFeatures());
                                    feature.setAlmScoreField(Double.valueOf(tempAlmScore));
                                }
                                feature.setType(Item.Type.Feature.toString());
                                if (PropertyValidator.isValid((Object)filter)) {
                                    if (PropertyValidator.isValid((Object)filter)) {
                                        feature.setFetchedBy(filter.getFilterFetchedBy());
                                    }
                                    if (PropertyValidator.isValid((Object)filter)) {
                                        feature.setTfsFilter(filter.getTfsId());
                                    }
                                }
                                feature.setSolutionBoard(this.dbRefOfSolutionBoard(solutionBoard));
                                feature.setStatus(this.filterStatus(feature.getStatus()));
                                Item existingSolutionFeature = (Item)existingSolutionFeaturesByKey.get(feature.getTfsId());
                                if (!PropertyValidator.isValid((Object)existingSolutionFeature)) {
                                    allNewFeatures.add(feature);
                                    tfsIdsForART.add(feature.getTfsId());
                                    continue;
                                }
                                existingSolutionFeaturesDeletionMap.put(existingSolutionFeature.getId(), Boolean.FALSE);
                                feature.setId(existingSolutionFeature.getId());
                                feature.setSolutionSourceItemLinks(existingSolutionFeature.getSolutionSourceItemLinks());
                                feature.setSolutionTargetItemLinks(existingSolutionFeature.getSolutionTargetItemLinks());
                                existingSolutionFeaturesToUpdate.add(feature);
                                if (PropertyValidator.isValid((Collection)existingSolutionFeature.getSolutionAlmDependencies())) {
                                    tfsDependenciesToBeDeleted.addAll(existingSolutionFeature.getSolutionAlmDependencies());
                                }
                                if (PropertyValidator.isValid((Object)solutionAlmSettings) && solutionAlmSettings.getDependencyEnabled().booleanValue() && PropertyValidator.isValid((Collection)solutionAlmSettings.getLinkTypes())) {
                                    feature.setSolutionAlmDependencies(new ArrayList());
                                    continue;
                                }
                                feature.setSolutionAlmDependencies(null);
                                continue;
                            }
                            catch (Exception ex) {
                                responseMap.put("dataStatus", "Error while processing data.");
                                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                            }
                        }
                    }
                    catch (Exception e) {
                        responseMap.put("dataStatus", "Error while processing data.");
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            catch (Exception e) {
                responseMap.put("dataStatus", "Error while processing data.");
                LOGGER.error("Exception while main parent conversion :: " + StringUtils.getTraceString((Throwable)e));
            }
        }
        if (PropertyValidator.isValid(validEpicIds)) {
            List existingEpicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardIdAndSessionIdIsNull(validEpicIds, solutionBoard.getId());
            for (EpicFeature epicFeature : existingEpicFeatures) {
                Item feature = (Item)existingSolutionFeaturesByKey.get(epicFeature.getFeatureKey());
                if (!PropertyValidator.isValid((Object)feature) || existingSolutionFeaturesDeletionMap.get(feature.getId()) != null) continue;
                existingSolutionFeaturesDeletionMap.put(feature.getId(), Boolean.TRUE);
            }
        }
        if (PropertyValidator.isValid(itemJiraDependenciesValues = jiraDependencyMapByTFSSourceTarget.values())) {
            for (ItemJiraDependency jiraDependency : itemJiraDependenciesValues) {
                jiraDependency.setSolutionId(solutionBoard.getId());
            }
            this.itemJiraDependencyRepository.save(itemJiraDependenciesValues);
            tfsDependenciesToBeDeleted.removeIf(v -> !PropertyValidator.isValid((Object)v));
            if (PropertyValidator.isValid(tfsDependenciesToBeDeleted)) {
                try {
                    this.itemJiraDependencyRepository.delete(tfsDependenciesToBeDeleted);
                }
                catch (Exception ex) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                }
            }
        }
        HashMap<String, EpicFeature> existingKendisRelation = new HashMap<String, EpicFeature>();
        HashMap<String, Item> existingParentByKendisKey = new HashMap<String, Item>();
        List kendisOnlyEpics = new ArrayList();
        ArrayList<String> kendisOnlyEpicIds = new ArrayList<String>();
        kendisOnlyEpics = this.itemRepository.findBySolutionBoardAndKendisKeyNotNull(solutionBoard);
        for (Item kendisEpic : kendisOnlyEpics) {
            kendisOnlyEpicIds.add(kendisEpic.getKendisKey());
            existingParentByKendisKey.put(kendisEpic.getKendisKey(), kendisEpic);
        }
        List existingKendisEpicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardId(kendisOnlyEpicIds, solutionBoard.getId());
        ArrayList<String> featureIdsFromExistingKendisRelations = new ArrayList<String>();
        for (EpicFeature epicFeature : existingKendisEpicFeatures) {
            String string = epicFeature.getEpicKey() + "_" + epicFeature.getFeatureId() + "_" + (epicFeature.getSessionId() == null ? "" : epicFeature.getSessionId());
            existingKendisRelation.put(string, epicFeature);
            featureIdsFromExistingKendisRelations.add(epicFeature.getFeatureId());
        }
        if (PropertyValidator.isValid(allEpics)) {
            List subSetsEpics = Lists.partition(new ArrayList(allEpics), (int)100);
            ArrayList tempEpics = new ArrayList();
            for (List list : subSetsEpics) {
                tempEpics.addAll(this.itemRepository.save((Iterable)list));
                LOGGER.debug(" subSetParentItems....  ");
            }
            allEpics = tempEpics;
        }
        if (PropertyValidator.isValid(allNewFeatures)) {
            List subSetsNewFeatures = Lists.partition(new ArrayList(allNewFeatures), (int)100);
            ArrayList tempNewFeatures = new ArrayList();
            for (List list : subSetsNewFeatures) {
                tempNewFeatures.addAll(this.itemRepository.save((Iterable)list));
                LOGGER.debug(" subSetNewFeatures....  ");
            }
            allNewFeatures = tempNewFeatures;
        }
        if (PropertyValidator.isValid(existingSolutionFeaturesToUpdate)) {
            this.itemRepository.save(existingSolutionFeaturesToUpdate);
        }
        if (PropertyValidator.isValid(existingEpicsDeletionMap) && !existingEpicsDeletionMap.isEmpty()) {
            ArrayList<String> deletedEpicsKeys = new ArrayList<String>();
            ArrayList<String> deletedEpicsIds = new ArrayList<String>();
            for (String string : existingEpicsDeletionMap.keySet()) {
                if (!((Boolean)existingEpicsDeletionMap.get(string)).equals(Boolean.TRUE)) continue;
                Item epic = (Item)existingEpicsById.get(string);
                deletedEpicsKeys.add(epic.getTfsId());
                deletedEpicsIds.add(epic.getId());
                tfsIdsForART.add(epic.getTfsId());
            }
            if (!deletedEpicsKeys.isEmpty()) {
                responseMap.put("deletedEpicIds", deletedEpicsIds);
                this.itemRepository.deleteByIdIn(deletedEpicsIds);
            }
        }
        if (PropertyValidator.isValid(existingSolutionFeaturesDeletionMap) && !existingSolutionFeaturesDeletionMap.isEmpty()) {
            ArrayList<String> deletedFeatureKeys = new ArrayList<String>();
            ArrayList deletedFeatureIds = new ArrayList();
            for (String string : existingSolutionFeaturesDeletionMap.keySet()) {
                Item item;
                if (!((Boolean)existingSolutionFeaturesDeletionMap.get(string)).equals(Boolean.TRUE) || !PropertyValidator.isValid((Object)(item = (Item)existingSolutionFeaturesById.get(string)))) continue;
                deletedFeatureKeys.add(item.getTfsId());
                deletedFeatureIds.add(item.getId());
                tfsIdsForART.add(item.getTfsId());
            }
            if (!deletedFeatureKeys.isEmpty()) {
                responseMap.put("deletedFeatureIds", deletedFeatureIds);
                this.itemRepository.deleteByIdIn(deletedFeatureIds);
            }
        }
        ArrayList<String> newEfFeatureIds = new ArrayList<String>();
        for (EpicFeature epicFeature : newEpicFeatures) {
            newEfFeatureIds.add(epicFeature.getFeatureId());
        }
        ArrayList<String> kendisEpicFeaturesToRemove = new ArrayList<String>();
        for (Map.Entry entry : existingKendisRelation.entrySet()) {
            String[] key = ((String)entry.getKey()).split("_");
            if (!PropertyValidator.isValid((String[])key) || !featureIdsFromExistingKendisRelations.contains(key[1]) || !newEfFeatureIds.contains(key[1])) continue;
            kendisEpicFeaturesToRemove.add(key[0]);
        }
        validEpicIds.addAll(kendisEpicFeaturesToRemove);
        if (PropertyValidator.isValid(validEpicIds)) {
            this.epicFeaturesRepository.deleteByEpicKeyInAndSolutionBoardId(validEpicIds, solutionBoard.getId());
        }
        ArrayList arrayList = new ArrayList();
        if (PropertyValidator.isValid(newEpicFeatures)) {
            List list = Lists.partition(new ArrayList(newEpicFeatures), (int)100);
            for (List subSetEpics : list) {
                arrayList.addAll(this.epicFeaturesRepository.save((Iterable)subSetEpics));
                LOGGER.debug(" epic feature relationship ....  ");
            }
        }
        responseMap.put("status", "success");
        responseMap.put("epics", allEpics);
        responseMap.put("newFeatures", allNewFeatures);
        responseMap.put("updatedFeatures", existingSolutionFeaturesToUpdate);
        responseMap.put("epicFeatureMap", arrayList);
        return responseMap;
    }

    public void compareBoardFeatures(String sessionBoardId, String syncId) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = board.getSession();
        if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
            TFSAlmConfigurations configuration = session.getTfsAlmConfigurations();
            List filters = configuration.getFeatureFilters();
            AlmAccount almAccount = configuration.getAlmAccount();
            int notificationCounter = 0;
            if (PropertyValidator.isValid((Collection)filters)) {
                ArrayList responseArray = new ArrayList();
                for (TFSFilter filter : filters) {
                    ArrayList<JSONObject> tfsItems = new ArrayList<JSONObject>();
                    AlmAccount tempALMAccount = new AlmAccount();
                    tempALMAccount.setId(almAccount.getId());
                    tempALMAccount.setUrl(almAccount.getUrl());
                    tempALMAccount.setUsername(almAccount.getUsername());
                    tempALMAccount.setPassword(almAccount.getPassword());
                    tempALMAccount.setAzureOAuthToken(almAccount.getAzureOAuthToken());
                    tempALMAccount.setSecretKey(almAccount.getSecretKey());
                    tempALMAccount.setClientId(almAccount.getClientId());
                    tempALMAccount.setIsTaggedUser(Boolean.valueOf(false));
                    tempALMAccount.setAdminAlmAcc(almAccount.getAdminAlmAcc());
                    tempALMAccount.setOAuthTokenOwnerUserId(almAccount.getOAuthTokenOwnerUserId());
                    AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUserCopyAlm((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount);
                    if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                        tempALMAccount.setUsername(taggedAlmAccount.getUsername());
                        tempALMAccount.setPassword(taggedAlmAccount.getPassword());
                        tempALMAccount.setAzureOAuthToken(taggedAlmAccount.getAzureOAuthToken());
                        tempALMAccount.setOAuthTokenOwnerUserId(taggedAlmAccount.getOAuthTokenOwnerUserId());
                        tempALMAccount.setIsTaggedUser(Boolean.valueOf(true));
                        tempALMAccount.setAdminAlmAcc(Boolean.valueOf(false));
                    } else {
                        tempALMAccount.setIsTaggedUser(Boolean.valueOf(true));
                    }
                    try {
                        int i;
                        JSONObject workItemObject;
                        JSONArray workItemsArray;
                        String tfsItemIdsStr;
                        if (PropertyValidator.isValid((Object)filter.getIsWiql()) && filter.getIsWiql().booleanValue()) {
                            String wiql = filter.getQueryJSON();
                            wiql = wiql.replace("\"", "'");
                            String queryStr = "{query:\"" + wiql + "\"}";
                            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, tempALMAccount, false);
                            tfsItemIdsStr = tfsResponse.getContent();
                        } else {
                            String filterId = filter.getTfsId();
                            tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(this.tfsUtils.encodeValue(filter.getTfsProjectId()), filterId, tempALMAccount);
                        }
                        LOGGER.debug("==================== RETURN FROM FILTER DETAILS");
                        JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                        LOGGER.debug("==================== RESPONSE PARSED : " + jsonObject.length());
                        String queryType = jsonObject.getString("queryType");
                        ArrayList<String> relations = new ArrayList<String>();
                        if (queryType.equals("flat")) {
                            workItemsArray = jsonObject.getJSONArray("workItems");
                            for (int i2 = 0; i2 < workItemsArray.length(); ++i2) {
                                JSONObject wiObject = workItemsArray.getJSONObject(i2);
                                String itemId = wiObject.getString("id");
                                String itemURL = wiObject.getString("url");
                                workItemObject = new JSONObject();
                                workItemObject.put("id", (Object)itemId);
                                workItemObject.put("url", (Object)itemURL);
                                tfsItems.add(workItemObject);
                            }
                        } else {
                            workItemsArray = new JSONArray();
                            JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                            ArrayList<String> subItemIds = new ArrayList<String>();
                            for (int i3 = 0; i3 < workItemsRelationsArray.length(); ++i3) {
                                JSONObject wirObject = workItemsRelationsArray.getJSONObject(i3);
                                Object sourceObject = null;
                                JSONObject targetObject = null;
                                String relation = null;
                                if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                                    targetObject = wirObject.getJSONObject("target");
                                }
                                if (!wirObject.isNull("rel")) {
                                    relation = wirObject.getString("rel");
                                }
                                if (PropertyValidator.isValid(targetObject)) {
                                    JSONObject workItemObject2 = new JSONObject();
                                    String itemId = targetObject.getString("id");
                                    String itemURL = targetObject.getString("url");
                                    workItemObject2.put("id", (Object)itemId);
                                    workItemObject2.put("url", (Object)itemURL);
                                    workItemsArray.put((Object)workItemObject2);
                                    tfsItems.add(workItemObject2);
                                }
                                if (PropertyValidator.isValid((Object)targetObject)) {
                                    String itemId = targetObject.getString("id");
                                    subItemIds.add(itemId);
                                }
                                if (!PropertyValidator.isValid((Object)relation)) continue;
                                relations.add(relation);
                            }
                        }
                        LOGGER.debug("==================== FILTER DATA PROCESSING COMPLETED");
                        List existingItems = this.itemRepository.findBySessionBoardsIdInAndTypeAndTfsIdIsNotNull(sessionBoardId, Item.FEATURE);
                        LOGGER.debug("==================== BOARD FEATURE FETCHED : " + existingItems.size());
                        HashMap itemMap = new HashMap();
                        HashMap<String, String> deleteItemMap = new HashMap<String, String>();
                        ArrayList itemsToDelete = new ArrayList();
                        existingItems.forEach(item -> {
                            itemMap.put(item.getTfsId(), item.getTfsId());
                            if (PropertyValidator.isValid((Object)item.getTfsFilter()) && item.getTfsFilter().equals(filter.getTfsId())) {
                                JSONObject workItemObject = new JSONObject();
                                workItemObject.put("id", (Object)item.getTfsId());
                                workItemObject.put("title", (Object)item.getTitle());
                                workItemObject.put("url", (Object)item.getTfsURL());
                                if (PropertyValidator.isValid((Object)item.getStatus())) {
                                    workItemObject.put("status", (Object)item.getStatus().getTitle());
                                }
                                workItemObject.put("icon", (Object)item.getTfsItemTypeIcon());
                                itemsToDelete.add(workItemObject);
                            }
                        });
                        for (i = 0; i < tfsItems.size(); ++i) {
                            workItemObject = (JSONObject)tfsItems.get(i);
                            deleteItemMap.put((String)workItemObject.get("id"), (String)workItemObject.get("id"));
                            if (itemMap.get(workItemObject.get("id")) == null) continue;
                            tfsItems.remove(i);
                            --i;
                        }
                        for (i = 0; i < itemsToDelete.size(); ++i) {
                            workItemObject = (JSONObject)itemsToDelete.get(i);
                            if (deleteItemMap.get(workItemObject.get("id")) == null) continue;
                            itemsToDelete.remove(i);
                            --i;
                        }
                        LOGGER.debug("==================== BOARD FEATURES COMPARED");
                        LOGGER.debug("==================== ITEMS ADDDED : " + tfsItems.size());
                        LOGGER.debug("==================== ITEMS DELETED : " + itemsToDelete.size());
                        notificationCounter += tfsItems.size();
                        HashMap<String, Object> response = new HashMap<String, Object>();
                        response.put("filter", filter);
                        response.put("itemsToAdd", tfsItems);
                        response.put("itemsToDelete", itemsToDelete);
                        responseArray.add(response);
                    }
                    catch (ViztrendJiraException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        HashMap<String, Object> response = new HashMap<String, Object>();
                        response.put("filter", filter);
                        response.put("error", (Object)e);
                        responseArray.add(response);
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                board.setNoticationCounter(Integer.valueOf(notificationCounter));
                this.sessionBoardRepository.save((Object)board);
                Gson gson = new Gson();
                HashMap pushData = new HashMap();
                pushData.put("changes", responseArray);
                String itemStr = gson.toJson(pushData);
                this.pushProgressUpdates("CompareFeature", syncId, itemStr, false);
            } else {
                Gson gson = new Gson();
                HashMap pushData = new HashMap();
                String itemStr = gson.toJson(pushData);
                this.pushProgressUpdates("CompareFeature", syncId, itemStr, false);
            }
        }
    }

    private List<String> getTfsItemsFromFilter(String wiql, TFSFilter tfsFilter, AlmAccount almAccount) {
        try {
            String tfsItemIdsStr;
            TFSResponse tfsResponse;
            String queryStr;
            ArrayList<String> tfsIds = new ArrayList<String>();
            if (wiql != null) {
                wiql = wiql.replace("\"", "'");
                queryStr = "{query:\"" + wiql + "\"}";
                tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, almAccount, true);
                tfsItemIdsStr = tfsResponse.getContent();
            } else if (PropertyValidator.isValid((Object)tfsFilter.getIsWiql()) && tfsFilter.getIsWiql().booleanValue()) {
                wiql = tfsFilter.getQueryJSON();
                wiql = wiql.replace("\"", "'");
                queryStr = "{query:\"" + wiql + "\"}";
                tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, almAccount, false);
                tfsItemIdsStr = tfsResponse.getContent();
            } else {
                tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(this.tfsUtils.encodeValue(tfsFilter.getTfsProjectId()), tfsFilter.getTfsId(), almAccount);
            }
            try {
                JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                String queryType = jsonObject.getString("queryType");
                ArrayList<String> relations = new ArrayList<String>();
                if (queryType.equals("flat")) {
                    JSONArray workItemsArray = jsonObject.getJSONArray("workItems");
                    for (int i = 0; i < workItemsArray.length(); ++i) {
                        JSONObject wiObject = workItemsArray.getJSONObject(i);
                        String itemId = wiObject.getString("id");
                        tfsIds.add(itemId);
                    }
                } else {
                    JSONArray workItemsArray = new JSONArray();
                    JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                    ArrayList<String> subItemIds = new ArrayList<String>();
                    for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                        JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                        Object sourceObject = null;
                        JSONObject targetObject = null;
                        String relation = null;
                        if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                            targetObject = wirObject.getJSONObject("target");
                        }
                        if (!wirObject.isNull("rel")) {
                            relation = wirObject.getString("rel");
                        }
                        if (PropertyValidator.isValid(targetObject)) {
                            JSONObject workItemObject = new JSONObject();
                            String itemId = targetObject.getString("id");
                            String itemURL = targetObject.getString("url");
                            tfsIds.add(itemId);
                            workItemObject.put("id", (Object)itemId);
                            workItemObject.put("url", (Object)itemURL);
                            workItemsArray.put((Object)workItemObject);
                        }
                        if (PropertyValidator.isValid((Object)targetObject)) {
                            String itemId = targetObject.getString("id");
                            subItemIds.add(itemId);
                        }
                        if (!PropertyValidator.isValid((Object)relation)) continue;
                        relations.add(relation);
                    }
                }
                return tfsIds;
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                return null;
            }
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private String createUpdatedItemsQuery(List<String> ids, Date lastSyncDate) {
        Date lastSyncDateUTC = lastSyncDate;
        Date currentDateUTC = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String lastSyncDateStr = dateFormat.format(lastSyncDateUTC);
        String currentDateStr = dateFormat.format(currentDateUTC);
        String tfsItemIdsStr = String.join((CharSequence)",", ids);
        String updateQuery = "SELECT";
        updateQuery = updateQuery + "\n [System.Id]";
        updateQuery = updateQuery + "\n FROM workitems";
        updateQuery = updateQuery + "\n WHERE";
        updateQuery = updateQuery + "\n [System.Id] IN (" + tfsItemIdsStr + ")";
        updateQuery = updateQuery + "\n AND [System.ChangedDate] >= '" + lastSyncDateStr + "'";
        updateQuery = updateQuery + "\n AND [System.ChangedDate] <= '" + currentDateStr + "'";
        return updateQuery;
    }

    private HashMap<String, Object> isRelationChanged(Item item, JSONArray relationsArray, List<String> childRelations, List<String> depRelations, String parentRelation, boolean ignoreSyncTime) {
        String key;
        String _id;
        String _rel;
        HashMap<String, Map> existingLinkMap = new HashMap<String, Map>();
        if (item.getTfsRelations() != null) {
            for (Map rel : item.getTfsRelations()) {
                _rel = (String)rel.get("rel");
                _id = (String)rel.get("id");
                key = _rel + ":" + _id;
                if (ignoreSyncTime && (parentRelation != null && _rel.equals(parentRelation) || depRelations != null && depRelations.contains(_rel))) continue;
                existingLinkMap.put(key, rel);
            }
        }
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            for (ItemJiraDependency jDep : item.getJiraDependencies()) {
                if (!PropertyValidator.isValid((Object)jDep)) continue;
                _rel = jDep.getTfsLinkType();
                _id = jDep.getTargetTFSItem().getTfsId();
                key = _rel + ":" + _id;
                HashMap<String, String> rel = new HashMap<String, String>();
                rel.put("rel", _rel);
                rel.put("id", _id);
                existingLinkMap.put(key, rel);
            }
        }
        ArrayList<Map> finalRelations = new ArrayList<Map>();
        ArrayList<Map> newParent = new ArrayList<Map>();
        ArrayList<Map> newChildren = new ArrayList<Map>();
        ArrayList<Map> newDeps = new ArrayList<Map>();
        ArrayList<Map> removedParent = new ArrayList<Map>();
        ArrayList<Map> removedChildren = new ArrayList<Map>();
        ArrayList<Map> removedDeps = new ArrayList<Map>();
        boolean changed = false;
        if (relationsArray != null) {
            for (int i = 0; i < relationsArray.length(); ++i) {
                JSONObject relationObject = relationsArray.getJSONObject(i);
                String rel = relationObject.getString("rel");
                String relURL = relationObject.getString("url");
                String itemId = relURL.substring(relURL.lastIndexOf("/") + 1);
                String key2 = rel + ":" + itemId;
                boolean isValidParent = false;
                boolean isValidChild = false;
                boolean isValidDep = false;
                if (childRelations != null && childRelations.contains(rel)) {
                    isValidChild = true;
                }
                if (depRelations != null && depRelations.contains(rel)) {
                    isValidDep = true;
                }
                if (parentRelation != null && parentRelation.equals(rel)) {
                    isValidParent = true;
                }
                if (isValidParent || isValidChild || isValidDep) {
                    finalRelations.add(this.relationToMap(rel, itemId, relURL));
                }
                if (existingLinkMap.get(key2) == null) {
                    if (isValidParent) {
                        changed = true;
                        newParent.add(this.relationToMap(rel, itemId, relURL));
                        continue;
                    }
                    if (isValidChild) {
                        changed = true;
                        newChildren.add(this.relationToMap(rel, itemId, relURL));
                        continue;
                    }
                    if (!isValidDep) continue;
                    changed = true;
                    newDeps.add(this.relationToMap(rel, itemId, relURL));
                    continue;
                }
                if (!isValidDep || !existingLinkMap.containsKey(key2)) continue;
                existingLinkMap.remove(key2);
            }
        }
        if (!existingLinkMap.isEmpty()) {
            for (String key3 : existingLinkMap.keySet()) {
                Map relation = (Map)existingLinkMap.get(key3);
                changed = true;
                String rel = (String)relation.get("rel");
                boolean isDepedency = true;
                if (childRelations != null && childRelations.contains(rel)) {
                    isDepedency = false;
                    removedChildren.add(relation);
                }
                if (parentRelation != null && parentRelation.equals(rel)) {
                    isDepedency = false;
                    removedParent.add(relation);
                }
                if (!isDepedency) continue;
                removedDeps.add(relation);
            }
        }
        if (changed) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("newParent", newParent);
            result.put("removedParent", removedParent);
            result.put("newChildren", newChildren);
            result.put("removedChildren", removedChildren);
            result.put("newDeps", newDeps);
            result.put("removedDeps", removedDeps);
            result.put("final", finalRelations);
            return result;
        }
        return null;
    }

    private HashMap<String, Object> findMatchingItemSyncMappersOfItem(Item item, Item parentItem, Session session, String iterationPath, String areaPath, HashMap<String, ItemSyncMapper> syncMappersMapByTeamSrintId, HashMap<String, ArrayList<ItemSyncMapper>> syncMappersMapByIterationPath, HashMap<String, TFSTeamMapping> tfsTeamMappingMapByTeamId) {
        TFSTeamMapping tfsTeamMapping;
        ArrayList<ItemSyncMapper> syncMappers;
        String key;
        TeamContainer previousTeamContainer = null;
        boolean oldSubItemMappingFound = false;
        boolean newSubItemMappingFound = false;
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            previousTeamContainer = (TeamContainer)item.getTeamContainers().get(0);
        }
        if (PropertyValidator.isValid(previousTeamContainer) && syncMappersMapByTeamSrintId.containsKey(key = previousTeamContainer.getTeam().getId() + ":" + previousTeamContainer.getContainer().getId())) {
            oldSubItemMappingFound = true;
        }
        ArrayList<ItemSyncMapper> matchedSyncMappers = new ArrayList<ItemSyncMapper>();
        if (PropertyValidator.isValid((Object)iterationPath) && PropertyValidator.isValid(syncMappers = syncMappersMapByIterationPath.get(iterationPath))) {
            for (ItemSyncMapper syncMapper : syncMappers) {
                if (!tfsTeamMappingMapByTeamId.containsKey(syncMapper.getTeam().getId())) continue;
                if (!session.getAreaPathDisabled().booleanValue()) {
                    tfsTeamMapping = tfsTeamMappingMapByTeamId.get(syncMapper.getTeam().getId());
                    if (!PropertyValidator.isValid((Object)areaPath)) continue;
                    if (tfsTeamMapping.getIncludeSubAreaPaths().booleanValue()) {
                        boolean check1 = areaPath.equals(tfsTeamMapping.getTfsAreaPath()) || areaPath.startsWith(tfsTeamMapping.getTfsAreaPath() + "\\");
                        boolean check2 = true;
                        if (PropertyValidator.isValid((Collection)tfsTeamMapping.getTfsAreaPathsForTeam())) {
                            check2 = false;
                            for (String aPath : tfsTeamMapping.getTfsAreaPathsForTeam()) {
                                if (!areaPath.equals(aPath) && !areaPath.startsWith(aPath + "\\")) continue;
                                check2 = true;
                                break;
                            }
                        }
                        if (!check1 && !check2) continue;
                        newSubItemMappingFound = true;
                        matchedSyncMappers.add(syncMapper);
                        continue;
                    }
                    if (!areaPath.equals(tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)tfsTeamMapping.getTfsAreaPathsForTeam()) || !tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                    newSubItemMappingFound = true;
                    matchedSyncMappers.add(syncMapper);
                    continue;
                }
                newSubItemMappingFound = true;
                matchedSyncMappers.add(syncMapper);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid(matchedSyncMappers)) {
            newSubItemMappingFound = true;
            if (matchedSyncMappers.size() > 1) {
                for (ItemSyncMapper syncMapper : matchedSyncMappers) {
                    tfsTeamMapping = tfsTeamMappingMapByTeamId.get(syncMapper.getTeam().getId());
                    if (!areaPath.equals(tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)tfsTeamMapping.getTfsAreaPathsForTeam()) || !tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                    matchedSyncMappers.clear();
                    matchedSyncMappers.add(syncMapper);
                    break;
                }
            }
        }
        boolean parentItemMappingFound = false;
        TeamContainer newTeamContainer = null;
        if (PropertyValidator.isValid(matchedSyncMappers)) {
            for (ItemSyncMapper itemSyncMapper : matchedSyncMappers) {
                TeamContainer teamContainer;
                if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                    for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                        if (!parentTeamContainer.getTeam().equals((Object)itemSyncMapper.getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.getContainer())) continue;
                        newTeamContainer = parentTeamContainer;
                        parentItemMappingFound = true;
                        item.setTeamContainers(new ArrayList());
                        item.getTeamContainers().add(newTeamContainer);
                        item.applySprintDates(session, null, null);
                        break;
                    }
                }
                if (parentItemMappingFound) continue;
                newTeamContainer = teamContainer = new TeamContainer();
                teamContainer.setTeam(itemSyncMapper.getTeam());
                teamContainer.setContainer(itemSyncMapper.getContainer());
                teamContainer.setSuspendActivity(true);
                item.setTeamContainers(new ArrayList());
                item.getTeamContainers().add(newTeamContainer);
                item.applySprintDates(session, null, null);
                if (parentItem.getTeamContainers() == null) {
                    parentItem.setTeamContainers(new ArrayList());
                }
                parentItem.getTeamContainers().add(newTeamContainer);
            }
        }
        result.put("teamContainer", newTeamContainer);
        result.put("oldSubItemMappingFound", oldSubItemMappingFound);
        result.put("newSubItemMappingFound", newSubItemMappingFound);
        result.put("syncMappers", matchedSyncMappers);
        return result;
    }

    public HashMap<String, Object> fetchUpdatedTFSItemsSinceLastSyncTime(String sessionBoardId, AlmAccount almAccount, HashMap<String, Object> params) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = sessionBoard.getSession();
        String syncId = (String)params.get("syncId");
        if (PropertyValidator.isValid((Object)session.getLastChangesSyncTime())) {
            Date lastSyncDate = session.getLastChangesSyncTime();
            List allSessionBoardItems = this.itemRepository.findTFSIdsBySessionBoardsIdInAndTfsIdIsNotNull(sessionBoardId);
            ArrayList<String> allItemsTfsIds = new ArrayList<String>();
            for (Item item : allSessionBoardItems) {
                allItemsTfsIds.add(item.getTfsId());
            }
            if (PropertyValidator.isValid(allItemsTfsIds)) {
                List subSetsOfTfsItems = Lists.partition(new ArrayList(allItemsTfsIds), (int)500);
                ArrayList allItemsUpdated = new ArrayList();
                for (List subSetOfTfsItems : subSetsOfTfsItems) {
                    String updateItemWiql = this.createUpdatedItemsQuery(subSetOfTfsItems, lastSyncDate);
                    try {
                        List updatedTfsIds = this.getTfsItemsFromFilter(updateItemWiql, null, almAccount);
                        if (!PropertyValidator.isValid((Collection)updatedTfsIds)) continue;
                        allItemsUpdated.addAll(updatedTfsIds);
                    }
                    catch (ViztrendJiraException viztrendJiraException) {}
                }
                Gson gson = new Gson();
                HashMap data = new HashMap();
                data.put("itemsUpdated", allItemsUpdated);
                this.pushProgressUpdates("FetchUpdatedTFSItems", syncId, gson.toJson(data), true);
                params.put("updateItemIds", allItemsUpdated);
                this.saveUpdatedTFSItemsSinceLastSyncTime(sessionBoard, almAccount, params);
                data = new HashMap();
                data.put("itemsUpdated", allItemsUpdated);
                this.pushProgressUpdates("FetchUpdatedTFSItems", syncId, gson.toJson(data), false);
            }
        } else {
            session.setLastChangesSyncTime(new Date());
            this.sessionRepository.save((Object)session);
            HashMap data = new HashMap();
            Gson gson = new Gson();
            this.pushProgressUpdates("FetchUpdatedTFSItems", syncId, gson.toJson(data), false);
        }
        return null;
    }

    public HashMap<String, Object> saveUpdatedTFSItemsSinceLastSyncTime(SessionBoard sessionBoard, AlmAccount almAccount, HashMap<String, Object> params) {
        Session session = sessionBoard.getSession();
        List updateItemIds = (List)params.get("updateItemIds");
        List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(session.getId());
        HashMap<String, TFSProject> tfsProjectsMapById = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (TFSProject tfsProject : tfsProjects) {
                tfsProjectsMapById.put(tfsProject.getTfsId(), tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
            }
        }
        List statuses = this.statusRepository.findBySessionId(session.getId());
        HashMap statusMapByKey = this.getStatusesMap(statuses);
        List syncMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoard.getId()));
        HashMap<String, Object> syncMappersMapByTeamSrintId = new HashMap<String, Object>();
        HashMap<String, ArrayList<Object>> syncMappersMapByIterationPath = new HashMap<String, ArrayList<Object>>();
        if (PropertyValidator.isValid((Collection)syncMappers)) {
            for (Object synMapper : syncMappers) {
                if (PropertyValidator.isValid((Object)synMapper.getTfsSprint())) {
                    ArrayList<Object> sms = (ArrayList<Object>)syncMappersMapByIterationPath.get(synMapper.getTfsSprint().getIterationPath());
                    if (sms == null) {
                        sms = new ArrayList<Object>();
                        syncMappersMapByIterationPath.put(synMapper.getTfsSprint().getIterationPath(), sms);
                    }
                    sms.add(synMapper);
                }
                String key = synMapper.getTeam().getId() + ":" + synMapper.getContainer().getId();
                syncMappersMapByTeamSrintId.put(key, synMapper);
            }
        }
        HashMap<String, TFSTeamMapping> tfsTeamMappingMapByTeamId = new HashMap<String, TFSTeamMapping>();
        if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)session.getTfsAlmConfigurations().getTeamMappings())) {
            for (TFSTeamMapping mappedTeam : session.getTfsAlmConfigurations().getTeamMappings()) {
                tfsTeamMappingMapByTeamId.put(mappedTeam.getKendisTeamId(), mappedTeam);
            }
        }
        boolean autoCloseItemDependency = false;
        boolean autoCloseSubItemDependency = false;
        boolean autoOpenItemDependency = false;
        boolean autoOpenSubItemDependency = false;
        if (PropertyValidator.isValid((Object)session.getItemLinkStatusDependentOn()) && !session.getItemLinkStatusDependentOn().equals("-1")) {
            autoCloseItemDependency = true;
        }
        if (PropertyValidator.isValid((Object)session.getSubItemLinkStatusDependentOn()) && !session.getSubItemLinkStatusDependentOn().equals("-1")) {
            autoCloseSubItemDependency = true;
        }
        if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfItemReOpen())) {
            autoOpenItemDependency = session.getReOpenDependencyIfItemReOpen();
        }
        if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfSubItemReOpen())) {
            autoOpenSubItemDependency = session.getReOpenDependencyIfSubItemReOpen();
        }
        ArrayList<String> autoCloseLinksOfItems = new ArrayList<String>();
        ArrayList<String> autoCloseLinksOfSubItems = new ArrayList<String>();
        ArrayList<String> autoOpenLinksOfItems = new ArrayList<String>();
        ArrayList<String> autoOpenLinksOfSubItems = new ArrayList<String>();
        ArrayList<String> autoCloseLinksOfItemIds = new ArrayList<String>();
        ArrayList<String> autoOpenLinksOfItemIds = new ArrayList<String>();
        List subSetsOfTfsItems = Lists.partition(new ArrayList(updateItemIds), (int)100);
        for (List subSetOfTfsItems : subSetsOfTfsItems) {
            List existingItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdIn(sessionBoard.getId(), subSetOfTfsItems);
            HashMap<String, Item> itemsMapByTfsId = new HashMap<String, Item>();
            HashMap<String, String> parentItemsMapToLoad = new HashMap<String, String>();
            HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
            HashMap<String, Item> featuresMapById = new HashMap<String, Item>();
            HashMap parentsMapById = new HashMap();
            if (PropertyValidator.isValid((Collection)existingItems)) {
                for (Item item : existingItems) {
                    itemsMapByTfsId.put(item.getTfsId(), item);
                    if (item.getType().equals(Item.FEATURE)) {
                        featuresMapById.put(item.getId(), item);
                        continue;
                    }
                    String parentId = item.getParent().getId();
                    parentItemsMapToLoad.put(parentId, parentId);
                }
            }
            HashMap<String, String> teamContainerChangeMap = new HashMap<String, String>();
            Set parentItemsToLoad = parentItemsMapToLoad.keySet();
            ArrayList newTemporaryList = new ArrayList(parentItemsToLoad);
            for (Object perentId : newTemporaryList) {
                if (featuresMapById.get(perentId) == null) continue;
                parentsMapById.put((String)perentId, featuresMapById.get(perentId));
                parentItemsMapToLoad.remove(perentId);
            }
            parentItemsToLoad = parentItemsMapToLoad.keySet();
            if (PropertyValidator.isValid(parentItemsToLoad)) {
                Object perentId;
                List parents = this.itemRepository.findByIdIn(parentItemsToLoad);
                perentId = parents.iterator();
                while (perentId.hasNext()) {
                    Item parent = (Item)perentId.next();
                    parentsMapById.put(parent.getId(), parent);
                }
            }
            ArrayList<Item> itemsToSave = new ArrayList<Item>();
            ArrayList<TeamContainer> teamContainersToSave = new ArrayList<TeamContainer>();
            String tfsItemIdsStr = String.join((CharSequence)",", subSetOfTfsItems);
            String tsfItemsStr = null;
            try {
                Set keys;
                List itemLinks;
                tsfItemsStr = this.tfsUtils.getItems("1", tfsItemIdsStr, almAccount);
                JSONObject tfsItemsJSON = new JSONObject(tsfItemsStr);
                JSONArray tfsItemsJSONArray = tfsItemsJSON.getJSONArray("value");
                for (int i = 0; i < tfsItemsJSONArray.length(); ++i) {
                    JSONObject itemObject = tfsItemsJSONArray.getJSONObject(i);
                    JSONObject tfsFields = itemObject.getJSONObject("fields");
                    String itemTfsId = itemObject.getString("id");
                    String iterationPath = (String)tfsFields.get("System.IterationPath");
                    String areaPath = (String)tfsFields.get("System.AreaPath");
                    HashMap<String, Object> extraFields = new HashMap<String, Object>();
                    extraFields.put("statusMap", statusMapByKey);
                    Item kendisItem = (Item)itemsMapByTfsId.get(itemTfsId);
                    if (!PropertyValidator.isValid((Object)kendisItem)) continue;
                    boolean areaPathChanged = false;
                    boolean iterationPathChanged = false;
                    boolean needToCheckTeamContainer = false;
                    boolean isFeature = false;
                    if (kendisItem.getType().equals(Item.FEATURE)) {
                        extraFields.put("type", Item.FEATURE);
                        isFeature = true;
                    } else {
                        extraFields.put("type", Item.USER_STORY);
                        if (!PropertyValidator.isValid((Object)kendisItem.getTfsAreaPath()) || !kendisItem.getTfsAreaPath().equals(areaPath)) {
                            areaPathChanged = true;
                        }
                        if (!PropertyValidator.isValid((Object)kendisItem.getTfsIterationPath()) || !kendisItem.getTfsIterationPath().equals(iterationPath)) {
                            iterationPathChanged = true;
                        }
                        if (areaPathChanged || iterationPathChanged) {
                            needToCheckTeamContainer = true;
                        }
                    }
                    Status oldStatus = kendisItem.getStatus();
                    this.getKendisItemFromTFSItem(session, kendisItem, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                    Status newStatus = kendisItem.getStatus();
                    if (!(PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)newStatus) && oldStatus.getCategory().equals(newStatus.getCategory()))) {
                        if (isFeature) {
                            if (PropertyValidator.isValid((Object)newStatus) && PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                                if (autoCloseItemDependency && newStatus.getCategory().equals("Done")) {
                                    autoCloseLinksOfItemIds.add(kendisItem.getId());
                                    for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                        autoCloseLinksOfItems.add(tc.getId());
                                    }
                                }
                                if (autoOpenItemDependency && !newStatus.getCategory().equals("Done")) {
                                    autoOpenLinksOfItemIds.add(kendisItem.getId());
                                    for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                        autoOpenLinksOfItems.add(tc.getId());
                                    }
                                }
                            }
                        } else if (PropertyValidator.isValid((Object)newStatus) && PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                            if (autoCloseSubItemDependency && newStatus.getCategory().equals("Done")) {
                                autoCloseLinksOfItemIds.add(kendisItem.getId());
                                for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                    autoCloseLinksOfSubItems.add(tc.getId());
                                }
                            }
                            if (autoCloseSubItemDependency && !newStatus.getCategory().equals("Done")) {
                                autoOpenLinksOfItemIds.add(kendisItem.getId());
                                for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                    autoOpenLinksOfSubItems.add(tc.getId());
                                }
                            }
                        }
                    }
                    if (!isFeature && needToCheckTeamContainer) {
                        TeamContainer oldTeamContainer = null;
                        if (PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                            oldTeamContainer = (TeamContainer)kendisItem.getTeamContainers().get(0);
                        }
                        Item parentItem = (Item)parentsMapById.get(kendisItem.getParent().getId());
                        HashMap matchingItemSyncMappersResult = this.findMatchingItemSyncMappersOfItem(kendisItem, parentItem, session, iterationPath, areaPath, syncMappersMapByTeamSrintId, syncMappersMapByIterationPath, tfsTeamMappingMapByTeamId);
                        boolean oldSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("oldSubItemMappingFound");
                        boolean newSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("newSubItemMappingFound");
                        TeamContainer newTeamContainer = (TeamContainer)matchingItemSyncMappersResult.get("teamContainer");
                        if (newSubItemMappingFound && newTeamContainer.getId() == null) {
                            newTeamContainer.setId(ObjectId.get().toString());
                            teamContainersToSave.add(newTeamContainer);
                            if (duplicationCheckMap.get(parentItem.getId()) == null) {
                                duplicationCheckMap.put(parentItem.getId(), parentItem.getId());
                                itemsToSave.add(parentItem);
                            }
                        }
                        if (!oldSubItemMappingFound && !newSubItemMappingFound && oldTeamContainer != null) {
                            kendisItem.setTeamContainers(new ArrayList());
                            kendisItem.getTeamContainers().add(oldTeamContainer);
                        }
                        if (PropertyValidator.isValid((Object)oldTeamContainer) && PropertyValidator.isValid((Object)newTeamContainer) && !oldTeamContainer.getId().equals(newTeamContainer.getId())) {
                            teamContainerChangeMap.put(oldTeamContainer.getId(), newTeamContainer.getId());
                        }
                    }
                    itemsToSave.add(kendisItem);
                    duplicationCheckMap.put(kendisItem.getId(), kendisItem.getId());
                }
                if (PropertyValidator.isValid((Collection)existingItems)) {
                    this.teamContainerRepository.save(teamContainersToSave);
                }
                this.itemRepository.save(itemsToSave);
                if (!teamContainerChangeMap.isEmpty() && PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(keys = teamContainerChangeMap.keySet(), keys)))) {
                    for (ItemLink link : itemLinks) {
                        if (teamContainerChangeMap.containsKey(link.getSourceTeamContainerId())) {
                            link.setSourceTeamContainerId((String)teamContainerChangeMap.get(link.getSourceTeamContainerId()));
                        }
                        if (!teamContainerChangeMap.containsKey(link.getTargetTeamContainerId())) continue;
                        link.setTargetTeamContainerId((String)teamContainerChangeMap.get(link.getTargetTeamContainerId()));
                    }
                    this.itemLinkRepository.save((Iterable)itemLinks);
                }
                session.setLastChangesSyncTime(new Date());
                this.sessionRepository.save((Object)session);
            }
            catch (ViztrendJiraException vje) {
                LOGGER.error(StringUtils.getTraceString((Throwable)vje));
                break;
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                break;
            }
        }
        this.autoOpenCloseItemLinks(session, autoCloseLinksOfItems, autoCloseLinksOfSubItems, autoOpenLinksOfItems, autoOpenLinksOfSubItems, autoCloseLinksOfItemIds, autoOpenLinksOfItemIds);
        return null;
    }

    private boolean isItemValidToAddForSession(Item item, Session session) throws Exception {
        if (PropertyValidator.isValid((Collection)session.getExcludeTfsStatuses()) && PropertyValidator.isValid((Object)item.getStatus()) && session.getExcludeTfsStatuses().contains(item.getStatus().getTitle())) {
            return false;
        }
        return !PropertyValidator.isValid((Collection)session.getExcludeTfsItemTypes()) || !PropertyValidator.isValid((Object)item.getTfsItemType()) || !session.getExcludeTfsItemTypes().contains(item.getTfsItemType());
    }

    public HashMap<String, Object> fetchUpdatedTFSItems(String sessionBoardId, AlmAccount almAccount, HashMap<String, Object> params) throws Exception {
        HashMap<String, String> newProjects;
        HashMap<String, String> ro_validChildMap;
        HashMap<String, String> ro_validParentMap;
        HashMap<String, String> ro_updatedOrNewChildMap;
        HashMap<String, String> ro_updatedOrNewParentMap;
        ArrayList<String> ro_childrenRemoved;
        ArrayList<HashMap> ro_parentRemoved;
        ArrayList<String> ro_childrenAdded;
        ArrayList<HashMap> ro_parentAdded;
        String resyncProcessId;
        String syncId;
        Gson gson;
        boolean isProcessFailed;
        boolean isReadOnly;
        TFSFilter filter;
        block195: {
            Set parentIdsToRemoved;
            HashMap<String, Item> parentIdsToRemovedMap;
            block194: {
                Iterator keys;
                List itemLinks;
                filter = (TFSFilter)params.get("filter");
                SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                Session session = sessionBoard.getSession();
                isReadOnly = false;
                if (params.containsKey("isReadOnly")) {
                    isReadOnly = (Boolean)params.get("isReadOnly");
                }
                isProcessFailed = false;
                gson = new Gson();
                syncId = (String)params.get("syncId");
                resyncProcessId = (String)params.get("resyncProcessId");
                boolean ignoreSyncTime = false;
                if (params.containsKey("ignoreSyncTime") && params.get("ignoreSyncTime") != null) {
                    ignoreSyncTime = (Boolean)params.get("ignoreSyncTime");
                }
                List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(session.getId());
                HashMap<String, TFSProject> tfsProjectsMapById = new HashMap<String, TFSProject>();
                HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
                if (PropertyValidator.isValid((Collection)tfsProjects)) {
                    for (TFSProject tfsProject : tfsProjects) {
                        tfsProjectsMapById.put(tfsProject.getTfsId(), tfsProject);
                        tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
                    }
                }
                List statuses = this.statusRepository.findBySessionId(session.getId());
                HashMap statusMapByKey = this.getStatusesMap(statuses);
                List syncMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardId));
                HashMap<String, Object> syncMappersMapByTeamSrintId = new HashMap<String, Object>();
                HashMap<String, ArrayList<Object>> syncMappersMapByIterationPath = new HashMap<String, ArrayList<Object>>();
                if (PropertyValidator.isValid((Collection)syncMappers)) {
                    for (Object synMapper : syncMappers) {
                        if (PropertyValidator.isValid((Object)synMapper.getTfsSprint())) {
                            ArrayList<Object> sms = (ArrayList<Object>)syncMappersMapByIterationPath.get(synMapper.getTfsSprint().getIterationPath());
                            if (sms == null) {
                                sms = new ArrayList<Object>();
                                syncMappersMapByIterationPath.put(synMapper.getTfsSprint().getIterationPath(), sms);
                            }
                            sms.add(synMapper);
                        }
                        if (!PropertyValidator.isValid((Object)synMapper.getTeam()) || !PropertyValidator.isValid((Object)synMapper.getContainer())) continue;
                        String key = synMapper.getTeam().getId() + ":" + synMapper.getContainer().getId();
                        syncMappersMapByTeamSrintId.put(key, synMapper);
                    }
                }
                HashMap<String, TFSTeamMapping> tfsTeamMappingMapByTeamId = new HashMap<String, TFSTeamMapping>();
                if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)session.getTfsAlmConfigurations().getTeamMappings())) {
                    for (TFSTeamMapping mappedTeam : session.getTfsAlmConfigurations().getTeamMappings()) {
                        tfsTeamMappingMapByTeamId.put(mappedTeam.getKendisTeamId(), mappedTeam);
                    }
                }
                List tfsIds = null;
                if (PropertyValidator.isValid((Object)filter)) {
                    try {
                        tfsIds = this.getTfsItemsFromFilter(null, filter, almAccount);
                    }
                    catch (ViztrendJiraException vje) {
                        isProcessFailed = true;
                        LOGGER.error(StringUtils.getTraceString((Throwable)vje));
                        HashMap<String, ViztrendJiraException> exp = new HashMap<String, ViztrendJiraException>();
                        exp.put("kendisError", vje);
                        this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
                    }
                } else {
                    tfsIds = (List)params.get("ids");
                }
                if (PropertyValidator.isValid((Collection)tfsIds) && session.getIgnoreItemsInResync() != null && !session.getIgnoreItemsInResync().isEmpty()) {
                    tfsIds = tfsIds.stream().filter(_id -> session.getIgnoreItemsInResync().get(_id) == null).collect(Collectors.toList());
                }
                boolean autoCloseItemDependency = false;
                boolean autoCloseSubItemDependency = false;
                boolean autoOpenItemDependency = false;
                boolean autoOpenSubItemDependency = false;
                if (PropertyValidator.isValid((Object)session.getItemLinkStatusDependentOn()) && !session.getItemLinkStatusDependentOn().equals("-1")) {
                    autoCloseItemDependency = true;
                }
                if (PropertyValidator.isValid((Object)session.getSubItemLinkStatusDependentOn()) && !session.getSubItemLinkStatusDependentOn().equals("-1")) {
                    autoCloseSubItemDependency = true;
                }
                if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfItemReOpen())) {
                    autoOpenItemDependency = session.getReOpenDependencyIfItemReOpen();
                }
                if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfSubItemReOpen())) {
                    autoOpenSubItemDependency = session.getReOpenDependencyIfSubItemReOpen();
                }
                ArrayList<String> autoCloseLinksOfItems = null;
                ArrayList<String> autoCloseLinksOfSubItems = null;
                ArrayList<String> autoOpenLinksOfItems = null;
                ArrayList<String> autoOpenLinksOfSubItems = null;
                ArrayList<String> autoCloseLinksOfItemIds = null;
                ArrayList<String> autoOpenLinksOfItemIds = null;
                if (!isReadOnly) {
                    autoCloseLinksOfItems = new ArrayList<String>();
                    autoCloseLinksOfSubItems = new ArrayList<String>();
                    autoOpenLinksOfItems = new ArrayList<String>();
                    autoOpenLinksOfSubItems = new ArrayList<String>();
                    autoCloseLinksOfItemIds = new ArrayList<String>();
                    autoOpenLinksOfItemIds = new ArrayList<String>();
                }
                ro_parentAdded = null;
                ro_childrenAdded = null;
                ro_parentRemoved = null;
                ro_childrenRemoved = null;
                ro_updatedOrNewParentMap = null;
                ro_updatedOrNewChildMap = null;
                ro_validParentMap = null;
                ro_validChildMap = null;
                if (isReadOnly) {
                    ro_parentAdded = new ArrayList<HashMap>();
                    ro_childrenAdded = new ArrayList<String>();
                    ro_parentRemoved = new ArrayList<HashMap>();
                    ro_childrenRemoved = new ArrayList<String>();
                    ro_updatedOrNewParentMap = new HashMap<String, String>();
                    ro_updatedOrNewChildMap = new HashMap<String, String>();
                    ro_validParentMap = new HashMap<String, String>();
                    ro_validChildMap = new HashMap<String, String>();
                }
                Map checkedMapDontAddParents = null;
                Map checkedMapDeleteParents = null;
                Map rs_updatedOrNewParentMap = null;
                HashMap rs_updatedOrNewChildMap = null;
                Map rs_validParentMap = null;
                HashMap rs_validChildMap = null;
                HashMap<String, String> teamContainerChangeMap = new HashMap<String, String>();
                HashMap<String, String> kendisIdMapByTfsId = new HashMap<String, String>();
                ArrayList<ItemJiraDependency> jiraDependenciesToSave = new ArrayList<ItemJiraDependency>();
                newProjects = new HashMap<String, String>();
                ArrayList allChildren = new ArrayList();
                if (!isReadOnly) {
                    String cachedData;
                    String key;
                    checkedMapDontAddParents = new HashMap();
                    checkedMapDeleteParents = new HashMap();
                    if (params.containsKey("checkedIds")) {
                        Map checkedIds = (Map)params.get("checkedIds");
                        if (checkedIds.containsKey("addParent")) {
                            checkedMapDontAddParents = (Map)checkedIds.get("addParent");
                        }
                        if (checkedIds.containsKey("deleteParent")) {
                            checkedMapDeleteParents = (Map)checkedIds.get("deleteParent");
                        }
                    }
                    if (resyncProcessId != null && PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)(key = resyncProcessId + ":" + filter.getTfsId())) && PropertyValidator.isValid((Object)(cachedData = MongoSyncUtils.retrieveData((String)key, (AppConfig.MongoConfig)this.mongoConfig)))) {
                        MongoSyncUtils.removeData((String)key, (AppConfig.MongoConfig)this.mongoConfig);
                        try {
                            Map parsedData = (Map)new ObjectMapper().readValue(cachedData, HashMap.class);
                            if (PropertyValidator.isValid((Object)parsedData)) {
                                rs_updatedOrNewParentMap = (Map)parsedData.get("updatedOrNewParent");
                                rs_validParentMap = (Map)parsedData.get("validParentMap");
                            }
                        }
                        catch (JsonMappingException e) {
                            e.printStackTrace();
                        }
                        catch (JsonProcessingException e) {
                            e.printStackTrace();
                        }
                    }
                    if (rs_updatedOrNewParentMap == null) {
                        rs_updatedOrNewParentMap = new HashMap();
                    }
                    if (rs_updatedOrNewChildMap == null) {
                        rs_updatedOrNewChildMap = new HashMap();
                    }
                    if (rs_validParentMap == null) {
                        rs_validParentMap = new HashMap();
                    }
                    if (rs_validChildMap == null) {
                        rs_validChildMap = new HashMap();
                    }
                }
                parentIdsToRemovedMap = new HashMap<String, Item>();
                if (PropertyValidator.isValid((Object)filter)) {
                    List filterParents;
                    ArrayList<String> filterIds = new ArrayList<String>();
                    filterIds.add(filter.getTfsId());
                    if (PropertyValidator.isValid((Collection)filter.getOldTfsIds())) {
                        filterIds.addAll(filter.getOldTfsIds());
                    }
                    if (PropertyValidator.isValid((Collection)(filterParents = this.itemRepository.findIdBySessionBoardsIdInAndTfsFilterInAndType(sessionBoardId, filterIds, Item.FEATURE)))) {
                        for (Item parent : filterParents) {
                            if (isReadOnly) {
                                parentIdsToRemovedMap.put(parent.getId(), parent);
                                continue;
                            }
                            if (rs_validParentMap.containsKey(parent.getTfsId())) continue;
                            parentIdsToRemovedMap.put(parent.getId(), parent);
                        }
                    }
                }
                if (PropertyValidator.isValid(tfsIds)) {
                    List subSetsOfTfsItems = Lists.partition(new ArrayList(tfsIds), (int)100);
                    HashMap<String, Item> parentMapByChildId = new HashMap<String, Item>();
                    for (List subSetOfTfsItems : subSetsOfTfsItems) {
                        Set childIdsToRemoved;
                        String tfsItemIdsStr = null;
                        if (!isReadOnly && PropertyValidator.isValid((Object)filter)) {
                            ArrayList<String> itemIds = new ArrayList<String>();
                            for (String itemId : subSetOfTfsItems) {
                                if (!rs_updatedOrNewParentMap.containsKey(itemId)) continue;
                                itemIds.add(itemId);
                            }
                            if (!PropertyValidator.isValid(itemIds)) continue;
                            tfsItemIdsStr = String.join((CharSequence)",", itemIds);
                        } else {
                            tfsItemIdsStr = String.join((CharSequence)",", subSetOfTfsItems);
                        }
                        String tsfItemsStr = null;
                        try {
                            tsfItemsStr = this.tfsUtils.getItems("1", tfsItemIdsStr, almAccount);
                        }
                        catch (ViztrendJiraException vje) {
                            isProcessFailed = true;
                            LOGGER.error(StringUtils.getTraceString((Throwable)vje));
                            HashMap<String, ViztrendJiraException> exp = new HashMap<String, ViztrendJiraException>();
                            exp.put("kendisError", vje);
                            this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
                            continue;
                        }
                        JSONObject tfsItemsJSON = new JSONObject(tsfItemsStr);
                        JSONArray tfsItemsJSONArray = tfsItemsJSON.getJSONArray("value");
                        HashMap<String, Item> childIdsToRemovedMap = new HashMap<String, Item>();
                        List existingItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndParentIsNull(sessionBoardId, subSetOfTfsItems);
                        HashMap existingItemsMapByTfsId = new HashMap();
                        if (PropertyValidator.isValid((Collection)existingItems)) {
                            existingItems.forEach(item -> existingItemsMapByTfsId.put(item.getTfsId(), item));
                            List children = this.itemRepository.findIdBySessionBoardsIdInAndParentInAndTfsIdNotNull(sessionBoardId, existingItems);
                            HashMap<String, Item> dulicationCheckMap = new HashMap<String, Item>();
                            if (PropertyValidator.isValid((Collection)children)) {
                                for (Item child : children) {
                                    if (isReadOnly) {
                                        childIdsToRemovedMap.put(child.getId(), child);
                                        continue;
                                    }
                                    if (!dulicationCheckMap.containsKey(child.getTfsId())) {
                                        dulicationCheckMap.put(child.getTfsId(), child);
                                        if (rs_validChildMap.containsKey(child.getTfsId())) continue;
                                        childIdsToRemovedMap.put(child.getId(), child);
                                        continue;
                                    }
                                    childIdsToRemovedMap.put(child.getId(), child);
                                }
                            }
                        }
                        ArrayList<Item> parentItemsToSave = new ArrayList<Item>();
                        HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
                        ArrayList<String> parentsIdToFetchDetails = new ArrayList<String>();
                        HashMap itemsByParentIdMap = new HashMap();
                        for (int i = 0; i < tfsItemsJSONArray.length(); ++i) {
                            Boolean skipItem;
                            JSONObject itemObject = tfsItemsJSONArray.getJSONObject(i);
                            JSONObject tfsFields = itemObject.getJSONObject("fields");
                            String itemTfsId = itemObject.getString("id");
                            Item kendisItem = (Item)existingItemsMapByTfsId.get(itemTfsId);
                            boolean itemUpdated = false;
                            HashMap<String, Object> extraFields = new HashMap<String, Object>();
                            extraFields.put("statusMap", statusMapByKey);
                            extraFields.put("type", Item.FEATURE);
                            if (isReadOnly) {
                                ro_validParentMap.put(itemTfsId, itemTfsId);
                            }
                            if (PropertyValidator.isValid((Object)kendisItem)) {
                                List depRelations;
                                HashMap relationChangeResult;
                                if (parentIdsToRemovedMap.containsKey(kendisItem.getId())) {
                                    parentIdsToRemovedMap.remove(kendisItem.getId());
                                }
                                kendisIdMapByTfsId.put(kendisItem.getTfsId(), kendisItem.getId());
                                String changeDateStr = tfsFields.getString("System.ChangedDate");
                                Date changeDate = PropertyValidator.parseDate((String)changeDateStr, (String)"yyyy-MM-dd'T'HH:mm:ss");
                                boolean changeFound = false;
                                if (ignoreSyncTime || kendisItem.getLastSyncDate() == null || TFSserviceImpl.dateToUTC((Date)kendisItem.getLastSyncDate()).getTime() < changeDate.getTime()) {
                                    changeFound = true;
                                }
                                if (changeFound) {
                                    itemUpdated = true;
                                    Status oldStatus = kendisItem.getStatus();
                                    Map itemMap = this.getKendisItemFromTFSItem(session, kendisItem, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                                    if (session != null && session.getScoreCard() != null && session.getScoreCard().getMappings() != null) {
                                        this.addMappedTfsFieldsToItem(kendisItem, tfsFields, session.getScoreCard().getMappings());
                                        this.scoreCardService.updateScorecardFieldsAccordingToMappedFields(session, kendisItem, kendisItem.getTfsFieldByKey());
                                    }
                                    Status newStatus = kendisItem.getStatus();
                                    if (!(PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)newStatus) && oldStatus.getCategory().equals(newStatus.getCategory()) || isReadOnly || !PropertyValidator.isValid((Object)newStatus) || !PropertyValidator.isValid((Collection)kendisItem.getTeamContainers()))) {
                                        if (autoCloseItemDependency && newStatus.getCategory().equals("Done")) {
                                            autoCloseLinksOfItemIds.add(kendisItem.getId());
                                            for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                                autoCloseLinksOfItems.add(tc.getId());
                                            }
                                        }
                                        if (autoOpenItemDependency && !newStatus.getCategory().equals("Done")) {
                                            autoOpenLinksOfItemIds.add(kendisItem.getId());
                                            for (TeamContainer tc : kendisItem.getTeamContainers()) {
                                                autoOpenLinksOfItems.add(tc.getId());
                                            }
                                        }
                                    }
                                }
                                JSONArray relationsArray = null;
                                if (!itemObject.isNull("relations")) {
                                    relationsArray = itemObject.getJSONArray("relations");
                                }
                                Object childRelations = new ArrayList();
                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                    for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                        if (!kendisItem.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                        childRelations.addAll(backlogMappingLink.getLinkTypes());
                                        break;
                                    }
                                } else {
                                    childRelations = kendisItem.getTfsLinkTypes();
                                }
                                if (relationsArray != null) {
                                    for (int index = 0; index < relationsArray.length(); ++index) {
                                        JSONObject relationObject = relationsArray.getJSONObject(index);
                                        String rel = relationObject.getString("rel");
                                        String relURL = relationObject.getString("url");
                                        String itemId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                        if (childRelations == null || !childRelations.contains(rel)) continue;
                                        parentMapByChildId.put(itemId, kendisItem);
                                    }
                                }
                                if ((relationChangeResult = this.isRelationChanged(kendisItem, relationsArray, childRelations, depRelations = session.getJiraLinkTypes(), "System.LinkTypes.Hierarchy-Reverse", ignoreSyncTime)) != null) {
                                    ArrayList finalRelations = (ArrayList)relationChangeResult.get("final");
                                    ArrayList newParent = (ArrayList)relationChangeResult.get("newParent");
                                    ArrayList newChildren = (ArrayList)relationChangeResult.get("newChildren");
                                    ArrayList newDeps = (ArrayList)relationChangeResult.get("newDeps");
                                    ArrayList removedParent = (ArrayList)relationChangeResult.get("removedParent");
                                    ArrayList removedChildren = (ArrayList)relationChangeResult.get("removedChildren");
                                    ArrayList removedDeps = (ArrayList)relationChangeResult.get("removedDeps");
                                    if (PropertyValidator.isValid((Collection)removedDeps)) {
                                        Iterator removedDepsMap = new HashMap();
                                        for (Map relationMap : removedDeps) {
                                            String relation = (String)relationMap.get("rel");
                                            String itemId = (String)relationMap.get("id");
                                            String key = relation + ":" + itemId;
                                            ((HashMap)((Object)removedDepsMap)).put(key, relationMap);
                                        }
                                        if (PropertyValidator.isValid((Collection)kendisItem.getJiraDependencies())) {
                                            for (int ind = 0; ind < kendisItem.getJiraDependencies().size(); ++ind) {
                                                ItemJiraDependency dep = (ItemJiraDependency)kendisItem.getJiraDependencies().get(ind);
                                                if (PropertyValidator.isValid((Object)dep)) {
                                                    String key = dep.getTfsLinkType() + ":" + dep.getTargetTFSItem().getTfsId();
                                                    Map relationMap = (Map)((HashMap)((Object)removedDepsMap)).get(key);
                                                    if (relationMap == null) continue;
                                                    kendisItem.getJiraDependencies().remove(ind);
                                                    --ind;
                                                    continue;
                                                }
                                                kendisItem.getJiraDependencies().remove(ind);
                                                --ind;
                                            }
                                        }
                                    }
                                    if (PropertyValidator.isValid((Collection)newDeps)) {
                                        for (Map relationMap : newDeps) {
                                            String relUrl;
                                            String relation = (String)relationMap.get("rel");
                                            ItemJiraDependency newDep = this.createJirDepdency(kendisItem, relation, relUrl = (String)relationMap.get("relUrl"));
                                            if (newDep == null) continue;
                                            jiraDependenciesToSave.add(newDep);
                                            if (kendisItem.getJiraDependencies() == null) {
                                                kendisItem.setJiraDependencies(new ArrayList());
                                            }
                                            kendisItem.getJiraDependencies().add(newDep);
                                        }
                                    }
                                    if (PropertyValidator.isValid((Collection)removedChildren)) {
                                        // empty if block
                                    }
                                    if (PropertyValidator.isValid((Collection)newParent)) {
                                        for (Map relationMap : newParent) {
                                            List<Item> itemsList;
                                            String parentId = (String)relationMap.get("id");
                                            if (!PropertyValidator.isValid((Object)kendisItem.getTfsFieldByKey())) {
                                                kendisItem.setTfsFieldByKey(new HashMap());
                                            }
                                            kendisItem.getTfsFieldByKey().put("ParentId", parentId);
                                            if (!duplicationCheckMap.containsKey(parentId)) {
                                                parentsIdToFetchDetails.add(parentId);
                                            }
                                            if (!itemsByParentIdMap.containsKey(parentId)) {
                                                itemsList = new ArrayList();
                                                itemsByParentIdMap.put(parentId, itemsList);
                                            } else {
                                                itemsList = (List)itemsByParentIdMap.get(parentId);
                                            }
                                            itemsList.add(kendisItem);
                                        }
                                    }
                                    itemUpdated = true;
                                    kendisItem.setTfsRelations((List)finalRelations);
                                }
                                if (!itemUpdated) continue;
                                parentItemsToSave.add(kendisItem);
                                duplicationCheckMap.put(kendisItem.getId(), kendisItem.getId());
                                if (!isReadOnly) continue;
                                ro_updatedOrNewParentMap.put(kendisItem.getTfsId(), kendisItem.getTfsId());
                                continue;
                            }
                            if (!isReadOnly && checkedMapDontAddParents.containsKey(itemTfsId) && (skipItem = (Boolean)checkedMapDontAddParents.get(itemTfsId)).booleanValue()) continue;
                            Map itemMap = this.getKendisItemFromTFSItem(session, null, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                            Item newItem = null;
                            if (!itemMap.containsKey("item")) {
                                LOGGER.debug("Parent Item TFS Id : " + itemObject.getString("id") + " is skipped as board don't have Project : " + itemMap.get("project"));
                                continue;
                            }
                            newItem = (Item)itemMap.get("item");
                            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                    if (!newItem.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                    newItem.setTfsLinkTypes(backlogMappingLink.getLinkTypes());
                                    break;
                                }
                            }
                            if (isReadOnly && PropertyValidator.isValid((Object)newItem.getTfsProjectId()) && !PropertyValidator.isValid((Collection)newItem.getTfsLinkTypes())) {
                                newProjects.put(newItem.getTfsProjectId(), newItem.getTfsProject());
                            }
                            newItem.setType(Item.FEATURE);
                            newItem.setSessionBoards(new ArrayList());
                            newItem.getSessionBoards().add(new SessionBoard(sessionBoardId));
                            newItem.setTfsRelations(new ArrayList());
                            if (PropertyValidator.isValid((Object)filter)) {
                                newItem.setTfsFilter(filter.getTfsId());
                            }
                            if (isReadOnly) {
                                ro_parentAdded.add(newItem.toSimpleObject());
                                ro_updatedOrNewParentMap.put(newItem.getTfsId(), newItem.getTfsId());
                            }
                            kendisIdMapByTfsId.put(newItem.getTfsId(), newItem.getId());
                            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
                                newItem.setFetchedBy(filter.getFilterFetchedBy());
                            } else {
                                newItem.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                            }
                            JSONArray relationsArray = null;
                            if (!itemObject.isNull("relations")) {
                                relationsArray = itemObject.getJSONArray("relations");
                            }
                            if (PropertyValidator.isValid(relationsArray)) {
                                ArrayList childRelations = new ArrayList();
                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                    for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                        if (!newItem.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                        childRelations.addAll(backlogMappingLink.getLinkTypes());
                                        break;
                                    }
                                }
                                List depRelations = session.getJiraLinkTypes();
                                String parentRelation = "System.LinkTypes.Hierarchy-Reverse";
                                if (relationsArray != null) {
                                    for (int ind = 0; ind < relationsArray.length(); ++ind) {
                                        List<Item> itemsList;
                                        ItemJiraDependency newDep;
                                        JSONObject relationObject = relationsArray.getJSONObject(ind);
                                        String rel = relationObject.getString("rel");
                                        String relURL = relationObject.getString("url");
                                        String itemId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                        if (childRelations.contains(rel)) {
                                            parentMapByChildId.put(itemId, newItem);
                                            newItem.getTfsRelations().add(this.relationToMap(rel, itemId, relURL));
                                        }
                                        if (PropertyValidator.isValid((Collection)depRelations) && depRelations.contains(rel) && (newDep = this.createJirDepdency(newItem, rel, relURL)) != null) {
                                            jiraDependenciesToSave.add(newDep);
                                            if (newItem.getJiraDependencies() == null) {
                                                newItem.setJiraDependencies(new ArrayList());
                                            }
                                            newItem.getJiraDependencies().add(newDep);
                                            newItem.getTfsRelations().add(this.relationToMap(rel, itemId, relURL));
                                        }
                                        if (!rel.equals(parentRelation)) continue;
                                        if (!PropertyValidator.isValid((Object)newItem.getTfsFieldByKey())) {
                                            newItem.setTfsFieldByKey(new HashMap());
                                        }
                                        newItem.getTfsFieldByKey().put("ParentId", itemId);
                                        if (!duplicationCheckMap.containsKey(itemId)) {
                                            parentsIdToFetchDetails.add(itemId);
                                        }
                                        if (!itemsByParentIdMap.containsKey(itemId)) {
                                            itemsList = new ArrayList();
                                            itemsByParentIdMap.put(itemId, itemsList);
                                        } else {
                                            itemsList = (List)itemsByParentIdMap.get(itemId);
                                        }
                                        itemsList.add(newItem);
                                        newItem.getTfsRelations().add(this.relationToMap(rel, itemId, relURL));
                                    }
                                }
                            }
                            parentItemsToSave.add(newItem);
                            duplicationCheckMap.put(newItem.getId(), newItem.getId());
                        }
                        if (!isReadOnly && PropertyValidator.isValid(parentsIdToFetchDetails)) {
                            try {
                                String idsChildStr = String.join((CharSequence)",", parentsIdToFetchDetails);
                                String childItemsStr = this.tfsUtils.getItems("1", idsChildStr, almAccount);
                                JSONObject _dataObjects = new JSONObject(childItemsStr);
                                String _count = _dataObjects.getString("count");
                                JSONArray _itemsArray = _dataObjects.getJSONArray("value");
                                for (int i = 0; i < _itemsArray.length(); ++i) {
                                    JSONObject itemObject = _itemsArray.getJSONObject(i);
                                    JSONObject tfsFields = itemObject.getJSONObject("fields");
                                    String tfsId = itemObject.getString("id");
                                    String title = (String)tfsFields.get("System.Title");
                                    String workItemType = (String)tfsFields.get("System.WorkItemType");
                                    String url = null;
                                    if (!itemObject.isNull("_links")) {
                                        JSONObject links = itemObject.getJSONObject("_links");
                                        JSONObject linkHTML = links.getJSONObject("html");
                                        url = linkHTML.getString("href");
                                    }
                                    List _featureItems = (List)itemsByParentIdMap.get(tfsId);
                                    for (Item fItem : _featureItems) {
                                        TFSProject tfsProject;
                                        if (!PropertyValidator.isValid((Object)fItem.getTfsFieldByKey())) {
                                            fItem.setTfsFieldByKey(new HashMap());
                                        }
                                        if (PropertyValidator.isValid((Object)(tfsProject = (TFSProject)tfsProjectsMapById.get(fItem.getTfsProjectId()))) && PropertyValidator.isValid((Object)tfsProject.getIconByItemType())) {
                                            String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                                            fItem.getTfsFieldByKey().put("ParentIcon", itemTypeIconUrl);
                                        }
                                        fItem.getTfsFieldByKey().put("ParentTitle", title);
                                        fItem.getTfsFieldByKey().put("ParentURL", url);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.error("Exception while fetching parent :: " + StringUtils.getTraceString((Throwable)ex));
                            }
                        }
                        if (!parentMapByChildId.isEmpty()) {
                            Set allChildrenIds = parentMapByChildId.keySet();
                            List subSetsChildrenIds = Lists.partition(new ArrayList(allChildrenIds), (int)100);
                            for (List subSetChildrenIds : subSetsChildrenIds) {
                                if (session.getIgnoreItemsInResync() != null && !session.getIgnoreItemsInResync().isEmpty()) {
                                    subSetChildrenIds = subSetChildrenIds.stream().filter(_id -> session.getIgnoreItemsInResync().get(_id) == null).collect(Collectors.toList());
                                }
                                String tfsChildrenIdsStr = null;
                                if (!isReadOnly && PropertyValidator.isValid((Object)filter)) {
                                    ArrayList<String> itemIds = new ArrayList<String>();
                                    for (String itemId : subSetChildrenIds) {
                                        itemIds.add(itemId);
                                    }
                                    if (!PropertyValidator.isValid(itemIds)) continue;
                                    tfsChildrenIdsStr = String.join((CharSequence)",", itemIds);
                                } else {
                                    tfsChildrenIdsStr = String.join((CharSequence)",", subSetChildrenIds);
                                }
                                String tsfChildItemsStr = null;
                                try {
                                    tsfChildItemsStr = this.tfsUtils.getItems("1", tfsChildrenIdsStr, almAccount);
                                }
                                catch (ViztrendJiraException vje) {
                                    isProcessFailed = true;
                                    LOGGER.error(StringUtils.getTraceString((Throwable)vje));
                                    HashMap<String, ViztrendJiraException> exp = new HashMap<String, ViztrendJiraException>();
                                    exp.put("kendisError", vje);
                                    this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
                                    break;
                                }
                                JSONObject tfsChildItemsJSON = new JSONObject(tsfChildItemsStr);
                                JSONArray tfsChildItemsJSONArray = tfsChildItemsJSON.getJSONArray("value");
                                List existingChildren = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndType(sessionBoardId, subSetChildrenIds, Item.USER_STORY);
                                HashMap existingChildrenMapByTfsId = new HashMap();
                                if (PropertyValidator.isValid((Collection)existingChildren)) {
                                    existingChildren.forEach(item -> {
                                        if (!existingChildrenMapByTfsId.containsKey(item.getTfsId())) {
                                            existingChildrenMapByTfsId.put(item.getTfsId(), item);
                                        }
                                        allChildren.add(item);
                                    });
                                }
                                ArrayList<Item> childrenItemsToSave = new ArrayList<Item>();
                                ArrayList<TeamContainer> teamContainersToSave = new ArrayList<TeamContainer>();
                                for (int i = 0; i < tfsChildItemsJSONArray.length(); ++i) {
                                    JSONObject itemObject = tfsChildItemsJSONArray.getJSONObject(i);
                                    JSONObject tfsFields = itemObject.getJSONObject("fields");
                                    String itemTfsId = itemObject.getString("id");
                                    String iterationPath = (String)tfsFields.get("System.IterationPath");
                                    String areaPath = (String)tfsFields.get("System.AreaPath");
                                    Item kendisChild = (Item)existingChildrenMapByTfsId.get(itemTfsId);
                                    HashMap<String, Object> extraFields = new HashMap<String, Object>();
                                    extraFields.put("statusMap", statusMapByKey);
                                    extraFields.put("type", Item.USER_STORY);
                                    boolean itemUpdated = false;
                                    if (isReadOnly) {
                                        ro_validChildMap.put(itemTfsId, itemTfsId);
                                    }
                                    if (kendisChild != null) {
                                        List depRelations;
                                        HashMap relationChangeResult;
                                        boolean isValid = false;
                                        try {
                                            isValid = this.isItemValidToAddForSession(kendisChild, session);
                                        }
                                        catch (Exception e) {
                                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                        }
                                        if (!isValid) continue;
                                        if (childIdsToRemovedMap.containsKey(kendisChild.getId())) {
                                            childIdsToRemovedMap.remove(kendisChild.getId());
                                        }
                                        kendisIdMapByTfsId.put(kendisChild.getTfsId(), kendisChild.getId());
                                        String changeDateStr = tfsFields.getString("System.ChangedDate");
                                        Date changeDate = PropertyValidator.parseDate((String)changeDateStr, (String)"yyyy-MM-dd'T'HH:mm:ss");
                                        boolean needToCheckTeamContainer = false;
                                        if (ignoreSyncTime) {
                                            needToCheckTeamContainer = true;
                                        }
                                        boolean changeFound = false;
                                        if (ignoreSyncTime || kendisChild.getLastSyncDate() == null || TFSserviceImpl.dateToUTC((Date)kendisChild.getLastSyncDate()).getTime() < changeDate.getTime()) {
                                            changeFound = true;
                                        }
                                        if (changeFound) {
                                            itemUpdated = true;
                                            boolean areaPathChanged = false;
                                            boolean iterationPathChanged = false;
                                            if (!PropertyValidator.isValid((Object)kendisChild.getTfsAreaPath()) || !kendisChild.getTfsAreaPath().equals(areaPath)) {
                                                areaPathChanged = true;
                                            }
                                            if (!PropertyValidator.isValid((Object)kendisChild.getTfsIterationPath()) || !kendisChild.getTfsIterationPath().equals(iterationPath)) {
                                                iterationPathChanged = true;
                                            }
                                            if (areaPathChanged || iterationPathChanged) {
                                                needToCheckTeamContainer = true;
                                            }
                                            Status oldStatus = kendisChild.getStatus();
                                            Map itemMap = this.getKendisItemFromTFSItem(session, kendisChild, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                                            Item newItem = null;
                                            if (!itemMap.containsKey("item")) continue;
                                            newItem = (Item)itemMap.get("item");
                                            Status newStatus = kendisChild.getStatus();
                                            if (!(PropertyValidator.isValid((Object)oldStatus) && PropertyValidator.isValid((Object)newStatus) && oldStatus.getCategory().equals(newStatus.getCategory()) || isReadOnly || !PropertyValidator.isValid((Object)newStatus) || !PropertyValidator.isValid((Collection)kendisChild.getTeamContainers()))) {
                                                if (autoCloseSubItemDependency && newStatus.getCategory().equals("Done")) {
                                                    autoCloseLinksOfItemIds.add(kendisChild.getId());
                                                    for (TeamContainer tc : kendisChild.getTeamContainers()) {
                                                        autoCloseLinksOfSubItems.add(tc.getId());
                                                    }
                                                }
                                                if (autoOpenSubItemDependency && !newStatus.getCategory().equals("Done")) {
                                                    autoOpenLinksOfItemIds.add(kendisChild.getId());
                                                    for (TeamContainer tc : kendisChild.getTeamContainers()) {
                                                        autoOpenLinksOfSubItems.add(tc.getId());
                                                    }
                                                }
                                            }
                                        }
                                        JSONArray relationsArray = null;
                                        if (!itemObject.isNull("relations")) {
                                            relationsArray = itemObject.getJSONArray("relations");
                                        }
                                        if ((relationChangeResult = this.isRelationChanged(kendisChild, relationsArray, null, depRelations = session.getJiraLinkTypes(), null, ignoreSyncTime)) != null) {
                                            ArrayList finalRelations = (ArrayList)relationChangeResult.get("final");
                                            ArrayList newDeps = (ArrayList)relationChangeResult.get("newDeps");
                                            ArrayList removedDeps = (ArrayList)relationChangeResult.get("removedDeps");
                                            if (PropertyValidator.isValid((Collection)removedDeps)) {
                                                TeamContainer tc;
                                                HashMap removedDepsMap = new HashMap();
                                                tc = removedDeps.iterator();
                                                while (tc.hasNext()) {
                                                    Map relationMap = (Map)tc.next();
                                                    String relation = (String)relationMap.get("rel");
                                                    String itemId = (String)relationMap.get("id");
                                                    String key = relation + ":" + itemId;
                                                    removedDepsMap.put(key, relationMap);
                                                }
                                                if (PropertyValidator.isValid((Collection)kendisChild.getJiraDependencies())) {
                                                    for (int ind = 0; ind < kendisChild.getJiraDependencies().size(); ++ind) {
                                                        ItemJiraDependency dep = (ItemJiraDependency)kendisChild.getJiraDependencies().get(ind);
                                                        if (PropertyValidator.isValid((Object)dep)) {
                                                            String key = dep.getTfsLinkType() + ":" + dep.getTargetTFSItem().getTfsId();
                                                            Map relationMap = (Map)removedDepsMap.get(key);
                                                            if (relationMap == null) continue;
                                                            kendisChild.getJiraDependencies().remove(ind);
                                                            --ind;
                                                            continue;
                                                        }
                                                        kendisChild.getJiraDependencies().remove(ind);
                                                        --ind;
                                                    }
                                                }
                                            }
                                            if (PropertyValidator.isValid((Collection)newDeps)) {
                                                for (Map relationMap : newDeps) {
                                                    String relUrl;
                                                    String relation = (String)relationMap.get("rel");
                                                    ItemJiraDependency newDep = this.createJirDepdency(kendisChild, relation, relUrl = (String)relationMap.get("relUrl"));
                                                    if (newDep == null) continue;
                                                    jiraDependenciesToSave.add(newDep);
                                                    if (kendisChild.getJiraDependencies() == null) {
                                                        kendisChild.setJiraDependencies(new ArrayList());
                                                    }
                                                    kendisChild.getJiraDependencies().add(newDep);
                                                }
                                            }
                                            itemUpdated = true;
                                            kendisChild.setTfsRelations((List)finalRelations);
                                        }
                                        Item parentItem = (Item)parentMapByChildId.get(kendisChild.getTfsId());
                                        if (childIdsToRemovedMap.containsKey(kendisChild.getTfsId())) {
                                            childIdsToRemovedMap.remove(kendisChild.getTfsId());
                                        }
                                        if (PropertyValidator.isValid((Object)parentItem) && (kendisChild.getParent() == null || kendisChild.getParent().getId() == null || !kendisChild.getParent().getId().equals(parentItem.getId()))) {
                                            itemUpdated = true;
                                            kendisChild.setParent(new Item(parentItem.getId()));
                                            needToCheckTeamContainer = true;
                                        }
                                        if (needToCheckTeamContainer) {
                                            TeamContainer oldTeamContainer = null;
                                            if (PropertyValidator.isValid((Collection)kendisChild.getTeamContainers())) {
                                                oldTeamContainer = (TeamContainer)kendisChild.getTeamContainers().get(0);
                                            }
                                            HashMap matchingItemSyncMappersResult = this.findMatchingItemSyncMappersOfItem(kendisChild, parentItem, session, iterationPath, areaPath, syncMappersMapByTeamSrintId, syncMappersMapByIterationPath, tfsTeamMappingMapByTeamId);
                                            boolean oldSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("oldSubItemMappingFound");
                                            boolean newSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("newSubItemMappingFound");
                                            TeamContainer newTeamContainer = (TeamContainer)matchingItemSyncMappersResult.get("teamContainer");
                                            if (newSubItemMappingFound && newTeamContainer.getId() == null) {
                                                newTeamContainer.setId(ObjectId.get().toString());
                                                teamContainersToSave.add(newTeamContainer);
                                                if (duplicationCheckMap.get(parentItem.getId()) == null) {
                                                    duplicationCheckMap.put(parentItem.getId(), parentItem.getId());
                                                    parentItemsToSave.add(parentItem);
                                                }
                                            }
                                            if (!oldSubItemMappingFound && !newSubItemMappingFound && oldTeamContainer != null) {
                                                kendisChild.setTeamContainers(new ArrayList());
                                                kendisChild.getTeamContainers().add(oldTeamContainer);
                                            }
                                            if (PropertyValidator.isValid((Object)oldTeamContainer) && PropertyValidator.isValid((Object)newTeamContainer) && !oldTeamContainer.getId().equals(newTeamContainer.getId()) && !isReadOnly) {
                                                teamContainerChangeMap.put(oldTeamContainer.getId(), newTeamContainer.getId());
                                            }
                                        }
                                        if (!itemUpdated) continue;
                                        childrenItemsToSave.add(kendisChild);
                                        if (!isReadOnly) continue;
                                        ro_updatedOrNewChildMap.put(kendisChild.getTfsId(), kendisChild.getTfsId());
                                        ro_updatedOrNewParentMap.put(parentItem.getTfsId(), parentItem.getTfsId());
                                        continue;
                                    }
                                    Map itemMap = this.getKendisItemFromTFSItem(session, null, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                                    Item newItem = null;
                                    if (!itemMap.containsKey("item")) {
                                        LOGGER.debug("Child Item TFS Id : " + itemObject.getString("id") + " is skipped as board don't have Project : " + itemMap.get("project"));
                                        continue;
                                    }
                                    newItem = (Item)itemMap.get("item");
                                    boolean isValid = false;
                                    try {
                                        isValid = this.isItemValidToAddForSession(newItem, session);
                                    }
                                    catch (Exception e) {
                                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                    }
                                    if (!isValid) continue;
                                    newItem.setType(Item.USER_STORY);
                                    newItem.setSessionBoards(new ArrayList());
                                    newItem.getSessionBoards().add(new SessionBoard(sessionBoardId));
                                    newItem.setTfsRelations(new ArrayList());
                                    if (PropertyValidator.isValid((Object)filter)) {
                                        newItem.setTfsFilter(filter.getTfsId());
                                    }
                                    if (isReadOnly) {
                                        ro_childrenAdded.add(newItem.getTfsId());
                                        ro_updatedOrNewChildMap.put(newItem.getTfsId(), newItem.getTfsId());
                                    }
                                    kendisIdMapByTfsId.put(newItem.getTfsId(), newItem.getId());
                                    if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
                                        newItem.setFetchedBy(filter.getFilterFetchedBy());
                                    } else {
                                        newItem.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                                    }
                                    JSONArray relationsArray = null;
                                    if (!itemObject.isNull("relations")) {
                                        relationsArray = itemObject.getJSONArray("relations");
                                    }
                                    if (PropertyValidator.isValid(relationsArray)) {
                                        List depRelations = session.getJiraLinkTypes();
                                        if (relationsArray != null) {
                                            for (int ind = 0; ind < relationsArray.length(); ++ind) {
                                                ItemJiraDependency newDep;
                                                JSONObject relationObject = relationsArray.getJSONObject(ind);
                                                String rel = relationObject.getString("rel");
                                                String relURL = relationObject.getString("url");
                                                String itemId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                                if (!PropertyValidator.isValid((Collection)depRelations) || !depRelations.contains(rel) || (newDep = this.createJirDepdency(newItem, rel, relURL)) == null) continue;
                                                jiraDependenciesToSave.add(newDep);
                                                if (newItem.getJiraDependencies() == null) {
                                                    newItem.setJiraDependencies(new ArrayList());
                                                }
                                                newItem.getJiraDependencies().add(newDep);
                                                newItem.getTfsRelations().add(this.relationToMap(rel, itemId, relURL));
                                            }
                                        }
                                    }
                                    Item parentItem = (Item)parentMapByChildId.get(newItem.getTfsId());
                                    newItem.setParent(new Item(parentItem.getId()));
                                    if (isReadOnly) {
                                        ro_updatedOrNewParentMap.put(parentItem.getTfsId(), parentItem.getTfsId());
                                    }
                                    HashMap matchingItemSyncMappersResult = this.findMatchingItemSyncMappersOfItem(newItem, parentItem, session, iterationPath, areaPath, syncMappersMapByTeamSrintId, syncMappersMapByIterationPath, tfsTeamMappingMapByTeamId);
                                    boolean newSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("newSubItemMappingFound");
                                    TeamContainer newTeamContainer = (TeamContainer)matchingItemSyncMappersResult.get("teamContainer");
                                    if (newSubItemMappingFound && newTeamContainer.getId() == null) {
                                        newTeamContainer.setId(ObjectId.get().toString());
                                        teamContainersToSave.add(newTeamContainer);
                                        if (duplicationCheckMap.get(parentItem.getId()) == null) {
                                            duplicationCheckMap.put(parentItem.getId(), parentItem.getId());
                                            parentItemsToSave.add(parentItem);
                                        }
                                    }
                                    childrenItemsToSave.add(newItem);
                                }
                                if (isReadOnly || isProcessFailed) continue;
                                if (PropertyValidator.isValid(teamContainersToSave)) {
                                    this.teamContainerRepository.save(teamContainersToSave);
                                }
                                if (!PropertyValidator.isValid(childrenItemsToSave)) continue;
                                this.itemRepository.save(childrenItemsToSave);
                                this.customRepositoryImpl.bulkLogs(sessionBoardId, null, childrenItemsToSave, null, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                            }
                        }
                        if (!isReadOnly && !isProcessFailed) {
                            if (PropertyValidator.isValid(parentItemsToSave)) {
                                this.itemRepository.save(parentItemsToSave);
                                this.customRepositoryImpl.bulkLogs(sessionBoardId, parentItemsToSave, null, null, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                            }
                            if (!PropertyValidator.isValid(childIdsToRemoved = childIdsToRemovedMap.keySet())) continue;
                            List _storiesDeleted = this.itemRepository.deleteByIdIn(childIdsToRemoved);
                            this.customRepositoryImpl.bulkLogs2(sessionBoardId, null, null, _storiesDeleted, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                            continue;
                        }
                        childIdsToRemoved = childIdsToRemovedMap.keySet();
                        for (String key : childIdsToRemoved) {
                            ro_childrenRemoved.add(((Item)childIdsToRemovedMap.get(key)).getTfsId());
                        }
                    }
                }
                if (isReadOnly) break block194;
                if (isProcessFailed) break block195;
                parentIdsToRemoved = parentIdsToRemovedMap.keySet();
                if (PropertyValidator.isValid(parentIdsToRemoved)) {
                    HashSet newTempSet = new HashSet(parentIdsToRemoved);
                    for (Object key : newTempSet) {
                        Item item2 = (Item)parentIdsToRemovedMap.get(key);
                        if (!PropertyValidator.isValid(checkedMapDeleteParents) || checkedMapDeleteParents.containsKey(item2.getTfsId())) continue;
                        parentIdsToRemovedMap.remove(key);
                    }
                }
                if (PropertyValidator.isValid(parentIdsToRemoved = parentIdsToRemovedMap.keySet())) {
                    List _featuresDeleted = this.itemRepository.deleteByIdIn(parentIdsToRemoved);
                    List _storiesDeleted = this.itemRepository.deleteBySessionBoardsIdInAndParent_IdIn(sessionBoardId, parentIdsToRemoved);
                    this.customRepositoryImpl.bulkLogs2(sessionBoardId, null, null, _featuresDeleted, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                    this.customRepositoryImpl.bulkLogs2(sessionBoardId, null, null, _storiesDeleted, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                }
                this.autoOpenCloseItemLinks(session, autoCloseLinksOfItems, autoCloseLinksOfSubItems, autoOpenLinksOfItems, autoOpenLinksOfSubItems, autoCloseLinksOfItemIds, autoOpenLinksOfItemIds);
                if (!teamContainerChangeMap.isEmpty() && PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(keys = teamContainerChangeMap.keySet(), keys)))) {
                    for (ItemLink link : itemLinks) {
                        if (teamContainerChangeMap.containsKey(link.getSourceTeamContainerId())) {
                            link.setSourceTeamContainerId((String)teamContainerChangeMap.get(link.getSourceTeamContainerId()));
                        }
                        if (!teamContainerChangeMap.containsKey(link.getTargetTeamContainerId())) continue;
                        link.setTargetTeamContainerId((String)teamContainerChangeMap.get(link.getTargetTeamContainerId()));
                    }
                    this.itemLinkRepository.save((Iterable)itemLinks);
                }
                if (!PropertyValidator.isValid(jiraDependenciesToSave)) break block195;
                for (ItemJiraDependency link : jiraDependenciesToSave) {
                    if (!kendisIdMapByTfsId.containsKey(link.getTargetTFSItem().getTfsId())) continue;
                    link.setTargetItemId((String)kendisIdMapByTfsId.get(link.getTargetTFSItem().getTfsId()));
                }
                this.itemJiraDependencyRepository.save(jiraDependenciesToSave);
                break block195;
            }
            parentIdsToRemoved = parentIdsToRemovedMap.keySet();
            for (String key : parentIdsToRemoved) {
                ro_parentRemoved.add(((Item)parentIdsToRemovedMap.get(key)).toSimpleObject());
            }
        }
        if (isReadOnly && !isProcessFailed) {
            if (PropertyValidator.isValid((Object)resyncProcessId) && PropertyValidator.isValid((Object)filter)) {
                String key = resyncProcessId + ":" + filter.getTfsId();
                HashMap<String, HashMap<String, String>> tempMap = new HashMap<String, HashMap<String, String>>();
                tempMap.put("updatedOrNewParent", ro_updatedOrNewParentMap);
                tempMap.put("updatedOrNewChild", ro_updatedOrNewChildMap);
                tempMap.put("validParentMap", ro_validParentMap);
                tempMap.put("validChildMap", ro_validChildMap);
                ObjectMapper mapper = new ObjectMapper();
                try {
                    MongoSyncUtils.storeData((String)key, (String)mapper.writeValueAsString(tempMap), (AppConfig.MongoConfig)this.mongoConfig);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            try {
                HashMap data = new HashMap();
                String key = "Other Items";
                if (PropertyValidator.isValid((Object)filter) && !filter.getId().contains("AddExisting")) {
                    key = filter.getId();
                }
                data.put(key, new HashMap());
                ((HashMap)data.get(key)).put("missingParent", ro_parentRemoved);
                ((HashMap)data.get(key)).put("missingChild", ro_childrenRemoved);
                ((HashMap)data.get(key)).put("newParent", ro_parentAdded);
                ((HashMap)data.get(key)).put("newChild", ro_childrenAdded);
                if (PropertyValidator.isValid(newProjects)) {
                    ((HashMap)data.get(key)).put("newProjects", newProjects);
                }
                this.pushProgressUpdates("ResyncLogging", syncId, gson.toJson(data), true);
                LOGGER.debug(" :: ResyncLogging  ");
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                HashMap<String, Exception> exp = new HashMap<String, Exception>();
                exp.put("kendisError", e);
                this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
            }
        }
        return null;
    }

    private ItemJiraDependency createJirDepdency(Item item, String rel, String relURL) {
        ItemJiraDependency existing;
        String childId = relURL.substring(relURL.lastIndexOf("/") + 1);
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies()) && (existing = (ItemJiraDependency)item.getJiraDependencies().stream().filter(ijd -> {
            boolean result = false;
            if (PropertyValidator.isValid((Object)ijd)) {
                try {
                    result = ijd.getTfsLinkType().equals(rel) && ijd.getTargetTFSItem().getTfsId().equals(childId);
                }
                catch (Exception ex) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                }
            }
            return result;
        }).findFirst().orElse(null)) != null) {
            return null;
        }
        ItemJiraDependency tfsDependency = new ItemJiraDependency();
        if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            tfsDependency.setSessionBoardId(((SessionBoard)item.getSessionBoards().get(0)).getId());
        }
        tfsDependency.setId(ObjectId.get().toString());
        tfsDependency.setIsTFS(Boolean.valueOf(true));
        tfsDependency.setSourceItemId(item.getId());
        tfsDependency.setTargetItemId(null);
        String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
        String sourceItemStatus = null;
        if (PropertyValidator.isValid((Object)item.getStatus())) {
            sourceItemStatus = item.getStatus().getTitle();
        }
        TFSIssue tfsSourceIssue = new TFSIssue(item.getTfsId(), item.getTitle(), sourceItemStatus, item.getTfsURL(), item.getTfsApiURL());
        TFSIssue tfsTargetIssue = new TFSIssue(childId, null, null, targetItemURL, relURL);
        tfsDependency.setSourceTFSItem(tfsSourceIssue);
        tfsDependency.setTargetTFSItem(tfsTargetIssue);
        tfsDependency.setTfsLinkType(rel);
        tfsDependency.setCreatedBy(UserContextUtil.getUserContext().getUsername());
        tfsDependency.setCreatedOn(new Date());
        tfsDependency.setRaisedOn(new Date());
        return tfsDependency;
    }

    public void fetcTFSItemsforBuckets(String sessionBoardId, Session session, AlmAccount almAccount) throws Exception {
        int i;
        LOGGER.debug("[Bucket] tfs service called ");
        List syncMapper = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardId));
        HashSet<String> path1 = new HashSet<String>();
        HashSet<String> path2 = new HashSet<String>();
        List mapping = session.getTfsAlmConfigurations().getTeamMappings();
        for (i = 0; i < mapping.size(); ++i) {
            if (!PropertyValidator.isValid((Object)((TFSTeamMapping)mapping.get(i)).getKendisTeamId()) || !PropertyValidator.isValid((Object)((TFSTeamMapping)mapping.get(i)).getTfsAreaPath()) || Boolean.TRUE.equals(session.getAreaPathDisabled()) && !Boolean.TRUE.equals(session.getTeamFieldEnable())) continue;
            path2.add(((TFSTeamMapping)mapping.get(i)).getTfsAreaPath());
        }
        for (i = 0; i < syncMapper.size(); ++i) {
            if (!PropertyValidator.isValid((Object)((ItemSyncMapper)syncMapper.get(i)).getTfsSprint()) || !PropertyValidator.isValid((Object)((ItemSyncMapper)syncMapper.get(i)).getTeam())) continue;
            path1.add(((ItemSyncMapper)syncMapper.get(i)).getTfsSprint().getIterationPath());
        }
        if (!PropertyValidator.isValid((Object)session.getBuckets())) {
            return;
        }
        Set kTypes = session.getBuckets().keySet();
        List existingItems = this.customRepositoryImpl.findBuckets(session, kTypes, (List)new /* Unavailable Anonymous Inner Class!! */);
        HashMap<String, Item> parentMapByChildType = new HashMap<String, Item>();
        HashMap<String, String> kendisIdsMap = new HashMap<String, String>();
        for (Item item2 : existingItems) {
            parentMapByChildType.put(item2.getIssueType().getId(), item2);
            kendisIdsMap.put(item2.getId(), item2.getIssueType().getId());
        }
        List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(session.getId());
        HashMap<String, TFSProject> tfsProjectsMapById = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (TFSProject tfsProject : tfsProjects) {
                tfsProjectsMapById.put(tfsProject.getTfsId(), tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), tfsProject);
            }
        }
        List statuses = this.statusRepository.findBySessionId(session.getId());
        HashMap statusMap = this.getStatusesMap(statuses);
        List syncMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardId));
        HashMap<String, Object> syncMappersMapByTeamSrintId = new HashMap<String, Object>();
        HashMap<String, ArrayList<Object>> syncMappersMapByIterationPath = new HashMap<String, ArrayList<Object>>();
        if (PropertyValidator.isValid((Collection)syncMappers)) {
            for (Object synMapper : syncMappers) {
                if (PropertyValidator.isValid((Object)synMapper.getTfsSprint())) {
                    ArrayList<Object> sms = (ArrayList<Object>)syncMappersMapByIterationPath.get(synMapper.getTfsSprint().getIterationPath());
                    if (sms == null) {
                        sms = new ArrayList<Object>();
                        syncMappersMapByIterationPath.put(synMapper.getTfsSprint().getIterationPath(), sms);
                    }
                    sms.add(synMapper);
                }
                if (!PropertyValidator.isValid((Object)synMapper.getTeam()) || !PropertyValidator.isValid((Object)synMapper.getContainer())) continue;
                String key = synMapper.getTeam().getId() + ":" + synMapper.getContainer().getId();
                syncMappersMapByTeamSrintId.put(key, synMapper);
            }
        }
        HashMap<String, TFSTeamMapping> tfsTeamMappingMapByTeamId = new HashMap<String, TFSTeamMapping>();
        if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)session.getTfsAlmConfigurations().getTeamMappings())) {
            for (TFSTeamMapping mappedTeam : session.getTfsAlmConfigurations().getTeamMappings()) {
                tfsTeamMappingMapByTeamId.put(mappedTeam.getKendisTeamId(), mappedTeam);
            }
        }
        HashMap<String, Object> extraFields = new HashMap<String, Object>();
        extraFields.put("statusMap", statusMap);
        extraFields.put("type", Item.USER_STORY);
        List children = this.itemRepository.findIdBySessionBoardsIdInAndParentInAndTfsIdNotNull(sessionBoardId, existingItems);
        HashMap<String, Item> childrenToRemoveMap = new HashMap<String, Item>();
        if (PropertyValidator.isValid((Collection)children)) {
            for (Item child : children) {
                childrenToRemoveMap.put(child.getId(), child);
            }
        }
        ArrayList<ItemJiraDependency> jiraDependenciesToDelete = new ArrayList<ItemJiraDependency>();
        ArrayList<ItemJiraDependency> jiraDependenciesToSave = new ArrayList<ItemJiraDependency>();
        ArrayList<TeamContainer> teamContainersToSave = new ArrayList<TeamContainer>();
        ArrayList<Item> itemsToSave = new ArrayList<Item>();
        for (String type : kTypes) {
            if (parentMapByChildType.get(type) == null) continue;
            StringBuilder names = new StringBuilder();
            List almTypes = ((IssueType)session.getBuckets().get(type)).getAlmTypes();
            for (Map _t : almTypes) {
                if (names.length() > 0) {
                    names.append(",");
                }
                names.append("'").append((String)_t.get("name")).append("'");
            }
            JSONObject o = new JSONObject();
            StringBuilder wiql = new StringBuilder().append("SELECT [System.Id], [System.Title] FROM WORKITEMS WHERE ").append("[System.WorkItemType] IN (").append(names.toString()).append(")").append(" AND [System.IterationPath] IN ('").append(String.join((CharSequence)"','", path1)).append("') ");
            if (path2.size() > 0) {
                wiql.append(" AND [System.AreaPath] IN ('").append(String.join((CharSequence)"','", path2)).append("') ");
            }
            o.put("query", (Object)wiql.toString());
            LOGGER.debug("[Bucket] wiql : " + wiql.toString());
            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(o.toString(), almAccount, false);
            String tfsItemIdsStr = tfsResponse.getContent();
            JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
            JSONArray workItemsArray = jsonObject.getJSONArray("workItems");
            ArrayList<String> tfsIds = new ArrayList<String>();
            for (int i2 = 0; i2 < workItemsArray.length(); ++i2) {
                JSONObject wiObject = workItemsArray.getJSONObject(i2);
                String itemId = wiObject.getString("id");
                tfsIds.add(itemId);
            }
            LOGGER.debug("[Bucket] wiql result ids : " + String.join((CharSequence)",", tfsIds));
            List setsIds = Lists.partition(new ArrayList(tfsIds), (int)100);
            for (List subSetsIds : setsIds) {
                String parentItemsStr = this.tfsUtils.getItems("1", String.join((CharSequence)",", subSetsIds), almAccount);
                List existingChildren = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndType(sessionBoardId, subSetsIds, Item.USER_STORY);
                HashMap existingChildrenMapByTfsId = new HashMap();
                if (PropertyValidator.isValid((Collection)existingChildren)) {
                    existingChildren.forEach(item -> {
                        if (!existingChildrenMapByTfsId.containsKey(item.getTfsId())) {
                            existingChildrenMapByTfsId.put(item.getTfsId(), item);
                        }
                    });
                }
                JSONObject dataObjects = new JSONObject(parentItemsStr);
                String count = dataObjects.getString("count");
                JSONArray itemsArray = dataObjects.getJSONArray("value");
                for (int i3 = 0; i3 < itemsArray.length(); ++i3) {
                    try {
                        JSONArray relationsArray;
                        JSONObject itemObject = itemsArray.getJSONObject(i3);
                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                        String itemTfsId = itemObject.getString("id");
                        Item kendisChild = (Item)existingChildrenMapByTfsId.get(itemTfsId);
                        Map itemMap = null;
                        itemMap = PropertyValidator.isValid((Object)kendisChild) ? this.getKendisItemFromTFSItem(session, kendisChild, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName) : this.getKendisItemFromTFSItem(session, null, itemObject, tfsFields, extraFields, tfsProjectsMapById, tfsProjectsMapByName);
                        Item item3 = null;
                        if (!PropertyValidator.isValid(itemMap.get("item"))) {
                            LOGGER.debug("Item TFS Id : " + itemObject.getString("id") + " is skipped as board don't have Project : " + itemMap.get("project"));
                            continue;
                        }
                        item3 = (Item)itemMap.get("item");
                        boolean isValid = false;
                        try {
                            isValid = this.isItemValidToAddForSession(item3, session);
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                        if (!isValid) continue;
                        item3.setSessionBoards(new ArrayList());
                        SessionBoard tempSessionBoard = new SessionBoard();
                        tempSessionBoard.setId(sessionBoardId);
                        item3.getSessionBoards().add(tempSessionBoard);
                        item3.setType(Item.USER_STORY.toString());
                        String iterationPath = item3.getTfsIterationPath();
                        String areaPath = item3.getTfsAreaPath();
                        if (childrenToRemoveMap.containsKey(item3.getId())) {
                            childrenToRemoveMap.remove(item3.getId());
                        }
                        HashMap<String, ItemJiraDependency> oldLinksMapByTfsIdAndLinkType = new HashMap<String, ItemJiraDependency>();
                        item3.setJiraDependencies(new ArrayList());
                        if (PropertyValidator.isValid((Collection)item3.getJiraDependencies())) {
                            for (ItemJiraDependency dependency : item3.getJiraDependencies()) {
                                String linkKey = dependency.getTargetTFSItem().getTfsId() + "_" + dependency.getTfsLinkType();
                                oldLinksMapByTfsIdAndLinkType.put(linkKey, dependency);
                            }
                        }
                        if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                            ArrayList tfsChilds = new ArrayList();
                            for (int j = 0; j < relationsArray.length(); ++j) {
                                JSONObject relationObject = relationsArray.getJSONObject(j);
                                String rel = relationObject.getString("rel");
                                ArrayList relationsToFetch = new ArrayList();
                                String relURL = relationObject.getString("url");
                                if (!PropertyValidator.isValid((Collection)session.getJiraLinkTypes()) || !session.getJiraLinkTypes().contains(rel)) continue;
                                String targetId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                if (item3.getTfsRelations() == null) {
                                    item3.setTfsRelations(new ArrayList());
                                }
                                item3.getTfsRelations().add(this.relationToMap(rel, targetId, relURL));
                                ItemJiraDependency tfsDependency = new ItemJiraDependency();
                                tfsDependency.setSessionBoardId(sessionBoardId);
                                tfsDependency.setIsTFS(Boolean.valueOf(true));
                                tfsDependency.setSourceItemId(item3.getId());
                                tfsDependency.setTargetItemId(null);
                                String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
                                String sourceItemStatus = null;
                                if (PropertyValidator.isValid((Object)item3.getStatus())) {
                                    sourceItemStatus = item3.getStatus().getTitle();
                                }
                                TFSIssue tfsSourceIssue = new TFSIssue(item3.getTfsId(), item3.getTitle(), sourceItemStatus, item3.getTfsURL(), item3.getTfsApiURL());
                                TFSIssue tfsTargetIssue = new TFSIssue(targetId, null, null, targetItemURL, relURL);
                                tfsDependency.setSourceTFSItem(tfsSourceIssue);
                                tfsDependency.setTargetTFSItem(tfsTargetIssue);
                                tfsDependency.setTfsLinkType(rel);
                                tfsDependency.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                tfsDependency.setCreatedOn(new Date());
                                String linkKey = targetId + "_" + rel;
                                if (PropertyValidator.isValid(oldLinksMapByTfsIdAndLinkType.get(linkKey))) {
                                    ItemJiraDependency oldTfsDependency = (ItemJiraDependency)oldLinksMapByTfsIdAndLinkType.get(linkKey);
                                    oldTfsDependency.setSourceTFSItem(tfsDependency.getSourceTFSItem());
                                    oldTfsDependency.setTargetTFSItem(tfsDependency.getTargetTFSItem());
                                    item3.getJiraDependencies().add(oldTfsDependency);
                                    oldLinksMapByTfsIdAndLinkType.remove(linkKey);
                                    continue;
                                }
                                tfsDependency.setId(ObjectId.get().toString());
                                tfsDependency.setRaisedOn(new Date());
                                item3.getJiraDependencies().add(tfsDependency);
                                jiraDependenciesToSave.add(tfsDependency);
                            }
                        }
                        if (!oldLinksMapByTfsIdAndLinkType.isEmpty()) {
                            Collection removedLinks = oldLinksMapByTfsIdAndLinkType.values();
                            for (ItemJiraDependency link : removedLinks) {
                                jiraDependenciesToDelete.add(link);
                            }
                        }
                        itemsToSave.add(item3);
                        String paretKendisItemTypeId = this.getItemTypeId(session, item3.getTfsItemType());
                        if (!PropertyValidator.isValid((Object)paretKendisItemTypeId)) {
                            LOGGER.debug("[Bucket] item [" + item3.getTfsId() + "] parent not found by tfs type: " + item3.getTfsItemType());
                        }
                        Item parentItem = (Item)parentMapByChildType.get(paretKendisItemTypeId);
                        if (PropertyValidator.isValid((Object)paretKendisItemTypeId) && !PropertyValidator.isValid((Object)parentItem)) {
                            LOGGER.debug("[Bucket] item [" + item3.getTfsId() + "] parent not found in buckets from db");
                        }
                        if (!PropertyValidator.isValid((Object)parentItem)) continue;
                        item3.setParent(new Item(parentItem.getId()));
                        HashMap matchingItemSyncMappersResult = this.findMatchingItemSyncMappersOfItem(item3, parentItem, session, iterationPath, areaPath, syncMappersMapByTeamSrintId, syncMappersMapByIterationPath, tfsTeamMappingMapByTeamId);
                        boolean newSubItemMappingFound = (Boolean)matchingItemSyncMappersResult.get("newSubItemMappingFound");
                        TeamContainer newTeamContainer = (TeamContainer)matchingItemSyncMappersResult.get("teamContainer");
                        if (!newSubItemMappingFound || newTeamContainer.getId() != null) continue;
                        newTeamContainer.setId(ObjectId.get().toString());
                        teamContainersToSave.add(newTeamContainer);
                        itemsToSave.add(parentItem);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while parent conversion :: " + StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        if (PropertyValidator.isValid(jiraDependenciesToSave)) {
            this.itemJiraDependencyRepository.save(jiraDependenciesToSave);
        }
        if (PropertyValidator.isValid(jiraDependenciesToDelete)) {
            this.itemJiraDependencyRepository.delete(jiraDependenciesToDelete);
        }
        if (PropertyValidator.isValid(teamContainersToSave)) {
            this.teamContainerRepository.save(teamContainersToSave);
        }
        if (PropertyValidator.isValid(itemsToSave)) {
            this.itemRepository.save(itemsToSave);
        }
        if (PropertyValidator.isValid(childrenToRemoveMap)) {
            this.itemRepository.deleteByIdIn(childrenToRemoveMap.keySet());
        }
    }

    private String getItemTypeId(Session session, String tfsItemType) {
        if (PropertyValidator.isValid((Object)session.getBuckets())) {
            Set keys = session.getBuckets().keySet();
            for (String key : keys) {
                IssueType issueType = (IssueType)session.getBuckets().get(key);
                List _types = issueType.getAlmTypes();
                if (!PropertyValidator.isValid((Collection)_types)) continue;
                for (Map o : _types) {
                    String type = (String)o.get("name");
                    if (type == null || !type.endsWith(tfsItemType)) continue;
                    return key;
                }
            }
        }
        return null;
    }

    private Map<String, String> relationToMap(String rel, String tfsId, String relUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rel", rel);
        map.put("id", tfsId);
        map.put("relUrl", relUrl);
        return map;
    }

    public HashMap<String, Object> fetchTFSItems(List<String> tfsIds, String sessionBoardId, List<String> relationTypes, IssueType issueType, TFSFilter filter, String metaMap, AlmAccount almAccount, HashMap<String, Object> ajaxParams) {
        HashMap parentToRemove;
        HashMap ignoreNewParent;
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = board.getSession();
        List statuses = this.statusRepository.findBySessionId(board.getSession().getId());
        HashMap statusMap = this.getStatusesMap(statuses);
        if (ajaxParams == null) {
            ajaxParams = new HashMap();
        }
        boolean removeEmptyParents = Boolean.TRUE.equals(ajaxParams.get("removeEmptyParents"));
        boolean isReadOnly = Boolean.TRUE.equals(ajaxParams.get("isReadOnly"));
        Gson gson = new Gson();
        String syncId = (String)ajaxParams.get("syncId");
        Map removedItemsMap = null;
        HashMap<String, HashMap> missingItemMap = new HashMap<String, HashMap>();
        HashMap<String, HashMap> newItemMap = new HashMap<String, HashMap>();
        HashMap<String, HashMap> missingChildMap = new HashMap<String, HashMap>();
        HashMap<String, HashMap> newChildMap = new HashMap<String, HashMap>();
        HashMap checkedIds = (HashMap)ajaxParams.get("checkedIds");
        HashMap<String, String> newProjects = new HashMap<String, String>();
        boolean isProcessFailed = false;
        if (checkedIds == null) {
            checkedIds = new HashMap();
        }
        if ((ignoreNewParent = (HashMap)checkedIds.get("addParent")) == null) {
            ignoreNewParent = new HashMap();
        }
        if ((parentToRemove = (HashMap)checkedIds.get("deleteParent")) == null) {
            parentToRemove = new HashMap();
        }
        if (!almAccount.getIsTaggedUser().booleanValue() && PropertyValidator.isValid((Object)filter)) {
            AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount);
            if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                almAccount = taggedAlmAccount;
            }
        } else {
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        }
        List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(board.getSession().getId());
        HashMap<String, TFSProject> tfsProjectsMap = new HashMap<String, TFSProject>();
        HashMap<String, TFSProject> tfsProjectsMapByName = new HashMap<String, TFSProject>();
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (Object tfsProject : tfsProjects) {
                tfsProjectsMap.put(tfsProject.getTfsId(), (TFSProject)tfsProject);
                tfsProjectsMapByName.put(tfsProject.getName(), (TFSProject)tfsProject);
            }
        }
        HashMap<String, TFSTeamMapping> tfsTeamMapping = new HashMap<String, TFSTeamMapping>();
        if (PropertyValidator.isValid((Object)board.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)board.getSession().getTfsAlmConfigurations().getTeamMappings())) {
            for (TFSTeamMapping mappedTeam : board.getSession().getTfsAlmConfigurations().getTeamMappings()) {
                tfsTeamMapping.put(mappedTeam.getKendisTeamId(), mappedTeam);
            }
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(new SessionBoard(sessionBoardId));
        List existingParentItems = new ArrayList();
        List otherExistingItems = new ArrayList();
        List existingChildItems = new ArrayList();
        List otherExistingChildItems = new ArrayList();
        List existingItems = this.itemRepository.findTFSIdBySessionBoardsIdInAndTfsIdIsNotNull(sessionBoardId);
        HashMap<String, String> existingItemMap = new HashMap<String, String>();
        for (Item item : existingItems) {
            existingItemMap.put(item.getTfsId(), item.getId());
        }
        if (PropertyValidator.isValid((Object)filter)) {
            existingParentItems = this.itemRepository.findBySessionBoardsIdInAndTfsFilterAndType(sessionBoardId, filter.getTfsId(), Item.Type.Feature.toString());
            existingChildItems = this.itemRepository.findBySessionBoardsIdInAndParentInAndTfsIdNotNull(sessionBoardId, existingParentItems);
            otherExistingItems = this.itemRepository.findBySessionBoardsIdInAndParentIsNullAndTfsFilterNotInAndTfsIdIsNotNull(sessionBoardId, (List)new /* Unavailable Anonymous Inner Class!! */);
            otherExistingChildItems = this.itemRepository.findBySessionBoardsIdInAndParentIsNotNullAndTfsFilterNotInAndTfsIdIsNotNull(sessionBoardId, (List)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            existingParentItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndParentIsNull(sessionBoardId, tfsIds);
            existingChildItems = this.itemRepository.findBySessionBoardsIdInAndParentIn(sessionBoardId, existingParentItems);
        }
        List syncMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardId));
        HashMap<String, Item> remEP_existingChildMap = new HashMap<String, Item>();
        HashMap<String, Boolean> remEP_itemLinksMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> remEP_parentIds = new HashMap<String, Boolean>();
        HashMap<String, Item> remEP_parentTCMap = new HashMap<String, Item>();
        HashMap<String, Boolean> remEP_childTCMap = new HashMap<String, Boolean>();
        HashMap<String, Item> existingChildItemMap = new HashMap<String, Item>();
        for (Item item : existingChildItems) {
            existingChildItemMap.put(item.getTfsId(), item);
            if (Boolean.TRUE.equals(isReadOnly) && PropertyValidator.isValid((Object)item.getTfsId())) {
                missingChildMap.put(item.getTfsId(), item.toSimpleObject());
            }
            if (!removeEmptyParents) continue;
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                remEP_childTCMap.put(((TeamContainer)item.getTeamContainers().get(0)).getId(), true);
            }
            if (PropertyValidator.isValid((Object)item.getParent().getId())) {
                remEP_existingChildMap.put(item.getId(), item);
                remEP_parentIds.put(item.getParent().getId(), true);
            }
            if (!PropertyValidator.isValid((Collection)item.getItemLinks())) continue;
            for (ItemLink itemLink : item.getItemLinks()) {
                remEP_childTCMap.put(itemLink.getSourceTeamContainerId(), true);
                remEP_childTCMap.put(itemLink.getTargetTeamContainerId(), true);
            }
        }
        for (Item item : otherExistingChildItems) {
            existingChildItemMap.put(item.getTfsId(), item);
            if (!Boolean.TRUE.equals(isReadOnly) || PropertyValidator.isValid((Object)item.getTfsId())) {
                // empty if block
            }
            if (!removeEmptyParents) continue;
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                remEP_childTCMap.put(((TeamContainer)item.getTeamContainers().get(0)).getId(), true);
            }
            if (PropertyValidator.isValid((Object)item.getParent().getId())) {
                remEP_existingChildMap.put(item.getId(), item);
                remEP_parentIds.put(item.getParent().getId(), true);
            }
            if (!PropertyValidator.isValid((Collection)item.getItemLinks())) continue;
            for (ItemLink itemLink : item.getItemLinks()) {
                remEP_childTCMap.put(itemLink.getSourceTeamContainerId(), true);
                remEP_childTCMap.put(itemLink.getTargetTeamContainerId(), true);
            }
        }
        if (!isReadOnly && PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getTfsId())) {
            List delItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndType(sessionBoardId, parentToRemove.keySet(), Item.Type.Feature.name());
            KendisUtils.putDeletedItems(removedItemsMap, (List)this.itemRepository.deleteByParentInAndTfsIdNotNull(delItems));
        }
        HashMap<String, Item> existingParentItemMap = new HashMap<String, Item>();
        HashMap<String, Boolean> updatedExistingParentItemMap = new HashMap<String, Boolean>();
        for (Item item : existingParentItems) {
            existingParentItemMap.put(item.getTfsId(), item);
            if (isReadOnly) {
                missingItemMap.put(item.getTfsId(), item.toSimpleObject());
            } else if (Boolean.TRUE.equals(parentToRemove.get(item.getTfsId()))) {
                updatedExistingParentItemMap.put(item.getId(), false);
            }
            if (!removeEmptyParents) continue;
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                for (TeamContainer tc2 : item.getTeamContainers()) {
                    remEP_parentTCMap.put(tc2.getId(), item);
                }
            }
            if (!PropertyValidator.isValid((Collection)item.getItemLinks())) continue;
            for (ItemLink itemLink : item.getItemLinks()) {
                remEP_itemLinksMap.put(itemLink.getSourceTeamContainerId(), true);
                remEP_itemLinksMap.put(itemLink.getTargetTeamContainerId(), true);
            }
        }
        for (Item item : otherExistingItems) {
            existingParentItemMap.put(item.getTfsId(), item);
            if (!removeEmptyParents) continue;
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                for (TeamContainer tc2 : item.getTeamContainers()) {
                    remEP_parentTCMap.put(tc2.getId(), item);
                }
            }
            if (!PropertyValidator.isValid((Collection)item.getItemLinks())) continue;
            for (ItemLink itemLink : item.getItemLinks()) {
                remEP_itemLinksMap.put(itemLink.getSourceTeamContainerId(), true);
                remEP_itemLinksMap.put(itemLink.getTargetTeamContainerId(), true);
            }
        }
        ArrayList<String> itemsToBeDeleted = new ArrayList<String>();
        ArrayList allParentItems = new ArrayList();
        ArrayList allChildItems = new ArrayList();
        ArrayList<ItemJiraDependency> tfsDependenciesToBeDeleted = new ArrayList<ItemJiraDependency>();
        HashMap itemsMapById = new HashMap();
        HashSet<String> relationTFSIds = new HashSet<String>();
        int depCount = 1;
        HashMap<String, ItemJiraDependency> jiraDependencyMapByTFSSourceTarget = new HashMap<String, ItemJiraDependency>();
        HashMap<String, String> tfsIdByItemId = new HashMap<String, String>();
        HashMap itemIdsMapByTFSId = new HashMap();
        HashMap<String, ItemJiraDependency> oldLinksMapByTfsIdAndLinkType = new HashMap<String, ItemJiraDependency>();
        boolean autoCloseItemDependency = false;
        boolean autoCloseSubItemDependency = false;
        boolean autoOpenItemDependency = false;
        boolean autoOpenSubItemDependency = false;
        if (PropertyValidator.isValid((Object)session.getItemLinkStatusDependentOn()) && !session.getItemLinkStatusDependentOn().equals("-1")) {
            autoCloseItemDependency = true;
        }
        if (PropertyValidator.isValid((Object)session.getSubItemLinkStatusDependentOn()) && !session.getSubItemLinkStatusDependentOn().equals("-1")) {
            autoCloseSubItemDependency = true;
        }
        if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfItemReOpen())) {
            autoOpenItemDependency = session.getReOpenDependencyIfItemReOpen();
        }
        if (PropertyValidator.isValid((Object)session.getReOpenDependencyIfSubItemReOpen())) {
            autoOpenSubItemDependency = session.getReOpenDependencyIfSubItemReOpen();
        }
        ArrayList autoCloseLinksOfItems = new ArrayList();
        ArrayList<String> autoCloseLinksOfSubItems = new ArrayList<String>();
        ArrayList autoOpenLinksOfItems = new ArrayList();
        ArrayList<String> autoOpenLinksOfSubItems = new ArrayList<String>();
        ArrayList<String> autoCloseLinksOfItemIds = new ArrayList<String>();
        ArrayList<String> autoOpenLinksOfItemIds = new ArrayList<String>();
        List subSetsParentIds = Lists.partition(new ArrayList<String>(tfsIds), (int)100);
        for (Object subSetParentIds : subSetsParentIds) {
            String idsParentStr = String.join((CharSequence)",", (Iterable<? extends CharSequence>)subSetParentIds);
            try {
                String parentItemsStr = this.tfsUtils.getItems("1", idsParentStr, almAccount);
                if (!isReadOnly) {
                    List existingSubParentItems;
                    if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getTfsId())) {
                        existingSubParentItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndParentIsNull(sessionBoardId, (List)subSetParentIds);
                        KendisUtils.putDeletedItems(removedItemsMap, (List)this.itemRepository.deleteByParentInAndTfsIdNotNull(existingSubParentItems));
                    } else {
                        existingSubParentItems = this.itemRepository.findBySessionBoardsIdInAndTfsIdInAndParentIsNull(sessionBoardId, (List)subSetParentIds);
                        KendisUtils.putDeletedItems(removedItemsMap, (List)this.itemRepository.deleteByParentInAndTfsIdNotNull(existingSubParentItems));
                    }
                }
                ArrayList<Item> parentItems = new ArrayList<Item>();
                ArrayList<Item> childItems = new ArrayList<Item>();
                try {
                    String childItemsStr;
                    String idsChildStr;
                    JSONObject dataObjects = new JSONObject(parentItemsStr);
                    String count = dataObjects.getString("count");
                    JSONArray itemsArray = dataObjects.getJSONArray("value");
                    Double sysSequence = new Double(System.nanoTime() / 100000L);
                    HashMap<String, Object> extraFields = new HashMap<String, Object>();
                    extraFields.put("sequence", sysSequence);
                    extraFields.put("statusMap", statusMap);
                    extraFields.put("type", Item.FEATURE);
                    HashMap<String, Item> parentItemMapById = new HashMap<String, Item>();
                    HashMap<String, Object> childMapByParent = new HashMap<String, Object>();
                    HashMap<String, String> parentMapByChild = new HashMap<String, String>();
                    HashMap<String, ItemJiraDependency> oldLinksMapByAlmId = new HashMap<String, ItemJiraDependency>();
                    HashMap parnetDuplicationCheckMap = new HashMap();
                    ArrayList<String> allParentsIdToFetchTitle = new ArrayList<String>();
                    HashMap<String, ArrayList> itemByParentIdMap = new HashMap<String, ArrayList>();
                    for (int i = 0; i < itemsArray.length(); ++i) {
                        try {
                            JSONArray relationsArray;
                            JSONObject itemObject = itemsArray.getJSONObject(i);
                            JSONObject tfsFields = itemObject.getJSONObject("fields");
                            Map itemMap = this.getKendisItemFromTFSItem(session, null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                            Item item = null;
                            if (!PropertyValidator.isValid(itemMap.get("item"))) {
                                LOGGER.debug("Item TFS Id : " + itemObject.getString("id") + " is skipped as board don't have Project : " + itemMap.get("project"));
                                continue;
                            }
                            item = (Item)itemMap.get("item");
                            item.setType(Item.FEATURE);
                            if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                for (Object backlogMappingLink : filter.getBacklogMappingLinks()) {
                                    if (!item.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                    item.setTfsLinkTypes(backlogMappingLink.getLinkTypes());
                                    break;
                                }
                            } else {
                                item.setTfsLinkTypes(relationTypes);
                            }
                            if (PropertyValidator.isValid((Object)filter)) {
                                item.setTfsFilter(filter.getTfsId());
                            }
                            if (PropertyValidator.isValid((Object)issueType)) {
                                item.setIssueType(issueType);
                            }
                            if (isReadOnly && PropertyValidator.isValid((Object)item.getTfsProjectId()) && !PropertyValidator.isValid((Collection)item.getTfsLinkTypes())) {
                                newProjects.put(item.getTfsProjectId(), item.getTfsProject());
                            }
                            if (existingParentItemMap.containsKey(item.getTfsId())) {
                                Item existingItem = (Item)existingParentItemMap.get(item.getTfsId());
                                item.setId(existingItem.getId());
                                item.setTeamContainers(existingItem.getTeamContainers());
                                item.setSequence(existingItem.getSequence());
                                item.setBacklogSequence(existingItem.getBacklogSequence());
                                item.setItemLinks(existingItem.getItemLinks());
                                item.setSolutionSourceItemLinks(existingItem.getSolutionSourceItemLinks());
                                item.setSolutionTargetItemLinks(existingItem.getSolutionTargetItemLinks());
                                item.setIssueType(existingItem.getIssueType());
                                item.setOriginItemId(existingItem.getOriginItemId());
                                item.setDuplicateOfId(existingItem.getDuplicateOfId());
                                item.setScore(existingItem.getScore());
                                item.setScoreParams(existingItem.getScoreParams());
                                item.setCreatedOn(existingItem.getCreatedOn());
                                item.setCreatedBy(existingItem.getCreatedBy());
                                if (!PropertyValidator.isValid((Object)item.getStartDate())) {
                                    item.setStartDate(existingItem.getStartDate());
                                }
                                if (!PropertyValidator.isValid((Object)item.getEndDate())) {
                                    item.setEndDate(existingItem.getEndDate());
                                }
                                if (!PropertyValidator.isValid((Object)existingItem.getTfsFilter()) && PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getTfsId())) {
                                    item.setTfsFilter(filter.getTfsId());
                                } else {
                                    item.setTfsFilter(existingItem.getTfsFilter());
                                    item.setTfsLinkTypes(existingItem.getTfsLinkTypes());
                                }
                                if (PropertyValidator.isValid((Object)existingItem.getFetchedBy())) {
                                    item.setFetchedBy(existingItem.getFetchedBy());
                                }
                                updatedExistingParentItemMap.put(item.getId(), true);
                                if (session.getJiraDependencyEnabled().booleanValue() && PropertyValidator.isValid((Collection)session.getJiraLinkTypes())) {
                                    if (PropertyValidator.isValid((Collection)existingItem.getJiraDependencies())) {
                                        Object backlogMappingLink;
                                        tfsDependenciesToBeDeleted.addAll(existingItem.getJiraDependencies());
                                        backlogMappingLink = existingItem.getJiraDependencies().iterator();
                                        while (backlogMappingLink.hasNext()) {
                                            ItemJiraDependency dependency = (ItemJiraDependency)backlogMappingLink.next();
                                            if (!PropertyValidator.isValid((Object)dependency)) continue;
                                            oldLinksMapByTfsIdAndLinkType.put(dependency.getTargetTFSItem().getTfsId() + "_" + dependency.getTfsLinkType(), dependency);
                                            if (!PropertyValidator.isValid((Object)dependency.getJiraDependencyId())) continue;
                                            oldLinksMapByAlmId.put(dependency.getJiraDependencyId(), dependency);
                                        }
                                    }
                                    item.setJiraDependencies(new ArrayList());
                                }
                                if (!isReadOnly && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)existingItem.getStatus()) && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                    if (autoCloseItemDependency && PropertyValidator.isValid((Object)existingItem.getStatus()) && PropertyValidator.isValid((Object)existingItem.getStatus().getCategory()) && !existingItem.getStatus().getCategory().equals("Done") && item.getStatus().getCategory().equals("Done")) {
                                        autoCloseLinksOfItemIds.add(existingItem.getId());
                                        item.getTeamContainers().forEach(tc -> autoCloseLinksOfItems.add(tc.getId()));
                                    }
                                    if (autoOpenItemDependency && PropertyValidator.isValid((Object)existingItem.getStatus()) && PropertyValidator.isValid((Object)existingItem.getStatus().getCategory()) && existingItem.getStatus().getCategory().equals("Done") && !item.getStatus().getCategory().equals("Done")) {
                                        autoOpenLinksOfItemIds.add(existingItem.getId());
                                        item.getTeamContainers().forEach(tc -> autoOpenLinksOfItems.add(tc.getId()));
                                    }
                                }
                            } else {
                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
                                    item.setFetchedBy(filter.getFilterFetchedBy());
                                } else {
                                    item.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                                }
                                newItemMap.put(item.getTfsId(), item.toSimpleObject());
                                if (!isReadOnly && !isReadOnly && checkedIds != null && Boolean.TRUE.equals(ignoreNewParent.get(item.getTfsId()))) continue;
                            }
                            item.setUpdatedOn(new Date());
                            item.setUpdatedBy(UserContextUtil.getUserContext().getUsername());
                            if (existingParentItemMap.containsKey(item.getTfsId())) {
                                KendisUtils.addChanges((boolean)isReadOnly, (boolean)true, (Item)item, (Item)((Item)existingParentItemMap.get(item.getTfsId())));
                            } else {
                                item.setCreatedOn(new Date());
                                item.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                KendisUtils.addChanges((boolean)isReadOnly, (boolean)true, (Item)item, null);
                            }
                            item.setSessionBoards(sessionBoards);
                            item.setTfsRelations(new ArrayList());
                            if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                                ArrayList tfsChilds = new ArrayList();
                                for (int j = 0; j < relationsArray.length(); ++j) {
                                    String childId;
                                    JSONObject relationObject = relationsArray.getJSONObject(j);
                                    String rel = relationObject.getString("rel");
                                    List relationsToFetch = new ArrayList();
                                    if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                        for (TFSBacklogMappingLinks backlogMappingLink : filter.getBacklogMappingLinks()) {
                                            if (!item.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                            relationsToFetch.addAll(backlogMappingLink.getLinkTypes());
                                            break;
                                        }
                                    } else {
                                        relationsToFetch = item.getTfsLinkTypes();
                                    }
                                    String relURL = relationObject.getString("url");
                                    if (PropertyValidator.isValid(relationsToFetch) && relationsToFetch.contains(rel)) {
                                        childId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                        tfsChilds.add(childId);
                                        parentMapByChild.put(childId, item.getId());
                                        item.getTfsRelations().add(this.relationToMap(rel, childId, relURL));
                                    }
                                    if (rel.equals("System.LinkTypes.Hierarchy-Reverse")) {
                                        ArrayList itemsList;
                                        String parentId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                        if (!PropertyValidator.isValid((Object)item.getTfsFieldByKey())) {
                                            item.setTfsFieldByKey(new HashMap());
                                        }
                                        item.getTfsFieldByKey().put("ParentId", parentId);
                                        if (!parnetDuplicationCheckMap.containsKey(parentId)) {
                                            allParentsIdToFetchTitle.add(parentId);
                                        }
                                        if (!itemByParentIdMap.containsKey(parentId)) {
                                            itemsList = new ArrayList();
                                            itemByParentIdMap.put(parentId, itemsList);
                                        } else {
                                            itemsList = (ArrayList)itemByParentIdMap.get(parentId);
                                        }
                                        itemsList.add(item);
                                        item.getTfsRelations().add(this.relationToMap(rel, parentId, relURL));
                                    }
                                    if (!session.getJiraDependencyEnabled().booleanValue() || !PropertyValidator.isValid((Collection)session.getJiraLinkTypes()) || !session.getJiraLinkTypes().contains(rel)) continue;
                                    childId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                    item.getTfsRelations().add(this.relationToMap(rel, childId, relURL));
                                    ItemJiraDependency tfsDependency = new ItemJiraDependency();
                                    tfsDependency.setSessionBoardId(board.getId());
                                    tfsDependency.setIsTFS(Boolean.valueOf(true));
                                    tfsDependency.setSourceItemId(item.getId());
                                    tfsDependency.setTargetItemId(null);
                                    String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
                                    String sourceItemStatus = null;
                                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                                        sourceItemStatus = item.getStatus().getTitle();
                                    }
                                    TFSIssue tfsSourceIssue = new TFSIssue(item.getTfsId(), item.getTitle(), sourceItemStatus, item.getTfsURL(), item.getTfsApiURL());
                                    TFSIssue tfsTargetIssue = new TFSIssue(childId, null, null, targetItemURL, relURL);
                                    tfsDependency.setSourceTFSItem(tfsSourceIssue);
                                    tfsDependency.setTargetTFSItem(tfsTargetIssue);
                                    tfsDependency.setTfsLinkType(rel);
                                    tfsDependency.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                    tfsDependency.setCreatedOn(new Date());
                                    if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                                        item.setJiraDependencies(new ArrayList());
                                    }
                                    if (PropertyValidator.isValid(oldLinksMapByTfsIdAndLinkType.get(childId + "_" + rel))) {
                                        ItemJiraDependency oldTfsDependency = (ItemJiraDependency)oldLinksMapByTfsIdAndLinkType.get(childId + "_" + rel);
                                        tfsDependenciesToBeDeleted.remove(oldTfsDependency);
                                        oldTfsDependency.setSourceTFSItem(tfsDependency.getSourceTFSItem());
                                        oldTfsDependency.setTargetTFSItem(tfsDependency.getTargetTFSItem());
                                        item.getJiraDependencies().add(oldTfsDependency);
                                        jiraDependencyMapByTFSSourceTarget.put(item.getId() + "_" + childId + "_" + depCount, oldTfsDependency);
                                        if (PropertyValidator.isValid((Object)oldTfsDependency.getJiraDependencyId()) && PropertyValidator.isValid(oldLinksMapByAlmId.get(oldTfsDependency.getJiraDependencyId()))) {
                                            oldLinksMapByAlmId.remove(oldTfsDependency.getJiraDependencyId());
                                        }
                                    } else {
                                        tfsDependency.setRaisedOn(new Date());
                                        item.getJiraDependencies().add(tfsDependency);
                                        jiraDependencyMapByTFSSourceTarget.put(item.getId() + "_" + childId + "_" + depCount, tfsDependency);
                                    }
                                    ++depCount;
                                    relationTFSIds.add(childId);
                                }
                                childMapByParent.put(item.getId(), tfsChilds);
                            }
                            if (!isReadOnly && PropertyValidator.isValid((Collection)item.getItemLinks())) {
                                ArrayList<String> itemLinksIdsList = new ArrayList<String>();
                                for (ItemLink itemLink : item.getItemLinks()) {
                                    if (!PropertyValidator.isValid((Object)itemLink.getAlmLinkId()) || !PropertyValidator.isValid(oldLinksMapByAlmId.get(itemLink.getAlmLinkId())) && session.getJiraDependencyEnabled().booleanValue()) continue;
                                    itemLinksIdsList.add(itemLink.getAlmLinkId());
                                    itemLink.setAlmLinkId(null);
                                }
                                List itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(itemLinksIdsList);
                                for (ItemLink itemLink : itemLinks) {
                                    itemLink.setAlmLinkId(null);
                                }
                                this.itemLinkRepository.save((Iterable)itemLinks);
                            }
                            tfsIdByItemId.put(item.getTfsId(), item.getId());
                            parentItemMapById.put(item.getId(), item);
                            parentItems.add(item);
                            missingItemMap.remove(item.getTfsId());
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while parent conversion :: " + StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    if (PropertyValidator.isValid(parentMapByChild.keySet())) {
                        List subSetsChildIds = Lists.partition(new ArrayList(parentMapByChild.keySet()), (int)100);
                        for (List subSetChildIds : subSetsChildIds) {
                            idsChildStr = String.join((CharSequence)",", subSetChildIds);
                            try {
                                childItemsStr = this.tfsUtils.getItems("1", idsChildStr, almAccount);
                                try {
                                    dataObjects = new JSONObject(childItemsStr);
                                    count = dataObjects.getString("count");
                                    itemsArray = dataObjects.getJSONArray("value");
                                    sysSequence = new Double(System.nanoTime() / 100000L);
                                    extraFields = new HashMap();
                                    extraFields.put("sequence", sysSequence);
                                    extraFields.put("statusMap", statusMap);
                                    extraFields.put("type", Item.USER_STORY);
                                    for (int i = 0; i < itemsArray.length(); ++i) {
                                        try {
                                            JSONArray relationsArray;
                                            Object inboundItemLinks;
                                            Item parentItem;
                                            JSONObject itemObject = itemsArray.getJSONObject(i);
                                            JSONObject tfsFields = itemObject.getJSONObject("fields");
                                            String iterationPath = (String)tfsFields.get("System.IterationPath");
                                            String areaPath = (String)tfsFields.get("System.AreaPath");
                                            Item _existingItem = (Item)existingChildItemMap.get(itemObject.get("id"));
                                            Map itemMap = this.getKendisItemFromTFSItem(session, null, itemObject, tfsFields, extraFields, tfsProjectsMap, tfsProjectsMapByName);
                                            Item item = null;
                                            if (PropertyValidator.isValid(itemMap.get("item"))) {
                                                item = (Item)itemMap.get("item");
                                            }
                                            if (item == null) {
                                                LOGGER.error("Child item skipped : " + (Integer)itemObject.get("id"));
                                                continue;
                                            }
                                            boolean isValid = this.isItemValidToAddForSession(item, session);
                                            if (!isValid) continue;
                                            item.setType(Item.USER_STORY);
                                            if (board.getSession().getTeamFieldEnable().booleanValue() && tfsFields.has(board.getSession().getTeamFieldTeamRefrence()) && PropertyValidator.isValid((Object)tfsFields.get(board.getSession().getTeamFieldTeamRefrence()))) {
                                                areaPath = (String)tfsFields.get(board.getSession().getTeamFieldTeamRefrence());
                                                item.setTfsAreaPath(areaPath);
                                            }
                                            if (PropertyValidator.isValid((Object)filter)) {
                                                item.setFetchedBy(filter.getFilterFetchedBy());
                                            }
                                            if (PropertyValidator.isValid((Object)filter)) {
                                                item.setTfsFilter(filter.getTfsId());
                                            }
                                            item.setParent(new Item((String)parentMapByChild.get(item.getTfsId())));
                                            item.setSessionBoards(sessionBoards);
                                            TeamContainer previousTeamContainer = null;
                                            Status previousStatus = null;
                                            if (existingChildItemMap.containsKey(item.getTfsId())) {
                                                Item existingItem = (Item)existingChildItemMap.get(item.getTfsId());
                                                if (PropertyValidator.isValid((Collection)existingItem.getTeamContainers())) {
                                                    previousTeamContainer = (TeamContainer)existingItem.getTeamContainers().get(0);
                                                }
                                                previousStatus = existingItem.getStatus();
                                                item.setId(existingItem.getId());
                                                item.setOriginItemId(existingItem.getOriginItemId());
                                                item.setDuplicateOfId(existingItem.getDuplicateOfId());
                                                item.setCreatedOn(existingItem.getCreatedOn());
                                                item.setCreatedBy(existingItem.getCreatedBy());
                                                item.setStartDate(existingItem.getStartDate());
                                                item.setEndDate(existingItem.getEndDate());
                                                if (!PropertyValidator.isValid((Object)existingItem.getTfsFilter()) && PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getTfsId())) {
                                                    item.setTfsFilter(filter.getTfsId());
                                                } else {
                                                    item.setTfsFilter(existingItem.getTfsFilter());
                                                }
                                                item.setSequence(existingItem.getSequence());
                                                item.setItemLinks(existingItem.getItemLinks());
                                                item.setBacklogSequence(existingItem.getBacklogSequence());
                                                if (session.getJiraDependencyEnabled().booleanValue() && PropertyValidator.isValid((Collection)session.getJiraLinkTypes())) {
                                                    if (PropertyValidator.isValid((Collection)existingItem.getJiraDependencies())) {
                                                        tfsDependenciesToBeDeleted.addAll(existingItem.getJiraDependencies());
                                                        for (ItemJiraDependency dependency : existingItem.getJiraDependencies()) {
                                                            if (!PropertyValidator.isValid((Object)dependency)) continue;
                                                            oldLinksMapByTfsIdAndLinkType.put(dependency.getTargetTFSItem().getTfsId() + "_" + dependency.getTfsLinkType(), dependency);
                                                            oldLinksMapByAlmId.put(dependency.getJiraDependencyId(), dependency);
                                                        }
                                                    }
                                                    item.setJiraDependencies(new ArrayList());
                                                }
                                                if (PropertyValidator.isValid((Object)existingItem.getFetchedBy())) {
                                                    item.setFetchedBy(existingItem.getFetchedBy());
                                                }
                                            } else {
                                                if (isReadOnly) {
                                                    newChildMap.put(item.getTfsId(), item.toSimpleObject());
                                                }
                                                if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
                                                    item.setFetchedBy(filter.getFilterFetchedBy());
                                                } else {
                                                    item.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                                                }
                                            }
                                            item.setUpdatedOn(new Date());
                                            item.setUpdatedBy(UserContextUtil.getUserContext().getUsername());
                                            if (!existingChildItemMap.containsKey(item.getTfsId())) {
                                                item.setCreatedOn(new Date());
                                                item.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                            }
                                            if (PropertyValidator.isValid((Object)(parentItem = (Item)parentItemMapById.get(item.getParent().getId())))) {
                                                if (!PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                                                    parentItem.setTeamContainers(new ArrayList());
                                                }
                                            } else {
                                                LOGGER.error("Parent item not exist : " + (Integer)itemObject.get("id"));
                                                continue;
                                            }
                                            boolean oldSubItemMappingFound = false;
                                            boolean newSubItemMappingFound = false;
                                            boolean parentItemMappingFound = false;
                                            if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                                item.setTeamContainers(new ArrayList());
                                            }
                                            if (PropertyValidator.isValid((Object)iterationPath)) {
                                                TFSTeamMapping _tfsTeamMapping;
                                                ArrayList<ItemSyncMapper> matchedSyncMappers = new ArrayList<ItemSyncMapper>();
                                                for (ItemSyncMapper syncMapper : syncMappers) {
                                                    if (PropertyValidator.isValid((Object)previousTeamContainer) && PropertyValidator.isValid((Object)syncMapper) && PropertyValidator.isValid((Object)syncMapper.getTfsSprint()) && previousTeamContainer.getContainer().getId().equals(syncMapper.getContainer().getId()) && previousTeamContainer.getTeam().getId().equals(syncMapper.getTeam().getId())) {
                                                        oldSubItemMappingFound = true;
                                                    }
                                                    if (!(PropertyValidator.isValid((Object)syncMapper) && PropertyValidator.isValid((Object)syncMapper.getTfsSprint()) && tfsTeamMapping.containsKey(syncMapper.getTeam().getId()) && board.getSession().getAreaPathDisabled().booleanValue())) {
                                                        // empty if block
                                                    }
                                                    if (!PropertyValidator.isValid((Object)syncMapper) || !PropertyValidator.isValid((Object)syncMapper.getTfsSprint()) || !iterationPath.equals(syncMapper.getTfsSprint().getIterationPath()) || !tfsTeamMapping.containsKey(syncMapper.getTeam().getId())) continue;
                                                    if (!board.getSession().getAreaPathDisabled().booleanValue()) {
                                                        _tfsTeamMapping = (TFSTeamMapping)tfsTeamMapping.get(syncMapper.getTeam().getId());
                                                        if (!PropertyValidator.isValid((Object)areaPath)) continue;
                                                        if (_tfsTeamMapping.getIncludeSubAreaPaths().booleanValue()) {
                                                            boolean check1 = areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) || areaPath.startsWith(_tfsTeamMapping.getTfsAreaPath() + "\\");
                                                            boolean check2 = true;
                                                            if (PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam())) {
                                                                check2 = false;
                                                                for (String aPath : _tfsTeamMapping.getTfsAreaPathsForTeam()) {
                                                                    if (!areaPath.equals(aPath) && !areaPath.startsWith(aPath + "\\")) continue;
                                                                    check2 = true;
                                                                    break;
                                                                }
                                                            }
                                                            if (!check1 && !check2) continue;
                                                            matchedSyncMappers.add(syncMapper);
                                                            continue;
                                                        }
                                                        if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                                                        matchedSyncMappers.add(syncMapper);
                                                        continue;
                                                    }
                                                    matchedSyncMappers.add(syncMapper);
                                                }
                                                if (PropertyValidator.isValid(matchedSyncMappers)) {
                                                    newSubItemMappingFound = true;
                                                    if (matchedSyncMappers.size() > 1) {
                                                        for (ItemSyncMapper syncMapper : matchedSyncMappers) {
                                                            _tfsTeamMapping = (TFSTeamMapping)tfsTeamMapping.get(syncMapper.getTeam().getId());
                                                            if (!areaPath.equals(_tfsTeamMapping.getTfsAreaPath()) && (!PropertyValidator.isValid((Collection)_tfsTeamMapping.getTfsAreaPathsForTeam()) || !_tfsTeamMapping.getTfsAreaPathsForTeam().contains(areaPath))) continue;
                                                            matchedSyncMappers.clear();
                                                            matchedSyncMappers.add(syncMapper);
                                                            break;
                                                        }
                                                    }
                                                    for (ItemSyncMapper itemSyncMapper : matchedSyncMappers) {
                                                        TeamContainer newTeamContainer = null;
                                                        if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                                                            for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                                                                if (!parentTeamContainer.getTeam().equals((Object)itemSyncMapper.getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.getContainer())) continue;
                                                                item.setTeamContainers(new ArrayList());
                                                                item.getTeamContainers().add(parentTeamContainer);
                                                                newTeamContainer = parentTeamContainer;
                                                                parentItemMappingFound = true;
                                                                item.applySprintDates(session, null, null);
                                                                break;
                                                            }
                                                        }
                                                        if (!parentItemMappingFound) {
                                                            TeamContainer teamContainer;
                                                            newTeamContainer = teamContainer = new TeamContainer();
                                                            teamContainer.setTeam(itemSyncMapper.getTeam());
                                                            teamContainer.setContainer(itemSyncMapper.getContainer());
                                                            teamContainer.setSequence(Double.valueOf((Double)extraFields.get("sequence") + 1000.0));
                                                            teamContainer.setSuspendActivity(true);
                                                            teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                                                            item.setTeamContainers(new ArrayList());
                                                            item.getTeamContainers().add(teamContainer);
                                                            item.applySprintDates(session, null, null);
                                                            parentItem.getTeamContainers().add(teamContainer);
                                                        }
                                                        if (isReadOnly || !PropertyValidator.isValid(newTeamContainer) || !PropertyValidator.isValid((Object)previousTeamContainer) || newTeamContainer.getId().equals(previousTeamContainer.getId())) continue;
                                                        ArrayList allItemLinks = new ArrayList();
                                                        List outboundItemLinks = item.getItemLinks();
                                                        if (PropertyValidator.isValid((Collection)outboundItemLinks)) {
                                                            for (int ind = 0; ind < outboundItemLinks.size(); ++ind) {
                                                                ItemLink link = (ItemLink)outboundItemLinks.get(ind);
                                                                link.setSourceTeamContainerId(newTeamContainer.getId());
                                                                link.setSourceFeatureId(item.getParent().getId());
                                                            }
                                                            allItemLinks.addAll(outboundItemLinks);
                                                        }
                                                        if (PropertyValidator.isValid((Collection)(inboundItemLinks = this.itemLinkRepository.findByTargetUserStoryId(item.getId())))) {
                                                            for (int ind = 0; ind < inboundItemLinks.size(); ++ind) {
                                                                ItemLink link = (ItemLink)inboundItemLinks.get(ind);
                                                                link.setTargetTeamContainerId(newTeamContainer.getId());
                                                                link.setTargetFeatureId(item.getParent().getId());
                                                            }
                                                            allItemLinks.addAll(inboundItemLinks);
                                                        }
                                                        if (!PropertyValidator.isValid(allItemLinks)) continue;
                                                        this.itemLinkRepository.save(allItemLinks);
                                                    }
                                                }
                                            }
                                            if (!oldSubItemMappingFound && !newSubItemMappingFound && PropertyValidator.isValid((Object)previousTeamContainer)) {
                                                item.setTeamContainers(new ArrayList());
                                                item.getTeamContainers().add(previousTeamContainer);
                                            }
                                            if (!isReadOnly && PropertyValidator.isValid((Object)previousStatus) && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                                if (autoCloseSubItemDependency && !previousStatus.getCategory().equals("Done") && item.getStatus().getCategory().equals("Done")) {
                                                    autoCloseLinksOfSubItems.add(item.getId());
                                                }
                                                if (autoOpenSubItemDependency && previousStatus.getCategory().equals("Done") && !item.getStatus().getCategory().equals("Done")) {
                                                    autoOpenLinksOfSubItems.add(item.getId());
                                                }
                                            }
                                            item.setTfsRelations(new ArrayList());
                                            if (!itemObject.isNull("relations") && PropertyValidator.isValid((Object)(relationsArray = itemObject.getJSONArray("relations")))) {
                                                ArrayList tfsChilds = new ArrayList();
                                                for (int j = 0; j < relationsArray.length(); ++j) {
                                                    JSONObject relationObject = relationsArray.getJSONObject(j);
                                                    String rel = relationObject.getString("rel");
                                                    List relationsToFetch = new ArrayList();
                                                    if (PropertyValidator.isValid((Object)filter) && PropertyValidator.isValid((Collection)filter.getBacklogMappingLinks())) {
                                                        inboundItemLinks = filter.getBacklogMappingLinks().iterator();
                                                        while (inboundItemLinks.hasNext()) {
                                                            TFSBacklogMappingLinks backlogMappingLink = (TFSBacklogMappingLinks)inboundItemLinks.next();
                                                            if (!item.getTfsProjectId().equals(backlogMappingLink.getTfsProjectId())) continue;
                                                            relationsToFetch.addAll(backlogMappingLink.getLinkTypes());
                                                            break;
                                                        }
                                                    } else {
                                                        relationsToFetch = item.getTfsLinkTypes();
                                                    }
                                                    String relURL = relationObject.getString("url");
                                                    if (PropertyValidator.isValid(relationsToFetch) && relationsToFetch.contains(rel)) {
                                                        String childId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                                        tfsChilds.add(childId);
                                                        parentMapByChild.put(childId, item.getId());
                                                    }
                                                    if (!PropertyValidator.isValid((Collection)session.getJiraLinkTypes()) || !session.getJiraLinkTypes().contains(rel)) continue;
                                                    String targetId = relURL.substring(relURL.lastIndexOf("/") + 1);
                                                    item.getTfsRelations().add(this.relationToMap(rel, targetId, relURL));
                                                    ItemJiraDependency tfsDependency = new ItemJiraDependency();
                                                    tfsDependency.setSessionBoardId(board.getId());
                                                    tfsDependency.setIsTFS(Boolean.valueOf(true));
                                                    tfsDependency.setSourceItemId(item.getId());
                                                    tfsDependency.setTargetItemId(null);
                                                    String targetItemURL = relURL.replace("_apis/wit/workItems", "_workitems/edit");
                                                    String sourceItemStatus = null;
                                                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                                                        sourceItemStatus = item.getStatus().getTitle();
                                                    }
                                                    TFSIssue tfsSourceIssue = new TFSIssue(item.getTfsId(), item.getTitle(), sourceItemStatus, item.getTfsURL(), item.getTfsApiURL());
                                                    TFSIssue tfsTargetIssue = new TFSIssue(targetId, null, null, targetItemURL, relURL);
                                                    tfsDependency.setSourceTFSItem(tfsSourceIssue);
                                                    tfsDependency.setTargetTFSItem(tfsTargetIssue);
                                                    tfsDependency.setTfsLinkType(rel);
                                                    tfsDependency.setCreatedBy(UserContextUtil.getUserContext().getUsername());
                                                    tfsDependency.setCreatedOn(new Date());
                                                    if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                                                        item.setJiraDependencies(new ArrayList());
                                                    }
                                                    if (PropertyValidator.isValid(oldLinksMapByTfsIdAndLinkType.get(targetId + "_" + rel))) {
                                                        ItemJiraDependency oldTfsDependency = (ItemJiraDependency)oldLinksMapByTfsIdAndLinkType.get(targetId + "_" + rel);
                                                        tfsDependenciesToBeDeleted.remove(oldTfsDependency);
                                                        oldTfsDependency.setSourceTFSItem(tfsDependency.getSourceTFSItem());
                                                        oldTfsDependency.setTargetTFSItem(tfsDependency.getTargetTFSItem());
                                                        item.getJiraDependencies().add(oldTfsDependency);
                                                        jiraDependencyMapByTFSSourceTarget.put(item.getId() + "_" + targetId + "_" + depCount, oldTfsDependency);
                                                        if (PropertyValidator.isValid((Object)oldTfsDependency.getJiraDependencyId()) && PropertyValidator.isValid(oldLinksMapByAlmId.get(oldTfsDependency.getJiraDependencyId()))) {
                                                            oldLinksMapByAlmId.remove(oldTfsDependency.getJiraDependencyId());
                                                        }
                                                    } else {
                                                        tfsDependency.setRaisedOn(new Date());
                                                        item.getJiraDependencies().add(tfsDependency);
                                                        jiraDependencyMapByTFSSourceTarget.put(item.getId() + "_" + targetId + "_" + depCount, tfsDependency);
                                                    }
                                                    ++depCount;
                                                    relationTFSIds.add(targetId);
                                                }
                                                childMapByParent.put(item.getId(), tfsChilds);
                                            }
                                            if (!isReadOnly && PropertyValidator.isValid((Collection)item.getItemLinks())) {
                                                ArrayList<String> itemLinksIdsList = new ArrayList<String>();
                                                for (ItemLink itemLink : item.getItemLinks()) {
                                                    if (!PropertyValidator.isValid((Object)itemLink.getAlmLinkId()) || !PropertyValidator.isValid(oldLinksMapByAlmId.get(itemLink.getAlmLinkId())) && session.getJiraDependencyEnabled().booleanValue()) continue;
                                                    itemLinksIdsList.add(itemLink.getAlmLinkId());
                                                    itemLink.setAlmLinkId(null);
                                                }
                                                List itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(itemLinksIdsList);
                                                for (ItemLink itemLink : itemLinks) {
                                                    itemLink.setAlmLinkId(null);
                                                }
                                                this.itemLinkRepository.save((Iterable)itemLinks);
                                            }
                                            tfsIdByItemId.put(item.getTfsId(), item.getId());
                                            if (existingChildItemMap.containsKey(item.getTfsId())) {
                                                KendisUtils.addChanges((boolean)isReadOnly, (boolean)true, (Item)item, (Item)((Item)existingChildItemMap.get(item.getTfsId())));
                                            } else {
                                                KendisUtils.addChanges((boolean)isReadOnly, (boolean)true, (Item)item, null);
                                            }
                                            childItems.add(item);
                                            missingChildMap.remove(item.getTfsId());
                                            continue;
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Exception while child detailed conversion :: " + StringUtils.getTraceString((Throwable)e));
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Exception while main child conversion :: " + StringUtils.getTraceString((Throwable)e));
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                                HashMap<String, Exception> exp = new HashMap<String, Exception>();
                                exp.put("kendisError", e);
                                this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
                            }
                        }
                    }
                    allParentItems.addAll(parentItems);
                    allChildItems.addAll(childItems);
                    if (!PropertyValidator.isValid(allParentsIdToFetchTitle)) continue;
                    try {
                        List subSetsChildIds = Lists.partition(allParentsIdToFetchTitle, (int)100);
                        for (List subSetChildIds : subSetsChildIds) {
                            idsChildStr = String.join((CharSequence)",", subSetChildIds);
                            childItemsStr = this.tfsUtils.getItems("1", idsChildStr, almAccount);
                            JSONObject _dataObjects = new JSONObject(childItemsStr);
                            String _count = _dataObjects.getString("count");
                            JSONArray _itemsArray = _dataObjects.getJSONArray("value");
                            for (int i = 0; i < _itemsArray.length(); ++i) {
                                JSONObject itemObject = _itemsArray.getJSONObject(i);
                                JSONObject tfsFields = itemObject.getJSONObject("fields");
                                String tfsId = itemObject.getString("id");
                                String title = (String)tfsFields.get("System.Title");
                                String workItemType = (String)tfsFields.get("System.WorkItemType");
                                String url = null;
                                if (!itemObject.isNull("_links")) {
                                    JSONObject links = itemObject.getJSONObject("_links");
                                    JSONObject linkHTML = links.getJSONObject("html");
                                    url = linkHTML.getString("href");
                                }
                                ArrayList _childItems = (ArrayList)itemByParentIdMap.get(tfsId);
                                for (Item cItem : _childItems) {
                                    TFSProject tfsProject;
                                    if (!PropertyValidator.isValid((Object)cItem.getTfsFieldByKey())) {
                                        cItem.setTfsFieldByKey(new HashMap());
                                    }
                                    if (PropertyValidator.isValid((Object)(tfsProject = (TFSProject)tfsProjectsMap.get(cItem.getTfsProjectId()))) && PropertyValidator.isValid((Object)tfsProject.getIconByItemType())) {
                                        String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                                        cItem.getTfsFieldByKey().put("tfsItemTypeIcon", itemTypeIconUrl);
                                    }
                                    cItem.getTfsFieldByKey().put("ParentTitle", title);
                                    cItem.getTfsFieldByKey().put("ParentURL", url);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception while fetching parent :: " + StringUtils.getTraceString((Throwable)ex));
                    }
                }
                catch (Exception e) {
                    isProcessFailed = true;
                    LOGGER.error("Exception while main parent conversion :: " + StringUtils.getTraceString((Throwable)e));
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    HashMap<String, Exception> exp = new HashMap<String, Exception>();
                    exp.put("kendisError", e);
                    this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                HashMap<String, Exception> exp = new HashMap<String, Exception>();
                exp.put("kendisError", e);
                this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
            }
        }
        if (!isProcessFailed) {
            Collection itemJiraDependenciesValues = jiraDependencyMapByTFSSourceTarget.values();
            if (PropertyValidator.isValid(itemJiraDependenciesValues)) {
                for (ItemJiraDependency jiraDependency : itemJiraDependenciesValues) {
                    Object targetId = null;
                    if (tfsIdByItemId.containsKey(jiraDependency.getTargetTFSItem().getTfsId())) {
                        targetId = (String)tfsIdByItemId.get(jiraDependency.getTargetTFSItem().getTfsId());
                    } else if (existingChildItemMap.containsKey(jiraDependency.getTargetTFSItem().getTfsId())) {
                        targetId = ((Item)existingChildItemMap.get(jiraDependency.getTargetTFSItem().getTfsId())).getId();
                    } else if (existingParentItemMap.containsKey(jiraDependency.getTargetTFSItem().getTfsId())) {
                        targetId = ((Item)existingParentItemMap.get(jiraDependency.getTargetTFSItem().getTfsId())).getId();
                    } else if (existingItemMap.containsKey(jiraDependency.getTargetTFSItem().getTfsId())) {
                        targetId = (String)existingItemMap.get(jiraDependency.getTargetTFSItem().getTfsId());
                    }
                    jiraDependency.setTargetItemId((String)targetId);
                    jiraDependency.setSessionBoardId(sessionBoardId);
                }
                if (!isReadOnly) {
                    this.itemJiraDependencyRepository.save(itemJiraDependenciesValues);
                    tfsDependenciesToBeDeleted.removeIf(v -> !PropertyValidator.isValid((Object)v));
                    if (PropertyValidator.isValid(tfsDependenciesToBeDeleted)) {
                        try {
                            this.itemJiraDependencyRepository.delete(tfsDependenciesToBeDeleted);
                        }
                        catch (Exception ex) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                        }
                    }
                }
            }
            for (String key : updatedExistingParentItemMap.keySet()) {
                if (((Boolean)updatedExistingParentItemMap.get(key)).booleanValue()) continue;
                itemsToBeDeleted.add(key);
            }
            if (!isReadOnly && PropertyValidator.isValid(itemsToBeDeleted)) {
                KendisUtils.putDeletedItems(removedItemsMap, (List)this.itemRepository.deleteByIdIn(itemsToBeDeleted));
            }
            if (!isReadOnly) {
                this.autoOpenCloseItemLinks(session, autoCloseLinksOfItems, autoCloseLinksOfSubItems, autoOpenLinksOfItems, autoOpenLinksOfSubItems, autoCloseLinksOfItemIds, autoOpenLinksOfItemIds);
                if (removeEmptyParents) {
                    Sets.SetView parentTCsWithOutChild = Sets.difference(remEP_parentTCMap.keySet(), remEP_childTCMap.keySet());
                    Sets.SetView parentTCsWithOutDependencies = Sets.difference((Set)parentTCsWithOutChild, remEP_itemLinksMap.keySet());
                    for (String tcId : parentTCsWithOutDependencies) {
                        if (!PropertyValidator.isValid((Object)((Item)remEP_parentTCMap.get(tcId)).getTfsId())) continue;
                        ((Item)remEP_parentTCMap.get(tcId)).getTeamContainers().remove(new TeamContainer(tcId));
                    }
                }
                this.itemRepository.save(allParentItems);
                this.itemRepository.save(allChildItems);
                this.customRepositoryImpl.bulkLogs(sessionBoardId, allParentItems, allChildItems, removedItemsMap, UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            }
            if (metaMap != null) {
                JSONObject pushJson = new JSONObject();
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    String parentStr = mapper.writeValueAsString(allParentItems);
                    String childStr = mapper.writeValueAsString(allChildItems);
                    String deletedStr = mapper.writeValueAsString(itemsToBeDeleted);
                    pushJson.put("isTFS", true);
                    JSONObject metaMapJSON = new JSONObject(metaMap);
                    if (!metaMapJSON.getString("event").equals("ResyncBoard")) {
                        pushJson.put("parentItems", (Object)parentStr);
                        pushJson.put("childItems", (Object)childStr);
                        pushJson.put("deletedItems", (Object)deletedStr);
                    }
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JsonProcessingException | JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        if (isReadOnly) {
            try {
                HashMap data = new HashMap();
                String key = "Other Items";
                if (PropertyValidator.isValid((Object)filter) && !filter.getId().contains("AddExisting")) {
                    key = filter.getId();
                }
                data.put(key, new HashMap());
                ((HashMap)data.get(key)).put("missingParent", missingItemMap.values());
                ((HashMap)data.get(key)).put("missingChild", missingChildMap.values());
                ((HashMap)data.get(key)).put("newParent", newItemMap.values());
                ((HashMap)data.get(key)).put("newChild", newChildMap.values());
                if (PropertyValidator.isValid(newProjects)) {
                    ((HashMap)data.get(key)).put("newProjects", newProjects);
                }
                this.pushProgressUpdates("ResyncLogging", syncId, gson.toJson(data), true);
                LOGGER.debug(" :: ResyncLogging  ");
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                HashMap<String, Exception> exp = new HashMap<String, Exception>();
                exp.put("kendisError", e);
                this.onResyncError(syncId, gson.toJson(exp), sessionBoardId, Boolean.valueOf(isReadOnly));
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("NewFeatures", newItemMap.values());
        return response;
    }

    private void autoOpenCloseItemLinks(Session session, List<String> autoCloseLinksOfItems, List<String> autoCloseLinksOfSubItems, List<String> autoOpenLinksOfItems, List<String> autoOpenLinksOfSubItems, List<String> autoCloseLinksOfItemIds, List<String> autoOpenLinksOfItemIds) {
        String parentKey = session.getItemLinkStatusDependentOn();
        String childKey = session.getSubItemLinkStatusDependentOn();
        HashMap openOrResolveDependenciesMap = new HashMap();
        HashSet openStatusDependencies = new HashSet();
        HashSet resolveStatusDependencies = new HashSet();
        openOrResolveDependenciesMap.put("Open", openStatusDependencies);
        openOrResolveDependenciesMap.put("Resolved", resolveStatusDependencies);
        HashMap<String, Status> linkStatusMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid(autoCloseLinksOfItems) || PropertyValidator.isValid(autoCloseLinksOfSubItems) || PropertyValidator.isValid(autoOpenLinksOfItems) || PropertyValidator.isValid(autoOpenLinksOfSubItems)) {
            boolean ignoreIfWrongItem;
            String linkOldStatus;
            String itemId;
            boolean ignoreUpdate;
            boolean add;
            List<ItemJiraDependency> itemJiraDependenciesList;
            List statuses = this.statusRepository.findByWorkFlow(session.getDependencyWorkFlow());
            Status openStatus = null;
            Status closeStatus = null;
            for (Status st : statuses) {
                if (openStatus == null && st.getCategory().equals("ToDo")) {
                    openStatus = st;
                    linkStatusMap.put("ToDo", openStatus);
                }
                if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                closeStatus = st;
                linkStatusMap.put("Done", closeStatus);
            }
            ArrayList<ItemLink> linksToBeUpdated = new ArrayList<ItemLink>();
            ArrayList<ItemJiraDependency> itemJiraDependencyToBeUpdated = new ArrayList<ItemJiraDependency>();
            List itemLinks = null;
            List itemJiraDependencies = null;
            List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
            if (PropertyValidator.isValid(autoCloseLinksOfItems)) {
                itemJiraDependenciesList = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoCloseLinksOfItemIds, autoCloseLinksOfItemIds);
                itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(autoCloseLinksOfItems, autoCloseLinksOfItems);
                if (parentKey.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (parentKey.equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoCloseLinksOfItemIds.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoCloseLinksOfItemIds.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        ignoreUpdate = false;
                        boolean ignoreIfWrongItem2 = true;
                        if (parentKey.equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || parentKey.equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                        itemId = "";
                        itemId = autoCloseLinksOfItemIds.contains(itemLink.getSourceFeatureId()) ? itemLink.getSourceFeatureId() : itemLink.getTargetFeatureId();
                        ignoreIfWrongItem2 = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, itemId, kendisLinkTypes, parentKey, session);
                        ignoreUpdate = session.getIgnoreUpdateIfManualResolvedForItem() != false && itemLink.getIsManuallyResolved() != false;
                        if (ignoreUpdate || ignoreIfWrongItem2) continue;
                        linkOldStatus = itemLink.getStatus();
                        itemLink.setStatus("Resolved");
                        if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                            Set resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                            resolveLinks.add(itemLink.getAlmLinkId());
                        }
                        itemLink.setWfStatus(closeStatus);
                        itemLink.setResolvedOn(new Date());
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        String itemId2 = "";
                        itemId2 = autoCloseLinksOfItemIds.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId2, kendisLinkTypes, parentKey, session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(closeStatus);
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                }
            }
            if (PropertyValidator.isValid(autoOpenLinksOfItems)) {
                itemJiraDependenciesList = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoOpenLinksOfItemIds, autoOpenLinksOfItemIds);
                itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(autoOpenLinksOfItems, autoOpenLinksOfItems);
                if (parentKey.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (parentKey.equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoOpenLinksOfItemIds.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoOpenLinksOfItemIds.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        ignoreUpdate = false;
                        boolean ignoreIfWrongItem3 = true;
                        if (parentKey.equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || parentKey.equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                        itemId = "";
                        itemId = autoOpenLinksOfItemIds.contains(itemLink.getSourceFeatureId()) ? itemLink.getSourceFeatureId() : itemLink.getTargetFeatureId();
                        ignoreIfWrongItem3 = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, itemId, kendisLinkTypes, parentKey, session);
                        ignoreUpdate = session.getIgnoreUpdateIfManualResolvedForItem() != false && itemLink.getIsManuallyResolved() != false;
                        if (ignoreUpdate || ignoreIfWrongItem3) continue;
                        linkOldStatus = itemLink.getStatus();
                        itemLink.setStatus("Open");
                        itemLink.setWfStatus(openStatus);
                        itemLink.setResolvedOn(null);
                        if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                            Set openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                            openLinks.add(itemLink.getAlmLinkId());
                        }
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        String itemId3 = "";
                        itemId3 = autoOpenLinksOfItemIds.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId3, kendisLinkTypes, parentKey, session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(openStatus);
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                }
            }
            if (PropertyValidator.isValid(autoCloseLinksOfSubItems)) {
                itemJiraDependenciesList = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoCloseLinksOfSubItems, autoCloseLinksOfSubItems);
                itemLinks = this.itemLinkRepository.findByTargetUserStoryIdInOrSourceUserStoryIdIn(autoCloseLinksOfSubItems, autoCloseLinksOfSubItems);
                if (childKey.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (childKey.equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoCloseLinksOfSubItems.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoCloseLinksOfSubItems.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        ignoreUpdate = false;
                        boolean ignoreIfWrongItem4 = true;
                        itemId = "";
                        itemId = autoCloseLinksOfSubItems.contains(itemLink.getSourceUserStoryId()) ? itemLink.getSourceUserStoryId() : itemLink.getTargetUserStoryId();
                        ignoreIfWrongItem4 = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, itemId, kendisLinkTypes, childKey, session);
                        ignoreUpdate = session.getIgnoreUpdateIfManualResolvedForSubItem() != false && itemLink.getIsManuallyResolved() != false;
                        if (ignoreUpdate || ignoreIfWrongItem4) continue;
                        itemLink.setStatus("Resolved");
                        itemLink.setWfStatus(closeStatus);
                        itemLink.setResolvedOn(new Date());
                        if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                            Set resolveLinks = (Set)openOrResolveDependenciesMap.get("Resolved");
                            resolveLinks.add(itemLink.getAlmLinkId());
                        }
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        String itemId4 = "";
                        itemId4 = autoCloseLinksOfSubItems.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId4, kendisLinkTypes, childKey, session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(closeStatus);
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                }
            }
            if (PropertyValidator.isValid(autoOpenLinksOfSubItems)) {
                itemJiraDependenciesList = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoOpenLinksOfSubItems, autoOpenLinksOfSubItems);
                itemLinks = this.itemLinkRepository.findByTargetUserStoryIdInOrSourceUserStoryIdIn(autoOpenLinksOfSubItems, autoOpenLinksOfSubItems);
                if (childKey.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (childKey.equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoOpenLinksOfSubItems.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoOpenLinksOfSubItems.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        ignoreUpdate = false;
                        boolean ignoreIfWrongItem5 = true;
                        itemId = "";
                        itemId = autoOpenLinksOfSubItems.contains(itemLink.getSourceUserStoryId()) ? itemLink.getSourceUserStoryId() : itemLink.getTargetUserStoryId();
                        ignoreIfWrongItem5 = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, itemId, kendisLinkTypes, childKey, session);
                        ignoreUpdate = session.getIgnoreUpdateIfManualResolvedForSubItem() != false && itemLink.getIsManuallyResolved() != false;
                        if (ignoreUpdate || ignoreIfWrongItem5) continue;
                        itemLink.setStatus("Open");
                        itemLink.setWfStatus(openStatus);
                        itemLink.setResolvedOn(null);
                        if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                            Set openLinks = (Set)openOrResolveDependenciesMap.get("Open");
                            openLinks.add(itemLink.getAlmLinkId());
                        }
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        String itemId5 = "";
                        itemId5 = autoOpenLinksOfSubItems.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId5, kendisLinkTypes, childKey, session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(openStatus);
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                }
            }
            if (PropertyValidator.isValid(linksToBeUpdated)) {
                this.itemLinkRepository.save(linksToBeUpdated);
            }
            if (PropertyValidator.isValid(itemJiraDependencyToBeUpdated)) {
                this.itemJiraDependencyRepository.save(itemJiraDependencyToBeUpdated);
            }
            this.customRepositoryImpl.updateJiraDependencyStatusOnItemStatus(openOrResolveDependenciesMap, linkStatusMap, session.getActiveSessionBoard());
        }
    }

    private List<ItemJiraDependency> getItemTFSDependencies(JiraIssue jIssue, List<String> jiraLinkTypes) {
        ArrayList<ItemJiraDependency> itemTFSDependencies = new ArrayList<ItemJiraDependency>();
        return itemTFSDependencies;
    }

    public Date getCurrentUtcTime() {
        OffsetDateTime utc = OffsetDateTime.now(ZoneOffset.UTC);
        Date date = Date.from(utc.toInstant());
        return date;
    }

    public static Date dateToUTC(Date date) {
        return new Date(date.getTime() - (long)Calendar.getInstance().getTimeZone().getOffset(date.getTime()));
    }

    private void addMappedTfsFieldsToItem(Item item, JSONObject tfsFields, List<FieldMapping> mappings) {
        for (FieldMapping fm : mappings) {
            String fieldId = fm.getMappedToFieldId();
            if (fieldId == null || !tfsFields.keySet().contains(fieldId)) continue;
            item.getTfsFieldByKey().put(fieldId, tfsFields.get(fieldId));
        }
    }

    private Map<String, Object> getKendisItemFromTFSItem(Session session, Item item, JSONObject itemObject, JSONObject tfsFields, Map<String, Object> extraFields, Map<String, TFSProject> tfsProjectsMap, Map<String, TFSProject> tfsProjectsMapByName) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (item == null) {
            item = new Item();
            item.setId(ObjectId.get().toString());
            item.setSuspendActivity(true);
            item.setSuspendPush(true);
        }
        item.setLastSyncDate(this.getCurrentUtcTime());
        item.setTfsFieldByKey(new HashMap());
        try {
            Map userMap;
            Object assignedTo;
            String rev = itemObject.getString("rev");
            String tfsId = itemObject.getString("id");
            String url = itemObject.getString("url");
            item.setAlmRevision(rev);
            String areaPath = (String)tfsFields.get("System.AreaPath");
            String teamProject = (String)tfsFields.get("System.TeamProject");
            String iterationPath = (String)tfsFields.get("System.IterationPath");
            String title = (String)tfsFields.get("System.Title");
            String state = (String)tfsFields.get("System.State");
            String workItemType = (String)tfsFields.get("System.WorkItemType");
            if (!tfsFields.isNull("System.AssignedTo")) {
                assignedTo = tfsFields.get("System.AssignedTo");
                userMap = this.itemTfsSyncService.getTfsUserMap(assignedTo);
                item.getTfsFieldByKey().put("AssignedTo", userMap);
            }
            if (!tfsFields.isNull("System.CreatedBy")) {
                assignedTo = tfsFields.get("System.CreatedBy");
                userMap = this.itemTfsSyncService.getTfsUserMap(assignedTo);
                item.getTfsFieldByKey().put("CreatedBy", userMap);
            }
            if (!tfsFields.isNull("System.CreatedDate")) {
                String createdDate = tfsFields.getString("System.CreatedDate");
                item.getTfsFieldByKey().put("CreatedDate", createdDate);
            }
            if (!tfsFields.isNull("System.ChangedDate")) {
                String changedDate = tfsFields.getString("System.ChangedDate");
                item.getTfsFieldByKey().put("ChangedDate", changedDate);
            }
            if (!tfsFields.isNull("System.IterationId")) {
                // empty if block
            }
            if (!itemObject.isNull("_links")) {
                JSONObject links = itemObject.getJSONObject("_links");
                JSONObject linkHTML = links.getJSONObject("html");
                item.setTfsURL(linkHTML.getString("href"));
            }
            String[] urlComponents = url.split("/");
            String projectId = null;
            projectId = urlComponents.length >= 9 ? urlComponents[4] : urlComponents[3];
            try {
                TFSProject tfsProject = null;
                if (tfsProjectsMap.containsKey(projectId)) {
                    tfsProject = tfsProjectsMap.get(projectId);
                    response.put("project", tfsProject);
                } else {
                    tfsProject = tfsProjectsMapByName.get(teamProject);
                    if (!PropertyValidator.isValid((Object)tfsProject)) {
                        response.put("success", Boolean.FALSE);
                        response.put("project", teamProject);
                        return response;
                    }
                    projectId = tfsProject.getTfsId();
                }
                if (PropertyValidator.isValid((Object)tfsProject)) {
                    if (PropertyValidator.isValid((Object)tfsProject.getIconByItemType())) {
                        String itemTypeIconUrl = (String)tfsProject.getIconByItemType().get(workItemType);
                        item.setTfsItemTypeIcon(itemTypeIconUrl);
                    } else {
                        item.setTfsItemTypeIcon(null);
                    }
                }
                response.put("project", tfsProject);
                if (PropertyValidator.isValid((Object)tfsProject)) {
                    String dateStr;
                    String dueDateStr;
                    Double storyPoint;
                    if (Item.FEATURE.equals((String)extraFields.get("type"))) {
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEstimationField()) && !tfsFields.isNull(tfsProject.getItemEstimationField())) {
                            LOGGER.debug("==================================");
                            LOGGER.debug("FEATURE_POINT_CHECK");
                            LOGGER.debug("Item ID : " + item.getTfsId());
                            LOGGER.debug("Field ID : " + tfsProject.getItemEstimationField());
                            LOGGER.debug("Field Value : " + String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                            LOGGER.debug("==================================");
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            item.setStoryPoints(storyPoint);
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField()) && !tfsFields.isNull(tfsProject.getItemDueDateField())) {
                            dueDateStr = (String)tfsFields.get(tfsProject.getItemDueDateField());
                            item.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField()) && !tfsFields.isNull(tfsProject.getItemStartDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getItemStartDateField());
                            item.setStartDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField()) && !tfsFields.isNull(tfsProject.getItemEndDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getItemEndDateField());
                            item.setEndDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getWsjfAlmField()) && !tfsFields.isNull(tfsProject.getWsjfAlmField())) {
                            int tempAlmScore = (Integer)tfsFields.get(tfsProject.getWsjfAlmField());
                            item.setAlmScoreField(Double.valueOf(tempAlmScore));
                        }
                    } else if (Item.USER_STORY.equals((String)extraFields.get("type"))) {
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField()) && !tfsFields.isNull(tfsProject.getSubItemEstimationField())) {
                            LOGGER.debug("==================================");
                            LOGGER.debug("STORY_POINT_CHECK");
                            LOGGER.debug("Item ID : " + item.getTfsId());
                            LOGGER.debug("Field ID : " + tfsProject.getSubItemEstimationField());
                            LOGGER.debug("Field Value : " + String.valueOf(tfsFields.get(tfsProject.getSubItemEstimationField())));
                            LOGGER.debug("==================================");
                            storyPoint = Double.parseDouble(String.valueOf(tfsFields.get(tfsProject.getSubItemEstimationField())));
                            if (PropertyValidator.isValid((Object)storyPoint)) {
                                storyPoint = StringUtils.round((double)storyPoint, (int)2);
                            }
                            item.setStoryPoints(storyPoint);
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField()) && !tfsFields.isNull(tfsProject.getSubItemDueDateField())) {
                            dueDateStr = (String)tfsFields.get(tfsProject.getSubItemDueDateField());
                            item.setDueDate(PropertyValidator.parseDate((String)dueDateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField()) && !tfsFields.isNull(tfsProject.getSubItemStartDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getSubItemStartDateField());
                            item.setStartDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                        if (PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField()) && !tfsFields.isNull(tfsProject.getSubItemEndDateField())) {
                            dateStr = (String)tfsFields.get(tfsProject.getSubItemEndDateField());
                            item.setEndDate(PropertyValidator.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                        }
                    }
                    if (PropertyValidator.isValid((Collection)tfsProject.getSelectedFields())) {
                        for (HashMap field : tfsProject.getSelectedFields()) {
                            String key = (String)field.get("referenceName");
                            String type = (String)field.get("type");
                            ItemJiraFieldMap fieldMap = null;
                            boolean newField = false;
                            if (PropertyValidator.isValid((Collection)item.getTfsFieldMap())) {
                                fieldMap = item.getTfsFieldMap().stream().filter(fm -> fm.getKey().equals(key)).findAny().orElse(null);
                            }
                            if (fieldMap == null) {
                                fieldMap = new ItemJiraFieldMap();
                                newField = true;
                            }
                            fieldMap.setKey(key);
                            fieldMap.setName((String)field.get("name"));
                            fieldMap.setType((String)field.get("type"));
                            if (tfsFields.has(key)) {
                                Object value = tfsFields.get(key);
                                if (type.equals("integer") || type.equals("double") || type.equals("boolean") || type.equals("dateTime")) {
                                    String _value = String.valueOf(value);
                                    fieldMap.setValue(_value);
                                } else if (value instanceof String) {
                                    fieldMap.setValue((String)value);
                                }
                            }
                            if (!newField) continue;
                            if (item.getTfsFieldMap() == null) {
                                item.setTfsFieldMap(new ArrayList());
                            }
                            item.getTfsFieldMap().add(fieldMap);
                        }
                    }
                }
            }
            catch (ClassCastException castException) {
                LOGGER.error(StringUtils.getTraceString((Throwable)castException));
            }
            catch (Exception exception) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            }
            String statusKey = projectId + workItemType + state;
            if (PropertyValidator.isValid((Object)extraFields.get("statusMap"))) {
                HashMap statusMap = (HashMap)extraFields.get("statusMap");
                item.setStatus((Status)statusMap.get(statusKey));
            }
            item.setTfsId(tfsId);
            item.setTitle(title);
            item.setTfsItemType(workItemType);
            item.setTfsProject(teamProject);
            item.setTfsProjectId(projectId);
            item.setTfsApiURL(url);
            item.setTfsAreaPath(areaPath);
            item.setTfsIterationPath(iterationPath);
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (session != null && session.getScoreCard() != null && session.getScoreCard().getMappings() != null && itemObject.keySet().contains("fields")) {
            this.scoreCardService.putScoreCardFieldsInItemFromJson(session.getScoreCard().getMappings(), item, (JSONObject)itemObject.get("fields"));
            this.scoreCardService.updateScorecardFieldsAccordingToMappedFields(session, item, item.getTfsFieldByKey());
        }
        response.put("success", Boolean.TRUE);
        response.put("item", item);
        return response;
    }

    public void removeRelationInTFS(String childItemId, String parentItemId, AlmAccount almAccount) throws Exception {
        String resultStr = this.tfsUtils.getItem(childItemId, "$expand=relations", almAccount);
        if (PropertyValidator.isValid((Object)resultStr)) {
            try {
                JSONObject itemObject = new JSONObject(resultStr);
                JSONArray relationsArray = itemObject.getJSONArray("relations");
                Integer relationIndexToBeRemoved = null;
                for (int i = 0; i < relationsArray.length(); ++i) {
                    JSONObject relationObject = relationsArray.getJSONObject(i);
                    String relation = relationObject.getString("rel");
                    String relURL = relationObject.getString("url");
                    String itemTFSId = relURL.substring(relURL.lastIndexOf("/") + 1);
                    if (!itemTFSId.equals(parentItemId)) continue;
                    relationIndexToBeRemoved = i;
                    break;
                }
                if (PropertyValidator.isValid(relationIndexToBeRemoved)) {
                    HashMap<String, Integer> fields = new HashMap<String, Integer>();
                    fields.put("removeRelation", relationIndexToBeRemoved);
                    this.tfsUtils.updateItemInTFS(childItemId, fields, almAccount);
                }
            }
            catch (JSONException ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }
    }

    public Item addRelationLinkInTFS(Item actionItem, AlmAccount almAccount, HashMap<String, Object> fields, Item targetItem, ItemLink itemLink) {
        try {
            TFSResponse response = this.tfsUtils.updateItemInTFS(actionItem.getTfsId(), fields, almAccount);
            if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
                ItemJiraDependency tfsDependency = new ItemJiraDependency();
                tfsDependency.setIsTFS(Boolean.valueOf(true));
                tfsDependency.setSourceItemId(actionItem.getId());
                tfsDependency.setTargetItemId(targetItem.getId());
                String sourceItemStatus = null;
                String targetItemStatus = null;
                if (PropertyValidator.isValid((Object)actionItem.getStatus())) {
                    sourceItemStatus = actionItem.getStatus().getTitle();
                }
                if (PropertyValidator.isValid((Object)targetItem.getStatus())) {
                    targetItemStatus = targetItem.getStatus().getTitle();
                }
                TFSIssue tfsSourceIssue = new TFSIssue(actionItem.getTfsId(), actionItem.getTitle(), sourceItemStatus, actionItem.getTfsURL(), actionItem.getTfsApiURL());
                TFSIssue tfsTargetIssue = new TFSIssue(targetItem.getTfsId(), targetItem.getTitle(), targetItemStatus, targetItem.getTfsURL(), targetItem.getTfsApiURL());
                tfsDependency.setSourceTFSItem(tfsSourceIssue);
                tfsDependency.setTargetTFSItem(tfsTargetIssue);
                tfsDependency.setTfsLinkType(itemLink.getType());
                tfsDependency.setJiraDependencyId(actionItem.getTfsId() + "-" + targetItem.getTfsId());
                tfsDependency.setSessionBoardId(((SessionBoard)actionItem.getSessionBoards().get(0)).getId());
                tfsDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)tfsDependency);
                if (!PropertyValidator.isValid((Collection)actionItem.getJiraDependencies())) {
                    actionItem.setJiraDependencies(new ArrayList());
                }
                actionItem.getJiraDependencies().add(tfsDependency);
                Item updateItem = (Item)this.itemRepository.save((Object)actionItem);
                itemLink.setSyncTfs(Boolean.valueOf(true));
                itemLink.setAlmLinkId(actionItem.getTfsId() + "-" + targetItem.getTfsId());
                this.customRepository.updateItemLinkOnAlmLinking(itemLink, "TFS");
                ItemJiraDependency reverseDependency = new ItemJiraDependency();
                reverseDependency.setIsTFS(Boolean.valueOf(true));
                reverseDependency.setSourceItemId(targetItem.getId());
                reverseDependency.setTargetItemId(actionItem.getId());
                reverseDependency.setSourceTFSItem(tfsTargetIssue);
                reverseDependency.setTargetTFSItem(tfsSourceIssue);
                reverseDependency.setJiraDependencyId(actionItem.getTfsId() + "-" + targetItem.getTfsId());
                reverseDependency.setSessionBoardId(((SessionBoard)actionItem.getSessionBoards().get(0)).getId());
                String linkType = itemLink.getType();
                String[] parts = linkType.split("-");
                if (PropertyValidator.isValid((String[])parts) && parts.length == 2) {
                    String _linkType = parts[0] + "-";
                    if (parts[1].equals("Forward")) {
                        _linkType = _linkType + "Reverse";
                    } else if (parts[1].equals("Reverse")) {
                        _linkType = _linkType + "Forward";
                    }
                    reverseDependency.setTfsLinkType(_linkType);
                } else {
                    reverseDependency.setTfsLinkType(linkType);
                }
                reverseDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)reverseDependency);
                if (!PropertyValidator.isValid((Collection)targetItem.getJiraDependencies())) {
                    targetItem.setJiraDependencies(new ArrayList());
                }
                targetItem.getJiraDependencies().add(reverseDependency);
                Item updateTargetItem = (Item)this.itemRepository.save((Object)targetItem);
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("isTFS", true);
                    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                    String itemStr = gsonExclusive.toJson((Object)updateItem);
                    pushJson.put("data", (Object)itemStr);
                    pushJson.put("metaMap", (Object)("{\"event\":\"TFSDependency\", \"boardId\":\"" + ((SessionBoard)updateItem.getSessionBoards().get(0)).getId() + "\",\"itemLinkId\":\"" + itemLink.getId() + "\",\"jiraId\":\"" + itemLink.getAlmLinkId() + "\"}"));
                    PushSender.sendMsg((String)pushJson.toString());
                    itemStr = gsonExclusive.toJson((Object)updateTargetItem);
                    pushJson.put("data", (Object)itemStr);
                    pushJson.put("metaMap", (Object)("{\"event\":\"TFSDependency\", \"boardId\":\"" + ((SessionBoard)updateTargetItem.getSessionBoards().get(0)).getId() + "\"}"));
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ViztrendJiraException vje) {
            Item freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setMetaMap(actionItem.getMetaMap());
            LOGGER.warn("Failed to save TFS issue.");
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            freshItem.setErrorInAlmSync(Boolean.valueOf(true));
            freshItem.setAlmErrorMessage(vje.getMessage());
            this.itemRepository.save((Object)freshItem);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            LOGGER.error("Updating TFS item :: FAILED.. error message saved in item.", (Throwable)vje);
            this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (User)loggedInUser, (ViztrendJiraException)vje, (Boolean)false));
            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (String)"AlmError", null, null, null, null, null, (Gson)gsonExclusive, (String)vje.getMessage()));
        }
        return null;
    }

    public Item createItemInTFS(Item actionItem, AlmAccount almAccount, boolean existingItem) {
        Item freshItem;
        Object tc;
        ItemSyncMapper itemSyncMapper;
        String tfsLinkType;
        SimpleDateFormat df;
        TimeZone tz;
        Session session = ((SessionBoard)actionItem.getSessionBoards().get(0)).getSession();
        String tfsProjectId = actionItem.getTfsProjectId();
        TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(session.getId(), tfsProjectId);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("title", actionItem.getTitle());
        if (PropertyValidator.isValid((Object)actionItem.getStatus())) {
            fields.put("state", actionItem.getStatus().getTitle());
        }
        if (PropertyValidator.isValid((Object)actionItem.getDueDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String targetDate = df.format(actionItem.getDueDate());
            if (PropertyValidator.isValid((Object)tfsProject)) {
                if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemDueDateField())) {
                    fields.put(tfsProject.getItemDueDateField(), targetDate);
                } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField())) {
                    fields.put(tfsProject.getSubItemDueDateField(), targetDate);
                }
            }
        }
        if (PropertyValidator.isValid((Object)actionItem.getStartDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String startDate = df.format(actionItem.getStartDate());
            if (PropertyValidator.isValid((Object)tfsProject) && actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemStartDateField())) {
                fields.put(tfsProject.getItemStartDateField(), startDate);
            }
        }
        if (PropertyValidator.isValid((Object)actionItem.getEndDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String endDate = df.format(actionItem.getEndDate());
            if (PropertyValidator.isValid((Object)tfsProject) && actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemEndDateField())) {
                fields.put(tfsProject.getItemEndDateField(), endDate);
            }
        }
        if (PropertyValidator.isValid((Object)actionItem.getTfsItemType())) {
            fields.put("itemType", actionItem.getTfsItemType());
        }
        if (PropertyValidator.isValid((Object)actionItem.getStoryPoints()) && PropertyValidator.isValid((Object)tfsProject)) {
            if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemEstimationField())) {
                fields.put(tfsProject.getItemEstimationField(), actionItem.getStoryPoints());
            } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField())) {
                fields.put(tfsProject.getSubItemEstimationField(), actionItem.getStoryPoints());
            }
        }
        String project = actionItem.getTfsProject();
        if (actionItem.getType().equals(Item.USER_STORY)) {
            if (PropertyValidator.isValid((Object)actionItem.getTfsAreaPath()) && actionItem.getTfsAreaPath().length() > 0) {
                String tfsAreaPath = actionItem.getTfsAreaPath();
                if (session.getTeamFieldEnable().booleanValue()) {
                    fields.put(session.getTeamFieldTeamRefrence(), tfsAreaPath);
                } else {
                    fields.put("areaPath", tfsAreaPath);
                }
            } else {
                fields.put("areaPath", project);
            }
            if (PropertyValidator.isValid((Object)actionItem.getTfsIterationPath()) && actionItem.getTfsIterationPath().length() > 0) {
                fields.put("iterationPath", actionItem.getTfsIterationPath());
            } else {
                fields.put("iterationPath", project);
            }
            if (PropertyValidator.isValid((Collection)actionItem.getTfsLinkTypes())) {
                tfsLinkType = (String)actionItem.getTfsLinkTypes().get(0);
                JSONObject relationObject = new JSONObject();
                try {
                    Item parentItem = (Item)this.itemRepository.findOne((Serializable)((Object)actionItem.getParent().getId()));
                    if (PropertyValidator.isValid((Object)parentItem.getTfsId())) {
                        relationObject.put("rel", (Object)tfsLinkType);
                        relationObject.put("url", (Object)parentItem.getTfsURL());
                        fields.put("relation", relationObject);
                    }
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        } else {
            if (PropertyValidator.isValid((Collection)actionItem.getTfsLinkTypes())) {
                tfsLinkType = (String)actionItem.getTfsLinkTypes().get(0);
                List children = this.itemRepository.findByParent(actionItem);
                if (PropertyValidator.isValid((Collection)children)) {
                    JSONArray relations = new JSONArray();
                    for (Item child : children) {
                        if (!PropertyValidator.isValid((Object)child.getTfsId())) continue;
                        JSONObject relationObject = new JSONObject();
                        JSONObject valueObject = new JSONObject();
                        valueObject.put("rel", (Object)tfsLinkType);
                        valueObject.put("url", (Object)child.getTfsURL());
                        relationObject.put("path", (Object)"/relations/-");
                        relationObject.put("value", (Object)valueObject);
                        relations.put((Object)relationObject);
                    }
                    fields.put("relations", relations);
                }
            }
            if (PropertyValidator.isValid((Object)actionItem.getTfsAreaPath())) {
                if (session.getTeamFieldEnable().booleanValue()) {
                    fields.put("areaPath", actionItem.getTfsAreaPath());
                } else {
                    fields.put("areaPath", actionItem.getTfsAreaPath());
                }
            } else {
                if (!session.getTeamFieldEnable().booleanValue()) {
                    fields.put("areaPath", project);
                }
                actionItem.setTfsAreaPath(project);
            }
            if (PropertyValidator.isValid((Object)actionItem.getTfsIterationPath())) {
                fields.put("iterationPath", actionItem.getTfsIterationPath());
            } else {
                fields.put("iterationPath", project);
            }
        }
        if (PropertyValidator.isValid((Collection)actionItem.getTeamContainers()) && !existingItem && PropertyValidator.isValid((Object)(itemSyncMapper = this.itemSyncMapperRepository.findByTeamAndContainer((tc = (TeamContainer)actionItem.getTeamContainers().get(0)).getTeam(), tc.getContainer()))) && PropertyValidator.isValid((Object)itemSyncMapper.getTfsSprint()) && PropertyValidator.isValid((Object)itemSyncMapper.getTfsSprint().getIterationPath())) {
            fields.put("iterationPath", itemSyncMapper.getTfsSprint().getIterationPath());
        }
        if (PropertyValidator.isValid((Collection)actionItem.getTfsFieldMap())) {
            for (ItemJiraFieldMap tfsField : actionItem.getTfsFieldMap()) {
                if (tfsField.getType().equals("1boolean")) {
                    fields.put(tfsField.getKey(), Boolean.parseBoolean(tfsField.getValue()));
                    continue;
                }
                if (tfsField.getType().equals("integer")) {
                    if (!PropertyValidator.isValid((Object)tfsField.getValue())) continue;
                    fields.put(tfsField.getKey(), Integer.parseInt(tfsField.getValue()));
                    continue;
                }
                if (tfsField.getType().equals("double")) {
                    if (!PropertyValidator.isValid((Object)tfsField.getValue())) continue;
                    fields.put(tfsField.getKey(), Double.parseDouble(tfsField.getValue()));
                    continue;
                }
                fields.put(tfsField.getKey(), tfsField.getValue());
            }
        }
        try {
            TFSResponse response = this.tfsUtils.createItemInTFS(actionItem.getTfsProjectId(), fields, almAccount);
            freshItem = this.itemRepository.findById(actionItem.getId());
            try {
                JSONObject tfsItem = new JSONObject(response.getContent());
                String tfsId = tfsItem.getString("id");
                String url = tfsItem.getString("url");
                String rev = tfsItem.getString("rev");
                if (!tfsItem.isNull("_links")) {
                    JSONObject links = tfsItem.getJSONObject("_links");
                    JSONObject linkHTML = links.getJSONObject("html");
                    freshItem.setTfsURL(linkHTML.getString("href"));
                }
                freshItem.setErrorInAlmSync(Boolean.valueOf(false));
                freshItem.setAlmErrorMessage(null);
                freshItem.setTfsId(tfsId);
                freshItem.setAlmRevision(rev);
                if (PropertyValidator.isValid((Object)actionItem.getMetaMap())) {
                    JSONObject metaObj = new JSONObject(actionItem.getMetaMap());
                    metaObj.put("event", (Object)"Update");
                    metaObj.put("push", (Object)"Self");
                    freshItem.setMetaMap(metaObj.toString());
                    if (PropertyValidator.isValid((Object)actionItem.getTfsAreaPath()) && !PropertyValidator.isValid((Object)freshItem.getTfsAreaPath())) {
                        freshItem.setTfsAreaPath(actionItem.getTfsAreaPath());
                    }
                }
                freshItem = (Item)this.itemRepository.save((Object)freshItem);
                this.almErrorRepository.deleteByItemId(freshItem.getId());
                Item itemForSprintReport = freshItem;
                new Thread(() -> {
                    Item dbItem = this.itemRepository.findById(itemForSprintReport.getId());
                    if (PropertyValidator.isValid((Object)dbItem) && PropertyValidator.isValid((Object)dbItem.getParent())) {
                        this.customRepositoryImpl.addAuditLogEntryInActiveSprintForSingleItem(dbItem);
                    }
                }).start();
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (ViztrendJiraException vje) {
            freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setMetaMap(actionItem.getMetaMap());
            LOGGER.warn("Failed to save TFS issue.");
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            freshItem.setErrorInAlmSync(Boolean.valueOf(true));
            freshItem.setAlmErrorMessage(vje.getMessage());
            this.itemRepository.save((Object)freshItem);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            LOGGER.error("Creating TFS item :: FAILED.. error message saved in item.", (Throwable)vje);
            this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (User)loggedInUser, (ViztrendJiraException)vje, (Boolean)false));
            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (String)"AlmError", null, null, null, null, null, (Gson)gsonExclusive, (String)vje.getMessage()));
        }
        return null;
    }

    public BacklogItem saveBacklogItemInTFS(BacklogItem item, Map<String, Object> itemMap, Map<String, Object> parentMap, Map<String, Object> params) {
        block43: {
            TFSProject tfsProject;
            AlmAccount almAccount = (AlmAccount)params.get("almAccount");
            Boolean update = (Boolean)params.get("update");
            String releaseTrainId = (String)params.get("releaseTrainId");
            WorkSpace releaseTrain = this.workSpaceRepository.findByIdOrKey(releaseTrainId, releaseTrainId);
            BacklogHierarchy backlogHierarchy = (BacklogHierarchy)this.backlogHierarchyRepository.findOne((Serializable)((Object)releaseTrain.getLinkedAlmHierarchy()));
            String requestId = null;
            if (params.containsKey("requestId")) {
                requestId = (String)params.get("requestId");
            }
            if (PropertyValidator.isValid((Object)(tfsProject = this.tfsProjectRepository.findByAlmIdAndTfsId(almAccount.getId(), (String)item.getFields().get("tfsProjectId"))))) {
                BacklogItem freshItem;
                List tfsFields;
                String _date;
                SimpleDateFormat df;
                Object tz;
                Boolean sendToAlm;
                HashMap<String, Object> fields = new HashMap<String, Object>();
                fields.put("title", item.getTitle());
                if (PropertyValidator.isValid((Object)item.getStatus())) {
                    Status status = (Status)this.statusRepository.findOne((Serializable)((Object)item.getStatus().getId()));
                    fields.put("state", status.getTitle());
                }
                String areaPath = null;
                if (item.getFields().containsKey("tfsAreaPath")) {
                    areaPath = (String)item.getFields().get("tfsAreaPath");
                }
                if (areaPath != null) {
                    fields.put("areaPath", areaPath);
                } else {
                    fields.put("areaPath", tfsProject.getName());
                }
                String iterationPath = null;
                if (item.getFields().containsKey("tfsIterationPath")) {
                    iterationPath = (String)item.getFields().get("tfsIterationPath");
                }
                if (iterationPath != null) {
                    fields.put("iterationPath", iterationPath);
                } else {
                    fields.put("iterationPath", tfsProject.getName());
                }
                if (params.containsKey("sendToAlm") && (sendToAlm = (Boolean)params.get("sendToAlm")).booleanValue() && PropertyValidator.isValid((Object)item.getDescription())) {
                    fields.put("System.Description", item.getDescription());
                }
                if (item.getFields().containsKey("StartDate")) {
                    Date startDate = (Date)item.getFields().get("StartDate");
                    if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField())) {
                        tz = TimeZone.getTimeZone("UTC");
                        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                        _date = df.format(startDate);
                        fields.put(tfsProject.getItemStartDateField(), _date);
                    }
                }
                if (item.getFields().containsKey("EndDate")) {
                    Date endDate = (Date)item.getFields().get("EndDate");
                    if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField())) {
                        tz = TimeZone.getTimeZone("UTC");
                        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                        _date = df.format(endDate);
                        fields.put(tfsProject.getItemEndDateField(), _date);
                    }
                }
                if (item.getStoryPoints() != null && PropertyValidator.isValid((Object)tfsProject.getItemEstimationField())) {
                    fields.put(tfsProject.getItemEstimationField(), item.getStoryPoints());
                }
                if (itemMap.containsKey("tfsFields") && PropertyValidator.isValid((Collection)(tfsFields = (List)itemMap.get("tfsFields")))) {
                    for (Map field : tfsFields) {
                        String key = (String)field.get("key");
                        Object value = field.get("value");
                        fields.put(key, value);
                    }
                }
                if (PropertyValidator.isValid(parentMap)) {
                    AlmHierarchyLevelMapping almMapping;
                    String parentUrl = (String)parentMap.get("url");
                    Integer level = (Integer)parentMap.get("backlogLevel");
                    HierarchyLevel hierarchyLevel = backlogHierarchy.getHierarchyLevels().stream().filter(_level -> _level.getLevel() == level).findAny().orElse(null);
                    if (PropertyValidator.isValid((Object)hierarchyLevel) && PropertyValidator.isValid((Object)(almMapping = (AlmHierarchyLevelMapping)hierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mapping -> mapping.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null))) && PropertyValidator.isValid((Collection)almMapping.getTfsItemLinkTypes())) {
                        TFSItemLinkType itemLinkType = (TFSItemLinkType)almMapping.getTfsItemLinkTypes().get(0);
                        String relation = null;
                        if (itemLinkType.getReferenceName().contains("Forward")) {
                            relation = itemLinkType.getReferenceName().replace("Forward", "Reverse");
                        } else if (itemLinkType.getReferenceName().contains("Reverse")) {
                            relation = itemLinkType.getReferenceName().replace("Reverse", "Forward");
                        }
                        JSONObject relationObj = new JSONObject();
                        relationObj.put("rel", (Object)relation);
                        relationObj.put("url", (Object)parentUrl);
                        fields.put("relation", relationObj);
                    }
                }
                boolean addParentRelation = false;
                if (params.containsKey("addParentRelation")) {
                    addParentRelation = (Boolean)params.get("addParentRelation");
                }
                if (!fields.containsKey("relation") && addParentRelation && PropertyValidator.isValid((Object)item.getParentRelationMap()) && PropertyValidator.isValid((Collection)((Collection)item.getParentRelationMap().get(releaseTrainId)))) {
                    ((List)item.getParentRelationMap().get(releaseTrainId)).forEach(prelation -> {
                        AlmHierarchyLevelMapping almMapping;
                        HierarchyLevel hierarchyLevel;
                        BaseItemLink parentItemRtLink;
                        String itemId = prelation.getBacklogItemId().toString();
                        BacklogItem parentItem = this.backlogItemRepository.findById(itemId);
                        if (PropertyValidator.isValid((Object)parentItem) && parentItem.getFields() != null && parentItem.getFields().get("tfsProjectId") != null && PropertyValidator.isValid((Object)(parentItemRtLink = (BaseItemLink)parentItem.getArtRelationMap().get(releaseTrainId))) && PropertyValidator.isValid((Object)(hierarchyLevel = (HierarchyLevel)backlogHierarchy.getHierarchyLevels().stream().filter(_level -> _level.getLevel() == parentItemRtLink.getBacklogLevel()).findAny().orElse(null))) && PropertyValidator.isValid((Object)(almMapping = (AlmHierarchyLevelMapping)hierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mapping -> mapping.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null))) && PropertyValidator.isValid((Collection)almMapping.getTfsItemLinkTypes())) {
                            TFSItemLinkType itemLinkType = (TFSItemLinkType)almMapping.getTfsItemLinkTypes().get(0);
                            String relation = null;
                            if (itemLinkType.getReferenceName().contains("Forward")) {
                                relation = itemLinkType.getReferenceName().replace("Forward", "Reverse");
                            } else if (itemLinkType.getReferenceName().contains("Reverse")) {
                                relation = itemLinkType.getReferenceName().replace("Reverse", "Forward");
                            }
                            JSONObject relationObj = new JSONObject();
                            relationObj.put("rel", (Object)relation);
                            relationObj.put("url", (Object)parentItem.getUrl());
                            fields.put("relation", relationObj);
                        }
                    });
                }
                fields.put("itemType", item.getAlmType());
                try {
                    TFSResponse response = update != false ? this.tfsUtils.updateItemInTFS(item.getAlmItemId(), fields, almAccount) : this.tfsUtils.createItemInTFS(tfsProject.getTfsId(), fields, almAccount);
                    freshItem = this.backlogItemRepository.findById(item.getId());
                    if (freshItem.getFields() == null) {
                        freshItem.setFields(new HashMap());
                    }
                    try {
                        AlmHierarchyLevelMapping almMapping;
                        JSONObject tfsItem = new JSONObject(response.getContent());
                        JSONObject tfsFields2 = tfsItem.getJSONObject("fields");
                        BaseItemLink artRelation = (BaseItemLink)freshItem.getArtRelationMap().get(releaseTrainId);
                        HierarchyLevel hierarchyLevel = backlogHierarchy.getHierarchyLevels().stream().filter(_level -> _level.getLevel() == artRelation.getBacklogLevel()).findAny().orElse(null);
                        if (PropertyValidator.isValid((Object)hierarchyLevel) && PropertyValidator.isValid((Object)(almMapping = (AlmHierarchyLevelMapping)hierarchyLevel.getAlmHierarchyLevelMappings().stream().filter(mapping -> mapping.getAlmAccountId().equals(almAccount.getId())).findAny().orElse(null)))) {
                            this.itemTfsSyncService.tfsItemFromRawJSON(freshItem, tfsItem, tfsFields2, null, null, null, almMapping);
                        }
                        if (freshItem.getFields().containsKey("AlmSyncError")) {
                            freshItem.getFields().remove("AlmSyncError");
                        }
                        if (freshItem.getFields().containsKey("AlmErrorMesaage")) {
                            freshItem.getFields().remove("AlmErrorMesaage");
                        }
                        freshItem.getFields().put("AlmSyncError", false);
                        this.backlogItemRepository.save((Object)freshItem);
                        Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                        HashMap<String, String> metaMap = new HashMap<String, String>();
                        metaMap.put("releaseTrainId", releaseTrainId);
                        if (update.booleanValue()) {
                            metaMap.put("event", "TFSItemUpdate");
                        } else {
                            metaMap.put("event", "TFSItemCreate");
                        }
                        JSONObject pushJson = new JSONObject();
                        HashMap<String, BacklogItem> pushData = new HashMap<String, BacklogItem>();
                        pushData.put("item", freshItem);
                        String itemStr = gsonExclusive.toJson(pushData);
                        pushJson.put("data", (Object)itemStr);
                        pushJson.put("tfs", true);
                        String metaMapStr = gsonExclusive.toJson(metaMap);
                        pushJson.put("metaMap", (Object)metaMapStr);
                        PushSender.sendMsg((String)pushJson.toString());
                        if (requestId != null) {
                            this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
                        }
                        boolean removeMiscStatusItems = false;
                        if (almAccount.getExcludeMiscStatuses() != null) {
                            removeMiscStatusItems = almAccount.getExcludeMiscStatuses();
                        }
                        if (!removeMiscStatusItems || !PropertyValidator.isValid((Object)freshItem.getStatus()) || !freshItem.getStatus().getCategory().equals("Misc")) break block43;
                        try {
                            this.itemTfsSyncService.deleteBacklogItems(Arrays.asList(freshItem), true);
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                        String pushString = null;
                        pushJson = null;
                        try {
                            pushJson = new JSONObject();
                            pushJson.put("isTFS", true);
                            pushJson.put("isRT", true);
                            pushJson.put("items", (Object)gsonExclusive.toJson(Arrays.asList(freshItem)));
                            String event = "TFSWebhookDelete";
                            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"isTFS\":" + Boolean.TRUE + "}"));
                            pushString = pushJson.toString();
                        }
                        catch (JSONException e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                        String companyId = this.companyRepository.findByTenant(almAccount.getTenant()).getId();
                        if (pushString != null) {
                            PushSender.sendPushMsg((String)companyId, pushString);
                        }
                    }
                    catch (JSONException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                catch (ViztrendJiraException vje) {
                    freshItem = this.backlogItemRepository.findById(item.getId());
                    LOGGER.error("Failed to save TFS issue." + StringUtils.getTraceString((Throwable)vje));
                    if (freshItem.getFields().containsKey("AlmSyncError")) {
                        freshItem.getFields().remove("AlmSyncError");
                    }
                    if (freshItem.getFields().containsKey("AlmErrorMesaage")) {
                        freshItem.getFields().remove("AlmErrorMesaage");
                    }
                    freshItem.getFields().put("AlmSyncError", true);
                    freshItem.getFields().put("AlmErrorMesaage", vje.getMessage());
                    this.backlogItemRepository.save((Object)freshItem);
                    LOGGER.error("Creating TFS item :: FAILED.. error message saved in item." + StringUtils.getTraceString((Throwable)vje));
                    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                    HashMap<String, String> metaMap = new HashMap<String, String>();
                    metaMap.put("releaseTrainId", releaseTrainId);
                    metaMap.put("event", "TFSItemSaveError");
                    JSONObject pushJson = new JSONObject();
                    HashMap<String, BacklogItem> pushData = new HashMap<String, BacklogItem>();
                    pushData.put("item", freshItem);
                    String itemStr = gsonExclusive.toJson(pushData);
                    pushJson.put("data", (Object)itemStr);
                    pushJson.put("tfs", true);
                    String metaMapStr = gsonExclusive.toJson(metaMap);
                    pushJson.put("metaMap", (Object)metaMapStr);
                    PushSender.sendMsg((String)pushJson.toString());
                    if (requestId == null) break block43;
                    this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
                }
            }
        }
        return null;
    }

    public Item updateItemScoreInTFS(Item actionItem, AlmAccount almAccount) {
        Session session = ((SessionBoard)actionItem.getSessionBoards().get(0)).getSession();
        String tfsProjectId = actionItem.getTfsProjectId();
        TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(session.getId(), tfsProjectId);
        Item freshItem = this.itemRepository.findById(actionItem.getId());
        HashMap<String, Double> fields = new HashMap<String, Double>();
        if (PropertyValidator.isValid((Object)actionItem.getScore()) && PropertyValidator.isValid((Object)tfsProject) && PropertyValidator.isValid((Object)tfsProject.getWsjfAlmField())) {
            fields.put(tfsProject.getWsjfAlmField(), actionItem.getScore());
        }
        try {
            TFSResponse response = this.tfsUtils.updateItemInTFS(actionItem.getTfsId(), fields, almAccount);
            freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setAlmScoreField(actionItem.getScore());
            freshItem = (Item)this.itemRepository.save((Object)freshItem);
        }
        catch (ViztrendJiraException viztrendJiraException) {
            // empty catch block
        }
        return null;
    }

    public void sendItemToTFS(Item savedItem, Item item, SessionBoard sessionBoard, boolean editMode) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public Item updateItemInTFS(Item actionItem, AlmAccount almAccount) {
        SimpleDateFormat df;
        TimeZone tz;
        Session session = ((SessionBoard)actionItem.getSessionBoards().get(0)).getSession();
        String tfsProjectId = actionItem.getTfsProjectId();
        TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(session.getId(), tfsProjectId);
        Item freshItem = this.itemRepository.findById(actionItem.getId());
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("title", actionItem.getTitle());
        if (PropertyValidator.isValid((Object)actionItem.getStatus())) {
            fields.put("state", actionItem.getStatus().getTitle());
        }
        if (PropertyValidator.isValid((Object)actionItem.getDueDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String targetDate = df.format(actionItem.getDueDate());
            if (PropertyValidator.isValid((Object)tfsProject)) {
                if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemDueDateField())) {
                    fields.put(tfsProject.getItemDueDateField(), targetDate);
                } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField())) {
                    fields.put(tfsProject.getSubItemDueDateField(), targetDate);
                }
            }
        } else if (!PropertyValidator.isValid((Object)actionItem.getDueDate()) && PropertyValidator.isValid((Object)tfsProject)) {
            if (PropertyValidator.isValid((Object)tfsProject.getItemDueDateField())) {
                fields.put(tfsProject.getItemDueDateField(), "");
            } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemDueDateField())) {
                fields.put(tfsProject.getSubItemDueDateField(), "");
            }
        }
        if (PropertyValidator.isValid((Object)actionItem.getStartDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String startDate = df.format(actionItem.getStartDate());
            if (PropertyValidator.isValid((Object)tfsProject)) {
                if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemStartDateField())) {
                    fields.put(tfsProject.getItemStartDateField(), startDate);
                } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField())) {
                    fields.put(tfsProject.getSubItemStartDateField(), startDate);
                }
            }
        } else if (!PropertyValidator.isValid((Object)actionItem.getStartDate()) && PropertyValidator.isValid((Object)tfsProject)) {
            if (PropertyValidator.isValid((Object)tfsProject.getItemStartDateField())) {
                fields.put(tfsProject.getItemStartDateField(), "");
            } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemStartDateField())) {
                fields.put(tfsProject.getSubItemStartDateField(), "");
            }
        }
        if (PropertyValidator.isValid((Object)actionItem.getEndDate())) {
            tz = TimeZone.getTimeZone("UTC");
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            String endDate = df.format(actionItem.getEndDate());
            if (PropertyValidator.isValid((Object)tfsProject)) {
                if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemEndDateField())) {
                    fields.put(tfsProject.getItemEndDateField(), endDate);
                } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField())) {
                    fields.put(tfsProject.getSubItemEndDateField(), endDate);
                }
            }
        } else if (!PropertyValidator.isValid((Object)actionItem.getEndDate()) && PropertyValidator.isValid((Object)tfsProject)) {
            if (PropertyValidator.isValid((Object)tfsProject.getItemEndDateField())) {
                fields.put(tfsProject.getItemEndDateField(), "");
            } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemEndDateField())) {
                fields.put(tfsProject.getSubItemEndDateField(), "");
            }
        }
        String project = actionItem.getTfsProject();
        fields.put("teamProject", project);
        if (PropertyValidator.isValid((Object)actionItem.getTfsAreaPath())) {
            if (session.getTeamFieldEnable().booleanValue()) {
                if (actionItem.getType().equals(Item.USER_STORY)) {
                    fields.put(session.getTeamFieldTeamRefrence(), actionItem.getTfsAreaPath());
                } else {
                    fields.put("areaPath", actionItem.getTfsAreaPath());
                }
            } else {
                fields.put("areaPath", actionItem.getTfsAreaPath());
            }
        } else {
            if (!session.getTeamFieldEnable().booleanValue()) {
                fields.put("areaPath", project);
            }
            freshItem.setTfsAreaPath(project);
        }
        if (freshItem.getType().equals(Item.USER_STORY)) {
            String newIter;
            String oldIter = PropertyValidator.isValid((Object)freshItem.getTfsIterationPath()) ? freshItem.getTfsIterationPath() : "";
            String string = newIter = PropertyValidator.isValid((Object)actionItem.getTfsIterationPath()) ? actionItem.getTfsIterationPath() : "";
            if (!oldIter.equals(newIter)) {
                if (PropertyValidator.isValid((Object)actionItem.getTfsIterationPath())) {
                    fields.put("iterationPath", actionItem.getTfsIterationPath());
                } else {
                    fields.put("iterationPath", project);
                }
            }
        } else if (PropertyValidator.isValid((Object)actionItem.getTfsIterationPath())) {
            fields.put("iterationPath", actionItem.getTfsIterationPath());
        } else {
            fields.put("iterationPath", project);
        }
        if (PropertyValidator.isValid((Object)actionItem.getTfsItemType())) {
            fields.put("itemType", actionItem.getTfsItemType());
        }
        if (PropertyValidator.isValid((Object)actionItem.getStoryPoints()) && PropertyValidator.isValid((Object)tfsProject)) {
            if (actionItem.getType().equals(Item.FEATURE) && PropertyValidator.isValid((Object)tfsProject.getItemEstimationField())) {
                fields.put(tfsProject.getItemEstimationField(), actionItem.getStoryPoints());
            } else if (actionItem.getType().equals(Item.USER_STORY) && PropertyValidator.isValid((Object)tfsProject.getSubItemEstimationField())) {
                fields.put(tfsProject.getSubItemEstimationField(), actionItem.getStoryPoints());
            }
        }
        try {
            HashMap metaMap;
            8 T1;
            JSONObject pushJson;
            TFSResponse response = this.tfsUtils.updateItemInTFS(actionItem.getTfsId(), fields, almAccount);
            6 T = new /* Unavailable Anonymous Inner Class!! */;
            Gson gsonExclusive = new Gson();
            HashMap responseMap = (HashMap)gsonExclusive.fromJson(response.getContent(), T.getType());
            Number almRevision = (Number)responseMap.get("rev");
            freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setAlmRevision("" + almRevision);
            freshItem.setMetaMap(actionItem.getMetaMap());
            boolean hasError = freshItem.getErrorInAlmSync() != null && freshItem.getErrorInAlmSync() != false;
            freshItem.setErrorInAlmSync(Boolean.valueOf(false));
            freshItem.setAlmErrorMessage(null);
            String sessionBoardId = null;
            if (PropertyValidator.isValid((Collection)freshItem.getSessionBoards())) {
                sessionBoardId = ((SessionBoard)freshItem.getSessionBoards().get(0)).getId();
            }
            boolean isValid = false;
            try {
                isValid = this.isItemValidToAddForSession(freshItem, session);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            if (!isValid && PropertyValidator.isValid((Object)freshItem.getType()) && freshItem.getType().equals(Item.USER_STORY)) {
                freshItem.setArchive(true);
                pushJson = new JSONObject();
                try {
                    gsonExclusive = new Gson();
                    T1 = new /* Unavailable Anonymous Inner Class!! */;
                    metaMap = (HashMap)gsonExclusive.fromJson(actionItem.getMetaMap(), T1.getType());
                    metaMap.put("event", "StoryDelete");
                    pushJson.put("isTFS", true);
                    pushJson.put("type", (Object)freshItem.getType());
                    pushJson.put("metaMap", (Object)gsonExclusive.toJson((Object)metaMap));
                    pushJson.put("id", (Object)freshItem.getId());
                    pushJson.put("boardId", (Object)sessionBoardId);
                    pushJson.put("event", (Object)"StoryDelete");
                    freshItem = new Item(freshItem);
                    pushJson.put("item", (Object)gsonExclusive.toJson((Object)freshItem));
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            freshItem = (Item)this.itemRepository.save((Object)freshItem);
            if (hasError) {
                pushJson = new JSONObject();
                try {
                    gsonExclusive = new Gson();
                    T1 = new /* Unavailable Anonymous Inner Class!! */;
                    metaMap = (HashMap)gsonExclusive.fromJson(actionItem.getMetaMap(), T1.getType());
                    metaMap.put("event", "AlmErrorFix");
                    pushJson.put("isTFS", true);
                    pushJson.put("type", (Object)freshItem.getType());
                    pushJson.put("metaMap", (Object)gsonExclusive.toJson((Object)metaMap));
                    pushJson.put("id", (Object)freshItem.getId());
                    pushJson.put("boardId", (Object)sessionBoardId);
                    pushJson.put("event", (Object)"AlmErrorFix");
                    freshItem = new Item(freshItem);
                    pushJson.put("item", (Object)gsonExclusive.toJson((Object)freshItem));
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            this.almErrorRepository.deleteByItemId(freshItem.getId());
        }
        catch (ViztrendJiraException vje) {
            freshItem = this.itemRepository.findById(actionItem.getId());
            freshItem.setMetaMap(actionItem.getMetaMap());
            LOGGER.warn("Failed to save TFS issue.");
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            freshItem.setErrorInAlmSync(Boolean.valueOf(true));
            freshItem.setAlmErrorMessage(vje.getMessage());
            this.itemRepository.save((Object)freshItem);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            LOGGER.error("Updating TFS item :: FAILED.. error message saved in item.", (Throwable)vje);
            this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (User)loggedInUser, (ViztrendJiraException)vje, (Boolean)false));
            PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJsonForTFS((Item)freshItem, (String)((SessionBoard)freshItem.getSessionBoards().get(0)).getId(), (String)"AlmError", null, null, null, null, null, (Gson)gsonExclusive, (String)vje.getMessage()));
        }
        return null;
    }

    public HashMap<String, Object> retrieveTfsProjectsWebhookStatusForUpdatedWorkItems(String tfsProjectIds, String sessionId, String url, String eventType) throws ViztrendJiraException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        HashMap<String, Boolean> tfsProjectIdsMap = new HashMap<String, Boolean>();
        HashMap<String, Object> workItemsEventTypeStatus = new HashMap<String, Object>();
        try {
            String[] tfsProjectIdsArray;
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            AlmAccount almAccount = session.getTfsAlmConfigurations().getAlmAccount();
            for (String projectId : tfsProjectIdsArray = tfsProjectIds.split(",")) {
                tfsProjectIdsMap.put(projectId, true);
            }
            JSONObject requestObject = new JSONObject();
            TFSResponse tfsResponse = null;
            try {
                requestObject.put("publisherId", (Object)"tfs");
                requestObject.put("eventType", (Object)eventType);
                requestObject.put("consumerId", (Object)"webHooks");
                requestObject.put("consumerActionId", (Object)"httpRequest");
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            if (eventType.equals("workitem.updated")) {
                tfsResponse = this.tfsUtils.getTFSProjectWebHooksForWorkItemsUpdated(requestObject, almAccount);
            } else if (eventType.equals("workitem.deleted")) {
                tfsResponse = this.tfsUtils.getTFSProjectWebHooksForWorkItemsDeleted(requestObject, almAccount);
            }
            if (PropertyValidator.isValid((Object)tfsResponse) && PropertyValidator.isValid((Object)tfsResponse.getContent())) {
                JSONObject responseObj = new JSONObject(tfsResponse.getContent());
                JSONArray workItemsArray = responseObj.getJSONArray("results");
                for (int i = 0; i < workItemsArray.length(); ++i) {
                    JSONObject wiObject = workItemsArray.getJSONObject(i);
                    JSONObject publisherInputs = (JSONObject)wiObject.get("publisherInputs");
                    String id = (String)publisherInputs.get("projectId");
                    JSONObject consumerInputs = (JSONObject)wiObject.get("consumerInputs");
                    String tfsWebhookUrl = (String)consumerInputs.get("url");
                    String status = (String)wiObject.get("status");
                    if (!tfsProjectIdsMap.containsKey(id) || !eventType.equals(wiObject.get("eventType")) || !url.equals(tfsWebhookUrl)) continue;
                    if (eventType.equals("workitem.updated")) {
                        workItemsEventTypeStatus.put("workitem.updated", true);
                    } else if (eventType.equals("workitem.deleted")) {
                        workItemsEventTypeStatus.put("workitem.deleted", true);
                    }
                    workItemsEventTypeStatus.put("status", status);
                    responseMap.put(id, workItemsEventTypeStatus);
                }
            } else if (tfsResponse == null) {
                responseMap.put("failure", "Something went wrong...");
            }
        }
        catch (ViztrendJiraException e) {
            responseMap.put("failure", "Something went wrong...");
            throw e;
        }
        catch (JSONException e) {
            e.printStackTrace();
            responseMap.put("failure", "Something went wrong...");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseMap.put("failure", "Something went wrong...");
        }
        return responseMap;
    }

    public HashMap<String, Object> getWorkItemUpdateWebhook(String workItemId, String almAccId, String boardId, String title) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            HashMap<String, String> testingWebhookForTFSMap = new HashMap<String, String>();
            if (PropertyValidator.isValid((Object)workItemId) && PropertyValidator.isValid((Object)almAccId) && PropertyValidator.isValid((Object)boardId) && PropertyValidator.isValid((Object)title)) {
                testingWebhookForTFSMap.put(workItemId, boardId);
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccId));
                almAccount.setTestingWebhookForTFS(testingWebhookForTFSMap);
                this.almAccountRepository.save((Object)almAccount);
                fields.put("title", title + ".1111");
                TFSResponse tFSResponse = this.tfsUtils.updateItemInTFS(workItemId, fields, almAccount);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseMap.put("failure", "Something went wrong...");
        }
        return responseMap;
    }

    public HashMap<String, Object> createTfsProjectWebhook(String tfsProjectId, String sessionId, String eventType) throws ViztrendJiraException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        AlmAccount almAccount = session.getTfsAlmConfigurations().getAlmAccount();
        JSONObject requestObject = new JSONObject();
        try {
            requestObject.put("publisherId", (Object)"tfs");
            if (eventType.equals("update")) {
                requestObject.put("eventType", (Object)"workitem.updated");
            } else if (eventType.equals("delete")) {
                requestObject.put("eventType", (Object)"workitem.deleted");
            }
            requestObject.put("resourceVersion", (Object)"1.0");
            requestObject.put("consumerId", (Object)"webHooks");
            requestObject.put("consumerActionId", (Object)"httpRequest");
            JSONObject publisherObject = new JSONObject();
            publisherObject.put("projectId", (Object)tfsProjectId);
            requestObject.put("publisherInputs", (Object)publisherObject);
            JSONObject consumerObject = new JSONObject();
            String webHookURL = UserContextUtil.getUserContext().getCurrentCompany().getUrl() + "/tfswebhook/" + almAccount.getId();
            consumerObject.put("url", (Object)webHookURL);
            requestObject.put("consumerInputs", (Object)consumerObject);
            TFSResponse tfsResponse = this.tfsUtils.createWebhookInTFS(almAccount, requestObject);
            responseMap.put("success", true);
        }
        catch (ViztrendJiraException e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            responseMap.put("almError", e.getAlmError());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseMap.put("message", e.getMessage());
        }
        return responseMap;
    }

    public boolean createWebhookInTFS(AlmAccount almAccount, String projectId) {
        String webHookStr = this.tfsUtils.getTFSWebHooks(almAccount);
        HashMap<String, Boolean> webHookMap = new HashMap<String, Boolean>();
        webHookMap.put("workitem.created", false);
        webHookMap.put("workitem.updated", false);
        webHookMap.put("workitem.deleted", false);
        if (PropertyValidator.isValid((Object)webHookStr)) {
            try {
                JSONObject dataObjects = new JSONObject(webHookStr);
                String count = dataObjects.getString("count");
                JSONArray itemsArray = dataObjects.getJSONArray("value");
                for (int i = 0; i < itemsArray.length(); ++i) {
                    try {
                        JSONObject webHookObject = itemsArray.getJSONObject(i);
                        JSONObject publisherInputs = webHookObject.getJSONObject("publisherInputs");
                        JSONObject consumerInputs = webHookObject.getJSONObject("consumerInputs");
                        String eventType = webHookObject.getString("eventType");
                        String webHookURL = consumerInputs.getString("url");
                        String publisherProjectId = publisherInputs.getString("projectId");
                        if (!publisherProjectId.equals(projectId) || !PropertyValidator.isValid((Object)webHookURL) || webHookURL.indexOf("/tfswebhook/" + almAccount.getId()) <= -1) continue;
                        if (eventType.equals("workitem.created")) {
                            webHookMap.put("workitem.created", true);
                        } else if (eventType.equals("workitem.updated")) {
                            webHookMap.put("workitem.updated", true);
                        } else if (eventType.equals("workitem.deleted")) {
                            webHookMap.put("workitem.deleted", true);
                        }
                        if (!((Boolean)webHookMap.get("workitem.updated")).booleanValue() || !((Boolean)webHookMap.get("workitem.deleted")).booleanValue() || !((Boolean)webHookMap.get("workitem.created")).booleanValue()) continue;
                        break;
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        String sStackTrace = sw.toString();
                        LOGGER.error(" ::  Exception ..  " + sStackTrace);
                    }
                }
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        for (String webHookKey : webHookMap.keySet()) {
            if (!((Boolean)webHookMap.get(webHookKey)).equals(false)) continue;
            JSONObject requestObject = new JSONObject();
            try {
                requestObject.put("publisherId", (Object)"tfs");
                requestObject.put("publisherId", (Object)"tfs");
                requestObject.put("eventType", (Object)webHookKey);
                requestObject.put("resourceVersion", (Object)"1.0");
                requestObject.put("consumerId", (Object)"webHooks");
                requestObject.put("consumerActionId", (Object)"httpRequest");
                JSONObject publisherObject = new JSONObject();
                publisherObject.put("projectId", (Object)projectId);
                requestObject.put("publisherInputs", (Object)publisherObject);
                JSONObject consumerObject = new JSONObject();
                String webHookURL = UserContextUtil.getUserContext().getCurrentCompany().getUrl() + "/tfswebhook/" + almAccount.getId();
                consumerObject.put("url", (Object)webHookURL);
                requestObject.put("consumerInputs", (Object)consumerObject);
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            this.tfsUtils.createWebhookInTFS(almAccount, requestObject);
        }
        return false;
    }

    private void pushSmartProgressUpdates(String progressType, String syncId, String data, boolean hasPendingPush) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            if (progressType == "SmartResyncLogging" || progressType == "ResyncNewProjects") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("data", (Object)data);
                pushJson.put("metaMap", (Object)("{\"event\":\"" + progressType + "\", \"syncId\":\"" + syncId + "\"}"));
            }
            if (!PropertyValidator.isValid(requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(!hasPendingPush)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pushProgressUpdates(String progressType, String syncId, String data, boolean hasPendingPush) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            if (progressType == "ResyncLogging" || progressType == "ResyncNewProjects" || progressType == "FetchUpdatedTFSItems" || progressType == "CompareFeature") {
                pushJson.put("type", (Object)"Board");
                pushJson.put("push", (Object)"Self");
                pushJson.put("data", (Object)data);
                pushJson.put("metaMap", (Object)("{\"event\":\"" + progressType + "\", \"syncId\":\"" + syncId + "\"}"));
            }
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(!hasPendingPush)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onResyncError(String syncId, String payload, String sessionBoardId, Boolean isReadOnly) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Board");
            pushJson.put("push", (Object)"Self");
            pushJson.put("error", true);
            pushJson.put("data", (Object)payload);
            pushJson.put("metaMap", (Object)("{\"event\":\"ReSyncError\", \"syncId\":\"" + syncId + "\"}"));
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private SolutionBoard dbRefOfSolutionBoard(SolutionBoard solutionBoard) {
        SolutionBoard _solutionBoard = new SolutionBoard();
        _solutionBoard.setId(solutionBoard.getId());
        return _solutionBoard;
    }

    private Status filterStatus(Status st) {
        st.setWorkFlow(null);
        st.setWorkFlowItemType(null);
        return st;
    }

    public Boolean isLoggedInCompanyUser(User user) {
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        for (UserCompany userCompany : user.getUserCompanies()) {
            if (userCompany.getCompany() == null || !userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<Status> updateStatusCategory(HashMap<String, Object> reqbody) {
        String title = (String)reqbody.get("status");
        String sessionId = (String)reqbody.get("sessionId");
        String almId = (String)reqbody.get("almId");
        String statusId = (String)reqbody.get("statusId");
        String jiraStatusId = (String)reqbody.get("jiraStatusId");
        String itemType = (String)reqbody.get("itemType");
        String sourceCategory = (String)reqbody.get("sourceCategory");
        String targetCategory = (String)reqbody.get("targetCategory");
        String tfsProjectId = (String)reqbody.get("tfsProjectId");
        String jiraProjKey = (String)reqbody.get("jiraProjKey");
        String type = (String)reqbody.get("type");
        Status status = null;
        List<Status> statuses = new ArrayList();
        if (!"jira".equals(type)) {
            status = (Status)this.statusRepository.findOne((Serializable)((Object)statusId));
            statuses.add(status);
            if (PropertyValidator.isValid((Object)status)) {
                Boolean saveInMapppings = (Boolean)reqbody.get("saveInMapppings");
                if (PropertyValidator.isValid((Object)saveInMapppings) && saveInMapppings.booleanValue()) {
                    String collectionId = (String)reqbody.get("collectionId");
                    if (status.getCategoryMappingByCollectionId() == null) {
                        status.setCategoryMappingByCollectionId(new HashMap());
                    }
                    status.getCategoryMappingByCollectionId().put(collectionId, targetCategory);
                } else {
                    status.setCategory(targetCategory);
                }
                status = (Status)this.statusRepository.save((Object)status);
                TFSPreferences preference = null;
                String key = itemType + "_" + status.getTitle();
                if (PropertyValidator.isValid((Object)sessionId)) {
                    preference = this.tfsPreferencesRepository.findByTfsProjectIdAndSessionIdAndKey(tfsProjectId, sessionId, key);
                    if (!PropertyValidator.isValid((Object)preference)) {
                        preference = new TFSPreferences();
                        preference.setTfsProjectId(tfsProjectId);
                        preference.setSessionId(sessionId);
                        preference.setKey(key);
                    }
                } else if (!(!PropertyValidator.isValid((Object)almId) || PropertyValidator.isValid((Object)saveInMapppings) && saveInMapppings.booleanValue() || PropertyValidator.isValid((Object)(preference = this.tfsPreferencesRepository.findByTfsProjectIdAndAlmIdAndKey(tfsProjectId, almId, key))))) {
                    preference = new TFSPreferences();
                    preference.setTfsProjectId(tfsProjectId);
                    preference.setAlmId(almId);
                    preference.setKey(key);
                }
                if (preference != null) {
                    preference.setValue(targetCategory);
                    this.tfsPreferencesRepository.save((Object)preference);
                }
            }
        } else {
            statuses = this.statusRepository.findBySessionIdAndJiraStatusId(sessionId, jiraStatusId);
            if (PropertyValidator.isValid(statuses)) {
                statuses.forEach(x -> x.setCategory(targetCategory));
                statuses = this.statusRepository.save(statuses);
            }
        }
        return statuses;
    }

    public void saveTFSLinkType(String linkTypes, String almAccountId) {
        try {
            JSONObject dataObjects = new JSONObject(linkTypes);
            JSONArray itemLinkTypes = dataObjects.getJSONArray("value");
            for (int i = 0; i < itemLinkTypes.length(); ++i) {
                JSONObject linkTypeObject = itemLinkTypes.getJSONObject(i);
                if (!PropertyValidator.isValid((Object)linkTypeObject.getJSONObject("attributes")) || !PropertyValidator.isValid((Object)linkTypeObject.getJSONObject("attributes").get("usage")) || !linkTypeObject.getJSONObject("attributes").get("usage").equals("workItemLink")) continue;
                ItemLinkType itemLinkType = new ItemLinkType();
                itemLinkType.setName(linkTypeObject.getString("name"));
                itemLinkType.setReferenceName(linkTypeObject.getString("referenceName"));
                itemLinkType.setAlmAccountId(almAccountId);
                itemLinkType.setUrl(linkTypeObject.getString("url"));
                itemLinkType.setDirectional((Boolean)linkTypeObject.getJSONObject("attributes").get("directional"));
                this.itemLinkTypeRepository.save((Object)itemLinkType);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public ItemTypeScheme getItemTypeScheme(String type) {
        ItemType itemType = this.itemTypeRepository.findByTitle(type);
        if (!PropertyValidator.isValid((Object)itemType)) {
            itemType = new ItemType();
            itemType.setTitle(type);
            itemType.setNested(true);
            itemType.setAllowedTypes(new String[0]);
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
            WorkFlow workFlow = null;
            if (type.equals(EnumKendis.MILESTONE.getCode())) {
                List milestoneWorkflowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.MILESTONE.getCode());
                if (!PropertyValidator.isValid((Collection)milestoneWorkflowList)) {
                    milestoneWorkflowList.add(this.releaseTrainService.createMilestoneWorkFlow());
                }
                workFlow = (WorkFlow)milestoneWorkflowList.get(0);
            } else {
                workFlow = this.customRepository.createDefaultWorkflow("Default " + type + " Workflow", type);
            }
            FieldTemplate fieldTemplate = null;
            if (!PropertyValidator.isValid(fieldTemplate)) {
                fieldTemplate = new FieldTemplate();
                List<Fields> fields = new ArrayList<Fields>();
                if (EnumKendis.EPIC.getCode().toString().equals(type)) {
                    fields.add(new Fields("1", "Key", "textfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("2", "Title", "textfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("3", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("4", "Size", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("5", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("6", "Priority", "severity", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("7", "Non Functional Requirements", "simpleEditor", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("8", "Start Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("9", "Due Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("10", "Business Benefits", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("11", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, null, null));
                    ArrayList<String> optionsForCardType = new ArrayList<String>();
                    optionsForCardType.add("Epic");
                    optionsForCardType.add("Feature");
                    optionsForCardType.add("User Story");
                    fields.add(new Fields("12", "Card Type", "singleselect", optionsForCardType, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, null, null));
                    fields = this.fieldsRepository.save(fields);
                    fieldTemplate.setConfiguredFields(fields);
                    fieldTemplate.setType(type);
                    fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
                } else {
                    fields.add(new Fields("1", "Title", "textfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("2", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("3", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("4", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("5", "Start Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    if (type == EnumKendis.PHASES.getCode()) {
                        fields.add(new Fields("6", "End Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    }
                    fields.add(new Fields("7", "Type", "singleselect", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields.add(new Fields("8", "Shape", "colorpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                    fields = this.fieldsRepository.save(fields);
                    fieldTemplate.setConfiguredFields(fields);
                    fieldTemplate.setType(type);
                    fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
                }
            }
            ItemTypeScheme itemTypeScheme = new ItemTypeScheme();
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setWorkflow(workFlow);
            itemTypeScheme.setFieldsTemplate(fieldTemplate);
            itemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
            return itemTypeScheme;
        }
        ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(itemType);
        return itemTypeScheme;
    }

    public List<ItemLinkType> createNewKendisLinkTypes() {
        ArrayList itemLinkTypeList = new ArrayList();
        ItemLinkType itemLinkType = new ItemLinkType("Depends on", "Depends on", "DependsOn-OUT", "Dependent on", Boolean.valueOf(true), 0);
        itemLinkTypeList.add(itemLinkType);
        itemLinkType = new ItemLinkType("Dependent on", "Dependent on", "DependentOn-IN", "Depends on", Boolean.valueOf(true), 1);
        itemLinkTypeList.add(itemLinkType);
        itemLinkType = new ItemLinkType("Associated with", "Associated with", "AssociatedWith-OUT", "Associated By", Boolean.valueOf(true), 2);
        itemLinkTypeList.add(itemLinkType);
        itemLinkType = new ItemLinkType("Associated By", "Associated By", "AssociatedBy-IN", "Associated with", Boolean.valueOf(true), 3);
        itemLinkTypeList.add(itemLinkType);
        itemLinkType = new ItemLinkType("Is Blocking", "Is Blocking", "IsBlocking-OUT", "Blocked by", Boolean.valueOf(true), 4);
        itemLinkTypeList.add(itemLinkType);
        itemLinkType = new ItemLinkType("Blocked by", "Blocked by", "BlockedBy-IN", "Is Blocking", Boolean.valueOf(true), 5);
        itemLinkTypeList.add(itemLinkType);
        itemLinkTypeList = (ArrayList)this.itemLinkTypeRepository.save(itemLinkTypeList);
        return itemLinkTypeList;
    }

    public void sendEmailWithPdf(HashMap<String, Object> requestBody) {
        ArrayList userIds = (ArrayList)requestBody.get("userIds");
        HashMap dataJson = new HashMap();
        List userList = null;
        String templateName = (String)requestBody.get("templateName");
        String boardType = (String)requestBody.get("boardType");
        String sessionUrl = "";
        if (PropertyValidator.isValid((Collection)userIds)) {
            userList = this.userRepository.findByIdIn((List)userIds);
        }
        String tenant = "";
        if (PropertyValidator.isValid(userList)) {
            tenant = ((User)userList.get(0)).getTenant();
        }
        String downloadUrl = this.notificationServiceImpl.getBaseUrl(tenant) + "/download-pdf/" + this.createDownloadPDFData((String)requestBody.get("img"));
        requestBody.put("downloadUrl", downloadUrl);
        String sessionBoardId = (String)requestBody.get("sessionBoardId");
        String endTag = (String)requestBody.get("urlTag");
        sessionUrl = boardType.equalsIgnoreCase("tfs") ? "/pisession?id=" : "/session?id=";
        String viewUrl = this.notificationServiceImpl.getBaseUrl(tenant) + sessionUrl + sessionBoardId + endTag;
        requestBody.put("viewUrl", viewUrl);
        this.createEmailDataForSharing(requestBody, dataJson);
        ArrayList<String> recipientList = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)userList)) {
            for (User user : userList) {
                recipientList.add(user.getEmail());
            }
            this.mailSender.sendMail(recipientList, "Kendis -  Smart report", templateName, dataJson, true);
        }
    }

    public void sendSprintReportEmail(String sprintID, String sessionBoardID) {
        String senderName = UserContextUtil.getUserContext().getLoggedInUser().getFullName();
        String templateName = "share_template";
        String boardType = "";
        HashMap<String, Object> dataJson = new HashMap<String, Object>();
        ArrayList userIds = new ArrayList();
        List userList = new ArrayList();
        ArrayList<String> userListByEmail = new ArrayList<String>();
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardID));
        Session session = sessionBoard.getSession();
        if (PropertyValidator.isValid((Collection)sessionBoard.getUserListForSprintReportEmail())) {
            userList = this.userRepository.findByIdIn(userIds);
        } else {
            userListByEmail.add(UserContextUtil.getUserContext().getLoggedInUser().getEmail());
        }
        String tempHtml = "<div>Greetings from Kendis!</div><div>The Sprint report has been shared with you for board '" + session.getTitle() + "'</div>";
        boardType = PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) ? "/pisession?id=" : "/session?id=";
        String viewUrl = boardType + "" + sessionBoardID + "&moreOptionsIndex=8&moreOptionsSubIndex=" + sprintID;
        dataJson.put("senderName", senderName);
        dataJson.put("viewReportURL", viewUrl);
        dataJson.put("downloadURL", "");
        dataJson.put("showViewReport", true);
        dataJson.put("body", tempHtml);
        dataJson.put("showDownloadReport", false);
        if (PropertyValidator.isValid(userList)) {
            for (User user : userList) {
                userListByEmail.add(user.getEmail());
            }
        }
        this.mailSender.sendMail(userListByEmail, "Kendis -  Sprint report", templateName, dataJson, true);
    }

    public void createEmailDataForSharing(HashMap<String, Object> requestBody, HashMap<String, Object> dataJson) {
        String templateType = (String)requestBody.get("templateType");
        dataJson.put("senderName", UserContextUtil.getUserContext().getLoggedInUser().getFullName());
        dataJson.put("body", requestBody.get("body"));
        if (templateType.equalsIgnoreCase("Reports")) {
            dataJson.put("showViewReport", requestBody.get("showViewReport"));
            dataJson.put("showDownloadReport", requestBody.get("showDownloadReport"));
        }
        String downloadUrl = (String)requestBody.get("downloadUrl");
        String viewUrl = (String)requestBody.get("viewUrl");
        dataJson.put("downloadURL", downloadUrl);
        dataJson.put("viewReportURL", viewUrl);
    }

    public BoardFilter createBoardFilter(BoardFilter boardFilter) {
        if (PropertyValidator.isValid((Object)boardFilter)) {
            boardFilter = (BoardFilter)this.boardFilterRepository.save((Object)boardFilter);
            User user = this.userRepository.findById(boardFilter.getUser().getId());
            boardFilter.setUser(user);
            return boardFilter;
        }
        return null;
    }

    public void deleteBoardFilter(BoardFilter boardFilter) {
        try {
            if (PropertyValidator.isValid((Object)boardFilter)) {
                this.boardFilterRepository.delete((Serializable)((Object)boardFilter.getId()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String createDownloadPDFData(String img) {
        String b64Image = img;
        String UUid = UUID.randomUUID().toString();
        MongoSyncUtils.storeData((String)UUid, (String)b64Image, (AppConfig.MongoConfig)this.mongoConfig);
        String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        String downloadUrl = "{\"_uuId\":\"" + UUid + "\",\"time\":\"" + timeStamp + "\"}";
        try {
            downloadUrl = EncDecUtility.encryptSimple((String)downloadUrl);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return downloadUrl;
    }

    public HashMap<String, List<BoardFilter>> fetchBoardFilters(String sessionId, String userId) {
        List filterList = this.boardFilterRepository.findBySessionIdAndUserIdIsNullOrSessionIdAndUserId(sessionId, sessionId, userId);
        ArrayList<BoardFilter> quickFilter = new ArrayList<BoardFilter>();
        ArrayList<BoardFilter> myFilter = new ArrayList<BoardFilter>();
        HashMap<String, List<BoardFilter>> response = new HashMap<String, List<BoardFilter>>();
        if (PropertyValidator.isValid((Collection)filterList)) {
            for (BoardFilter filter : filterList) {
                if (PropertyValidator.isValid((Object)filter.getType())) continue;
                if (PropertyValidator.isValid((Object)filter.getUserId())) {
                    myFilter.add(filter);
                    continue;
                }
                quickFilter.add(filter);
            }
            response.put("quickFilter", quickFilter);
            response.put("myFilter", myFilter);
            return response;
        }
        return null;
    }

    public HashMap<String, List<BoardFilter>> fetchDependencyFilters(String sessionId, String userId) throws Exception {
        List filterList = this.customRepository.findDependencyFiltersBySessionAndUser(sessionId, userId);
        ArrayList<BoardFilter> quickFilter = new ArrayList<BoardFilter>();
        ArrayList<BoardFilter> myFilter = new ArrayList<BoardFilter>();
        HashMap<String, List<BoardFilter>> response = new HashMap<String, List<BoardFilter>>();
        if (PropertyValidator.isValid((Collection)filterList)) {
            for (BoardFilter filter : filterList) {
                if (PropertyValidator.isValid((Object)filter.getUserId())) {
                    myFilter.add(filter);
                    continue;
                }
                quickFilter.add(filter);
            }
            response.put("quickFilter", quickFilter);
            response.put("myFilter", myFilter);
            return response;
        }
        return null;
    }

    public boolean checkDependencyStatusUpdateOnItemStatusUpdate(Object obj, String itemId, List<ItemLinkType> kendisLinkTypes, String key, Session session) {
        String linkDirection = "";
        String sourceItemId = "";
        String targetItemId = "";
        boolean ignoreIfWrongItem = true;
        String boardArrowDirectionSetting = session.getLineArrowDirection();
        if (obj instanceof ItemLink) {
            ItemLink itemLink = (ItemLink)obj;
            String[] type = itemLink.getType().split("-");
            List<String> typeList = Arrays.asList(type);
            if (typeList.size() > 1) {
                linkDirection = typeList.get(1);
                linkDirection = linkDirection.equals("Forward") ? "OUT" : "IN";
            } else {
                ItemLinkType kendisItemLink = kendisLinkTypes.stream().filter(link -> link.getName().equals(itemLink.getType())).findAny().orElse(null);
                if (PropertyValidator.isValid((Object)kendisItemLink)) {
                    String[] KendisType = kendisItemLink.getReferenceName().split("-");
                    List<String> KendisTypeList = Arrays.asList(KendisType);
                    linkDirection = KendisTypeList.get(1);
                } else {
                    linkDirection = "No Direction";
                }
            }
            if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                sourceItemId = itemLink.getSourceUserStoryId();
            } else {
                String string = sourceItemId = itemLink.getSourceFeatureId() != null ? itemLink.getSourceFeatureId() : itemLink.getSourceItemId();
            }
            targetItemId = PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) ? itemLink.getTargetUserStoryId() : (itemLink.getTargetFeatureId() != null ? itemLink.getTargetFeatureId() : itemLink.getTargetItemId());
        } else {
            ItemJiraDependency jD = (ItemJiraDependency)obj;
            if (PropertyValidator.isValid((Object)jD.getTfsLinkType())) {
                String[] type = jD.getTfsLinkType().split("-");
                List<String> typeList = Arrays.asList(type);
                linkDirection = typeList.size() > 1 ? ((linkDirection = typeList.get(1)).equals("Forward") ? "OUT" : "IN") : "No Direction";
            } else {
                linkDirection = jD.getDirection();
                if (linkDirection.equals("")) {
                    linkDirection = "No Direction";
                }
            }
            sourceItemId = jD.getSourceItemId();
            targetItemId = jD.getTargetItemId();
        }
        if (boardArrowDirectionSetting.equals("Successor") && key.equals(Session.DependencyStatusOption.Target.toString()) || boardArrowDirectionSetting.equals("Predecessor") && key.equals(Session.DependencyStatusOption.Source.toString())) {
            if (linkDirection.equals("IN") && itemId.equals(targetItemId) || linkDirection.equals("OUT") && itemId.equals(sourceItemId)) {
                ignoreIfWrongItem = false;
            }
        } else if (boardArrowDirectionSetting.equals("Predecessor") && key.equals(Session.DependencyStatusOption.Target.toString()) || boardArrowDirectionSetting.equals("Successor") && key.equals(Session.DependencyStatusOption.Source.toString())) {
            if (linkDirection.equals("IN") && itemId.equals(sourceItemId) || linkDirection.equals("OUT") && itemId.equals(targetItemId)) {
                ignoreIfWrongItem = false;
            }
        } else if (key.equals(Session.DependencyStatusOption.SourceTarget.toString())) {
            ignoreIfWrongItem = false;
        }
        if (linkDirection.equals("No Direction")) {
            ignoreIfWrongItem = false;
        }
        return ignoreIfWrongItem;
    }

    public TFSProject linkTFSProjectsWithAlm(String tfsProjectId, String almId, TFSProject tfsProject) throws ViztrendJiraException {
        AlmAccount almAccount = this.almAccountRepository.findById(almId);
        TFSProject tfsProjectNew = this.fetchTFSProject(tfsProjectId, almAccount, tfsProject);
        if (PropertyValidator.isValid((Object)tfsProjectNew)) {
            tfsProjectNew.setAlmId(almId);
        }
        tfsProjectNew.setAlmAccount(almAccount);
        return tfsProjectNew;
    }

    private TFSProject fetchTFSProject(String tfsProjectId, AlmAccount almAccount, TFSProject tfsProject) throws ViztrendJiraException {
        if (PropertyValidator.isValid((Object)tfsProject) && PropertyValidator.isValid((Object)tfsProject.getId())) {
            if (PropertyValidator.isValid((Object)tfsProject.getFetchedBy())) {
                AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)tfsProject.getFetchedBy(), (AlmAccount)almAccount);
                if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                    almAccount = taggedAlmAccount;
                }
            } else {
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
            }
        }
        String tfsProjectStr = null;
        tfsProjectStr = this.tfsUtils.getTFSProject(tfsProjectId, almAccount);
        JSONObject projectObject = new JSONObject(tfsProjectStr);
        String id = PropertyValidator.isValid((Object)tfsProject) ? tfsProject.getId() : ObjectId.get().toString();
        String tfsId = projectObject.getString("id");
        String name = projectObject.getString("name");
        String url = projectObject.getString("url");
        String state = projectObject.getString("state");
        TFSProject tfsProjectTemp = new TFSProject(id, tfsId, name, url, state);
        tfsProjectTemp.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
        JSONObject capabilitiesObject = projectObject.getJSONObject("capabilities");
        JSONObject processTemplateObject = capabilitiesObject.getJSONObject("processTemplate");
        String templateName = processTemplateObject.getString("templateName");
        String templateTypeId = processTemplateObject.getString("templateTypeId");
        tfsProjectTemp.setTfsProcessId(templateTypeId);
        tfsProjectTemp.setTfsProcessName(templateName);
        if (PropertyValidator.isValid((Object)tfsProject) && PropertyValidator.isValid((Object)tfsProject.getId())) {
            tfsProjectTemp.setId(tfsProject.getId());
            tfsProjectTemp.setItemEstimationField(tfsProject.getItemEstimationField());
            tfsProjectTemp.setSubItemEstimationField(tfsProject.getSubItemEstimationField());
            tfsProjectTemp.setItemDueDateField(tfsProject.getItemDueDateField());
            tfsProjectTemp.setSubItemDueDateField(tfsProject.getSubItemDueDateField());
            tfsProjectTemp.setItemStartDateField(tfsProject.getItemStartDateField());
            tfsProjectTemp.setItemEndDateField(tfsProject.getItemEndDateField());
            tfsProjectTemp.setLinkedWorkspaceKeys(tfsProject.getLinkedWorkspaceKeys());
            tfsProjectTemp.setLinkedConfigIds(tfsProject.getLinkedConfigIds());
            tfsProjectTemp.setHasMappingByCollectionId(tfsProject.getHasMappingByCollectionId());
        }
        String tfsTeamsStr = this.tfsUtils.getProjectTeamsByPage(tfsProjectTemp.getTfsId(), almAccount);
        tfsProjectTemp.setTeamsStr(tfsTeamsStr);
        String classificationNodes = this.tfsUtils.getProjectAreaNodes(tfsProjectTemp.getTfsId(), null, almAccount);
        tfsProjectTemp.setClassificationNodes(classificationNodes);
        boolean updateProcess = false;
        if (PropertyValidator.isValid((Object)tfsProject)) {
            updateProcess = true;
        }
        this.setProcessData(tfsProjectTemp, almAccount, updateProcess);
        this.createWebhookInTFS(almAccount, tfsProjectId);
        return tfsProjectTemp;
    }

    private void setProcessData(TFSProject tfsProject, AlmAccount almAccount, boolean forceUpdate) {
        String tfsAllFieldsStr = this.tfsUtils.getProjectAllFields(tfsProject.getTfsId(), almAccount);
        JSONObject allFieldsObject = new JSONObject(tfsAllFieldsStr);
        JSONArray fieldsArray = allFieldsObject.getJSONArray("value");
        HashMap<String, JSONObject> allFieldsMap = new HashMap<String, JSONObject>();
        for (int i = 0; i < fieldsArray.length(); ++i) {
            JSONObject fieldObject = fieldsArray.getJSONObject(i);
            String fieldRefName = fieldObject.getString("referenceName");
            allFieldsMap.put(fieldRefName, fieldObject);
            continue;
        }
        String tfsItemTypesStr = this.tfsUtils.getProjectItemTypes(tfsProject.getTfsId(), almAccount);
        JSONObject itemTypesObject = new JSONObject(tfsItemTypesStr);
        JSONArray itemTypesArray = itemTypesObject.getJSONArray("value");
        JSONObject itemTypesWithFields = new JSONObject();
        tfsProject.setIconByItemType(new HashMap());
        for (int i = 0; i < itemTypesArray.length(); ++i) {
            try {
                JSONObject itemTypeObject = itemTypesArray.getJSONObject(i);
                String itemTypeName = itemTypeObject.getString("name");
                JSONObject icon = itemTypeObject.getJSONObject("icon");
                String iconURL = icon.getString("url");
                tfsProject.getIconByItemType().put(itemTypeName, iconURL);
                String itemTypeFields = this.tfsUtils.getProjectItemTypeFields(tfsProject.getTfsId(), itemTypeName, almAccount);
                itemTypesWithFields = new JSONObject(itemTypeFields);
                JSONArray itemTypeWithFieldsArray = itemTypesWithFields.getJSONArray("value");
                for (int j = 0; j < itemTypeWithFieldsArray.length(); ++j) {
                    JSONObject fieldObject = itemTypeWithFieldsArray.getJSONObject(j);
                    if (fieldObject.isNull("referenceName") || !allFieldsMap.containsKey(fieldObject.get("referenceName"))) continue;
                    JSONObject fieldMapObj = (JSONObject)allFieldsMap.get(fieldObject.get("referenceName"));
                    fieldObject.put("type", fieldMapObj.get("type"));
                    fieldObject.put("readOnly", fieldMapObj.get("readOnly"));
                }
                itemTypeObject.put("fieldsWithAllowedValues", (Object)itemTypesWithFields);
                itemTypeObject.remove("fields");
                itemTypeObject.remove("fieldInstances");
                itemTypeObject.remove("xmlForm");
                continue;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                LOGGER.error(" :: JSON Exception ..  " + sStackTrace);
            }
        }
        tfsProject.setItemTypesJSON(itemTypesObject.toString());
        tfsProject.setFieldsStr(tfsAllFieldsStr);
    }

    public void saveBulkLinks(Map map) throws Exception {
        String itemLinks;
        ObjectWriter ow;
        JSONObject pushJson;
        List chunk;
        ArrayList kendisItemLinkIds = (ArrayList)map.get("kendisItemLinks");
        ArrayList almItemLinkIds = (ArrayList)map.get("almItemLinks");
        Map fieldsMap = (Map)map.get("fieldsMap");
        String requestId = (String)map.get("requestId");
        String sessionId = (String)map.get("sessionId");
        String solutionBoardId = (String)map.get("solutionBoardId");
        LOGGER.error("Checking Lock");
        if (PropertyValidator.isValid((Object)sessionId)) {
            this.customRepositoryImpl.checkIfSessionLocked(sessionId, "Bulk save");
        } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
            this.customRepositoryImpl.checkIfSolutionBoardLocked(solutionBoardId, "Bulk save", EnumKendis.DEPENDENCY.getCode());
        }
        ArrayList<ItemJiraDependency> reverseItemJiraDependenciesToUpdate = new ArrayList<ItemJiraDependency>();
        List itemLinksToUpdate = null;
        List itemJiraDependenciesToUpdate = null;
        if (PropertyValidator.isValid((Collection)kendisItemLinkIds)) {
            itemLinksToUpdate = this.itemLinkRepository.findByIdIn((List)kendisItemLinkIds);
            this.updateItemLinkObject(itemLinksToUpdate, fieldsMap);
        }
        if (PropertyValidator.isValid((Collection)almItemLinkIds)) {
            itemJiraDependenciesToUpdate = this.itemJiraDependencyRepository.findByIdIn((List)almItemLinkIds);
            if (PropertyValidator.isValid((Collection)itemJiraDependenciesToUpdate)) {
                for (ItemJiraDependency itemjiraDependency : itemJiraDependenciesToUpdate) {
                    Map statusMap;
                    ItemJiraDependency reverseDependency;
                    if (!PropertyValidator.isValid((Object)itemjiraDependency.getSourceItemId()) || !PropertyValidator.isValid((Object)itemjiraDependency.getTargetItemId()) || !PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(itemjiraDependency.getTargetItemId(), itemjiraDependency.getSourceItemId())))) continue;
                    reverseItemJiraDependenciesToUpdate.add(reverseDependency);
                    if (!PropertyValidator.isValid(fieldsMap.get("solutionStatuses")) || !PropertyValidator.isValid((statusMap = (Map)fieldsMap.get("solutionStatuses")).get(itemjiraDependency.getId()))) continue;
                    statusMap.put(reverseDependency.getId(), statusMap.get(itemjiraDependency.getId()));
                }
                this.updateItemJiraDependencyObject(itemJiraDependenciesToUpdate, fieldsMap, Boolean.valueOf(true));
            }
            this.updateItemJiraDependencyObject(reverseItemJiraDependenciesToUpdate, fieldsMap, Boolean.valueOf(false));
        }
        int chunkSize = 5;
        if (PropertyValidator.isValid((Collection)itemLinksToUpdate)) {
            for (int i = 0; i < itemLinksToUpdate.size(); i += chunkSize) {
                int end = Math.min(i + chunkSize, itemLinksToUpdate.size());
                chunk = itemLinksToUpdate.subList(i, end);
                chunk = this.itemLinkRepository.save(chunk);
                pushJson = new JSONObject();
                ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                itemLinks = ow.writeValueAsString((Object)itemLinksToUpdate);
                pushJson.put("links", (Collection)chunk);
                pushJson.put("updated", chunk.size());
                pushJson.put("type", (Object)"kendisLink");
                pushJson.put("metaMap", true);
                if (!PropertyValidator.isValid((Object)requestId)) continue;
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        if (PropertyValidator.isValid((Collection)itemJiraDependenciesToUpdate)) {
            for (int i = 0; i < itemJiraDependenciesToUpdate.size(); i += chunkSize) {
                int end = Math.min(i + chunkSize, itemJiraDependenciesToUpdate.size());
                chunk = itemJiraDependenciesToUpdate.subList(i, end);
                chunk = this.itemJiraDependencyRepository.save((Iterable)chunk);
                pushJson = new JSONObject();
                ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                itemLinks = ow.writeValueAsString((Object)itemJiraDependenciesToUpdate);
                pushJson.put("links", (Collection)chunk);
                pushJson.put("updated", chunk.size());
                pushJson.put("type", (Object)"almLink");
                pushJson.put("metaMap", true);
                if (!PropertyValidator.isValid((Object)requestId)) continue;
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        LOGGER.error("Reached end of iteration");
        JSONObject pushJson2 = new JSONObject();
        ObjectWriter ow2 = new ObjectMapper().writer().withDefaultPrettyPrinter();
        String itemLinks2 = ow2.writeValueAsString((Object)itemLinksToUpdate);
        pushJson2.put("completed", true);
        pushJson2.put("metaMap", true);
        if (PropertyValidator.isValid((Object)requestId)) {
            this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson2.toString(), Boolean.valueOf(true)));
        }
        if (PropertyValidator.isValid(reverseItemJiraDependenciesToUpdate)) {
            this.itemJiraDependencyRepository.save(reverseItemJiraDependenciesToUpdate);
        }
        LOGGER.error("Opening Lock");
        if (PropertyValidator.isValid((Object)sessionId)) {
            this.customRepositoryImpl.removeSessionLock(sessionId);
        } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
            this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.DEPENDENCY.getCode());
        }
    }

    public void updateItemLinkObject(List<ItemLink> links, Map fieldsMap) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        for (ItemLink itemLink : links) {
            SimpleDateFormat sdf;
            User resp;
            Map respMap;
            ItemLink itemLink2;
            String json;
            Object status;
            Map statusMap;
            if (fieldsMap.containsKey("status")) {
                statusMap = (Map)fieldsMap.get("status");
                status = new Status((String)statusMap.get("id"));
                status.setTitle((String)statusMap.get("title"));
                status.setCategory((String)statusMap.get("category"));
                if (PropertyValidator.isValid((Object)itemLink.getWfStatus()) && !itemLink.getWfStatus().getId().equals(status.getId())) {
                    try {
                        json = mapper.writeValueAsString((Object)itemLink);
                        itemLink2 = (ItemLink)mapper.readValue(json, ItemLink.class);
                        itemLink2.setWfStatus((Status)status);
                        this.notificationServiceImpl.startNotificationThread(itemLink2, itemLink, "dependency_statuschange_template", Boolean.valueOf(false), "");
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
                itemLink.setWfStatus((Status)status);
            }
            if (fieldsMap.containsKey("solutionStatuses") && (statusMap = (Map)fieldsMap.get("solutionStatuses")).containsKey(itemLink.getId())) {
                status = (Map)statusMap.get(itemLink.getId());
                Status statusObj = new Status((String)status.get("id"));
                statusObj.setTitle((String)status.get("title"));
                statusObj.setCategory((String)status.get("category"));
                itemLink.setWfStatus(statusObj);
            }
            if (fieldsMap.containsKey("responsible")) {
                respMap = (Map)fieldsMap.get("responsible");
                if (PropertyValidator.isValid((Object)respMap) && !respMap.isEmpty()) {
                    resp = this.userRepository.findById((String)respMap.get("id"));
                    if (PropertyValidator.isValid((Object)itemLink.getResponsible()) && !itemLink.getResponsible().getId().equals(resp.getId())) {
                        try {
                            json = mapper.writeValueAsString((Object)itemLink);
                            itemLink2 = (ItemLink)mapper.readValue(json, ItemLink.class);
                            itemLink2.setResponsible(resp);
                            this.notificationServiceImpl.startNotificationThread(itemLink2, itemLink, "dependency_responsible_template", Boolean.valueOf(false), "");
                        }
                        catch (JsonProcessingException e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    }
                    itemLink.setResponsible(resp);
                } else {
                    itemLink.setResponsible(null);
                }
            }
            if (fieldsMap.containsKey("reporter")) {
                respMap = (Map)fieldsMap.get("reporter");
                if (PropertyValidator.isValid((Object)respMap) && !respMap.isEmpty()) {
                    resp = new User((String)respMap.get("id"));
                    itemLink.setReporter(resp);
                } else {
                    itemLink.setReporter(null);
                }
            }
            if (fieldsMap.containsKey("targetDate")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date due = sdf.parse((String)fieldsMap.get("targetDate"));
                    itemLink.setDueDate(due);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("raisedOn")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date raisedOn = sdf.parse((String)fieldsMap.get("raisedOn"));
                    itemLink.setRaisedOn(raisedOn);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("comment")) {
                String text = (String)fieldsMap.get("comment");
                Conversation conv = new Conversation();
                conv.setText(text);
                User convoUser = new User(UserContextUtil.getUserContext().getLoggedInUser().getId());
                conv.setUser(convoUser);
                conv = (Conversation)this.conversationRepository.save((Object)conv);
                itemLink.getConversations().add(conv);
            }
            if (!PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) continue;
            this.almSyncService.syncKendisAndAlmLink((Object)itemLink);
        }
    }

    public void updateItemJiraDependencyObject(List<ItemJiraDependency> links, Map fieldsMap, Boolean original) throws Exception {
        for (ItemJiraDependency itemLink : links) {
            SimpleDateFormat sdf;
            User resp;
            Map respMap;
            Object status;
            Map statusMap;
            if (fieldsMap.containsKey("status")) {
                statusMap = (Map)fieldsMap.get("status");
                status = new Status((String)statusMap.get("id"));
                status.setCategory((String)statusMap.get("category"));
                itemLink.setWfStatus((Status)status);
            }
            if (fieldsMap.containsKey("solutionStatuses") && (statusMap = (Map)fieldsMap.get("solutionStatuses")).containsKey(itemLink.getId())) {
                status = (Map)statusMap.get(itemLink.getId());
                Status statusObj = new Status((String)status.get("id"));
                itemLink.setWfStatus(statusObj);
            }
            if (fieldsMap.containsKey("responsible")) {
                respMap = (Map)fieldsMap.get("responsible");
                if (PropertyValidator.isValid((Object)respMap) && !respMap.isEmpty()) {
                    resp = this.userRepository.findById((String)respMap.get("id"));
                    itemLink.setResponsible(resp);
                } else {
                    itemLink.setResponsible(null);
                }
            }
            if (fieldsMap.containsKey("reporter")) {
                respMap = (Map)fieldsMap.get("reporter");
                if (PropertyValidator.isValid((Object)respMap) && !respMap.isEmpty()) {
                    resp = new User((String)respMap.get("id"));
                    itemLink.setReporter(resp);
                } else {
                    itemLink.setReporter(null);
                }
            }
            if (fieldsMap.containsKey("targetDate")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date due = sdf.parse((String)fieldsMap.get("targetDate"));
                    itemLink.setDueDate(due);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("raisedOn")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    Date raisedOn = sdf.parse((String)fieldsMap.get("raisedOn"));
                    itemLink.setRaisedOn(raisedOn);
                }
                catch (ParseException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (fieldsMap.containsKey("comment")) {
                String text = (String)fieldsMap.get("comment");
                Conversation conv = new Conversation();
                conv.setText(text);
                User convoUser = new User(UserContextUtil.getUserContext().getLoggedInUser().getId());
                conv.setUser(convoUser);
                conv = (Conversation)this.conversationRepository.save((Object)conv);
                itemLink.getConversations().add(conv);
            }
            if (!original.booleanValue() || !PropertyValidator.isValid((Object)itemLink.getJiraDependencyId())) continue;
            this.almSyncService.syncKendisAndAlmLink((Object)itemLink);
        }
    }

    public HashMap<String, Object> resyncIterationPathsOfProject(String projectId, String almId) throws ViztrendJiraException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TFSProject project = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)projectId));
        AlmAccount almAccount = this.almAccountRepository.findById(almId);
        if (PropertyValidator.isValid((Object)project)) {
            String classificationNodes = this.tfsUtils.getProjectAreaNodes(project.getTfsId(), null, almAccount);
            project.setClassificationNodes(classificationNodes);
            project = (TFSProject)this.tfsProjectRepository.save((Object)project);
            result.put("success", true);
            result.put("project", project);
        }
        return result;
    }

    public HashMap copyFilter(HashMap copyFilterRequest) throws Exception {
        String newFilterName;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap copyFilter = (HashMap)copyFilterRequest.get("copyFilter");
        String sessionId = (String)copyFilterRequest.get("sessionId");
        boolean nameExists = this.customRepositoryImpl.checkFilterNameExists(sessionId, newFilterName = (String)copyFilterRequest.get("newFilterName"));
        if (nameExists) {
            response.put("success", false);
            response.put("nameConflict", true);
            response.put("message", "A filter with this name already exists. Please enter a new name.");
            return response;
        }
        Query findQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId((String)copyFilter.get("id"))));
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        findQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        BasicDBObject originalFilter = (BasicDBObject)this.mongoTemplate.findOne(findQuery, BasicDBObject.class, "boardFilter");
        if (originalFilter != null) {
            BoardFilter newFilter = new BoardFilter();
            newFilter.setFilterName(newFilterName);
            newFilter.setSessionId(sessionId);
            newFilter.setDescription((String)originalFilter.get("description"));
            newFilter.setFilters((String)originalFilter.get("filters"));
            newFilter.setType((String)originalFilter.get("type"));
            Object userId = originalFilter.get("userId");
            if (userId != null) {
                newFilter.setUserId((String)userId);
            }
            DBRef userRef = (DBRef)originalFilter.get("user");
            User user = new User();
            user.setId(userRef.getId().toString());
            newFilter.setUser(user);
            this.createBoardFilter(newFilter);
            response.put("success", true);
            response.put("message", "Filter copied successfully");
        } else {
            response.put("success", false);
            response.put("message", "Original filter not found");
        }
        return response;
    }

    static /* synthetic */ TFSUtils access$000(TFSserviceImpl x0) {
        return x0.tfsUtils;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

