/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.JiraAlmAccountMeta;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StatsExclusion;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.JiraAlmAccountMetaRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatsServiceDAO;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ImportService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.StatsService;
import com.viztrend.safe.service.StatsServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="StatsService")
@Transactional
public class StatsServiceImpl
implements StatsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsServiceImpl.class);
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    ImportService importService;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private Environment env;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private JiraAlmAccountMetaRepository jiraAlmAccountMetaRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private StatsServiceDAO statsServiceDAO;

    private void buildQuery(Query query) {
        try {
            query.fields().include("_id");
            query.fields().include("originItemId");
            query.fields().include("parent");
            query.fields().include("title");
            query.fields().include("subItemEstimate");
            query.fields().include("status");
            query.fields().include("jiraKey");
            query.fields().include("jiraId");
            query.fields().include("tfsId");
            query.fields().include("tfsURL");
            query.fields().include("itemLinks");
            query.fields().include("sessionBoards");
            query.fields().include("jiraDependencies");
            query.fields().include("teamContainers");
            query.fields().include("issueType");
            query.fields().include("createdOn");
            query.fields().include("updatedOn");
            query.fields().include("dueDate");
            query.fields().include("storyPoints");
            query.fields().include("externalReferenceURL");
            query.fields().include("createdBy");
            query.fields().include("duplicateOfId");
            query.fields().include("updatedBy");
            query.fields().include("type");
            query.fields().include("tfsApiURL");
            query.fields().include("tfsProjectId");
            query.fields().include("tfsProject");
            query.fields().include("tfsItemType");
            query.fields().include("tfsItemTypeIcon");
            query.fields().include("tfsFilter");
            query.fields().include("tfsAreaPath");
            query.fields().include("tfsIterationPath");
            query.fields().include("jiraFilter");
            query.fields().include("jiraProjectKey");
            query.fields().include("jiraIssueTypeId");
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private List<DBObject> getSingleItemById(String itemId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getPiReportItems(SessionBoard sessionBoard) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoard.getId())));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getPiReportItemsWithTypeSorted(SessionBoard sessionBoard, String type) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoard.getId())));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getPiReportItemsSorted(SessionBoard sessionBoard) {
        ArrayList<String> itemTypeList = new ArrayList<String>();
        itemTypeList.add(Item.FEATURE);
        itemTypeList.add(Item.USER_STORY);
        ArrayList<DBObject> rawItems = new ArrayList<DBObject>();
        for (int i = 0; i < itemTypeList.size(); ++i) {
            rawItems.addAll(this.getPiReportItemsWithTypeSorted(sessionBoard, (String)itemTypeList.get(i)));
        }
        return rawItems;
    }

    private List<DBObject> getPiReportItemsBySelectedCartTypes(SessionBoard sessionBoard, List<ObjectId> allSelectedCartTypeIds, boolean isFearureCartTypeSelected, String tenant) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoard.getId())));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").ne((Object)"UserStory"));
        if (isFearureCartTypeSelected) {
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"issueType").exists(false), Criteria.where((String)"issueType.$id").in(allSelectedCartTypeIds), Criteria.where((String)"issueType.$id").is((Object)"-1")});
            query.addCriteria((CriteriaDefinition)criteria);
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"issueType.$id").in(allSelectedCartTypeIds));
        }
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getPiReportStoriesOfSelectedCartTypes(SessionBoard sessionBoard, List<ObjectId> allParentIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoard.getId())));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(allParentIds));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getItemsForDIfferentBoards(List<ObjectId> allActiveSessionBoards) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        this.buildQuery(query);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(allActiveSessionBoards));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    private List<DBObject> getIssueTypeOfBoardWhichIsArchive(String tenant) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("issueType").find(query.getQueryObject());
        List issueTypes = dbCursorPrefix.toArray();
        return issueTypes;
    }

    private List<DBObject> getItemsLinksOfBoards(List<ObjectId> allLinksIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.fields().include("_id");
        query.fields().include("originItemId");
        query.fields().include("status");
        query.fields().include("sessionBoardId");
        query.fields().include("type");
        query.fields().include("wfStatus");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(allLinksIds));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query.getQueryObject(), query.getFieldsObject());
        List rawItemsLinks = dbCursorPrefix.toArray();
        return rawItemsLinks;
    }

    private List<DBObject> getSessions(List<ObjectId> workSpaces) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("activeSessionBoard");
        query.fields().include("itemWorkFlow");
        query.fields().include("subItemWorkFlow");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").in(workSpaces));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject(), query.getFieldsObject());
        List rawSessions = dbCursorPrefix.toArray();
        return rawSessions;
    }

    private List<DBObject> getSessionsByIds(List<ObjectId> sessionIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("activeSessionBoard");
        query.fields().include("itemWorkFlow");
        query.fields().include("subItemWorkFlow");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sessionIds));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject(), query.getFieldsObject());
        List rawSessions = dbCursorPrefix.toArray();
        return rawSessions;
    }

    private List<DBObject> getAuditLogData(List<ObjectId> auditLogIds, List<String> linkedBaseLineAuditLogIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"_id").in(auditLogIds), Criteria.where((String)"linkedBaseLineAuditLogId").in(linkedBaseLineAuditLogIds)}));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("auditLog").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    private List<DBObject> getItemCompleatHistory(List<String> spillOverItemsIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.with(new Sort(Sort.Direction.ASC, new String[]{"createdOn"}));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"itemId").in(spillOverItemsIds), Criteria.where((String)"detail.originItemId").in(spillOverItemsIds)});
        query.addCriteria((CriteriaDefinition)criteria);
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLog").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    private List<DBObject> getTeamContainer(List<ObjectId> teamContainerIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamContainerIds));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    public List<DBObject> getAllAccessableBoards() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        ArrayList<ObjectId> workSpacesIds = new ArrayList<ObjectId>();
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepositoryImpl.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        for (WorkSpace rawWorkSpace : workSpaces) {
            workSpacesIds.add(new ObjectId(String.valueOf(String.valueOf(rawWorkSpace.getId()))));
        }
        List<Object> sessions = new ArrayList<DBObject>();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.getSessions(workSpacesIds);
        }
        return sessions;
    }

    private List<DBObject> getTeamCapacity(List<String> sessionBoardIds, String tenant) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").in(sessionBoardIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("teamSprintVelocity").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    private HashMap<String, Object> piComparison() throws Exception {
        List allSessionBoards = this.getAllAccessableBoards();
        LinkedList<ObjectId> activeSessionBoardObjIds = new LinkedList<ObjectId>();
        HashMap<String, String> allSessionBoardsNameBySessionBoardId = new HashMap<String, String>();
        HashMap allSessionActiveStateByActiveSessionBoardId = new HashMap();
        HashMap objectiveTeamsMapByBoardId = new HashMap();
        HashMap<String, String> sessionBoardIdsByActiveSessionBoardIds = new HashMap<String, String>();
        HashMap<String, String> sessionBoardIdsByNewObjectiveFlag = new HashMap<String, String>();
        for (DBObject piSession : allSessionBoards) {
            String activeSessionBoard = String.valueOf(piSession.get("activeSessionBoard"));
            activeSessionBoardObjIds.add(new ObjectId(activeSessionBoard));
            if (piSession.get("activeSessionBoard") == null) continue;
            allSessionBoardsNameBySessionBoardId.put(String.valueOf(piSession.get("_id")), String.valueOf(piSession.get("title")));
            sessionBoardIdsByActiveSessionBoardIds.put(String.valueOf(piSession.get("activeSessionBoard")), String.valueOf(piSession.get("_id")));
        }
        List allActiveSessionBoards = this.statsServiceDAO.findSessionBoardsByIdIn(activeSessionBoardObjIds, UserContextUtil.getUserContext().getLoggedInUser().getTenant());
        HashMap objectivesMapByActiveSessionBoardIds = new HashMap();
        List activeSessionBoardIds = allActiveSessionBoards.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List sessionIds = allActiveSessionBoards.stream().map(sessionBoard -> sessionBoard.getSession().getId()).collect(Collectors.toList());
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        Map loadObjectivesDataByActiveSessionId = this.objectiveService.fetchNewObjectiveDataForBoards(activeSessionBoardIds, sessionIds, tenant);
        for (SessionBoard activeSessionBoard : allActiveSessionBoards) {
            allSessionActiveStateByActiveSessionBoardId.put(sessionBoardIdsByActiveSessionBoardIds.get(activeSessionBoard.getId()), activeSessionBoard.getState().getTitle());
            if (!activeSessionBoard.getSession().getLoadOldObjectivesView().booleanValue()) {
                HashMap newObjective = (HashMap)loadObjectivesDataByActiveSessionId.get(String.valueOf(activeSessionBoard.getSession().getId()));
                objectivesMapByActiveSessionBoardIds.put(sessionBoardIdsByActiveSessionBoardIds.get(activeSessionBoard.getId()), newObjective);
                sessionBoardIdsByNewObjectiveFlag.put(String.valueOf(sessionBoardIdsByActiveSessionBoardIds.get(activeSessionBoard.getId())), String.valueOf(activeSessionBoard.getSession().getLoadOldObjectivesView()));
            } else {
                objectivesMapByActiveSessionBoardIds.put(sessionBoardIdsByActiveSessionBoardIds.get(activeSessionBoard.getId()), activeSessionBoard.getObjectivesMap());
            }
            List activeSessionTeams = activeSessionBoard.getTeams();
            HashMap objectiveTeams = new HashMap();
            activeSessionTeams.forEach(team -> {
                HashMap<String, String> teamDetails = new HashMap<String, String>();
                teamDetails.put("id", team.getId());
                teamDetails.put("title", team.getTitle());
                teamDetails.put("label", team.getLabel());
                teamDetails.put("color", team.getColor());
                objectiveTeams.put(team.getId(), teamDetails);
            });
            objectiveTeamsMapByBoardId.put(sessionBoardIdsByActiveSessionBoardIds.get(activeSessionBoard.getId()), objectiveTeams);
        }
        List issueTypes = this.issueTypeRepository.findAll();
        HashMap<String, String> issueTypeMapById = new HashMap<String, String>();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType.getTitle()));
        issueTypeMapById.put("-100", "Features");
        HashMap<String, Object> programPredictabilityMatrix = new HashMap<String, Object>();
        programPredictabilityMatrix.put("cartType", issueTypeMapById);
        programPredictabilityMatrix.put("mapOfBoardIdAndActiveState", allSessionActiveStateByActiveSessionBoardId);
        programPredictabilityMatrix.put("mapOfBoardIdAndName", allSessionBoardsNameBySessionBoardId);
        programPredictabilityMatrix.put("teamData", objectiveTeamsMapByBoardId);
        programPredictabilityMatrix.put("objectiveMapByBoardId", objectivesMapByActiveSessionBoardIds);
        programPredictabilityMatrix.put("sessionBoardForNewObjectiveFlag", sessionBoardIdsByNewObjectiveFlag);
        return programPredictabilityMatrix;
    }

    private HashMap<String, Object> boardScopChangeData(List<SessionBoard> allActiveSessionBoards, List<IssueType> issueTypes, Map<String, String> allSessionidsMapBySessionBoardIds) {
        List allStates = this.stateRepository.findAll();
        State prevState = null;
        HashMap scopeChangeDataMapByBoardId = new HashMap();
        HashMap<String, HashMap> dependencyDataMapByBoardId = new HashMap<String, HashMap>();
        HashMap issueTypeMapById = new HashMap();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
        HashMap boardStatusMap = new HashMap();
        List allStatuses = this.statusRepository.findAll();
        if (allStatuses != null) {
            allStatuses.forEach(status -> boardStatusMap.put(String.valueOf(status.getId()), status));
        }
        for (SessionBoard activeSessionBoard : allActiveSessionBoards) {
            HashMap getStoryData;
            HashMap getCartTypeData;
            HashMap<String, Integer> addRemoveData;
            String title;
            String issueTypeId;
            DBRef issueTypeRef;
            IssueType issueType2;
            HashMap getFeatureData;
            HashMap<String, Integer> addRemoveData2;
            for (State s : allStates) {
                if (activeSessionBoard.getState().getTitle().equalsIgnoreCase("Draft")) {
                    prevState = null;
                    continue;
                }
                if (activeSessionBoard.getState().getTitle().equalsIgnoreCase("Close")) {
                    if (s.getSequence() != activeSessionBoard.getState().getSequence() - 2) continue;
                    prevState = s;
                    break;
                }
                if (s.getSequence() != activeSessionBoard.getState().getSequence() - 1) continue;
                prevState = s;
                break;
            }
            Session session = activeSessionBoard.getSession();
            SessionBoard prevSessionBoard = this.sessionBoardRepository.findOneBySessionAndState(session, prevState);
            List rawItems = this.getPiReportItemsSorted(activeSessionBoard);
            List previousStateItems = null;
            if (prevState != null) {
                previousStateItems = this.getPiReportItemsSorted(prevSessionBoard);
            }
            HashMap<String, DBObject> currentStateItemsMapById = new HashMap<String, DBObject>();
            ArrayList<String> itemsLinksArrayIds = new ArrayList<String>();
            ArrayList<ObjectId> itemsLinksArrayObjectIds = new ArrayList<ObjectId>();
            if (rawItems != null) {
                for (DBObject rawItem : rawItems) {
                    if (rawItem.get("originItemId") != null) {
                        currentStateItemsMapById.put(String.valueOf(rawItem.get("originItemId")), rawItem);
                        currentStateItemsMapById.put(String.valueOf(rawItem.get("_id")), rawItem);
                    } else {
                        currentStateItemsMapById.put(String.valueOf(rawItem.get("_id")), rawItem);
                    }
                    if (rawItem.get("itemLinks") == null) continue;
                    List itemLinksRef = (List)rawItem.get("itemLinks");
                    for (int k = 0; k < itemLinksRef.size(); ++k) {
                        DBRef linksRef = (DBRef)itemLinksRef.get(k);
                        itemsLinksArrayIds.add(String.valueOf(linksRef.getId()));
                        ObjectId obj = new ObjectId(String.valueOf(String.valueOf(linksRef.getId())));
                        itemsLinksArrayObjectIds.add(obj);
                    }
                }
            }
            HashMap<String, DBObject> previousStateItemsMapById = new HashMap<String, DBObject>();
            HashMap scopeChangeData = new HashMap();
            if (previousStateItems != null) {
                for (DBObject previousRawItem : previousStateItems) {
                    if (previousRawItem.get("originItemId") != null) {
                        previousStateItemsMapById.put(String.valueOf(previousRawItem.get("originItemId")), previousRawItem);
                        if (currentStateItemsMapById.get(previousRawItem.get("originItemId")) != null) continue;
                        if (previousRawItem.get("type").equals(Item.FEATURE)) {
                            if (previousRawItem.get("issueType") == null && issueTypeMapById.get("-100") != null) {
                                if (scopeChangeData.get("Scope Changes-Features") == null) {
                                    addRemoveData2 = new HashMap();
                                    addRemoveData2.put("Added", 0);
                                    addRemoveData2.put("Removed", 0);
                                    scopeChangeData.put("Scope Changes-Features", addRemoveData2);
                                }
                                getFeatureData = (HashMap)scopeChangeData.get("Scope Changes-Features");
                                getFeatureData.put("Removed", (Integer)getFeatureData.get("Removed") + 1);
                                continue;
                            }
                            if (previousRawItem.get("issueType") == null) continue;
                            issueType2 = null;
                            issueTypeRef = (DBRef)previousRawItem.get("issueType");
                            if (!PropertyValidator.isValid((Object)issueTypeRef)) continue;
                            issueTypeId = String.valueOf(issueTypeRef.getId());
                            title = null;
                            issueType2 = (IssueType)issueTypeMapById.get(issueTypeId);
                            if (issueType2 == null) continue;
                            title = "Scope Changes-" + issueType2.getTitle();
                            if (scopeChangeData.get(title) == null) {
                                addRemoveData = new HashMap();
                                addRemoveData.put("Added", 0);
                                addRemoveData.put("Removed", 0);
                                scopeChangeData.put(title, addRemoveData);
                            }
                            getCartTypeData = (HashMap)scopeChangeData.get(title);
                            getCartTypeData.put("Removed", (Integer)getCartTypeData.get("Removed") + 1);
                            continue;
                        }
                        if (!previousRawItem.get("type").equals(Item.USER_STORY)) continue;
                        if (scopeChangeData.get("Scope Changes-Stories") == null) {
                            addRemoveData2 = new HashMap();
                            addRemoveData2.put("Added", 0);
                            addRemoveData2.put("Removed", 0);
                            scopeChangeData.put("Scope Changes-Stories", addRemoveData2);
                        }
                        getStoryData = (HashMap)scopeChangeData.get("Scope Changes-Stories");
                        getStoryData.put("Removed", (Integer)getStoryData.get("Removed") + 1);
                        continue;
                    }
                    previousStateItemsMapById.put(String.valueOf(previousRawItem.get("_id")), previousRawItem);
                    if (currentStateItemsMapById.get(String.valueOf(previousRawItem.get("_id"))) != null) continue;
                    if (previousRawItem.get("type").equals(Item.FEATURE)) {
                        if (previousRawItem.get("issueType") == null && issueTypeMapById.get("-100") != null) {
                            if (scopeChangeData.get("Scope Changes-Features") == null) {
                                addRemoveData2 = new HashMap();
                                addRemoveData2.put("Added", 0);
                                addRemoveData2.put("Removed", 0);
                                scopeChangeData.put("Scope Changes-Features", addRemoveData2);
                            }
                            getFeatureData = (HashMap)scopeChangeData.get("Scope Changes-Features");
                            getFeatureData.put("Removed", (Integer)getFeatureData.get("Removed") + 1);
                            continue;
                        }
                        if (previousRawItem.get("issueType") == null) continue;
                        issueType2 = null;
                        issueTypeRef = (DBRef)previousRawItem.get("issueType");
                        if (!PropertyValidator.isValid((Object)issueTypeRef)) continue;
                        issueTypeId = String.valueOf(issueTypeRef.getId());
                        title = null;
                        issueType2 = (IssueType)issueTypeMapById.get(issueTypeId);
                        if (issueType2 == null) continue;
                        title = "Scope Changes-" + issueType2.getTitle();
                        if (scopeChangeData.get(title) == null) {
                            addRemoveData = new HashMap();
                            addRemoveData.put("Added", 0);
                            addRemoveData.put("Removed", 0);
                            scopeChangeData.put(title, addRemoveData);
                        }
                        getCartTypeData = (HashMap)scopeChangeData.get(title);
                        getCartTypeData.put("Removed", (Integer)getCartTypeData.get("Removed") + 1);
                        continue;
                    }
                    if (!previousRawItem.get("type").equals(Item.USER_STORY)) continue;
                    if (scopeChangeData.get("Scope Changes-Stories") == null) {
                        addRemoveData2 = new HashMap();
                        addRemoveData2.put("Added", 0);
                        addRemoveData2.put("Removed", 0);
                        scopeChangeData.put("Scope Changes-Stories", addRemoveData2);
                    }
                    getStoryData = (HashMap)scopeChangeData.get("Scope Changes-Stories");
                    getStoryData.put("Removed", (Integer)getStoryData.get("Removed") + 1);
                }
            }
            if (rawItems != null) {
                for (DBObject rawItem : rawItems) {
                    if (rawItem.get("originItemId") != null) {
                        if (previousStateItemsMapById.get(rawItem.get("originItemId")) != null) continue;
                        if (rawItem.get("type").equals(Item.FEATURE)) {
                            if (rawItem.get("issueType") == null && issueTypeMapById.get("-100") != null) {
                                if (scopeChangeData.get("Scope Changes-Features") == null) {
                                    addRemoveData2 = new HashMap();
                                    addRemoveData2.put("Added", 0);
                                    addRemoveData2.put("Removed", 0);
                                    scopeChangeData.put("Scope Changes-Features", addRemoveData2);
                                }
                                getFeatureData = (HashMap)scopeChangeData.get("Scope Changes-Features");
                                getFeatureData.put("Added", (Integer)getFeatureData.get("Added") + 1);
                                continue;
                            }
                            if (rawItem.get("issueType") == null) continue;
                            issueType2 = null;
                            issueTypeRef = (DBRef)rawItem.get("issueType");
                            if (!PropertyValidator.isValid((Object)issueTypeRef)) continue;
                            issueTypeId = String.valueOf(issueTypeRef.getId());
                            title = null;
                            issueType2 = (IssueType)issueTypeMapById.get(issueTypeId);
                            if (issueType2 == null) continue;
                            title = "Scope Changes-" + issueType2.getTitle();
                            if (scopeChangeData.get(title) == null) {
                                addRemoveData = new HashMap<String, Integer>();
                                addRemoveData.put("Added", 0);
                                addRemoveData.put("Removed", 0);
                                scopeChangeData.put(title, addRemoveData);
                            }
                            getCartTypeData = (HashMap)scopeChangeData.get(title);
                            getCartTypeData.put("Added", (Integer)getCartTypeData.get("Added") + 1);
                            continue;
                        }
                        if (!rawItem.get("type").equals(Item.USER_STORY)) continue;
                        if (scopeChangeData.get("Scope Changes-Stories") == null) {
                            addRemoveData2 = new HashMap<String, Integer>();
                            addRemoveData2.put("Added", 0);
                            addRemoveData2.put("Removed", 0);
                            scopeChangeData.put("Scope Changes-Stories", addRemoveData2);
                        }
                        getStoryData = (HashMap)scopeChangeData.get("Scope Changes-Stories");
                        getStoryData.put("Added", (Integer)getStoryData.get("Added") + 1);
                        continue;
                    }
                    if (previousStateItemsMapById.get(String.valueOf(rawItem.get("duplicateOfId"))) != null) continue;
                    if (rawItem.get("type").equals(Item.FEATURE)) {
                        if (rawItem.get("issueType") == null && issueTypeMapById.get("-100") != null) {
                            if (scopeChangeData.get("Scope Changes-Features") == null) {
                                addRemoveData2 = new HashMap();
                                addRemoveData2.put("Added", 0);
                                addRemoveData2.put("Removed", 0);
                                scopeChangeData.put("Scope Changes-Features", addRemoveData2);
                            }
                            getFeatureData = (HashMap)scopeChangeData.get("Scope Changes-Features");
                            getFeatureData.put("Added", (Integer)getFeatureData.get("Added") + 1);
                            continue;
                        }
                        if (rawItem.get("issueType") == null) continue;
                        issueType2 = null;
                        issueTypeRef = (DBRef)rawItem.get("issueType");
                        if (!PropertyValidator.isValid((Object)issueTypeRef)) continue;
                        issueTypeId = String.valueOf(issueTypeRef.getId());
                        title = null;
                        issueType2 = (IssueType)issueTypeMapById.get(issueTypeId);
                        if (issueType2 == null) continue;
                        title = "Scope Changes-" + issueType2.getTitle();
                        if (scopeChangeData.get(title) == null) {
                            addRemoveData = new HashMap();
                            addRemoveData.put("Added", 0);
                            addRemoveData.put("Removed", 0);
                            scopeChangeData.put(title, addRemoveData);
                        }
                        getCartTypeData = (HashMap)scopeChangeData.get(title);
                        getCartTypeData.put("Added", (Integer)getCartTypeData.get("Added") + 1);
                        continue;
                    }
                    if (!rawItem.get("type").equals(Item.USER_STORY)) continue;
                    if (scopeChangeData.get("Scope Changes-Stories") == null) {
                        addRemoveData2 = new HashMap();
                        addRemoveData2.put("Added", 0);
                        addRemoveData2.put("Removed", 0);
                        scopeChangeData.put("Scope Changes-Stories", addRemoveData2);
                    }
                    getStoryData = (HashMap)scopeChangeData.get("Scope Changes-Stories");
                    getStoryData.put("Added", (Integer)getStoryData.get("Added") + 1);
                }
            }
            dependencyDataMapByBoardId.put(allSessionidsMapBySessionBoardIds.get(String.valueOf(activeSessionBoard.getId())), this.boardDependencyData(itemsLinksArrayObjectIds, boardStatusMap));
            scopeChangeDataMapByBoardId.put(allSessionidsMapBySessionBoardIds.get(String.valueOf(activeSessionBoard.getId())), scopeChangeData);
        }
        HashMap<String, Object> dependencyAndScopChangeData = new HashMap<String, Object>();
        dependencyAndScopChangeData.put("boardsDependencyData", dependencyDataMapByBoardId);
        dependencyAndScopChangeData.put("boardsScopChangeData", scopeChangeDataMapByBoardId);
        return dependencyAndScopChangeData;
    }

    private HashMap<String, Object> itemsDataByStatus(List<DBObject> rawItems, Map<String, Status> statusMapById, Map<String, String> allSessionidsMapBySessionBoardIds) {
        HashMap<String, Object> itemsDataMapByBoardId = new HashMap<String, Object>();
        for (DBObject rawItem : rawItems) {
            HashMap<String, Integer> planedAndDone;
            HashMap itemsDataMapByDataType;
            List itemSessionBoard = (List)rawItem.get("sessionBoards");
            DBRef itemSessionBoardId = (DBRef)itemSessionBoard.get(0);
            if (itemsDataMapByBoardId.get(allSessionidsMapBySessionBoardIds.get(String.valueOf(itemSessionBoardId.getId()))) == null) {
                itemsDataMapByDataType = new HashMap();
                itemsDataMapByBoardId.put(allSessionidsMapBySessionBoardIds.get(String.valueOf(itemSessionBoardId.getId())), itemsDataMapByDataType);
            }
            itemsDataMapByDataType = (HashMap)itemsDataMapByBoardId.get(allSessionidsMapBySessionBoardIds.get(String.valueOf(itemSessionBoardId.getId())));
            DBRef statusRef = (DBRef)rawItem.get("status");
            Status status = null;
            if (PropertyValidator.isValid((Object)statusRef)) {
                String statusId = String.valueOf(statusRef.getId());
                status = statusMapById.get(statusId);
            }
            if (!PropertyValidator.isValid(status)) {
                Status newStatus = new Status();
                newStatus.setTitle("Misc");
                newStatus.setCategory("Misc");
                newStatus.setColor("#7c50b1");
                status = newStatus;
            }
            List TeamsContainer = (List)rawItem.get("teamContainers");
            if (rawItem.get("teamContainers") == null || TeamsContainer.size() <= 0) continue;
            if (rawItem.get("type").equals(Item.FEATURE)) {
                if (itemsDataMapByDataType.get("Features") == null) {
                    planedAndDone = new HashMap<String, Integer>();
                    planedAndDone.put("Planned", 0);
                    planedAndDone.put("Accepted", 0);
                    itemsDataMapByDataType.put("Features", planedAndDone);
                }
                HashMap getFeatureData = (HashMap)itemsDataMapByDataType.get("Features");
                getFeatureData.put("Planned", (Integer)getFeatureData.get("Planned") + 1);
                if (status == null || !status.getCategory().equals("Done")) continue;
                getFeatureData.put("Accepted", (Integer)getFeatureData.get("Accepted") + 1);
                continue;
            }
            if (!rawItem.get("type").equals(Item.USER_STORY) || TeamsContainer.size() <= 0) continue;
            if (itemsDataMapByDataType.get("Stories") == null) {
                planedAndDone = new HashMap();
                planedAndDone.put("Planned", 0);
                planedAndDone.put("Accepted", 0);
                itemsDataMapByDataType.put("Stories", planedAndDone);
            }
            HashMap getStoryData = (HashMap)itemsDataMapByDataType.get("Stories");
            getStoryData.put("Planned", (Integer)getStoryData.get("Planned") + 1);
            if (status == null || !status.getCategory().equals("Done")) continue;
            getStoryData.put("Accepted", (Integer)getStoryData.get("Accepted") + 1);
        }
        return itemsDataMapByBoardId;
    }

    private HashMap<String, Object> boardDependencyData(ArrayList<ObjectId> linksIds, HashMap<String, Status> boardStatusMap) {
        List allItemsLinks = this.getItemsLinksOfBoards(linksIds);
        HashMap<String, Integer> DependencyData = new HashMap<String, Integer>();
        for (DBObject link : allItemsLinks) {
            if (DependencyData.get("Raised") == null) {
                DependencyData.put("Raised", 0);
                DependencyData.put("Resolved", 0);
            }
            DependencyData.put("Raised", (Integer)DependencyData.get("Raised") + 1);
            Status linkStatus = null;
            DBRef linkStatusWorkFlowId = (DBRef)link.get("wfStatus");
            if (PropertyValidator.isValid((Object)linkStatusWorkFlowId)) {
                linkStatus = boardStatusMap.get(String.valueOf(linkStatusWorkFlowId.getId()));
                if (!linkStatus.getCategory().equals("Done")) continue;
                DependencyData.put("Resolved", (Integer)DependencyData.get("Resolved") + 1);
                continue;
            }
            if (!link.get("status").equals("Resolved")) continue;
            DependencyData.put("Resolved", (Integer)DependencyData.get("Resolved") + 1);
        }
        HashMap<String, Object> boardDependencyData = new HashMap<String, Object>();
        boardDependencyData.put("Dependencies", DependencyData);
        return boardDependencyData;
    }

    public HashMap<String, Object> getDataByTeam(String sessionId, Map<String, Object> requestStr) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        String currentSessionBoardId = (String)requestStr.get("currentSessionBoardId");
        SessionBoard activeSessionBoard = null;
        activeSessionBoard = currentSessionBoardId != null && !currentSessionBoardId.equals(session.getActiveSessionBoard()) ? (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)currentSessionBoardId)) : (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
        List activeSessionTeams = activeSessionBoard.getTeams();
        List activeSessionContainers = activeSessionBoard.getContainers();
        HashMap teamNameMapById = new HashMap();
        HashMap teamDetails = new HashMap();
        HashMap<String, String> containerNameMapById = new HashMap<String, String>();
        HashMap<String, Container> containerMapById = new HashMap<String, Container>();
        int unPlannedSum = 0;
        HashMap<String, String> unplannedData = new HashMap<String, String>();
        HashMap teamDoneByFeatures = new HashMap();
        ArrayList<DBObject> storyDetails = new ArrayList<DBObject>();
        Collections.sort(activeSessionContainers, new /* Unavailable Anonymous Inner Class!! */);
        HashMap getBoardAllStatusesMap = this.getBoardAllStatuses(session);
        HashMap statusMapById = (HashMap)getBoardAllStatusesMap.get("statusMapById");
        if (activeSessionTeams != null) {
            activeSessionTeams.forEach(team -> {
                teamNameMapById.put(team.getId(), team.getTitle());
                teamDetails.put(team.getId(), team);
                HashMap featuresDeatils = new HashMap();
                teamDoneByFeatures.put(team.getId(), featuresDeatils);
            });
        }
        Container currentSprint = null;
        Date currentDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        currentDate = cal.getTime();
        for (Container container : activeSessionContainers) {
            containerNameMapById.put(container.getId(), container.getTitle());
            containerMapById.put(container.getId(), container);
            if (PropertyValidator.isValid((Object)container.getOriginItemId())) {
                containerMapById.put(container.getOriginItemId(), container);
            }
            if (currentSprint != null || container.getStartDate() == null || !currentDate.after(container.getStartDate()) && !currentDate.equals(container.getStartDate()) || container.getEndDate() == null || !currentDate.before(container.getEndDate()) && !currentDate.equals(container.getEndDate())) continue;
            currentSprint = container;
        }
        ArrayList<String> boardIds = new ArrayList<String>();
        boardIds.add(activeSessionBoard.getId());
        List boardCapacity = this.getTeamCapacity(boardIds, activeSessionBoard.getTenant());
        HashMap teamDetailsById = new HashMap();
        HashMap sprintDetailsMapByIds = new HashMap();
        HashMap sprintDetailsByTeamsMapBySprintIds = new HashMap();
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap teamDetailBySprint = new HashMap();
        HashMap teamContainersMap = new HashMap();
        HashMap sprintContainersMap = new HashMap();
        HashMap itemKey = new HashMap();
        HashMap itemTeamAndSprintMapByItemId = new HashMap();
        HashMap mapForCheckingNoTeamAndSprintComesDouble = new HashMap();
        ArrayList curentStateItemsLinks = new ArrayList();
        ArrayList curentStatejiraDependencies = new ArrayList();
        HashMap<String, DBObject> itemsById = new HashMap<String, DBObject>();
        HashMap<String, DBObject> currentStateItemsMapByTeamContainerIdsForDependencies = new HashMap<String, DBObject>();
        try {
            ArrayList<String> storiesCreatedAfterActiveSprint = new ArrayList<String>();
            List rawItems = null;
            boolean isFearureCartTypeSelected = false;
            ArrayList<ObjectId> cartTypeIds = new ArrayList<ObjectId>();
            HashMap issueTypeMapByIdForUserSelection = this.getIssueTypeOfTheBoard(session);
            HashMap statsExclusionData = new HashMap();
            ArrayList userSelectedCartType = new ArrayList();
            HashMap dataFlags = (HashMap)requestStr.get("flagsForDataRequire");
            if (!PropertyValidator.isValid(dataFlags.get("notFeatchExcludeItemData"))) {
                statsExclusionData = this.getExcludedItemsCalculation(session, issueTypeMapByIdForUserSelection);
                userSelectedCartType = this.filterCartTypes(issueTypeMapByIdForUserSelection, (ArrayList)statsExclusionData.get("cardType"));
            }
            if (dataFlags.get("callFromAnalyticsFlag") != null && userSelectedCartType.size() > 0) {
                for (int i = 0; i < userSelectedCartType.size(); ++i) {
                    HashMap tempCartType = (HashMap)userSelectedCartType.get(i);
                    String cartTypeId = (String)tempCartType.get("id");
                    if (!cartTypeId.equals(String.valueOf(-100))) {
                        cartTypeIds.add(new ObjectId(cartTypeId));
                        continue;
                    }
                    if (!cartTypeId.equals(String.valueOf(-100))) continue;
                    isFearureCartTypeSelected = true;
                }
                List issueTypes = new ArrayList();
                if (isFearureCartTypeSelected) {
                    issueTypes = this.getIssueTypeOfBoardWhichIsArchive(activeSessionBoard.getTenant());
                    for (int i = 0; i < issueTypes.size(); ++i) {
                        HashMap tempCartType = (HashMap)issueTypes.get(i);
                        cartTypeIds.add(new ObjectId(String.valueOf(tempCartType.get("_id"))));
                    }
                }
                if (activeSessionBoard != null) {
                    rawItems = this.getPiReportItemsBySelectedCartTypes(activeSessionBoard, cartTypeIds, isFearureCartTypeSelected, activeSessionBoard.getTenant());
                }
                ArrayList<ObjectId> storyIdsOfCurrentState = new ArrayList<ObjectId>();
                for (int i = 0; i < rawItems.size(); ++i) {
                    DBObject rawItem = (DBObject)rawItems.get(i);
                    storyIdsOfCurrentState.add(new ObjectId(String.valueOf(rawItem.get("_id"))));
                }
                Object rawItemsStories = null;
                if (activeSessionBoard != null) {
                    rawItemsStories = this.getPiReportStoriesOfSelectedCartTypes(activeSessionBoard, storyIdsOfCurrentState);
                }
                for (int i = 0; i < rawItemsStories.size(); ++i) {
                    rawItems.add(rawItemsStories.get(i));
                }
            }
            if (rawItems == null) {
                rawItems = this.getPiReportItemsSorted(activeSessionBoard);
            }
            ArrayList<ObjectId> currentStateTeamContainersIds = new ArrayList<ObjectId>();
            HashMap<String, DBObject> currentStateItemsMapById = new HashMap<String, DBObject>();
            if (rawItems != null) {
                for (DBObject rawItem : rawItems) {
                    List TeamsContainer;
                    if (rawItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)rawItem.get("storyPoints"))) {
                        rawItem.put("storyPoints", (Object)0.0);
                    }
                    rawItem.put("_id", (Object)String.valueOf(rawItem.get("_id")));
                    rawItem.put("id", (Object)String.valueOf(rawItem.get("_id")));
                    currentStateItemsMapById.put(String.valueOf(rawItem.get("_id")), rawItem);
                    if (rawItem.get("teamContainers") == null || (TeamsContainer = (List)rawItem.get("teamContainers")).size() <= 0) continue;
                    List teamContRef = (List)rawItem.get("teamContainers");
                    for (int j = 0; j < teamContRef.size(); ++j) {
                        DBRef tcRef = (DBRef)teamContRef.get(j);
                        currentStateTeamContainersIds.add(new ObjectId(String.valueOf(tcRef.getId())));
                    }
                }
            }
            List currentStateTeamContainers = this.getTeamContainer(currentStateTeamContainersIds);
            HashMap<String, DBObject> currentStateTeamContainersMapById = new HashMap<String, DBObject>();
            for (int i = 0; i < currentStateTeamContainers.size(); ++i) {
                if (currentStateTeamContainers.size() <= i) continue;
                DBObject currentTeamContainer = (DBObject)currentStateTeamContainers.get(i);
                currentStateTeamContainersMapById.put(String.valueOf(currentTeamContainer.get("_id")), currentTeamContainer);
            }
            HashMap includedFeaturesMap = new HashMap();
            for (DBObject rawItem : rawItems) {
                try {
                    Boolean includeItemFlag;
                    DBRef statusRef = (DBRef)rawItem.get("status");
                    Status status = null;
                    if (PropertyValidator.isValid((Object)statusRef)) {
                        String statusId = String.valueOf(statusRef.getId());
                        status = (Status)statusMapById.get(statusId);
                    }
                    if (!PropertyValidator.isValid(status)) {
                        Status newStatus = new Status();
                        newStatus.setTitle("Misc");
                        newStatus.setCategory("Misc");
                        newStatus.setColor("#7c50b1");
                        status = newStatus;
                    }
                    if (!(includeItemFlag = this.checkExcludeItemsStatus(rawItem, status, (Map)statsExclusionData, includedFeaturesMap)).booleanValue()) continue;
                    itemsById.put(String.valueOf(rawItem.get("_id")), rawItem);
                    if (rawItem.containsField("originItemId")) {
                        itemsById.put(String.valueOf(rawItem.get("originItemId")), rawItem);
                    }
                    if (dataFlags.get("Dependencies") != null) {
                        this.storeItemsKendisAndJiraDependencies(rawItem, curentStateItemsLinks, curentStatejiraDependencies);
                    }
                    itemKey = this.getItemJirsOrTFSKey(rawItem);
                    if (rawItem.get("teamContainers") != null) {
                        List teamContainersRef = (List)rawItem.get("teamContainers");
                        if (rawItem.get("type").equals(Item.FEATURE) && teamContainersRef.size() == 0) {
                            ++unPlannedSum;
                            if (status != null) {
                                if (PropertyValidator.isValid((Object)status.getTitle())) {
                                    unplannedData.put("Status", status.getTitle());
                                } else {
                                    unplannedData.put("Status", "N/A");
                                }
                                unplannedData.put("Category", status.getCategory());
                            }
                        }
                        ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
                        HashMap checkDuplicateFeature = new HashMap();
                        for (int j = 0; j < teamContainersRef.size(); ++j) {
                            HashMap updateSprintTeamStory;
                            HashMap updateSprintStory;
                            DBRef parentId;
                            DBRef tcRef = (DBRef)teamContainersRef.get(j);
                            DBObject tcObject = (DBObject)currentStateTeamContainersMapById.get(String.valueOf(tcRef.getId()));
                            if (!PropertyValidator.isValid((Object)tcObject)) continue;
                            DBRef teamRef = (DBRef)tcObject.get("team");
                            DBRef containerRef = (DBRef)tcObject.get("container");
                            if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                            Team team2 = (Team)teamDetails.get(String.valueOf(teamRef.getId()));
                            Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                            if (container == null) continue;
                            tcs.add(new TeamContainer(team2, container));
                            rawItem.put("sprint_" + container.getId(), (Object)true);
                            currentStateItemsMapByTeamContainerIdsForDependencies.put(String.valueOf(tcObject.get("_id")), rawItem);
                            this.getItemTeamAndSprint(rawItem, team2, container, itemTeamAndSprintMapByItemId, mapForCheckingNoTeamAndSprintComesDouble, status);
                            boolean teamCheckForDublicateFeature = false;
                            boolean sprintCheckForDublicateFeature = false;
                            if (checkDuplicateFeature.get(String.valueOf(teamRef.getId())) != null && checkDuplicateFeature.get(String.valueOf(containerRef.getId())) != null) continue;
                            if (checkDuplicateFeature.get(String.valueOf(teamRef.getId())) == null) {
                                teamCheckForDublicateFeature = true;
                            }
                            if (checkDuplicateFeature.get(String.valueOf(containerRef.getId())) == null) {
                                sprintCheckForDublicateFeature = true;
                            }
                            if (rawItem.get("type").equals(Item.FEATURE)) {
                                HashMap<String, Object> featureDetailsByTeam = new HashMap<String, Object>();
                                featureDetailsByTeam.put("Details", rawItem.get("title"));
                                if (status != null) {
                                    if (PropertyValidator.isValid((Object)status.getTitle())) {
                                        featureDetailsByTeam.put("Status", status.getTitle());
                                    } else {
                                        featureDetailsByTeam.put("Status", "N/A");
                                    }
                                    featureDetailsByTeam.put("Category", status.getCategory());
                                } else {
                                    featureDetailsByTeam.put("Status", "-");
                                    featureDetailsByTeam.put("Category", "-");
                                }
                                if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                                    HashMap itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                                    if (itemTeamAndSprintMap.get("teams") != null) {
                                        featureDetailsByTeam.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                                    }
                                    if (itemTeamAndSprintMap.get("sprints") != null) {
                                        featureDetailsByTeam.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                                    }
                                }
                                featureDetailsByTeam.put("key", itemKey.get("key"));
                                if (rawItem.get("createdOn") != null) {
                                    featureDetailsByTeam.put("createdOn", rawItem.get("createdOn"));
                                }
                                featureDetailsByTeam.put("keyType", itemKey.get("keyType"));
                                featureDetailsByTeam.put("keyLink", itemKey.get("keyLink"));
                                if (PropertyValidator.isValid((Object)rawItem.get("backlogSequence"))) {
                                    featureDetailsByTeam.put("backlogSequence", rawItem.get("backlogSequence"));
                                }
                                if (PropertyValidator.isValid((Object)rawItem.get("sequence"))) {
                                    featureDetailsByTeam.put("sequence", rawItem.get("sequence"));
                                }
                                featureDetailsByTeam.put("id", String.valueOf(rawItem.get("_id")));
                                featureDetailsByTeam.put("id", String.valueOf(rawItem.get("_id")));
                                featureDetailsByTeam.put("tfsId", rawItem.get("tfsId"));
                                featureDetailsByTeam.put("tfsURL", rawItem.get("tfsURL"));
                                featureDetailsByTeam.put("tfsApiURL", rawItem.get("tfsApiURL"));
                                featureDetailsByTeam.put("tfsProjectId", rawItem.get("tfsProjectId"));
                                featureDetailsByTeam.put("tfsProject", rawItem.get("tfsProject"));
                                featureDetailsByTeam.put("tfsItemType", rawItem.get("tfsItemType"));
                                featureDetailsByTeam.put("tfsItemTypeIcon", rawItem.get("tfsItemTypeIcon"));
                                featureDetailsByTeam.put("tfsFilter", rawItem.get("tfsFilter"));
                                featureDetailsByTeam.put("tfsAreaPath", rawItem.get("tfsAreaPath"));
                                featureDetailsByTeam.put("tfsIterationPath", rawItem.get("tfsIterationPath"));
                                featureDetailsByTeam.put("jiraKey", rawItem.get("jiraKey"));
                                featureDetailsByTeam.put("jiraId", rawItem.get("jiraId"));
                                featureDetailsByTeam.put("jiraFilter", rawItem.get("jiraFilter"));
                                featureDetailsByTeam.put("jiraProjectKey", rawItem.get("jiraProjectKey"));
                                featureDetailsByTeam.put("jiraIssueTypeId", rawItem.get("jiraIssueTypeId"));
                                HashMap<String, Serializable> featureDetailsBySprint = new HashMap<String, Serializable>(featureDetailsByTeam);
                                if (teamCheckForDublicateFeature) {
                                    if (dataFlags.get("allTeamProgressGraph") != null) {
                                        HashMap<String, Object> dataMapForTeamCalculations = new HashMap<String, Object>();
                                        dataMapForTeamCalculations.put("checkDuplicateFeature", checkDuplicateFeature);
                                        dataMapForTeamCalculations.put("rawItem", rawItem);
                                        dataMapForTeamCalculations.put("status", status);
                                        dataMapForTeamCalculations.put("teamRef", teamRef);
                                        dataMapForTeamCalculations.put("teamDetailsById", teamDetailsById);
                                        dataMapForTeamCalculations.put("teamDetails", teamDetails);
                                        dataMapForTeamCalculations.put("boardCapacity", boardCapacity);
                                        dataMapForTeamCalculations.put("featureDetailsByTeam", new HashMap(featureDetailsByTeam));
                                        dataMapForTeamCalculations.put("containerMapById", containerMapById);
                                        this.boardTeamCalculations(dataMapForTeamCalculations);
                                    }
                                    if (dataFlags.get("teamFeatureDoneByStories") != null && teamRef != null && teamRef.getId() != null && PropertyValidator.isValid((Object)rawItem.get("_id"))) {
                                        featureDetailsByTeam.put("featureStories", new ArrayList());
                                        HashMap putTeamDoneFeature = (HashMap)teamDoneByFeatures.get(String.valueOf(teamRef.getId()));
                                        putTeamDoneFeature.put(String.valueOf(rawItem.get("_id")), new HashMap(featureDetailsByTeam));
                                    }
                                }
                                if (dataFlags.get("sprintByTeamView") == null) continue;
                                HashMap<String, Object> dataMapForSprintCalculations = new HashMap<String, Object>();
                                featureDetailsBySprint.put("accordItemFlag", Boolean.valueOf(true));
                                featureDetailsBySprint.put("featureStories", new ArrayList());
                                dataMapForSprintCalculations.put("checkDuplicateFeature", checkDuplicateFeature);
                                dataMapForSprintCalculations.put("containerRef", containerRef);
                                dataMapForSprintCalculations.put("boardCapacity", boardCapacity);
                                dataMapForSprintCalculations.put("sprintDetailsMapByIds", sprintDetailsMapByIds);
                                dataMapForSprintCalculations.put("containerMapById", containerMapById);
                                dataMapForSprintCalculations.put("rawItem", rawItem);
                                dataMapForSprintCalculations.put("status", status);
                                dataMapForSprintCalculations.put("featureDetailsByTeam", featureDetailsBySprint);
                                dataMapForSprintCalculations.put("sprintDetailsByTeamsMapBySprintIds", sprintDetailsByTeamsMapBySprintIds);
                                dataMapForSprintCalculations.put("teamRef", teamRef);
                                dataMapForSprintCalculations.put("teamDetails", teamDetails);
                                this.boardSprintCalculations(dataMapForSprintCalculations);
                                continue;
                            }
                            if (!rawItem.get("type").equals(Item.USER_STORY)) continue;
                            HashMap storySprint = new HashMap();
                            HashMap storyTeam = new HashMap();
                            HashMap<String, Object> stories = new HashMap<String, Object>();
                            stories.put("Details", rawItem.get("title"));
                            if (status != null) {
                                if (PropertyValidator.isValid((Object)status.getTitle())) {
                                    stories.put("Status", status.getTitle());
                                } else {
                                    stories.put("Status", "N/A");
                                }
                                stories.put("Category", status.getCategory());
                            }
                            if (PropertyValidator.isValid((Object)(parentId = (DBRef)rawItem.get("parent"))) && PropertyValidator.isValid((Object)parentId.getId()) && currentStateItemsMapById.get(String.valueOf(parentId.getId())) != null) {
                                DBObject parentItem = (DBObject)currentStateItemsMapById.get(String.valueOf(parentId.getId()));
                                HashMap itemkey = this.getItemJirsOrTFSKey(parentItem);
                                stories.put("parentkey", itemkey.get("key"));
                                stories.put("parentkeyType", itemkey.get("keyType"));
                                stories.put("parentkeyLink", itemkey.get("keyLink"));
                                stories.put("parentDetails", parentItem.get("title"));
                                stories.put("parentTfsId", parentItem.get("tfsId"));
                                stories.put("parentTfsURL", parentItem.get("tfsURL"));
                                stories.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                                stories.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                                stories.put("parentTfsProject", parentItem.get("tfsProject"));
                                stories.put("parentTfsItemType", parentItem.get("tfsItemType"));
                                stories.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                                stories.put("parentTfsFilter", parentItem.get("tfsFilter"));
                                stories.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                                stories.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                                stories.put("parentJiraKey", parentItem.get("jiraKey"));
                                stories.put("parentJiraId", parentItem.get("jiraId"));
                                stories.put("parentJiraFilter", parentItem.get("jiraFilter"));
                                stories.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                                stories.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                            }
                            if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                                HashMap itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                                if (itemTeamAndSprintMap.get("teams") != null) {
                                    stories.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                                    storyTeam = (HashMap)itemTeamAndSprintMap.get("teams");
                                    storyTeam = (HashMap)storyTeam.get(team2.getId());
                                }
                                if (itemTeamAndSprintMap.get("sprints") != null) {
                                    stories.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                                    storySprint = (HashMap)itemTeamAndSprintMap.get("sprints");
                                    if (PropertyValidator.isValid((Object)currentSprint)) {
                                        storySprint = (HashMap)storySprint.get(currentSprint.getId());
                                    }
                                }
                            }
                            stories.put("Estimate", rawItem.get("storyPoints"));
                            stories.put("key", itemKey.get("key"));
                            stories.put("keyType", itemKey.get("keyType"));
                            stories.put("keyLink", itemKey.get("keyLink"));
                            stories.put("id", String.valueOf(rawItem.get("_id")));
                            stories.put("tfsId", rawItem.get("tfsId"));
                            stories.put("tfsURL", rawItem.get("tfsURL"));
                            stories.put("tfsApiURL", rawItem.get("tfsApiURL"));
                            stories.put("tfsProjectId", rawItem.get("tfsProjectId"));
                            stories.put("tfsProject", rawItem.get("tfsProject"));
                            stories.put("tfsItemType", rawItem.get("tfsItemType"));
                            stories.put("tfsItemTypeIcon", rawItem.get("tfsItemTypeIcon"));
                            stories.put("tfsFilter", rawItem.get("tfsFilter"));
                            stories.put("tfsAreaPath", rawItem.get("tfsAreaPath"));
                            stories.put("tfsIterationPath", rawItem.get("tfsIterationPath"));
                            stories.put("jiraKey", rawItem.get("jiraKey"));
                            stories.put("jiraId", rawItem.get("jiraId"));
                            stories.put("jiraFilter", rawItem.get("jiraFilter"));
                            stories.put("jiraProjectKey", rawItem.get("jiraProjectKey"));
                            stories.put("jiraIssueTypeId", rawItem.get("jiraIssueTypeId"));
                            if (rawItem.get("createdOn") != null) {
                                stories.put("createdOn", rawItem.get("createdOn"));
                                Date createdDate = (Date)rawItem.get("createdOn");
                                if (PropertyValidator.isValid((Object)currentSprint) && currentSprint.getStartDate() != null && (createdDate.after(currentSprint.getStartDate()) || createdDate.after(currentSprint.getStartDate())) && storySprint != null && storyTeam != null) {
                                    storiesCreatedAfterActiveSprint.add((String)stories.get("id"));
                                }
                            }
                            if (teamCheckForDublicateFeature) {
                                storyDetails.add(rawItem);
                                if (dataFlags.get("allTeamProgressGraph") != null || dataFlags.get("sprintByTeamView") != null) {
                                    HashMap<String, Cloneable> dataMapForTeamAndSprintCalculationsForStories = new HashMap<String, Cloneable>();
                                    dataMapForTeamAndSprintCalculationsForStories.put("teamContainersMap", teamContainersMap);
                                    dataMapForTeamAndSprintCalculationsForStories.put("sprintContainersMap", sprintContainersMap);
                                    dataMapForTeamAndSprintCalculationsForStories.put("tcObject", (Cloneable)tcObject);
                                    dataMapForTeamAndSprintCalculationsForStories.put("rawItem", (Cloneable)rawItem);
                                    dataMapForTeamAndSprintCalculationsForStories.put("teamRef", (Cloneable)teamRef);
                                    dataMapForTeamAndSprintCalculationsForStories.put("status", (Cloneable)status);
                                    dataMapForTeamAndSprintCalculationsForStories.put("teamDetailBySprint", teamDetailBySprint);
                                    dataMapForTeamAndSprintCalculationsForStories.put("teamDetailsById", teamDetailsById);
                                    dataMapForTeamAndSprintCalculationsForStories.put("containerRef", (Cloneable)containerRef);
                                    dataMapForTeamAndSprintCalculationsForStories.put("teamDetails", teamDetails);
                                    dataMapForTeamAndSprintCalculationsForStories.put("stories", stories);
                                    dataMapForTeamAndSprintCalculationsForStories.put("storiesCreatedAfterActiveSprint", storiesCreatedAfterActiveSprint);
                                    this.boardTeamAndSprintCalculationsForStories(dataMapForTeamAndSprintCalculationsForStories);
                                    storiesCreatedAfterActiveSprint = new ArrayList();
                                }
                            }
                            if (dataFlags.get("sprintByTeamView") == null) continue;
                            if (sprintCheckForDublicateFeature && (updateSprintStory = (HashMap)sprintDetailsMapByIds.get(String.valueOf(containerRef.getId()))) != null) {
                                ArrayList teamStories = (ArrayList)updateSprintStory.get("storyDetails");
                                teamStories.add(stories);
                                this.calculationForTeamAndSprint(status, rawItem, updateSprintStory);
                            }
                            if ((updateSprintTeamStory = (HashMap)sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(containerRef.getId()))) == null) continue;
                            HashMap teamDetailsInThatSprint = (HashMap)updateSprintTeamStory.get("teamDataInTheSprint");
                            if (teamDetailsInThatSprint != null && teamDetailsInThatSprint.get(String.valueOf(team2.getId())) == null) {
                                HashMap temperoryteamDetails = new HashMap();
                                temperoryteamDetails.put("teamName", teamNameMapById.get(String.valueOf(teamRef.getId())));
                                temperoryteamDetails.put("teamId", String.valueOf(team2.getId()));
                                temperoryteamDetails.put("teamColor", team2.getColor());
                                teamDetailsInThatSprint.put(String.valueOf(team2.getId()), temperoryteamDetails);
                            }
                            HashMap teamFeaturesInThatSprint = (HashMap)teamDetailsInThatSprint.get(String.valueOf(team2.getId()));
                            this.calculationForTeamAndSprint(status, rawItem, teamFeaturesInThatSprint);
                        }
                        rawItem.put("_teamContainers", tcs);
                        continue;
                    }
                    if (!rawItem.get("type").equals(Item.FEATURE)) continue;
                    ++unPlannedSum;
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (dataFlags.containsKey("baseLineData") || dataFlags.containsKey("spillOver")) {
                HashMap responseDataSpillOverAndBaseLine = this.spillOverAndBaseLineCalculations(dataFlags, boardCapacity, activeSessionBoard, containerMapById, teamDetails, itemsById);
                if (dataFlags.get("baseLineData") != null) {
                    response.put("baseLineData", responseDataSpillOverAndBaseLine.get("baseLineData"));
                    response.put("baseLineDataSpillOver", responseDataSpillOverAndBaseLine.get("baseLineDataSpillOver"));
                }
                if (dataFlags.get("spillOver") != null) {
                    response.put("spillOverResponce", responseDataSpillOverAndBaseLine.get("spillOverResponce"));
                }
            }
            if (dataFlags.get("teamFeatureDoneByStories") != null || dataFlags.get("sprintByTeamView") != null) {
                HashMap<String, Cloneable> dataMapForFeatureDoneByStoriesCalculations = new HashMap<String, Cloneable>();
                dataMapForFeatureDoneByStoriesCalculations.put("storyDetails", storyDetails);
                dataMapForFeatureDoneByStoriesCalculations.put("teamContainersMap", teamContainersMap);
                dataMapForFeatureDoneByStoriesCalculations.put("teamDoneByFeatures", teamDoneByFeatures);
                dataMapForFeatureDoneByStoriesCalculations.put("statusMapById", statusMapById);
                dataMapForFeatureDoneByStoriesCalculations.put("itemTeamAndSprintMapByItemId", itemTeamAndSprintMapByItemId);
                dataMapForFeatureDoneByStoriesCalculations.put("sprintDetailsMapByIds", sprintDetailsMapByIds);
                dataMapForFeatureDoneByStoriesCalculations.put("sprintContainersMap", sprintContainersMap);
                dataMapForFeatureDoneByStoriesCalculations.put("dataFlags", dataFlags);
                this.featureDoneByStoriesForTeamCalculationForSories(dataMapForFeatureDoneByStoriesCalculations);
            }
            if (dataFlags.get("sprintByTeamView") != null || dataFlags.get("allTeamProgressGraph") != null) {
                HashMap<String, Object> dataMapForTeamAndSprintCalculationsWhichContainsNoItem = new HashMap<String, Object>();
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("teamDetailsById", teamDetailsById);
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("boardCapacity", boardCapacity);
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("activeSessionTeams", activeSessionTeams);
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("teamDetailBySprint", teamDetailBySprint);
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("activeSessionContainers", activeSessionContainers);
                dataMapForTeamAndSprintCalculationsWhichContainsNoItem.put("containerMapById", containerMapById);
                this.boardTeamAndSprintCalculationsWhichContainsNoItem(dataMapForTeamAndSprintCalculationsWhichContainsNoItem);
            }
            if (dataFlags.get("featureDeliveryInActiveSprint") != null) {
                response.put("featureAndStoriesStatsInActiveSprint", this.countFeatureDeliveryInCurrentSprint(activeSessionBoard, teamDetailsById, currentSprint));
            }
            if (dataFlags.get("sprintDependencies") != null) {
                response.put("sprintDependencies", this.getTeamOrBoardDependencies(activeSessionBoard, curentStateItemsLinks, curentStatejiraDependencies, "sprintDependencies", itemsById, currentStateItemsMapByTeamContainerIdsForDependencies));
            }
            if (dataFlags.get("unPlannedSum") != null) {
                response.put("unPlannedSum", unPlannedSum);
            }
            if (dataFlags.get("sprintByTeamView") != null) {
                this.calculationForNoFeatureSprint(sprintDetailsMapByIds, sprintDetailsByTeamsMapBySprintIds, activeSessionContainers, activeSessionTeams, boardCapacity);
                response.put("ContainerNames", containerNameMapById);
                response.put("sprintDetailsMapByIds", sprintDetailsMapByIds);
                response.put("sprintDetails", teamDetailBySprint);
                response.put("sprintDetailsByTeamsMapBySprintIds", sprintDetailsByTeamsMapBySprintIds);
            }
            if (dataFlags.get("teamFeatureDoneByStories") != null) {
                response.put("teamDoneByFeatures", teamDoneByFeatures);
            }
            if (dataFlags.get("allTeamProgressGraph") != null) {
                response.put("teamDetails", teamDetails);
                response.put("teamDetailsById", teamDetailsById);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    private HashMap<String, Object> spillOverAndBaseLineCalculations(HashMap<String, Object> dataFlags, List<DBObject> boardCapacity, SessionBoard activeSessionBoard, HashMap<String, Container> containerMapById, HashMap<String, Team> teamDetails, HashMap<String, DBObject> itemsById) {
        ArrayList<ObjectId> lastBaseLinerAuditLogIds = new ArrayList<ObjectId>();
        ArrayList<String> lastBaseLinerAuditLogIdsStr = new ArrayList<String>();
        HashMap<String, String> auditLogIdForSpillData = new HashMap<String, String>();
        HashMap<String, DBObject> capacityMap = new HashMap<String, DBObject>();
        for (DBObject capacity : boardCapacity) {
            String lastBaseLineAuditLogId = null;
            if (capacity.get("lastBaseLineAuditLogId") != null) {
                lastBaseLineAuditLogId = String.valueOf(capacity.get("lastBaseLineAuditLogId"));
                lastBaseLinerAuditLogIdsStr.add(lastBaseLineAuditLogId);
                lastBaseLinerAuditLogIds.add(new ObjectId(lastBaseLineAuditLogId));
                capacityMap.put(lastBaseLineAuditLogId, capacity);
            }
            if (capacity.get("lastSpillOverAuditLogId") == null) continue;
            auditLogIdForSpillData.put(lastBaseLineAuditLogId, "sprint_" + String.valueOf(capacity.get("sprintId")));
            auditLogIdForSpillData.put("tsvSprintId_" + lastBaseLineAuditLogId, String.valueOf(capacity.get("sprintId")));
            auditLogIdForSpillData.put("tsvTeamId_" + lastBaseLineAuditLogId, String.valueOf(capacity.get("teamId")));
        }
        List auditLogsWithSpillOver = this.getAuditLogData(lastBaseLinerAuditLogIds, lastBaseLinerAuditLogIdsStr);
        List baseLineAuditData = this.filterAuditLogDataExceptEventType(auditLogsWithSpillOver, "ITEM_ADD");
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (dataFlags.get("baseLineData") != null || dataFlags.get("commitedLoad") != null) {
            response.put("baseLineData", this.filterBaseLineData(baseLineAuditData, activeSessionBoard, containerMapById, teamDetails, capacityMap));
            response.put("baseLineDataSpillOver", this.filterBaseLineData(auditLogsWithSpillOver, activeSessionBoard, containerMapById, teamDetails, capacityMap));
        }
        if (dataFlags.get("spillOver") != null) {
            response.put("spillOverResponce", this.filterSpillOverFromBaseLineData(auditLogsWithSpillOver, containerMapById, teamDetails, itemsById, auditLogIdForSpillData));
        }
        return response;
    }

    private List<DBObject> filterAuditLogDataExceptEventType(List<DBObject> auditLogs, String eventType) {
        if (!PropertyValidator.isValid(auditLogs)) {
            return new ArrayList<DBObject>();
        }
        if (!PropertyValidator.isValid((Object)eventType)) {
            return auditLogs;
        }
        ArrayList<DBObject> filteredAuditLogs = new ArrayList<DBObject>();
        for (DBObject auditLog : auditLogs) {
            if (eventType.equals(auditLog.get("eventType"))) continue;
            filteredAuditLogs.add(auditLog);
        }
        return filteredAuditLogs;
    }

    private HashMap<String, Object> countFeatureDeliveryInCurrentSprint(SessionBoard activeSessionBoard, HashMap<String, Object> teamDetailsById, Container currentSprint) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, AbstractCollection> teamLevelFeatureDeliveryCount = new HashMap<String, AbstractCollection>();
        int featuresDoneForWholeSprints = 0;
        try {
            HashMap<String, Integer> sortedConatinersIndexMap = new HashMap<String, Integer>();
            HashMap<String, Integer> storiesNotCompletedYet = new HashMap<String, Integer>();
            ArrayList<String> featuresDeliveryInLastSprint = new ArrayList<String>();
            ArrayList<String> programFeaturesDeliveryInLastSprint = new ArrayList<String>();
            ArrayList<String> storyOpenFromPreviouSprint = new ArrayList<String>();
            ArrayList<String> programLevelFeatureDelivery = new ArrayList<String>();
            HashMap<String, String> tempProgramLevelFeatureDelivery = new HashMap<String, String>();
            int tempOpenStoryPreviousSprint = 0;
            List activeSessionContainers = activeSessionBoard.getContainers();
            Collections.sort(activeSessionContainers, new /* Unavailable Anonymous Inner Class!! */);
            for (int i = 0; i < activeSessionBoard.getContainers().size(); ++i) {
                sortedConatinersIndexMap.put(((Container)activeSessionBoard.getContainers().get(i)).getId(), i);
            }
            HashSet programeFeatureList = new HashSet();
            teamLevelFeatureDeliveryCount.put("allTeam", programeFeatureList);
            for (Team selectedTeam : activeSessionBoard.getTeams()) {
                ArrayList<String> tempFeatureList = new ArrayList<String>();
                HashMap teamData = (HashMap)teamDetailsById.get(selectedTeam.getId());
                if (teamData == null) continue;
                HashMap selectedTeamFeature = (HashMap)teamData.get("featureDetails");
                ArrayList selectedTeamStories = (ArrayList)teamData.get("storyDetails");
                if (PropertyValidator.isValid((Object)selectedTeamFeature)) {
                    for (String key : selectedTeamFeature.keySet()) {
                        HashMap feature = new HashMap();
                        feature = (HashMap)selectedTeamFeature.get(key);
                        String featureCategory = (String)feature.get("Category");
                        HashMap itemTeamData = (HashMap)feature.get("itemTeamData");
                        HashMap itemTeamDataBySprint = (HashMap)(itemTeamData = (HashMap)itemTeamData.get(selectedTeam.getId())).get("featureSprintOfTheTeam");
                        if (PropertyValidator.isValid((Object)itemTeamDataBySprint) && PropertyValidator.isValid((Object)currentSprint) && PropertyValidator.isValid((Object)currentSprint.getId())) {
                            int max = -1;
                            for (String sprintKey : itemTeamDataBySprint.keySet()) {
                                int containerIndex = (Integer)sortedConatinersIndexMap.get(sprintKey);
                                if (containerIndex <= max) continue;
                                max = containerIndex;
                            }
                            if (max == (Integer)sortedConatinersIndexMap.get(currentSprint.getId())) {
                                tempFeatureList.add(key);
                            }
                            if (max == (Integer)sortedConatinersIndexMap.get(currentSprint.getId()) - 1 && (EnumStatusCategory.OPEN.getCode().equals(featureCategory) || EnumStatusCategory.INPROGRESS.getCode().equals(featureCategory))) {
                                featuresDeliveryInLastSprint.add(key);
                            }
                        }
                        HashMap itemSprintData = (HashMap)feature.get("itemSprintData");
                        if (tempProgramLevelFeatureDelivery.get(key) != null || !PropertyValidator.isValid((Object)itemSprintData) || !PropertyValidator.isValid((Object)currentSprint) || !PropertyValidator.isValid((Object)currentSprint.getId())) continue;
                        int max = -1;
                        for (String sprintId : itemSprintData.keySet()) {
                            int containerIndex = (Integer)sortedConatinersIndexMap.get(sprintId);
                            if (containerIndex <= max) continue;
                            max = containerIndex;
                        }
                        tempProgramLevelFeatureDelivery.put(key, key);
                        if (max == (Integer)sortedConatinersIndexMap.get(currentSprint.getId())) {
                            programLevelFeatureDelivery.add(key);
                        }
                        if (max != (Integer)sortedConatinersIndexMap.get(currentSprint.getId()) - 1 || !EnumStatusCategory.OPEN.getCode().equals(featureCategory) && !EnumStatusCategory.INPROGRESS.getCode().equals(featureCategory)) continue;
                        programFeaturesDeliveryInLastSprint.add(key);
                    }
                }
                teamLevelFeatureDeliveryCount.put(selectedTeam.getId(), tempFeatureList);
                if (!PropertyValidator.isValid((Collection)selectedTeamStories) || !PropertyValidator.isValid((Object)currentSprint) || !PropertyValidator.isValid((Object)currentSprint.getId())) continue;
                for (HashMap story : selectedTeamStories) {
                    HashMap storySprintData = (HashMap)story.get("itemSprintData");
                    for (String key : storySprintData.keySet()) {
                        if ((Integer)sortedConatinersIndexMap.get(key) >= (Integer)sortedConatinersIndexMap.get(currentSprint.getId()) || !EnumStatusCategory.OPEN.getCode().equals(story.get("Category")) && !EnumStatusCategory.INPROGRESS.getCode().equals(story.get("Category"))) continue;
                        storyOpenFromPreviouSprint.add((String)story.get("id"));
                        ++tempOpenStoryPreviousSprint;
                    }
                }
                storiesNotCompletedYet.put(selectedTeam.getId(), tempOpenStoryPreviousSprint);
                tempOpenStoryPreviousSprint = 0;
            }
            response.put("featuresDoneForWholeSprints", featuresDoneForWholeSprints);
            response.put("teamLevelFeatureDeliveryCount", teamLevelFeatureDeliveryCount);
            response.put("storiesOpenFromPreviousSprints", storyOpenFromPreviouSprint);
            response.put("openFeaturesDeliveryInLastSprint", featuresDeliveryInLastSprint);
            response.put("storiesMissedPreviousDeliverySprint", storiesNotCompletedYet);
            response.put("programFeaturesDeliveryInLastSprint", programFeaturesDeliveryInLastSprint);
            response.put("programLevelFeatureDelivery", programLevelFeatureDelivery);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        response.put("featuresDoneForWholeSprints", featuresDoneForWholeSprints);
        response.put("teamLevelFeatureDeliveryCount", teamLevelFeatureDeliveryCount);
        return response;
    }

    private void featureDoneByStoriesForTeamCalculationForSories(HashMap<String, Object> dataMapForFeatureDoneByStoriesCalculations) {
        try {
            ArrayList storyDetails = (ArrayList)dataMapForFeatureDoneByStoriesCalculations.get("storyDetails");
            HashMap teamContainersMap = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("teamContainersMap");
            HashMap teamDoneByFeatures = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("teamDoneByFeatures");
            HashMap statusMapById = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("statusMapById");
            HashMap itemTeamAndSprintMapByItemId = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("itemTeamAndSprintMapByItemId");
            HashMap sprintDetailsMapByIds = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("sprintDetailsMapByIds");
            HashMap sprintContainersMap = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("sprintContainersMap");
            HashMap dataFlags = (HashMap)dataMapForFeatureDoneByStoriesCalculations.get("dataFlags");
            for (DBObject story : storyDetails) {
                HashMap getFeatureDetails;
                HashMap putSprintStoryStauts;
                String getContainer;
                HashMap putSprintFeature;
                DBRef statusRef = (DBRef)story.get("status");
                Status status = null;
                if (PropertyValidator.isValid((Object)statusRef)) {
                    String statusId = String.valueOf(statusRef.getId());
                    status = (Status)statusMapById.get(statusId);
                }
                if (!PropertyValidator.isValid(status)) {
                    Status newStatus = new Status();
                    newStatus.setTitle("Misc");
                    newStatus.setCategory("Misc");
                    newStatus.setColor("#7c50b1");
                    status = newStatus;
                }
                HashMap<String, Object> stories = new HashMap<String, Object>();
                if (itemTeamAndSprintMapByItemId.get(String.valueOf(story.get("_id"))) != null) {
                    HashMap itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(story.get("_id")));
                    if (itemTeamAndSprintMap.get("teams") != null) {
                        stories.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                    }
                    if (itemTeamAndSprintMap.get("sprints") != null) {
                        stories.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                    }
                }
                stories.put("Details", story.get("title"));
                if (status != null) {
                    if (PropertyValidator.isValid((Object)status.getTitle())) {
                        stories.put("Status", status.getTitle());
                    } else {
                        stories.put("Status", "N/A");
                    }
                    stories.put("Category", status.getCategory());
                }
                stories.put("Estimate", story.get("storyPoints"));
                stories.put("id", String.valueOf(story.get("_id")));
                if (story.get("createdOn") != null) {
                    stories.put("createdOn", story.get("createdOn"));
                }
                String featureKey = null;
                String featureKeyLink = null;
                if (story.get("jiraId") != null) {
                    featureKey = (String)story.get("jiraKey");
                    stories.put("keyType", "jiraKey");
                } else if (story.get("tfsId") != null) {
                    featureKey = (String)story.get("tfsId");
                    featureKeyLink = (String)story.get("tfsURL");
                    stories.put("keyType", "tfsId");
                } else if (story.get("kendisKey") != null) {
                    featureKey = (String)story.get("kendisKey");
                    featureKeyLink = (String)story.get("externalReferenceURL");
                    stories.put("keyType", "kendisKey");
                } else if (story.get("jiraKey") != null) {
                    featureKey = (String)story.get("jiraKey");
                    featureKeyLink = (String)story.get("externalReferenceURL");
                    stories.put("keyType", "kendisKey");
                }
                stories.put("key", featureKey);
                stories.put("keyLink", featureKeyLink);
                if (PropertyValidator.isValid((Object)story.get("backlogSequence"))) {
                    stories.put("backlogSequence", story.get("backlogSequence"));
                }
                if (PropertyValidator.isValid((Object)story.get("sequence"))) {
                    stories.put("sequence", story.get("sequence"));
                }
                stories.put("tfsId", story.get("tfsId"));
                stories.put("tfsURL", story.get("tfsURL"));
                stories.put("tfsApiURL", story.get("tfsApiURL"));
                stories.put("tfsProjectId", story.get("tfsProjectId"));
                stories.put("tfsProject", story.get("tfsProject"));
                stories.put("tfsItemType", story.get("tfsItemType"));
                stories.put("tfsItemTypeIcon", story.get("tfsItemTypeIcon"));
                stories.put("tfsFilter", story.get("tfsFilter"));
                stories.put("tfsAreaPath", story.get("tfsAreaPath"));
                stories.put("tfsIterationPath", story.get("tfsIterationPath"));
                stories.put("jiraKey", story.get("jiraKey"));
                stories.put("jiraId", story.get("jiraId"));
                stories.put("jiraFilter", story.get("jiraFilter"));
                stories.put("jiraProjectKey", story.get("jiraProjectKey"));
                stories.put("jiraIssueTypeId", story.get("jiraIssueTypeId"));
                List teamContainersRef = (List)story.get("teamContainers");
                DBRef parentId = (DBRef)story.get("parent");
                if (dataFlags.get("teamFeatureDoneByStories") != null && PropertyValidator.isValid((Object)((DBRef)teamContainersRef.get(0)).getId())) {
                    String getTeam = (String)teamContainersMap.get(String.valueOf(((DBRef)teamContainersRef.get(0)).getId()));
                    if (dataFlags.get("teamFeatureDoneByStories") != null) {
                        HashMap putTeamDoneFeature = (HashMap)teamDoneByFeatures.get(String.valueOf(getTeam));
                        HashMap putStoryStauts = null;
                        if (putTeamDoneFeature != null && parentId != null && PropertyValidator.isValid((Object)parentId.getId())) {
                            putStoryStauts = (HashMap)putTeamDoneFeature.get(String.valueOf(parentId.getId()));
                        }
                        if (putStoryStauts != null) {
                            if (putStoryStauts.get("totalStories") == null) {
                                putStoryStauts.put("totalStories", 0);
                                putStoryStauts.put("doneStories", 0);
                                putStoryStauts.put("totalStoryPoints", 0);
                                putStoryStauts.put("doneStoryPoints", 0);
                            }
                            putStoryStauts.put("totalStories", (Integer)putStoryStauts.get("totalStories") + 1);
                            if (story.get("storyPoints") == null) {
                                putStoryStauts.put("totalStoryPoints", Double.valueOf(String.valueOf(putStoryStauts.get("totalStoryPoints"))) + 0.0);
                            } else {
                                putStoryStauts.put("totalStoryPoints", Double.valueOf(String.valueOf(putStoryStauts.get("totalStoryPoints"))) + Double.valueOf(String.valueOf(story.get("storyPoints"))));
                            }
                            if (status != null && status.getCategory().equalsIgnoreCase("Done")) {
                                putStoryStauts.put("doneStories", (Integer)putStoryStauts.get("doneStories") + 1);
                                if (story.get("storyPoints") == null) {
                                    putStoryStauts.put("doneStoryPoints", Double.valueOf(String.valueOf(putStoryStauts.get("doneStoryPoints"))) + 0.0);
                                } else {
                                    putStoryStauts.put("doneStoryPoints", Double.valueOf(String.valueOf(putStoryStauts.get("doneStoryPoints"))) + Double.valueOf(String.valueOf(story.get("storyPoints"))));
                                }
                            }
                            ArrayList teamFeatureStories = (ArrayList)putStoryStauts.get("featureStories");
                            teamFeatureStories.add(stories);
                        }
                    }
                }
                if (!PropertyValidator.isValid((Object)((DBRef)teamContainersRef.get(0)).getId()) || !PropertyValidator.isValid((Object)parentId) || !PropertyValidator.isValid((Object)parentId.getId()) || (putSprintFeature = (HashMap)sprintDetailsMapByIds.get(String.valueOf(getContainer = (String)sprintContainersMap.get(String.valueOf(((DBRef)teamContainersRef.get(0)).getId()))))) == null || (putSprintStoryStauts = (HashMap)(getFeatureDetails = (HashMap)putSprintFeature.get("featureDetails")).get(String.valueOf(parentId.getId()))) == null) continue;
                if (putSprintStoryStauts.get("totalStories") == null) {
                    putSprintStoryStauts.put("totalStories", 0);
                    putSprintStoryStauts.put("doneStories", 0);
                    putSprintStoryStauts.put("totalStoryPoints", 0);
                    putSprintStoryStauts.put("doneStoryPoints", 0);
                }
                putSprintStoryStauts.put("totalStories", (Integer)putSprintStoryStauts.get("totalStories") + 1);
                if (story.get("storyPoints") == null) {
                    putSprintStoryStauts.put("totalStoryPoints", Double.valueOf(String.valueOf(putSprintStoryStauts.get("totalStoryPoints"))) + 0.0);
                } else {
                    putSprintStoryStauts.put("totalStoryPoints", Double.valueOf(String.valueOf(putSprintStoryStauts.get("totalStoryPoints"))) + Double.valueOf(String.valueOf(story.get("storyPoints"))));
                }
                if (status != null && status.getCategory().equalsIgnoreCase("Done")) {
                    putSprintStoryStauts.put("doneStories", (Integer)putSprintStoryStauts.get("doneStories") + 1);
                    if (story.get("storyPoints") == null) {
                        putSprintStoryStauts.put("doneStoryPoints", Double.valueOf(String.valueOf(putSprintStoryStauts.get("doneStoryPoints"))) + 0.0);
                    } else {
                        putSprintStoryStauts.put("doneStoryPoints", Double.valueOf(String.valueOf(putSprintStoryStauts.get("doneStoryPoints"))) + Double.valueOf(String.valueOf(story.get("storyPoints"))));
                    }
                }
                ArrayList sprintFeatureStories = (ArrayList)putSprintStoryStauts.get("featureStories");
                sprintFeatureStories.add(stories);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void boardSprintCalculations(HashMap<String, Object> dataMapForTeamCalculations) {
        try {
            HashMap checkDuplicateFeature = (HashMap)dataMapForTeamCalculations.get("checkDuplicateFeature");
            DBRef containerRef = (DBRef)dataMapForTeamCalculations.get("containerRef");
            List boardCapacity = (List)dataMapForTeamCalculations.get("boardCapacity");
            HashMap sprintDetailsMapByIds = (HashMap)dataMapForTeamCalculations.get("sprintDetailsMapByIds");
            HashMap containerMapById = (HashMap)dataMapForTeamCalculations.get("containerMapById");
            DBObject rawItem = (DBObject)dataMapForTeamCalculations.get("rawItem");
            Status status = (Status)dataMapForTeamCalculations.get("status");
            HashMap featureDetailsByTeam = (HashMap)dataMapForTeamCalculations.get("featureDetailsByTeam");
            HashMap sprintDetailsByTeamsMapBySprintIds = (HashMap)dataMapForTeamCalculations.get("sprintDetailsByTeamsMapBySprintIds");
            DBRef teamRef = (DBRef)dataMapForTeamCalculations.get("teamRef");
            HashMap teamDetails = (HashMap)dataMapForTeamCalculations.get("teamDetails");
            if (containerRef != null && containerRef.getId() != null && teamRef != null && teamRef.getId() != null) {
                Container getContainer;
                if (checkDuplicateFeature.get(String.valueOf(containerRef.getId())) == null) {
                    checkDuplicateFeature.put(String.valueOf(containerRef.getId()), String.valueOf(containerRef.getId()));
                    if (sprintDetailsMapByIds.get(String.valueOf(containerRef.getId())) == null) {
                        HashMap sprintDetails = new HashMap();
                        sprintDetailsMapByIds.put(String.valueOf(containerRef.getId()), sprintDetails);
                    }
                    getContainer = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                    HashMap sprintDetails = (HashMap)sprintDetailsMapByIds.get(String.valueOf(containerRef.getId()));
                    if (sprintDetails.isEmpty()) {
                        sprintDetails.put("featureDetails", new HashMap());
                        sprintDetails.put("storyDetails", new ArrayList());
                        Double capacityCount = 0.0;
                        for (DBObject capacity : boardCapacity) {
                            if (!String.valueOf(capacity.get("sprintId")).equalsIgnoreCase(String.valueOf(containerRef.getId()))) continue;
                            capacityCount = capacityCount + Double.valueOf(String.valueOf(capacity.get("velocity")));
                        }
                        sprintDetails.put("CapacityCount", capacityCount);
                        sprintDetails.put("containerName", getContainer.getTitle());
                        sprintDetails.put("containerId", String.valueOf(getContainer.getId()));
                        sprintDetails.put("containerLabel", getContainer.getLabel());
                    }
                    HashMap updateSprintFeature = (HashMap)sprintDetailsMapByIds.get(String.valueOf(containerRef.getId()));
                    HashMap sprintFeature = (HashMap)updateSprintFeature.get("featureDetails");
                    sprintFeature.put(String.valueOf(rawItem.get("_id")), new HashMap(featureDetailsByTeam));
                    this.calculationForTeamAndSprint(status, rawItem, updateSprintFeature);
                }
                if (sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(containerRef.getId())) == null) {
                    HashMap sprintDataByTeam = new HashMap();
                    sprintDetailsByTeamsMapBySprintIds.put(String.valueOf(containerRef.getId()), sprintDataByTeam);
                }
                getContainer = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                HashMap sprintDataByTeam = (HashMap)sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(containerRef.getId()));
                if (sprintDataByTeam.isEmpty()) {
                    sprintDataByTeam.put("teamDataInTheSprint", new HashMap());
                    sprintDataByTeam.put("containerName", getContainer.getTitle());
                    sprintDataByTeam.put("containerId", String.valueOf(getContainer.getId()));
                    sprintDataByTeam.put("containerLabel", getContainer.getLabel());
                    sprintDataByTeam.put("totalFeatureCountByTeamSprint", 0);
                    sprintDataByTeam.put("toDoFeatureCountByTeamSprint", 0);
                    sprintDataByTeam.put("inProgressFeatureCountByTeamSprint", 0);
                    sprintDataByTeam.put("doneFeatureCountByTeamSprint", 0);
                    sprintDataByTeam.put("miscFeatureCountByTeamSprint", 0);
                    sprintDataByTeam.put("totalStoryCountByTeamSprint", 0);
                    sprintDataByTeam.put("toDoStoryCountByTeamSprint", 0);
                    sprintDataByTeam.put("inProgressStoryCountByTeamSprint", 0);
                    sprintDataByTeam.put("doneStoryCountByTeamSprint", 0);
                    sprintDataByTeam.put("miscStoryCountByTeamSprint", 0);
                    sprintDataByTeam.put("storyPointCountByTeamSprint", 0);
                    sprintDataByTeam.put("doneStoryPointCountByTeamSprint", 0);
                    sprintDataByTeam.put("toDoStoryPointCountByTeamSprint", 0);
                    sprintDataByTeam.put("inProgressStoryPointCountByTeamSprint", 0);
                    sprintDataByTeam.put("miscStoryPointCountByTeamSprint", 0);
                    sprintDataByTeam.put("progressOfFeaturesByTeamSprint", 0);
                    sprintDataByTeam.put("progressOfStoriesByTeamSprint", 0);
                    sprintDataByTeam.put("progressOfStoryPointByTeamSprint", 0);
                    sprintDataByTeam.put("accordItemFlag", false);
                }
                Team getTeam = (Team)teamDetails.get(String.valueOf(teamRef.getId()));
                HashMap updateSprintTeamFeature = (HashMap)sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(containerRef.getId()));
                HashMap teamDetailsInThatSprint = (HashMap)updateSprintTeamFeature.get("teamDataInTheSprint");
                if (teamDetailsInThatSprint.get(String.valueOf(getTeam.getId())) == null) {
                    HashMap<String, String> temperoryteamDetails = new HashMap<String, String>();
                    temperoryteamDetails.put("teamName", getTeam.getTitle());
                    temperoryteamDetails.put("teamId", String.valueOf(getTeam.getId()));
                    temperoryteamDetails.put("teamColor", getTeam.getColor());
                    teamDetailsInThatSprint.put(String.valueOf(getTeam.getId()), temperoryteamDetails);
                }
                HashMap teamFeaturesInThatSprint = (HashMap)teamDetailsInThatSprint.get(String.valueOf(getTeam.getId()));
                this.calculationForTeamAndSprint(status, rawItem, teamFeaturesInThatSprint);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void boardTeamCalculations(HashMap<String, Object> dataMapForTeamCalculations) {
        try {
            HashMap checkDuplicateFeature = (HashMap)dataMapForTeamCalculations.get("checkDuplicateFeature");
            DBObject rawItem = (DBObject)dataMapForTeamCalculations.get("rawItem");
            Status status = (Status)dataMapForTeamCalculations.get("status");
            DBRef teamRef = (DBRef)dataMapForTeamCalculations.get("teamRef");
            HashMap teamDetailsById = (HashMap)dataMapForTeamCalculations.get("teamDetailsById");
            HashMap teamDetails = (HashMap)dataMapForTeamCalculations.get("teamDetails");
            List boardCapacity = (List)dataMapForTeamCalculations.get("boardCapacity");
            HashMap featureDetailsByTeam = (HashMap)dataMapForTeamCalculations.get("featureDetailsByTeam");
            HashMap containerMapById = (HashMap)dataMapForTeamCalculations.get("containerMapById");
            if (teamRef != null && teamRef.getId() != null && checkDuplicateFeature.get(String.valueOf(teamRef.getId())) == null) {
                checkDuplicateFeature.put(String.valueOf(teamRef.getId()), String.valueOf(teamRef.getId()));
                if (teamDetailsById.get(String.valueOf(teamRef.getId())) == null) {
                    HashMap teamList = new HashMap();
                    teamDetailsById.put(String.valueOf(teamRef.getId()), teamList);
                }
                Team getTeam = (Team)teamDetails.get(String.valueOf(teamRef.getId()));
                HashMap teamDetail = (HashMap)teamDetailsById.get(String.valueOf(teamRef.getId()));
                if (teamDetail.isEmpty()) {
                    teamDetail.put("featureDetails", new HashMap());
                    teamDetail.put("storyDetails", new ArrayList());
                    Double capacityCount = 0.0;
                    for (DBObject capacity : boardCapacity) {
                        if (!PropertyValidator.isValid(containerMapById.get(String.valueOf(capacity.get("sprintId")))) || !String.valueOf(capacity.get("teamId")).equalsIgnoreCase(String.valueOf(teamRef.getId())) || !capacity.containsField("velocity")) continue;
                        capacityCount = capacityCount + Double.valueOf(String.valueOf(capacity.get("velocity")));
                    }
                    teamDetail.put("CapacityCount", capacityCount);
                    if (PropertyValidator.isValid((Object)getTeam.getTitle())) {
                        teamDetail.put("teamName", getTeam.getTitle());
                    }
                    teamDetail.put("teamId", String.valueOf(teamRef.getId()));
                    teamDetail.put("teamColor", getTeam.getColor());
                }
                HashMap updateTeamFeature = (HashMap)teamDetailsById.get(String.valueOf(teamRef.getId()));
                HashMap teamFeature = (HashMap)updateTeamFeature.get("featureDetails");
                teamFeature.put(String.valueOf(rawItem.get("_id")), new HashMap(featureDetailsByTeam));
                this.calculationForTeamAndSprint(status, rawItem, updateTeamFeature);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void boardTeamAndSprintCalculationsWhichContainsNoItem(HashMap<String, Object> dataMapForTeamAndSprintCalculationsWhichContainsNoItem) {
        try {
            HashMap teamDetailsById = (HashMap)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("teamDetailsById");
            List boardCapacity = (List)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("boardCapacity");
            List activeSessionTeams = (List)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("activeSessionTeams");
            HashMap teamDetailBySprint = (HashMap)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("teamDetailBySprint");
            List activeSessionContainers = (List)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("activeSessionContainers");
            HashMap containerMapById = (HashMap)dataMapForTeamAndSprintCalculationsWhichContainsNoItem.get("containerMapById");
            if (activeSessionTeams != null) {
                activeSessionTeams.forEach(team -> {
                    HashMap sprintMap;
                    if (teamDetailsById.get(String.valueOf(team.getId())) == null) {
                        HashMap<String, Object> teamDetail = new HashMap<String, Object>();
                        teamDetail.put("teamName", team.getTitle());
                        teamDetail.put("teamId", String.valueOf(team.getId()));
                        teamDetail.put("teamColor", team.getColor());
                        teamDetail.put("totalFeatureCount", 0);
                        teamDetail.put("toDoFeatureCount", 0);
                        teamDetail.put("inProgressFeatureCount", 0);
                        teamDetail.put("doneFeatureCount", 0);
                        teamDetail.put("totalStoryCount", 0);
                        teamDetail.put("toDoStoryCount", 0);
                        teamDetail.put("inProgressStoryCount", 0);
                        teamDetail.put("doneStoryCount", 0);
                        teamDetail.put("storyPointCount", 0);
                        teamDetail.put("doneStoryPointCount", 0);
                        teamDetail.put("toDoStoryPointCount", 0);
                        teamDetail.put("inProgressStoryPointCount", 0);
                        Double capacityCount = 0.0;
                        for (DBObject capacity : boardCapacity) {
                            if (!PropertyValidator.isValid(containerMapById.get(String.valueOf(capacity.get("sprintId")))) || !String.valueOf(capacity.get("teamId")).equalsIgnoreCase(String.valueOf(team.getId()))) continue;
                            capacityCount = capacityCount + Double.valueOf(String.valueOf(capacity.get("velocity")));
                        }
                        teamDetail.put("CapacityCount", capacityCount);
                        teamDetailsById.put(String.valueOf(team.getId()), teamDetail);
                    }
                    if ((sprintMap = (HashMap)teamDetailBySprint.get(String.valueOf(team.getId()))) == null) {
                        sprintMap = new HashMap();
                        teamDetailBySprint.put(String.valueOf(team.getId()), sprintMap);
                    }
                    HashMap sprintMapData = (HashMap)teamDetailBySprint.get(String.valueOf(team.getId()));
                    if (activeSessionContainers != null) {
                        activeSessionContainers.forEach(container -> {
                            HashMap sprintDetail;
                            if (sprintMapData.get(String.valueOf(container.getId())) == null) {
                                sprintDetail = new HashMap();
                                sprintDetail.put("sprintLoad", 0);
                                sprintDetail.put("doneStoryPoints", 0);
                                sprintDetail.put("teamName", team.getTitle());
                                sprintDetail.put("teamId", team.getId());
                                sprintDetail.put("teamColor", team.getColor());
                                sprintMapData.put(String.valueOf(container.getId()), sprintDetail);
                            }
                            sprintDetail = (HashMap)sprintMapData.get(String.valueOf(container.getId()));
                            Double capacityCount = 0.0;
                            Double commitedLoad = 0.0;
                            for (DBObject capacity : boardCapacity) {
                                if (!String.valueOf(capacity.get("sprintId")).equalsIgnoreCase(String.valueOf(container.getId())) || !String.valueOf(capacity.get("teamId")).equalsIgnoreCase(String.valueOf(team.getId()))) continue;
                                capacityCount = Double.valueOf(String.valueOf(capacity.get("velocity")));
                                if (capacity.get("commitedLoad") == null) continue;
                                commitedLoad = Double.valueOf(String.valueOf(capacity.get("commitedLoad")));
                            }
                            sprintDetail.put("commitedLoad", commitedLoad);
                            sprintDetail.put("sprintCapacity", capacityCount);
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void boardTeamAndSprintCalculationsForStories(HashMap<String, Object> dataMapForTeamCalculations) {
        try {
            HashMap tempMap;
            HashMap sprintMap;
            HashMap teamContainersMap = (HashMap)dataMapForTeamCalculations.get("teamContainersMap");
            DBObject tcObject = (DBObject)dataMapForTeamCalculations.get("tcObject");
            DBObject rawItem = (DBObject)dataMapForTeamCalculations.get("rawItem");
            DBRef teamRef = (DBRef)dataMapForTeamCalculations.get("teamRef");
            Status status = (Status)dataMapForTeamCalculations.get("status");
            HashMap teamDetailBySprint = (HashMap)dataMapForTeamCalculations.get("teamDetailBySprint");
            HashMap teamDetailsById = (HashMap)dataMapForTeamCalculations.get("teamDetailsById");
            DBRef containerRef = (DBRef)dataMapForTeamCalculations.get("containerRef");
            HashMap teamDetails = (HashMap)dataMapForTeamCalculations.get("teamDetails");
            HashMap stories = (HashMap)dataMapForTeamCalculations.get("stories");
            HashMap sprintContainersMap = (HashMap)dataMapForTeamCalculations.get("sprintContainersMap");
            List storiesCreatedAfterActiveSprint = (List)dataMapForTeamCalculations.get("storiesCreatedAfterActiveSprint");
            teamContainersMap.put(String.valueOf(tcObject.get("_id")), String.valueOf(teamRef.getId()));
            sprintContainersMap.put(String.valueOf(tcObject.get("_id")), String.valueOf(containerRef.getId()));
            HashMap updateTeamStory = (HashMap)teamDetailsById.get(String.valueOf(teamRef.getId()));
            List tempStories = new ArrayList();
            if (PropertyValidator.isValid((Object)updateTeamStory)) {
                tempStories = (List)updateTeamStory.get("storiesCreatedAfterActiveSprint");
                if (tempStories != null && tempStories.size() > 0) {
                    tempStories.addAll(storiesCreatedAfterActiveSprint);
                    updateTeamStory.put("storiesCreatedAfterActiveSprint", tempStories);
                } else {
                    updateTeamStory.put("storiesCreatedAfterActiveSprint", storiesCreatedAfterActiveSprint);
                }
                ArrayList teamStories = (ArrayList)updateTeamStory.get("storyDetails");
                teamStories.add(stories);
                this.calculationForTeamAndSprint(status, rawItem, updateTeamStory);
            }
            if (teamDetailBySprint.get(String.valueOf(teamRef.getId())) == null) {
                teamDetailBySprint.put(String.valueOf(teamRef.getId()), new HashMap());
            }
            if ((sprintMap = (HashMap)teamDetailBySprint.get(String.valueOf(teamRef.getId()))).get(String.valueOf(containerRef.getId())) == null) {
                sprintMap.put(String.valueOf(containerRef.getId()), new HashMap());
            }
            if ((tempMap = (HashMap)sprintMap.get(String.valueOf(containerRef.getId()))).isEmpty()) {
                tempMap.put("sprintLoad", 0);
                tempMap.put("doneStoryPoints", 0);
                Team team = (Team)teamDetails.get(String.valueOf(teamRef.getId()));
                tempMap.put("teamName", team.getTitle());
                tempMap.put("teamId", String.valueOf(teamRef.getId()));
                tempMap.put("teamColor", team.getColor());
            }
            if (rawItem.get("storyPoints") == null) {
                tempMap.put("sprintLoad", Double.valueOf(String.valueOf(tempMap.get("sprintLoad"))) + 0.0);
            } else {
                tempMap.put("sprintLoad", Double.valueOf(String.valueOf(tempMap.get("sprintLoad"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
            }
            if (status != null && status.getCategory().equalsIgnoreCase("Done")) {
                if (rawItem.get("storyPoints") == null) {
                    tempMap.put("doneStoryPoints", Double.valueOf(String.valueOf(tempMap.get("doneStoryPoints"))) + 0.0);
                } else {
                    tempMap.put("doneStoryPoints", Double.valueOf(String.valueOf(tempMap.get("doneStoryPoints"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void calculationForNoFeatureSprint(HashMap<String, Object> sprintDetailsMapByIds, HashMap<String, Object> sprintDetailsByTeamsMapBySprintIds, List<Container> activeSessionContainers, List<Team> activeSessionTeams, List<DBObject> boardCapacity) {
        try {
            activeSessionContainers.forEach(container -> {
                if (sprintDetailsMapByIds.get(String.valueOf(container.getId())) == null) {
                    HashMap<String, Object> sprintDetail = new HashMap<String, Object>();
                    sprintDetail.put("containerName", container.getTitle());
                    sprintDetail.put("containerId", String.valueOf(container.getId()));
                    sprintDetail.put("containerLabel", container.getLabel());
                    sprintDetail.put("containerOriginItemId", container.getOriginItemId());
                    sprintDetail.put("totalFeatureCount", 0);
                    sprintDetail.put("toDoFeatureCount", 0);
                    sprintDetail.put("inProgressFeatureCount", 0);
                    sprintDetail.put("doneFeatureCount", 0);
                    sprintDetail.put("miscFeatureCount", 0);
                    sprintDetail.put("totalStoryCount", 0);
                    sprintDetail.put("toDoStoryCount", 0);
                    sprintDetail.put("inProgressStoryCount", 0);
                    sprintDetail.put("doneStoryCount", 0);
                    sprintDetail.put("miscStoryCount", 0);
                    sprintDetail.put("storyPointCount", 0);
                    sprintDetail.put("doneStoryPointCount", 0);
                    sprintDetail.put("toDoStoryPointCount", 0);
                    sprintDetail.put("inProgressStoryPointCount", 0);
                    sprintDetail.put("miscStoryPointCount", 0);
                    Double capacityCount = 0.0;
                    for (DBObject capacity : boardCapacity) {
                        if (!String.valueOf(capacity.get("sprintId")).equalsIgnoreCase(String.valueOf(container.getId())) || !capacity.containsField("velocity")) continue;
                        capacityCount = capacityCount + Double.valueOf(String.valueOf(capacity.get("velocity")));
                    }
                    sprintDetail.put("CapacityCount", capacityCount);
                    sprintDetailsMapByIds.put(String.valueOf(container.getId()), sprintDetail);
                }
                if (sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(container.getId())) == null) {
                    HashMap<String, Object> sprintDetailByTeam = new HashMap<String, Object>();
                    sprintDetailByTeam.put("containerName", container.getTitle());
                    sprintDetailByTeam.put("containerId", String.valueOf(container.getId()));
                    sprintDetailByTeam.put("containerLabel", container.getLabel());
                    sprintDetailByTeam.put("teamDataInTheSprint", new HashMap());
                    sprintDetailByTeam.put("totalFeatureCountByTeamSprint", 0);
                    sprintDetailByTeam.put("toDoFeatureCountByTeamSprint", 0);
                    sprintDetailByTeam.put("inProgressFeatureCountByTeamSprint", 0);
                    sprintDetailByTeam.put("doneFeatureCountByTeamSprint", 0);
                    sprintDetailByTeam.put("miscFeatureCountByTeamSprint", 0);
                    sprintDetailByTeam.put("totalStoryCountByTeamSprint", 0);
                    sprintDetailByTeam.put("toDoStoryCountByTeamSprint", 0);
                    sprintDetailByTeam.put("inProgressStoryCountByTeamSprint", 0);
                    sprintDetailByTeam.put("doneStoryCountByTeamSprint", 0);
                    sprintDetailByTeam.put("miscStoryCountByTeamSprint", 0);
                    sprintDetailByTeam.put("storyPointCountByTeamSprint", 0);
                    sprintDetailByTeam.put("doneStoryPointCountByTeamSprint", 0);
                    sprintDetailByTeam.put("toDoStoryPointCountByTeamSprint", 0);
                    sprintDetailByTeam.put("inProgressStoryPointCountByTeamSprint", 0);
                    sprintDetailByTeam.put("miscStoryPointCountByTeamSprint", 0);
                    sprintDetailByTeam.put("progressOfFeaturesByTeamSprint", 0);
                    sprintDetailByTeam.put("progressOfStoriesByTeamSprint", 0);
                    sprintDetailByTeam.put("progressOfStoryPointByTeamSprint", 0);
                    sprintDetailByTeam.put("accordItemFlag", false);
                    sprintDetailsByTeamsMapBySprintIds.put(String.valueOf(container.getId()), sprintDetailByTeam);
                }
                HashMap updateSprintTeamData = (HashMap)sprintDetailsByTeamsMapBySprintIds.get(String.valueOf(container.getId()));
                HashMap teamDetailsInThatSprint = (HashMap)updateSprintTeamData.get("teamDataInTheSprint");
                activeSessionTeams.forEach(team -> {
                    if (teamDetailsInThatSprint.get(String.valueOf(team.getId())) == null) {
                        HashMap<String, Object> temperoryteamDetails = new HashMap<String, Object>();
                        temperoryteamDetails.put("teamName", String.valueOf(team.getTitle()));
                        temperoryteamDetails.put("teamId", String.valueOf(team.getId()));
                        temperoryteamDetails.put("teamColor", team.getColor());
                        temperoryteamDetails.put("totalFeatureCount", 0);
                        temperoryteamDetails.put("toDoFeatureCount", 0);
                        temperoryteamDetails.put("inProgressFeatureCount", 0);
                        temperoryteamDetails.put("doneFeatureCount", 0);
                        temperoryteamDetails.put("miscFeatureCount", 0);
                        temperoryteamDetails.put("totalStoryCount", 0);
                        temperoryteamDetails.put("toDoStoryCount", 0);
                        temperoryteamDetails.put("inProgressStoryCount", 0);
                        temperoryteamDetails.put("doneStoryCount", 0);
                        temperoryteamDetails.put("miscStoryCount", 0);
                        temperoryteamDetails.put("storyPointCount", 0);
                        temperoryteamDetails.put("doneStoryPointCount", 0);
                        temperoryteamDetails.put("toDoStoryPointCount", 0);
                        temperoryteamDetails.put("inProgressStoryPointCount", 0);
                        temperoryteamDetails.put("miscStoryPointCount", 0);
                        temperoryteamDetails.put("doneStoryCountIdsList", new ArrayList());
                        temperoryteamDetails.put("doneFeatureCountIdsList", new ArrayList());
                        teamDetailsInThatSprint.put(String.valueOf(team.getId()), temperoryteamDetails);
                    }
                });
            });
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void calculationForTeamAndSprint(Status status, DBObject rawItem, HashMap<String, Object> updateData) {
        try {
            if (updateData.get("totalFeatureCount") == null) {
                updateData.put("totalFeatureCount", 0);
                updateData.put("toDoFeatureCount", 0);
                updateData.put("inProgressFeatureCount", 0);
                updateData.put("doneFeatureCount", 0);
                updateData.put("miscFeatureCount", 0);
                updateData.put("totalStoryCount", 0);
                updateData.put("toDoStoryCount", 0);
                updateData.put("inProgressStoryCount", 0);
                updateData.put("doneStoryCount", 0);
                updateData.put("miscStoryCount", 0);
                updateData.put("storyPointCount", 0);
                updateData.put("doneStoryPointCount", 0);
                updateData.put("toDoStoryPointCount", 0);
                updateData.put("inProgressStoryPointCount", 0);
                updateData.put("miscStoryPointCount", 0);
                updateData.put("doneFeatureCountIdsList", new ArrayList());
                updateData.put("doneStoryCountIdsList", new ArrayList());
            }
            if (rawItem.get("type").equals(Item.FEATURE) && status != null && status.getCategory() != null) {
                updateData.put("totalFeatureCount", (Integer)updateData.get("totalFeatureCount") + 1);
                if (status.getCategory().equalsIgnoreCase("ToDo")) {
                    updateData.put("toDoFeatureCount", (Integer)updateData.get("toDoFeatureCount") + 1);
                } else if (status.getCategory().equalsIgnoreCase("InProgress")) {
                    updateData.put("inProgressFeatureCount", (Integer)updateData.get("inProgressFeatureCount") + 1);
                } else if (status.getCategory().equalsIgnoreCase("Done")) {
                    updateData.put("doneFeatureCount", (Integer)updateData.get("doneFeatureCount") + 1);
                    if (PropertyValidator.isValid((Object)updateData.get("doneFeatureCountIdsList"))) {
                        ArrayList updateTeamAndSprintData = (ArrayList)updateData.get("doneFeatureCountIdsList");
                        updateTeamAndSprintData.add(String.valueOf(rawItem.get("_id")));
                    }
                } else if (status.getCategory().equalsIgnoreCase("Misc")) {
                    updateData.put("miscFeatureCount", (Integer)updateData.get("miscFeatureCount") + 1);
                }
            } else if (rawItem.get("type").equals(Item.USER_STORY) && status != null && status.getCategory() != null) {
                updateData.put("totalStoryCount", (Integer)updateData.get("totalStoryCount") + 1);
                if (status != null && status.getCategory().equalsIgnoreCase("ToDo")) {
                    updateData.put("toDoStoryCount", (Integer)updateData.get("toDoStoryCount") + 1);
                    if (rawItem.get("storyPoints") != null) {
                        updateData.put("toDoStoryPointCount", Double.valueOf(String.valueOf(updateData.get("toDoStoryPointCount"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                    }
                } else if (status != null && status.getCategory().equalsIgnoreCase("InProgress")) {
                    updateData.put("inProgressStoryCount", (Integer)updateData.get("inProgressStoryCount") + 1);
                    if (rawItem.get("storyPoints") != null) {
                        updateData.put("inProgressStoryPointCount", Double.valueOf(String.valueOf(updateData.get("inProgressStoryPointCount"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                    }
                } else if (status != null && status.getCategory().equalsIgnoreCase("Done")) {
                    updateData.put("doneStoryCount", (Integer)updateData.get("doneStoryCount") + 1);
                    if (PropertyValidator.isValid((Object)updateData.get("doneStoryCountIdsList"))) {
                        ArrayList updateTeamAndSprintData = (ArrayList)updateData.get("doneStoryCountIdsList");
                        updateTeamAndSprintData.add(String.valueOf(rawItem.get("_id")));
                    }
                    if (rawItem.get("storyPoints") != null) {
                        updateData.put("doneStoryPointCount", Double.valueOf(String.valueOf(updateData.get("doneStoryPointCount"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                    }
                } else if (status != null && status.getCategory().equalsIgnoreCase("Misc")) {
                    updateData.put("miscStoryCount", (Integer)updateData.get("miscStoryCount") + 1);
                    if (rawItem.get("storyPoints") != null) {
                        updateData.put("miscStoryPointCount", Double.valueOf(String.valueOf(updateData.get("miscStoryPointCount"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                    }
                }
                if (rawItem.get("storyPoints") != null) {
                    updateData.put("storyPointCount", Double.valueOf(String.valueOf(updateData.get("storyPointCount"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private HashMap<String, Object> processKendisDependencies(ItemLink link, HashMap<String, Object> teamContainersMapById, HashMap<String, Container> containersMapById, HashMap<String, Team> teamMapById, HashMap<String, DBObject> stateItemsMapById, HashMap<String, DBObject> stateItemsMapByTeamContainerId) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getId())) {
                if (PropertyValidator.isValid((Object)link.getWfStatus())) {
                    Status status = link.getWfStatus();
                    Status cp_status = new Status();
                    cp_status.setId(status.getId());
                    cp_status.setTitle(status.getTitle());
                    cp_status.setCategory(status.getCategory());
                    link.setWfStatus(cp_status);
                }
                TeamContainer sourceTeamContainer = (TeamContainer)teamContainersMapById.get(link.getSourceTeamContainerId());
                Container sourceConatinerId = null;
                Container sourceContainer = null;
                Team sourceTeamId = null;
                Team sourceTeam = null;
                if (sourceTeamContainer != null) {
                    sourceConatinerId = sourceTeamContainer.getContainer();
                    sourceContainer = containersMapById.get(sourceConatinerId.getId());
                    sourceTeamId = sourceTeamContainer.getTeam();
                    sourceTeam = teamMapById.get(sourceTeamId.getId());
                }
                Container targetConatinerId = null;
                Container targetContainer = null;
                Team targetTeamId = null;
                Team targetTeam = null;
                TeamContainer targetTeamContainer = (TeamContainer)teamContainersMapById.get(link.getTargetTeamContainerId());
                if (targetTeamContainer != null) {
                    targetConatinerId = targetTeamContainer.getContainer();
                    targetContainer = containersMapById.get(targetConatinerId.getId());
                    targetTeamId = targetTeamContainer.getTeam();
                    targetTeam = teamMapById.get(targetTeamId.getId());
                }
                DBObject sourceItem = null;
                if (stateItemsMapById.get(link.getSourceUserStoryId()) != null) {
                    sourceItem = stateItemsMapById.get(link.getSourceUserStoryId());
                } else if (link.getSourceFeatureId() != null) {
                    sourceItem = stateItemsMapById.get(link.getSourceFeatureId());
                } else if (stateItemsMapById.get(link.getSourceItemId()) != null) {
                    sourceItem = stateItemsMapById.get(link.getSourceItemId());
                } else if (stateItemsMapByTeamContainerId.get(link.getSourceTeamContainerId()) != null) {
                    sourceItem = stateItemsMapByTeamContainerId.get(link.getSourceTeamContainerId());
                }
                DBObject targetItem = null;
                if (stateItemsMapById.get(link.getTargetUserStoryId()) != null) {
                    targetItem = stateItemsMapById.get(link.getTargetUserStoryId());
                } else if (link.getTargetFeatureId() != null) {
                    targetItem = stateItemsMapById.get(link.getTargetFeatureId());
                } else if (stateItemsMapById.get(link.getTargetItemId()) != null) {
                    targetItem = stateItemsMapById.get(link.getTargetItemId());
                } else if (stateItemsMapByTeamContainerId.get(link.getTargetTeamContainerId()) != null) {
                    targetItem = stateItemsMapByTeamContainerId.get(link.getTargetTeamContainerId());
                }
                HashMap<String, Object> linkDataByAttribute = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)sourceTeamContainer) && PropertyValidator.isValid((Object)targetTeamContainer) && PropertyValidator.isValid((Object)sourceItem) && PropertyValidator.isValid((Object)targetItem)) {
                    linkDataByAttribute.put("createdBy", link.getCreatedBy());
                    linkDataByAttribute.put("createdOn", link.getCreatedOn());
                    linkDataByAttribute.put("description", link.getDescription());
                    linkDataByAttribute.put("duplicateOfId", link.getDuplicateOfId());
                    linkDataByAttribute.put("dueDate", link.getDueDate());
                    linkDataByAttribute.put("eventType", link.getEventType());
                    linkDataByAttribute.put("generatedId", link.getGeneratedId());
                    linkDataByAttribute.put("id", link.getId());
                    linkDataByAttribute.put("isManuallyResolved", link.getIsManuallyResolved());
                    linkDataByAttribute.put("jiraDependency", link.getJiraDependency());
                    linkDataByAttribute.put("level", link.getLevel());
                    linkDataByAttribute.put("customId", link.getCustomId());
                    if (link.getOriginItemId() != null) {
                        linkDataByAttribute.put("parentId", String.valueOf(link.getOriginItemId()));
                    } else {
                        linkDataByAttribute.put("parentId", String.valueOf(link.getId()));
                    }
                    if (link.getWfStatus() != null) {
                        linkDataByAttribute.put("wfStatus", link.getWfStatus());
                    }
                    linkDataByAttribute.put("linkType", link.getType());
                    linkDataByAttribute.put("lost", link.getLost());
                    linkDataByAttribute.put("oldSate", link.getOldSate());
                    linkDataByAttribute.put("originItemId", link.getOriginItemId());
                    linkDataByAttribute.put("raisedOn", link.getRaisedOn());
                    linkDataByAttribute.put("resolvedOn", link.getResolvedOn());
                    linkDataByAttribute.put("rowStatus", link.getRowStatus());
                    linkDataByAttribute.put("sessionBoardId", link.getSessionBoardId());
                    linkDataByAttribute.put("source", 0);
                    linkDataByAttribute.put("sourceItem", sourceItem);
                    linkDataByAttribute.put("sourceUserStoryId", link.getSourceUserStoryId());
                    linkDataByAttribute.put("sourceFeatureId", link.getSourceFeatureId());
                    linkDataByAttribute.put("sourceJiraId", link.getSourceJiraId());
                    linkDataByAttribute.put("sourceItemId", link.getSourceItemId());
                    linkDataByAttribute.put("sourceSprint", sourceContainer);
                    linkDataByAttribute.put("sourceTeam", sourceTeam);
                    HashMap<String, Object> sourceSprint = new HashMap<String, Object>();
                    if (sourceContainer != null) {
                        sourceSprint.put("id", sourceContainer.getId());
                        sourceSprint.put("title", sourceContainer.getTitle());
                        sourceSprint.put("label", sourceContainer.getLabel());
                        sourceSprint.put("isIPSprint", sourceContainer.getIsIPSprint());
                        sourceSprint.put("endDate", sourceContainer.getEndDate());
                        sourceSprint.put("startDate", sourceContainer.getStartDate());
                    }
                    HashMap<String, String> sourceTeamDetailsMap = new HashMap<String, String>();
                    if (sourceTeam != null) {
                        sourceTeamDetailsMap.put("color", sourceTeam.getColor());
                        sourceTeamDetailsMap.put("id", sourceTeam.getId());
                        sourceTeamDetailsMap.put("label", sourceTeam.getLabel());
                        sourceTeamDetailsMap.put("title", sourceTeam.getTitle());
                    }
                    HashMap<String, Object> sourceTCMap = new HashMap<String, Object>();
                    sourceTCMap.put("container", sourceSprint);
                    if (sourceTeamContainer != null) {
                        sourceTCMap.put("id", sourceTeamContainer.getId());
                    } else {
                        sourceTCMap.put("id", "NA");
                    }
                    sourceTCMap.put("team", sourceTeamDetailsMap);
                    linkDataByAttribute.put("sourceTC", sourceTCMap);
                    linkDataByAttribute.put("sourceTeamContainerId", link.getSourceTeamContainerId());
                    linkDataByAttribute.put("sourceUserStoryId", link.getSourceUserStoryId());
                    linkDataByAttribute.put("status", link.getStatus());
                    linkDataByAttribute.put("syncTfs", link.getSyncTfs());
                    linkDataByAttribute.put("targetItem", targetItem);
                    linkDataByAttribute.put("targetFeatureId", link.getTargetFeatureId());
                    linkDataByAttribute.put("targetUserStoryId", link.getTargetUserStoryId());
                    linkDataByAttribute.put("targetJiraId", link.getTargetJiraId());
                    linkDataByAttribute.put("targetItemId", link.getTargetItemId());
                    linkDataByAttribute.put("targetSprint", targetContainer);
                    linkDataByAttribute.put("targetTeam", targetTeam);
                    HashMap<String, Object> targeteSprint = new HashMap<String, Object>();
                    if (targetContainer != null) {
                        targeteSprint.put("id", targetContainer.getId());
                        targeteSprint.put("title", targetContainer.getTitle());
                        targeteSprint.put("label", targetContainer.getLabel());
                        targeteSprint.put("isIPSprint", targetContainer.getIsIPSprint());
                        targeteSprint.put("endDate", targetContainer.getEndDate());
                        targeteSprint.put("startDate", targetContainer.getStartDate());
                    }
                    HashMap<String, String> targetTeamDetailsMap = new HashMap<String, String>();
                    if (targetTeam != null) {
                        targetTeamDetailsMap.put("color", targetTeam.getColor());
                        targetTeamDetailsMap.put("id", targetTeam.getId());
                        targetTeamDetailsMap.put("label", targetTeam.getLabel());
                        targetTeamDetailsMap.put("title", targetTeam.getTitle());
                    }
                    HashMap<String, Object> targetTCMap = new HashMap<String, Object>();
                    targetTCMap.put("container", targeteSprint);
                    if (targetTeamContainer != null) {
                        targetTCMap.put("id", targetTeamContainer.getId());
                    } else {
                        targetTCMap.put("id", "NA");
                    }
                    targetTCMap.put("team", targetTeamDetailsMap);
                    linkDataByAttribute.put("targetTC", targetTCMap);
                    linkDataByAttribute.put("targetTeamContainerId", link.getTargetTeamContainerId());
                    linkDataByAttribute.put("targetUserStoryId", link.getTargetUserStoryId());
                    linkDataByAttribute.put("title", link.getTitle());
                    linkDataByAttribute.put("type", link.getType());
                    if (link.getType().contains("Related")) {
                        linkDataByAttribute.put("type", "Related");
                    }
                    if (link.getType().contains("Forward")) {
                        linkDataByAttribute.put("type", "Successor");
                    }
                    if (link.getType().contains("Reverse")) {
                        linkDataByAttribute.put("type", "Predecessor");
                    }
                    linkDataByAttribute.put("updatedBy", link.getUpdatedBy());
                    linkDataByAttribute.put("updatedOn", link.getUpdatedOn());
                    responce.put("linkDataByAttribute", linkDataByAttribute);
                    responce.put("sourceTeamId", sourceTeamId);
                    responce.put("targetTeamId", targetTeamId);
                    responce.put("targetContainer", targetContainer);
                    responce.put("sourceContainer", sourceContainer);
                }
            }
            return responce;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return responce;
        }
    }

    private void putDependenciesData(HashMap<String, Object> processedDependencies) {
        try {
            Team sourceTeamId = (Team)processedDependencies.get("sourceTeamId");
            Team targetTeamId = (Team)processedDependencies.get("targetTeamId");
            Container targetContainer = (Container)processedDependencies.get("targetContainer");
            Container sourceContainer = (Container)processedDependencies.get("sourceContainer");
            HashMap linkDataByAttribute = (HashMap)processedDependencies.get("linkDataByAttribute");
            String teamOrBoardDepndencyFlag = (String)processedDependencies.get("teamOrBoardDepndencyFlag");
            HashMap currentStateLinksMapsByTeamId = (HashMap)processedDependencies.get("currentStateLinksMapsByTeamId");
            HashMap currentLinksBySprintReceived = (HashMap)processedDependencies.get("currentLinksBySprintReceived");
            HashMap currentLinksBySprintCreater = (HashMap)processedDependencies.get("currentLinksBySprintCreater");
            HashMap boardDependency = (HashMap)processedDependencies.get("boardDependency");
            if (teamOrBoardDepndencyFlag == "teamDependencies") {
                Status linkStatus;
                if (sourceTeamId != null) {
                    HashMap getSourceTeamData = (HashMap)currentStateLinksMapsByTeamId.get(sourceTeamId.getId());
                    HashMap getSourceTeamCreatedLinks = (HashMap)getSourceTeamData.get("created");
                    getSourceTeamCreatedLinks.put("currentTotal", (Integer)getSourceTeamCreatedLinks.get("currentTotal") + 1);
                    if (linkDataByAttribute.get("wfStatus") != null) {
                        linkStatus = (Status)linkDataByAttribute.get("wfStatus");
                        if (!linkStatus.getCategory().equals("Done")) {
                            getSourceTeamCreatedLinks.put("totalOpen", (Integer)getSourceTeamCreatedLinks.get("totalOpen") + 1);
                            HashMap getSourceTeamCreatedOpenLinks = (HashMap)getSourceTeamCreatedLinks.get("open");
                            if (linkDataByAttribute.get("originItemId") != null) {
                                getSourceTeamCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                            } else {
                                getSourceTeamCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                            }
                        } else if (linkStatus.getCategory().equals("Done")) {
                            getSourceTeamCreatedLinks.put("totalResolved", (Integer)getSourceTeamCreatedLinks.get("totalResolved") + 1);
                            HashMap getSourceTeamResolvedLinks = (HashMap)getSourceTeamCreatedLinks.get("resolved");
                            if (linkDataByAttribute.get("originItemId") != null) {
                                getSourceTeamResolvedLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                            } else {
                                getSourceTeamResolvedLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                            }
                        }
                    }
                }
                if (targetTeamId != null) {
                    HashMap getTargetTeamData = (HashMap)currentStateLinksMapsByTeamId.get(targetTeamId.getId());
                    HashMap getTargetTeamCreatedLinks = (HashMap)getTargetTeamData.get("received");
                    getTargetTeamCreatedLinks.put("currentTotal", (Integer)getTargetTeamCreatedLinks.get("currentTotal") + 1);
                    if (linkDataByAttribute.get("wfStatus") != null) {
                        linkStatus = (Status)linkDataByAttribute.get("wfStatus");
                        if (!linkStatus.getCategory().equals("Done")) {
                            getTargetTeamCreatedLinks.put("totalOpen", (Integer)getTargetTeamCreatedLinks.get("totalOpen") + 1);
                            HashMap getTargetTeamCreatedOpenLinks = (HashMap)getTargetTeamCreatedLinks.get("open");
                            if (linkDataByAttribute.get("originItemId") != null) {
                                getTargetTeamCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                            } else {
                                getTargetTeamCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                            }
                        } else if (linkStatus.getCategory().equals("Done")) {
                            getTargetTeamCreatedLinks.put("totalResolved", (Integer)getTargetTeamCreatedLinks.get("totalResolved") + 1);
                            HashMap getTargetTeamResolvedLinks = (HashMap)getTargetTeamCreatedLinks.get("resolved");
                            if (linkDataByAttribute.get("originItemId") != null) {
                                getTargetTeamResolvedLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                            } else {
                                getTargetTeamResolvedLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                            }
                        }
                    }
                }
            } else if (teamOrBoardDepndencyFlag == "sprintDependencies") {
                ArrayList getTargetSprintData;
                if (targetContainer != null) {
                    if (currentLinksBySprintReceived.get(String.valueOf(targetContainer.getId())) == null) {
                        currentLinksBySprintReceived.put(String.valueOf(targetContainer.getId()), new ArrayList());
                    }
                    getTargetSprintData = (ArrayList)currentLinksBySprintReceived.get(String.valueOf(targetContainer.getId()));
                    getTargetSprintData.add(linkDataByAttribute);
                }
                if (sourceContainer != null) {
                    if (currentLinksBySprintCreater.get(String.valueOf(sourceContainer.getId())) == null) {
                        currentLinksBySprintCreater.put(String.valueOf(sourceContainer.getId()), new ArrayList());
                    }
                    getTargetSprintData = (ArrayList)currentLinksBySprintCreater.get(String.valueOf(sourceContainer.getId()));
                    getTargetSprintData.add(linkDataByAttribute);
                }
            } else {
                boardDependency.put("currentTotal", (Integer)boardDependency.get("currentTotal") + 1);
                if (linkDataByAttribute.get("wfStatus") != null) {
                    Status linkStatus = (Status)linkDataByAttribute.get("wfStatus");
                    if (!linkStatus.getCategory().equals("Done")) {
                        boardDependency.put("totalOpen", (Integer)boardDependency.get("totalOpen") + 1);
                        HashMap getCreatedOpenLinks = (HashMap)boardDependency.get("open");
                        if (linkDataByAttribute.get("originItemId") != null) {
                            getCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                        } else {
                            getCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                        }
                    } else if (linkStatus.getCategory().equals("Done")) {
                        boardDependency.put("totalResolved", (Integer)boardDependency.get("totalResolved") + 1);
                        HashMap getResolvedLinks = (HashMap)boardDependency.get("resolved");
                        if (linkDataByAttribute.get("originItemId") != null) {
                            getResolvedLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                        } else {
                            getResolvedLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                        }
                    }
                } else if (linkDataByAttribute.get("status").equals("Open")) {
                    boardDependency.put("totalOpen", (Integer)boardDependency.get("totalOpen") + 1);
                    HashMap getCreatedOpenLinks = (HashMap)boardDependency.get("open");
                    if (linkDataByAttribute.get("originItemId") != null) {
                        getCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                    } else {
                        getCreatedOpenLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                    }
                } else if (linkDataByAttribute.get("status").equals("Resolved")) {
                    boardDependency.put("totalResolved", (Integer)boardDependency.get("totalResolved") + 1);
                    HashMap getResolvedLinks = (HashMap)boardDependency.get("resolved");
                    if (linkDataByAttribute.get("originItemId") != null) {
                        getResolvedLinks.put(String.valueOf(linkDataByAttribute.get("originItemId")), linkDataByAttribute);
                    } else {
                        getResolvedLinks.put(String.valueOf(linkDataByAttribute.get("id")), linkDataByAttribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private HashMap<String, DBObject> checkTFSDependencyDirection(ItemJiraDependency link, HashMap<String, DBObject> stateItemsMapById) {
        HashMap<String, DBObject> linkItems = new HashMap<String, DBObject>();
        try {
            if (link.getTfsLinkType().contains("Reverse") || link.getTfsLinkType().contains("Related")) {
                linkItems.put("linkSourceItem", stateItemsMapById.get(String.valueOf(link.getSourceItemId())));
                linkItems.put("linkTargetItem", stateItemsMapById.get(String.valueOf(link.getTargetItemId())));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return linkItems;
    }

    private HashMap<String, DBObject> checkJiraDependencyDirection(ItemJiraDependency link, HashMap<String, DBObject> stateItemsMapById) {
        HashMap<String, DBObject> linkItems = new HashMap<String, DBObject>();
        try {
            if (link.getDirection().contains("OUT")) {
                linkItems.put("linkSourceItem", stateItemsMapById.get(String.valueOf(link.getTargetItemId())));
                linkItems.put("linkTargetItem", stateItemsMapById.get(String.valueOf(link.getSourceItemId())));
            } else if (link.getDirection().contains("IN") || link.getDirection().contains("")) {
                linkItems.put("linkSourceItem", stateItemsMapById.get(String.valueOf(link.getSourceItemId())));
                linkItems.put("linkTargetItem", stateItemsMapById.get(String.valueOf(link.getTargetItemId())));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return linkItems;
    }

    private TeamContainer maxTeamContainerSequence(List<DBRef> teamContainerList, HashMap<String, Object> teamContainersMapById) {
        TeamContainer maxTeamContainer = null;
        try {
            if (PropertyValidator.isValid(teamContainerList)) {
                for (int i = 0; i < teamContainerList.size(); ++i) {
                    DBRef containerRef = teamContainerList.get(i);
                    TeamContainer teamContainer = (TeamContainer)teamContainersMapById.get(String.valueOf(containerRef.getId()));
                    if (maxTeamContainer == null) {
                        maxTeamContainer = teamContainer;
                    }
                    Double maxSequence = maxTeamContainer.getContainer().getSequence();
                    Double sequence = teamContainer.getContainer().getSequence();
                    if (maxSequence.longValue() >= sequence.longValue()) continue;
                    maxTeamContainer = teamContainer;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return maxTeamContainer;
    }

    private HashMap<String, Object> getTfsLinkTypeName(String referenceName, Object tfsOrjiraLinksTypes, HashMap<String, Object> linkTypes_SP_REP) {
        HashMap<String, Object> linkTypeName = new HashMap<String, Object>();
        try {
            3 T = new /* Unavailable Anonymous Inner Class!! */;
            Map reqbody = new HashMap();
            Gson gson = new Gson();
            reqbody = (Map)gson.fromJson((String)tfsOrjiraLinksTypes, T.getType());
            List linkType = (List)reqbody.get("value");
            for (Object e : linkType) {
                String referenceNameTemp = (String)((Map)e).get("referenceName");
                String TypeName = (String)((Map)e).get("name");
                if (!referenceNameTemp.equals(referenceName)) continue;
                linkTypeName.put("label", TypeName);
                linkTypeName.put("name", TypeName);
                linkTypeName.put("value", TypeName);
                linkTypeName.put("color", "#09c199");
                return linkTypeName;
            }
            if (PropertyValidator.isValid(linkTypeName)) {
                for (String string : linkTypes_SP_REP.keySet()) {
                    HashMap defaultLinkType = (HashMap)linkTypes_SP_REP.get(string);
                    if (!defaultLinkType.get("value").equals(referenceName)) continue;
                    linkTypeName.put("label", String.valueOf(defaultLinkType.get("label")));
                    linkTypeName.put("name", String.valueOf(defaultLinkType.get("label")));
                    linkTypeName.put("value", String.valueOf(defaultLinkType.get("label")));
                    linkTypeName.put("color", "#09c199");
                    return linkTypeName;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return linkTypeName;
    }

    private HashMap<String, Object> getLinkType(String type, HashMap<String, Object> linkTypes_SP_REP) {
        HashMap responce = new HashMap();
        try {
            if (PropertyValidator.isValid((Object)linkTypes_SP_REP.get(type))) {
                responce = (HashMap)linkTypes_SP_REP.get(type);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, Object> byDefaultLinkTypes() {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            HashMap<String, String> linkData = new HashMap<String, String>();
            linkData.put("label", "Depends on");
            linkData.put("name", "Depends on");
            linkData.put("value", "Depends on");
            responce.put("Dependent on", new HashMap(linkData));
            linkData = new HashMap();
            linkData.put("label", "Associated with");
            linkData.put("name", "Associated with");
            linkData.put("value", "Associated with");
            responce.put("Associated with", new HashMap(linkData));
            linkData = new HashMap();
            linkData.put("label", "Blocked By");
            linkData.put("name", "Blocked By");
            linkData.put("value", "Blocked By");
            responce.put("Blocked By", new HashMap(linkData));
            linkData = new HashMap();
            linkData.put("label", "Is blocking");
            linkData.put("name", "Is blocking");
            linkData.put("value", "Blocking");
            responce.put("Blocking", new HashMap(linkData));
            linkData = new HashMap();
            linkData.put("label", "Links to");
            linkData.put("name", "Links to");
            linkData.put("value", "Link");
            responce.put("Link", new HashMap(linkData));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, Object> processJiraOrTfsDependencies(ItemJiraDependency link, HashMap<String, Object> teamContainersMapById, HashMap<String, Container> containersMapById, HashMap<String, Team> teamMapById, HashMap<String, DBObject> stateItemsMapById, HashMap<String, DBObject> stateItemsMapByTeamContainerId, HashMap<String, Object> tfsOrjiraLinksTypes, HashMap<String, Object> linkTypes_SP_REP) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)link.getWfStatus())) {
                Status status = link.getWfStatus();
                Status cp_status = new Status();
                cp_status.setId(status.getId());
                cp_status.setTitle(status.getTitle());
                cp_status.setCategory(status.getCategory());
                link.setWfStatus(cp_status);
            }
            HashMap<String, Object> linkDataByAttribute = new HashMap<String, Object>();
            HashMap linkItems = new HashMap();
            linkItems = link.getIsTFS() != false ? this.checkTFSDependencyDirection(link, stateItemsMapById) : this.checkJiraDependencyDirection(link, stateItemsMapById);
            DBObject linkSourceItem = stateItemsMapById.get(String.valueOf(link.getSourceItemId()));
            DBObject linkTargetItem = stateItemsMapById.get(String.valueOf(link.getTargetItemId()));
            if (PropertyValidator.isValid((Object)linkItems)) {
                linkSourceItem = (DBObject)linkItems.get("linkSourceItem");
                linkTargetItem = (DBObject)linkItems.get("linkTargetItem");
            }
            if (PropertyValidator.isValid((Object)linkSourceItem) && PropertyValidator.isValid((Object)linkTargetItem) && PropertyValidator.isValid((Object)linkSourceItem.get("teamContainers")) && PropertyValidator.isValid((Object)linkTargetItem.get("teamContainers"))) {
                TeamContainer maxSourceTeamContainer = this.maxTeamContainerSequence((List)linkSourceItem.get("teamContainers"), teamContainersMapById);
                TeamContainer maxTargetTeamContainer = this.maxTeamContainerSequence((List)linkTargetItem.get("teamContainers"), teamContainersMapById);
                if (PropertyValidator.isValid((Object)maxSourceTeamContainer) && PropertyValidator.isValid((Object)maxTargetTeamContainer)) {
                    Container sourceContainer = containersMapById.get(maxSourceTeamContainer.getContainer().getId());
                    Container targetContainer = containersMapById.get(maxTargetTeamContainer.getContainer().getId());
                    Team sourceTeam = teamMapById.get(maxSourceTeamContainer.getTeam().getId());
                    Team targetTeam = teamMapById.get(maxTargetTeamContainer.getTeam().getId());
                    linkDataByAttribute.put("createdBy", link.getCreatedBy());
                    linkDataByAttribute.put("createdOn", link.getCreatedOn());
                    linkDataByAttribute.put("description", link.getDescription());
                    linkDataByAttribute.put("duplicateOfId", link.getDuplicateOfId());
                    linkDataByAttribute.put("dueDate", link.getDueDate());
                    linkDataByAttribute.put("eventType", link.getEventType());
                    linkDataByAttribute.put("generatedId", link.getGeneratedId());
                    linkDataByAttribute.put("id", link.getId());
                    if (link.getOriginItemId() != null) {
                        linkDataByAttribute.put("parentId", String.valueOf(link.getOriginItemId()));
                    } else {
                        linkDataByAttribute.put("parentId", String.valueOf(link.getId()));
                    }
                    if (PropertyValidator.isValid((Object)link.getWfStatus())) {
                        linkDataByAttribute.put("wfStatus", link.getWfStatus());
                        linkDataByAttribute.put("status", link.getStatus());
                    } else if (PropertyValidator.isValid((Object)link.getStatus())) {
                        linkDataByAttribute.put("status", link.getStatus());
                    } else {
                        linkDataByAttribute.put("status", "Open");
                    }
                    linkDataByAttribute.put("linkType", link.getType());
                    linkDataByAttribute.put("oldSate", link.getOldSate());
                    linkDataByAttribute.put("originItemId", link.getOriginItemId());
                    linkDataByAttribute.put("raisedOn", link.getRaisedOn());
                    linkDataByAttribute.put("resolvedOn", link.getResolvedOn());
                    linkDataByAttribute.put("rowStatus", link.getRowStatus());
                    linkDataByAttribute.put("sessionBoardId", link.getSessionBoardId());
                    linkDataByAttribute.put("source", link.getSource());
                    linkDataByAttribute.put("sourceItemId", link.getSourceItemId());
                    linkDataByAttribute.put("sourceItem", linkSourceItem);
                    linkDataByAttribute.put("sourceSprint", sourceContainer);
                    linkDataByAttribute.put("sourceTeam", sourceTeam);
                    HashMap<String, Object> sourceSprint = new HashMap<String, Object>();
                    if (sourceContainer != null) {
                        sourceSprint.put("id", sourceContainer.getId());
                        sourceSprint.put("title", sourceContainer.getTitle());
                        sourceSprint.put("label", sourceContainer.getLabel());
                        sourceSprint.put("isIPSprint", sourceContainer.getIsIPSprint());
                        sourceSprint.put("endDate", sourceContainer.getEndDate());
                        sourceSprint.put("startDate", sourceContainer.getStartDate());
                    }
                    HashMap<String, String> sourceTeamDetailsMap = new HashMap<String, String>();
                    if (sourceTeam != null) {
                        sourceTeamDetailsMap.put("color", sourceTeam.getColor());
                        sourceTeamDetailsMap.put("id", sourceTeam.getId());
                        sourceTeamDetailsMap.put("label", sourceTeam.getLabel());
                        sourceTeamDetailsMap.put("title", sourceTeam.getTitle());
                    }
                    HashMap<String, Object> sourceTCMap = new HashMap<String, Object>();
                    sourceTCMap.put("container", sourceSprint);
                    sourceTCMap.put("id", "NA");
                    if (maxSourceTeamContainer != null) {
                        sourceTCMap.put("id", maxSourceTeamContainer.getId());
                    }
                    sourceTCMap.put("team", sourceTeamDetailsMap);
                    linkDataByAttribute.put("sourceTC", sourceTCMap);
                    linkDataByAttribute.put("sourceTeamContainerId", maxSourceTeamContainer.getId());
                    linkDataByAttribute.put("sourceTFSItem", link.getSourceTFSItem());
                    linkDataByAttribute.put("targetItemId", link.getTargetItemId());
                    linkDataByAttribute.put("targetItem", linkTargetItem);
                    linkDataByAttribute.put("targetSprint", targetContainer);
                    linkDataByAttribute.put("targetTeam", targetTeam);
                    HashMap<String, Object> targeteSprint = new HashMap<String, Object>();
                    if (targetContainer != null) {
                        targeteSprint.put("id", targetContainer.getId());
                        targeteSprint.put("title", targetContainer.getTitle());
                        targeteSprint.put("label", targetContainer.getLabel());
                        targeteSprint.put("isIPSprint", targetContainer.getIsIPSprint());
                        targeteSprint.put("endDate", targetContainer.getEndDate());
                        targeteSprint.put("startDate", targetContainer.getStartDate());
                    }
                    HashMap<String, String> targetTeamDetailsMap = new HashMap<String, String>();
                    if (targetTeam != null) {
                        targetTeamDetailsMap.put("color", targetTeam.getColor());
                        targetTeamDetailsMap.put("id", targetTeam.getId());
                        targetTeamDetailsMap.put("label", targetTeam.getLabel());
                        targetTeamDetailsMap.put("title", targetTeam.getTitle());
                    }
                    HashMap<String, Object> targetTCMap = new HashMap<String, Object>();
                    targetTCMap.put("container", targeteSprint);
                    if (maxTargetTeamContainer != null) {
                        targetTCMap.put("id", maxTargetTeamContainer.getId());
                    }
                    targetTCMap.put("team", targetTeamDetailsMap);
                    linkDataByAttribute.put("targetTC", targetTCMap);
                    linkDataByAttribute.put("targetTeamContainerId", maxTargetTeamContainer.getId());
                    linkDataByAttribute.put("type", link.getType());
                    linkDataByAttribute.put("updatedBy", link.getUpdatedBy());
                    linkDataByAttribute.put("updatedOn", link.getUpdatedOn());
                    linkDataByAttribute.put("targetTFSItem", link.getTargetTFSItem());
                    linkDataByAttribute.put("conversations", link.getConversations());
                    linkDataByAttribute.put("createdOn", link.getCreatedOn());
                    linkDataByAttribute.put("isTFS", link.getIsTFS());
                    linkDataByAttribute.put("raisedOn", link.getRaisedOn());
                    linkDataByAttribute.put("link", link);
                    linkDataByAttribute.put("updatedBy", link.getUpdatedBy());
                    linkDataByAttribute.put("updatedOn", link.getUpdatedOn());
                    linkDataByAttribute.put("watcherList", link.getWatcherList());
                    linkDataByAttribute.put("lineDirection", link.getLineDirection());
                    linkDataByAttribute.put("lineDirectionSaveAs", link.getLineDirectionSaveAs());
                    HashMap linkType = new HashMap();
                    if (PropertyValidator.isValid((Object)tfsOrjiraLinksTypes.get("tfsLinksTypes"))) {
                        linkType = this.getTfsLinkTypeName(link.getTfsLinkType(), tfsOrjiraLinksTypes.get("tfsLinksTypes"), linkTypes_SP_REP);
                    }
                    if (PropertyValidator.isValid((Object)link.getTfsLinkType()) && PropertyValidator.isValid(linkType)) {
                        linkDataByAttribute.put("type", linkType.get("value"));
                        linkDataByAttribute.put("linkType", linkType);
                        linkDataByAttribute.put("tfsLinkType", link.getTfsLinkType());
                        linkDataByAttribute.put("isTfsDep", true);
                    } else if (link.getType() == null && PropertyValidator.isValid((Object)link.getLinkType())) {
                        linkDataByAttribute.put("type", String.valueOf(link.getLinkType().getInward()));
                        if (link.getDirection().equals("")) {
                            linkDataByAttribute.put("type", String.valueOf(link.getLinkType().getName()));
                        }
                        linkDataByAttribute.put("isJiraDep", true);
                        if (link.getDirection().equals("IN")) {
                            linkType.put("label", String.valueOf(link.getLinkType().getInward()));
                            linkType.put("name", String.valueOf(link.getLinkType().getInward()));
                            linkType.put("value", String.valueOf(link.getLinkType().getInward()));
                            linkType.put("color", "#09c199");
                        } else if (link.getDirection().equals("OUT")) {
                            linkType.put("label", String.valueOf(link.getLinkType().getOutward()));
                            linkType.put("name", String.valueOf(link.getLinkType().getOutward()));
                            linkType.put("value", String.valueOf(link.getLinkType().getOutward()));
                            linkType.put("color", "#09c199");
                        } else {
                            linkType.put("label", String.valueOf(link.getLinkType().getName()));
                            linkType.put("name", String.valueOf(link.getLinkType().getName()));
                            linkType.put("value", String.valueOf(link.getLinkType().getName()));
                            linkType.put("color", "#09c199");
                        }
                        linkDataByAttribute.put("linkType", linkType);
                    } else {
                        linkDataByAttribute.put("type", link.getType());
                        linkDataByAttribute.put("linkType", this.getLinkType(link.getType(), linkTypes_SP_REP));
                    }
                    linkDataByAttribute.put("direction", link.getDirection());
                    responce.put("linkDataByAttribute", linkDataByAttribute);
                    responce.put("sourceTeamId", sourceTeam);
                    responce.put("targetTeamId", targetTeam);
                    responce.put("targetContainer", targetContainer);
                    responce.put("sourceContainer", sourceContainer);
                }
            }
            return responce;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return responce;
        }
    }

    private HashMap<String, Object> getTeamOrBoardDependencies(SessionBoard sessionBoard, ArrayList<String> linksIds, ArrayList<String> jiraDependenciesLinksIds, String teamOrBoardDepndencyFlag, HashMap<String, DBObject> stateItemsMapById, HashMap<String, DBObject> stateItemsMapByTeamContainerId) {
        try {
            if (sessionBoard != null) {
                List allItemsLinksInCurrentState = this.itemLinkRepository.findByIdIn(linksIds);
                List allItemsJiraLinksInCurrentState = this.itemJiraDependencyRepository.findByIdIn(jiraDependenciesLinksIds);
                List activeSessionTeams = sessionBoard.getTeams();
                HashMap teamMapById = new HashMap();
                HashMap currentLinksBySprintReceived = new HashMap();
                HashMap currentLinksBySprintCreater = new HashMap();
                HashMap<String, Object> currentStateLinksMapsByTeamId = new HashMap<String, Object>();
                HashMap<String, Object> boardDependency = new HashMap<String, Object>();
                if (teamOrBoardDepndencyFlag == "teamDependencies") {
                    activeSessionTeams.forEach(team -> {
                        teamMapById.put(team.getId(), team);
                        HashMap<String, Serializable> currentLinksByTeamCreated = new HashMap<String, Serializable>();
                        currentLinksByTeamCreated.put("open", new HashMap());
                        currentLinksByTeamCreated.put("resolved", new HashMap());
                        currentLinksByTeamCreated.put("currentTotal", Integer.valueOf(0));
                        currentLinksByTeamCreated.put("totalOpen", Integer.valueOf(0));
                        currentLinksByTeamCreated.put("totalResolved", Integer.valueOf(0));
                        HashMap<String, Serializable> currentLinksByTeamReceived = new HashMap<String, Serializable>();
                        currentLinksByTeamReceived.put("open", new HashMap());
                        currentLinksByTeamReceived.put("resolved", new HashMap());
                        currentLinksByTeamReceived.put("currentTotal", Integer.valueOf(0));
                        currentLinksByTeamReceived.put("totalOpen", Integer.valueOf(0));
                        currentLinksByTeamReceived.put("totalResolved", Integer.valueOf(0));
                        HashMap<String, HashMap<String, Serializable>> currentLinksBySourceandTarget = new HashMap<String, HashMap<String, Serializable>>();
                        currentLinksBySourceandTarget.put("created", currentLinksByTeamCreated);
                        currentLinksBySourceandTarget.put("received", currentLinksByTeamReceived);
                        currentStateLinksMapsByTeamId.put(team.getId(), currentLinksBySourceandTarget);
                    });
                } else {
                    activeSessionTeams.forEach(team -> teamMapById.put(team.getId(), team));
                    boardDependency.put("open", new HashMap());
                    boardDependency.put("resolved", new HashMap());
                    boardDependency.put("currentTotal", 0);
                    boardDependency.put("totalOpen", 0);
                    boardDependency.put("totalResolved", 0);
                }
                List activeSessionContainers = sessionBoard.getContainers();
                List activeSessionTeamContainers = this.teamContainerRepository.findByContainerIn(activeSessionContainers);
                HashMap containersMapById = new HashMap();
                activeSessionContainers.forEach(conatainer -> containersMapById.put(String.valueOf(conatainer.getId()), conatainer));
                HashMap teamContainersMapById = new HashMap();
                activeSessionTeamContainers.forEach(teamConatainer -> teamContainersMapById.put(String.valueOf(teamConatainer.getId()), teamConatainer));
                HashMap<String, String> checkDuplictaeDep = new HashMap<String, String>();
                for (ItemLink link : allItemsLinksInCurrentState) {
                    Object processedDependencies;
                    if (PropertyValidator.isValid((Object)link.getSourceTfsId()) && PropertyValidator.isValid((Object)link.getTargetTfsId())) {
                        String buildId = link.getSourceTfsId() + "-" + link.getTargetTfsId();
                        checkDuplictaeDep.put(buildId, buildId);
                    }
                    if (PropertyValidator.isValid((Object)link.getAlmLinkId())) {
                        checkDuplictaeDep.put(String.valueOf(link.getAlmLinkId()), link.getAlmLinkId());
                    }
                    if (!PropertyValidator.isValid((Object)(processedDependencies = this.processKendisDependencies(link, teamContainersMapById, containersMapById, teamMapById, (HashMap)stateItemsMapById.clone(), stateItemsMapByTeamContainerId))) || !PropertyValidator.isValid(((HashMap)processedDependencies).get("linkDataByAttribute"))) continue;
                    ((HashMap)processedDependencies).put("teamOrBoardDepndencyFlag", teamOrBoardDepndencyFlag);
                    ((HashMap)processedDependencies).put("currentStateLinksMapsByTeamId", currentStateLinksMapsByTeamId);
                    ((HashMap)processedDependencies).put("currentLinksBySprintReceived", currentLinksBySprintReceived);
                    ((HashMap)processedDependencies).put("currentLinksBySprintCreater", currentLinksBySprintCreater);
                    ((HashMap)processedDependencies).put("boardDependency", boardDependency);
                    this.putDependenciesData((HashMap)processedDependencies);
                }
                HashMap<String, Object> tfsOrjiraLinksTypes = new HashMap<String, Object>();
                if (sessionBoard.getSession().getAlmConfigurations() != null && sessionBoard.getSession().getAlmConfigurations().size() > 0) {
                    tfsOrjiraLinksTypes.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount(), false));
                } else if (sessionBoard.getSession().getTfsAlmConfigurations() != null && sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount() != null) {
                    JiraAlmAccountMeta accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getId());
                    tfsOrjiraLinksTypes.put("tfsLinksTypes", accountMeta.getIssueLinkTypes());
                }
                HashMap linkTypes_SP_REP = this.byDefaultLinkTypes();
                for (ItemJiraDependency link : allItemsJiraLinksInCurrentState) {
                    HashMap processedDependencies;
                    String buildJiraDependencyIdOneSide = "";
                    String buildJiraDependencyIdOtherSide = "";
                    boolean checkDuplicateFlag = true;
                    if (link.getJiraDependencyId() == null && PropertyValidator.isValid((Object)link.getSourceTFSItem()) && PropertyValidator.isValid((Object)link.getSourceTFSItem().getTfsId()) && PropertyValidator.isValid((Object)link.getTargetTFSItem()) && PropertyValidator.isValid((Object)link.getTargetTFSItem().getTfsId())) {
                        buildJiraDependencyIdOneSide = link.getSourceTFSItem().getTfsId() + "-" + link.getTargetTFSItem().getTfsId();
                        buildJiraDependencyIdOtherSide = link.getTargetTFSItem().getTfsId() + "-" + link.getSourceTFSItem().getTfsId();
                        if (PropertyValidator.isValid((Object)buildJiraDependencyIdOneSide) && PropertyValidator.isValid(checkDuplictaeDep.get(buildJiraDependencyIdOneSide))) {
                            checkDuplicateFlag = false;
                        }
                        if (PropertyValidator.isValid((Object)buildJiraDependencyIdOtherSide) && PropertyValidator.isValid(checkDuplictaeDep.get(buildJiraDependencyIdOtherSide))) {
                            checkDuplicateFlag = false;
                        }
                    }
                    if ((link.getJiraDependencyId() != null || !checkDuplicateFlag) && (link.getJiraDependencyId() == null || PropertyValidator.isValid(checkDuplictaeDep.get(link.getJiraDependencyId()))) || !PropertyValidator.isValid((Object)(processedDependencies = this.processJiraOrTfsDependencies(link, teamContainersMapById, containersMapById, teamMapById, stateItemsMapById, stateItemsMapByTeamContainerId, tfsOrjiraLinksTypes, linkTypes_SP_REP))) || !PropertyValidator.isValid(processedDependencies.get("linkDataByAttribute"))) continue;
                    if (link.getJiraDependencyId() != null) {
                        checkDuplictaeDep.put(link.getJiraDependencyId().toString(), link.getJiraDependencyId());
                    }
                    if (PropertyValidator.isValid((Object)buildJiraDependencyIdOneSide)) {
                        checkDuplictaeDep.put(buildJiraDependencyIdOneSide, buildJiraDependencyIdOneSide);
                    }
                    if (PropertyValidator.isValid((Object)buildJiraDependencyIdOtherSide)) {
                        checkDuplictaeDep.put(buildJiraDependencyIdOtherSide, buildJiraDependencyIdOtherSide);
                    }
                    processedDependencies.put("teamOrBoardDepndencyFlag", teamOrBoardDepndencyFlag);
                    processedDependencies.put("currentStateLinksMapsByTeamId", currentStateLinksMapsByTeamId);
                    processedDependencies.put("currentLinksBySprintReceived", currentLinksBySprintReceived);
                    processedDependencies.put("currentLinksBySprintCreater", currentLinksBySprintCreater);
                    processedDependencies.put("boardDependency", boardDependency);
                    this.putDependenciesData(processedDependencies);
                }
                if (teamOrBoardDepndencyFlag == "teamDependencies") {
                    return currentStateLinksMapsByTeamId;
                }
                if (teamOrBoardDepndencyFlag == "sprintDependencies") {
                    HashMap<String, Object> sprintDependenciesResponceMap = new HashMap<String, Object>();
                    sprintDependenciesResponceMap.put("currentLinksBySprintReceived", currentLinksBySprintReceived);
                    sprintDependenciesResponceMap.put("currentLinksBySprintCreater", currentLinksBySprintCreater);
                    return sprintDependenciesResponceMap;
                }
                return boardDependency;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public HashMap<String, Object> getItems(String requestStr) {
        HashMap<String, Object> responseJson;
        block13: {
            responseJson = new HashMap<String, Object>();
            try {
                Gson g = new Gson();
                4 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
                String board = (String)reqbody.get("selectedBoards");
                String cartType = (String)reqbody.get("selectedCartType");
                String sessionId = (String)reqbody.get("sessionId");
                String inspectAndAdaptSession = (String)reqbody.get("inspectAndAdaptSessionDateTime");
                String filePath = null;
                filePath = "InspectAndAdaptData_" + sessionId + ".txt";
                File tempFile = new File(this.env.getProperty("temp.file.location") + filePath);
                boolean exists = tempFile.exists();
                if (board != null) {
                    ObjectMapper map = new ObjectMapper();
                    5 S = new /* Unavailable Anonymous Inner Class!! */;
                    String sessionObject = (String)g.fromJson(sessionId, S.getType());
                    Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionObject));
                    6 inspectAndAdaptBoardsType = new /* Unavailable Anonymous Inner Class!! */;
                    ArrayList selectedBoards = (ArrayList)g.fromJson(board, inspectAndAdaptBoardsType.getType());
                    session.setInspectAndAdaptBoards((List)selectedBoards);
                    session.setInspectAndAdaptSessionDateTime(inspectAndAdaptSession);
                    List selectedCartType = null;
                    try {
                        selectedCartType = (List)map.readValue(cartType, (JavaType)map.getTypeFactory().constructCollectionType(List.class, IssueType.class));
                    }
                    catch (IOException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    ArrayList<String> cartTypeIds = new ArrayList<String>();
                    for (IssueType cartTypeId : selectedCartType) {
                        cartTypeIds.add(cartTypeId.getId());
                    }
                    session.setCartTypeIds(cartTypeIds);
                    this.sessionRepository.save((Object)session);
                    List allSessionBoards = this.getAllAccessableBoards();
                    ArrayList<ObjectId> selectedSessionBoardsIds = new ArrayList<ObjectId>();
                    ArrayList<String> allActiveSessionBoardIds = new ArrayList<String>();
                    ArrayList<ObjectId> allActiveSessionBoardObjectIds = new ArrayList<ObjectId>();
                    ArrayList<String> allSessionBoardIds = new ArrayList<String>();
                    ArrayList<String> worflowsIds = new ArrayList<String>();
                    for (int i = 0; i < selectedBoards.size(); ++i) {
                        ObjectId obj = new ObjectId(String.valueOf(((Map)selectedBoards.get(i)).get("id")));
                        selectedSessionBoardsIds.add(obj);
                    }
                    List selectedSessionBoards = this.getSessionsByIds(selectedSessionBoardsIds);
                    HashMap<String, String> allSessionidsMapBySessionBoardIds = new HashMap<String, String>();
                    for (int i = 0; i < selectedSessionBoards.size(); ++i) {
                        allActiveSessionBoardIds.add(String.valueOf(((DBObject)selectedSessionBoards.get(i)).get("activeSessionBoard")));
                        allSessionidsMapBySessionBoardIds.put(String.valueOf(((DBObject)selectedSessionBoards.get(i)).get("activeSessionBoard")), String.valueOf(((DBObject)selectedSessionBoards.get(i)).get("_id")));
                        ObjectId obj = new ObjectId(String.valueOf(((DBObject)selectedSessionBoards.get(i)).get("activeSessionBoard")));
                        allActiveSessionBoardObjectIds.add(obj);
                    }
                    for (DBObject piSession : allSessionBoards) {
                        allSessionBoardIds.add(String.valueOf(piSession.get("_id")));
                        DBRef itemWorkFlowId = (DBRef)piSession.get("itemWorkFlow");
                        worflowsIds.add(String.valueOf(itemWorkFlowId.getId()));
                        DBRef subItemWorkFlowId = (DBRef)piSession.get("subItemWorkFlow");
                        worflowsIds.add(String.valueOf(subItemWorkFlowId.getId()));
                    }
                    List sessionWorkflows = this.workFlowRepository.findBySessionIdIn(allSessionBoardIds);
                    sessionWorkflows.forEach(wf -> worflowsIds.add(wf.getId()));
                    HashMap statusMapById = new HashMap();
                    List allStatuses = this.statusRepository.findBySessionIdIn(allSessionBoardIds);
                    if (allStatuses != null) {
                        allStatuses.forEach(status -> statusMapById.put(status.getId(), status));
                    }
                    if ((allStatuses = this.statusRepository.findByWorkFlowIdIn(worflowsIds)) != null) {
                        allStatuses.forEach(status -> statusMapById.put(status.getId(), status));
                    }
                    List allActiveSessionBoards = this.sessionBoardRepository.findByIdIn(allActiveSessionBoardIds);
                    List rawItems = this.getItemsForDIfferentBoards(allActiveSessionBoardObjectIds);
                    responseJson.put("scopeChangeAndDependencyData", this.boardScopChangeData(allActiveSessionBoards, selectedCartType, allSessionidsMapBySessionBoardIds));
                    responseJson.put("planedUnPlanedData", this.itemsDataByStatus(rawItems, statusMapById, allSessionidsMapBySessionBoardIds));
                    responseJson.put("reportTimeAndDate", new Date());
                    ObjectMapper mapper = new ObjectMapper();
                    FileOutputStream fileStream = new FileOutputStream(new File(this.env.getProperty("temp.file.location") + filePath));
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
                    writer.write(mapper.writeValueAsString(responseJson));
                    writer.close();
                    fileStream.close();
                    break block13;
                }
                if (exists) {
                    File myObj = new File(this.env.getProperty("temp.file.location") + filePath);
                    Scanner myReader = new Scanner(myObj);
                    while (myReader.hasNextLine()) {
                        String data = myReader.nextLine();
                        responseJson.put("stringData", data);
                    }
                    myReader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return responseJson;
    }

    public HashMap<String, Object> getSelectedBoards(Map<String, String> requestStr) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String sessionId = requestStr.get("sessionId");
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            List inspectAndAdaptBoards = session.getInspectAndAdaptBoards();
            String inspectAndAdaptSessionDate = session.getInspectAndAdaptSessionDateTime();
            ArrayList<ObjectId> inspectAndAdaptSelectedBoardIds = new ArrayList<ObjectId>();
            if (inspectAndAdaptBoards != null) {
                for (int i = 0; i < inspectAndAdaptBoards.size(); ++i) {
                    inspectAndAdaptSelectedBoardIds.add(new ObjectId(String.valueOf(((Map)inspectAndAdaptBoards.get(i)).get("id"))));
                }
            }
            List allSessionBoards = this.getSessionsByIds(inspectAndAdaptSelectedBoardIds);
            ArrayList<String> allActiveSessionBoardIds = new ArrayList<String>();
            HashMap<String, String> allActiveSessionBoardsMapBySessionIds = new HashMap<String, String>();
            for (DBObject piSession : allSessionBoards) {
                allActiveSessionBoardIds.add(String.valueOf(piSession.get("activeSessionBoard")));
                allActiveSessionBoardsMapBySessionIds.put(String.valueOf(piSession.get("activeSessionBoard")), String.valueOf(piSession.get("_id")));
            }
            List allActiveSessionBoards = this.sessionBoardRepository.findByIdIn(allActiveSessionBoardIds);
            HashMap allActiveSessionBoardsCurrentStates = new HashMap();
            for (SessionBoard activeSessionBoard : allActiveSessionBoards) {
                allActiveSessionBoardsCurrentStates.put(allActiveSessionBoardsMapBySessionIds.get(activeSessionBoard.getId()), activeSessionBoard.getState().getTitle());
            }
            responseJson.put("selectedCartTypes", session.getCartTypeIds());
            responseJson.put("selectedBoards", inspectAndAdaptBoards);
            responseJson.put("selectedBoardsStateById", allActiveSessionBoardsCurrentStates);
            if (PropertyValidator.isValid((Object)inspectAndAdaptSessionDate)) {
                responseJson.put("inspectAndAdaptSessionDate", inspectAndAdaptSessionDate);
            } else {
                responseJson.put("inspectAndAdaptSessionDate", "-1");
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responseJson;
    }

    private void calculationForNoItemSprintInSelectedTeam(HashMap<String, Object> sprintDetailsMapByIds, List<Container> activeSessionContainers) {
        activeSessionContainers.forEach(container -> {
            if (sprintDetailsMapByIds.get(String.valueOf(container.getId())) == null) {
                HashMap<String, Object> sprintDetail = new HashMap<String, Object>();
                sprintDetail.put("containerName", container.getTitle());
                sprintDetail.put("containerId", String.valueOf(container.getId()));
                sprintDetail.put("containerLabel", container.getLabel());
                sprintDetail.put("containerOriginItemId", container.getOriginItemId());
                sprintDetail.put("totalFeatureCount", 0);
                sprintDetail.put("toDoFeatureCount", 0);
                sprintDetail.put("inProgressFeatureCount", 0);
                sprintDetail.put("doneFeatureCount", 0);
                sprintDetail.put("miscFeatureCount", 0);
                sprintDetail.put("totalStoryCount", 0);
                sprintDetail.put("toDoStoryCount", 0);
                sprintDetail.put("inProgressStoryCount", 0);
                sprintDetail.put("doneStoryCount", 0);
                sprintDetail.put("miscStoryCount", 0);
                sprintDetail.put("storyPointCount", 0);
                sprintDetail.put("doneStoryPointCount", 0);
                sprintDetail.put("toDoStoryPointCount", 0);
                sprintDetail.put("inProgressStoryPointCount", 0);
                sprintDetail.put("miscStoryPointCount", 0);
                sprintDetailsMapByIds.put(String.valueOf(container.getId()), sprintDetail);
            }
        });
    }

    private void storeItemsKendisAndJiraDependencies(DBObject rawItem, ArrayList<String> curentStateItemsLinks, ArrayList<String> curentStatejiraDependencies) {
        List jiraDependencies;
        DBRef linksRef;
        int k;
        List itemLinks;
        if (rawItem.get("itemLinks") != null && (itemLinks = (List)rawItem.get("itemLinks")).size() > 0) {
            List itemLinksRef = (List)rawItem.get("itemLinks");
            for (k = 0; k < itemLinksRef.size(); ++k) {
                linksRef = (DBRef)itemLinksRef.get(k);
                curentStateItemsLinks.add(String.valueOf(linksRef.getId()));
            }
        }
        if (rawItem.get("jiraDependencies") != null && (jiraDependencies = (List)rawItem.get("jiraDependencies")).size() > 0) {
            List jiraDependenciesRef = (List)rawItem.get("jiraDependencies");
            for (k = 0; k < jiraDependenciesRef.size(); ++k) {
                linksRef = (DBRef)jiraDependenciesRef.get(k);
                curentStatejiraDependencies.add(String.valueOf(linksRef.getId()));
            }
        }
    }

    private Boolean checkExcludeItemsStatus(DBObject rawItem, Status status, Map<String, Object> requestStr, HashMap<String, Object> includedFeaturesMap) {
        Boolean includeItemFlag = false;
        HashMap selectedFeaturesStatus = (HashMap)requestStr.get("featuresStatus");
        HashMap selectedStoryStatus = (HashMap)requestStr.get("storyStatus");
        HashMap featuresIssueType = (HashMap)requestStr.get("featuresIssueType");
        HashMap storyIssueType = (HashMap)requestStr.get("storyIssueType");
        try {
            if (rawItem.get("type").equals(Item.USER_STORY)) {
                if ((!PropertyValidator.isValid((Object)rawItem.get("tfsItemType")) && !PropertyValidator.isValid((Object)rawItem.get("jiraIssueTypeId")) || !PropertyValidator.isValid((Object)storyIssueType) || PropertyValidator.isValid((Object)rawItem.get("jiraIssueTypeId")) && !PropertyValidator.isValid(storyIssueType.get(rawItem.get("jiraIssueTypeId"))) || PropertyValidator.isValid((Object)rawItem.get("tfsItemType")) && !PropertyValidator.isValid(storyIssueType.get(rawItem.get("tfsItemType")))) && (!PropertyValidator.isValid((Object)selectedStoryStatus) || PropertyValidator.isValid((Object)status) && !PropertyValidator.isValid(selectedStoryStatus.get(status.getTitle())))) {
                    return rawItem.get("parent") == null || includedFeaturesMap.containsKey(((DBRef)rawItem.get("parent")).getId().toString());
                }
            } else if (rawItem.get("type").equals(Item.FEATURE)) {
                if ((!PropertyValidator.isValid((Object)rawItem.get("tfsItemType")) && !PropertyValidator.isValid((Object)rawItem.get("jiraIssueTypeId")) || !PropertyValidator.isValid((Object)featuresIssueType) || PropertyValidator.isValid((Object)rawItem.get("jiraIssueTypeId")) && !PropertyValidator.isValid(featuresIssueType.get(rawItem.get("jiraIssueTypeId"))) || PropertyValidator.isValid((Object)rawItem.get("tfsItemType")) && !PropertyValidator.isValid(featuresIssueType.get(rawItem.get("tfsItemType")))) && (!PropertyValidator.isValid((Object)selectedFeaturesStatus) || PropertyValidator.isValid((Object)status) && !PropertyValidator.isValid(selectedFeaturesStatus.get(status.getTitle())))) {
                    includeItemFlag = true;
                    includedFeaturesMap.put(rawItem.get("_id").toString(), rawItem);
                }
                return includeItemFlag;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return includeItemFlag;
    }

    private ArrayList<Object> filterCartTypes(HashMap<String, String> issueTypeMapByIdForUserSelection, ArrayList<Object> cardTypeList) {
        ArrayList<Object> response = new ArrayList<Object>();
        try {
            HashMap<String, String> copyOfCartTypeMap = new HashMap<String, String>(issueTypeMapByIdForUserSelection);
            if (PropertyValidator.isValid(cardTypeList)) {
                for (int i = 0; i < cardTypeList.size(); ++i) {
                    HashMap cartType = (HashMap)cardTypeList.get(i);
                    if (!PropertyValidator.isValid((Object)copyOfCartTypeMap.get(cartType.get("id")))) continue;
                    copyOfCartTypeMap.remove(cartType.get("id"));
                }
            }
            if (PropertyValidator.isValid(copyOfCartTypeMap.keySet())) {
                for (String key : copyOfCartTypeMap.keySet()) {
                    HashMap<String, String> temporaryMapToSaveData = new HashMap<String, String>();
                    temporaryMapToSaveData.put("id", key);
                    temporaryMapToSaveData.put("title", copyOfCartTypeMap.get(key));
                    response.add(temporaryMapToSaveData);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    private HashMap<String, Object> getExcludedItemsCalculation(Session session, HashMap<String, String> issueTypeMapByIdForUserSelection) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("cardType", new ArrayList());
        response.put("featuresStatus", new HashMap());
        response.put("storyStatus", new HashMap());
        response.put("featuresIssueType", new HashMap());
        response.put("storyIssueType", new HashMap());
        try {
            HashMap<String, String> statsExclusionMap = new HashMap<String, String>();
            statsExclusionMap.put("sessionId", session.getId().toString());
            statsExclusionMap.put("viewType", EnumKendis.ALANYTICS_EXCLUDEITEMS_VIEWTYPE.getCode());
            HashMap excludedFilterData = this.planService.fetchExcludedItems(statsExclusionMap);
            StatsExclusion statsExclusion = (StatsExclusion)excludedFilterData.get("statsExclusion");
            if (PropertyValidator.isValid((Object)statsExclusion) && PropertyValidator.isValid(statsExclusion.getExcludedItems().get("cardType"))) {
                response.put("cardType", statsExclusion.getExcludedItems().get("cardType"));
                response.put("featuresStatus", statsExclusion.getExcludedItems().get("featuresStatus"));
                response.put("storyStatus", statsExclusion.getExcludedItems().get("storyStatus"));
                response.put("featuresIssueType", statsExclusion.getExcludedItems().get("featuresIssueType"));
                response.put("storyIssueType", statsExclusion.getExcludedItems().get("storyIssueType"));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    public HashMap<String, Object> getPiReport(String sessionId, Map<String, Object> requestStr) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            HashMap dataFlags = (HashMap)requestStr.get("flagsForDataRequire");
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            String currentSessionBoardId = (String)requestStr.get("currentSessionBoardId");
            SessionBoard activeSessionBoard = null;
            activeSessionBoard = currentSessionBoardId != null && !currentSessionBoardId.equals(session.getActiveSessionBoard()) ? (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)currentSessionBoardId)) : (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
            response.put("SessionBoard", activeSessionBoard);
            String activeSessionBoardTitle = activeSessionBoard.getState().getTitle();
            HashMap featureMapById = new HashMap();
            HashMap previousStateFeatureMapById = new HashMap();
            HashMap getBoardPreviousStateMap = this.getBoardPreviousState(activeSessionBoard, session);
            State prevState = (State)getBoardPreviousStateMap.get("prevState");
            SessionBoard prevSessionBoard = (SessionBoard)getBoardPreviousStateMap.get("prevSessionBoard");
            ArrayList sessionBoards = (ArrayList)getBoardPreviousStateMap.get("sessionBoards");
            String previousSessionBoardTitle = null;
            if (prevSessionBoard != null) {
                previousSessionBoardTitle = prevSessionBoard.getState().getTitle();
            }
            HashMap getBoardAllStatusesMap = this.getBoardAllStatuses(session);
            HashMap statusMapById = (HashMap)getBoardAllStatusesMap.get("statusMapById");
            HashMap issueTypeMapByIdForUserSelection = this.getIssueTypeOfTheBoard(session);
            HashMap getSprintAndTeamsMapData = this.getSprintAndTeamsMap(activeSessionBoard, prevSessionBoard);
            HashMap containerMapById = (HashMap)getSprintAndTeamsMapData.get("containerMapById");
            HashMap teamMapById = (HashMap)getSprintAndTeamsMapData.get("teamMapById");
            HashMap teamItemById = (HashMap)getSprintAndTeamsMapData.get("teamItemById");
            List activeSessionContainers = (List)getSprintAndTeamsMapData.get("activeSessionContainers");
            List activeSessionTeams = (List)getSprintAndTeamsMapData.get("activeSessionTeams");
            List previousStateItems = null;
            List previousStateItemsWithUserSelectedCartType = null;
            List rawItems = null;
            HashMap statsExclusionData = new HashMap();
            ArrayList userSelectedCartType = new ArrayList();
            if (!PropertyValidator.isValid(dataFlags.get("notFeatchExcludeItemData"))) {
                statsExclusionData = this.getExcludedItemsCalculation(session, issueTypeMapByIdForUserSelection);
                userSelectedCartType = this.filterCartTypes(issueTypeMapByIdForUserSelection, (ArrayList)statsExclusionData.get("cardType"));
            }
            if (dataFlags.get("callFromAnalyticsFlag") != null && userSelectedCartType.size() > 0) {
                HashMap<String, Object> functionParametersForFetchDataOnCartType = new HashMap<String, Object>();
                functionParametersForFetchDataOnCartType.put("sessionBoards", sessionBoards);
                functionParametersForFetchDataOnCartType.put("requestStr", userSelectedCartType);
                functionParametersForFetchDataOnCartType.put("prevState", prevState);
                functionParametersForFetchDataOnCartType.put("tenant", session.getTenant());
                HashMap rawItemsOfBothState = this.featchDataOnTheBaseOfUserSelectedCartType(functionParametersForFetchDataOnCartType);
                rawItems = (List)rawItemsOfBothState.get("rawItems");
                previousStateItemsWithUserSelectedCartType = (List)rawItemsOfBothState.get("previousStateItems");
            }
            HashMap unplannedFeatures = new HashMap();
            HashMap unplannedStories = new HashMap();
            HashMap unplannedData = new HashMap();
            unplannedData.put("unplannedFeatures", unplannedFeatures);
            unplannedData.put("unplannedStories", unplannedStories);
            int totalNumberofFeatures = 0;
            int totalNumberofStories = 0;
            int backlogItemsInPlanningCount = 0;
            HashMap featureMapByStatus = new HashMap();
            HashMap storiesMayByStatus = new HashMap();
            HashMap featuresCompletion = new HashMap();
            HashMap storyCompletion = new HashMap();
            HashMap storyPointsCompletion = new HashMap();
            ArrayList storiesAddedInTracking = new ArrayList();
            ArrayList featuresAddedInTracking = new ArrayList();
            double numberOfStoryPointsAddedInTrakingState = 0.0;
            double totalNumberofStoryPoints = 0.0;
            int numberOfStoriesAddedInTrakingState = 0;
            int trackingFeaturesCount = 0;
            ArrayList featureChangeSprint = new ArrayList();
            ArrayList storyChangeSprint = new ArrayList();
            int featuresChanged = 0;
            int storiesChanged = 0;
            ArrayList curentStateItemsLinks = new ArrayList();
            ArrayList curentStatejiraDependencies = new ArrayList();
            HashMap<String, DBObject> itemsById = new HashMap<String, DBObject>();
            HashMap<String, DBObject> currentStateItemsMapByTeamContainerIdsForDependencies = new HashMap<String, DBObject>();
            HashMap itemTeamAndSprintMapByItemId = new HashMap();
            HashMap mapForCheckingNoTeamAndSprintComesDouble = new HashMap();
            HashMap previousStateItemTeamAndSprintMapByItemId = new HashMap();
            HashMap previousStateMapForCheckingNoTeamAndSprintComesDouble = new HashMap();
            ArrayList<HashMap> storiesDetailsCurrentState = new ArrayList<HashMap>();
            HashMap currentStateItemMapById = new HashMap();
            HashMap previousStateItemMapById = new HashMap();
            ArrayList storiesDetailsPreviousState = new ArrayList();
            HashSet<HashMap> featuresPresentInBacklog = new HashSet<HashMap>();
            HashMap<String, HashMap> featuresPresentInBacklogMapById = new HashMap<String, HashMap>();
            ArrayList previousStateItemsLinks = new ArrayList();
            ArrayList previousStatejiraDependencies = new ArrayList();
            HashMap changeOfStoryPointsInCurrentAndPreviousStateOfStory = new HashMap();
            HashMap<String, HashMap> teamBySprintPreviousLoad = new HashMap<String, HashMap>();
            if (rawItems == null) {
                rawItems = this.getPiReportItemsSorted((SessionBoard)sessionBoards.get(0));
            }
            if (prevState != null && previousStateItems == null) {
                previousStateItems = this.getPiReportItemsSorted((SessionBoard)sessionBoards.get(1));
                if (!PropertyValidator.isValid((Collection)previousStateItemsWithUserSelectedCartType) && !PropertyValidator.isValid((Collection)userSelectedCartType)) {
                    previousStateItemsWithUserSelectedCartType = previousStateItems;
                }
            }
            ArrayList<ObjectId> currentStateTeamContainersIds = new ArrayList<ObjectId>();
            HashMap<String, DBObject> currentStateItemsMapById = new HashMap<String, DBObject>();
            HashMap currentStateProcessedItemsMapByIds = new HashMap();
            if (rawItems != null) {
                for (DBObject rawItem : rawItems) {
                    List TeamsContainer;
                    if (rawItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)rawItem.get("storyPoints"))) {
                        rawItem.put("storyPoints", (Object)0.0);
                    }
                    rawItem.put("id", (Object)String.valueOf(rawItem.get("_id")));
                    currentStateItemsMapById.put(String.valueOf(rawItem.get("_id")), rawItem);
                    if (rawItem.get("teamContainers") == null || (TeamsContainer = (List)rawItem.get("teamContainers")).size() <= 0) continue;
                    List teamContRef = (List)rawItem.get("teamContainers");
                    for (int j = 0; j < teamContRef.size(); ++j) {
                        DBRef tcRef = (DBRef)teamContRef.get(j);
                        currentStateTeamContainersIds.add(new ObjectId(String.valueOf(tcRef.getId())));
                    }
                }
            }
            HashMap<String, DBObject> previousStateItemsMapBy_Ids_OR_OriginItemId = new HashMap<String, DBObject>();
            HashMap<String, DBObject> previousStateItemsMapByIdsOnly = new HashMap<String, DBObject>();
            ArrayList<ObjectId> previousStateTeamContainersIds = new ArrayList<ObjectId>();
            if (previousStateItems != null) {
                for (DBObject previousRawItem : previousStateItems) {
                    List TeamsContainer;
                    if (previousRawItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)previousRawItem.get("storyPoints"))) {
                        previousRawItem.put("storyPoints", (Object)0.0);
                    }
                    if (previousRawItem.get("teamContainers") != null && (TeamsContainer = (List)previousRawItem.get("teamContainers")).size() > 0) {
                        List teamContRef = (List)previousRawItem.get("teamContainers");
                        for (int j = 0; j < teamContRef.size(); ++j) {
                            DBRef tcRef = (DBRef)teamContRef.get(j);
                            previousStateTeamContainersIds.add(new ObjectId(String.valueOf(tcRef.getId())));
                        }
                    }
                    previousStateItemsMapByIdsOnly.put(String.valueOf(previousRawItem.get("_id")), previousRawItem);
                    if (previousRawItem.get("originItemId") != null) {
                        previousStateItemsMapBy_Ids_OR_OriginItemId.put(String.valueOf(previousRawItem.get("originItemId")), previousRawItem);
                        continue;
                    }
                    if (previousRawItem.get("_id") == null) continue;
                    previousStateItemsMapBy_Ids_OR_OriginItemId.put(String.valueOf(previousRawItem.get("_id")), previousRawItem);
                }
            }
            List previousStateTeamContainers = this.getTeamContainer(previousStateTeamContainersIds);
            List currentStateTeamContainers = this.getTeamContainer(currentStateTeamContainersIds);
            HashMap<String, DBObject> previousStateTeamContainersMapById = new HashMap<String, DBObject>();
            HashMap<String, DBObject> currentStateTeamContainersMapById = new HashMap<String, DBObject>();
            int sizeForTeamContainersLoop = 0;
            sizeForTeamContainersLoop = currentStateTeamContainers.size() > previousStateTeamContainers.size() ? currentStateTeamContainers.size() : previousStateTeamContainers.size();
            for (int i = 0; i < sizeForTeamContainersLoop; ++i) {
                if (previousStateTeamContainers.size() > i) {
                    DBObject previousTeamContainer = (DBObject)previousStateTeamContainers.get(i);
                    previousStateTeamContainersMapById.put(String.valueOf(previousTeamContainer.get("_id")), previousTeamContainer);
                }
                if (currentStateTeamContainers.size() <= i) continue;
                DBObject currentTeamContainer = (DBObject)currentStateTeamContainers.get(i);
                currentStateTeamContainersMapById.put(String.valueOf(currentTeamContainer.get("_id")), currentTeamContainer);
            }
            if (rawItems != null) {
                HashMap includedFeaturesMap = new HashMap();
                for (DBObject rawItem : rawItems) {
                    try {
                        String featureIdKey;
                        DBRef parentId;
                        HashMap itemkey;
                        DBRef parentId2;
                        Boolean includeItemFlag;
                        DBRef statusRef = (DBRef)rawItem.get("status");
                        Status status = null;
                        if (PropertyValidator.isValid((Object)statusRef)) {
                            String statusId = String.valueOf(statusRef.getId());
                            status = (Status)statusMapById.get(statusId);
                        }
                        if (!PropertyValidator.isValid(status)) {
                            Status newStatus = new Status();
                            newStatus.setTitle("Misc");
                            newStatus.setCategory("Misc");
                            newStatus.setColor("#7c50b1");
                            status = newStatus;
                        }
                        if (!(includeItemFlag = this.checkExcludeItemsStatus(rawItem, status, (Map)statsExclusionData, includedFeaturesMap)).booleanValue()) continue;
                        if (rawItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)rawItem.get("storyPoints"))) {
                            rawItem.put("storyPoints", (Object)0.0);
                        }
                        if (rawItem.get("type").equals(Item.USER_STORY)) {
                            ++totalNumberofStories;
                        } else if (rawItem.get("type").equals(Item.FEATURE)) {
                            ++totalNumberofFeatures;
                        }
                        if (rawItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)rawItem.get("storyPoints"))) {
                            rawItem.put("storyPoints", (Object)0.0);
                        }
                        HashMap<String, String> trimmedStatus = new HashMap<String, String>();
                        trimmedStatus.put("title", status.getTitle());
                        trimmedStatus.put("category", status.getCategory());
                        trimmedStatus.put("_id", status.getId());
                        rawItem.put("status", trimmedStatus);
                        itemsById.put(String.valueOf(rawItem.get("_id")), rawItem);
                        if (dataFlags.get("Dependencies") != null) {
                            this.storeItemsKendisAndJiraDependencies(rawItem, curentStateItemsLinks, curentStatejiraDependencies);
                        }
                        boolean checkTeamContainersExistInDB = false;
                        ArrayList<TeamContainer> currentTeamContainers = new ArrayList<TeamContainer>();
                        List TeamsContainer = (List)rawItem.get("teamContainers");
                        if (rawItem.get("teamContainers") != null && TeamsContainer.size() > 0) {
                            ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
                            List teamContRef = (List)rawItem.get("teamContainers");
                            for (int j = 0; j < teamContRef.size(); ++j) {
                                DBRef tcRef = (DBRef)teamContRef.get(j);
                                DBObject tcObject = (DBObject)currentStateTeamContainersMapById.get(String.valueOf(tcRef.getId()));
                                if (!PropertyValidator.isValid((Object)tcObject)) continue;
                                DBRef teamRef = (DBRef)tcObject.get("team");
                                DBRef containerRef = (DBRef)tcObject.get("container");
                                if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                                TeamContainer teamContainer = new TeamContainer();
                                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                                Team team2 = (Team)teamMapById.get(String.valueOf(teamRef.getId()));
                                Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                                tcs.add(new TeamContainer(team2, container));
                                rawItem.put("sprint_" + container.getId(), (Object)true);
                                if (!PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)team2)) continue;
                                teamContainer.setTeam(team2);
                                teamContainer.setContainer(container);
                                currentTeamContainers.add(teamContainer);
                                checkTeamContainersExistInDB = true;
                                currentStateItemsMapByTeamContainerIdsForDependencies.put(String.valueOf(tcObject.get("_id")), rawItem);
                                this.getItemTeamAndSprint(rawItem, team2, container, itemTeamAndSprintMapByItemId, mapForCheckingNoTeamAndSprintComesDouble, status);
                                HashMap getTeamForSprintDetailes = (HashMap)teamItemById.get(team2.getId());
                                HashMap allSprintDetailes = (HashMap)getTeamForSprintDetailes.get("sprintDetailes");
                                if (allSprintDetailes.get(String.valueOf(container.getId())) == null) {
                                    this.calculationForNoItemSprintInSelectedTeam(allSprintDetailes, activeSessionContainers);
                                }
                                HashMap getItemSprint = (HashMap)allSprintDetailes.get(String.valueOf(container.getId()));
                                this.calculationForTeamAndSprint(status, rawItem, getItemSprint);
                                if (!rawItem.get("type").equals(Item.FEATURE) || dataFlags.get("allTeamsDetailByBoardState") == null) continue;
                                this.calculationForTeamsDataByStateOfBoard("currentState", status, rawItem, teamItemById, itemTeamAndSprintMapByItemId, team2, currentStateItemMapById);
                            }
                            HashMap getItemDetailsInMap = this.putItemDetailsInMap(rawItem, itemTeamAndSprintMapByItemId, status);
                            if (rawItem.get("type").equals(Item.USER_STORY)) {
                                parentId2 = (DBRef)rawItem.get("parent");
                                if (PropertyValidator.isValid((Object)parentId2) && PropertyValidator.isValid((Object)parentId2.getId()) && currentStateItemsMapById.get(String.valueOf(parentId2.getId())) != null) {
                                    DBObject parentItem = (DBObject)currentStateItemsMapById.get(String.valueOf(parentId2.getId()));
                                    itemkey = this.getItemJirsOrTFSKey(parentItem);
                                    getItemDetailsInMap.put("parentkey", itemkey.get("key"));
                                    getItemDetailsInMap.put("parentkeyType", itemkey.get("keyType"));
                                    getItemDetailsInMap.put("parentkeyLink", itemkey.get("keyLink"));
                                    getItemDetailsInMap.put("parentDetails", parentItem.get("title"));
                                    getItemDetailsInMap.put("parentTfsId", parentItem.get("tfsId"));
                                    getItemDetailsInMap.put("parentTfsURL", parentItem.get("tfsURL"));
                                    getItemDetailsInMap.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                                    getItemDetailsInMap.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                                    getItemDetailsInMap.put("parentTfsProject", parentItem.get("tfsProject"));
                                    getItemDetailsInMap.put("parentTfsItemType", parentItem.get("tfsItemType"));
                                    getItemDetailsInMap.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                                    getItemDetailsInMap.put("parentTfsFilter", parentItem.get("tfsFilter"));
                                    getItemDetailsInMap.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                                    getItemDetailsInMap.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                                    getItemDetailsInMap.put("parentJiraKey", parentItem.get("jiraKey"));
                                    getItemDetailsInMap.put("parentJiraId", parentItem.get("jiraId"));
                                    getItemDetailsInMap.put("parentJiraFilter", parentItem.get("jiraFilter"));
                                    getItemDetailsInMap.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                                    getItemDetailsInMap.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                                }
                                storiesDetailsCurrentState.add(getItemDetailsInMap);
                            }
                            currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("_id")), new HashMap(getItemDetailsInMap));
                            if (rawItem.get("originItemId") != null) {
                                currentStateItemMapById.put(String.valueOf(rawItem.get("originItemId")), new HashMap(getItemDetailsInMap));
                                currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("originItemId")), new HashMap(getItemDetailsInMap));
                            } else if (rawItem.get("_id") != null) {
                                currentStateItemMapById.put(String.valueOf(rawItem.get("_id")), new HashMap(getItemDetailsInMap));
                            } else if (rawItem.get("duplicateOfId") != null) {
                                currentStateItemMapById.put(String.valueOf(rawItem.get("duplicateOfId")), new HashMap(getItemDetailsInMap));
                            }
                            if (prevState != null && dataFlags.get("previousStateRequire") != null) {
                                if (dataFlags.get("scopeChange") != null) {
                                    HashMap<String, Object> boardScopChangeDataForFunction = new HashMap<String, Object>();
                                    boardScopChangeDataForFunction.put("rawItem", rawItem);
                                    boardScopChangeDataForFunction.put("storiesAddedInTracking", storiesAddedInTracking);
                                    boardScopChangeDataForFunction.put("getItemDetailsInMap", new HashMap(getItemDetailsInMap));
                                    boardScopChangeDataForFunction.put("featuresAddedInTracking", featuresAddedInTracking);
                                    boardScopChangeDataForFunction.put("previousStateItemsMapBy_Ids_OR_OriginItemId", previousStateItemsMapBy_Ids_OR_OriginItemId);
                                    HashMap boardScopChangeCounts = this.getBoardScopeChangeData(boardScopChangeDataForFunction, totalNumberofStoryPoints, numberOfStoryPointsAddedInTrakingState, numberOfStoriesAddedInTrakingState, trackingFeaturesCount);
                                    totalNumberofStoryPoints = (Double)boardScopChangeCounts.get("totalNumberofStoryPoints");
                                    numberOfStoryPointsAddedInTrakingState = (Double)boardScopChangeCounts.get("numberOfStoryPointsAddedInTrakingState");
                                    numberOfStoriesAddedInTrakingState = (Integer)boardScopChangeCounts.get("numberOfStoriesAddedInTrakingState");
                                    trackingFeaturesCount = (Integer)boardScopChangeCounts.get("trackingFeaturesCount");
                                }
                                DBObject previousItem = null;
                                boolean checkItemAvailable = false;
                                if (PropertyValidator.isValid((Object)rawItem.get("originItemId")) && previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId"))) != null) {
                                    checkItemAvailable = true;
                                    previousItem = (DBObject)previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId")));
                                } else if (previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                                    checkItemAvailable = true;
                                    previousItem = (DBObject)previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("_id")));
                                }
                                if (checkItemAvailable) {
                                    ArrayList<TeamContainer> previousTeamContainers = new ArrayList<TeamContainer>();
                                    if (previousItem != null && previousItem.get("teamContainers") != null) {
                                        DBObject previousStateStoryParentItem;
                                        DBRef currentparent;
                                        DBRef parentId3;
                                        List previousTeamContainersRef = (List)previousItem.get("teamContainers");
                                        for (int k = 0; k < previousTeamContainersRef.size(); ++k) {
                                            DBObject tcObject;
                                            DBRef tcRef = (DBRef)previousTeamContainersRef.get(k);
                                            if (!PropertyValidator.isValid((Object)tcRef) || !PropertyValidator.isValid((Object)tcRef.getId()) || !PropertyValidator.isValid((Object)(tcObject = (DBObject)previousStateTeamContainersMapById.get(String.valueOf(tcRef.getId()))))) continue;
                                            DBRef containerRef = (DBRef)tcObject.get("container");
                                            DBRef teamRef = (DBRef)tcObject.get("team");
                                            if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                                            TeamContainer teamContainer = new TeamContainer();
                                            teamContainer.setId(String.valueOf(tcObject.get("_id")));
                                            Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                                            Team team3 = (Team)teamMapById.get(String.valueOf(teamRef.getId()));
                                            teamContainer.setContainer(container);
                                            previousTeamContainers.add(teamContainer);
                                            if (PropertyValidator.isValid((Object)team3) && PropertyValidator.isValid((Object)container)) {
                                                HashMap sprintMapForLoad;
                                                HashMap teamBySprintMapForLoad;
                                                if (!teamBySprintPreviousLoad.containsKey(String.valueOf(team3.getId()))) {
                                                    teamBySprintMapForLoad = new HashMap();
                                                    teamBySprintPreviousLoad.put(String.valueOf(team3.getId()), teamBySprintMapForLoad);
                                                }
                                                teamBySprintMapForLoad = (HashMap)teamBySprintPreviousLoad.get(String.valueOf(team3.getId()));
                                                if (PropertyValidator.isValid((Object)container.getOriginItemId()) && !teamBySprintMapForLoad.containsKey(String.valueOf(container.getOriginItemId()))) {
                                                    sprintMapForLoad = new HashMap();
                                                    sprintMapForLoad.put("previousStateLoad", 0.0);
                                                    teamBySprintMapForLoad.put(String.valueOf(container.getOriginItemId()), sprintMapForLoad);
                                                } else if (PropertyValidator.isValid((Object)container.getId()) && !teamBySprintMapForLoad.containsKey(String.valueOf(container.getId()))) {
                                                    sprintMapForLoad = new HashMap();
                                                    sprintMapForLoad.put("previousStateLoad", 0.0);
                                                    teamBySprintMapForLoad.put(String.valueOf(container.getId()), sprintMapForLoad);
                                                }
                                                sprintMapForLoad = new HashMap();
                                                if (PropertyValidator.isValid((Object)container.getOriginItemId())) {
                                                    sprintMapForLoad = (HashMap)teamBySprintMapForLoad.get(String.valueOf(container.getOriginItemId()));
                                                } else if (PropertyValidator.isValid((Object)container.getId())) {
                                                    sprintMapForLoad = (HashMap)teamBySprintMapForLoad.get(String.valueOf(container.getId()));
                                                }
                                                if (previousItem.get("type").equals(Item.USER_STORY) && previousItem.get("storyPoints") != null) {
                                                    sprintMapForLoad.put("previousStateLoad", Double.valueOf(String.valueOf(sprintMapForLoad.get("previousStateLoad"))) + Double.valueOf(String.valueOf(previousItem.get("storyPoints"))));
                                                }
                                            }
                                            this.getItemTeamAndSprint(previousItem, team3, container, previousStateItemTeamAndSprintMapByItemId, previousStateMapForCheckingNoTeamAndSprintComesDouble, status);
                                            this.getDifferenceOfStoryPointsByStateOfItemMapByItemId(rawItem, previousItem, changeOfStoryPointsInCurrentAndPreviousStateOfStory);
                                        }
                                        HashMap getPreviousStateItemDetailsInMap = this.putItemDetailsInMap(previousItem, previousStateItemTeamAndSprintMapByItemId, status);
                                        if (previousItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)(parentId3 = (DBRef)previousItem.get("parent"))) && PropertyValidator.isValid((Object)parentId3.getId()) && previousStateItemsMapByIdsOnly.get(String.valueOf(parentId3.getId())) != null) {
                                            DBObject parentItem = (DBObject)previousStateItemsMapByIdsOnly.get(String.valueOf(parentId3.getId()));
                                            HashMap itemkey2 = this.getItemJirsOrTFSKey(parentItem);
                                            getPreviousStateItemDetailsInMap.put("parentkey", itemkey2.get("key"));
                                            getPreviousStateItemDetailsInMap.put("parentkeyType", itemkey2.get("keyType"));
                                            getPreviousStateItemDetailsInMap.put("parentkeyLink", itemkey2.get("keyLink"));
                                            getPreviousStateItemDetailsInMap.put("parentDetails", parentItem.get("title"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsId", parentItem.get("tfsId"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsURL", parentItem.get("tfsURL"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsProject", parentItem.get("tfsProject"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsItemType", parentItem.get("tfsItemType"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsFilter", parentItem.get("tfsFilter"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                                            getPreviousStateItemDetailsInMap.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                                            getPreviousStateItemDetailsInMap.put("parentJiraKey", parentItem.get("jiraKey"));
                                            getPreviousStateItemDetailsInMap.put("parentJiraId", parentItem.get("jiraId"));
                                            getPreviousStateItemDetailsInMap.put("parentJiraFilter", parentItem.get("jiraFilter"));
                                            getPreviousStateItemDetailsInMap.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                                            getPreviousStateItemDetailsInMap.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                                        }
                                        HashMap<String, Integer> obj = new HashMap<String, Integer>(getPreviousStateItemDetailsInMap);
                                        obj.put("Estimate", 0);
                                        obj.put("doneStoryPoint", 0);
                                        if (previousItem.get("type").equals(Item.FEATURE)) {
                                            if (previousItem.get("originItemId") != null) {
                                                previousStateFeatureMapById.put(String.valueOf(previousItem.get("originItemId")), obj);
                                            } else {
                                                previousStateFeatureMapById.put(String.valueOf(previousItem.get("_id")), obj);
                                            }
                                        } else if (previousItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)(currentparent = (DBRef)previousItem.get("parent"))) && PropertyValidator.isValid((Object)currentparent.getId()) && PropertyValidator.isValid((Object)(previousStateStoryParentItem = (DBObject)previousStateItemsMapByIdsOnly.get(String.valueOf(currentparent.getId()))))) {
                                            if (previousStateStoryParentItem.get("originItemId") != null && previousStateFeatureMapById.get(String.valueOf(previousStateStoryParentItem.get("originItemId"))) == null) {
                                                previousStateFeatureMapById.put(String.valueOf(previousStateStoryParentItem.get("originItemId")), obj);
                                            } else if (previousStateStoryParentItem.get("originItemId") == null && previousStateFeatureMapById.get(String.valueOf(previousStateStoryParentItem.get("_id"))) == null) {
                                                previousStateFeatureMapById.put(String.valueOf(previousStateStoryParentItem.get("_id")), obj);
                                            }
                                            HashMap getpreviousfeatureStoriesData = new HashMap();
                                            getpreviousfeatureStoriesData = previousStateStoryParentItem.get("originItemId") != null ? (HashMap)previousStateFeatureMapById.get(String.valueOf(previousStateStoryParentItem.get("originItemId"))) : (HashMap)previousStateFeatureMapById.get(String.valueOf(previousStateStoryParentItem.get("_id")));
                                            if (previousItem.get("storyPoints") != null) {
                                                getpreviousfeatureStoriesData.put("Estimate", Double.valueOf(String.valueOf(getpreviousfeatureStoriesData.get("Estimate"))) + Double.valueOf(String.valueOf(previousItem.get("storyPoints"))));
                                            }
                                        }
                                    }
                                    if (dataFlags.get("deliveryVariations") != null) {
                                        HashMap<String, Object> variationFunctionDataMap = new HashMap<String, Object>();
                                        variationFunctionDataMap.put("currentTeamContainers", currentTeamContainers);
                                        variationFunctionDataMap.put("previousTeamContainers", previousTeamContainers);
                                        variationFunctionDataMap.put("featureChangeSprint", featureChangeSprint);
                                        variationFunctionDataMap.put("storyChangeSprint", storyChangeSprint);
                                        variationFunctionDataMap.put("itemTeamAndSprintMapByItemId", itemTeamAndSprintMapByItemId);
                                        variationFunctionDataMap.put("previousStateItemTeamAndSprintMapByItemId", previousStateItemTeamAndSprintMapByItemId);
                                        variationFunctionDataMap.put("itemKey", this.getItemJirsOrTFSKey(rawItem));
                                        variationFunctionDataMap.put("rawItem", rawItem);
                                        variationFunctionDataMap.put("previousItem", previousItem);
                                        variationFunctionDataMap.put("status", status);
                                        variationFunctionDataMap.put("featuresChanged", featuresChanged);
                                        variationFunctionDataMap.put("storiesChanged", storiesChanged);
                                        variationFunctionDataMap.put("currentStateItemsMapById", currentStateItemsMapById);
                                        HashMap changeOfFeatureAndStoryCountOfvariation = this.deliveryVariations(variationFunctionDataMap);
                                        storiesChanged = (Integer)changeOfFeatureAndStoryCountOfvariation.get("storiesChanged");
                                        featuresChanged = (Integer)changeOfFeatureAndStoryCountOfvariation.get("featuresChanged");
                                    }
                                }
                            }
                            if ((dataFlags.get("completionGraphWithPopupData") != null || dataFlags.get("boardStateStatusTable") != null) && checkTeamContainersExistInDB) {
                                HashMap itemByStatusFunctionData = new HashMap();
                                itemByStatusFunctionData.put("itemDetailes", new HashMap(getItemDetailsInMap));
                                itemByStatusFunctionData.put("status", status);
                                itemByStatusFunctionData.put("featureMapByStatus", featureMapByStatus);
                                itemByStatusFunctionData.put("featuresCompletion", featuresCompletion);
                                itemByStatusFunctionData.put("featureMapById", featureMapById);
                                itemByStatusFunctionData.put("storyCompletion", storyCompletion);
                                itemByStatusFunctionData.put("storiesMayByStatus", storiesMayByStatus);
                                itemByStatusFunctionData.put("storyPointsCompletion", storyPointsCompletion);
                                this.getItemDataMapByItemStatus(itemByStatusFunctionData, rawItem);
                            }
                            rawItem.put("_teamContainers", tcs);
                        } else {
                            DBObject previousItem = null;
                            boolean checkItemAvailable = false;
                            if (PropertyValidator.isValid((Object)rawItem.get("originItemId")) && previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId"))) != null) {
                                checkItemAvailable = true;
                                previousItem = (DBObject)previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId")));
                            } else if (previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                                checkItemAvailable = true;
                                previousItem = (DBObject)previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("_id")));
                            }
                            if (checkItemAvailable) {
                                ArrayList<TeamContainer> previousTeamContainers = new ArrayList<TeamContainer>();
                                if (previousItem != null && previousItem.get("teamContainers") != null) {
                                    List previousTeamContainersRef = (List)previousItem.get("teamContainers");
                                    for (int k = 0; k < previousTeamContainersRef.size(); ++k) {
                                        DBRef tcRef = (DBRef)previousTeamContainersRef.get(k);
                                        DBObject tcObject = (DBObject)previousStateTeamContainersMapById.get(String.valueOf(tcRef.getId()));
                                        if (!PropertyValidator.isValid((Object)tcObject)) continue;
                                        DBRef containerRef = (DBRef)tcObject.get("container");
                                        DBRef teamRef = (DBRef)tcObject.get("team");
                                        if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                                        TeamContainer teamContainer = new TeamContainer();
                                        teamContainer.setId(String.valueOf(tcObject.get("_id")));
                                        Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                                        Team team4 = (Team)teamMapById.get(String.valueOf(teamRef.getId()));
                                        teamContainer.setContainer(container);
                                        previousTeamContainers.add(teamContainer);
                                        if (PropertyValidator.isValid((Object)team4) && PropertyValidator.isValid((Object)container)) {
                                            HashMap sprintMapForLoad;
                                            HashMap teamBySprintMapForLoad;
                                            if (!teamBySprintPreviousLoad.containsKey(String.valueOf(team4.getId()))) {
                                                teamBySprintMapForLoad = new HashMap();
                                                teamBySprintPreviousLoad.put(String.valueOf(team4.getId()), teamBySprintMapForLoad);
                                            }
                                            teamBySprintMapForLoad = (HashMap)teamBySprintPreviousLoad.get(String.valueOf(team4.getId()));
                                            if (PropertyValidator.isValid((Object)container.getOriginItemId()) && !teamBySprintMapForLoad.containsKey(String.valueOf(container.getOriginItemId()))) {
                                                sprintMapForLoad = new HashMap();
                                                sprintMapForLoad.put("previousStateLoad", 0.0);
                                                teamBySprintMapForLoad.put(String.valueOf(container.getOriginItemId()), sprintMapForLoad);
                                            } else if (PropertyValidator.isValid((Object)container.getId()) && !teamBySprintMapForLoad.containsKey(String.valueOf(container.getId()))) {
                                                sprintMapForLoad = new HashMap();
                                                sprintMapForLoad.put("previousStateLoad", 0.0);
                                                teamBySprintMapForLoad.put(String.valueOf(container.getId()), sprintMapForLoad);
                                            }
                                            sprintMapForLoad = new HashMap();
                                            if (PropertyValidator.isValid((Object)container.getOriginItemId())) {
                                                sprintMapForLoad = (HashMap)teamBySprintMapForLoad.get(String.valueOf(container.getOriginItemId()));
                                            } else if (PropertyValidator.isValid((Object)container.getId())) {
                                                sprintMapForLoad = (HashMap)teamBySprintMapForLoad.get(String.valueOf(container.getId()));
                                            }
                                            if (previousItem.get("type").equals(Item.USER_STORY) && previousItem.get("storyPoints") != null && sprintMapForLoad.get("previousStateLoad") != null) {
                                                sprintMapForLoad.put("previousStateLoad", Double.valueOf(String.valueOf(sprintMapForLoad.get("previousStateLoad"))) + Double.valueOf(String.valueOf(previousItem.get("storyPoints"))));
                                            }
                                        }
                                        this.getItemTeamAndSprint(previousItem, team4, container, previousStateItemTeamAndSprintMapByItemId, previousStateMapForCheckingNoTeamAndSprintComesDouble, status);
                                    }
                                    if (dataFlags.get("deliveryVariations") != null) {
                                        HashMap<String, Object> variationFunctionDataMap = new HashMap<String, Object>();
                                        variationFunctionDataMap.put("currentTeamContainers", currentTeamContainers);
                                        variationFunctionDataMap.put("previousTeamContainers", previousTeamContainers);
                                        variationFunctionDataMap.put("featureChangeSprint", featureChangeSprint);
                                        variationFunctionDataMap.put("storyChangeSprint", storyChangeSprint);
                                        variationFunctionDataMap.put("itemTeamAndSprintMapByItemId", itemTeamAndSprintMapByItemId);
                                        variationFunctionDataMap.put("previousStateItemTeamAndSprintMapByItemId", previousStateItemTeamAndSprintMapByItemId);
                                        variationFunctionDataMap.put("itemKey", this.getItemJirsOrTFSKey(rawItem));
                                        variationFunctionDataMap.put("rawItem", rawItem);
                                        variationFunctionDataMap.put("previousItem", previousItem);
                                        variationFunctionDataMap.put("status", status);
                                        variationFunctionDataMap.put("featuresChanged", featuresChanged);
                                        variationFunctionDataMap.put("storiesChanged", storiesChanged);
                                        variationFunctionDataMap.put("currentStateItemsMapById", currentStateItemsMapById);
                                        HashMap changeOfFeatureAndStoryCountOfvariation = this.deliveryVariations(variationFunctionDataMap);
                                        storiesChanged = (Integer)changeOfFeatureAndStoryCountOfvariation.get("storiesChanged");
                                        featuresChanged = (Integer)changeOfFeatureAndStoryCountOfvariation.get("featuresChanged");
                                    }
                                }
                                if (rawItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)(parentId2 = (DBRef)rawItem.get("parent"))) && PropertyValidator.isValid((Object)parentId2.getId()) && currentStateItemsMapById.get(String.valueOf(parentId2.getId())) != null) {
                                    DBObject parentItem = (DBObject)currentStateItemsMapById.get(String.valueOf(parentId2.getId()));
                                    itemkey = this.getItemJirsOrTFSKey(parentItem);
                                    rawItem.put("parentkey", itemkey.get("key"));
                                    rawItem.put("parentkeyType", itemkey.get("keyType"));
                                    rawItem.put("parentkeyLink", itemkey.get("keyLink"));
                                    rawItem.put("parentDetails", parentItem.get("title"));
                                    rawItem.put("parentTfsId", parentItem.get("tfsId"));
                                    rawItem.put("parentTfsURL", parentItem.get("tfsURL"));
                                    rawItem.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                                    rawItem.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                                    rawItem.put("parentTfsProject", parentItem.get("tfsProject"));
                                    rawItem.put("parentTfsItemType", parentItem.get("tfsItemType"));
                                    rawItem.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                                    rawItem.put("parentTfsFilter", parentItem.get("tfsFilter"));
                                    rawItem.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                                    rawItem.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                                    rawItem.put("parentJiraKey", parentItem.get("jiraKey"));
                                    rawItem.put("parentJiraId", parentItem.get("jiraId"));
                                    rawItem.put("parentJiraFilter", parentItem.get("jiraFilter"));
                                    rawItem.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                                    rawItem.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                                }
                                currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("_id")), rawItem);
                                if (rawItem.get("originItemId") != null) {
                                    currentStateItemMapById.put(String.valueOf(rawItem.get("originItemId")), rawItem);
                                    currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("originItemId")), rawItem);
                                } else if (rawItem.get("_id") != null) {
                                    currentStateItemMapById.put(String.valueOf(rawItem.get("_id")), rawItem);
                                } else if (rawItem.get("duplicateOfId") != null) {
                                    currentStateItemMapById.put(String.valueOf(rawItem.get("duplicateOfId")), rawItem);
                                }
                            }
                            if (dataFlags.get("completionGraphWithPopupData") != null || dataFlags.get("boardStateStatusTable") != null) {
                                HashMap itemByStatusFunctionData = new HashMap();
                                HashMap getItemDetailsInMap = this.putItemDetailsInMap(rawItem, itemTeamAndSprintMapByItemId, status);
                                itemByStatusFunctionData.put("itemDetailes", new HashMap(getItemDetailsInMap));
                                itemByStatusFunctionData.put("status", status);
                                itemByStatusFunctionData.put("featureMapById", featureMapById);
                                this.unplannedItems(itemByStatusFunctionData, rawItem);
                                if (rawItem.get("type").equals(Item.FEATURE)) {
                                    HashMap putUnplannedFeatures = (HashMap)unplannedData.get("unplannedFeatures");
                                    putUnplannedFeatures.put(String.valueOf(rawItem.get("_id")), getItemDetailsInMap);
                                } else if (rawItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)status) && !status.getCategory().equals("Done")) {
                                    HashMap putUnplannedStories = (HashMap)unplannedData.get("unplannedStories");
                                    putUnplannedStories.put(String.valueOf(rawItem.get("_id")), getItemDetailsInMap);
                                }
                            }
                        }
                        HashMap getItemDetailsInMap = this.putItemDetailsInMap(rawItem, itemTeamAndSprintMapByItemId, status);
                        if (rawItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)(parentId = (DBRef)rawItem.get("parent"))) && PropertyValidator.isValid((Object)parentId.getId()) && currentStateItemsMapById.get(String.valueOf(parentId.getId())) != null) {
                            DBObject parentItem = (DBObject)currentStateItemsMapById.get(String.valueOf(parentId.getId()));
                            HashMap itemkey3 = this.getItemJirsOrTFSKey(parentItem);
                            getItemDetailsInMap.put("parentkey", itemkey3.get("key"));
                            getItemDetailsInMap.put("parentkeyType", itemkey3.get("keyType"));
                            getItemDetailsInMap.put("parentkeyLink", itemkey3.get("keyLink"));
                            getItemDetailsInMap.put("parentDetails", parentItem.get("title"));
                            getItemDetailsInMap.put("parentTfsId", parentItem.get("tfsId"));
                            getItemDetailsInMap.put("parentTfsURL", parentItem.get("tfsURL"));
                            getItemDetailsInMap.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                            getItemDetailsInMap.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                            getItemDetailsInMap.put("parentTfsProject", parentItem.get("tfsProject"));
                            getItemDetailsInMap.put("parentTfsItemType", parentItem.get("tfsItemType"));
                            getItemDetailsInMap.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                            getItemDetailsInMap.put("parentTfsFilter", parentItem.get("tfsFilter"));
                            getItemDetailsInMap.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                            getItemDetailsInMap.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                            getItemDetailsInMap.put("parentJiraKey", parentItem.get("jiraKey"));
                            getItemDetailsInMap.put("parentJiraId", parentItem.get("jiraId"));
                            getItemDetailsInMap.put("parentJiraFilter", parentItem.get("jiraFilter"));
                            getItemDetailsInMap.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                            getItemDetailsInMap.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                        }
                        currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("_id")), new HashMap(getItemDetailsInMap));
                        if (rawItem.get("originItemId") != null) {
                            currentStateProcessedItemsMapByIds.put(String.valueOf(rawItem.get("originItemId")), new HashMap(getItemDetailsInMap));
                        }
                        String string = featureIdKey = rawItem.get("originItemId") != null ? String.valueOf(rawItem.get("originItemId")) : String.valueOf(rawItem.get("_id"));
                        if (dataFlags.get("backlogFeatures") == null || previousStateItemsMapBy_Ids_OR_OriginItemId.get(featureIdKey) == null || !rawItem.get("type").equals(Item.FEATURE)) continue;
                        ++backlogItemsInPlanningCount;
                        featuresPresentInBacklog.add(getItemDetailsInMap);
                        featuresPresentInBacklogMapById.put(featureIdKey, getItemDetailsInMap);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            HashMap removedPreviousStateFeatureMapById = new HashMap();
            HashMap previousStateItemsMapByIdsForDependencies = new HashMap();
            HashMap previousStateItemsMapByTeamContainerIdsForDependencies = new HashMap();
            HashMap<String, Object> paramitersForthePreviousStateCalculation = new HashMap<String, Object>();
            if (prevState != null && dataFlags.get("previousStateRequire") != null) {
                paramitersForthePreviousStateCalculation.put("removedPreviousStateFeatureMapById", removedPreviousStateFeatureMapById);
                paramitersForthePreviousStateCalculation.put("previousStateItemsMapByIdsForDependencies", previousStateItemsMapByIdsForDependencies);
                paramitersForthePreviousStateCalculation.put("previousStateItemsMapByTeamContainerIdsForDependencies", previousStateItemsMapByTeamContainerIdsForDependencies);
                paramitersForthePreviousStateCalculation.put("previousStateItemTeamAndSprintMapByItemId", previousStateItemTeamAndSprintMapByItemId);
                paramitersForthePreviousStateCalculation.put("previousStateMapForCheckingNoTeamAndSprintComesDouble", previousStateMapForCheckingNoTeamAndSprintComesDouble);
                paramitersForthePreviousStateCalculation.put("previousStateItems", previousStateItems);
                paramitersForthePreviousStateCalculation.put("previousStateItemsLinks", previousStateItemsLinks);
                paramitersForthePreviousStateCalculation.put("statusMapById", statusMapById);
                paramitersForthePreviousStateCalculation.put("teamMapById", teamMapById);
                paramitersForthePreviousStateCalculation.put("containerMapById", containerMapById);
                if (dataFlags.get("callFromAnalyticsFlag") != null) {
                    paramitersForthePreviousStateCalculation.put("callFromAnalyticsFlag", true);
                } else {
                    paramitersForthePreviousStateCalculation.put("callFromAnalyticsFlag", false);
                }
                paramitersForthePreviousStateCalculation.put("currentStateItemsMapBy_Ids_OR_OriginItemId", currentStateItemMapById);
                paramitersForthePreviousStateCalculation.put("teamItemById", teamItemById);
                paramitersForthePreviousStateCalculation.put("previousStateItemMapById", previousStateItemMapById);
                paramitersForthePreviousStateCalculation.put("storiesDetailsPreviousState", storiesDetailsPreviousState);
                paramitersForthePreviousStateCalculation.put("previousStateItemsMapByIdsOnly", previousStateItemsMapByIdsOnly);
                paramitersForthePreviousStateCalculation.put("previousStatejiraDependencies", previousStatejiraDependencies);
                paramitersForthePreviousStateCalculation.put("previousStateItemsWithUserSelectedCartType", previousStateItemsWithUserSelectedCartType);
                paramitersForthePreviousStateCalculation.put("statsExclusionData", statsExclusionData);
                paramitersForthePreviousStateCalculation.put("featuresPresentInBacklog", featuresPresentInBacklog);
                paramitersForthePreviousStateCalculation.put("featuresPresentInBacklogMapById", featuresPresentInBacklogMapById);
                this.calculationForThePriviousStateDataOfTheBoard(paramitersForthePreviousStateCalculation);
            }
            activeSessionTeams.forEach(team -> {
                HashMap getTeamForSprintDetailes = (HashMap)teamItemById.get(team.getId());
                HashMap allSprintDetailes = (HashMap)getTeamForSprintDetailes.get("sprintDetailes");
                if (PropertyValidator.isValid((Object)allSprintDetailes)) {
                    this.calculationForNoItemSprintInSelectedTeam(allSprintDetailes, activeSessionContainers);
                }
            });
            HashMap<String, String> parentItemData = new HashMap<String, String>();
            parentItemData.put("parentItem", session.getParentItem());
            parentItemData.put("parentItemColor", session.getParentItemColor());
            parentItemData.put("parentItemTextColor", session.getParentItemTextColor());
            HashMap<String, String> childItemData = new HashMap<String, String>();
            childItemData.put("childItem", session.getChildItem());
            childItemData.put("childItemColor", session.getChildItemColor());
            childItemData.put("childItemTextColor", session.getChildItemTextColor());
            if (dataFlags.get("callFromInspectAndAdapeFlag") != null) {
                String filePath = null;
                filePath = "InspectAndAdaptData_" + sessionId + ".txt";
                File tempFile = new File(this.env.getProperty("temp.file.location") + filePath);
                boolean exists = tempFile.exists();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("sessionId", sessionId);
                response.put("inspectAndAdaptBoards", this.getSelectedBoards(param));
                response.put("fileExists", exists);
                response.put("programPredictabilityMatrix", this.piComparison());
                if (PropertyValidator.isValid((Object)session.getInspectAndAdaptSessionDateTime())) {
                    response.put("inspectAndAdaptSessionDate", session.getInspectAndAdaptSessionDateTime());
                } else {
                    response.put("inspectAndAdaptSessionDate", "-1");
                }
            }
            response.put("currentStateProcessedItemsMapByIds", currentStateProcessedItemsMapByIds);
            if (dataFlags.get("callFromAnalyticsFlag") != null || dataFlags.get("callFromInspectAndAdapeFlag") != null) {
                response.put("totalStories", totalNumberofStories);
                response.put("totalNumberofFeatures", totalNumberofFeatures);
                response.put("activeSessionBoard", activeSessionBoardTitle);
                response.put("previousSessionBoard", previousSessionBoardTitle);
                response.put("parentItemData", parentItemData);
                response.put("childItemData", childItemData);
            }
            if (dataFlags.get("callFromAnalyticsFlag") != null) {
                response.put("cartType", issueTypeMapByIdForUserSelection);
                response.put("storyPointsInDifferentState", changeOfStoryPointsInCurrentAndPreviousStateOfStory);
            }
            if (dataFlags.get("completionGraphWithPopupData") != null) {
                response.put("featurePopUpData", featureMapByStatus);
                response.put("featureCompletion", featuresCompletion);
                response.put("storyCompletion", storyCompletion);
                response.put("storyPopUpData", storiesMayByStatus);
                response.put("storyPointsCompletion", storyPointsCompletion);
            }
            if (dataFlags.get("boardStateStatusTable") != null) {
                response.put("featureMapById", featureMapById);
                response.put("unplannedData", unplannedData);
                response.put("previousStateFeatureMapById", previousStateFeatureMapById);
                response.put("removedPreviousStateFeatureMapById", removedPreviousStateFeatureMapById);
            }
            if (dataFlags.get("scopeChange") != null) {
                response.put("storyAddedInTracking", storiesAddedInTracking);
                response.put("featuresAddedInTracking", featuresAddedInTracking);
                response.put("totalStoryPoint", totalNumberofStoryPoints);
                response.put("storiesInTrakingState", numberOfStoriesAddedInTrakingState);
                response.put("storyPointInTrakingState", numberOfStoryPointsAddedInTrakingState);
                response.put("trackingFeatures", trackingFeaturesCount);
            }
            if (dataFlags.get("deliveryVariations") != null) {
                response.put("featureChangeSprint", featureChangeSprint);
                response.put("storyChangeSprint", storyChangeSprint);
                response.put("featureDeliveryVariation", featuresChanged);
                response.put("storyDeliveryVariation", storiesChanged);
            }
            if (dataFlags.get("backlogFeatures") != null) {
                response.put("backlogItemsInPlanning", featuresPresentInBacklog.size());
                response.put("backlogFeature", featuresPresentInBacklog);
            }
            if (dataFlags.get("previousStateRequire") != null) {
                response.put("teamBySprintPreviousLoad", teamBySprintPreviousLoad);
            }
            if (dataFlags.get("sprintDependencies") != null) {
                response.put("sprintDependencies", this.getTeamOrBoardDependencies(activeSessionBoard, curentStateItemsLinks, curentStatejiraDependencies, "sprintDependencies", itemsById, currentStateItemsMapByTeamContainerIdsForDependencies));
            }
            if (dataFlags.get("boardDependencies") != null) {
                response.put("currentStateLinks", this.getTeamOrBoardDependencies(activeSessionBoard, curentStateItemsLinks, curentStatejiraDependencies, "boardDependencies", itemsById, currentStateItemsMapByTeamContainerIdsForDependencies));
                response.put("previousStateLinks", this.getTeamOrBoardDependencies(prevSessionBoard, previousStateItemsLinks, previousStatejiraDependencies, "boardDependencies", previousStateItemsMapByIdsForDependencies, previousStateItemsMapByTeamContainerIdsForDependencies));
            }
            if (dataFlags.get("spillOver") != null) {
                // empty if block
            }
            if (dataFlags.get("allTeamsDetailByBoardState") != null) {
                this.calculationForTeamsStoriesByStateOfBoard(storiesDetailsCurrentState, storiesDetailsPreviousState, teamItemById);
                response.put("previousStateItemMapById", previousStateItemMapById);
                response.put("currentStateItemMapById", currentStateItemMapById);
                response.put("teamStateByItems", teamItemById);
            }
            if (dataFlags.get("commitedLoad") != null) {
                ArrayList<String> boardIds = new ArrayList<String>();
                boardIds.add(activeSessionBoard.getId());
                List boardCapacity = this.getTeamCapacity(boardIds, activeSessionBoard.getTenant());
                HashMap responseDataSpillOverAndBaseLine = this.spillOverAndBaseLineCalculations(dataFlags, boardCapacity, activeSessionBoard, containerMapById, teamMapById, itemsById);
                if (dataFlags.get("commitedLoad") != null) {
                    response.put("baseLineData", responseDataSpillOverAndBaseLine.get("baseLineData"));
                }
                if (dataFlags.get("spillOver") != null) {
                    response.put("baseLineDataSpillOver", responseDataSpillOverAndBaseLine.get("baseLineDataSpillOver"));
                    response.put("spillOverResponce", responseDataSpillOverAndBaseLine.get("spillOverResponce"));
                }
                HashMap comitedloadMapBySprintId = new HashMap();
                for (DBObject capacity : boardCapacity) {
                    HashMap loadAndVelocity;
                    if (!capacity.containsField("sprintId")) continue;
                    if (!comitedloadMapBySprintId.containsKey(capacity.get("sprintId"))) {
                        comitedloadMapBySprintId.put(String.valueOf(capacity.get("sprintId")), new HashMap());
                    }
                    if (!(loadAndVelocity = (HashMap)comitedloadMapBySprintId.get(capacity.get("sprintId"))).containsKey("commitedLoad")) {
                        loadAndVelocity.put("commitedLoad", 0);
                        loadAndVelocity.put("capacity", 0);
                    }
                    if (capacity.containsField("commitedLoad") && loadAndVelocity.containsKey("commitedLoad")) {
                        loadAndVelocity.put("commitedLoad", Double.valueOf(String.valueOf(loadAndVelocity.get("commitedLoad"))) + Double.valueOf(String.valueOf(capacity.get("commitedLoad"))));
                    }
                    if (!capacity.containsField("velocity") || !loadAndVelocity.containsKey("capacity")) continue;
                    loadAndVelocity.put("capacity", Double.valueOf(String.valueOf(loadAndVelocity.get("capacity"))) + Double.valueOf(String.valueOf(capacity.get("velocity"))));
                }
                response.put("commitedLoad", comitedloadMapBySprintId);
                response.put("teamSprintVelocity", this.calculateTeamSprintVelocity(boardCapacity));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    private void unplannedItems(HashMap<String, Object> itemByStatusFunctionData, DBObject rawItem) {
        HashMap getItemDetailsInMap = (HashMap)itemByStatusFunctionData.get("itemDetailes");
        Status status = (Status)itemByStatusFunctionData.get("status");
        HashMap featureMapById = (HashMap)itemByStatusFunctionData.get("featureMapById");
        String type = (String)rawItem.get("type");
        if (type.equals(Item.FEATURE)) {
            if (featureMapById.get(String.valueOf(rawItem.get("_id"))) != null) {
                HashMap parentFeatureDetailes = (HashMap)featureMapById.get(String.valueOf(rawItem.get("_id")));
                getItemDetailsInMap.put("unPlanned", true);
                getItemDetailsInMap.put("unPlannedEstimate", parentFeatureDetailes.get("unPlannedEstimate"));
                getItemDetailsInMap.put("unPlannedToDoStoryCount", parentFeatureDetailes.get("unPlannedToDoStoryCount"));
                getItemDetailsInMap.put("unPlannedInProgressStoryCount", parentFeatureDetailes.get("unPlannedInProgressStoryCount"));
                getItemDetailsInMap.put("unPlannedDoneStoryCount", parentFeatureDetailes.get("unPlannedDoneStoryCount"));
                getItemDetailsInMap.put("unPlannedMiscStoryCount", parentFeatureDetailes.get("unPlannedMiscStoryCount"));
                getItemDetailsInMap.put("unPlannedDoneStoryPoint", parentFeatureDetailes.get("unPlannedDoneStoryPoint"));
                getItemDetailsInMap.put("unPlannedToDoStoryPoint", parentFeatureDetailes.get("unPlannedToDoStoryPoint"));
                getItemDetailsInMap.put("unPlannedInProgressStoryPoint", parentFeatureDetailes.get("unPlannedInProgressStoryPoint"));
                getItemDetailsInMap.put("unPlannedMiscStoryPoint", parentFeatureDetailes.get("unPlannedMiscStoryPoint"));
                getItemDetailsInMap.put("Planned", false);
                getItemDetailsInMap.put("Estimate", parentFeatureDetailes.get("Estimate"));
                getItemDetailsInMap.put("ToDoStoryCount", parentFeatureDetailes.get("ToDoStoryCount"));
                getItemDetailsInMap.put("InProgressStoryCount", parentFeatureDetailes.get("InProgressStoryCount"));
                getItemDetailsInMap.put("DoneStoryCount", parentFeatureDetailes.get("DoneStoryCount"));
                getItemDetailsInMap.put("MiscStoryCount", parentFeatureDetailes.get("MiscStoryCount"));
                getItemDetailsInMap.put("doneStoryPoint", parentFeatureDetailes.get("doneStoryPoint"));
                getItemDetailsInMap.put("toDoStoryPoint", parentFeatureDetailes.get("toDoStoryPoint"));
                getItemDetailsInMap.put("inProgressStoryPoint", parentFeatureDetailes.get("inProgressStoryPoint"));
                getItemDetailsInMap.put("miscStoryPoint", parentFeatureDetailes.get("miscStoryPoint"));
            } else {
                getItemDetailsInMap.put("unPlanned", true);
                getItemDetailsInMap.put("unPlannedEstimate", 0);
                getItemDetailsInMap.put("unPlannedToDoStoryCount", new ArrayList());
                getItemDetailsInMap.put("unPlannedInProgressStoryCount", new ArrayList());
                getItemDetailsInMap.put("unPlannedDoneStoryCount", new ArrayList());
                getItemDetailsInMap.put("unPlannedMiscStoryCount", new ArrayList());
                getItemDetailsInMap.put("unPlannedDoneStoryPoint", 0);
                getItemDetailsInMap.put("unPlannedToDoStoryPoint", 0);
                getItemDetailsInMap.put("unPlannedInProgressStoryPoint", 0);
                getItemDetailsInMap.put("unPlannedMiscStoryPoint", 0);
                getItemDetailsInMap.put("Planned", false);
                getItemDetailsInMap.put("Estimate", 0);
                getItemDetailsInMap.put("ToDoStoryCount", new ArrayList());
                getItemDetailsInMap.put("InProgressStoryCount", new ArrayList());
                getItemDetailsInMap.put("DoneStoryCount", new ArrayList());
                getItemDetailsInMap.put("MiscStoryCount", new ArrayList());
                getItemDetailsInMap.put("doneStoryPoint", 0);
                getItemDetailsInMap.put("toDoStoryPoint", 0);
                getItemDetailsInMap.put("inProgressStoryPoint", 0);
                getItemDetailsInMap.put("miscStoryPoint", 0);
            }
            getItemDetailsInMap.put("unPlanned", true);
            featureMapById.put(String.valueOf(rawItem.get("_id")), getItemDetailsInMap);
        } else {
            DBRef parent = (DBRef)rawItem.get("parent");
            if (PropertyValidator.isValid((Object)parent) && PropertyValidator.isValid((Object)parent.getId())) {
                if (featureMapById.get(String.valueOf(parent.getId())) == null) {
                    HashMap<String, Serializable> parentFeatureDetailes = new HashMap<String, Serializable>();
                    parentFeatureDetailes.put("unPlannedEstimate", Integer.valueOf(0));
                    parentFeatureDetailes.put("unPlannedToDoStoryCount", new ArrayList());
                    parentFeatureDetailes.put("unPlannedInProgressStoryCount", new ArrayList());
                    parentFeatureDetailes.put("unPlannedDoneStoryCount", new ArrayList());
                    parentFeatureDetailes.put("unPlannedMiscStoryCount", new ArrayList());
                    parentFeatureDetailes.put("unPlannedDoneStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("unPlannedToDoStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("unPlannedInProgressStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("unPlannedMiscStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("Estimate", Integer.valueOf(0));
                    parentFeatureDetailes.put("ToDoStoryCount", new ArrayList());
                    parentFeatureDetailes.put("InProgressStoryCount", new ArrayList());
                    parentFeatureDetailes.put("DoneStoryCount", new ArrayList());
                    parentFeatureDetailes.put("MiscStoryCount", new ArrayList());
                    parentFeatureDetailes.put("doneStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("toDoStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("inProgressStoryPoint", Integer.valueOf(0));
                    parentFeatureDetailes.put("miscStoryPoint", Integer.valueOf(0));
                    featureMapById.put(String.valueOf(parent.getId()), parentFeatureDetailes);
                }
                HashMap getfeatureStoriesData = (HashMap)featureMapById.get(String.valueOf(parent.getId()));
                if (status != null && status.getCategory() != null) {
                    if (status.getCategory().equalsIgnoreCase("ToDo")) {
                        ArrayList updateUnplannedData = (ArrayList)getfeatureStoriesData.get("unPlannedToDoStoryCount");
                        updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                        if (rawItem.get("storyPoints") != null) {
                            getfeatureStoriesData.put("unPlannedToDoStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("unPlannedToDoStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                        }
                    } else if (status.getCategory().equalsIgnoreCase("InProgress")) {
                        ArrayList updateUnplannedData = (ArrayList)getfeatureStoriesData.get("unPlannedInProgressStoryCount");
                        updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                        if (rawItem.get("storyPoints") != null) {
                            getfeatureStoriesData.put("unPlannedInProgressStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("unPlannedInProgressStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                        }
                    } else if (status.getCategory().equalsIgnoreCase("Done")) {
                        ArrayList updateUnplannedData = (ArrayList)getfeatureStoriesData.get("unPlannedDoneStoryCount");
                        updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                        if (rawItem.get("storyPoints") != null) {
                            getfeatureStoriesData.put("unPlannedDoneStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("unPlannedDoneStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                        }
                    } else {
                        ArrayList updateUnplannedData = (ArrayList)getfeatureStoriesData.get("unPlannedMiscStoryCount");
                        updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                        if (rawItem.get("storyPoints") != null) {
                            getfeatureStoriesData.put("unPlannedMiscStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("unPlannedMiscStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                        }
                    }
                    if (rawItem.get("storyPoints") != null) {
                        getfeatureStoriesData.put("unPlannedEstimate", Double.valueOf(String.valueOf(getfeatureStoriesData.get("unPlannedEstimate"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                    }
                }
            }
        }
    }

    private HashMap<String, Object> getBoardPreviousState(SessionBoard activeSessionBoard, Session session) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            List allStates = this.stateRepository.findAllByTenant(activeSessionBoard.getTenant());
            State prevState = null;
            for (State s : allStates) {
                if (activeSessionBoard.getState().getTitle().equalsIgnoreCase("Draft")) {
                    prevState = null;
                    continue;
                }
                if (activeSessionBoard.getState().getTitle().equalsIgnoreCase("Close")) {
                    if (s.getSequence() != activeSessionBoard.getState().getSequence() - 2) continue;
                    prevState = s;
                    continue;
                }
                if (s.getSequence() != activeSessionBoard.getState().getSequence() - 1) continue;
                prevState = s;
                break;
            }
            SessionBoard prevSessionBoard = null;
            prevSessionBoard = this.sessionBoardRepository.findOneBySessionAndState(session, prevState);
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            sessionBoards.add(activeSessionBoard);
            sessionBoards.add(prevSessionBoard);
            responce.put("prevState", prevState);
            responce.put("sessionBoards", sessionBoards);
            responce.put("prevSessionBoard", prevSessionBoard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, Object> getBoardAllStatuses(Session session) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            HashMap<String, String> statusTypeMapById;
            HashMap<String, Status> statusMapById = new HashMap<String, Status>();
            ArrayList statusListOfNameAndIds = new ArrayList();
            ArrayList<String> worflowsIds = new ArrayList<String>();
            worflowsIds.add(session.getItemWorkFlow().getId());
            worflowsIds.add(session.getSubItemWorkFlow().getId());
            List sessionWorkflows = this.workFlowRepository.findBySessionId(session.getId());
            List allStatuses = this.statusRepository.findBySessionId(session.getId());
            if (allStatuses != null) {
                for (Status status : allStatuses) {
                    if (!PropertyValidator.isValid((Object)status) || statusMapById.get(status.getId()) != null) continue;
                    statusMapById.put(status.getId(), status);
                    statusTypeMapById = new HashMap<String, String>();
                    statusTypeMapById.put("id", status.getId());
                    statusTypeMapById.put("title", status.getTitle());
                    statusListOfNameAndIds.add(statusTypeMapById);
                }
            }
            sessionWorkflows.forEach(wf -> worflowsIds.add(wf.getId()));
            allStatuses = this.statusRepository.findByWorkFlowIdIn(worflowsIds);
            for (Status status : allStatuses) {
                if (!PropertyValidator.isValid((Object)status) || statusMapById.get(status.getId()) != null) continue;
                statusMapById.put(status.getId(), status);
                statusTypeMapById = new HashMap();
                statusTypeMapById.put("id", status.getId());
                statusTypeMapById.put("title", status.getTitle());
                statusListOfNameAndIds.add(statusTypeMapById);
            }
            responce.put("statusMapById", statusMapById);
            responce.put("statusListOfNameAndIds", statusListOfNameAndIds);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, String> getIssueTypeOfTheBoardWhichIsArchive(Session session) {
        HashMap<String, String> issueTypeMapByIdForUserSelection = new HashMap<String, String>();
        try {
            List issueTypes = this.getIssueTypeOfBoardWhichIsArchive(session.getTenant());
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(String.valueOf(issueType.get("_id")), (IssueType)issueType));
            List issueTypesForUserSelection = issueTypes;
            issueTypesForUserSelection.forEach(issueType -> issueTypeMapByIdForUserSelection.put(String.valueOf(issueType.get("_id")), String.valueOf(issueType)));
            return issueTypeMapByIdForUserSelection;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return issueTypeMapByIdForUserSelection;
        }
    }

    private HashMap<String, String> getIssueTypeOfTheBoard(Session session) {
        HashMap<String, String> issueTypeMapByIdForUserSelection = new HashMap<String, String>();
        try {
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            List issueTypesForUserSelection = issueTypes;
            issueTypesForUserSelection.forEach(issueType -> issueTypeMapByIdForUserSelection.put(issueType.getId(), issueType.getTitle()));
            issueTypeMapByIdForUserSelection.put("-100", session.getParentItem());
            return issueTypeMapByIdForUserSelection;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return issueTypeMapByIdForUserSelection;
        }
    }

    private HashMap<String, Object> getSprintAndTeamsMap(SessionBoard activeSessionBoard, SessionBoard prevSessionBoard) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            HashMap containerMapById = new HashMap();
            HashMap teamMapById = new HashMap();
            HashMap teamItemById = new HashMap();
            List activeSessionTeams = activeSessionBoard.getTeams();
            List activeSessionContainers = activeSessionBoard.getContainers();
            activeSessionContainers.forEach(container -> containerMapById.put(container.getId(), container));
            if (prevSessionBoard != null) {
                List previousSessionContainers = prevSessionBoard.getContainers();
                previousSessionContainers.forEach(container -> containerMapById.put(container.getId(), container));
            }
            activeSessionTeams.forEach(team -> {
                teamMapById.put(team.getId(), team);
                HashMap stateDetailes = new HashMap();
                stateDetailes.put("currentState", new HashMap());
                stateDetailes.put("priviousState", new HashMap());
                stateDetailes.put("sprintDetailes", new HashMap());
                teamItemById.put(team.getId(), stateDetailes);
            });
            responce.put("containerMapById", containerMapById);
            responce.put("teamMapById", teamMapById);
            responce.put("teamItemById", teamItemById);
            responce.put("activeSessionContainers", activeSessionContainers);
            responce.put("activeSessionTeams", activeSessionTeams);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, String> getItemJirsOrTFSKey(DBObject rawItem) {
        HashMap<String, String> itemKey = new HashMap<String, String>();
        try {
            String featureKey = null;
            String featureKeyLink = null;
            if (rawItem.get("jiraId") != null) {
                featureKey = (String)rawItem.get("jiraKey");
                itemKey.put("keyType", "jiraKey");
            } else if (rawItem.get("tfsId") != null) {
                featureKey = (String)rawItem.get("tfsId");
                featureKeyLink = (String)rawItem.get("tfsURL");
                itemKey.put("keyType", "tfsId");
            } else if (rawItem.get("kendisKey") != null) {
                featureKey = (String)rawItem.get("kendisKey");
                featureKeyLink = (String)rawItem.get("externalReferenceURL");
                itemKey.put("keyType", "kendisKey");
            } else if (rawItem.get("jiraKey") != null) {
                featureKey = (String)rawItem.get("jiraKey");
                featureKeyLink = (String)rawItem.get("externalReferenceURL");
                itemKey.put("keyType", "kendisKey");
            }
            itemKey.put("key", featureKey);
            itemKey.put("keyLink", featureKeyLink);
            return itemKey;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return itemKey;
        }
    }

    private void getItemTeamAndSprint(DBObject rawItem, Team team, Container container, HashMap<String, Object> itemTeamAndSprintMapByItemId, HashMap<String, Object> mapForCheckingNoTeamAndSprintComesDouble, Status status) {
        HashMap getIteamSprintArray;
        HashMap itemTeamAndSprintMap;
        if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) == null) {
            HashMap itemTeamAndSprintArraysMapByName = new HashMap();
            itemTeamAndSprintArraysMapByName.put("sprints", new HashMap());
            itemTeamAndSprintArraysMapByName.put("teams", new HashMap());
            itemTeamAndSprintMapByItemId.put(String.valueOf(rawItem.get("_id")), itemTeamAndSprintArraysMapByName);
            mapForCheckingNoTeamAndSprintComesDouble.put(String.valueOf(rawItem.get("_id")), new HashMap());
        }
        HashMap<String, Object> temporaryTeamMap = new HashMap<String, Object>();
        HashMap<String, Object> temporarySprintMap = new HashMap<String, Object>();
        if (team != null) {
            temporaryTeamMap.put("teamId", team.getId());
            temporaryTeamMap.put("teamTitle", team.getTitle());
            temporaryTeamMap.put("teamLabels", team.getLabel());
            temporaryTeamMap.put("teamColor", team.getColor());
            temporaryTeamMap.put("featureSprintOfTheTeam", new HashMap());
            if (PropertyValidator.isValid((Object)container)) {
                HashMap featureSprintOfTheTeam = (HashMap)temporaryTeamMap.get("featureSprintOfTheTeam");
                featureSprintOfTheTeam.put(String.valueOf(container.getId()), String.valueOf(container.getId()));
            }
            if (rawItem.get("type").equals(Item.FEATURE)) {
                temporaryTeamMap.put("doneStoryPoints", 0.0);
                temporaryTeamMap.put("toDoStoryPoints", 0.0);
                temporaryTeamMap.put("inProgressStoryPoints", 0.0);
                temporaryTeamMap.put("miscStoryPoints", 0.0);
                temporaryTeamMap.put("totalStoryPoints", 0.0);
                temporaryTeamMap.put("doneStoriesCount", new ArrayList());
                temporaryTeamMap.put("toDoStoriesCount", new ArrayList());
                temporaryTeamMap.put("inProgressStoriesCount", new ArrayList());
                temporaryTeamMap.put("totalStoriesCount", new ArrayList());
                temporaryTeamMap.put("miscStoriesCount", new ArrayList());
                temporaryTeamMap.put("sprintDetailsInTeam", new HashMap());
            }
        }
        if (PropertyValidator.isValid((Object)container)) {
            temporarySprintMap.put("container", container.getTitle());
            temporarySprintMap.put("containerLabel", container.getLabel());
            temporarySprintMap.put("containerId", container.getId());
            temporarySprintMap.put("sequence", container.getSequence());
            if (container.getOriginItemId() != null) {
                temporarySprintMap.put("sprintOriginItemId", container.getOriginItemId());
            } else if (container.getDuplicateOfId() != null) {
                temporarySprintMap.put("sprintDuplicateOfId", container.getDuplicateOfId());
            }
            temporarySprintMap.put("featureTeamOfTheSprint", new HashMap());
            if (team != null) {
                HashMap<String, String> temporarySprintTeamMap = new HashMap<String, String>();
                temporarySprintTeamMap.put("teamId", team.getId());
                temporarySprintTeamMap.put("teamTitle", team.getTitle());
                temporarySprintTeamMap.put("teamLabels", team.getLabel());
                temporarySprintTeamMap.put("teamColor", team.getColor());
                HashMap featureTeamOfTheSprint = (HashMap)temporarySprintMap.get("featureTeamOfTheSprint");
                featureTeamOfTheSprint.put(String.valueOf(team.getId()), temporarySprintTeamMap);
            }
        }
        HashMap getTemporaryMapForCheckItemData = (HashMap)mapForCheckingNoTeamAndSprintComesDouble.get(String.valueOf(rawItem.get("_id")));
        if (PropertyValidator.isValid((Object)team)) {
            if (getTemporaryMapForCheckItemData.get(String.valueOf(team.getId())) == null) {
                HashMap getIteamTeamArray;
                itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                if (PropertyValidator.isValid((Object)itemTeamAndSprintMap) && PropertyValidator.isValid((Object)(getIteamTeamArray = (HashMap)itemTeamAndSprintMap.get("teams")))) {
                    getTemporaryMapForCheckItemData.put(String.valueOf(team.getId()), team.getId());
                    getIteamTeamArray.put(String.valueOf(team.getId()), temporaryTeamMap);
                }
            } else {
                HashMap featureSprintOfTheTeam;
                HashMap getItemTeam;
                HashMap getItemTeamArray;
                itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                if (PropertyValidator.isValid((Object)itemTeamAndSprintMap) && PropertyValidator.isValid((Object)(getItemTeamArray = (HashMap)itemTeamAndSprintMap.get("teams"))) && PropertyValidator.isValid((Object)(getItemTeam = (HashMap)getItemTeamArray.get(String.valueOf(team.getId())))) && PropertyValidator.isValid((Object)(featureSprintOfTheTeam = (HashMap)getItemTeam.get("featureSprintOfTheTeam")))) {
                    featureSprintOfTheTeam.put(String.valueOf(container.getId()), String.valueOf(container.getId()));
                }
            }
            DBRef parentId = (DBRef)rawItem.get("parent");
            if (rawItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)parentId) && PropertyValidator.isValid((Object)parentId.getId()) && itemTeamAndSprintMapByItemId.get(String.valueOf(parentId.getId())) == null) {
                mapForCheckingNoTeamAndSprintComesDouble.put(String.valueOf(parentId.getId()), new HashMap());
                HashMap itemTeamAndSprintArraysMapByName = new HashMap();
                itemTeamAndSprintArraysMapByName.put("sprints", new HashMap());
                itemTeamAndSprintArraysMapByName.put("teams", new HashMap());
                itemTeamAndSprintMapByItemId.put(String.valueOf(parentId.getId()), itemTeamAndSprintArraysMapByName);
            }
            if (rawItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)parentId) && PropertyValidator.isValid((Object)parentId.getId())) {
                HashMap getTemporaryMapForCheckItemDataForFeatureStoryPoints = (HashMap)mapForCheckingNoTeamAndSprintComesDouble.get(String.valueOf(parentId.getId()));
                if (team != null && getTemporaryMapForCheckItemDataForFeatureStoryPoints.get(String.valueOf(team.getId())) == null) {
                    HashMap<String, Object> temporaryTeamMapForFeature = new HashMap<String, Object>();
                    temporaryTeamMapForFeature.put("teamId", team.getId());
                    temporaryTeamMapForFeature.put("teamTitle", team.getTitle());
                    temporaryTeamMapForFeature.put("teamLabels", team.getLabel());
                    temporaryTeamMapForFeature.put("teamColor", team.getColor());
                    temporaryTeamMapForFeature.put("doneStoryPoints", 0.0);
                    temporaryTeamMapForFeature.put("toDoStoryPoints", 0.0);
                    temporaryTeamMapForFeature.put("inProgressStoryPoints", 0.0);
                    temporaryTeamMapForFeature.put("miscStoryPoints", 0.0);
                    temporaryTeamMapForFeature.put("totalStoryPoints", 0.0);
                    temporaryTeamMapForFeature.put("doneStoriesCount", new ArrayList());
                    temporaryTeamMapForFeature.put("toDoStoriesCount", new ArrayList());
                    temporaryTeamMapForFeature.put("inProgressStoriesCount", new ArrayList());
                    temporaryTeamMapForFeature.put("miscStoriesCount", new ArrayList());
                    temporaryTeamMapForFeature.put("totalStoriesCount", new ArrayList());
                    temporaryTeamMapForFeature.put("sprintDetailsInTeam", new HashMap());
                    HashMap itemTeamAndSprintMap2 = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(parentId.getId()));
                    if (PropertyValidator.isValid((Object)itemTeamAndSprintMap2) && itemTeamAndSprintMap2.get("teams") != null) {
                        HashMap getIteamTeamArray = (HashMap)itemTeamAndSprintMap2.get("teams");
                        getTemporaryMapForCheckItemDataForFeatureStoryPoints.put(String.valueOf(team.getId()), team.getId());
                        getIteamTeamArray.put(String.valueOf(team.getId()), temporaryTeamMapForFeature);
                    }
                }
                if (getTemporaryMapForCheckItemDataForFeatureStoryPoints.get(String.valueOf(team.getId())) != null && status != null) {
                    try {
                        HashMap itemTeamAndSprintMap3 = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(parentId.getId()));
                        HashMap getIteamTeamMap = (HashMap)itemTeamAndSprintMap3.get("teams");
                        HashMap temporaryTeamMapForFeature = (HashMap)getIteamTeamMap.get(String.valueOf(team.getId()));
                        HashMap sprintDetailsInTheTeam = (HashMap)temporaryTeamMapForFeature.get("sprintDetailsInTeam");
                        if (PropertyValidator.isValid((Object)sprintDetailsInTheTeam)) {
                            ArrayList updateSingleSprintMapInTheTeam;
                            ArrayList updateTemporaryTeamMapForFeature;
                            HashMap<String, Object> singleSprintMapInTheTeam;
                            if (PropertyValidator.isValid((Object)container) && sprintDetailsInTheTeam.get(String.valueOf(container.getId())) == null) {
                                singleSprintMapInTheTeam = new HashMap<String, Object>();
                                singleSprintMapInTheTeam.put("container", container.getTitle());
                                singleSprintMapInTheTeam.put("containerLabel", container.getLabel());
                                singleSprintMapInTheTeam.put("doneStoryPoints", 0.0);
                                singleSprintMapInTheTeam.put("totalStoryPoints", 0.0);
                                singleSprintMapInTheTeam.put("doneStoriesCount", new ArrayList());
                                singleSprintMapInTheTeam.put("totalStoriesCount", new ArrayList());
                                sprintDetailsInTheTeam.put(String.valueOf(container.getId()), singleSprintMapInTheTeam);
                            }
                            singleSprintMapInTheTeam = (HashMap<String, Object>)sprintDetailsInTheTeam.get(String.valueOf(container.getId()));
                            if (PropertyValidator.isValid((Object)status) && PropertyValidator.isValid((Object)status.getCategory())) {
                                if (status.getCategory().equals("Done")) {
                                    updateTemporaryTeamMapForFeature = (ArrayList)temporaryTeamMapForFeature.get("doneStoriesCount");
                                    updateTemporaryTeamMapForFeature.add(String.valueOf(rawItem.get("_id")));
                                    updateSingleSprintMapInTheTeam = (ArrayList)singleSprintMapInTheTeam.get("doneStoriesCount");
                                    updateSingleSprintMapInTheTeam.add(String.valueOf(rawItem.get("_id")));
                                    if (rawItem.get("storyPoints") != null) {
                                        temporaryTeamMapForFeature.put("doneStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("doneStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        temporaryTeamMapForFeature.put("totalStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        singleSprintMapInTheTeam.put("totalStoryPoints", Double.valueOf(String.valueOf(singleSprintMapInTheTeam.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        singleSprintMapInTheTeam.put("doneStoryPoints", Double.valueOf(String.valueOf(singleSprintMapInTheTeam.get("doneStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                    }
                                } else if (status.getCategory().equals("InProgress")) {
                                    updateTemporaryTeamMapForFeature = (ArrayList)temporaryTeamMapForFeature.get("inProgressStoriesCount");
                                    updateTemporaryTeamMapForFeature.add(String.valueOf(rawItem.get("_id")));
                                    if (rawItem.get("storyPoints") != null) {
                                        temporaryTeamMapForFeature.put("inProgressStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("inProgressStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        temporaryTeamMapForFeature.put("totalStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        singleSprintMapInTheTeam.put("totalStoryPoints", Double.valueOf(String.valueOf(singleSprintMapInTheTeam.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                    }
                                } else if (status.getCategory().equals("ToDo")) {
                                    updateTemporaryTeamMapForFeature = (ArrayList)temporaryTeamMapForFeature.get("toDoStoriesCount");
                                    updateTemporaryTeamMapForFeature.add(String.valueOf(rawItem.get("_id")));
                                    if (rawItem.get("storyPoints") != null) {
                                        temporaryTeamMapForFeature.put("totalStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        temporaryTeamMapForFeature.put("toDoStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("toDoStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        singleSprintMapInTheTeam.put("totalStoryPoints", Double.valueOf(String.valueOf(singleSprintMapInTheTeam.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                    }
                                } else if (status.getCategory().equals("Misc")) {
                                    updateTemporaryTeamMapForFeature = (ArrayList)temporaryTeamMapForFeature.get("miscStoriesCount");
                                    updateTemporaryTeamMapForFeature.add(String.valueOf(rawItem.get("_id")));
                                    if (rawItem.get("storyPoints") != null) {
                                        temporaryTeamMapForFeature.put("totalStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        temporaryTeamMapForFeature.put("miscStoryPoints", Double.valueOf(String.valueOf(temporaryTeamMapForFeature.get("miscStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                        singleSprintMapInTheTeam.put("totalStoryPoints", Double.valueOf(String.valueOf(singleSprintMapInTheTeam.get("totalStoryPoints"))) + (Double)rawItem.get("storyPoints"));
                                    }
                                }
                            }
                            updateTemporaryTeamMapForFeature = (ArrayList)temporaryTeamMapForFeature.get("totalStoriesCount");
                            updateTemporaryTeamMapForFeature.add(String.valueOf(rawItem.get("_id")));
                            updateSingleSprintMapInTheTeam = (ArrayList)singleSprintMapInTheTeam.get("totalStoriesCount");
                            updateSingleSprintMapInTheTeam.add(String.valueOf(rawItem.get("_id")));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        if (PropertyValidator.isValid((Object)container) && getTemporaryMapForCheckItemData.get(String.valueOf(container.getId())) == null) {
            itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
            getIteamSprintArray = (HashMap)itemTeamAndSprintMap.get("sprints");
            getTemporaryMapForCheckItemData.put(String.valueOf(container.getId()), container.getId());
            getIteamSprintArray.put(String.valueOf(container.getId()), temporarySprintMap);
        } else if (PropertyValidator.isValid((Object)container) && getTemporaryMapForCheckItemData.containsKey(String.valueOf(container.getId()))) {
            itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
            getIteamSprintArray = (HashMap)itemTeamAndSprintMap.get("sprints");
            HashMap getIteamSprint = (HashMap)getIteamSprintArray.get(String.valueOf(container.getId()));
            HashMap getFeatureTeamOfTheSprintMap = new HashMap();
            if (getIteamSprint.containsKey("featureTeamOfTheSprint")) {
                getFeatureTeamOfTheSprintMap = (HashMap)getIteamSprint.get("featureTeamOfTheSprint");
            } else {
                getIteamSprint.put("featureTeamOfTheSprint", new HashMap());
                getFeatureTeamOfTheSprintMap = (HashMap)getIteamSprint.get("featureTeamOfTheSprint");
            }
            HashMap featureTeamOfTheSprint = (HashMap)temporarySprintMap.get("featureTeamOfTheSprint");
            if (team != null && PropertyValidator.isValid((Object)featureTeamOfTheSprint)) {
                HashMap getsprintTeam = (HashMap)featureTeamOfTheSprint.get(String.valueOf(team.getId()));
                getFeatureTeamOfTheSprintMap.put(String.valueOf(team.getId()), getsprintTeam);
            }
        }
    }

    private HashMap<String, Object> putItemDetailsInMap(DBObject rawItem, HashMap<String, Object> itemTeamAndSprintMapByItemId, Status status) {
        try {
            HashMap<String, Object> rawItemDetails = new HashMap<String, Object>();
            HashMap itemkey = this.getItemJirsOrTFSKey(rawItem);
            if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                HashMap itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                if (itemTeamAndSprintMap.get("teams") != null) {
                    rawItemDetails.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                }
                if (itemTeamAndSprintMap.get("sprints") != null) {
                    rawItemDetails.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                }
            }
            if (rawItem.get("type").equals(Item.USER_STORY)) {
                rawItemDetails.put("Estimate", rawItem.get("storyPoints"));
                DBRef parentId = (DBRef)rawItem.get("parent");
                if (PropertyValidator.isValid((Object)parentId)) {
                    rawItemDetails.put("parent", String.valueOf(parentId.getId()));
                }
            } else if (PropertyValidator.isValid((Object)rawItem.get("issueType"))) {
                DBRef cardTypeRef = (DBRef)rawItem.get("issueType");
                rawItemDetails.put("cardType", String.valueOf(cardTypeRef.getId()));
            } else {
                rawItemDetails.put("cardType", String.valueOf(-100));
            }
            rawItemDetails.put("key", itemkey.get("key"));
            rawItemDetails.put("keyType", itemkey.get("keyType"));
            rawItemDetails.put("keyLink", itemkey.get("keyLink"));
            rawItemDetails.put("type", rawItem.get("type"));
            rawItemDetails.put("_id", String.valueOf(rawItem.get("_id")));
            rawItemDetails.put("id", String.valueOf(rawItem.get("_id")));
            rawItemDetails.put("Details", rawItem.get("title"));
            rawItemDetails.put("key", itemkey.get("key"));
            rawItemDetails.put("keyType", itemkey.get("keyType"));
            rawItemDetails.put("keyLink", itemkey.get("keyLink"));
            rawItemDetails.put("type", rawItem.get("type"));
            rawItemDetails.put("_id", String.valueOf(rawItem.get("_id")));
            rawItemDetails.put("id", String.valueOf(rawItem.get("_id")));
            rawItemDetails.put("Details", rawItem.get("title"));
            rawItemDetails.put("tfsId", rawItem.get("tfsId"));
            rawItemDetails.put("tfsURL", rawItem.get("tfsURL"));
            rawItemDetails.put("tfsApiURL", rawItem.get("tfsApiURL"));
            rawItemDetails.put("tfsProjectId", rawItem.get("tfsProjectId"));
            rawItemDetails.put("tfsProject", rawItem.get("tfsProject"));
            rawItemDetails.put("tfsItemType", rawItem.get("tfsItemType"));
            rawItemDetails.put("tfsItemTypeIcon", rawItem.get("tfsItemTypeIcon"));
            rawItemDetails.put("tfsFilter", rawItem.get("tfsFilter"));
            rawItemDetails.put("tfsAreaPath", rawItem.get("tfsAreaPath"));
            rawItemDetails.put("tfsIterationPath", rawItem.get("tfsIterationPath"));
            rawItemDetails.put("jiraKey", rawItem.get("jiraKey"));
            rawItemDetails.put("jiraId", rawItem.get("jiraId"));
            rawItemDetails.put("jiraFilter", rawItem.get("jiraFilter"));
            rawItemDetails.put("jiraProjectKey", rawItem.get("jiraProjectKey"));
            rawItemDetails.put("jiraIssueTypeId", rawItem.get("jiraIssueTypeId"));
            if (rawItem.get("originItemId") != null) {
                rawItemDetails.put("originItemId", String.valueOf(rawItem.get("originItemId")));
            }
            if (status != null) {
                if (PropertyValidator.isValid((Object)status.getTitle())) {
                    rawItemDetails.put("Status", status.getTitle());
                } else {
                    rawItemDetails.put("Status", "N/A");
                }
                rawItemDetails.put("Category", status.getCategory());
            }
            if (PropertyValidator.isValid((Object)rawItem.get("backlogSequence"))) {
                rawItemDetails.put("backlogSequence", rawItem.get("backlogSequence"));
            }
            if (PropertyValidator.isValid((Object)rawItem.get("sequence"))) {
                rawItemDetails.put("sequence", rawItem.get("sequence"));
            }
            return new HashMap<String, Object>(rawItemDetails);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private HashMap<String, Object> getBoardScopeChangeData(HashMap<String, Object> boardScopChangeDataForFUnction, double totalNumberofStoryPoints, double numberOfStoryPointsAddedInTrakingState, int numberOfStoriesAddedInTrakingState, int trackingFeaturesCount) {
        try {
            DBObject rawItem = (DBObject)boardScopChangeDataForFUnction.get("rawItem");
            ArrayList storiesAddedInTracking = (ArrayList)boardScopChangeDataForFUnction.get("storiesAddedInTracking");
            HashMap getItemDetailsInMap = (HashMap)boardScopChangeDataForFUnction.get("getItemDetailsInMap");
            ArrayList featuresAddedInTracking = (ArrayList)boardScopChangeDataForFUnction.get("featuresAddedInTracking");
            HashMap previousStateItemsMapBy_Ids_OR_OriginItemId = (HashMap)boardScopChangeDataForFUnction.get("previousStateItemsMapBy_Ids_OR_OriginItemId");
            HashMap<String, String> itemInTracking = new HashMap<String, String>(getItemDetailsInMap);
            Date date = (Date)rawItem.get("createdOn");
            if (date != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMM/dd/yyyy");
                String strDate = dateFormat.format(date);
                itemInTracking.put("createdDate", strDate);
            } else {
                itemInTracking.put("createdDate", "  ---");
            }
            if (rawItem.get("type").equals(Item.USER_STORY)) {
                if (rawItem.get("storyPoints") != null) {
                    totalNumberofStoryPoints += ((Double)rawItem.get("storyPoints")).doubleValue();
                }
                if (rawItem.get("originItemId") != null && !PropertyValidator.isValid(previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId")))) || rawItem.get("originItemId") == null && !PropertyValidator.isValid(previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("id"))))) {
                    ++numberOfStoriesAddedInTrakingState;
                    if (rawItem.get("storyPoints") != null) {
                        numberOfStoryPointsAddedInTrakingState += ((Double)rawItem.get("storyPoints")).doubleValue();
                    }
                    storiesAddedInTracking.add(itemInTracking);
                }
            } else if (rawItem.get("type").equals(Item.FEATURE) && (rawItem.get("originItemId") != null && !PropertyValidator.isValid(previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("originItemId")))) || rawItem.get("originItemId") == null && !PropertyValidator.isValid(previousStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(rawItem.get("id")))))) {
                ++trackingFeaturesCount;
                featuresAddedInTracking.add(itemInTracking);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> boardScopChangeCounts = new HashMap<String, Object>();
        boardScopChangeCounts.put("totalNumberofStoryPoints", totalNumberofStoryPoints);
        boardScopChangeCounts.put("numberOfStoryPointsAddedInTrakingState", numberOfStoryPointsAddedInTrakingState);
        boardScopChangeCounts.put("numberOfStoriesAddedInTrakingState", numberOfStoriesAddedInTrakingState);
        boardScopChangeCounts.put("trackingFeaturesCount", trackingFeaturesCount);
        return boardScopChangeCounts;
    }

    private void getDifferenceOfStoryPointsByStateOfItemMapByItemId(DBObject rawItem, DBObject previousItem, HashMap<String, Object> changeOfStoryPointsInCurrentAndPreviousStateOfStory) {
        try {
            Double storyPoints;
            if (changeOfStoryPointsInCurrentAndPreviousStateOfStory.get(String.valueOf(rawItem.get("_id"))) == null) {
                HashMap estimateOfStory = new HashMap();
                changeOfStoryPointsInCurrentAndPreviousStateOfStory.put(String.valueOf(rawItem.get("_id")), estimateOfStory);
            }
            HashMap getStoryPointOftheState = (HashMap)changeOfStoryPointsInCurrentAndPreviousStateOfStory.get(String.valueOf(rawItem.get("_id")));
            getStoryPointOftheState.put("previousStateEstimate", 0.0);
            if (PropertyValidator.isValid((Object)previousItem.get("storyPoints")) && Double.isNaN(storyPoints = (Double)previousItem.get("storyPoints"))) {
                getStoryPointOftheState.put("previousStateEstimate", previousItem.get("storyPoints"));
            }
            getStoryPointOftheState.put("currentStateEstimate", 0.0);
            if (PropertyValidator.isValid((Object)rawItem.get("storyPoints")) && Double.isNaN(storyPoints = (Double)rawItem.get("storyPoints"))) {
                getStoryPointOftheState.put("currentStateEstimate", rawItem.get("storyPoints"));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private HashMap<String, Object> getItemDataMapByItemStatus(HashMap<String, Object> itemByStatusFunctionData, DBObject rawItem) {
        try {
            HashMap getItemDetailsInMap = (HashMap)itemByStatusFunctionData.get("itemDetailes");
            Status status = (Status)itemByStatusFunctionData.get("status");
            HashMap featureMapByStatus = (HashMap)itemByStatusFunctionData.get("featureMapByStatus");
            HashMap featuresCompletion = (HashMap)itemByStatusFunctionData.get("featuresCompletion");
            HashMap featureMapById = (HashMap)itemByStatusFunctionData.get("featureMapById");
            HashMap storiesMayByStatus = (HashMap)itemByStatusFunctionData.get("storiesMayByStatus");
            HashMap storyCompletion = (HashMap)itemByStatusFunctionData.get("storyCompletion");
            HashMap storyPointsCompletion = (HashMap)itemByStatusFunctionData.get("storyPointsCompletion");
            String type = (String)rawItem.get("type");
            if (type.equals(Item.FEATURE)) {
                if (PropertyValidator.isValid((Object)status) && featureMapByStatus.get(status.getCategory()) == null) {
                    featureMapByStatus.put(status.getCategory(), new ArrayList());
                }
                if (featureMapById.get(String.valueOf(rawItem.get("_id"))) != null) {
                    HashMap parentFeatureDetailes = (HashMap)featureMapById.get(String.valueOf(rawItem.get("_id")));
                    getItemDetailsInMap.put("unPlanned", false);
                    getItemDetailsInMap.put("unPlannedEstimate", parentFeatureDetailes.get("unPlannedEstimate"));
                    getItemDetailsInMap.put("unPlannedToDoStoryCount", parentFeatureDetailes.get("unPlannedToDoStoryCount"));
                    getItemDetailsInMap.put("unPlannedInProgressStoryCount", parentFeatureDetailes.get("unPlannedInProgressStoryCount"));
                    getItemDetailsInMap.put("unPlannedDoneStoryCount", parentFeatureDetailes.get("unPlannedDoneStoryCount"));
                    getItemDetailsInMap.put("unPlannedMiscStoryCount", parentFeatureDetailes.get("unPlannedMiscStoryCount"));
                    getItemDetailsInMap.put("unPlannedDoneStoryPoint", parentFeatureDetailes.get("unPlannedDoneStoryPoint"));
                    getItemDetailsInMap.put("unPlannedToDoStoryPoint", parentFeatureDetailes.get("unPlannedToDoStoryPoint"));
                    getItemDetailsInMap.put("unPlannedInProgressStoryPoint", parentFeatureDetailes.get("unPlannedInProgressStoryPoint"));
                    getItemDetailsInMap.put("unPlannedMiscStoryPoint", parentFeatureDetailes.get("unPlannedMiscStoryPoint"));
                    getItemDetailsInMap.put("Planned", true);
                    getItemDetailsInMap.put("Estimate", parentFeatureDetailes.get("Estimate"));
                    getItemDetailsInMap.put("ToDoStoryCount", parentFeatureDetailes.get("ToDoStoryCount"));
                    getItemDetailsInMap.put("InProgressStoryCount", parentFeatureDetailes.get("InProgressStoryCount"));
                    getItemDetailsInMap.put("DoneStoryCount", parentFeatureDetailes.get("DoneStoryCount"));
                    getItemDetailsInMap.put("MiscStoryCount", parentFeatureDetailes.get("MiscStoryCount"));
                    getItemDetailsInMap.put("doneStoryPoint", parentFeatureDetailes.get("doneStoryPoint"));
                    getItemDetailsInMap.put("toDoStoryPoint", parentFeatureDetailes.get("toDoStoryPoint"));
                    getItemDetailsInMap.put("inProgressStoryPoint", parentFeatureDetailes.get("inProgressStoryPoint"));
                    getItemDetailsInMap.put("miscStoryPoint", parentFeatureDetailes.get("miscStoryPoint"));
                } else {
                    getItemDetailsInMap.put("unPlanned", false);
                    getItemDetailsInMap.put("unPlannedEstimate", 0);
                    getItemDetailsInMap.put("unPlannedToDoStoryCount", new ArrayList());
                    getItemDetailsInMap.put("unPlannedInProgressStoryCount", new ArrayList());
                    getItemDetailsInMap.put("unPlannedDoneStoryCount", new ArrayList());
                    getItemDetailsInMap.put("unPlannedMiscStoryCount", new ArrayList());
                    getItemDetailsInMap.put("unPlannedDoneStoryPoint", 0);
                    getItemDetailsInMap.put("unPlannedToDoStoryPoint", 0);
                    getItemDetailsInMap.put("unPlannedInProgressStoryPoint", 0);
                    getItemDetailsInMap.put("unPlannedMiscStoryPoint", 0);
                    getItemDetailsInMap.put("Planned", true);
                    getItemDetailsInMap.put("Estimate", 0);
                    getItemDetailsInMap.put("ToDoStoryCount", new ArrayList());
                    getItemDetailsInMap.put("InProgressStoryCount", new ArrayList());
                    getItemDetailsInMap.put("DoneStoryCount", new ArrayList());
                    getItemDetailsInMap.put("MiscStoryCount", new ArrayList());
                    getItemDetailsInMap.put("doneStoryPoint", 0);
                    getItemDetailsInMap.put("toDoStoryPoint", 0);
                    getItemDetailsInMap.put("inProgressStoryPoint", 0);
                    getItemDetailsInMap.put("miscStoryPoint", 0);
                }
                if (PropertyValidator.isValid((Object)status)) {
                    Integer count = (Integer)featuresCompletion.get(status.getCategory());
                    if (count == null) {
                        count = 0;
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    ArrayList featureList = (ArrayList)featureMapByStatus.get(status.getCategory());
                    getItemDetailsInMap.put("Planned", true);
                    featureList.add(getItemDetailsInMap);
                    featureMapByStatus.put(status.getCategory(), featureList);
                    featuresCompletion.put(status.getCategory(), count);
                }
                featureMapById.put(String.valueOf(rawItem.get("_id")), getItemDetailsInMap);
            } else {
                DBRef parent = (DBRef)rawItem.get("parent");
                if (PropertyValidator.isValid((Object)parent)) {
                    if (featureMapById.get(String.valueOf(parent.getId())) == null) {
                        HashMap<String, Serializable> parentFeatureDetailes = new HashMap<String, Serializable>();
                        parentFeatureDetailes.put("unPlannedEstimate", Integer.valueOf(0));
                        parentFeatureDetailes.put("unPlannedToDoStoryCount", new ArrayList());
                        parentFeatureDetailes.put("unPlannedInProgressStoryCount", new ArrayList());
                        parentFeatureDetailes.put("unPlannedDoneStoryCount", new ArrayList());
                        parentFeatureDetailes.put("unPlannedMiscStoryCount", new ArrayList());
                        parentFeatureDetailes.put("unPlannedDoneStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("unPlannedToDoStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("unPlannedInProgressStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("unPlannedMiscStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("Estimate", Integer.valueOf(0));
                        parentFeatureDetailes.put("ToDoStoryCount", new ArrayList());
                        parentFeatureDetailes.put("InProgressStoryCount", new ArrayList());
                        parentFeatureDetailes.put("DoneStoryCount", new ArrayList());
                        parentFeatureDetailes.put("MiscStoryCount", new ArrayList());
                        parentFeatureDetailes.put("doneStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("toDoStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("inProgressStoryPoint", Integer.valueOf(0));
                        parentFeatureDetailes.put("miscStoryPoint", Integer.valueOf(0));
                        featureMapById.put(String.valueOf(parent.getId()), parentFeatureDetailes);
                    }
                    HashMap getfeatureStoriesData = (HashMap)featureMapById.get(String.valueOf(parent.getId()));
                    Double storyPoints = 0.0;
                    if (status != null) {
                        Integer count;
                        ArrayList updateUnplannedData;
                        if (status.getCategory().equalsIgnoreCase("ToDo")) {
                            updateUnplannedData = (ArrayList)getfeatureStoriesData.get("ToDoStoryCount");
                            updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                            if (rawItem.get("storyPoints") != null) {
                                getfeatureStoriesData.put("toDoStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("toDoStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                            }
                        } else if (status.getCategory().equalsIgnoreCase("InProgress")) {
                            updateUnplannedData = (ArrayList)getfeatureStoriesData.get("InProgressStoryCount");
                            updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                            if (rawItem.get("storyPoints") != null) {
                                getfeatureStoriesData.put("inProgressStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("inProgressStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                            }
                        } else if (status.getCategory().equalsIgnoreCase("Done")) {
                            updateUnplannedData = (ArrayList)getfeatureStoriesData.get("DoneStoryCount");
                            updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                            if (rawItem.get("storyPoints") != null) {
                                getfeatureStoriesData.put("doneStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("doneStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                            }
                        } else {
                            updateUnplannedData = (ArrayList)getfeatureStoriesData.get("MiscStoryCount");
                            updateUnplannedData.add(String.valueOf(rawItem.get("_id")));
                            if (rawItem.get("storyPoints") != null) {
                                getfeatureStoriesData.put("miscStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("miscStoryPoint"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                            }
                        }
                        if (rawItem.get("storyPoints") != null) {
                            getfeatureStoriesData.put("Estimate", Double.valueOf(String.valueOf(getfeatureStoriesData.get("Estimate"))) + Double.valueOf(String.valueOf(rawItem.get("storyPoints"))));
                            storyPoints = (Double)rawItem.get("storyPoints");
                        }
                        if ((count = (Integer)storyCompletion.get(status.getCategory())) == null) {
                            count = 0;
                        }
                        Integer n = count;
                        Integer n3 = count = Integer.valueOf(count + 1);
                        if (storiesMayByStatus.get(status.getCategory()) == null) {
                            storiesMayByStatus.put(status.getCategory(), new ArrayList());
                        }
                        ArrayList storyList = (ArrayList)storiesMayByStatus.get(status.getCategory());
                        storyList.add(getItemDetailsInMap);
                        storiesMayByStatus.put(status.getCategory(), storyList);
                        storyCompletion.put(status.getCategory(), count);
                        Double storyPointsTotal = (Double)storyPointsCompletion.get(status.getCategory());
                        if (storyPointsTotal == null) {
                            storyPointsTotal = 0.0;
                        }
                        storyPointsTotal = storyPointsTotal + storyPoints;
                        storyPointsCompletion.put(status.getCategory(), storyPointsTotal);
                    }
                }
            }
            HashMap<String, Object> totalFeatureAndStoryCount = new HashMap<String, Object>();
            return totalFeatureAndStoryCount;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private HashMap<String, Object> deliveryVariations(HashMap<String, Object> variationFunctionDataMap) {
        HashMap itemTeamAndSprintMap;
        DBRef parentId;
        Container currentContainer;
        ArrayList currentTeamContainers = (ArrayList)variationFunctionDataMap.get("currentTeamContainers");
        ArrayList previousTeamContainers = (ArrayList)variationFunctionDataMap.get("previousTeamContainers");
        ArrayList featureChangeSprint = (ArrayList)variationFunctionDataMap.get("featureChangeSprint");
        ArrayList storyChangeSprint = (ArrayList)variationFunctionDataMap.get("storyChangeSprint");
        HashMap itemTeamAndSprintMapByItemId = (HashMap)variationFunctionDataMap.get("itemTeamAndSprintMapByItemId");
        HashMap previousStateItemTeamAndSprintMapByItemId = (HashMap)variationFunctionDataMap.get("previousStateItemTeamAndSprintMapByItemId");
        HashMap itemKey = (HashMap)variationFunctionDataMap.get("itemKey");
        DBObject rawItem = (DBObject)variationFunctionDataMap.get("rawItem");
        DBObject previousItem = (DBObject)variationFunctionDataMap.get("previousItem");
        Status status = (Status)variationFunctionDataMap.get("status");
        int featuresChanged = (Integer)variationFunctionDataMap.get("featuresChanged");
        int storiesChanged = (Integer)variationFunctionDataMap.get("storiesChanged");
        HashMap currentStateItemsMapById = (HashMap)variationFunctionDataMap.get("currentStateItemsMapById");
        Container previousDeliveryContainer = null;
        Container curentDeliveryContainer = null;
        double maxSequence = 0.0;
        for (TeamContainer tC : previousTeamContainers) {
            currentContainer = tC.getContainer();
            if (!(currentContainer.getSequence() > maxSequence)) continue;
            previousDeliveryContainer = currentContainer;
            maxSequence = currentContainer.getSequence();
        }
        maxSequence = 0.0;
        for (TeamContainer tC : currentTeamContainers) {
            currentContainer = tC.getContainer();
            if (!(currentContainer.getSequence() > maxSequence)) continue;
            curentDeliveryContainer = currentContainer;
            maxSequence = currentContainer.getSequence();
        }
        HashMap<String, Object> itemVariationData = new HashMap<String, Object>();
        itemVariationData.put("Details", rawItem.get("title"));
        if (status != null) {
            itemVariationData.put("Status", status.getTitle());
            itemVariationData.put("Category", status.getCategory());
        } else {
            itemVariationData.put("Status", "NA");
            itemVariationData.put("Category", "NA");
        }
        itemVariationData.put("key", itemKey.get("key"));
        itemVariationData.put("keyType", itemKey.get("keyType"));
        itemVariationData.put("keyLink", itemKey.get("keyLink"));
        itemVariationData.put("id", String.valueOf(rawItem.get("_id")));
        itemVariationData.put("tfsId", rawItem.get("tfsId"));
        itemVariationData.put("tfsURL", rawItem.get("tfsURL"));
        itemVariationData.put("tfsApiURL", rawItem.get("tfsApiURL"));
        itemVariationData.put("tfsProjectId", rawItem.get("tfsProjectId"));
        itemVariationData.put("tfsProject", rawItem.get("tfsProject"));
        itemVariationData.put("tfsItemType", rawItem.get("tfsItemType"));
        itemVariationData.put("tfsItemTypeIcon", rawItem.get("tfsItemTypeIcon"));
        itemVariationData.put("tfsFilter", rawItem.get("tfsFilter"));
        itemVariationData.put("tfsAreaPath", rawItem.get("tfsAreaPath"));
        itemVariationData.put("tfsIterationPath", rawItem.get("tfsIterationPath"));
        itemVariationData.put("jiraKey", rawItem.get("jiraKey"));
        itemVariationData.put("jiraId", rawItem.get("jiraId"));
        itemVariationData.put("jiraFilter", rawItem.get("jiraFilter"));
        itemVariationData.put("jiraProjectKey", rawItem.get("jiraProjectKey"));
        itemVariationData.put("jiraIssueTypeId", rawItem.get("jiraIssueTypeId"));
        if (previousItem.get("type").equals(Item.USER_STORY) && PropertyValidator.isValid((Object)(parentId = (DBRef)rawItem.get("parent"))) && PropertyValidator.isValid((Object)parentId.getId()) && currentStateItemsMapById.get(String.valueOf(parentId.getId())) != null) {
            DBObject parentItem = (DBObject)currentStateItemsMapById.get(String.valueOf(parentId.getId()));
            HashMap itemkey = this.getItemJirsOrTFSKey(parentItem);
            itemVariationData.put("parentkey", itemkey.get("key"));
            itemVariationData.put("parentkeyType", itemkey.get("keyType"));
            itemVariationData.put("parentkeyLink", itemkey.get("keyLink"));
            itemVariationData.put("parentDetails", parentItem.get("title"));
            itemVariationData.put("parentTfsId", parentItem.get("tfsId"));
            itemVariationData.put("parentTfsURL", parentItem.get("tfsURL"));
            itemVariationData.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
            itemVariationData.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
            itemVariationData.put("parentTfsProject", parentItem.get("tfsProject"));
            itemVariationData.put("parentTfsItemType", parentItem.get("tfsItemType"));
            itemVariationData.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
            itemVariationData.put("parentTfsFilter", parentItem.get("tfsFilter"));
            itemVariationData.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
            itemVariationData.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
            itemVariationData.put("parentJiraKey", parentItem.get("jiraKey"));
            itemVariationData.put("parentJiraId", parentItem.get("jiraId"));
            itemVariationData.put("parentJiraFilter", parentItem.get("jiraFilter"));
            itemVariationData.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
            itemVariationData.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
        }
        if (PropertyValidator.isValid((Object)rawItem.get("backlogSequence"))) {
            itemVariationData.put("backlogSequence", rawItem.get("backlogSequence"));
        }
        if (PropertyValidator.isValid((Object)rawItem.get("sequence"))) {
            itemVariationData.put("sequence", rawItem.get("sequence"));
        }
        if (curentDeliveryContainer != null && previousDeliveryContainer != null) {
            HashMap itemTeamAndSprintMap2;
            String currentSprintId = null;
            currentSprintId = curentDeliveryContainer.getOriginItemId() == null ? curentDeliveryContainer.getId() : curentDeliveryContainer.getOriginItemId();
            String previousSprintId = null;
            previousSprintId = previousDeliveryContainer.getOriginItemId() == null ? previousDeliveryContainer.getId() : previousDeliveryContainer.getOriginItemId();
            if (rawItem.get("type").equals(Item.FEATURE) && !currentSprintId.equalsIgnoreCase(previousSprintId)) {
                ++featuresChanged;
                if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                    itemTeamAndSprintMap2 = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                    if (itemTeamAndSprintMap2.get("teams") != null) {
                        itemVariationData.put("itemTeamData", itemTeamAndSprintMap2.get("teams"));
                    }
                    if (itemTeamAndSprintMap2.get("sprints") != null) {
                        itemVariationData.put("itemSprintData", itemTeamAndSprintMap2.get("sprints"));
                    }
                }
                if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id"))) != null) {
                    itemTeamAndSprintMap2 = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id")));
                    if (PropertyValidator.isValid(itemTeamAndSprintMap2.get("teams")) && !itemTeamAndSprintMap2.get("teams").equals(itemVariationData.get("itemTeamData"))) {
                        itemVariationData.put("previousStateItemTeamData", itemTeamAndSprintMap2.get("teams"));
                    }
                    if (PropertyValidator.isValid(itemTeamAndSprintMap2.get("sprints")) && !itemTeamAndSprintMap2.get("sprints").equals(itemVariationData.get("itemSprintData"))) {
                        itemVariationData.put("previousStateItemSprintData", itemTeamAndSprintMap2.get("sprints"));
                    }
                }
                featureChangeSprint.add(itemVariationData);
            } else if (rawItem.get("type").equals(Item.USER_STORY) && !currentSprintId.equalsIgnoreCase(previousSprintId)) {
                ++storiesChanged;
                itemVariationData.put("Estimate", rawItem.get("storyPoints"));
                if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                    itemTeamAndSprintMap2 = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                    if (itemTeamAndSprintMap2.get("teams") != null) {
                        itemVariationData.put("itemTeamData", itemTeamAndSprintMap2.get("teams"));
                    }
                    if (itemTeamAndSprintMap2.get("sprints") != null) {
                        itemVariationData.put("itemSprintData", itemTeamAndSprintMap2.get("sprints"));
                    }
                }
                if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id"))) != null) {
                    itemTeamAndSprintMap2 = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id")));
                    if (itemTeamAndSprintMap2.get("teams") != null && !itemTeamAndSprintMap2.get("teams").equals(itemVariationData.get("itemTeamData"))) {
                        itemVariationData.put("previousStateItemTeamData", itemTeamAndSprintMap2.get("teams"));
                    }
                    if (itemTeamAndSprintMap2.get("sprints") != null) {
                        itemVariationData.put("previousStateItemSprintData", itemTeamAndSprintMap2.get("sprints"));
                    }
                }
                storyChangeSprint.add(itemVariationData);
            }
        } else if (curentDeliveryContainer == null && previousDeliveryContainer != null) {
            if (rawItem.get("type").equals(Item.USER_STORY)) {
                ++storiesChanged;
                itemVariationData.put("Estimate", rawItem.get("storyPoints"));
                itemVariationData.put("currentTeamBacklog", "Backlog");
                itemVariationData.put("currentSprintBacklog", "Backlog");
                if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id"))) != null) {
                    itemTeamAndSprintMap = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id")));
                    if (itemTeamAndSprintMap.get("teams") != null) {
                        itemVariationData.put("previousStateItemTeamData", itemTeamAndSprintMap.get("teams"));
                    }
                    if (itemTeamAndSprintMap.get("sprints") != null) {
                        itemVariationData.put("previousStateItemSprintData", itemTeamAndSprintMap.get("sprints"));
                    }
                }
                storyChangeSprint.add(itemVariationData);
            } else if (rawItem.get("type").equals(Item.FEATURE)) {
                ++featuresChanged;
                itemVariationData.put("currentTeamBacklog", "Backlog");
                itemVariationData.put("currentSprintBacklog", "Backlog");
                if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id"))) != null) {
                    itemTeamAndSprintMap = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousItem.get("_id")));
                    if (itemTeamAndSprintMap.get("teams") != null) {
                        itemVariationData.put("previousStateItemTeamData", itemTeamAndSprintMap.get("teams"));
                    }
                    if (itemTeamAndSprintMap.get("sprints") != null) {
                        itemVariationData.put("previousStateItemSprintData", itemTeamAndSprintMap.get("sprints"));
                    }
                }
                featureChangeSprint.add(itemVariationData);
            }
        } else if (curentDeliveryContainer != null && previousDeliveryContainer == null) {
            if (rawItem.get("type").equals(Item.USER_STORY)) {
                ++storiesChanged;
                itemVariationData.put("Estimate", rawItem.get("storyPoints"));
                itemVariationData.put("previousTeamBacklog", "Backlog");
                itemVariationData.put("previousSprintBacklog", "Backlog");
                if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                    itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                    if (itemTeamAndSprintMap.get("teams") != null) {
                        itemVariationData.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                    }
                    if (itemTeamAndSprintMap.get("sprints") != null) {
                        itemVariationData.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                    }
                }
                storyChangeSprint.add(itemVariationData);
            } else if (rawItem.get("type").equals(Item.FEATURE)) {
                ++featuresChanged;
                itemVariationData.put("previousTeamBacklog", "Backlog");
                itemVariationData.put("previousSprintBacklog", "Backlog");
                if (itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id"))) != null) {
                    itemTeamAndSprintMap = (HashMap)itemTeamAndSprintMapByItemId.get(String.valueOf(rawItem.get("_id")));
                    if (itemTeamAndSprintMap.get("teams") != null) {
                        itemVariationData.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                    }
                    if (itemTeamAndSprintMap.get("sprints") != null) {
                        itemVariationData.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                    }
                }
                featureChangeSprint.add(itemVariationData);
            }
        }
        HashMap<String, Object> changeInCountOfFeatureAndStory = new HashMap<String, Object>();
        changeInCountOfFeatureAndStory.put("featuresChanged", featuresChanged);
        changeInCountOfFeatureAndStory.put("storiesChanged", storiesChanged);
        return changeInCountOfFeatureAndStory;
    }

    public HashMap<String, Object> getItemPath(String itemId) {
        try {
            long startTimeOfProcessing = System.currentTimeMillis();
            ArrayList<String> itemIdForPath = new ArrayList<String>();
            List rawItems = this.getSingleItemById(itemId);
            DBObject rawItem = (DBObject)rawItems.get(0);
            if (rawItem.get("originItemId") != null) {
                itemIdForPath.add(String.valueOf(rawItem.get("originItemId")));
            } else {
                itemIdForPath.add(itemId);
            }
            long startTime = System.currentTimeMillis();
            List itemCompleatPathHistory = this.getItemCompleatHistory(itemIdForPath);
            long endTime = System.currentTimeMillis();
            HashMap<String, Object> itemPathCompleatLog = new HashMap<String, Object>();
            for (DBObject spillOverItem : itemCompleatPathHistory) {
                if ("WEBHOOK".equals(spillOverItem.get("activitySource")) && "{}".equals(spillOverItem.get("changes"))) continue;
                if (itemPathCompleatLog.get("ItemPath") == null) {
                    itemPathCompleatLog.put("ItemPath", new ArrayList());
                }
                Map itemDataFromLog = (Map)spillOverItem.get("detail");
                List itemTeamContainerFromLogList = (List)itemDataFromLog.get("teamContainers");
                Map itemStatus = (Map)itemDataFromLog.get("status");
                ArrayList sprintsListOfAnItem = new ArrayList();
                ArrayList teamListOfAnItem = new ArrayList();
                HashMap checkDuplicateTeam = new HashMap();
                if (itemTeamContainerFromLogList != null) {
                    Map itemSessionBoardState = (Map)itemDataFromLog.get("sessionBoardState");
                    for (int i = 0; i < itemTeamContainerFromLogList.size(); ++i) {
                        HashMap itemTeamContainerFromLogMap = (HashMap)itemTeamContainerFromLogList.get(i);
                        HashMap itemTeamFromLog = (HashMap)itemTeamContainerFromLogMap.get("team");
                        HashMap itemContainerFromLog = (HashMap)itemTeamContainerFromLogMap.get("container");
                        if (checkDuplicateTeam.get(itemTeamFromLog.get("id")) == null) {
                            checkDuplicateTeam.put(String.valueOf(itemTeamFromLog.get("id")), itemTeamFromLog.get("id"));
                            HashMap itemNewTeamForSpillOver = new HashMap();
                            itemNewTeamForSpillOver.put("teamId", itemTeamFromLog.get("id"));
                            itemNewTeamForSpillOver.put("teamTitle", itemTeamFromLog.get("title"));
                            itemNewTeamForSpillOver.put("teamLabels", itemTeamFromLog.get("label"));
                            itemNewTeamForSpillOver.put("teamColor", itemTeamFromLog.get("color"));
                            teamListOfAnItem.add(itemNewTeamForSpillOver);
                        }
                        HashMap itemNewSprintForSpillOver = new HashMap();
                        itemNewSprintForSpillOver.put("container", itemContainerFromLog.get("title"));
                        itemNewSprintForSpillOver.put("containerLabel", itemContainerFromLog.get("label"));
                        itemNewSprintForSpillOver.put("containerId", itemContainerFromLog.get("id"));
                        sprintsListOfAnItem.add(itemNewSprintForSpillOver);
                    }
                    HashMap<String, Object> itemLogHistory = new HashMap<String, Object>();
                    Date date = (Date)spillOverItem.get("eventTime");
                    if (date != null) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM/dd/yyyy");
                        itemLogHistory.put("updateTime", dateFormat.format(date));
                    } else {
                        itemLogHistory.put("updateTime", "N/A");
                    }
                    if (spillOverItem.get("activityBy") != null) {
                        itemLogHistory.put("activityBy", spillOverItem.get("activityBy"));
                    } else {
                        itemLogHistory.put("activityBy", "NA");
                    }
                    if (itemDataFromLog.get("type").equals("UserStory") && itemDataFromLog.get("storyPoints") != null) {
                        itemLogHistory.put("storyPoints", itemDataFromLog.get("storyPoints"));
                    }
                    itemLogHistory.put("sprints", sprintsListOfAnItem.clone());
                    itemLogHistory.put("teams", teamListOfAnItem.clone());
                    itemLogHistory.put("state", itemSessionBoardState.get("title"));
                    if (PropertyValidator.isValid((Object)itemStatus)) {
                        itemLogHistory.put("category", itemStatus.get("category"));
                        itemLogHistory.put("status", itemStatus.get("title"));
                        itemLogHistory.put("statusColor", itemStatus.get("color"));
                    }
                    ArrayList getSpillOvreHistoryArray = (ArrayList)itemPathCompleatLog.get("ItemPath");
                    getSpillOvreHistoryArray.add(itemLogHistory);
                    sprintsListOfAnItem.clear();
                    teamListOfAnItem.clear();
                    continue;
                }
                HashMap<String, Object> itemLogHistory = new HashMap<String, Object>();
                Date date = (Date)spillOverItem.get("eventTime");
                if (date != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM/dd/yyyy");
                    itemLogHistory.put("updateTime", dateFormat.format(date));
                } else {
                    itemLogHistory.put("updateTime", "N/A");
                }
                if (spillOverItem.get("activityBy") != null) {
                    itemLogHistory.put("activityBy", spillOverItem.get("activityBy"));
                } else {
                    itemLogHistory.put("activityBy", "NA");
                }
                itemLogHistory.put("activityBy", spillOverItem.get("activityBy"));
                itemLogHistory.put("BackLog", "BackLog");
                if (PropertyValidator.isValid((Object)itemStatus)) {
                    itemLogHistory.put("category", itemStatus.get("category"));
                    itemLogHistory.put("status", itemStatus.get("title"));
                    itemLogHistory.put("statusColor", "#F0C31F");
                }
                itemLogHistory.put("state", "Not Planned");
                ArrayList getSpillOvreHistoryArray = (ArrayList)itemPathCompleatLog.get("ItemPath");
                getSpillOvreHistoryArray.add(itemLogHistory);
            }
            long endTimeOfProcessing = System.currentTimeMillis();
            return itemPathCompleatLog;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private HashMap<String, Object> featchDataOnTheBaseOfUserSelectedCartType(HashMap<String, Object> functionParametersForFetchDataOnCartType) {
        try {
            ArrayList sessionBoards = (ArrayList)functionParametersForFetchDataOnCartType.get("sessionBoards");
            ArrayList requestStr = (ArrayList)functionParametersForFetchDataOnCartType.get("requestStr");
            State prevState = (State)functionParametersForFetchDataOnCartType.get("prevState");
            String tenant = (String)functionParametersForFetchDataOnCartType.get("tenant");
            List previousStateItems = null;
            List rawItems = null;
            ArrayList<ObjectId> cartTypeIds = new ArrayList<ObjectId>();
            boolean isFearureCartTypeSelected = false;
            for (int i = 0; i < requestStr.size(); ++i) {
                HashMap tempCartType = (HashMap)requestStr.get(i);
                String cartTypeId = (String)tempCartType.get("id");
                if (!cartTypeId.equals(String.valueOf(-100))) {
                    cartTypeIds.add(new ObjectId(cartTypeId));
                    continue;
                }
                if (!cartTypeId.equals(String.valueOf(-100))) continue;
                isFearureCartTypeSelected = true;
            }
            List issueTypes = new ArrayList();
            if (isFearureCartTypeSelected) {
                issueTypes = this.getIssueTypeOfBoardWhichIsArchive(tenant);
                for (int i = 0; i < issueTypes.size(); ++i) {
                    HashMap tempCartType = (HashMap)issueTypes.get(i);
                    cartTypeIds.add(new ObjectId(String.valueOf(tempCartType.get("_id"))));
                }
            }
            if (sessionBoards.size() > 0) {
                rawItems = this.getPiReportItemsBySelectedCartTypes((SessionBoard)sessionBoards.get(0), cartTypeIds, isFearureCartTypeSelected, tenant);
                if (prevState != null) {
                    previousStateItems = this.getPiReportItemsBySelectedCartTypes((SessionBoard)sessionBoards.get(1), cartTypeIds, isFearureCartTypeSelected, tenant);
                }
            }
            ArrayList<ObjectId> storyIdsOfCurrentState = new ArrayList<ObjectId>();
            ArrayList<ObjectId> storyIdsOfPreviousState = new ArrayList<ObjectId>();
            int maxSizeOfFeaturesForGettingStoryIdsLoop = 0;
            maxSizeOfFeaturesForGettingStoryIdsLoop = rawItems.size();
            if (previousStateItems != null && rawItems.size() < previousStateItems.size()) {
                maxSizeOfFeaturesForGettingStoryIdsLoop = rawItems.size();
            }
            for (int i = 0; i < maxSizeOfFeaturesForGettingStoryIdsLoop; ++i) {
                if (rawItems.size() > i) {
                    DBObject rawItem = (DBObject)rawItems.get(i);
                    storyIdsOfCurrentState.add(new ObjectId(String.valueOf(rawItem.get("_id"))));
                }
                if (previousStateItems == null || previousStateItems.size() <= i) continue;
                DBObject previousStaterawItem = (DBObject)previousStateItems.get(i);
                storyIdsOfPreviousState.add(new ObjectId(String.valueOf(previousStaterawItem.get("_id"))));
            }
            List previousStateItemsStories = null;
            List rawItemsStories = null;
            if (sessionBoards.size() > 0) {
                rawItemsStories = this.getPiReportStoriesOfSelectedCartTypes((SessionBoard)sessionBoards.get(0), storyIdsOfCurrentState);
                if (prevState != null) {
                    previousStateItemsStories = this.getPiReportStoriesOfSelectedCartTypes((SessionBoard)sessionBoards.get(1), storyIdsOfPreviousState);
                }
            }
            int maxSizeOfStoriesToAddInFeaturesList = 0;
            maxSizeOfStoriesToAddInFeaturesList = rawItemsStories.size();
            if (previousStateItemsStories != null && rawItemsStories.size() < previousStateItemsStories.size()) {
                maxSizeOfStoriesToAddInFeaturesList = previousStateItemsStories.size();
            }
            for (int i = 0; i < maxSizeOfStoriesToAddInFeaturesList; ++i) {
                if (rawItemsStories.size() > i) {
                    rawItems.add(rawItemsStories.get(i));
                }
                if (previousStateItemsStories == null || previousStateItemsStories.size() <= i) continue;
                previousStateItems.add(previousStateItemsStories.get(i));
            }
            HashMap<String, Object> rawItemsOfBothState = new HashMap<String, Object>();
            rawItemsOfBothState.put("rawItems", rawItems);
            rawItemsOfBothState.put("previousStateItems", previousStateItems);
            return rawItemsOfBothState;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new HashMap<String, Object>();
        }
    }

    private void calculationForThePriviousStateDataOfTheBoard(HashMap<String, Object> paramitersForthePreviousStateCalculation) {
        try {
            HashMap removedPreviousStateFeatureMapById = (HashMap)paramitersForthePreviousStateCalculation.get("removedPreviousStateFeatureMapById");
            HashMap previousStateItemsMapByIdsForDependencies = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateItemsMapByIdsForDependencies");
            HashMap previousStateItemsMapByTeamContainerIdsForDependencies = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateItemsMapByTeamContainerIdsForDependencies");
            HashMap previousStateItemTeamAndSprintMapByItemId = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateItemTeamAndSprintMapByItemId");
            HashMap previousStateMapForCheckingNoTeamAndSprintComesDouble = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateMapForCheckingNoTeamAndSprintComesDouble");
            List previousStateItems = (List)paramitersForthePreviousStateCalculation.get("previousStateItems");
            ArrayList previousStateItemsLinks = (ArrayList)paramitersForthePreviousStateCalculation.get("previousStateItemsLinks");
            HashMap statusMapById = (HashMap)paramitersForthePreviousStateCalculation.get("statusMapById");
            HashMap teamMapById = (HashMap)paramitersForthePreviousStateCalculation.get("teamMapById");
            HashMap containerMapById = (HashMap)paramitersForthePreviousStateCalculation.get("containerMapById");
            boolean callFromAnalyticsFlag = (Boolean)paramitersForthePreviousStateCalculation.get("callFromAnalyticsFlag");
            HashMap currentStateItemsMapBy_Ids_OR_OriginItemId = (HashMap)paramitersForthePreviousStateCalculation.get("currentStateItemsMapBy_Ids_OR_OriginItemId");
            HashMap teamItemById = (HashMap)paramitersForthePreviousStateCalculation.get("teamItemById");
            HashMap previousStateItemMapById = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateItemMapById");
            ArrayList storiesDetailsPreviousState = (ArrayList)paramitersForthePreviousStateCalculation.get("storiesDetailsPreviousState");
            HashMap previousStateItemsMapByIdsOnly = (HashMap)paramitersForthePreviousStateCalculation.get("previousStateItemsMapByIdsOnly");
            ArrayList previousStatejiraDependencies = (ArrayList)paramitersForthePreviousStateCalculation.get("previousStatejiraDependencies");
            ArrayList previousStateItemsWithUserSelectedCartType = (ArrayList)paramitersForthePreviousStateCalculation.get("previousStateItemsWithUserSelectedCartType");
            HashMap statsExclusionData = (HashMap)paramitersForthePreviousStateCalculation.get("statsExclusionData");
            HashMap includedFeaturesMap = new HashMap();
            Set featuresPresentInBacklog = (Set)paramitersForthePreviousStateCalculation.get("featuresPresentInBacklog");
            HashMap featuresPresentInBacklogMapById = (HashMap)paramitersForthePreviousStateCalculation.get("featuresPresentInBacklogMapById");
            for (DBObject previousStateItem : previousStateItemsWithUserSelectedCartType) {
                String featureIdKey;
                List itemLinks;
                Boolean includeItemFlag;
                DBRef statusRef = (DBRef)previousStateItem.get("status");
                Status status = null;
                if (PropertyValidator.isValid((Object)statusRef)) {
                    String statusId = String.valueOf(statusRef.getId());
                    status = (Status)statusMapById.get(statusId);
                }
                if (!PropertyValidator.isValid(status)) {
                    Status newStatus = new Status();
                    newStatus.setTitle("Misc");
                    newStatus.setCategory("Misc");
                    newStatus.setColor("#7c50b1");
                    status = newStatus;
                }
                if (!(includeItemFlag = this.checkExcludeItemsStatus(previousStateItem, status, (Map)statsExclusionData, includedFeaturesMap)).booleanValue()) continue;
                if (previousStateItem.get("type").equals(Item.USER_STORY) && !PropertyValidator.isValid((Object)previousStateItem.get("storyPoints"))) {
                    previousStateItem.put("storyPoints", (Object)0.0);
                }
                HashMap<String, String> itemKey = new HashMap<String, String>();
                String featureKey = null;
                String featureKeyLink = null;
                if (previousStateItem.get("jiraId") != null) {
                    featureKey = (String)previousStateItem.get("jiraKey");
                    itemKey.put("keyType", "jiraKey");
                } else if (previousStateItem.get("tfsId") != null) {
                    featureKey = (String)previousStateItem.get("tfsId");
                    featureKeyLink = (String)previousStateItem.get("tfsURL");
                    itemKey.put("keyType", "tfsId");
                } else if (previousStateItem.get("kendisKey") != null) {
                    featureKey = (String)previousStateItem.get("kendisKey");
                    featureKeyLink = (String)previousStateItem.get("externalReferenceURL");
                    itemKey.put("keyType", "kendisKey");
                } else if (previousStateItem.get("jiraKey") != null) {
                    featureKey = (String)previousStateItem.get("jiraKey");
                    featureKeyLink = (String)previousStateItem.get("externalReferenceURL");
                    itemKey.put("keyType", "kendisKey");
                }
                itemKey.put("key", featureKey);
                itemKey.put("keyLink", featureKeyLink);
                previousStateItemsMapByIdsForDependencies.put(String.valueOf(previousStateItem.get("_id")), previousStateItem);
                this.storeItemsKendisAndJiraDependencies(previousStateItem, previousStateItemsLinks, previousStatejiraDependencies);
                if (previousStateItem.get("itemLinks") != null && (itemLinks = (List)previousStateItem.get("itemLinks")).size() > 0) {
                    List itemLinksRef = (List)previousStateItem.get("itemLinks");
                    for (int k = 0; k < itemLinksRef.size(); ++k) {
                        DBRef linksRef = (DBRef)itemLinksRef.get(k);
                        previousStateItemsLinks.add(String.valueOf(linksRef.getId()));
                    }
                }
                Object removedItemFromPreviousSTate = null;
                if (previousStateItem.get("teamContainers") != null) {
                    String featureIdKey2;
                    List TeamsContainer = (List)previousStateItem.get("teamContainers");
                    if (TeamsContainer.size() > 0) {
                        List teamContRef = (List)previousStateItem.get("teamContainers");
                        for (int j = 0; j < teamContRef.size(); ++j) {
                            ArrayList updateRemovedData;
                            DBRef parent;
                            HashMap itemTeamAndSprintMap;
                            DBRef tcRef = (DBRef)teamContRef.get(j);
                            Query query = new Query();
                            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                            DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                            if (!dbCursorDomain.hasNext()) continue;
                            DBObject tcObject = dbCursorDomain.next();
                            DBRef containerRef = (DBRef)tcObject.get("container");
                            DBRef teamRef = (DBRef)tcObject.get("team");
                            TeamContainer teamContainer = new TeamContainer();
                            teamContainer.setId(String.valueOf(tcObject.get("_id")));
                            Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                            Team team = (Team)teamMapById.get(String.valueOf(teamRef.getId()));
                            teamContainer.setContainer(container);
                            previousStateItemsMapByTeamContainerIdsForDependencies.put(String.valueOf(tcObject.get("_id")), previousStateItem);
                            if (!callFromAnalyticsFlag) continue;
                            if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id"))) == null) {
                                HashMap itemTeamAndSprintArraysMapByName = new HashMap();
                                itemTeamAndSprintArraysMapByName.put("sprints", new HashMap());
                                itemTeamAndSprintArraysMapByName.put("teams", new HashMap());
                                previousStateItemTeamAndSprintMapByItemId.put(String.valueOf(previousStateItem.get("_id")), itemTeamAndSprintArraysMapByName);
                                previousStateMapForCheckingNoTeamAndSprintComesDouble.put(String.valueOf(previousStateItem.get("_id")), new HashMap());
                            }
                            HashMap<String, String> temporaryTeamMap = new HashMap<String, String>();
                            HashMap<String, Object> temporarySprintMap = new HashMap<String, Object>();
                            if (team != null) {
                                temporaryTeamMap.put("teamId", team.getId());
                                temporaryTeamMap.put("teamTitle", team.getTitle());
                                temporaryTeamMap.put("teamLabels", team.getLabel());
                                temporaryTeamMap.put("teamColor", team.getColor());
                            }
                            if (container != null) {
                                temporarySprintMap.put("container", container.getTitle());
                                temporarySprintMap.put("containerLabel", container.getLabel());
                                temporarySprintMap.put("containerId", container.getId());
                                temporarySprintMap.put("sequence", container.getSequence());
                                if (container.getOriginItemId() != null) {
                                    temporarySprintMap.put("sprintOriginItemId", container.getOriginItemId());
                                } else if (container.getDuplicateOfId() != null) {
                                    temporarySprintMap.put("sprintDuplicateOfId", container.getDuplicateOfId());
                                }
                            }
                            HashMap getTemporaryMapForCheckItemData = (HashMap)previousStateMapForCheckingNoTeamAndSprintComesDouble.get(String.valueOf(previousStateItem.get("_id")));
                            if (PropertyValidator.isValid((Object)team) && getTemporaryMapForCheckItemData.get(String.valueOf(team.getId())) == null) {
                                getTemporaryMapForCheckItemData.put(String.valueOf(team.getId()), team.getId());
                                itemTeamAndSprintMap = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id")));
                                HashMap getIteamTeamArray = (HashMap)itemTeamAndSprintMap.get("teams");
                                getIteamTeamArray.put(String.valueOf(team.getId()), temporaryTeamMap);
                            }
                            if (PropertyValidator.isValid((Object)container) && getTemporaryMapForCheckItemData.get(String.valueOf(container.getId())) == null) {
                                getTemporaryMapForCheckItemData.put(String.valueOf(container.getId()), container.getId());
                                itemTeamAndSprintMap = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id")));
                                HashMap getIteamSprintArray = (HashMap)itemTeamAndSprintMap.get("sprints");
                                getIteamSprintArray.put(String.valueOf(container.getId()), temporarySprintMap);
                            }
                            if (previousStateItem.get("originItemId") != null && currentStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(previousStateItem.get("originItemId"))) != null) {
                                removedItemFromPreviousSTate = previousStateItem;
                            } else if (previousStateItem.get("duplicateOfId") != null && currentStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(previousStateItem.get("duplicateOfId"))) != null) {
                                removedItemFromPreviousSTate = previousStateItem;
                            } else if (previousStateItem.get("_id") != null && currentStateItemsMapBy_Ids_OR_OriginItemId.get(String.valueOf(previousStateItem.get("_id"))) != null) {
                                removedItemFromPreviousSTate = previousStateItem;
                            }
                            if (PropertyValidator.isValid((Object)team) && previousStateItem.get("type").equals(Item.FEATURE)) {
                                HashMap getItemDetailsInMap = this.calculationForTeamsDataByStateOfBoard("priviousState", status, previousStateItem, teamItemById, previousStateItemTeamAndSprintMapByItemId, team, previousStateItemMapById);
                                if (previousStateItem.get("originItemId") != null && !featuresPresentInBacklogMapById.containsKey(String.valueOf(previousStateItem.get("originItemId"))) || previousStateItem.get("originItemId") == null && !featuresPresentInBacklogMapById.containsKey(String.valueOf(previousStateItem.get("_id")))) {
                                    featuresPresentInBacklog.add(getItemDetailsInMap);
                                }
                            } else {
                                HashMap<String, Object> stories = new HashMap<String, Object>();
                                HashMap itemTeamAndSprintMap2 = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id")));
                                if (itemTeamAndSprintMap2.get("teams") != null) {
                                    stories.put("itemTeamData", itemTeamAndSprintMap2.get("teams"));
                                }
                                if (itemTeamAndSprintMap2.get("sprints") != null) {
                                    stories.put("itemSprintData", itemTeamAndSprintMap2.get("sprints"));
                                }
                                stories.put("key", itemKey.get("key"));
                                stories.put("keyType", itemKey.get("keyType"));
                                stories.put("keyLink", itemKey.get("keyLink"));
                                stories.put("type", previousStateItem.get("type"));
                                stories.put("_id", String.valueOf(previousStateItem.get("_id")));
                                stories.put("Details", previousStateItem.get("title"));
                                DBRef parentId = (DBRef)previousStateItem.get("parent");
                                if (PropertyValidator.isValid((Object)parentId) && PropertyValidator.isValid((Object)parentId.getId()) && previousStateItemsMapByIdsOnly.get(String.valueOf(parentId.getId())) != null) {
                                    DBObject parentItem = (DBObject)previousStateItemsMapByIdsOnly.get(String.valueOf(parentId.getId()));
                                    HashMap itemkey = this.getItemJirsOrTFSKey(parentItem);
                                    stories.put("parentkey", itemkey.get("key"));
                                    stories.put("parentkeyType", itemkey.get("keyType"));
                                    stories.put("parentkeyLink", itemkey.get("keyLink"));
                                    stories.put("parentDetails", parentItem.get("title"));
                                    stories.put("parentTfsId", parentItem.get("tfsId"));
                                    stories.put("parentTfsURL", parentItem.get("tfsURL"));
                                    stories.put("parentTfsApiURL", parentItem.get("tfsApiURL"));
                                    stories.put("parentTfsProjectId", parentItem.get("tfsProjectId"));
                                    stories.put("parentTfsProject", parentItem.get("tfsProject"));
                                    stories.put("parentTfsItemType", parentItem.get("tfsItemType"));
                                    stories.put("parentTfsItemTypeIcon", parentItem.get("tfsItemTypeIcon"));
                                    stories.put("parentTfsFilter", parentItem.get("tfsFilter"));
                                    stories.put("parentTfsAreaPath", parentItem.get("tfsAreaPath"));
                                    stories.put("parentTfsIterationPath", parentItem.get("tfsIterationPath"));
                                    stories.put("parentJiraKey", parentItem.get("jiraKey"));
                                    stories.put("parentJiraId", parentItem.get("jiraId"));
                                    stories.put("parentJiraFilter", parentItem.get("jiraFilter"));
                                    stories.put("parentJiraProjectKey", parentItem.get("jiraProjectKey"));
                                    stories.put("parentJiraIssueTypeId", parentItem.get("jiraIssueTypeId"));
                                }
                                if (PropertyValidator.isValid((Object)status)) {
                                    if (PropertyValidator.isValid((Object)status.getTitle())) {
                                        stories.put("Status", status.getTitle());
                                    } else {
                                        stories.put("Status", "N/A");
                                    }
                                    stories.put("Category", status.getCategory());
                                }
                                stories.put("Estimate", previousStateItem.get("storyPoints"));
                                if (PropertyValidator.isValid((Object)parentId) && PropertyValidator.isValid((Object)parentId.getId())) {
                                    stories.put("parent", parentId.getId());
                                }
                                stories.put("tfsId", previousStateItem.get("tfsId"));
                                stories.put("tfsURL", previousStateItem.get("tfsURL"));
                                stories.put("tfsApiURL", previousStateItem.get("tfsApiURL"));
                                stories.put("tfsProjectId", previousStateItem.get("tfsProjectId"));
                                stories.put("tfsProject", previousStateItem.get("tfsProject"));
                                stories.put("tfsItemType", previousStateItem.get("tfsItemType"));
                                stories.put("tfsItemTypeIcon", previousStateItem.get("tfsItemTypeIcon"));
                                stories.put("tfsFilter", previousStateItem.get("tfsFilter"));
                                stories.put("tfsAreaPath", previousStateItem.get("tfsAreaPath"));
                                stories.put("tfsIterationPath", previousStateItem.get("tfsIterationPath"));
                                stories.put("jiraKey", previousStateItem.get("jiraKey"));
                                stories.put("jiraId", previousStateItem.get("jiraId"));
                                stories.put("jiraFilter", previousStateItem.get("jiraFilter"));
                                stories.put("jiraProjectKey", previousStateItem.get("jiraProjectKey"));
                                stories.put("jiraIssueTypeId", previousStateItem.get("jiraIssueTypeId"));
                                if (container.getOriginItemId() != null) {
                                    stories.put("sprintOriginItemId", container.getOriginItemId());
                                } else if (container.getDuplicateOfId() != null) {
                                    stories.put("sprintDuplicateOfId", container.getDuplicateOfId());
                                }
                                if (previousStateItem.get("originItemId") != null) {
                                    stories.put("originItemId", String.valueOf(previousStateItem.get("originItemId")));
                                    stories.put("id", String.valueOf(previousStateItem.get("_id")));
                                    previousStateItemMapById.put(String.valueOf(previousStateItem.get("originItemId")), new HashMap(stories));
                                } else if (previousStateItem.get("_id") != null) {
                                    stories.put("id", String.valueOf(previousStateItem.get("_id")));
                                    previousStateItemMapById.put(String.valueOf(previousStateItem.get("_id")), new HashMap(stories));
                                } else if (previousStateItem.get("duplicateOfId") != null) {
                                    stories.put("duplicateOfId", String.valueOf(previousStateItem.get("duplicateOfId")));
                                    previousStateItemMapById.put(String.valueOf(previousStateItem.get("duplicateOfId")), new HashMap(stories));
                                }
                                storiesDetailsPreviousState.add(stories);
                            }
                            removedItemFromPreviousSTate = removedItemFromPreviousSTate != null ? null : previousStateItem;
                            String type = (String)previousStateItem.get("type");
                            if (type.equals(Item.FEATURE) && removedItemFromPreviousSTate != null) {
                                if (status == null || TeamsContainer == null || TeamsContainer.size() <= 0) continue;
                                HashMap<String, Object> obj = new HashMap<String, Object>();
                                if (TeamsContainer != null) {
                                    if (TeamsContainer.size() > 0) {
                                        obj.put("Planned", true);
                                    } else {
                                        obj.put("Planned", false);
                                    }
                                }
                                if (previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id"))) != null) {
                                    HashMap itemTeamAndSprintMap3 = (HashMap)previousStateItemTeamAndSprintMapByItemId.get(String.valueOf(previousStateItem.get("_id")));
                                    if (itemTeamAndSprintMap3.get("teams") != null) {
                                        obj.put("previousStateItemTeamData", itemTeamAndSprintMap3.get("teams"));
                                    }
                                    if (itemTeamAndSprintMap3.get("sprints") != null) {
                                        obj.put("previousStateItemSprintData", itemTeamAndSprintMap3.get("sprints"));
                                    }
                                }
                                obj.put("Details", previousStateItem.get("title"));
                                if (PropertyValidator.isValid((Object)status)) {
                                    if (PropertyValidator.isValid((Object)status.getTitle())) {
                                        obj.put("Status", status.getTitle());
                                    } else {
                                        obj.put("Status", "N/A");
                                    }
                                    obj.put("Category", status.getCategory());
                                }
                                obj.put("id", String.valueOf(previousStateItem.get("_id")));
                                obj.put("key", itemKey.get("key"));
                                obj.put("keyType", itemKey.get("keyType"));
                                obj.put("keyLink", itemKey.get("keyLink"));
                                obj.put("Estimate", 0);
                                obj.put("ToDoStoryCount", new ArrayList());
                                obj.put("InProgressStoryCount", new ArrayList());
                                obj.put("DoneStoryCount", new ArrayList());
                                obj.put("MiscStoryCount", new ArrayList());
                                obj.put("toDoStoryPoint", 0);
                                obj.put("inProgressStoryPoint", 0);
                                obj.put("doneStoryPoint", 0);
                                obj.put("miscStoryPoint", 0);
                                obj.put("unPlannedToDoStoryCount", new ArrayList());
                                obj.put("unPlannedInProgressStoryCount", new ArrayList());
                                obj.put("unPlannedDoneStoryCount", new ArrayList());
                                obj.put("unPlannedMiscStoryCount", new ArrayList());
                                removedPreviousStateFeatureMapById.put(String.valueOf(previousStateItem.get("_id")), obj);
                                continue;
                            }
                            if (removedItemFromPreviousSTate == null || !callFromAnalyticsFlag || TeamsContainer == null || TeamsContainer.size() <= 0 || !PropertyValidator.isValid((Object)(parent = (DBRef)previousStateItem.get("parent"))) || !PropertyValidator.isValid((Object)parent.getId())) continue;
                            if (removedPreviousStateFeatureMapById.get(String.valueOf(parent.getId())) == null && removedItemFromPreviousSTate != null) {
                                HashMap<String, Object> addNewFeature = new HashMap<String, Object>();
                                addNewFeature.put("Estimate", 0);
                                addNewFeature.put("ToDoStoryCount", new ArrayList());
                                addNewFeature.put("InProgressStoryCount", new ArrayList());
                                addNewFeature.put("DoneStoryCount", new ArrayList());
                                addNewFeature.put("MiscStoryCount", new ArrayList());
                                addNewFeature.put("toDoStoryPoint", 0);
                                addNewFeature.put("inProgressStoryPoint", 0);
                                addNewFeature.put("doneStoryPoint", 0);
                                addNewFeature.put("miscStoryPoint", 0);
                                addNewFeature.put("unPlannedToDoStoryCount", new ArrayList());
                                addNewFeature.put("unPlannedInProgressStoryCount", new ArrayList());
                                addNewFeature.put("unPlannedDoneStoryCount", new ArrayList());
                                addNewFeature.put("unPlannedMiscStoryCount", new ArrayList());
                                addNewFeature.put("id", String.valueOf(previousStateItem.get("_id")));
                                removedPreviousStateFeatureMapById.put(String.valueOf(parent.getId()), addNewFeature);
                            }
                            HashMap getfeatureStoriesData = (HashMap)removedPreviousStateFeatureMapById.get(String.valueOf(parent.getId()));
                            if (status == null) continue;
                            if (status.getCategory().equalsIgnoreCase("ToDo")) {
                                updateRemovedData = (ArrayList)getfeatureStoriesData.get("ToDoStoryCount");
                                updateRemovedData.add(String.valueOf(previousStateItem.get("_id")));
                                if (previousStateItem.get("storyPoints") == null) continue;
                                getfeatureStoriesData.put("toDoStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("toDoStoryPoint"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                                getfeatureStoriesData.put("Estimate", Double.valueOf(String.valueOf(getfeatureStoriesData.get("Estimate"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                                continue;
                            }
                            if (status.getCategory().equalsIgnoreCase("InProgress")) {
                                updateRemovedData = (ArrayList)getfeatureStoriesData.get("InProgressStoryCount");
                                updateRemovedData.add(String.valueOf(previousStateItem.get("_id")));
                                if (previousStateItem.get("storyPoints") == null) continue;
                                getfeatureStoriesData.put("inProgressStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("inProgressStoryPoint"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                                getfeatureStoriesData.put("Estimate", Double.valueOf(String.valueOf(getfeatureStoriesData.get("Estimate"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                                continue;
                            }
                            if (!status.getCategory().equalsIgnoreCase("Done")) continue;
                            updateRemovedData = (ArrayList)getfeatureStoriesData.get("DoneStoryCount");
                            updateRemovedData.add(String.valueOf(previousStateItem.get("_id")));
                            if (previousStateItem.get("storyPoints") == null) continue;
                            getfeatureStoriesData.put("doneStoryPoint", Double.valueOf(String.valueOf(getfeatureStoriesData.get("doneStoryPoint"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                            getfeatureStoriesData.put("Estimate", Double.valueOf(String.valueOf(getfeatureStoriesData.get("Estimate"))) + Double.valueOf(String.valueOf(previousStateItem.get("storyPoints"))));
                        }
                        continue;
                    }
                    String string = featureIdKey2 = previousStateItem.get("originItemId") != null ? String.valueOf(previousStateItem.get("originItemId")) : String.valueOf(previousStateItem.get("_id"));
                    if (!previousStateItem.get("type").equals(Item.FEATURE) || featuresPresentInBacklogMapById.containsKey(featureIdKey2)) continue;
                    HashMap getItemDetailsInMap = this.putItemDetailsInMap(previousStateItem, previousStateItemTeamAndSprintMapByItemId, status);
                    featuresPresentInBacklog.add(getItemDetailsInMap);
                    continue;
                }
                String string = featureIdKey = previousStateItem.get("originItemId") != null ? String.valueOf(previousStateItem.get("originItemId")) : String.valueOf(previousStateItem.get("_id"));
                if (!previousStateItem.get("type").equals(Item.FEATURE) || featuresPresentInBacklogMapById.containsKey(featureIdKey)) continue;
                HashMap getItemDetailsInMap = this.putItemDetailsInMap(previousStateItem, previousStateItemTeamAndSprintMapByItemId, status);
                featuresPresentInBacklog.add(getItemDetailsInMap);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void calculationForTeamsStoriesByStateOfBoard(ArrayList<Object> storiesDetailsCurrentState, ArrayList<Object> storiesDetailsPreviousState, HashMap<String, Object> teamItemById) {
        try {
            int size = 0;
            size = storiesDetailsPreviousState.size() > storiesDetailsCurrentState.size() ? storiesDetailsPreviousState.size() : storiesDetailsCurrentState.size();
            for (int i = 0; i < size; ++i) {
                HashMap priviousState;
                HashMap priviousStory;
                HashMap getStoryArray;
                HashMap getfeature;
                HashMap currentState;
                Map.Entry entry;
                String key;
                HashMap getStates;
                HashMap currentStory;
                HashMap getTeamMap;
                if (i < storiesDetailsCurrentState.size() && (getTeamMap = (HashMap)(currentStory = (HashMap)storiesDetailsCurrentState.get(i)).get("itemTeamData")) != null && getTeamMap.size() > 0 && (getStates = (HashMap)teamItemById.get(key = (String)(entry = getTeamMap.entrySet().iterator().next()).getKey())) != null && !(currentState = (HashMap)getStates.get("currentState")).isEmpty() && PropertyValidator.isValid(currentStory.get("parent")) && (getfeature = (HashMap)currentState.get(String.valueOf(currentStory.get("parent")))) != null) {
                    getStoryArray = (HashMap)getfeature.get("stories");
                    getStoryArray.put(String.valueOf(currentStory.get("_id")), currentStory);
                }
                if (i >= storiesDetailsPreviousState.size() || (getTeamMap = (HashMap)(priviousStory = (HashMap)storiesDetailsPreviousState.get(i)).get("itemTeamData")).size() <= 0 || (getStates = (HashMap)teamItemById.get(key = (String)(entry = getTeamMap.entrySet().iterator().next()).getKey())) == null || (priviousState = (HashMap)getStates.get("priviousState")).isEmpty() || !PropertyValidator.isValid(priviousStory.get("parent")) || (getfeature = (HashMap)priviousState.get(String.valueOf(priviousStory.get("parent")))) == null) continue;
                getStoryArray = (HashMap)getfeature.get("stories");
                getStoryArray.put(String.valueOf(priviousStory.get("_id")), priviousStory);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private HashMap<String, Object> calculationForTeamsDataByStateOfBoard(String State2, Status status, DBObject rawItem, HashMap<String, Object> updateFeatureData, HashMap<String, Object> itemTeamAndSprintData, Team team, HashMap<String, Object> stateItemMapById) {
        HashMap<String, Object> itemDetailInState = new HashMap<String, Object>();
        try {
            if (itemTeamAndSprintData.get(String.valueOf(rawItem.get("_id"))) != null) {
                HashMap itemTeamAndSprintMap = (HashMap)itemTeamAndSprintData.get(String.valueOf(rawItem.get("_id")));
                if (itemTeamAndSprintMap.get("teams") != null) {
                    itemDetailInState.put("itemTeamData", itemTeamAndSprintMap.get("teams"));
                }
                if (itemTeamAndSprintMap.get("sprints") != null) {
                    itemDetailInState.put("itemSprintData", itemTeamAndSprintMap.get("sprints"));
                }
                String featureKey = null;
                String featureKeyLink = null;
                if (rawItem.get("jiraId") != null) {
                    featureKey = (String)rawItem.get("jiraKey");
                    itemDetailInState.put("keyType", "jiraKey");
                } else if (rawItem.get("tfsId") != null) {
                    featureKey = (String)rawItem.get("tfsId");
                    featureKeyLink = (String)rawItem.get("tfsURL");
                    itemDetailInState.put("keyType", "tfsId");
                } else if (rawItem.get("kendisKey") != null) {
                    featureKey = (String)rawItem.get("kendisKey");
                    featureKeyLink = (String)rawItem.get("externalReferenceURL");
                    itemDetailInState.put("keyType", "kendisKey");
                } else if (rawItem.get("jiraKey") != null) {
                    featureKey = (String)rawItem.get("jiraKey");
                    featureKeyLink = (String)rawItem.get("externalReferenceURL");
                    itemDetailInState.put("keyType", "kendisKey");
                }
                itemDetailInState.put("key", featureKey);
                itemDetailInState.put("keyLink", featureKeyLink);
                itemDetailInState.put("Details", rawItem.get("title"));
                itemDetailInState.put("id", String.valueOf(rawItem.get("_id")));
                itemDetailInState.put("type", String.valueOf(rawItem.get("type")));
                if (PropertyValidator.isValid((Object)rawItem.get("backlogSequence"))) {
                    itemDetailInState.put("backlogSequence", rawItem.get("backlogSequence"));
                }
                if (PropertyValidator.isValid((Object)rawItem.get("sequence"))) {
                    itemDetailInState.put("sequence", rawItem.get("sequence"));
                }
                itemDetailInState.put("tfsId", rawItem.get("tfsId"));
                itemDetailInState.put("tfsURL", rawItem.get("tfsURL"));
                itemDetailInState.put("tfsApiURL", rawItem.get("tfsApiURL"));
                itemDetailInState.put("tfsProjectId", rawItem.get("tfsProjectId"));
                itemDetailInState.put("tfsProject", rawItem.get("tfsProject"));
                itemDetailInState.put("tfsItemType", rawItem.get("tfsItemType"));
                itemDetailInState.put("tfsItemTypeIcon", rawItem.get("tfsItemTypeIcon"));
                itemDetailInState.put("tfsFilter", rawItem.get("tfsFilter"));
                itemDetailInState.put("tfsAreaPath", rawItem.get("tfsAreaPath"));
                itemDetailInState.put("tfsIterationPath", rawItem.get("tfsIterationPath"));
                itemDetailInState.put("jiraKey", rawItem.get("jiraKey"));
                itemDetailInState.put("jiraId", rawItem.get("jiraId"));
                itemDetailInState.put("jiraFilter", rawItem.get("jiraFilter"));
                itemDetailInState.put("jiraProjectKey", rawItem.get("jiraProjectKey"));
                itemDetailInState.put("jiraIssueTypeId", rawItem.get("jiraIssueTypeId"));
                if (status != null) {
                    if (PropertyValidator.isValid((Object)status.getTitle())) {
                        itemDetailInState.put("Status", status.getTitle());
                    } else {
                        itemDetailInState.put("Status", "N/A");
                    }
                    itemDetailInState.put("Category", status.getCategory());
                }
                if (rawItem.get("originItemId") != null) {
                    itemDetailInState.put("originItemId", String.valueOf(rawItem.get("originItemId")));
                    stateItemMapById.put(String.valueOf(rawItem.get("originItemId")), new HashMap<String, Object>(itemDetailInState));
                } else if (rawItem.get("_id") != null) {
                    itemDetailInState.put("_id", String.valueOf(rawItem.get("_id")));
                    stateItemMapById.put(String.valueOf(rawItem.get("_id")), new HashMap<String, Object>(itemDetailInState));
                } else if (rawItem.get("duplicateOfId") != null) {
                    itemDetailInState.put("duplicateOfId", String.valueOf(rawItem.get("duplicateOfId")));
                    stateItemMapById.put(String.valueOf(rawItem.get("duplicateOfId")), new HashMap<String, Object>(itemDetailInState));
                }
                itemDetailInState.put("stories", new HashMap());
                HashMap getTeamForCurrentState = (HashMap)updateFeatureData.get(team.getId());
                HashMap currentStateData = (HashMap)getTeamForCurrentState.get(State2);
                if (currentStateData.get(String.valueOf(rawItem.get("_id"))) == null) {
                    currentStateData.put(String.valueOf(rawItem.get("_id")), itemDetailInState);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return itemDetailInState;
    }

    public void calculateRiskByOpenStatusCurrentSprint(Risk risk, HashMap<String, Object> riskOpenCurrentSPMapById) {
        for (BoardTeam riskTeam : risk.getBoardTeams()) {
            Set<String> teamData = new HashSet<String>();
            if (!riskOpenCurrentSPMapById.isEmpty()) {
                teamData = (Set)riskOpenCurrentSPMapById.get(riskTeam.getTeamId());
            }
            if (!PropertyValidator.isValid(teamData)) {
                teamData = new HashSet();
            }
            teamData.add(risk.getId());
            riskOpenCurrentSPMapById.put(riskTeam.getTeamId(), teamData);
        }
    }

    public List<String> getPreviousSprintIds(HashMap<String, Object> boardContainersMap, Container currentSprint) {
        ArrayList<String> previousSprintsIds = new ArrayList<String>();
        for (Map.Entry<String, Object> conatiner : boardContainersMap.entrySet()) {
            Container sprint = (Container)conatiner.getValue();
            if (!sprint.getEndDate().before(currentSprint.getStartDate())) continue;
            previousSprintsIds.add(conatiner.getKey());
        }
        return previousSprintsIds;
    }

    public Boolean calculateRiskByOpenStatus(Risk risk, Container currentSprint, HashMap<String, Object> boardContainersMap, HashMap<String, Object> risksFromPreviousSprint) {
        List previousSprintsIds = new ArrayList();
        previousSprintsIds = this.getPreviousSprintIds(boardContainersMap, currentSprint);
        int flag = 0;
        if (EnumStatusCategory.OPEN.getCode().equals(risk.getStatus().getCategory()) || EnumStatusCategory.INPROGRESS.getCode().equals(risk.getStatus().getCategory())) {
            if (risk.getResolutionDate() != null && risk.getResolutionDate().before(currentSprint.getStartDate())) {
                flag = 1;
            } else if (risk.getBoardSprints() != null) {
                for (BoardSprints sprint : risk.getBoardSprints()) {
                    if (!previousSprintsIds.contains(sprint.getSprintId())) continue;
                    flag = 1;
                }
            }
        }
        if (flag > 0) {
            for (BoardTeam riskTeam : risk.getBoardTeams()) {
                HashSet teamData = new HashSet();
                if (!risksFromPreviousSprint.isEmpty() && risksFromPreviousSprint.get(riskTeam.getTeamId()) != null) {
                    teamData = (HashSet)risksFromPreviousSprint.get(riskTeam.getTeamId());
                }
                teamData.add(risk.getId());
                risksFromPreviousSprint.put(riskTeam.getTeamId(), teamData);
            }
        }
        return flag == 1;
    }

    public void calculateRiskByOpenStatusAndTeamSprint(Risk risk, SessionBoard board, HashMap<String, Object> openRiskMapByTeamId, HashMap<String, Object> boardTeamsMapById) {
        try {
            for (BoardTeam riskTeam : risk.getBoardTeams()) {
                Team tempTeam = (Team)boardTeamsMapById.get(riskTeam.getTeamId());
                if (tempTeam == null || !riskTeam.getSessionId().equals(board.getSession().getId()) || !EnumStatusCategory.OPEN.getCode().equals(risk.getStatus().getCategory()) && !EnumStatusCategory.INPROGRESS.getCode().equals(risk.getStatus().getCategory())) continue;
                HashMap teamData = new HashMap();
                if (!openRiskMapByTeamId.isEmpty()) {
                    teamData = (HashMap)openRiskMapByTeamId.get(riskTeam.getId());
                }
                if (teamData == null || teamData.isEmpty()) {
                    teamData = new HashMap();
                    teamData.put("openRisks", new ArrayList());
                    openRiskMapByTeamId.put(riskTeam.getTeamId(), teamData);
                }
                List tempRiskIds = (List)teamData.get("openRisks");
                tempRiskIds.add(risk.getId());
                openRiskMapByTeamId.put(riskTeam.getTeamId(), tempRiskIds);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public HashMap<String, Object> getRiskStatsBySprintAndTeam(HashMap<String, Object> requestStr) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap programLevelResponse = new HashMap();
        HashMap openRiskMapByTeamId = new HashMap();
        HashMap previousSPRiskMapByTeamId = new HashMap();
        HashMap dueRisksInSprintMapByTeamId = new HashMap();
        HashMap riskOpenForActiveSprintByTeam = new HashMap();
        String sprintId = "";
        String riskRegisterId = "";
        RiskRegister riskRegister = new RiskRegister();
        try {
            Container currentSprint;
            ArrayList<String> risksDueInCurrentNextsprint = new ArrayList<String>();
            ArrayList<String> risksOpenPreviousSprint = new ArrayList<String>();
            ArrayList<String> riskClosedInCurrentSprint = new ArrayList<String>();
            List sessionBoards = new ArrayList();
            if (PropertyValidator.isValid(requestStr)) {
                riskRegisterId = (String)requestStr.get("riskRegisterId");
                sprintId = (String)requestStr.get("sprintId");
                riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            }
            if (PropertyValidator.isValid((Object)(currentSprint = (Container)this.containerRepository.findOne((Serializable)((Object)sprintId))))) {
                sessionBoards = this.sessionBoardRepository.findByContainersId(currentSprint.getId());
            }
            List riskList = this.riskRepository.findByRiskRegister(riskRegister);
            HashMap<String, Container> containerMapById = new HashMap<String, Container>();
            HashMap<String, Team> teamMapById = new HashMap<String, Team>();
            if (PropertyValidator.isValid(sessionBoards)) {
                for (Container container : ((SessionBoard)sessionBoards.get(0)).getContainers()) {
                    containerMapById.put(container.getId(), container);
                }
                for (Team team : ((SessionBoard)sessionBoards.get(0)).getTeams()) {
                    teamMapById.put(team.getId(), team);
                }
                for (Risk risk : riskList) {
                    LOGGER.debug("risk resoulation date" + risk.getResolutionDate());
                    LOGGER.debug("currentSprint" + risk.getResolutionDate());
                    if (EnumStatusCategory.OPEN.getCode().equals(risk.getStatus().getCategory()) || EnumStatusCategory.INPROGRESS.getCode().equals(risk.getStatus().getCategory())) {
                        if (risk.getResolutionDate() != null && currentSprint != null && (risk.getResolutionDate().after(currentSprint.getStartDate()) || risk.getResolutionDate().equals(currentSprint.getStartDate())) && (risk.getResolutionDate().before(currentSprint.getEndDate()) || risk.getResolutionDate().equals(currentSprint.getEndDate()))) {
                            risksDueInCurrentNextsprint.add(risk.getId());
                            this.calculateRiskByOpenStatusCurrentSprint(risk, riskOpenForActiveSprintByTeam);
                        } else if (PropertyValidator.isValid((Collection)risk.getBoardSprints()) && risk.getBoardSprints().size() > 0) {
                            for (BoardSprints sprint : risk.getBoardSprints()) {
                                if (!sprint.getSprintId().equals(currentSprint.getId())) continue;
                                risksDueInCurrentNextsprint.add(risk.getId());
                                this.calculateRiskByOpenStatusCurrentSprint(risk, riskOpenForActiveSprintByTeam);
                            }
                        }
                    }
                    if (this.calculateRiskByOpenStatus(risk, currentSprint, containerMapById, previousSPRiskMapByTeamId).booleanValue()) {
                        risksOpenPreviousSprint.add(risk.getId());
                    }
                    if (risk.getResolutionDate() != null && (risk.getResolutionDate().after(currentSprint.getStartDate()) || risk.getResolutionDate().equals(currentSprint.getStartDate())) && (risk.getResolutionDate().before(currentSprint.getEndDate()) || risk.getResolutionDate().equals(currentSprint.getEndDate()))) {
                        for (BoardTeam riskTeam : risk.getBoardTeams()) {
                            Team tempTeam = (Team)teamMapById.get(riskTeam.getTeamId());
                            if (tempTeam == null || !riskTeam.getSessionId().equals(((SessionBoard)sessionBoards.get(0)).getSession().getId())) continue;
                            ArrayList<String> dueRisks = null;
                            if (dueRisksInSprintMapByTeamId.get(riskTeam.getTeamId()) != null) {
                                dueRisks = (ArrayList<String>)dueRisksInSprintMapByTeamId.get(riskTeam.getTeamId());
                            }
                            if (PropertyValidator.isValid(dueRisks)) {
                                dueRisks.add(risk.getId());
                                dueRisksInSprintMapByTeamId.put(riskTeam.getTeamId(), dueRisks);
                                continue;
                            }
                            dueRisks = new ArrayList<String>();
                            dueRisks.add(risk.getId());
                            dueRisksInSprintMapByTeamId.put(riskTeam.getTeamId(), dueRisks);
                        }
                    }
                    if (risk == null || !EnumStatusCategory.DONE.getCode().equals(risk.getStatus().getCategory()) || risk.getUpdatedOn() == null || !risk.getUpdatedOn().after(currentSprint.getStartDate()) && !risk.getUpdatedOn().equals(currentSprint.getStartDate()) || !risk.getUpdatedOn().before(currentSprint.getEndDate()) && !risk.getUpdatedOn().equals(currentSprint.getEndDate())) continue;
                    riskClosedInCurrentSprint.add(risk.getId());
                }
            }
            programLevelResponse.put("risksDueInCurrentNextsprint", risksDueInCurrentNextsprint);
            programLevelResponse.put("riskHighSeverityOpen", risksOpenPreviousSprint);
            programLevelResponse.put("risksClosedDuringCurrentSprint", riskClosedInCurrentSprint);
            response.put("OpenRisksTeamLevel", openRiskMapByTeamId);
            response.put("OpenRisksFromPreviousSprint", previousSPRiskMapByTeamId);
            response.put("RiskAnalyticsProgramLevel", programLevelResponse);
            response.put("DueRisksInSprintMapByTeamId", dueRisksInSprintMapByTeamId);
            response.put("riskOpenForActiveSprintByTeam", riskOpenForActiveSprintByTeam);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private HashMap<String, Object> filterBaseLineData(List<DBObject> auditLogs, SessionBoard activeSessionBoard, HashMap<String, Container> containerMapById, HashMap<String, Team> teamMapById, Map<String, DBObject> capMap) {
        HashMap<String, Object> baseLineDataByTeamAndSprint = new HashMap<String, Object>();
        try {
            Gson gson = new Gson();
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            Map reqbody = new HashMap();
            for (DBObject auditLogData : auditLogs) {
                if (auditLogData.get("auditData") == null) continue;
                reqbody = (Map)gson.fromJson((String)auditLogData.get("auditData"), T.getType());
                Set keys = reqbody.keySet();
                Double sum = 0.0;
                String event = (String)auditLogData.get("eventType");
                for (String key : keys) {
                    Map spillOverItemNewTeamData;
                    Team newTeam;
                    Map singleBaseLineItem = (Map)reqbody.get(key);
                    HashMap<String, Object> itemBaseLineData = new HashMap<String, Object>();
                    if (!singleBaseLineItem.get("type").equals("UserStory")) continue;
                    String featureKey = null;
                    String featureKeyLink = null;
                    if (PropertyValidator.isValid(singleBaseLineItem.get("jiraId"))) {
                        featureKey = (String)singleBaseLineItem.get("jiraKey");
                        itemBaseLineData.put("keyType", "jiraKey");
                    } else if (PropertyValidator.isValid(singleBaseLineItem.get("tfsId"))) {
                        featureKey = (String)singleBaseLineItem.get("tfsId");
                        featureKeyLink = (String)singleBaseLineItem.get("tfsURL");
                        itemBaseLineData.put("keyType", "tfsId");
                    } else if (PropertyValidator.isValid(singleBaseLineItem.get("kendisKey"))) {
                        featureKey = (String)singleBaseLineItem.get("kendisKey");
                        featureKeyLink = (String)singleBaseLineItem.get("externalReferenceURL");
                        itemBaseLineData.put("keyType", "kendisKey");
                    } else if (PropertyValidator.isValid(singleBaseLineItem.get("jiraKey"))) {
                        featureKey = (String)singleBaseLineItem.get("jiraKey");
                        featureKeyLink = (String)singleBaseLineItem.get("externalReferenceURL");
                        itemBaseLineData.put("keyType", "kendisKey");
                    }
                    itemBaseLineData.put("key", featureKey);
                    itemBaseLineData.put("keyLink", featureKeyLink);
                    itemBaseLineData.put("id", singleBaseLineItem.get("id"));
                    itemBaseLineData.put("Details", singleBaseLineItem.get("title"));
                    itemBaseLineData.put("tfsId", singleBaseLineItem.get("tfsId"));
                    itemBaseLineData.put("tfsURL", singleBaseLineItem.get("tfsURL"));
                    itemBaseLineData.put("tfsItemType", singleBaseLineItem.get("tfsItemType"));
                    itemBaseLineData.put("tfsItemTypeIcon", singleBaseLineItem.get("tfsItemTypeIcon"));
                    itemBaseLineData.put("tfsAreaPath", singleBaseLineItem.get("tfsAreaPath"));
                    itemBaseLineData.put("tfsIterationPath", singleBaseLineItem.get("tfsIterationPath"));
                    itemBaseLineData.put("jiraKey", singleBaseLineItem.get("jiraKey"));
                    itemBaseLineData.put("jiraId", singleBaseLineItem.get("jiraId"));
                    itemBaseLineData.put("jiraFilter", singleBaseLineItem.get("jiraFilter"));
                    itemBaseLineData.put("jiraIssueTypeId", singleBaseLineItem.get("jiraIssueTypeId"));
                    itemBaseLineData.put("event", event);
                    if (PropertyValidator.isValid(singleBaseLineItem.get("status"))) {
                        Map baseLineItemStatus = null;
                        try {
                            baseLineItemStatus = (Map)singleBaseLineItem.get("status");
                        }
                        catch (Exception e) {
                            LOGGER.debug(String.valueOf(singleBaseLineItem.get("status")));
                        }
                        itemBaseLineData.put("Category", baseLineItemStatus.get("category"));
                        itemBaseLineData.put("Status", baseLineItemStatus.get("title"));
                    }
                    if (singleBaseLineItem.get("storyPoints") != null) {
                        sum = sum + (Double)singleBaseLineItem.get("storyPoints");
                        itemBaseLineData.put("Estimate", singleBaseLineItem.get("storyPoints"));
                    }
                    if (singleBaseLineItem.get("parent") != null) {
                        Map spillOverItemParent = (Map)singleBaseLineItem.get("parent");
                        itemBaseLineData.put("feature", spillOverItemParent.get("title"));
                        itemBaseLineData.put("parentId", spillOverItemParent.get("id"));
                        itemBaseLineData.put("parentkey", spillOverItemParent.get("key"));
                        itemBaseLineData.put("parentkeyType", spillOverItemParent.get("keyType"));
                        itemBaseLineData.put("parentkeyLink", spillOverItemParent.get("keyLink"));
                        itemBaseLineData.put("parentDetails", spillOverItemParent.get("title"));
                        itemBaseLineData.put("parentTfsItemTypeIcon", spillOverItemParent.get("tfsItemTypeIcon"));
                        itemBaseLineData.put("parentJiraIssueTypeId", spillOverItemParent.get("jiraIssueTypeId"));
                    }
                    List baseLineItemTeamContainersArray = new ArrayList();
                    Map baseLineItemTeamContainers = new HashMap();
                    if (singleBaseLineItem.get("teamContainers") != null && PropertyValidator.isValid(baseLineItemTeamContainersArray = (List)singleBaseLineItem.get("teamContainers")) && baseLineItemTeamContainersArray.get(0) != null) {
                        baseLineItemTeamContainers = (Map)baseLineItemTeamContainersArray.get(0);
                    }
                    HashMap baseLineTeamDataForSprint = new HashMap();
                    if (baseLineItemTeamContainers.get("team") != null && (newTeam = teamMapById.get((spillOverItemNewTeamData = (Map)baseLineItemTeamContainers.get("team")).get("id"))) != null) {
                        HashMap<String, String> baseLIneItemCurrentTeam = new HashMap<String, String>();
                        baseLIneItemCurrentTeam.put("teamId", newTeam.getId());
                        baseLIneItemCurrentTeam.put("teamTitle", newTeam.getTitle());
                        baseLIneItemCurrentTeam.put("teamLabels", newTeam.getLabel());
                        baseLIneItemCurrentTeam.put("teamColor", newTeam.getColor());
                        HashMap<String, HashMap<String, String>> ItemCurrentTeam = new HashMap<String, HashMap<String, String>>();
                        ItemCurrentTeam.put(String.valueOf(newTeam.getId()), baseLIneItemCurrentTeam);
                        itemBaseLineData.put("itemTeamData", ItemCurrentTeam);
                        if (baseLineDataByTeamAndSprint.get(String.valueOf(newTeam.getId())) == null) {
                            baseLineDataByTeamAndSprint.put(String.valueOf(newTeam.getId()), new HashMap());
                        }
                        baseLineTeamDataForSprint = (HashMap)baseLineDataByTeamAndSprint.get(String.valueOf(newTeam.getId()));
                    }
                    if (baseLineItemTeamContainers.get("container") == null) continue;
                    Map spillOverNewItemSprintData = (Map)baseLineItemTeamContainers.get("container");
                    Container container = containerMapById.get(spillOverNewItemSprintData.get("id"));
                    if (!PropertyValidator.isValid((Object)container)) {
                        container = containerMapById.get(spillOverNewItemSprintData.get("originItemId"));
                    }
                    if (!PropertyValidator.isValid((Object)container)) continue;
                    HashMap<String, String> baseLIneItemCurrentSprint = new HashMap<String, String>();
                    baseLIneItemCurrentSprint.put("container", container.getTitle());
                    baseLIneItemCurrentSprint.put("containerLabel", container.getLabel());
                    baseLIneItemCurrentSprint.put("containerId", container.getId());
                    HashMap<String, HashMap<String, String>> ItemCurrentSprint = new HashMap<String, HashMap<String, String>>();
                    ItemCurrentSprint.put(String.valueOf(container.getId()), baseLIneItemCurrentSprint);
                    itemBaseLineData.put("itemSprintData", ItemCurrentSprint);
                    if (baseLineTeamDataForSprint.get(String.valueOf(container.getId())) == null) {
                        baseLineTeamDataForSprint.put(String.valueOf(container.getId()), new ArrayList());
                    }
                    ArrayList baseLineTeamDataForItems = (ArrayList)baseLineTeamDataForSprint.get(String.valueOf(container.getId()));
                    baseLineTeamDataForItems.add(itemBaseLineData);
                }
                DBObject cap = capMap.get(String.valueOf(auditLogData.get("_id")));
                if (!PropertyValidator.isValid((Object)cap)) continue;
                cap.put("commitedLoad", (Object)sum);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return baseLineDataByTeamAndSprint;
    }

    private HashMap<String, Object> filterSpillOverFromBaseLineData(List<DBObject> auditLogs, HashMap<String, Container> containerMapById, HashMap<String, Team> teamMapById, HashMap<String, DBObject> itemsById, Map<String, String> auditLogIdForSpillData) {
        try {
            Set ids;
            Gson gson = new Gson();
            8 T = new /* Unavailable Anonymous Inner Class!! */;
            Map reqbody = new HashMap();
            ArrayList<String> spillOverItemsIds = new ArrayList<String>();
            HashMap<String, Boolean> selectedParentIds = new HashMap<String, Boolean>();
            HashMap spillOverDataBySprintIds = new HashMap();
            HashMap spillOverDataByTeamIds = new HashMap();
            HashMap spillOverDataByItemType = new HashMap();
            HashMap spillOverStories = new HashMap();
            HashMap spillOverFeatures = new HashMap();
            spillOverDataByItemType.put("spillOverStories", spillOverStories);
            spillOverDataByItemType.put("spillOverFeatures", spillOverFeatures);
            if (PropertyValidator.isValid(auditLogs)) {
                for (DBObject auditLogData : auditLogs) {
                    String auditId = PropertyValidator.isValid((Object)auditLogData.get("linkedBaseLineAuditLogId")) ? (String)auditLogData.get("linkedBaseLineAuditLogId") : String.valueOf(auditLogData.get("_id"));
                    String startedSprintId = auditLogIdForSpillData.get(auditId);
                    if (!PropertyValidator.isValid((Object)startedSprintId) || auditLogData.get("auditData") == null) continue;
                    String oldTeamId = auditLogIdForSpillData.get("tsvTeamId_" + auditId);
                    String oldSprintId = auditLogIdForSpillData.get("tsvSprintId_" + auditId);
                    reqbody = (Map)gson.fromJson((String)auditLogData.get("auditData"), T.getType());
                    Set keys = reqbody.keySet();
                    for (String key : keys) {
                        Map spillOverItemParent;
                        boolean isStory;
                        Map loggedItem = (Map)reqbody.get(key);
                        String itemId = String.valueOf(loggedItem.get("id"));
                        DBObject currentItem = itemsById.get(itemId);
                        if (currentItem == null) {
                            currentItem = itemsById.get(key);
                        }
                        if (currentItem == null || (isStory = loggedItem.get("type").equals(Item.Type.UserStory.name())) && Boolean.TRUE.equals(currentItem.get(startedSprintId))) continue;
                        HashMap<String, Object> itemSpillOverData = new HashMap<String, Object>();
                        List baseLineTCs = new ArrayList();
                        List spillOverTCs = new ArrayList();
                        HashMap<String, Boolean> oldTeamIdsMap = new HashMap<String, Boolean>();
                        HashMap<String, Boolean> oldSprintIdsMap = new HashMap<String, Boolean>();
                        if (loggedItem.get("teamContainers") != null && PropertyValidator.isValid(baseLineTCs = (List)loggedItem.get("teamContainers"))) {
                            HashMap teams = new HashMap();
                            HashMap sprints = new HashMap();
                            itemSpillOverData.put("previousStateItemTeamData", teams);
                            itemSpillOverData.put("previousStateItemSprintData", sprints);
                            for (Object tc : baseLineTCs) {
                                Set getSpillOverItemIdsArray;
                                Map old;
                                if (!PropertyValidator.isValid(tc)) continue;
                                Map baseLineTC = (Map)tc;
                                if (baseLineTC.containsKey("team")) {
                                    old = (Map)baseLineTC.get("team");
                                    HashMap<String, String> team = new HashMap<String, String>();
                                    String teamId = (String)old.get("id");
                                    team.put("teamId", teamId);
                                    team.put("teamTitle", (String)old.get("title"));
                                    team.put("teamLabels", (String)old.get("label"));
                                    team.put("teamColor", (String)old.get("color"));
                                    teams.put(String.valueOf(teamId), team);
                                    oldTeamIdsMap.put(String.valueOf(teamId), true);
                                    if (spillOverDataByTeamIds.get(teamId) == null) {
                                        spillOverDataByTeamIds.put(teamId, new HashSet());
                                    }
                                    getSpillOverItemIdsArray = (Set)spillOverDataByTeamIds.get(teamId);
                                    getSpillOverItemIdsArray.add(itemId);
                                }
                                if (!baseLineTC.containsKey("container")) continue;
                                old = (Map)baseLineTC.get("container");
                                HashMap<String, Object> sprint = new HashMap<String, Object>();
                                String sprintId = (String)old.get("id");
                                sprint.put("containerId", sprintId);
                                sprint.put("container", old.get("title"));
                                sprint.put("containerLabel", old.get("label"));
                                sprint.put("featureTeamOfTheSprint", new HashMap());
                                if (baseLineTC.containsKey("team")) {
                                    Map oldTeam = (Map)baseLineTC.get("team");
                                    HashMap<String, String> temporarySprintTeamMap = new HashMap<String, String>();
                                    temporarySprintTeamMap.put("teamId", String.valueOf(oldTeam.get("id")));
                                    temporarySprintTeamMap.put("teamTitle", (String)oldTeam.get("title"));
                                    temporarySprintTeamMap.put("teamLabels", (String)oldTeam.get("label"));
                                    temporarySprintTeamMap.put("teamColor", (String)oldTeam.get("color"));
                                    HashMap featureTeamOfTheSprint = (HashMap)sprint.get("featureTeamOfTheSprint");
                                    featureTeamOfTheSprint.put(String.valueOf(oldTeam.get("id")), temporarySprintTeamMap);
                                }
                                sprints.put(String.valueOf(sprintId), sprint);
                                oldSprintIdsMap.put(String.valueOf(sprintId), true);
                                if (spillOverDataBySprintIds.get(sprintId) == null) {
                                    spillOverDataBySprintIds.put(sprintId, new HashSet());
                                }
                                getSpillOverItemIdsArray = (Set)spillOverDataBySprintIds.get(sprintId);
                                getSpillOverItemIdsArray.add(itemId);
                            }
                        }
                        if (PropertyValidator.isValid(spillOverTCs = (List)currentItem.get("_teamContainers"))) {
                            HashMap sprints = new HashMap();
                            HashMap teams = new HashMap();
                            itemSpillOverData.put("itemTeamData", teams);
                            itemSpillOverData.put("itemSprintData", sprints);
                            for (TeamContainer teamContainer : spillOverTCs) {
                                String sprintId;
                                String teamId;
                                if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                                if (!(teamContainer.getTeam() == null || (teamId = String.valueOf(teamContainer.getTeam().getId())).equals(oldTeamId) && isStory)) {
                                    HashMap<String, String> team = new HashMap<String, String>();
                                    team.put("teamId", teamId);
                                    team.put("teamTitle", teamContainer.getTeam().getTitle());
                                    team.put("teamLabels", teamContainer.getTeam().getLabel());
                                    team.put("teamColor", teamContainer.getTeam().getColor());
                                    teams.put(teamId, team);
                                    if (oldTeamIdsMap.containsKey(teamId)) {
                                        oldTeamIdsMap.put(teamId, false);
                                    } else {
                                        oldTeamIdsMap.put(teamId, true);
                                    }
                                }
                                if (teamContainer.getContainer() == null || (sprintId = String.valueOf(teamContainer.getContainer().getId())).equals(oldSprintId) && isStory) continue;
                                HashMap<String, String> sprint = new HashMap<String, String>();
                                sprint.put("containerId", sprintId);
                                sprint.put("container", teamContainer.getContainer().getTitle());
                                sprint.put("containerLabel", teamContainer.getContainer().getLabel());
                                sprints.put(sprintId, sprint);
                                if (oldSprintIdsMap.containsKey(sprintId)) {
                                    oldSprintIdsMap.put(sprintId, false);
                                    continue;
                                }
                                oldSprintIdsMap.put(sprintId, true);
                            }
                            if (!isStory) {
                                if (!MapUtils.invertMap(oldTeamIdsMap).containsKey(true)) {
                                    itemSpillOverData.remove("previousStateItemTeamData");
                                }
                                if (!MapUtils.invertMap(oldSprintIdsMap).containsKey(true)) {
                                    itemSpillOverData.remove("previousStateItemSprintData");
                                }
                            }
                        } else if (!PropertyValidator.isValid(spillOverTCs)) {
                            itemSpillOverData.put("currentTeamBacklog", "Backlog");
                            itemSpillOverData.put("currentSprintBacklog", "Backlog");
                        }
                        if (!PropertyValidator.isValid(spillOverTCs) || spillOverTCs.get(0) == null || isStory) {
                            // empty if block
                        }
                        spillOverItemsIds.add(itemId);
                        String featureKey = null;
                        String featureKeyLink = null;
                        if (PropertyValidator.isValid(loggedItem.get("jiraId"))) {
                            featureKey = (String)loggedItem.get("jiraKey");
                            itemSpillOverData.put("keyType", "jiraKey");
                            itemSpillOverData.put("jiraId", "jiraId");
                            itemSpillOverData.put("jiraIssueTypeId", loggedItem.get("jiraIssueTypeId"));
                        } else if (PropertyValidator.isValid(loggedItem.get("tfsId"))) {
                            featureKey = (String)loggedItem.get("tfsId");
                            featureKeyLink = (String)loggedItem.get("tfsURL");
                            itemSpillOverData.put("keyType", "tfsId");
                            itemSpillOverData.put("tfsItemTypeIcon", loggedItem.get("tfsItemTypeIcon"));
                        } else if (PropertyValidator.isValid(loggedItem.get("kendisKey"))) {
                            featureKey = (String)loggedItem.get("kendisKey");
                            featureKeyLink = (String)loggedItem.get("externalReferenceURL");
                            itemSpillOverData.put("keyType", "kendisKey");
                        } else if (PropertyValidator.isValid(loggedItem.get("jiraKey"))) {
                            featureKey = (String)loggedItem.get("jiraKey");
                            featureKeyLink = (String)loggedItem.get("externalReferenceURL");
                            itemSpillOverData.put("keyType", "kendisKey");
                        }
                        itemSpillOverData.put("key", featureKey);
                        itemSpillOverData.put("keyLink", featureKeyLink);
                        itemSpillOverData.put("Details", loggedItem.get("title"));
                        itemSpillOverData.put("originItemId", loggedItem.get("originItemId"));
                        itemSpillOverData.put("id", itemId);
                        if (PropertyValidator.isValid(loggedItem.get("status"))) {
                            Map spillOverItemStatus = (Map)loggedItem.get("status");
                            itemSpillOverData.put("Category", spillOverItemStatus.get("category"));
                            itemSpillOverData.put("Status", spillOverItemStatus.get("title"));
                        }
                        if (loggedItem.get("newStoryPoints") != null) {
                            itemSpillOverData.put("currentEstimate", loggedItem.get("newStoryPoints"));
                        }
                        if (!currentItem.get("type").equals(Item.FEATURE)) {
                            if (PropertyValidator.isValid((Object)currentItem.get("storyPoints"))) {
                                itemSpillOverData.put("Estimate", currentItem.get("storyPoints"));
                            } else {
                                itemSpillOverData.put("Estimate", 0.0);
                            }
                        }
                        if (loggedItem.get("storyPoints") != null && !loggedItem.get("storyPoints").equals(currentItem.get("storyPoints"))) {
                            itemSpillOverData.put("previousEstimate", loggedItem.get("storyPoints"));
                        } else if (loggedItem.get("storyPoints") == null) {
                            itemSpillOverData.put("previousEstimate", 0.0);
                        }
                        if (loggedItem.get("parent") != null && isStory) {
                            spillOverItemParent = (Map)loggedItem.get("parent");
                            itemSpillOverData.put("feature", spillOverItemParent.get("title"));
                            itemSpillOverData.put("parentId", spillOverItemParent.get("id"));
                            selectedParentIds.put((String)spillOverItemParent.get("id"), true);
                        }
                        if (isStory) {
                            if (loggedItem.get("parent") != null) {
                                spillOverItemParent = (Map)loggedItem.get("parent");
                                itemSpillOverData.put("feature", spillOverItemParent.get("title"));
                                itemSpillOverData.put("parentId", spillOverItemParent.get("id"));
                                itemSpillOverData.put("parentkey", spillOverItemParent.get("key"));
                                itemSpillOverData.put("parentkeyType", spillOverItemParent.get("keyType"));
                                itemSpillOverData.put("parentkeyLink", spillOverItemParent.get("keyLink"));
                                itemSpillOverData.put("parentDetails", spillOverItemParent.get("title"));
                                itemSpillOverData.put("parentTfsItemTypeIcon", spillOverItemParent.get("tfsItemTypeIcon"));
                                itemSpillOverData.put("parentJiraIssueTypeId", spillOverItemParent.get("jiraIssueTypeId"));
                            }
                            spillOverStories.put(itemId, itemSpillOverData);
                            if (spillOverFeatures.get(itemSpillOverData.get("parentId")) == null) {
                                HashMap storyParentMap = new HashMap();
                                if (!currentItem.get("type").equals(Item.FEATURE) && itemSpillOverData.get("previousEstimate") != null) {
                                    storyParentMap.put("previousEstimate", itemSpillOverData.get("previousEstimate"));
                                }
                                storyParentMap.put("ToDo", 0);
                                storyParentMap.put("InProgress", 0);
                                storyParentMap.put("Done", 0);
                                storyParentMap.put("Misc", 0);
                                if (PropertyValidator.isValid(itemSpillOverData.get("Category"))) {
                                    storyParentMap.put(String.valueOf(itemSpillOverData.get("Category")), (Integer)storyParentMap.get(itemSpillOverData.get("Category")) + 1);
                                }
                                spillOverFeatures.put(String.valueOf(itemSpillOverData.get("parentId")), storyParentMap);
                                continue;
                            }
                            if (spillOverFeatures.get(itemSpillOverData.get("parentId")) == null) continue;
                            HashMap getParentItemMap = (HashMap)spillOverFeatures.get(itemSpillOverData.get("parentId"));
                            if (itemSpillOverData.get("previousEstimate") != null && getParentItemMap.get("previousEstimate") != null) {
                                getParentItemMap.put("previousEstimate", (Double)getParentItemMap.get("previousEstimate") + (Double)itemSpillOverData.get("previousEstimate"));
                            } else if (itemSpillOverData.get("previousEstimate") != null && getParentItemMap.get("previousEstimate") == null) {
                                getParentItemMap.put("previousEstimate", Double.valueOf((Double)itemSpillOverData.get("previousEstimate")));
                            }
                            if (!PropertyValidator.isValid(itemSpillOverData.get("Category"))) continue;
                            getParentItemMap.put(String.valueOf(itemSpillOverData.get("Category")), (Integer)getParentItemMap.get(itemSpillOverData.get("Category")) + 1);
                            continue;
                        }
                        if (!loggedItem.get("type").equals(Item.Type.Feature.name())) continue;
                        HashMap getSpillOverFeaturesMap = (HashMap)spillOverDataByItemType.get("spillOverFeatures");
                        if (getSpillOverFeaturesMap.get(itemId) == null) {
                            itemSpillOverData.put("ToDo", 0);
                            itemSpillOverData.put("InProgress", 0);
                            itemSpillOverData.put("Done", 0);
                            itemSpillOverData.put("Misc", 0);
                            getSpillOverFeaturesMap.put(itemId, itemSpillOverData);
                            continue;
                        }
                        if (getSpillOverFeaturesMap.get(itemId) == null) continue;
                        HashMap getParentItemMap = (HashMap)getSpillOverFeaturesMap.get(itemId);
                        itemSpillOverData.put("ToDo", getParentItemMap.get("ToDo"));
                        itemSpillOverData.put("InProgress", getParentItemMap.get("InProgress"));
                        itemSpillOverData.put("Done", getParentItemMap.get("Done"));
                        itemSpillOverData.put("Misc", getParentItemMap.get("Misc"));
                        itemSpillOverData.put("previousEstimate", getParentItemMap.get("previousEstimate"));
                        getSpillOverFeaturesMap.put(itemId, itemSpillOverData);
                    }
                }
            }
            if (PropertyValidator.isValid(ids = spillOverFeatures.keySet())) {
                HashSet copy = new HashSet();
                copy.addAll(ids);
                for (String id : copy) {
                    if (selectedParentIds.containsKey(id)) continue;
                    spillOverFeatures.remove(id);
                }
            }
            HashMap<String, Object> responceOfSpillOver = new HashMap<String, Object>();
            responceOfSpillOver.put("spillOverItems", spillOverDataByItemType);
            responceOfSpillOver.put("spillOverDataBySprintIds", spillOverDataBySprintIds);
            responceOfSpillOver.put("spillOverDataByTeamIds", spillOverDataByTeamIds);
            return responceOfSpillOver;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new HashMap<String, Object>();
        }
    }

    public HashMap<String, Object> getObjectiveStatsBySprintAndTeam(SessionBoard activeSessionBoard, Container currentSprint) {
        try {
            int objectivesCreatedInSprint = 0;
            if (PropertyValidator.isValid((Object)activeSessionBoard)) {
                HashMap boardObjectives = activeSessionBoard.getObjectivesMap();
                List objectiveIds = activeSessionBoard.getObjectiveIds();
                if (PropertyValidator.isValid((Collection)objectiveIds) && objectiveIds.size() > 0) {
                    for (int i = 0; i < objectiveIds.size(); ++i) {
                        Objective selectedObjective = (Objective)boardObjectives.get(objectiveIds.get(i));
                        if (!PropertyValidator.isValid((Object)selectedObjective) || !selectedObjective.getCreatedOn().after(currentSprint.getStartDate()) && !selectedObjective.getCreatedOn().equals(currentSprint.getStartDate()) || !selectedObjective.getCreatedOn().after(currentSprint.getEndDate()) && !selectedObjective.getCreatedOn().equals(currentSprint.getEndDate())) continue;
                        ++objectivesCreatedInSprint;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    public HashMap<String, Object> calculateTeamSprintVelocity(List<DBObject> boardCapacity) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            for (DBObject capacity : boardCapacity) {
                if (!PropertyValidator.isValid((Object)capacity.get("sprintId")) || !PropertyValidator.isValid((Object)capacity.get("teamId"))) continue;
                if (!response.containsKey(String.valueOf(capacity.get("teamId")))) {
                    response.put(String.valueOf(capacity.get("teamId")), new HashMap());
                }
                HashMap sprintData = (HashMap)response.get(String.valueOf(capacity.get("teamId")));
                HashMap<String, Object> teamVelocityData = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)capacity.get("velocity"))) {
                    teamVelocityData.put("capacity", capacity.get("velocity"));
                } else {
                    teamVelocityData.put("capacity", 0);
                }
                if (PropertyValidator.isValid((Object)capacity.get("commitedLoad"))) {
                    teamVelocityData.put("commitedLoad", capacity.get("commitedLoad"));
                } else {
                    teamVelocityData.put("commitedLoad", 0);
                }
                sprintData.put(String.valueOf(capacity.get("sprintId")), teamVelocityData);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }
}

