/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.PIController;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.SprintReportServics;
import com.viztrend.safe.service.StateChangeService;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="StateChangeService")
@Transactional
public class StateChangeServiceImpl
implements StateChangeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PIController.class);
    @Autowired
    CustomRepositoryImpl customRepositoryImpl;
    @Autowired
    SessionBoardRepository sessionBoardRepository;
    @Autowired
    PushResponseRepository pushResponseRepository;
    @Autowired
    ItemRepository itemRepository;
    @Autowired
    TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    ContainerRepository containerRepository;
    @Autowired
    TeamContainerRepository teamContainerRepository;
    @Autowired
    ItemLinkRepository itemLinkRepository;
    @Autowired
    ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    SprintReportServics sprintReportServics;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    ObjectiveService objectiveService;

    public HashMap<String, Object> changeBoardState(HashMap<String, Object> params) {
        SessionBoard savedSessionBoard = null;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List subSetsNewItemLinksNotNullList;
            Object newItemLinkId;
            String boardId = (String)params.get("boardId");
            String stateId = (String)params.get("stateId");
            Boolean isFinalState = (Boolean)params.get("isFinalState");
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            responseJson.put("currentSessionBoard", savedSessionBoard.getId());
            SessionBoard newSessionBoard = new SessionBoard();
            if (!PropertyValidator.isValid((Object)savedSessionBoard.getState())) {
                savedSessionBoard.setState(new State(stateId));
                this.sessionBoardRepository.save((Object)savedSessionBoard);
                responseJson.put("newSessionBoard", savedSessionBoard.getId());
                responseJson.put("success", true);
                responseJson.put("newStateId", stateId);
                return responseJson;
            }
            String currentSessionId = savedSessionBoard.getSession().getId();
            this.customRepositoryImpl.checkIfSessionLocked(currentSessionId, "State Change");
            if (PropertyValidator.isValid((Object)savedSessionBoard.getParentBoard())) {
                throw new ViztrendJiraException(Integer.valueOf(Integer.parseInt(HttpStatus.IM_USED.toString())), "This State has already been saved.");
            }
            List allSessionBoardsOfSession = this.sessionBoardRepository.findBySessionId(savedSessionBoard.getSession().getId());
            if (PropertyValidator.isValid((Collection)allSessionBoardsOfSession)) {
                for (SessionBoard sb : allSessionBoardsOfSession) {
                    if (sb.getId().equals(boardId) || !PropertyValidator.isValid((Object)sb.getState()) || !sb.getState().getId().equals(stateId)) continue;
                    throw new ViztrendJiraException(Integer.valueOf(Integer.parseInt(HttpStatus.IM_USED.toString())), "This State has already been saved.");
                }
            }
            List newTeams = savedSessionBoard.getTeams();
            List newContainers = savedSessionBoard.getContainers();
            String newSessionBoardId = ObjectId.get().toString();
            HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
            ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
            ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
            ArrayList<ItemJiraDependency> newItemJiraDepdendecies = new ArrayList<ItemJiraDependency>();
            sessionBoards.add(savedSessionBoard);
            List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
            HashMap<String, String> itemIdsMapOldToNew = new HashMap<String, String>();
            for (Item item : items) {
                List jiraDeps;
                List itemLinks;
                List teamContainers = item.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc : teamContainers) {
                        if (!PropertyValidator.isValid((Object)tc) || duplicationCheckMap.containsKey(tc.getId())) continue;
                        duplicationCheckMap.put(tc.getId(), tc.getId());
                        newTeamContainers.add(tc);
                        String newTCId = ObjectId.get().toString();
                        itemIdsMapOldToNew.put(tc.getId(), newTCId);
                    }
                }
                if (PropertyValidator.isValid((Collection)(itemLinks = item.getItemLinks()))) {
                    TeamContainer tc;
                    tc = itemLinks.iterator();
                    while (tc.hasNext()) {
                        ItemLink itemLink = (ItemLink)tc.next();
                        if (!PropertyValidator.isValid((Object)itemLink)) continue;
                        newItemLinks.add(itemLink);
                        String newLinkId = ObjectId.get().toString();
                        itemIdsMapOldToNew.put(itemLink.getId(), newLinkId);
                    }
                }
                if (PropertyValidator.isValid((Collection)(jiraDeps = item.getJiraDependencies()))) {
                    for (ItemJiraDependency jiraDep : jiraDeps) {
                        if (!PropertyValidator.isValid((Object)jiraDep)) continue;
                        newItemJiraDepdendecies.add(jiraDep);
                        String newJLinkId = ObjectId.get().toString();
                        itemIdsMapOldToNew.put(jiraDep.getId(), newJLinkId);
                    }
                }
                String newItemId = ObjectId.get().toString();
                itemIdsMapOldToNew.put(item.getId(), newItemId);
            }
            ArrayList oldContainers = new ArrayList();
            newContainers.forEach(con -> {
                String newContainerId = ObjectId.get().toString();
                itemIdsMapOldToNew.put(con.getId(), newContainerId);
                Container oldCon = new Container();
                oldCon.setId(con.getId());
                oldContainers.add(oldCon);
            });
            Object modTeamContainers = new ArrayList();
            ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
            ArrayList<ItemJiraDependency> newJiraDepsNotNullList = new ArrayList<ItemJiraDependency>();
            List tsvList = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
            for (Object newTsv : tsvList) {
                if (itemIdsMapOldToNew.containsKey(newTsv.getSprintId())) {
                    newTsv.setSprintId((String)itemIdsMapOldToNew.get(newTsv.getSprintId()));
                }
                if (newTsv.getOriginItemId() == null) {
                    newTsv.setOriginItemId(newTsv.getId());
                }
                newTsv.setNextStateId(newTsv.getId());
                String newTsvId = ObjectId.get().toString();
                newTsv.setId(newTsvId);
                newTsv.setSessionBoardId(newSessionBoardId);
            }
            if (Boolean.TRUE.equals(isFinalState)) {
                savedSessionBoard.setStatus(SessionBoard.CLOSED);
            } else {
                savedSessionBoard.setStatus(SessionBoard.OPEN);
            }
            newSessionBoard.setState(new State(savedSessionBoard.getState().getId()));
            if (PropertyValidator.isValid((Collection)savedSessionBoard.getContainers())) {
                ArrayList<Container> _newConts = new ArrayList<Container>();
                for (Container con2 : savedSessionBoard.getContainers()) {
                    Container newcon = new Container();
                    newcon.setId((String)itemIdsMapOldToNew.get(con2.getId()));
                    _newConts.add(newcon);
                }
                newSessionBoard.setContainers(_newConts);
            }
            newSessionBoard.setStatus(SessionBoard.CLOSED);
            newSessionBoard.setTeams(newTeams);
            newSessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
            newSessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
            newSessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
            newSessionBoard.setTzEnabled(savedSessionBoard.getTzEnabled());
            newSessionBoard.setTzSite(savedSessionBoard.getTzSite());
            newSessionBoard.setTzStartTime(savedSessionBoard.getTzStartTime());
            newSessionBoard.setTzEndTime(savedSessionBoard.getTzEndTime());
            newSessionBoard.setTzStartTimeDiff(savedSessionBoard.getTzStartTimeDiff());
            newSessionBoard.setTzEndTimeDiff(savedSessionBoard.getTzEndTimeDiff());
            newSessionBoard.setParentBoard(savedSessionBoard.getId());
            newSessionBoard.setCreationDate(new Date());
            newSessionBoard.setSession(savedSessionBoard.getSession());
            newSessionBoard.setCreatedOn(new Date());
            newSessionBoard.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            newSessionBoard.setId(newSessionBoardId);
            newContainers.forEach(f -> {
                String newContainerId = (String)itemIdsMapOldToNew.get(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setNextStateId(f.getId());
                f.setId(newContainerId);
                f.setSessionBoardId(newSessionBoardId);
            });
            ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
            newSessionBoardList.add(newSessionBoard);
            for (Item item : items) {
                ItemLink newLink;
                ArrayList<ItemLink> _newLinks;
                item.setSessionBoards(newSessionBoardList);
                if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                    ArrayList<TeamContainer> _newTeamContainers = new ArrayList<TeamContainer>();
                    for (TeamContainer tc : item.getTeamContainers()) {
                        if (!itemIdsMapOldToNew.containsKey(tc.getId())) continue;
                        TeamContainer newTc = new TeamContainer();
                        newTc.setId((String)itemIdsMapOldToNew.get(tc.getId()));
                        _newTeamContainers.add(newTc);
                    }
                    item.setTeamContainers(_newTeamContainers);
                }
                if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                    _newLinks = new ArrayList<ItemLink>();
                    for (ItemLink link : item.getItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !itemIdsMapOldToNew.containsKey(link.getId())) continue;
                        newLink = new ItemLink();
                        newLink.setId((String)itemIdsMapOldToNew.get(link.getId()));
                        _newLinks.add(newLink);
                    }
                    item.setItemLinks(_newLinks);
                }
                if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                    _newLinks = new ArrayList();
                    for (ItemLink link : item.getJiraDependencies()) {
                        if (!PropertyValidator.isValid((Object)link) || !itemIdsMapOldToNew.containsKey(link.getId())) continue;
                        newLink = new ItemJiraDependency();
                        newLink.setId((String)itemIdsMapOldToNew.get(link.getId()));
                        _newLinks.add(newLink);
                    }
                    item.setJiraDependencies(_newLinks);
                }
                if (PropertyValidator.isValid((Object)item.getParent()) && itemIdsMapOldToNew.containsKey(item.getParent().getId())) {
                    Item newParent = new Item();
                    newParent.setId((String)itemIdsMapOldToNew.get(item.getParent().getId()));
                    item.setParent(newParent);
                }
                if (item.getOriginItemId() == null) {
                    item.setOriginItemId(item.getId());
                }
                item.setNextStateId(item.getId());
                item.setId((String)itemIdsMapOldToNew.get(item.getId()));
                item.setSuspendActivity(true);
            }
            for (TeamContainer tc : newTeamContainers) {
                if (!PropertyValidator.isValid((Object)tc.getContainer()) || !PropertyValidator.isValid((Object)tc.getContainer().getId()) || !PropertyValidator.isValid(itemIdsMapOldToNew.get(tc.getContainer().getId()))) continue;
                Container newContainer = new Container();
                newContainer.setId((String)itemIdsMapOldToNew.get(tc.getContainer().getId()));
                tc.setContainer(newContainer);
                if (!PropertyValidator.isValid((Object)tc.getOriginItemId())) {
                    tc.setOriginItemId(tc.getId());
                }
                tc.setNextStateId(tc.getId());
                String newTCId = (String)itemIdsMapOldToNew.get(tc.getId());
                tc.setId(newTCId);
                tc.setSessionBoardId(newSessionBoardId);
                modTeamContainers.add(tc);
            }
            for (ItemLink itemLink : newItemLinks) {
                if (itemLink == null) continue;
                if (itemIdsMapOldToNew.containsKey(itemLink.getSourceTeamContainerId())) {
                    itemLink.setSourceTeamContainerId((String)itemIdsMapOldToNew.get(itemLink.getSourceTeamContainerId()));
                }
                if (itemIdsMapOldToNew.containsKey(itemLink.getTargetTeamContainerId())) {
                    itemLink.setTargetTeamContainerId((String)itemIdsMapOldToNew.get(itemLink.getTargetTeamContainerId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) && itemIdsMapOldToNew.containsKey(itemLink.getSourceUserStoryId())) {
                    itemLink.setSourceUserStoryId((String)itemIdsMapOldToNew.get(itemLink.getSourceUserStoryId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && itemIdsMapOldToNew.containsKey(itemLink.getTargetUserStoryId())) {
                    itemLink.setTargetUserStoryId((String)itemIdsMapOldToNew.get(itemLink.getTargetUserStoryId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId()) && itemIdsMapOldToNew.containsKey(itemLink.getSourceFeatureId())) {
                    itemLink.setSourceFeatureId((String)itemIdsMapOldToNew.get(itemLink.getSourceFeatureId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceItemId()) && itemIdsMapOldToNew.containsKey(itemLink.getSourceItemId())) {
                    itemLink.setSourceItemId((String)itemIdsMapOldToNew.get(itemLink.getSourceItemId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId()) && itemIdsMapOldToNew.containsKey(itemLink.getTargetFeatureId())) {
                    itemLink.setTargetFeatureId((String)itemIdsMapOldToNew.get(itemLink.getTargetFeatureId()));
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetItemId()) && itemIdsMapOldToNew.containsKey(itemLink.getTargetItemId())) {
                    itemLink.setTargetItemId((String)itemIdsMapOldToNew.get(itemLink.getTargetItemId()));
                }
                itemLink.setNextStateId(itemLink.getId());
                itemLink.setOriginItemId(itemLink.getOriginItemId() == null ? itemLink.getId() : itemLink.getOriginItemId());
                itemLink.setDuplicateOfId(itemLink.getId());
                newItemLinkId = (String)itemIdsMapOldToNew.get(itemLink.getId());
                itemLink.setId((String)newItemLinkId);
                itemLink.setSessionBoardId(newSessionBoardId);
                newItemLinksNotNullList.add(itemLink);
            }
            for (ItemJiraDependency jiraDep : newItemJiraDepdendecies) {
                if (jiraDep == null) continue;
                if (PropertyValidator.isValid((Object)jiraDep.getSourceItemId()) && itemIdsMapOldToNew.containsKey(jiraDep.getSourceItemId())) {
                    jiraDep.setSourceItemId((String)itemIdsMapOldToNew.get(jiraDep.getSourceItemId()));
                }
                if (PropertyValidator.isValid((Object)jiraDep.getTargetItemId()) && itemIdsMapOldToNew.containsKey(jiraDep.getTargetItemId())) {
                    jiraDep.setTargetItemId((String)itemIdsMapOldToNew.get(jiraDep.getTargetItemId()));
                }
                jiraDep.setOriginItemId(jiraDep.getId());
                jiraDep.setOriginItemId(jiraDep.getOriginItemId() == null ? jiraDep.getId() : jiraDep.getOriginItemId());
                newItemLinkId = (String)itemIdsMapOldToNew.get(jiraDep.getId());
                jiraDep.setId((String)newItemLinkId);
                jiraDep.setSessionBoardId(newSessionBoardId);
                newJiraDepsNotNullList.add(jiraDep);
            }
            LOGGER.debug(" Before stateChangeForBaseItems....  ");
            LOGGER.debug(" After stateChangeForBaseItems....  ");
            if (PropertyValidator.isValid((Collection)newContainers)) {
                newContainers = this.containerRepository.save((Iterable)newContainers);
            }
            if (PropertyValidator.isValid(modTeamContainers)) {
                List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
                Iterator tempModTeamContainers = new ArrayList();
                for (List subSetModTeamContainer : subSetsModTeamContainers) {
                    tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
                    LOGGER.debug(" subSetModTeamContainer....  ");
                }
                modTeamContainers = tempModTeamContainers;
            }
            if (PropertyValidator.isValid(newItemLinksNotNullList)) {
                subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
                for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
                    LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
                }
            }
            if (PropertyValidator.isValid(newJiraDepsNotNullList)) {
                subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newJiraDepsNotNullList), (int)100);
                for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
                    this.itemJiraDependencyRepository.save((Iterable)subSetNewItemLinksNotNullList);
                    LOGGER.debug(" subSetNewItemJiraDepsNotNullList....  ");
                }
            }
            if (PropertyValidator.isValid((Collection)tsvList)) {
                List subSetsTSVList = Lists.partition(new ArrayList(tsvList), (int)100);
                for (List subSetTSVList : subSetsTSVList) {
                    this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
                    LOGGER.debug(" subSetTSVList....  ");
                }
            }
            if (PropertyValidator.isValid((Collection)items)) {
                List subSetsNewItems = Lists.partition(new ArrayList(items), (int)100);
                ArrayList tempNewItems = new ArrayList();
                for (List subSetNewItems : subSetsNewItems) {
                    tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
                    LOGGER.debug(" subSetNewItems....  ");
                }
            }
            if (savedSessionBoard.getStateChangeDate() == null) {
                newSessionBoard.setStateChangeDate(savedSessionBoard.getCreatedOn());
            } else {
                newSessionBoard.setStateChangeDate(savedSessionBoard.getStateChangeDate());
            }
            savedSessionBoard.setStateChangeDate(new Date());
            newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newSessionBoard);
            savedSessionBoard.setState(new State(stateId));
            savedSessionBoard.setContainers(oldContainers);
            this.sessionBoardRepository.save((Object)savedSessionBoard);
            this.sprintReportServics.sprintReportHandleStateChange(currentSessionId, savedSessionBoard, newSessionBoard, itemIdsMapOldToNew);
            if (!newSessionBoard.getSession().getLoadOldObjectivesView().booleanValue()) {
                try {
                    HashMap objectives = this.objectiveService.loadObjectivesListBySessionId(currentSessionId, null, boardId);
                    ObjectMapper mapper = new ObjectMapper();
                    MongoSyncUtils.storeData((String)("old_state_objectives_" + newSessionBoard.getId()), (String)mapper.writeValueAsString((Object)objectives), (AppConfig.MongoConfig)this.mongoConfig);
                }
                catch (Exception ex) {
                    LOGGER.error("error in save objective state :" + StringUtils.getTraceString((Throwable)ex));
                }
            }
            this.customRepositoryImpl.removeSessionLock(currentSessionId);
            responseJson.put("newSessionBoard", newSessionBoard.getId());
            responseJson.put("success", true);
            responseJson.put("newStateId", stateId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            AlmError almerr = new AlmError();
            JSONObject pushJson = new JSONObject();
            if (e instanceof ViztrendJiraException) {
                ViztrendJiraException vJe = (ViztrendJiraException)((Object)e);
                if (HttpStatus.LOCKED.toString().equals(String.valueOf(vJe.getCode()))) {
                    almerr.setHttpErrorCode(((ViztrendJiraException)((Object)e)).getCode());
                } else if (HttpStatus.IM_USED.toString().equals(String.valueOf(vJe.getCode()))) {
                    pushJson.put("newBoardId", (Object)savedSessionBoard.getParentBoard());
                    almerr.setHttpErrorCode(((ViztrendJiraException)((Object)e)).getCode());
                    this.customRepositoryImpl.removeSessionLock(savedSessionBoard.getSession().getId());
                } else {
                    almerr.setHttpErrorCode(Integer.valueOf(400));
                    this.customRepositoryImpl.removeSessionLock(savedSessionBoard.getSession().getId());
                }
            } else {
                this.customRepositoryImpl.removeSessionLock(savedSessionBoard.getSession().getId());
            }
            almerr.setAlmErrorMessage(e.getMessage());
            almerr.setDescription(StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            responseJson.put("error", almerr);
        }
        return responseJson;
    }
}

