/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.controller.ExternalEntitiesController;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.SprintReportServics;
import com.viztrend.safe.service.StatsService;
import com.viztrend.safe.strategy.DoubleTypeAdapter;
import com.viztrend.safe.strategy.FloatTypeAdapter;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="SprintReportServics")
@Transactional
public class SprintReportServiceImpl
implements SprintReportServics {
    @Autowired
    private StatsService statsService;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private ExternalEntitiesController externalEntitiesController;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private ObjectiveService objectiveService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SprintReportServiceImpl.class);

    private List<DBObject> getSingleItemById(String sessionId, String sprintId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sessionId").is((Object)sessionId), Criteria.where((String)"sprintId").is((Object)sprintId)});
        query.addCriteria((CriteriaDefinition)criteria);
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("auditLog").find(query.getQueryObject());
        dbCursorPrefix.sort((DBObject)new BasicDBObject("createdOn", (Object)-1));
        List rawAuditlogs = dbCursorPrefix.toArray();
        return rawAuditlogs;
    }

    public AuditLog saveSprintReportExtraData(String auditLogId, Map<String, Object> requestStr) {
        try {
            AuditLog selectedAuditLog = this.auditLogRepository.findById(auditLogId);
            HashMap response = (HashMap)selectedAuditLog.getAuditMeta();
            response.put("description", requestStr.get("description"));
            if (PropertyValidator.isValid((Object)requestStr.get("settings"))) {
                response.put("settings", requestStr.get("settings"));
            }
            selectedAuditLog.setAuditMeta((Map)response);
            this.auditLogRepository.save((Object)selectedAuditLog);
            return selectedAuditLog;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private String getOldSprintReportDescription(String sessionId, String sprintId) {
        try {
            LOGGER.debug("getOldSprintReportDescription_136");
            String description = "";
            List sprintReport = this.getSingleItemById(sessionId, sprintId);
            if (sprintReport.isEmpty()) {
                Container previousStateSprint;
                LOGGER.debug("getOldSprintReportDescription_139");
                Container currentStateSprint = this.containerRepository.findById(sprintId);
                if (PropertyValidator.isValid((Object)currentStateSprint) && PropertyValidator.isValid((Object)(previousStateSprint = this.containerRepository.findById(currentStateSprint.getDuplicateOfId()))) && PropertyValidator.isValid((Collection)(sprintReport = this.getSingleItemById(sessionId, previousStateSprint.getId())))) {
                    DBObject previousStateSprintReport = (DBObject)sprintReport.get(0);
                    Map auditMeta = (Map)previousStateSprintReport.get("auditMeta");
                    description = (String)auditMeta.get("description");
                }
                LOGGER.debug("getOldSprintReportDescription_163");
            } else if (PropertyValidator.isValid((Collection)sprintReport)) {
                DBObject currentStateSprintReport = (DBObject)sprintReport.get(0);
                Map auditMeta = (Map)currentStateSprintReport.get("auditMeta");
                description = (String)auditMeta.get("description");
                LOGGER.debug("getOldSprintReportDescription_168");
            }
            return description;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return "";
        }
    }

    public DBObject getSprintReport(String sessionId, String sprintId) {
        try {
            LOGGER.debug("getSprintReport_145");
            List sprintReport = this.getSingleItemById(sessionId, sprintId);
            if (sprintReport.isEmpty()) {
                LOGGER.debug("getSprintReport_149");
                String description = "";
                String settings = "";
                this.sprintReportGenration(sessionId, sprintId, description, settings, null);
                sprintReport = this.getSingleItemById(sessionId, sprintId);
                LOGGER.debug("getSprintReport_155");
            }
            DBObject latestSprintReport = null;
            if (PropertyValidator.isValid((Collection)sprintReport)) {
                LOGGER.debug("getSprintReport_161");
                for (DBObject sprintVersion : sprintReport) {
                    if (latestSprintReport == null) {
                        latestSprintReport = sprintVersion;
                        LOGGER.debug("getSprintReport_166");
                    }
                    Date latestSprintReportDate = (Date)latestSprintReport.get("createdOn");
                    Date sprintVersionDate = (Date)sprintVersion.get("createdOn");
                    if (latestSprintReportDate.getTime() >= sprintVersionDate.getTime()) continue;
                    latestSprintReport = sprintVersion;
                }
                latestSprintReport.put("id", (Object)String.valueOf(latestSprintReport.get("_id")));
            }
            return latestSprintReport;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public AuditLog sprintReportSelectedVersion(String auditLogId) {
        try {
            AuditLog selectedAuditLog = this.auditLogRepository.findById(auditLogId);
            return selectedAuditLog;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public ArrayList<Object> getSprintReportVersion(String sessionId, String sprintId) {
        ArrayList<Object> response = new ArrayList<Object>();
        try {
            List sprintReport = this.getSingleItemById(sessionId, sprintId);
            if (PropertyValidator.isValid((Collection)sprintReport)) {
                for (DBObject sprintVersion : sprintReport) {
                    HashMap<String, Object> sprintReportVersionData = new HashMap<String, Object>();
                    sprintReportVersionData.put("id", String.valueOf(sprintVersion.get("_id")));
                    sprintReportVersionData.put("sessionId", sprintVersion.get("sessionId"));
                    sprintReportVersionData.put("sprintId", sprintVersion.get("sprintId"));
                    sprintReportVersionData.put("createdBy", sprintVersion.get("createdBy"));
                    sprintReportVersionData.put("createdOn", sprintVersion.get("createdOn"));
                    response.add(sprintReportVersionData);
                }
            }
            return response;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return response;
        }
    }

    private HashMap<String, Object> dataParameterForCall() {
        HashMap<String, Object> parametersForCall = new HashMap<String, Object>();
        try {
            HashMap<String, String> parameterForServer = new HashMap<String, String>();
            parameterForServer.put("previousStateRequire", "previousStateRequire");
            parameterForServer.put("callFromAnalyticsFlag", "callFromAnalyticsFlag");
            parameterForServer.put("completionGraphWithPopupData", "completionGraphWithPopupData");
            parameterForServer.put("scopeChange", "scopeChange");
            parameterForServer.put("deliveryVariations", "deliveryVariations");
            parameterForServer.put("backlogFeatures", "backlogFeatures");
            parameterForServer.put("boardStateStatusTable", "boardStateStatusTable");
            parameterForServer.put("spillOver", "spillOver");
            parameterForServer.put("allTeamProgressGraph", "allTeamProgressGraph");
            parameterForServer.put("teamFeatureDoneByStories", "teamFeatureDoneByStories");
            parameterForServer.put("teamBySprintGraphData", "teamBySprintGraphData");
            parameterForServer.put("unPlannedSum", "unPlannedSum");
            parameterForServer.put("sprintByTeamView", "sprintByTeamView");
            parameterForServer.put("baseLineData", "baseLineData");
            parameterForServer.put("commitedLoad", "commitedLoad");
            parameterForServer.put("allTeamsDetailByBoardState", "allTeamsDetailByBoardState");
            parameterForServer.put("Dependencies", "Dependencies");
            parameterForServer.put("sprintDependencies", "sprintDependencies");
            parameterForServer.put("notFeatchExcludeItemData", "notFeatchExcludeItemData");
            parametersForCall.put("flagsForDataRequire", parameterForServer);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return parametersForCall;
    }

    public void callSprintReportFunctionWithDelay(String sessionId, String sprintId, String description, String settings, String userName) {
        try {
            Container activeSprint = this.containerRepository.findById(sprintId);
            activeSprint.setProcessingSprintReport(Boolean.valueOf(true));
            this.containerRepository.save((Object)activeSprint);
            int delayInSeconds = 300;
            new Thread(() -> {
                try {
                    Thread.sleep(delayInSeconds * 1000);
                    this.sprintReportGenration(sessionId, sprintId, description, null, userName);
                    activeSprint.setProcessingSprintReport(Boolean.valueOf(false));
                    this.containerRepository.save((Object)activeSprint);
                }
                catch (Exception e) {
                    LOGGER.error("Error generating sprint report from webhooksyncServiceImpl: {}", (Object)StringUtils.getTraceString((Throwable)e));
                }
                finally {
                    activeSprint.setProcessingSprintReport(Boolean.valueOf(false));
                    this.containerRepository.save((Object)activeSprint);
                }
            }).start();
        }
        catch (Exception e) {
            LOGGER.error("Error in callSprintReportFunctionWithDelay: {}", (Object)StringUtils.getTraceString((Throwable)e));
        }
    }

    public AuditLog sprintReportGenration(String sessionId, String sprintId, String description, String settings, String userName) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap itemsState = new HashMap();
        HashMap parametersForCall = this.dataParameterForCall();
        LOGGER.debug("sprintReportGenration_288");
        HashMap getAnalyticsData = this.statsService.getPiReport(sessionId, (Map)parametersForCall);
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
        Container activeSprint = this.containerRepository.findById(sprintId);
        LOGGER.debug("sprintReportGenration_293");
        if (!PropertyValidator.isValid((Object)activeSprint)) {
            activeSprint = this.findActiveSprintOfTheBoard(getAnalyticsData);
        }
        LOGGER.debug("sprintReportGenration_297");
        AuditLog auditLog = new AuditLog();
        if (PropertyValidator.isValid((Object)activeSprint)) {
            LOGGER.debug("sprintReportGenration_303");
            String sprintReportDescription = description;
            if (!PropertyValidator.isValid((Object)sprintReportDescription)) {
                sprintReportDescription = this.getOldSprintReportDescription(sessionId, sprintId);
            }
            response.put("sprintFeatureDelivery", this.filterFeaturesForSprints(getAnalyticsData, activeSprint, itemsState));
            response.put("sprintStoriesDelivery", this.sprintStoriesCalculation(getAnalyticsData, activeSprint, itemsState));
            response.put("sprintRisk", this.calculateRiskRelatedToCurrentBoard((SessionBoard)getAnalyticsData.get("SessionBoard"), activeSprint, itemsState));
            response.put("sprintImpediments", this.calculateImpedimentsLinkedToSprint((SessionBoard)getAnalyticsData.get("SessionBoard"), activeSprint, itemsState));
            response.put("sprintdependencies", this.calculateSprintDependencies(getAnalyticsData, activeSprint, itemsState));
            response.put("teamSprintVelocity", getAnalyticsData.get("teamSprintVelocity"));
            response.put("settings", settings);
            response.put("boardState", getAnalyticsData.get("activeSessionBoard"));
            response.put("sprintId", String.valueOf(activeSprint.getId()));
            response.put("description", sprintReportDescription);
            try {
                LOGGER.debug("_SprintReportBeforGson_");
                GsonBuilder gsonBuilderWithCriteria = new GsonBuilder();
                gsonBuilderWithCriteria.registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter());
                gsonBuilderWithCriteria.registerTypeAdapter(Float.class, (Object)new FloatTypeAdapter());
                Gson gson = gsonBuilderWithCriteria.create();
                String json = gson.toJson(itemsState);
                String temp = json.toString();
                Date currentDate = new Date();
                response.put("reportGenerationDate", currentDate);
                if (PropertyValidator.isValid((Object)userName)) {
                    auditLog.setId(ObjectId.get().toHexString());
                    auditLog.setCreatedBy(userName);
                }
                auditLog.setSessionBoardId(activeSessionBoard.getId());
                auditLog.setSessionId(sessionId);
                auditLog.setCreatedOn(currentDate);
                auditLog.setEventType("SPRINT_REPORT");
                auditLog.setAuditData(temp);
                auditLog.setTenant(session.getTenant());
                auditLog.setAuditMeta(response);
                auditLog.setSprintId(String.valueOf(activeSprint.getId()));
                this.auditLogRepository.save((Object)auditLog);
            }
            catch (Exception ex) {
                LOGGER.debug("sprintReportGenration_351");
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
            LOGGER.debug("sprintReportGenration_334");
        }
        return auditLog;
    }

    private void putDataInArrayOfObject(HashMap<String, Object> objectMap, String property, String id, HashMap<String, Object> Data) {
        try {
            if (PropertyValidator.isValid((Object)objectMap.get(property))) {
                HashMap propertyMap = (HashMap)objectMap.get(property);
                if (!PropertyValidator.isValid(propertyMap.get(id))) {
                    propertyMap.put(id, new ArrayList());
                }
                ArrayList dataArray = (ArrayList)propertyMap.get(id);
                dataArray.add(Data.get("id"));
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private String getItemKey(Map<String, Object> item) {
        String key = (String)item.get("tfsId");
        if (key == null) {
            key = (String)item.get("jiraId");
        }
        if (key == null) {
            // empty if block
        }
        return key;
    }

    public void putItemWithoutDuplicate(Map<String, Object> data, Map<String, Object> itemsState, Map<String, String> duplicate) {
        String key = this.getItemKey(data);
        String id = String.valueOf(data.get("id"));
        if (PropertyValidator.isValid((Object)key) && PropertyValidator.isValid((Object)duplicate.get(key))) {
            String prev = duplicate.get(key);
            itemsState.remove(prev);
        }
        itemsState.put(id, data);
        if (key != null) {
            duplicate.put(key, id);
        }
    }

    private HashMap<String, Object> filterFeaturesForSprints(HashMap<String, Object> analyticsData, Container activeSprint, HashMap<String, Object> itemsState) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            response.put("delivered", new HashMap());
            response.put("planned", new HashMap());
            HashMap featureMapById = (HashMap)analyticsData.get("featureMapById");
            SessionBoard activeSessionBoard = (SessionBoard)analyticsData.get("SessionBoard");
            LOGGER.debug("filterFeaturesForSprints_381");
            if (PropertyValidator.isValid((Object)featureMapById)) {
                LOGGER.debug("filterFeaturesForSprints_384");
                for (String key : featureMapById.keySet()) {
                    HashMap feature = (HashMap)featureMapById.get(key);
                    if (!PropertyValidator.isValid((Object)feature) || !PropertyValidator.isValid(feature.get("itemSprintData"))) continue;
                    ArrayList sprintsByBoardSequence = this.sprintSequenceByBoard((HashMap)feature.get("itemSprintData"), activeSessionBoard);
                    HashMap maxSprint = (HashMap)sprintsByBoardSequence.get(0);
                    for (int i = 0; i < sprintsByBoardSequence.size(); ++i) {
                        double tempSprintSequence;
                        HashMap tempSprint = (HashMap)sprintsByBoardSequence.get(i);
                        double maxSprintSequence = (Double)maxSprint.get("sequence");
                        if (!(maxSprintSequence < (tempSprintSequence = ((Double)tempSprint.get("sequence")).doubleValue()))) continue;
                        maxSprint = tempSprint;
                    }
                    if (feature.get("Category").equals("Done")) {
                        this.putDataInArrayOfObject(response, "delivered", String.valueOf(maxSprint.get("containerId")), feature);
                    }
                    this.putDataInArrayOfObject(response, "planned", String.valueOf(maxSprint.get("containerId")), feature);
                    itemsState.put(String.valueOf(feature.get("id")), feature);
                }
            }
            LOGGER.debug("filterFeaturesForSprints_422");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private ArrayList<Object> sprintSequenceByBoard(HashMap<String, Object> sprintMap, SessionBoard activeSessionBoard) {
        ArrayList<Object> response = new ArrayList<Object>();
        try {
            ArrayList containerList = (ArrayList)activeSessionBoard.getContainers();
            if (PropertyValidator.isValid((Collection)containerList)) {
                for (Container container : containerList) {
                    if (sprintMap.get(String.valueOf(container.getId())) == null) continue;
                    response.add(sprintMap.get(String.valueOf(container.getId())));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private HashMap<String, Object> sprintStoriesCalculation(HashMap<String, Object> analyticsData, Container activeSprint, HashMap<String, Object> itemsState) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            response.put("spillOver", new HashMap());
            response.put("committedLoad", new HashMap());
            response.put("scopeChange", new HashMap());
            response.put("removed", new HashMap());
            response.put("totalStories", new HashMap());
            response.put("scopeAddedAfterSprintStart", new HashMap());
            response.put("objectivePlannedStories", new HashMap());
            response.put("objectiveDeliveredStories", new HashMap());
            LOGGER.debug("sprintStoriesCalculation_460");
            HashMap duplicate = new HashMap();
            this.spillOverCalculationForStories(analyticsData, response, activeSprint, itemsState, duplicate);
            this.committedLoadCalculationForStories(analyticsData, response, activeSprint, itemsState, duplicate);
            this.scopeChangeCalculationForStories(analyticsData, response, activeSprint, itemsState, duplicate);
            this.objectiveCalculationForStories(analyticsData, response, activeSprint, itemsState, duplicate);
            this.addNewStoriesInTotalStories(analyticsData, response, activeSprint, itemsState, duplicate);
            LOGGER.debug("sprintStoriesCalculation_468");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private void addNewStoriesInTotalStories(HashMap<String, Object> analyticsData, HashMap<String, Object> response, Container activeSprint, Map<String, Object> itemsState, Map<String, String> duplicate) {
        Map baseLineDataSpillOver = (Map)analyticsData.get("baseLineDataSpillOver");
        if (!PropertyValidator.isValid((Object)baseLineDataSpillOver) || !PropertyValidator.isValid((Object)activeSprint)) {
            return;
        }
        Set teamIds = baseLineDataSpillOver.keySet();
        if (!PropertyValidator.isValid(teamIds)) {
            return;
        }
        Map totalStories = (Map)response.get("totalStories");
        HashMap spillOverStoriesByContainerId = new HashMap();
        HashMap committedLoadStoriesAddedAfterSprintStart = new HashMap();
        for (String teamId : teamIds) {
            Map spillOverDataByContainerId = (Map)baseLineDataSpillOver.get(teamId);
            if (!PropertyValidator.isValid((Object)spillOverDataByContainerId)) continue;
            Set containerIds = spillOverDataByContainerId.keySet();
            for (String containerId : containerIds) {
                List spillOverData;
                if (!containerId.equals(activeSprint.getId()) || !PropertyValidator.isValid((Collection)(spillOverData = (List)spillOverDataByContainerId.get(containerId)))) continue;
                spillOverData.forEach(data -> {
                    String id = (String)data.get("id");
                    String key = this.getItemKey(data);
                    List<String> itemIds = PropertyValidator.isValid(spillOverStoriesByContainerId.get(containerId)) ? (List)spillOverStoriesByContainerId.get(containerId) : new ArrayList();
                    itemIds.add(id);
                    HashSet itemIdSet = new HashSet(itemIds);
                    spillOverStoriesByContainerId.put(containerId, new ArrayList(itemIdSet));
                    Map committedLoadStoriesData = (Map)itemsState.get("commitedLoadStoriesData");
                    if (PropertyValidator.isValid((Object)committedLoadStoriesData) && !committedLoadStoriesData.containsKey(id)) {
                        this.putDataInArrayOfObject(response, "scopeAddedAfterSprintStart", containerId, (HashMap)data);
                    }
                    committedLoadStoriesAddedAfterSprintStart.put(id, data);
                    if (!itemsState.containsKey(id)) {
                        this.putItemWithoutDuplicate(data, itemsState, duplicate);
                    }
                });
            }
        }
        if (spillOverStoriesByContainerId.size() > 0) {
            totalStories.putAll(spillOverStoriesByContainerId);
        }
        itemsState.put("committedLoadStoriesAddedAfterSprintStart", committedLoadStoriesAddedAfterSprintStart);
    }

    private void spillOverCalculationForStories(HashMap<String, Object> analyticsData, HashMap<String, Object> response, Container activeSprint, HashMap<String, Object> itemsState, Map<String, String> duplicate) {
        try {
            HashMap spillOverResponce = (HashMap)analyticsData.get("spillOverResponce");
            HashMap<String, HashMap> spillOverStoriesData = new HashMap<String, HashMap>();
            HashMap currentStateItemsMapByIds = (HashMap)analyticsData.get("currentStateProcessedItemsMapByIds");
            LOGGER.debug("spillOverCalculationForStories_486");
            if (PropertyValidator.isValid((Object)spillOverResponce) && PropertyValidator.isValid(spillOverResponce.get("spillOverDataBySprintIds"))) {
                LOGGER.debug("spillOverCalculationForStories_490");
                HashMap allSpillOverItems = (HashMap)spillOverResponce.get("spillOverItems");
                HashMap spillOverStories = (HashMap)allSpillOverItems.get("spillOverStories");
                HashMap spillOverDataBySprintIds = (HashMap)spillOverResponce.get("spillOverDataBySprintIds");
                if (PropertyValidator.isValid((Object)spillOverDataBySprintIds)) {
                    for (String sprintId : spillOverDataBySprintIds.keySet()) {
                        Set spillOverSprintItemsIds;
                        if (!activeSprint.getId().equals(sprintId) || !PropertyValidator.isValid((Collection)(spillOverSprintItemsIds = (Set)spillOverDataBySprintIds.get(sprintId)))) continue;
                        for (Object itemId : spillOverSprintItemsIds) {
                            if (!PropertyValidator.isValid(spillOverStories.get(itemId)) || !PropertyValidator.isValid(currentStateItemsMapByIds.get(itemId))) continue;
                            HashMap spillOverStory = (HashMap)spillOverStories.get(itemId);
                            this.putDataInArrayOfObject(response, "spillOver", String.valueOf(sprintId), spillOverStory);
                            spillOverStoriesData.put(String.valueOf(spillOverStory.get("id")), spillOverStory);
                            HashMap spillOverStoryUpdatedData = (HashMap)currentStateItemsMapByIds.get(itemId);
                            if (PropertyValidator.isValid((Object)itemsState.get(spillOverStory.get("id")))) continue;
                            if (PropertyValidator.isValid(spillOverStory.get("previousStateItemSprintData"))) {
                                spillOverStoryUpdatedData.put("previousStateItemSprintData", spillOverStory.get("previousStateItemSprintData"));
                            }
                            if (PropertyValidator.isValid(spillOverStory.get("previousStateItemTeamData"))) {
                                spillOverStoryUpdatedData.put("previousStateItemTeamData", spillOverStory.get("previousStateItemTeamData"));
                            }
                            if (PropertyValidator.isValid(spillOverStory.get("currentTeamBacklog"))) {
                                spillOverStoryUpdatedData.put("currentTeamBacklog", spillOverStory.get("currentTeamBacklog"));
                            }
                            if (PropertyValidator.isValid(spillOverStory.get("currentSprintBacklog"))) {
                                spillOverStoryUpdatedData.put("currentSprintBacklog", spillOverStory.get("currentSprintBacklog"));
                            }
                            if (PropertyValidator.isValid(spillOverStory.get("previousEstimate"))) {
                                spillOverStoryUpdatedData.put("previousEstimate", spillOverStory.get("previousEstimate"));
                            }
                            if (PropertyValidator.isValid(spillOverStory.get("previousEstimate"))) {
                                spillOverStoryUpdatedData.put("previousEstimate", spillOverStory.get("previousEstimate"));
                            }
                            this.putItemWithoutDuplicate((Map)spillOverStoryUpdatedData, itemsState, duplicate);
                        }
                    }
                }
            }
            itemsState.put("spillOverStoriesData", spillOverStoriesData);
            LOGGER.debug("spillOverCalculationForStories_530");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void committedLoadCalculationForStories(HashMap<String, Object> analyticsData, HashMap<String, Object> response, Container activeSprint, HashMap<String, Object> itemsState, Map<String, String> duplicate) {
        try {
            HashMap<String, HashMap> checkDuplicateItems = new HashMap<String, HashMap>();
            HashMap baseLineData = (HashMap)analyticsData.get("baseLineData");
            HashMap currentStateItemsMapByIds = (HashMap)analyticsData.get("currentStateProcessedItemsMapByIds");
            HashMap<String, HashMap> commitedLoadStoriesData = new HashMap<String, HashMap>();
            LOGGER.debug("committedLoadCalculationForStories_544");
            if (PropertyValidator.isValid((Object)baseLineData)) {
                LOGGER.debug("committedLoadCalculationForStories_549");
                for (String teamId : baseLineData.keySet()) {
                    HashMap teamCommittedloadData = (HashMap)baseLineData.get(teamId);
                    if (!PropertyValidator.isValid((Object)teamCommittedloadData)) continue;
                    for (String sprintId : teamCommittedloadData.keySet()) {
                        if (!activeSprint.getId().equals(sprintId)) continue;
                        ArrayList sprintCommittedloadData = (ArrayList)teamCommittedloadData.get(sprintId);
                        for (int i = 0; i < sprintCommittedloadData.size(); ++i) {
                            HashMap item = (HashMap)sprintCommittedloadData.get(i);
                            if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid(currentStateItemsMapByIds.get(item.get("id")))) continue;
                            HashMap processeditem = (HashMap)currentStateItemsMapByIds.get(item.get("id"));
                            if (PropertyValidator.isValid(checkDuplicateItems.get(item.get("id")))) continue;
                            checkDuplicateItems.put(String.valueOf(item.get("id")), processeditem);
                            this.putDataInArrayOfObject(response, "committedLoad", String.valueOf(sprintId), processeditem);
                            commitedLoadStoriesData.put(String.valueOf(item.get("id")), item);
                            if (PropertyValidator.isValid((Object)itemsState.get(item.get("id")))) continue;
                            this.putItemWithoutDuplicate((Map)processeditem, itemsState, duplicate);
                        }
                    }
                }
            }
            itemsState.put("commitedLoadStoriesData", commitedLoadStoriesData);
            LOGGER.debug("committedLoadCalculationForStories_581");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void scopeChangeCalculationForStories(HashMap<String, Object> analyticsData, HashMap<String, Object> response, Container activeSprint, HashMap<String, Object> itemsState, Map<String, String> duplicate) {
        try {
            HashMap previousStateItemMapById = (HashMap)analyticsData.get("previousStateItemMapById");
            HashMap currentStateItemsMapByIds = (HashMap)analyticsData.get("currentStateProcessedItemsMapByIds");
            HashMap<String, HashMap> checkDuplicateItems = new HashMap<String, HashMap>();
            Object activeSessionBoard = analyticsData.get("activeSessionBoard");
            LOGGER.debug("scopeChangeCalculationForStories_597");
            if (PropertyValidator.isValid((Object)currentStateItemsMapByIds)) {
                LOGGER.debug("scopeChangeCalculationForStories_600");
                for (String itemId : currentStateItemsMapByIds.keySet()) {
                    HashMap currentStateStory = (HashMap)currentStateItemsMapByIds.get(itemId);
                    if (!PropertyValidator.isValid((Object)currentStateStory) || !currentStateStory.get("type").equals("UserStory")) continue;
                    if (!PropertyValidator.isValid(currentStateStory.get("originItemId")) && PropertyValidator.isValid(previousStateItemMapById.get(currentStateStory.get("id"))) || PropertyValidator.isValid(currentStateStory.get("originItemId")) && PropertyValidator.isValid(previousStateItemMapById.get(currentStateStory.get("originItemId")))) {
                        HashMap previousStateStory = new HashMap();
                        if (!PropertyValidator.isValid(currentStateStory.get("originItemId")) && PropertyValidator.isValid(previousStateItemMapById.get(currentStateStory.get("id")))) {
                            previousStateStory = (HashMap)previousStateItemMapById.get(currentStateStory.get("id"));
                        }
                        if (PropertyValidator.isValid(currentStateStory.get("originItemId")) && PropertyValidator.isValid(previousStateItemMapById.get(currentStateStory.get("originItemId")))) {
                            previousStateStory = (HashMap)previousStateItemMapById.get(currentStateStory.get("originItemId"));
                        }
                        if (!PropertyValidator.isValid(previousStateStory) || activeSessionBoard.equals("Draft")) continue;
                        this.compareSprints(currentStateStory, previousStateStory, response, activeSprint, itemsState, duplicate, checkDuplicateItems);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)currentStateStory) || !PropertyValidator.isValid(currentStateStory.get("itemSprintData"))) continue;
                    HashMap currentStateStorySprint = (HashMap)currentStateStory.get("itemSprintData");
                    for (String sprintId : currentStateStorySprint.keySet()) {
                        if (!activeSprint.getId().equals(sprintId) || checkDuplicateItems.get(String.valueOf(currentStateStory.get("id"))) != null) continue;
                        this.putDataInArrayOfObject(response, "totalStories", String.valueOf(sprintId), currentStateStory);
                        if (!activeSessionBoard.equals("Draft")) {
                            this.putDataInArrayOfObject(response, "scopeChange", String.valueOf(sprintId), currentStateStory);
                        }
                        if (PropertyValidator.isValid((Object)itemsState.get(currentStateStory.get("id")))) {
                            HashMap lockedItem = (HashMap)itemsState.get(currentStateStory.get("id"));
                            if (PropertyValidator.isValid(lockedItem.get("previousStateItemSprintData"))) {
                                currentStateStory.put("previousStateItemSprintData", lockedItem.get("previousStateItemSprintData"));
                            }
                            if (PropertyValidator.isValid(lockedItem.get("previousStateItemTeamData"))) {
                                currentStateStory.put("previousStateItemTeamData", lockedItem.get("previousStateItemTeamData"));
                            }
                            if (PropertyValidator.isValid(lockedItem.get("currentTeamBacklog"))) {
                                currentStateStory.put("currentTeamBacklog", lockedItem.get("currentTeamBacklog"));
                            }
                            if (PropertyValidator.isValid(lockedItem.get("currentSprintBacklog"))) {
                                currentStateStory.put("currentSprintBacklog", lockedItem.get("currentSprintBacklog"));
                            }
                            if (PropertyValidator.isValid(lockedItem.get("previousEstimate"))) {
                                currentStateStory.put("previousEstimate", lockedItem.get("previousEstimate"));
                            }
                            if (PropertyValidator.isValid(lockedItem.get("previousEstimate"))) {
                                currentStateStory.put("previousEstimate", lockedItem.get("previousEstimate"));
                            }
                            this.putItemWithoutDuplicate((Map)currentStateStory, itemsState, duplicate);
                        } else {
                            this.putItemWithoutDuplicate((Map)currentStateStory, itemsState, duplicate);
                        }
                        checkDuplicateItems.put(String.valueOf(currentStateStory.get("id")), currentStateStory);
                    }
                }
            }
            LOGGER.debug("scopeChangeCalculationForStories_636");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void compareSprints(HashMap<String, Object> currentStateStory, HashMap<String, Object> previousStateStory, HashMap<String, Object> response, Container activeSprint, HashMap<String, Object> itemsState, Map<String, String> duplicate, HashMap<String, Object> checkDuplicateItems) {
        block8: {
            try {
                HashMap currentStateStorySprint = (HashMap)currentStateStory.get("itemSprintData");
                if (!PropertyValidator.isValid((Object)currentStateStorySprint)) break block8;
                for (String sprintId : currentStateStorySprint.keySet()) {
                    if (!activeSprint.getId().equals(sprintId)) continue;
                    HashMap currentStateSprint = (HashMap)currentStateStorySprint.get(sprintId);
                    if (!checkDuplicateItems.containsKey(String.valueOf(currentStateStory.get("id")))) {
                        checkDuplicateItems.put(String.valueOf(currentStateStory.get("id")), currentStateStory);
                        this.putDataInArrayOfObject(response, "totalStories", String.valueOf(sprintId), currentStateStory);
                    }
                    if (PropertyValidator.isValid(currentStateStory)) {
                        this.putItemWithoutDuplicate(currentStateStory, itemsState, duplicate);
                    }
                    if (PropertyValidator.isValid(previousStateStory) && PropertyValidator.isValid((Object)previousStateStory.get("itemSprintData"))) {
                        HashMap previousStateStorySprint = (HashMap)previousStateStory.get("itemSprintData");
                        if (!PropertyValidator.isValid((Object)previousStateStorySprint)) continue;
                        for (String previousSprintId : previousStateStorySprint.keySet()) {
                            HashMap previousStateSprint = (HashMap)previousStateStorySprint.get(previousSprintId);
                            String currentStateSprintId = (String)currentStateSprint.get("id");
                            if (currentStateSprintId == null) {
                                currentStateSprintId = (String)currentStateSprint.get("containerId");
                            }
                            if (PropertyValidator.isValid(previousStateSprint.get("sprintOriginItemId")) && PropertyValidator.isValid(currentStateSprint.get("sprintOriginItemId")) && currentStateSprint.get("sprintOriginItemId").equals(previousStateSprint.get("sprintOriginItemId")) || sprintId == previousSprintId || PropertyValidator.isValid(currentStateSprint.get("sprintOriginItemId")) && currentStateSprint.get("sprintOriginItemId").equals(previousSprintId) || !PropertyValidator.isValid(currentStateSprint.get("sprintOriginItemId")) && currentStateSprintId.equals(previousStateSprint.get("sprintOriginItemId"))) continue;
                            this.putDataInArrayOfObject(response, "scopeChange", String.valueOf(sprintId), currentStateStory);
                        }
                        continue;
                    }
                    this.putDataInArrayOfObject(response, "scopeChange", String.valueOf(sprintId), currentStateStory);
                }
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }
    }

    private void objectiveCalculationForTeamAndSprint(HashMap<String, Object> analyticsData, HashMap<String, Object> response) {
        try {
            SessionBoard sessionBoard = (SessionBoard)analyticsData.get("SessionBoard");
            LOGGER.debug("objectiveCalculationForTeamAndSprint_698");
            if (PropertyValidator.isValid((Object)sessionBoard.getObjectivesMap())) {
                LOGGER.debug("objectiveCalculationForTeamAndSprint_701");
                HashMap objectivesMap = sessionBoard.getObjectivesMap();
                HashMap allItems = (HashMap)analyticsData.get("currentStateProcessedItemsMapByIds");
                HashMap objectivesMapById = new HashMap();
                if (PropertyValidator.isValid((Object)objectivesMap)) {
                    LOGGER.debug("objectiveCalculationForTeamAndSprint_709");
                    for (String key : objectivesMap.keySet()) {
                        Objective objectives = (Objective)objectivesMap.get(key);
                        HashMap<String, Object> objectivesData = new HashMap<String, Object>();
                        objectivesData.put("title", objectives.getTitle());
                        objectivesData.put("teamId", objectives.getTeamId());
                        objectivesData.put("values", new ArrayList());
                        if (PropertyValidator.isValid((Collection)objectives.getValues())) {
                            for (ObjectiveValue objectiveValue : objectives.getValues()) {
                                HashMap<String, Object> objectiveValues = new HashMap<String, Object>();
                                HashMap<String, String> allLinkStories = new HashMap<String, String>();
                                HashMap<String, String> allLinkDoneStories = new HashMap<String, String>();
                                HashMap allLinkStoriesBySprint = new HashMap();
                                if (PropertyValidator.isValid((Collection)objectiveValue.getItemIds())) {
                                    if (PropertyValidator.isValid((Collection)sessionBoard.getContainers())) {
                                        for (Container container : sessionBoard.getContainers()) {
                                            allLinkStoriesBySprint.put(container.getId().toString(), new ArrayList());
                                        }
                                    }
                                    for (String itemId : objectiveValue.getItemIds()) {
                                        HashMap item = (HashMap)allItems.get(itemId);
                                        if (!PropertyValidator.isValid((Object)item) || !item.get("type").equals(Item.USER_STORY)) continue;
                                        String storySprintId = null;
                                        if (!PropertyValidator.isValid(item.get("itemSprintData"))) continue;
                                        HashMap storySprint = (HashMap)item.get("itemSprintData");
                                        Iterator iterator = storySprint.keySet().iterator();
                                        while (iterator.hasNext()) {
                                            String sprintId;
                                            storySprintId = sprintId = (String)iterator.next();
                                        }
                                        if (item.get("Category").equals("Done")) {
                                            allLinkDoneStories.put(item.get("id").toString(), item.get("id").toString());
                                        }
                                        allLinkStories.put(item.get("id").toString(), item.get("id").toString());
                                        if (!PropertyValidator.isValid((Object)storySprintId) || !PropertyValidator.isValid(allLinkStoriesBySprint.get(storySprintId))) continue;
                                        ArrayList tempSprintSrories = (ArrayList)allLinkStoriesBySprint.get(storySprintId);
                                        tempSprintSrories.add(item.get("id").toString());
                                    }
                                }
                                objectiveValues.put("id", objectiveValue.getId().toString());
                                objectiveValues.put("title", objectiveValue.getTitle());
                                objectiveValues.put("type", objectiveValue.getType());
                                objectiveValues.put("planValue", objectiveValue.getPlanValue());
                                objectiveValues.put("actualValue", objectiveValue.getActualValue());
                                objectiveValues.put("itemIds", objectiveValue.getItemIds());
                                objectiveValues.put("allLinkStories", allLinkStories);
                                objectiveValues.put("allLinkDoneStories", allLinkDoneStories);
                                objectiveValues.put("allLinkStoriesBySprint", allLinkStoriesBySprint);
                                ArrayList tempObjectiveValues = (ArrayList)objectivesData.get("values");
                                tempObjectiveValues.add(objectiveValues);
                            }
                        }
                        objectivesMapById.put(key, objectivesData);
                    }
                }
                LOGGER.debug("objectiveCalculationForTeamAndSprint_785");
                response.put("objectiveCalculationForTeamAndSprint", objectivesMapById);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void objectiveCalculationForStories(HashMap<String, Object> analyticsData, HashMap<String, Object> response, Container activeSprint, HashMap<String, Object> itemsState, Map<String, String> duplicate) {
        try {
            List objectiveGroupList;
            HashMap newObjective;
            HashMap<String, String> objectiveIdMap = new HashMap<String, String>();
            SessionBoard activeSessionBoard = (SessionBoard)analyticsData.get("SessionBoard");
            HashMap allItems = (HashMap)analyticsData.get("currentStateProcessedItemsMapByIds");
            LOGGER.debug("objectiveCalculationForStories_804");
            if (PropertyValidator.isValid((Object)activeSessionBoard.getObjectivesMap())) {
                HashMap objectivesMap = activeSessionBoard.getObjectivesMap();
                if (PropertyValidator.isValid((Object)objectivesMap)) {
                    LOGGER.debug("objectiveCalculationForStories_809");
                    for (Object key : objectivesMap.keySet()) {
                        Objective objective = (Objective)objectivesMap.get(key);
                        if (!PropertyValidator.isValid((Collection)objective.getValues())) continue;
                        for (ObjectiveValue objectiveValue : objective.getValues()) {
                            if (!PropertyValidator.isValid((Collection)objectiveValue.getItemIds())) continue;
                            for (String itemId : objectiveValue.getItemIds()) {
                                objectiveIdMap.put(String.valueOf(itemId), itemId);
                            }
                        }
                    }
                }
            } else if (!activeSessionBoard.getSession().getLoadOldObjectivesView().booleanValue()) {
                newObjective = this.objectiveService.loadObjectivesListBySessionId(String.valueOf(activeSessionBoard.getSession().getId()), null, activeSessionBoard.getId());
                if (PropertyValidator.isValid(newObjective.get("objectiveGroups"))) {
                    objectiveGroupList = (List)newObjective.get("objectiveGroups");
                    for (Objective objective : objectiveGroupList) {
                        if (!PropertyValidator.isValid((Collection)objective.getBaseItemList())) continue;
                        for (BaseItem subObjective : objective.getBaseItemList()) {
                            if (!PropertyValidator.isValid((Collection)subObjective.getBaseItemLinks())) continue;
                            for (Item item : subObjective.getLinkedItems()) {
                                objectiveIdMap.put(String.valueOf(item.getId()), item.getId());
                            }
                        }
                    }
                }
            } else if (!activeSessionBoard.getSession().getLoadOldObjectivesView().booleanValue() && PropertyValidator.isValid((newObjective = this.objectiveService.loadObjectivesListBySessionId(String.valueOf(activeSessionBoard.getSession().getId()), null, activeSessionBoard.getId())).get("objectiveGroups"))) {
                objectiveGroupList = (List)newObjective.get("objectiveGroups");
                for (Objective objective : objectiveGroupList) {
                    if (!PropertyValidator.isValid((Collection)objective.getBaseItemList())) continue;
                    for (BaseItem subObjective : objective.getBaseItemList()) {
                        if (!PropertyValidator.isValid((Collection)subObjective.getBaseItemLinks())) continue;
                        for (Item item : subObjective.getLinkedItems()) {
                            objectiveIdMap.put(String.valueOf(item.getId()), item.getId());
                        }
                    }
                }
            }
            LOGGER.debug("objectiveCalculationForStories_834");
            HashMap allSories = (HashMap)response.get("totalStories");
            ArrayList storiesInActiveSprint = (ArrayList)allSories.get(activeSprint.getId());
            HashMap<String, HashMap> chcekDuplicateStories = new HashMap<String, HashMap>();
            if (PropertyValidator.isValid((Collection)storiesInActiveSprint)) {
                LOGGER.debug("objectiveCalculationForStories_841");
                for (Object storyId : storiesInActiveSprint) {
                    HashMap story = (HashMap)allItems.get(storyId);
                    if (!PropertyValidator.isValid(objectiveIdMap.get(storyId)) && (!PropertyValidator.isValid(story.get("parent")) || !PropertyValidator.isValid(objectiveIdMap.get(story.get("parent")))) || !PropertyValidator.isValid((Object)story)) continue;
                    this.putDataInArrayOfObject(response, "objectivePlannedStories", String.valueOf(activeSprint.getId()), story);
                    if (!PropertyValidator.isValid((Object)itemsState.get(story.get("id")))) {
                        this.putItemWithoutDuplicate((Map)story, itemsState, duplicate);
                    }
                    chcekDuplicateStories.put(story.get("id").toString(), story);
                    if (!story.get("Category").equals("Done")) continue;
                    this.putDataInArrayOfObject(response, "objectiveDeliveredStories", String.valueOf(activeSprint.getId()), story);
                }
            }
            LOGGER.debug("objectiveCalculationForStories_866");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private Container findActiveSprintOfTheBoard(HashMap<String, Object> analyticsData) {
        Container activeSprint = null;
        try {
            LOGGER.debug("findActiveSprintOfTheBoard_876");
            SessionBoard activeSessionBoard = (SessionBoard)analyticsData.get("SessionBoard");
            if (PropertyValidator.isValid((Collection)activeSessionBoard.getContainers())) {
                List containers = activeSessionBoard.getContainers();
                LOGGER.debug("findActiveSprintOfTheBoard_882");
                Date currentDate = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(currentDate);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                currentDate = calendar.getTime();
                for (Container container : containers) {
                    if (activeSprint != null || container.getStartDate() == null || !currentDate.after(container.getStartDate()) && !currentDate.equals(container.getStartDate()) || container.getEndDate() == null || !currentDate.before(container.getEndDate()) && !currentDate.equals(container.getEndDate())) continue;
                    activeSprint = container;
                }
            }
            LOGGER.debug("findActiveSprintOfTheBoard_906");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return activeSprint;
    }

    private ArrayList<String> calculateRiskRelatedToCurrentBoard(SessionBoard activeSessionBoard, Container activeSprint, HashMap<String, Object> riskState) {
        ArrayList<String> response = new ArrayList<String>();
        try {
            RiskRegister riskRegister = activeSessionBoard.getSession().getRiskRegister();
            LOGGER.debug("calculateRiskRelatedToCurrentBoard_920");
            if (PropertyValidator.isValid((Object)riskRegister)) {
                List boardRisk = this.riskRepository.findAllByRiskRegisterId(String.valueOf(riskRegister.getId()));
                LOGGER.debug("calculateRiskRelatedToCurrentBoard_926");
                if (PropertyValidator.isValid((Collection)boardRisk)) {
                    for (Risk risk : boardRisk) {
                        String riskKey;
                        HashMap<String, Object> saveRiskState = new HashMap<String, Object>();
                        HashMap<String, String> riskStatus = new HashMap<String, String>();
                        if (PropertyValidator.isValid((Object)risk.getStatus()) && PropertyValidator.isValid((Object)risk.getStatus().getTitle())) {
                            riskStatus.put("title", risk.getStatus().getTitle());
                        }
                        if (PropertyValidator.isValid((Object)risk.getStatus()) && PropertyValidator.isValid((Object)risk.getStatus().getCategory())) {
                            riskStatus.put("category", risk.getStatus().getCategory());
                        }
                        if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Object)risk.getTfsAttributes().getTfsId())) {
                            riskKey = risk.getTfsAttributes().getTfsId();
                            saveRiskState.put("key", riskKey);
                        } else if (PropertyValidator.isValid((Object)riskRegister.getRegisterKey()) && PropertyValidator.isValid((Object)risk.getRiskNumber())) {
                            riskKey = riskRegister.getRegisterKey() + "-" + risk.getRiskNumber();
                            saveRiskState.put("key", riskKey);
                        }
                        if (PropertyValidator.isValid((Object)risk.getImpact()) && PropertyValidator.isValid((Object)risk.getImpact().getTitle())) {
                            saveRiskState.put("riskLevel", risk.getImpact().getTitle());
                        }
                        if (PropertyValidator.isValid((Object)risk.getId())) {
                            saveRiskState.put("id", risk.getId());
                        }
                        if (PropertyValidator.isValid((Object)risk.getRiskTitle())) {
                            saveRiskState.put("title", risk.getRiskTitle());
                        }
                        if (PropertyValidator.isValid((Object)risk.getRaisedDate())) {
                            saveRiskState.put("raisedDate", risk.getRaisedDate());
                        }
                        if (PropertyValidator.isValid((Object)risk.getResolutionDate())) {
                            saveRiskState.put("targetResolutionDate", risk.getResolutionDate());
                        }
                        if (PropertyValidator.isValid((Collection)risk.getBoardTeams())) {
                            saveRiskState.put("teams", risk.getBoardTeams());
                        }
                        if (PropertyValidator.isValid((Collection)risk.getBoardSprints())) {
                            saveRiskState.put("sprints", risk.getBoardSprints());
                        }
                        saveRiskState.put("status", riskStatus);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(activeSprint.getEndDate());
                        calendar.set(11, 23);
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        calendar.set(14, 999);
                        activeSprint.setEndDate(calendar.getTime());
                        calendar.setTime(activeSprint.getStartDate());
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        activeSprint.setStartDate(calendar.getTime());
                        if (activeSprint.getStartDate() != null && activeSprint.getEndDate() != null && risk.getResolutionDate() != null && activeSprint.getStartDate().getTime() <= risk.getResolutionDate().getTime() && activeSprint.getEndDate().getTime() >= risk.getResolutionDate().getTime()) {
                            response.add(String.valueOf(risk.getId()));
                            riskState.put(String.valueOf(risk.getId()), saveRiskState);
                            continue;
                        }
                        if (!PropertyValidator.isValid((Collection)risk.getBoardSprints())) continue;
                        for (BoardSprints riskSprint : risk.getBoardSprints()) {
                            if (!riskSprint.getSprintId().equals(String.valueOf(activeSprint.getId()))) continue;
                            response.add(String.valueOf(risk.getId()));
                            riskState.put(String.valueOf(risk.getId()), saveRiskState);
                        }
                    }
                }
            }
            LOGGER.debug("calculateRiskRelatedToCurrentBoard_986");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private List<DBObject> findContainerByIdOrOriginItemId(String sprintId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        Criteria criteria = new Criteria();
        String spId = null;
        try {
            spId = new ObjectId(sprintId);
        }
        catch (Exception e) {
            spId = sprintId;
        }
        criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)spId), Criteria.where((String)"originItemId").is((Object)sprintId)});
        query.addCriteria((CriteriaDefinition)criteria);
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("container").find(query.getQueryObject());
        List rawSprints = dbCursorPrefix.toArray();
        return rawSprints;
    }

    private Container findTheLatestStateOfOldSprint(String sprintId, SessionBoard activeSessionBoard) {
        try {
            List rawSprints;
            Container container = (Container)this.containerRepository.findOne((Serializable)((Object)sprintId));
            String sprintIdOrOriginItemId = container.getId();
            if (PropertyValidator.isValid((Object)container.getOriginItemId())) {
                sprintIdOrOriginItemId = container.getOriginItemId();
            }
            if (PropertyValidator.isValid((Collection)(rawSprints = this.findContainerByIdOrOriginItemId(sprintIdOrOriginItemId))) && PropertyValidator.isValid((Collection)activeSessionBoard.getContainers())) {
                HashMap<String, Container> activeStateSprints = new HashMap<String, Container>();
                for (Container sprint : activeSessionBoard.getContainers()) {
                    activeStateSprints.put(sprint.getId().toString(), sprint);
                }
                for (DBObject rawSprint : rawSprints) {
                    if (!PropertyValidator.isValid(activeStateSprints.get(String.valueOf(rawSprint.get("_id"))))) continue;
                    container = (Container)activeStateSprints.get(String.valueOf(rawSprint.get("_id")));
                    break;
                }
            }
            return container;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private HashMap<String, Object> calculateImpedimentsLinkedToSprint(SessionBoard activeSessionBoard, Container activeSprint, HashMap<String, Object> itemsState) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            LOGGER.debug("calculateImpedimentsLinkedToSprint_1000");
            HashMap<String, String> checkDuplicate = new HashMap<String, String>();
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            ArrayList<String> ImpedimentStringArray = new ArrayList<String>();
            ImpedimentStringArray.add("Impediment");
            requestBody.put("sessionId", String.valueOf(activeSessionBoard.getSession().getId()));
            requestBody.put("getType", "All");
            requestBody.put("types", ImpedimentStringArray);
            ResponseEntity ImpedimentsResponce = this.externalEntitiesController.getDynamicItemByType(requestBody);
            HashMap Impediments = (HashMap)ImpedimentsResponce.getBody();
            List baseItemList = (List)Impediments.get("items");
            ArrayList<String> doneImpediment = new ArrayList<String>();
            ArrayList<String> totalImpediment = new ArrayList<String>();
            if (PropertyValidator.isValid((Collection)baseItemList)) {
                LOGGER.debug("calculateImpedimentsLinkedToSprint_1019");
                for (BaseItem baseItem : baseItemList) {
                    if (!PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks()) || PropertyValidator.isValid(checkDuplicate.get(String.valueOf(baseItem.getId())))) continue;
                    for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                        Container container;
                        if (!PropertyValidator.isValid((Object)baseItemLink.getSprintId()) || !PropertyValidator.isValid((Object)(container = this.findTheLatestStateOfOldSprint(baseItemLink.getSprintId(), activeSessionBoard)).getId()) || !container.getId().equals(String.valueOf(activeSprint.getId())) || PropertyValidator.isValid(checkDuplicate.get(String.valueOf(baseItem.getId())))) continue;
                        HashMap<String, Object> ImpedimentData = new HashMap<String, Object>();
                        HashMap<String, String> impedimentStatus = new HashMap<String, String>();
                        impedimentStatus.put("title", baseItem.getStatus().getTitle());
                        impedimentStatus.put("category", baseItem.getStatus().getCategory());
                        ArrayList baseItemLinksData = new ArrayList();
                        for (BaseItemLink linkItem : baseItem.getBaseItemLinks()) {
                            HashMap<String, Object> linksItemsData = new HashMap<String, Object>();
                            String sprintId = linkItem.getSprintId();
                            if (PropertyValidator.isValid((Object)linkItem.getSprintId())) {
                                Container linkContainer = this.findTheLatestStateOfOldSprint(linkItem.getSprintId(), activeSessionBoard);
                                sprintId = linkContainer.getId();
                            }
                            linksItemsData.put("id", linkItem.getId());
                            linksItemsData.put("sessionId", linkItem.getSessionId());
                            linksItemsData.put("scrumOfScrumId", linkItem.getScrumOfScrumId());
                            linksItemsData.put("sprintId", sprintId);
                            linksItemsData.put("teamId", linkItem.getTeamId());
                            linksItemsData.put("sequence", linkItem.getSequence());
                            linksItemsData.put("isSystemLink", linkItem.getIsSystemLink());
                            baseItemLinksData.add(linksItemsData);
                        }
                        ImpedimentData.put("baseItemLinks", baseItemLinksData);
                        ImpedimentData.put("createdBy", baseItem.getCreatedBy());
                        ImpedimentData.put("createdOn", baseItem.getCreatedOn());
                        ImpedimentData.put("id", baseItem.getId());
                        ImpedimentData.put("key", baseItem.getKey());
                        ImpedimentData.put("notifyWatchers", baseItem.getNotifyWatchers());
                        ImpedimentData.put("rowStatus", baseItem.getRowStatus());
                        ImpedimentData.put("sequence", baseItem.getSequence());
                        ImpedimentData.put("source", baseItem.getSource());
                        ImpedimentData.put("starred", baseItem.getStarred());
                        ImpedimentData.put("status", impedimentStatus);
                        ImpedimentData.put("title", baseItem.getTitle());
                        ImpedimentData.put("type", baseItem.getType());
                        ImpedimentData.put("updatedBy", baseItem.getUpdatedBy());
                        ImpedimentData.put("updatedOn", baseItem.getUpdatedOn());
                        if (baseItem.getStatus().equals((Object)"Done")) {
                            doneImpediment.add(String.valueOf(baseItem.getId()));
                        }
                        totalImpediment.add(String.valueOf(baseItem.getId()));
                        itemsState.put(String.valueOf(baseItem.getId()), ImpedimentData);
                        checkDuplicate.put(String.valueOf(baseItem.getId()), baseItem.getId());
                    }
                }
            }
            LOGGER.debug("calculateImpedimentsLinkedToSprint_1084");
            response.put("doneImpediment", doneImpediment);
            response.put("totalImpediment", totalImpediment);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return response;
    }

    private HashMap<String, Object> calculateSprintDependencies(HashMap<String, Object> analyticsData, Container activeSprint, HashMap<String, Object> itemsState) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Container targetContainer;
            Container sorceContainer;
            HashMap singleDependency;
            int i;
            ArrayList dependencies;
            HashMap sprintDependencies = (HashMap)analyticsData.get("sprintDependencies");
            HashMap sprintCreaterDependencies = (HashMap)sprintDependencies.get("currentLinksBySprintCreater");
            HashMap sprintReceivedDependencies = (HashMap)sprintDependencies.get("currentLinksBySprintReceived");
            ArrayList<String> sprintSelfDependecies = new ArrayList<String>();
            ArrayList<String> sprintInwordsDependencies = new ArrayList<String>();
            ArrayList<String> sprintOutwardsDependencies = new ArrayList<String>();
            HashMap checkDuplicateDependencies = new HashMap();
            LOGGER.debug("calculateSprintDependencies_1109");
            if (PropertyValidator.isValid((Object)sprintCreaterDependencies)) {
                LOGGER.debug("calculateSprintDependencies_1113");
                dependencies = (ArrayList)sprintCreaterDependencies.get(String.valueOf(activeSprint.getId()));
                if (PropertyValidator.isValid((Collection)dependencies)) {
                    for (i = 0; i < dependencies.size(); ++i) {
                        singleDependency = (HashMap)dependencies.get(i);
                        sorceContainer = (Container)singleDependency.get("sourceSprint");
                        targetContainer = (Container)singleDependency.get("targetSprint");
                        if (PropertyValidator.isValid((Object)sorceContainer) && PropertyValidator.isValid((Object)targetContainer) && sorceContainer.getId().equals(targetContainer.getId()) && !PropertyValidator.isValid(checkDuplicateDependencies.get(String.valueOf(singleDependency.get("id"))))) {
                            sprintSelfDependecies.add(String.valueOf(singleDependency.get("id")));
                            checkDuplicateDependencies.put(String.valueOf(singleDependency.get("id")), singleDependency.get("id"));
                            itemsState.put(String.valueOf(singleDependency.get("id")), singleDependency);
                            continue;
                        }
                        if (PropertyValidator.isValid(checkDuplicateDependencies.get(String.valueOf(singleDependency.get("id"))))) continue;
                        checkDuplicateDependencies.put(String.valueOf(singleDependency.get("id")), singleDependency.get("id"));
                        sprintOutwardsDependencies.add(String.valueOf(singleDependency.get("id")));
                        itemsState.put(String.valueOf(singleDependency.get("id")), singleDependency);
                    }
                }
            }
            LOGGER.debug("calculateSprintDependencies_1139");
            if (PropertyValidator.isValid((Object)sprintReceivedDependencies) && PropertyValidator.isValid((Collection)(dependencies = (ArrayList)sprintReceivedDependencies.get(String.valueOf(activeSprint.getId()))))) {
                for (i = 0; i < dependencies.size(); ++i) {
                    singleDependency = (HashMap)dependencies.get(i);
                    sorceContainer = (Container)singleDependency.get("sourceSprint");
                    targetContainer = (Container)singleDependency.get("targetSprint");
                    if (PropertyValidator.isValid((Object)sorceContainer) && PropertyValidator.isValid((Object)targetContainer) && sorceContainer.getId().equals(targetContainer.getId()) && !PropertyValidator.isValid(checkDuplicateDependencies.get(String.valueOf(singleDependency.get("id"))))) {
                        sprintSelfDependecies.add(String.valueOf(singleDependency.get("id")));
                        checkDuplicateDependencies.put(String.valueOf(singleDependency.get("id")), singleDependency.get("id"));
                        itemsState.put(String.valueOf(singleDependency.get("id")), singleDependency);
                        continue;
                    }
                    if (PropertyValidator.isValid(checkDuplicateDependencies.get(String.valueOf(singleDependency.get("id"))))) continue;
                    sprintInwordsDependencies.add(String.valueOf(singleDependency.get("id")));
                    itemsState.put(String.valueOf(singleDependency.get("id")), singleDependency);
                }
            }
            LOGGER.debug("calculateSprintDependencies_1167");
            response.put("sprintSelfDependecies", sprintSelfDependecies);
            response.put("sprintInwordsDependencies", sprintInwordsDependencies);
            response.put("sprintOutwardsDependencies", sprintOutwardsDependencies);
            return response;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return response;
        }
    }

    public void sprintReportHandleStateChange(String sessionId, SessionBoard oldSessionBoard, SessionBoard newSessionBoard, Map<String, String> itemIdsMapOldToNew) throws Exception {
        List allSprintReports;
        ArrayList<String> oldSprintIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)oldSessionBoard.getContainers())) {
            for (Container con : oldSessionBoard.getContainers()) {
                oldSprintIds.add(con.getId());
            }
        }
        if (PropertyValidator.isValid((Collection)(allSprintReports = this.auditLogRepository.findBySessionBoardIdAndSprintIdIn(oldSessionBoard.getId(), oldSprintIds)))) {
            ArrayList<AuditLog> reportsToSave = new ArrayList<AuditLog>();
            for (AuditLog report : allSprintReports) {
                if (!report.getResolvedInStateChanged().booleanValue() && itemIdsMapOldToNew.containsKey(report.getSprintId())) {
                    Map teamSprintVelocity;
                    Object totalStories;
                    Object committedLoad;
                    Map sprintStoriesDelivery;
                    ArrayList<String> newItemIds;
                    Map sprintFeatureDelivery = (Map)report.getAuditMeta().get("sprintFeatureDelivery");
                    if (PropertyValidator.isValid((Object)sprintFeatureDelivery)) {
                        Map planned;
                        HashMap newSprintFeatureDelivery = new HashMap();
                        Map delivered = (Map)sprintFeatureDelivery.get("delivered");
                        if (PropertyValidator.isValid((Object)delivered)) {
                            HashMap newDelivered = new HashMap();
                            for (String string : oldSprintIds) {
                                List itemIds2 = (List)delivered.get(string);
                                if (!PropertyValidator.isValid((Collection)itemIds2)) continue;
                                ArrayList<String> arrayList = new ArrayList<String>();
                                newDelivered.put(itemIdsMapOldToNew.get(string), arrayList);
                                for (String string2 : itemIds2) {
                                    if (!itemIdsMapOldToNew.containsKey(string2)) continue;
                                    arrayList.add(itemIdsMapOldToNew.get(string2));
                                }
                            }
                            newSprintFeatureDelivery.put("delivered", newDelivered);
                        }
                        if (PropertyValidator.isValid((Object)(planned = (Map)sprintFeatureDelivery.get("planned")))) {
                            HashMap newPlanned = new HashMap();
                            for (String sprintId2 : oldSprintIds) {
                                List list = (List)planned.get(sprintId2);
                                if (!PropertyValidator.isValid((Collection)list)) continue;
                                newItemIds = new ArrayList<String>();
                                newPlanned.put(itemIdsMapOldToNew.get(sprintId2), newItemIds);
                                for (Object itemId : list) {
                                    if (!itemIdsMapOldToNew.containsKey(itemId)) continue;
                                    newItemIds.add(itemIdsMapOldToNew.get(itemId));
                                }
                            }
                            newSprintFeatureDelivery.put("planned", newPlanned);
                        }
                        if (!newSprintFeatureDelivery.isEmpty()) {
                            report.getAuditMeta().put("sprintFeatureDelivery", newSprintFeatureDelivery);
                        }
                    }
                    if (PropertyValidator.isValid((Object)(sprintStoriesDelivery = (Map)report.getAuditMeta().get("sprintStoriesDelivery")))) {
                        Map map;
                        Map map2;
                        Map scopeAddedAfterSprintStart;
                        Map map3;
                        HashMap newSprintStoriesDelivery = new HashMap();
                        Map scopeChange = (Map)sprintStoriesDelivery.get("scopeChange");
                        if (PropertyValidator.isValid((Object)scopeChange)) {
                            HashMap newscopeChange = new HashMap();
                            for (Object sprintId : oldSprintIds) {
                                List list = (List)scopeChange.get(sprintId);
                                if (!PropertyValidator.isValid((Collection)list)) continue;
                                newItemIds = new ArrayList();
                                newscopeChange.put(itemIdsMapOldToNew.get(sprintId), newItemIds);
                                for (Object itemId : list) {
                                    if (!itemIdsMapOldToNew.containsKey(itemId)) continue;
                                    newItemIds.add(itemIdsMapOldToNew.get(itemId));
                                }
                            }
                            newSprintStoriesDelivery.put("scopeChange", newscopeChange);
                        }
                        if (PropertyValidator.isValid((Object)(committedLoad = (Map)sprintStoriesDelivery.get("committedLoad")))) {
                            Object sprintId;
                            HashMap hashMap = new HashMap();
                            sprintId = oldSprintIds.iterator();
                            while (sprintId.hasNext()) {
                                Object itemId;
                                String string = (String)sprintId.next();
                                List itemIds3 = (List)committedLoad.get(string);
                                if (!PropertyValidator.isValid((Collection)itemIds3)) continue;
                                ArrayList<String> arrayList = new ArrayList<String>();
                                hashMap.put(itemIdsMapOldToNew.get(string), arrayList);
                                itemId = itemIds3.iterator();
                                while (itemId.hasNext()) {
                                    String itemId3 = (String)itemId.next();
                                    if (!itemIdsMapOldToNew.containsKey(itemId3)) continue;
                                    arrayList.add(itemIdsMapOldToNew.get(itemId3));
                                }
                            }
                            newSprintStoriesDelivery.put("committedLoad", hashMap);
                        }
                        if (PropertyValidator.isValid((Object)(map3 = (Map)sprintStoriesDelivery.get("spillOver")))) {
                            HashMap newspillOver = new HashMap();
                            for (Object sprintId5 : oldSprintIds) {
                                List list = (List)map3.get(sprintId5);
                                if (!PropertyValidator.isValid((Collection)list)) continue;
                                ArrayList<String> newItemIds4 = new ArrayList<String>();
                                newspillOver.put(itemIdsMapOldToNew.get(sprintId5), newItemIds4);
                                for (Object itemId4 : list) {
                                    if (!itemIdsMapOldToNew.containsKey(itemId4)) continue;
                                    newItemIds4.add(itemIdsMapOldToNew.get(itemId4));
                                }
                            }
                            newSprintStoriesDelivery.put("spillOver", newspillOver);
                        }
                        if (PropertyValidator.isValid((Object)(scopeAddedAfterSprintStart = (Map)sprintStoriesDelivery.get("scopeAddedAfterSprintStart")))) {
                            Object sprintId5;
                            HashMap hashMap = new HashMap();
                            sprintId5 = oldSprintIds.iterator();
                            while (sprintId5.hasNext()) {
                                Object itemId4;
                                String string = (String)sprintId5.next();
                                List itemIds5 = (List)scopeAddedAfterSprintStart.get(string);
                                if (!PropertyValidator.isValid((Collection)itemIds5)) continue;
                                ArrayList<String> newItemIds5 = new ArrayList<String>();
                                hashMap.put(itemIdsMapOldToNew.get(string), newItemIds5);
                                itemId4 = itemIds5.iterator();
                                while (itemId4.hasNext()) {
                                    String itemId5 = (String)itemId4.next();
                                    if (!itemIdsMapOldToNew.containsKey(itemId5)) continue;
                                    newItemIds5.add(itemIdsMapOldToNew.get(itemId5));
                                }
                            }
                            newSprintStoriesDelivery.put("scopeAddedAfterSprintStart", hashMap);
                        }
                        if (PropertyValidator.isValid((Object)(map2 = (Map)sprintStoriesDelivery.get("objectivePlannedStories")))) {
                            HashMap newobjectivePlannedStories = new HashMap();
                            for (Object sprintId7 : oldSprintIds) {
                                List itemIds6 = (List)map2.get(sprintId7);
                                if (!PropertyValidator.isValid((Collection)itemIds6)) continue;
                                ArrayList<String> newItemIds6 = new ArrayList<String>();
                                newobjectivePlannedStories.put(itemIdsMapOldToNew.get(sprintId7), newItemIds6);
                                for (Object itemId6 : itemIds6) {
                                    if (!itemIdsMapOldToNew.containsKey(itemId6)) continue;
                                    newItemIds6.add(itemIdsMapOldToNew.get(itemId6));
                                }
                            }
                            newSprintStoriesDelivery.put("objectivePlannedStories", newobjectivePlannedStories);
                        }
                        if (PropertyValidator.isValid((Object)(totalStories = (Map)sprintStoriesDelivery.get("totalStories")))) {
                            Object sprintId7;
                            HashMap hashMap = new HashMap();
                            sprintId7 = oldSprintIds.iterator();
                            while (sprintId7.hasNext()) {
                                Object itemId6;
                                String sprintId8 = (String)sprintId7.next();
                                List itemIds7 = (List)totalStories.get(sprintId8);
                                if (!PropertyValidator.isValid((Collection)itemIds7)) continue;
                                ArrayList<String> newItemIds7 = new ArrayList<String>();
                                hashMap.put(itemIdsMapOldToNew.get(sprintId8), newItemIds7);
                                itemId6 = itemIds7.iterator();
                                while (itemId6.hasNext()) {
                                    String itemId7 = (String)itemId6.next();
                                    if (!itemIdsMapOldToNew.containsKey(itemId7)) continue;
                                    newItemIds7.add(itemIdsMapOldToNew.get(itemId7));
                                }
                            }
                            newSprintStoriesDelivery.put("totalStories", hashMap);
                        }
                        if (PropertyValidator.isValid((Object)(map = (Map)sprintStoriesDelivery.get("objectiveDeliveredStories")))) {
                            HashMap newobjectiveDeliveredStories = new HashMap();
                            for (String sprintId9 : oldSprintIds) {
                                List itemIds8 = (List)map.get(sprintId9);
                                if (!PropertyValidator.isValid((Collection)itemIds8)) continue;
                                ArrayList<String> newItemIds8 = new ArrayList<String>();
                                newobjectiveDeliveredStories.put(itemIdsMapOldToNew.get(sprintId9), newItemIds8);
                                for (String itemId8 : itemIds8) {
                                    if (!itemIdsMapOldToNew.containsKey(itemId8)) continue;
                                    newItemIds8.add(itemIdsMapOldToNew.get(itemId8));
                                }
                            }
                            newSprintStoriesDelivery.put("objectiveDeliveredStories", newobjectiveDeliveredStories);
                        }
                        if (!newSprintStoriesDelivery.isEmpty()) {
                            report.getAuditMeta().put("sprintStoriesDelivery", newSprintStoriesDelivery);
                        }
                    }
                    if (PropertyValidator.isValid((Object)(teamSprintVelocity = (Map)report.getAuditMeta().get("teamSprintVelocity")))) {
                        HashMap newteamSprintVelocity = new HashMap();
                        committedLoad = teamSprintVelocity.keySet().iterator();
                        while (committedLoad.hasNext()) {
                            String string = (String)committedLoad.next();
                            Map teamData = (Map)teamSprintVelocity.get(string);
                            HashMap<String, Map> hashMap = new HashMap<String, Map>();
                            newteamSprintVelocity.put(string, hashMap);
                            totalStories = teamData.keySet().iterator();
                            while (totalStories.hasNext()) {
                                String string3 = (String)totalStories.next();
                                Map sprintData = (Map)teamData.get(string3);
                                hashMap.put(itemIdsMapOldToNew.get(string3), sprintData);
                            }
                        }
                        if (!newteamSprintVelocity.isEmpty()) {
                            report.getAuditMeta().put("teamSprintVelocity", newteamSprintVelocity);
                        }
                    }
                    if (PropertyValidator.isValid((Object)report.getAuditMeta())) {
                        report.getAuditMeta().put("sprintId", itemIdsMapOldToNew.get(report.getSprintId()));
                    }
                    report.setResolvedInStateChanged(Boolean.TRUE);
                    report.setSprintId(itemIdsMapOldToNew.get(report.getSprintId()));
                    if (PropertyValidator.isValid((Object)report.getAuditData())) {
                        GsonBuilder gsonBuilderWithCriteria = new GsonBuilder();
                        gsonBuilderWithCriteria.registerTypeAdapter(Double.class, (Object)new DoubleTypeAdapter());
                        gsonBuilderWithCriteria.registerTypeAdapter(Float.class, (Object)new FloatTypeAdapter());
                        Gson gson = gsonBuilderWithCriteria.create();
                        Map map = (Map)gson.fromJson(report.getAuditData(), Map.class);
                        if (PropertyValidator.isValid((Object)map)) {
                            HashMap<String, Map> newAuditDataMap = new HashMap<String, Map>();
                            for (String key : map.keySet()) {
                                Map item;
                                if (key.equals("commitedLoadStoriesData")) {
                                    Map map4 = (Map)map.get("commitedLoadStoriesData");
                                    HashMap<String, Map> newcommitedLoadStoriesData = new HashMap<String, Map>();
                                    for (String itemKey : map4.keySet()) {
                                        item = (Map)map4.get(itemKey);
                                        item = this.correctItemForStateChange(item, itemIdsMapOldToNew);
                                        newcommitedLoadStoriesData.put(itemIdsMapOldToNew.get(itemKey), item);
                                    }
                                    newAuditDataMap.put("commitedLoadStoriesData", newcommitedLoadStoriesData);
                                    continue;
                                }
                                if (key.equals("committedLoadStoriesAddedAfterSprintStart")) {
                                    Map map5 = (Map)map.get("committedLoadStoriesAddedAfterSprintStart");
                                    HashMap<String, Map> newcommittedLoadStoriesAddedAfterSprintStart = new HashMap<String, Map>();
                                    for (String itemKey : map5.keySet()) {
                                        item = (Map)map5.get(itemKey);
                                        item = this.correctItemForStateChange(item, itemIdsMapOldToNew);
                                        newcommittedLoadStoriesAddedAfterSprintStart.put(itemIdsMapOldToNew.get(itemKey), item);
                                    }
                                    newAuditDataMap.put("committedLoadStoriesAddedAfterSprintStart", newcommittedLoadStoriesAddedAfterSprintStart);
                                    continue;
                                }
                                if (key.equals("spillOverStoriesData")) {
                                    Map map6 = (Map)map.get("spillOverStoriesData");
                                    HashMap<String, Map> newspillOverStoriesData = new HashMap<String, Map>();
                                    for (String itemKey : map6.keySet()) {
                                        item = (Map)map6.get(itemKey);
                                        item = this.correctItemForStateChange(item, itemIdsMapOldToNew);
                                        newspillOverStoriesData.put(itemIdsMapOldToNew.get(itemKey), item);
                                    }
                                    newAuditDataMap.put("spillOverStoriesData", newspillOverStoriesData);
                                    continue;
                                }
                                Map map7 = (Map)map.get(key);
                                String type = (String)map7.get("type");
                                if (type != null && (type.equals("UserStory") || type.equals("Feature"))) {
                                    Map map8 = this.correctItemForStateChange(map7, itemIdsMapOldToNew);
                                    newAuditDataMap.put(itemIdsMapOldToNew.get(key), map8);
                                    continue;
                                }
                                newAuditDataMap.put(key, map7);
                            }
                            String string = gson.toJson(newAuditDataMap);
                            report.setAuditData(string);
                        }
                    }
                    reportsToSave.add(report);
                }
                if (!PropertyValidator.isValid(reportsToSave)) continue;
                this.auditLogRepository.save(reportsToSave);
            }
        }
    }

    private Map<String, Object> correctItemForStateChange(Map<String, Object> item, Map<String, String> itemIdsMapOldToNew) {
        if (item.containsKey("parent") && itemIdsMapOldToNew.containsKey(item.get("parent"))) {
            String parentId = (String)item.get("parent");
            item.put("parent", itemIdsMapOldToNew.get(parentId));
        }
        if (item.containsKey("itemSprintData")) {
            Map itemSprintData = (Map)item.get("itemSprintData");
            HashMap<String, Map> newitemSprintData = new HashMap<String, Map>();
            for (String spId : itemSprintData.keySet()) {
                Map _itemSprintData = (Map)itemSprintData.get(spId);
                String containerId = (String)_itemSprintData.get("containerId");
                if (!itemIdsMapOldToNew.containsKey(containerId)) continue;
                _itemSprintData.put("containerId", itemIdsMapOldToNew.get(containerId));
                newitemSprintData.put(itemIdsMapOldToNew.get(containerId), _itemSprintData);
            }
            if (!newitemSprintData.isEmpty()) {
                item.put("itemSprintData", newitemSprintData);
            }
        }
        if (item.containsKey("itemTeamData")) {
            Map itemTeamData = (Map)item.get("itemTeamData");
            for (String teamId : itemTeamData.keySet()) {
                Map _itemTeamData = (Map)itemTeamData.get(teamId);
                if (!_itemTeamData.containsKey("featureSprintOfTheTeam")) continue;
                Map featureSprintOfTheTeam = (Map)_itemTeamData.get("featureSprintOfTheTeam");
                HashMap<String, String> newfeatureSprintOfTheTeam = new HashMap<String, String>();
                for (String spId : featureSprintOfTheTeam.keySet()) {
                    if (!itemIdsMapOldToNew.containsKey(spId)) continue;
                    newfeatureSprintOfTheTeam.put(itemIdsMapOldToNew.get(spId), spId);
                }
                if (newfeatureSprintOfTheTeam.isEmpty()) continue;
                _itemTeamData.put("featureSprintOfTheTeam", newfeatureSprintOfTheTeam);
            }
        }
        return item;
    }
}

