/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SolutionArea;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.SolutionAreaRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.SolutionAreaService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="solutionAreaService")
@Transactional
class SolutionAreaServiceImpl
implements SolutionAreaService {
    @Autowired
    private CustomRepositoryImpl customRepository;
    @Autowired
    private SolutionAreaRepository solutionAreaRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionAreaService.class);

    SolutionAreaServiceImpl() {
    }

    public HashMap<String, Object> getSolutionAreasAndCollections(HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query query1 = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        List solutionAreas = this.mongoTemplate.find(query1, SolutionArea.class);
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        ArrayList<SolutionArea> allowedSolutionAreas = new ArrayList<SolutionArea>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
        List releaseTrains = this.mongoTemplate.find(query, WorkSpace.class);
        HashSet almAccountList = new HashSet();
        ArrayList<WorkSpace> allowedWorkspaces = new ArrayList<WorkSpace>();
        if (user.getIsAdmin().booleanValue()) {
            allowedSolutionAreas.addAll(solutionAreas);
            allowedWorkspaces.addAll(releaseTrains);
        } else {
            Query query2 = new Query();
            Criteria crt = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group").in((Collection)user.getGroups())});
            query2.addCriteria((CriteriaDefinition)crt);
            List workSpaceAccessRoles = this.mongoTemplate.find(query2, WorkSpaceAccessRole.class);
            HashMap<String, Boolean> accessRollMap = new HashMap<String, Boolean>();
            HashMap<String, WorkSpace> validWorkspaceMap = new HashMap<String, WorkSpace>();
            for (WorkSpaceAccessRole role : workSpaceAccessRoles) {
                WorkSpace workspace = role.getWorkSpace();
                if (!PropertyValidator.isValid((Object)workspace)) continue;
                accessRollMap.put(workspace.getId(), true);
            }
            for (WorkSpace rt : releaseTrains) {
                if (accessRollMap.get(rt.getId()) == null) continue;
                allowedWorkspaces.add(rt);
                validWorkspaceMap.put(rt.getId(), rt);
            }
            for (SolutionArea sa : solutionAreas) {
                boolean validSolArea = false;
                if (PropertyValidator.isValid((Object)sa.getOwnerCollection()) && PropertyValidator.isValid((Object)sa.getOwnerCollection().getId()) && !sa.getOwnerCollection().getId().equals("-1") && validWorkspaceMap.containsKey(sa.getOwnerCollection().getId())) {
                    validSolArea = true;
                }
                if (PropertyValidator.isValid((Collection)sa.getLinkedCollections())) {
                    for (String collectionId : sa.getLinkedCollections()) {
                        if (!validWorkspaceMap.containsKey(collectionId)) continue;
                        validSolArea = true;
                    }
                }
                if (!validSolArea) continue;
                allowedSolutionAreas.add(sa);
            }
        }
        for (WorkSpace workspace : allowedWorkspaces) {
            if (PropertyValidator.isValid((Collection)workspace.getLinkedAlmAccounts())) {
                ArrayList linkedAccountList = new ArrayList();
                workspace.getLinkedAlmAccounts().stream().forEach(almAccount -> {
                    almAccountList.add(almAccount);
                    AlmAccount alm = new AlmAccount(almAccount.getId(), almAccount.getType(), almAccount.getName());
                    linkedAccountList.add(alm);
                });
                workspace.setLinkedAlmAccounts(linkedAccountList);
            }
            if (!PropertyValidator.isValid((Collection)workspace.getAlmFilters())) continue;
            workspace.getAlmFilters().stream().forEach(filter -> filter.setAlmAccount(new AlmAccount(filter.getAlmAccount().getId())));
        }
        response.put("solutionAreas", allowedSolutionAreas);
        response.put("workspaces", allowedWorkspaces);
        return response;
    }

    public HashMap<String, Object> getSolutionForCollection(String collectionId) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query query1 = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"ownerCollection.$id").is((Object)new ObjectId(collectionId)), Criteria.where((String)"linkedCollections").in(new Object[]{collectionId})});
        query1.addCriteria((CriteriaDefinition)criteria);
        List solutionAreas = this.mongoTemplate.find(query1, SolutionArea.class);
        response.put("success", true);
        response.put("solutionAreas", solutionAreas);
        return response;
    }

    public HashMap<String, Object> sortListingItem(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String sequence = (String)params.get("sequence");
        if (params.containsKey("solutionAreaId")) {
            String solutionAreaId = (String)params.get("solutionAreaId");
            SolutionArea solutionArea = (SolutionArea)this.solutionAreaRepository.findOne((Serializable)((Object)solutionAreaId));
            solutionArea.setSequence(Double.valueOf(Double.parseDouble(sequence)));
            this.solutionAreaRepository.save((Object)solutionArea);
            response.put("success", true);
            response.put("sequence", solutionArea.getSequence());
        } else if (params.containsKey("collectionId")) {
            String collectionId = (String)params.get("collectionId");
            WorkSpace collection = this.workSpaceRepository.findById(collectionId);
            collection.setSequence(Double.valueOf(Double.parseDouble(sequence)));
            this.workSpaceRepository.save((Object)collection);
            response.put("success", true);
            response.put("sequence", collection.getSequence());
        }
        return response;
    }

    public HashMap<String, Object> getCollectionTags(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        List collectionIds = (List)params.get("collectionIds");
        List collectionIdsObjs = collectionIds.stream().map(cid -> new ObjectId(cid)).collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(collectionIdsObjs));
        List releaseTrains = this.mongoTemplate.find(query, WorkSpace.class);
        ArrayList tags = new ArrayList();
        for (WorkSpace col : releaseTrains) {
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put("id", col.getId());
            tag.put("key", col.getKey());
            tag.put("color", col.getColor());
            tag.put("title", col.getTitle());
            tag.put("shortName", col.getShortName());
            if (PropertyValidator.isValid((Object)col.getType())) {
                tag.put("typePrefix", col.getType().getPrefix());
                tag.put("typeTitle", col.getType().getTitle());
            }
            tags.add(tag);
        }
        response.put("collections", tags);
        return response;
    }

    public HashMap<String, Object> getSessionTags(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        List sessionIds = (List)params.get("sessionIds");
        List sessionIdsObjs = sessionIds.stream().map(cid -> new ObjectId(cid)).collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sessionIdsObjs));
        List sessions = this.mongoTemplate.find(query, Session.class);
        ArrayList tags = new ArrayList();
        for (Session session : sessions) {
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put("id", session.getId());
            tag.put("title", session.getTitle());
            tag.put("activeSessionBoard", session.getActiveSessionBoard());
            tag.put("workSpace", session.getWorkSpace().getId());
            tags.add(tag);
        }
        response.put("boards", tags);
        return response;
    }

    public HashMap<String, Object> getSolutionBoards(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query query1 = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        if (params.containsKey("solutionAreaId")) {
            String solutionAreaId = (String)params.get("solutionAreaId");
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionArea.$id").is((Object)new ObjectId(solutionAreaId)));
        }
        if (params.containsKey("collectionId")) {
            String collectionId = (String)params.get("collectionId");
            if (collectionId.equals("-1")) {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace").is(null));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionArea").is(null));
            } else {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").is((Object)new ObjectId(collectionId)));
            }
        }
        List solutionBoards = this.mongoTemplate.find(query1, SolutionBoard.class);
        User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        for (SolutionBoard sb : solutionBoards) {
            if (!PropertyValidator.isValid((Collection)sb.getFavouriteForUsers())) continue;
            String foundUID = sb.getFavouriteForUsers().stream().filter(uid -> uid.equals(currentUser.getId())).findAny().orElse(null);
            if (PropertyValidator.isValid((Object)foundUID)) {
                sb.setFavouriteForCuurrentUser(true);
                continue;
            }
            sb.setFavouriteForCuurrentUser(false);
        }
        response.put("boards", solutionBoards);
        return response;
    }

    public HashMap<String, Object> saveSolutionArea(SolutionArea solutionArea) throws Exception {
        List existingRoles;
        HashMap<String, Object> response = new HashMap<String, Object>();
        List selectedCollectionIds = solutionArea.getLinkedCollections();
        List<Object> collectionIds = new ArrayList();
        if (solutionArea.getId() == null) {
            solutionArea.setKey(this.customRepository.generateKey("SA"));
            if (PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                collectionIds.addAll(selectedCollectionIds);
            }
        } else {
            SolutionArea existingArea = (SolutionArea)this.solutionAreaRepository.findOne((Serializable)((Object)solutionArea.getId()));
            if (PropertyValidator.isValid((Object)existingArea) && PropertyValidator.isValid((Collection)existingArea.getLinkedCollections()) && PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                HashSet existingCollectionIds = new HashSet(existingArea.getLinkedCollections());
                collectionIds = selectedCollectionIds.stream().filter(id -> !existingCollectionIds.contains(id)).collect(Collectors.toList());
            } else if (PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                collectionIds.addAll(selectedCollectionIds);
            }
        }
        response.put("success", true);
        SolutionArea savedSolutionArea = (SolutionArea)this.solutionAreaRepository.save((Object)solutionArea);
        if (PropertyValidator.isValid((Collection)solutionArea.getAccessRoles())) {
            for (WorkSpaceAccessRole accessRole : solutionArea.getAccessRoles()) {
                if (PropertyValidator.isValid((Object)accessRole.getUser())) {
                    if (accessRole.getUser().isLdap()) {
                        accessRole.getUser().setId(null);
                        User ldapUser = this.userRepository.findByUserCompanies_Company_IdAndUserNameIgnoreCase(UserContextUtil.getUserContext().getCurrentCompany().getId(), accessRole.getUser().getUserName().toLowerCase());
                        if (PropertyValidator.isValid((Object)ldapUser)) {
                            accessRole.setUser(ldapUser);
                        } else {
                            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                            accessRole.getUser().setUserCompanies(new ArrayList());
                            UserCompany userCompany = new UserCompany();
                            userCompany.setCompany(new Company(cid));
                            userCompany.setIsGuest(accessRole.getUser().getIsGuest());
                            accessRole.getUser().getUserCompanies().add(userCompany);
                            accessRole.getUser().setUserName(accessRole.getUser().getUserName().toLowerCase());
                            accessRole.setUser((User)this.userRepository.save((Object)accessRole.getUser()));
                        }
                    }
                } else if (PropertyValidator.isValid((Object)accessRole.getGroup()) && accessRole.getGroup().isLdap()) {
                    accessRole.getGroup().setId(null);
                    Group ldapGroup = this.groupRepository.findByTitle(accessRole.getGroup().getTitle());
                    if (PropertyValidator.isValid((Object)ldapGroup)) {
                        accessRole.setGroup(ldapGroup);
                    } else {
                        accessRole.setGroup((Group)this.groupRepository.save((Object)accessRole.getGroup()));
                    }
                }
                SolutionArea tempSolutionArea = new SolutionArea();
                tempSolutionArea.setId(savedSolutionArea.getId());
                accessRole.setSolutionArea(tempSolutionArea);
            }
            existingRoles = this.workSpaceAccessRoleRepository.findBySolutionArea(savedSolutionArea);
            if (PropertyValidator.isValid((Collection)existingRoles)) {
                HashSet existingRoleSet = new HashSet(existingRoles);
                HashSet newRoleSet = new HashSet(solutionArea.getAccessRoles());
                HashSet rolesToRemove = new HashSet(existingRoleSet);
                rolesToRemove.removeAll(newRoleSet);
                if (!rolesToRemove.isEmpty()) {
                    this.workSpaceAccessRoleRepository.delete(rolesToRemove);
                }
            }
            this.workSpaceAccessRoleRepository.save((Iterable)solutionArea.getAccessRoles());
        } else {
            existingRoles = this.workSpaceAccessRoleRepository.findBySolutionArea(savedSolutionArea);
            if (PropertyValidator.isValid((Collection)existingRoles)) {
                this.workSpaceAccessRoleRepository.delete((Iterable)existingRoles);
            }
        }
        response.put("solutionArea", savedSolutionArea);
        return response;
    }

    public HashMap<String, Object> deleteSolutionArea(String solutionAreaId) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        SolutionArea tempArea = new SolutionArea();
        tempArea.setId(solutionAreaId);
        Query query1 = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionArea.$id").is((Object)new ObjectId(solutionAreaId)));
        List solutionBoards = this.mongoTemplate.find(query1, SolutionBoard.class);
        if (PropertyValidator.isValid((Collection)solutionBoards)) {
            for (SolutionBoard sb : solutionBoards) {
                sb.setSolutionArea(null);
            }
            this.solutionBoardRepository.save((Iterable)solutionBoards);
        }
        this.workSpaceAccessRoleRepository.deleteBySolutionArea(tempArea);
        this.solutionAreaRepository.deleteById(solutionAreaId);
        response.put("solutionAreaId", solutionAreaId);
        response.put("success", true);
        return response;
    }

    public HashMap<String, Object> solutionBoardMoveTo(Map<String, String> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String solutionBoardId = params.get("solutionBoardId");
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionBoardId));
        if (PropertyValidator.isValid((Object)solutionBoard)) {
            if (params.containsKey("solutionAreaId")) {
                String solutionAreaId = params.get("solutionAreaId");
                SolutionArea tempSolutionArea = new SolutionArea();
                tempSolutionArea.setId(solutionAreaId);
                solutionBoard.setWorkSpace(null);
                solutionBoard.setSolutionArea(tempSolutionArea);
            } else if (params.containsKey("collectionId")) {
                String collectionId = params.get("collectionId");
                WorkSpace tempCollection = new WorkSpace();
                tempCollection.setId(collectionId);
                solutionBoard.setWorkSpace(tempCollection);
                solutionBoard.setSolutionArea(null);
            }
            this.solutionBoardRepository.save((Object)solutionBoard);
            SolutionBoard newCopy = this.solutionBoardRepository.findById(solutionBoardId);
            response.put("success", true);
            response.put("board", newCopy);
        } else {
            response.put("success", false);
        }
        return response;
    }

    public HashMap<String, Object> getSolutionBoardsBySolutionAreaAndCollections(Map<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query query1 = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
        if (params.containsKey("solutionAreaId")) {
            List solutionAreaIds = (List)params.get("solutionAreaId");
            List solutionAreaObjectIds = solutionAreaIds.stream().map(ObjectId::new).collect(Collectors.toList());
            orCriteria.add(Criteria.where((String)"solutionArea.$id").in(solutionAreaObjectIds));
        }
        if (params.containsKey("collectionId")) {
            List collectionIds = (List)params.get("collectionId");
            if (PropertyValidator.isValid((Collection)collectionIds) && collectionIds.contains("-1")) {
                orCriteria.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"workSpace").is(null), Criteria.where((String)"solutionArea").is(null)}));
                collectionIds.remove("-1");
            }
            if (PropertyValidator.isValid((Collection)collectionIds) && !collectionIds.isEmpty()) {
                List collectionObjectIds = collectionIds.stream().map(ObjectId::new).collect(Collectors.toList());
                orCriteria.add(Criteria.where((String)"workSpace.$id").in(collectionObjectIds));
            }
        }
        if (!orCriteria.isEmpty()) {
            query1.addCriteria((CriteriaDefinition)new Criteria().orOperator(orCriteria.toArray(new Criteria[0])));
        }
        List solutionBoards = this.mongoTemplate.find(query1, SolutionBoard.class);
        response.put("boards", solutionBoards);
        return response;
    }
}

