/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.service.ScheduledCleanerService;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="ScheduledCleanerService")
public class ScheduledCleanerServiceImpl
implements ScheduledCleanerService {
    @Autowired
    private PushResponseRepository pushResponseRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledCleanerServiceImpl.class);

    @Scheduled(cron="0 0 */3 * * *")
    public void cleanPushResponse() {
        try {
            LOGGER.info("***** Executing cleanPushResponse() *****");
            Instant thirtyMinutesAgo = Instant.now().minus(Duration.ofMinutes(30L));
            LOGGER.info("Searching items older than: " + Date.from(thirtyMinutesAgo));
            List itemsToClean = this.pushResponseRepository.findItemsOlderThan(Date.from(thirtyMinutesAgo));
            LOGGER.info("Total Push Responses Fetched: " + itemsToClean.size());
            this.pushResponseRepository.delete((Iterable)itemsToClean);
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred in cleanPushResponse: ", (Throwable)ex);
        }
    }
}

