/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.google.gson.Gson;
import com.mongodb.DBObject;
import com.viztrend.safe.alm.jira.bo.JiraWebhookMappedData;
import com.viztrend.safe.alm.jira.bo.SQSJsonJira;
import com.viztrend.safe.alm.jira.bo.SQSJsonTfs;
import com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.service.SQSWebhookService;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.service.WebHookSyncServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3CacheUtil;
import com.viztrend.safe.utils.SystemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.aws.messaging.listener.SqsMessageDeletionPolicy;
import org.springframework.cloud.aws.messaging.listener.annotation.SqsListener;
import org.springframework.core.env.Environment;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ConditionalOnExpression(value="!('${sqs.aws.accessKey}'.contains('xxxxxx') or ${isLocalDeployment})")
public class SQSWebhookService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQSWebhookService.class);
    @Value(value="${sqs.webhook.url}")
    private String sqsURl;
    @Autowired(required=false)
    private String jiraQueueName;
    @Autowired(required=false)
    private String tfsQueueName;
    @Autowired(required=false)
    private AmazonSQS amazonSQS;
    @Autowired
    private Gson gson;
    @Autowired
    private Environment env;
    @Autowired
    private CustomRepositoryImpl<Object> customRepositoryImpl;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private WebHookSyncService webHookSyncService;

    @PostConstruct
    public void validateConfiguration() {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            LOGGER.info("SQSWebhookService running in LOCAL deployment mode - AWS SQS disabled");
            return;
        }
        String accessKey = this.env.getProperty("sqs.aws.accessKey");
        if ("xxxxxx".equals(accessKey)) {
            LOGGER.info("SQSWebhookService: AWS SQS disabled - access key is placeholder value");
            return;
        }
        if (this.amazonSQS == null || this.jiraQueueName == null || this.tfsQueueName == null) {
            LOGGER.warn("SQSWebhookService: AWS SQS beans not available - SQS functionality disabled");
            return;
        }
        LOGGER.info("SQSWebhookService Configuration:");
        LOGGER.info("SQS Queue URL: " + (this.sqsURl != null ? this.sqsURl : "NOT CONFIGURED"));
        LOGGER.info("AmazonSQS Client: " + (this.amazonSQS != null ? "INITIALIZED" : "NOT INITIALIZED"));
        if (this.sqsURl == null || this.sqsURl.isEmpty()) {
            LOGGER.error("sqs.webhook.url is not configured!");
        }
        if (this.jiraQueueName == null || this.jiraQueueName.isEmpty()) {
            LOGGER.error("sqs.webhook.jira.queue.name is not configured!");
        }
        if (this.tfsQueueName == null || this.tfsQueueName.isEmpty()) {
            LOGGER.error("sqs.webhook.tfs.queue.name is not configured!");
        }
        if (this.amazonSQS == null) {
            LOGGER.error("AmazonSQS client is not initialized!");
        }
        this.createQueueIfNotExists(this.jiraQueueName);
        this.createQueueIfNotExists(this.tfsQueueName);
        LOGGER.info("SQS Listener should be listening on queue: " + this.jiraQueueName);
    }

    private void createQueueIfNotExists(String queueName) {
        if (this.amazonSQS == null || queueName == null || queueName.isEmpty()) {
            LOGGER.warn("Cannot create queue: AmazonSQS client or queue name not available");
            return;
        }
        try {
            GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest(queueName);
            this.amazonSQS.getQueueUrl(getQueueUrlRequest);
            LOGGER.info("SQS queue already exists: " + queueName);
        }
        catch (QueueDoesNotExistException e) {
            LOGGER.info("SQS queue does not exist, creating: " + queueName);
            this.createQueue(queueName);
        }
        catch (Exception e) {
            LOGGER.error("Error checking SQS queue existence: " + queueName, (Throwable)e);
        }
    }

    private void createQueue(String queueName) {
        try {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
            if (queueName.endsWith(".fifo")) {
                createQueueRequest.addAttributesEntry("FifoQueue", "true");
                createQueueRequest.addAttributesEntry("ContentBasedDeduplication", "true");
                createQueueRequest.addAttributesEntry("MessageRetentionPeriod", "1209600");
                createQueueRequest.addAttributesEntry("VisibilityTimeout", "30");
                createQueueRequest.addAttributesEntry("ReceiveMessageWaitTimeSeconds", "0");
                LOGGER.info("Creating FIFO queue with deduplication: " + queueName);
            } else {
                createQueueRequest.addAttributesEntry("MessageRetentionPeriod", "1209600");
                createQueueRequest.addAttributesEntry("VisibilityTimeout", "30");
                createQueueRequest.addAttributesEntry("ReceiveMessageWaitTimeSeconds", "0");
                LOGGER.info("Creating standard queue: " + queueName);
            }
            CreateQueueResult result = this.amazonSQS.createQueue(createQueueRequest);
            LOGGER.info("Successfully created SQS queue: " + result.getQueueUrl());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create SQS queue: " + queueName, (Throwable)e);
        }
    }

    private String findValidCompany(String almAccountId, Long time) {
        List alms = null;
        try {
            alms = this.customRepositoryImpl.getByObjectId((Collection)new /* Unavailable Anonymous Inner Class!! */, AlmAccount.class);
            if (PropertyValidator.isValid((Collection)alms) && PropertyValidator.isValid(alms.get(0)) && Boolean.TRUE.equals(((DBObject)alms.get(0)).get("isActive"))) {
                String tenant = (String)((DBObject)alms.get(0)).get("tenant");
                Company company = this.companyRepository.findByTenant(tenant);
                LOGGER.debug("[SQS] Webhook received from :" + company.getUrlPrefix() + " :: ALM Account Id :" + almAccountId);
                if (PropertyValidator.isValid((Object)company)) {
                    long diff = 1L;
                    long diff2 = 1L;
                    if (company.getExpiryDate() != null) {
                        diff = company.getExpiryDate().getTime() - time;
                    } else if (company.getNextPaymentDate() != null) {
                        diff2 = company.getNextPaymentDate().getTime() - time;
                    }
                    if (diff > 0L && diff2 > 0L) {
                        return tenant;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Failed to find valid company while procession webhook from SQS queue", (Throwable)e);
        }
        try {
            S3CacheUtil.blockAccount((String)almAccountId);
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Failed find valid ALM or Company, so alm id to block list in sqs", (Throwable)e);
        }
        return "0";
    }

    private static boolean isElbActive() {
        if (!SystemUtil.isProductionCloudEnv()) {
            return true;
        }
        long timeDiff = System.currentTimeMillis() - WebHookSyncServiceImpl.elbLastActive;
        if (timeDiff > 30000L) {
            LOGGER.error("Schedule timeout since : " + timeDiff / 1000L + " seconds");
            return false;
        }
        return true;
    }

    @SqsListener(value={"${sqs.webhook.jira.queue.name}"}, deletionPolicy=SqsMessageDeletionPolicy.ON_SUCCESS)
    public void processJiraWebhook(String body, @Header(value="MessageGroupId") String almId) {
        try {
            if (!SQSWebhookService.isElbActive()) {
                LOGGER.error("ELB not active; retry later");
                throw new InactiveNodeException(this, "ELB not active; retry later");
            }
            this.webHookSyncService.printLogs(almId, "[SQS] webhook received");
            String tenant = this.findValidCompany(almId, Long.valueOf(new Date().getTime()));
            if (!"0".equals(tenant)) {
                SQSJsonJira sqs = (SQSJsonJira)this.gson.fromJson(body, SQSJsonJira.class);
                if (sqs.getBody().checkEvent()) {
                    JiraWebhookMappedData webhook = new JiraWebhookMappedData();
                    webhook.setJiraWebhookPayload(sqs.getBody());
                    webhook.fillInfo(almId, tenant, null);
                    this.webHookSyncService.processJiraWebhook(webhook);
                } else {
                    this.webHookSyncService.printLogs(almId, "[SQS] webhook skipped due to event/link type check not passed");
                }
            }
            this.webHookSyncService.printLogs(almId, "[SQS] webhook processed");
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Failed to process JIRA webhook message", (Throwable)e);
            throw e;
        }
    }

    @SqsListener(value={"${sqs.webhook.tfs.queue.name}"}, deletionPolicy=SqsMessageDeletionPolicy.ON_SUCCESS)
    public void processTFSWebhook(String body, @Header(value="MessageGroupId") String almId) {
        try {
            if (!SQSWebhookService.isElbActive()) {
                LOGGER.error("ELB not active; retry later");
                throw new InactiveNodeException(this, "ELB not active; retry later");
            }
            this.webHookSyncService.printLogs(almId, "[SQS] webhook received");
            String tenant = this.findValidCompany(almId, Long.valueOf(new Date().getTime()));
            if (!"0".equals(tenant)) {
                SQSJsonTfs sqs = (SQSJsonTfs)this.gson.fromJson(body, SQSJsonTfs.class);
                TFSWebhookMappedData data = new TFSWebhookMappedData();
                data.fillInfo(almId, tenant, sqs.getBody(), "", "");
                this.webHookSyncService.updateTFSWebhookItem(data);
            }
            this.webHookSyncService.printLogs(almId, "[SQS] webhook processed");
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Failed to process JIRA webhook message", (Throwable)e);
            throw e;
        }
    }

    public boolean sendMessageToDynamicQueue(String accountId, Object payload, Long time, String queueName) {
        try {
            JSONObject sqs = new JSONObject();
            sqs.put("accountId", (Object)accountId);
            if (payload instanceof String) {
                sqs.put("json", payload);
            } else {
                sqs.put("json", (Object)this.gson.toJson(payload));
            }
            sqs.put("time", (Object)time);
            this.createQueueIfNotExists(queueName);
            SendMessageRequest sendMsgRequest = new SendMessageRequest().withQueueUrl(this.sqsURl + "/" + queueName).withMessageBody(sqs.toString()).withMessageGroupId(accountId).withMessageDeduplicationId(UUID.randomUUID().toString());
            SendMessageResult result = this.amazonSQS.sendMessage(sendMsgRequest);
            LOGGER.debug("[SQS] msg sent to SQS: {} for account: {}", (Object)result.getMessageId(), (Object)accountId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Error sending msg for account: " + accountId, (Throwable)e);
            return false;
        }
    }

    public List<String> printAllFromQueue(String queueName) {
        ArrayList<String> msg = new ArrayList<String>();
        try {
            String fullQueueUrl = this.sqsURl + "/" + queueName;
            LOGGER.info("[SQS] Attempting to read from queue: " + fullQueueUrl);
            int totalMessagesProcessed = 0;
            int batchCount = 0;
            while (true) {
                ++batchCount;
                ReceiveMessageRequest receiveRequest = new ReceiveMessageRequest().withQueueUrl(fullQueueUrl).withMaxNumberOfMessages(Integer.valueOf(10)).withWaitTimeSeconds(Integer.valueOf(1));
                ReceiveMessageResult result = this.amazonSQS.receiveMessage(receiveRequest);
                if (result.getMessages().isEmpty()) break;
                LOGGER.info("[SQS] Found " + result.getMessages().size() + " messages in batch #" + batchCount);
                for (Message message : result.getMessages()) {
                    try {
                        LOGGER.info("[SQS] Processing message ID: " + message.getMessageId());
                        msg.add(message.getBody());
                        ++totalMessagesProcessed;
                    }
                    catch (Exception e) {
                        LOGGER.error("[SQS] Failed to process queue message: " + message.getMessageId(), (Throwable)e);
                    }
                }
                Thread.sleep(100L);
            }
            LOGGER.info("[SQS] No more messages found in queue: " + queueName);
            LOGGER.info("[SQS] ===== QUEUE PROCESSING COMPLETE =====");
            LOGGER.info("[SQS] Total messages processed: " + totalMessagesProcessed);
            LOGGER.info("[SQS] Total batches processed: " + batchCount);
            LOGGER.info("[SQS] Queue: " + queueName + " is now empty");
        }
        catch (Exception e) {
            LOGGER.error("[SQS] Error reading from queue: " + queueName, (Throwable)e);
        }
        return msg;
    }
}

