/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatus;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatusRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.service.RoadmapService;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.TimeSeriesUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="roadmapService")
@Transactional
class RoadmapServiceImpl
implements RoadmapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoadmapServiceImpl.class);
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private TimeSeriesSyncStatusRepository timeSeriesSyncStatusRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TimeSeriesRepository timeSeriesRepository;

    RoadmapServiceImpl() {
    }

    private Map<String, TeamContainer> getTeamContainers(Map<String, List<DBObject>> itemsByBoard) {
        HashMap<String, TeamContainer> teamContainerMap = new HashMap<String, TeamContainer>();
        if (!PropertyValidator.isValid(itemsByBoard)) {
            return teamContainerMap;
        }
        HashSet teamContainerIds = new HashSet();
        for (List<DBObject> itemList : itemsByBoard.values()) {
            itemList.forEach(item -> {
                if (PropertyValidator.isValid((Object)item.get("teamContainers"))) {
                    List teamContainerRefs = (List)item.get("teamContainers");
                    teamContainerRefs.forEach(ref -> teamContainerIds.add(ref.getId().toString()));
                }
            });
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)KendisUtils.getListAsObjectIds(teamContainerIds)));
        try (DBCursor cursor = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());){
            while (cursor.hasNext()) {
                BasicDBObject object = (BasicDBObject)cursor.next();
                TeamContainer teamContainer = new TeamContainer();
                String id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
                teamContainer.setId(id);
                teamContainer.setOriginItemId(object.getString("originItemId"));
                if (PropertyValidator.isValid((Object)object.get("team"))) {
                    DBRef teamRef = (DBRef)object.get("team");
                    Team team = new Team(teamRef.getId().toString());
                    teamContainer.setTeam(team);
                }
                if (PropertyValidator.isValid((Object)object.get("container"))) {
                    DBRef containerRef = (DBRef)object.get("container");
                    Container container = new Container(containerRef.getId().toString());
                    teamContainer.setContainer(container);
                }
                teamContainerMap.put(teamContainer.getId(), teamContainer);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return teamContainerMap;
    }

    private Map<String, List<DBObject>> getBoardItemsForSmartReport(List<ObjectId> sessionBoardIds) {
        HashMap<String, List<DBObject>> allItemsByBoard = new HashMap<String, List<DBObject>>();
        if (!PropertyValidator.isValid(sessionBoardIds)) {
            return allItemsByBoard;
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds));
        query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
        try (DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection(KendisUtils.dbName(Item.class)).find(query.getQueryObject()).sort((DBObject)new BasicDBObject("backlogSequence", (Object)1));){
            while (dbCursorPrefix.hasNext()) {
                DBObject item = dbCursorPrefix.next();
                if (!PropertyValidator.isValid((Object)item.get("sessionBoards"))) continue;
                List sessionBoardRefs = (List)item.get("sessionBoards");
                sessionBoardRefs.forEach(ref -> allItemsByBoard.computeIfAbsent(ref.getId().toString(), k -> new LinkedList()).add(item));
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return allItemsByBoard;
    }

    private List<DBObject> getBoardItems(String sessionBoard) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoard)));
        query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("backlogSequence", (Object)1));
        List allItems = dbCursorPrefix.toArray();
        return allItems;
    }

    private List<DBObject> getBoardStatus(ArrayList<Object> allStatuses) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(allStatuses));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject());
        List _statusesRaw = dbCursorPrefix.toArray();
        return _statusesRaw;
    }

    private HashMap<String, Object> getBoardPreviousState(String sessionBoardId) {
        HashMap<String, Object> responce = new HashMap<String, Object>();
        try {
            SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)activeSessionBoard.getSession().getId()));
            ArrayList<SessionBoard> stateSessionBoards = new ArrayList<SessionBoard>();
            ArrayList sessionBoardStateArray = new ArrayList();
            List allStates = this.stateRepository.findAll();
            for (State s : allStates) {
                if (s.getSequence() >= activeSessionBoard.getState().getSequence()) continue;
                HashMap<String, Object> tempSessionBoardStateMap = new HashMap<String, Object>();
                SessionBoard temSessionBoard = this.sessionBoardRepository.findOneBySessionAndState(session, s);
                tempSessionBoardStateMap.put("sequence", s.getSequence());
                tempSessionBoardStateMap.put("title", s.getTitle());
                tempSessionBoardStateMap.put("sessionBoardId", String.valueOf(temSessionBoard.getId()));
                sessionBoardStateArray.add(tempSessionBoardStateMap);
                stateSessionBoards.add(temSessionBoard);
            }
            stateSessionBoards.add(activeSessionBoard);
            responce.put("activeSessionBoard", activeSessionBoard);
            responce.put("session", session);
            responce.put("stateSessionBoards", stateSessionBoards);
            responce.put("sessionBoardStateArray", sessionBoardStateArray);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responce;
    }

    private HashMap<String, Object> boardTeamSprintAndIssueTypeMap(SessionBoard currentSessionBoard) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            HashMap teamsMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            List teams = currentSessionBoard.getTeams();
            List containers = currentSessionBoard.getContainers();
            teams.forEach(team -> teamsMapById.put(team.getId(), team));
            containers.forEach(container -> containerMapById.put(container.getId(), container));
            responseJson.put("teamsMapById", teamsMapById);
            responseJson.put("containerMapById", containerMapById);
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private String checkItemOriginItemIdORId(Item item) {
        if (PropertyValidator.isValid((Object)item.getOriginItemId())) {
            return String.valueOf(item.getOriginItemId());
        }
        return String.valueOf(item.getId());
    }

    private void compareItemWithPreviousStates(Item item, HashMap<String, Object> stateSessionBoardsData) {
        HashMap stateSessionData = new HashMap();
        for (String key : stateSessionBoardsData.keySet()) {
            HashMap sessionData = (HashMap)stateSessionBoardsData.get(key);
            HashMap<String, Date> stateSessionDateMap = new HashMap<String, Date>();
            if (PropertyValidator.isValid((Object)item) && sessionData.containsKey(this.checkItemOriginItemIdORId(item))) {
                Item previousStateItem = (Item)sessionData.get(this.checkItemOriginItemIdORId(item));
                stateSessionDateMap.put("startDate", previousStateItem.getStartDate());
                stateSessionDateMap.put("endDate", previousStateItem.getEndDate());
            }
            stateSessionData.put(String.valueOf(key), stateSessionDateMap);
        }
        item.setStates(stateSessionData);
    }

    private Map<String, Object> processDataBasedOnStateForSmartReport(List<DBObject> boardStateItems, SessionBoard sessionBoard, Map<String, TeamContainer> teamContainerData, Map<String, Team> currentStateTeamsMapById, Map<String, Container> currentStateContainerMapById, Map<String, IssueType> issueTypeMapById, HashMap<String, Object> stateSessionBoardsData, boolean comparisonFlag) {
        try {
            ArrayList allStatuses = new ArrayList();
            HashMap statusMapById = new HashMap();
            ArrayList itemLinks = new ArrayList();
            HashMap itemLinkMapById = new HashMap();
            ArrayList jiraLinks = new ArrayList();
            HashMap jiraLinkMapById = new HashMap();
            HashMap childItemsByParentId = new HashMap();
            HashMap<String, Object> currentStateItemsMapById = new HashMap<String, Object>();
            HashMap<String, Object> currentStateLinearItemsMapById = new HashMap<String, Object>();
            Set fields = sessionBoard.getSession().combineAdditionalFields(null, null, true, null);
            if (PropertyValidator.isValid(boardStateItems)) {
                boardStateItems.forEach(dbItem -> {
                    Item item = this.createItemSmartForReport(dbItem, teamContainerData, statusMapById, (List)allStatuses, (Map)itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, currentStateTeamsMapById, currentStateContainerMapById, issueTypeMapById);
                    currentStateLinearItemsMapById.put(this.checkItemOriginItemIdORId(item), item);
                    item.putCustomeValuesAsText((Map)dbItem.get("jiraFieldByKey"), (Collection)fields, null);
                    if (item.getType().equals(Item.FEATURE)) {
                        currentStateItemsMapById.put(this.checkItemOriginItemIdORId(item), item);
                        List subItems = childItemsByParentId.computeIfAbsent(item.getId(), k -> new ArrayList());
                        item.setSubItems(subItems);
                    } else if (PropertyValidator.isValid((Object)item.getParent())) {
                        List subItems = childItemsByParentId.computeIfAbsent(item.getParent().getId(), k -> new ArrayList());
                        subItems.add(item);
                    } else {
                        LOGGER.debug("Item does not have parent : " + item.getJiraKey() + " : " + item.getId());
                    }
                });
            }
            if (comparisonFlag) {
                List _itemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
                List _jiraLinks = this.itemJiraDependencyRepository.findByIdIn(jiraLinks);
                List _statusesRaw = this.getBoardStatus(allStatuses);
                ArrayList<Status> _statuses = new ArrayList<Status>();
                if (PropertyValidator.isValid((Collection)_statusesRaw)) {
                    _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
                }
                HashMap _itemLinksMap = new HashMap();
                HashMap _jiraLinksMap = new HashMap();
                HashMap _statusesMap = new HashMap();
                if (PropertyValidator.isValid((Collection)_itemLinks)) {
                    _itemLinks.forEach(item -> _itemLinksMap.put(item.getId(), item));
                }
                if (PropertyValidator.isValid((Collection)_jiraLinks)) {
                    _jiraLinks.forEach(item -> _jiraLinksMap.put(item.getId(), item));
                }
                if (PropertyValidator.isValid(_statuses)) {
                    _statuses.forEach(item -> {
                        item.setWorkFlow(null);
                        item.setWorkFlowItemType(null);
                        _statusesMap.put(item.getId(), item);
                    });
                }
                if (PropertyValidator.isValid(currentStateLinearItemsMapById)) {
                    for (Object it : currentStateLinearItemsMapById.values()) {
                        List orgJiraLinks;
                        Item item2 = (Item)it;
                        this.compareItemWithPreviousStates(item2, stateSessionBoardsData);
                        item2.setStatus((Status)_statusesMap.get(item2.getStatus().getId()));
                        List orgItemLinks = item2.getItemLinks();
                        if (PropertyValidator.isValid((Collection)orgItemLinks)) {
                            ArrayList newItemLinks = new ArrayList();
                            orgItemLinks.forEach(link -> {
                                ItemLink newlink = (ItemLink)_itemLinksMap.get(link.getId());
                                if (PropertyValidator.isValid((Object)newlink)) {
                                    if (PropertyValidator.isValid((Object)newlink.getWfStatus())) {
                                        newlink.getWfStatus().setWorkFlow(null);
                                        newlink.getWfStatus().setWorkFlowItemType(null);
                                    }
                                    newItemLinks.add(newlink);
                                }
                            });
                            item2.setItemLinks(newItemLinks);
                        }
                        if (!PropertyValidator.isValid((Collection)(orgJiraLinks = item2.getJiraDependencies()))) continue;
                        ArrayList newJiraLinks = new ArrayList();
                        orgJiraLinks.forEach(link -> {
                            if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid(_jiraLinksMap.get(link.getId()))) {
                                String[] type;
                                List<String> typeList;
                                ItemJiraDependency almLink = (ItemJiraDependency)_jiraLinksMap.get(link.getId());
                                if (!PropertyValidator.isValid((Object)almLink.getJiraDependencyId()) && PropertyValidator.isValid((Object)almLink.getSourceItemId()) && PropertyValidator.isValid((Object)almLink.getTargetItemId()) && (typeList = Arrays.asList(type = almLink.getTfsLinkType().split("-"))).size() > 1) {
                                    if (typeList.get(1).equals("Reverse")) {
                                        almLink.setJiraDependencyId(almLink.getTargetTFSItem().getTfsId() + "-" + almLink.getSourceTFSItem().getTfsId());
                                    } else {
                                        almLink.setJiraDependencyId(almLink.getSourceTFSItem().getTfsId() + "-" + almLink.getTargetTFSItem().getTfsId());
                                    }
                                }
                                newJiraLinks.add(_jiraLinksMap.get(link.getId()));
                            }
                        });
                        item2.setJiraDependencies(newJiraLinks);
                    }
                }
                return currentStateItemsMapById;
            }
            return currentStateLinearItemsMapById;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private HashMap<String, Object> processDataBasedOnState(List<DBObject> boardStateItems, SessionBoard sessionBoard, HashMap<String, Team> currentStateTeamsMapById, HashMap<String, Container> currentStateContainerMapById, HashMap<String, IssueType> issueTypeMapById, HashMap<String, Object> stateSessionBoardsData, boolean comparisonFlag, HashMap<String, Object> _itemMapByLinkType) {
        try {
            ArrayList allStatuses = new ArrayList();
            HashMap statusMapById = new HashMap();
            ArrayList itemLinks = new ArrayList();
            HashMap itemLinkMapById = new HashMap();
            ArrayList jiraLinks = new ArrayList();
            HashMap jiraLinkMapById = new HashMap();
            HashMap<String, ArrayList<Item>> childItemsByParentId = new HashMap<String, ArrayList<Item>>();
            HashMap<String, Object> currentStateItemsMapById = new HashMap<String, Object>();
            HashMap<String, Object> currentStateLinearItemsMapById = new HashMap<String, Object>();
            Set fields = sessionBoard.getSession().combineAdditionalFields(null, null, true, null);
            if (PropertyValidator.isValid(boardStateItems)) {
                for (int itemIndex = 0; itemIndex < boardStateItems.size(); ++itemIndex) {
                    ArrayList<Item> subItems;
                    DBObject vo2 = boardStateItems.get(itemIndex);
                    Item item2 = this.createItemForReport(vo2, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, currentStateTeamsMapById, currentStateContainerMapById, issueTypeMapById);
                    currentStateLinearItemsMapById.put(this.checkItemOriginItemIdORId(item2), item2);
                    item2.putCustomeValuesAsText((Map)vo2.get("jiraFieldByKey"), (Collection)fields, null);
                    if (item2.getType().equals(Item.FEATURE)) {
                        currentStateItemsMapById.put(this.checkItemOriginItemIdORId(item2), item2);
                        subItems = (ArrayList)childItemsByParentId.get(item2.getId());
                        if (subItems == null) {
                            subItems = new ArrayList();
                            childItemsByParentId.put(item2.getId(), subItems);
                        }
                        item2.setSubItems(subItems);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)item2.getParent())) {
                        subItems = (ArrayList<Item>)childItemsByParentId.get(item2.getParent().getId());
                        if (subItems == null) {
                            subItems = new ArrayList<Item>();
                            childItemsByParentId.put(item2.getParent().getId(), subItems);
                        }
                        subItems.add(item2);
                        continue;
                    }
                    LOGGER.debug("Item does not have parent : " + item2.getJiraKey() + " : " + item2.getId());
                }
            }
            if (comparisonFlag) {
                List _itemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
                List _jiraLinks = this.itemJiraDependencyRepository.findByIdIn(jiraLinks);
                List _statusesRaw = this.getBoardStatus(allStatuses);
                ArrayList<Status> _statuses = new ArrayList<Status>();
                if (PropertyValidator.isValid((Collection)_statusesRaw)) {
                    _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
                }
                HashMap _itemLinksMap = new HashMap();
                HashMap _jiraLinksMap = new HashMap();
                HashMap _statusesMap = new HashMap();
                if (PropertyValidator.isValid((Collection)_itemLinks)) {
                    _itemLinks.forEach(item -> _itemLinksMap.put(item.getId(), item));
                }
                if (PropertyValidator.isValid((Collection)_jiraLinks)) {
                    _jiraLinks.forEach(item -> _jiraLinksMap.put(item.getId(), item));
                }
                if (PropertyValidator.isValid(_statuses)) {
                    _statuses.forEach(item -> {
                        item.setWorkFlow(null);
                        item.setWorkFlowItemType(null);
                        _statusesMap.put(item.getId(), item);
                    });
                }
                if (PropertyValidator.isValid(currentStateLinearItemsMapById)) {
                    for (Object it : currentStateLinearItemsMapById.values()) {
                        List orgJiraLinks;
                        Item item3 = (Item)it;
                        this.compareItemWithPreviousStates(item3, stateSessionBoardsData);
                        item3.setStatus((Status)_statusesMap.get(item3.getStatus().getId()));
                        List orgItemLinks = item3.getItemLinks();
                        if (PropertyValidator.isValid((Collection)orgItemLinks)) {
                            ArrayList newItemLinks = new ArrayList();
                            orgItemLinks.forEach(link -> {
                                ItemLink newlink = (ItemLink)_itemLinksMap.get(link.getId());
                                if (PropertyValidator.isValid((Object)newlink)) {
                                    if (PropertyValidator.isValid((Object)newlink.getWfStatus())) {
                                        newlink.getWfStatus().setWorkFlow(null);
                                        newlink.getWfStatus().setWorkFlowItemType(null);
                                    }
                                    newItemLinks.add(newlink);
                                }
                            });
                            item3.setItemLinks(newItemLinks);
                        }
                        if (!PropertyValidator.isValid((Collection)(orgJiraLinks = item3.getJiraDependencies()))) continue;
                        ArrayList newJiraLinks = new ArrayList();
                        orgJiraLinks.forEach(link -> {
                            if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid(_jiraLinksMap.get(link.getId()))) {
                                String[] type;
                                List<String> typeList;
                                ItemJiraDependency almLink = (ItemJiraDependency)_jiraLinksMap.get(link.getId());
                                if (!PropertyValidator.isValid((Object)almLink.getJiraDependencyId()) && PropertyValidator.isValid((Object)almLink.getSourceItemId()) && PropertyValidator.isValid((Object)almLink.getTargetItemId()) && (typeList = Arrays.asList(type = almLink.getTfsLinkType().split("-"))).size() > 1) {
                                    if (typeList.get(1).equals("Reverse")) {
                                        almLink.setJiraDependencyId(almLink.getTargetTFSItem().getTfsId() + "-" + almLink.getSourceTFSItem().getTfsId());
                                    } else {
                                        almLink.setJiraDependencyId(almLink.getSourceTFSItem().getTfsId() + "-" + almLink.getTargetTFSItem().getTfsId());
                                    }
                                }
                                newJiraLinks.add(_jiraLinksMap.get(link.getId()));
                            }
                        });
                        item3.setJiraDependencies(newJiraLinks);
                    }
                }
                return currentStateItemsMapById;
            }
            return currentStateLinearItemsMapById;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public Map<String, Object> getRoadMapDataForSmartReport(String sessionBoardId, String requestId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            long startTime = System.currentTimeMillis();
            HashMap boardStateMap = this.getBoardPreviousState(sessionBoardId);
            SessionBoard activeSessionBoard = (SessionBoard)boardStateMap.get("activeSessionBoard");
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapByIds = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapByIds.put(issueType.getId(), issueType));
            List stateSessionBoards = (List)boardStateMap.get("stateSessionBoards");
            HashMap<String, Map> sessionBoardData = new HashMap<String, Map>();
            List sessionBoardIds = stateSessionBoards.stream().map(sessionBoard -> new ObjectId(sessionBoard.getId())).collect(Collectors.toList());
            Map stateItemsBySessionBoardId = this.getBoardItemsForSmartReport(sessionBoardIds);
            Map teamContainerById = this.getTeamContainers(stateItemsBySessionBoardId);
            startTime = System.currentTimeMillis();
            for (SessionBoard sessionBoard2 : stateSessionBoards) {
                HashMap boardsTeamSprintAndStatusMap = this.boardTeamSprintAndIssueTypeMap(sessionBoard2);
                List stateItems = (List)stateItemsBySessionBoardId.get(sessionBoard2.getId());
                Map teamsMapById = (Map)boardsTeamSprintAndStatusMap.get("teamsMapById");
                Map containerMapById = (Map)boardsTeamSprintAndStatusMap.get("containerMapById");
                if (sessionBoard2.getState().getSequence() < activeSessionBoard.getState().getSequence()) {
                    sessionBoardData.put(sessionBoard2.getId(), this.processDataBasedOnStateForSmartReport(stateItems, sessionBoard2, teamContainerById, teamsMapById, containerMapById, issueTypeMapByIds, new HashMap(), false));
                    continue;
                }
                if (!sessionBoard2.getState().getSequence().equals(activeSessionBoard.getState().getSequence())) continue;
                responseJson.put("sessionBoardItems", this.processDataBasedOnStateForSmartReport(stateItems, sessionBoard2, teamContainerById, teamsMapById, containerMapById, issueTypeMapByIds, sessionBoardData, true));
            }
            responseJson.put("sessionBoardStateArray", boardStateMap.get("sessionBoardStateArray"));
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            responseJson.put("done", true);
            return null;
        }
    }

    public HashMap<String, Object> getroadMapBoardData(String sessionBoardId, String requestId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap boardStateMap = this.getBoardPreviousState(sessionBoardId);
            HashMap _itemMapByLinkType = null;
            SessionBoard activeSessionBoard = (SessionBoard)boardStateMap.get("activeSessionBoard");
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapByIds = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapByIds.put(issueType.getId(), issueType));
            ArrayList stateSessionBoards = (ArrayList)boardStateMap.get("stateSessionBoards");
            HashMap<String, HashMap> sessionBoardData = new HashMap<String, HashMap>();
            HashMap teamsMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            boolean comparisonFlag = true;
            for (SessionBoard sessionBoard : stateSessionBoards) {
                HashMap boardsTeamSprintAndStatusMap = this.boardTeamSprintAndIssueTypeMap(sessionBoard);
                List stateItems = this.getBoardItems(String.valueOf(sessionBoard.getId()));
                teamsMapById = (HashMap)boardsTeamSprintAndStatusMap.get("teamsMapById");
                containerMapById = (HashMap)boardsTeamSprintAndStatusMap.get("containerMapById");
                if (sessionBoard.getState().getSequence() < activeSessionBoard.getState().getSequence()) {
                    comparisonFlag = false;
                    sessionBoardData.put(String.valueOf(sessionBoard.getId()), this.processDataBasedOnState(stateItems, sessionBoard, teamsMapById, containerMapById, issueTypeMapByIds, new HashMap(), comparisonFlag, null));
                    continue;
                }
                if (!sessionBoard.getState().getSequence().equals(activeSessionBoard.getState().getSequence())) continue;
                _itemMapByLinkType = new HashMap();
                comparisonFlag = true;
                responseJson.put("sessionBoardItems", this.processDataBasedOnState(stateItems, sessionBoard, teamsMapById, containerMapById, issueTypeMapByIds, sessionBoardData, comparisonFlag, _itemMapByLinkType));
            }
            responseJson.put("sessionBoardStateArray", boardStateMap.get("sessionBoardStateArray"));
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            responseJson.put("done", true);
            return null;
        }
    }

    private Item createItemSmartForReport(DBObject vo, Map<String, TeamContainer> teamContainerData, Map<String, String> statusMapById, List<Object> allStatuses, Map<String, String> itemLinkMapById, List<String> itemLinks, Map<String, String> jiraLinkMapById, List<String> jiraLinks, Map<String, Team> teamMapById, Map<String, Container> containerMapById, Map<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (DBRef tcRef : teamContainersRef) {
                TeamContainer teamContainer = teamContainerData.get(tcRef.getId().toString());
                if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                if (PropertyValidator.isValid((Object)teamContainer.getTeam())) {
                    Team team = teamMapById.get(teamContainer.getTeam().getId());
                    teamContainer.setTeam(team);
                }
                if (PropertyValidator.isValid((Object)teamContainer.getContainer())) {
                    Container container = containerMapById.get(teamContainer.getContainer().getId());
                    teamContainer.setContainer(container);
                }
                if (!PropertyValidator.isValid((Object)teamContainer.getTeam()) || !PropertyValidator.isValid((Object)teamContainer.getTeam().getId()) || !PropertyValidator.isValid((Object)teamContainer.getContainer()) || !PropertyValidator.isValid((Object)teamContainer.getContainer().getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        List jiraLinkTypesRef = (List)vo.get("linkTypes");
        if (PropertyValidator.isValid((Collection)jiraLinkTypesRef)) {
            jiraLinkTypesRef.forEach(linkRef -> {
                JiraIssueLinkType link = new JiraIssueLinkType(linkRef);
                _jiraLinkTypes.add(link);
            });
        }
        return new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, _jiraLinkTypes);
    }

    private Item createItemForReport(DBObject vo, HashMap<String, String> statusMapById, ArrayList<Object> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        List jiraLinkTypesRef = (List)vo.get("linkTypes");
        if (PropertyValidator.isValid((Collection)jiraLinkTypesRef)) {
            jiraLinkTypesRef.forEach(linkRef -> {
                JiraIssueLinkType link = new JiraIssueLinkType(linkRef);
                _jiraLinkTypes.add(link);
            });
        }
        return new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, _jiraLinkTypes);
    }

    public Item updateTeamContainer(Item item) {
        return null;
    }

    public boolean unlinkBacklogItemsFromBoard(String boardId, String artId, List<String> backlogItemsIds) {
        ArrayList backlogItemsToRemove = new ArrayList();
        try {
            Board board = this.boardRepository.findByIdOrKey(boardId, boardId);
            if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid((Collection)board.getLinkedBacklogItems()) && PropertyValidator.isValid(backlogItemsIds)) {
                backlogItemsToRemove.addAll(board.getLinkedBacklogItems().stream().filter(backlogItemsIds::contains).collect(Collectors.toList()));
            }
            if (PropertyValidator.isValid(backlogItemsToRemove)) {
                LOGGER.info("removing items from board : {}", backlogItemsToRemove);
                board.getLinkedBacklogItems().removeAll(backlogItemsToRemove);
                this.boardRepository.save((Object)board);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return false;
        }
        return true;
    }

    public Map<String, Object> createDataForRoadmapsProgress(Map<String, Object> requestStr) throws Exception {
        boolean errorCase;
        LocalDate localDate;
        String dateString;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String interval = "";
        Date startDate = null;
        Date endDate = null;
        String roadMapId = "";
        String progressCriteria = "";
        String releaseTrainId = "";
        String itemsSelection = "planned";
        String hierachLevel = "0";
        String requestId = "";
        String type = null;
        String itemType = null;
        String groupBy = "-1";
        String groupValueType = "";
        String optionType = "";
        Map filters = new HashMap();
        List backlogItemsIds = new ArrayList();
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("progressCriteria"))) {
            progressCriteria = (String)requestStr.get("progressCriteria");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("roadMapId"))) {
            roadMapId = (String)requestStr.get("roadMapId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("releaseTrainId"))) {
            releaseTrainId = (String)requestStr.get("releaseTrainId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("itemsSelection"))) {
            itemsSelection = (String)requestStr.get("itemsSelection");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("hierachLevel"))) {
            hierachLevel = (String)requestStr.get("hierachLevel");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("requestId"))) {
            requestId = (String)requestStr.get("requestId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("type"))) {
            type = (String)requestStr.get("type");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("itemType"))) {
            itemType = (String)requestStr.get("itemType");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("groupBy"))) {
            groupBy = (String)requestStr.get("groupBy");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("groupValueType"))) {
            groupValueType = (String)requestStr.get("groupValueType");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("optionType"))) {
            optionType = (String)requestStr.get("optionType");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("filters"))) {
            filters = (Map)requestStr.get("filters");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("backlogItemIds"))) {
            backlogItemsIds = (List)requestStr.get("backlogItemIds");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("startDate"))) {
            dateString = (String)requestStr.get("startDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfPreviousDay = localDate.atTime(LocalTime.MIN);
            startDate = Date.from(dateTimeAtEndOfPreviousDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (PropertyValidator.isValid((Object)requestStr.get("endDate"))) {
            dateString = (String)requestStr.get("endDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfCurrentDay = localDate.atTime(LocalTime.MAX);
            endDate = Date.from(dateTimeAtEndOfCurrentDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        Date today = new Date();
        if (!PropertyValidator.isValid(startDate) || !PropertyValidator.isValid(endDate) || endDate.before(startDate) || startDate.after(today)) {
            resultMap.put("errorCase", true);
            return resultMap;
        }
        TimeSeriesSyncStatus baseItemSyncStatus = this.timeSeriesSyncStatusRepository.findByItemType("baseItem");
        Date syncDate = null;
        if (null != baseItemSyncStatus) {
            syncDate = baseItemSyncStatus.getCreatedOn();
            if (startDate.before(syncDate) && endDate.after(syncDate)) {
                startDate = syncDate;
            }
        } else {
            syncDate = startDate;
        }
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        List intervalDates = timeSeriesUtils.divideIntervals(startDate, endDate, interval);
        startDate = (Date)intervalDates.get(0);
        endDate = (Date)intervalDates.get(intervalDates.size() - 1);
        Map timeSeriesDataMap = this.timeSeriesRepository.getItemsForRoadMapProgress(interval, startDate, endDate, intervalDates, syncDate, roadMapId, progressCriteria, releaseTrainId, backlogItemsIds, itemsSelection, hierachLevel, requestId, filters, type, itemType, groupBy, groupValueType, optionType);
        Map itemKeys = (Map)timeSeriesDataMap.get("itemKeys");
        Map itemTitles = (Map)timeSeriesDataMap.get("itemTitles");
        Map itemColors = (Map)timeSeriesDataMap.get("itemColors");
        Map itemData = (Map)timeSeriesDataMap.get("datedBaseItemsMap");
        if (timeSeriesDataMap.containsKey("errorCase") && (errorCase = ((Boolean)timeSeriesDataMap.get("errorCase")).booleanValue())) {
            resultMap.put("errorCase", errorCase);
            return resultMap;
        }
        HashSet<String> attachedReleaseTrains = new HashSet<String>();
        attachedReleaseTrains.add(releaseTrainId);
        Map datedProgressMap = this.timeSeriesRepository.calculateProgressForRoadMaps(itemData, progressCriteria, intervalDates, roadMapId, attachedReleaseTrains);
        Map progressMap = (Map)datedProgressMap.get("datedProgressMap");
        Map seriesMap = timeSeriesUtils.getSeriesForRoadmaps(progressMap, roadMapId, intervalDates);
        Map series = (Map)seriesMap.get("series");
        resultMap.put("progress", datedProgressMap);
        resultMap.put("errorCase", false);
        resultMap.put("intervals", interval);
        resultMap.put("series", series);
        resultMap.put("itemIdsMap", itemKeys);
        resultMap.put("itemTitlesMap", itemTitles);
        resultMap.put("itemColorsMap", itemColors);
        resultMap.put("intervalDates", intervalDates);
        return resultMap;
    }
}

