/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.api.dto.RoadmapSectionDTO;
import com.viztrend.safe.api.dto.SequenceManagerDTO;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.RoadmapSectionRepository;
import com.viztrend.safe.service.RTItemOperationsService;
import com.viztrend.safe.service.RoadmapSectionService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.SequenceUtils;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="roadmapSectionService")
public class RoadmapSectionServiceImpl
implements RoadmapSectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoadmapSectionServiceImpl.class);
    private final BoardRepository boardRepository;
    private RoadmapSectionRepository roadmapSectionRepository;
    private RTItemOperationsService rtItemOperationsService;

    @Autowired
    public RoadmapSectionServiceImpl(RoadmapSectionRepository roadmapSectionRepository, RTItemOperationsService rtItemOperationsService, BoardRepository boardRepository) {
        this.roadmapSectionRepository = roadmapSectionRepository;
        this.rtItemOperationsService = rtItemOperationsService;
        this.boardRepository = boardRepository;
    }

    public List<RoadmapSection> getRoadmapSections(String roadmapId) {
        return this.roadmapSectionRepository.findByParentRoadmapId(roadmapId);
    }

    public RoadmapSection addRoadmapSection(@NotNull RoadmapSection roadmapSection) {
        return (RoadmapSection)this.roadmapSectionRepository.save((Object)roadmapSection);
    }

    public RoadmapSection updateRoadmapSection(RoadmapSectionDTO roadmapSectionDto) {
        RoadmapSection latestRoadmapSection = this.roadmapSectionRepository.findById(roadmapSectionDto.getId());
        if (latestRoadmapSection == null) {
            throw new KendisException("Roadmap section not found");
        }
        return (RoadmapSection)this.roadmapSectionRepository.save((Object)roadmapSectionDto.updateEntity(latestRoadmapSection));
    }

    public void deleteRoadmapSection(String roadmapSectionId) {
        RoadmapSection roadmapSection = this.roadmapSectionRepository.findById(roadmapSectionId);
        if (roadmapSection == null) {
            throw new KendisException("Roadmap section not found");
        }
        roadmapSection.setArchive(true);
        this.roadmapSectionRepository.save((Object)roadmapSection);
        this.rtItemOperationsService.removeSectionRelation(roadmapSectionId);
    }

    public RoadmapSection updateRoadmapSectionSequence(SequenceManagerDTO sequenceManagerDTO) {
        if (!PropertyValidator.isValid((Object)sequenceManagerDTO.getNextObjectId()) && !PropertyValidator.isValid((Object)sequenceManagerDTO.getPrevObjectId())) {
            throw new KendisException("Invalid sequence manager object");
        }
        RoadmapSection roadmapSectionReordered = this.roadmapSectionRepository.findById(sequenceManagerDTO.getModifiedObjectId());
        if (roadmapSectionReordered == null) {
            throw new KendisException("Roadmap section not found");
        }
        if (PropertyValidator.isValid((Object)sequenceManagerDTO.getPrevObjectId()) && PropertyValidator.isValid((Object)sequenceManagerDTO.getNextObjectId())) {
            RoadmapSection prevRoadmapSection = this.roadmapSectionRepository.findById(sequenceManagerDTO.getPrevObjectId());
            RoadmapSection nextRoadmapSection = this.roadmapSectionRepository.findById(sequenceManagerDTO.getNextObjectId());
            if (prevRoadmapSection == null || nextRoadmapSection == null) {
                throw new KendisException("Roadmap section not found");
            }
            roadmapSectionReordered.setSequence(Double.valueOf(SequenceUtils.generateSequenceOnReorder((Double)prevRoadmapSection.getSequence(), (Double)nextRoadmapSection.getSequence())));
        } else if (PropertyValidator.isValid((Object)sequenceManagerDTO.getPrevObjectId())) {
            RoadmapSection prevRoadmapSection = this.roadmapSectionRepository.findById(sequenceManagerDTO.getPrevObjectId());
            if (prevRoadmapSection == null) {
                throw new KendisException("Roadmap section not found");
            }
            roadmapSectionReordered.setSequence(Double.valueOf(SequenceUtils.generateSequenceOnReorder((Double)prevRoadmapSection.getSequence(), null)));
        } else if (PropertyValidator.isValid((Object)sequenceManagerDTO.getNextObjectId())) {
            RoadmapSection nextRoadmapSection = this.roadmapSectionRepository.findById(sequenceManagerDTO.getNextObjectId());
            if (nextRoadmapSection == null) {
                throw new KendisException("Roadmap section not found");
            }
            roadmapSectionReordered.setSequence(Double.valueOf(SequenceUtils.generateSequenceOnReorder(null, (Double)nextRoadmapSection.getSequence())));
        }
        this.roadmapSectionRepository.save((Object)roadmapSectionReordered);
        return roadmapSectionReordered;
    }

    public Object addRoadmapSectionAtLast(RoadmapSection roadmapSection) {
        RoadmapSection lastRoadmapSection = this.roadmapSectionRepository.findFirstByParentRoadmapIdOrderBySequenceDesc(roadmapSection.getParentRoadmapId());
        if (lastRoadmapSection == null) {
            roadmapSection.setSequence(Double.valueOf(1.0));
        } else {
            roadmapSection.setSequence(Double.valueOf(lastRoadmapSection.getSequence() + 1.0));
        }
        return this.roadmapSectionRepository.save((Object)roadmapSection);
    }

    public void createDefaultSection(String roadmapId) {
        if (this.isDefaultSectionExist(roadmapId)) {
            return;
        }
        String defaultSectionName = "Planned Items";
        Board roadmapBoard = this.boardRepository.findByIdOrKey(roadmapId, Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)roadmapBoard) && PropertyValidator.isValid((Object)roadmapBoard.getFilterCriteria()) && PropertyValidator.isValid((Object)roadmapBoard.getFilterCriteria().getName())) {
            defaultSectionName = roadmapBoard.getFilterCriteria().getName();
        }
        RoadmapSection defaultSection = new RoadmapSection();
        defaultSection.setParentRoadmapId(roadmapId);
        defaultSection.setName(defaultSectionName);
        defaultSection.setColor("#3DC198");
        defaultSection.setSequence(Double.valueOf(0.0));
        defaultSection.setDefaultSection(Boolean.valueOf(true));
        this.roadmapSectionRepository.save((Object)defaultSection);
    }

    public boolean isDefaultSectionExist(String roadmapId) {
        return PropertyValidator.isValid((Object)this.roadmapSectionRepository.findByParentRoadmapIdAndIsDefaultSectionTrue(roadmapId));
    }
}

