/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.RiskImpact;
import com.viztrend.safe.persistence.entity.RiskMatrix;
import com.viztrend.safe.persistence.entity.RiskProbability;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.repository.RiskMatrixRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.service.RiskAPIService;
import com.viztrend.safe.service.RiskApiServiceV1;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="RiskApiServiceV1")
@Transactional
public class RiskApiServiceV1Impl
implements RiskApiServiceV1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskApiServiceV1Impl.class);
    @Autowired
    private RiskAPIService riskAPIService;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private RiskMatrixRepository riskMatrixRepository;
    @Autowired
    private StatusRepository statusRepository;

    public HashMap<String, Object> getListOfRiskRegister(String fields, String expand, int startAt, int pageLimit) throws Exception {
        LOGGER.debug("Fetching risk registers list - startAt: {}, pageLimit: {}, fields: {}", new Object[]{startAt, pageLimit, fields});
        HashMap response = this.riskAPIService.getListOfRiskRegister(fields, expand, startAt, pageLimit);
        LOGGER.debug("Old service returned response: {}", (Object)response);
        if (response == null || response.isEmpty()) {
            LOGGER.warn("Old service returned null or empty response");
            LinkedHashMap<String, Object> emptyResponse = new LinkedHashMap<String, Object>();
            emptyResponse.put("Data", new ArrayList());
            emptyResponse.put("startAt", startAt);
            emptyResponse.put("pageLimit", pageLimit);
            emptyResponse.put("total", 0);
            return emptyResponse;
        }
        LinkedHashMap<String, Object> v1Response = new LinkedHashMap<String, Object>();
        v1Response.put("Data", response.get("data"));
        v1Response.put("startAt", response.get("startAt"));
        v1Response.put("pageLimit", response.get("pageLimit"));
        v1Response.put("total", response.get("total"));
        LOGGER.debug("V1 response: {}", v1Response);
        return v1Response;
    }

    public HashMap<String, Object> getRiskRegisterByIdOrKey(String registerIdOrKey, String fields, String expand) throws Exception {
        LOGGER.debug("Fetching risk register by ID or key: {}, fields: {}", (Object)registerIdOrKey, (Object)fields);
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)registerIdOrKey));
            if (PropertyValidator.isValid((Object)riskRegister)) {
                LinkedHashMap<String, Object> registerData = new LinkedHashMap<String, Object>();
                registerData.put("id", riskRegister.getId());
                registerData.put("key", riskRegister.getRegisterKey());
                registerData.put("title", riskRegister.getRegisterName());
                if (PropertyValidator.isValid((Object)riskRegister.getStatus())) {
                    HashMap<String, String> statusData = new HashMap<String, String>();
                    statusData.put("id", riskRegister.getStatus().getId());
                    statusData.put("status", riskRegister.getStatus().getTitle());
                    registerData.put("status", statusData);
                }
                registerData.put("createdBy", riskRegister.getCreatedBy());
                registerData.put("updatedBy", riskRegister.getUpdatedBy());
                registerData.put("createdOn", riskRegister.getCreatedOn());
                registerData.put("updatedOn", riskRegister.getUpdatedOn());
                responseJson.put("Data", registerData);
            } else {
                responseJson.put("Data", new HashMap());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching risk register by ID or key: {}", (Object)registerIdOrKey, (Object)e);
            throw e;
        }
        return responseJson;
    }

    public HashMap<String, Object> getRiskRegisterMetadata(String registerId) throws Exception {
        LOGGER.debug("Fetching metadata for risk register: {}", (Object)registerId);
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> metadataData = new LinkedHashMap<String, Object>();
        try {
            RiskMatrix riskMatrix;
            List statuses;
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)registerId));
            if (!PropertyValidator.isValid((Object)riskRegister)) {
                LOGGER.warn("Risk register not found: {}", (Object)registerId);
                responseJson.put("Data", new HashMap());
                return responseJson;
            }
            if (PropertyValidator.isValid((Object)riskRegister.getWorkflow()) && PropertyValidator.isValid((Collection)(statuses = this.statusRepository.findByWorkFlow(riskRegister.getWorkflow())))) {
                Iterator statusList = new ArrayList();
                for (Status status : statuses) {
                    HashMap<String, String> statusData = new HashMap<String, String>();
                    statusData.put("id", status.getId());
                    statusData.put("title", status.getTitle());
                    statusData.put("category", status.getCategory());
                    statusData.put("color", status.getColor());
                    statusList.add(statusData);
                }
                metadataData.put("statuses", statusList);
            }
            if (PropertyValidator.isValid((Collection)riskRegister.getImpactList())) {
                ArrayList impactLevels = new ArrayList();
                for (RiskImpact impact : riskRegister.getImpactList()) {
                    HashMap<String, String> impactData = new HashMap<String, String>();
                    impactData.put("id", impact.getId());
                    impactData.put("title", impact.getTitle());
                    impactData.put("code", impact.getCode());
                    impactLevels.add(impactData);
                }
                metadataData.put("impactLevels", impactLevels);
            }
            if (PropertyValidator.isValid((Collection)riskRegister.getProbabilityList())) {
                ArrayList probabilityLevels = new ArrayList();
                for (RiskProbability probability : riskRegister.getProbabilityList()) {
                    HashMap<String, String> probabilityData = new HashMap<String, String>();
                    probabilityData.put("id", probability.getId());
                    probabilityData.put("title", probability.getTitle());
                    probabilityData.put("code", probability.getCode());
                    probabilityLevels.add(probabilityData);
                }
                metadataData.put("probabilityLevels", probabilityLevels);
            }
            if (PropertyValidator.isValid((Object)riskRegister.getRiskMatrix()) && PropertyValidator.isValid((Object)(riskMatrix = (RiskMatrix)this.riskMatrixRepository.findOne((Serializable)((Object)riskRegister.getRiskMatrix().getId()))))) {
                HashMap<String, Object> riskMatrixData = new HashMap<String, Object>();
                riskMatrixData.put("id", riskMatrix.getId());
                riskMatrixData.put("name", riskMatrix.getTitle());
                if (PropertyValidator.isValid((Collection)riskMatrix.getRiskLevelList())) {
                    ArrayList riskLevels = new ArrayList();
                    riskMatrix.getRiskLevelList().forEach(level -> {
                        HashMap<String, Object> levelData = new HashMap<String, Object>();
                        levelData.put("level", level.getTitle());
                        levelData.put("lowerLimit", level.getLowerLimit());
                        levelData.put("upperLimit", level.getUpperLimit());
                        levelData.put("color", level.getColor());
                        riskLevels.add(levelData);
                    });
                    riskMatrixData.put("riskLevels", riskLevels);
                }
                metadataData.put("riskMatrix", riskMatrixData);
            }
            responseJson.put("Data", metadataData);
            LOGGER.debug("Successfully fetched metadata for risk register: {}", (Object)registerId);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching metadata for risk register: {}", (Object)registerId, (Object)e);
            throw e;
        }
        return responseJson;
    }

    public HashMap<String, Object> getRiskRegisterLinkedBoards(String riskRegisterId, int startAt, int pageLimit) throws Exception {
        LOGGER.debug("Fetching linked boards for risk register: {}, startAt: {}, pageLimit: {}", new Object[]{riskRegisterId, startAt, pageLimit});
        HashMap response = this.riskAPIService.getRiskRegisterLinkedBoards(riskRegisterId, startAt, pageLimit);
        LinkedHashMap<String, Object> v1Response = new LinkedHashMap<String, Object>();
        v1Response.put("Data", response.get("data"));
        v1Response.put("startAt", response.get("startAt"));
        v1Response.put("pageLimit", response.get("pageLimit"));
        v1Response.put("total", response.get("total"));
        return v1Response;
    }

    public HashMap<String, Object> getListOfRiskByRiskRegister(String riskRegisterId, String fields, String expand, int startAt, int pageLimit) throws Exception {
        LOGGER.debug("Fetching risks for register: {}, startAt: {}, pageLimit: {}, fields: {}", new Object[]{riskRegisterId, startAt, pageLimit, fields});
        HashMap response = this.riskAPIService.getListOfRiskByRiskRegister(riskRegisterId, fields, expand, startAt, pageLimit);
        LinkedHashMap<String, Object> v1Response = new LinkedHashMap<String, Object>();
        v1Response.put("Data", response.get("data"));
        v1Response.put("startAt", response.get("startAt"));
        v1Response.put("pageLimit", response.get("pageLimit"));
        v1Response.put("total", response.get("total"));
        return v1Response;
    }

    public HashMap<String, Object> getRiskById(String id, String fields, String expand) throws Exception {
        LOGGER.debug("Fetching risk by ID: {}, fields: {}", (Object)id, (Object)fields);
        HashMap response = this.riskAPIService.getRiskById(id, fields, expand);
        if (response.containsKey("data")) {
            LinkedHashMap<String, Object> v1Response = new LinkedHashMap<String, Object>();
            v1Response.put("Data", response.get("data"));
            return v1Response;
        }
        return response;
    }

    public HashMap<String, Object> getRiskRegisterLinkToTheBoard(String activeSessionId, String fields, String expand) throws Exception {
        LOGGER.debug("Fetching risk register for board: {}, fields: {}", (Object)activeSessionId, (Object)fields);
        HashMap response = this.riskAPIService.getRiskRegisterLinkToTheBoard(activeSessionId, fields, expand);
        if (response.containsKey("data")) {
            LinkedHashMap<String, Object> v1Response = new LinkedHashMap<String, Object>();
            v1Response.put("Data", response.get("data"));
            return v1Response;
        }
        return response;
    }
}

