/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.FilterCriteriaRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSPreferencesRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.RTTfsMetaService;
import com.viztrend.safe.service.RTTfsMetaServiceImpl;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.TfsProjectWorkflowService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component(value="RTTfsMetaService")
public class RTTfsMetaServiceImpl
implements RTTfsMetaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTTfsMetaServiceImpl.class);
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private FilterCriteriaRepository filterCriteriaRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TfsProjectWorkflowService tfsProjectWorkflowService;
    @Autowired
    private TFSPreferencesRepository tfsPreferencesRepository;

    public String loadTfsProjects(String almId) {
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        String tfsProjects = this.tfSservice.fetchTFSProjects(almAccount);
        return tfsProjects;
    }

    public Map<String, Object> linkTfsProject(String projectId, String almId, String metaMap, String syncId, String releaseTrainKey) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TFSProject tfsProject = this.tfsProjectRepository.findByAlmIdAndTfsId(almId, projectId);
        if (PropertyValidator.isValid((Object)tfsProject)) {
            if (PropertyValidator.isValid((Collection)tfsProject.getLinkedWorkspaceKeys()) && tfsProject.getLinkedWorkspaceKeys().contains(releaseTrainKey)) {
                result.put("success", false);
                result.put("reason", "AlreadyExist");
            } else {
                if ((tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)tfsProject.getId()))).getLinkedWorkspaceKeys() == null) {
                    tfsProject.setLinkedWorkspaceKeys(new ArrayList());
                }
                tfsProject.getLinkedWorkspaceKeys().add(releaseTrainKey);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)tfsProject.getId()));
                Update update = new Update();
                update.set("linkedWorkspaceKeys", (Object)tfsProject.getLinkedWorkspaceKeys());
                this.mongoTemplate.updateMulti(query, update, TFSProject.class);
                WorkFlow workFlow = this.workFlowRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
                List statuses = this.statusRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
                workFlow.setStatuses(statuses);
                tfsProject.setWorkFlow(workFlow);
                result.put("project", tfsProject);
                result.put("success", true);
                result.put("action", "projectLinked");
            }
            return result;
        }
        try {
            TFSProject tfsProjectNew = this.tfSservice.linkTFSProjectsWithAlm(projectId, almId, null);
            WorkFlow worlflow = this.tfsProjectWorkflowService.createWorkflowForProject(tfsProjectNew, almId);
            tfsProjectNew.setWorkFlow(worlflow);
            ArrayList<String> key = new ArrayList<String>();
            key.add(releaseTrainKey);
            tfsProjectNew.setLinkedWorkspaceKeys(key);
            this.tfsProjectRepository.save((Object)tfsProjectNew);
            result.put("success", true);
            result.put("project", tfsProjectNew);
            return result;
        }
        catch (Exception e2) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", e2);
            return result;
        }
    }

    public Map<String, Object> resyncTfsProject(Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tfsProjectId = (String)params.get("tfsProjectId");
        String metaMap = (String)params.get("metaMap");
        String syncId = (String)params.get("syncId");
        String almId = (String)params.get("almId");
        boolean resetStatusCategory = false;
        if (params.containsKey("resetStatusCategory")) {
            resetStatusCategory = (Boolean)params.get("resetStatusCategory");
        }
        try {
            TFSProject tfsProject = this.tfsProjectRepository.findByAlmIdAndTfsId(almId, tfsProjectId);
            TFSProject tfsProjectNew = this.tfSservice.linkTFSProjectsWithAlm(tfsProjectId, almId, tfsProject);
            if (resetStatusCategory) {
                this.tfsPreferencesRepository.deleteByTfsProjectIdAndAlmId(tfsProjectId, almId);
            }
            WorkFlow workFlow = this.tfsProjectWorkflowService.updateWorkflowForProject(tfsProjectNew, almId);
            tfsProjectNew.setWorkFlow(workFlow);
            this.tfsProjectRepository.save((Object)tfsProjectNew);
            result.put("success", true);
            result.put("project", tfsProjectNew);
            return result;
        }
        catch (ViztrendJiraException e2) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e2);
            return result;
        }
        catch (Exception e) {
            result.put("success", false);
            return result;
        }
    }

    public Map<String, Object> deleteTfsProject(String projectId, String almId, String metaMap, String syncId, String workspaceKey) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            TFSProject tfsProject = this.tfsProjectRepository.findByAlmIdAndTfsId(almId, projectId);
            if (PropertyValidator.isValid((Object)tfsProject) && tfsProject.getLinkedWorkspaceKeys().contains(workspaceKey)) {
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.and("fields.tfsProjectId").is((Object)projectId);
                query.addCriteria((CriteriaDefinition)criteria);
                int itemCount = this.mongoTemplate.getCollection("backlogItem").find(query.getQueryObject()).count();
                if (itemCount > 0) {
                    result.put("success", false);
                    result.put("error", "item exist for the project");
                } else {
                    tfsProject.getLinkedWorkspaceKeys().remove(workspaceKey);
                    if (tfsProject.getLinkedWorkspaceKeys().size() == 0) {
                        this.statusRepository.deleteByTfsProjectIdAndAlmId(projectId, almId);
                        this.workFlowRepository.deleteByTfsProjectIdAndAlmId(projectId, almId);
                        this.workFlowItemTypeRepository.deleteByTfsProjectIdAndAlmId(projectId, almId);
                        this.tfsProjectRepository.deleteByTfsIdAndAlmId(projectId, almId);
                    } else {
                        query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)tfsProject.getId()));
                        Update update = new Update();
                        update.set("linkedWorkspaceKeys", (Object)tfsProject.getLinkedWorkspaceKeys());
                        this.mongoTemplate.updateMulti(query, update, TFSProject.class);
                    }
                    result.put("success", true);
                    result.put("projectId", projectId);
                }
            }
            return result;
        }
        catch (ViztrendJiraException e2) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e2);
            return result;
        }
    }

    public Map<String, Object> getTfsProcess(String almAccountId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            if (PropertyValidator.isValid((Object)almAccount)) {
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                result.put("tfsProcessStr", this.tfsUtils.getTFSProcess(almAccount));
                result.put("success", true);
            }
        }
        catch (ViztrendJiraException e) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAllTFSFields(String almAccountId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            if (PropertyValidator.isValid((Object)almAccount)) {
                result.put("tfsFieldsStr", this.tfsUtils.getAllFields(almAccount));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Map<String, Object> getTfsProcessWorkItemType(String payload) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)payload)) {
                Gson g = new Gson();
                1 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
                String processId = (String)requestBody.get("processId");
                String almAccountId = (String)requestBody.get("almAccountId");
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
                result.put("tfsProcessWorkItemTypesStr", this.tfsUtils.getTFSProcessWorkItemTypes(almAccount, processId));
                result.put("success", true);
            }
        }
        catch (ViztrendJiraException e) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<TFSProject> fetchLinkedTfsProjects(String almId, String releaseTrainKey) {
        ArrayList<TFSProject> tfsProjects = new ArrayList<TFSProject>();
        List projects = this.tfsProjectRepository.findByAlmIdAndLinkedWorkspaceKeysIn(almId, releaseTrainKey);
        if (PropertyValidator.isValid((Collection)projects)) {
            for (TFSProject project : projects) {
                WorkFlow workFlow = this.workFlowRepository.findByTfsProjectIdAndAlmId(project.getTfsId(), almId);
                List statuses = this.statusRepository.findByTfsProjectIdAndAlmId(project.getTfsId(), almId);
                workFlow.setStatuses(statuses);
                project.setWorkFlow(workFlow);
                tfsProjects.add(project);
            }
        }
        return tfsProjects;
    }
}

