/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.internal.LinkedTreeMap;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.api.dto.BacklogGroupItemsInfoDTO;
import com.viztrend.safe.api.dto.RTFetchServiceRequestDTO;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.persistence.querytools.PlannedIterationPathOrDatesFilterQueryFactory;
import com.viztrend.safe.persistence.querytools.UnplannedIterationPathOrDatesFilterQueryFactory;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.RoadmapSectionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="RTItemFetchService")
public class RTItemFetchServiceImpl
implements RTItemFetchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTItemFetchServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private RoadmapSectionRepository roadmapSectionRepository;
    @Autowired
    private PlannedIterationPathOrDatesFilterQueryFactory plannedIterationPathOverDatesFilterQueryFactory;
    @Autowired
    private UnplannedIterationPathOrDatesFilterQueryFactory unplannedIterationPathOrDatesFilterQueryFactory;
    @Autowired
    private CustomRepositoryImpl customRepositoryImpl;

    public Map<String, Object> searchBacklogItems(HashMap<String, Object> params) {
        String searchText = (String)params.get("searchText");
        String almId = (String)params.get("almId");
        String backlogLevelStr = (String)params.get("backlogLevel");
        String releaseTrainId = (String)params.get("releaseTrainId");
        boolean allFields = false;
        if (params.containsKey("allFields")) {
            allFields = (Boolean)params.get("allFields");
        }
        boolean excludeAlmKey = false;
        boolean excludeTitle = false;
        if (params.containsKey("excludeAlmKey")) {
            excludeAlmKey = (Boolean)params.get("excludeAlmKey");
        }
        if (params.containsKey("excludeTitle")) {
            excludeTitle = (Boolean)params.get("excludeTitle");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        query.addCriteria((CriteriaDefinition)tenantCriteria);
        if (PropertyValidator.isValid((Object)almId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)almId));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.artRelation(releaseTrainId) + ".releaseTrainId")).is((Object)releaseTrainId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.artRelation(releaseTrainId) + ".backlogLevel")).is((Object)Integer.parseInt(backlogLevelStr)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.artRelation(releaseTrainId) + ".rowStatus")).is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        String options = "i";
        Criteria searchCriteria = null;
        if (excludeAlmKey) {
            searchCriteria = Criteria.where((String)"title").regex(searchText, options);
            query.addCriteria((CriteriaDefinition)searchCriteria);
        } else if (excludeTitle) {
            searchCriteria = Criteria.where((String)"almKey").regex(searchText, options);
            query.addCriteria((CriteriaDefinition)searchCriteria);
        } else {
            searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchText, options), Criteria.where((String)"almKey").regex(searchText, options)});
            query.addCriteria((CriteriaDefinition)searchCriteria);
        }
        if (!allFields) {
            query.fields().include("almKey");
            query.fields().include("id");
            query.fields().include("title");
            query.fields().include("almItemId");
        }
        List items = this.mongoTemplate.find(query, BacklogItem.class);
        result.put("items", items);
        return result;
    }

    public Map<String, Object> getBacklogItems(HashMap<String, Object> params) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        String releaseTrainId = (String)params.get("releaseTrainId");
        ArrayList itemIds = (ArrayList)params.get("itemIds");
        Boolean fetchParents = (Boolean)params.get("fetchParents");
        if (fetchParents == null) {
            fetchParents = false;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList itemIdsObj = new ArrayList();
        itemIds.forEach(_id -> itemIdsObj.add(new ObjectId(_id)));
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        BasicDBObject basicMatch = new BasicDBObject();
        basicMatch.append("_id", (Object)new BasicDBObject("$in", itemIdsObj));
        basicMatch.append("tenant", (Object)tenant);
        BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)basicMatch);
        pipelines.add(finalMatchPipeline);
        pipelines.addAll(this.getRollupPipeline(releaseTrainId, params));
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        Cursor dbCursor = collection.aggregate(pipelines, ao);
        ArrayList<DBObject> items = new ArrayList<DBObject>();
        HashMap parentMap = new HashMap();
        while (dbCursor.hasNext()) {
            DBObject item = (DBObject)dbCursor.next();
            this.formatItemDbObject(item);
            items.add(item);
            if (!fetchParents.booleanValue()) continue;
            this.putItemParentInMap(releaseTrainId, item, parentMap);
        }
        if (!parentMap.isEmpty()) {
            List parents = this.backlogItemRepository.findParentsByIdIn(parentMap.keySet());
            result.put("parents", parents);
        }
        result.put("items", items);
        return result;
    }

    public Map<String, Object> getBatchItemsCompletion(HashMap<String, Object> params) {
        List baseItemLinks = (List)params.get("baseItemLinks");
        ArrayList<ObjectId> itemIdsObj = new ArrayList<ObjectId>();
        HashMap<String, ArrayList<String>> releaseTrainsByItemId = new HashMap<String, ArrayList<String>>();
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (Map link : baseItemLinks) {
                String releaseTrainId = (String)link.get("releaseTrainId");
                String baseItemId = (String)link.get("baseItemId");
                itemIdsObj.add(new ObjectId(baseItemId));
                ArrayList<String> rts = (ArrayList<String>)releaseTrainsByItemId.get(baseItemId);
                if (rts == null) {
                    rts = new ArrayList<String>();
                    rts.add(releaseTrainId);
                    releaseTrainsByItemId.put(baseItemId, rts);
                    continue;
                }
                rts.add(releaseTrainId);
            }
        }
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{"updatedBy"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsObj));
        DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("backlogItem").find(query.getQueryObject()).sort((DBObject)new BasicDBObject("updatedBy", (Object)1));
        List allItems = dbCursorPrefix.toArray();
        ArrayList<String> statusIds = new ArrayList<String>();
        HashMap<String, String> statusIdMap = new HashMap<String, String>();
        ArrayList finalItems = new ArrayList();
        for (DBObject itemData : allItems) {
            BacklogItem backlogItem = new BacklogItem();
            backlogItem.setId(String.valueOf(itemData.get("_id")));
            ArrayList releaseTrainIds = (ArrayList)releaseTrainsByItemId.get(backlogItem.getId());
            DBObject artRelationMap = (DBObject)itemData.get("artRelationMap");
            if (!PropertyValidator.isValid((Collection)releaseTrainIds)) continue;
            for (String releaseTrainId : releaseTrainIds) {
                DBObject artRelation = (DBObject)artRelationMap.get(releaseTrainId);
                if (artRelation == null || (Integer)artRelation.get("rowStatus") != 0) continue;
                if (itemData.containsField("status")) {
                    DBRef status = (DBRef)itemData.get("status");
                    String statusId = String.valueOf(status.getId());
                    Status st = new Status();
                    st.setId(statusId);
                    backlogItem.setStatus(st);
                    if (statusIdMap.get(statusId) == null) {
                        statusIdMap.put(statusId, statusId);
                        statusIds.add(statusId);
                    }
                }
                HashMap<String, String> itemEntry = new HashMap<String, String>();
                itemEntry.put("rtId", releaseTrainId);
                itemEntry.put("item", (String)backlogItem);
                finalItems.add(itemEntry);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("items", finalItems);
        if (!statusIds.isEmpty()) {
            List statuses = this.statusRepository.findStatusByIdIn(statusIds);
            result.put("statuses", statuses);
        }
        return result;
    }

    private Map<String, Object> prepareParamsForgetBacklogItemsWithLevel(int batchSize, RTFetchServiceRequestDTO requestObj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageStart", "0");
        params.put("pageSize", String.valueOf(batchSize));
        params.put("sortBy", "startDate");
        params.put("sortOrder", "1");
        params.put("boardId", String.valueOf(requestObj.getBoardId()));
        params.put("hierachLevel", String.valueOf(requestObj.getHierachLevel()));
        params.put("fetchFetchedByUser", false);
        params.put("loadStatuses", true);
        params.put("filter", requestObj.getFilter());
        return params;
    }

    private Map<String, Object> getParamsForFetchingOnlyGroups(RTFetchServiceRequestDTO requestObj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("boardId", String.valueOf(requestObj.getBoardId()));
        params.put("hierachLevel", String.valueOf(requestObj.getHierachLevel()));
        params.put("groupBy", requestObj.getGroupBy());
        params.put("fetchFetchedByUser", false);
        params.put("loadStatuses", true);
        return params;
    }

    private boolean validateResultGetBacklogGroupItems(Map<String, Object> result) {
        if (result == null || result.get("result") == null) {
            return false;
        }
        Object resultObj = result.get("result");
        if (resultObj instanceof Map) {
            Map resultitems = (Map)resultObj;
            Object itemsObj = resultitems.get("items");
            if (itemsObj instanceof List) {
                List items = (List)itemsObj;
                return PropertyValidator.isValid((Collection)items);
            }
            return false;
        }
        return false;
    }

    private boolean validateResultFromGetBacklogItemsWithLevel(Map<String, Object> result) {
        List items;
        BasicDBObject resultDbObj;
        Object itemsObj;
        if (result == null || result.get("result") == null) {
            return false;
        }
        Object resultObj = result.get("result");
        return !(resultObj instanceof BasicDBObject) || !((itemsObj = (resultDbObj = (BasicDBObject)resultObj).get("items")) instanceof List) || !(items = (List)itemsObj).isEmpty();
    }

    public void streamBacklogItems(OutputStream outputStream, RTFetchServiceRequestDTO request, String releaseTrainId, int sleepTimeMs, int batchSize) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map params = this.prepareParamsForgetBacklogItemsWithLevel(batchSize, request);
            while (true) {
                LOGGER.info("Going to Fetch items for page: " + params.get("pageStart"));
                Map result = this.getBacklogItemsWithLevel(releaseTrainId, params);
                LOGGER.info("Fetched items for page: " + params.get("pageStart"));
                if (!this.validateResultFromGetBacklogItemsWithLevel(result)) {
                    LOGGER.info("==================== Streaming Ended ===================");
                    break;
                }
                outputStream.write(objectMapper.writeValueAsBytes((Object)result));
                outputStream.flush();
                outputStream.write("\n".getBytes());
                params.put("pageStart", String.valueOf(Integer.parseInt((String)params.get("pageStart")) + Integer.parseInt((String)params.get("pageSize"))));
                Thread.sleep(sleepTimeMs);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamBacklogItemsGrouped(RTFetchServiceRequestDTO request, OutputStream outputStream) throws Exception {
        try (BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);){
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            try {
                Object lock = new Object();
                for (Object groupId : request.getBacklogGroupItemsInfo().keySet()) {
                    executorService.submit(() -> {
                        try {
                            this.processGroupId(request, bufferedStream, groupId, lock);
                        }
                        catch (Exception e) {
                            LOGGER.error("-----Error while processing groupId: " + groupId + "-----" + StringUtils.getTraceString((Throwable)e));
                        }
                    });
                }
            }
            finally {
                executorService.shutdown();
                boolean terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
                if (!terminated) {
                    LOGGER.warn("-----Executor did not terminate within the specified timeout-----");
                    executorService.shutdownNow();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupId(RTFetchServiceRequestDTO request, BufferedOutputStream bufferedStream, Object groupId, Object lock) throws Exception {
        Map params = this.prepareParams(request, groupId);
        while (true) {
            Map result;
            if (!this.validateResultGetBacklogGroupItems(result = this.fetchGroupItems(request, groupId, params))) break;
            Object object = lock;
            synchronized (object) {
                this.writeResultToStream((OutputStream)bufferedStream, result);
            }
            this.updatePageStart(params);
        }
        LOGGER.info("Streaming Ended for groupId: " + groupId);
    }

    public Map<String, Object> prepareParams(RTFetchServiceRequestDTO request, Object groupId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hierachLevel", String.valueOf(request.getHierachLevel()));
        params.put("pageStart", "0");
        params.put("pageSize", "1000");
        params.put("sortBy", "startDate");
        params.put("sortOrder", "-1");
        params.put("fetchFetchedByUser", false);
        params.put("loadStatuses", true);
        params.put("groupType", request.getGroupBy());
        params.put("groupValueType", request.getGroupValueType());
        params.put("boardId", request.getBoardId());
        params.put("filter", request.getFilter());
        params.put("optionType", request.getOptionType());
        params.put("releaseTrainId", request.getReleaseTrainId());
        if (request.getBacklogGroupItemsInfo().containsKey(groupId)) {
            if (PropertyValidator.isValid((Collection)((BacklogGroupItemsInfoDTO)request.getBacklogGroupItemsInfo().get(groupId)).getExcludeGroupIds())) {
                params.put("excludeGroupIds", ((BacklogGroupItemsInfoDTO)request.getBacklogGroupItemsInfo().get(groupId)).getExcludeGroupIds());
            }
            if (PropertyValidator.isValid((Collection)((BacklogGroupItemsInfoDTO)request.getBacklogGroupItemsInfo().get(groupId)).getGroupIds())) {
                params.put("groupIds", ((BacklogGroupItemsInfoDTO)request.getBacklogGroupItemsInfo().get(groupId)).getGroupIds());
            }
        }
        if (!"null".equals(groupId)) {
            if (groupId instanceof Integer) {
                groupId = ((Integer)groupId).doubleValue();
            }
            params.put("groupId", groupId);
        }
        return params;
    }

    public Map<String, Object> fetchGroupItems(RTFetchServiceRequestDTO request, Object groupId, Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("groupId", groupId);
        result.put("result", this.getBacklogGroupItems(request.getReleaseTrainId(), params));
        return result;
    }

    private void writeResultToStream(OutputStream outputStream, Map<String, Object> result) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        outputStream.write(objectMapper.writeValueAsBytes(result));
        outputStream.write("\n".getBytes());
        outputStream.flush();
    }

    private void updatePageStart(Map<String, Object> params) {
        int pageStart = Integer.parseInt((String)params.get("pageStart"));
        int pageSize = Integer.parseInt((String)params.get("pageSize"));
        params.put("pageStart", String.valueOf(pageStart + pageSize));
    }

    public Map<String, Object> getBacklogItemsWithLevel(String id, Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date start = new Date();
        try {
            DBObject filtersPipeline;
            boolean fetchFetchedByUser = true;
            if (params.containsKey("fetchFetchedByUser")) {
                fetchFetchedByUser = (Boolean)params.get("fetchFetchedByUser");
            }
            String hierachLevelStr = null;
            if (params.containsKey("hierachLevel")) {
                hierachLevelStr = (String)params.get("hierachLevel");
            }
            String sortBy = this.artRelation(id) + ".sequence";
            String sortOrder = "1";
            if (params.containsKey("sortBy")) {
                sortBy = (String)params.get("sortBy");
            }
            if (params.containsKey("sortOrder")) {
                sortOrder = (String)params.get("sortOrder");
            }
            String pageStartStr = null;
            String pageSizeStr = null;
            String boardId = null;
            if (params.containsKey("pageStart")) {
                pageStartStr = (String)params.get("pageStart");
            }
            if (params.containsKey("pageSize")) {
                pageSizeStr = (String)params.get("pageSize");
            }
            if (params.containsKey("boardId")) {
                boardId = (String)params.get("boardId");
            }
            boolean showManual = false;
            if (params.containsKey("showManual")) {
                showManual = (Boolean)params.get("showManual");
            }
            String groupBy = (String)params.get("groupBy");
            Boolean rollupToGroups = (Boolean)params.get("rollupToGroups");
            boolean fetchParents = false;
            if (params.containsKey("fetchParents")) {
                fetchParents = (Boolean)params.get("fetchParents");
            }
            Map filter = (Map)params.get("filter");
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
            BasicDBObject basicMatch = new BasicDBObject();
            basicMatch.append("tenant", (Object)tenant);
            basicMatch.append("rowStatus", (Object)0);
            basicMatch.append("archive", (Object)false);
            if (hierachLevelStr != null) {
                basicMatch.append(this.artRelation(id) + ".backlogLevel", (Object)Integer.parseInt(hierachLevelStr));
            }
            if (id != null && !"null".equals(id)) {
                basicMatch.append(this.artRelation(id) + ".releaseTrainId", (Object)id);
            }
            if (id != null && !"null".equals(id)) {
                if (params.containsKey("archieve")) {
                    Boolean archieve = (Boolean)params.get("archieve");
                    basicMatch.append(this.artRelation(id) + ".rowStatus", (Object)(archieve != false ? 1 : 0));
                } else {
                    basicMatch.append(this.artRelation(id) + ".rowStatus", (Object)0);
                }
            }
            BasicDBObject basicMatchPipeline = new BasicDBObject("$match", (Object)basicMatch);
            pipelines.add(basicMatchPipeline);
            Board board = null;
            ArrayList<ObjectId> itemIds = new ArrayList<ObjectId>();
            if (PropertyValidator.isValid((Object)boardId)) {
                board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
            }
            if (PropertyValidator.isValid(board)) {
                if (PropertyValidator.isValid(board) && PropertyValidator.isValid((Collection)board.getLinkedBacklogItems())) {
                    for (String itemId : board.getLinkedBacklogItems()) {
                        if (!PropertyValidator.isValid((Object)itemId)) continue;
                        itemIds.add(new ObjectId(itemId));
                    }
                }
                if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid((Collection)board.getPlannedItems())) {
                    for (String itemId : board.getPlannedItems()) {
                        if (!PropertyValidator.isValid((Object)itemId)) continue;
                        itemIds.add(new ObjectId(itemId));
                    }
                }
                BasicDBObject boardItemsMatch = new BasicDBObject("_id", (Object)new BasicDBObject("$in", itemIds));
                if (!showManual && PropertyValidator.isValid((Object)board.getFilterCriteria())) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    Map filterCriteriaMap = (Map)objectMapper.convertValue((Object)board.getFilterCriteria(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    Map criteriaMap = (Map)filterCriteriaMap.get("criteria");
                    DBObject criteriaPipeline = this.getFilterPipeline(id, criteriaMap, pipelines);
                    if (criteriaPipeline != null) {
                        BasicDBObject matchPipeline = new BasicDBObject("$match", (Object)new BasicDBObject("$or", Arrays.asList(boardItemsMatch, criteriaPipeline)));
                        pipelines.add(matchPipeline);
                    } else {
                        BasicDBObject boardItemMatchPipeline = new BasicDBObject("$match", (Object)boardItemsMatch);
                        pipelines.add(boardItemMatchPipeline);
                    }
                } else {
                    BasicDBObject boardItemMatchPipeline = new BasicDBObject("$match", (Object)boardItemsMatch);
                    pipelines.add(boardItemMatchPipeline);
                }
            }
            if ((filtersPipeline = this.getFilterPipeline(id, filter, pipelines)) != null) {
                BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)filtersPipeline);
                pipelines.add(finalMatchPipeline);
            }
            if (groupBy != null) {
                ArrayList groupByPipelines;
                if (rollupToGroups != null && rollupToGroups.booleanValue()) {
                    pipelines.addAll(this.getRollupPipeline(id, params));
                }
                if ((groupByPipelines = this.getGroupByPipeline(id, params)) != null) {
                    pipelines.addAll(groupByPipelines);
                }
            }
            boolean sortRequireRollup = sortBy.equals("totalEstimate") || sortBy.equals("childCount");
            boolean rollupAdded = false;
            if (groupBy == null) {
                if (sortRequireRollup) {
                    rollupAdded = true;
                    pipelines.addAll(this.getRollupPipeline(id, params));
                }
                pipelines.addAll(this.getSortFieldsPipeline(id, params));
            }
            ArrayList<BasicDBObject> facetMatchPipelines = new ArrayList<BasicDBObject>();
            if (pageSizeStr != null && pageStartStr != null) {
                facetMatchPipelines.add(new BasicDBObject("$skip", (Object)Integer.parseInt(pageStartStr)));
                facetMatchPipelines.add(new BasicDBObject("$limit", (Object)Integer.parseInt(pageSizeStr)));
            }
            if (groupBy == null && !rollupAdded) {
                facetMatchPipelines.addAll(this.getRollupPipeline(id, params));
            }
            BasicDBObject facetPipeline = new BasicDBObject("$facet", (Object)new BasicDBObject("pageInfo", Arrays.asList(new BasicDBObject("$count", (Object)"total"))).append("items", facetMatchPipelines));
            pipelines.add(facetPipeline);
            BasicDBObject facetProjectPipeline = BasicDBObject.parse((String)"{$project:{items:1,total:{$arrayElemAt:[\"$pageInfo.total\",0]}}}");
            pipelines.add(facetProjectPipeline);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            HashSet<String> userIdList = new HashSet<String>();
            LOGGER.info("================ QUERY for org level fetching ==== ");
            LOGGER.debug(((Object)pipelines).toString());
            try (Cursor dbCursor = collection.aggregate(pipelines, ao);){
                Date end = new Date();
                LOGGER.info("==================================================");
                LOGGER.info("\t\tQuery Time : " + (end.getTime() - start.getTime()));
                LOGGER.info("==================================================");
                boolean loadStatuses = false;
                ArrayList<String> statusIds = null;
                if (params.containsKey("loadStatuses") && (loadStatuses = ((Boolean)params.get("loadStatuses")).booleanValue())) {
                    statusIds = new ArrayList<String>();
                }
                HashMap<String, String> parentMap = new HashMap<String, String>();
                start = new Date();
                while (dbCursor.hasNext()) {
                    ArrayList newgroups;
                    List userList;
                    DBObject o = (DBObject)dbCursor.next();
                    BasicDBList itemsArray = (BasicDBList)o.get("items");
                    for (int i = 0; i < itemsArray.size(); ++i) {
                        DBObject item = (DBObject)itemsArray.get(i);
                        if (fetchFetchedByUser && item.containsField("fetchedBy")) {
                            DBRef user = (DBRef)item.get("fetchedBy");
                            userIdList.add(String.valueOf(user.getId()));
                        }
                        if (groupBy == null) {
                            this.formatItemDbObject(item);
                            if (statusIds != null && item.containsKey("status")) {
                                statusIds.add((String)((DBObject)item.get("status")).get("id"));
                            }
                            if (!fetchParents) continue;
                            this.putItemParentInMap(id, item, parentMap);
                            continue;
                        }
                        if (groupBy.equals("Parent")) {
                            DBObject _id = (DBObject)item.get("_id");
                            String parentId = String.valueOf(_id.get("id"));
                            _id.put("id", (Object)parentId);
                            parentMap.put(parentId, parentId);
                        }
                        if (!item.containsKey("groupItems")) continue;
                        BasicDBList groupItems = (BasicDBList)item.get("groupItems");
                        for (int j = 0; j < groupItems.size(); ++j) {
                            DBObject gitem = (DBObject)groupItems.get(j);
                            this.formatItemDbObject(gitem);
                            if (statusIds == null || !item.containsKey("status")) continue;
                            statusIds.add((String)((DBObject)item.get("status")).get("id"));
                        }
                    }
                    if (fetchFetchedByUser && PropertyValidator.isValid((Collection)itemsArray) && PropertyValidator.isValid(userIdList) && PropertyValidator.isValid((Collection)(userList = this.userRepository.findBasicUserInforByIdIn(userIdList)))) {
                        HashMap<String, User> userMapById = new HashMap<String, User>();
                        for (User user : userList) {
                            userMapById.put(user.getId(), user);
                        }
                        for (int i = 0; i < itemsArray.size(); ++i) {
                            DBObject item = (DBObject)itemsArray.get(i);
                            DBRef user = (DBRef)item.get("fetchedBy");
                            if (!PropertyValidator.isValid((Object)user)) continue;
                            item.put("fetchedBy", userMapById.get(String.valueOf(user.getId())));
                        }
                    }
                    if (groupBy != null && (newgroups = this.handleArchivedGroups(itemsArray, groupBy)) != null) {
                        o.put("items", (Object)newgroups);
                    }
                    result.put("result", o);
                }
                if (!parentMap.isEmpty()) {
                    List parents = this.backlogItemRepository.findParentsByIdIn(parentMap.keySet());
                    result.put("parents", parents);
                }
                if (PropertyValidator.isValid(statusIds)) {
                    List statuses = this.statusRepository.findStatusByIdIn(statusIds);
                    result.put("statuses", statuses);
                }
                end = new Date();
                LOGGER.info("==================================================");
                LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
                LOGGER.info("==================================================");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getBacklogItemsWithLevel()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private ArrayList<DBObject> handleArchivedGroups(BasicDBList itemsArray, String groupBy) throws Exception {
        block47: {
            HashMap<String, String> validgroupType = new HashMap<String, String>();
            validgroupType.put("Session", "");
            validgroupType.put("SolutionBoards", "");
            validgroupType.put("Teams", "");
            validgroupType.put("Containers", "");
            validgroupType.put("Milestones", "");
            validgroupType.put("Batches", "");
            if (validgroupType.get(groupBy) == null) {
                return null;
            }
            try {
                DBObject noGroup = null;
                ArrayList<ObjectId> groupsObjectIds = new ArrayList<ObjectId>();
                ArrayList<String> groupsStringIds = new ArrayList<String>();
                for (int i = 0; i < itemsArray.size(); ++i) {
                    String _id;
                    DBObject group = (DBObject)itemsArray.get(i);
                    DBObject _idObj = (DBObject)group.get("_id");
                    if (_idObj == null) {
                        _idObj = new BasicDBObject();
                    }
                    if ((_id = String.valueOf(_idObj.get("id"))) != null && _id.equals("null")) {
                        _idObj.put("id", null);
                        _id = null;
                    }
                    if (_id == null) {
                        noGroup = group;
                        continue;
                    }
                    try {
                        groupsObjectIds.add(new ObjectId(_id));
                        continue;
                    }
                    catch (Exception e) {
                        groupsStringIds.add(_id);
                    }
                }
                if (!PropertyValidator.isValid(groupsObjectIds) && !PropertyValidator.isValid(groupsStringIds)) break block47;
                String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
                if (PropertyValidator.isValid(groupsObjectIds) && PropertyValidator.isValid(groupsStringIds)) {
                    query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"_id").in(groupsObjectIds), Criteria.where((String)"_id").in(groupsStringIds)}));
                } else if (PropertyValidator.isValid(groupsObjectIds)) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(groupsObjectIds));
                } else if (PropertyValidator.isValid(groupsStringIds)) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(groupsStringIds));
                }
                query.fields().include("id");
                String collectionName = "";
                if (groupBy.equals("Session")) {
                    collectionName = "session";
                    query.fields().include("title");
                } else if (groupBy.equals("SolutionBoards")) {
                    collectionName = "solutionBoard";
                    query.fields().include("title");
                } else if (groupBy.equals("Teams")) {
                    collectionName = "team";
                    query.fields().include("title");
                } else if (groupBy.equals("Containers")) {
                    collectionName = "container";
                    query.fields().include("title");
                } else if (groupBy.equals("Milestones")) {
                    collectionName = "backlogItem";
                    query.fields().include("title");
                } else if (groupBy.equals("Batches")) {
                    collectionName = "baseItem";
                    query.fields().include("title");
                }
                DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection(collectionName).find(query.getQueryObject()).sort((DBObject)new BasicDBObject("updatedOn", (Object)1));
                List allItems = dbCursorPrefix.toArray();
                HashMap allItemsMapById = new HashMap();
                allItems.forEach(item -> {
                    String _id = String.valueOf(item.get("_id"));
                    allItemsMapById.put(_id, item);
                });
                HashMap<String, Boolean> noGroupItemsMapById = new HashMap<String, Boolean>();
                for (int i = 0; i < itemsArray.size(); ++i) {
                    String _id;
                    DBObject group = (DBObject)itemsArray.get(i);
                    DBObject _idObj = (DBObject)group.get("_id");
                    if (_idObj == null) {
                        _idObj = new BasicDBObject();
                    }
                    if ((_id = String.valueOf(_idObj.get("id"))) != null && _id.equals("null")) {
                        _id = null;
                    }
                    if (_id == null) {
                        if (!group.containsKey("groupItems")) continue;
                        BasicDBList groupItems = (BasicDBList)group.get("groupItems");
                        for (int j = 0; j < groupItems.size(); ++j) {
                            DBObject gitem = (DBObject)groupItems.get(j);
                            String gitemid = (String)gitem.get("id");
                            noGroupItemsMapById.put(gitemid, true);
                        }
                        continue;
                    }
                    DBObject groupDetail = (DBObject)allItemsMapById.get(_id);
                    if (!PropertyValidator.isValid((Object)groupDetail) || !group.containsKey("groupItems")) continue;
                    BasicDBList groupItems = (BasicDBList)group.get("groupItems");
                    for (int j = 0; j < groupItems.size(); ++j) {
                        DBObject gitem = (DBObject)groupItems.get(j);
                        String gitemid = (String)gitem.get("id");
                        noGroupItemsMapById.put(gitemid, true);
                    }
                }
                ArrayList<DBObject> newGroups = new ArrayList<DBObject>();
                for (int i = 0; i < itemsArray.size(); ++i) {
                    BasicDBList multiIds;
                    String groupId;
                    DBObject group = (DBObject)itemsArray.get(i);
                    DBObject idObj = (DBObject)group.get("_id");
                    if (idObj == null) {
                        idObj = new BasicDBObject();
                    }
                    if ((groupId = String.valueOf(idObj.get("id"))) != null && groupId.equals("null")) {
                        groupId = null;
                    }
                    String nogroupId = null;
                    if (groupId == null) {
                        groupId = "";
                    }
                    if (noGroup != null) {
                        DBObject idObj2 = (DBObject)noGroup.get("_id");
                        if (idObj2 == null) {
                            idObj2 = new BasicDBObject();
                        }
                        nogroupId = String.valueOf(idObj2.get("id"));
                    }
                    if (nogroupId != null && nogroupId.equals("null")) {
                        nogroupId = null;
                    }
                    if (nogroupId == null) {
                        nogroupId = "";
                    }
                    if (groupId.equals(nogroupId)) continue;
                    DBObject groupDetail = (DBObject)allItemsMapById.get(groupId);
                    if (groupDetail != null) {
                        idObj.put("title", groupDetail.get("title"));
                        newGroups.add(group);
                        continue;
                    }
                    if (noGroup == null) {
                        noGroup = new BasicDBObject();
                        BasicDBObject noGroupIdObj = new BasicDBObject();
                        noGroup.put("_id", (Object)noGroupIdObj);
                    }
                    if (!noGroup.containsKey("groupItems")) {
                        BasicDBList nogroupItems = new BasicDBList();
                        noGroup.put("groupItems", (Object)nogroupItems);
                    }
                    if (!noGroup.containsKey("multiIds")) {
                        multiIds = new BasicDBList();
                        noGroup.put("multiIds", (Object)multiIds);
                    }
                    if (!noGroup.containsKey("count")) {
                        Integer count = 0;
                        noGroup.put("count", (Object)count);
                    }
                    if (group.containsKey("groupItems")) {
                        BasicDBList groupItems = (BasicDBList)group.get("groupItems");
                        for (int j = 0; j < groupItems.size(); ++j) {
                            Integer noGroupCount;
                            DBObject gitem = (DBObject)groupItems.get(j);
                            String gitemid = (String)gitem.get("id");
                            if (noGroupItemsMapById.get(gitemid) != null) continue;
                            noGroupItemsMapById.put(gitemid, true);
                            BasicDBList noGroupItems = (BasicDBList)noGroup.get("groupItems");
                            noGroupItems.add((Object)gitem);
                            Integer n = noGroupCount = (Integer)noGroup.get("count");
                            Integer n2 = noGroupCount = Integer.valueOf(noGroupCount + 1);
                            noGroup.put("count", (Object)noGroupCount);
                        }
                    }
                    multiIds = (BasicDBList)noGroup.get("multiIds");
                    multiIds.add((Object)groupId);
                    noGroup.put("multiIds", (Object)multiIds);
                }
                if (noGroup != null) {
                    BasicDBList excludeGroupIds = new BasicDBList();
                    noGroup.put("excludeGroupIds", (Object)excludeGroupIds);
                    newGroups.forEach(g -> {
                        String groupId;
                        DBObject idObj = (DBObject)g.get("_id");
                        if (idObj == null) {
                            idObj = new BasicDBObject();
                        }
                        if ((groupId = String.valueOf(idObj.get("id"))) != null) {
                            excludeGroupIds.add((Object)groupId);
                        }
                    });
                    newGroups.add(noGroup);
                }
                return newGroups;
            }
            catch (Exception e) {
                LOGGER.error("Error processing handleArchivedGroups()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    public Map<String, Object> getBacklogItemsIdsWithLevel(String id, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> resultSet = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String filterId = entry.getKey();
                Map filterParams = (Map)entry.getValue();
                Date start = new Date();
                String hierachLevelStr = null;
                if (filterParams.containsKey("hierachLevel")) {
                    hierachLevelStr = (String)filterParams.get("hierachLevel");
                }
                String sortBy = this.artRelation(id) + ".sequence";
                String sortOrder = "1";
                if (filterParams.containsKey("sortBy")) {
                    sortBy = (String)filterParams.get("sortBy");
                }
                if (filterParams.containsKey("sortOrder")) {
                    sortOrder = (String)filterParams.get("sortOrder");
                }
                Boolean fetchData = false;
                if (filterParams.containsKey("fetchData")) {
                    fetchData = (Boolean)filterParams.get("fetchData");
                }
                String pageStartStr = null;
                String pageSizeStr = null;
                String boardId = null;
                if (filterParams.containsKey("pageStart")) {
                    pageStartStr = (String)filterParams.get("pageStart");
                }
                if (filterParams.containsKey("pageSize")) {
                    pageSizeStr = (String)filterParams.get("pageSize");
                }
                if (filterParams.containsKey("boardId")) {
                    boardId = (String)filterParams.get("boardId");
                }
                String groupBy = (String)filterParams.get("groupBy");
                Boolean rollupToGroups = (Boolean)filterParams.get("rollupToGroups");
                boolean fetchParents = false;
                if (filterParams.containsKey("fetchParents")) {
                    fetchParents = (Boolean)filterParams.get("fetchParents");
                }
                LinkedTreeMap filter = (LinkedTreeMap)filterParams.get("filter");
                HashMap result = new HashMap();
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
                BasicDBObject basicMatch = new BasicDBObject();
                basicMatch.append("tenant", (Object)tenant);
                basicMatch.append("rowStatus", (Object)0);
                basicMatch.append("archive", (Object)false);
                if (hierachLevelStr != null) {
                    basicMatch.append(this.artRelation(id) + ".backlogLevel", (Object)Integer.parseInt(hierachLevelStr));
                }
                if (id != null && !"null".equals(id)) {
                    basicMatch.append(this.artRelation(id) + ".releaseTrainId", (Object)id);
                }
                if (id != null && !"null".equals(id)) {
                    if (params.containsKey("archieve")) {
                        Boolean archieve = (Boolean)params.get("archieve");
                        basicMatch.append(this.artRelation(id) + ".rowStatus", (Object)(archieve != false ? 1 : 0));
                    } else {
                        basicMatch.append(this.artRelation(id) + ".rowStatus", (Object)0);
                    }
                }
                BasicDBObject basicMatchPipeline = new BasicDBObject("$match", (Object)basicMatch);
                pipelines.add(basicMatchPipeline);
                DBObject filtersPipeline = this.getFilterPipeline(id, (Map)filter, pipelines);
                if (filtersPipeline != null) {
                    BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)filtersPipeline);
                    pipelines.add(finalMatchPipeline);
                }
                BasicDBObject projectionPipeline = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1));
                if (fetchData.booleanValue()) {
                    projectionPipeline = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{\"_id\":1, \"title\": 1, \"fields\": 1, \"almKey\": 1}"));
                }
                pipelines.add(projectionPipeline);
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
                AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
                HashSet userIdList = new HashSet();
                Cursor dbCursor = collection.aggregate(pipelines, ao);
                Date end = new Date();
                LOGGER.info("==================================================");
                LOGGER.info("\t\tQuery Time : " + (end.getTime() - start.getTime()));
                LOGGER.info("==================================================");
                start = new Date();
                ArrayList<BacklogItem> items = new ArrayList<BacklogItem>();
                while (dbCursor.hasNext()) {
                    DBObject o = (DBObject)dbCursor.next();
                    String ItemId = o.get("_id").toString();
                    BacklogItem backlogItem = new BacklogItem();
                    backlogItem.setId(ItemId);
                    if (fetchData.booleanValue()) {
                        String title = o.get("title").toString();
                        String almKey = o.get("almKey").toString();
                        Map fields = (Map)o.get("fields");
                        backlogItem.setTitle(title);
                        backlogItem.setFields(fields);
                        backlogItem.setAlmKey(almKey);
                    }
                    items.add(backlogItem);
                }
                result.put("items", items);
                end = new Date();
                LOGGER.info("==================================================");
                LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
                LOGGER.info("==================================================");
                resultSet.put(filterId, result);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getBacklogItemsIdsWithLevel()" + StringUtils.getTraceString((Throwable)e));
        }
        return resultSet;
    }

    private DBObject formatItemDbObject(DBObject item) {
        item.put("id", (Object)String.valueOf(item.get("_id")));
        item.removeField("_id");
        if (item.containsField("status")) {
            DBRef status = (DBRef)item.get("status");
            BasicDBObject st = new BasicDBObject("id", (Object)String.valueOf(status.getId()));
            item.put("status", (Object)st);
        }
        if (item.containsField("children")) {
            item.removeField("children");
        }
        if (item.containsField("childrenTree")) {
            item.removeField("childrenTree");
        }
        return item;
    }

    private void putItemParentInMap(String releaseTrainId, DBObject item, HashMap<String, String> parentMap) {
        DBObject parentRelationsMap;
        if (item.containsKey("parentRelationMap") && PropertyValidator.isValid((Object)(parentRelationsMap = (DBObject)item.get("parentRelationMap"))) && parentRelationsMap.containsKey(releaseTrainId)) {
            BasicDBList parentRelations = (BasicDBList)parentRelationsMap.get(releaseTrainId);
            for (int j = 0; j < parentRelations.size(); ++j) {
                DBObject parentRelation = (DBObject)parentRelations.get(j);
                String parentId = String.valueOf(parentRelation.get("backlogItemId"));
                parentRelation.removeField("backlogItemId");
                parentRelation.put("backlogItemId", (Object)parentId);
                parentMap.put(parentId, parentId);
            }
        }
    }

    private ArrayList<DBObject> getSortFieldsPipeline(String artId, Map<String, Object> params) {
        ArrayList<DBObject> pipelines = new ArrayList<DBObject>();
        String sortBy = this.artRelation(artId) + ".sequence";
        String sortOrder = "1";
        if (params.containsKey("sortBy")) {
            sortBy = (String)params.get("sortBy");
        }
        if (params.containsKey("sortOrder")) {
            sortOrder = (String)params.get("sortOrder");
        }
        if (sortBy.equals("title")) {
            BasicDBObject lowerTitleFields = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{\"lowerTitle\": { \"$toLower\" : \"$title\" } }"));
            pipelines.add((DBObject)lowerTitleFields);
            BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject().append("lowerTitle", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sort);
        } else if (sortBy.equals("statusTitle")) {
            BasicDBObject statusPipeline1 = new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"status").append("localField", (Object)"status.$id").append("foreignField", (Object)"_id").append("as", (Object)"statusTitle"));
            pipelines.add((DBObject)statusPipeline1);
            BasicDBObject statusPipeline2 = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{ \"statusTitle\" : { \"$toLower\" : { \"$arrayElemAt\" : [\"$statusTitle.title\", 0] } } }"));
            pipelines.add((DBObject)statusPipeline2);
            BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject().append("statusTitle", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sort);
        } else if (sortBy.equals("childCount")) {
            BasicDBObject statusPipeline2 = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{ childCount: { $size: \"$childrenStatuses\" } }"));
            pipelines.add((DBObject)statusPipeline2);
        } else if (sortBy.equals("totalEstimate")) {
            BasicDBObject statusPipeline2 = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{ \"totalEstimate\" : { \"$add\" : [ \"$childStoryPoints\", \"$storyPoints\" ] }, }"));
            pipelines.add((DBObject)statusPipeline2);
        } else if (sortBy.equals("date")) {
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append("fields.StartDate", (Object)Integer.parseInt(sortOrder)).append("fields.EndDate", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sortPipeline);
        } else if (sortBy.equals("startDate")) {
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append("fields.StartDate", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sortPipeline);
        } else if (sortBy.equals("endDate")) {
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append("fields.EndDate", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sortPipeline);
        } else if (sortBy.equals("itemType")) {
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append("fields.itemType", (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sortPipeline);
        } else {
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append(sortBy, (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add((DBObject)sortPipeline);
        }
        return pipelines;
    }

    private ArrayList<DBObject> getRollupPipeline(String artId, Map<String, Object> params) {
        ArrayList<DBObject> pipelines = new ArrayList<DBObject>();
        Boolean noRollup = (Boolean)params.get("noRollup");
        Boolean rollupTeams = (Boolean)params.get("rollupTeams");
        Boolean rollupSprints = (Boolean)params.get("rollupSprints");
        Boolean rollupBatches = (Boolean)params.get("rollupBatches");
        Boolean rollupStoryPointsArray = (Boolean)params.get("rollupStoryPointsArray");
        Boolean rollupDates = (Boolean)params.get("rollupDates");
        if (noRollup != null && noRollup.booleanValue()) {
            return pipelines;
        }
        BasicDBObject graphLookup = new BasicDBObject("$graphLookup", (Object)new BasicDBObject("from", (Object)"backlogItem").append("startWith", (Object)("$" + this.childRelation(artId) + ".backlogItemId")).append("connectFromField", (Object)(this.childRelation(artId) + ".backlogItemId")).append("connectToField", (Object)"_id").append("as", (Object)"childrenTree").append("depthField", (Object)"depth"));
        pipelines.add((DBObject)graphLookup);
        BasicDBObject filterArchieved = new BasicDBObject("$addFields", (Object)new BasicDBObject("childrenTree", (Object)new BasicDBObject("$filter", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("cond", (Object)BasicDBObject.parse((String)("{$eq: [\"$$child." + this.artRelation(artId) + ".rowStatus\",0]}"))))));
        pipelines.add((DBObject)filterArchieved);
        BasicDBObject addMaxDepth = new BasicDBObject("$addFields", (Object)new BasicDBObject("maxDepth", (Object)new BasicDBObject("$max", (Object)"$childrenTree.depth")));
        pipelines.add((DBObject)addMaxDepth);
        BasicDBObject feilds = new BasicDBObject("childBoards", (Object)new BasicDBObject("$reduce", (Object)new BasicDBObject("input", (Object)("$childrenTree." + this.boardRelations(artId) + ".sessionBoardId")).append("initialValue", new ArrayList()).append("in", (Object)BasicDBObject.parse((String)"{$setUnion: [\"$$value\",\"$$this\"]}")))).append("children", (Object)new BasicDBObject("$filter", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("cond", (Object)BasicDBObject.parse((String)"{$eq: [ \"$$child.depth\", 0 ]}")))).append("childStoryPoints", (Object)BasicDBObject.parse((String)"{ $sum: \"$childrenTree.storyPoints\" } ")).append("leafStoryPoints", (Object)new BasicDBObject("$sum", (Object)new BasicDBObject("$map", (Object)new BasicDBObject("input", (Object)new BasicDBObject("$filter", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("cond", (Object)new BasicDBObject("$eq", Arrays.asList("$$child.depth", "$maxDepth"))))).append("as", (Object)"leaf").append("in", (Object)"$$leaf.storyPoints")))).append("leafStoryPointsArray", (Object)new BasicDBObject("$map", (Object)new BasicDBObject("input", (Object)new BasicDBObject("$filter", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("cond", (Object)new BasicDBObject("$eq", Arrays.asList("$$child.depth", "$maxDepth"))))).append("as", (Object)"leaf").append("in", (Object)BasicDBObject.parse((String)"{ \"status\" : { \"$toString\":\"$$leaf.status.$id\" }, \"storyPoints\" : \"$$leaf.storyPoints\" }"))));
        feilds.append("childSolutionBoards", (Object)new BasicDBObject("$reduce", (Object)new BasicDBObject("input", (Object)("$childrenTree." + this.solutionRelations(artId) + ".solutionId")).append("initialValue", new ArrayList()).append("in", (Object)BasicDBObject.parse((String)"{$setUnion: [\"$$value\",\"$$this\"]}"))));
        if (rollupDates != null && rollupDates.booleanValue()) {
            feilds.append("childDates", (Object)new BasicDBObject("$map", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("in", (Object)BasicDBObject.parse((String)"{ \"startDate\" : \"$$child.fields.StartDate\", \"endDate\" : \"$$child.fields.EndDate\" }"))));
            feilds.append("childIterations", (Object)new BasicDBObject("$map", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("in", (Object)BasicDBObject.parse((String)"{ \"iteration\" : \"$$child.fields.tfsIterationPath\" }"))));
        }
        if (rollupStoryPointsArray != null && rollupStoryPointsArray.booleanValue()) {
            feilds.append("childStoryPointsByStatus", (Object)new BasicDBObject("$map", (Object)new BasicDBObject("input", (Object)"$childrenTree").append("as", (Object)"child").append("in", (Object)BasicDBObject.parse((String)"{ \"status\" : {\"$toString\":\"$$child.status.$id\"}, \"storyPoints\" : \"$$child.storyPoints\" }"))));
        }
        if (rollupSprints != null && rollupSprints.booleanValue()) {
            feilds.append("childContainers", (Object)new BasicDBObject("$reduce", (Object)new BasicDBObject("input", (Object)("$childrenTree." + this.teamSprintRelations(artId) + ".sprintId")).append("initialValue", new ArrayList()).append("in", (Object)BasicDBObject.parse((String)"{$setUnion: [\"$$value\",\"$$this\"]}"))));
        }
        if (rollupTeams != null && rollupTeams.booleanValue()) {
            feilds.append("childTeams", (Object)new BasicDBObject("$reduce", (Object)new BasicDBObject("input", (Object)("$childrenTree." + this.teamSprintRelations(artId) + ".teamId")).append("initialValue", new ArrayList()).append("in", (Object)BasicDBObject.parse((String)"{$setUnion: [\"$$value\",\"$$this\"]}"))));
        }
        if (rollupBatches != null && rollupBatches.booleanValue()) {
            feilds.append("childBatches", (Object)new BasicDBObject("$reduce", (Object)new BasicDBObject("input", (Object)("$childrenTree." + this.batchRelations(artId) + ".baseItemId")).append("initialValue", new ArrayList()).append("in", (Object)BasicDBObject.parse((String)"{$setUnion: [\"$$value\",\"$$this\"]}"))));
        }
        BasicDBObject piProjection = new BasicDBObject("$addFields", (Object)feilds);
        pipelines.add((DBObject)piProjection);
        BasicDBObject childrenStatuses = new BasicDBObject("$addFields", (Object)new BasicDBObject("childrenStatuses", (Object)BasicDBObject.parse((String)"{$map : { input : \"$children\", as : \"child\", in : {$toString: \"$$child.status.$id\"}  } }")));
        pipelines.add((DBObject)childrenStatuses);
        BasicDBObject projectPipeline = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{\"children\":0,\"childrenTree\":0}"));
        pipelines.add((DBObject)projectPipeline);
        return pipelines;
    }

    private DBObject getParentsPipeline(String releaseTrainId) {
        BasicDBObject parentPipeline = new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"backlogItem").append("let", (Object)new BasicDBObject("links", (Object)("$" + this.parentRelation(releaseTrainId)))).append("pipeline", Arrays.asList(new BasicDBObject("$match", (Object)BasicDBObject.parse((String)"{ $expr: { $and:[{ $in : [ \"$_id\", \"$$links.backlogItemId\" ]} ] } }")), new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{\"id\":{$toString:\"$_id\"}}")), new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{\"almKey\":1,\"almItemId\":1,\"title\":1,\"url\":1, \"id\":1, \"_id\":0}")))).append("as", (Object)"parents"));
        return parentPipeline;
    }

    private ArrayList<DBObject> getGroupByPipeline(String artId, Map<String, Object> params) {
        BasicDBObject filterPipeline;
        String groupFieldName;
        String groupBy = (String)params.get("groupBy");
        String type = (String)params.get("type");
        String itemType = (String)params.get("itemType");
        Boolean fetchParents = (Boolean)params.get("fetchParents");
        Boolean fetchGroupItems = (Boolean)params.get("fetchGroupItems");
        Boolean rollupToGroups = (Boolean)params.get("rollupToGroups");
        if (fetchParents == null) {
            fetchParents = false;
        }
        if (fetchGroupItems == null) {
            fetchGroupItems = false;
        }
        if (rollupToGroups == null) {
            rollupToGroups = false;
        }
        if (type == null) {
            type = "";
        }
        ArrayList<DBObject> pipelines = new ArrayList<DBObject>();
        String groupParentsStr = "{ $group : {";
        if (groupBy.equals("kendisStatus")) {
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$lookup: {from: 'status', localField: 'status.$id', foreignField: '_id', as: 'statusDetails' }}"));
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$unwind: { path: '$statusDetails', preserveNullAndEmptyArrays: true } }"));
            groupParentsStr = groupParentsStr + "_id : {id: '$statusDetails.title', title: '$statusDetails.title'}";
        } else if (groupBy.equals("Parent")) {
            groupFieldName = "parents";
            groupFieldName = "parentRelationMap." + artId + "";
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$" + groupFieldName + "\", preserveNullAndEmptyArrays: true} }")));
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".backlogItemId\"}";
        } else if (groupBy.equals("Session")) {
            groupFieldName = this.boardRelations(artId);
            if (fetchGroupItems.booleanValue()) {
                BasicDBObject addFieldPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("g_" + groupFieldName, (Object)("$" + groupFieldName)));
                pipelines.add((DBObject)addFieldPipeline);
                groupFieldName = "g_" + groupFieldName;
            }
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$" + groupFieldName + "\", preserveNullAndEmptyArrays: true} }")));
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".sessionId\"}";
        } else if (groupBy.equalsIgnoreCase("solutionBoards")) {
            groupFieldName = this.solutionRelations(artId);
            if (fetchGroupItems.booleanValue()) {
                BasicDBObject addFieldPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("g_" + groupFieldName, (Object)("$" + groupFieldName)));
                pipelines.add((DBObject)addFieldPipeline);
                groupFieldName = "g_" + groupFieldName;
            }
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$" + groupFieldName + "\", preserveNullAndEmptyArrays: true} }")));
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".solutionId\"}";
        } else if (groupBy.equals("Teams")) {
            filterPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("teamLinks", (Object)new BasicDBObject("$setUnion", (Object)("$" + this.teamSprintRelations(artId) + ".teamId"))));
            pipelines.add((DBObject)filterPipeline);
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$unwind: {path: \"$teamLinks\", preserveNullAndEmptyArrays: true} }"));
            groupParentsStr = groupParentsStr + "_id : {id:\"$teamLinks\"}";
        } else if (groupBy.equals("Containers")) {
            filterPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("sprintLinks", (Object)new BasicDBObject("$setUnion", (Object)("$" + this.teamSprintRelations(artId) + ".sprintId"))));
            pipelines.add((DBObject)filterPipeline);
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$unwind: {path: \"$sprintLinks\", preserveNullAndEmptyArrays: true} }"));
            groupParentsStr = groupParentsStr + "_id : {id:\"$sprintLinks\"}";
        } else if (groupBy.equals("Milestones")) {
            filterPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("milestoneLinks", (Object)new BasicDBObject("$setUnion", (Object)"$milestoneRelations.baseItemId")));
            pipelines.add((DBObject)filterPipeline);
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$unwind: {path: \"$milestoneLinks\", preserveNullAndEmptyArrays: true} }"));
            groupParentsStr = groupParentsStr + "_id : {id:\"$milestoneLinks\"}";
        } else if (groupBy.equals("Batches")) {
            groupFieldName = this.batchRelations(artId);
            if (fetchGroupItems.booleanValue()) {
                BasicDBObject addFieldPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject("g_" + groupFieldName, (Object)("$" + groupFieldName)));
                pipelines.add((DBObject)addFieldPipeline);
                groupFieldName = "g_" + groupFieldName;
            }
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$" + groupFieldName + "\", preserveNullAndEmptyArrays: true} }")));
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".baseItemId\"}";
        } else if (groupBy.equalsIgnoreCase("kendisResponsible")) {
            groupFieldName = "fields.responsible";
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".id\", title:\"$" + groupFieldName + ".fullName\" }";
        } else if (groupBy.equalsIgnoreCase("tfsResponsible")) {
            groupFieldName = "fields.AssignedTo";
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".uniqueName\", title:\"$" + groupFieldName + ".displayName\" }";
        } else if (groupBy.equalsIgnoreCase("jiraResponsible")) {
            groupFieldName = "almFields.assignee";
            groupParentsStr = groupParentsStr + "_id : {id:\"$" + groupFieldName + ".emailAddress\", title:\"$" + groupFieldName + ".displayName\" }";
        } else if (groupBy.equals("Section")) {
            groupFieldName = this.sectionRelations();
            String boardId = (String)params.get("boardId");
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$" + groupFieldName + "\", preserveNullAndEmptyArrays: true} }")));
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$lookup: {  from: \"roadmapSection\",   let: { baseItemId: { $toObjectId: \"$" + groupFieldName + ".baseItemId\" } },   pipeline: [    { $match: { $expr: { $eq: [\"$_id\", \"$$baseItemId\"] } } }  ],   as: \"roadmapDetails\" }}")));
            pipelines.add((DBObject)BasicDBObject.parse((String)"{$unwind: {path: \"$roadmapDetails\", preserveNullAndEmptyArrays: true} }"));
            groupParentsStr = groupParentsStr + "_id : {  \"$cond\": [    { \"$eq\": [\"$roadmapDetails.parentRoadmapId\", \"" + boardId + "\"] },    { \"id\": \"$" + groupFieldName + ".baseItemId\" },    { }  ]},";
        } else if (groupBy.equals("timeCapsuleRelation")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$timeCapsuleRelation.customId\"}";
        } else if (groupBy.equals("Project")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$fields.tfsProject\", title:\"$fields.tfsProject\"}";
        } else if (groupBy.equals("AreaPath")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$fields.tfsAreaPath\", title:\"$fields.tfsAreaPath\"}";
        } else if (groupBy.equals("Iteration")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$fields.tfsIterationPath\", title:\"$fields.tfsIterationPath\"}";
        } else if (groupBy.equals("issuetype") || groupBy.equals("project") || groupBy.equals("priority") || groupBy.equals("status")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$almFields." + groupBy + ".name\", title:\"$almFields." + groupBy + ".name\"}";
        } else if (groupBy.contains("kendisFields")) {
            String[] fieldValue = groupBy.split("-");
            if (type.equalsIgnoreCase("object")) {
                groupParentsStr = groupParentsStr + "_id : {id:\"$fields." + fieldValue[1] + ".title\", title:\"$fields." + fieldValue[1] + ".title\"}";
            } else if (type.equalsIgnoreCase("array")) {
                pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$fields." + fieldValue[1] + "\", preserveNullAndEmptyArrays: true} }")));
                groupParentsStr = groupParentsStr + "_id : {id:\"$fields." + fieldValue[1] + ".title\", title:\"$fields." + fieldValue[1] + ".title\"}";
            } else {
                groupParentsStr = type.equalsIgnoreCase("user") ? groupParentsStr + "_id : {id:\"$fields." + fieldValue[1] + ".fullName\", title:\"$fields." + fieldValue[1] + ".fullName\"}" : groupParentsStr + "_id : {id:\"$fields." + fieldValue[1] + "\", title:\"$fields." + fieldValue[1] + "\"}";
            }
        } else if (type.equalsIgnoreCase("option") || type.equalsIgnoreCase("option-with-child")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$almFields." + groupBy + ".value\", title:\"$almFields." + groupBy + ".value\"}";
        } else if (type.equalsIgnoreCase("user")) {
            groupParentsStr = groupParentsStr + "_id : {id:\"$almFields." + groupBy + ".displayName\", title:\"$almFields." + groupBy + ".displayName\"}";
        } else if (type.equalsIgnoreCase("array")) {
            pipelines.add((DBObject)BasicDBObject.parse((String)("{$unwind: {path: \"$almFields." + groupBy + "\", preserveNullAndEmptyArrays: true} }")));
            groupParentsStr = itemType != null && itemType.equalsIgnoreCase("string") ? groupParentsStr + "_id : {id:\"$almFields." + groupBy + "\", title:\"$almFields." + groupBy + "\"}" : (itemType != null && (itemType.equalsIgnoreCase("json") || itemType.equalsIgnoreCase("version") || itemType.equalsIgnoreCase("component")) ? groupParentsStr + "_id : {id:\"$almFields." + groupBy + ".name\", title:\"$almFields." + groupBy + ".name\"}" : groupParentsStr + "_id : {id:\"$almFields." + groupBy + ".value\", title:\"$almFields." + groupBy + ".value\"}");
        } else {
            groupParentsStr = groupParentsStr + "_id : {id:\"$almFields." + groupBy + "\", title:\"$almFields." + groupBy + "\"}";
        }
        groupParentsStr = groupParentsStr + "count: { $sum:1 }";
        boolean groupItemsMapped = false;
        if (fetchGroupItems.booleanValue()) {
            groupItemsMapped = true;
            groupParentsStr = groupParentsStr + "groupItems: { $push : \"$$ROOT\" }";
        } else if (rollupToGroups.booleanValue()) {
            groupItemsMapped = true;
            groupParentsStr = groupParentsStr + "groupItems: { $push : {\"childStoryPointsByStatus\":\"$childStoryPointsByStatus\" , \"childContainers\":\"$childContainers\" , \"childrenStatuses\":\"$childrenStatuses\" , \"startDate\":\"$fields.StartDate\", \"endDate\":\"$fields.EndDate\", \"tfsIterationPath\":\"$fields.tfsIterationPath\", \"childDates\":\"$childDates\",\"childIterations\":\"$childIterations\", \"_id\":\"$_id\" } }";
        }
        if (!groupItemsMapped) {
            groupParentsStr = groupParentsStr + "groupItems: { $push : { \"_id\":\"$_id\" } }";
        }
        groupParentsStr = groupParentsStr + "}}";
        pipelines.add((DBObject)BasicDBObject.parse((String)groupParentsStr));
        return pipelines;
    }

    private DBObject getFilterPipeline(String artId, Map<String, Object> filter, List<DBObject> pipes) {
        ArrayList rules;
        if (PropertyValidator.isValid(filter) && filter.containsKey("rules") && PropertyValidator.isValid((Collection)(rules = (ArrayList)filter.get("rules")))) {
            ArrayList<Object> queries = new ArrayList<Object>();
            for (Map rule : rules) {
                List values2;
                BasicDBObject c2;
                BasicDBObject c22;
                List list;
                Object tfsIterationsMap;
                Object query;
                String str;
                ArrayList value;
                String type = (String)rule.get("type");
                String key = (String)rule.get("key");
                String almType = (String)rule.get("almType");
                if (key.equals("almKey")) {
                    value = (ArrayList)rule.get("value");
                    str = "";
                    for (String s2 : value) {
                        str = str + "/" + s2 + "/i,";
                    }
                    query = new BasicDBObject("almKey", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    queries.add(query);
                    continue;
                }
                if (key.equals("show-unplanned-items-only")) {
                    boolean value2 = (Boolean)rule.get("value");
                    if (!value2) continue;
                    BasicDBObject startDateMissingOrNull = new BasicDBObject("$or", (Object)new /* Unavailable Anonymous Inner Class!! */);
                    BasicDBObject endDateMissingOrNull = new BasicDBObject("$or", (Object)new /* Unavailable Anonymous Inner Class!! */);
                    BasicDBList orConditions = new BasicDBList();
                    orConditions.add((Object)startDateMissingOrNull);
                    orConditions.add((Object)endDateMissingOrNull);
                    BasicDBObject query2 = new BasicDBObject("$or", (Object)orConditions);
                    queries.add(query2);
                    continue;
                }
                if (key.equals("show-planned-items-only")) {
                    boolean value3 = (Boolean)rule.get("value");
                    if (!value3) continue;
                    BasicDBObject startDateCondition = new BasicDBObject("$exists", (Object)true).append("$ne", null);
                    BasicDBObject endDateCondition = new BasicDBObject("$exists", (Object)true).append("$ne", null);
                    BasicDBObject query3 = new BasicDBObject("fields.StartDate", (Object)startDateCondition).append("fields.EndDate", (Object)endDateCondition);
                    queries.add(query3);
                    continue;
                }
                if (key.equals("planned-iteration-path-or-item-dates")) {
                    tfsIterationsMap = rule.get("value");
                    queries.add(this.plannedIterationPathOverDatesFilterQueryFactory.createQuery(artId, tfsIterationsMap));
                    continue;
                }
                if (key.equals("unplanned-iteration-path-or-item-dates")) {
                    tfsIterationsMap = rule.get("value");
                    queries.add(this.unplannedIterationPathOrDatesFilterQueryFactory.createQuery(artId, tfsIterationsMap));
                    continue;
                }
                if (key.equals("itemIds")) {
                    value = (ArrayList)rule.get("value");
                    list = value.stream().map(ObjectId::new).collect(Collectors.toList());
                    c22 = new BasicDBObject("_id", (Object)new BasicDBObject("$in", list));
                    queries.add(c22);
                    continue;
                }
                if (key.equals("kendisKey")) {
                    value = (ArrayList)rule.get("value");
                    str = "";
                    for (String s2 : value) {
                        str = str + "/" + s2 + "/i,";
                    }
                    query = new BasicDBObject("kendisKey", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    queries.add(query);
                    continue;
                }
                if (key.equals("title")) {
                    value = (ArrayList)rule.get("value");
                    str = "";
                    for (String s2 : value) {
                        str = str + "/" + s2 + "/i,";
                    }
                    query = new BasicDBObject("title", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    queries.add(query);
                    continue;
                }
                if (key.equals("title-id")) {
                    value = (ArrayList)rule.get("value");
                    str = "";
                    for (String s2 : value) {
                        str = str + "/" + s2 + "/i,";
                    }
                    BasicDBObject titleQuery = new BasicDBObject("title", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    BasicDBObject almKeyQuery = new BasicDBObject("almKey", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    BasicDBObject kendisItemQuery = new BasicDBObject("kendisKey", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    BasicDBObject externalKeyQuery = new BasicDBObject("fields.externalKey", (Object)BasicDBObject.parse((String)("{$in:[" + str + "]}")));
                    BasicDBObject query4 = new BasicDBObject("$or", Arrays.asList(titleQuery, almKeyQuery, kendisItemQuery, externalKeyQuery));
                    queries.add(query4);
                    continue;
                }
                if (key.equals("status")) {
                    value = (ArrayList)rule.get("value");
                    list = value.stream().filter(statusId -> statusId != null && ObjectId.isValid((String)statusId)).map(s -> new ObjectId(s)).collect(Collectors.toList());
                    BasicDBObject statusObject = new BasicDBObject("status.$id", (Object)new BasicDBObject("$in", list));
                    queries.add(statusObject);
                    continue;
                }
                if (key.equals("iterationPath")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject iterationPathObject = new BasicDBObject("fields.tfsIterationPath", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(iterationPathObject);
                    continue;
                }
                if (key.equals("areaPath")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject areaPathObject = new BasicDBObject("fields.tfsAreaPath", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(areaPathObject);
                    continue;
                }
                if (key.equals("project")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject projectObject = almType.equalsIgnoreCase("tfs") ? new BasicDBObject("fields.tfsProjectId", (Object)new BasicDBObject("$in", (Object)value)) : new BasicDBObject("almFields.project.key", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(projectObject);
                    continue;
                }
                if (key.equals("parent")) {
                    value = (ArrayList)rule.get("value");
                    list = value.stream().map(val -> new ObjectId((String)val.get("id"))).collect(Collectors.toList());
                    c22 = new BasicDBObject(this.parentRelation(artId) + ".backlogItemId", (Object)new BasicDBObject("$in", list));
                    queries.add(c22);
                    continue;
                }
                if (key.equals("session")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.boardRelations(artId) + ".sessionBoardId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equalsIgnoreCase("solutionBoards")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equals("teams")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equals("containers")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equals("batch")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.batchRelations(artId) + ".baseItemId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equals("objective")) {
                    value = (ArrayList)rule.get("value");
                    c2 = new BasicDBObject(this.objectiveRelations(artId) + ".baseItemId", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(c2);
                    continue;
                }
                if (key.equals("kendisResponsible")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject responsible = new BasicDBObject("fields.responsible.fullName", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(responsible);
                    continue;
                }
                if (key.equals("tfsResponsible")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject AssignedTo = new BasicDBObject("fields.AssignedTo.displayName", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(AssignedTo);
                    continue;
                }
                if (key.equals("jiraResponsible")) {
                    value = (ArrayList)rule.get("value");
                    BasicDBObject assignee = new BasicDBObject("almFields.assignee.displayName", (Object)new BasicDBObject("$in", (Object)value));
                    queries.add(assignee);
                    continue;
                }
                value = (ArrayList)rule.get("value");
                String prefix = "";
                prefix = PropertyValidator.isValid(rule.get("custom")) ? "almFields." : "almFields.";
                if (!PropertyValidator.isValid((Collection)value)) continue;
                String str2 = "";
                BasicDBObject fieldObject = null;
                if (value.get(0) instanceof String) {
                    for (String s3 : value) {
                        str2 = str2 + "/" + s3 + "/i,";
                    }
                }
                if (type.equalsIgnoreCase("datetime")) {
                    if (pipes != null) {
                        BasicDBObject addFieldPipeline = new BasicDBObject("$addFields", (Object)new BasicDBObject(prefix + key, (Object)BasicDBObject.parse((String)("{$toLong:{$toDate:'$" + prefix + key + "'}}"))));
                        pipes.add((DBObject)addFieldPipeline);
                        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                        try {
                            Date startDate = f.parse(((String)value.get(0)).toString());
                            Date endDate = f.parse(((String)value.get(1)).toString());
                            Long gte = startDate.getTime();
                            Long lte = endDate.getTime();
                            fieldObject = new BasicDBObject(prefix + key, (Object)BasicDBObject.parse((String)("{$gte :" + gte + ", $lte :" + lte + "}")));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (type.equalsIgnoreCase("user")) {
                    fieldObject = new BasicDBObject(prefix + key + ".displayName", (Object)BasicDBObject.parse((String)("{$in:[" + str2 + "]}")));
                } else if (type.equalsIgnoreCase("userpicker")) {
                    fieldObject = new BasicDBObject(prefix + key + ".fullName", (Object)BasicDBObject.parse((String)("{$in:[" + str2 + "]}")));
                } else if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("integer")) {
                    values2 = value.stream().map(Integer::parseInt).collect(Collectors.toList());
                    fieldObject = new BasicDBObject(prefix + key, (Object)new BasicDBObject("$in", values2));
                } else if (type.equalsIgnoreCase("double")) {
                    values2 = value.stream().map(Double::parseDouble).collect(Collectors.toList());
                    fieldObject = new BasicDBObject(prefix + key, (Object)new BasicDBObject("$in", values2));
                } else {
                    BasicDBObject cond1 = new BasicDBObject(prefix + key, (Object)BasicDBObject.parse((String)("{$in:[" + str2 + "]}")));
                    BasicDBObject cond2 = null;
                    BasicDBObject cond3 = null;
                    cond2 = str2 == "" ? new BasicDBObject(prefix + key + ".id", (Object)new BasicDBObject("$in", (Object)value)) : new BasicDBObject(prefix + key + ".id", (Object)BasicDBObject.parse((String)("{$in:[" + str2 + "]}")));
                    if (type.equalsIgnoreCase("boolean")) {
                        List values3 = value.stream().map(Boolean::parseBoolean).collect(Collectors.toList());
                        cond3 = new BasicDBObject(prefix + key, (Object)new BasicDBObject("$in", values3));
                    }
                    fieldObject = PropertyValidator.isValid(cond3) ? new BasicDBObject("$or", Arrays.asList(cond1, cond2, cond3)) : new BasicDBObject("$or", Arrays.asList(cond1, cond2));
                }
                if (fieldObject == null) continue;
                queries.add(fieldObject);
            }
            String operator = (String)filter.get("condition");
            operator = operator.toLowerCase();
            String operation = "$" + operator;
            return new BasicDBObject(operation, queries);
        }
        return null;
    }

    public Map<String, Object> getBacklogItemsChildren(String releaseTrainId, HashMap<String, Object> params) throws Exception {
        Boolean fetchParents;
        String backlogItemId = (String)params.get("backlogItemId");
        String sortBy = this.artRelation(releaseTrainId) + ".sequence";
        String sortOrder = "1";
        if (params.containsKey("sortBy")) {
            sortBy = (String)params.get("sortBy");
        }
        if (params.containsKey("sortOrder")) {
            sortOrder = (String)params.get("sortOrder");
        }
        if ((fetchParents = (Boolean)params.get("fetchParents")) == null) {
            fetchParents = false;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        try {
            DBObject filtersPipeline;
            String groupBy = (String)params.get("groupBy");
            Boolean rollupToGroups = (Boolean)params.get("rollupToGroups");
            if (rollupToGroups == null) {
                rollupToGroups = false;
            }
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            BasicDBObject firstMatchPipeline = new BasicDBObject("$match", (Object)new BasicDBObject().append("tenant", (Object)tenant).append("rowStatus", (Object)0).append("archive", (Object)false).append(this.artRelation(releaseTrainId) + ".rowStatus", (Object)0).append(this.parentRelation(releaseTrainId) + ".backlogItemId", (Object)new ObjectId(backlogItemId)));
            pipelines.add(firstMatchPipeline);
            LinkedTreeMap filter = (LinkedTreeMap)params.get("filter");
            if (PropertyValidator.isValid((Object)filter) && (filtersPipeline = this.getFilterPipeline(releaseTrainId, (Map)filter, pipelines)) != null) {
                BasicDBObject filterMatchPipeline = new BasicDBObject("$match", (Object)filtersPipeline);
                pipelines.add(filterMatchPipeline);
            }
            if (groupBy == null) {
                pipelines.addAll(this.getRollupPipeline(releaseTrainId, params));
                pipelines.addAll(this.getSortFieldsPipeline(releaseTrainId, params));
            } else {
                ArrayList groupByPipelines;
                if (rollupToGroups.booleanValue()) {
                    pipelines.addAll(this.getRollupPipeline(releaseTrainId, params));
                }
                if ((groupByPipelines = this.getGroupByPipeline(releaseTrainId, params)) != null) {
                    pipelines.addAll(groupByPipelines);
                }
            }
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
            Cursor dbCursor = collection.aggregate(pipelines, ao);
            ArrayList<DBObject> items = new ArrayList<DBObject>();
            HashMap<String, String> parentMap = new HashMap<String, String>();
            while (dbCursor.hasNext()) {
                DBObject item = (DBObject)dbCursor.next();
                if (groupBy == null) {
                    this.formatItemDbObject(item);
                    if (fetchParents.booleanValue()) {
                        this.putItemParentInMap(releaseTrainId, item, parentMap);
                    }
                } else {
                    if (groupBy.equals("Parent")) {
                        DBObject _id = (DBObject)item.get("_id");
                        String parentId = String.valueOf(_id.get("id"));
                        _id.put("id", (Object)parentId);
                        parentMap.put(parentId, parentId);
                    }
                    if (item.containsKey("groupItems")) {
                        BasicDBList groupItems = (BasicDBList)item.get("groupItems");
                        for (int j = 0; j < groupItems.size(); ++j) {
                            DBObject gitem = (DBObject)groupItems.get(j);
                            this.formatItemDbObject(gitem);
                        }
                    }
                }
                items.add(item);
            }
            if (!parentMap.isEmpty()) {
                List parents = this.backlogItemRepository.findParentsByIdIn(parentMap.keySet());
                result.put("parents", parents);
            }
            result.put("children", items);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getBacklogItemsChildren()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public BasicDBObject appendSubGroupConditionInGroupItemsCall(BasicDBObject conditions, String artId, Map<String, Object> params) throws Exception {
        String type = (String)params.get("subGroupValueType");
        String groupType = (String)params.get("subGroupType");
        String groupId = null;
        if (PropertyValidator.isValid((Object)params.get("subGroupId"))) {
            groupId = params.get("subGroupId").toString();
        }
        List groupIds = null;
        if (PropertyValidator.isValid((Object)params.get("subGroupIds"))) {
            groupIds = (List)params.get("subGroupIds");
        }
        List excludeGroupIds = null;
        if (PropertyValidator.isValid((Object)params.get("excludeSubGroupIds"))) {
            excludeGroupIds = (List)params.get("excludeSubGroupIds");
        }
        String optionType = (String)params.get("subOptionType");
        if (groupType.equals("kendisStatus")) {
            if (groupId != null) {
                conditions.append("statusDetails.title", (Object)groupId);
            } else {
                conditions.append("statusDetails.title", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Parent")) {
            if (groupId != null) {
                conditions.append(this.parentRelation(artId) + ".backlogItemId", (Object)new ObjectId(groupId));
            } else {
                conditions.append(this.parentRelation(artId) + ".0", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Session")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                ArrayList<String> nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    BasicDBObject nullQuery = new BasicDBObject(this.boardRelations(artId) + ".sessionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    BasicDBObject nonNullQuery = new BasicDBObject(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.boardRelations(artId) + ".sessionId", (Object)groupId);
            } else {
                conditions.append(this.boardRelations(artId) + ".sessionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Milestones")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                ArrayList<String> nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    BasicDBObject nullQuery = new BasicDBObject("milestoneRelations.baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    BasicDBObject nonNullQuery = new BasicDBObject("milestoneRelations.baseItemId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append("milestoneRelations.baseItemId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append("milestoneRelations.baseItemId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append("milestoneRelations.baseItemId", (Object)groupId);
            } else {
                conditions.append("milestoneRelations.baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equalsIgnoreCase("solutionBoards")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                ArrayList<String> nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    BasicDBObject nullQuery = new BasicDBObject(this.solutionRelations(artId) + ".solutionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    BasicDBObject nonNullQuery = new BasicDBObject(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)groupId);
            } else {
                conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Teams")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                ArrayList<String> nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    BasicDBObject nullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".teamId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    BasicDBObject nonNullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)groupId);
            } else {
                conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Containers")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                ArrayList<String> nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    BasicDBObject nullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".sprintId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    BasicDBObject nonNullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)groupId);
            } else {
                conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Batches")) {
            if (groupId != null) {
                conditions.append(this.batchRelations(artId) + ".baseItemId", (Object)groupId);
            } else {
                conditions.append(this.batchRelations(artId) + ".baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Project")) {
            if (groupId != null) {
                conditions.append("fields.tfsProject", (Object)groupId);
            } else {
                conditions.append("fields.tfsProject", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("AreaPath")) {
            if (groupId != null) {
                conditions.append("fields.tfsAreaPath", (Object)groupId);
            } else {
                conditions.append("fields.tfsAreaPath", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("kendisResponsible")) {
            if (groupId != null) {
                conditions.append("fields.responsible.id", (Object)groupId);
            } else {
                conditions.append("fields.responsible.id", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("tfsResponsible")) {
            if (groupId != null) {
                conditions.append("fields.AssignedTo.uniqueName", (Object)groupId);
            } else {
                conditions.append("fields.AssignedTo.uniqueName", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("jiraResponsible")) {
            if (groupId != null) {
                conditions.append("almFields.assignee.emailAddress", (Object)groupId);
            } else {
                conditions.append("almFields.assignee.emailAddress", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Iteration")) {
            if (groupId != null) {
                conditions.append("fields.tfsIterationPath", (Object)groupId);
            } else {
                conditions.append("fields.tfsIterationPath", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equalsIgnoreCase("issuetype") || groupType.equalsIgnoreCase("project") || groupType.equalsIgnoreCase("priority") || groupType.equalsIgnoreCase("status")) {
            conditions.append("fields." + groupType + ".name", (Object)groupId);
        } else if (groupType.contains("kendisFields")) {
            String[] fieldValue = groupType.split("-");
            if (groupId != null) {
                if (type.equalsIgnoreCase("user")) {
                    conditions.append("fields." + fieldValue[1] + ".fullName", (Object)groupId);
                } else if (type.equalsIgnoreCase("object") || type.equalsIgnoreCase("array")) {
                    conditions.append("fields." + fieldValue[1] + ".title", (Object)groupId);
                } else {
                    conditions.append("fields." + fieldValue[1], (Object)groupId);
                }
            } else {
                BasicDBObject cond1 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$type: 10}"));
                BasicDBObject cond2 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$exists : false}"));
                BasicDBObject cond3 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$eq : []}"));
                conditions.append("$or", Arrays.asList(cond1, cond2, cond3));
            }
        } else if (groupId != null) {
            if (type.equalsIgnoreCase("option") || type.equalsIgnoreCase("option-with-child")) {
                conditions.append("almFields." + groupType + ".value", (Object)groupId);
            } else if (type.equalsIgnoreCase("user")) {
                conditions.append("almFields." + groupType + ".displayName", (Object)groupId);
            } else if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("double")) {
                conditions.append("almFields." + groupType, (Object)((Double)params.get("subGroupId")));
            } else if (type.equalsIgnoreCase("boolean") && params.get("subGroupId") instanceof Boolean) {
                conditions.append("almFields." + groupType, (Object)((Boolean)params.get("subGroupId")));
            } else if (type.equalsIgnoreCase("array")) {
                if (optionType.equalsIgnoreCase("string")) {
                    conditions.append("almFields." + groupType, (Object)groupId);
                } else if (optionType.equalsIgnoreCase("json") || optionType.equalsIgnoreCase("version") || optionType.equalsIgnoreCase("component")) {
                    conditions.append("almFields." + groupType + ".name", (Object)groupId);
                } else {
                    conditions.append("almFields." + groupType + ".value", (Object)groupId);
                }
            } else {
                conditions.append("almFields." + groupType, (Object)groupId);
            }
        } else {
            BasicDBObject cond1 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$type: 10}"));
            BasicDBObject cond2 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$exists : false}"));
            BasicDBObject cond3 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$eq : []}"));
            conditions.append("$or", Arrays.asList(cond1, cond2, cond3));
        }
        return conditions;
    }

    public Map<String, Object> getBacklogGroupItemsMultiGroups(String releaseTrainId, HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public Map<String, Object> getBacklogGroupItems(String artId, Map<String, Object> params) throws Exception {
        DBObject filtersPipeline;
        BasicDBObject nonNullQuery;
        BasicDBObject nullQuery;
        ArrayList<String> nonNullIds;
        Boolean fetchParents;
        String boardId = (String)params.get("boardId");
        String hierachLevelStr = (String)params.get("hierachLevel");
        String type = (String)params.get("groupValueType");
        String optionType = (String)params.get("optionType");
        String groupId = null;
        if (PropertyValidator.isValid((Object)params.get("groupId"))) {
            groupId = params.get("groupId").toString();
        }
        List groupIds = null;
        if (PropertyValidator.isValid((Object)params.get("groupIds"))) {
            groupIds = (List)params.get("groupIds");
        }
        List excludeGroupIds = null;
        if (PropertyValidator.isValid((Object)params.get("excludeGroupIds"))) {
            excludeGroupIds = (List)params.get("excludeGroupIds");
        }
        String parentId = (String)params.get("parentId");
        String groupType = (String)params.get("groupType");
        String pageStartStr = (String)params.get("pageStart");
        String pageSizeStr = (String)params.get("pageSize");
        String sortBy = this.artRelation(artId) + ".sequence";
        String sortOrder = "1";
        if (params.containsKey("sortBy")) {
            sortBy = (String)params.get("sortBy");
        }
        if (params.containsKey("sortOrder")) {
            sortOrder = (String)params.get("sortOrder");
        }
        if ((fetchParents = (Boolean)params.get("fetchParents")) == null) {
            fetchParents = false;
        }
        Map filter = (Map)params.get("filter");
        int level = Integer.parseInt(hierachLevelStr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        BasicDBObject conditions = new BasicDBObject().append("tenant", (Object)tenant).append("rowStatus", (Object)0).append("archive", (Object)false).append(this.artRelation(artId) + ".releaseTrainId", (Object)artId).append(this.artRelation(artId) + ".backlogLevel", (Object)level).append(this.artRelation(artId) + ".rowStatus", (Object)0);
        if (parentId != null) {
            conditions.append(this.parentRelation(artId) + ".backlogItemId", (Object)new ObjectId(parentId));
        }
        if (groupType.equals("kendisStatus")) {
            pipelines.add(BasicDBObject.parse((String)"{$lookup: {from: 'status', localField: 'status.$id', foreignField: '_id', as: 'statusDetails' }}"));
            pipelines.add(BasicDBObject.parse((String)"{$unwind: { path: '$statusDetails', preserveNullAndEmptyArrays: true } }"));
            if (groupId != null) {
                conditions.append("statusDetails.title", (Object)groupId);
            } else {
                conditions.append("statusDetails.title", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Parent")) {
            if (groupId != null) {
                conditions.append(this.parentRelation(artId) + ".backlogItemId", (Object)new ObjectId(groupId));
            } else {
                conditions.append(this.parentRelation(artId) + ".0", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Session")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                nonNullIds = new ArrayList<String>();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    nullQuery = new BasicDBObject(this.boardRelations(artId) + ".sessionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    nonNullQuery = new BasicDBObject(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.boardRelations(artId) + ".sessionId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.boardRelations(artId) + ".sessionId", (Object)groupId);
            } else {
                conditions.append(this.boardRelations(artId) + ".sessionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equalsIgnoreCase("solutionBoards")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                nonNullIds = new ArrayList();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    nullQuery = new BasicDBObject(this.solutionRelations(artId) + ".solutionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    nonNullQuery = new BasicDBObject(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$in", nonNullIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)groupId);
            } else {
                conditions.append(this.solutionRelations(artId) + ".solutionId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Teams")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                nonNullIds = new ArrayList();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    nullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".teamId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    nonNullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$in", (Object)groupIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)groupId);
            } else {
                conditions.append(this.teamSprintRelations(artId) + ".teamId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Milestones")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                nonNullIds = new ArrayList();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    nullQuery = new BasicDBObject("milestoneRelations.baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    nonNullQuery = new BasicDBObject("milestoneRelations.baseItemId", (Object)new BasicDBObject("$in", (Object)groupIds));
                    if (excludeGroupIds != null) {
                        conditions.append("milestoneRelations.baseItemId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append("milestoneRelations.baseItemId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append("milestoneRelations.baseItemId", (Object)groupId);
            } else {
                conditions.append("milestoneRelations.baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Containers")) {
            if (groupIds != null) {
                boolean isNullExist = false;
                nonNullIds = new ArrayList();
                for (String _id : groupIds) {
                    if (_id == null) {
                        isNullExist = true;
                        continue;
                    }
                    nonNullIds.add(_id);
                }
                if (isNullExist) {
                    nullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".sprintId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
                    nonNullQuery = new BasicDBObject(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$in", (Object)groupIds));
                    if (excludeGroupIds != null) {
                        conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$nin", (Object)excludeGroupIds));
                    } else {
                        conditions.append("$or", Arrays.asList(nullQuery, nonNullQuery));
                    }
                } else {
                    conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)new BasicDBObject("$in", (Object)groupIds));
                }
            } else if (groupId != null) {
                conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)groupId);
            } else {
                conditions.append(this.teamSprintRelations(artId) + ".sprintId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Batches")) {
            if (groupId != null) {
                conditions.append(this.batchRelations(artId) + ".baseItemId", (Object)groupId);
            } else {
                conditions.append(this.batchRelations(artId) + ".baseItemId", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Section")) {
            if (groupId != null) {
                conditions.append(this.sectionRelations() + ".baseItemId", (Object)groupId);
            } else {
                ArrayList excludeSectionIds = new ArrayList();
                this.roadmapSectionRepository.findByParentRoadmapId(boardId).forEach(section -> excludeSectionIds.add(section.getId()));
                conditions.append(this.sectionRelations() + ".baseItemId", (Object)new BasicDBObject("$nin", excludeSectionIds));
            }
        } else if (groupType.equals("Project")) {
            if (groupId != null) {
                conditions.append("fields.tfsProject", (Object)groupId);
            } else {
                conditions.append("fields.tfsProject", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("AreaPath")) {
            if (groupId != null) {
                conditions.append("fields.tfsAreaPath", (Object)groupId);
            } else {
                conditions.append("fields.tfsAreaPath", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("Iteration")) {
            if (groupId != null) {
                conditions.append("fields.tfsIterationPath", (Object)groupId);
            } else {
                conditions.append("fields.tfsIterationPath", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equalsIgnoreCase("issuetype") || groupType.equalsIgnoreCase("project") || groupType.equalsIgnoreCase("priority") || groupType.equalsIgnoreCase("status")) {
            conditions.append("almFields." + groupType + ".name", (Object)groupId);
        } else if (groupType.contains("kendisFields")) {
            String[] fieldValue = groupType.split("-");
            if (groupId != null) {
                if (type.equalsIgnoreCase("user")) {
                    conditions.append("fields." + fieldValue[1] + ".fullName", (Object)groupId);
                } else if (type.equalsIgnoreCase("object") || type.equalsIgnoreCase("array")) {
                    conditions.append("fields." + fieldValue[1] + ".title", (Object)groupId);
                } else {
                    conditions.append("fields." + fieldValue[1], (Object)groupId);
                }
            } else {
                BasicDBObject cond1 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$type: 10}"));
                BasicDBObject cond2 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$exists : false}"));
                BasicDBObject cond3 = new BasicDBObject("fields." + fieldValue[1], (Object)BasicDBObject.parse((String)"{$eq : []}"));
                conditions.append("$or", Arrays.asList(cond1, cond2, cond3));
            }
        } else if (groupType.equals("kendisResponsible")) {
            if (groupId != null) {
                conditions.append("fields.responsible.id", (Object)groupId);
            } else {
                conditions.append("fields.responsible.id", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("tfsResponsible")) {
            if (groupId != null) {
                conditions.append("fields.AssignedTo.uniqueName", (Object)groupId);
            } else {
                conditions.append("fields.AssignedTo.uniqueName", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupType.equals("jiraResponsible")) {
            if (groupId != null) {
                conditions.append("almFields.assignee.emailAddress", (Object)groupId);
            } else {
                conditions.append("almFields.assignee.emailAddress", (Object)BasicDBObject.parse((String)"{$exists : false}"));
            }
        } else if (groupId != null) {
            if (type.equalsIgnoreCase("option") || type.equalsIgnoreCase("option-with-child")) {
                conditions.append("almFields." + groupType + ".value", (Object)groupId);
            } else if (type.equalsIgnoreCase("user")) {
                conditions.append("almFields." + groupType + ".displayName", (Object)groupId);
            } else if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("double")) {
                Object groupIdObj = params.get("groupId");
                Double groupIdValue = null;
                if (groupIdObj instanceof Number) {
                    groupIdValue = ((Number)groupIdObj).doubleValue();
                } else if (groupIdObj instanceof String) {
                    groupIdValue = Double.parseDouble((String)groupIdObj);
                }
                conditions.append("almFields." + groupType, (Object)groupIdValue);
            } else if (type.equalsIgnoreCase("boolean") && params.get("groupId") instanceof Boolean) {
                conditions.append("almFields." + groupType, (Object)((Boolean)params.get("groupId")));
            } else if (type.equalsIgnoreCase("array")) {
                if (optionType.equalsIgnoreCase("string")) {
                    conditions.append("almFields." + groupType, (Object)groupId);
                } else if (optionType.equalsIgnoreCase("json") || optionType.equalsIgnoreCase("version") || optionType.equalsIgnoreCase("component")) {
                    conditions.append("almFields." + groupType + ".name", (Object)groupId);
                } else {
                    conditions.append("almFields." + groupType + ".value", (Object)groupId);
                }
            } else {
                conditions.append("almFields." + groupType, (Object)groupId);
            }
        } else {
            BasicDBObject cond1 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$type: 10}"));
            BasicDBObject cond2 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$exists : false}"));
            BasicDBObject cond3 = new BasicDBObject("almFields." + groupType, (Object)BasicDBObject.parse((String)"{$eq : []}"));
            conditions.append("$or", Arrays.asList(cond1, cond2, cond3));
        }
        String subGroupType = (String)params.get("subGroupType");
        if (subGroupType != null) {
            if (subGroupType.equals("kendisStatus")) {
                pipelines.add(new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)"status").append("localField", (Object)"status.$id").append("foreignField", (Object)"_id").append("as", (Object)"statusDetails")));
                pipelines.add(new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$statusDetails").append("preserveNullAndEmptyArrays", (Object)true)));
            }
            conditions = this.appendSubGroupConditionInGroupItemsCall(conditions, artId, params);
        }
        pipelines.add(new BasicDBObject("$match", (Object)conditions));
        Board board = null;
        ArrayList<ObjectId> itemIds = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid((Object)boardId)) {
            board = (Board)this.boardRepository.findOne((Serializable)((Object)boardId));
        }
        if (PropertyValidator.isValid(board)) {
            if (PropertyValidator.isValid(board) && PropertyValidator.isValid((Collection)board.getLinkedBacklogItems())) {
                for (String itemId : board.getLinkedBacklogItems()) {
                    if (!PropertyValidator.isValid((Object)itemId)) continue;
                    itemIds.add(new ObjectId(itemId));
                }
            }
            if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid((Collection)board.getPlannedItems())) {
                for (String itemId : board.getPlannedItems()) {
                    if (!PropertyValidator.isValid((Object)itemId)) continue;
                    itemIds.add(new ObjectId(itemId));
                }
            }
            BasicDBObject boardItemsMatch = new BasicDBObject("_id", (Object)new BasicDBObject("$in", itemIds));
            if (PropertyValidator.isValid((Object)board.getFilterCriteria())) {
                BasicDBObject matchPipeline;
                ObjectMapper objectMapper = new ObjectMapper();
                Map filterCriteriaMap = (Map)objectMapper.convertValue((Object)board.getFilterCriteria(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Map criteriaMap = (Map)filterCriteriaMap.get("criteria");
                DBObject criteriaPipeline = this.getFilterPipeline(artId, criteriaMap, pipelines);
                if (criteriaPipeline != null) {
                    matchPipeline = new BasicDBObject("$match", (Object)new BasicDBObject("$or", Arrays.asList(boardItemsMatch, criteriaPipeline)));
                    pipelines.add(matchPipeline);
                } else {
                    matchPipeline = new BasicDBObject("$match", (Object)boardItemsMatch);
                    pipelines.add(matchPipeline);
                }
            } else {
                BasicDBObject boardItemMatchPipeline = new BasicDBObject("$match", (Object)boardItemsMatch);
                pipelines.add(boardItemMatchPipeline);
            }
        }
        if ((filtersPipeline = this.getFilterPipeline(artId, filter, pipelines)) != null) {
            BasicDBObject finalMatchPipeline = new BasicDBObject("$match", (Object)filtersPipeline);
            pipelines.add(finalMatchPipeline);
        }
        String groupBy = (String)params.get("groupBy");
        Boolean rollupToGroups = (Boolean)params.get("rollupToGroups");
        if (rollupToGroups == null) {
            rollupToGroups = false;
        }
        if (groupBy == null) {
            boolean sortRequireRollup = sortBy.equals("totalEstimate") || sortBy.equals("childCount");
            boolean rollupAdded = false;
            if (sortRequireRollup) {
                rollupAdded = true;
                pipelines.addAll(this.getRollupPipeline(artId, params));
            }
            BasicDBObject sortPipeline = new BasicDBObject("$sort", (Object)new BasicDBObject().append(sortBy, (Object)Integer.parseInt(sortOrder)).append("_id", (Object)1));
            pipelines.add(sortPipeline);
            if (pageStartStr != null && pageSizeStr != null) {
                pipelines.add(BasicDBObject.parse((String)("{$skip:" + Integer.parseInt(pageStartStr) + "}")));
                pipelines.add(BasicDBObject.parse((String)("{$limit:" + Integer.parseInt(pageSizeStr) + "}")));
            }
            if (!rollupAdded) {
                pipelines.addAll(this.getRollupPipeline(artId, params));
            }
        } else {
            ArrayList groupByPipelines;
            if (rollupToGroups.booleanValue()) {
                pipelines.addAll(this.getRollupPipeline(artId, params));
            }
            if ((groupByPipelines = this.getGroupByPipeline(artId, params)) != null) {
                pipelines.addAll(groupByPipelines);
            }
        }
        LOGGER.info("================ QUERY for fetching items for a group ==== ");
        LOGGER.debug(pipelines.toString());
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        Cursor dbCursor = collection.aggregate(pipelines, ao);
        BasicDBList items = new BasicDBList();
        HashMap<String, String> parentMap = new HashMap<String, String>();
        while (dbCursor.hasNext()) {
            DBObject item = (DBObject)dbCursor.next();
            if (groupBy == null) {
                this.formatItemDbObject(item);
                if (fetchParents.booleanValue()) {
                    this.putItemParentInMap(artId, item, parentMap);
                }
            } else {
                if (groupBy.equals("Parent")) {
                    DBObject _id = (DBObject)item.get("_id");
                    String _parentId = String.valueOf(_id.get("id"));
                    _id.put("id", (Object)_parentId);
                    parentMap.put(_parentId, _parentId);
                }
                if (item.containsKey("groupItems")) {
                    BasicDBList groupItems = (BasicDBList)item.get("groupItems");
                    for (int j = 0; j < groupItems.size(); ++j) {
                        DBObject gitem = (DBObject)groupItems.get(j);
                        this.formatItemDbObject(gitem);
                    }
                }
            }
            items.add((Object)item);
        }
        if (groupBy != null) {
            ArrayList newgroups = this.handleArchivedGroups(items, groupBy);
            if (newgroups != null) {
                result.put("items", newgroups);
            }
        } else {
            result.put("items", items);
        }
        if (!parentMap.isEmpty()) {
            List parents = this.backlogItemRepository.findParentsByIdIn(parentMap.keySet());
            result.put("parents", parents);
        }
        return result;
    }

    public List<BacklogItem> childBacklogItems(String rtId, List<ObjectId> itemIds) {
        ArrayList<BacklogItem> childBacklogItems = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.parentRelation(rtId) + ".backlogItemId")).in(itemIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.artRelation(rtId) + ".rowStatus")).is((Object)0));
        query.fields().include("storyPoints").include("status");
        childBacklogItems = this.mongoTemplate.find(query, BacklogItem.class);
        return childBacklogItems;
    }

    public List<BacklogItem> findBacklogItemsByItemIdsIn(String rtId, List<ObjectId> itemIds) {
        ArrayList<BacklogItem> backlogItems = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(itemIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)(this.artRelation(rtId) + ".rowStatus")).is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.fields().include("childRelationMap").include("status");
        backlogItems = this.mongoTemplate.find(query, BacklogItem.class);
        return backlogItems;
    }

    public List<BacklogItem> findBacklogItemsByItemIdsInPaginated(String rtId, Integer size, Integer page, List<ObjectId> itemIds) {
        int startIdx = page * size;
        int endIdx = Math.min(startIdx + size, itemIds.size());
        List<ObjectId> paginatedItemIds = itemIds.subList(startIdx, endIdx);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(paginatedItemIds));
        return this.mongoTemplate.find(query, BacklogItem.class);
    }

    public List<Status> findStatusEssentialsById(List<String> statusIds) {
        ArrayList<Status> statusList = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(statusIds));
        query.fields().include("color");
        query.fields().include("title");
        query.fields().include("category");
        query.fields().include("categoryMappingByCollectionId");
        statusList = this.mongoTemplate.find(query, Status.class);
        return statusList;
    }

    public Map<String, Object> getTeamsWithLevel(String id, Map<String, Object> params) throws Exception {
        Map teamsColor = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map<String, Object> teamParams = params;
            teamParams.put("groupBy", "Teams");
            teamsColor = this.getBacklogItemsWithLevel(id, teamParams);
            Map resultData = (Map)teamsColor.get("result");
            List items = (List)resultData.get("items");
            List idList = items.stream().map(item -> (String)((Map)item.get("_id")).get("id")).collect(Collectors.toList());
            List teams = this.teamRepository.findTeamsByIdIn(idList);
            Map<String, String> teamsWithColors = teams.stream().collect(Collectors.toMap(BaseEntity::getId, Team::getColor));
            result.put("teamsWithColor", teamsWithColors);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamsWithLevel()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private String artRelation(String artId) {
        return "artRelationMap." + artId;
    }

    private String childRelation(String artId) {
        return "childRelationMap." + artId;
    }

    private String parentRelation(String artId) {
        return "parentRelationMap." + artId;
    }

    private String boardRelations(String artId) {
        return "boardRelations";
    }

    private String teamSprintRelations(String artId) {
        return "teamContainerRelations";
    }

    private String sectionRelations() {
        return "sectionRelations";
    }

    private String solutionRelations(String artId) {
        return "solutionRelations";
    }

    private String batchRelations(String artId) {
        return "batchRelations";
    }

    private String objectiveRelations(String artId) {
        return "objectiveRelations";
    }

    public List<BacklogItem> fetchBacklogItemsByIds(List<String> ids) throws Exception {
        ArrayList<BacklogItem> backlogItems = new ArrayList();
        backlogItems = this.backlogItemRepository.findByIdIn(ids);
        return backlogItems;
    }

    public List<BacklogItem> fetchParentItemsFromBacklog(List<BacklogItem> items, String releaseTrainId) throws Exception {
        HashSet<String> parentIds = new HashSet<String>();
        for (BacklogItem item : items) {
            List links;
            if (!PropertyValidator.isValid((Object)item) || item.getParentRelationMap() == null || item.getParentRelationMap().get(releaseTrainId) == null || (links = (List)item.getParentRelationMap().get(releaseTrainId)) == null) continue;
            for (BaseItemLink link : links) {
                if (link.getBacklogItemId() == null) continue;
                parentIds.add(link.getBacklogItemId().toString());
            }
        }
        if (!parentIds.isEmpty()) {
            return this.backlogItemRepository.findByIdIn(new ArrayList(parentIds));
        }
        return new ArrayList<BacklogItem>();
    }

    public Map<String, Object> getBacklogItemsChildrenCounts(String releaseTrainId, List<String> itemIds, Integer iterationPathDates, Integer datePreference, String boardId, String almAccountType, Map<String, Object> tfsIterationMap) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap counts = new HashMap();
        try (Cursor dbCursor = null;){
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            List objectIds = itemIds.stream().filter(id -> ObjectId.isValid((String)id)).map(ObjectId::new).collect(Collectors.toList());
            if (objectIds.isEmpty()) {
                result.put("counts", counts);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            for (String itemId : itemIds) {
                if (!ObjectId.isValid((String)itemId)) continue;
                HashMap<String, Integer> itemCounts = new HashMap<String, Integer>();
                itemCounts.put("plannedCount", 0);
                itemCounts.put("unplannedCount", 0);
                counts.put(itemId, itemCounts);
            }
            ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
            BasicDBObject matchPipeline = new BasicDBObject("$match", (Object)new BasicDBObject().append("tenant", (Object)tenant).append("rowStatus", (Object)0).append("archive", (Object)false).append(this.artRelation(releaseTrainId) + ".rowStatus", (Object)0).append("parentRelationMap." + releaseTrainId + ".backlogItemId", (Object)new BasicDBObject("$in", objectIds)));
            pipelines.add(matchPipeline);
            BasicDBObject projectionPipeline = new BasicDBObject("$project", (Object)new BasicDBObject().append("fields", (Object)1).append("parentRelationMap", (Object)1));
            pipelines.add(projectionPipeline);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
            dbCursor = collection.aggregate(pipelines, ao);
            while (dbCursor.hasNext()) {
                List parentRelationArray;
                DBObject parentRelationMap;
                Object parentRelationArrayObj;
                DBObject item = (DBObject)dbCursor.next();
                this.formatItemDbObject(item);
                ObjectId parentItemId = null;
                Object parentRelationMapObj = item.get("parentRelationMap");
                if (parentRelationMapObj instanceof DBObject && (parentRelationArrayObj = (parentRelationMap = (DBObject)parentRelationMapObj).get(releaseTrainId)) instanceof List && !(parentRelationArray = (List)parentRelationArrayObj).isEmpty()) {
                    DBObject parentRel = (DBObject)parentRelationArray.get(0);
                    parentItemId = (ObjectId)parentRel.get("backlogItemId");
                }
                if (parentItemId == null) continue;
                String parentItemIdStr = parentItemId.toString();
                boolean isPlanned = this.isItemPlannedWithTfsSettings(item, releaseTrainId, iterationPathDates, datePreference, boardId, almAccountType, tfsIterationMap);
                Map itemCounts = (Map)counts.get(parentItemIdStr);
                if (itemCounts == null) continue;
                if (isPlanned) {
                    itemCounts.put("plannedCount", (Integer)itemCounts.get("plannedCount") + 1);
                    continue;
                }
                itemCounts.put("unplannedCount", (Integer)itemCounts.get("unplannedCount") + 1);
            }
            result.put("counts", counts);
        }
        return result;
    }

    private boolean isItemPlanned(DBObject item, String releaseTrainId) {
        try {
            DBObject fields = (DBObject)item.get("fields");
            if (fields != null) {
                Object startDate = fields.get("StartDate");
                Object endDate = fields.get("EndDate");
                if (startDate != null && endDate != null) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error determining if item is planned: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isItemPlannedWithTfsSettings(DBObject item, String releaseTrainId, Integer iterationPathDates, Integer datePreference, String boardId, String almAccountType, Map<String, Object> tfsIterationMap) {
        try {
            DBObject fields = (DBObject)item.get("fields");
            if (fields == null) {
                return false;
            }
            boolean isTfs = "tfs".equalsIgnoreCase(almAccountType);
            if (isTfs && iterationPathDates != null && iterationPathDates == 0) {
                Object tfsIterationPath = fields.get("tfsIterationPath");
                Object startDate = fields.get("StartDate");
                Object endDate = fields.get("EndDate");
                if (datePreference != null && datePreference == 1) {
                    Map iterationDates;
                    if (tfsIterationPath != null && tfsIterationMap != null && (iterationDates = this.getTfsIterationDatesFromMap(tfsIterationMap, tfsIterationPath.toString())) != null && iterationDates.get("startDate") != null && iterationDates.get("endDate") != null) {
                        return true;
                    }
                    if (startDate == null || endDate == null) return false;
                    return true;
                }
                if (startDate == null || endDate == null) Map iterationDates;
                return tfsIterationPath != null && tfsIterationMap != null && (iterationDates = this.getTfsIterationDatesFromMap(tfsIterationMap, tfsIterationPath.toString())) != null && iterationDates.get("startDate") != null && iterationDates.get("endDate") != null;
                return true;
            }
            Object startDate = fields.get("StartDate");
            Object endDate = fields.get("EndDate");
            if (startDate == null || endDate == null) return false;
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error determining if item is planned with TFS settings: " + StringUtils.getTraceString((Throwable)e));
            return false;
        }
    }

    private Map<String, Object> getTfsIterationDatesFromMap(Map<String, Object> tfsIterationMap, String iterationPath) {
        try {
            Map iterationMap;
            Object attributes;
            if (tfsIterationMap == null || iterationPath == null) {
                return null;
            }
            Object iterationData = tfsIterationMap.get(iterationPath);
            if (iterationData == null) {
                return null;
            }
            if (iterationData instanceof Map && (attributes = (iterationMap = (Map)iterationData).get("attributes")) instanceof Map) {
                Map attrsMap = (Map)attributes;
                Object startDate = attrsMap.get("startDate");
                Object endDate = attrsMap.get("finishDate");
                if (startDate != null && endDate != null) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("startDate", startDate);
                    result.put("endDate", endDate);
                    return result;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error getting TFS iteration dates from map: " + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public Map<String, Object> resolveGroupIdForItemTransition(String itemId, String releaseTrainId, String targetState, String targetGroupBy, String boardId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemId)));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            BacklogItem item = (BacklogItem)this.mongoTemplate.findOne(query, BacklogItem.class);
            if (item == null) {
                result.put("success", false);
                result.put("message", "Item not found");
                return result;
            }
            String resolvedGroupId = "null";
            HashMap metadata = new HashMap();
            switch (targetGroupBy) {
                case "Section": {
                    resolvedGroupId = this.resolveSectionGroupId(item, boardId);
                    break;
                }
                case "kendisStatus": {
                    resolvedGroupId = this.resolveStatusGroupId(item);
                    break;
                }
                case "Batches": {
                    resolvedGroupId = this.resolveBatchGroupId(item, releaseTrainId);
                    break;
                }
                case "Teams": {
                    resolvedGroupId = this.resolveTeamGroupId(item, releaseTrainId);
                    break;
                }
                case "Containers": {
                    resolvedGroupId = this.resolveContainerGroupId(item, releaseTrainId);
                    break;
                }
                case "Session": {
                    resolvedGroupId = this.resolveSessionGroupId(item, releaseTrainId);
                    break;
                }
                case "SolutionBoards": {
                    resolvedGroupId = this.resolveSolutionBoardGroupId(item, releaseTrainId);
                    break;
                }
                case "Milestones": {
                    resolvedGroupId = this.resolveMilestoneGroupId(item, releaseTrainId);
                    break;
                }
                case "kendisResponsible": {
                    resolvedGroupId = this.resolveResponsibleGroupId(item);
                    break;
                }
                case "tfsResponsible": {
                    resolvedGroupId = this.resolveTfsResponsibleGroupId(item);
                    break;
                }
                case "jiraResponsible": {
                    resolvedGroupId = this.resolveJiraResponsibleGroupId(item);
                    break;
                }
                case "Project": {
                    resolvedGroupId = this.resolveProjectGroupId(item);
                    break;
                }
                case "AreaPath": {
                    resolvedGroupId = this.resolveAreaPathGroupId(item);
                    break;
                }
                case "Iteration": {
                    resolvedGroupId = this.resolveIterationGroupId(item);
                    break;
                }
                default: {
                    resolvedGroupId = "null";
                }
            }
            result.put("success", true);
            result.put("groupId", resolvedGroupId);
            result.put("metadata", metadata);
        }
        catch (Exception e) {
            LOGGER.error("Error resolving group ID for item transition: " + StringUtils.getTraceString((Throwable)e));
            result.put("success", false);
            result.put("message", "Error resolving group ID: " + e.getMessage());
        }
        return result;
    }

    private String resolveSectionGroupId(BacklogItem item, String boardId) {
        List sectionIds;
        if (item.getSectionRelations() != null && !item.getSectionRelations().isEmpty() && !(sectionIds = item.getSectionRelations().stream().filter(relation -> relation.getBaseItemId() != null).map(BaseItemLink::getBaseItemId).collect(Collectors.toList())).isEmpty()) {
            try {
                Iterable sectionsIterable = this.roadmapSectionRepository.findAll(sectionIds);
                ArrayList<RoadmapSection> sections = new ArrayList<RoadmapSection>();
                for (RoadmapSection section2 : sectionsIterable) {
                    sections.add(section2);
                }
                Map<String, RoadmapSection> sectionMap = sections.stream().collect(Collectors.toMap(BaseEntity::getId, section -> section));
                for (BaseItemLink sectionRelation : item.getSectionRelations()) {
                    RoadmapSection section3;
                    if (sectionRelation.getBaseItemId() == null || (section3 = sectionMap.get(sectionRelation.getBaseItemId())) == null || !boardId.equals(section3.getParentRoadmapId())) continue;
                    return sectionRelation.getBaseItemId();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error checking section relations: " + e.getMessage());
            }
        }
        return "null";
    }

    private String resolveStatusGroupId(BacklogItem item) {
        if (item.getStatus() != null && item.getStatus().getTitle() != null) {
            return item.getStatus().getTitle();
        }
        return "null";
    }

    private String resolveBatchGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getBatchRelations() != null && !item.getBatchRelations().isEmpty()) {
            for (BaseItemLink batchRelation : item.getBatchRelations()) {
                if (!releaseTrainId.equals(batchRelation.getReleaseTrainId())) continue;
                return batchRelation.getBaseItemId();
            }
        }
        return "null";
    }

    private String resolveTeamGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getTeamContainerRelations() != null && !item.getTeamContainerRelations().isEmpty()) {
            HashSet<String> teamIds = new HashSet<String>();
            for (BaseItemLink teamRelation : item.getTeamContainerRelations()) {
                if (!releaseTrainId.equals(teamRelation.getReleaseTrainId()) || teamRelation.getTeamId() == null) continue;
                teamIds.add(teamRelation.getTeamId());
            }
            return teamIds.isEmpty() ? "null" : (String)teamIds.iterator().next();
        }
        return "null";
    }

    private String resolveContainerGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getTeamContainerRelations() != null && !item.getTeamContainerRelations().isEmpty()) {
            HashSet<String> containerIds = new HashSet<String>();
            for (BaseItemLink containerRelation : item.getTeamContainerRelations()) {
                if (!releaseTrainId.equals(containerRelation.getReleaseTrainId()) || containerRelation.getSprintId() == null) continue;
                containerIds.add(containerRelation.getSprintId());
            }
            return containerIds.isEmpty() ? "null" : (String)containerIds.iterator().next();
        }
        return "null";
    }

    private String resolveSessionGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getBoardRelations() != null && !item.getBoardRelations().isEmpty()) {
            HashSet<String> sessionIds = new HashSet<String>();
            for (BaseItemLink boardRelation : item.getBoardRelations()) {
                if (!releaseTrainId.equals(boardRelation.getReleaseTrainId()) || boardRelation.getSessionId() == null) continue;
                sessionIds.add(boardRelation.getSessionId());
            }
            return sessionIds.isEmpty() ? "null" : (String)sessionIds.iterator().next();
        }
        return "null";
    }

    private String resolveSolutionBoardGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getSolutionRelations() != null && !item.getSolutionRelations().isEmpty()) {
            HashSet<String> solutionIds = new HashSet<String>();
            for (BaseItemLink solutionRelation : item.getSolutionRelations()) {
                if (!releaseTrainId.equals(solutionRelation.getReleaseTrainId()) || solutionRelation.getSolutionId() == null) continue;
                solutionIds.add(solutionRelation.getSolutionId());
            }
            return solutionIds.isEmpty() ? "null" : (String)solutionIds.iterator().next();
        }
        return "null";
    }

    private String resolveMilestoneGroupId(BacklogItem item, String releaseTrainId) {
        if (item.getMilestoneRelations() != null && !item.getMilestoneRelations().isEmpty()) {
            HashSet<String> milestoneIds = new HashSet<String>();
            for (BaseItemLink milestoneRelation : item.getMilestoneRelations()) {
                if (!releaseTrainId.equals(milestoneRelation.getReleaseTrainId()) || milestoneRelation.getBaseItemId() == null) continue;
                milestoneIds.add(milestoneRelation.getBaseItemId());
            }
            return milestoneIds.isEmpty() ? "null" : (String)milestoneIds.iterator().next();
        }
        return "null";
    }

    private String resolveResponsibleGroupId(BacklogItem item) {
        Map responsible;
        if (item.getFields() != null && item.getFields().get("responsible") != null && (responsible = (Map)item.getFields().get("responsible")).get("id") != null) {
            return responsible.get("id").toString();
        }
        return "null";
    }

    private String resolveTfsResponsibleGroupId(BacklogItem item) {
        Map assignedTo;
        if (item.getFields() != null && item.getFields().get("AssignedTo") != null && (assignedTo = (Map)item.getFields().get("AssignedTo")).get("uniqueName") != null) {
            return assignedTo.get("uniqueName").toString();
        }
        return "null";
    }

    private String resolveJiraResponsibleGroupId(BacklogItem item) {
        Map assignee;
        if (item.getAlmFields() != null && item.getAlmFields().get("assignee") != null && (assignee = (Map)item.getAlmFields().get("assignee")).get("emailAddress") != null) {
            return assignee.get("emailAddress").toString();
        }
        return "null";
    }

    private String resolveProjectGroupId(BacklogItem item) {
        if (item.getFields() != null && item.getFields().get("tfsProject") != null) {
            return item.getFields().get("tfsProject").toString();
        }
        return "null";
    }

    private String resolveAreaPathGroupId(BacklogItem item) {
        if (item.getFields() != null && item.getFields().get("tfsAreaPath") != null) {
            return item.getFields().get("tfsAreaPath").toString();
        }
        return "null";
    }

    private String resolveIterationGroupId(BacklogItem item) {
        if (item.getFields() != null && item.getFields().get("tfsIterationPath") != null) {
            return item.getFields().get("tfsIterationPath").toString();
        }
        return "null";
    }
}

