/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.PiAgenda;
import com.viztrend.safe.persistence.entity.PiAgendaDay;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PiSystemRole;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.AnswerRepository;
import com.viztrend.safe.persistence.repository.AnswerTemplateRepository;
import com.viztrend.safe.persistence.repository.PiAgendaDayRepository;
import com.viztrend.safe.persistence.repository.PiAgendaRepository;
import com.viztrend.safe.persistence.repository.PiDayRepository;
import com.viztrend.safe.persistence.repository.PiJourneyEventRepository;
import com.viztrend.safe.persistence.repository.PiJourneyRepository;
import com.viztrend.safe.persistence.repository.PiProgramRoleRepository;
import com.viztrend.safe.persistence.repository.PiSiteRepository;
import com.viztrend.safe.persistence.repository.PiSosRepository;
import com.viztrend.safe.persistence.repository.PiSystemRoleRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PiUserCapacityRepository;
import com.viztrend.safe.persistence.repository.QuestionRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="PiJourneyService")
public class PiJourneyServiceImp
implements PiJourneyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PiJourneyServiceImp.class);
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private PiJourneyRepository piJourneyRepository;
    @Autowired
    private PiDayRepository piDayRepository;
    @Autowired
    private PiSiteRepository piSiteRepository;
    @Autowired
    private PiAgendaRepository piAgendaRepository;
    @Autowired
    private PiAgendaDayRepository piAgendaDayRepository;
    @Autowired
    private PiJourneyEventRepository piJourneyEventRepository;
    @Autowired
    private PiProgramRoleRepository piProgramRoleRepository;
    @Autowired
    private QuestionRepository questionRepository;
    @Autowired
    private AnswerRepository answerRepository;
    @Autowired
    private PiSosRepository piSosRepository;
    @Autowired
    private AnswerTemplateRepository answerTemplateRepository;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private PiUserCapacityRepository piUserCapacityRepository;
    @Autowired
    private PiSystemRoleRepository piSystemRoleRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public HashMap<String, Object> getPiJourneyData(String sessionId, String sessionBoardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        if (sessionBoardId == null) {
            sessionBoardId = session.getActiveSessionBoard();
        } else if (sessionBoardId.equals("") || sessionBoardId.equals("null")) {
            sessionBoardId = session.getActiveSessionBoard();
        }
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        PiJourney piJourney = this.piJourneyRepository.findBySessionId(sessionId);
        if (!PropertyValidator.isValid((Object)piJourney)) {
            piJourney = new PiJourney();
            piJourney.setSites(new ArrayList());
            piJourney.setDays(new ArrayList());
            piJourney.setId(ObjectId.get().toString());
            piJourney.setSessionId(sessionId);
            PiAgenda piAgenda = new PiAgenda();
            piAgenda.setPiJourneyId(piJourney.getId());
            piAgenda.setPiAgendaDays(new ArrayList());
            piAgenda = (PiAgenda)this.piAgendaRepository.save((Object)piAgenda);
            piJourney.setAgenda(piAgenda);
            piJourney = (PiJourney)this.piJourneyRepository.save((Object)piJourney);
        }
        for (PiSite site : piJourney.getSites()) {
            TimeZone timeZone = TimeZone.getTimeZone(site.getTimeZone());
            if (timeZone.inDaylightTime(new Date())) {
                site.setUseDst(Boolean.valueOf(true));
                continue;
            }
            site.setUseDst(Boolean.valueOf(false));
        }
        List systemRoles = this.getSystemRoles();
        responseJson.put("journey", piJourney);
        responseJson.put("session", session);
        responseJson.put("sessionBoard", sessionBoard);
        responseJson.put("systemRoles", systemRoles);
        return responseJson;
    }

    public PiAgenda getPiAgendaData(String agendaId) {
        PiAgenda agenda = (PiAgenda)this.piAgendaRepository.findOne((Serializable)((Object)agendaId));
        if (PropertyValidator.isValid((Collection)agenda.getPiAgendaDays())) {
            for (PiAgendaDay day : agenda.getPiAgendaDays()) {
                day.getEvents();
            }
        }
        return agenda;
    }

    private List<PiSystemRole> getSystemRoles() {
        List<PiSystemRole> systemRoles = this.piSystemRoleRepository.findAllByOrderByTitleAsc();
        if (PropertyValidator.isValid((Collection)systemRoles)) {
            return systemRoles;
        }
        systemRoles = new ArrayList<PiSystemRole>();
        PiSystemRole role1 = new PiSystemRole("RTE");
        role1.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role1);
        PiSystemRole role2 = new PiSystemRole("Business Executive");
        role2.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role2);
        PiSystemRole role3 = new PiSystemRole("Product Manager");
        role3.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role3);
        PiSystemRole role4 = new PiSystemRole("Architect");
        role4.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role4);
        PiSystemRole role5 = new PiSystemRole("Scrum Master");
        role5.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role5);
        PiSystemRole role6 = new PiSystemRole("Product Owner");
        role6.setIsSystem(Boolean.valueOf(true));
        systemRoles.add(role6);
        systemRoles = this.piSystemRoleRepository.save(systemRoles);
        systemRoles.sort(Comparator.comparing(PiSystemRole::getTitle));
        return systemRoles;
    }

    public void changeState(SessionBoard currentSessionBoard, SessionBoard newSessionBoard, Map<String, String> containerNewIdByOldIdMap) {
    }

    public Map<String, Object> getPiJourneyMeta(String tenant) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("roles", this.getSystemRoles());
        try {
            ArrayList<String> codes = new ArrayList<String>();
            codes.add(User.UserType.ALM_JIRA.name());
            codes.add(User.UserType.ALM_TFS.name());
            ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
            BasicDBObject where = new BasicDBObject();
            where.append("tenant", (Object)tenant);
            where.append("archive", (Object)new BasicDBObject("$ne", (Object)true));
            where.append("userType", (Object)new BasicDBObject("$in", codes));
            pipe.add(new BasicDBObject("$match", (Object)where));
            pipe.add(new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'id': {'$toString':'$_id'},'_id':0,'userName':1,'firstName':1,'lastName':1,'fullName':1,'email':1,'userType':1}}")));
            pipe.add(new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id':'','data':{'$mergeObjects':{'$arrayToObject':[[{'k':'$fullName','v':'$$ROOT'}]]}}}")));
            pipe.add(new BasicDBObject("$replaceRoot", (Object)BasicDBObject.parse((String)"{'newRoot':'$data'}")));
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(User.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            Cursor db = collection.aggregate(pipe, ao);
            if (db.hasNext()) {
                meta.put("users", ((DBObject)db.next()).toMap());
            }
            db.close();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return meta;
    }

    public List<Object> findCapacitiesByAggregation(String tenant, SessionBoard board, List<String> teamIds, String groupBy) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            Query query = null;
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").in(new Object[]{board.getSession().getId()}));
            DBObject journey = this.mongoTemplate.getCollection(KendisUtils.dbName(PiJourney.class)).findOne(query.getQueryObject());
            if (PropertyValidator.isValid((Object)journey)) {
                String journeyId = String.valueOf(journey.get("_id"));
                ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
                BasicDBObject where = new BasicDBObject();
                where.append("archive", (Object)new BasicDBObject("$ne", (Object)true));
                if (PropertyValidator.isValid((Object)board.getId())) {
                    where.append("sessionBoardId", (Object)board.getId());
                }
                if (PropertyValidator.isValid((Object)journeyId)) {
                    where.append("piJourneyId", (Object)journeyId);
                }
                if (PropertyValidator.isValid(teamIds)) {
                    where.append("teamId", (Object)new BasicDBObject("$in", teamIds));
                }
                pipe.add(new BasicDBObject("$match", (Object)where));
                pipe.add(BasicDBObject.parse((String)"{'$lookup':{'from':'piSystemRole','localField':'systemRole.$id','foreignField':'_id','as':'systemRole'}}"));
                pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$systemRole','preserveNullAndEmptyArrays':true}}"));
                pipe.add(BasicDBObject.parse((String)"{'$unwind':'$containersCapacity'}"));
                pipe.add(BasicDBObject.parse((String)"{'$group':{'_id':{'userId':'$user.$id','teamId':'$teamId'},'role':{'$first':{'$toString':'$systemRole.title'}}, 'total':{'$sum':'$containersCapacity.capacity'}}}"));
                pipe.add(BasicDBObject.parse((String)"{'$group':{'_id':'$_id.userId','data':{'$push':{'k':'$_id.teamId','v':{'role':'$role','capacity' :'$total'}}}}}"));
                pipe.add(BasicDBObject.parse((String)"{'$lookup':{'from':'user','localField':'_id','foreignField':'_id','as':'user'}}"));
                pipe.add(BasicDBObject.parse((String)"{'$unwind':'$user'}"));
                pipe.add(BasicDBObject.parse((String)"{'$project':{'_id':0,'id':{'$toString':'$_id'},'user':'$user.fullName', 'userEmail':'$user.email' ,'capacity':{'$sum':'$data.v.capacity'},'data':{'$arrayToObject':{'$map':{'input':'$data','as':'pair','in':['$$pair.k','$$pair.v']}}}}}"));
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(PiUserCapacity.class));
                AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
                Cursor db = collection.aggregate(pipe, ao);
                while (db.hasNext()) {
                    result.add(db.next());
                }
                db.close();
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public Map<String, Object> searchUsers(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String tenant = null;
        String cid = null;
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        } else if ("apiUser".equals(SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            tenant = (String)UserContextDTO.getFromLocalThread().get("apiKeyTenant");
            cid = (String)UserContextDTO.getFromLocalThread().get("apiKeyCompanyId");
        }
        String searchQurey = (String)requestBody.get("query");
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        String options = "i";
        Criteria criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userName").regex(searchQurey, options), Criteria.where((String)"fullName").regex(searchQurey, options), Criteria.where((String)"email").regex(searchQurey, options)});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)criteria1);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.company.id").is((Object)cid));
        List users1 = this.mongoTemplate.find(query, User.class);
        query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies").is(null));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        options = "i";
        criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userName").regex(searchQurey, options), Criteria.where((String)"fullName").regex(searchQurey, options), Criteria.where((String)"email").regex(searchQurey, options)});
        query.addCriteria((CriteriaDefinition)criteria1);
        List users2 = this.mongoTemplate.find(query, User.class);
        if (PropertyValidator.isValid((Collection)users2)) {
            users1.addAll(users2);
        }
        responseJson.put("success", true);
        responseJson.put("users", users1);
        return responseJson;
    }
}

