/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.PiAgendaDay;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiJourneyEvent;
import com.viztrend.safe.persistence.entity.PiTeamBreakoutTeam;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.repository.PiJourneyEventRepository;
import com.viztrend.safe.persistence.repository.PiJourneyRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PiUserCapacityRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.service.PiJourneyBoardService;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="PiJourneyBoardService")
public class PiJourneyBoardServiceImp
implements PiJourneyBoardService {
    @Autowired
    private PiJourneyRepository piJourneyRepository;
    @Autowired
    private PiJourneyEventRepository piJourneyEventRepository;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private PiUserCapacityRepository piUserCapacityRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;

    public void updateTeamCapacityOnAddSprint(SessionBoard sessionBoard, Container container) {
        List teamCapacities;
        PiJourney piJourney = this.piJourneyRepository.findBySessionId(sessionBoard.getSession().getId());
        ArrayList<PiUserCapacity> userCapacities = new ArrayList<PiUserCapacity>();
        if (PropertyValidator.isValid((Object)piJourney) && PropertyValidator.isValid((Collection)(teamCapacities = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionId(piJourney.getId(), sessionBoard.getSession().getId())))) {
            for (PiTeamCapacity teamCapacity : teamCapacities) {
                if (!PropertyValidator.isValid((Collection)teamCapacity.getUsersCapacity())) continue;
                for (PiUserCapacity userCapacity : teamCapacity.getUsersCapacity()) {
                    if (userCapacity.getContainersCapacity() == null) {
                        userCapacity.setContainersCapacity(new ArrayList());
                    }
                    PiContainerCapacity containerCapacity = new PiContainerCapacity();
                    String containerId = container.getOriginItemId();
                    if (containerId == null) {
                        containerId = container.getId();
                    }
                    containerCapacity.setContainerId(containerId);
                    containerCapacity.setCapacity(piJourney.getDefaultUserCapacity());
                    userCapacity.getContainersCapacity().add(containerCapacity);
                    userCapacities.add(userCapacity);
                }
            }
            if (PropertyValidator.isValid(userCapacities)) {
                this.piUserCapacityRepository.save(userCapacities);
            }
            this.updateTeamCapacity(teamCapacities, sessionBoard, container);
        }
    }

    private ArrayList<TeamSprintVelocity> updateTeamCapacity(List<PiTeamCapacity> teamCapacities, SessionBoard activeSessionBoard, Container container) {
        ArrayList<TeamSprintVelocity> sprintVelocities = new ArrayList<TeamSprintVelocity>();
        for (PiTeamCapacity teamCapacity : teamCapacities) {
            HashMap<String, ArrayList<PiContainerCapacity>> piContainersCapacityMap = new HashMap<String, ArrayList<PiContainerCapacity>>();
            if (PropertyValidator.isValid((Collection)teamCapacity.getUsersCapacity())) {
                for (PiUserCapacity uc : teamCapacity.getUsersCapacity()) {
                    if (!PropertyValidator.isValid((Collection)uc.getContainersCapacity())) continue;
                    for (PiContainerCapacity cc : uc.getContainersCapacity()) {
                        ArrayList<PiContainerCapacity> array = (ArrayList<PiContainerCapacity>)piContainersCapacityMap.get(cc.getContainerId());
                        if (array == null) {
                            array = new ArrayList<PiContainerCapacity>();
                            piContainersCapacityMap.put(cc.getContainerId(), array);
                        }
                        array.add(cc);
                    }
                }
            }
            TeamSprintVelocity tsv = new TeamSprintVelocity();
            tsv.setSprintId(container.getId());
            tsv.setTeamId(teamCapacity.getTeam().getId());
            tsv.setSessionBoardId(activeSessionBoard.getId());
            tsv.setAutoUpdate(Boolean.valueOf(true));
            tsv.setManualUpdate(Boolean.valueOf(false));
            sprintVelocities.add(tsv);
            String containerId = container.getOriginItemId();
            if (containerId == null) {
                containerId = container.getId();
            }
            double valocity = 0.0;
            ArrayList ccArray = (ArrayList)piContainersCapacityMap.get(containerId);
            if (PropertyValidator.isValid((Collection)ccArray)) {
                for (PiContainerCapacity cc : ccArray) {
                    valocity += (double)cc.getCapacity().floatValue();
                }
            }
            tsv.setVelocity(Double.valueOf(valocity));
        }
        this.teamSprintVelocityRepository.save(sprintVelocities);
        return sprintVelocities;
    }

    public void updateTeamBreakoutOnTeamRemove(String sessionId, String teamId) {
        PiJourney piJourney = this.piJourneyRepository.findBySessionId(sessionId);
        if (PropertyValidator.isValid((Object)piJourney)) {
            ArrayList<PiJourneyEvent> eventsToUpdate = new ArrayList<PiJourneyEvent>();
            if (PropertyValidator.isValid((Collection)piJourney.getAgenda().getPiAgendaDays())) {
                for (PiAgendaDay agendaDay : piJourney.getAgenda().getPiAgendaDays()) {
                    if (!PropertyValidator.isValid((Collection)agendaDay.getEvents())) continue;
                    for (PiJourneyEvent event : agendaDay.getEvents()) {
                        if (!PropertyValidator.isValid((Object)event.getType()) || !event.getType().equals("breakout") || !PropertyValidator.isValid((Collection)event.getTeams())) continue;
                        int teamIndex = -1;
                        for (int i = 0; i < event.getTeams().size(); ++i) {
                            PiTeamBreakoutTeam team = (PiTeamBreakoutTeam)event.getTeams().get(i);
                            if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getTeamId()) || !team.getTeamId().equals(teamId)) continue;
                            teamIndex = i;
                        }
                        if (teamIndex <= -1) continue;
                        event.getTeams().remove(teamIndex);
                        eventsToUpdate.add(event);
                    }
                }
            }
            this.piJourneyEventRepository.save(eventsToUpdate);
        }
    }
}

