/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.stripe.Stripe;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.PaymentIntent;
import com.stripe.param.PaymentIntentCreateParams;
import com.viztrend.safe.annotations.SchedLock;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.PaymentDetails;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.PaymentTransactions;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CountersRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.PaymentTransactionsRepository;
import com.viztrend.safe.service.PaymentService;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.PaymentChargeVO;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="PaymentService")
public class PaymentServiceImpl
implements PaymentService {
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private LocalMailSender localMailSender;
    @Autowired
    private PaymentTransactionsRepository paymentTransactionsRepository;
    @Autowired
    private CountersRepository countersRepository;
    @Autowired
    private Environment env;
    @Autowired
    private CustomRepository customRepository;
    private String bcc = "testput10@gmail.com";
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentServiceImpl.class);

    @PostConstruct
    private void PostConstruct() {
        if ("kendis.io".equals(this.env.getProperty("server.domain"))) {
            this.bcc = "finance@kendis.io";
        }
    }

    public PaymentChargeVO charge(Company company, String customerId, String payment_intent_id, boolean isRecurring, boolean isRenew) {
        PaymentIntent intent = null;
        Date nextPaymentDate = null;
        String paymentMethodId = "";
        PaymentChargeVO pcVO = new PaymentChargeVO();
        Charge charge = null;
        String error = null;
        PaymentTransactions paymentTransactions = new PaymentTransactions();
        paymentTransactions.setFormat("new");
        try {
            Stripe.apiKey = this.env.getProperty("stripe.apiKey");
            Calendar cal = Calendar.getInstance();
            if (company.getNextPaymentDate() != null) {
                cal.setTime(company.getNextPaymentDate());
            }
            cal.add(2, Integer.parseInt(company.getDuration() + ""));
            cal.set(13, 0);
            cal.set(14, 0);
            nextPaymentDate = cal.getTime();
            paymentMethodId = company.getPaymentDetails().getIntent_id();
            long totalPriceInUSDLong = company.getTotalPrice();
            if (company.getPaymentDetails().getIntent_id() == null) {
                Customer customer = Customer.retrieve((String)customerId);
                HashMap<String, Object> chargeParams = new HashMap<String, Object>();
                chargeParams.put("amount", totalPriceInUSDLong);
                chargeParams.put("currency", "usd");
                chargeParams.put("customer", customer.getId());
                chargeParams.put("source", customer.getDefaultSource());
                charge = Charge.create(chargeParams);
            } else if (company.getPaymentDetails().getIntent_id() != null && payment_intent_id == null) {
                Stripe.apiKey = this.env.getProperty("stripe.apiKey");
                PaymentIntentCreateParams createParams = PaymentIntentCreateParams.builder().setAmount(Long.valueOf(totalPriceInUSDLong)).setCurrency("usd").setConfirm(Boolean.valueOf(true)).setPaymentMethod(paymentMethodId).setConfirmationMethod(PaymentIntentCreateParams.ConfirmationMethod.MANUAL).setCustomer(customerId).setSetupFutureUsage(PaymentIntentCreateParams.SetupFutureUsage.OFF_SESSION).build();
                intent = PaymentIntent.create((PaymentIntentCreateParams)createParams);
            } else if (payment_intent_id != "" && payment_intent_id != null) {
                intent = PaymentIntent.retrieve((String)payment_intent_id);
                intent = intent.confirm();
            }
            if (intent != null && intent.getStatus().equals("requires_action") && !isRecurring) {
                pcVO.setPaymentIntent(intent);
                return pcVO;
            }
            if (intent != null && intent.getStatus().equals("succeeded") || isRecurring) {
                pcVO.setPaymentIntent(intent);
                paymentTransactions.setEndDate((Date)(intent != null && intent.getStatus().equals("requires_action") ? null : nextPaymentDate));
                paymentTransactions.setIsError(intent != null && intent.getStatus().equals("requires_action"));
                paymentTransactions.setError(intent != null ? intent.getStatus() : null);
                paymentTransactions.setPlanPrice(company.getPlanPrice());
                paymentTransactions.setVatPct(company.getVatPct());
                paymentTransactions.setDuration(Long.valueOf(company.getDuration()));
                paymentTransactions.setUsersCount(Long.valueOf(company.getUserCount()));
                paymentTransactions.setVatCode(company.getPaymentDetails().getVatCountry().getCode());
                paymentTransactions.setCompany(company);
                paymentTransactions.setChargedAmount(company.getTotalPrice());
                paymentTransactions.setTenant(company.getTenant());
                paymentTransactions.setEmail(company.getPaymentDetails().getEmail());
                paymentTransactions.setBillingCompanyName(company.getPaymentDetails().getBillingCompanyName());
                paymentTransactions.setAddress(company.getPaymentDetails().getAddress());
                paymentTransactions.setCountry(company.getPaymentDetails().getCountry());
                paymentTransactions.setVatNo(company.getPaymentDetails().getVatNo());
                paymentTransactions.setPackageType(company.getPaymentDetails().getPackageType());
                paymentTransactions.setGeneratedId(this.customRepository.getNextSeq("PaymentTransactions", Integer.valueOf((int)new Date().getTime()), Integer.valueOf(120)));
                LOGGER.debug("save payment transaction ...........");
                this.paymentTransactionsRepository.save((Object)paymentTransactions);
            }
        }
        catch (Exception ex) {
            HashMap<String, String> varsFailer = new HashMap<String, String>();
            String baseUrl = this.getHttpScheme() + "://" + company.getUrlPrefix() + "." + this.env.getProperty("server.domain");
            varsFailer.put("paymentURL", baseUrl + "/administration#billing");
            varsFailer.put("name", company.getPaymentDetails().getBillingCompanyName());
            String emal = company.getPaymentDetails().getEmail();
            this.localMailSender.sendMail(emal, this.bcc, "Kendis Subscription Failed", "failInvoiceTemplate", varsFailer, true);
            LOGGER.error("Email for Other failer");
            error = PropertyValidator.isValid((Object)ex.getMessage()) ? ex.getMessage() : ex.toString();
            pcVO.setPaymentIntent(intent);
            paymentTransactions.setEndDate(null);
            paymentTransactions.setIsError(true);
            paymentTransactions.setError(ex.getMessage());
            paymentTransactions.setPlanPrice(company.getPlanPrice());
            paymentTransactions.setVatPct(company.getVatPct());
            paymentTransactions.setDuration(Long.valueOf(company.getDuration()));
            paymentTransactions.setUsersCount(Long.valueOf(company.getUserCount()));
            paymentTransactions.setVatCode(company.getPaymentDetails().getVatCountry().getCode());
            paymentTransactions.setCompany(company);
            paymentTransactions.setChargedAmount(company.getTotalPrice());
            paymentTransactions.setTenant(company.getTenant());
            paymentTransactions.setEmail(company.getPaymentDetails().getEmail());
            paymentTransactions.setBillingCompanyName(company.getPaymentDetails().getBillingCompanyName());
            paymentTransactions.setAddress(company.getPaymentDetails().getAddress());
            paymentTransactions.setCountry(company.getPaymentDetails().getCountry());
            paymentTransactions.setVatNo(company.getPaymentDetails().getVatNo());
            paymentTransactions.setPackageType(company.getPaymentDetails().getPackageType());
            paymentTransactions.setGeneratedId(this.customRepository.getNextSeq("PaymentTransactions", Integer.valueOf(19145210), Integer.valueOf(120)));
            this.paymentTransactionsRepository.save((Object)paymentTransactions);
            pcVO.setError(error);
            return pcVO;
        }
        try {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            HashMap<String, String> varsFailer = new HashMap<String, String>();
            vars.put("invId", Long.parseLong(paymentTransactions.getGeneratedId()));
            vars.put("users", company.getUserCount());
            vars.put("duration", company.getDuration());
            if (company.getDuration() == 1L) {
                vars.put("monthCount", "month");
            } else {
                vars.put("monthCount", "months");
            }
            BigDecimal roundedplanPrice = null;
            BigDecimal roundedChargedAmount = null;
            roundedplanPrice = new BigDecimal((double)company.getPlanPrice() / 100.0).setScale(2, RoundingMode.HALF_UP);
            float resultplanPrice = roundedplanPrice.floatValue();
            roundedChargedAmount = new BigDecimal((double)company.getTotalPrice() / 100.0).setScale(2, RoundingMode.HALF_UP);
            float resultChargedAmount = roundedChargedAmount.floatValue();
            BigDecimal roundedVat = new BigDecimal(resultChargedAmount - resultplanPrice).setScale(2, RoundingMode.HALF_UP);
            float resultVat = roundedVat.floatValue();
            vars.put("planPrice", roundedplanPrice);
            vars.put("totalPrice", Float.valueOf(resultChargedAmount));
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy");
            vars.put("startDate", formatter.format(new Date()));
            if (paymentTransactions.getEndDate() != null) {
                vars.put("endDate", formatter.format(paymentTransactions.getEndDate()));
            }
            vars.put("name", company.getPaymentDetails().getBillingCompanyName());
            varsFailer.put("name", company.getPaymentDetails().getBillingCompanyName());
            vars.put("email", company.getPaymentDetails().getEmail());
            vars.put("address", company.getPaymentDetails().getAddress());
            vars.put("country", company.getPaymentDetails().getCountry());
            vars.put("vat", Float.valueOf(resultVat));
            if (company.getPaymentPackageConfig() != null) {
                if (company.getPaymentPackageConfig().getLiveChat().booleanValue()) {
                    vars.put("planType", "Premium Cloud");
                } else {
                    vars.put("planType", "Basic Cloud");
                }
            } else {
                vars.put("planType", "Legacy");
            }
            if (company.getPaymentDetails().getVatNo() != null) {
                vars.put("vatNo", company.getPaymentDetails().getVatNo());
            } else {
                vars.put("vatNo", " ");
            }
            String baseUrl = this.getHttpScheme() + "://" + company.getUrlPrefix() + "." + this.env.getProperty("server.domain");
            if (this.env.getProperty("isLocalDeployment").equals("true")) {
                baseUrl = company.getUrl();
            }
            String emal = company.getPaymentDetails().getEmail();
            vars.put("paymentURL", baseUrl + "/administration#billing");
            varsFailer.put("paymentURL", baseUrl + "/administration#billing");
            if (intent != null && intent.getStatus().equals("succeeded") || charge != null && charge.getStatus().equals("succeeded")) {
                LOGGER.error("Email for Success");
                this.sendInvoiceEmail(vars, company.getId(), isRenew);
            } else if (intent != null && intent.getStatus().equals("requires_action")) {
                LOGGER.error("Email for 3Ds fail");
                this.localMailSender.sendMail(emal, this.bcc, "Kendis Subscription Failed", "failthreedsInvoiceTemplate", varsFailer, true);
            } else {
                LOGGER.error("Email for Other failer");
                this.localMailSender.sendMail(emal, this.bcc, "Kendis Subscription Failed", "failInvoiceTemplate", varsFailer, true);
            }
        }
        catch (Exception ex) {
            LOGGER.error("3 Error while sending email :");
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        pcVO.setDate((Date)(intent != null && intent.getStatus().equals("requires_action") ? null : nextPaymentDate));
        pcVO.setCustomerId(intent != null ? intent.getCustomer() : customerId);
        return pcVO;
    }

    public void updatePaymentPlan(Company company) {
        Company pCompany = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        BigDecimal oldPlanPrice = null;
        oldPlanPrice = PropertyValidator.isValid((Object)pCompany.getPaymentFormat()) && pCompany.getPaymentFormat().equals("new") ? new BigDecimal((double)pCompany.getPlanPrice() / 100.0).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(pCompany.getPlanPrice()).setScale(2, RoundingMode.HALF_UP);
        float resultOldPlanPrice = oldPlanPrice.floatValue();
        Date newNextPaymentDate = this.getNewNextPaymentDate(pCompany, company);
        HashMap<String, Object> mailData = new HashMap<String, Object>();
        mailData.put("oldPrice", Float.valueOf(resultOldPlanPrice));
        mailData.put("oldUsers", pCompany.getUserCount());
        mailData.put("oldDuration", pCompany.getDuration());
        if (pCompany.getDuration() == 1L) {
            mailData.put("oldMonth", "month");
        } else {
            mailData.put("oldMonth", "months");
        }
        BigDecimal newPlanPrice = new BigDecimal((double)company.getPlanPrice() / 100.0).setScale(2, RoundingMode.HALF_UP);
        float resultNewPlanPrice = newPlanPrice.floatValue();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy");
        String strDate = formatter.format(pCompany.getNextPaymentDate());
        mailData.put("oldNextDate", strDate);
        mailData.put("oldPlanType", pCompany.getPaymentDetails().getPlanType());
        mailData.put("fullName", UserContextUtil.getUserContext().getLoggedInUser().getFullName());
        mailData.put("newPrice", Float.valueOf(resultNewPlanPrice));
        mailData.put("newUsers", company.getUserCount());
        mailData.put("newDuration", company.getDuration());
        if (company.getDuration() == 1L) {
            mailData.put("newMonth", "month");
        } else {
            mailData.put("newMonth", "months");
        }
        String newDate = formatter.format(newNextPaymentDate);
        mailData.put("newNextDate", newDate);
        mailData.put("newPlanType", company.getPaymentDetails().getPlanType());
        mailData.put("currency", "$");
        String baseUrl = this.getHttpScheme() + "://" + pCompany.getUrlPrefix() + "." + this.env.getProperty("server.domain");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            baseUrl = pCompany.getUrl();
        }
        mailData.put("paymentURL", baseUrl + "/administration#billing");
        if (PropertyValidator.isValid((Object)company.getPaymentPackageConfig())) {
            if (!PropertyValidator.isValid((Object)pCompany.getPaymentPackageConfig())) {
                pCompany.setPaymentPackageConfig(new PaymentPackageConfig());
            }
            pCompany.getPaymentPackageConfig().setLDAP(company.getPaymentPackageConfig().getLDAP());
            pCompany.getPaymentPackageConfig().setLiveChat(company.getPaymentPackageConfig().getLiveChat());
            pCompany.getPaymentPackageConfig().setoAuth(company.getPaymentPackageConfig().getoAuth());
            pCompany.getPaymentPackageConfig().setSAML(company.getPaymentPackageConfig().getSAML());
            pCompany.getPaymentPackageConfig().setMFA(company.getPaymentPackageConfig().getMFA());
            pCompany.getPaymentPackageConfig().setSecurity(company.getPaymentPackageConfig().getSecurity());
            pCompany.getPaymentPackageConfig().setSolutionBoard(company.getPaymentPackageConfig().getSolutionBoard());
        }
        pCompany.setNextPaymentDate(newNextPaymentDate);
        pCompany.setDuration(company.getDuration());
        pCompany.setUserCount(company.getUserCount());
        pCompany.setPlanPrice(company.getPlanPrice());
        pCompany.setTotalPrice(company.getTotalPrice());
        pCompany.setPaymentFormat("new");
        PaymentDetails paymentDetails = pCompany.getPaymentDetails();
        paymentDetails.setPlanType(company.getPaymentDetails().getPlanType());
        if (paymentDetails.getEmail().equalsIgnoreCase(UserContextUtil.getUserContext().getLoggedInUser().getEmail())) {
            this.localMailSender.sendMail(paymentDetails.getEmail(), this.bcc, "Your Kendis Plan has been updated", "updatePaymentTemplate", mailData, true);
        } else {
            this.localMailSender.sendMail(paymentDetails.getEmail(), this.bcc, "Your Kendis Plan has been updated", "updatePaymentTemplate", mailData, true);
            this.localMailSender.sendMail(UserContextUtil.getUserContext().getLoggedInUser().getEmail(), this.bcc, "Your Kendis Plan has been updated", "updatePaymentTemplate", mailData, true);
        }
        this.companyRepository.save((Object)pCompany);
    }

    public String createInvoice(Map vars) {
        String invoiceTemplate = "invoicePDFTemplate";
        String pdfFileLoc = null;
        try {
            if (UserContextUtil.getUserContext() != null) {
                vars.put("fullName", UserContextUtil.getUserContext().getLoggedInUser().getFullName());
            } else {
                vars.put("fullName", "User");
            }
            SimpleDateFormat dt = new SimpleDateFormat("dd MMM yyyy");
            Date date = dt.parse((String)vars.get("startDate"));
            dt = new SimpleDateFormat("MM-yyyy");
            String fileName = "Kendis-invoice-for" + dt.format(date);
            pdfFileLoc = this.localMailSender.generatePDF(invoiceTemplate, vars, fileName);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (pdfFileLoc == null) {
            return null;
        }
        return pdfFileLoc;
    }

    public Date getNewNextPaymentDate(Company beforeCompany, Company afterCompany) {
        Date currentNextPaymentDate = beforeCompany.getNextPaymentDate();
        if (currentNextPaymentDate == null) {
            return null;
        }
        int newRemainingDays = Days.daysBetween((ReadableInstant)new DateTime(), (ReadableInstant)new DateTime((Object)currentNextPaymentDate)).getDays() + 1;
        long afterPlanPrice = afterCompany.getPlanPrice();
        long beforPlanPrice = beforeCompany.getPlanPrice();
        if (!PropertyValidator.isValid((Object)beforeCompany.getPaymentFormat()) || !beforeCompany.getPaymentFormat().equals("new")) {
            beforPlanPrice *= 100L;
        }
        int prorataCost = Math.round((afterPlanPrice - beforPlanPrice) * (long)newRemainingDays / (beforeCompany.getDuration() * 31L));
        if (prorataCost < 0) {
            prorataCost = 0;
        }
        if (newRemainingDays <= 0) {
            return currentNextPaymentDate;
        }
        double newCostPerDay = afterPlanPrice / (afterCompany.getDuration() * 31L);
        double oldCostPerDay = beforPlanPrice / (beforeCompany.getDuration() * 31L);
        double remainingBalance = (double)newRemainingDays * oldCostPerDay;
        double daystoadd = remainingBalance / newCostPerDay;
        return new DateTime().plusDays((int)Math.round(daystoadd)).toDate();
    }

    public void sendInvoiceEmail(Map vars, String cid, boolean isRenew) {
        Company company = this.companyRepository.findById(cid);
        String email = "";
        if (UserContextUtil.getUserContext() != null) {
            email = UserContextUtil.getUserContext().getLoggedInUser().getEmail();
            vars.put("fullName", UserContextUtil.getUserContext().getLoggedInUser().getFullName());
        } else if (company.getUpdatedBy() != null) {
            email = company.getUpdatedBy();
            vars.put("fullName", "User");
        }
        String secondEmail = null;
        if (company.getPaymentDetails() != null) {
            secondEmail = this.companyRepository.findById(cid).getPaymentDetails().getEmail();
        }
        String emailTemplate = isRenew ? "renewPaymentTemplate" : "invoiceTemplate";
        String pdfTemplate = "invoicePDFTemplate";
        try {
            SimpleDateFormat dt = new SimpleDateFormat("MM-dd-yyyy");
            Date date = dt.parse((String)vars.get("startDate"));
            dt = new SimpleDateFormat("MM-yyyy");
            String fileName = "Kendis-invoice-for" + dt.format(date);
            String pdfFileLoc = this.localMailSender.generatePDF(pdfTemplate, vars, fileName);
            if ("kendis.io".equals(this.env.getProperty("server.domain"))) {
                this.bcc = "finance@kendis.io";
            }
            if (!email.isEmpty()) {
                this.localMailSender.sendMail(email, this.bcc, "Your Kendis subscription has been successful", emailTemplate, vars, true, new FileSystemResource(new File(pdfFileLoc)));
            }
            if (secondEmail != null && !secondEmail.equals(email)) {
                this.localMailSender.sendMail(secondEmail, this.bcc, "Your Kendis subscription has been successful", emailTemplate, vars, true, new FileSystemResource(new File(pdfFileLoc)));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public Company fixPaymentPlanForCompany(Company company) throws Exception {
        if (company.getPaymentFormat() != null && company.getPaymentFormat().equals("new")) {
            float vatRate;
            long planPrice = company.getPlanPrice();
            double vatPrice = 0.0;
            long resultVatPrice = 0L;
            boolean hasVatNumber = false;
            if (PropertyValidator.isValid((Object)company.getPaymentDetails()) && PropertyValidator.isValid((Object)company.getPaymentDetails().getVatNo()) && company.getPaymentDetails().getVatNo().length() > 0) {
                hasVatNumber = true;
            }
            if (PropertyValidator.isValid((Object)company.getPaymentDetails().getVatCountry()) && !hasVatNumber && (vatRate = company.getPaymentDetails().getVatCountry().getVatRate()) > 0.0f) {
                vatPrice = vatRate / 100.0f * (float)planPrice;
                BigDecimal roundedVatPrice = new BigDecimal(vatPrice).setScale(0, RoundingMode.HALF_UP);
                resultVatPrice = roundedVatPrice.longValue();
            }
            long totalPrice = planPrice + resultVatPrice;
            company.setTotalPrice(totalPrice);
            company.setPaymentFormat("new");
            this.companyRepository.save((Object)company);
        } else {
            float vatRate;
            long planPrice = company.getPlanPrice();
            double vatPrice = 0.0;
            long resultVatPrice = 0L;
            planPrice *= 100L;
            boolean hasVatNumber = false;
            if (PropertyValidator.isValid((Object)company.getPaymentDetails()) && PropertyValidator.isValid((Object)company.getPaymentDetails().getVatNo()) && company.getPaymentDetails().getVatNo().length() > 0) {
                hasVatNumber = true;
            }
            if (PropertyValidator.isValid((Object)company.getPaymentDetails().getVatCountry()) && !hasVatNumber && (vatRate = company.getPaymentDetails().getVatCountry().getVatRate()) > 0.0f) {
                vatPrice = vatRate / 100.0f * (float)planPrice;
                BigDecimal roundedVatPrice = new BigDecimal(vatPrice).setScale(0, RoundingMode.HALF_UP);
                resultVatPrice = roundedVatPrice.longValue();
            }
            long totalPrice = planPrice + resultVatPrice;
            company.setPlanPrice(planPrice);
            company.setTotalPrice(totalPrice);
            company.setPaymentFormat("new");
            this.companyRepository.save((Object)company);
        }
        return company;
    }

    @SchedLock(name="dayEndPayments")
    @Scheduled(cron="${payment.cronExpression}")
    public Boolean dayEndPayments() {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            return false;
        }
        LOGGER.debug(" ======== Running process dayEndPayments ============== ");
        if (this.env.getProperty("server.replica").equals("36-82")) {
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LOGGER.debug("********************************");
        LOGGER.debug("payment schedule started ...... ");
        LOGGER.debug("********************************");
        try {
            Object paymentIntent = null;
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date startDate = cal.getTime();
            cal.add(10, 24);
            Date endDate = cal.getTime();
            Query query = new Query();
            Criteria OR = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"retry").is((Object)Boolean.TRUE), Criteria.where((String)"nextPaymentDate").gte((Object)startDate).andOperator(new Criteria[]{Criteria.where((String)"nextPaymentDate").lte((Object)endDate)})});
            query.addCriteria((CriteriaDefinition)OR);
            List companies = this.mongoTemplate.find(query, Company.class);
            for (Company company : companies) {
                Date nextPaymentDate = null;
                LOGGER.debug("company charging payment... :" + company.getUrlPrefix());
                if (company.getPaymentDetails() == null || company.getPaymentDetails().getCustomerId() == null) continue;
                PaymentChargeVO pcVO = null;
                pcVO = this.charge(company = this.fixPaymentPlanForCompany(company), company.getPaymentDetails().getCustomerId(), null, true, true);
                nextPaymentDate = pcVO.getDate();
                if (nextPaymentDate != null) {
                    company.setNextPaymentDate(nextPaymentDate);
                    company.setExpiryDate(null);
                } else {
                    cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    cal.add(5, 15);
                    company.setExpiryDate(cal.getTime());
                }
                company.setRetry(false);
                this.companyRepository.save((Object)company);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while recurring payments :" + StringUtils.getTraceString((Throwable)ex));
        }
        return true;
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }
}

