/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.PIService;
import com.viztrend.safe.service.PIServiceImpl;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.IntercommUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PIServiceImpl
implements PIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PIServiceImpl.class);
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ConversationRepository conversationRepository;

    public Map<String, Object> saveLinks(String requestBody) throws Exception {
        Item savedItem;
        SessionBoard board;
        Gson g = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String itemJson = (String)requestMap.get("item");
        String syncId = (String)requestMap.get("syncId");
        String requestId = (String)requestMap.get("requestId");
        String metaMap = (String)requestMap.get("metaMap");
        ObjectMapper mapper = new ObjectMapper();
        Item item = null;
        try {
            item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
        }
        catch (JsonParseException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        List linkIdsBeingUpdated = (List)requestMap.get("linkIds");
        ArrayList<ItemLink> linksBeingUpdated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksBeingCreated = new ArrayList<ItemLink>();
        ArrayList<ItemLink> linksToBeCreatedInTFS = new ArrayList<ItemLink>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        for (int i = 0; i < item.getItemLinks().size(); ++i) {
            ItemLink link2 = (ItemLink)item.getItemLinks().get(i);
            if (link2.getId() == null) {
                if (PropertyValidator.isValid((Object)link2.getWfStatus())) {
                    if (link2.getWfStatus().getCategory().equals("Done")) {
                        link2.setIsManuallyResolved(Boolean.valueOf(true));
                        link2.setResolvedOn(new Date());
                    } else {
                        link2.setResolvedOn(null);
                    }
                }
                linksBeingCreated.add(link2);
            } else if (linkIdsBeingUpdated != null) {
                linkIdsBeingUpdated.forEach(id -> {
                    if (id.equals(link2.getId())) {
                        linksBeingUpdated.add(link2);
                        return;
                    }
                });
            }
            if (!Boolean.TRUE.equals(link2.getSyncTfs())) continue;
            linksToBeCreatedInTFS.add(link2);
        }
        linksBeingUpdated.forEach(link -> {
            ItemLink savedLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)link.getId()));
            String st1 = "";
            String st2 = "";
            if (PropertyValidator.isValid((Object)savedLink.getWfStatus()) && PropertyValidator.isValid((Object)link.getWfStatus())) {
                st1 = savedLink.getWfStatus().getId();
                st2 = link.getWfStatus().getId();
            } else {
                st1 = link.getWfStatus().getCategory();
                st2 = savedLink.getStatus().equals("Resolved") ? "Done" : "ToDo";
            }
            HashMap emailTemp = new HashMap();
            if (!st1.equals(st2)) {
                if (link.getWfStatus().getCategory().equals("Done")) {
                    link.setIsManuallyResolved(Boolean.valueOf(true));
                    link.setResolvedOn(new Date());
                } else {
                    link.setResolvedOn(null);
                }
                this.notificationService.startNotificationThread(link, savedLink, "dependency_statuschange_template", Boolean.valueOf(false), "");
            }
            if (!(link.getResponsible() == null && savedLink.getResponsible() == null || link.getResponsible() != null && savedLink.getResponsible() != null && link.getResponsible().getId().equals(savedLink.getResponsible().getId()))) {
                this.notificationService.startNotificationThread(link, savedLink, "dependency_responsible_template", Boolean.valueOf(false), "");
                if (PropertyValidator.isValid((Object)savedLink.getResponsible())) {
                    this.notificationService.startNotificationThread(link, savedLink, "dependency_old_responsible_template", Boolean.valueOf(true), "");
                }
            }
            link.setWatcherList(savedLink.getWatcherList());
            if (PropertyValidator.isValid((Object)link.getAlmLinkId())) {
                List linkedAlmLinks = (List)this.almSyncService.syncKendisAndAlmLink(link);
                response.put("linkedAlmLinks", linkedAlmLinks);
            }
        });
        Session session = null;
        if (PropertyValidator.isValid(linksBeingCreated)) {
            int index = 0;
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(((ItemLink)linksBeingCreated.get(0)).getSessionBoardId());
            session = sessionBoard.getSession();
            if (PropertyValidator.isValid((Object)session.getDependencyPrefix())) {
                for (ItemLink link3 : linksBeingCreated) {
                    link3.setCustomId(Integer.valueOf(this.customRepository.getNextSeq(session.getId(), null, null)).intValue());
                    try {
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                    catch (Exception ex) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                    }
                }
            }
        }
        if (PropertyValidator.isValid((Collection)(board = (SessionBoard)(savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()))).getSessionBoards().get(0)).getSession().getAlmConfigurations()) && PropertyValidator.isValid((Object)savedItem.getJiraId())) {
            JiraUtils.saveLinks((Item)savedItem, (List)item.getItemLinks(), (String)syncId, (String)requestId);
        } else {
            for (int i = 0; i < item.getItemLinks().size(); ++i) {
                ItemLink link3;
                link3 = (ItemLink)item.getItemLinks().get(i);
                link3.setJiraDependency(null);
            }
        }
        List itemLinks = this.itemLinkRepository.save((Iterable)item.getItemLinks());
        if (!PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
            savedItem.setItemLinks(new ArrayList());
        }
        savedItem.setItemLinks(itemLinks);
        savedItem.setMetaMap(metaMap);
        savedItem.putLastUpdatedValue(Item.Actions.itemLinks.name(), (Object)itemLinks);
        this.itemRepository.save((Object)savedItem);
        if (PropertyValidator.isValid((Object)board.getSession().getTfsAlmConfigurations())) {
            AlmAccount almAccount = board.getSession().getTfsAlmConfigurations().getAlmAccount();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        this.userService.setOnboardingMeta("Create_Dependencies", true);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("dependencies_created", 1);
        String username = null;
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            username = UserContextUtil.getUserContext().getLoggedInUser().getUserName();
        } else if ("apiUser".equals(SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            username = (String)UserContextDTO.getFromLocalThread().get("apiKeyUsername");
        }
        IntercommUtils.post((String)username, vars);
        response.put("itemLinks", itemLinks);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Feature");
            pushJson.put("boardId", (Object)board.getId());
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    public ResponseEntity<Object> saveTfsLink(ItemJiraDependency dependency) throws Exception {
        ItemJiraDependency reverseDependency;
        String metaMap = dependency.getMetaMap();
        ArrayList<ItemJiraDependency> linksToSave = new ArrayList<ItemJiraDependency>();
        ItemJiraDependency oldLink = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)dependency.getId()));
        if (PropertyValidator.isValid((Object)oldLink.getSourceItemId()) && PropertyValidator.isValid((Object)oldLink.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(oldLink.getTargetItemId(), oldLink.getSourceItemId())))) {
            this.almSyncService.setLinkMeta(reverseDependency, dependency);
            linksToSave.add(reverseDependency);
        }
        if (PropertyValidator.isValid((Object)oldLink)) {
            this.almSyncService.setLinkMeta(oldLink, dependency);
            linksToSave.add(oldLink);
        }
        HashMap<String, ArrayList<ItemJiraDependency>> response = new HashMap<String, ArrayList<ItemJiraDependency>>();
        for (ItemJiraDependency link : linksToSave) {
            if (!dependency.getWfStatus().getCategory().equalsIgnoreCase("Done")) continue;
            link.setResolvedOn(new Date());
        }
        this.itemJiraDependencyRepository.save(linksToSave);
        response.put("linksToSave", linksToSave);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Feature");
            pushJson.put("boardId", (Object)dependency.getSessionBoardId());
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    public ResponseEntity<Object> saveConversationByItemLink(String parentId, List<Conversation> conversations) throws Exception {
        List<String> itemLinkIds = Arrays.asList(parentId.split(","));
        ArrayList itemLinks = (ArrayList)this.customRepository.getItemLink(itemLinkIds);
        if (PropertyValidator.isValid(conversations)) {
            for (Conversation conv : conversations) {
                if (PropertyValidator.isValid((Object)conv.getId())) continue;
                Pattern p = Pattern.compile("\\[-(.*?)\\]");
                Matcher m = p.matcher(conv.getText());
                while (m.find()) {
                    ArrayList<String> emails = new ArrayList<String>();
                    emails.add(m.group(1));
                }
                itemLinks.forEach(link -> this.notificationService.startNotificationThread(link, link, "dependency_comment_template", Boolean.valueOf(false), conv.getText()));
            }
        }
        conversations = this.conversationRepository.save(conversations);
        if (PropertyValidator.isValid((Collection)itemLinks)) {
            for (ItemLink itemLink : itemLinks) {
                itemLink.setConversations(conversations);
            }
            this.itemLinkRepository.save((Iterable)itemLinks);
            conversations.forEach(con -> con.getUser());
            return new ResponseEntity((Object)itemLinks, HttpStatus.OK);
        }
        ArrayList itemJiraDependencies = (ArrayList)this.itemJiraDependencyRepository.findByIdIn(itemLinkIds);
        if (PropertyValidator.isValid((Collection)itemJiraDependencies)) {
            for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
                itemJiraDependency.setConversations(conversations);
            }
            this.itemJiraDependencyRepository.save((Iterable)itemJiraDependencies);
            conversations.forEach(con -> con.getUser());
            return new ResponseEntity((Object)itemJiraDependencies, HttpStatus.OK);
        }
        return null;
    }

    static /* synthetic */ NotificationService access$000(PIServiceImpl x0) {
        return x0.notificationService;
    }

    static /* synthetic */ ItemRepository access$100(PIServiceImpl x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ TFSservice access$200(PIServiceImpl x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ CustomRepository access$400(PIServiceImpl x0) {
        return x0.customRepository;
    }
}

